/*!
 * Font Awesome Pro 6.4.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2023 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      enumerableOnly && (symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      })), keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = null != arguments[i] ? arguments[i] : {};
      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  var _familyProxy, _familyProxy2, _familyProxy3, _familyProxy4, _familyProxy5;

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();
  var FAMILY_CLASSIC = 'classic';
  var FAMILY_SHARP = 'sharp';
  var FAMILIES = [FAMILY_CLASSIC, FAMILY_SHARP];

  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[FAMILY_CLASSIC];
      }
    });
  }
  var PREFIX_TO_STYLE = familyProxy((_familyProxy = {}, _defineProperty(_familyProxy, FAMILY_CLASSIC, {
    'fa': 'solid',
    'fas': 'solid',
    'fa-solid': 'solid',
    'far': 'regular',
    'fa-regular': 'regular',
    'fal': 'light',
    'fa-light': 'light',
    'fat': 'thin',
    'fa-thin': 'thin',
    'fad': 'duotone',
    'fa-duotone': 'duotone',
    'fab': 'brands',
    'fa-brands': 'brands',
    'fak': 'kit',
    'fa-kit': 'kit'
  }), _defineProperty(_familyProxy, FAMILY_SHARP, {
    'fa': 'solid',
    'fass': 'solid',
    'fa-solid': 'solid',
    'fasr': 'regular',
    'fa-regular': 'regular',
    'fasl': 'light',
    'fa-light': 'light'
  }), _familyProxy));
  var STYLE_TO_PREFIX = familyProxy((_familyProxy2 = {}, _defineProperty(_familyProxy2, FAMILY_CLASSIC, {
    'solid': 'fas',
    'regular': 'far',
    'light': 'fal',
    'thin': 'fat',
    'duotone': 'fad',
    'brands': 'fab',
    'kit': 'fak'
  }), _defineProperty(_familyProxy2, FAMILY_SHARP, {
    'solid': 'fass',
    'regular': 'fasr',
    'light': 'fasl'
  }), _familyProxy2));
  var PREFIX_TO_LONG_STYLE = familyProxy((_familyProxy3 = {}, _defineProperty(_familyProxy3, FAMILY_CLASSIC, {
    'fab': 'fa-brands',
    'fad': 'fa-duotone',
    'fak': 'fa-kit',
    'fal': 'fa-light',
    'far': 'fa-regular',
    'fas': 'fa-solid',
    'fat': 'fa-thin'
  }), _defineProperty(_familyProxy3, FAMILY_SHARP, {
    'fass': 'fa-solid',
    'fasr': 'fa-regular',
    'fasl': 'fa-light'
  }), _familyProxy3));
  var LONG_STYLE_TO_PREFIX = familyProxy((_familyProxy4 = {}, _defineProperty(_familyProxy4, FAMILY_CLASSIC, {
    'fa-brands': 'fab',
    'fa-duotone': 'fad',
    'fa-kit': 'fak',
    'fa-light': 'fal',
    'fa-regular': 'far',
    'fa-solid': 'fas',
    'fa-thin': 'fat'
  }), _defineProperty(_familyProxy4, FAMILY_SHARP, {
    'fa-solid': 'fass',
    'fa-regular': 'fasr',
    'fa-light': 'fasl'
  }), _familyProxy4));
  var FONT_WEIGHT_TO_PREFIX = familyProxy((_familyProxy5 = {}, _defineProperty(_familyProxy5, FAMILY_CLASSIC, {
    '900': 'fas',
    '400': 'far',
    'normal': 'far',
    '300': 'fal',
    '100': 'fat'
  }), _defineProperty(_familyProxy5, FAMILY_SHARP, {
    '900': 'fass',
    '400': 'fasr',
    '300': 'fasl'
  }), _familyProxy5));
  var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
  var DUOTONE_CLASSES = {
    GROUP: 'duotone-group',
    SWAP_OPACITY: 'swap-opacity',
    PRIMARY: 'primary',
    SECONDARY: 'secondary'
  };
  var prefixes = new Set();
  Object.keys(STYLE_TO_PREFIX[FAMILY_CLASSIC]).map(prefixes.add.bind(prefixes));
  Object.keys(STYLE_TO_PREFIX[FAMILY_SHARP]).map(prefixes.add.bind(prefixes));
  var RESERVED_CLASSES = [].concat(FAMILIES, _toConsumableArray(prefixes), ['2xs', 'xs', 'sm', 'lg', 'xl', '2xl', 'beat', 'border', 'fade', 'beat-fade', 'bounce', 'flip-both', 'flip-horizontal', 'flip-vertical', 'flip', 'fw', 'inverse', 'layers-counter', 'layers-text', 'layers', 'li', 'pull-left', 'pull-right', 'pulse', 'rotate-180', 'rotate-270', 'rotate-90', 'rotate-by', 'shake', 'spin-pulse', 'spin-reverse', 'spin', 'stack-1x', 'stack-2x', 'stack', 'ul', DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY]).concat(oneToTen.map(function (n) {
    return "".concat(n, "x");
  })).concat(oneToTwenty.map(function (n) {
    return "w-".concat(n);
  }));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});
  }

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", ["M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160V320c0 88.4-71.6 160-160 160S0 408.4 0 320V192zM160 96c-53 0-96 43-96 96V320c0 53 43 96 96 96s96-43 96-96V192c0-53-43-96-96-96z", ""]],
    "1": [256, 512, [], "31", ["M160 64c0-11.8-6.5-22.6-16.9-28.2s-23-5-32.8 1.6l-96 64C-.5 111.2-4.4 131 5.4 145.8s29.7 18.7 44.4 8.9L96 123.8V416H32c-17.7 0-32 14.3-32 32s14.3 32 32 32h96 96c17.7 0 32-14.3 32-32s-14.3-32-32-32H160V64z", ""]],
    "2": [320, 512, [], "32", ["M142.9 96c-21.5 0-42.2 8.5-57.4 23.8L54.6 150.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L40.2 74.5C67.5 47.3 104.4 32 142.9 32C223 32 288 97 288 177.1c0 38.5-15.3 75.4-42.5 102.6L109.3 416H288c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L200.2 234.5c15.2-15.2 23.8-35.9 23.8-57.4c0-44.8-36.3-81.1-81.1-81.1z", ""]],
    "3": [320, 512, [], "33", ["M0 64C0 46.3 14.3 32 32 32H272c13.2 0 25 8.1 29.8 20.4s1.5 26.3-8.2 35.2L162.3 208H184c75.1 0 136 60.9 136 136s-60.9 136-136 136H105.4C63 480 24.2 456 5.3 418.1l-1.9-3.8c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l1.9 3.8c8.1 16.3 24.8 26.5 42.9 26.5H184c39.8 0 72-32.2 72-72s-32.2-72-72-72H80c-13.2 0-25-8.1-29.8-20.4s-1.5-26.3 8.2-35.2L189.7 96H32C14.3 96 0 81.7 0 64z", ""]],
    "4": [384, 512, [], "34", ["M189 77.6c7.5-16 .7-35.1-15.3-42.6s-35.1-.7-42.6 15.3L3 322.4c-4.7 9.9-3.9 21.5 1.9 30.8S21 368 32 368H256v80c0 17.7 14.3 32 32 32s32-14.3 32-32V368h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H320V160c0-17.7-14.3-32-32-32s-32 14.3-32 32V304H82.4L189 77.6z", ""]],
    "5": [320, 512, [], "35", ["M32.5 58.3C35.3 43.1 48.5 32 64 32H256c17.7 0 32 14.3 32 32s-14.3 32-32 32H90.7L70.3 208H184c75.1 0 136 60.9 136 136s-60.9 136-136 136H100.5c-39.4 0-75.4-22.3-93-57.5l-4.1-8.2c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l4.1 8.2c6.8 13.6 20.6 22.1 35.8 22.1H184c39.8 0 72-32.2 72-72s-32.2-72-72-72H32c-9.5 0-18.5-4.2-24.6-11.5s-8.6-16.9-6.9-26.2l32-176z", ""]],
    "6": [320, 512, [], "36", ["M232.4 84.7c11.4-13.5 9.7-33.7-3.8-45.1s-33.7-9.7-45.1 3.8L38.6 214.7C14.7 242.9 1.1 278.4 .1 315.2c0 1.4-.1 2.9-.1 4.3c0 .2 0 .3 0 .5c0 88.4 71.6 160 160 160s160-71.6 160-160c0-85.5-67.1-155.4-151.5-159.8l63.9-75.6zM256 320A96 96 0 1 1 64 320a96 96 0 1 1 192 0z", ""]],
    "7": [320, 512, [], "37", ["M0 64C0 46.3 14.3 32 32 32H288c11.5 0 22 6.1 27.7 16.1s5.7 22.2-.1 32.1l-224 384c-8.9 15.3-28.5 20.4-43.8 11.5s-20.4-28.5-11.5-43.8L232.3 96H32C14.3 96 0 81.7 0 64z", ""]],
    "8": [320, 512, [], "38", ["M304 160c0-70.7-57.3-128-128-128H144C73.3 32 16 89.3 16 160c0 34.6 13.7 66 36 89C20.5 272.3 0 309.8 0 352c0 70.7 57.3 128 128 128h64c70.7 0 128-57.3 128-128c0-42.2-20.5-79.7-52-103c22.3-23 36-54.4 36-89zM176.1 288H192c35.3 0 64 28.7 64 64s-28.7 64-64 64H128c-35.3 0-64-28.7-64-64s28.7-64 64-64h15.9c0 0 .1 0 .1 0h32c0 0 .1 0 .1 0zm0-64c0 0 0 0 0 0H144c0 0 0 0 0 0c-35.3 0-64-28.7-64-64c0-35.3 28.7-64 64-64h32c35.3 0 64 28.7 64 64c0 35.3-28.6 64-64 64z", ""]],
    "9": [320, 512, [], "39", ["M64 192a96 96 0 1 0 192 0A96 96 0 1 0 64 192zm87.5 159.8C67.1 347.4 0 277.5 0 192C0 103.6 71.6 32 160 32s160 71.6 160 160c0 2.6-.1 5.3-.2 7.9c-1.7 35.7-15.2 70-38.4 97.4l-145 171.4c-11.4 13.5-31.6 15.2-45.1 3.8s-15.2-31.6-3.8-45.1l63.9-75.6z", ""]],
    "fill-drip": [576, 512, [], "f576", ["M67.5 288H386.7L238.6 436.1c-12.5 12.5-32.8 12.5-45.3 0L75.9 318.6c-8.3-8.3-11.1-20-8.4-30.6zM512 512c-35.3 0-64-28.7-64-64c0-25.2 32.6-79.6 51.2-108.7c6-9.4 19.5-9.4 25.5 0C543.4 368.4 576 422.8 576 448c0 35.3-28.7 64-64 64z", "M86.6 9.4C74.1-3.1 53.9-3.1 41.4 9.4s-12.5 32.8 0 45.3L122.7 136 30.6 228.1c-37.5 37.5-37.5 98.3 0 135.8L148.1 481.4c37.5 37.5 98.3 37.5 135.8 0L474.3 290.9c28.1-28.1 28.1-73.7 0-101.8L322.9 37.7c-28.1-28.1-73.7-28.1-101.8 0L168 90.7 86.6 9.4zM168 181.3l49.4 49.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L213.3 136l53.1-53.1c3.1-3.1 8.2-3.1 11.3 0L429.1 234.3c3.1 3.1 3.1 8.2 0 11.3L238.6 436.1c-12.5 12.5-32.8 12.5-45.3 0L75.9 318.6c-12.5-12.5-12.5-32.8 0-45.3L168 181.3z"]],
    "arrows-to-circle": [640, 512, [], "e4bd", ["M256 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z", "M9.4 9.4C21.9-3.1 42.1-3.1 54.6 9.4L160 114.7V96c0-17.7 14.3-32 32-32s32 14.3 32 32v96c0 4.3-.9 8.5-2.4 12.2c-1.6 3.7-3.8 7.3-6.9 10.3l-.1 .1c-3.1 3-6.6 5.3-10.3 6.9c-3.8 1.6-7.9 2.4-12.2 2.4H96c-17.7 0-32-14.3-32-32s14.3-32 32-32h18.7L9.4 54.6C-3.1 42.1-3.1 21.9 9.4 9.4zM114.7 352H96c-17.7 0-32-14.3-32-32s14.3-32 32-32h96 0l.1 0c8.8 0 16.7 3.6 22.5 9.3l.1 .1c3 3.1 5.3 6.6 6.9 10.3c1.6 3.8 2.4 7.9 2.4 12.2v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V397.3L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L114.7 352zM416 96c0-17.7 14.3-32 32-32s32 14.3 32 32v18.7L585.4 9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L525.3 160H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H448c-8.8 0-16.8-3.6-22.6-9.3l-.1-.1c-3-3.1-5.3-6.6-6.9-10.3s-2.4-7.8-2.4-12.2l0-.1v0V96zM525.3 352L630.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L480 397.3V416c0 17.7-14.3 32-32 32s-32-14.3-32-32V320v0c0 0 0-.1 0-.1c0-4.3 .9-8.4 2.4-12.2c1.6-3.8 3.9-7.3 6.9-10.4c5.8-5.8 13.7-9.3 22.5-9.4c0 0 .1 0 .1 0h0 96c17.7 0 32 14.3 32 32s-14.3 32-32 32H525.3z"]],
    "circle-chevron-right": [512, 512, ["chevron-circle-right"], "f138", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM241 377c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l87-87-87-87c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L345 239c9.4 9.4 9.4 24.6 0 33.9L241 377z", "M345 239c9.4 9.4 9.4 24.6 0 33.9L241 377c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l87-87-87-87c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L345 239z"]],
    "wagon-covered": [640, 512, [], "f8ee", ["M4.5 57.4C-5.2 30.3 16.1 2.1 44.8 4.1L194.1 14C210.9 15.1 224 29.1 224 45.9V224H64L4.5 57.4zM288 16h64c17.7 0 32 14.3 32 32V224H256V48c0-17.7 14.3-32 32-32zM64 400a112 112 0 1 1 224 0A112 112 0 1 1 64 400zm96 62V416H114c5.8 22.5 23.5 40.2 46 46zm-46-78h46V338c-22.5 5.8-40.2 23.5-46 46zm124 32H192v46c22.5-5.8 40.2-23.5 46-46zm0-32c-5.8-22.5-23.5-40.2-46-46v46h46zm114 16a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm96 62V416H402c5.8 22.5 23.5 40.2 46 46zm-46-78h46V338c-22.5 5.8-40.2 23.5-46 46zm124 32H480v46c22.5-5.8 40.2-23.5 46-46zm0-32c-5.8-22.5-23.5-40.2-46-46v46h46zM595.2 4.1c28.7-1.9 50 26.2 40.3 53.4L576 224H416V45.9c0-16.8 13.1-30.8 29.9-31.9l149.3-10z", "M96 256c-17.7 0-32 14.3-32 32s14.3 32 32 32h1.6c20.2-19.8 47.9-32 78.4-32c61.9 0 112 50.1 112 112c0 5.4-.4 10.8-1.1 16h66.3c-.7-5.2-1.1-10.6-1.1-16c0-61.9 50.1-112 112-112c30.5 0 58.2 12.2 78.4 32H544c17.7 0 32-14.3 32-32s-14.3-32-32-32H96z"]],
    "line-height": [576, 512, [], "f871", ["M256 96c0-17.7 14.3-32 32-32H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H288c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H288c-17.7 0-32-14.3-32-32zm32 128H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H288c-17.7 0-32-14.3-32-32s14.3-32 32-32z", "M73.4 41.4c12.5-12.5 32.8-12.5 45.3 0l64 64c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-9.4-9.4V370.7l9.4-9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l9.4 9.4V141.3l-9.4 9.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l64-64z"]],
    "bagel": [640, 512, [129391], "e3d7", ["M413.9 44.4c10.9-7.5 25.3-7.5 36.2 0L471 58.7c5.1 3.5 11.1 5.4 17.2 5.6l25.3 .7c13.2 .4 24.8 8.8 29.3 21.3l8.5 23.9c2.1 5.8 5.8 10.9 10.6 14.6L582 140.2c10.5 8.1 14.9 21.7 11.2 34.4L586 199c-1.7 5.9-1.7 12.2 0 18.1l7.2 24.3c3.7 12.7-.7 26.3-11.2 34.4l-20.1 15.5c-4.9 3.8-8.6 8.8-10.6 14.6l-8.5 23.9c-4.4 12.5-16.1 20.9-29.3 21.3l-25.3 .7c-6.2 .2-12.1 2.1-17.2 5.6l-20.9 14.3c-4.1 2.8-8.7 4.5-13.3 5.2c7.3-23 11.3-47.5 11.3-72.9c0-11.4-.8-22.5-2.3-33.5c28.8-6.3 50.3-31.9 50.3-62.5c0-35.3-28.7-64-64-64c-13.3 0-25.6 4-35.9 11c-20.8-26.2-46.9-48-76.8-63.6l1.8-5.1c4.4-12.5 16.1-20.9 29.3-21.3l25.3-.7c6.2-.2 12.1-2.1 17.2-5.6l20.9-14.3z", "M432 416c-3.9 0-7.7-.1-11.5-.3c6.5-12.3 12-25.3 16.3-38.8c4.7-.7 9.3-2.5 13.3-5.3L471 357.3c5.1-3.5 11-5.4 17.2-5.6l25.3-.7c13.2-.4 24.8-8.8 29.3-21.3l8.5-23.9c2.1-5.8 5.8-10.9 10.6-14.6L582 275.8c10.5-8.1 14.9-21.7 11.2-34.4L586 217c-1.7-5.9-1.7-12.2 0-18.1l7.2-24.3c3.7-12.7-.7-26.3-11.2-34.4l-20.1-15.5c-4.9-3.8-8.6-8.8-10.6-14.6l-8.5-23.9c-4.4-12.5-16.1-20.9-29.3-21.3l-25.3-.7c-6.2-.2-12.1-2.1-17.2-5.6L450.1 44.4c-10.9-7.5-25.3-7.5-36.2 0L393 58.7c-5.1 3.5-11 5.4-17.2 5.6L350.5 65c-13.2 .4-24.8 8.8-29.3 21.3l-1.8 5.1c-14.4-7.6-29.7-13.7-45.7-18.3C311.8 28.4 368.6 0 432 0C546.9 0 640 93.1 640 208s-93.1 208-208 208zM0 304a208 208 0 1 1 416 0A208 208 0 1 1 0 304zm256 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 416a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm144 16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48-16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16-176a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM144 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 272a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "transporter-7": [512, 512, [], "e2a8", ["M472.7 38.6L480 64l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L480 96l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L448 96l-25.4-7.3c-3.9-1.1-6.6-4.7-6.6-8.7s2.7-7.6 6.6-8.7L448 64l7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6zm-416 224L64 288l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L64 320l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L32 320 6.6 312.7C2.7 311.6 0 308.1 0 304s2.7-7.6 6.6-8.7L32 288l7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6z", "M96 480c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H128c-17.7 0-32-14.3-32-32z"]],
    "at": [512, 512, [61946], "40", ["M256 64C150 64 64 150 64 256s86 192 192 192c17.7 0 32 14.3 32 32s-14.3 32-32 32C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256v32c0 53-43 96-96 96c-29.3 0-55.6-13.2-73.2-33.9C320 371.1 289.5 384 256 384c-70.7 0-128-57.3-128-128s57.3-128 128-128c27.9 0 53.7 8.9 74.7 24.1c5.7-5 13.1-8.1 21.3-8.1c17.7 0 32 14.3 32 32v80 32c0 17.7 14.3 32 32 32s32-14.3 32-32V256c0-106-86-192-192-192zm64 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z", ""]],
    "rectangles-mixed": [576, 512, [], "e323", ["M432 32c-26.5 0-48 21.5-48 48V336c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H432zM112 304c-26.5 0-48 21.5-48 48v80c0 26.5 21.5 48 48 48H288c26.5 0 48-21.5 48-48V352c0-26.5-21.5-48-48-48H112z", "M0 80C0 53.5 21.5 32 48 32H272c26.5 0 48 21.5 48 48V208c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80z"]],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", ["M164.9 24.6c-7.7-18.6-28-28.5-47.4-23.2l-88 24C12.1 30.2 0 46 0 64C0 311.4 200.6 512 448 512c18 0 33.8-12.1 38.6-29.5l24-88c5.3-19.4-4.6-39.7-23.2-47.4l-96-40c-16.3-6.8-35.2-2.1-46.3 11.6L304.7 368C234.3 334.7 177.3 277.7 144 207.3L193.3 167c13.7-11.2 18.4-30 11.6-46.3l-40-96z", "M295 217c-9.4-9.4-9.4-24.6 0-33.9l135-135H384c-13.3 0-24-10.7-24-24s10.7-24 24-24H488c13.3 0 24 10.7 24 24V128c0 13.3-10.7 24-24 24s-24-10.7-24-24V81.9L329 217c-9.4 9.4-24.6 9.4-33.9 0z"]],
    "trash-can": [448, 512, [61460, "trash-alt"], "f2ed", ["M416 96H32V448c0 35.3 28.7 64 64 64H352c35.3 0 64-28.7 64-64V96zM144 176V400c0 8.8-7.2 16-16 16s-16-7.2-16-16V176c0-8.8 7.2-16 16-16s16 7.2 16 16zm96 0V400c0 8.8-7.2 16-16 16s-16-7.2-16-16V176c0-8.8 7.2-16 16-16s16 7.2 16 16zm96 0V400c0 8.8-7.2 16-16 16s-16-7.2-16-16V176c0-8.8 7.2-16 16-16s16 7.2 16 16z", "M163.8 0c-12.1 0-23.2 6.8-28.6 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8z"]],
    "circle-l": [512, 512, [], "e114", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 152V336H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24V152c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M184 128c13.3 0 24 10.7 24 24V336H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24V152c0-13.3 10.7-24 24-24z"]],
    "head-side-goggles": [512, 512, ["head-vr"], "f6ea", ["M45.9 128H225.6C233 91.5 265.3 64 304 64h95.1C364 24.7 312.9 0 256 0H233.7C148.3 0 75.3 53.1 45.9 128zM32.2 192c-.2 3.2-.2 6.5-.2 9.7c0 44.8 18.3 91.5 46.5 127.7C88.9 342.8 96 358.8 96 375.8V480c0 17.7 14.3 32 32 32H288c17.7 0 32-14.3 32-32V448h64c35.3 0 64-28.7 64-64V320h20.2c24.2 0 43.8-19.6 43.8-43.8c0-10-3.4-19.6-9.6-27.4L482.6 224H304c-26.2 0-49.4-12.6-64-32H32.2z", "M304 64H416V224H304c-26.2 0-49.4-12.6-64-32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H225.6C233 91.5 265.3 64 304 64zM480 224H448V64h32c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32z"]],
    "text-height": [576, 512, [], "f034", ["M64 96v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V80C0 53.5 21.5 32 48 32H160 272c26.5 0 48 21.5 48 48v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V96H192l0 320h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H96c-17.7 0-32-14.3-32-32s14.3-32 32-32h32l0-320H64z", "M457.4 41.4c12.5-12.5 32.8-12.5 45.3 0l64 64c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H512l0 192h32c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8h32l0-192H416c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l64-64z"]],
    "user-xmark": [640, 512, ["user-times"], "f235", ["M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3z", "M505 143c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]],
    "face-hand-yawn": [512, 512, [], "e379", ["M336.9 498.9C438.7 465.1 512 369.1 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256c0 94.5 51.2 177 127.3 221.4c-9.8-18-15.3-38.6-15.3-60.5V384 330.4c0-28.7 23.3-52 52-52c1.8 0 3.6 .1 5.3 .3C184.8 246.3 217.8 224 256 224c28.7 0 54.5 12.6 72.1 32.6c14.8-2.4 30.4 2 41.8 13.4c12.2 12.2 16.5 29.4 12.8 45c1.1 .9 2.2 1.9 3.2 3c18.1 18.1 18.7 47.1 1.8 65.9c16.9 18.8 16.3 47.8-1.8 65.9l-49 49zM202 124.5l-80 64c-6.9 5.5-17 4.4-22.5-2.5s-4.4-17 2.5-22.5l80-64c6.9-5.5 17-4.4 22.5 2.5s4.4 17-2.5 22.5zM307.5 102c5.5-6.9 15.6-8 22.5-2.5l80 64c6.9 5.5 8 15.6 2.5 22.5s-15.6 8-22.5 2.5l-80-64c-6.9-5.5-8-15.6-2.5-22.5z", "M204.5 102c-5.5-6.9-15.6-8-22.5-2.5l-80 64c-6.9 5.5-8 15.6-2.5 22.5s15.6 8 22.5 2.5l80-64c6.9-5.5 8-15.6 2.5-22.5zm94.8 197.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-79 79c-5 5-13.7 1.5-13.7-5.7V330.4c0-11-9-20-20-20s-20 9-20 20V384v32.8c0 52.6 42.6 95.2 95.2 95.2c25.2 0 49.5-10 67.3-27.9l56.8-56.8c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L321.4 424c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L289.4 392c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l67.3-67.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L257.4 360c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3zM310 124.5l80 64c6.9 5.5 17 4.4 22.5-2.5s4.4-17-2.5-22.5l-80-64c-6.9-5.5-17-4.4-22.5 2.5s-4.4 17 2.5 22.5z"]],
    "gauge-simple-min": [512, 512, ["tachometer-slowest"], "f62d", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-35.3-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6c-11.3-7-26.1-3.5-33 7.8s-3.5 26.1 7.8 33l117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64s64-28.7 64-64z", "M100.6 227.6c-11.3-7-26.1-3.5-33 7.8s-3.5 26.1 7.8 33l117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6z"]],
    "stethoscope": [576, 512, [129658], "f0f1", ["M448 265.3V336c0 61.9-50.1 112-112 112c-57.6 0-105-43.4-111.3-99.3c-10.6 2.2-21.5 3.3-32.7 3.3c-10.8 0-21.3-1.1-31.5-3.1C167.1 440.1 243.1 512 336 512c97.2 0 176-78.8 176-176V265.3c-9.8 4.3-20.6 6.7-32 6.7s-22.2-2.4-32-6.7z", "M122.1 62.4c16.8-5.6 25.8-23.7 20.2-40.5S118.6-3.9 101.9 1.6L75.8 10.3C49.6 19.1 32 43.5 32 71.1V192c0 88.4 71.6 160 160 160s160-71.6 160-160V71.1c0-27.5-17.6-52-43.8-60.7L282.1 1.6c-16.8-5.6-34.9 3.5-40.5 20.2s3.5 34.9 20.2 40.5L288 71.1V192c0 53-43 96-96 96s-96-43-96-96V71.1l26.1-8.7zM512 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-80a80 80 0 1 0 0 160 80 80 0 1 0 0-160z"]],
    "coffin": [384, 512, [9904], "f6c6", ["M11.5 114.9l91-104C108.5 4 117.3 0 126.5 0h131c9.2 0 18 4 24.1 10.9l91 104c7.4 8.5 11.5 19.3 11.5 30.6c0 4.4-.6 8.7-1.8 12.9L286.7 488.9c-4 13.7-16.5 23.1-30.7 23.1H128.1c-14.3 0-26.8-9.4-30.7-23.1L1.8 158.3C.6 154.1 0 149.8 0 145.4c0-11.2 4.1-22.1 11.5-30.6z", ""]],
    "message": [512, 512, ["comment-alt"], "f27a", ["M64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h96v80c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64z", ""]],
    "salad": [512, 512, [129367, "bowl-salad"], "f81e", ["M423.8 96.2c-2.6-.2-5.2-.2-7.8-.2c-70.7 0-128 57.3-128 128c0 11 1.4 21.8 4 32H240V112c0-8.8-7.2-16-16-16s-16 7.2-16 16V249.4L107.3 148.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L169.4 256H96c-53 0-96-43-96-96s43-96 96-96c8.7 0 17.2 1.2 25.3 3.4C138.5 27.7 178 0 224 0s85.5 27.7 102.7 67.4c8-2.2 16.5-3.4 25.3-3.4c28.5 0 54.2 12.5 71.8 32.2zM512 224c0 11.2-1.9 22-5.5 32H325.5c-3.5-10-5.5-20.8-5.5-32c0-53 43-96 96-96s96 43 96 96z", "M27.4 288C12.3 288 0 300.3 0 315.4c0 70.5 44.4 130.7 106.7 154.1l1.8 14.4c2 16 15.6 28 31.8 28H371.8c16.1 0 29.8-12 31.8-28l1.8-14.4C467.6 446.1 512 385.9 512 315.4c0-15.1-12.3-27.4-27.4-27.4H27.4z"]],
    "info": [192, 512, [], "f129", ["M48 80a48 48 0 1 1 96 0A48 48 0 1 1 48 80z", "M32 192c-17.7 0-32 14.3-32 32s14.3 32 32 32H64V448H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H160c17.7 0 32-14.3 32-32s-14.3-32-32-32H128V224c0-17.7-14.3-32-32-32H32z"]],
    "robot-astromech": [512, 512, [], "e2d2", ["M96 192c-26.5 0-48 21.5-48 48V398.3c0 8.7-2.4 17.2-6.8 24.7L2.3 487.8c-3 4.9-3 11.1-.2 16.1s8.2 8.1 13.9 8.1h96c8.8 0 16-7.2 16-16V384l45.3 45.3c12 12 28.3 18.7 45.3 18.7h75c17 0 33.3-6.7 45.3-18.7L384 384V496c0 8.8 7.2 16 16 16h96c5.8 0 11.1-3.1 13.9-8.1s2.8-11.2-.2-16.1L470.8 423c-4.5-7.5-6.8-16-6.8-24.7V240c0-26.5-21.5-48-48-48H96zm112 64h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H208c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H208c-8.8 0-16-7.2-16-16s7.2-16 16-16z", "M128 128C128 57.3 185.3 0 256 0s128 57.3 128 128v64H128V128zm96 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM208 256h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H208c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H208c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "ring-diamond": [384, 512, [], "e5ab", ["M122.5 13.3C126.6 5.1 134.9 0 144 0h96c9.1 0 17.4 5.1 21.5 13.3l24 48c3.5 7.1 3.4 15.5-.5 22.4l-30.4 54.8C234.9 131.7 213.9 128 192 128s-42.9 3.7-62.6 10.4L99 83.7c-3.8-6.9-4-15.3-.5-22.4l24-48z", "M192 192a128 128 0 1 0 0 256 128 128 0 1 0 0-256zM384 320A192 192 0 1 1 0 320a192 192 0 1 1 384 0z"]],
    "fondue-pot": [512, 512, [129749], "e40d", ["M319 39.8l-24 96c-2.9 11.5-11.6 20-22.2 23L256.5 224H224c0-1.3 .2-2.6 .5-3.9L241.8 151c-7.9-7.7-11.7-19.3-8.8-30.8l24-96C261.2 7.1 278.6-3.3 295.8 1s27.6 21.7 23.3 38.8zm62.9 120.2L339.2 224H304c0-3.1 .9-6.1 2.7-8.9l48.6-72.9c-4.9-9.9-4.5-22.1 2.1-31.9l64-96C431.2-.5 451-4.4 465.8 5.4s18.7 29.7 8.9 44.4l-64 96c-6.6 9.9-17.7 14.9-28.7 14.2zM64 240V224h48 48v16 32c0 8.8-7.2 16-16 16s-16-7.2-16-16s-7.2-16-16-16s-16 7.2-16 16v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V240z", "M64 224H32c-17.7 0-32 14.3-32 32v64c0 52.3 25.1 98.8 64 128v32c0 17.7 14.3 32 32 32s32-14.3 32-32v-3.2c10.3 2.1 21 3.2 32 3.2H288c11 0 21.7-1.1 32-3.2V480c0 17.7 14.3 32 32 32s32-14.3 32-32V448c38.9-29.2 64-75.7 64-128V288h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H448 384 160v16 32c0 8.8-7.2 16-16 16s-16-7.2-16-16s-7.2-16-16-16s-16 7.2-16 16v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V240 224z"]],
    "theta": [384, 512, [], "f69e", ["M96 256c0-17.7 14.3-32 32-32H256c17.7 0 32 14.3 32 32s-14.3 32-32 32H128c-17.7 0-32-14.3-32-32z", "M104.2 128.4C79.9 160 64 205 64 256s15.9 96 40.2 127.6C128.5 415.1 159.8 432 192 432s63.5-16.9 87.8-48.4C304.1 352 320 307 320 256s-15.9-96-40.2-127.6C255.5 96.9 224.2 80 192 80s-63.5 16.9-87.8 48.4zm-50.7-39C87.1 45.7 135.8 16 192 16s104.9 29.7 138.5 73.4C364.1 133.1 384 192.1 384 256s-19.9 122.9-53.5 166.6C296.9 466.3 248.2 496 192 496s-104.9-29.7-138.5-73.4C19.9 378.9 0 319.9 0 256S19.9 133.1 53.5 89.4z"]],
    "face-hand-peeking": [640, 512, [129763], "e481", ["M545.5 134.7c-15.9-6.5-34.8-3.3-47.7 9.6c-7.3 7.3-11.5 16.6-12.6 26.2l-37.9-27.1c-10.9-7.8-24.3-9.3-36.1-5.4c-6.2-1.4-12.6-2.1-19.2-2.1c-48.6 0-88 39.4-88 88c0 40.3 27.1 74.3 64.1 84.7c-.1 1.1-.1 2.2-.1 3.3c0 22.1 17.9 40 40 40h8c0 .3 0 .6 0 .9c0 22.1 17.9 40 40 40h64.8c5.5 0 10.9-.4 16.3-1.1C491.8 464 411.5 512 320 512c-109.6 0-203-68.8-239.6-165.6c12.4 4.3 25.5 6.5 38.8 6.5l64.8 0c22.1 0 40-17.9 40-40c0-.3 0-.6 0-.9h8c22.1 0 40-17.9 40-40c0-2.6-.2-5.1-.7-7.5c10.1-7.3 16.7-19.1 16.7-32.5s-6.6-25.3-16.7-32.5c.5-2.4 .7-4.9 .7-7.5c0-22.1-17.9-40-40-40H156.8l1.5-1.5c17.2-17.2 17.2-45 0-62.2c-6-6-13.2-9.9-20.9-11.7C183.8 29.3 248.5 0 320 0c97.5 0 182.2 54.5 225.5 134.7zM384 400c0-26.5-28.7-48-64-48s-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48zm32.4-176c0 6.1-2.3 11.8-6.1 16H374.5c-3.8-4.2-6.1-9.9-6.1-16c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M232 208c8.8 0 16-7.2 16-16s-7.2-16-16-16H118.2c-7.1 0-10.7-8.6-5.7-13.7l28.8-28.8c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0L51.9 166.4l-.8 .8C14.7 204.4 15 264.1 51.9 301c17.9 17.9 42.1 27.9 67.3 27.9l64.8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-14 0c-2.5 0-4.5-2-4.5-4.5s2-4.5 4.5-4.5h62c8.8 0 16-7.2 16-16s-7.2-16-16-16H169.6c-2.2 0-4-1.8-4-4s1.8-4 4-4l78.4 0c8.8 0 16-7.2 16-16s-7.2-16-16-16H169.6c-2.2 0-4-1.8-4-4s1.8-4 4-4l62.4 0zm182.7-19c-7.2-5.1-8.9-15.1-3.7-22.3s15.1-8.9 22.3-3.7l81.8 58.4c2.3 1.6 5.1 2.3 7.8 2c9.3-1.1 13.2-12.4 6.6-19l-14.8-14.8c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0l45.1 45.1 .8 .8c36.4 37.2 36.1 96.9-.8 133.8c-17.9 17.9-42.1 27.9-67.3 27.9H456c-8.8 0-16-7.2-16-16s7.2-16 16-16h19.5c2.5 0 4.5-2 4.5-4.5s-2-4.5-4.5-4.5L408 328c-8.8 0-16-7.2-16-16s7.2-16 16-16h68c2.2 0 4-1.8 4-4s-1.8-4-4-4H392c-8.8 0-16-7.2-16-16s7.2-16 16-16l74.6 0c7.4 0 13.4-6 13.4-13.4c0-4.3-2.1-8.4-5.6-10.9L414.7 189z"]],
    "square-user": [448, 512, [], "e283", ["M81.1 416H366.9c-7.8-54.3-54.4-96-110.9-96H192c-56.4 0-103.1 41.7-110.9 96zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM224 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144z", "M152 200a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM81.1 416c7.8-54.3 54.4-96 110.9-96h64c56.4 0 103.1 41.7 110.9 96H81.1z"]],
    "down-left-and-up-right-to-center": [512, 512, ["compress-alt"], "f422", ["M216 272H72c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l39 39L7 439c-9.4 9.4-9.4 24.6 0 33.9l32 32c9.4 9.4 24.6 9.4 33.9 0l87-87 39 39c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2V296c0-13.3-10.7-24-24-24z", "M473 7c-9.4-9.4-24.6-9.4-33.9 0l-87 87L313 55c-6.9-6.9-17.2-8.9-26.2-5.2S272 62.3 272 72V216c0 13.3 10.7 24 24 24H440c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-39-39 87-87c9.4-9.4 9.4-24.6 0-33.9L473 7z"]],
    "explosion": [576, 512, [], "e4e9", ["M499.6 11.3c6.7-10.7 20.5-14.5 31.7-8.5s15.8 19.5 10.6 31L404.8 338.6c2.2 2.3 4.3 4.7 6.3 7.1l97.2-54.7c10.5-5.9 23.6-3.1 30.9 6.4s6.3 23-2.2 31.5l-91.4 91.4c1.6 9 2.4 18.2 2.4 27.7H384c0-53-43-96-96-96s-96 43-96 96H128c0-8.1 .6-16 1.8-23.8L42.3 363.7c-9.7-6.8-13.1-19.6-7.9-30.3s17.4-15.9 28.7-12.4l97.2 30.4c3-3.9 6.1-7.6 9.4-11.3L107.4 236.4c-6.1-10.1-3.9-23.1 5.1-30.7s22.2-7.5 31.1 .1L246 293.6c1.5-.4 3-.8 4.5-1.1l13.6-142.7c1.2-12.3 11.5-21.7 23.9-21.7s22.7 9.4 23.9 21.7l13.5 141.9L499.6 11.3zM288 0c13.3 0 24 10.7 24 24V72c0 13.3-10.7 24-24 24s-24-10.7-24-24V24c0-13.3 10.7-24 24-24z", "M0 480c0-17.7 14.3-32 32-32H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z"]],
    "file-lines": [384, 512, [128441, 128462, 61686, "file-alt", "file-text"], "f15c", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM112 256c-8.8 0-16 7.2-16 16s7.2 16 16 16H272c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H272c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H272c8.8 0 16-7.2 16-16s-7.2-16-16-16H112z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM112 256c-8.8 0-16 7.2-16 16s7.2 16 16 16H272c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H272c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H272c8.8 0 16-7.2 16-16s-7.2-16-16-16H112z"]],
    "wave-square": [640, 512, [], "f83e", ["M128 64c0-17.7 14.3-32 32-32H320c17.7 0 32 14.3 32 32V416h96V256c0-17.7 14.3-32 32-32H608c17.7 0 32 14.3 32 32s-14.3 32-32 32H512V448c0 17.7-14.3 32-32 32H320c-17.7 0-32-14.3-32-32V96H192V256c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32h96V64z", ""]],
    "ring": [512, 512, [], "f70b", ["M411.1 255.2C434.3 242 448 225.6 448 208c0-44.2-86-80-192-80s-192 35.8-192 80c0 17.6 13.7 34 36.9 47.2C141.2 235.9 195.8 224 256 224s114.8 11.9 155.1 31.2z", "M111.9 157.4C147.1 139.8 198 128 256 128s108.9 11.8 144.1 29.4C437.2 176 448 195.7 448 208s-10.8 32-47.9 50.6C364.9 276.2 314 288 256 288s-108.9-11.8-144.1-29.4C74.8 240 64 220.3 64 208s10.8-32 47.9-50.6zM83.3 100.2C39.4 122.2 0 158.4 0 208v96c0 49.6 39.4 85.8 83.3 107.8C129.1 434.7 190.3 448 256 448s126.9-13.3 172.7-36.2c43.9-22 83.3-58.2 83.3-107.8V208c0-49.6-39.4-85.8-83.3-107.8C382.9 77.3 321.7 64 256 64s-126.9 13.3-172.7 36.2z"]],
    "building-un": [384, 512, [], "e4d9", ["M48 0C21.5 0 0 21.5 0 48V464c0 26.5 21.5 48 48 48h96V432c0-26.5 21.5-48 48-48s48 21.5 48 48v80h96c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H48zM64 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H80c-8.8 0-16-7.2-16-16V240zm112-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H176c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H272c-8.8 0-16-7.2-16-16V240zM237.3 71.1l34.7 52V80c0-8.8 7.2-16 16-16s16 7.2 16 16v96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4l-34.7-52V176c0 8.8-7.2 16-16 16s-16-7.2-16-16V80c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4zM112 80v64c0 8.8 7.2 16 16 16s16-7.2 16-16V80c0-8.8 7.2-16 16-16s16 7.2 16 16v64c0 26.5-21.5 48-48 48s-48-21.5-48-48V80c0-8.8 7.2-16 16-16s16 7.2 16 16z", "M237.3 71.1c-3.9-5.9-11.2-8.5-17.9-6.4s-11.4 8.3-11.4 15.3v96c0 8.8 7.2 16 16 16s16-7.2 16-16V132.8l34.7 52c3.9 5.9 11.2 8.5 17.9 6.4s11.4-8.3 11.4-15.3V80c0-8.8-7.2-16-16-16s-16 7.2-16 16v43.2l-34.7-52zM112 80c0-8.8-7.2-16-16-16s-16 7.2-16 16v64c0 26.5 21.5 48 48 48s48-21.5 48-48V80c0-8.8-7.2-16-16-16s-16 7.2-16 16v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V80z"]],
    "dice-three": [448, 512, [9858], "f527", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm64 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M96 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "tire-pressure-warning": [512, 512, [], "f633", ["M384 32c0-17.7 14.3-32 32-32s32 14.3 32 32V54.5c0 24.1 3.9 48 11.5 70.8l2.5 7.4c4.8 14.4 11.5 28.6 19.3 44.4c17.5 35.6 33.4 82.6 27.5 136.2c-5.3 48.6-28.1 99-76.8 148.7v34c0 8.8-7.2 16-16 16H384c-8.8 0-16-7.2-16-16v-8H336v8c0 8.8-7.2 16-16 16H288c-8.8 0-16-7.2-16-16v-8H240v8c0 8.8-7.2 16-16 16H192c-8.8 0-16-7.2-16-16v-8H144v8c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V462C31.3 412.3 8.6 361.9 3.2 313.3c-5.9-53.6 9.9-100.6 27.5-136.2c7.8-15.8 14.5-30 19.3-44.4l2.5-7.4C60.1 102.5 64 78.5 64 54.5V32C64 14.3 78.3 0 96 0s32 14.3 32 32V54.5c0 31-5 61.7-14.8 91.1l-2.5 7.4c-6.3 19-14.8 36.6-22.6 52.5c-14.7 29.7-25.3 64-21.3 100.9c3.7 34 20.4 74.1 65.7 117.7H379.4c45.3-43.6 62-83.7 65.7-117.7c4.1-36.9-6.6-71.1-21.3-100.9c-7.8-15.8-16.3-33.5-22.6-52.5l-2.5-7.4C389 116.2 384 85.4 384 54.5V32z", "M280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24V232c0 13.3 10.7 24 24 24s24-10.7 24-24V120zM256 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "wifi-fair": [640, 512, ["wifi-2"], "f6ab", ["M320 96C216.8 96 123.2 136.7 54.2 202.9c-12.8 12.2-33 11.8-45.2-.9s-11.8-33 .9-45.2C90.3 79.5 199.6 32 320 32s229.7 47.5 310.2 124.7c12.8 12.2 13.2 32.5 .9 45.2s-32.5 13.2-45.2 .9C516.8 136.7 423.2 96 320 96z", "M171.8 312c39.5-34.9 91.3-56 148.2-56s108.6 21.1 148.2 56c13.3 11.7 33.5 10.4 45.2-2.8s10.4-33.5-2.8-45.2C459.8 219.2 393 192 320 192s-139.8 27.2-190.5 72c-13.3 11.7-14.5 31.9-2.8 45.2s31.9 14.5 45.2 2.8zM320 480a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", ["M0 192H448V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V192zm64 80v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zm144-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H208zm112 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H336c-8.8 0-16 7.2-16 16zM80 384c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V400c0-8.8-7.2-16-16-16H80zm112 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V400c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16zm144-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V400c0-8.8-7.2-16-16-16H336z", "M160 32c0-17.7-14.3-32-32-32S96 14.3 96 32V64H48C21.5 64 0 85.5 0 112v80H448V112c0-26.5-21.5-48-48-48H352V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V64H160V32z"]],
    "mp3-player": [384, 512, [], "f8ce", ["M0 64C0 28.7 28.7 0 64 0H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM288 352A96 96 0 1 0 96 352a96 96 0 1 0 192 0zM96 64C78.3 64 64 78.3 64 96v64c0 17.7 14.3 32 32 32H288c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32H96z", "M96 64H288c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32zM224 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 352a96 96 0 1 1 192 0A96 96 0 1 1 96 352z"]],
    "anchor-circle-check": [640, 512, [], "e4aa", ["M288 64a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm96 32c0 33.4-17 62.8-42.9 80H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H320V368v80h19.2c12.6 24.7 30.9 46 53 62.2c-7.9 1.2-16 1.8-24.2 1.8H288 208c-88.4 0-160-71.6-160-160v-6.1l-7 7c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l56-56c9.4-9.4 24.6-9.4 33.9 0l56 56c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-7-7V352c0 53 43 96 96 96h48V240H224c-17.7 0-32-14.3-32-32s14.3-32 32-32h10.9C209 158.8 192 129.4 192 96c0-53 43-96 96-96s96 43 96 96z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "tally-4": [640, 512, [], "e297", ["M128 32c17.7 0 32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64c0-17.7 14.3-32 32-32zm128 0c17.7 0 32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64c0-17.7 14.3-32 32-32zM416 64V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64c0-17.7 14.3-32 32-32s32 14.3 32 32z", "M512 32c17.7 0 32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64c0-17.7 14.3-32 32-32z"]],
    "rectangle-history": [512, 512, [], "e4a2", ["M464 104c0-13.3-10.7-24-24-24L72 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l368 0c13.3 0 24-10.7 24-24zM416 24c0-13.3-10.7-24-24-24L120 0C106.7 0 96 10.7 96 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24z", "M448 160c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l384 0z"]],
    "building-circle-arrow-right": [640, 512, [], "e4d1", ["M0 48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V232.2c-39.1 32.3-64 81.1-64 135.8c0 49.5 20.4 94.2 53.3 126.2C364.5 505.1 351.1 512 336 512H240V432c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-26.5 0-48-21.5-48-48V48zM80 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H80zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H272zM64 112v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H176zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm19.3-211.3l56 56c6.2 6.2 6.2 16.4 0 22.6l-56 56c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L521.4 384H432c-8.8 0-16-7.2-16-16s7.2-16 16-16h89.4l-28.7-28.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]],
    "volleyball": [512, 512, [127952, "volleyball-ball"], "f45f", ["M511.8 267.4c-26.1 8.7-53.4 13.8-81 15.1c9.2-105.3-31.5-204.2-103.2-272.4C434.1 41.1 512 139.5 512 256c0 3.8-.1 7.6-.2 11.4zm-3.9 34.7c-5.8 32-17.6 62-34.2 88.7c-97.5 48.5-217.7 42.6-311.9-24.5c23.7-36.2 55.4-67.7 94.5-91.8c79.9 43.2 170.1 50.8 251.6 27.6zm-236-55.5c-2.5-90.9-41.1-172.7-101.9-231.7C196.8 5.2 225.8 0 256 0c2.7 0 5.3 0 7.9 .1c90.8 60.2 145.7 167.2 134.7 282.3c-43.1-2.4-86.4-14.1-126.8-35.9zM138 28.8c20.6 18.3 38.7 39.4 53.7 62.6C95.9 136.1 30.6 220.8 7.3 316.9C2.5 297.4 0 277 0 256C0 157.2 56 71.5 138 28.8zm69.6 90.5c19.5 38.6 31 81.9 32.3 127.7C162.5 294.6 110.9 368.9 90.2 451C66 430.4 45.6 405.4 30.4 377.2c6.7-108.7 71.9-209.9 177.1-257.9zM256 512c-50.7 0-98-14.7-137.8-40.2c5.6-27 14.8-53.1 27.4-77.7C232.2 454.6 338.1 468.8 433 441c-46 44-108.3 71-177 71z", "M138 28.8c20.6 18.3 38.7 39.4 53.7 62.6C95.9 136.1 30.6 220.8 7.3 316.9c5.2 21.2 13 41.5 23.1 60.3c6.7-108.7 71.9-209.9 177.1-257.9c19.5 38.6 31 81.9 32.3 127.7C162.5 294.6 110.9 368.9 90.2 451c8.9 7.5 18.2 14.5 28.1 20.8c5.6-27 14.8-53.1 27.4-77.7C232.2 454.6 338.1 468.8 433 441c15.6-14.9 29.3-31.8 40.7-50.2c-97.5 48.5-217.7 42.6-311.9-24.5c23.7-36.2 55.4-67.8 94.5-91.8c79.9 43.2 170.1 50.8 251.6 27.6c2.1-11.3 3.4-22.9 3.9-34.7c-26.1 8.7-53.4 13.8-81 15.1c9.2-105.3-31.6-204.2-103.2-272.4C307.3 4.2 286 .8 263.9 .1c90.8 60.2 145.7 167.2 134.7 282.3c-43.2-2.4-86.4-14.1-126.8-35.9c-2.5-90.9-41.1-172.7-101.9-231.7c-11 3.9-21.7 8.6-32 14z"]],
    "sun-haze": [640, 512, [], "f765", ["M435.1 13.1c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L320 65.1 229.7 2.8c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L185 121 77.1 140.9c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L129.1 256l62.9 0c0-70.7 57.3-128 128-128s128 57.3 128 128l62.9 0 62.3-90.3c3.1-4.5 3.7-10.2 1.6-15.2s-6.6-8.6-11.9-9.6L455 121 435.1 13.1zM416 256c0-53-43-96-96-96s-96 43-96 96H416z", "M640 312c0-13.3-10.7-24-24-24H504c-13.3 0-24 10.7-24 24s10.7 24 24 24H616c13.3 0 24-10.7 24-24zm-208 0c0-13.3-10.7-24-24-24H88c-13.3 0-24 10.7-24 24s10.7 24 24 24H408c13.3 0 24-10.7 24-24zm144 88c0-13.3-10.7-24-24-24H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H552c13.3 0 24-10.7 24-24zM88 464c-13.3 0-24 10.7-24 24s10.7 24 24 24H200c13.3 0 24-10.7 24-24s-10.7-24-24-24H88zm208 0c-13.3 0-24 10.7-24 24s10.7 24 24 24H616c13.3 0 24-10.7 24-24s-10.7-24-24-24H296z"]],
    "text-size": [640, 512, [], "f894", ["M64 96v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V80C0 53.5 21.5 32 48 32H192 336c26.5 0 48 21.5 48 48v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V96H224l0 320h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H128c-17.7 0-32-14.3-32-32s14.3-32 32-32h32l0-320H64z", "M384 288v16c0 17.7-14.3 32-32 32s-32-14.3-32-32V272c0-26.5 21.5-48 48-48H592c26.5 0 48 21.5 48 48v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V288H512l0 128h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H432c-17.7 0-32-14.3-32-32s14.3-32 32-32h16l0-128H384z"]],
    "ufo": [640, 512, [128760], "e047", ["M496 237.1s-51.8 50.9-176 50.9s-176-50.9-176-50.9C144 141.5 222.8 64 320 64s176 77.5 176 173.1z", "M320 288c124.2 0 176-50.9 176-50.9c0-8.3-.6-16.5-1.7-24.5C582 235.5 640 275 640 320c0 70.7-143.3 128-320 128S0 390.7 0 320c0-45 58-84.5 145.7-107.4c-1.2 8-1.7 16.2-1.7 24.5c0 0 51.8 50.9 176 50.9zm24 88a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM128 352a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm408-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "fork": [512, 512, ["utensil-fork"], "f2e3", ["M411.3 27.3c5.8-5.8 6.3-15.1 1.1-21.5S398-1.9 391.1 2.7l-106.5 71C256.8 92.3 240 123.6 240 157.1c0 26.6 10.6 52.1 29.4 70.9L284 242.6c18.8 18.8 44.3 29.4 70.9 29.4c33.5 0 64.8-16.8 83.4-44.6l71-106.5c4.6-6.8 3.2-16-3.2-21.2s-15.6-4.8-21.5 1.1L393.4 192c-5.2 5.2-13.6 5.2-18.8 0c-4.9-4.9-5.2-12.8-.6-18.1l86.1-99.4c5.5-6.3 5.2-15.9-.8-21.8s-15.4-6.3-21.8-.8L338.1 138c-5.3 4.6-13.2 4.3-18.1-.6c-5.2-5.2-5.2-13.6 0-18.8l91.3-91.3z", "M9.4 457.4L255.7 211c3.9 6.1 8.4 11.8 13.6 17L284 242.6c5.2 5.2 10.9 9.8 17 13.6L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3z"]],
    "arrows-up-to-line": [576, 512, [], "e4c2", ["M0 64C0 81.7 14.3 96 32 96l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64z", "M54.6 278.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l96-96c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L160 237.3 160 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-210.7L54.6 278.6zm320 0c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l96-96c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L480 237.3 480 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-210.7-41.4 41.4z"]],
    "mobile-signal": [512, 512, [], "e1ef", ["M288 64H64V448H227c-2 13-3 26.4-3 40v24H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H288c35.3 0 64 28.7 64 64V261.7c-24.1 14.5-45.7 32.8-64 54V64zM128 400c0-8.8 7.2-16 16-16h64c8.8 0 16 7.2 16 16s-7.2 16-16 16H144c-8.8 0-16-7.2-16-16z", "M512 280c0-13.3-10.7-24-24-24c-128.1 0-232 103.9-232 232c0 13.3 10.7 24 24 24s24-10.7 24-24c0-101.6 82.4-184 184-184c13.3 0 24-10.7 24-24zM448 480a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm40-128c-75.1 0-136 60.9-136 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-48.6 39.4-88 88-88c13.3 0 24-10.7 24-24s-10.7-24-24-24z"]],
    "barcode-scan": [640, 512, [], "f465", ["M0 256c0-13.3 10.7-24 24-24H616c13.3 0 24 10.7 24 24s-10.7 24-24 24H24c-13.3 0-24-10.7-24-24z", "M64 56c0-13.3 10.7-24 24-24h16c13.3 0 24 10.7 24 24V192H64V56zm0 264h64V456c0 13.3-10.7 24-24 24H88c-13.3 0-24-10.7-24-24V320zm96 0h32V464c0 8.8-7.2 16-16 16s-16-7.2-16-16V320zm64 0h64V456c0 13.3-10.7 24-24 24H248c-13.3 0-24-10.7-24-24V320zm64-128H224V56c0-13.3 10.7-24 24-24h16c13.3 0 24 10.7 24 24V192zm32 128h64V456c0 13.3-10.7 24-24 24H344c-13.3 0-24-10.7-24-24V320zm64-128H320V56c0-13.3 10.7-24 24-24h16c13.3 0 24 10.7 24 24V192zm64 128h32V464c0 8.8-7.2 16-16 16s-16-7.2-16-16V320zm32-128H448V48c0-8.8 7.2-16 16-16s16 7.2 16 16V192zm32 128h64V456c0 13.3-10.7 24-24 24H536c-13.3 0-24-10.7-24-24V320zm64-128H512V56c0-13.3 10.7-24 24-24h16c13.3 0 24 10.7 24 24V192zm-384 0H160V48c0-8.8 7.2-16 16-16s16 7.2 16 16V192z"]],
    "sort-down": [320, 512, ["sort-desc"], "f0dd", ["M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zM109.3 160H210.7L160 109.3 109.3 160z", "M182.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128z"]],
    "folder-arrow-down": [512, 512, ["folder-download"], "e053", ["M512 416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H192c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8H448c35.3 0 64 28.7 64 64V416zM280 200c0-13.3-10.7-24-24-24s-24 10.7-24 24V302.1l-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31V200z", "M256 176c13.3 0 24 10.7 24 24V302.1l31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31V200c0-13.3 10.7-24 24-24z"]],
    "circle-minus": [512, 512, ["minus-circle"], "f056", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 232H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M160 256c0-13.3 10.7-24 24-24H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24z"]],
    "face-icicles": [512, 512, [], "e37c", ["M512 256c0 8.3-.4 16.6-1.2 24.7c0 .5-.1 1.1-.1 1.6l-14.8 200C494.7 499.1 480.8 512 464 512s-30.7-12.9-31.9-29.6l-2.8-37.9c-5 4.6-10.2 9-15.6 13.2l-11.5 32.9C397.7 503.4 385.6 512 372 512c-11.5 0-21.9-6.1-27.5-15.7C316.9 506.5 287.1 512 256 512c-69.4 0-132.3-27.6-178.4-72.4C71.9 444.9 64.3 448 56 448c-15.6 0-29-11.3-31.6-26.7L6.5 313.4C2.2 294.9 0 275.7 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256zM56 415.8l0 .2 0-.2 20-120.2C78.1 283.3 68.6 272 56 272s-22.1 11.3-20.1 23.7L56 415.8zM344 400l28 80 28-80V360l-56 0v40zm55.3-56c-3.8-22.7-23.6-40-47.3-40h-8v40l55.3 0zM328 344V304H264v40h64zm0 56V360H264v40l32 48 32-48zm-80-96H184v40l64 0V304zm0 56l-64 0v40h64V360zm-80-16V304h-8c-23.8 0-43.5 17.3-47.3 40H168zm0 56V360H112.7c3.8 22.7 23.6 40 47.3 40h8zm40.4-192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM464 480l21.8-232.1C487 235.1 476.9 224 464 224s-23 11.1-21.8 23.9L464 480z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "shovel": [512, 512, [], "f713", ["M406.6 9.4c-12.5-12.5-32.8-12.5-45.3 0L317.3 53.5C298.5 72.2 288 97.6 288 124.1c0 15.9 3.7 30.9 10.3 44.3l-97 97 45.3 45.3 97-97c13.4 6.6 28.4 10.3 44.3 10.3c26.5 0 51.9-10.5 70.6-29.3l44.1-44.1c12.5-12.5 12.5-32.8 0-45.3l-96-96zM362.5 98.7L384 77.3 434.7 128l-21.5 21.5c-6.7 6.7-15.9 10.5-25.4 10.5c-19.8 0-35.9-16.1-35.9-35.9c0-9.5 3.8-18.6 10.5-25.4z", "M0 386.3V480c0 17.7 14.3 32 32 32h93.7c42.4 0 83.1-16.9 113.1-46.9l58.5-58.5c12.5-12.5 12.5-32.8 0-45.3L150.6 214.6c-12.5-12.5-32.8-12.5-45.3 0L46.9 273.1C16.9 303.1 0 343.8 0 386.3z"]],
    "door-open": [576, 512, [], "f52b", ["M307.7 6.8C315.5 12.8 320 22.1 320 32V480v32l-32 0L96 512l-32 0V480 92.5c0-22 15-41.2 36.4-46.6L280.2 1c9.6-2.4 19.7-.2 27.5 5.8zM232 288c13.3 0 24-14.3 24-32s-10.7-32-24-32s-24 14.3-24 32s10.7 32 24 32z", "M320 128H448V480c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H512V128c0-35.3-28.7-64-64-64H320v64zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32H64V448H32zM232 288c13.3 0 24-14.3 24-32s-10.7-32-24-32s-24 14.3-24 32s10.7 32 24 32z"]],
    "films": [576, 512, [], "e17a", ["M256 112v48c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V112c0-17.7-14.3-32-32-32H288c-17.7 0-32 14.3-32 32zm0 144v48c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32H288c-17.7 0-32 14.3-32 32zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120V344c0 75.1 60.9 136 136 136H456c13.3 0 24-10.7 24-24s-10.7-24-24-24H136c-48.6 0-88-39.4-88-88V120z", "M96 96c0-35.3 28.7-64 64-64H512c35.3 0 64 28.7 64 64V320c0 35.3-28.7 64-64 64H160c-35.3 0-64-28.7-64-64V96zm56 0v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V96c0-8.8-7.2-16-16-16H168c-8.8 0-16 7.2-16 16zM488 80c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V96c0-8.8-7.2-16-16-16H488zM152 200v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V200c0-8.8-7.2-16-16-16H168c-8.8 0-16 7.2-16 16zm336-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V200c0-8.8-7.2-16-16-16H488zM152 304v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V304c0-8.8-7.2-16-16-16H168c-8.8 0-16 7.2-16 16zm336-16c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V304c0-8.8-7.2-16-16-16H488zM256 112v48c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V112c0-17.7-14.3-32-32-32H288c-17.7 0-32 14.3-32 32zm32 112c-17.7 0-32 14.3-32 32v48c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32H288z"]],
    "right-from-bracket": [512, 512, ["sign-out-alt"], "f2f5", ["M199.7 60.8c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-53 0-96-43-96-96l0-256c0-53 43-96 96-96l64 0c17.7 0 32 14.3 32 32z", "M508.4 225.5L385.7 102.7c-6.4-6.4-15-9.9-24-9.9c-18.7 0-33.9 15.2-33.9 33.9l0 62.1-128 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0 0 62.1c0 18.7 15.2 33.9 33.9 33.9c9 0 17.6-3.6 24-9.9L508.4 280.1c7.2-7.2 11.3-17.1 11.3-27.3s-4.1-20.1-11.3-27.3z"]],
    "face-glasses": [512, 512, [], "e377", ["M512 256c0 141.4-114.6 256-256 256S0 397.4 0 256c0-22.8 3-44.8 8.5-65.8c2.2 1.2 4.8 1.8 7.5 1.8H48v56c0 30.9 25.1 56 56 56h80c30.9 0 56-25.1 56-56V192h32v56c0 30.9 25.1 56 56 56h80c30.9 0 56-25.1 56-56V192h32c2.7 0 5.2-.7 7.5-1.8c5.6 21 8.5 43.1 8.5 65.8zM53.4 160H18.6C56.6 66.2 148.6 0 256 0S455.4 66.2 493.4 160H458.6c-9-18.9-28.3-32-50.6-32H328c-22.3 0-41.6 13.1-50.6 32H234.6c-9-18.9-28.3-32-50.6-32H104c-22.3 0-41.6 13.1-50.6 32zm88.1 179.9c-6.7 5.8-7.4 15.9-1.6 22.6c22.2 25.7 61 53.5 116.1 53.5s93.8-27.9 116.1-53.5c5.8-6.7 5.1-16.8-1.6-22.6s-16.8-5.1-22.6 1.6C330 362.2 299.4 384 256 384s-74-21.8-91.9-42.5c-5.8-6.7-15.9-7.4-22.6-1.6z", "M16 192H48v56c0 30.9 25.1 56 56 56h80c30.9 0 56-25.1 56-56V192h32v56c0 30.9 25.1 56 56 56h80c30.9 0 56-25.1 56-56V192h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H458.6c-9-18.9-28.3-32-50.6-32H328c-22.3 0-41.6 13.1-50.6 32H234.6c-9-18.9-28.3-32-50.6-32H104c-22.3 0-41.6 13.1-50.6 32H16c-8.8 0-16 7.2-16 16s7.2 16 16 16zm64 56V192v-8c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24v64c0 13.3-10.7 24-24 24H104c-13.3 0-24-10.7-24-24zm352-56v56c0 13.3-10.7 24-24 24H328c-13.3 0-24-10.7-24-24V184c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24v8zM184.4 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm168 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "nfc": [448, 512, [], "e1f7", ["M210.7 128H144 112c-8.8 0-16 7.2-16 16V368c0 8.8 7.2 16 16 16H336c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H256c-8.8 0-16 7.2-16 16v66.7c18.6 6.6 32 24.4 32 45.3c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V144c0-5.6 1-11 2.7-16z", "M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm48 64h32c8.8 0 16 7.2 16 16s-7.2 16-16 16h66.7c6.6-18.6 24.4-32 45.3-32h80c26.5 0 48 21.5 48 48V368c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48V144c0-26.5 21.5-48 48-48z"]],
    "atom": [512, 512, [9883], "f5d2", ["M290.9 412.3c-16.7 33.8-31 35.7-34.9 35.7s-18.1-1.9-34.9-35.7c11.4-3.9 23.1-8.4 34.9-13.5c11.8 5.1 23.4 9.7 34.9 13.5zM469.6 384c20.7-37.1 9.4-82.8-23.6-128c33-45.2 44.3-90.9 23.6-128c-20.2-36.3-62.5-49.3-115.2-43.2C332.4 32.7 298.8 0 256 0s-76.4 32.7-98.4 84.8c-52.7-6.1-95 6.8-115.2 43.2C21.7 165.1 33 210.8 66 256c-33 45.2-44.3 90.9-23.6 128c20.2 36.3 62.5 49.3 115.2 43.2c22 52.1 55.7 84.8 98.4 84.8s76.4-32.7 98.4-84.8c52.7 6.1 95-6.8 115.2-43.2zm-67.8-79.2c18.9 30.2 14.2 44 11.9 48.1c-1.6 2.9-8.4 13-40.2 11.7c2.8-13.1 5-26.9 6.7-41.2c7.6-6.1 14.8-12.3 21.6-18.6zm11.9-145.7c2.3 4.2 7 17.9-11.9 48.1c-6.8-6.3-14-12.5-21.6-18.6c-1.7-14.3-3.9-28-6.7-41.2c31.8-1.4 38.6 8.7 40.2 11.7zM256 64c3.9 0 18.1 1.9 34.9 35.7c-11.4 3.9-23.1 8.4-34.9 13.5c-11.8-5.1-23.4-9.7-34.9-13.5C237.9 65.9 252.1 64 256 64zM138.5 147.5c-2.8 13.1-5 26.9-6.7 41.2c-7.6 6.1-14.8 12.3-21.6 18.6C91.4 177 96 163.3 98.3 159.1c1.6-2.9 8.4-13 40.2-11.7zM98.3 352.9c-2.3-4.2-7-17.9 11.9-48.1c6.8 6.3 14 12.5 21.6 18.6c1.7 14.2 3.9 28 6.7 41.2c-31.8 1.4-38.6-8.7-40.2-11.7zM256 176a80 80 0 1 1 0 160 80 80 0 1 1 0-160z", "M224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "soap": [512, 512, [129532], "e06e", ["M160 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm96 144a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM384 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M385.6 262.1C404.3 244.5 416 219.6 416 192c53 0 96 43 96 96V416c0 53-43 96-96 96H96c-53 0-96-43-96-96V288c0-53 43-96 96-96H224c0 24.6 9.2 47 24.4 64H160c-53 0-96 43-96 96s43 96 96 96H352c53 0 96-43 96-96c0-41.2-25.9-76.3-62.4-89.9zM320 288h32c35.3 0 64 28.7 64 64s-28.7 64-64 64H160c-35.3 0-64-28.7-64-64s28.7-64 64-64H320z"]],
    "icons": [512, 512, ["heart-music-camera-bolt"], "f86d", ["M139.7 219.1l96.4-99.9c28-29 26.5-76.9-4.5-103.9c-28-23.5-68.9-19-93.9 6.5l-9.5 10.5-10-10.5c-25-25.5-66.4-30-93.4-6.5c-31.5 27-33 74.9-5 103.9l96.9 99.9c6 6.5 16.5 6.5 23 0zm333.7 39.9c-6-4.4-14.3-4-19.9 .9l-128 112c-5 4.4-6.8 11.4-4.4 17.7s8.3 10.4 15 10.4h55.7l-38.4 89.7c-2.9 6.9-.7 14.9 5.3 19.2s14.3 4 19.9-.9l128-112c5-4.4 6.8-11.4 4.4-17.7s-8.3-10.4-15-10.4H440.3l38.4-89.7c2.9-6.9 .7-14.9-5.3-19.2z", "M500.3 7.3C507.7 13.3 512 22.4 512 32V176c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48V71L352 90.2V208c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48V64c0-15.3 10.8-28.4 25.7-31.4l160-32c9.4-1.9 19.1 .6 26.6 6.6zM74.7 304l11.8-17.8c5.9-8.9 15.9-14.2 26.6-14.2h61.7c10.7 0 20.7 5.3 26.6 14.2L213.3 304H256c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V336c0-17.7 14.3-32 32-32H74.7zM192 408a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]],
    "microphone-lines-slash": [640, 512, ["microphone-alt-slash"], "f539", ["M401.3 412.2l-43.1-33.9C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128v-8.7L144.7 210c-.5 1.9-.7 3.9-.7 6v40c0 89.1 66.2 162.7 152 174.4V464H248c-13.3 0-24 10.7-24 24s10.7 24 24 24h72 72c13.3 0 24-10.7 24-24s-10.7-24-24-24H344V430.4c20.4-2.8 39.7-9.1 57.3-18.2zm70.8-67.5c15.2-26 23.9-56.3 23.9-88.7V216c0-13.3-10.7-24-24-24s-24 10.7-24 24v24 16c0 21.2-5.1 41.1-14.2 58.7l38.3 30zM408 294.5c5.2-11.8 8-24.8 8-38.5H358.9L408 294.5zM324.4 229c2.9-3.1 7-5 11.6-5h80V192H336c-8.8 0-16-7.2-16-16s7.2-16 16-16h80V128H336c-8.8 0-16-7.2-16-16s7.2-16 16-16h80c0-53-43-96-96-96s-96 43-96 96v54.3L324.4 229z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "closed-captioning-slash": [640, 512, [], "e135", ["M32 121.2V416c0 35.3 28.7 64 64 64H487.4L295 328.4c-16.8 14.7-38.9 23.6-63 23.6c-53 0-96-43-96-96c0-16 3.9-31.1 10.8-44.3L32 121.2zM255.9 297.6l-70-55.1c-1.3 4.3-1.9 8.8-1.9 13.5c0 26.5 21.5 48 48 48c8.7 0 16.9-2.3 23.9-6.4zM303.5 192c6.1 6.8 7.6 16.2 4.7 24.3l22.4 17.5c10-42.3 48-73.8 93.4-73.8c28.4 0 54 12.4 71.5 32c8.8 9.9 8 25-1.9 33.9s-25 8-33.9-1.9c-8.8-9.9-21.6-16-35.8-16c-26.5 0-48 21.5-48 48c0 5.4 .9 10.5 2.5 15.4l41.4 32.5c1.3 .1 2.7 .2 4.1 .2c14.2 0 27-6.1 35.8-16c8.8-9.9 24-10.7 33.9-1.9s10.7 24 1.9 33.9c-7.8 8.7-17.2 16-27.7 21.4L600.8 445.6c4.6-8.8 7.2-18.9 7.2-29.6V96c0-35.3-28.7-64-64-64H96c-6.7 0-13.1 1-19.2 2.9L236.6 160.1c26.6 1.2 50.4 13.3 67 31.9z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", ["M48 0C21.5 0 0 21.5 0 48V176c0 26.5 21.5 48 48 48H176c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H48zM336 0c-26.5 0-48 21.5-48 48V176c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H336zM0 336V464c0 26.5 21.5 48 48 48H176c26.5 0 48-21.5 48-48V336c0-26.5-21.5-48-48-48H48c-26.5 0-48 21.5-48 48zM416 64V96h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H416v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V128H352c-8.8 0-16-7.2-16-16s7.2-16 16-16h32V64c0-8.8 7.2-16 16-16s16 7.2 16 16zM64 96h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H64c-8.8 0-16-7.2-16-16s7.2-16 16-16zM83.3 348.7L112 377.4l28.7-28.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L134.6 400l28.7 28.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L112 422.6 83.3 451.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L89.4 400 60.7 371.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z", "M416 64V96h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H416v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V128H352c-8.8 0-16-7.2-16-16s7.2-16 16-16h32V64c0-8.8 7.2-16 16-16s16 7.2 16 16zM64 96h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H64c-8.8 0-16-7.2-16-16s7.2-16 16-16zM83.3 348.7L112 377.4l28.7-28.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L134.6 400l28.7 28.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L112 422.6 83.3 451.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L89.4 400 60.7 371.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zM288 336c0-26.5 21.5-48 48-48H464c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48H336c-26.5 0-48-21.5-48-48V336zm48 32c0 8.8 7.2 16 16 16h96c8.8 0 16-7.2 16-16s-7.2-16-16-16H352c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16h96c8.8 0 16-7.2 16-16s-7.2-16-16-16H352c-8.8 0-16 7.2-16 16z"]],
    "bridge-circle-check": [640, 512, [], "e4c9", ["M32 64c0-17.7 14.3-32 32-32H576c17.7 0 32 14.3 32 32s-14.3 32-32 32H536v64h72v72.2C577.6 207.1 538.5 192 496 192c-69.1 0-128.9 39.8-157.7 97.7c-5.9-1.1-12-1.7-18.3-1.7c-53 0-96 43-96 96v64c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V384c0-53-43-96-96-96V160h72V96H64C46.3 96 32 81.7 32 64zM408 96v64h80V96H408zm-48 64V96H280v64h80zM152 96v64h80V96H152z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "sliders-up": [512, 512, ["sliders-v"], "f3f1", ["M96 0C78.3 0 64 14.3 64 32V86.7C73.8 82.4 84.6 80 96 80s22.2 2.4 32 6.7V32c0-17.7-14.3-32-32-32zM64 233.3V480c0 17.7 14.3 32 32 32s32-14.3 32-32V233.3c-9.8 4.3-20.6 6.7-32 6.7s-22.2-2.4-32-6.7zM256 0c-17.7 0-32 14.3-32 32V278.7c9.8-4.3 20.6-6.7 32-6.7s22.2 2.4 32 6.7V32c0-17.7-14.3-32-32-32zM224 425.3V480c0 17.7 14.3 32 32 32s32-14.3 32-32V425.3c-9.8 4.3-20.6 6.7-32 6.7s-22.2-2.4-32-6.7zM448 32c0-17.7-14.3-32-32-32s-32 14.3-32 32v86.7c9.8-4.3 20.6-6.7 32-6.7s22.2 2.4 32 6.7V32zM384 265.3V480c0 17.7 14.3 32 32 32s32-14.3 32-32V265.3c-9.8 4.3-20.6 6.7-32 6.7s-22.2-2.4-32-6.7z", "M96 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112A80 80 0 1 0 96 80a80 80 0 1 0 0 160zm160 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM384 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]],
    "location-minus": [384, 512, ["map-marker-minus"], "f609", ["M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM120 168H264c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M96 192c0-13.3 10.7-24 24-24H264c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24z"]],
    "pump-medical": [448, 512, [], "e06a", ["M117.4 160c-33.3 0-61 25.5-63.8 58.7L35 442.7C31.9 480 61.3 512 98.8 512H285.2c37.4 0 66.9-32 63.8-69.3l-18.7-224c-2.8-33.2-30.5-58.7-63.8-58.7H117.4zM216 280v32h32c13.3 0 24 10.7 24 24s-10.7 24-24 24H216v32c0 13.3-10.7 24-24 24s-24-10.7-24-24V360H136c-13.3 0-24-10.7-24-24s10.7-24 24-24h32V280c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M128 32c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32h60.1c21.2 0 41.6 8.4 56.6 23.4l33.9 33.9c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-33.9-33.9c-3-3-7.1-4.7-11.3-4.7H256v64H128V32zm64 224c13.3 0 24 10.7 24 24v32h32c13.3 0 24 10.7 24 24s-10.7 24-24 24H216v32c0 13.3-10.7 24-24 24s-24-10.7-24-24V360H136c-13.3 0-24-10.7-24-24s10.7-24 24-24h32V280c0-13.3 10.7-24 24-24z"]],
    "fingerprint": [512, 512, [], "f577", ["M256 80c97.2 0 176 78.8 176 176v24.9c0 27.7-1.7 55.3-5 82.7c-1.4 11.7-11.5 20.3-23.3 20.3c-14.7 0-25.9-13.2-24.2-27.8c3-24.9 4.4-50.1 4.4-75.3V256c0-70.7-57.3-128-128-128c-11.6 0-22.8 1.5-33.4 4.4c-10.6 2.9-22.3 .4-29.4-7.9c-10.4-12.1-6.9-30.9 8.3-35.9C218.6 83 237 80 256 80zM150.7 148.7c8.2 9.6 7.5 23.8 .2 34.2C136.5 203.6 128 228.8 128 256v24.9c0 28.9-3.3 57.7-9.7 85.8C115.9 377 106.6 384 96.1 384c-15.9 0-27.3-15.6-23.9-31.1c5.2-23.6 7.8-47.7 7.8-71.9V256c0-40.6 13.7-78 36.8-107.7c8.5-11 24.8-10.2 33.9 .4zM280 256v24.9c0 65.8-12.1 131-35.7 192.4l-5.9 15.3c-4.8 12.4-18.6 18.5-31 13.8s-18.5-18.6-13.8-31l5.9-15.3C221 400.2 232 340.8 232 280.9V256c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M48 256C48 141.1 141.1 48 256 48c63.1 0 119.6 28.1 157.8 72.5c8.6 10.1 23.8 11.2 33.8 2.6s11.2-23.8 2.6-33.8C403.3 34.6 333.7 0 256 0C114.6 0 0 114.6 0 256v40c0 13.3 10.7 24 24 24s24-10.7 24-24V256zm458.5-52.9c-2.7-13-15.5-21.3-28.4-18.5s-21.3 15.5-18.5 28.4c2.9 13.9 4.5 28.3 4.5 43.1v40c0 13.3 10.7 24 24 24s24-10.7 24-24V256c0-18.1-1.9-35.8-5.5-52.9zM352 256c0-53-43-96-96-96s-96 43-96 96v24.9c0 35.9-4.6 71.5-13.8 106.1c-3.8 14.3 6.7 29 21.5 29c9.5 0 17.9-6.2 20.4-15.4c10.5-39 15.9-79.2 15.9-119.7V256c0-28.7 23.3-52 52-52s52 23.3 52 52v24.9c0 36.3-3.5 72.4-10.4 107.9c-2.7 13.9 7.7 27.2 21.8 27.2c10.2 0 19-7 21-17c7.7-38.8 11.6-78.3 11.6-118.1V256z"]],
    "ski-boot": [512, 512, [], "e3cc", ["M480 448L5.6 448l-5 26c-1.8 9.4 .7 19.1 6.8 26.4c6.1 7.3 15.1 11.6 24.6 11.6H480.1c17.6 0 31.9-14.3 31.9-32c0-17.7-14.3-32-32-32zM35.4 292.8c45.7-10.8 158.9-58 194-260.8H112C96.7 32 83.5 42.9 80.6 58L35.4 292.8z", "M358 .6c17.4 3.3 28.7 20.1 25.4 37.5l-6.2 32L360 160H288c-8.8 0-16 7.2-16 16s7.2 16 16 16h65.8l-12.3 64H272c-8.8 0-16 7.2-16 16s7.2 16 16 16h68l122 59.2c11 5.4 18 16.5 18 28.8v72L5.6 448 35.4 292.8c45.7-10.8 158.9-58 194-260.8h90l1.2-6C323.9 8.6 340.7-2.8 358 .6z"]],
    "standard-definition": [576, 512, ["rectangle-sd"], "e28a", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM304 184c0-13.3 10.7-24 24-24h56c53 0 96 43 96 96s-43 96-96 96H328c-13.3 0-24-10.7-24-24V184zm48 24v96h32c26.5 0 48-21.5 48-48s-21.5-48-48-48H352zm-193.2 8.1c-.3 3 .2 3.9 .3 4.1l0 0c.2 .3 .9 1.5 3.9 3.3c7 4.2 18 7 34.1 10.7l1.7 .4 0 0c13.6 3.2 31.5 7.3 45.1 15.5c7.7 4.6 15.4 11.1 20.5 20.7c5.3 9.8 6.7 20.8 5 32.3c-1.6 10.9-6 20.7-13.4 28.5c-7.2 7.6-16 12.3-24.9 15.2c-17.2 5.4-37.5 4.9-56.4 2.3l-.1 0 0 0c-11-1.5-28.6-6.7-39.4-9.9l0 0 0 0 0 0c-2-.6-3.8-1.1-5.3-1.5c-11.9-3.4-18.8-15.8-15.4-27.7s15.8-18.8 27.7-15.4c2.3 .6 4.7 1.4 7.2 2.1c11.1 3.2 24 7 31.4 8c16.8 2.2 29.2 1.8 36.9-.6c3.5-1.1 5.1-2.4 5.8-3.1c.5-.6 1.3-1.6 1.7-4.3c.5-3.4-.1-4.5-.2-4.7l0 0c-.2-.3-.9-1.5-3.9-3.3c-7-4.2-18-7-34.1-10.7l-1.7-.4 0 0c-13.6-3.2-31.5-7.3-45.1-15.5c-7.7-4.6-15.4-11.1-20.5-20.7c-5.3-9.8-6.7-20.8-5-32.3c.1-.4 .1-.8 .2-1.2c4.6-22.6 19.7-36.2 38.5-42.3c17.1-5.5 37.1-5 56-2.5c5.8 .8 23.2 3.7 29.7 5.1c12.1 2.8 19.6 14.8 16.9 26.8s-14.8 19.6-26.8 16.9c-4.7-1.1-20.6-3.7-25.7-4.4c-16.8-2.2-28.8-1.7-36.2 .7c-5.5 1.8-7.3 3.9-8.3 8z", "M328 160c-13.3 0-24 10.7-24 24V328c0 13.3 10.7 24 24 24h56c53 0 96-43 96-96s-43-96-96-96H328zm24 144V208h32c26.5 0 48 21.5 48 48s-21.5 48-48 48H352zM167.1 208.1c7.4-2.4 19.5-2.9 36.2-.7c5.1 .7 21.1 3.4 25.7 4.4c12.1 2.8 24.1-4.8 26.8-16.9s-4.8-24.1-16.9-26.8c-6.5-1.5-23.9-4.4-29.7-5.1c-18.9-2.5-38.9-3.1-56 2.5c-18.8 6.1-33.9 19.7-38.5 42.3c-.1 .4-.1 .8-.2 1.2c-1.7 11.4-.2 22.4 5 32.3c5.1 9.6 12.9 16.1 20.5 20.7c13.7 8.2 31.5 12.3 45.1 15.5l1.7 .4c16 3.7 27.1 6.5 34.1 10.7c3 1.8 3.8 3 3.9 3.3l0 0c.1 .1 .7 1.2 .2 4.7c-.4 2.7-1.2 3.8-1.7 4.3c-.7 .7-2.3 2-5.8 3.1c-7.7 2.4-20.1 2.9-36.9 .6c-7.4-1-20.3-4.8-31.4-8c-2.5-.7-5-1.4-7.2-2.1c-11.9-3.4-24.3 3.5-27.7 15.4s3.5 24.3 15.4 27.7c1.5 .4 3.3 1 5.3 1.6l0 0 0 0c10.8 3.2 28.4 8.3 39.4 9.9l0 0 .1 0c18.9 2.5 39.2 3.1 56.4-2.3c8.9-2.8 17.8-7.5 24.9-15.2c7.3-7.8 11.8-17.6 13.4-28.5c1.7-11.4 .2-22.4-5-32.3c-5.1-9.6-12.9-16.1-20.5-20.7c-13.7-8.2-31.5-12.3-45.1-15.5l0 0-1.7-.4c-16-3.7-27.1-6.5-34.1-10.7c-3-1.8-3.8-3-3.9-3.3l0 0c-.1-.1-.6-1.1-.3-4.1c.9-4 2.8-6.2 8.3-8z"]],
    "h1": [576, 512, [], "f313", ["M32 64c17.7 0 32 14.3 32 32V224H256V96c0-17.7 14.3-32 32-32s32 14.3 32 32V256 416c0 17.7-14.3 32-32 32s-32-14.3-32-32V288H64V416c0 17.7-14.3 32-32 32s-32-14.3-32-32V256 96C0 78.3 14.3 64 32 64z", "M496.8 68.8C506.3 74.6 512 84.9 512 96V384h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H480 416c-17.7 0-32-14.3-32-32s14.3-32 32-32h32V147.8l-17.7 8.8c-15.8 7.9-35 1.5-42.9-14.3s-1.5-35 14.3-42.9l64-32c9.9-5 21.7-4.4 31.1 1.4z"]],
    "hand-point-right": [512, 512, [], "f0a4", ["M512 128c0 17.7-14.3 32-32 32l-208 0 0-64 208 0c17.7 0 32 14.3 32 32zM200 288l.6 0c-5.4 9.4-8.6 20.3-8.6 32c0 13.2 4 25.4 10.8 35.6C177.9 364.3 160 388.1 160 416c0 11.7 3.1 22.6 8.6 32l-8.6 0C71.6 448 0 376.4 0 288l0-61.7c0-42.4 16.9-83.1 46.9-113.1l11.6-11.6C82.5 77.5 115.1 64 149 64l27 0c35.3 0 64 28.7 64 64l0 88c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-56c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 56c0 39.8 32.2 72 72 72z", "M352 192c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32h48zm-32 96c17.7 0 32 14.3 32 32s-14.3 32-32 32H256c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0zm0 128c0 17.7-14.3 32-32 32H224c-17.7 0-32-14.3-32-32s14.3-32 32-32h64c17.7 0 32 14.3 32 32z"]],
    "magnifying-glass-location": [512, 512, ["search-location"], "f689", ["M208 416A208 208 0 1 0 208 0a208 208 0 1 0 0 416zm11.4-101.4c-6 7.3-16.8 7.3-22.7 0C174.5 287.6 128 224.8 128 176c0-44.2 35.8-80 80-80s80 35.8 80 80c0 48.8-46.5 111.6-68.6 138.6z", "M288 176c0 48.8-46.5 111.6-68.6 138.6c-6 7.3-16.8 7.3-22.7 0C174.5 287.6 128 224.8 128 176c0-44.2 35.8-80 80-80s80 35.8 80 80zm-48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm90.7 200C348 363.3 363.3 348 376 330.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376z"]],
    "message-bot": [640, 512, [], "e3b8", ["M96 64c0-35.3 28.7-64 64-64H480c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H373.3L249.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H160c-35.3 0-64-28.7-64-64V64zm96 32c-17.7 0-32 14.3-32 32V256c0 17.7 14.3 32 32 32H448c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H192z", "M59.7 208c-5.5 9.6-15.9 16-27.7 16c-17.7 0-32-14.3-32-32s14.3-32 32-32c11.8 0 22.2 6.4 27.7 16H96v32H59.7zM192 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm224-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm224 32c0 17.7-14.3 32-32 32c-11.8 0-22.2-6.4-27.7-16H544V176h36.3c5.5-9.6 15.9-16 27.7-16c17.7 0 32 14.3 32 32z"]],
    "forward-step": [320, 512, ["step-forward"], "f051", ["M288 448c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32s-32 14.3-32 32V416c0 17.7 14.3 32 32 32z", "M18.4 445c11.2 5.3 24.5 3.6 34.1-4.4l192-160L256 271V241l-11.5-9.6-192-160c-9.5-7.9-22.8-9.7-34.1-4.4S0 83.6 0 96V416c0 12.4 7.2 23.7 18.4 29z"]],
    "face-smile-beam": [512, 512, [128522, "smile-beam"], "f5b8", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.1 325.5C182 346.2 212.6 368 256 368s74-21.8 91.9-42.5c5.8-6.7 15.9-7.4 22.6-1.6s7.4 15.9 1.6 22.6C349.8 372.1 311.1 400 256 400s-93.8-27.9-116.1-53.5c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6zm53.5-96.7l0 0 0 0-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2 0 0 0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l0 0 0 0zm160 0l0 0-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2 0 0 0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l0 0 0 0 0 0z", "M217.6 228.8l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 188.4 120 206.1 120 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0zm160 0l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 188.4 280 206.1 280 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0z"]],
    "light-ceiling": [512, 512, [], "e016", ["M256 0c17.7 0 32 14.3 32 32V192H256 224V32c0-17.7 14.3-32 32-32zm64 448c0 35.3-28.7 64-64 64s-64-28.7-64-64H320z", "M256 192C125.4 192 17.7 289.8 2 416.1C-.2 433.6 14.3 448 32 448H480c17.7 0 32.2-14.4 30-31.9C494.3 289.8 386.6 192 256 192z"]],
    "message-exclamation": [512, 512, ["comment-alt-exclamation"], "f4a5", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zM256 80c-13.3 0-24 10.7-24 24V216c0 13.3 10.7 24 24 24s24-10.7 24-24V104c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M280 104c0-13.3-10.7-24-24-24s-24 10.7-24 24V216c0 13.3 10.7 24 24 24s24-10.7 24-24V104zM256 336a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "bowl-scoop": [448, 512, [127847, "bowl-shaved-ice"], "e3de", ["M413.3 256c1.7-10.4 2.7-21.1 2.7-32c0-106-86-192-192-192S32 118 32 224c0 10.9 .9 21.6 2.7 32H413.3z", "M4 261.4c3-3.4 7.4-5.4 12-5.4H432c4.6 0 9 2 12 5.4s4.5 8 3.9 12.6l-2 15.9C436.9 361.9 375.6 416 303 416H262.6l68.7 68.7c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9H128c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4L185.4 416H145C72.4 416 11.1 361.9 2.1 289.9L.1 274c-.6-4.6 .8-9.1 3.9-12.6z"]],
    "square-x": [448, 512, [], "e286", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm90.3 104.5L224 218.8l69.7-82.3c8.6-10.1 23.7-11.4 33.8-2.8s11.4 23.7 2.8 33.8L255.4 256l74.9 88.5c8.6 10.1 7.3 25.3-2.8 33.8s-25.3 7.3-33.8-2.8L224 293.2l-69.7 82.3c-8.6 10.1-23.7 11.4-33.8 2.8s-11.4-23.7-2.8-33.8L192.6 256l-74.9-88.5c-8.6-10.1-7.3-25.3 2.8-33.8s25.3-7.3 33.8 2.8z", "M120.5 133.7c10.1-8.6 25.3-7.3 33.8 2.8L224 218.8l69.7-82.3c8.6-10.1 23.7-11.4 33.8-2.8s11.4 23.7 2.8 33.8L255.4 256l74.9 88.5c8.6 10.1 7.3 25.3-2.8 33.8s-25.3 7.3-33.8-2.8L224 293.2l-69.7 82.3c-8.6 10.1-23.7 11.4-33.8 2.8s-11.4-23.7-2.8-33.8L192.6 256l-74.9-88.5c-8.6-10.1-7.3-25.3 2.8-33.8z"]],
    "utility-pole-double": [512, 512, [], "e2c4", ["M128 64H80V56c0-13.3 10.7-24 24-24s24 10.7 24 24v8zM48 64H0V56C0 42.7 10.7 32 24 32s24 10.7 24 24v8zm35.2 64h57.7L224 183.4v38.5L83.2 128zM288 183.4L371.2 128h57.7L288 221.9V183.4zM384 64V56c0-13.3 10.7-24 24-24s24 10.7 24 24v8H384zm80 0V56c0-13.3 10.7-24 24-24s24 10.7 24 24v8H464zM288 375.4L371.2 320h57.7L288 413.9V375.4zM140.8 320L224 375.4v38.5L83.2 320h57.7zM128 256H80v-8c0-13.3 10.7-24 24-24s24 10.7 24 24v8zm-80 0H0v-8c0-13.3 10.7-24 24-24s24 10.7 24 24v8zm464 0H464v-8c0-13.3 10.7-24 24-24s24 10.7 24 24v8zm-80 0H384v-8c0-13.3 10.7-24 24-24s24 10.7 24 24v8z", "M256 0c17.7 0 32 14.3 32 32V64H512V96c0 17.7-14.3 32-32 32H288V256H512v32c0 17.7-14.3 32-32 32H288V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V320H32c-17.7 0-32-14.3-32-32V256H224V128H32C14.3 128 0 113.7 0 96V64H224V32c0-17.7 14.3-32 32-32z"]],
    "flag-checkered": [448, 512, [127937], "f11e", ["M64 246.2l69-17.2c19.4-4.9 39.4-6.1 59-3.8V331.8c20.3 2.4 40.2 8.3 58.7 17.5c21.8 10.9 45.4 17.1 69.3 18.5V258.7c25.2 0 50.4-5.8 73.6-17.4L448 214.2v-96l-54.4 27.2c-23.2 11.6-48.4 17.4-73.6 17.4V60.6c-25.2 0-50.4-5.8-73.6-17.4c-17.2-8.6-35.6-14-54.4-16.3V129.1c18.8 2.2 37.2 7.7 54.4 16.3c23.2 11.6 48.4 17.4 73.6 17.4v96c-25.2 0-50.4-5.8-73.6-17.4c-17.2-8.6-35.6-14-54.4-16.3v-96c-19.6-2.3-39.6-1.1-59 3.8L64 150.2v96z", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32V480c0 17.7 14.3 32 32 32s32-14.3 32-32V352l64.3-16.1c21-5.2 42.6-6.6 63.7-4.1V225.1c-19.6-2.3-39.6-1.1-59 3.8L64 246.2v-96l69-17.2c19.4-4.9 39.4-6.1 59-3.8v96c18.8 2.2 37.2 7.7 54.4 16.3c23.2 11.6 48.4 17.4 73.6 17.4V367.8c24.4 1.4 49.1-2.2 72.5-11l34.7-13c12.5-4.7 20.8-16.6 20.8-30V214.2l-54.4 27.2c-23.2 11.6-48.4 17.4-73.6 17.4v-96c25.2 0 50.4-5.8 73.6-17.4L448 118.2v-52c0-23-24.2-38-44.8-27.7l-9.6 4.8C370.4 54.8 345.2 60.6 320 60.6V162.7c-25.2 0-50.4-5.8-73.6-17.4c-17.2-8.6-35.6-14-54.4-16.3V27c-19.6-2.3-39.6-1.1-59 3.8L64 48V32z"]],
    "chevrons-up": [512, 512, ["chevron-double-up"], "f325", ["M233.4 233.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 301.3 86.6 470.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z", "M233.4 41.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 109.3 86.6 278.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z"]],
    "football": [512, 512, [127944, "football-ball"], "f44e", ["M16.8 306.7c2.1-19.2 5.4-38.6 10.1-57.8L264.5 486.6c-18.3 4.4-37.7 7.6-58.4 9.5L16.8 306.7zM485.1 263L247.5 25.4c18.3-4.4 37.7-7.6 58.4-9.5L495.2 205.3c-2.1 19.2-5.4 38.6-10.1 57.8z", "M247.5 25.4c-13.5 3.3-26.4 7.2-38.6 11.7C142.9 61.6 96.7 103.6 66 153.6c-18.3 29.8-30.9 62.3-39.2 95.4L264.5 486.6c13.5-3.3 26.4-7.2 38.6-11.7c66-24.5 112.2-66.5 142.9-116.5c18.3-29.8 30.9-62.3 39.1-95.3L247.5 25.4zM495.2 205.3c6.1-56.8 1.4-112.2-7.7-156.4c-2.7-12.9-13-22.9-26.1-25.1c-58.2-9.7-109.9-12-155.6-7.9L495.2 205.3zM206.1 496L16.8 306.7c-6.1 56.8-1.4 112.2 7.7 156.4c2.7 12.9 13 22.9 26.1 25.1c58.2 9.7 109.9 12 155.6 7.9zm54.6-331.3c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6zm-48 48c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6zm-48 48c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6z"]],
    "user-vneck": [448, 512, [], "e461", ["M352 128A128 128 0 1 1 96 128a128 128 0 1 1 256 0z", "M130 308.3c6.1-1.4 12.4 1.4 15.9 6.6L210.7 412c6.3 9.5 20.3 9.5 26.6 0l64.8-97.1c3.5-5.2 9.8-8 15.9-6.6c74.5 17.2 130 84 130 163.7v8c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32v-8c0-79.7 55.5-146.5 130-163.7z"]],
    "school-circle-exclamation": [640, 512, [], "e56c", ["M302.2 5.4c10.7-7.2 24.8-7.2 35.5 0L473.7 96H592c26.5 0 48 21.5 48 48V266.8C608.1 221.6 555.5 192 496 192c-38.5 0-74.2 12.4-103.1 33.4c9.6-14.1 15.1-31.1 15.1-49.4c0-48.6-39.4-88-88-88s-88 39.4-88 88s39.4 88 88 88c15.6 0 30.2-4 42.9-11.1c-23.4 27.1-38.8 61.4-42.2 99.1h-.5l-.3 0c-35.3 0-64 28.7-64 64v96h64v0H48c-26.5 0-48-21.5-48-48V144c0-26.5 21.5-48 48-48H166.3L302.2 5.4zM80 208v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V208c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16zm0 128v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V336c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16zM336 144v16h16c8.8 0 16 7.2 16 16s-7.2 16-16 16H320c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16s16 7.2 16 16z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16V288z"]],
    "crop": [512, 512, [], "f125", ["M457.4 9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-56.8 56.8c-5.9-22-23.2-39.4-45.3-45.3L457.4 9.4zM384 128v45.3L173.3 384H384v64H128c-35.3 0-64-28.7-64-64V32C64 14.3 78.3 0 96 0s32 14.3 32 32V338.7L338.7 128H384zm64 320V384h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H448z", "M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32H64V64H32zM384 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-352c0-35.3-28.7-64-64-64H128v64l256 0 0 352z"]],
    "angles-down": [448, 512, ["angle-double-down"], "f103", ["M201.4 278.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 210.7 86.6 73.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z", "M201.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 402.7 86.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"]],
    "users-rectangle": [640, 512, [], "e594", ["M175.8 224a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-26.5 32C119.9 256 96 279.9 96 309.3c0 14.7 11.9 26.7 26.7 26.7h56.1c8-34.1 32.8-61.7 65.2-73.6c-7.5-4.1-16.2-6.4-25.3-6.4H149.3zm368 80c14.7 0 26.7-11.9 26.7-26.7c0-29.5-23.9-53.3-53.3-53.3H421.3c-9.2 0-17.8 2.3-25.3 6.4c32.4 11.9 57.2 39.5 65.2 73.6h56.1zm-89.4 0c-8.6-24.3-29.9-42.6-55.9-47c-3.9-.7-7.9-1-12-1H280c-4.1 0-8.1 .3-12 1c-26 4.4-47.3 22.7-55.9 47c-2.7 7.5-4.1 15.6-4.1 24c0 13.3 10.7 24 24 24H408c13.3 0 24-10.7 24-24c0-8.4-1.4-16.5-4.1-24zM464 224a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-80-32a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z", "M0 96C0 43 43 0 96 0H544c53 0 96 43 96 96V416c0 53-43 96-96 96H96c-53 0-96-43-96-96V96zM96 64C78.3 64 64 78.3 64 96V416c0 17.7 14.3 32 32 32H544c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32H96z"]],
    "people-roof": [640, 512, [], "e537", ["M360 200a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM184 296a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm312 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM200 441.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-36.3-67.5c1.7-1.7 3.2-3.6 4.3-5.8L264 345.5V400c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V345.5l26.9 49.9c1.2 2.2 2.6 4.1 4.3 5.8l-36.3 67.5c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L440 441.5V480c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V441.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3H486.2c-16.3 0-31.9 4.5-45.4 12.6l-33.6-62.3c-15.3-28.5-45.1-46.3-77.5-46.3H310.2c-32.4 0-62.1 17.8-77.5 46.3l-33.6 62.3c-13.5-8.1-29.1-12.6-45.4-12.6H134.2c-32.4 0-62.1 17.8-77.5 46.3L18.9 468.6c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L88 441.5V480c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V441.5z", "M304.5 4c9.7-5.4 21.4-5.4 31.1 0l288 160c15.4 8.6 21 28.1 12.4 43.5s-28.1 21-43.5 12.4L320 68.6 47.5 220c-15.4 8.6-34.9 3-43.5-12.4s-3-34.9 12.4-43.5L304.5 4z"]],
    "square-arrow-right": [448, 512, ["arrow-square-right"], "f33b", ["M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM361 273L249 385c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l71-71L104 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l182.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L361 239c9.4 9.4 9.4 24.6 0 33.9z", "M361 239c9.4 9.4 9.4 24.6 0 33.9L249 385c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l71-71L104 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l182.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L361 239z"]],
    "location-plus": [384, 512, ["map-marker-plus"], "f60a", ["M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM168 280V216H104c-13.3 0-24-10.7-24-24s10.7-24 24-24h64V104c0-13.3 10.7-24 24-24s24 10.7 24 24v64h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H216v64c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M168 216v64c0 13.3 10.7 24 24 24s24-10.7 24-24V216h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H216V104c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H104c-13.3 0-24 10.7-24 24s10.7 24 24 24h64z"]],
    "lightbulb-exclamation-on": [640, 512, [], "e1ca", ["M449.2 297.8c-19.8 27.1-39.7 54.4-49.2 86.2H240c-9.6-31.9-29.5-59.1-49.2-86.2c-5.2-7.1-10.4-14.2-15.4-21.4C155.6 247.9 144 213.3 144 176C144 78.8 222.8 0 320 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4zM320 64c-13.3 0-24 10.7-24 24V200c0 13.3 10.7 24 24 24s24-10.7 24-24V88c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M69.3 4l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3S58.3-3.3 69.3 4zM597.3 44l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zM24 160H88c13.3 0 24 10.7 24 24s-10.7 24-24 24H24c-13.3 0-24-10.7-24-24s10.7-24 24-24zm528 0h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H552c-13.3 0-24-10.7-24-24s10.7-24 24-24zM117.3 332l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zm432-39.9l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3s22.3-14 33.3-6.7zM400 432c0 44.2-35.8 80-80 80s-80-35.8-80-80V384H400v48z"]],
    "people-line": [640, 512, [], "e534", ["M360 72a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM184 168a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm312 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM200 313.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-36.3-67.5c1.7-1.7 3.2-3.6 4.3-5.8L264 217.5V272c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V217.5l26.9 49.9c1.2 2.2 2.6 4.1 4.3 5.8l-36.3 67.5c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L440 313.5V352c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V313.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3H486.2c-16.3 0-31.9 4.5-45.4 12.6l-33.6-62.3c-15.3-28.5-45.1-46.3-77.5-46.3H310.2c-32.4 0-62.1 17.8-77.5 46.3l-33.6 62.3c-13.5-8.1-29.1-12.6-45.4-12.6H134.2c-32.4 0-62.1 17.8-77.5 46.3L18.9 340.6c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L88 313.5V352c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V313.5z", "M0 448c0-17.7 14.3-32 32-32H608c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z"]],
    "beer-mug-empty": [512, 512, ["beer"], "f0fc", ["M32 64c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32V96h51.2c42.4 0 76.8 34.4 76.8 76.8V274.9c0 30.4-17.9 57.9-45.6 70.2L384 381.7V416c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V64zM384 311.6l56.4-25.1c4.6-2.1 7.6-6.6 7.6-11.7V172.8c0-7.1-5.7-12.8-12.8-12.8H384V311.6zM160 144c0-8.8-7.2-16-16-16s-16 7.2-16 16V368c0 8.8 7.2 16 16 16s16-7.2 16-16V144zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16V368c0 8.8 7.2 16 16 16s16-7.2 16-16V144zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16V368c0 8.8 7.2 16 16 16s16-7.2 16-16V144z", "M144 128c8.8 0 16 7.2 16 16V368c0 8.8-7.2 16-16 16s-16-7.2-16-16V144c0-8.8 7.2-16 16-16zm64 0c8.8 0 16 7.2 16 16V368c0 8.8-7.2 16-16 16s-16-7.2-16-16V144c0-8.8 7.2-16 16-16zm64 0c8.8 0 16 7.2 16 16V368c0 8.8-7.2 16-16 16s-16-7.2-16-16V144c0-8.8 7.2-16 16-16z"]],
    "crate-empty": [512, 512, [], "e151", ["M48 224c-26.5 0-48 21.5-48 48v80H512V272c0-26.5-21.5-48-48-48H48zM512 384H0v80c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V384zM64 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM48 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM448 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM432 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z", "M64 304a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM464 288a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM448 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "diagram-predecessor": [512, 512, [], "e477", ["M448 480c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64L64 288c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l384 0z", "M224 224c35.3 0 64-28.7 64-64V96l80 0c8.8 0 16 7.2 16 16v16H345.9c-21.4 0-32.1 25.9-17 41L399 239c9.4 9.4 24.6 9.4 33.9 0L503 169c15.1-15.1 4.4-41-17-41H448V112c0-44.2-35.8-80-80-80H224 208 64C28.7 32 0 60.7 0 96v64c0 35.3 28.7 64 64 64l160 0z"]],
    "transporter": [512, 512, [], "e042", ["M472.7 6.6L480 32l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L480 64l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L448 64l-25.4-7.3c-3.9-1.1-6.6-4.7-6.6-8.7s2.7-7.6 6.6-8.7L448 32l7.3-25.4C456.4 2.7 459.9 0 464 0s7.6 2.7 8.7 6.6zm-416 64L64 96l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L64 128l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L32 128 6.6 120.7C2.7 119.6 0 116.1 0 112s2.7-7.6 6.6-8.7L32 96l7.3-25.4C40.4 66.7 43.9 64 48 64s7.6 2.7 8.7 6.6z", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 272v96H184V237.3L153 276c-11.1 13.8-31.2 16-45 5s-16-31.2-5-45l57.7-72c18.2-22.7 45.8-36 74.9-36h40.7c29.1 0 56.7 13.2 74.9 36L409 236c11 13.8 8.8 33.9-5 45s-33.9 8.8-45-5l-31-38.7V416H264V320H248zM216 512H128c-17.7 0-32-14.3-32-32s14.3-32 32-32H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H296 216z"]],
    "calendar-circle-user": [576, 512, [], "e471", ["M96 32c0-17.7 14.3-32 32-32s32 14.3 32 32V64H288V32c0-17.7 14.3-32 32-32s32 14.3 32 32V64h48c26.5 0 48 21.5 48 48v48H0V112C0 85.5 21.5 64 48 64H96V32zM416 192.7c-89.7 8.1-160 83.5-160 175.3c0 59.5 29.6 112.1 74.8 144H48c-26.5 0-48-21.5-48-48V192H416v.7z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-32c-30.2 0-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7h65.2c21 0 38.9 13.7 45.1 32.7C489.5 468.1 462.2 480 432 480zm0-192a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "arrow-up-long": [384, 512, ["long-arrow-up"], "f176", ["M160 109.3V480c0 17.7 14.3 32 32 32s32-14.3 32-32V109.3l-32-32-32 32z", "M169.4 9.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L192 77.3 86.6 182.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128z"]],
    "person-carry-box": [384, 512, ["person-carry"], "f4cf", ["M224 96c-17.7 0-32 14.3-32 32v96h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H352c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H224z", "M32 48a48 48 0 1 1 96 0A48 48 0 1 1 32 48zM96 241.7v65.1l51 51c7.1 7.1 11.8 16.2 13.4 26.1l15.2 90.9c2.9 17.4-8.9 33.9-26.3 36.8s-33.9-8.9-36.8-26.3L98.1 399.4 18.7 320C6.7 308 0 291.7 0 274.7V186.6C0 154.2 26.2 128 58.6 128c24.1 0 46.5 12 59.9 32l42.6 64H224c17.7 0 32 14.3 32 32s-14.3 32-32 32H152.6c-16 0-31-8-39.9-21.4L96 241.7zM0 480L0 346.5l64 64V480v0c0 17.7-14.3 32-32 32s-32-14.3-32-32z"]],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", ["M372.5 256.5l-.7-1.9C337.8 160.8 282 76.5 209.1 8.5l-3.3-3C202.1 2 197.1 0 192 0s-10.1 2-13.8 5.5l-3.3 3C102 76.5 46.2 160.8 12.2 254.6l-.7 1.9C3.9 277.3 0 299.4 0 321.6C0 426.7 86.8 512 192 512s192-85.3 192-190.4c0-22.2-3.9-44.2-11.5-65.1zm-90.8 49.5c4.1 9.3 6.2 19.4 6.2 29.5c0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l1.9-4.3c15.8-35.4 37.9-67.7 65.3-95.1l8.9-8.9c3.6-3.6 8.5-5.6 13.6-5.6s10 2 13.6 5.6l8.9 8.9c27.4 27.4 49.6 59.7 65.3 95.1l1.9 4.3z", "M279.8 301.6l1.9 4.3c4.1 9.3 6.2 19.4 6.2 29.5c0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l1.9-4.3c15.8-35.4 37.9-67.7 65.3-95.1l8.9-8.9c3.6-3.6 8.5-5.6 13.6-5.6s10 2 13.6 5.6l8.9 8.9c27.4 27.4 49.6 59.7 65.3 95.1z"]],
    "person": [320, 512, [129485, "male"], "f183", ["M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z", "M88 256.9L59.4 304.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l58.3-97c17.4-28.9 48.6-46.6 82.3-46.6h29.7c33.7 0 64.9 17.7 82.3 46.6l58.3 97c9.1 15.1 4.2 34.8-10.9 43.9s-34.8 4.2-43.9-10.9L232 256.9V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H152V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V256.9z"]],
    "laptop": [640, 512, [128187], "f109", ["M128 32C92.7 32 64 60.7 64 96V352h64V96H512V352h64V96c0-35.3-28.7-64-64-64H128zM19.2 384C8.6 384 0 392.6 0 403.2C0 445.6 34.4 480 76.8 480H563.2c42.4 0 76.8-34.4 76.8-76.8c0-10.6-8.6-19.2-19.2-19.2H19.2z", "M128 96H512V352H128V96z"]],
    "file-csv": [512, 512, [], "f6dd", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V304H176c-35.3 0-64 28.7-64 64V512H64c-35.3 0-64-28.7-64-64V64z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM200 352c-22.1 0-40 17.9-40 40v80c0 22.1 17.9 40 40 40h16c22.1 0 40-17.9 40-40v-8c0-8.8-7.2-16-16-16s-16 7.2-16 16v8c0 4.4-3.6 8-8 8H200c-4.4 0-8-3.6-8-8V392c0-4.4 3.6-8 8-8h16c4.4 0 8 3.6 8 8v8c0 8.8 7.2 16 16 16s16-7.2 16-16v-8c0-22.1-17.9-40-40-40H200zm133.1 0c-24.9 0-45.1 20.2-45.1 45.1c0 17.8 10.5 34 26.8 41.2l37.4 16.6c4.7 2.1 7.8 6.8 7.8 12c0 7.2-5.9 13.1-13.1 13.1H304c-8.8 0-16 7.2-16 16s7.2 16 16 16h42.9c24.9 0 45.1-20.2 45.1-45.1c0-17.8-10.5-34-26.8-41.2l-37.4-16.6c-4.7-2.1-7.8-6.8-7.8-12c0-7.2 5.9-13.1 13.1-13.1H368c8.8 0 16-7.2 16-16s-7.2-16-16-16H333.1zm98.9 0c-8.8 0-16 7.2-16 16v31.6c0 34.7 10.3 68.7 29.6 97.6l5.1 7.7c3 4.5 8 7.1 13.3 7.1s10.3-2.7 13.3-7.1l5.1-7.7c19.3-28.9 29.6-62.9 29.6-97.6V368c0-8.8-7.2-16-16-16s-16 7.2-16 16v31.6c0 23-5.5 45.6-16 66c-10.5-20.3-16-42.9-16-66V368c0-8.8-7.2-16-16-16z"]],
    "menorah": [640, 512, [], "f676", ["M2.7 49.7L20.8 7.4C22.8 2.9 27.1 0 32 0s9.2 2.9 11.2 7.4L61.3 49.7c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32S0 81.7 0 64V62.8c0-4.5 .9-8.9 2.7-13.1zm96 0L116.8 7.4C118.8 2.9 123.1 0 128 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1zM212.8 7.4C214.8 2.9 219.1 0 224 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1L212.8 7.4zm77.8 42.4L308.8 7.4C310.8 2.9 315.1 0 320 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1zM404.8 7.4C406.8 2.9 411.1 0 416 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1L404.8 7.4zm77.8 42.4L500.8 7.4C502.8 2.9 507.1 0 512 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1zM596.8 7.4C598.8 2.9 603.1 0 608 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1L596.8 7.4z", "M64 160c0-17.7-14.3-32-32-32s-32 14.3-32 32V288c0 53 43 96 96 96H288v64H160c-17.7 0-32 14.3-32 32s14.3 32 32 32H320 480c17.7 0 32-14.3 32-32s-14.3-32-32-32H352V384H544c53 0 96-43 96-96V160c0-17.7-14.3-32-32-32s-32 14.3-32 32V288c0 17.7-14.3 32-32 32H352V160c0-17.7-14.3-32-32-32s-32 14.3-32 32V320H96c-17.7 0-32-14.3-32-32V160zm96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32v96 32h64V256 160zm96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32v96 32h64V256 160zm192 0c0-17.7-14.3-32-32-32s-32 14.3-32 32v96 32h64V256 160zm96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32v96 32h64V256 160z"]],
    "union": [384, 512, [8899], "f6a2", ["M32 32c17.7 0 32 14.3 32 32V288c0 70.7 57.3 128 128 128s128-57.3 128-128V64c0-17.7 14.3-32 32-32s32 14.3 32 32V288c0 106-86 192-192 192S0 394 0 288V64C0 46.3 14.3 32 32 32z", ""]],
    "chevrons-left": [512, 512, ["chevron-double-left"], "f323", ["M233.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l192-192c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L301.3 256 470.6 425.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-192-192z", "M41.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l192-192c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L109.3 256 278.6 425.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-192-192z"]],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM131.9 280.9c-29.4-29.8-29.4-78.2 0-108s77-29.8 106.4 0l17.7 18 17.7-18c29.4-29.8 77-29.8 106.4 0s29.4 78.2 0 108L278.5 384.1c-6.2 6.3-14.3 9.4-22.5 9.4s-16.3-3.1-22.5-9.4L131.9 280.9z", "M131.9 172.9c-29.4 29.8-29.4 78.2 0 108L233.5 384.1c6.2 6.3 14.3 9.4 22.5 9.4s16.3-3.1 22.5-9.4L380.1 280.9c29.4-29.8 29.4-78.2 0-108s-77-29.8-106.4 0l-17.7 18-17.7-18c-29.4-29.8-77-29.8-106.4 0z"]],
    "truck-plane": [640, 512, [], "e58f", ["M144 86.1C144 54.7 169.4 0 200 0c31.5 0 56 54.7 56 86.1v96.9l0 0c0 .4 0 .7 0 1.1V325.5 408v3.5l.1 .1c1.2 22.2 13.7 41.3 31.9 51.8V496c0 5.2 .8 10.3 2.4 15L200 480.9l-90.9 30.3c-4.9 1.6-10.2 .8-14.4-2.2s-6.6-7.8-6.6-13V464c0-4.9 2.2-9.5 6-12.5l50-40V330.3l-123.4 37c-4.8 1.5-10.1 .5-14.1-2.5S0 357.1 0 352V288c0-5.6 2.9-10.8 7.8-13.7L144 192.5V86.1z", "M336 128c-26.5 0-48 21.5-48 48V400c0 20.9 13.4 38.7 32 45.3V488c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V448H544v40c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V445.3c18.6-6.6 32-24.4 32-45.3V176c0-26.5-21.5-48-48-48H336zm16 176l15.8-49.3c3.3-8.7 11.2-14.7 20.5-14.7H539.7c9.2 0 17.2 6 20.5 14.7L576 304H352zm192 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM360 352a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "record-vinyl": [512, 512, [], "f8d9", ["M256 384a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-384a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"]],
    "bring-forward": [512, 512, [], "f856", ["M448 448H224V352H160v96c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V224c0-35.3-28.7-64-64-64H352v64h96V448z", "M0 288c0 35.3 28.7 64 64 64H288c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64V288z"]],
    "square-p": [448, 512, [], "e279", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm88 96h92c50.8 0 92 41.2 92 92s-41.2 92-92 92H176v48c0 13.3-10.7 24-24 24s-24-10.7-24-24V288 152c0-13.3 10.7-24 24-24zm92 136c24.3 0 44-19.7 44-44s-19.7-44-44-44H176v88h68z", "M128 152c0-13.3 10.7-24 24-24h92c50.8 0 92 41.2 92 92s-41.2 92-92 92H176v48c0 13.3-10.7 24-24 24s-24-10.7-24-24V288 152zm48 112h68c24.3 0 44-19.7 44-44s-19.7-44-44-44H176v88z"]],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm407.4 75.5c5-11.8-7-22.5-19.3-18.7c-39.7 12.2-84.5 19-131.8 19s-92.1-6.8-131.8-19c-12.3-3.8-24.3 6.9-19.3 18.7c25 59.1 83.2 100.5 151.1 100.5s126.2-41.4 151.1-100.5zM160 120c-3.1 0-5.9 1.8-7.2 4.6l-16.6 34.7-38.1 5c-3.1 .4-5.6 2.5-6.6 5.5s-.1 6.2 2.1 8.3l27.9 26.5-7 37.8c-.6 3 .7 6.1 3.2 7.9s5.8 2 8.5 .6L160 232.5l33.8 18.3c2.7 1.5 6 1.3 8.5-.6s3.7-4.9 3.2-7.9l-7-37.8L226.4 178c2.2-2.1 3.1-5.3 2.1-8.3s-3.5-5.1-6.6-5.5l-38.1-5-16.6-34.7c-1.3-2.8-4.1-4.6-7.2-4.6zm192 0c-3.1 0-5.9 1.8-7.2 4.6l-16.6 34.7-38.1 5c-3.1 .4-5.6 2.5-6.6 5.5s-.1 6.2 2.1 8.3l27.9 26.5-7 37.8c-.6 3 .7 6.1 3.2 7.9s5.8 2 8.5 .6L352 232.5l33.8 18.3c2.7 1.5 6 1.3 8.5-.6s3.7-4.9 3.2-7.9l-7-37.8L418.4 178c2.2-2.1 3.1-5.3 2.1-8.3s-3.5-5.1-6.6-5.5l-38.1-5-16.6-34.7c-1.3-2.8-4.1-4.6-7.2-4.6z", "M167.2 124.6c-1.3-2.8-4.1-4.6-7.2-4.6s-5.9 1.8-7.2 4.6l-16.6 34.7-38.1 5c-3.1 .4-5.6 2.5-6.6 5.5s-.1 6.2 2.1 8.3l27.9 26.5-7 37.8c-.6 3 .7 6.1 3.2 7.9s5.8 2 8.5 .6L160 232.5l33.8 18.3c2.7 1.5 6 1.3 8.5-.6s3.7-4.9 3.2-7.9l-7-37.8L226.4 178c2.2-2.1 3.1-5.3 2.1-8.3s-3.5-5.1-6.6-5.5l-38.1-5-16.6-34.7zm192 0c-1.3-2.8-4.1-4.6-7.2-4.6s-5.9 1.8-7.2 4.6l-16.6 34.7-38.1 5c-3.1 .4-5.6 2.5-6.6 5.5s-.1 6.2 2.1 8.3l27.9 26.5-7 37.8c-.6 3 .7 6.1 3.2 7.9s5.8 2 8.5 .6L352 232.5l33.8 18.3c2.7 1.5 6 1.3 8.5-.6s3.7-4.9 3.2-7.9l-7-37.8L418.4 178c2.2-2.1 3.1-5.3 2.1-8.3s-3.5-5.1-6.6-5.5l-38.1-5-16.6-34.7z"]],
    "sigma": [384, 512, [8721], "f68b", ["M2.4 51.8C7.4 39.8 19.1 32 32 32H320c35.3 0 64 28.7 64 64v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V96H109.3L246.6 233.4c12.5 12.5 12.5 32.8 0 45.3L109.3 416H320V384c0-17.7 14.3-32 32-32s32 14.3 32 32v32c0 35.3-28.7 64-64 64H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L178.7 256 9.4 86.6C.2 77.5-2.5 63.7 2.4 51.8z", ""]],
    "camera-movie": [576, 512, [127909, 127910], "f8a9", ["M32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32H64V448c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V320c0-35.3-28.7-64-64-64H128 64 32z", "M128 64a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM352 256H128C57.3 256 0 198.7 0 128S57.3 0 128 0c48.2 0 90.2 26.6 112 66C261.8 26.6 303.8 0 352 0c70.7 0 128 57.3 128 128s-57.3 128-128 128zm0-192a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM558.3 259.4c10.8 5.4 17.7 16.5 17.7 28.6V480c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48L448 448V432 336 320l12.8-9.6 64-48c9.7-7.3 22.7-8.4 33.5-3z"]],
    "bong": [448, 512, [], "f55c", ["M160 208.5c0 29.1-15.6 53.9-37.2 67.8C87.3 299.2 64 338.9 64 384c0 23.4 6.2 45.2 17.1 64H302.9c10.9-18.8 17.1-40.6 17.1-64c0-45.1-23.3-84.8-58.8-107.7c-21.6-13.9-37.2-38.7-37.2-67.8V64H160V208.5zM288 64V208.5c0 5.7 3.1 10.9 7.9 14c11.2 7.2 21.5 15.5 30.9 24.8L366.1 208l-7-7c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l24 24 24 24c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-7-7-43.3 43.3C374 314.1 384 347.9 384 384c0 39.4-11.9 76.1-32.2 106.5c-9.6 14.4-26.5 21.5-43.8 21.5H76.1c-17.3 0-34.2-7.1-43.8-21.5C11.9 460.1 0 423.4 0 384c0-67.8 35.1-127.3 88.1-161.5c4.8-3.1 7.9-8.3 7.9-14V64C78.3 64 64 49.7 64 32S78.3 0 96 0h16H272h16c17.7 0 32 14.3 32 32s-14.3 32-32 32z", "M302.9 320H81.1C70.2 338.8 64 360.7 64 384c0 23.4 6.2 45.2 17.1 64H302.9c10.9-18.8 17.1-40.6 17.1-64c0-23.3-6.2-45.2-17.1-64z"]],
    "clarinet": [640, 512, [], "f8ad", ["M631.5 161.9c5.2 2.8 8.5 8.2 8.5 14.1V368c0 5.9-3.2 11.3-8.5 14.1s-11.5 2.5-16.4-.8l-31.9-21.3c-7.9-5.3-17.1-8.1-26.6-8.1H108.3c-10.2 0-20.3-1.9-29.7-5.7L10.1 318.9C4 316.4 0 310.5 0 304V240c0-6.5 4-12.4 10.1-14.9l68.6-27.4c9.4-3.8 19.5-5.7 29.7-5.7H556.6c9.5 0 18.7-2.8 26.6-8.1l31.9-21.3c4.9-3.3 11.2-3.6 16.4-.8zM272 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z", "M240 128c-8.8 0-16 7.2-16 16s7.2 16 16 16h16v32h32V160h64v32h32V160h64v32h32V160h16c8.8 0 16-7.2 16-16s-7.2-16-16-16H464 368 272 240zm32 168a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "truck-flatbed": [640, 512, [], "e2b6", ["M176 512a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm288 0a80 80 0 1 0 0-160 80 80 0 1 0 0 160z", "M640 384c0 17.7-14.3 32-32 32H574.9c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96H352 286.9c-3.6-24.9-15.3-47.2-32.5-64H352V128c0-17.7 14.3-32 32-32h16 16 50.7c17 0 33.3 6.7 45.3 18.7L589.3 192c12 12 18.7 28.3 18.7 45.3V256v32 64c17.7 0 32 14.3 32 32zM97.6 352c-17.1 16.8-28.9 39.1-32.5 64H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H97.6zM544 256V237.3L466.7 160H416v96H544z"]],
    "spaghetti-monster-flying": [640, 512, ["pastafarianism"], "f67b", ["M197.1 127.8L212.2 158c-21.1 13.6-37.7 30.2-51.4 46.4c-7.1 8.3-13.5 16.6-19.3 24l-1.4 1.8c-6.3 8.1-11.6 14.8-16.7 20.4C112.7 262.3 107.3 264 104 264c-2.5 0-4.3-.6-7.1-3.3c-3.7-3.5-7.1-8.8-12.5-17.4l-.6-.9c-4.6-7.4-11-17.6-19.4-25.7C54.7 207.4 41.5 200 24 200c-13.3 0-24 10.7-24 24s10.7 24 24 24c2.5 0 4.3 .6 7.1 3.3c3.7 3.5 7.1 8.8 12.5 17.4l.6 .9 0 0c4.6 7.4 11 17.6 19.4 25.7C73.3 304.6 86.5 312 104 312c18.5 0 32.9-8.5 44.3-18.6c3.1 4 6.6 8.3 10.5 12.7c-1.4 4.3-2.8 8.5-4 12.5c-.9 3-1.8 5.8-2.6 8.6c-3 9.8-5.5 18.2-8.6 25.9c-3.9 9.8-7.4 15.4-10.8 18.5c-2.6 2.4-5.9 4.3-12.8 4.3c-8.7 0-16.9-4.2-33.7-13.2c-15-8-35.7-18.8-62.3-18.8c-13.3 0-24 10.7-24 24s10.7 24 24 24c13.4 0 24.7 5.2 39.7 13.2c1 .6 2.1 1.1 3.2 1.7l0 0C80.1 414 98.6 424 120 424c18.4 0 33.6-6.1 45.5-17.2c11.1-10.3 17.9-23.7 22.7-36c3.6-9 6.7-19.1 9.5-28.5c16.4 12.3 36.1 23.6 58.9 31.3c-3.6 10.8-8.4 23.5-14.4 36.2c-7.5 15.9-16.2 30.4-25.8 40.5C207 460.5 198.8 464 192 464c-13.3 0-24 10.7-24 24s10.7 24 24 24c25.2 0 45-13.5 59.5-28.8c14.5-15.4 25.7-34.9 34.2-53c8-17 14.1-33.8 18.3-46.9c5.2 .4 10.6 .6 16 .6s10.8-.2 16-.6c4.2 13 10.3 29.9 18.3 46.9c8.5 18.1 19.8 37.6 34.2 53C403 498.5 422.8 512 448 512c13.3 0 24-10.7 24-24s-10.7-24-24-24c-6.8 0-15-3.5-24.5-13.7c-9.5-10.1-18.3-24.6-25.8-40.5c-5.9-12.6-10.7-25.4-14.4-36.2c22.8-7.7 42.5-19 58.9-31.3c2.9 9.4 6 19.5 9.5 28.5c4.8 12.2 11.6 25.6 22.7 36C486.4 417.9 501.6 424 520 424c21.4 0 39.9-10 53.1-17.1c1.1-.6 2.2-1.2 3.2-1.7c15-8 26.3-13.2 39.7-13.2c13.3 0 24-10.7 24-24s-10.7-24-24-24c-26.6 0-47.3 10.8-62.3 18.8c-16.8 9-25 13.2-33.7 13.2c-6.8 0-10.2-1.9-12.8-4.3c-3.4-3.2-7-8.8-10.8-18.5c-3-7.7-5.6-16.1-8.6-25.9c-.8-2.7-1.7-5.6-2.6-8.6c-1.2-4-2.6-8.2-4-12.5c3.9-4.5 7.4-8.8 10.5-12.7C503.1 303.5 517.5 312 536 312c17.5 0 30.7-7.4 40.4-16.7c8.4-8.1 14.8-18.3 19.4-25.7l.6-.9c5.4-8.6 8.8-13.9 12.5-17.4c2.8-2.7 4.6-3.3 7.1-3.3c13.3 0 24-10.7 24-24s-10.7-24-24-24c-17.5 0-30.7 7.4-40.4 16.7c-8.4 8.1-14.8 18.3-19.4 25.7l-.6 .9c-5.4 8.6-8.8 13.9-12.5 17.4c-2.8 2.7-4.6 3.3-7.1 3.3c-3.3 0-8.7-1.7-19.4-13.4c-5.1-5.6-10.4-12.3-16.7-20.4l-1.4-1.8c-5.8-7.4-12.2-15.7-19.3-24c-13.8-16.2-30.4-32.8-51.4-46.4l15.1-30.2c-17.1-1.3-32.2-9.4-42.9-21.5l-15.6 31.2c-18.7-6-39.9-9.5-64.4-9.5s-45.8 3.5-64.4 9.5L240 106.3c-10.7 12.1-25.9 20.1-42.9 21.5z", "M208 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 0a64 64 0 1 1 128 0A64 64 0 1 1 128 64zm336 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 0a64 64 0 1 1 128 0A64 64 0 1 1 384 64z"]],
    "arrow-down-up-across-line": [576, 512, [], "e4af", ["M0 256c0-17.7 14.3-32 32-32H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z", "M137.4 502.6c12.5 12.5 32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 402.7V288H128V402.7L86.6 361.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96zM128 224h64V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V224zM393.4 9.4l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L384 109.3V224h64V109.3l41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0zM448 448V288H384V448c0 17.7 14.3 32 32 32s32-14.3 32-32z"]],
    "leaf-heart": [512, 512, [], "f4cb", ["M272 96l0 0H376c42.7 0 79.9-23.9 98.8-59.1c3.5-6.5 13.6-6.8 16.2 .1c13.5 36.5 21.1 77 21.1 119.6C512 317.1 405.1 447.3 273 448l-1 0c-81.7 0-150.4-55.7-170.2-131.2C68.7 347.5 48 391.4 48 440v16c0 13.3-10.7 24-24 24s-24-10.7-24-24V440c0-75.1 38.3-141.2 96.4-179.9C102.5 168.5 178.8 96 272 96l0 0zM189.7 242.8c0 14.4 5.8 28.3 16.2 38.4l70.9 69c6.2 6 16.1 6 22.3 0l70.9-69c10.4-10.1 16.2-23.9 16.2-38.4c0-29.5-23.9-53.5-53.5-53.5h-1.5c-14.3 0-28.1 5.6-38.4 15.6l-4.9 4.8-4.9-4.8c-10.3-10-24-15.6-38.4-15.6h-1.5c-29.5 0-53.5 23.9-53.5 53.5z", "M243.2 189.3c-29.5 0-53.5 23.9-53.5 53.5c0 14.4 5.8 28.3 16.2 38.4l70.9 69c6.2 6 16.1 6 22.3 0l70.9-69c10.4-10.1 16.2-23.9 16.2-38.4c0-29.5-23.9-53.5-53.5-53.5h-1.5c-14.3 0-28.1 5.6-38.3 15.6l-4.9 4.8-4.9-4.8c-10.3-10-24-15.6-38.4-15.6h-1.5z"]],
    "house-building": [640, 512, [], "e1b1", ["M320 48c0-26.5 21.5-48 48-48H592c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48H400c10-13.4 16-30 16-48V352h16c8.8 0 16-7.2 16-16V304c0-8.8-7.2-16-16-16H416V277.1c0-7.2-1-14.3-2.8-21.1H432c8.8 0 16-7.2 16-16V208c0-8.8-7.2-16-16-16H400c-8.8 0-16 7.2-16 16v4.6l-64-58.7V48zM528 192c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V208c0-8.8-7.2-16-16-16H528zM512 304v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V304c0-8.8-7.2-16-16-16H528c-8.8 0-16 7.2-16 16zM384 112v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H400c-8.8 0-16 7.2-16 16zM528 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H528z", "M0 464V277.1c0-13.5 5.6-26.3 15.6-35.4l144-132c18.4-16.8 46.5-16.8 64.9 0l144 132c9.9 9.1 15.6 21.9 15.6 35.4V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48zM168 272c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V296c0-13.3-10.7-24-24-24H168z"]],
    "cheese-swiss": [512, 512, [129472], "f7f0", ["M512 256V240.2C512 125.2 418.8 32 303.8 32c-10.3 0-20.3 3-28.9 8.7l-47 31.3c-7.8 5.2-9.2 16.1-6.3 25.1c1.5 4.7 2.3 9.7 2.3 14.9c0 26.5-21.5 48-48 48c-12 0-22.9-4.4-31.3-11.6c-7.1-6.1-17.7-9.1-25.5-3.8L28.5 205C11.3 216.5 .8 235.5 0 256H332.2c-7.6 8.5-12.2 19.7-12.2 32c0 26.5 21.5 48 48 48s48-21.5 48-48c0-12.3-4.6-23.5-12.2-32H512zM224 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z", "M368 336c26.5 0 48-21.5 48-48c0-12.3-4.6-23.5-12.2-32H512V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256H332.2c-7.6 8.5-12.2 19.7-12.2 32c0 26.5 21.5 48 48 48zM224 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]],
    "spoon": [512, 512, [129348, 61873, "utensil-spoon"], "f2e5", ["M224 160.2c0 24.5 9.4 49 28.1 67.7l32 32c18.7 18.7 43.2 28.1 67.7 28.1C432 288 512 192 512 96c0-53-43-96-96-96C320 0 224 80 224 160.2z", "M245.8 220.9c2 2.4 4.1 4.7 6.3 6.9l32 32c2.2 2.2 4.6 4.3 6.9 6.3L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L245.8 220.9z"]],
    "jar-wheat": [320, 512, [], "e517", ["M64 64C28.7 64 0 92.7 0 128V448c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zM176 224H122.2C90 224 64 198 64 165.8c0-3.2 2.6-5.8 5.8-5.8H112c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7h42.2c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 224zm74.2 32c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2H176 144 122.2C90 320 64 294 64 261.8c0-3.2 2.6-5.8 5.8-5.8l42.2 0c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7h42.2zm0 96c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 416v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V416l-21.8 0C90 416 64 390 64 357.8c0-3.2 2.6-5.8 5.8-5.8H112c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7h42.2z", "M64 0H256c17.7 0 32 14.3 32 32s-14.3 32-32 32H64C46.3 64 32 49.7 32 32S46.3 0 64 0zM256 165.8c0 32.1-26 58.2-58.2 58.2L176 224l-32 0-21.8 0C90 224 64 198 64 165.8c0-3.2 2.6-5.8 5.8-5.8H112c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7h42.2c3.2 0 5.8 2.6 5.8 5.8zM250.2 256c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 320l-32 0-21.8 0C90 320 64 294 64 261.8c0-3.2 2.6-5.8 5.8-5.8H112c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7h42.2zm0 96c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 416v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V416l-21.8 0C90 416 64 390 64 357.8c0-3.2 2.6-5.8 5.8-5.8H112c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7h42.2z"]],
    "envelopes-bulk": [640, 512, ["mail-bulk"], "f674", ["M96 32V224h96V192c0-35.3 28.7-64 64-64H480V32c0-17.7-14.3-32-32-32H128C110.3 0 96 14.3 96 32zM256 160c-17.7 0-32 14.3-32 32v32h96c35.3 0 64 28.7 64 64V416H576c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32H256zm240 64h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H496c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16zM32 301v39.8L168 441.6c6.9 5.1 15.3 7.9 24 7.9s17-2.8 24-7.9L352 340.8V301L196.9 415.9c-1.4 1-3.1 1.6-4.9 1.6s-3.5-.6-4.9-1.6L32 301z", "M496 224h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H496c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16zM32 288c0-17.7 14.3-32 32-32H320c17.7 0 32 14.3 32 32v13L196.9 415.9c-1.4 1-3.1 1.6-4.9 1.6s-3.5-.6-4.9-1.6L32 301V288zM216 441.6L352 340.8V480c0 17.7-14.3 32-32 32H64c-17.7 0-32-14.3-32-32V340.8L168 441.6c6.9 5.1 15.3 7.9 24 7.9s17-2.8 24-7.9z"]],
    "file-circle-exclamation": [576, 512, [], "e4eb", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384v38.6C310.1 219.5 256 287.4 256 368c0 59.1 29.1 111.3 73.7 143.3c-3.2 .5-6.4 .7-9.7 .7H64c-35.3 0-64-28.7-64-64V64z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zm48 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16v80c0 8.8-7.2 16-16 16s-16-7.2-16-16V288c0-8.8 7.2-16 16-16z"]],
    "bow-arrow": [512, 512, [127993], "f6b9", ["M309.7 168.3c-60.7-47.3-143.3-53-209.3-17.1L360.8 411.6c35.8-66 30.1-148.6-17.1-209.3l45.5-45.5c71.7 86.4 77.8 209 18.3 301.5c11.6 12.6 11.3 32.1-.9 44.3c-12.5 12.5-32.8 12.5-45.3 0l-352-352c-12.5-12.5-12.5-32.8 0-45.3c12.2-12.2 31.8-12.5 44.3-.9C146.3 45 268.8 51.1 355.3 122.8l-45.5 45.5z", "M511.7 18.9c1-5.2-.7-10.5-4.4-14.3S498.2-.7 493.1 .3l-128 24c-5.8 1.1-10.6 5.3-12.3 11s-.2 11.8 4 16l35 35L213.7 264.4l33.9 33.9L425.7 120.3l35 35c4.2 4.2 10.4 5.7 16 4s9.9-6.5 11-12.3l24-128zM202.3 343.6l-33.9-33.9-23.8 23.8L93.8 320.7c-8.2-2-16.8 .4-22.8 6.3L7 391c-6.1 6.1-8.5 15-6.2 23.4s8.9 14.8 17.3 16.9l50 12.5 12.5 50c2.1 8.4 8.5 15 16.9 17.3s17.3 0 23.4-6.2l64-64c6-6 8.4-14.6 6.3-22.8l-12.7-50.8 23.8-23.8z"]],
    "cart-xmark": [576, 512, [], "e0dd", ["M459.2 288H170.7L124.5 45.5c-.9-4.8-2.4-9.3-4.4-13.5h411c26.3 0 45.5 25 38.6 50.4l-41 152.3c-8.5 31.4-37 53.3-69.5 53.3zM395.4 128.9c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0L336 131.7l-31.1-31.1c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3L307.7 160l-31.1 31.1c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0L336 188.3l31.1 31.1c7.8 7.8 20.5 7.8 28.3 0s7.8-20.5 0-28.3L364.3 160l31.1-31.1z", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48H69.5c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5H488c13.3 0 24-10.7 24-24s-10.7-24-24-24H199.7c-11.5 0-21.4-8.2-23.6-19.5l-51.6-271C119.5 19.1 96.4 0 69.5 0H24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM395.4 128.9c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0L336 131.7l-31.1-31.1c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3L307.7 160l-31.1 31.1c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0L336 188.3l31.1 31.1c7.8 7.8 20.5 7.8 28.3 0s7.8-20.5 0-28.3L364.3 160l31.1-31.1z"]],
    "hexagon-xmark": [512, 512, ["times-hexagon", "xmark-hexagon"], "f2ee", ["M17.1 292c-12.9-22.3-12.9-49.7 0-72L105.4 67.1c12.9-22.3 36.6-36 62.4-36H344.3c25.7 0 49.5 13.7 62.4 36L494.9 220c12.9 22.3 12.9 49.7 0 72L406.6 444.9c-12.9 22.3-36.6 36-62.4 36H167.7c-25.7 0-49.5-13.7-62.4-36L17.1 292zM175 175c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z", "M209 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]],
    "circle-h": [512, 512, [9405, "hospital-symbol"], "f47e", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM368 152V256 360c0 13.3-10.7 24-24 24s-24-10.7-24-24V280H192l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24s24 10.7 24 24v80H320V152c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M344 128c13.3 0 24 10.7 24 24l0 104V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V280H192l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80 128 0 0-80c0-13.3 10.7-24 24-24z"]],
    "merge": [512, 512, [], "e526", ["M243.8 252l3.2 4L154.2 372c-6.1 7.6-15.3 12-25 12H32c-17.7 0-32 14.3-32 32s14.3 32 32 32h97.2c29.2 0 56.7-13.3 75-36l99.2-124h15.4c-29.2 0-56.7-13.3-75-36z", "M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32h97.2c9.7 0 18.9 4.4 25 12l89.6 112c18.2 22.8 45.8 36 75 36H384v32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c6-6 9.4-14.1 9.4-22.6s-3.4-16.6-9.4-22.6l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6v32H318.8c-9.7 0-18.9-4.4-25-12L204.2 100c-18.2-22.8-45.8-36-75-36H32z"]],
    "pager": [512, 512, [128223], "f815", ["M0 128C0 92.7 28.7 64 64 64H448c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128zm64 32v64c0 17.7 14.3 32 32 32H416c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H96c-17.7 0-32 14.3-32 32zM80 320c-13.3 0-24 10.7-24 24s10.7 24 24 24h56c13.3 0 24-10.7 24-24s-10.7-24-24-24H80zm136 0c-13.3 0-24 10.7-24 24s10.7 24 24 24h48c13.3 0 24-10.7 24-24s-10.7-24-24-24H216z", "M64 160c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V160z"]],
    "cart-minus": [576, 512, [], "e0db", ["M459.2 288H170.7L124.5 45.5c-.9-4.8-2.4-9.3-4.4-13.5h411c26.3 0 45.5 25 38.6 50.4l-41 152.3c-8.5 31.4-37 53.3-69.5 53.3zM272 140c-11 0-20 9-20 20s9 20 20 20H400c11 0 20-9 20-20s-9-20-20-20H272z", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48H69.5c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5H488c13.3 0 24-10.7 24-24s-10.7-24-24-24H199.7c-11.5 0-21.4-8.2-23.6-19.5l-51.6-271C119.5 19.1 96.4 0 69.5 0H24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM272 140c-11 0-20 9-20 20s9 20 20 20H400c11 0 20-9 20-20s-9-20-20-20H272z"]],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", ["M32 64C32 28.7 60.7 0 96 0H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V64zm96 304c0 8.8 7.2 16 16 16H336c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80H208c-44.2 0-80 35.8-80 80zM240 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128z", "M496 64c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V80c0-8.8 7.2-16 16-16zm0 128c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V208c0-8.8 7.2-16 16-16zm16 144v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V336c0-8.8 7.2-16 16-16s16 7.2 16 16zM128 368c0-44.2 35.8-80 80-80h64c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16H144c-8.8 0-16-7.2-16-16zM240 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]],
    "pan-frying": [576, 512, [127859], "e42c", ["M176 224a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z", "M427.6 317.6C440.7 289.1 448 257.4 448 224C448 100.3 347.7 0 224 0S0 100.3 0 224S100.3 448 224 448c53.3 0 102.3-18.6 140.8-49.7L472.7 498.5c11 8.8 24.1 13.5 39.3 13.5c35.3 0 64-28.7 64-64c0-20.9-9.3-38.8-24.7-50.5L427.6 317.6zM254.1 115.6c15.2 15.8 44.5 32.9 65.8 38.4c13.7 3.5 26.4 11.6 35.5 23.9c21 28.4 15.1 68.5-13.3 89.5c-8.9 6.6-18.9 10.5-29.2 12c-18.6 2.6-42.2 16.3-51.6 32.6c-22.1 38.3-71 51.4-109.3 29.3s-51.4-71-29.3-109.3c12.4-21.4 19.4-53 21.5-77.6c1.3-14.9 7.8-29.4 19.4-40.5c25.5-24.5 66-23.7 90.5 1.8zM512 432a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "grid": [448, 512, ["grid-3"], "e195", ["M200 32c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V72c0-22.1-17.9-40-40-40H200zM40 192c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40H88c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40H40zM160 392v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V392c0-22.1-17.9-40-40-40H200c-22.1 0-40 17.9-40 40zM360 192c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40H360z", "M0 72C0 49.9 17.9 32 40 32H88c22.1 0 40 17.9 40 40v48c0 22.1-17.9 40-40 40H40c-22.1 0-40-17.9-40-40V72zM0 392c0-22.1 17.9-40 40-40H88c22.1 0 40 17.9 40 40v48c0 22.1-17.9 40-40 40H40c-22.1 0-40-17.9-40-40V392zM288 232v48c0 22.1-17.9 40-40 40H200c-22.1 0-40-17.9-40-40V232c0-22.1 17.9-40 40-40h48c22.1 0 40 17.9 40 40zM320 72c0-22.1 17.9-40 40-40h48c22.1 0 40 17.9 40 40v48c0 22.1-17.9 40-40 40H360c-22.1 0-40-17.9-40-40V72zM448 392v48c0 22.1-17.9 40-40 40H360c-22.1 0-40-17.9-40-40V392c0-22.1 17.9-40 40-40h48c22.1 0 40 17.9 40 40z"]],
    "football-helmet": [512, 512, [], "f44f", ["M288 352h39.7l9.6 51c10.1 54 57.2 93 112.1 93h17c25.2 0 45.6-20.4 45.6-45.6V400 368c0-26.5-21.5-48-48-48H354.3l-14-74.5-31.8 4L321.7 320H272l16 32zm78.3 32l-6-32H464c8.8 0 16 7.2 16 16v16H366.3zm8.4 32H480v34.4c0 7.5-6.1 13.6-13.6 13.6h-17c-32.7 0-61.6-19.3-74.7-48z", "M462.5 230.2c17.5-2.2 30.2-18.3 25.7-35.3C461.1 91.9 367.4 16 256 16C123.5 16 16 123.5 16 256c0 56.3 19.4 108.1 51.9 149.1c5.7 7.1 14.4 10.9 23.5 10.9h14c4.3 0 8.6 .9 12.6 2.6l93.4 40c8.3 3.5 17.2 5.4 26.1 5.4h1.7c35.7 0 64.7-29 64.7-64.7c0-10-2.3-20-6.8-28.9L259 294c-2-4-3-8.4-3-12.8c0-14.4 10.7-26.6 25.1-28.4l181.4-22.7zM176 312a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "hand-love": [512, 512, [], "e1a5", ["M160 0c17.7 0 32 14.3 32 32V191.9l0 .1v96c0 35.3 28.7 64 64 64c19.1 0 36.3-8.4 48-21.7c11.7 13.3 28.9 21.7 48 21.7c35.3 0 64-28.7 64-64V224.1c0 0 0 0 0-.1V96c0-17.7 14.3-32 32-32s32 14.3 32 32V336c0 97.2-78.8 176-176 176H284.8c-59.6 0-116.9-22.9-160-64L12.4 341c-16-15.2-16.6-40.6-1.4-56.6s40.6-16.6 56.6-1.4l60.5 57.6c0-1.5-.1-3.1-.1-4.6V32c0-17.7 14.3-32 32-32z", "M256 160c-17.7 0-32 14.3-32 32v96c0 17.7 14.3 32 32 32s32-14.3 32-32V192c0-17.7-14.3-32-32-32zm96 32c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V224c0-17.7-14.3-32-32-32z"]],
    "trees": [640, 512, [], "f724", ["M178.5 5.8L70.2 121.4c-4 4.3-6.2 9.9-6.2 15.7C64 149.7 74.3 160 86.9 160H112L37.4 249.5c-3.5 4.2-5.4 9.5-5.4 15c0 13 10.5 23.5 23.5 23.5H80L5.4 377.5C1.9 381.7 0 387 0 392.5c0 13 10.5 23.5 23.5 23.5H160V216c0-17.7 14.3-32 32-32s32 14.3 32 32V416H360.5c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L304 288h24.5c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L272 160h25.1c12.7 0 22.9-10.3 22.9-22.9c0-5.8-2.2-11.4-6.2-15.7L205.5 5.8C202 2.1 197.1 0 192 0s-10 2.1-13.5 5.8zm163.1 99.1c6.7 9.3 10.4 20.5 10.4 32.1c0 17.7-8.3 33.4-21.3 43.4L371.1 229c8.3 10 12.9 22.5 12.9 35.5c0 17.8-8.4 33.6-21.4 43.8L403.1 357c8.2 9.8 12.7 22.2 12.9 35h0V216c0-17.7 14.3-32 32-32s32 14.3 32 32V416H616.5c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L560 288h24.5c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L528 160h25.1c12.7 0 22.9-10.3 22.9-22.9c0-5.8-2.2-11.4-6.2-15.7L461.5 5.8C458 2.1 453.1 0 448 0s-10 2.1-13.5 5.8l-92.9 99.1z", "M224 216c0-17.7-14.3-32-32-32s-32 14.3-32 32V480c0 17.7 14.3 32 32 32s32-14.3 32-32V216zm256 0c0-17.7-14.3-32-32-32s-32 14.3-32 32V480c0 17.7 14.3 32 32 32s32-14.3 32-32V216z"]],
    "strikethrough": [512, 512, [], "f0cc", ["M161.3 144c3.2-17.2 14-30.1 33.7-38.6c21.1-9 51.8-12.3 88.6-6.5c11.9 1.9 48.8 9.1 60.1 12c17.1 4.5 34.6-5.6 39.2-22.7s-5.6-34.6-22.7-39.2c-14.3-3.8-53.6-11.4-66.6-13.4c-44.7-7-88.3-4.2-123.7 10.9c-36.5 15.6-64.4 44.8-71.8 87.3c-.1 .6-.2 1.1-.2 1.7c-2.8 23.9 .5 45.6 10.1 64.6c4.5 9 10.2 16.9 16.7 23.9H270.1c-.1 0-.3-.1-.4-.1l-1.1-.3c-36-10.8-65.2-19.6-85.2-33.1c-9.3-6.3-15-12.6-18.2-19.1c-3.1-6.1-5.2-14.6-3.8-27.4zM348.9 337.2c2.7 6.5 4.4 15.8 1.9 30.1c-3 17.6-13.8 30.8-33.9 39.4c-21.1 9-51.7 12.3-88.5 6.5c-18-2.9-49.1-13.5-74.4-22.1c-5.6-1.9-11-3.7-15.9-5.4c-16.8-5.6-34.9 3.5-40.5 20.3s3.5 34.9 20.3 40.5c3.6 1.2 7.9 2.7 12.7 4.3l0 0 0 0c24.9 8.5 63.6 21.7 87.6 25.6l0 0 .2 0c44.7 7 88.3 4.2 123.7-10.9c36.5-15.6 64.4-44.8 71.8-87.3c3.6-21 2.7-40.4-3.1-58.1H335.1c7 5.6 11.4 11.2 13.9 17.2z", "M0 256c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z"]],
    "page": [384, 512, [], "e428", ["M64 512H320c35.3 0 64-28.7 64-64V138.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0H64C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64z", ""]],
    "k": [320, 512, [107], "4b", ["M311 86.3c12.3-12.7 12-32.9-.7-45.2s-32.9-12-45.2 .7l-155.2 160L64 249V64c0-17.7-14.3-32-32-32S0 46.3 0 64V328 448c0 17.7 14.3 32 32 32s32-14.3 32-32V341l64.7-66.7 133 192c10.1 14.5 30 18.1 44.5 8.1s18.1-30 8.1-44.5L174.1 227.4 311 86.3z", ""]],
    "diagram-previous": [512, 512, [], "e478", ["M385 168.4c16 16 19.6 37.2 14.1 55.6h49c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96v64c0 35.3 28.7 64 64 64l49 0c-5.5-18.4-2-39.6 14.1-55.6L216.4 79c21.9-21.9 57.3-21.9 79.2 0L385 168.4z", "M448 288c35.3 0 64 28.7 64 64v64c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V352c0-35.3 28.7-64 64-64H232V224l-46.1 0c-21.4 0-32.1-25.9-17-41L239 113c9.4-9.4 24.6-9.4 33.9 0L343 183c15.1 15.1 4.4 41-17 41L280 224v64H448z"]],
    "gauge-min": [512, 512, ["tachometer-alt-slowest"], "f628", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6c-11.3-7-26.1-3.5-33 7.8s-3.5 26.1 7.8 33l117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M100.6 227.6c-11.3-7-26.1-3.5-33 7.8s-3.5 26.1 7.8 33l117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6z"]],
    "folder-grid": [512, 512, [], "e188", ["M448 480H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H192c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64zM104 240c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V264c0-13.3-10.7-24-24-24H104zm128 0c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V264c0-13.3-10.7-24-24-24H232zm104 24v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V264c0-13.3-10.7-24-24-24H360c-13.3 0-24 10.7-24 24z", "M80 264c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H104c-13.3 0-24-10.7-24-24V264zm128 0c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H232c-13.3 0-24-10.7-24-24V264zm152-24h48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H360c-13.3 0-24-10.7-24-24V264c0-13.3 10.7-24 24-24z"]],
    "eggplant": [512, 512, [], "e16c", ["M307.2 49.2C314.1 67.2 331.5 80 352 80c5.8 0 10.7 4 12.6 9.4c4.8 13.3 13 25.4 22.8 35.1s21.9 18 35.1 22.8c5.4 2 9.4 6.9 9.4 12.6c0 22.3 15.1 41 35.7 46.4C426.6 337.3 322.1 512.2 176.4 512C79.9 511.9 1.4 431.3 0 336C-1.6 222.5 83.4 181.3 169.9 139.3c51.1-24.8 102.6-49.8 137.3-90.1z", "M505 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-9 9H320c-8.8 0-16 7.2-16 16c0 26.5 21.5 48 48 48c5.8 0 10.7 4 12.6 9.4c4.8 13.3 13 25.4 22.8 35.1s21.9 18 35.1 22.8c5.4 2 9.4 6.9 9.4 12.6c0 26.5 21.5 48 48 48c8.8 0 16-7.2 16-16V49.9l9-9z"]],
    "ram": [640, 512, [128015], "f70a", ["M475.3 352H464c-61.9 0-112-50.1-112-112V207.4c-18.7-2.7-35.5-14.8-43.5-33.4c-8.9-20.8-4.3-44 10-59.7C312.3 85.6 286.7 64 256 64c-19.2 0-36.5 8.5-48.2 21.9C196.9 77.2 183 72 168 72c-30.1 0-55.3 20.8-62.2 48.8c-3.2-.5-6.5-.8-9.8-.8c-35.3 0-64 28.7-64 64c0 5.3 .7 10.5 1.9 15.5C13.7 210.3 0 231.5 0 256s13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5c0 35.3 28.7 64 64 64c3.3 0 6.6-.3 9.8-.7c6.8 28 32.1 48.7 62.2 48.7c15 0 28.9-5.2 39.8-13.9c11.7 13.4 29 21.9 48.2 21.9s36.5-8.5 48.2-21.9C315.1 434.8 329 440 344 440c30.1 0 55.3-20.8 62.2-48.7c3.2 .5 6.5 .7 9.8 .7c26.9 0 49.9-16.5 59.3-40z", "M400 0c-35.3 0-64 28.7-64 64v8c0 13.3 10.7 24 24 24s24-10.7 24-24V64c0-8.8 7.2-16 16-16s16 7.2 16 16V88.4c-6.8 6.1-12.8 13.2-17.6 21l-47.8 20.5c-12.2 5.2-17.8 19.3-12.6 31.5s19.3 17.8 31.5 12.6l14.5-6.2V240c0 44.2 35.8 80 80 80h32c44.2 0 80-35.8 80-80V167.8l14.5 6.2c12.2 5.2 26.3-.4 31.5-12.6s-.4-26.3-12.6-31.5l-47.8-20.5c-4.9-7.8-10.8-14.9-17.6-21V64c0-8.8 7.2-16 16-16s16 7.2 16 16v8c0 13.3 10.7 24 24 24s24-10.7 24-24V64c0-35.3-28.7-64-64-64s-64 28.7-64 64v1.3c-5.2-.9-10.5-1.3-16-1.3s-10.8 .5-16 1.3V64c0-35.3-28.7-64-64-64zm64 160a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM115.1 485.9c2.8 15.1 16.1 26.1 31.5 26.1H176c17.7 0 32-14.3 32-32V426.3l-.2-.2C196.9 434.8 183 440 168 440c-30.1 0-55.3-20.8-62.2-48.7c-2.7 .4-5.5 .7-8.3 .7l17.6 93.9zM304 480c0 17.7 14.3 32 32 32h29.4c15.4 0 28.6-11 31.4-26.1L414.5 392c-2.8-.1-5.6-.3-8.3-.7c-6.8 28-32.1 48.7-62.2 48.7c-15 0-28.9-5.2-39.8-13.9l-.2 .2V480z"]],
    "landmark-flag": [512, 512, [], "e51c", ["M128 192H64V420.3c-.6 .3-1.2 .7-1.7 1.1l-48 32c-11.7 7.8-17 22.4-12.9 35.9S17.9 512 32 512H480c14.1 0 26.5-9.2 30.6-22.7s-1.1-28.1-12.9-35.9l-48-32c-.6-.4-1.2-.7-1.8-1.1V192H384V416H344V192H280V416H232V192H168V416H128V192z", "M272 0h80c8.8 0 16 7.2 16 16V80c0 8.8-7.2 16-16 16H272v32H464c17.7 0 32 14.3 32 32s-14.3 32-32 32H48c-17.7 0-32-14.3-32-32s14.3-32 32-32H240V16c0-8.8 7.2-16 16-16h16z"]],
    "lips": [576, 512, [128068, 128482], "f600", ["M0 224c0 9.2 2.6 19.1 5.3 27.5c3 9.1 7.4 19.4 12.8 30.3c10.8 21.7 26.8 46.9 47.7 71.1C107.2 400.9 171.3 448 256 448h64c84.7 0 148.8-47.1 190.2-95.1c20.9-24.2 36.8-49.4 47.7-71.1c5.4-10.8 9.7-21.1 12.8-30.3c2.8-8.4 5.3-18.3 5.3-27.5H512c0 7.9-80 96-224 96s-224-88.1-224-96H0z", "M297.7 94c-3.4 2.5-6.7 4.9-9.7 7.3c-3-2.4-6.2-4.8-9.7-7.3C260.6 81.2 231.5 64 200 64c-20.3 0-42.8 9.3-61.4 19.2c-20 10.6-41.1 24.7-60.2 39.5c-19.1 14.8-37.1 31.2-50.8 46.5c-6.8 7.6-13.1 15.7-17.9 23.7C5.5 200.2 0 211.2 0 224H64c0-7.7 46.3-31.1 138.8-32c3.4 0 6.9 .5 10.1 1.5c13.1 4 49.4 14.4 75.1 14.4s62-10.4 75.1-14.4c3.3-1 6.7-1.6 10.1-1.5c92.5 .9 138.8 24.2 138.8 32h64c0-12.8-5.5-23.8-9.7-31c-4.8-8.1-11.1-16.1-17.9-23.7c-13.6-15.3-31.7-31.7-50.8-46.5c-19.1-14.9-40.2-29-60.2-39.5C418.8 73.3 396.3 64 376 64c-31.5 0-60.6 17.2-78.3 30z"]],
    "pencil": [512, 512, [9999, 61504, "pencil-alt"], "f303", ["M492.7 58.2c25 25 25 65.5 0 90.5l-60 60L302.7 78.7l60-60c25-25 65.5-25 90.5 0l39.4 39.4zM315.3 186.7l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z", "M432.7 208.7L302.7 78.7 58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L432.7 208.7zM89.3 360.5l22.7-9.1v32c0 8.8 7.2 16 16 16h32l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3zm226-196.4c6.2 6.2 6.2 16.4 0 22.6l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0z"]],
    "backward": [512, 512, [9194], "f04a", ["M493.6 445c-11.2 5.3-24.5 3.6-34.1-4.4L256 271V241L459.5 71.4c9.5-7.9 22.8-9.7 34.1-4.4S512 83.6 512 96V416c0 12.4-7.2 23.7-18.4 29z", "M203.5 440.6c9.5 7.9 22.8 9.7 34.1 4.4s18.4-16.6 18.4-29V96c0-12.4-7.2-23.7-18.4-29s-24.5-3.6-34.1 4.4l-192 160C4.2 237.5 0 246.5 0 256s4.2 18.5 11.5 24.6l192 160z"]],
    "caret-right": [256, 512, [], "f0da", ["M246.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 256c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l128-128z", ""]],
    "comments": [640, 512, [128490, 61670], "f086", ["M231.5 383C348.9 372.9 448 288.3 448 176c0-5.2-.2-10.4-.6-15.5C555.1 167.1 640 243.2 640 336c0 38.6-14.7 74.3-39.6 103.4c3.5 9.4 8.7 17.7 14.2 24.7c4.8 6.2 9.7 11 13.3 14.3c1.8 1.6 3.3 2.9 4.3 3.7c.5 .4 .9 .7 1.1 .8l.2 .2 0 0 0 0c5.6 4.1 7.9 11.3 5.8 17.9c-2.1 6.6-8.3 11.1-15.2 11.1c-21.8 0-43.8-5.6-62.1-12.5c-9.2-3.5-17.8-7.4-25.2-11.4C505.9 503.3 470.2 512 432 512c-95.6 0-176.2-54.6-200.5-129z", "M416 176c0 97.2-93.1 176-208 176c-38.2 0-73.9-8.7-104.7-23.9c-7.5 4-16 7.9-25.3 11.4C59.8 346.4 37.8 352 16 352c-6.9 0-13.1-4.5-15.2-11.1s.2-13.8 5.8-17.9l0 0 0 0 .2-.2c.2-.2 .6-.4 1.1-.8c1-.8 2.5-2 4.3-3.7c3.6-3.3 8.5-8.1 13.3-14.3c5.5-7 10.7-15.4 14.2-24.7C14.7 250.3 0 214.6 0 176C0 78.8 93.1 0 208 0S416 78.8 416 176z"]],
    "paste": [512, 512, ["file-clipboard"], "f0ea", ["M224 176c0-26.5 21.5-48 48-48H396.1c12.7 0 24.9 5.1 33.9 14.1l67.9 67.9c9 9 14.1 21.2 14.1 33.9V464c0 26.5-21.5 48-48 48H272c-26.5 0-48-21.5-48-48V176z", "M160 0c-23.7 0-44.4 12.9-55.4 32H48C21.5 32 0 53.5 0 80V400c0 26.5 21.5 48 48 48H192V176c0-44.2 35.8-80 80-80h48V80c0-26.5-21.5-48-48-48H215.4C204.4 12.9 183.7 0 160 0zm0 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "desktop-arrow-down": [576, 512, [], "e155", ["M264 0H64C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H312V64H512V288H64V64H264V0z", "M264 64H64V288H512V64H312V174.1l39-39c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0l-80-80c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l39 39V64zm82.7 384L336 416H240l-10.7 32H160c-17.7 0-32 14.3-32 32s14.3 32 32 32H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H346.7z"]],
    "code-pull-request": [512, 512, [], "e13c", ["M112 153.3c-9.8 4.3-20.6 6.7-32 6.7s-22.2-2.4-32-6.7V358.7c9.8-4.3 20.6-6.7 32-6.7s22.2 2.4 32 6.7V153.3zM400 358.7c9.8-4.3 20.6-6.7 32-6.7s22.2 2.4 32 6.7V192c0-70.7-57.3-128-128-128H320V24c0-9.5-5.6-18.1-14.2-21.9S287-.2 279.9 6.2l-80 72c-5.1 4.6-7.9 11-7.9 17.8s2.9 13.3 7.9 17.8l80 72c7 6.3 17.2 7.9 25.8 4.1s14.2-12.4 14.2-21.9V128h16c35.3 0 64 28.7 64 64V358.7z", "M80 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104A80 80 0 1 0 80 0a80 80 0 1 0 0 160zm0 248a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm328-80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]],
    "pumpkin": [576, 512, [], "f707", ["M157.5 171.7c-7.5 4.5-16-3.4-10.4-10.1c9.6-11.4 20.6-21.7 32.7-30.5c-.6-.1-1.2-.2-1.8-.3c-8.5-1.8-17.2-2.8-26-2.8C68.1 128 0 214 0 320S68.1 512 152 512c19.3 0 37.8-4.5 54.7-12.8c8.3-4.1 18.2-4.1 26.5 0c17 8.3 35.4 12.8 54.7 12.8s37.8-4.5 54.7-12.8c8.3-4.1 18.2-4.1 26.5 0c17 8.3 35.4 12.8 54.7 12.8c83.9 0 152-86 152-192s-68.1-192-152-192c-8.9 0-17.6 1-26 2.8c-.6 .1-1.2 .2-1.8 .3c12.1 8.8 23.1 19.1 32.7 30.5c5.6 6.7-2.9 14.6-10.4 10.1C380.3 149 335.7 136 288 136s-92.3 13-130.5 35.7z", "M234.6 103.9l40.9-93.5c2.8-6.3 9-10.4 15.8-10.4h1.2c2.3 0 4.7 .5 6.8 1.4l42.3 18.1c6.4 2.7 10.5 9 10.5 15.9v72C332.1 100 310.5 96 288 96c-18.6 0-36.5 2.8-53.5 7.9z"]],
    "clipboard-list": [384, 512, [], "f46d", ["M113.2 66.3c.1-.8 .3-1.6 .4-2.3H64C28.7 64 0 92.7 0 128V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H270.4c.2 .8 .3 1.6 .4 2.3C290.1 72.6 304 90.7 304 112v24c0 13.3-10.7 24-24 24H192 104c-13.3 0-24-10.7-24-24V112c0-21.3 13.9-39.4 33.2-45.7zM72 272a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104-16H304c8.8 0 16 7.2 16 16s-7.2 16-16 16H176c-8.8 0-16-7.2-16-16s7.2-16 16-16zM72 368a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88 0c0-8.8 7.2-16 16-16H304c8.8 0 16 7.2 16 16s-7.2 16-16 16H176c-8.8 0-16-7.2-16-16z", "M113.2 66.3C119.6 28.7 152.5 0 192 0s72.4 28.7 78.8 66.3C290.1 72.6 304 90.7 304 112v24c0 13.3-10.7 24-24 24H192 104c-13.3 0-24-10.7-24-24V112c0-21.3 13.9-39.4 33.2-45.7zM216 80a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM72 272a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm0 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "pen-field": [640, 512, [], "e211", ["M0 208c0-44.2 35.8-80 80-80H272c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16H496c8.8 0 16-7.2 16-16V304c0-17.7 14.3-32 32-32s32 14.3 32 32V432c0 44.2-35.8 80-80 80H80c-44.2 0-80-35.8-80-80V208z", "M534.1 16L494.4 55.7l89.3 89.3 39.8-38.9c19.1-18.7 19.2-49.4 .4-68.2L601.9 16c-18.8-18.8-49.2-18.7-67.9 0zM471.7 78.4L328.5 221.8c-7 7-12.3 15.6-15.4 25l-23.8 71.3c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l71.5-23.9c9.2-3.1 17.6-8.2 24.5-15L560.8 167.5 471.7 78.4zM160 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "blueberries": [512, 512, [], "e2e8", ["M351.3 351.3C441.4 343.6 512 268 512 176C512 78.8 433.2 0 336 0C244 0 168.4 70.6 160.7 160.7c5.1-.4 10.2-.7 15.3-.7c97.2 0 176 78.8 176 176c0 5.2-.2 10.3-.7 15.3zM368 48c8.8 0 16 7.2 16 16V96h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H384v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V128H320c-8.8 0-16-7.2-16-16s7.2-16 16-16h32V64c0-8.8 7.2-16 16-16zM192 224c0-8.8-7.2-16-16-16s-16 7.2-16 16v32H128c-8.8 0-16 7.2-16 16s7.2 16 16 16h32v32c0 8.8 7.2 16 16 16s16-7.2 16-16V288h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H192V224z", "M384 64V96h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H384v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V128H320c-8.8 0-16-7.2-16-16s7.2-16 16-16h32V64c0-8.8 7.2-16 16-16s16 7.2 16 16zM0 336a176 176 0 1 1 352 0A176 176 0 1 1 0 336zM176 208c-8.8 0-16 7.2-16 16v32H128c-8.8 0-16 7.2-16 16s7.2 16 16 16h32v32c0 8.8 7.2 16 16 16s16-7.2 16-16V288h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H192V224c0-8.8-7.2-16-16-16z"]],
    "truck-ramp-box": [640, 512, ["truck-loading"], "f4de", ["M23.1 207.7c-4.6-17.1 5.6-34.6 22.6-39.2l154.5-41.4c17.1-4.6 34.6 5.6 39.2 22.6l41.4 154.5c4.6 17.1-5.6 34.6-22.6 39.2L103.7 384.9c-17.1 4.6-34.6-5.6-39.2-22.6L23.1 207.7zm69-51.6l20.7 77.3c2.3 8.5 11.1 13.6 19.6 11.3l30.9-8.3c8.5-2.3 13.6-11.1 11.3-19.6l-20.7-77.3L92.1 156.1zM544 320a96 96 0 1 1 0 192 96 96 0 1 1 0-192z", "M544 288c-66.1 0-120.6 50.2-127.3 114.5L48.4 502.9c-17.1 4.6-34.6-5.4-39.3-22.5s5.4-34.6 22.5-39.3L352 353.8V64c0-35.3 28.7-64 64-64H640V331.3c-23.5-26.6-57.8-43.3-96-43.3zM153.9 139.5l20.7 77.3c2.3 8.5-2.8 17.3-11.3 19.6l-30.9 8.3c-8.5 2.3-17.3-2.8-19.6-11.3L92.1 156.1l61.8-16.6z"]],
    "note": [448, 512, [], "e1ff", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V320H320c-17.7 0-32 14.3-32 32V480H64c-35.3 0-64-28.7-64-64V96zM112 384a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM88 104a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm24 152a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z", "M288 352V480h5.5c17 0 33.3-6.7 45.3-18.7l90.5-90.5c12-12 18.7-28.3 18.7-45.3V320H320c-17.7 0-32 14.3-32 32z"]],
    "arrow-down-to-square": [512, 512, [], "e096", ["M0 112C0 67.8 35.8 32 80 32h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16H432c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H400c-17.7 0-32-14.3-32-32s14.3-32 32-32h32c44.2 0 80 35.8 80 80V432c0 44.2-35.8 80-80 80H80c-44.2 0-80-35.8-80-80V112z", "M233.4 342.6c12.5 12.5 32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L288 242.7V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V242.7l-41.4-41.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96z"]],
    "user-check": [640, 512, [], "f4fc", ["M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3z", "M625 143c9.4 9.4 9.4 24.6 0 33.9L497 305c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L591 143c9.4-9.4 24.6-9.4 33.9 0z"]],
    "cloud-xmark": [640, 512, [], "e35f", ["M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zm95-273c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z", "M273 207c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]],
    "vial-virus": [512, 512, [], "e597", ["M0 64C0 46.3 14.3 32 32 32H96h64 64c17.7 0 32 14.3 32 32s-14.3 32-32 32V207.1c-3.1 2.1-6.1 4.4-8.8 7.2c-21.9 21.9-21.9 57.3 0 79.2c.2 .2 .2 .3 .3 .3l0 0c0 .1 0 .3-.1 .6s-.2 .4-.3 .5l-.1 0c-.1 0-.2 0-.4 0c-30.9 0-56 25.1-56 56s25.1 56 56 56c.2 0 .4 0 .4 0l.1 0c.1 .1 .2 .2 .3 .5s.1 .5 .1 .6l0 0c0 .1-.1 .2-.3 .3c-11.2 11.2-16.6 25.9-16.4 40.5C181.3 468 156 480 128 480c-53 0-96-43-96-96V96C14.3 96 0 81.7 0 64zM96 96v96h64V96H96z", "M376 216c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 28.8-34.9 43.3-55.2 22.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c20.4 20.4 5.9 55.2-22.9 55.2c-13.3 0-24 10.7-24 24s10.7 24 24 24c28.8 0 43.3 34.9 22.9 55.3c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c20.4-20.4 55.2-6 55.2 22.8c0 13.3 10.7 24 24 24s24-10.7 24-24c0-28.8 34.8-43.2 55.2-22.8c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9c-20.4-20.4-5.9-55.3 22.9-55.3c13.3 0 24-10.7 24-24s-10.7-24-24-24c-28.8 0-43.2-34.8-22.9-55.2c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0C410.9 259.3 376 244.8 376 216zM288.8 321.4a31.7 31.7 0 1 1 63.5 0 31.7 31.7 0 1 1 -63.5 0zm95.2 39.6a23.8 23.8 0 1 1 0 47.6 23.8 23.8 0 1 1 0-47.6z"]],
    "book-blank": [448, 512, [128213, 128215, 128216, 128217, "book-alt"], "f5d9", ["M64 416c0-17.7 14.3-32 32-32H416v64H96c-17.7 0-32-14.3-32-32z", "M0 96C0 43 43 0 96 0H384h32c17.7 0 32 14.3 32 32V352c0 17.7-14.3 32-32 32H352 256 96c-17.7 0-32 14.3-32 32s14.3 32 32 32H256h96 64c17.7 0 32 14.3 32 32s-14.3 32-32 32H384 96c-53 0-96-43-96-96V96z"]],
    "golf-flag-hole": [512, 512, [], "e3ac", ["M128 332.8C51.5 349.4 0 380.5 0 416c0 53 114.6 96 256 96s256-43 256-96s-114.6-96-256-96c-27.9 0-54.8 1.7-80 4.8v70.1c11.7-6.6 28.9-10.8 48-10.8c35.3 0 64 14.3 64 32s-28.7 32-64 32c-23.2 0-43.5-6.2-54.7-15.4c-4.4 4.5-10.5 7.4-17.3 7.4c-13.3 0-24-10.7-24-24V332.8z", "M139.4 3.6c7.1-4.4 15.9-4.8 23.4-1.1l208 104c8.1 4.1 13.3 12.4 13.3 21.5s-5.1 17.4-13.3 21.5L176 246.8V416c0 13.3-10.7 24-24 24s-24-10.7-24-24V240c0-1.4 .1-2.7 .3-4c-.2-1.3-.3-2.6-.3-4V24c0-8.3 4.3-16 11.4-20.4z"]],
    "message-arrow-down": [512, 512, ["comment-alt-arrow-down"], "e1db", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zm280 56c0-13.3-10.7-24-24-24s-24 10.7-24 24V238.1l-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31V120z", "M256 96c13.3 0 24 10.7 24 24V238.1l31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31V120c0-13.3 10.7-24 24-24z"]],
    "face-unamused": [512, 512, [], "e39f", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm60.1-117.3c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6C188.2 355.4 216.3 336 256 336s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2zM112 192h64c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32H112c-8.8 0-16-7.2-16-16s7.2-16 16-16zm176 16c0-8.8 7.2-16 16-16h64c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32H304c-8.8 0-16-7.2-16-16z", "M96 208c0-8.8 7.2-16 16-16h64c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32H112c-8.8 0-16-7.2-16-16zm192 0c0-8.8 7.2-16 16-16h64c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32H304c-8.8 0-16-7.2-16-16z"]],
    "sheet-plastic": [384, 512, [], "e571", ["M64 512c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H320c35.3 0 64 28.7 64 64V352H256c-17.7 0-32 14.3-32 32V512H64zM171.3 75.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-96 96c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l96-96zm96 32c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-160 160c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l160-160z", "M224 512L384 352H256c-17.7 0-32 14.3-32 32V512z"]],
    "circle-9": [512, 512, [], "e0f6", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256 16a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm-26 44.4l-29.6 25.4c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l81.6-70C337.8 287.2 352 256.4 352 224c0-53-43-96-96-96s-96 43-96 96c0 44 29.6 81.1 70 92.4z", "M304 224a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-74 92.4l-29.6 25.4c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l81.6-70C337.8 287.2 352 256.4 352 224c0-53-43-96-96-96s-96 43-96 96c0 44 29.6 81.1 70 92.4z"]],
    "blog": [512, 512, [], "f781", ["M224 0c-17.7 0-32 14.3-32 32s14.3 32 32 32c123.7 0 224 100.3 224 224c0 17.7 14.3 32 32 32s32-14.3 32-32C512 128.9 383.1 0 224 0zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32c70.7 0 128 57.3 128 128c0 17.7 14.3 32 32 32s32-14.3 32-32c0-106-86-192-192-192z", "M48 96c26.5 0 48 21.5 48 48V368c0 26.5 21.5 48 48 48s48-21.5 48-48s-21.5-48-48-48H128V224h16c79.5 0 144 64.5 144 144s-64.5 144-144 144S0 447.5 0 368V144c0-26.5 21.5-48 48-48z"]],
    "user-ninja": [448, 512, [129399], "f504", ["M144 112c0-8.8 7.2-16 16-16H288c8.8 0 16 7.2 16 16s-7.2 16-16 16H160c-8.8 0-16-7.2-16-16z", "M224 256c-57.2 0-105.6-37.5-122-89.3c-1.1 1.3-2.2 2.6-3.5 3.8c-15.8 15.8-38.8 20.7-53.6 22.1c-8.1 .8-14.6-5.7-13.8-13.8c1.4-14.7 6.3-37.8 22.1-53.6c5.8-5.8 12.6-10.1 19.6-13.4c-7-3.2-13.8-7.6-19.6-13.4C37.4 82.7 32.6 59.7 31.1 44.9c-.8-8.1 5.7-14.6 13.8-13.8c14.7 1.4 37.8 6.3 53.6 22.1c4.8 4.8 8.7 10.4 11.7 16.1C131.4 28.2 174.4 0 224 0c70.7 0 128 57.3 128 128s-57.3 128-128 128zM0 482.3C0 399.5 56.4 330 132.8 309.9c6-1.6 12.2 .9 15.9 5.8l62.5 83.3c6.4 8.5 19.2 8.5 25.6 0l62.5-83.3c3.7-4.9 9.9-7.4 15.9-5.8C391.6 330 448 399.5 448 482.3c0 16.4-13.3 29.7-29.7 29.7H29.7C13.3 512 0 498.7 0 482.3zM160 96c-8.8 0-16 7.2-16 16s7.2 16 16 16H288c8.8 0 16-7.2 16-16s-7.2-16-16-16H160z"]],
    "pencil-slash": [640, 512, [], "e215", ["M237.6 283.2L195.5 250l-72.9 72.9c-10.4 10.4-18 23.3-22.2 37.4L65 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2l88.3-88.3-77.9-61.4-27.6 27.6c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l24.9-24.9zm141.7-96.5l-47.8 47.8 78.1 61.2 42.1-42.1L474.3 231l11.3-11.3-33.9-33.9-62.1-62.1L355.7 89.8l-11.3 11.3-22.6 22.6-57.8 57.8 42.2 33.1 50.5-50.5c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM224 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9l-78.1 23 23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1v32c0 8.8 7.2 16 16 16h32zM426.7 18.7L412.3 33.2 389.7 55.8 378.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L517.3 18.7c-25-25-65.5-25-90.5 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "bowling-pins": [512, 512, [], "f437", ["M128 0c35.3 0 64 28.7 64 64v1.1c0 7.4-1 14.8-2.9 22l-17.7 64.8c-.7 2.7-1.3 5.4-1.8 8.1H86.5c-.5-2.7-1.1-5.4-1.8-8.1L66.9 87.1c-2-7.2-2.9-14.6-2.9-22V64C64 28.7 92.7 0 128 0zM82.1 210.4c2.2-6 3.8-12.1 4.8-18.4h82.3c1 6.3 2.6 12.4 4.8 18.4l38.6 104.7c7.6 20.6 11.5 42.5 11.5 64.4c0 28.9-6.7 57.5-19.7 83.4l-15.7 31.4C183.2 505.2 172.1 512 160 512H96c-12.1 0-23.2-6.8-28.6-17.7L51.7 462.9C38.7 437 32 408.5 32 379.5c0-22 3.9-43.8 11.5-64.4L82.1 210.4zM384 0c35.3 0 64 28.7 64 64v1.1c0 7.4-1 14.8-2.9 22l-17.7 64.8c-.7 2.7-1.3 5.4-1.8 8.1H342.5c-.5-2.7-1.1-5.4-1.8-8.1L322.9 87.1c-2-7.2-2.9-14.6-2.9-22V64c0-35.3 28.7-64 64-64zM338.1 210.4c2.2-6 3.8-12.1 4.8-18.4h82.3c1 6.3 2.6 12.4 4.8 18.4L470 319.3c6.6 17.9 10 36.8 10 55.8c0 20.5-3.9 40.9-11.5 59.9l-22.7 56.9C440.9 504 429.1 512 416 512H352c-13.1 0-24.9-8-29.7-20.1L299.5 435C291.9 416 288 395.6 288 375.1c0-19 3.4-37.9 10-55.8l40.1-108.9z", "M86.8 192c.8-4.9 1.2-9.9 1.2-14.8c0-5.8-.5-11.5-1.5-17.2h83.1c-1 5.7-1.5 11.4-1.5 17.2c0 5 .4 9.9 1.2 14.8H86.8zm256 0c.8-4.9 1.2-9.9 1.2-14.8c0-5.8-.5-11.5-1.5-17.2h83.1c-1 5.7-1.5 11.4-1.5 17.2c0 5 .4 9.9 1.2 14.8H342.8z"]],
    "person-arrow-up-from-line": [640, 512, [], "e539", ["M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-8 352V352h16v96h64V256.9l28.6 47.5c9.1 15.1 28.8 20 43.9 10.9s20-28.8 10.9-43.9l-58.3-97c-17.4-28.9-48.6-46.6-82.3-46.6H177.1c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9L120 256.9V448h64z", "M598.6 166.6c12.5-12.5 12.5-32.8 0-45.3l-80-80c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L464 141.3 464 384c0 17.7 14.3 32 32 32s32-14.3 32-32V141.3l25.4 25.4c12.5 12.5 32.8 12.5 45.3 0zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "down-right": [384, 512, [], "e16b", ["M145.4 305.4L11.3 171.3C4.1 164.1 0 154.2 0 144s4.1-20.1 11.3-27.3L52.7 75.3C59.9 68.1 69.8 64 80 64s20.1 4.1 27.3 11.3L241.4 209.4l-96 96z", "M336 432H96c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l240-240c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6V400c0 17.7-14.3 32-32 32z"]],
    "scroll-torah": [640, 512, ["torah"], "f6a0", ["M544 32H96V480H544V32zM196 313.7c0-3.2 .9-6.4 2.5-9.2L226.7 256l-28.3-48.5c-1.6-2.8-2.5-6-2.5-9.2c0-10.1 8.2-18.3 18.3-18.3H271l31.4-53.9c3.6-6.3 10.3-10.1 17.6-10.1s13.9 3.8 17.6 10.1L369 180h56.7c10.1 0 18.3 8.2 18.3 18.3c0 3.2-.9 6.4-2.5 9.2L413.3 256l28.3 48.5c1.6 2.8 2.5 6 2.5 9.2c0 10.1-8.2 18.3-18.3 18.3H369l-31.4 53.9c-3.6 6.3-10.3 10.1-17.6 10.1s-13.9-3.8-17.6-10.1L271 332H214.3c-10.1 0-18.3-8.2-18.3-18.3zm124 54.7L341.2 332H298.8L320 368.4zM254.5 256l30.3 52h70.4l30.3-52-30.3-52H284.8l-30.3 52zm144.9 23.8L383 308h32.8l-16.4-28.2zM415.8 204H383l16.4 28.2L415.8 204zM320 143.6L298.8 180h42.4L320 143.6zM224.2 204l16.4 28.2L257 204H224.2zM257 308l-16.4-28.2L224.2 308H257z", "M96 480V32C96 14.3 74.5 0 48 0S0 14.3 0 32V480c0 17.7 21.5 32 48 32s48-14.3 48-32zm544 0V32c0-17.7-21.5-32-48-32s-48 14.3-48 32V480c0 17.7 21.5 32 48 32s48-14.3 48-32z"]],
    "webhook": [576, 512, [], "e5d5", ["M210.1 110C220 67 262.9 40.1 306 50.1c41.1 9.5 67.5 49.2 61.1 90.2c-2.1 13.1 6.9 25.4 20 27.4s25.4-6.9 27.4-20C424.8 82 382.6 18.5 316.8 3.3c-68.9-15.9-137.6 27-153.5 95.9c-10.7 46.3 5.2 92.6 37.7 122.7L129.7 336c17.7 .6 32.9 10.7 40.7 25.4l82.8-132.5c3.4-5.4 4.5-11.9 3-18.1s-5.3-11.6-10.7-15c-28.2-17.6-43.4-51.7-35.5-85.9zm120.3 40.5c-7.8 14.7-23.1 24.8-40.7 25.4l82.8 132.5c3.4 5.4 8.8 9.2 15 10.7s12.7 .3 18.1-3c30.9-19.3 72.1-15.5 99 11.3c31.2 31.2 31.2 81.9 0 113.1c-26.8 26.8-68.1 30.6-99 11.3c-11.2-7-26-3.6-33.1 7.6s-3.6 26 7.6 33.1c49.4 31 115.4 25 158.4-18c50-50 50-131 0-181c-37-37-91-46.6-136.8-28.9L330.4 150.5zM110.1 278.8c-5.1-12.2-19.1-18-31.4-12.9C22.1 289.4-11 351 3.3 412.8c15.9 68.9 84.6 111.8 153.5 95.9c51-11.8 87.7-52.5 97-100.7H406.4c-4.1-7.1-6.4-15.3-6.4-24s2.3-16.9 6.4-24H232c-6.4 0-12.5 2.5-17 7s-7 10.6-7 17c0 36.4-25 69.4-62 77.9c-43.1 9.9-86-16.9-95.9-60c-8.9-38.6 11.7-77.1 47.1-91.8c12.2-5.1 18-19.1 12.9-31.4z", "M288 176a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM176 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm320 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]],
    "blinds-open": [512, 512, [], "f8fc", ["M160 192H494.2c9.8 0 17.8-8 17.8-17.8c0-4-1.4-7.9-3.9-11.1L489.6 140c-6.1-7.6-15.3-12-25-12H160v64zm-32-64H47.4c-9.7 0-18.9 4.4-25 12L3.9 163.1C1.4 166.3 0 170.2 0 174.2C0 184 8 192 17.8 192H128V128zM98.7 288H47.4c-9.7 0-18.9 4.4-25 12L3.9 323.1C1.4 326.3 0 330.2 0 334.2C0 344 8 352 17.8 352H144 494.2c9.8 0 17.8-8 17.8-17.8c0-4-1.4-7.9-3.9-11.1L489.6 300c-6.1-7.6-15.3-12-25-12H189.3c1.8 5 2.7 10.4 2.7 16c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16zM494.2 512c9.8 0 17.8-8 17.8-17.8c0-4-1.4-7.9-3.9-11.1L489.6 460c-6.1-7.6-15.3-12-25-12H47.4c-9.7 0-18.9 4.4-25 12L3.9 483.1C1.4 486.3 0 490.2 0 494.2C0 504 8 512 17.8 512H494.2z", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64h96V258.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V64H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "fence": [512, 512, [], "e303", ["M192 160H128v64h64V160zm192 0H320v64h64V160zM128 352v64h64V352H128zm256 0H320v64h64V352z", "M76.8 38.4C73.8 34.4 69 32 64 32s-9.8 2.4-12.8 6.4L6.4 98.1C2.2 103.7 0 110.4 0 117.3V448c0 17.7 14.3 32 32 32H96c17.7 0 32-14.3 32-32V117.3c0-6.9-2.2-13.7-6.4-19.2L76.8 38.4zm192 0c-3-4-7.8-6.4-12.8-6.4s-9.8 2.4-12.8 6.4L198.4 98.1c-4.2 5.5-6.4 12.3-6.4 19.2V448c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V117.3c0-6.9-2.2-13.7-6.4-19.2L268.8 38.4zM448 32c-5 0-9.8 2.4-12.8 6.4L390.4 98.1c-4.2 5.5-6.4 12.3-6.4 19.2V448c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V117.3c0-6.9-2.2-13.7-6.4-19.2L460.8 38.4c-3-4-7.8-6.4-12.8-6.4z"]],
    "up": [384, 512, ["arrow-alt-up"], "f357", ["M128 256V440c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V256H128z", "M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8h96v0H256v0h96c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-160-160z"]],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", ["M566.6 54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192 45.3 45.3 192-192zM464 512a80 80 0 1 0 0-160 80 80 0 1 0 0 160z", "M409.4 281.4L294.6 166.6c-4.2-4.2-10-6.6-16-6.6c-12.5 0-22.6 10.1-22.6 22.6v29.1L364.3 320h29.1c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16zm-68.3 72L222.6 234.9c-42.7-3.7-85.2 11.7-115.8 42.3l-8 8C76.5 307.5 64 337.7 64 369.2c0 6.8 7.1 11.2 13.2 8.2l51.1-25.5c5-2.5 9.5 4.1 5.4 7.9L7.3 473.4C2.7 477.6 0 483.6 0 489.9C0 502.1 9.9 512 22.1 512l173.3 0c38.8 0 75.9-15.4 103.4-42.8c30.6-30.6 45.9-73.1 42.3-115.8z"]],
    "drumstick": [512, 512, [127831], "f6d6", ["M160.2 278.2c3 39.2 34.3 70.5 73.5 73.5l-36.4 36.4c-12.3 12.3-11.4 32.5-7.2 49.4c1.1 4.6 1.8 9.5 1.8 14.5c0 33.1-26.9 60-60 60s-60-26.9-60-60c0-6.3-5.7-12-12-12c-33.1 0-60-26.9-60-60s26.9-60 60-60c5 0 9.8 .6 14.5 1.8c16.9 4.2 37.1 5.2 49.4-7.2l36.4-36.4z", "M160 176v96c0 44.2 35.8 80 80 80h96c97.2 0 176-78.8 176-176S433.2 0 336 0S160 78.8 160 176z"]],
    "square-v": [448, 512, [], "e284", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm77.5 125.3L224 322.3l82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-104-208c-5.9-11.9-1.1-26.3 10.7-32.2s26.3-1.1 32.2 10.7z", "M109.3 146.5c11.9-5.9 26.3-1.1 32.2 10.7L224 322.3l82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-104-208c-5.9-11.9-1.1-26.3 10.7-32.2z"]],
    "face-awesome": [512, 512, ["gave-dandy"], "e409", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM144 120c35.3 0 64 28.7 64 64v10.3c0 16.4-13.3 29.7-29.7 29.7H109.7C93.3 224 80 210.7 80 194.3V184c0-35.3 28.7-64 64-64zm128 72c0-39.8 32.2-72 72-72s72 32.2 72 72v7.5c0 13.5-11 24.5-24.5 24.5H296.5C283 224 272 213 272 199.5V192zM116.3 288H395.7c10.4 0 18.1 9.6 15.9 19.8C395.5 380.4 330.3 432 256 432s-139.5-51.6-155.6-124.2c-2.3-10.2 5.5-19.8 15.9-19.8z", "M154 120.8c22.6 3.5 41.3 18.9 49.5 39.6c-5.6 9.4-15.8 15.6-27.5 15.6c-17.7 0-32-14.3-32-32c0-9.1 3.8-17.4 10-23.2zM360.8 122c22 5.3 40.1 20.6 49.1 40.9c-5.8 8-15.2 13.1-25.9 13.1c-17.7 0-32-14.3-32-32c0-8.5 3.3-16.3 8.8-22zM100.4 307.8c-2.3-10.2 5.5-19.8 15.9-19.8H395.7c10.4 0 18.1 9.6 15.9 19.8c-5 22.3-14.6 42.7-27.7 60.2c-13.4-10-30-16-47.9-16c-44.2 0-80 35.8-80 80c-74.3 0-139.5-51.6-155.6-124.2z"]],
    "dial-off": [576, 512, [], "e162", ["M256 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M312 446.2c77-11.6 136-78 136-158.2c0-88.4-71.6-160-160-160s-160 71.6-160 160c0 80.2 59 146.6 136 158.2V288c0-13.3 10.7-24 24-24s24 10.7 24 24V446.2z"]],
    "toggle-off": [576, 512, [], "f204", ["M192 128c-70.7 0-128 57.3-128 128s57.3 128 128 128H384c70.7 0 128-57.3 128-128s-57.3-128-128-128H192zM384 64c106 0 192 86 192 192s-86 192-192 192H192C86 448 0 362 0 256S86 64 192 64H384z", "M96 256a96 96 0 1 0 192 0A96 96 0 1 0 96 256z"]],
    "face-smile-horns": [640, 512, [], "e391", ["M64 256a256 256 0 1 1 512 0A256 256 0 1 1 64 256zm141.5 91.9c-6.7 5.8-7.4 15.9-1.6 22.6c22.2 25.7 61 53.5 116.1 53.5s93.8-27.9 116.1-53.5c5.8-6.7 5.1-16.8-1.6-22.6s-16.8-5.1-22.6 1.6C394 370.2 363.4 392 320 392s-74-21.8-91.9-42.5c-5.8-6.7-15.9-7.4-22.6-1.6zM240.4 304c17.7 0 32-14.3 32-32c0-1.5-.1-3-.3-4.4l10.9 3.6c8.4 2.8 17.4-1.7 20.2-10.1s-1.7-17.4-10.1-20.2l-96-32c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2l30.7 10.2c-5.8 5.8-9.3 13.8-9.3 22.6c0 17.7 14.3 32 32 32zm192-32c0-8.9-3.6-17-9.5-22.8l30.2-10.1c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-96 32c-8.4 2.8-12.9 11.9-10.1 20.2s11.9 12.9 20.2 10.1l11.7-3.9c-.2 1.5-.3 3.1-.3 4.7c0 17.7 14.3 32 32 32s32-14.3 32-32z", "M566.1 185.1C550.5 131 517.6 84.3 473.8 51.3c17-3.3 39.7-8.6 63-15.5c29.8-8.9 59.1-20.2 78.4-33.1c5.4-3.6 12.4-3.6 17.8 0s8.1 10.1 6.8 16.4c-6.2 31-29.3 106.6-73.6 166zM103.3 35.8c23.3 7 46 12.2 63 15.5c-43.8 33-76.7 79.7-92.3 133.8C29.6 125.8 6.5 50.1 .3 19.1C-1 12.8 1.7 6.3 7.1 2.7s12.4-3.6 17.8 0c19.3 12.9 48.5 24.2 78.4 33.1zM240.4 304c-17.7 0-32-14.3-32-32c0-8.8 3.6-16.8 9.3-22.6l-30.7-10.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l96 32c8.4 2.8 12.9 11.9 10.1 20.2s-11.9 12.9-20.2 10.1l-10.9-3.6c.2 1.5 .3 2.9 .3 4.4c0 17.7-14.3 32-32 32zm192-32c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-1.6 .1-3.2 .3-4.7l-11.7 3.9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l96-32c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-30.2 10.1c5.9 5.8 9.5 13.9 9.5 22.8z"]],
    "box-archive": [512, 512, ["archive"], "f187", ["M480 128H32V416c0 35.3 28.7 64 64 64H416c35.3 0 64-28.7 64-64V128zM192 192H320c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-17.7 0-32-14.3-32-32s14.3-32 32-32z", "M0 64C0 46.3 14.3 32 32 32H480c17.7 0 32 14.3 32 32V96c0 17.7-14.3 32-32 32H32C14.3 128 0 113.7 0 96V64z"]],
    "grapes": [512, 512, [], "e306", ["M320 72c0-29.7 17.6-55 26.7-66c3.3-4 8.2-6 13.3-6s10 2 13.2 6C382.3 17.4 400 44.3 400 80c0 32-8 40-8 40s8-8 40-8c35.7 0 62.6 17.7 74 26.8c4 3.2 6 8.1 6 13.2s-2 10-6 13.3C495 174.4 469.7 192 440 192c-40 0-55.3-15.3-80-40s-40-40-40-80z", "M248 208a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-80-32A56 56 0 1 0 56 176a56 56 0 1 0 112 0zM88 368a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM56 512a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm144-32a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm192-80a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM224 344a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm192-80a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"]],
    "person-drowning": [576, 512, [], "e545", ["M269.5 389.9c11.1-7.9 25.9-7.9 37 0C329 405.4 356.5 416 384 416c26.9 0 55.4-10.8 77.4-26.1l0 0c11.9-8.5 28.1-7.8 39.2 1.7c14.4 11.9 32.5 21 50.6 25.2c17.2 4 27.9 21.2 23.9 38.4s-21.2 27.9-38.4 23.9c-24.5-5.7-44.9-16.5-58.2-25C449.5 469.7 417 480 384 480c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9c-33 0-65.5-10.3-94.5-25.8c-13.4 8.4-33.7 19.3-58.2 25c-17.2 4-34.4-6.7-38.4-23.9s6.7-34.4 23.9-38.4c18.1-4.2 36.2-13.3 50.6-25.2c11.1-9.4 27.3-10.1 39.2-1.7l0 0C136.7 405.2 165.1 416 192 416c27.5 0 55-10.6 77.5-26.1z", "M160 32c17.7 0 32 14.3 32 32V96.2c0 52.7 34.1 99.3 84.3 115.3c40 12.7 82.7 14.5 123.7 5.2l105-23.9c17.2-3.9 34.4 6.9 38.3 24.1s-6.9 34.4-24.1 38.3l-105 23.9c-10.6 2.4-21.2 4.2-31.9 5.5l-17.7 97.6c-13.6-3.2-27.3-9.4-39.7-18c-22.1-15.5-51.6-15.5-73.7 0c-17.1 11.8-38 20.3-59.2 20.3c-7.3 0-15-1.2-22.8-3.3l21-146.7C151.5 200.1 128 150.2 128 96.2V64c0-17.7 14.3-32 32-32zm96 96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]],
    "dial-max": [576, 512, [], "e15e", ["M256 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M417.1 382.8c46.2-62.6 41-151.3-15.7-208c-62.5-62.5-163.8-62.5-226.3 0s-62.5 163.8 0 226.3c56.7 56.7 145.4 62 208 15.7L271.3 304.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L417.1 382.8z"]],
    "circle-m": [512, 512, [], "e115", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM171.5 137.9L256 255l84.5-117.1c6.1-8.4 16.9-12 26.8-8.8s16.6 12.4 16.6 22.8V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V226.2l-60.5 83.8c-4.5 6.2-11.7 9.9-19.5 9.9s-14.9-3.7-19.5-9.9L176 226.2V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-10.4 6.7-19.6 16.6-22.8s20.7 .3 26.8 8.8z", "M144.6 129.2c9.9-3.2 20.7 .3 26.8 8.8L256 255l84.5-117.1c6.1-8.4 16.9-12 26.8-8.8s16.6 12.4 16.6 22.8V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V226.2l-60.5 83.8c-4.5 6.2-11.7 9.9-19.5 9.9s-14.9-3.7-19.5-9.9L176 226.2V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-10.4 6.7-19.6 16.6-22.8z"]],
    "calendar-image": [448, 512, [], "e0d4", ["M0 192H448V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V192zM147.2 360.7L99.8 422.2c-8.1 10.5-.6 25.8 12.7 25.8H338.9c12.6 0 20.3-13.9 13.5-24.6L268.9 292.3c-6.1-9.7-20.1-9.9-26.7-.5L184 376l-11.4-15.1c-6.4-8.5-19-8.5-25.5-.2zM128 320a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M128 0C110.3 0 96 14.3 96 32V64H48C21.5 64 0 85.5 0 112v80H448V112c0-26.5-21.5-48-48-48H352V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V64H160V32c0-17.7-14.3-32-32-32zM99.8 422.2c-8.1 10.5-.6 25.8 12.7 25.8H338.9c12.6 0 20.3-13.9 13.5-24.6L268.9 292.3c-6.1-9.7-20.1-9.9-26.7-.5L184 376l-11.4-15.1c-6.4-8.5-19-8.5-25.5-.2L99.8 422.2z"]],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", ["M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm0-144c6.7 0 13-2.8 17.6-7.7l104-112c6.5-7 8.2-17.2 4.4-25.9s-12.5-14.4-22-14.4H152c-9.5 0-18.2 5.7-22 14.4s-2.1 18.9 4.4 25.9l104 112c4.5 4.9 10.9 7.7 17.6 7.7z", "M273.6 360.3c-4.5 4.9-10.9 7.7-17.6 7.7s-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9s12.5-14.4 22-14.4H360c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112z"]],
    "arrow-down-9-1": [576, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", ["M445.7 148.9A32 32 0 1 0 418.3 91a32 32 0 1 0 27.4 57.9zm-40.7 54.9C369.6 192.4 344 159.2 344 120c0-48.6 39.4-88 88-88s88 39.4 88 88c0 23.5-7.5 46.3-21.5 65.2L449.7 251c-10.5 14.2-30.6 17.2-44.8 6.7s-17.2-30.6-6.7-44.8l6.8-9.2zM464 320v96h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H432 384c-17.7 0-32-14.3-32-32s14.3-32 32-32h16V364.4l-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16c9.8-3.3 20.5-1.6 28.8 4.4s13.3 15.7 13.3 26z", "M160 480c9 0 17.5-3.8 23.6-10.4l88-96c11.9-13 11.1-33.3-2-45.2s-33.3-11.1-45.2 2L192 365.7V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V365.7L95.6 330.4c-11.9-13-32.2-13.9-45.2-2s-13.9 32.2-2 45.2l88 96C142.5 476.2 151 480 160 480z"]],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", ["M174.5 498.8C73.1 464.7 0 368.9 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 112.9-73.1 208.7-174.5 242.8C346.7 484 352 466.6 352 448V401.1c24.3-17.5 43.6-41.6 55.4-69.6c5-11.8-7-22.5-19.3-18.7c-39.7 12.2-84.5 19-131.8 19s-92.1-6.8-131.8-19c-12.3-3.8-24.3 6.9-19.3 18.7c11.7 27.8 30.8 51.7 54.8 69.2V448c0 18.6 5.3 36 14.5 50.8zm-41-368.1c-7.9-4.2-17.5 1.5-17.5 10.5c0 2.8 1 5.5 2.8 7.6l36 43.2-36 43.2c-1.8 2.1-2.8 4.8-2.8 7.6c0 9 9.6 14.7 17.5 10.5l89.9-47.9c10.7-5.7 10.7-21.1 0-26.8l-89.9-47.9zM396 141.1c0-9-9.6-14.7-17.5-10.5l-89.9 47.9c-10.7 5.7-10.7 21.1 0 26.8l89.9 47.9c7.9 4.2 17.5-1.5 17.5-10.5c0-2.8-1-5.5-2.8-7.6l-36-43.2 36-43.2c1.8-2.1 2.8-4.8 2.8-7.6z", "M133.5 130.7c-7.9-4.2-17.5 1.5-17.5 10.5c0 2.8 1 5.5 2.8 7.6l36 43.2-36 43.2c-1.8 2.1-2.8 4.8-2.8 7.6c0 9 9.6 14.7 17.5 10.5l89.9-47.9c10.7-5.7 10.7-21.1 0-26.8l-89.9-47.9zm245 0l-89.9 47.9c-10.7 5.7-10.7 21.1 0 26.8l89.9 47.9c7.9 4.2 17.5-1.5 17.5-10.5c0-2.8-1-5.5-2.8-7.6l-36-43.2 36-43.2c1.8-2.1 2.8-4.8 2.8-7.6c0-9-9.6-14.7-17.5-10.5zM320 448V402.6c0-14.7-11.9-26.6-26.6-26.6h-2c-11.3 0-21.1 7.9-23.6 18.9c-2.8 12.6-20.8 12.6-23.6 0c-2.5-11.1-12.3-18.9-23.6-18.9h-2c-14.7 0-26.6 11.9-26.6 26.6V448c0 35.3 28.7 64 64 64s64-28.7 64-64z"]],
    "shish-kebab": [512, 512, [], "f821", ["M393.4 73.4c12.5-12.5 32.8-12.5 45.3 0c10.4 10.4 12.2 26.4 5.1 38.6c-8.8 15.3-3.6 34.9 11.7 43.7s34.9 3.6 43.7-11.7c21.2-36.7 16.2-84.5-15.3-115.9c-37.5-37.5-98.3-37.5-135.8 0c-25.7 25.7-33.8 62.4-24.3 94.9c1.8 6.1 2.4 11.4 2.1 15.2c-.1 2-.5 2.9-.6 3.2l-31 31 45.3 45.3 31.1-31.1c13.1-13.1 18-29.4 19.1-43.4c1.1-13.8-1.3-27.2-4.5-38c-3.2-11-.5-23.1 8.1-31.7zM241.7 315.6l-45.3-45.3-30.1 30.1 45.3 45.3 30.1-30.1zm-128 128L68.4 398.3l-59 59c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l59-59zM325.3 141.5a.1 .1 0 1 0 -.1-.2 .1 .1 0 1 0 .1 .2z", "M203.7 138.3l-41.4 41.4c-15.6 15.6-15.6 40.9 0 56.6L275.7 349.7c15.6 15.6 40.9 15.6 56.6 0l41.4-41.4c15.6-15.6 15.6-40.9 0-56.6L260.3 138.3c-15.6-15.6-40.9-15.6-56.6 0zm-71.4 128c-15.6-15.6-40.9-15.6-56.6 0L34.3 307.7c-15.6 15.6-15.6 40.9 0 56.6L147.7 477.7c15.6 15.6 40.9 15.6 56.6 0l41.4-41.4c15.6-15.6 15.6-40.9 0-56.6L132.3 266.3z"]],
    "spray-can": [512, 512, [], "f5bd", ["M256 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM80 336a80 80 0 1 1 160 0A80 80 0 1 1 80 336zM384 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM448 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM384 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M128 0h64c17.7 0 32 14.3 32 32v96H96V32c0-17.7 14.3-32 32-32zM0 256c0-53 43-96 96-96H224c53 0 96 43 96 96V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V256zm240 80A80 80 0 1 0 80 336a80 80 0 1 0 160 0z"]],
    "alarm-snooze": [512, 512, [], "f845", ["M256 512c50.3 0 96.8-16.6 134.2-44.6l35.2 35.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-35.2-35.2c28-37.4 44.6-83.8 44.6-134.2C480 164.3 379.7 64 256 64S32 164.3 32 288c0 50.3 16.6 96.8 44.6 134.2L41.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l35.2-35.2c37.4 28 83.8 44.6 134.1 44.6zM200 192H312c9.2 0 17.5 5.2 21.6 13.5s3 18-2.6 25.3L249.1 336H312c13.3 0 24 10.7 24 24s-10.7 24-24 24H200c-9.2 0-17.5-5.2-21.6-13.5s-3-18 2.6-25.3L262.9 240H200c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M14.9 146.4L160 25.4C143 9.6 120.2 0 95.2 0C42.6 0 0 42.6 0 95.2c0 18.8 5.5 36.3 14.9 51.1zm482.3 0C506.5 131.6 512 114 512 95.2C512 42.6 469.4 0 416.8 0C391.8 0 369 9.6 352 25.4L497.1 146.4zM200 192c-13.3 0-24 10.7-24 24s10.7 24 24 24h62.9L181.1 345.3c-5.6 7.2-6.6 17-2.6 25.3s12.4 13.5 21.6 13.5H312c13.3 0 24-10.7 24-24s-10.7-24-24-24H249.1l81.9-105.3c5.6-7.2 6.6-17 2.6-25.3s-12.4-13.5-21.6-13.5H200z"]],
    "scarecrow": [448, 512, [], "f70d", ["M224 192A96 96 0 1 0 224 0a96 96 0 1 0 0 192zM192 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM192 400.1V480c0 17.7 14.3 32 32 32s32-14.3 32-32V400.1l-24.1 13.8c-4.9 2.8-11 2.8-15.9 0L192 400.1z", "M133.5 128H32c-5.9 0-11.3 3.2-14.1 8.5s-2.5 11.5 .8 16.4l7.6 11.4L6.4 179.2C2.4 182.2 0 187 0 192s2.4 9.8 6.4 12.8l19.9 14.9-7.6 11.4c-3.3 4.9-3.6 11.2-.8 16.4s8.2 8.5 14.1 8.5h73c10.1 0 17.7 9.2 15.7 19.1L96.3 396.9c-1.2 6.2 1.2 12.5 6.3 16.1s11.8 4 17.3 .9L160.1 391c4.9-2.8 11-2.8 15.9 0l40.1 22.9c4.9 2.8 11 2.8 15.9 0L272.1 391c4.9-2.8 11-2.8 15.9 0l40.1 22.9c5.4 3.1 12.2 2.8 17.3-.9s7.6-10 6.3-16.1L327.3 275.1c-2-9.9 5.6-19.1 15.7-19.1h73c5.9 0 11.3-3.2 14.1-8.5s2.5-11.5-.8-16.4l-7.6-11.4 19.9-14.9c4-3 6.4-7.8 6.4-12.8s-2.4-9.8-6.4-12.8l-19.9-14.9 7.6-11.4c3.3-4.9 3.6-11.2 .8-16.4s-8.2-8.5-14.1-8.5H314.5c-13.2 37.3-48.7 64-90.5 64s-77.4-26.7-90.5-64z"]],
    "truck-monster": [640, 512, [], "f63b", ["M130.3 276c4.8-11.7 16.2-20 29.7-20s24.9 8.3 29.7 20c9.1 2.5 17.7 6.1 25.7 10.7c11.6-4.9 25.6-2.6 35.1 6.8s11.8 23.5 6.8 35.1c4.6 8 8.2 16.6 10.7 25.7c11.7 4.8 20 16.2 20 29.7s-8.3 24.9-20 29.7c-2.5 9.1-6.1 17.7-10.7 25.7c4.9 11.6 2.6 25.6-6.8 35.1s-23.5 11.8-35.1 6.8c-8 4.6-16.6 8.2-25.7 10.7c-4.8 11.7-16.2 20-29.7 20s-24.9-8.3-29.7-20c-9.1-2.5-17.7-6.1-25.7-10.7C93 486.3 79 484 69.5 474.5S57.7 451 62.6 439.4c-4.6-8-8.2-16.6-10.7-25.7c-11.7-4.8-20-16.2-20-29.7s8.3-24.9 20-29.7c2.5-9.1 6.1-17.7 10.7-25.7C57.7 317 60 303 69.5 293.5s23.5-11.8 35.1-6.8c8-4.6 16.6-8.2 25.7-10.7zM208 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM450.3 276c4.8-11.7 16.2-20 29.7-20s24.9 8.3 29.7 20c9.1 2.5 17.7 6.1 25.7 10.7c11.6-4.9 25.6-2.6 35.1 6.8s11.8 23.5 6.9 35.1c4.6 8 8.2 16.6 10.7 25.7c11.7 4.8 20 16.2 20 29.7s-8.3 24.9-20 29.7c-2.5 9.1-6.1 17.7-10.7 25.7c4.9 11.6 2.6 25.6-6.9 35.1s-23.5 11.8-35.1 6.8c-8 4.6-16.6 8.2-25.7 10.7c-4.8 11.7-16.2 20-29.7 20s-24.9-8.3-29.7-20c-9.1-2.5-17.7-6.1-25.7-10.7c-11.6 4.9-25.6 2.6-35.1-6.9s-11.8-23.5-6.8-35.1c-4.6-8-8.2-16.6-10.7-25.7c-11.7-4.8-20-16.2-20-29.7s8.3-24.9 20-29.7c2.5-9.1 6.1-17.7 10.7-25.7c-4.9-11.6-2.6-25.6 6.8-35.1s23.5-11.8 35.1-6.8c8-4.6 16.6-8.2 25.7-10.7zM528 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z", "M288 64v64H416L368 64H288zM419.2 25.6L496 128h80c17.7 0 32 14.3 32 32v64c17.7 0 32 14.3 32 32s-14.3 32-32 32c-29.2-38.9-75.7-64-128-64s-98.8 25.1-128 64H288c-29.2-38.9-75.7-64-128-64s-98.8 25.1-128 64c-17.7 0-32-14.3-32-32s14.3-32 32-32V160c0-17.7 14.3-32 32-32H224V48c0-26.5 21.5-48 48-48h96c20.1 0 39.1 9.5 51.2 25.6z"]],
    "gift-card": [576, 512, [], "f663", ["M470.4 128H512c35.3 0 64 28.7 64 64V320H0V192c0-35.3 28.7-64 64-64h41.6c14.6 28.5 44.2 48 78.4 48h59.4l-53.9 64.6c-8.5 10.2-7.1 25.3 3.1 33.8s25.3 7.1 33.8-3.1L288 197.5l61.6 73.9c8.5 10.2 23.6 11.6 33.8 3.1s11.6-23.6 3.1-33.8L332.6 176H392c34.2 0 63.8-19.5 78.4-48zM0 416H576v32c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V416z", "M186.2 48H184c-22.1 0-40 17.9-40 40s17.9 40 40 40h73.3L222.5 68.8C214.9 55.9 201.1 48 186.2 48zm57.3 128H184c-48.6 0-88-39.4-88-88s39.4-88 88-88h2.2c31.9 0 61.5 16.9 77.7 44.4l24.1 41 24.1-41C328.3 16.9 357.9 0 389.8 0H392c48.6 0 88 39.4 88 88s-39.4 88-88 88H332.6l53.9 64.6c8.5 10.2 7.1 25.3-3.1 33.8s-25.3 7.1-33.8-3.1L288 197.5l-61.6 73.9c-8.5 10.2-23.6 11.6-33.8 3.1s-11.6-23.6-3.1-33.8L243.4 176zM392 128c22.1 0 40-17.9 40-40s-17.9-40-40-40h-2.2c-14.9 0-28.8 7.9-36.3 20.8L318.7 128H320h72zM576 416H0V320H576v96z"]],
    "w": [576, 512, [119], "57", ["M20.8 34c16.5-6.2 35 2.2 41.2 18.7l110.2 294L257.3 55c4-13.7 16.5-23 30.7-23s26.7 9.4 30.7 23l85.1 291.7L514 52.8c6.2-16.5 24.6-24.9 41.2-18.7s24.9 24.7 18.7 41.2l-144 384c-4.8 12.9-17.4 21.3-31.2 20.7s-25.7-9.8-29.5-23L288 178.3 206.7 457c-3.9 13.2-15.8 22.5-29.5 23s-26.3-7.8-31.2-20.7L2 75.2C-4.2 58.7 4.2 40.2 20.8 34z", ""]],
    "code-pull-request-draft": [448, 512, [], "e3fa", ["M416 80a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 153.3c-9.8 4.3-20.6 6.7-32 6.7s-22.2-2.4-32-6.7V358.7c9.8-4.3 20.6-6.7 32-6.7s22.2 2.4 32 6.7V153.3zM368 288a48 48 0 1 0 0-96 48 48 0 1 0 0 96z", "M80 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104A80 80 0 1 0 80 0a80 80 0 1 0 0 160zm0 248a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm264-80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]],
    "square-b": [448, 512, [], "e264", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm64 120c0-13.3 10.7-24 24-24h92c42 0 76 34 76 76c0 16.2-5.1 31.3-13.8 43.7C324.3 261.6 336 283.4 336 308c0 42-34 76-76 76H152c-13.3 0-24-10.7-24-24V256 152zm144 52c0-15.5-12.5-28-28-28H176v56h68c15.5 0 28-12.5 28-28zM176 336h84c15.5 0 28-12.5 28-28s-12.5-28-28-28H244 176v56z", "M152 128c-13.3 0-24 10.7-24 24V256 360c0 13.3 10.7 24 24 24H260c42 0 76-34 76-76c0-24.6-11.7-46.4-29.8-60.3c8.7-12.4 13.8-27.4 13.8-43.7c0-42-34-76-76-76H152zm92 104H176V176h68c15.5 0 28 12.5 28 28s-12.5 28-28 28zm-68 48h68 16c15.5 0 28 12.5 28 28s-12.5 28-28 28H176V280z"]],
    "elephant": [640, 512, [128024], "f6da", ["M192 112C192 50.1 242.1 0 304 0c30.5 0 58.2 12.2 78.4 32H384c88.4 0 160 71.6 160 160V346.5c-10 3.5-20.8 5.5-32 5.5c-34.9 0-65.5-18.6-82.3-46.5c-4.6-7.6-14.4-10-22-5.4s-10 14.4-5.4 22c4 6.6 8.6 12.9 13.7 18.7V480c0 17.7-14.3 32-32 32H320c-17.7 0-32-14.3-32-32V410c-15.3 3.9-31.4 6-48 6s-32.7-2.1-48-6v70c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V344.7c-2.6 4.7-5.5 9.2-8.7 13.5L43.2 374.4c-8 10.6-23 12.8-33.6 4.8s-12.8-23-4.8-33.6l12.1-16.2c5.7-7.6 9.6-16.3 11.4-25.6C30.8 291.7 32 279.4 32 267V248c0-72.2 35.4-136.1 89.9-175.4c16.7-13.1 35.6-23.4 56.1-30.4c-11.5 20.7-18 44.5-18 69.8c0 79.5 64.5 144 144 144c8.8 0 16-7.2 16-16s-7.2-16-16-16c-61.9 0-112-50.1-112-112zM480 380c10.2 2.6 21 4 32 4s21.8-1.4 32-4v18.6c0 9.6 7.8 17.4 17.4 17.4c6.6 0 12.6-3.7 15.6-9.6l2.3-4.7c7.9-15.8 27.1-22.2 42.9-14.3s22.2 27.1 14.3 42.9l-2.3 4.7c-13.8 27.6-42 45-72.8 45c-45 0-81.4-36.5-81.4-81.4V380zm0-172a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z", "M464 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-34.3 81.5c-4.6-7.6-14.4-10-22-5.4s-10 14.4-5.4 22c22.4 37.1 63.1 62 109.7 62c35.8 0 68.2-14.7 91.4-38.4c6.2-6.3 6.1-16.4-.2-22.6s-16.4-6.1-22.6 .2C563.1 341 538.9 352 512 352c-34.9 0-65.5-18.6-82.3-46.5z"]],
    "earth-africa": [512, 512, [127757, "globe-africa"], "f57c", ["M146 24.8l39.9 54.8c4 5.5 6.1 12.1 6.1 18.8v39.5c0 3.9 1.6 7.7 4.3 10.4c6.2 6.2 16.5 5.7 22-1.2l13.6-17c4.7-5.9 12.9-7.7 19.6-4.3l15.2 7.6c3.4 1.7 7.2 2.6 11 2.6c6.5 0 12.8-2.6 17.4-7.2l3.9-3.9c2.9-2.9 7.3-3.6 11-1.8l29.2 14.6c7.8 3.9 12.6 11.8 12.6 20.5c0 10.5-7.1 19.6-17.3 22.2l-35.4 8.8c-7.4 1.8-15.1 1.5-22.4-.9l-32-10.7c-3.3-1.1-6.7-1.7-10.2-1.7c-7 0-13.8 2.3-19.4 6.5L176 212c-10.1 7.6-16 19.4-16 32v28c0 26.5 21.5 48 48 48h32c8.8 0 16 7.2 16 16v48c0 17.7 14.3 32 32 32c10.1 0 19.6-4.7 25.6-12.8l25.6-34.1c8.3-11.1 12.8-24.6 12.8-38.4V318.6c0-3.9 2.6-7.3 6.4-8.2l5.3-1.3c11.9-3 20.3-13.7 20.3-26c0-7.1-2.8-13.9-7.8-18.9l-33.5-33.5c-3.7-3.7-3.7-9.7 0-13.4c5.7-5.7 14.1-7.7 21.8-5.1l12.5 4.2c13.2 4.4 27.6-1.6 33.9-14c3.2-6.3 9.6-10.3 16.7-10.3h76.4c5.3 20.5 8.1 41.9 8.1 64c0 141.4-114.6 256-256 256S0 397.4 0 256C0 154 59.7 65.9 146 24.8z", "M146 24.8l39.9 54.8c4 5.5 6.1 12.1 6.1 18.8v39.5c0 3.9 1.6 7.7 4.3 10.4c6.2 6.2 16.5 5.7 22-1.2l13.6-17c4.7-5.9 12.9-7.7 19.6-4.3l15.2 7.6c3.4 1.7 7.2 2.6 11 2.6c6.5 0 12.8-2.6 17.4-7.2l3.9-3.9c2.9-2.9 7.3-3.6 11-1.8l29.2 14.6c7.8 3.9 12.6 11.8 12.6 20.5c0 10.5-7.1 19.6-17.3 22.2l-35.4 8.8c-7.4 1.8-15.1 1.5-22.4-.9l-32-10.7c-3.3-1.1-6.7-1.7-10.2-1.7c-7 0-13.8 2.3-19.4 6.5L176 212c-10.1 7.6-16 19.4-16 32v28c0 26.5 21.5 48 48 48h32c8.8 0 16 7.2 16 16v48c0 17.7 14.3 32 32 32c10.1 0 19.6-4.7 25.6-12.8l25.6-34.1c8.3-11.1 12.8-24.6 12.8-38.4V318.6c0-3.9 2.6-7.3 6.4-8.2l5.3-1.3c11.9-3 20.3-13.7 20.3-26c0-7.1-2.8-13.9-7.8-18.9l-33.5-33.5c-3.7-3.7-3.7-9.7 0-13.4c5.7-5.7 14.1-7.7 21.8-5.1l12.5 4.2c13.2 4.4 27.6-1.6 33.9-14c3.2-6.3 9.6-10.3 16.7-10.3h76.4C475.5 81.6 375.3 0 256 0c-39.4 0-76.7 8.9-110 24.8z"]],
    "rainbow": [640, 512, [127752], "f75b", ["M320 192c-88.4 0-160 71.6-160 160v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V352c0-123.7 100.3-224 224-224s224 100.3 224 224v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V352c0-88.4-71.6-160-160-160z", "M64 352C64 210.6 178.6 96 320 96s256 114.6 256 256v96c0 17.7 14.3 32 32 32s32-14.3 32-32V352C640 175.3 496.7 32 320 32S0 175.3 0 352v96c0 17.7 14.3 32 32 32s32-14.3 32-32V352zm192 0c0-35.3 28.7-64 64-64s64 28.7 64 64v96c0 17.7 14.3 32 32 32s32-14.3 32-32V352c0-70.7-57.3-128-128-128s-128 57.3-128 128v96c0 17.7 14.3 32 32 32s32-14.3 32-32V352z"]],
    "circle-notch": [512, 512, [], "f1ce", ["M222.7 32.1c5 16.9-4.6 34.8-21.5 39.8C121.8 95.6 64 169.1 64 256c0 106 86 192 192 192s192-86 192-192c0-86.9-57.8-160.4-137.1-184.1c-16.9-5-26.6-22.9-21.5-39.8s22.9-26.6 39.8-21.5C434.9 42.1 512 140 512 256c0 141.4-114.6 256-256 256S0 397.4 0 256C0 140 77.1 42.1 182.9 10.6c16.9-5 34.8 4.6 39.8 21.5z", ""]],
    "tablet-screen-button": [448, 512, ["tablet-alt"], "f3fa", ["M0 64C0 28.7 28.7 0 64 0H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM256 448a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM384 64H64V384H384V64z", "M64 64H384V384H64V64z"]],
    "paw": [512, 512, [], "f1b0", ["M226.5 92.9c14.3 42.9-.3 86.2-32.6 96.8s-70.1-15.6-84.4-58.5s.3-86.2 32.6-96.8s70.1 15.6 84.4 58.5zM90.2 282.7c-24.5 14-59.7-.9-78.5-33.3S-2.7 179.3 21.8 165.3s59.7 .9 78.5 33.3s14.3 70.1-10.2 84.1zm331.7 0c-24.5-14-29.1-51.7-10.2-84.1s54-47.3 78.5-33.3s29.1 51.7 10.2 84.1s-54 47.3-78.5 33.3zM310.1 189.7c-32.3-10.6-46.9-53.9-32.6-96.8s52.1-69.1 84.4-58.5s46.9 53.9 32.6 96.8s-52.1 69.1-84.4 58.5z", "M69.2 401.2C121.6 259.9 214.7 224 256 224s134.4 35.9 186.8 177.2c3.6 9.7 5.2 20.1 5.2 30.5v1.6c0 25.8-20.9 46.7-46.7 46.7c-11.5 0-22.9-1.4-34-4.2l-88-22c-15.3-3.8-31.3-3.8-46.6 0l-88 22c-11.1 2.8-22.5 4.2-34 4.2C84.9 480 64 459.1 64 433.3v-1.6c0-10.4 1.6-20.8 5.2-30.5z"]],
    "message-question": [512, 512, [], "e1e3", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zm169.8 53.3l-.4 1.2c-4.4 12.5 2.1 26.2 14.6 30.6s26.2-2.1 30.6-14.6l.4-1.2c1.1-3.2 4.2-5.3 7.5-5.3h58.3c8.4 0 15.1 6.8 15.1 15.1c0 5.4-2.9 10.4-7.6 13.1l-44.3 25.4c-7.5 4.3-12.1 12.2-12.1 20.8V216c0 13.3 10.7 24 24 24c13.1 0 23.8-10.5 24-23.6l32.3-18.5c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1H222.6c-23.7 0-44.8 14.9-52.8 37.3zM288 304a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M222.6 80c-23.7 0-44.8 14.9-52.8 37.3l-.4 1.2c-4.4 12.5 2.1 26.2 14.6 30.6s26.2-2.1 30.6-14.6l.4-1.2c1.1-3.2 4.2-5.3 7.5-5.3h58.3c8.4 0 15.1 6.8 15.1 15.1c0 5.4-2.9 10.4-7.6 13.1l-44.3 25.4c-7.5 4.3-12.1 12.2-12.1 20.8V216c0 13.3 10.7 24 24 24c13.1 0 23.8-10.5 24-23.6l32.3-18.5c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1H222.6zM256 336a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "cloud": [640, 512, [9729], "f0c2", ["M0 336c0 79.5 64.5 144 144 144H512c70.7 0 128-57.3 128-128c0-61.9-44-113.6-102.4-125.4c4.1-10.7 6.4-22.4 6.4-34.6c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192c0 2.7 .1 5.4 .2 8.1C40.2 219.8 0 273.2 0 336z", ""]],
    "trowel-bricks": [512, 512, [], "e58a", ["M320 224H480c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H320c-17.7 0-32-14.3-32-32V256c0-17.7 14.3-32 32-32zM0 416c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V416zm192 0c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H224c-17.7 0-32-14.3-32-32V416z", "M256 32c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4l-192 96C6.8 104.8 0 115.9 0 128s6.8 23.2 17.7 28.6l192 96c9.9 5 21.7 4.4 31.1-1.4s15.2-16.1 15.2-27.2V152h89c3.6 13.8 16.1 24 31 24h88c26.5 0 48-21.5 48-48s-21.5-48-48-48H376c-14.9 0-27.4 10.2-31 24H256V32z"]],
    "square-3": [448, 512, [], "e258", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm88 96H280c9.9 0 18.8 6.1 22.4 15.3s1.1 19.7-6.2 26.4l-50.8 46.5c41.9 4.8 74.6 40.4 74.6 83.6c0 46.5-37.7 84.2-84.2 84.2H208c-30.1 0-58.1-15.6-73.9-41.2l-2.6-4.2c-7-11.3-3.5-26.1 7.8-33s26.1-3.5 33 7.8l2.6 4.2c7.1 11.5 19.6 18.4 33 18.4h27.8c20 0 36.2-16.2 36.2-36.2c0-20.1-16.3-36.3-36.4-36.2l-51.5 .3c-9.9 .1-18.9-6-22.5-15.2s-1.2-19.8 6.1-26.5L218.3 176H152c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M128 152c0-13.3 10.7-24 24-24H280c9.9 0 18.8 6.1 22.4 15.3s1.1 19.7-6.1 26.4l-50.8 46.5c41.9 4.8 74.6 40.4 74.6 83.6c0 46.5-37.7 84.2-84.2 84.2H208c-30.1 0-58.1-15.6-73.9-41.2l-2.6-4.2c-7-11.3-3.5-26.1 7.8-33s26.1-3.5 33 7.8l2.6 4.2c7.1 11.5 19.6 18.4 33 18.4h27.8c20 0 36.2-16.2 36.2-36.2c0-20.1-16.3-36.3-36.4-36.2l-51.5 .3c-9.9 .1-18.9-6-22.5-15.2s-1.2-19.8 6.1-26.5L218.3 176H152c-13.3 0-24-10.7-24-24z"]],
    "face-flushed": [512, 512, [128563, "flushed"], "f579", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 368H320c8.8 0 16 7.2 16 16s-7.2 16-16 16H192c-8.8 0-16-7.2-16-16s7.2-16 16-16zM88 224a72 72 0 1 1 144 0A72 72 0 1 1 88 224zm264-72a72 72 0 1 1 0 144 72 72 0 1 1 0-144z", "M160 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm192 0a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "hospital-user": [576, 512, [], "f80d", ["M0 48C0 21.5 21.5 0 48 0H272c26.5 0 48 21.5 48 48V271.8v95.9c-38.2 21.4-64 62.3-64 109.2c0 12.9 3.6 24.9 9.9 35.1H48c-26.5 0-48-21.5-48-48V384H144c8.8 0 16-7.2 16-16s-7.2-16-16-16H0V288H144c8.8 0 16-7.2 16-16s-7.2-16-16-16H0V48zM136 80v24H112c-8.8 0-16 7.2-16 16v16c0 8.8 7.2 16 16 16h24v24c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16V152h24c8.8 0 16-7.2 16-16V120c0-8.8-7.2-16-16-16H184V80c0-8.8-7.2-16-16-16H152c-8.8 0-16 7.2-16 16z", "M432 352a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm-50.9 32c-51.4 0-93.1 41.7-93.1 93.1c0 19.3 15.6 34.9 34.9 34.9H541.1c19.3 0 34.9-15.6 34.9-34.9c0-51.4-41.7-93.1-93.1-93.1H381.1z"]],
    "microwave": [576, 512, [], "e01b", ["M120 128c-13.3 0-24 10.7-24 24V328c0 13.3 10.7 24 24 24H392c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H120z", "M0 96C0 60.7 28.7 32 64 32H512c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64c0 17.7-14.3 32-32 32s-32-14.3-32-32H128c0 17.7-14.3 32-32 32s-32-14.3-32-32c-35.3 0-64-28.7-64-64V96zm96 56V328c0 13.3 10.7 24 24 24H392c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H120c-13.3 0-24 10.7-24 24zm400-40c-8.8 0-16 7.2-16 16V352c0 8.8 7.2 16 16 16s16-7.2 16-16V128c0-8.8-7.2-16-16-16z"]],
    "chf-sign": [640, 512, [], "e602", ["M224 32c17.7 0 32 14.3 32 32V224h96V64c0-17.7 14.3-32 32-32s32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V288H256V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64c0-17.7 14.3-32 32-32z", "M0 113.4C0 68.5 36.5 32 81.4 32c30.8 0 59 17.4 72.8 45l2.3 4.7c7.9 15.8 1.5 35-14.3 42.9s-35 1.5-42.9-14.3L97 105.6c-3-5.9-9-9.6-15.6-9.6C71.8 96 64 103.8 64 113.4V398.6c0 9.6 7.8 17.4 17.4 17.4c6.6 0 12.6-3.7 15.6-9.6l2.3-4.7c7.9-15.8 27.1-22.2 42.9-14.3s22.2 27.1 14.3 42.9l-2.3 4.7c-13.8 27.6-42 45-72.8 45C36.5 480 0 443.5 0 398.6V113.4zM448 64c0-17.7 14.3-32 32-32H608c17.7 0 32 14.3 32 32s-14.3 32-32 32H512V224h64c17.7 0 32 14.3 32 32s-14.3 32-32 32H512V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64z"]],
    "tent-arrow-left-right": [576, 512, [], "e57f", ["M268.6 166.5c11.5-8.7 27.3-8.7 38.8 0l168 128c6.6 5 11 12.5 12.3 20.7l24 160c1.4 9.2-1.3 18.6-7.4 25.6s-14.9 11.1-24.2 11.1H384L288 352V512H96c-9.3 0-18.2-4.1-24.2-11.1s-8.8-16.4-7.4-25.6l24-160c1.2-8.2 5.6-15.7 12.3-20.7l168-128z", "M454.2 7.9c8.9-9.9 24-10.7 33.9-1.8l80 72c5.1 4.6 7.9 11 7.9 17.8s-2.9 13.3-7.9 17.8l-80 72c-9.9 8.9-25 8.1-33.9-1.8s-8.1-25 1.8-33.9L489.5 120 86.5 120l33.5 30.2c9.9 8.9 10.7 24 1.8 33.9s-24 10.7-33.9 1.8l-80-72C2.9 109.3 0 102.8 0 96s2.9-13.3 7.9-17.8l80-72c9.9-8.9 25-8.1 33.9 1.8s8.1 25-1.8 33.9L86.5 72l402.9 0L455.9 41.8c-9.9-8.9-10.7-24-1.8-33.9z"]],
    "cart-circle-arrow-up": [640, 512, [], "e3f0", ["M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48H69.5c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5h121c-.5-5.3-.7-10.6-.7-16c0-10.9 1-21.6 2.9-32H199.7c-11.5 0-21.4-8.2-23.6-19.5L170.7 288H339.2c29.1-57 88.4-96 156.8-96c14.8 0 29.1 1.8 42.8 5.2L569.7 82.4C576.6 57 557.4 32 531.1 32h-411C111 12.8 91.6 0 69.5 0H24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96z", "M640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM428.7 348.7l56-56c6.2-6.2 16.4-6.2 22.6 0l56 56c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L512 342.6l0 89.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-89.4-28.7 28.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z"]],
    "trash-clock": [576, 512, [], "e2b0", ["M416 96H32L53.4 466.8c1.5 25.4 22.5 45.2 47.9 45.2H330.8C285.6 480.1 256 427.5 256 368c0-89.9 67.4-164 154.4-174.7L416 96z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H448V304c0-8.8-7.2-16-16-16z"]],
    "gavel": [512, 512, ["legal"], "f0e3", ["M249.4 217.4L168 298.7l-1.4-1.4c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3l48 48c12.5 12.5 32.8 12.5 45.3 0l112-112c12.5-12.5 12.5-32.8 0-45.3l-1.4-1.4 81.4-81.4-45.3-45.3z", "M273.4 9.4c12.5-12.5 32.8-12.5 45.3 0l16 16c12.5 12.5 12.5 32.8 0 45.3l-4 4L437.4 181.4l4-4c12.5-12.5 32.8-12.5 45.3 0l16 16c12.5 12.5 12.5 32.8 0 45.3l-120 120c-12.5 12.5-32.8 12.5-45.3 0l-16-16c-12.5-12.5-12.5-32.8 0-45.3l4-4L218.6 186.6l-4 4c-12.5 12.5-32.8 12.5-45.3 0l-16-16c-12.5-12.5-12.5-32.8 0-45.3l120-120z"]],
    "sprinkler-ceiling": [384, 512, [], "e44c", ["M112 344a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM64 408a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM24 448a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM224 344a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-32 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-80 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm184-88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-72 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm136-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z", "M0 96c0 15.3 10.8 28.4 25.7 31.4L128 147.8V82.6L64 69.8V0H0V96zm256 51.8l102.3-20.5c15-3 25.7-16.1 25.7-31.4V0H320V69.8L256 82.6v65.3zM224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32V192H96c-17.7 0-32 14.3-32 32s14.3 32 32 32h96 96c17.7 0 32-14.3 32-32s-14.3-32-32-32H224V64z"]],
    "browsers": [576, 512, [], "e0cb", ["M192 64a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM512 416c35.3 0 64-28.7 64-64l0-160L96 192V352c0 35.3 28.7 64 64 64l352 0z", "M160 0C124.7 0 96 28.7 96 64V192H576V64c0-35.3-28.7-64-64-64H160zm32 128a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm64-32c0-13.3 10.7-24 24-24H488c13.3 0 24 10.7 24 24s-10.7 24-24 24H280c-13.3 0-24-10.7-24-24zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120V376c0 75.1 60.9 136 136 136H456c13.3 0 24-10.7 24-24s-10.7-24-24-24H136c-48.6 0-88-39.4-88-88V120z"]],
    "trillium": [448, 512, [], "e588", ["M130.8 135.6c-1.8 8.1-2.8 16.3-2.8 24.4c0 15.7 3.8 30.4 10.4 43.5c-16.3 0-32.7 4.2-47.8 12.9c-6.3 3.6-12.2 7.9-17.7 12.8C26.4 196.4 7 161 0 144.3c-5.8-13.8 3-29.1 17.9-31c18.3-2.3 59.8-3.2 112.9 22.2zM375 229.2c-5.5-4.9-11.4-9.2-17.7-12.8c-15-8.7-31.5-12.8-47.7-12.9c6.6-13.1 10.4-27.8 10.4-43.5c0-8.2-1-16.3-2.8-24.4c53.1-25.4 94.6-24.5 112.9-22.2c14.9 1.9 23.7 17.1 17.9 31c-7 16.7-26.4 52.1-73 84.9zM169 390.8c6.1-2.2 12-4.9 17.5-8.1c16.6-9.6 29.2-23.3 37.4-39.2c8.1 15.8 20.8 29.6 37.4 39.2c5.6 3.2 11.5 5.9 17.7 8.2c-4.8 53.1-25.4 90.2-36 106.3c-9.1 13.7-28.8 13.7-37.9 0c-10.6-16-31.2-53.2-36-106.3z", "M214.1 8.9C189.6 31.8 128 95.9 128 160c0 15.7 3.8 30.4 10.4 43.5c-16.3 0-32.7 4.2-47.8 12.9c-55.5 32-80.2 117.5-87.8 150.2c-1.8 7.5 2.5 14.9 9.9 17.1c32.1 9.7 118.4 31.1 173.9-1c16.6-9.6 29.2-23.3 37.4-39.2c8.1 15.8 20.8 29.6 37.4 39.2c55.5 32 141.8 10.7 173.9 1c7.4-2.2 11.6-9.6 9.9-17.1c-7.6-32.7-32.3-118.1-87.8-150.2c-15-8.7-31.5-12.8-47.7-12.9c6.6-13.1 10.4-27.8 10.4-43.5c0-64.1-61.6-128.2-86.1-151.1c-5.6-5.3-14.1-5.3-19.8 0zM224 200a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]],
    "music-slash": [640, 512, [], "f8d1", ["M563.1 6.3c8.1 6 12.9 15.6 12.9 25.7v72V368c0 16.7-6.2 32.2-16.7 45.1L421.2 304.8C437.4 294.3 457.8 288 480 288c11.2 0 22 1.6 32 4.6V147L300.7 210.4 192.1 125.3c1.1-13 10-24.1 22.7-27.9l320-96c9.7-2.9 20.2-1.1 28.3 5zM192 247.3l64 50.4V432c0 44.2-43 80-96 80s-96-35.8-96-80s43-80 96-80c11.2 0 22 1.6 32 4.6V247.3z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "truck-ramp": [640, 512, [], "f4e0", ["M448 416a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z", "M416.7 402.5C423.4 338.2 477.9 288 544 288c38.2 0 72.5 16.8 96 43.3V0H416c-35.3 0-64 28.7-64 64V353.8L31.6 441.1c-17.1 4.6-27.1 22.2-22.5 39.3s22.2 27.1 39.3 22.5L416.7 402.5z"]],
    "binoculars": [512, 512, [], "f1e5", ["M96 64V96h96V64c0-17.7-14.3-32-32-32H128c-17.7 0-32 14.3-32 32zm224 0V96h96V64c0-17.7-14.3-32-32-32H352c-17.7 0-32 14.3-32 32zM288 96H224V256h64V96z", "M192 448V256h32V96H192 93c-16.4 0-30.2 12.5-31.8 28.8l-9 89.7c-2.7 27.3-11.5 53.7-25.6 77.3C9.2 320.7 0 353.8 0 387.6V448c0 17.7 14.3 32 32 32H160c17.7 0 32-14.3 32-32zm128 0c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32V387.6c0-33.8-9.2-66.9-26.5-95.8c-14.1-23.6-22.9-49.9-25.6-77.3l-9-89.7C449.2 108.5 435.5 96 419 96H320 288V256h32V448z"]],
    "microphone-slash": [640, 512, [], "f131", ["M401.3 412.2l-43.1-33.9C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128v-8.7L144.7 210c-.5 1.9-.7 3.9-.7 6v40c0 89.1 66.2 162.7 152 174.4V464H248c-13.3 0-24 10.7-24 24s10.7 24 24 24h72 72c13.3 0 24-10.7 24-24s-10.7-24-24-24H344V430.4c20.4-2.8 39.7-9.1 57.3-18.2zm70.8-67.5c15.2-26 23.9-56.3 23.9-88.7V216c0-13.3-10.7-24-24-24s-24 10.7-24 24v40c0 21.2-5.1 41.1-14.2 58.7l38.3 30zM408 294.5c5.2-11.8 8-24.8 8-38.5V96c0-53-43-96-96-96s-96 43-96 96v54.3L408 294.5z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "box-tissue": [512, 512, [], "e05b", ["M113.8 224H48c-26.5 0-48 21.5-48 48V384H512V272c0-26.5-21.5-48-48-48H405.3L384 288h48c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16s7.2-16 16-16h48l-14.2-64z", "M103.9 0H208c40 0 52 24 64 48s24 48 64 48h67.6c21.8 0 37.3 21.4 30.4 42.1L373.3 320H135.1L72.7 38.9C68.2 19 83.4 0 103.9 0zM512 384v80c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V384H512z"]],
    "circle-c": [512, 512, [], "e101", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM199.4 312.6c31.2 31.2 81.9 31.2 113.1 0c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-50 50-131 50-181 0s-50-131 0-181s131-50 181 0c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-31.2-31.2-81.9-31.2-113.1 0s-31.2 81.9 0 113.1z", "M312.6 199.4c-31.2-31.2-81.9-31.2-113.1 0s-31.2 81.9 0 113.1s81.9 31.2 113.1 0c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-50 50-131 50-181 0s-50-131 0-181s131-50 181 0c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0z"]],
    "star-christmas": [512, 512, [], "f7d4", ["M71 105c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l48 48c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L71 105zM441 105l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l48-48c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zm0 336c-9.4 9.4-24.6 9.4-33.9 0l-48-48c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l48 48c9.4 9.4 9.4 24.6 0 33.9zM71 407l48-48c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z", "M192 320L15.5 275.9C6.4 273.6 0 265.4 0 256s6.4-17.6 15.5-19.9L192 192 236.1 15.5C238.4 6.4 246.6 0 256 0s17.6 6.4 19.9 15.5L320 192l176.5 44.1c9.1 2.3 15.5 10.5 15.5 19.9s-6.4 17.6-15.5 19.9L320 320 275.9 496.5c-2.3 9.1-10.5 15.5-19.9 15.5s-17.6-6.4-19.9-15.5L192 320z"]],
    "chart-bullet": [512, 512, [], "e0e1", ["M160 64v64h80V64H160zm288 96H288v64H464c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48H288v64H448v32zm-288 0v64h80V160H160zM384 384v64h80c26.5 0 48-21.5 48-48V336c0-26.5-21.5-48-48-48H384v64h64v32H384zm-48-32V288H256v64h80zm0 32H256v64h80V384z", "M264 32c-13.3 0-24 10.7-24 24V232c0 13.3 10.7 24 24 24s24-10.7 24-24V56c0-13.3-10.7-24-24-24zM48 64C21.5 64 0 85.5 0 112v64c0 26.5 21.5 48 48 48H160V64H48zm0 224c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48H256V288H48zm336-8c0-13.3-10.7-24-24-24s-24 10.7-24 24V456c0 13.3 10.7 24 24 24s24-10.7 24-24V280z"]],
    "motorcycle": [640, 512, [127949], "f21c", ["M128 416c26.9 0 49.9-16.5 59.3-40h66.4C242.5 435.2 190.5 480 128 480C57.3 480 0 422.7 0 352s57.3-128 128-128c62.5 0 114.5 44.8 125.8 104H187.3c-9.5-23.5-32.5-40-59.3-40c-35.3 0-64 28.7-64 64s28.7 64 64 64zm256-64c0-40 18.4-75.7 47.1-99.2l31.6 58.4C453.5 322.3 448 336.5 448 352c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-2.4 0-4.8 .1-7.1 .4L473.3 230c12.2-3.9 25.2-6 38.7-6c70.7 0 128 57.3 128 128s-57.3 128-128 128s-128-57.3-128-128z", "M280 32c-13.3 0-24 10.7-24 24s10.7 24 24 24h57.7l16.4 30.3L256 192l-45.3-45.3c-12-12-28.3-18.7-45.3-18.7H64c-17.7 0-32 14.3-32 32v32h96c88.4 0 160 71.6 160 160c0 11-1.1 21.7-3.2 32h70.4c-2.1-10.3-3.2-21-3.2-32c0-52.2 25-98.6 63.7-127.8l75.2 139.2c6.3 11.7 20.9 16 32.5 9.7s16-20.9 9.7-32.5L418.2 128H480c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32H459.6c-7.5 0-14.7 2.6-20.5 7.4L391.7 78.9l-14-26c-7-12.9-20.5-21-35.2-21H280zM128 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "tree-christmas": [448, 512, [127876], "f7db", ["M195.3 105.9l2.1 .8L215 153.8c1.4 3.8 5 6.2 9 6.2s7.6-2.5 9-6.2l17.7-47.1 2.1-.8L418.8 313.5c3.4 4.2 5.2 9.4 5.2 14.8c0 13.1-10.6 23.7-23.7 23.7H368l76.2 122c2.5 4 3.8 8.5 3.8 13.2c0 13.7-11.1 24.9-24.9 24.9H24.9C11.1 512 0 500.9 0 487.1c0-4.7 1.3-9.2 3.8-13.2L80 352H47.7C34.6 352 24 341.4 24 328.3c0-5.4 1.8-10.6 5.2-14.8L195.3 105.9zM160 312a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM312 416a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z", "M150.2 71l47.1-17.7L215 6.2c1.4-3.8 5-6.2 9-6.2s7.6 2.5 9 6.2l17.7 47.1L297.8 71c3.8 1.4 6.2 5 6.2 9s-2.5 7.6-6.2 9l-47.1 17.7L233 153.8c-1.4 3.8-5 6.2-9 6.2s-7.6-2.5-9-6.2l-17.7-47.1L150.2 89c-3.8-1.4-6.2-5-6.2-9s2.5-7.6 6.2-9zM288 392a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "tire-flat": [512, 512, [], "f632", ["M239.9 350l0 65c-44.2-5.5-81.5-33.6-99.8-72.4l61.9-20.1c8.6 13.4 22.1 23.4 37.9 27.5zm32 0c15.9-4.1 29.4-14.1 38-27.6l61.9 20.1c-18.3 38.8-55.6 66.9-99.8 72.4l0-65zm47.9-58c.1-1.3 .1-2.7 .1-4c0-15.4-5.5-29.6-14.5-40.6l38.2-52.6C368.5 218.1 384 251.2 384 288c0 8.3-.8 16.3-2.3 24.2L319.9 292zm-40.2-63.5c-7.3-2.9-15.3-4.5-23.6-4.5s-16.3 1.6-23.6 4.5l-10-13.8-28.1-38.8C212.5 165.8 233.6 160 256 160s43.5 5.8 61.8 15.9l-38.2 52.6zm-73.1 18.9c-9.1 11-14.5 25.2-14.5 40.6c0 1.4 0 2.7 .1 4l-61.8 20.1c-1.5-7.8-2.3-15.9-2.3-24.2c0-36.8 15.5-69.9 40.3-93.3l28.1 38.7 10.1 13.9zM256 448a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM224 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M0 288C0 146.6 114.6 32 256 32s256 114.6 256 256c0 47.3-12.8 91.7-35.2 129.7c20.3 5.6 35.2 24.2 35.2 46.3c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48c0-22.1 14.9-40.7 35.2-46.3C12.8 379.7 0 335.3 0 288zm416 0c0-88.4-71.6-160-160-160s-160 71.6-160 160c0 52.3 25.1 98.8 64 128c26.7 20.1 60 32 96 32c33.1 0 63.9-10.1 89.5-27.3c2.2-1.5 4.4-3.1 6.6-4.7c38.9-29.2 64-75.7 64-128zM256 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "sunglasses": [576, 512, [128374], "f892", ["M192.9 303.6c10.5 2.8 20.8 6.3 30.5 10.4l-3.2 57.5c-1.9 33.9-29.9 60.4-63.9 60.4H112c-32.7 0-59.7-24.5-63.5-56.2l144.4-72.2zM356 374l141-70.5c10.7 2.8 21.1 6.4 31 10.7V368c0 35.3-28.7 64-64 64H419.7c-33.1 0-60.6-25.3-63.7-58z", "M118.6 80c-11.5 0-21.4 7.9-24 19.1L57.1 259.8c25.6-7.8 52.6-11.8 78.6-11.8c40.1 0 82.2 9.6 118.5 27.3c5.8 2.9 10.4 7.3 13.5 12.7h40.6c3.1-5.4 7.7-9.8 13.5-12.7c36.2-17.8 78.4-27.3 118.5-27.3c26 0 53 4.1 78.6 11.8L481.4 99.1c-2.6-11.2-12.6-19.1-24-19.1c-3.1 0-6.2 .6-9.2 1.8L416.9 94.3c-12.3 4.9-26.3-1.1-31.2-13.4s1.1-26.3 13.4-31.2l31.3-12.5c8.6-3.4 17.7-5.2 27-5.2c33.8 0 63.1 23.3 70.8 56.2l43.9 188c1.7 7.3 2.9 14.7 3.5 22.2c.3 1.8 .5 3.7 .5 5.6v5.2c0 .5 0 1 0 1.5V352c0 .2 0 .4 0 .6V368c0 61.9-50.1 112-112 112H419.7c-59.4 0-108.5-46.4-111.8-105.8L306.6 352H269.4l-1.2 22.2C264.9 433.6 215.8 480 156.3 480H112C50.1 480 0 429.9 0 368V352 310.7 304c0-1.9 .2-3.8 .5-5.7c.6-7.4 1.8-14.8 3.5-22.1l43.9-188C55.5 55.3 84.8 32 118.6 32c9.2 0 18.4 1.8 27 5.2l31.3 12.5c12.3 4.9 18.3 18.9 13.4 31.2s-18.9 18.3-31.2 13.4L127.8 81.8c-2.9-1.2-6-1.8-9.2-1.8zM48 352v16c0 35.3 28.7 64 64 64h44.3c34 0 62-26.5 63.9-60.5l3.2-57.5c-27.3-11.7-58.3-18-87.7-18c-29.5 0-60.5 6.4-87.7 18.2V352zm392.3-56c-29.4 0-60.4 6.3-87.7 18l3.2 57.5c1.9 33.9 29.9 60.5 63.9 60.5H464c35.3 0 64-28.7 64-64V314.2c-27.2-11.8-58.2-18.2-87.7-18.2z"]],
    "badge": [512, 512, [], "f335", ["M340.9 51.1C324.8 20.7 292.8 0 256 0s-68.8 20.7-84.9 51.1C138.2 41 101 49 75 75s-34 63.3-23.9 96.1C20.7 187.2 0 219.2 0 256s20.7 68.8 51.1 84.9C41 373.8 49 411 75 437s63.3 34 96.1 23.9C187.2 491.3 219.2 512 256 512s68.8-20.7 84.9-51.1C373.8 471 411 463 437 437s34-63.3 23.9-96.1C491.3 324.8 512 292.8 512 256s-20.7-68.8-51.1-84.9C471 138.2 463 101 437 75s-63.3-34-96.1-23.9z", ""]],
    "message-pen": [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zm340.8 59c-14.7-14.7-38.6-14.7-53.3 0L272.6 138l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3zM178.1 232.5c-4.1 4.1-7 9.2-8.4 14.9L160.5 284c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L250 160.6l-71.9 71.9z", "M287.5 123L272.6 138l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3s-38.6-14.7-53.3 0zM250 160.6l-71.9 71.9c-4.1 4.1-7 9.2-8.4 14.9L160.5 284c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L250 160.6z"]],
    "bell-concierge": [512, 512, [128718, "concierge-bell"], "f562", ["M216 64c-13.3 0-24 10.7-24 24s10.7 24 24 24h16v33.3c7.9-.8 15.9-1.3 24-1.3s16.1 .4 24 1.3V112h16c13.3 0 24-10.7 24-24s-10.7-24-24-24H256 216zM480 400H32 24c-13.3 0-24 10.7-24 24s10.7 24 24 24H488c13.3 0 24-10.7 24-24s-10.7-24-24-24h-8z", "M480 368c0-123.7-100.3-224-224-224S32 244.3 32 368v32H480V368z"]],
    "pen-ruler": [512, 512, ["pencil-ruler"], "f5ae", ["M249.4 103.4L204.2 58.3c-.3 .3-.6 .7-.9 1l-64 64c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l64-64c.3-.3 .7-.6 1-.9L161.9 16C143.2-2.7 112.8-2.7 94.1 16L16 94.1c-18.7 18.7-18.7 49.1 0 67.9l87.4 87.4L249.4 103.4zM408.6 262.6L262.6 408.6 350.1 496c18.7 18.7 49.1 18.7 67.9 0L496 417.9c18.7-18.7 18.7-49.1 0-67.9l-19.8-19.8c-.3 .3-.6 .7-.9 1l-64 64c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l64-64c.3-.3 .7-.6 1-.9l-45.1-45.1z", "M378.7 19.3L322.3 75.7 436.3 189.7l56.4-56.4c25-25 25-65.5 0-90.5L469.3 19.3c-25-25-65.5-25-90.5 0zm-79 79L44.9 353.2c-6.7 6.7-11.6 15.1-14.2 24.2L.9 481.4C-1.5 489.8 .9 498.8 7 505s15.2 8.5 23.6 6.1l104-29.7c9.2-2.6 17.5-7.5 24.2-14.2L413.7 212.3 299.7 98.3z"]],
    "arrow-progress": [512, 512, [], "e5df", ["M448 0a64 64 0 1 1 0 128A64 64 0 1 1 448 0zM64 384c23.7 0 44.4 12.9 55.4 32H160V401.9c0-9.9 8-17.9 17.9-17.9c4 0 7.8 1.3 11 3.8l60.8 47.3c4 3.1 6.3 7.9 6.3 12.9s-2.3 9.8-6.3 12.9l-60.8 47.3c-3.1 2.4-7 3.8-11 3.8c-9.9 0-17.9-8-17.9-17.9V480H119.4c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64s28.7-64 64-64z", "M256 110.1V96H128c-35.3 0-64 28.7-64 64s28.7 64 64 64H384c70.7 0 128 57.3 128 128c0 62.2-44.4 114.1-103.2 125.6C398.1 498 376.7 512 352 512c-35.3 0-64-28.7-64-64s28.7-64 64-64c22.2 0 41.7 11.3 53.2 28.4c24.9-8.7 42.8-32.5 42.8-60.4c0-35.3-28.7-64-64-64H128C57.3 288 0 230.7 0 160S57.3 32 128 32H256V17.9C256 8 264 0 273.9 0c4 0 7.8 1.3 11 3.8l60.8 47.3c4 3.1 6.3 7.9 6.3 12.9s-2.3 9.8-6.3 12.9l-60.8 47.3c-3.1 2.4-7 3.8-11 3.8c-9.9 0-17.9-8-17.9-17.9z"]],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", ["M272 416H48L4.8 473.6C1.7 477.8 0 482.8 0 488c0 13.3 10.7 24 24 24H296c13.3 0 24-10.7 24-24c0-5.2-1.7-10.2-4.8-14.4L272 416z", "M48 416L72 264 47 232.8c-4.5-5.7-7-12.7-7-20V112c0-8.8 7.2-16 16-16H80c8.8 0 16 7.2 16 16v24c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V112c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v24c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V112c0-8.8 7.2-16 16-16h24c8.8 0 16 7.2 16 16V212.8c0 7.3-2.5 14.3-7 20L248 264l24 152H48zm88-135.1c0 3.9 3.2 7.1 7.1 7.1h33.8c3.9 0 7.1-3.2 7.1-7.1V248c0-13.3-10.7-24-24-24s-24 10.7-24 24v32.9z"]],
    "square-root": [576, 512, [8730], "f697", ["M282.6 78.1c8-27.3 33-46.1 61.4-46.1H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H344L238.7 457c-3.6 12.3-14.1 21.2-26.8 22.8s-25.1-4.6-31.5-15.6L77.6 288H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H77.6c22.8 0 43.8 12.1 55.3 31.8l65.2 111.8L282.6 78.1z", ""]],
    "album-collection-circle-plus": [640, 512, [], "e48e", ["M56 0H456c13.3 0 24 10.7 24 24s-10.7 24-24 24H56C42.7 48 32 37.3 32 24S42.7 0 56 0zM12 176.2C21.1 165.9 34.2 160 48 160H464c13.8 0 26.9 5.9 36 16.2c4.2 4.8 7.4 10.3 9.4 16.3c-4.4-.3-8.9-.5-13.4-.5c-46.9 0-89.5 18.3-121 48.2C342.9 220.1 301.4 208 256 208C154.4 208 72 268.9 72 344s82.4 136 184 136c33.2 0 64.4-6.5 91.3-17.9c12.4 19.6 28.6 36.6 47.5 49.9H80c-24.2 0-44.6-18-47.6-42L.4 214c-1.7-13.7 2.5-27.4 11.6-37.7zM288 352c0 13.3-14.3 24-32 24s-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24zM16 104c0-13.3 10.7-24 24-24H472c13.3 0 24 10.7 24 24s-10.7 24-24 24H40c-13.3 0-24-10.7-24-24z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16v48H432c-8.8 0-16 7.2-16 16s7.2 16 16 16h48v48c0 8.8 7.2 16 16 16s16-7.2 16-16V384h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H512V304c0-8.8-7.2-16-16-16z"]],
    "people-arrows": [640, 512, ["people-arrows-left-right"], "e068", ["M192 64A64 64 0 1 0 64 64a64 64 0 1 0 128 0zM25.9 233.4l-4.1 49.3c-2.5 29.8 15.7 56.1 42.2 65.6V464c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V348.3c.6-.2 1.1-.4 1.7-.6L167 321c-9.4-9.4-9.4-24.6 0-33.9l62-62c-7.1-37.4-39.8-65.1-78.6-65.1H105.6c-41.6 0-76.3 31.9-79.7 73.4zM446.3 347.6c.6 .2 1.1 .4 1.7 .6V464c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V348.3c26.5-9.5 44.7-35.8 42.2-65.6l-4.1-49.3C610.7 191.9 576 160 534.4 160H489.6c-38.8 0-71.5 27.7-78.6 65.1l62 62c9.4 9.4 9.4 24.6 0 33.9l-26.7 26.7zM576 64A64 64 0 1 0 448 64a64 64 0 1 0 128 0z", "M257.2 217.8c9 3.7 14.8 12.5 14.8 22.2v32h96V240c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l64 64c9.4 9.4 9.4 24.6 0 33.9l-64 64c-6.9 6.9-17.2 8.9-26.2 5.2s-14.8-12.5-14.8-22.2V336H272v32c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-64-64c-9.4-9.4-9.4-24.6 0-33.9l64-64c6.9-6.9 17.2-8.9 26.2-5.2z"]],
    "face-angry-horns": [640, 512, [], "e368", ["M64 256a256 256 0 1 1 512 0A256 256 0 1 1 64 256zM402.7 411.9c6.6-5.9 7.1-16 1.2-22.6C387.8 371.4 359.7 352 320 352s-67.8 19.4-83.9 37.3c-5.9 6.6-5.4 16.7 1.2 22.6s16.7 5.4 22.6-1.2c11.7-13 31.6-26.7 60.1-26.7s48.4 13.7 60.1 26.7c5.9 6.6 16 7.1 22.6 1.2zM240.4 304c17.7 0 32-14.3 32-32c0-1.5-.1-3-.3-4.4l10.9 3.6c8.4 2.8 17.4-1.7 20.2-10.1s-1.7-17.4-10.1-20.2l-96-32c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2l30.7 10.2c-5.8 5.8-9.3 13.8-9.3 22.6c0 17.7 14.3 32 32 32zm192-32c0-8.9-3.6-17-9.5-22.8l30.2-10.1c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-96 32c-8.4 2.8-12.9 11.9-10.1 20.2s11.9 12.9 20.2 10.1l11.7-3.9c-.2 1.5-.3 3.1-.3 4.7c0 17.7 14.3 32 32 32s32-14.3 32-32z", "M566.1 185.1C550.5 131 517.6 84.3 473.8 51.3c17-3.3 39.7-8.6 63-15.5c29.8-8.9 59.1-20.2 78.4-33.1c5.4-3.6 12.4-3.6 17.8 0s8.1 10.1 6.8 16.4c-6.2 31-29.3 106.6-73.6 166zM103.3 35.8c23.3 7 46 12.2 63 15.5c-43.8 33-76.7 79.7-92.3 133.8C29.6 125.8 6.5 50.1 .3 19.1C-1 12.8 1.7 6.3 7.1 2.7s12.4-3.6 17.8 0c19.3 12.9 48.5 24.2 78.4 33.1zM240.4 304c-17.7 0-32-14.3-32-32c0-8.8 3.6-16.8 9.3-22.6l-30.7-10.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l96 32c8.4 2.8 12.9 11.9 10.1 20.2s-11.9 12.9-20.2 10.1l-10.9-3.6c.2 1.5 .3 2.9 .3 4.4c0 17.7-14.3 32-32 32zm192-32c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-1.6 .1-3.2 .3-4.7l-11.7 3.9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l96-32c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-30.2 10.1c5.9 5.8 9.5 13.9 9.5 22.8z"]],
    "mars-and-venus-burst": [640, 512, [], "e523", ["M176 8c6.6 0 12.4 4 14.9 10.1l29.4 74 76.2-23.1c6.3-1.9 13.1 .2 17.2 5.3c3 3.7 4.1 8.5 3.2 13C270.7 115.4 240 166.1 240 224c0 27.8 7.1 53.9 19.5 76.7l1.9 26.4c.5 6.5-3.1 12.7-9 15.5s-12.9 1.8-17.8-2.6L176 286.1l-58.6 53.9c-4.8 4.4-11.9 5.5-17.8 2.6s-9.5-9-9-15.5l5.6-79.4L17.6 235.4c-6.5-1-11.7-5.9-13.1-12.2s1.1-13 6.5-16.7l65.6-45.1L37 92.2c-3.3-5.7-2.7-12.8 1.4-17.9s10.9-7.2 17.2-5.3l76.2 23.1 29.4-74C163.6 12 169.4 8 176 8z", "M481.8 14.8C485.5 5.8 494.3 0 504 0H616c13.3 0 24 10.7 24 24V136c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-39-39-24.7 24.7C551 163.3 560 192.6 560 224c0 80.2-59.1 146.7-136.1 158.2c0 .6 .1 1.2 .1 1.8v.4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .3 .4 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3h24c13.3 0 24 10.7 24 24s-10.7 24-24 24H424v.2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0l-24 0-24 0v0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V486 486v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V485 485v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V484v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V483v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V481v-.1-.1-.1-.1-.1-.1-.1-.1V480v-.1-.1-.1-.1-.1-.1-.1V479v-.1-.1-.1-.1-.1-.1-.1V478v-.1-.1-.1-.1-.1-.1V477v-.1-.1-.1-.1-.1-.1V476v-.1-.1-.1-.1-.1-.1V475v-.1-.2-.2-.2-.2-.2V474v-.2-.2-.2-.2-.2V473v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V470v-.2-.2-.2-.2-.2V469v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V467v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V463v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V459v-.2-.2-.2-.2-.2-.2-.2-.2V457v-.2-.2-.2-.2V456H352c-13.3 0-24-10.7-24-24s10.7-24 24-24h24v-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3V403v-.3-.3V402v-.3-.3V401v-.3-.3V400v-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.4-.3-.4-.4-.4-.4V393v-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4V388v-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4V384c0-.6 0-1.2 .1-1.8C299.1 370.7 240 304.2 240 224c0-88.4 71.6-160 160-160c39.6 0 75.9 14.4 103.8 38.2L526.1 80 487 41c-6.9-6.9-8.9-17.2-5.2-26.2zM592 48l0 0h0v0zM400 488h24c0 13.3-10.7 24-24 24s-24-10.7-24-24h24zm96-264a96 96 0 1 0 -192 0 96 96 0 1 0 192 0z"]],
    "tombstone": [448, 512, [], "f720", ["M224 0C118 0 32 86 32 192V448H416V192C416 86 330 0 224 0zm24 152v40h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H248V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V240H152c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V152c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M248 152c0-13.3-10.7-24-24-24s-24 10.7-24 24v40H152c-13.3 0-24 10.7-24 24s10.7 24 24 24h48V360c0 13.3 10.7 24 24 24s24-10.7 24-24V240h48c13.3 0 24-10.7 24-24s-10.7-24-24-24H248V152zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "square-caret-right": [448, 512, ["caret-square-right"], "f152", ["M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM320 256c0 6.7-2.8 13-7.7 17.6l-112 104c-7 6.5-17.2 8.2-25.9 4.4s-14.4-12.5-14.4-22l0-208c0-9.5 5.7-18.2 14.4-22s18.9-2.1 25.9 4.4l112 104c4.9 4.5 7.7 10.9 7.7 17.6z", "M312.3 273.6c4.9-4.5 7.7-10.9 7.7-17.6s-2.8-13-7.7-17.6l-112-104c-7-6.5-17.2-8.2-25.9-4.4s-14.4 12.5-14.4 22l0 208c0 9.5 5.7 18.2 14.4 22s18.9 2.1 25.9-4.4l112-104z"]],
    "scissors": [512, 512, [9984, 9986, 9988, "cut"], "f0c4", ["M256 192l-39.5-39.5c4.9-12.6 7.5-26.2 7.5-40.5C224 50.1 173.9 0 112 0S0 50.1 0 112s50.1 112 112 112c14.3 0 27.9-2.7 40.5-7.5L192 256l64-64zm64 64l-64 64L396.8 460.8c28.3 28.3 74.1 28.3 102.4 0c7.1-7.1 7.1-18.5 0-25.6L320 256zM112 160a48 48 0 1 1 0-96 48 48 0 1 1 0 96z", "M216.5 359.5L499.2 76.8c7.1-7.1 7.1-18.5 0-25.6c-28.3-28.3-74.1-28.3-102.4 0L152.5 295.5c-12.6-4.9-26.2-7.5-40.5-7.5C50.1 288 0 338.1 0 400s50.1 112 112 112s112-50.1 112-112c0-14.3-2.7-27.9-7.5-40.5zM64 400a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"]],
    "list-music": [512, 512, [], "f8c9", ["M0 96C0 78.3 14.3 64 32 64H256c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 128 0 113.7 0 96zM0 224c0-17.7 14.3-32 32-32H256c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32zM0 352c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z", "M512 32c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-96 32C360.8 38 352 50.2 352 64v64V359.7c-14.5-4.9-30.8-7.7-48-7.7c-61.9 0-112 35.8-112 80s50.1 80 112 80s112-35.8 112-80V151.1l74.1-24.7C503.2 122 512 109.8 512 96V32z"]],
    "sun-plant-wilt": [640, 512, [], "e57a", ["M174.6 9.5C172 3.7 166.3 0 160 0s-12 3.7-14.6 9.5L120.6 64.9 63.9 43.2c-5.9-2.3-12.6-.8-17 3.6s-5.9 11.1-3.6 17l21.7 56.7L9.5 145.4C3.7 148 0 153.7 0 160s3.7 12 9.5 14.6l55.4 24.8L43.2 256.1c-2.3 5.9-.8 12.6 3.6 17s11.1 5.9 17 3.6l56.7-21.7 24.8 55.4c2.6 5.8 8.3 9.5 14.6 9.5s12-3.7 14.6-9.5l24.8-55.4 56.7 21.7c5.9 2.3 12.6 .8 17-3.6s5.9-11.1 3.6-17l-21.7-56.7 55.4-24.8c5.8-2.6 9.5-8.3 9.5-14.6s-3.7-12-9.5-14.6l-55.4-24.8 21.7-56.7c2.3-5.9 .8-12.6-3.6-17s-11.1-5.9-17-3.6L199.4 64.9 174.6 9.5zM96 160a64 64 0 1 1 128 0A64 64 0 1 1 96 160zm64 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M536 144c-17.7 0-32 14.3-32 32v96 8V448H608c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H456V280v-8c0-17.7-14.3-32-32-32s-32 14.3-32 32v21.4c14.8 7.7 24 23.1 24 44.6c0 16.6-16 43.9-37.4 67.2c-5.7 6.2-15.5 6.2-21.2 0C336 382 320 354.9 320 338c0-21.5 9.2-37 24-44.6V272c0-44.2 35.8-80 80-80c11.4 0 22.2 2.4 32 6.7V176c0-44.2 35.8-80 80-80s80 35.8 80 80v53.4c14.8 7.7 24 23.1 24 44.6c0 16.6-16 43.9-37.4 67.2c-5.7 6.2-15.5 6.2-21.2 0C560 318 544 290.9 544 274c0-21.5 9.2-37 24-44.6V176c0-17.7-14.3-32-32-32z"]],
    "toilets-portable": [576, 512, [], "e584", ["M24 64H0V88 488c0 13.3 10.7 24 24 24s24-10.7 24-24v-8H208v8c0 13.3 10.7 24 24 24s24-10.7 24-24V88 64H232 24zM192 224c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V240c0-8.8 7.2-16 16-16zM344 64H320V88 488c0 13.3 10.7 24 24 24s24-10.7 24-24v-8H528v8c0 13.3 10.7 24 24 24s24-10.7 24-24V88 64H552h-8H352h-8zM512 224c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V240c0-8.8 7.2-16 16-16z", "M32 0C14.3 0 0 14.3 0 32V64H256V32c0-17.7-14.3-32-32-32H32zM352 0c-17.7 0-32 14.3-32 32V64H576V32c0-17.7-14.3-32-32-32H352zM192 224c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16s16-7.2 16-16V240c0-8.8-7.2-16-16-16zm336 16c0-8.8-7.2-16-16-16s-16 7.2-16 16v64c0 8.8 7.2 16 16 16s16-7.2 16-16V240z"]],
    "hockey-puck": [512, 512, [], "f453", ["M512 160c0 53-114.6 96-256 96S0 213 0 160s114.6-96 256-96s256 43 256 96z", "M256 256c141.4 0 256-43 256-96V352c0 53-114.6 96-256 96S0 405 0 352V160c0 53 114.6 96 256 96z"]],
    "mustache": [640, 512, [], "e5bc", ["M193.4 194.9c16.4-12.3 36.3-18.9 56.8-18.9c26.6 0 51.9 11.2 69.8 30.7c17.9-19.5 43.2-30.7 69.8-30.7c20.5 0 40.4 6.6 56.8 18.9l13.1 9.8c16.7 12.5 37 19.3 57.8 19.3c15 0 29.7-3.5 43.1-10.2l8.3-4.1c1.9-1 4-1.5 6-1.7c1.8-.1 3.6 0 5.4 .5c.3 .1 .5 .2 .8 .2c2.2 .7 4.1 1.9 5.7 3.3c1.2 1.1 2.2 2.3 3 3.7c.4 .6 .7 1.3 1 1.9c.6 1.5 1 2.9 1.1 4.4c.2 2.2 0 4.5-.7 6.8c-9.4 28.3-32.9 54.7-58.8 73.8c-25.8 19-57.3 33.1-85 33.1c-16.4 0-34.4-4.7-50.1-11.2c-15.6-6.5-30.6-15.5-40.6-25.5c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0c6 6 17 13 30.3 18.5c13.2 5.5 26.9 8.8 37.8 8.8c18.2 0 43-9.9 66-26.9c9.5-7 18.1-14.8 25.4-22.9c-7 1.2-14.2 1.8-21.4 1.8c-27.8 0-54.8-9-77-25.7l-13.1-9.8c-10.8-8.1-24-12.5-37.6-12.5c-19 0-37 8.6-48.9 23.5l-8.2 10.2c-.4 .6-.9 1.1-1.4 1.6c-1.3 1.3-2.8 2.4-4.5 3.1c-4.4 2.1-9.4 2-13.7 0c-1.6-.8-3.1-1.8-4.5-3.1c-.5-.5-1-1-1.4-1.6l-8.2-10.2c-11.9-14.9-29.9-23.5-48.9-23.5c-13.6 0-26.7 4.4-37.6 12.5l-13.1 9.8c-22.2 16.7-49.3 25.7-77 25.7c-7.2 0-14.3-.6-21.4-1.8c7.3 8.1 16 15.9 25.4 22.9c23 17 47.9 26.9 66 26.9c10.9 0 24.6-3.3 37.8-8.8c13.3-5.5 24.3-12.5 30.3-18.5c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-10 10-25 19-40.6 25.5C227 331.3 209 336 192.6 336c-27.7 0-59.2-14.1-85-33.1c-25.9-19.1-49.3-45.5-58.8-73.7c-.1-.4-.2-.8-.3-1.2c-.4-1.5-.6-3.1-.5-4.6c.1-2.2 .6-4.4 1.7-6.5c1-2.1 2.4-3.8 4.1-5.2c1.3-1.1 2.9-2 4.6-2.7c.3-.1 .7-.2 1-.3c3.8-1.1 7.7-.8 11.1 .7c.2 .1 .5 .2 .7 .3l8.2 4.1c13.4 6.7 28.1 10.2 43.1 10.2c20.9 0 41.2-6.8 57.8-19.3l13.1-9.8z", "M231 112c-31.6 0-61.7 13.2-83.1 36.4l-2 2.1c-27.6 29.9-74.6 30.9-103.4 2.1L41 151c-2.5-2.5-5.5-4.4-8.6-5.5c-2.6-1-5.4-1.5-8.4-1.5c-3.6 0-7.1 .8-10.2 2.3c-1.7 .8-3.3 1.8-4.8 3c-1.5 1.2-2.9 2.7-4.1 4.2c-.7 1-1.4 2-2 3C1.1 159.9 0 163.8 0 168v39.4C0 313.8 86.2 400 192.6 400c46.7 0 91.7-16.9 126.9-47.7l.5-.4 .5 .4c35.1 30.7 80.2 47.7 126.9 47.7C553.8 400 640 313.8 640 207.4V168c0-4-1-7.8-2.7-11.2c-.2-.5-.5-.9-.8-1.4c-.2-.4-.5-.8-.7-1.1c-.3-.5-.7-1-1.1-1.4c-1.1-1.3-2.3-2.5-3.6-3.6c-4.1-3.3-9.3-5.2-15-5.2c-2.9 0-5.8 .5-8.4 1.5c-3.1 1.2-6.1 3-8.6 5.5l-1.6 1.6c-28.8 28.8-75.8 27.9-103.4-2.1l-2-2.1C470.7 125.2 440.6 112 409 112c-33 0-64.4 14.4-85.9 39.5l-3.1 3.6-3.1-3.6C295.4 126.4 264 112 231 112zm19.2 64c26.6 0 51.9 11.2 69.8 30.7c17.9-19.5 43.2-30.7 69.8-30.7c20.5 0 40.4 6.6 56.8 18.9l13.1 9.8c16.7 12.5 37 19.3 57.8 19.3c15 0 29.7-3.5 43.1-10.2l8.3-4.1c1.9-1 4-1.5 6-1.7c1.8-.1 3.6 0 5.4 .5c.3 .1 .5 .2 .8 .2c2.2 .7 4.1 1.9 5.7 3.3c1.2 1.1 2.2 2.3 3 3.7c.4 .6 .7 1.3 1 1.9c.6 1.5 1 2.9 1.1 4.4c.2 2.2 0 4.5-.7 6.8c-9.4 28.3-32.9 54.7-58.8 73.8c-25.8 19-57.3 33.1-85 33.1c-16.4 0-34.4-4.7-50.1-11.2c-15.6-6.5-30.6-15.5-40.6-25.5c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0c6 6 17 13 30.3 18.5c13.2 5.5 26.9 8.8 37.8 8.8c18.2 0 43-9.9 66-26.9c9.5-7 18.1-14.8 25.4-22.9c-7 1.2-14.2 1.8-21.4 1.8c-27.8 0-54.8-9-77-25.7l-13.1-9.8c-10.8-8.1-24-12.5-37.6-12.5c-19 0-37 8.6-48.9 23.5l-8.2 10.2c-.4 .6-.9 1.1-1.4 1.6c-1.3 1.3-2.8 2.4-4.5 3.1c-4.4 2.1-9.4 2-13.7 0c-1.6-.8-3.1-1.8-4.5-3.1c-.5-.5-1-1-1.4-1.6l-8.2-10.2c-11.9-14.9-29.9-23.5-48.9-23.5c-13.6 0-26.7 4.4-37.6 12.5l-13.1 9.8c-22.2 16.7-49.3 25.7-77 25.7c-7.2 0-14.3-.6-21.4-1.8c7.3 8.1 16 15.9 25.4 22.9c23 17 47.9 26.9 66 26.9c10.9 0 24.6-3.3 37.8-8.8c13.3-5.5 24.3-12.5 30.3-18.5c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-10 10-25 19-40.6 25.5C227 331.3 209 336 192.6 336c-27.7 0-59.2-14.1-85-33.1c-25.9-19.1-49.3-45.5-58.8-73.7c-.1-.4-.2-.8-.3-1.2c-.4-1.5-.6-3.1-.5-4.6c.1-2.2 .6-4.4 1.7-6.5c1-2.1 2.4-3.8 4.1-5.2c1.3-1.1 2.9-2 4.6-2.7c.3-.1 .7-.2 1-.3c3.8-1.1 7.7-.8 11.1 .7c.2 .1 .5 .2 .7 .3l8.2 4.1c13.4 6.7 28.1 10.2 43.1 10.2c20.9 0 41.2-6.8 57.8-19.3l13.1-9.8c16.4-12.3 36.3-18.9 56.8-18.9z"]],
    "hyphen": [320, 512, [], "2d", ["M0 256c0-17.7 14.3-32 32-32H288c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z", ""]],
    "table": [512, 512, [], "f0ce", ["M224 320v96h64V320l160 0V256l-160 0V160H224v96L64 256v64l160 0z", "M64 160V416H448V160H64zM0 96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96z"]],
    "user-chef": [448, 512, [], "e3d2", ["M96 160H352c0 70.7-57.3 128-128 128s-128-57.3-128-128z", "M384 48c0 20.9-13.4 38.7-32 45.3V112v48H320 304 144 128 96V112 93.3C77.4 86.7 64 68.9 64 48C64 21.5 85.5 0 112 0c14.3 0 27.2 6.3 36 16.3C156.8 6.3 169.7 0 184 0c16.7 0 31.4 8.5 40 21.5C232.6 8.5 247.3 0 264 0c14.3 0 27.2 6.3 36 16.3C308.8 6.3 321.7 0 336 0c26.5 0 48 21.5 48 48zM178.4 340.6c7.5 1.9 8.2 12.3 1 15.2l-43.2 17.3C111.9 382.8 96 406.3 96 432.5V480v24 8H88 64 25.6C11.5 512 0 500.5 0 486.4c0-58.8 37.7-108.8 90.3-127c3.3-1.2 5.7-4.3 5.7-7.8V330.2c0-5.2 4.9-9 9.9-7.8l72.5 18.1zM352 512H160 136h-8v-8V480 432.5c0-13.1 8-24.9 20.1-29.7L341 325.6c5.3-2.1 11 1.8 11 7.4v18.6c0 3.5 2.3 6.6 5.7 7.8c52.6 18.2 90.3 68.2 90.3 127c0 14.1-11.5 25.6-25.6 25.6H352zM224 432a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "message-image": [512, 512, ["comment-alt-image"], "e1e0", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zm176 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm120 0c-8 0-15.5 4-20 10.7l-56 84L202.7 201c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6h80 48H392c8.9 0 17-4.9 21.2-12.7s3.7-17.3-1.2-24.6l-96-144C311.5 132 304 128 296 128z", "M144 160a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm172-21.3C311.5 132 304 128 296 128s-15.5 4-20 10.7l-56 84L202.7 201c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6h80 48H392c8.9 0 17-4.9 21.2-12.7s3.7-17.3-1.2-24.6l-96-144z"]],
    "users-medical": [640, 512, [], "f830", ["M64 80a80 80 0 1 1 160 0A80 80 0 1 1 64 80zm368 0a80 80 0 1 1 160 0A80 80 0 1 1 432 80zM106.7 192h42.7c15.9 0 31 3.5 44.6 9.7c-1.3 7.2-1.9 14.7-1.9 22.3c0 38.2 16.8 72.5 43.3 96c-.2 0-.4 0-.7 0H21.3C9.6 320 0 310.4 0 298.7C0 239.8 47.8 192 106.7 192zm298 128c26.6-23.5 43.3-57.8 43.3-96c0-7.6-.7-15-1.9-22.3c13.6-6.3 28.7-9.7 44.6-9.7h42.7C592.2 192 640 239.8 640 298.7c0 11.8-9.6 21.3-21.3 21.3H605.3c-6.6-18.6-24.4-32-45.3-32H528c-20.9 0-38.7 13.4-45.3 32H405.3c-.2 0-.4 0-.7 0zm28.2 43.5C422.5 372.3 416 385.4 416 400v32c0 26.5 21.5 48 48 48h16v16c0 5.6 1 11 2.7 16H154.7c-14.7 0-26.7-11.9-26.7-26.7C128 411.7 187.7 352 261.3 352H378.7c19.3 0 37.6 4.1 54.2 11.5zM320 128a96 96 0 1 1 0 192 96 96 0 1 1 0-192z", "M528 320c-8.8 0-16 7.2-16 16v48l-48 0c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h48v48c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V448h48c8.8 0 16-7.2 16-16V400c0-8.8-7.2-16-16-16l-48 0V336c0-8.8-7.2-16-16-16H528z"]],
    "sensor-triangle-exclamation": [640, 512, ["sensor-alert"], "e029", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64v32c-26.4 0-50.7 14.2-63.7 37.1L233.9 430c-6.5 11.5-9.9 24.5-9.9 37.7c0 4.2 .3 8.3 1 12.3H64c-35.3 0-64-28.7-64-64V96zm88 0c-13.3 0-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V120c0-13.3-10.7-24-24-24zm96 0c-13.3 0-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V120c0-13.3-10.7-24-24-24z", "M412.2 180.9l-150.4 265c-3.8 6.7-5.8 14.2-5.8 21.9c0 24.5 19.8 44.3 44.3 44.3H595.7c24.5 0 44.3-19.8 44.3-44.3c0-7.7-2-15.2-5.8-21.9l-150.4-265C476.5 168 462.8 160 448 160s-28.5 8-35.8 20.9zM448 256c8.8 0 16 7.2 16 16v88c0 8.8-7.2 16-16 16s-16-7.2-16-16V272c0-8.8 7.2-16 16-16zM424 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "magnifying-glass-arrow-right": [512, 512, [], "e521", ["M208 416A208 208 0 1 0 208 0a208 208 0 1 0 0 416zm33-297l72 72c9.4 9.4 9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31H120c-13.3 0-24-10.7-24-24s10.7-24 24-24H238.1l-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0z", "M241 119c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l31 31H120c-13.3 0-24 10.7-24 24s10.7 24 24 24H238.1l-31 31c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9l-72-72zM457.4 502.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L376 330.7C363.3 348 348 363.3 330.7 376L457.4 502.6z"]],
    "tachograph-digital": [640, 512, ["digital-tachograph"], "f566", ["M64 64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H576c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zm32 64H320c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32zM64 368c0-8.8 7.2-16 16-16H336c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16zm320 0c0-8.8 7.2-16 16-16H560c8.8 0 16 7.2 16 16s-7.2 16-16 16H400c-8.8 0-16-7.2-16-16zM80 288a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z", "M96 128c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H96zM80 352c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H80zm320 0c-8.8 0-16 7.2-16 16s7.2 16 16 16H560c8.8 0 16-7.2 16-16s-7.2-16-16-16H400z"]],
    "face-mask": [576, 512, [], "e37f", ["M542 224.1c-1.5 .2-3.1 .6-4.5 1.3L423.1 276.2C414.4 264 400.2 256 384 256H192c-16.2 0-30.4 8-39.1 20.2L38.5 225.4c-1.5-.7-3-1.1-4.5-1.3C49.7 97.8 157.4 0 288 0S526.3 97.8 542 224.1zm2 33.4c-.3 47.9-13.7 92.7-36.9 131c-2.9-2.8-6.8-4.5-11.1-4.5H432V307.3l112-49.8zM487.9 416c-46.9 58.5-119 96-199.9 96s-152.9-37.5-199.9-96h58.6c6.6 18.6 24.4 32 45.3 32H384c20.9 0 38.7-13.4 45.3-32h58.6zm-419-27.5c-23.2-38.2-36.6-83-36.9-131l112 49.8V384H80c-4.3 0-8.2 1.7-11.1 4.5zM240 176c8.8 0 16-7.2 16-16s-7.2-16-16-16c-55.4 0-93.6 23-107.3 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0C162.9 195.7 193 176 240 176zm180.7 27.3c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6C429.6 167 391.4 144 336 144c-8.8 0-16 7.2-16 16s7.2 16 16 16c47 0 77.1 19.7 84.7 27.3z", "M38.5 225.4c-8.1-3.6-17.5 0-21.1 8.1s0 17.5 8.1 21.1L144 307.3V384H80c-8.8 0-16 7.2-16 16s7.2 16 16 16h66.7c6.6 18.6 24.4 32 45.3 32H384c20.9 0 38.7-13.4 45.3-32H496c8.8 0 16-7.2 16-16s-7.2-16-16-16H432V307.3l118.5-52.7c8.1-3.6 11.7-13 8.1-21.1s-13-11.7-21.1-8.1L423.1 276.2C414.4 264 400.2 256 384 256H192c-16.2 0-30.4 8-39.1 20.2L38.5 225.4zM208 304H368c8.8 0 16 7.2 16 16s-7.2 16-16 16H208c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64H368c8.8 0 16 7.2 16 16s-7.2 16-16 16H208c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "pickleball": [576, 512, [], "e435", ["M432 512a128 128 0 1 0 0-256 128 128 0 1 0 0 256zM352 384a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm80 80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0-64a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm96 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-80-80a16 16 0 1 1 0-32 16 16 0 1 1 0 32z", "M386.3 28c-37.5-37.4-98.4-37.4-136 0L84.9 193c-18.4 18.3-23.8 45.8-13.9 69.7l24.2 57.9c10 23.9 4.5 51.5-13.9 69.8L27.8 443.8c-15.6 15.6-15.7 40.9 0 56.5s41 15.6 56.7 0l53.8-53.6c18.3-18.2 45.7-23.7 69.6-13.9l56.7 23.2c8.7 3.6 17.9 5.1 26.9 4.7C279.1 437.9 272 411.8 272 384c0-3.3 .1-6.5 .3-9.8L133.1 235.5c-6.3-6.2-6.3-16.4 0-22.6s16.4-6.3 22.6 0L279.3 336.1C299.7 271.1 360.3 224 432 224c32.1 0 62 9.4 87 25.7c16.7-35.5 10.3-79.1-19.1-108.4L386.3 28z"]],
    "star-sharp-half": [576, 512, [], "e28c", ["M321.6 50.4l40 125.6H485.7 488h13.3H520c10.3 0 19.4 6.5 22.7 16.2s.1 20.4-8 26.7L520 230.4l-10.5 8.2-1.8 1.4L403.9 320.7l40.1 126 1.1 3.5 4.7 14.8 5 15.7c3.2 10-.5 21-9.1 27s-20.2 5.7-28.5-.7l-13-10.1L392 487.3l-2.9-2.3L288 406.4V325.3 155.9 0c10.5 0 19.7 6.8 22.9 16.7L316 32.9l0 0 4.6 14.3 1 3.2z", "M254.4 50.4L214.5 176H90.3 88 74.7 56c-10.3 0-19.4 6.5-22.7 16.2s-.1 20.4 8 26.7L56 230.4l10.5 8.2 1.8 1.4 103.7 80.7L132 446.7l-1.1 3.5L126.1 465l-5 15.7c-3.2 10 .5 21 9.1 27s20.2 5.7 28.5-.7l13-10.1 12.3-9.5 2.9-2.3L288 406.4V325.3 155.9 0c-10.5 0-19.7 6.8-22.9 16.7L260 32.9l0 0-4.6 14.3-1 3.2z"]],
    "users-slash": [640, 512, [], "e073", ["M440.6 320L420 303.9c17.5-21.9 28-49.7 28-79.9c0-7.6-.7-15-1.9-22.3c13.6-6.3 28.7-9.7 44.6-9.7h42.7C592.2 192 640 239.8 640 298.7c0 11.8-9.6 21.3-21.3 21.3H440.6zm-45.7-35.8L243.7 165.7C261.3 142.8 288.9 128 320 128c53 0 96 43 96 96c0 22.8-7.9 43.7-21.2 60.2zM203.1 133.9L77.5 35.5C91.9 14.1 116.3 0 144 0c44.2 0 80 35.8 80 80c0 20.8-7.9 39.7-20.9 53.9zM106.7 192h15.2l72.6 57.2c5.6 27.9 20.3 52.6 40.8 70.8c-.2 0-.4 0-.7 0H21.3C9.6 320 0 310.4 0 298.7C0 239.8 47.8 192 106.7 192zM261.3 352h63.6L509.2 497.2c-4.4 8.8-13.4 14.8-23.9 14.8H154.7c-14.7 0-26.7-11.9-26.7-26.7C128 411.7 187.7 352 261.3 352zM512 0a80 80 0 1 1 0 160A80 80 0 1 1 512 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "clover": [448, 512, [], "e139", ["M173.3 32C139.4 32 112 59.4 112 93.3v4.9c0 12 3.3 23.7 9.4 34l31.9 53.2-53.2-31.9c-10.3-6.2-22-9.4-34-9.4H61.3C27.4 144 0 171.4 0 205.3c0 16.2 6.5 31.8 17.9 43.3l7.4 7.4-7.4 7.4C6.5 274.9 0 290.5 0 306.7C0 340.6 27.4 368 61.3 368h4.9c12 0 23.7-3.3 34-9.4l53.2-31.9-31.9 53.2c-6.2 10.3-9.4 22-9.4 34v4.9c0 33.8 27.4 61.3 61.3 61.3c16.2 0 31.8-6.5 43.3-17.9l7.4-7.4 7.4 7.4c11.5 11.5 27.1 17.9 43.3 17.9c33.8 0 61.3-27.4 61.3-61.3v-4.9c0-12-3.3-23.7-9.4-34l-31.9-53.2 53.2 31.9c10.3 6.2 22 9.4 34 9.4h4.9c33.8 0 61.3-27.4 61.3-61.3c0-16.2-6.5-31.8-17.9-43.3l-7.4-7.4 7.4-7.4c11.5-11.5 17.9-27.1 17.9-43.3c0-33.8-27.4-61.3-61.3-61.3h-4.9c-12 0-23.7 3.3-34 9.4l-53.2 31.9 31.9-53.2c6.2-10.3 9.4-22 9.4-34V93.3C336 59.4 308.6 32 274.7 32c-16.2 0-31.8 6.5-43.3 17.9L224 57.4l-7.4-7.4C205.1 38.5 189.5 32 173.3 32z", ""]],
    "meat": [512, 512, [127830], "f814", ["M343.9 168.1c-15.3-15.3-20.4-34.9-11.5-43.8s28.5-3.7 43.8 11.5s20.4 34.9 11.5 43.8s-28.5 3.7-43.8-11.5zm-220 146.5l6.3-6.3c7.9 36.7 36.8 65.6 73.5 73.5l-6.3 6.3c-12.3 12.3-11.4 32.5-7.2 49.4c1.1 4.6 1.8 9.5 1.8 14.5c0 33.1-26.9 60-60 60s-60-26.9-60-60c0-6.3-5.7-12-12-12c-33.1 0-60-26.9-60-60s26.9-60 60-60c5 0 9.8 .6 14.5 1.8c16.9 4.2 37.1 5.2 49.4-7.2z", "M243.6 19.6C283.7-20.4 371.9 2.8 440.5 71.5s91.9 156.8 51.8 196.9l-40.5 40.5C403.9 357 338.7 384 270.8 384H224c-53 0-96-43-96-96V241.3c0-67.9 27-133 75-181l40.7-40.7zm64 184.8c49.6 49.6 113.3 66.4 142.2 37.4s12.2-92.6-37.4-142.2S299.1 33.2 270.2 62.2s-12.2 92.6 37.4 142.2z"]],
    "reply": [512, 512, [61714, "mail-reply"], "f3e5", ["M224 288V128H336c97.2 0 176 78.8 176 176c0 113.3-81.5 163.9-100.2 174.1c-2.5 1.4-5.3 1.9-8.1 1.9c-10.9 0-19.7-8.9-19.7-19.7c0-7.5 4.3-14.4 9.8-19.5c9.4-8.8 22.2-26.4 22.2-56.7c0-53-43-96-96-96H224z", "M224 64c0-12.6-7.4-24.1-19-29.2s-25-3-34.4 5.4l-160 144C3.9 190.3 0 198.9 0 208s3.9 17.7 10.6 23.8l160 144c9.4 8.5 22.9 10.6 34.4 5.4s19-16.6 19-29.2V64z"]],
    "star-and-crescent": [512, 512, [9770], "f699", ["M375.4 137.4c3.5-7.1 13.7-7.1 17.2 0l31.5 63.8c1.4 2.8 4.1 4.8 7.2 5.3l70.4 10.2c7.9 1.1 11 10.8 5.3 16.4l-50.9 49.6c-2.3 2.2-3.3 5.4-2.8 8.5l12 70.1c1.3 7.8-6.9 13.8-13.9 10.1l-63-33.1c-2.8-1.5-6.1-1.5-8.9 0l-63 33.1c-7 3.7-15.3-2.3-13.9-10.1l12-70.1c.5-3.1-.5-6.3-2.8-8.5L261 233.1c-5.7-5.6-2.6-15.2 5.3-16.4l70.4-10.2c3.1-.5 5.8-2.4 7.2-5.3l31.5-63.8z", "M256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c33 0 64.6-6.3 93.6-17.7c7.4-2.9 11.5-10.7 9.8-18.4s-8.8-13-16.7-12.4c-4.8 .3-9.7 .5-14.6 .5c-114.9 0-208-93.1-208-208s93.1-208 208-208c4.9 0 9.8 .2 14.6 .5c7.9 .5 15-4.7 16.7-12.4s-2.4-15.5-9.8-18.4C320.6 6.3 289 0 256 0z"]],
    "empty-set": [512, 512, [8709, 216], "f656", ["M390.2 76.6C352.8 48.6 306.3 32 256 32C132.3 32 32 132.3 32 256c0 50.3 16.6 96.8 44.6 134.2l45.9-45.9C105.8 318.9 96 288.6 96 256c0-88.4 71.6-160 160-160c32.6 0 62.9 9.8 88.2 26.5l45.9-45.9zM167.8 389.5l-45.9 45.9c37.4 28 83.8 44.6 134.1 44.6c123.7 0 224-100.3 224-224c0-50.3-16.6-96.8-44.6-134.1l-45.9 45.9C406.2 193.1 416 223.4 416 256c0 88.4-71.6 160-160 160c-32.6 0-62.9-9.8-88.2-26.5z", "M502.6 9.4c12.5 12.5 12.5 32.8 0 45.3l-448 448c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l448-448c12.5-12.5 32.8-12.5 45.3 0z"]],
    "house-fire": [640, 512, [], "e50c", ["M288 352c0-.6 0-1.3 0-1.9c0-35.2 16.3-73.6 37.2-107.4c21.7-35.2 51.9-71.2 87.3-102.8c9.8-8.8 22.5-12.7 34.8-11.7L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24c0 18 14 32.1 32 32.1h32v69.7c-.1 .9-.1 1.8-.1 2.8V472c0 22.1 17.9 40 40 40h16c1.2 0 2.4-.1 3.6-.2c1.5 .1 3 .2 4.5 .2H160h24c22.1 0 40-17.9 40-40V448 384c0-17.7 14.3-32 32-32h32z", "M443.7 160c3.5 0 7 1.3 9.8 3.8c19.7 17.8 38.2 37 55.5 57.7c7.9-9.9 16.8-20.7 26.5-29.5c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 58.8 24.2 79C640 440 568.7 512 480 512c-89.7 0-160-72.1-160-159.8c0-26.4 12.7-60.7 32.4-92.6c20-32.4 48.1-66.1 81.4-95.8c2.8-2.5 6.4-3.8 10-3.7zM481 448c18 0 34-5 49-15c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78z"]],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm88 200H296c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M128 256c0-13.3 10.7-24 24-24H296c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24z"]],
    "helicopter": [640, 512, [128641], "f533", ["M128 32c0-17.7 14.3-32 32-32H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H384v64H320V64H160c-17.7 0-32-14.3-32-32zM630.6 425.4c12.5 12.5 12.5 32.8 0 45.3l-3.9 3.9c-24 24-56.6 37.5-90.5 37.5H256c-17.7 0-32-14.3-32-32s14.3-32 32-32H536.2c17 0 33.3-6.7 45.3-18.7l3.9-3.9c12.5-12.5 32.8-12.5 45.3 0z", "M384 384H320c-20.1 0-39.1-9.5-51.2-25.6l-71.4-95.2c-3.5-4.7-8.3-8.3-13.7-10.5L47.2 198.1c-9.5-3.8-16.7-12-19.2-22L5 83.9C2.4 73.8 10.1 64 20.5 64H48c10.1 0 19.6 4.7 25.6 12.8L112 128H384h32c88.4 0 160 71.6 160 160v64c0 17.7-14.3 32-32 32H384zm0-64H512V288c0-53-43-96-96-96H384V320z"]],
    "bird": [512, 512, [], "e469", ["M162.1 407.4l48.6 91.9c6.2 11.7 20.7 16.2 32.4 10s16.2-20.7 10-32.4L221 416c-20.4-.3-40.1-3.3-58.9-8.6zm99 5.6l45.7 86.3c6.2 11.7 20.7 16.2 32.4 10s16.2-20.7 10-32.4l-40.9-77.2c-15 6.1-30.8 10.6-47.2 13.4zM448 175.5l56.2-33.7c4.8-2.9 7.8-8.1 7.8-13.7s-2.9-10.8-7.8-13.7L446.6 79.7C447.5 85 448 90.4 448 96v79.5z", "M0 188.4V192C0 315.7 100.3 416 224 416s224-100.3 224-224V96c0-53-43-96-96-96s-96 43-96 96v32c0 17.7-14.3 32-32 32H28.4C12.7 160 0 172.7 0 188.4zM352 96a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "compass": [512, 512, [129517], "f14e", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM162.4 380.6c-19.4 7.5-38.5-11.6-31-31l55.5-144.3c3.3-8.5 9.9-15.1 18.4-18.4l144.3-55.5c19.4-7.5 38.5 11.6 31 31L325.1 306.7c-3.2 8.5-9.9 15.1-18.4 18.4L162.4 380.6z", "M162.4 380.6l144.3-55.5c8.5-3.3 15.1-9.9 18.4-18.4l55.5-144.3c7.5-19.4-11.6-38.5-31-31L205.3 186.9c-8.5 3.3-15.1 9.9-18.4 18.4L131.4 349.6c-7.5 19.4 11.6 38.5 31 31zM256 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", ["M64 480c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64zM224 352c6.7 0 13-2.8 17.6-7.7l104-112c6.5-7 8.2-17.2 4.4-25.9s-12.5-14.4-22-14.4H120c-9.5 0-18.2 5.7-22 14.4s-2.1 18.9 4.4 25.9l104 112c4.5 4.9 10.9 7.7 17.6 7.7z", "M241.6 344.3c-4.5 4.9-10.9 7.7-17.6 7.7s-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9s12.5-14.4 22-14.4H328c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112z"]],
    "heart-half-stroke": [512, 512, ["heart-half-alt"], "e1ac", ["M256 480c10.3 0 20.2-3.9 27.7-10.9L464.4 300.4c30.4-28.3 47.6-68 47.6-109.5v-5.8c0-69.9-50.5-129.5-119.4-141C347 36.5 300.6 51.4 268 84L256 96v90.5l45.3-45.3 12-12c18-18 43.6-26.2 68.8-22c38.1 6.3 66 39.3 66 77.9v5.8c0 23.8-9.9 46.5-27.3 62.7L256 407.4V480z", "M256 96L244 84l0 0c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1v5.8c0 41.5 17.2 81.2 47.6 109.5L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9l0-50.7 0-265.4V96z"]],
    "file-circle-question": [576, 512, [], "e4ef", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384v38.6C310.1 219.5 256 287.4 256 368c0 59.1 29.1 111.3 73.7 143.3c-3.2 .5-6.4 .7-9.7 .7H64c-35.3 0-64-28.7-64-64V64z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zm48 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-64-94.4c0-23 18.6-41.6 41.6-41.6h40.5c25.4 0 45.9 20.6 45.9 45.9c0 17.1-9.5 32.7-24.5 40.6L448 378.9V384c0 8.8-7.2 16-16 16s-16-7.2-16-16V369.2c0-5.9 3.3-11.4 8.6-14.2l32-16.8c4.6-2.4 7.4-7.2 7.4-12.3c0-7.7-6.2-13.9-13.9-13.9H409.6c-5.3 0-9.6 4.3-9.6 9.6l0 6.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-6.4z"]],
    "laptop-code": [640, 512, [], "f5fc", ["M128 32C92.7 32 64 60.7 64 96V352h64V96H512V352h64V96c0-35.3-28.7-64-64-64H128zM19.2 384C8.6 384 0 392.6 0 403.2C0 445.6 34.4 480 76.8 480H563.2c42.4 0 76.8-34.4 76.8-76.8c0-10.6-8.6-19.2-19.2-19.2H19.2z", "M512 96H128V352H512V96zM281 193l-31 31 31 31c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-9.4-9.4-9.4-24.6 0-33.9l48-48c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zM393 159l48 48c9.4 9.4 9.4 24.6 0 33.9l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0z"]],
    "joystick": [448, 512, [128377], "f8c5", ["M192 352V219.4c10.1 3 20.9 4.6 32 4.6s21.9-1.6 32-4.6V352H192zM64 352c0-17.7 14.3-32 32-32s32 14.3 32 32H64z", "M336 112a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zM176 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM64 352c-35.3 0-64 28.7-64 64v32c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V416c0-35.3-28.7-64-64-64H64z"]],
    "grill-fire": [576, 512, [], "e5a4", ["M40 32C17.9 32 0 49.9 0 72V96c0 89.8 52.9 167.3 129.2 203l-23.1 53.8c-3.3-.5-6.7-.8-10.1-.8c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64h75.5c-5.5-15.3-9.1-31.4-10.7-48h-73l22.9-53.4c15.9 3.6 32.3 5.4 49.3 5.4c1.2 0 2.4 0 3.6 0c5.9-26.2 18.6-52.9 33.6-77.3c21.7-35.2 51.9-71.2 87.3-102.8C366.2 124 393.3 124 411 140c9 8.1 17.7 16.4 26.2 25.1c7-21.8 10.9-45 10.9-69.1V72c0-22.1-17.9-40-40-40H40zM72 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z", "M379.7 160c3.5 0 7 1.3 9.8 3.8c19.7 17.8 38.2 37 55.5 57.7c7.9-9.9 16.8-20.7 26.5-29.5c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 58.8 24.2 79C576 440 504.7 512 416 512c-89.7 0-160-72.1-160-159.8c0-26.4 12.7-60.7 32.4-92.6c20-32.4 48.1-66.1 81.4-95.8c2.8-2.5 6.4-3.8 10-3.7zM417 448c18 0 34-5 49-15c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78z"]],
    "rectangle-vertical-history": [576, 512, [], "e237", ["M120 48c-13.3 0-24 10.7-24 24V440c0 13.3 10.7 24 24 24s24-10.7 24-24V72c0-13.3-10.7-24-24-24zM24 96C10.7 96 0 106.7 0 120V392c0 13.3 10.7 24 24 24s24-10.7 24-24V120c0-13.3-10.7-24-24-24z", "M192 64c0-35.3 28.7-64 64-64H512c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H256c-35.3 0-64-28.7-64-64V64z"]],
    "swatchbook": [512, 512, [], "f5c3", ["M64 64v64h64V64H64zM173.1 473.1c5.9-3.7 11.4-8.1 16.5-13.2L435.2 214.4c12.5-12.5 12.5-32.8 0-45.3L344.7 78.6c-12.5-12.5-32.8-12.5-45.3 0L192 186V416c0 19.9-6 38.4-16.4 53.7c-.8 1.2-1.6 2.3-2.5 3.5zM480 512c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32H374.8l-192 192L480 512zM128 192H64v64h64V192z", "M32 0C14.3 0 0 14.3 0 32V416c0 53 43 96 96 96s96-43 96-96V32c0-17.7-14.3-32-32-32H32zm96 64v64H64V64h64zM64 192h64v64H64V192zM96 392a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "prescription-bottle": [384, 512, [], "f485", ["M352 96H32v96H144c8.8 0 16 7.2 16 16s-7.2 16-16 16H32v64H144c8.8 0 16 7.2 16 16s-7.2 16-16 16H32v64H144c8.8 0 16 7.2 16 16s-7.2 16-16 16H32v32c0 35.3 28.7 64 64 64H288c35.3 0 64-28.7 64-64V96z", "M32 0C14.3 0 0 14.3 0 32V64C0 81.7 14.3 96 32 96H352c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H32zM144 192H32v32H144c8.8 0 16-7.2 16-16s-7.2-16-16-16zm0 96H32v32H144c8.8 0 16-7.2 16-16s-7.2-16-16-16zm0 96H32v32H144c8.8 0 16-7.2 16-16s-7.2-16-16-16z"]],
    "bars": [448, 512, ["navicon"], "f0c9", ["M0 256c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z", "M448 96c0-17.7-14.3-32-32-32H32C14.3 64 0 78.3 0 96s14.3 32 32 32H416c17.7 0 32-14.3 32-32zm0 320c0-17.7-14.3-32-32-32H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H416c17.7 0 32-14.3 32-32z"]],
    "keyboard-left": [640, 512, [], "e1c3", ["M224 64c-35.3 0-64 28.7-64 64V384c0 35.3 28.7 64 64 64H576c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H224zm16 64h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H240c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zM224 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H240c-8.8 0-16-7.2-16-16V240zm16 80h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H240c-8.8 0-16-7.2-16-16V336c0-8.8 7.2-16 16-16zm80-176c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H336c-8.8 0-16-7.2-16-16V144zm16 80h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H336c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16zM320 336c0-8.8 7.2-16 16-16H464c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H336c-8.8 0-16-7.2-16-16V336zM432 128h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H432c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zM416 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H432c-8.8 0-16-7.2-16-16V240zM528 128h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H528c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zM512 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H528c-8.8 0-16-7.2-16-16V240zm16 80h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H528c-8.8 0-16-7.2-16-16V336c0-8.8 7.2-16 16-16z", "M240 128h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H240c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zm0 96h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H240c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16zM224 336c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H240c-8.8 0-16-7.2-16-16V336zM336 128h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H336c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zM320 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H336c-8.8 0-16-7.2-16-16V240zM432 128h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H432c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zM416 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H432c-8.8 0-16-7.2-16-16V240zM528 128h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H528c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zM512 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H528c-8.8 0-16-7.2-16-16V240zm16 80h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H528c-8.8 0-16-7.2-16-16V336c0-8.8 7.2-16 16-16zM113.2 153.8c9 3.7 14.8 12.5 14.8 22.2V336c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L7 273c-9.4-9.4-9.4-24.6 0-33.9l80-80c6.9-6.9 17.2-8.9 26.2-5.2z"]],
    "people-group": [640, 512, [], "e533", ["M128 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM48 304c0-16.2 6-31.1 16-42.3v84.7C54 335 48 320.2 48 304zm112 0c0-37.8 14.6-72.2 38.4-97.9c-16.1-9-34.7-14.1-54.4-14.1H112C50.1 192 0 242.1 0 304c0 44.7 26.2 83.2 64 101.2V448c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V405.2 394.5c-20-24.7-32-56.2-32-90.5zM448 405.2V448c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V405.2c37.8-18 64-56.5 64-101.2c0-61.9-50.1-112-112-112H496c-19.7 0-38.3 5.1-54.4 14.1C465.4 231.8 480 266.2 480 304c0 34.3-12 65.8-32 90.5v10.7zM512 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm80 144c0 16.2-6 31-16 42.3V261.7c10 11.3 16 26.1 16 42.3z", "M384 96A64 64 0 1 0 256 96a64 64 0 1 0 128 0zM256 261.7v84.7c-10-11.3-16-26.1-16-42.3s6-31.1 16-42.3zm128 84.7V261.7c10 11.3 16 26.1 16 42.3s-6 31-16 42.3zm0 58.9c37.8-18 64-56.5 64-101.2c0-61.9-50.1-112-112-112H304c-61.9 0-112 50.1-112 112c0 44.7 26.2 83.2 64 101.2V448c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V405.2z"]],
    "hourglass-end": [384, 512, [8987, "hourglass-3"], "f253", ["M32 75V64H96V75c0 25.5 10.1 49.9 28.1 67.9L192 210.7l67.9-67.9c18-18 28.1-42.4 28.1-67.9V64h64V75c0 42.4-16.9 83.1-46.9 113.1L237.3 256l67.9 67.9c30 30 46.9 70.7 46.9 113.1v11H288V437c0-25.5-10.1-49.9-28.1-67.9L192 301.3l-67.9 67.9c-18 18-28.1 42.4-28.1 67.9v11H32V437c0-42.4 16.9-83.1 46.9-113.1L146.7 256 78.9 188.1l22.6-22.6L78.9 188.1C48.9 158.1 32 117.4 32 75z", "M0 32C0 14.3 14.3 0 32 0H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 64 0 49.7 0 32zM0 480c0-17.7 14.3-32 32-32l64 0V437c0-25.5 10.1-49.9 28.1-67.9L192 301.3l67.9 67.9c18 18 28.1 42.4 28.1 67.9v11l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z"]],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", ["M119.4 44.1c23.3-3.9 46.8-1.9 68.5 5.3l49.8 77.5-75.4 75.4c-1.5 1.5-2.4 3.6-2.3 5.8s1 4.2 2.6 5.7l112 104c2.9 2.7 7.4 2.9 10.5 .3s3.8-7 1.7-10.4l-60.4-98.1 90.7-75.6c2.6-2.1 3.5-5.7 2.4-8.8L296.8 61.7c28.5-16.7 62.4-23.2 95.7-17.6C461.5 55.6 512 115.2 512 185.1v5.8c0 41.5-17.2 81.2-47.6 109.5L283.7 469.1c-7.5 7-17.4 10.9-27.7 10.9s-20.2-3.9-27.7-10.9L47.6 300.4C17.2 272.1 0 232.4 0 190.9v-5.8c0-69.9 50.5-129.5 119.4-141z", "M296.8 61.7C286.4 67.8 276.7 75.3 268 84L256 96 244 84c-16-16-35.2-27.7-56-34.6l49.8 77.5-75.4 75.4c-1.5 1.5-2.4 3.6-2.3 5.8s1 4.2 2.6 5.7l112 104c2.9 2.7 7.4 2.9 10.5 .3s3.8-7 1.7-10.4l-60.4-98.1 90.7-75.6c2.6-2.1 3.5-5.7 2.4-8.8L296.8 61.7z"]],
    "face-beam-hand-over-mouth": [512, 512, [129325], "e47c", ["M512 256c0 113.1-73.3 209.1-175.1 242.9l49-49c18.1-18.1 18.7-47.1 1.8-65.9c16.9-18.8 16.3-47.8-1.8-65.9c-1-1-2.1-2-3.2-3c3.7-15.7-.5-32.8-12.8-45s-29.4-16.5-45-12.8c-.9-1.1-1.9-2.2-3-3.2c-18.7-18.7-49.1-18.7-67.9 0L207 301.1c-9.4-13.7-25.1-22.7-43-22.7c-28.7 0-52 23.3-52 52V384v32.8c0 21.9 5.5 42.5 15.3 60.5C51.2 433 0 350.5 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256zM217.6 212.8l0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 172.4 120 190.1 120 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0 0 0zm160 0l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 172.4 280 190.1 280 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0z", "M217.6 212.8l0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 172.4 120 190.1 120 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0 0 0zm81.7 86.5c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-79 79c-5 5-13.7 1.5-13.7-5.7V330.4c0-11-9-20-20-20s-20 9-20 20V384v32.8c0 52.6 42.6 95.2 95.2 95.2c25.2 0 49.5-10 67.3-27.9l56.8-56.8c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L321.4 424c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L289.4 392c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l67.3-67.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L257.4 360c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3zm78.3-86.5l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 172.4 280 190.1 280 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0z"]],
    "droplet-percent": [384, 512, ["humidity"], "f750", ["M192 512C86 512 0 426 0 320C0 228.8 130.2 57.7 166.6 11.7C172.6 4.2 181.5 0 191.1 0h1.8c9.6 0 18.5 4.2 24.5 11.7C253.8 57.7 384 228.8 384 320c0 106-86 192-192 192zm75.3-267.3c-6.2-6.2-16.4-6.2-22.6 0l-128 128c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l128-128c6.2-6.2 6.2-16.4 0-22.6zM136 288a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM248 400a24 24 0 1 0 0-48 24 24 0 1 0 0 48z", "M267.3 267.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-128 128c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l128-128zM160 264a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM272 376a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "square-up-right": [448, 512, [8599, "external-link-square-alt"], "f360", ["M384 32c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384zM320 313.4V176c0-8.8-7.2-16-16-16H166.6c-12.5 0-22.6 10.1-22.6 22.6c0 6 2.4 11.8 6.6 16L184 232l-66.3 66.3C114 302 112 306.9 112 312s2 10 5.7 13.7l36.7 36.7c3.6 3.6 8.5 5.7 13.7 5.7s10-2 13.7-5.7L248 296l33.4 33.4c4.2 4.2 10 6.6 16 6.6c12.5 0 22.6-10.1 22.6-22.6z", "M320 176V313.4c0 12.5-10.1 22.6-22.6 22.6c-6 0-11.8-2.4-16-6.6L248 296l-66.3 66.3C178 366 173.1 368 168 368s-10-2-13.7-5.7l-36.7-36.7C114 322 112 317.1 112 312s2-10 5.7-13.7L184 232l-33.4-33.4c-4.2-4.2-6.6-10-6.6-16c0-12.5 10.1-22.6 22.6-22.6H304c8.8 0 16 7.2 16 16z"]],
    "face-kiss-beam": [512, 512, [128537, "kiss-beam"], "f597", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm48.7-198.3c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448c-3.6 0-6.8-2.5-7.7-6s.6-7.2 3.8-9l0 0 0 0 0 0 0 0 .2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1 0 0 0 0 0 0c-2.5-1.4-4.1-4.1-4.1-7s1.6-5.6 4.1-7l0 0 0 0 0 0 0 0 0 0 .2-.1 .3-.2 .6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3-.5-.3-.2-.1 0 0 0 0 0 0c-3.2-1.8-4.7-5.5-3.8-9s4.1-6 7.7-6c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4zm-87.1-84.9l0 0 0 0-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2 0 0 0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l0 0 0 0zm160 0l0 0-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2 0 0 0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l0 0 0 0 0 0z", "M217.6 228.8l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 188.4 120 206.1 120 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0zm160 0l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 188.4 280 206.1 280 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0z"]],
    "corn": [512, 512, [127805], "f6c7", ["M491.5 74.9C503.7 68.1 512 55 512 40c0-22.1-17.9-40-40-40c-15 0-28.1 8.3-34.9 20.5C429.8 12.8 419.4 8 408 8c-18 0-33.2 11.8-38.2 28.2C364.4 33.5 358.4 32 352 32c-18 0-33.2 11.8-38.2 28.2C308.4 57.5 302.4 56 296 56c-22.1 0-40 17.9-40 40c0 1.1 0 2.3 .1 3.4C251.2 97.2 245.7 96 240 96c-13.6 0-25.7 6.8-32.9 17.3c29.7 47.7 41.1 103.6 34.2 157.5c53.9-6.9 109.8 4.5 157.5 34.2c10.4-7.2 17.3-19.3 17.3-32.9c0-5.7-1.2-11.2-3.4-16.1c1.1 .1 2.2 .1 3.4 .1c22.1 0 40-17.9 40-40c0-6.4-1.5-12.4-4.2-17.8c16.3-5 28.2-20.2 28.2-38.2c0-6.4-1.5-12.4-4.2-17.8c16.3-5 28.2-20.2 28.2-38.2c0-11.4-4.8-21.8-12.5-29.1z", "M150.9 94.1c-4.3-4.8-12.1-2.4-13.2 3.9l-10.2 54.9c-4.7 25.4-17 48.8-35.3 67.1l-64 64c-36.4 36.4-37.5 94.7-3.2 132.4l77.4-77.4c30.4-30.4 66.9-50.9 105.5-61.6c12.6-69.3-11.5-132.9-56.9-183.4zM47.4 439.2l44.7 44.7c37.5 37.5 98.3 37.5 135.8 0l64-64c18.3-18.3 41.7-30.6 67.1-35.3L414 374.3c6.3-1.2 8.7-8.9 3.9-13.2c-53-47.6-120.7-71.6-192.8-55c-36.7 8.5-71.5 27-100.1 55.6L47.4 439.2z"]],
    "roller-coaster": [640, 512, [], "e324", ["M200 105.9c14 7 26.2 17.4 35.3 30.5L248 154.7V456c0 13.3-10.7 24-24 24s-24-10.7-24-24V105.9zm96 117.9l48 69.1V456c0 13.3-10.7 24-24 24s-24-10.7-24-24V223.8zm96 128.2c14.2 11.5 30.5 20.2 48 25.6V456c0 13.3-10.7 24-24 24s-24-10.7-24-24V351.9zM488 384h8c13.9 0 27.3-2 40-5.6V456c0 13.3-10.7 24-24 24s-24-10.7-24-24V384zM104 113.1c13.7-9.7 30.2-15.8 48-16.9V456c0 13.3-10.7 24-24 24s-24-10.7-24-24V113.1z", "M158.1 96c-52 0-94.1 42.1-94.1 94.1V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V190.1C0 102.8 70.8 32 158.1 32c51.8 0 100.3 25.4 129.8 67.9l129 185.7c15 21.5 39.5 34.4 65.7 34.4H496c44.2 0 80-35.8 80-80c0-32.8-19.7-61-48-73.3V264c0 13.3-10.7 24-24 24s-24-10.7-24-24V160.6c-14.2 1.5-28 5.8-40.7 12.5l-7.3 3.9v74.2L357.6 144.2l51.6-27.5C434.7 103.1 463.1 96 492 96h4c79.5 0 144 64.5 144 144c0 2.7-.1 5.4-.2 8h.2V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V359.8c-22.9 15.3-50.4 24.2-80 24.2H482.6c-47.2 0-91.4-23.1-118.3-61.9l-129-185.7C217.7 111.1 188.9 96 158.1 96z"]],
    "photo-film-music": [640, 512, [], "e228", ["M160 96H64C28.7 96 0 124.7 0 160V384c0 35.3 28.7 64 64 64H289.9c4.4-18.2 15.9-33.1 29.6-43.4c6.8-5.1 14.5-9.4 22.6-12.6H192c-17.7 0-32-14.3-32-32V96zM56 168c0-8.8 7.2-16 16-16H88c8.8 0 16 7.2 16 16v16c0 8.8-7.2 16-16 16H72c-8.8 0-16-7.2-16-16V168zm16 80H88c8.8 0 16 7.2 16 16v16c0 8.8-7.2 16-16 16H72c-8.8 0-16-7.2-16-16V264c0-8.8 7.2-16 16-16zM56 360c0-8.8 7.2-16 16-16H88c8.8 0 16 7.2 16 16v16c0 8.8-7.2 16-16 16H72c-8.8 0-16-7.2-16-16V360zM640 184c0-7.7-3.7-15-10-19.5s-14.3-5.7-21.6-3.3l-192 64c-9.8 3.3-16.4 12.4-16.4 22.8v48V417.5c-5.1-1-10.5-1.5-16-1.5c-35.3 0-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48V313.3l144-48v88.2c-5.1-1-10.5-1.5-16-1.5c-35.3 0-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48c0-1.5-.1-3-.3-4.4c.2-1.2 .3-2.4 .3-3.6V232 184zM461.6 103.5c-2.9-4.7-8.1-7.5-13.6-7.5s-10.6 2.8-13.6 7.5L388 177.9l-15.3-19.7c-3-3.9-7.7-6.2-12.6-6.2s-9.6 2.3-12.6 6.2l-56 72c-3.8 4.8-4.4 11.4-1.7 16.9s8.3 9 14.4 9h64l0-7.9c0-24.1 15.4-45.5 38.3-53.1l93.1-31-37.8-60.5z", "M192 64c0-35.3 28.7-64 64-64H576c35.3 0 64 28.7 64 64v69.6c-12.9-6.1-27.9-7.1-41.7-2.5l-98.9 33-37.8-60.5c-2.9-4.7-8.1-7.5-13.6-7.5s-10.6 2.8-13.6 7.5L388 177.9l-15.3-19.7c-3-3.9-7.7-6.2-12.6-6.2s-9.6 2.3-12.6 6.2l-56 72c-3.8 4.8-4.4 11.4-1.7 16.9s8.3 9 14.4 9h64v64H256c-35.3 0-64-28.7-64-64V64zM320 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "radar": [512, 512, [], "e024", ["M350.9 127.2l-46.1 46.1c-14.3-8.4-31-13.3-48.8-13.3c-53 0-96 43-96 96s43 96 96 96s96-43 96-96h64c0 73.5-49.6 135.5-117.2 154.2C290.8 394.7 274.7 384 256 384s-34.8 10.7-42.8 26.2c-51.7-14.3-92.8-53.9-109.4-104.6c14.4-8.3 24.1-23.8 24.1-41.7c0-19.4-11.5-36.1-28-43.7C116.2 149.1 179.9 96 256 96c35.5 0 68.3 11.6 94.9 31.2zm22.8-22.8C341.2 79 300.4 64 256 64C163.1 64 85.7 129.9 67.9 217.6C47.2 222.9 32 241.7 32 264c0 23.8 17.3 43.6 40.1 47.4c19.3 64.3 71.5 114.4 137 130.9C213.8 463.8 233 480 256 480s42.2-16.2 46.9-37.8C386.3 421.3 448 345.9 448 256h64c0 141.4-114.6 256-256 256S0 397.4 0 256S114.6 0 256 0c62.1 0 118.9 22.1 163.3 58.8l-45.5 45.5z", "M497 49c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-182 182c-7.7-3.3-16.1-5.1-25-5.1c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64c0-8.9-1.8-17.3-5.1-25L497 49z"]],
    "sickle": [512, 512, [], "f822", ["M128 181c0 38 11.9 74.7 33.7 105.2L137 311l16 16 32 32 16 16 23-23 24.5-24.5c4.5-4.5 5.9-11.3 3.7-17.3c-7-18.9-12.2-37.9-12.2-58.6v-9.8C240 165.7 301.7 104 377.8 104c41.7 0 81 18.9 107.1 51.1c2.4 3 6.1 4.9 9.9 4.9c7.6 0 13.3-6.8 11.5-14.2C485.8 62.1 410.1 0 320 0H309C209 0 128 81 128 181z", "M129 303c-9.4-9.4-24.6-9.4-33.9 0L79 319c-9.4 9.4-9.4 24.6 0 33.9l7 7L7 439c-9.4 9.4-9.4 24.6 0 33.9l32 32c9.4 9.4 24.6 9.4 33.9 0l79-79 7 7c9.4 9.4 24.6 9.4 33.9 0l16-16c9.4-9.4 9.4-24.6 0-33.9l-24-24-32-32-24-24z"]],
    "film": [512, 512, [127902], "f008", ["M192 96c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H192zm0 192c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V320c0-17.7-14.3-32-32-32H192z", "M0 96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM48 368v32c0 8.8 7.2 16 16 16H96c8.8 0 16-7.2 16-16V368c0-8.8-7.2-16-16-16H64c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V368c0-8.8-7.2-16-16-16H416zM48 240v32c0 8.8 7.2 16 16 16H96c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H64c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H416zM48 112v32c0 8.8 7.2 16 16 16H96c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H64c-8.8 0-16 7.2-16 16zM416 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H416zM160 128v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H192c-17.7 0-32 14.3-32 32zm32 160c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V320c0-17.7-14.3-32-32-32H192z"]],
    "coconut": [512, 512, [], "e2f6", ["M256 256c62.5-62.5 92.9-133.4 67.9-158.4s-95.9 5.4-158.4 67.9S72.6 298.9 97.6 323.9s95.9-5.4 158.4-67.9z", "M274.5 55.3c42.7-13.2 71.9-7.4 86.7 7.5s20.6 44 7.5 86.7c-12.8 41.5-42.1 89.6-85.8 133.3s-91.8 73-133.3 85.8c-42.7 13.2-71.9 7.4-86.7-7.5s-20.6-44-7.5-86.7c12.8-41.5 42.1-89.6 85.8-133.3s91.8-73 133.3-85.8zM395.2 28.8C361.5-4.8 309.6-5.7 260.4 9.5C210 25 155.3 59.1 107.2 107.2S25 209.9 9.5 260.3C-5.7 309.6-4.8 361.5 28.9 395.2l41 41C118.4 484.7 184.3 512 253 512c143.1 0 259-116 259-259c0-68.7-27.3-134.6-75.9-183.2L395.2 28.8zm24.1 175.8l32 32c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-32-32c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-56 136l32 32c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-32-32c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-136 56l32 32c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-32-32c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]],
    "ruler-horizontal": [640, 512, [], "f547", ["M0 336c0 26.5 21.5 48 48 48l544 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0c-26.5 0-48 21.5-48 48L0 336z", "M144 208l0-80H112v80c0 8.8 7.2 16 16 16s16-7.2 16-16zm96-80H208v80c0 8.8 7.2 16 16 16s16-7.2 16-16V128zm96 80V128H304v80c0 8.8 7.2 16 16 16s16-7.2 16-16zm96-80H400v80c0 8.8 7.2 16 16 16s16-7.2 16-16V128zm96 0H496v80c0 8.8 7.2 16 16 16s16-7.2 16-16V128z"]],
    "shield-cross": [512, 512, [9960], "f712", ["M224 10.8L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c0 6.4 .2 13 .6 20H192c17.7 0 32-14.3 32-32V10.8zM24.7 224C43.7 319.9 97.4 437.2 224 500.4V256c0-17.7-14.3-32-32-32H24.7zM288 500.4C414.6 437.2 468.3 319.9 487.3 224H320c-17.7 0-32 14.3-32 32V500.4zM495.4 160c.4-7 .6-13.7 .6-20c.1-26.2-16.3-47.9-38.3-57.2L288 10.8V128c0 17.7 14.3 32 32 32H495.4z", "M288 10.8L269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L224 10.8V128c0 17.7-14.3 32-32 32H16.6c1.1 19.4 3.6 41.1 8.1 64H192c17.7 0 32 14.3 32 32V500.4c1.9 .9 3.7 1.8 5.6 2.7c16.7 8 36.1 8 52.8 0c1.9-.9 3.8-1.8 5.6-2.7V256c0-17.7 14.3-32 32-32H487.3c4.5-22.9 7.1-44.6 8.1-64H320c-17.7 0-32-14.3-32-32V10.8z"]],
    "cassette-tape": [576, 512, [128429], "f8ab", ["M0 96C0 60.7 28.7 32 64 32H512c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H483.1l-36.3-96.9c-7-18.7-24.9-31.1-44.9-31.1H174.2c-20 0-37.9 12.4-44.9 31.1L92.9 480H64c-35.3 0-64-28.7-64-64V96zM416.8 394.4L448.9 480H127.1l32.1-85.6c2.3-6.2 8.3-10.4 15-10.4H401.8c6.7 0 12.6 4.1 15 10.4zM160 128c-44.2 0-80 35.8-80 80s35.8 80 80 80H416c44.2 0 80-35.8 80-80s-35.8-80-80-80H160z", "M240 208c0 11.4-2.4 22.2-6.7 32H342.7c-4.3-9.8-6.7-20.6-6.7-32s2.4-22.2 6.7-32H233.3c4.3 9.8 6.7 20.6 6.7 32zm176 80H160c-44.2 0-80-35.8-80-80s35.8-80 80-80H416c44.2 0 80 35.8 80 80s-35.8 80-80 80zM160 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm272-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "square-terminal": [448, 512, [], "e32a", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm70.3 55.8c-9 9.8-8.3 25 1.5 33.9L148.5 256 71.8 326.3c-9.8 9-10.4 24.1-1.5 33.9s24.1 10.4 33.9 1.5l96-88c5-4.5 7.8-11 7.8-17.7s-2.8-13.1-7.8-17.7l-96-88c-9.8-9-25-8.3-33.9 1.5zM216 336c-13.3 0-24 10.7-24 24s10.7 24 24 24H360c13.3 0 24-10.7 24-24s-10.7-24-24-24H216z", "M71.8 185.7c-9.8-9-10.4-24.1-1.5-33.9s24.1-10.4 33.9-1.5l96 88c5 4.5 7.8 11 7.8 17.7s-2.8 13.1-7.8 17.7l-96 88c-9.8 9-25 8.3-33.9-1.5s-8.3-25 1.5-33.9L148.5 256 71.8 185.7zM216 336H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H216c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "people-robbery": [576, 512, [], "e536", ["M400 128c41.7 0 78.1-28.4 88.2-68.9L497 24.2C501.2 7.1 518.6-3.3 535.8 1s27.6 21.7 23.3 38.8l-8.7 34.9c-11 44-40.2 79.6-78.3 99.6V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H392V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V174.3c-38.1-20-67.3-55.7-78.3-99.6L241 39.8C236.7 22.6 247.1 5.2 264.2 1s34.5 6.1 38.8 23.3l8.7 34.9C321.9 99.6 358.3 128 400 128zM352 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z", "M32 48a48 48 0 1 1 96 0A48 48 0 1 1 32 48zM8 192c0-35.3 28.7-64 64-64h32.7c27.4 0 52.9 14 67.5 37.1L209.6 224H240c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-11 0-21.1-5.6-27-14.9l-13-20.5V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H72V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V288.6l0-.6V192z"]],
    "lightbulb": [384, 512, [128161], "f0eb", ["M321.2 297.8c-19.8 27.1-39.7 54.4-49.2 86.2H112c-9.6-31.9-29.5-59.1-49.2-86.2c-5.2-7.1-10.4-14.2-15.4-21.4C27.6 247.9 16 213.3 16 176C16 78.8 94.8 0 192 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4zM112 176c0-44.2 35.8-80 80-80c8.8 0 16-7.2 16-16s-7.2-16-16-16C130.1 64 80 114.1 80 176c0 8.8 7.2 16 16 16s16-7.2 16-16z", "M192 512c44.2 0 80-35.8 80-80V384H112v48c0 44.2 35.8 80 80 80z"]],
    "caret-left": [256, 512, [], "f0d9", ["M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 256c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-128-128z", ""]],
    "comment-middle": [512, 512, [], "e149", ["M188.3 408.7l44.5 89c4.4 8.8 13.3 14.3 23.2 14.3s18.8-5.5 23.2-14.3l44.5-89C432.2 384.5 512 303.8 512 208C512 93.1 397.4 0 256 0S0 93.1 0 208c0 95.8 79.8 176.5 188.3 200.7z", ""]],
    "trash-can-list": [640, 512, [], "e2ab", ["M384 96H32V464c0 26.5 21.5 48 48 48H336c26.5 0 48-21.5 48-48V96zM160 192V416c0 8.8-7.2 16-16 16s-16-7.2-16-16V192c0-8.8 7.2-16 16-16s16 7.2 16 16zm128 0V416c0 8.8-7.2 16-16 16s-16-7.2-16-16V192c0-8.8 7.2-16 16-16s16 7.2 16 16z", "M119.2 17.7C124.6 6.8 135.7 0 147.8 0H268.2c12.1 0 23.2 6.8 28.6 17.7L304 32h80c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h80l7.2-14.3zM480 128H608c17.7 0 32 14.3 32 32s-14.3 32-32 32H480c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 128h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H480c-17.7 0-32-14.3-32-32s14.3-32 32-32zM448 416c0-17.7 14.3-32 32-32h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H480c-17.7 0-32-14.3-32-32z"]],
    "block": [448, 512, [], "e46a", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm96 8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm280 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM96 408a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm280 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z", "M72 128a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm304 0a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM96 408a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm280 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-384c13.3 0 24 10.7 24 24V264c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-13.3 10.7-24 24-24zM224 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M280 152c0-13.3-10.7-24-24-24s-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152zM256 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "school-circle-xmark": [640, 512, [], "e56d", ["M302.2 5.4c10.7-7.2 24.8-7.2 35.5 0L473.7 96H592c26.5 0 48 21.5 48 48V266.8C608.1 221.6 555.5 192 496 192c-38.5 0-74.2 12.4-103.1 33.4c9.6-14.1 15.1-31.1 15.1-49.4c0-48.6-39.4-88-88-88s-88 39.4-88 88s39.4 88 88 88c15.6 0 30.2-4 42.9-11.1c-23.4 27.1-38.8 61.4-42.2 99.1h-.5l-.3 0c-35.3 0-64 28.7-64 64v96h64v0H48c-26.5 0-48-21.5-48-48V144c0-26.5 21.5-48 48-48H166.3L302.2 5.4zM80 208v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V208c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16zm0 128v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V336c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16zM336 144v16h16c8.8 0 16 7.2 16 16s-7.2 16-16 16H320c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16s16 7.2 16 16z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]],
    "arrow-right-from-bracket": [512, 512, ["sign-out"], "f08b", ["M192 64c0 17.7-14.3 32-32 32L96 96c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l64 0c17.7 0 32 14.3 32 32z", "M502.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-128 128c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L402.7 288 192 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l210.7 0-73.4-73.4c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l128 128z"]],
    "face-frown-slight": [512, 512, [], "e376", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm91.9-117.5C330 373.8 299.4 352 256 352s-74 21.8-91.9 42.5c-5.8 6.7-15.9 7.4-22.6 1.6s-7.4-15.9-1.6-22.6c22.2-25.7 61-53.5 116.1-53.5s93.8 27.9 116.1 53.5c5.8 6.7 5.1 16.8-1.6 22.6s-16.8 5.1-22.6-1.6zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "circle-chevron-down": [512, 512, ["chevron-circle-down"], "f13a", ["M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM377 241c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-87 87-87-87c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L239 345c9.4 9.4 24.6 9.4 33.9 0L377 241z", "M239 345c9.4 9.4 24.6 9.4 33.9 0L377 241c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-87 87-87-87c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L239 345z"]],
    "sidebar-flip": [512, 512, [], "e24f", ["M0 96C0 60.7 28.7 32 64 32H288V480H64c-35.3 0-64-28.7-64-64V96z", "M448 32c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H288V32H448zM424 96H376c-13.3 0-24 10.7-24 24s10.7 24 24 24h48c13.3 0 24-10.7 24-24s-10.7-24-24-24zm24 120c0-13.3-10.7-24-24-24H376c-13.3 0-24 10.7-24 24s10.7 24 24 24h48c13.3 0 24-10.7 24-24zm-24 72H376c-13.3 0-24 10.7-24 24s10.7 24 24 24h48c13.3 0 24-10.7 24-24s-10.7-24-24-24z"]],
    "unlock-keyhole": [448, 512, ["unlock-alt"], "f13e", ["M224 64c-44.2 0-80 35.8-80 80v48H80V144C80 64.5 144.5 0 224 0c57.5 0 107 33.7 130.1 82.3c7.6 16 .8 35.1-15.2 42.6s-35.1 .8-42.6-15.2C283.4 82.6 255.9 64 224 64z", "M64 192c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V256c0-35.3-28.7-64-64-64H64zM256 384H192c-17.7 0-32-14.3-32-32s14.3-32 32-32h64c17.7 0 32 14.3 32 32s-14.3 32-32 32z"]],
    "temperature-list": [512, 512, [], "e299", ["M144 64c-26.5 0-48 21.5-48 48V276.5c0 17.3-7.1 31.9-15.3 42.5C70.2 332.6 64 349.5 64 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-18.5-6.2-35.4-16.7-48.9c-8.2-10.6-15.3-25.2-15.3-42.5V112c0-26.5-21.5-48-48-48zM32 112C32 50.2 82.1 0 144 0s112 50.1 112 112V276.5c0 .1 .1 .3 .2 .6c.2 .6 .8 1.6 1.7 2.8c18.9 24.4 30.1 55 30.1 88.1c0 79.5-64.5 144-144 144S0 447.5 0 368c0-33.2 11.2-63.8 30.1-88.1c.9-1.2 1.5-2.2 1.7-2.8c.1-.3 .2-.5 .2-.6V112z", "M320 64c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H352c-17.7 0-32-14.3-32-32zM192 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V176c0-8.8 7.2-16 16-16s16 7.2 16 16V322.7c18.6 6.6 32 24.4 32 45.3zM352 160H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H352c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 160c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H384c-17.7 0-32-14.3-32-32z"]],
    "cloud-showers-heavy": [512, 512, [], "f740", ["M94.1 385.5c5.2-12.2-.4-26.3-12.6-31.5s-26.3 .4-31.5 12.6l-48 112c-5.2 12.2 .4 26.3 12.6 31.5s26.3-.4 31.5-12.6l48-112zm120 0c5.2-12.2-.4-26.3-12.6-31.5s-26.3 .4-31.5 12.6l-48 112c-5.2 12.2 .4 26.3 12.6 31.5s26.3-.4 31.5-12.6l48-112zm219.4-31.5c-12.2-5.2-26.3 .4-31.5 12.6l-48 112c-5.2 12.2 .4 26.3 12.6 31.5s26.3-.4 31.5-12.6l48-112c5.2-12.2-.4-26.3-12.6-31.5zM326.1 385.5c5.2-12.2-.4-26.3-12.6-31.5s-26.3 .4-31.5 12.6l-48 112c-5.2 12.2 .4 26.3 12.6 31.5s26.3-.4 31.5-12.6l48-112z", "M0 224c0 53 43 96 96 96H416c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0c1.1-5.2 1.6-10.5 1.6-16c0-44.2-35.8-80-80-80c-24.3 0-46.1 10.9-60.8 28C256.5 24.3 219.1 0 176 0C114.1 0 64 50.1 64 112c0 7.1 .7 14.1 1.9 20.8C27.6 145.4 0 181.5 0 224z"]],
    "headphones-simple": [512, 512, ["headphones-alt"], "f58f", ["M256 80C141.1 80 48 173.1 48 288V392c0 13.3-10.7 24-24 24s-24-10.7-24-24V288C0 146.6 114.6 32 256 32s256 114.6 256 256V392c0 13.3-10.7 24-24 24s-24-10.7-24-24V288c0-114.9-93.1-208-208-208z", "M144 288c-35.3 0-64 28.7-64 64v64c0 35.3 28.7 64 64 64h16c17.7 0 32-14.3 32-32V320c0-17.7-14.3-32-32-32H144zm224 0H352c-17.7 0-32 14.3-32 32V448c0 17.7 14.3 32 32 32h16c35.3 0 64-28.7 64-64V352c0-35.3-28.7-64-64-64z"]],
    "sitemap": [576, 512, [], "f0e8", ["M264 280v40h48V280H464c4.4 0 8 3.6 8 8v32h48V288c0-30.9-25.1-56-56-56H312V192H264v40H112c-30.9 0-56 25.1-56 56v32h48V288c0-4.4 3.6-8 8-8H264z", "M208 80c0-26.5 21.5-48 48-48h64c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H256c-26.5 0-48-21.5-48-48V80zM48 320h64c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V368c0-26.5 21.5-48 48-48zm208 0h64c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H256c-26.5 0-48-21.5-48-48V368c0-26.5 21.5-48 48-48zm208 0h64c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H464c-26.5 0-48-21.5-48-48V368c0-26.5 21.5-48 48-48z"]],
    "pipe-section": [640, 512, [], "e438", ["M576 128H64V384H576V128z", "M64 128c0-17.7-14.3-32-32-32S0 110.3 0 128V384c0 17.7 14.3 32 32 32s32-14.3 32-32V128zm576 0c0-17.7-14.3-32-32-32s-32 14.3-32 32V384c0 17.7 14.3 32 32 32s32-14.3 32-32V128z"]],
    "space-station-moon-construction": [512, 512, ["space-station-moon-alt"], "e034", ["M511 279.1c.7-7.6 1-15.3 1-23.1c0-10.8-.7-21.5-2-32H448V160H368V96h48V56.1C372.2 21 316.5 0 256 0C114.6 0 0 114.6 0 256c0 7.8 .3 15.5 1 23.1C73.2 304.7 160.8 320 256 320s182.8-15.3 255-40.9zM6.8 314.8C33.4 427.9 134.9 512 256 512c76.5 0 145.1-33.5 192-86.7V384H384V342.8c-40.7 6-83.7 9.2-128 9.2c-91.3 0-176.6-13.6-249.2-37.2zM112 160a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z", "M224 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-112 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM6.8 314.8C4.1 303.2 2.1 291.3 1 279.1C73.2 304.7 160.8 320 256 320s182.8-15.3 255-40.9c-1.1 12.2-3 24.1-5.8 35.8C432.6 338.4 347.3 352 256 352s-176.6-13.6-249.2-37.2z"]],
    "circle-dollar-to-slot": [512, 512, ["donate"], "f4b9", ["M256 416A208 208 0 1 0 256 0a208 208 0 1 0 0 416zm20-312v13.9c7.5 1.2 14.6 2.9 21.1 4.7c10.7 2.8 17 13.8 14.2 24.5s-13.8 17-24.5 14.2c-11-2.9-21.6-5-31.2-5.2c-7.9-.1-16 1.8-21.5 5c-4.8 2.8-6.2 5.6-6.2 9.3c0 1.8 .1 3.5 5.3 6.7c6.3 3.8 15.5 6.7 28.3 10.5l.7 .2c11.2 3.4 25.6 7.7 37.1 15c12.9 8.1 24.3 21.3 24.6 41.6c.3 20.9-10.5 36.1-24.8 45c-7.2 4.5-15.2 7.3-23.2 9V312c0 11-9 20-20 20s-20-9-20-20V297.4c-10.3-2.2-20-5.5-28.2-8.4l0 0 0 0c-2.1-.7-4.1-1.4-6.1-2.1c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6c2.5 .8 4.9 1.7 7.2 2.4c13.6 4.6 24 8.1 35.1 8.5c8.6 .3 16.5-1.6 21.4-4.7c4.1-2.5 6-5.5 5.9-10.5c0-2.9-.8-5-5.9-8.2c-6.3-4-15.4-6.9-28-10.7l-1.7-.5c-10.9-3.3-24.6-7.4-35.6-14c-12.7-7.7-24.6-20.5-24.7-40.7c-.1-21.1 11.8-35.7 25.8-43.9c6.9-4.1 14.5-6.8 22.2-8.5V104c0-11 9-20 20-20s20 9 20 20z", "M276 104c0-11-9-20-20-20s-20 9-20 20v14c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1l0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4V312c0 11 9 20 20 20s20-9 20-20V298.2c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7V104zM64 352H48c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V400c0-26.5-21.5-48-48-48H448c-19.4 25.9-44 47.7-72.2 64H448v32H256 64V416h72.2C108 399.7 83.4 377.9 64 352z"]],
    "memory": [576, 512, [], "f538", ["M64 64C28.7 64 0 92.7 0 128v7.4c0 6.8 4.4 12.6 10.1 16.3C23.3 160.3 32 175.1 32 192s-8.7 31.7-21.9 40.3C4.4 236 0 241.8 0 248.6V320H576V248.6c0-6.8-4.4-12.6-10.1-16.3C552.7 223.7 544 208.9 544 192s8.7-31.7 21.9-40.3c5.7-3.7 10.1-9.5 10.1-16.3V128c0-35.3-28.7-64-64-64H64zm128 96v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-17.7 14.3-32 32-32s32 14.3 32 32z", "M192 160v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-17.7 14.3-32 32-32s32 14.3 32 32zM0 416V320H576v96c0 17.7-14.3 32-32 32H496V416c0-8.8-7.2-16-16-16s-16 7.2-16 16v32H368V416c0-8.8-7.2-16-16-16s-16 7.2-16 16v32H240V416c0-8.8-7.2-16-16-16s-16 7.2-16 16v32H112V416c0-8.8-7.2-16-16-16s-16 7.2-16 16v32H32c-17.7 0-32-14.3-32-32z"]],
    "face-sleeping": [512, 512, [], "e38d", ["M477.8 128c21.8 37.7 34.2 81.4 34.2 128c0 141.4-114.6 256-256 256S0 397.4 0 256S114.6 0 256 0c48.7 0 94.2 13.6 132.9 37.2c1.9 4 4.4 7.6 7.3 10.8c-12.2 13.7-15.7 33.3-8.6 50.4c7.4 17.9 24.9 29.6 44.3 29.6h45.8zM256 80c0 8.8 7.2 16 16 16h25.4l-36.7 36.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H310.6l36.7-36.7c4.6-4.6 5.9-11.5 3.5-17.4s-8.3-9.9-14.8-9.9H272c-8.8 0-16 7.2-16 16zm0 344a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm60.8-185.6c-5.3-7.1-15.3-8.5-22.4-3.2s-8.5 15.3-3.2 22.4c30.4 40.5 91.2 40.5 121.6 0c5.3-7.1 3.9-17.1-3.2-22.4s-17.1-3.9-22.4 3.2c-17.6 23.5-52.8 23.5-70.4 0zm-121.6 0c-17.6 23.5-52.8 23.5-70.4 0c-5.3-7.1-15.3-8.5-22.4-3.2s-8.5 15.3-3.2 22.4c30.4 40.5 91.2 40.5 121.6 0c5.3-7.1 3.9-17.1-3.2-22.4s-17.1-3.9-22.4 3.2z", "M416 16c0 8.8 7.2 16 16 16h25.4L420.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H470.6l36.7-36.7c4.6-4.6 5.9-11.5 3.5-17.4S502.5 0 496 0H432c-8.8 0-16 7.2-16 16zM256 80c0 8.8 7.2 16 16 16h25.4l-36.7 36.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H310.6l36.7-36.7c4.6-4.6 5.9-11.5 3.5-17.4s-8.3-9.9-14.8-9.9H272c-8.8 0-16 7.2-16 16zM387.2 238.4c-17.6 23.5-52.8 23.5-70.4 0c-5.3-7.1-15.3-8.5-22.4-3.2s-8.5 15.3-3.2 22.4c30.4 40.5 91.2 40.5 121.6 0c5.3-7.1 3.9-17.1-3.2-22.4s-17.1-3.9-22.4 3.2zm-262.4 0c-5.3-7.1-15.3-8.5-22.4-3.2s-8.5 15.3-3.2 22.4c30.4 40.5 91.2 40.5 121.6 0c5.3-7.1 3.9-17.1-3.2-22.4s-17.1-3.9-22.4 3.2c-17.6 23.5-52.8 23.5-70.4 0z"]],
    "road-spikes": [640, 512, [], "e568", ["M416 246.9V114.8c0-15.6 20.1-22 29.1-9.2L581.8 300.8C598.8 325.2 608 354.2 608 384H450.5 416 322.5 288 194.5 160 32V114.8c0-15.6 20.1-22 29.1-9.2L160 246.9V114.8c0-15.6 20.1-22 29.1-9.2L288 246.9V114.8c0-15.6 20.1-22 29.1-9.2L416 246.9z", "M0 416c0-17.7 14.3-32 32-32H608c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z"]],
    "fire-burner": [640, 512, [], "e4f1", ["M321 288c-45 0-81-29-81-78c0-24 15-45 45-82c4 5 62 79 62 79l36-42c3 4 5 8 7 12c18 33 10 75-20 96c-15 10-31 15-49 15zM32 280c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H80v80H560V304H536c-13.3 0-24-10.7-24-24s10.7-24 24-24h48c13.3 0 24 10.7 24 24V384c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V416c0-17.7 14.3-32 32-32V280zM320 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM192 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M283.7 0c3.5 0 7 1.3 9.8 3.8c19.7 17.8 38.2 37 55.5 57.7c7.9-9.9 16.8-20.7 26.5-29.5c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 58.8 24.2 79C480 280 408.7 352 320 352c-89.7 0-160-72.1-160-159.8c0-26.4 12.7-60.7 32.4-92.6c20-32.4 48.1-66.1 81.4-95.8c2.8-2.5 6.4-3.8 10-3.7zM321 288c18 0 34-5 49-15c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78z"]],
    "squirrel": [512, 512, [], "f71a", ["M158 301.7c-18.7 22.3-30 51-30 82.3c0 70.7 57.3 128 128 128h49.1C242.7 512 192 461.3 192 398.9v-3.8c0-27.6 11-54.1 30.5-73.6l7-7c24-24 43.7-51.6 58.5-81.6V144C288 64.5 223.5 0 144 0S0 64.5 0 144s64.5 144 144 144c2.3 0 4.6-.1 6.9-.2c4.9-.2 9.1 3.5 9.1 8.4c0 2-.7 3.9-2 5.4z", "M320 75.2C320 69 325 64 331.2 64c15.2 0 28.7 7.6 36.8 19.2C376.1 71.6 389.6 64 404.8 64C411 64 416 69 416 75.2V96c53 0 96 43 96 96l-8.2 12.4c-14.8 22.3-39.8 35.6-66.6 35.6H416v58.8c-14.5-6.9-30.8-10.8-48-10.8c-13.1 0-25.6 2.2-37.3 6.4c-8.3 2.9-12.7 12.1-9.8 20.4s12.1 12.7 20.4 9.8c8.3-2.9 17.3-4.5 26.7-4.5c18 0 34.6 6 48 16c19.4 14.6 32 37.8 32 64c0 18-6 34.6-16 48h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H376 352 320 305.1 304v0c-62-.6-112-51-112-113.1v-3.8c0-27.6 11-54.1 30.5-73.6l7-7C287.4 256.6 320 178 320 96V75.2zM416 176a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "arrow-up-to-line": [384, 512, ["arrow-to-top"], "f341", ["M0 64C0 46.3 14.3 32 32 32H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64z", "M169.4 169.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L224 269.3V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V269.3L86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128z"]],
    "flag": [448, 512, [127988, 61725], "f024", ["M64 352l64.3-16.1c41.1-10.3 84.6-5.5 122.5 13.4c44.2 22.1 95.5 24.8 141.7 7.4l34.7-13c12.5-4.7 20.8-16.6 20.8-30V66.1c0-23-24.2-38-44.8-27.7l-9.6 4.8c-46.3 23.2-100.8 23.2-147.1 0c-35.1-17.6-75.4-22-113.5-12.5L64 48V352z", "M32 0C49.7 0 64 14.3 64 32V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V32C0 14.3 14.3 0 32 0z"]],
    "face-cowboy-hat": [512, 512, [], "e36e", ["M48 304c0-49.4 17.2-94.7 45.9-130.4C136.6 204.9 193.5 224 256 224s119.4-19.1 162.1-50.4c28.7 35.7 45.9 81 45.9 130.4c0 114.9-93.1 208-208 208S48 418.9 48 304zm299.8 60.7c-27.9 7.8-59 12.1-91.6 12.1s-63.7-4.3-91.6-12.1c-12.4-3.5-24.3 7.3-18.6 18.8C166.2 424.1 208 452 256.2 452s90-27.9 110.2-68.6c5.7-11.5-6.2-22.2-18.6-18.8zM216 296a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm104 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z", "M133.6 109.8C148.6 64.9 179.2 0 216 0c9.1 0 17.9 4 26.1 10.7c7.9 6.5 19.8 6.5 27.7 0C278.1 4 286.9 0 296 0c36.8 0 67.4 64.9 82.4 109.8C412 99.3 442 84.6 466.9 66.8c2.5-1.8 5.4-2.8 8.4-2.8c8.9 0 15.6 8.3 12.9 16.7C461.2 163.2 367.5 224 256 224S50.8 163.2 23.8 80.7C21 72.3 27.7 64 36.7 64c3 0 6 1 8.4 2.8C70 84.6 100 99.3 133.6 109.8zM168 296a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm152-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "hanukiah": [640, 512, [128334], "f6e6", ["M314.2 3.3C309.1 12.1 296 36.6 296 56c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7C324.6 1.2 322.4 0 320 0s-4.6 1.2-5.8 3.3zm-288 48C21.1 60.1 8 84.6 8 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7C36.6 49.2 34.4 48 32 48s-4.6 1.2-5.8 3.3zM88 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C101.1 60.1 88 84.6 88 104zm82.2-52.7C165.1 60.1 152 84.6 152 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3zM216 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C229.1 60.1 216 84.6 216 104zM394.2 51.3C389.1 60.1 376 84.6 376 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3zM440 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C453.1 60.1 440 84.6 440 104zm82.2-52.7C517.1 60.1 504 84.6 504 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3zM584 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C597.1 60.1 584 84.6 584 104z", "M352 144c0-17.7-14.3-32-32-32s-32 14.3-32 32V320H96c-17.7 0-32-14.3-32-32V192c0-17.7-14.3-32-32-32s-32 14.3-32 32v96c0 53 43 96 96 96H288v64H160c-17.7 0-32 14.3-32 32s14.3 32 32 32H320 480c17.7 0 32-14.3 32-32s-14.3-32-32-32H352V384H544c53 0 96-43 96-96V192c0-17.7-14.3-32-32-32s-32 14.3-32 32v96c0 17.7-14.3 32-32 32H352V144zM128 176c0-8.8-7.2-16-16-16s-16 7.2-16 16v96 16h32V272 176zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16v96 16h32V272 176zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16v96 16h32V272 176zm160 0c0-8.8-7.2-16-16-16s-16 7.2-16 16v96 16h32V272 176zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16v96 16h32V272 176zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16v96 16h32V272 176z"]],
    "chart-scatter-3d": [512, 512, [], "e0e8", ["M256 32c17.7 0 32 14.3 32 32V273L468.5 423.4c13.6 11.3 15.4 31.5 4.1 45.1s-31.5 15.4-45.1 4.1L256 329.7 84.5 472.6c-13.6 11.3-33.8 9.5-45.1-4.1s-9.5-33.8 4.1-45.1L224 273V64c0-17.7 14.3-32 32-32z", "M32 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM416 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM64 256A32 32 0 1 0 0 256a32 32 0 1 0 64 0zM256 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "display-chart-up": [576, 512, [], "e5e3", ["M64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM512 64V352H64V64H512z", "M64 64H512V352H64V64zM346.7 448H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H160c-17.7 0-32-14.3-32-32s14.3-32 32-32h69.3L240 416h96l10.7 32zM344 112c-13.3 0-24 10.7-24 24s10.7 24 24 24h38.1L304 238.1l-63-63c-9.4-9.4-24.6-9.4-33.9 0l-88 88c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l71-71 63 63c4.5 4.5 10.6 7 17 7s12.5-2.5 17-7l95-95V232c0 13.3 10.7 24 24 24s24-10.7 24-24V136c0-13.3-10.7-24-24-24H344z"]],
    "square-code": [448, 512, [], "e267", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm262.2 71.9c-8.9 9.9-8.1 25 1.8 33.9L324.1 256l-60.2 54.2c-9.9 8.9-10.7 24-1.8 33.9s24 10.7 33.9 1.8l80-72c5.1-4.6 7.9-11 7.9-17.8s-2.9-13.3-7.9-17.8l-80-72c-9.9-8.9-25-8.1-33.9 1.8zm-78.1 33.9c9.9-8.9 10.7-24 1.8-33.9s-24-10.7-33.9-1.8l-80 72c-5.1 4.6-7.9 11-7.9 17.8s2.9 13.3 7.9 17.8l80 72c9.9 8.9 25 8.1 33.9-1.8s8.1-25-1.8-33.9L123.9 256l60.2-54.2z", "M184.1 201.8c9.9-8.9 10.7-24 1.8-33.9s-24-10.7-33.9-1.8l-80 72c-5.1 4.6-7.9 11-7.9 17.8s2.9 13.3 7.9 17.8l80 72c9.9 8.9 25 8.1 33.9-1.8s8.1-25-1.8-33.9L123.9 256l60.2-54.2zm79.9 0L324.1 256l-60.2 54.2c-9.9 8.9-10.7 24-1.8 33.9s24 10.7 33.9 1.8l80-72c5.1-4.6 7.9-11 7.9-17.8s-2.9-13.3-7.9-17.8l-80-72c-9.9-8.9-25-8.1-33.9 1.8s-8.1 25 1.8 33.9z"]],
    "feather": [512, 512, [129718], "f52d", ["M97.9 448h84c49.7 0 97.9-14.4 139-41c11.1-7.2 5.5-23-7.8-23c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l81-24.3c2.5-.8 4.8-2.1 6.7-4l22.4-22.4c10.1-10.1 2.9-27.3-11.3-27.3l-32.2 0c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l112-33.6c4-1.2 7.4-3.9 9.3-7.7C506.4 207.6 512 184.1 512 160c0-41-16.3-80.3-45.3-109.3l-5.5-5.5C432.3 16.3 393 0 352 0s-80.3 16.3-109.3 45.3L139 149C91 197 64 262.1 64 330v84L311 167c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L97.9 448z", "M24 512c-6.2 0-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9L311 167c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L41 505c-4.7 4.7-10.8 7-17 7z"]],
    "volume-low": [448, 512, [128264, "volume-down"], "f027", ["M378.8 185c8.4-10.3 23.5-11.8 33.8-3.5C434.1 199.1 448 225.9 448 256s-13.9 56.9-35.4 74.5c-10.3 8.4-25.4 6.8-33.8-3.5s-6.8-25.4 3.5-33.8C393.1 284.4 400 271 400 256s-6.9-28.4-17.7-37.3c-10.3-8.4-11.8-23.5-3.5-33.8z", "M320 64c0-12.6-7.4-24-18.9-29.2s-25-3.1-34.4 5.3L131.8 160H64c-35.3 0-64 28.7-64 64v64c0 35.3 28.7 64 64 64h67.8L266.7 471.9c9.4 8.4 22.9 10.4 34.4 5.3S320 460.6 320 448V64z"]],
    "xmark-to-slot": [576, 512, ["times-to-slot", "vote-nay"], "f771", ["M144 32c-26.5 0-48 21.5-48 48V400H480V80c0-26.5-21.5-48-48-48H144zm63 103c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z", "M207 135c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9zM48 288H96v80H80c-8.8 0-16 7.2-16 16s7.2 16 16 16H496c8.8 0 16-7.2 16-16s-7.2-16-16-16H480V288h48c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V336c0-26.5 21.5-48 48-48z"]],
    "box-taped": [448, 512, ["box-alt"], "f49a", ["M50.7 58.5C58.9 42.3 75.5 32 93.7 32H192L160 160H0L50.7 58.5zM288 160v96c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V160H288zm0 0L256 32h98.3c18.2 0 34.8 10.3 42.9 26.5L448 160H288z", "M160 160H0V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V160H288v96c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V160z"]],
    "comment-slash": [640, 512, [], "f4b3", ["M424.1 430.1L82.9 161.3C70.7 185.6 64 212.2 64 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c37 0 72.3-6.4 104.1-17.9zm88.9-53.4C552.2 340.2 576 292.3 576 240C576 125.1 461.4 32 320 32c-67.7 0-129.3 21.4-175.1 56.3l368 288.5z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "swords": [512, 512, [9876], "f71d", ["M146.7 278.6L96 329.4 182.6 416l50.7-50.7-86.6-86.6zm218.5-45.3L484.5 114.2c6.7-6.7 11.3-15.2 13.1-24.5l14.1-70.5c1-5.2-.6-10.7-4.4-14.5s-9.2-5.4-14.5-4.4L422.4 14.4c-9.3 1.9-17.8 6.4-24.5 13.1L278.6 146.7l86.6 86.6zM19.1 .3C13.9-.7 8.5 .9 4.7 4.7S-.7 13.9 .3 19.1L14.4 89.6c1.9 9.3 6.4 17.8 13.1 24.5L329.4 416 416 329.4 114.2 27.5c-6.7-6.7-15.2-11.3-24.5-13.1L19.1 .3z", "M75.3 308.7c-6.2-6.2-16.4-6.2-22.6 0l-16 16c-4.7 4.7-6 11.8-3.3 17.8l27.5 62L4.7 460.7c-6.2 6.2-6.2 16.4 0 22.6l24 24c6.2 6.2 16.4 6.2 22.6 0l56.2-56.2 62 27.5c6 2.7 13.1 1.4 17.8-3.3l16-16c6.2-6.2 6.2-16.4 0-22.6l-128-128zm361.4 0l-128 128c-6.2 6.2-6.2 16.4 0 22.6l16 16c4.7 4.7 11.8 6 17.8 3.3l62-27.5 56.2 56.2c6.2 6.2 16.4 6.2 22.6 0l24-24c6.2-6.2 6.2-16.4 0-22.6l-56.2-56.2 27.5-62c2.7-6.1 1.4-13.1-3.3-17.8l-16-16c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "cloud-sun-rain": [640, 512, [127782], "f743", ["M294.2 1.2c5.1 2.1 8.7 6.7 9.6 12.1l10.4 62.4c-23.3 10.8-42.9 28.4-56 50.3c-14.6-9-31.8-14.1-50.2-14.1c-53 0-96 43-96 96c0 35.5 19.3 66.6 48 83.2c.8 31.8 13.2 60.7 33.1 82.7l-56 39.2c-4.5 3.1-10.3 3.8-15.4 1.6s-8.7-6.7-9.6-12.1L98.1 317.9 13.4 303.8c-5.4-.9-10-4.5-12.1-9.6s-1.5-10.9 1.6-15.4L52.5 208 2.9 137.2c-3.2-4.5-3.8-10.3-1.6-15.4s6.7-8.7 12.1-9.6L98.1 98.1l14.1-84.7c.9-5.4 4.5-10 9.6-12.1s10.9-1.5 15.4 1.6L208 52.5 278.8 2.9c4.5-3.2 10.3-3.8 15.4-1.6zM208 144c13.8 0 26.7 4.4 37.1 11.9c-1.2 4.1-2.2 8.3-3 12.6c-37.9 14.6-67.2 46.6-77.8 86.4C151.8 243.1 144 226.5 144 208c0-35.3 28.7-64 64-64zm76.1 309.3l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7s14 22.3 6.7 33.3zm96 0l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7s14 22.3 6.7 33.3zm96 0l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7s14 22.3 6.7 33.3zm96 0l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7s14 22.3 6.7 33.3z", "M559.9 383.9c44.2 0 80-35.8 80-80c0-39.3-28.4-72.1-65.8-78.7c1.2-5.6 1.9-11.3 1.9-17.2c0-44.2-35.8-80-80-80c-17 0-32.8 5.3-45.8 14.4C433.3 114.6 402.8 96 368 96c-53 0-96 43-96 96l0 1.3c-45.4 7.6-80 47.1-80 94.6c0 53 43 96 96 96H559.9z"]],
    "album": [448, 512, [128189], "f89f", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM224 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320z", "M224 416a160 160 0 1 0 0-320 160 160 0 1 0 0 320zm0-192a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "circle-n": [512, 512, [], "e118", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM203.7 138.3L304 283.2V152c0-13.3 10.7-24 24-24s24 10.7 24 24V360c0 10.5-6.8 19.8-16.8 22.9s-20.9-.6-26.9-9.2L208 228.8V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-10.5 6.8-19.8 16.8-22.9s20.9 .6 26.9 9.2z", "M176.8 129.1c10-3.1 20.9 .6 26.9 9.2L304 283.2V152c0-13.3 10.7-24 24-24s24 10.7 24 24V360c0 10.5-6.8 19.8-16.8 22.9s-20.9-.6-26.9-9.2L208 228.8V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-10.5 6.8-19.8 16.8-22.9z"]],
    "compress": [448, 512, [], "f066", ["M160 448c0 17.7-14.3 32-32 32s-32-14.3-32-32V384H32c-17.7 0-32-14.3-32-32s14.3-32 32-32h96c17.7 0 32 14.3 32 32v96zM320 192c-17.7 0-32-14.3-32-32V64c0-17.7 14.3-32 32-32s32 14.3 32 32v64h64c17.7 0 32 14.3 32 32s-14.3 32-32 32H320z", "M160 64c0-17.7-14.3-32-32-32s-32 14.3-32 32v64H32c-17.7 0-32 14.3-32 32s14.3 32 32 32h96c17.7 0 32-14.3 32-32V64zM320 320c-17.7 0-32 14.3-32 32v96c0 17.7 14.3 32 32 32s32-14.3 32-32V384h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H320z"]],
    "wheat-awn": [512, 512, ["wheat-alt"], "e2cd", ["M505 7c9.4 9.4 9.4 24.6 0 33.9l-88 88c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L471 7c9.4-9.4 24.6-9.4 33.9 0zm-177.8 223L295.3 262c-16-1.6-32.2-.1-47.8 4.3c4.8-16.6 6.1-34 4-51l30.5-30.5L294.2 197l22.6 22.6 10.4 10.4zm131.6-46.9c-14.4-10.3-30.5-17.2-47.1-20.8L471 103c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-46.2 46.2zm-108-84c-3.9-16.4-11.1-32.2-21.6-46.3L375 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L350.7 99.2zM225.4 331.9l-31.9 31.9c-16-1.6-32.2-.1-47.8 4.3c4.8-16.6 6.1-34 4-51l30.5-30.5L215 321.5l0 0 10.4 10.4zM123.5 433.7L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l68.9-68.9 34.8 34.8 0 0 10.4 10.4z", "M282.8 27.3c6.2-6.2 16.4-6.2 22.6 0l11.3 11.3c34.1 34.1 44.9 82.6 32.5 125.9c43.3-12.4 91.8-1.5 125.9 32.5l11.3 11.3c6.2 6.2 6.2 16.4 0 22.6l-11.3 11.3c-37.5 37.5-98.3 37.5-135.8 0l-22.6-22.6 0 0-45.3-45.3c-37.5-37.5-37.5-98.3 0-135.8l11.3-11.3zM203.6 129.1L215 140.5c34.1 34.1 44.9 82.6 32.5 125.9c43.3-12.4 91.8-1.5 125.9 32.5l11.3 11.3c6.2 6.2 6.2 16.4 0 22.6l-11.3 11.3c-37.5 37.5-98.3 37.5-135.8 0L215 321.5l0 0-45.3-45.3c-37.5-37.5-37.5-98.3 0-135.8L181 129.1c6.2-6.2 16.4-6.2 22.6 0zM79.2 231c6.2-6.2 16.4-6.2 22.6 0l11.3 11.3c34.1 34.1 44.9 82.6 32.5 125.9c43.3-12.4 91.8-1.5 125.9 32.5L282.8 412c6.2 6.2 6.2 16.4 0 22.6l-11.3 11.3c-37.5 37.5-98.3 37.5-135.8 0l-22.6-22.6s0 0 0 0L67.9 378c-37.5-37.5-37.5-98.3 0-135.8L79.2 231z"]],
    "ankh": [320, 512, [9765], "f644", ["M192 320V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V320h64z", "M160 64c-35.3 0-64 28.7-64 64c0 41.6 20.7 76.6 46.6 104.1c5.9 6.2 11.8 11.8 17.4 16.7c5.6-4.9 11.5-10.5 17.4-16.7C203.3 204.6 224 169.6 224 128c0-35.3-28.7-64-64-64zM32 128C32 57.3 89.3 0 160 0s128 57.3 128 128c0 52.4-21.5 95.5-46.8 128H288c17.7 0 32 14.3 32 32s-14.3 32-32 32H172.6 147.4 32c-17.7 0-32-14.3-32-32s14.3-32 32-32H78.8C53.5 223.5 32 180.4 32 128z"]],
    "hands-holding-child": [640, 512, [], "e4fa", ["M80 104c0-22.1-17.9-40-40-40S0 81.9 0 104v56 64V325.5c0 25.5 10.1 49.9 28.1 67.9L128 493.3c12 12 28.3 18.7 45.3 18.7H240c26.5 0 48-21.5 48-48V385.1c0-29.7-11.8-58.2-32.8-79.2l-25.3-25.3 0 0-15.2-15.2-32-32c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l32 32 15.2 15.2c11 11 9.2 29.2-3.7 37.8c-9.7 6.5-22.7 5.2-31-3.1L98.7 309.5c-12-12-18.7-28.3-18.7-45.3V224 144 104zm480 0v40 80 40.2c0 17-6.7 33.3-18.7 45.3l-51.1 51.1c-8.3 8.3-21.3 9.6-31 3.1c-12.9-8.6-14.7-26.9-3.7-37.8l15.2-15.2 32-32c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-32 32-15.2 15.2 0 0-25.3 25.3c-21 21-32.8 49.5-32.8 79.2V464c0 26.5 21.5 48 48 48h66.7c17 0 33.3-6.7 45.3-18.7l99.9-99.9c18-18 28.1-42.4 28.1-67.9V224 160 104c0-22.1-17.9-40-40-40s-40 17.9-40 40z", "M280 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM384.5 181l-19.8-16.7L375.8 253c1.6 13.2-7.7 25.1-20.8 26.8s-25.1-7.7-26.8-20.8l-4.4-35h-7.6l-4.4 35c-1.6 13.2-13.6 22.5-26.8 20.8s-22.5-13.6-20.8-26.8l11.1-88.8L255.5 181c-10.1 8.6-25.3 7.3-33.8-2.8s-7.3-25.3 2.8-33.8L266 109.2c10.1-8.5 22.9-13.2 36.2-13.2h35.6c13.2 0 26 4.7 36.2 13.2l41.5 35.1c10.1 8.6 11.4 23.7 2.8 33.8s-23.7 11.4-33.8 2.8z"]],
    "asterisk": [384, 512, [10033, 61545], "2a", ["M192 32c17.7 0 32 14.3 32 32V199.5l111.5-66.9c15.2-9.1 34.8-4.2 43.9 11s4.2 34.8-11 43.9L254.2 256l114.3 68.6c15.2 9.1 20.1 28.7 11 43.9s-28.7 20.1-43.9 11L224 312.5V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V312.5L48.5 379.4c-15.2 9.1-34.8 4.2-43.9-11s-4.2-34.8 11-43.9L129.8 256 15.5 187.4c-15.2-9.1-20.1-28.7-11-43.9s28.7-20.1 43.9-11L160 199.5V64c0-17.7 14.3-32 32-32z", ""]],
    "key-skeleton-left-right": [640, 512, [], "e3b4", ["M128 448a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm0-192C57.3 256 0 313.3 0 384s57.3 128 128 128c59.6 0 109.8-40.8 124-96l196 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-32 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-68 0c-14.2-55.2-64.3-96-124-96z", "M512 64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 192c70.7 0 128-57.3 128-128S582.7 0 512 0C452.4 0 402.2 40.8 388 96L192 96c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32h32v32c0 17.7 14.3 32 32 32s32-14.3 32-32V160h68c14.2 55.2 64.3 96 124 96z"]],
    "comment-lines": [512, 512, [], "f4b0", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM152 176H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96H264c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M128 200c0-13.3 10.7-24 24-24H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24H264c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24z"]],
    "luchador-mask": [448, 512, ["luchador", "mask-luchador"], "f455", ["M144 288c-44.2 0-80-35.8-80-80c0-26.5 21.5-48 48-48h32c44.2 0 80 35.8 80 80c0-44.2 35.8-80 80-80h32c26.5 0 48 21.5 48 48c0 44.2-35.8 80-80 80H290.7c3.4 6.3 5.3 13.4 5.3 20.7c0 4-.6 7.9-1.6 11.6c32.3 3.2 57.6 30.5 57.6 63.7c0 35.3-28.7 64-64 64H160c-35.3 0-64-28.7-64-64c0-33.2 25.2-60.5 57.6-63.7c-1-3.7-1.6-7.6-1.6-11.6c0-7.3 1.8-14.4 5.3-20.7H144zM96 208c0 26.5 21.5 48 48 48h32c8.8 0 16-7.2 16-16c0-26.5-21.5-48-48-48H112c-8.8 0-16 7.2-16 16zm88 100.7c0 6.2 5.1 11.3 11.3 11.3h11.3 6 .6 21.5 .6 6 11.3c6.2 0 11.3-5.1 11.3-11.3c0-3-1.2-5.9-3.3-8l-8-8-4.2-4.2-.4-.4-10.3-10.3C234 274 229.1 272 224 272s-10 2-13.7 5.7L200 288l-.4 .4-4.2 4.2-8 8c-2.1 2.1-3.3 5-3.3 8zM195.3 352H160c-17.7 0-32 14.3-32 32s14.3 32 32 32H288c17.7 0 32-14.3 32-32s-14.3-32-32-32H252.7 195.3zM336 192H304c-26.5 0-48 21.5-48 48c0 8.8 7.2 16 16 16h32c26.5 0 48-21.5 48-48c0-8.8-7.2-16-16-16z", "M0 224C0 100.3 100.3 0 224 0S448 100.3 448 224v96c0 106-86 192-192 192H192C86 512 0 426 0 320V224zm153.6 96.3C121.2 323.5 96 350.8 96 384c0 35.3 28.7 64 64 64H288c35.3 0 64-28.7 64-64c0-33.2-25.2-60.5-57.6-63.7c1-3.7 1.6-7.6 1.6-11.6c0-7.3-1.8-14.4-5.3-20.7H304c44.2 0 80-35.8 80-80c0-26.5-21.5-48-48-48H304c-44.2 0-80 35.8-80 80c0-44.2-35.8-80-80-80H112c-26.5 0-48 21.5-48 48c0 44.2 35.8 80 80 80h13.3c-3.4 6.3-5.3 13.4-5.3 20.7c0 4 .6 7.9 1.6 11.6z"]],
    "square-check": [448, 512, [9745, 9989, 61510, "check-square"], "f14a", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM337 209L209 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L303 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z", "M337 175c9.4 9.4 9.4 24.6 0 33.9L209 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L303 175c9.4-9.4 24.6-9.4 33.9 0z"]],
    "shredder": [512, 512, [], "f68a", ["M128 0C92.7 0 64 28.7 64 64V192h64V64H354.7L384 93.3V192h64V93.3c0-17-6.7-33.3-18.7-45.3L400 18.7C388 6.7 371.7 0 354.7 0H128zM40 384V488c0 13.3 10.7 24 24 24s24-10.7 24-24V384H40zm96 0V488c0 13.3 10.7 24 24 24s24-10.7 24-24V384H136zm96 0V488c0 13.3 10.7 24 24 24s24-10.7 24-24V384H232zm96 0V488c0 13.3 10.7 24 24 24s24-10.7 24-24V384H328zm96 0V488c0 13.3 10.7 24 24 24s24-10.7 24-24V384H424z", "M64 192c-35.3 0-64 28.7-64 64v96c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32V256c0-35.3-28.7-64-64-64H64zm368 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "book-open-cover": [640, 512, ["book-open-alt"], "e0c0", ["M64 373.8c0 15.3 10.8 28.4 25.7 31.4L304 448V32L100.6 2.2C81.3-.7 64 14.3 64 33.8V373.8zM576 33.8c0-19.5-17.3-34.5-36.6-31.7L336 32V448l214.3-42.9c15-3 25.7-16.1 25.7-31.4V33.8z", "M89.7 405.1L320 451.2l230.3-46.1c15-3 25.7-16.1 25.7-31.4V28.8l25.7-5.1C621.5 19.7 640 34.8 640 55V421.8c0 15.3-10.8 28.4-25.7 31.4L320 512 25.7 453.1C10.8 450.2 0 437 0 421.8V55C0 34.8 18.5 19.7 38.3 23.7L64 28.8v345c0 15.3 10.8 28.4 25.7 31.4z"]],
    "sandwich": [512, 512, [129386], "f81f", ["M32 304c22.7 0 44.3-10.3 58.8-17.2l0 0c1.3-.6 2.6-1.2 3.8-1.8c17.4-8.2 29.4-13 41.4-13c16.2 0 27.5 5 45.4 13.1l.1 0c18 8.2 41.4 18.9 74.5 18.9s56.6-10.7 74.5-18.9l.1 0C348.5 277 359.8 272 376 272c12 0 23.9 4.7 41.4 13c1.2 .6 2.5 1.2 3.8 1.8l0 0c14.5 6.9 36.1 17.2 58.8 17.2c17.7 0 32-14.3 32-32s-14.3-32-32-32c-7.2 0-15.8-3.7-35.4-13c-16.6-7.8-40.6-19-68.6-19c-30.6 0-53 10.2-70.1 18l-1.9 .9C286.9 234.7 274.3 240 256 240s-30.9-5.3-48.1-13.1l-1.9-.9c-17-7.8-39.4-18-70.1-18c-28 0-52.1 11.3-68.6 19c-19.6 9.2-28.2 13-35.4 13c-17.7 0-32 14.3-32 32s14.3 32 32 32zm201.7 37.7l70.2 40.9c10 5.8 22.3 5.8 32.2 0l70.2-40.9c6.4-3.7 13.6-5.7 20.9-5.7H212.8c7.4 0 14.6 2 20.9 5.7z", "M32 64C14.3 64 0 78.3 0 96v48c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32H32zM233.7 341.7c-6.4-3.7-13.6-5.7-20.9-5.7H208 32c-17.7 0-32 14.3-32 32v48c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32V368c0-17.7-14.3-32-32-32H432h-4.8c-7.4 0-14.6 2-20.9 5.7l-70.2 40.9c-10 5.8-22.3 5.8-32.2 0l-70.2-40.9z"]],
    "peseta-sign": [384, 512, [], "e221", ["M32 160l0 64c-17.7 0-32-14.3-32-32s14.3-32 32-32zm250.5 64H96V160H282.5c3.5 10 5.5 20.8 5.5 32s-1.9 22-5.5 32zm66.3 0c2.1-10.3 3.2-21 3.2-32s-1.1-21.7-3.2-32H352c17.7 0 32 14.3 32 32s-14.3 32-32 32h-3.2z", "M32 64c0-17.7 14.3-32 32-32H192c88.4 0 160 71.6 160 160s-71.6 160-160 160H96v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V320 64zM96 288h96c53 0 96-43 96-96s-43-96-96-96H96V288z"]],
    "square-parking-slash": [640, 512, ["parking-slash"], "f617", ["M544 401.1V96c0-35.3-28.7-64-64-64H160c-21.6 0-40.7 10.7-52.3 27.1L227 152.7c6-14.5 20.3-24.7 37-24.7h72c53 0 96 43 96 96c0 26.3-10.6 50.2-27.8 67.5L544 401.1zM352.8 251.2c9.1-5.6 15.2-15.7 15.2-27.2c0-17.7-14.3-32-32-32H288v8.4l64.8 50.8zM486.9 479.6L288 322.9V352c0 17.7-14.3 32-32 32s-32-14.3-32-32V288 272.5L96 171.6V416c0 35.3 28.7 64 64 64H480c2.3 0 4.6-.1 6.9-.4z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "train-tunnel": [512, 512, [], "e454", ["M256 0C114.6 0 0 114.6 0 256V448c0 35.3 28.7 64 64 64h41.4l64.3-64.3C137.3 444.5 112 417.2 112 384V192c0-35.3 28.7-64 64-64H336c35.3 0 64 28.7 64 64V384c0 33.2-25.3 60.5-57.7 63.7L406.6 512H448c35.3 0 64-28.7 64-64V256C512 114.6 397.4 0 256 0zM361.4 512l-64-64H214.6l-64 64H361.4zM160 216v80c0 13.3 10.7 24 24 24H328c13.3 0 24-10.7 24-24V216c0-13.3-10.7-24-24-24H184c-13.3 0-24 10.7-24 24z", "M112 192c0-35.3 28.7-64 64-64H336c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H176c-35.3 0-64-28.7-64-64V192zm48 24v80c0 13.3 10.7 24 24 24H328c13.3 0 24-10.7 24-24V216c0-13.3-10.7-24-24-24H184c-13.3 0-24 10.7-24 24zm96 200a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "heading": [448, 512, ["header"], "f1dc", ["M0 64C0 46.3 14.3 32 32 32H80h48c17.7 0 32 14.3 32 32s-14.3 32-32 32H112V208H336V96H320c-17.7 0-32-14.3-32-32s14.3-32 32-32h48 48c17.7 0 32 14.3 32 32s-14.3 32-32 32H400V240 416h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H368 320c-17.7 0-32-14.3-32-32s14.3-32 32-32h16V272H112V416h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H80 32c-17.7 0-32-14.3-32-32s14.3-32 32-32H48V240 96H32C14.3 96 0 81.7 0 64z", ""]],
    "ghost": [384, 512, [128123], "f6e2", ["M40.1 467.1l-11.2 9c-3.2 2.5-7.1 3.9-11.1 3.9C8 480 0 472 0 462.2V192C0 86 86 0 192 0S384 86 384 192V462.2c0 9.8-8 17.8-17.8 17.8c-4 0-7.9-1.4-11.1-3.9l-11.2-9c-13.4-10.7-32.8-9-44.1 3.9L269.3 506c-3.3 3.8-8.2 6-13.3 6s-9.9-2.2-13.3-6l-26.6-30.5c-12.7-14.6-35.4-14.6-48.2 0L141.3 506c-3.3 3.8-8.2 6-13.3 6s-9.9-2.2-13.3-6L84.2 471c-11.3-12.9-30.7-14.6-44.1-3.9zM160 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M128 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "face-anguished": [512, 512, [], "e369", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-192c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16H192c-8.8 0-16-7.2-16-16c0-44.2 35.8-80 80-80zM144.4 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm141 .9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z", "M192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm-15.6 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM333 128.9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z"]],
    "hockey-sticks": [640, 512, [], "f454", ["M462.3 3.4c15.8 7.9 22.2 27.1 14.3 42.9L261.5 476.6c-10.8 21.7-33 35.4-57.2 35.4H160 128 96V480 352H252.2L419.4 17.7c7.9-15.8 27.1-22.2 42.9-14.3zM0 384c0-17.7 14.3-32 32-32H64V512H32c-17.7 0-32-14.3-32-32V384zm576-32V512H544V352h32z", "M220.6 17.7l81.5 163-35.8 71.6L163.4 46.3c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3zM337.9 395.3l35.8-71.6L387.8 352H544V480v32H512 480 435.8c-24.2 0-46.4-13.7-57.2-35.4l-40.6-81.3zM608 352c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32H576V352h32zM96 352V512H64V352H96z"]],
    "abacus": [576, 512, [129518], "f640", ["M512 96V208H448V176H416v32H288V176H256v32H160V176H128v32H64V96h64v32h32V96h96v32h32V96H416v32h32V96h64zM64 416l0-176h64v24h32V240h96v24h32V240H416v96h32V240h64V416H448V384H416v32H288V384H256v32H160V384H128v32H64zm64-80h32V312H128v24zm128 0h32V312H256v24zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64z", "M96 152c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H248c-13.3 0-24-10.7-24-24zm160 0c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H408c-13.3 0-24-10.7-24-24zM96 288c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H248c-13.3 0-24-10.7-24-24zM96 360c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H248c-13.3 0-24-10.7-24-24zm160 0c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H408c-13.3 0-24-10.7-24-24z"]],
    "film-simple": [512, 512, ["film-alt"], "f3a0", ["M160 32H352V480H160V32z", "M160 32H112V80c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V34C20.4 41.1 0 66.2 0 96V416c0 29.8 20.4 54.9 48 62V432c0-8.8 7.2-16 16-16H96c8.8 0 16 7.2 16 16v48h48V32zM352 480h48V432c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v46c27.6-7.1 48-32.2 48-62V96c0-29.8-20.4-54.9-48-62V80c0 8.8-7.2 16-16 16H416c-8.8 0-16-7.2-16-16V32H352V480zM64 160H96c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16zm336 16c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H416c-8.8 0-16-7.2-16-16V176zM64 288H96c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V304c0-8.8 7.2-16 16-16zm336 16c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H416c-8.8 0-16-7.2-16-16V304z"]],
    "list": [512, 512, ["list-squares"], "f03a", ["M160 96c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-17.7 0-32-14.3-32-32zm32 128H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-17.7 0-32-14.3-32-32s14.3-32 32-32z", "M16 72c0-13.3 10.7-24 24-24H88c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V72zm0 160c0-13.3 10.7-24 24-24H88c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V232zM40 368H88c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V392c0-13.3 10.7-24 24-24z"]],
    "tree-palm": [576, 512, [127796], "f82b", ["M248.4 206.9c4 10.8 7.8 26.2 9.7 47.2c4.2 46.5-1.6 116.8-32.7 216.4c-3 9.7-1.3 20.3 4.8 28.5s15.6 13 25.8 13h64c16.1 0 29.8-12 31.8-28c12.4-99-2.3-207.2-31.7-292H272c-2.5 0-5-.6-7.1-1.7l-16.5 16.5z", "M133.2 141.9L102.9 91.4c-3.1-5.2-10.6-5.2-13.7 0L69.5 124.1c-1.4 2.4-4 3.9-6.9 3.9H16c-8.8 0-16.1-7.2-14.4-15.9C10.7 64.2 59.6 0 160 0c88 0 136.5 49.4 153.2 93.8C338.4 76.2 372.3 64 416 64c100.4 0 149.3 64.2 158.4 112.1c1.7 8.7-5.6 15.9-14.4 15.9H513.3c-2.8 0-5.4-1.5-6.9-3.9l-19.6-32.7c-3.1-5.2-10.6-5.2-13.7 0l-19.6 32.7c-1.4 2.4-4.1 3.9-6.9 3.9H272c-2.5 0-5-.6-7.1-1.7L109.8 345.5c-6.2 6.2-16.5 6.3-21.4-1C61 304.1 50.2 224.1 121.1 153.1c4-4 8-7.7 12-11.2z"]],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", ["M384 32c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384zm-90.7 96.7c-9.7-2.6-19.9 2.3-23.7 11.6l-20 48c-3.4 8.2-1 17.6 5.8 23.2L280 231.7c-16.6 35.2-45.1 63.7-80.3 80.3l-20.2-24.7c-5.6-6.8-15-9.2-23.2-5.8l-48 20c-9.3 3.9-14.2 14-11.6 23.7l12 44C111.1 378 119 384 128 384c123.7 0 224-100.3 224-224c0-9-6-16.9-14.7-19.3l-44-12z", "M269.5 140.3c3.9-9.3 14-14.2 23.7-11.6l44 12C346 143.1 352 151 352 160c0 123.7-100.3 224-224 224c-9 0-16.9-6-19.3-14.7l-12-44c-2.6-9.7 2.3-19.9 11.6-23.7l48-20c8.2-3.4 17.6-1 23.2 5.8L199.7 312c35.2-16.6 63.7-45.1 80.3-80.3l-24.7-20.2c-6.8-5.6-9.2-15-5.8-23.2l20-48z"]],
    "cart-plus": [576, 512, [], "f217", ["M170.7 288H459.2c32.6 0 61.1-21.8 69.5-53.3l41-152.3C576.6 57 557.4 32 531.1 32h-411c2 4.2 3.5 8.8 4.4 13.5L170.7 288zM252 160c0-11 9-20 20-20h44V96c0-11 9-20 20-20s20 9 20 20v44h44c11 0 20 9 20 20s-9 20-20 20H356v44c0 11-9 20-20 20s-20-9-20-20V180H272c-11 0-20-9-20-20z", "M0 24C0 10.7 10.7 0 24 0H69.5c26.9 0 50 19.1 55 45.5l51.6 271c2.2 11.3 12.1 19.5 23.6 19.5H488c13.3 0 24 10.7 24 24s-10.7 24-24 24H199.7c-34.6 0-64.3-24.6-70.7-58.5L77.4 54.5c-.7-3.8-4-6.5-7.9-6.5H24C10.7 48 0 37.3 0 24zM128 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM252 160c0-11 9-20 20-20h44V96c0-11 9-20 20-20s20 9 20 20v44h44c11 0 20 9 20 20s-9 20-20 20H356v44c0 11-9 20-20 20s-20-9-20-20V180H272c-11 0-20-9-20-20z"]],
    "gamepad": [640, 512, [], "f11b", ["M192 64C86 64 0 150 0 256S86 448 192 448H448c106 0 192-86 192-192s-86-192-192-192H192zM496 168a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM392 304a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM168 200c0-13.3 10.7-24 24-24s24 10.7 24 24v32h32c13.3 0 24 10.7 24 24s-10.7 24-24 24H216v32c0 13.3-10.7 24-24 24s-24-10.7-24-24V280H136c-13.3 0-24-10.7-24-24s10.7-24 24-24h32V200z", "M192 176c-13.3 0-24 10.7-24 24v32H136c-13.3 0-24 10.7-24 24s10.7 24 24 24h32v32c0 13.3 10.7 24 24 24s24-10.7 24-24V280h32c13.3 0 24-10.7 24-24s-10.7-24-24-24H216V200c0-13.3-10.7-24-24-24z"]],
    "border-center-v": [448, 512, [], "f89d", ["M448 448a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM64 352A32 32 0 1 1 0 352a32 32 0 1 1 64 0zM384 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 160A32 32 0 1 1 0 160a32 32 0 1 1 64 0zm320 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 256A32 32 0 1 1 0 256a32 32 0 1 1 64 0zM384 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM0 64a32 32 0 1 1 64 0A32 32 0 1 1 0 64zM64 448A32 32 0 1 1 0 448a32 32 0 1 1 64 0zM288 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM352 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM288 448a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM160 64A32 32 0 1 1 96 64a32 32 0 1 1 64 0zM96 448a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm64-192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M224 480c-17.7 0-32-14.3-32-32l0-384c0-17.7 14.3-32 32-32s32 14.3 32 32l0 384c0 17.7-14.3 32-32 32z"]],
    "circle-dot": [512, 512, [128280, "dot-circle"], "f192", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-352a96 96 0 1 1 0 192 96 96 0 1 1 0-192z", "M256 160a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]],
    "clipboard-medical": [384, 512, [], "e133", ["M113.2 66.3c.1-.8 .3-1.6 .4-2.3H64C28.7 64 0 92.7 0 128V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H270.4c.2 .8 .3 1.6 .4 2.3C290.1 72.6 304 90.7 304 112v24c0 13.3-10.7 24-24 24H192 104c-13.3 0-24-10.7-24-24V112c0-21.3 13.9-39.4 33.2-45.7zM160 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48h48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H224v48c0 8.8-7.2 16-16 16H176c-8.8 0-16-7.2-16-16V352H112c-8.8 0-16-7.2-16-16V304c0-8.8 7.2-16 16-16h48V240z", "M113.2 66.3C119.6 28.7 152.5 0 192 0s72.4 28.7 78.8 66.3C290.1 72.6 304 90.7 304 112v24c0 13.3-10.7 24-24 24H192 104c-13.3 0-24-10.7-24-24V112c0-21.3 13.9-39.4 33.2-45.7zM216 80a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM160 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48h48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H224v48c0 8.8-7.2 16-16 16H176c-8.8 0-16-7.2-16-16V352H112c-8.8 0-16-7.2-16-16V304c0-8.8 7.2-16 16-16h48V240z"]],
    "face-dizzy": [512, 512, ["dizzy"], "f567", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-224a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM100.7 132.7c6.2-6.2 16.4-6.2 22.6 0L160 169.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L182.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L160 214.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L137.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6zm192 0c6.2-6.2 16.4-6.2 22.6 0L352 169.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L374.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L352 214.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L329.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6z", "M196.7 132.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L182.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L160 214.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L137.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L160 169.4l36.7-36.7zm96 0c6.2-6.2 16.4-6.2 22.6 0L352 169.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L374.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L352 214.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L329.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6z"]],
    "egg": [384, 512, [129370], "f7fb", ["M192 496C86 496 0 394 0 288C0 176 64 16 192 16s192 160 192 272c0 106-86 208-192 208zM154.8 134c6.5-6 7-16.1 1-22.6s-16.1-7-22.6-1c-23.9 21.8-41.1 52.7-52.3 84.2C69.7 226.1 64 259.7 64 288c0 8.8 7.2 16 16 16s16-7.2 16-16c0-24.5 5-54.4 15.1-82.8c10.1-28.5 25-54.1 43.7-71.2z", "M155.8 111.4c6 6.5 5.5 16.7-1 22.6c-18.8 17.1-33.6 42.7-43.7 71.2C101 233.6 96 263.5 96 288c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-28.3 5.7-61.9 16.9-93.5c11.2-31.5 28.4-62.4 52.3-84.2c6.5-6 16.7-5.5 22.6 1z"]],
    "up-to-line": [384, 512, ["arrow-alt-to-top"], "f34d", ["M0 64C0 81.7 14.3 96 32 96H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H32C14.3 32 0 46.3 0 64z", "M219.3 139.3L342.1 262.1c6.4 6.4 9.9 15 9.9 24c0 18.7-15.2 33.9-33.9 33.9L256 320l0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-128-62.1 0C47.2 320 32 304.8 32 286.1c0-9 3.6-17.6 9.9-24L164.7 139.3c7.2-7.2 17.1-11.3 27.3-11.3s20.1 4.1 27.3 11.3z"]],
    "house-medical-circle-xmark": [640, 512, [], "e513", ["M394.8 512C349.5 480.1 320 427.5 320 368c0-5.4 .2-10.7 .7-16H320v16c0 8.8-7.2 16-16 16H272c-8.8 0-16-7.2-16-16V320H208c-8.8 0-16-7.2-16-16V272c0-8.8 7.2-16 16-16h48V208c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48h40.2c32.3-39.1 81.1-64 135.8-64c8.9 0 17.6 .7 26.1 1.9L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24c0 18 14 32.1 32 32.1h32V448c0 35.3 28.7 64 64 64H394.8z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]],
    "watch-fitness": [384, 512, [], "f63e", ["M80 64C35.8 64 0 99.8 0 144V368c0 44.2 35.8 80 80 80H304c44.2 0 80-35.8 80-80V144c0-44.2-35.8-80-80-80H80zm0 157.3c0-33.8 27.4-61.3 61.3-61.3c16.2 0 31.8 6.5 43.3 17.9l7.4 7.4 7.4-7.4c11.5-11.5 27.1-17.9 43.3-17.9c33.8 0 61.3 27.4 61.3 61.3c0 16.2-6.5 31.8-17.9 43.3l-82.7 82.7c-6.2 6.2-16.4 6.2-22.6 0L97.9 264.6C86.5 253.1 80 237.5 80 221.3z", "M112.3 0H271.7C298.4 0 320 21.6 320 48.3V65.6c-5.2-1-10.5-1.6-16-1.6H80c-5.5 0-10.8 .6-16 1.6V48.3C64 21.6 85.6 0 112.3 0zM64 464V446.4c5.2 1 10.5 1.6 16 1.6H304c5.5 0 10.8-.6 16-1.6V464c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48zM80 221.3c0-33.8 27.4-61.3 61.3-61.3c16.2 0 31.8 6.5 43.3 17.9l7.4 7.4 7.4-7.4c11.5-11.5 27.1-17.9 43.3-17.9c33.8 0 61.3 27.4 61.3 61.3c0 16.2-6.5 31.8-17.9 43.3l-82.7 82.7c-6.2 6.2-16.4 6.2-22.6 0L97.9 264.6C86.5 253.1 80 237.5 80 221.3z"]],
    "clock-nine-thirty": [512, 512, [], "e34d", ["M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V256c0-13.3-10.7-24-24-24H152c-13.3 0-24 10.7-24 24s10.7 24 24 24h80V392c0 13.3 10.7 24 24 24s24-10.7 24-24z", "M256 416c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H152c-13.3 0-24 10.7-24 24s10.7 24 24 24h80V392c0 13.3 10.7 24 24 24z"]],
    "campground": [576, 512, [9978], "f6bb", ["M0 448v16c0 26.5 21.5 48 48 48H288 528c26.5 0 48-21.5 48-48V448H407.5l0 0H288 168.5l0 0H0z", "M372 7c13.8 11 16 31.2 5 45l-48 60L563.7 405.4c7.9 9.9 12.3 22.3 12.3 35V448H407.5L288 291.7 168.5 448H0v-7.6c0-12.7 4.3-25.1 12.3-35L247 112 199 52c-11-13.8-8.8-33.9 5-45s33.9-8.8 45 5l39 48.8L327 12c11-13.8 31.2-16 45-5zM47.7 512H528.3c-.1 0-.2 0-.3 0H288 48c-.1 0-.2 0-.3 0z"]],
    "folder-plus": [512, 512, [], "f65e", ["M512 416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H192c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8H448c35.3 0 64 28.7 64 64V416zM232 376c0 13.3 10.7 24 24 24s24-10.7 24-24V312h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V200c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64v64z", "M232 312v64c0 13.3 10.7 24 24 24s24-10.7 24-24V312h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V200c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64z"]],
    "jug": [448, 512, [], "f8c6", ["M160 0c-17.7 0-32 14.3-32 32s14.3 32 32 32H288c17.7 0 32-14.3 32-32s-14.3-32-32-32H160zM416 288H32V416H416V288z", "M144 59.7V85c0 7.1-2.4 14-6.7 19.6L59 205.3c-17.5 22.5-27 50.1-27 78.6V288H416v-4.1c0-17.4-3.5-34.5-10.3-50.3C430.6 222.3 448 197.2 448 168c0-39.8-32.2-72-72-72c-21.2 0-40.3 9.2-53.5 23.8l-11.8-15.1C306.4 99 304 92.1 304 85V59.7c-4.7 2.7-10.2 4.3-16 4.3H160c-5.8 0-11.3-1.6-16-4.3zM32 448c0 35.3 28.7 64 64 64H352c35.3 0 64-28.7 64-64V416H32v32zM378.6 191.9l-25.1-32.2c3.4-9.1 12.2-15.6 22.5-15.6c13.3 0 24 10.7 24 24c0 12.4-9.4 22.6-21.4 23.9z"]],
    "futbol": [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", ["M155.4 20.5C119.8 35.8 88.3 58.9 63.1 87.6l40.1 100.1c2.4 6 2.6 12.6 .6 18.8s-6.1 11.4-11.6 14.8L1 278.9c3.5 39.4 15.9 76.3 35.2 108.5l107.6-7.2c6.4-.4 12.8 1.4 18.1 5.2s9 9.3 10.5 15.6L199 505.6c18.3 4.2 37.4 6.4 57 6.4s38.7-2.2 57-6.4L339.5 401c1.6-6.3 5.3-11.8 10.5-15.6s11.6-5.6 18.1-5.2l107.6 7.2c19.3-32.2 31.7-69.1 35.2-108.5l-91.3-57.5c-5.5-3.4-9.6-8.7-11.6-14.8s-1.8-12.8 .6-18.8L448.9 87.6c-25.1-28.8-56.6-51.9-92.3-67.1L273.7 89.6c-5 4.1-11.2 6.4-17.7 6.4s-12.7-2.3-17.7-6.4L155.4 20.5zm86.5 145.7c8.4-6.1 19.8-6.1 28.2 0L337 214.8c8.4 6.1 11.9 16.9 8.7 26.8l-25.5 78.6c-3.2 9.9-12.4 16.6-22.8 16.6H214.7c-10.4 0-19.6-6.7-22.8-16.6l-25.6-78.6c-3.2-9.9 .3-20.7 8.7-26.8l66.9-48.6z", "M1 278.9c-.7-7.5-1-15.2-1-22.9C0 191.5 23.8 132.6 63.1 87.6l40.1 100.1c2.4 6 2.6 12.6 .6 18.8s-6.1 11.4-11.6 14.8L1 278.9zM199 505.6C130 489.9 71.6 446.4 36.2 387.4l107.6-7.2c6.4-.4 12.8 1.4 18.1 5.2s9 9.3 10.5 15.6L199 505.6zM475.8 387.4C440.4 446.4 382 489.9 313 505.6L339.5 401c1.6-6.3 5.3-11.8 10.5-15.6s11.6-5.6 18.1-5.2l107.6 7.2zM448.9 87.6C488.2 132.6 512 191.5 512 256c0 7.7-.3 15.3-1 22.9l-91.3-57.5c-5.5-3.4-9.6-8.7-11.6-14.8s-1.8-12.8 .6-18.8L448.9 87.6zM356.6 20.5L273.7 89.6c-5 4.1-11.2 6.4-17.7 6.4s-12.7-2.3-17.7-6.4L155.4 20.5C186.3 7.3 220.3 0 256 0s69.7 7.3 100.6 20.5zM241.9 166.3c8.4-6.1 19.8-6.1 28.2 0L337 214.8c8.4 6.1 11.9 16.9 8.7 26.8l-25.5 78.6c-3.2 9.9-12.4 16.6-22.8 16.6H214.7c-10.4 0-19.6-6.7-22.8-16.6l-25.6-78.6c-3.2-9.9 .3-20.7 8.7-26.8l66.9-48.6z"]],
    "snow-blowing": [640, 512, [], "f761", ["M512 48c-17.7 0-32 14.3-32 32s14.3 32 32 32h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H416c-17.7 0-32 14.3-32 32s14.3 32 32 32H544c53 0 96-43 96-96s-43-96-96-96H512zm0 416h24c53 0 96-43 96-96s-43-96-96-96H416c-17.7 0-32 14.3-32 32s14.3 32 32 32H536c17.7 0 32 14.3 32 32s-14.3 32-32 32H512c-17.7 0-32 14.3-32 32s14.3 32 32 32z", "M176 64c13.3 0 24 10.7 24 24v25.4l12.7-12.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L200 158.6v55.8l48.3-27.9 12.9-48.2c2.3-8.5 11.1-13.6 19.6-11.3s13.6 11.1 11.3 19.6l-4.6 17.3 22-12.7c11.5-6.6 26.2-2.7 32.8 8.8s2.7 26.2-8.8 32.8l-22 12.7 17.3 4.6c8.5 2.3 13.6 11.1 11.3 19.6s-11.1 13.6-19.6 11.3l-48.2-12.9L224 256l48.3 27.9L320.6 271c8.5-2.3 17.3 2.8 19.6 11.3s-2.8 17.3-11.3 19.6l-17.3 4.6 22 12.7c11.5 6.6 15.4 21.3 8.8 32.8s-21.3 15.4-32.8 8.8l-22-12.7 4.6 17.3c2.3 8.5-2.8 17.3-11.3 19.6s-17.3-2.8-19.6-11.3l-12.9-48.2L200 297.6v55.8l35.3 35.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L200 398.6V424c0 13.3-10.7 24-24 24s-24-10.7-24-24V398.6l-12.7 12.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L152 353.4V297.6l-48.3 27.9L90.7 373.7c-2.3 8.5-11.1 13.6-19.6 11.3s-13.6-11.1-11.3-19.6l4.6-17.3-22 12.7C31 367.4 16.4 363.5 9.7 352s-2.7-26.2 8.8-32.8l22-12.7-17.3-4.6c-8.5-2.3-13.6-11.1-11.3-19.6s11.1-13.6 19.6-11.3l48.2 12.9L128 256 79.7 228.1 31.4 241c-8.5 2.3-17.3-2.8-19.6-11.3s2.8-17.3 11.3-19.6l17.3-4.6-22-12.7C7 186.2 3.1 171.5 9.7 160s21.3-15.4 32.8-8.8l22 12.7-4.6-17.3c-2.3-8.5 2.8-17.3 11.3-19.6s17.3 2.8 19.6 11.3l12.9 48.2L152 214.4V158.6l-35.3-35.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L152 113.4V88c0-13.3 10.7-24 24-24z"]],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", ["M208.1 272.1c-.6 0-1.2-.1-1.8-.1H184c-66.3 0-120 53.7-120 120c0 6.2 .5 12.4 1.4 18.4C68.1 428.2 56.1 448 38 448H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H175.9c.1 0 .1-.1 .1-.1s.1-.1 .1-.1c2.6 .2 5.2 .3 7.9 .3c66.3 0 120-53.7 120-120c0-2.8-.1-5.5-.2-8.3L208.1 272.1z", "M411 331.6c-19.9 32.6-55.3 52.4-93.4 52.4c-4.8 0-9.6-.3-14.3-.9L208 272c.2-35.9 17.8-69.4 47.1-90.1L500.2 8.8c18.6-13.1 43.9-11.4 60.5 4.2s20 40.6 8.2 60.1L411 331.6z"]],
    "lock": [448, 512, [128274], "f023", ["M224 64c-44.2 0-80 35.8-80 80v48H80V144C80 64.5 144.5 0 224 0s144 64.5 144 144v48H304V144c0-44.2-35.8-80-80-80z", "M0 256c0-35.3 28.7-64 64-64H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256z"]],
    "arrow-down-from-line": [384, 512, [8615, "arrow-from-top"], "f345", ["M0 64C0 81.7 14.3 96 32 96H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H32C14.3 32 0 46.3 0 64z", "M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.7V304 192c0-17.7-14.3-32-32-32s-32 14.3-32 32V304v66.7L86.6 297.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128z"]],
    "gas-pump": [512, 512, [9981], "f52f", ["M96 0C60.7 0 32 28.7 32 64V448H320V64c0-35.3-28.7-64-64-64H96zm16 64H240c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V80c0-8.8 7.2-16 16-16z", "M384 64l32 32v64c0 29.8 20.4 54.9 48 62V376c0 13.3-10.7 24-24 24s-24-10.7-24-24V344c0-48.6-39.4-88-88-88h-8v48h8c22.1 0 40 17.9 40 40v32c0 39.8 32.2 72 72 72s72-32.2 72-72V224 192 168 154.5c0-17-6.7-33.3-18.7-45.3L416 32c-8.8-8.8-23.2-8.8-32 0s-8.8 23.2 0 32zM0 480c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32s-14.3-32-32-32H32c-17.7 0-32 14.3-32 32z"]],
    "signal-bars-slash": [640, 512, ["signal-alt-slash"], "f694", ["M608 451.2V48c0-26.5-21.5-48-48-48s-48 21.5-48 48V376l96 75.2zM448 325.8V176c0-26.5-21.5-48-48-48s-48 21.5-48 48v74.6l96 75.2zM560 512l-.3 0h.7l-.3 0zM448 464V449l-96-75.6V464c0 26.5 21.5 48 48 48s48-21.5 48-48zM288 322.9l-74.7-58.8C200.5 272.7 192 287.4 192 304V464c0 26.5 21.5 48 48 48s48-21.5 48-48V322.9zM80 384c-26.5 0-48 21.5-48 48v32c0 26.5 21.5 48 48 48s48-21.5 48-48V432c0-26.5-21.5-48-48-48z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "monkey": [576, 512, [128018], "f6fb", ["M384 64c-26.5 0-48 21.5-48 48c0 20.8 13.2 38.4 31.6 45.1c4.7 1.7 8.4 5.9 8.4 10.9c0 22.1 17.9 40 40 40s40-17.9 40-40c0-5 3.7-9.2 8.4-10.9c18.5-6.7 31.6-24.4 31.6-45.1c0-26.5-21.5-48-48-48H384zm-16 48a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z", "M160 416c0-89.7 61.4-165 144.5-186.1C329.1 265 369.9 288 416 288c9.8 0 19.4-1 28.7-3L526.5 363c31.6 30.2 49.5 72 49.5 115.7V480c0 17.7-14.3 32-32 32s-32-14.3-32-32v-1.2c0-26.2-10.7-51.3-29.7-69.4L416 346.1V448h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H416 160C71.6 512 0 440.4 0 352V110.1C0 49.3 49.3 0 110.1 0h10.4c57.2 0 102.8 47.8 100.1 104.9c-2.3 48.2-38.6 88-86.4 94.6l-1.9 .3c-17.5 2.4-33.7-9.8-36.1-27.3s9.8-33.7 27.3-36.1l1.9-.3c17.3-2.4 30.4-16.7 31.2-34.2c1-20.6-15.5-37.9-36.2-37.9H110.1C84.7 64 64 84.7 64 110.1V352c0 53 43 96 96 96V416zM416 256c-29.3 0-55.9-12.2-74.8-31.7c-9-9.3-16.2-20.2-21.3-32.3c-35.3 0-64-28.7-64-64s28.6-64 64-64c15.7-37.6 52.8-64 96-64s80.4 26.4 96 64c35.3 0 64 28.7 64 64s-28.6 64-64 64c-15.7 37.6-52.8 64-96 64zM384 64c-26.5 0-48 21.5-48 48c0 20.8 13.2 38.4 31.6 45.1c4.7 1.7 8.4 5.9 8.4 10.9c0 22.1 17.9 40 40 40s40-17.9 40-40c0-5 3.7-9.2 8.4-10.9c18.5-6.7 31.6-24.4 31.6-45.1c0-26.5-21.5-48-48-48H384z"]],
    "rectangle-pro": [640, 512, ["pro"], "e235", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H576c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm40 128h56c35.3 0 64 28.7 64 64s-28.7 64-64 64H128v40c0 13.3-10.7 24-24 24s-24-10.7-24-24V264 184c0-13.3 10.7-24 24-24zm56 80c8.8 0 16-7.2 16-16s-7.2-16-16-16H128v32h32zm80-56c0-13.3 10.7-24 24-24h56c35.3 0 64 28.7 64 64c0 21.9-11 41.2-27.7 52.7l24.1 38.5c7 11.2 3.6 26-7.6 33.1s-26 3.6-33.1-7.6l-33-52.7H288v40c0 13.3-10.7 24-24 24s-24-10.7-24-24V264 184zm48 56h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H288v32zm200-80c48.6 0 88 39.4 88 88v16c0 48.6-39.4 88-88 88s-88-39.4-88-88V248c0-48.6 39.4-88 88-88zm-40 88v16c0 22.1 17.9 40 40 40s40-17.9 40-40V248c0-22.1-17.9-40-40-40s-40 17.9-40 40z", "M80 184v80 64c0 13.3 10.7 24 24 24s24-10.7 24-24V288h32c35.3 0 64-28.7 64-64s-28.7-64-64-64H104c-13.3 0-24 10.7-24 24zm48 56V208h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H128zm112-56v80 64c0 13.3 10.7 24 24 24s24-10.7 24-24V288h18.7l33 52.7c7 11.2 21.8 14.7 33.1 7.6s14.7-21.8 7.6-33.1l-24.1-38.5C373 265.2 384 245.9 384 224c0-35.3-28.7-64-64-64H264c-13.3 0-24 10.7-24 24zm48 56V208h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H288zm200-80c-48.6 0-88 39.4-88 88v16c0 48.6 39.4 88 88 88s88-39.4 88-88V248c0-48.6-39.4-88-88-88zm-40 88c0-22.1 17.9-40 40-40s40 17.9 40 40v16c0 22.1-17.9 40-40 40s-40-17.9-40-40V248z"]],
    "house-night": [640, 512, [], "e010", ["M125.2 16.1c6.2-4.4 5.4-14.8-2.2-15.6c-3.6-.4-7.3-.5-11-.5C50.1 0 0 50.1 0 112s50.1 112 112 112c32.1 0 61.1-13.5 81.5-35.2c5.2-5.6-1-14-8.6-13.2c-2.9 .3-5.9 .4-9 .4c-48.6 0-88-39.4-88-88c0-29.7 14.7-55.9 37.2-71.9zm123.3-3.8L236.6 44.6 204.3 56.5c-7 2.6-7 12.4 0 15l32.3 11.9 11.9 32.3c2.6 7 12.4 7 15 0l11.9-32.3 32.3-11.9c7-2.6 7-12.4 0-15L275.4 44.6 263.5 12.3c-2.6-7-12.4-7-15 0zm-160 320L76.6 364.6 44.3 376.5c-7 2.6-7 12.4 0 15l32.3 11.9 11.9 32.3c2.6 7 12.4 7 15 0l11.9-32.3 32.3-11.9c7-2.6 7-12.4 0-15l-32.3-11.9-11.9-32.3c-2.6-7-12.4-7-15 0z", "M378.3 104.5c12.3-11.3 31.2-11.3 43.4 0l208 192c9.7 8.9 12.9 22.9 8.1 35.2S621.2 352 608 352H576V464c0 26.5-21.5 48-48 48H272c-26.5 0-48-21.5-48-48V352H192c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8.1-35.2l208-192zM368 288c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16V304c0-8.8-7.2-16-16-16H368z"]],
    "hot-tub-person": [512, 512, ["hot-tub"], "f593", ["M248 0c13.3 0 24 10.7 24 24v5.2c0 20.4 8.7 39.9 23.8 53.5l16.4 14.8c25.3 22.8 39.7 55.2 39.7 89.2V200c0 13.3-10.7 24-24 24s-24-10.7-24-24V186.8c0-20.4-8.7-39.9-23.8-53.5l-16.4-14.8C238.4 95.7 224 63.3 224 29.2V24c0-13.3 10.7-24 24-24zM0 256c0-53 43-96 96-96c20.8 0 41 6.7 57.6 19.2L256 256H0zM384 24v5.2c0 20.4 8.7 39.9 23.8 53.5l16.4 14.8c25.3 22.8 39.7 55.2 39.7 89.2V200c0 13.3-10.7 24-24 24s-24-10.7-24-24V186.8c0-20.4-8.7-39.9-23.8-53.5l-16.4-14.8C350.4 95.7 336 63.3 336 29.2V24c0-13.3 10.7-24 24-24s24 10.7 24 24zM0 64a64 64 0 1 1 128 0A64 64 0 1 1 0 64z", "M0 256H448c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256zm112 64c-8.8 0-16 7.2-16 16v96c0 8.8 7.2 16 16 16s16-7.2 16-16V336c0-8.8-7.2-16-16-16zm112 16c0-8.8-7.2-16-16-16s-16 7.2-16 16v96c0 8.8 7.2 16 16 16s16-7.2 16-16V336zm80-16c-8.8 0-16 7.2-16 16v96c0 8.8 7.2 16 16 16s16-7.2 16-16V336c0-8.8-7.2-16-16-16zm112 16c0-8.8-7.2-16-16-16s-16 7.2-16 16v96c0 8.8 7.2 16 16 16s16-7.2 16-16V336z"]],
    "blanket": [448, 512, [], "f498", ["M0 352V128C0 75 43 32 96 32H352c53 0 96 43 96 96V304c0-44.2-35.8-80-80-80H128C57.3 224 0 281.3 0 352z", "M128 288c-35.3 0-64 28.7-64 64s28.7 64 64 64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H128C57.3 480 0 422.7 0 352s57.3-128 128-128H368c44.2 0 80 35.8 80 80s-35.8 80-80 80H128c-17.7 0-32-14.3-32-32s14.3-32 32-32H368c8.8 0 16-7.2 16-16s-7.2-16-16-16H128z"]],
    "map-location": [576, 512, ["map-marked"], "f59f", ["M416 503V200.4c3.5-6.9 6.7-13.8 9.6-20.6c.5-1.2 1-2.5 1.5-3.7l116-46.4C558.9 123.4 576 135 576 152V422.8c0 9.8-6 18.6-15.1 22.3L416 503zM15.1 187.3l122.6-49c2.4 14.1 7.2 28.3 12.8 41.5c2.9 6.8 6.1 13.7 9.6 20.6V451.8L32.9 502.7C17.1 509 0 497.4 0 480.4V209.6c0-9.8 6-18.6 15.1-22.3zM384 255V504.3L192 449.4V255c20.5 31.3 42.3 59.6 56.2 77c20.5 25.6 59.1 25.6 79.6 0c13.9-17.4 35.7-45.7 56.2-77z", "M408 120c0 54.6-73.1 151.9-105.2 192c-7.7 9.6-22 9.6-29.6 0C241.1 271.9 168 174.6 168 120C168 53.7 221.7 0 288 0s120 53.7 120 120z"]],
    "house-flood-water": [576, 512, [], "e50e", ["M306.5 309.9c-11.1-7.9-25.9-7.9-37 0C247 325.4 219.5 336 192 336c-26.9 0-55.3-10.8-77.4-26.1l0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 389.7 159 400 192 400c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.5-27.3-10.1-39.2-1.7l0 0C439.4 325.2 410.9 336 384 336c-27.5 0-55-10.6-77.5-26.1zM384 448c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1l0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7l0 0C439.4 437.2 410.9 448 384 448z", "M306.8 6.1C295.6-2 280.4-2 269.2 6.1l-176 128c-11.2 8.2-15.9 22.6-11.6 35.8S98.1 192 112 192h16v73c1.7 1 3.3 2 4.9 3.1c18 12.4 40.1 20.3 59.2 20.3c21.1 0 42-8.5 59.2-20.3c22.1-15.5 51.6-15.5 73.7 0c18.4 12.7 39.6 20.3 59.2 20.3c19 0 41.2-7.9 59.2-20.3c1.5-1 3-2 4.5-2.9l-.3-73.2H464c13.9 0 26.1-8.9 30.4-22.1s-.4-27.6-11.6-35.8l-176-128z"]],
    "comments-question-check": [640, 512, [], "e14f", ["M208 352c114.9 0 208-78.8 208-176S322.9 0 208 0S0 78.8 0 176c0 38.6 14.7 74.3 39.6 103.4c-3.5 9.4-8.7 17.7-14.2 24.7c-4.8 6.2-9.7 11-13.3 14.3c-1.8 1.6-3.3 2.9-4.3 3.7c-.5 .4-.9 .7-1.1 .8l-.2 .2 0 0 0 0C1 327.2-1.4 334.4 .8 340.9S9.1 352 16 352c21.8 0 43.8-5.6 62.1-12.5c9.2-3.5 17.8-7.4 25.2-11.4C134.1 343.3 169.8 352 208 352zM136.2 108.4c6.6-18.6 24.2-31.1 44-31.1h48.5c29.1 0 52.6 23.6 52.6 52.6c0 18.8-10.1 36.3-26.4 45.6L228 191c-.2 10.9-9.1 19.6-20 19.6c-11 0-20-9-20-20V179.5c0-7.2 3.8-13.8 10-17.3L235 140.9c3.9-2.3 6.3-6.4 6.3-10.9c0-7-5.7-12.6-12.6-12.6H180.2c-2.8 0-5.3 1.8-6.3 4.4l-.4 1c-3.7 10.4-15.1 15.9-25.5 12.2s-15.9-15.1-12.2-25.5l.4-1zM181.3 264a26.7 26.7 0 1 1 53.3 0 26.7 26.7 0 1 1 -53.3 0z", "M136.2 108.4l-.4 1c-3.7 10.4 1.8 21.8 12.2 25.5s21.8-1.8 25.5-12.2l.4-1c.9-2.7 3.5-4.4 6.3-4.4h48.5c7 0 12.6 5.7 12.6 12.6c0 4.5-2.4 8.7-6.3 10.9L198 162.1c-6.2 3.6-10 10.2-10 17.3v11.2c0 11 9 20 20 20c10.9 0 19.8-8.8 20-19.6l26.9-15.4c16.3-9.4 26.4-26.8 26.4-45.6c0-29.1-23.6-52.6-52.6-52.6H180.2c-19.8 0-37.4 12.4-44 31.1zM234.7 264a26.7 26.7 0 1 0 -53.3 0 26.7 26.7 0 1 0 53.3 0zM448 176c0 112.3-99.1 196.9-216.5 207C255.8 457.4 336.4 512 432 512c38.2 0 73.9-8.7 104.7-23.9c7.5 3.9 16 7.9 25.3 11.4c18.3 6.9 40.3 12.5 62.1 12.5c6.9 0 13.1-4.5 15.2-11.1c2.1-6.6-.2-13.8-5.8-17.9l0 0 0 0-.2-.2c-.2-.2-.6-.4-1.1-.8c-1-.8-2.5-2-4.3-3.7c-3.6-3.3-8.5-8.1-13.3-14.3c-5.5-7-10.7-15.4-14.2-24.7c24.9-29 39.6-64.7 39.6-103.4c0-92.8-84.9-168.9-192.6-175.5c.4 5.1 .6 10.3 .6 15.5zm-33 17.6c-9.9 84.3-90 151-190.2 157.8l0 0c100.1-6.8 180.3-73.5 190.2-157.8zM566.1 318.1l-80 80c-7.8 7.8-20.5 7.8-28.3 0l-40-40c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0L472 355.7l65.9-65.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3z"]],
    "tree": [448, 512, [127794], "f1bb", ["M210.6 5.9L62 169.4c-3.9 4.2-6 9.8-6 15.5C56 197.7 66.3 208 79.1 208H104L30.6 281.4c-4.2 4.2-6.6 10-6.6 16C24 309.9 34.1 320 46.6 320H80L5.4 409.5C1.9 413.7 0 419 0 424.5c0 13 10.5 23.5 23.5 23.5H192V224c0-17.7 14.3-32 32-32s32 14.3 32 32V448H424.5c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L368 320h33.4c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L344 208h24.9c12.7 0 23.1-10.3 23.1-23.1c0-5.7-2.1-11.3-6-15.5L237.4 5.9C234 2.1 229.1 0 224 0s-10 2.1-13.4 5.9z", "M224 192c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V224c0-17.7 14.3-32 32-32z"]],
    "arrows-cross": [448, 512, [], "e0a2", ["M288 480H416c17.7 0 32-14.3 32-32V320c0-17.7-14.3-32-32-32s-32 14.3-32 32v50.7L269.3 256 224 301.3 338.7 416H288c-17.7 0-32 14.3-32 32s14.3 32 32 32zM178.7 256L224 210.7 54.6 41.4c-12.5-12.5-32.8-12.5-45.3 0S-3.1 74.1 9.4 86.6L178.7 256z", "M256 64c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32V192c0 17.7-14.3 32-32 32s-32-14.3-32-32V141.3L54.6 470.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L338.7 96H288c-17.7 0-32-14.3-32-32z"]],
    "backpack": [448, 512, [127890], "f5d4", ["M184 56c0-4.4 3.6-8 8-8h64c4.4 0 8 3.6 8 8V96h48V56c0-30.9-25.1-56-56-56H192c-30.9 0-56 25.1-56 56V96h48V56zM352 384H96V512H352V384z", "M0 224C0 153.3 57.3 96 128 96H320c70.7 0 128 57.3 128 128V448c0 35.3-28.7 64-64 64H352V400 336c0-26.5-21.5-48-48-48H144c-26.5 0-48 21.5-48 48v64V512H64c-35.3 0-64-28.7-64-64V224zm144-48c-8.8 0-16 7.2-16 16s7.2 16 16 16H304c8.8 0 16-7.2 16-16s-7.2-16-16-16H144z"]],
    "square-small": [320, 512, [], "e27e", ["M0 160c0-35.3 28.7-64 64-64H256c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160z", ""]],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", ["M512 416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H192c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8H448c35.3 0 64 28.7 64 64V416zM280 360V257.9l31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31V360c0 13.3 10.7 24 24 24s24-10.7 24-24z", "M256 384c13.3 0 24-10.7 24-24V257.9l31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31V360c0 13.3 10.7 24 24 24z"]],
    "bridge-lock": [640, 512, [], "e4cc", ["M64 32C46.3 32 32 46.3 32 64s14.3 32 32 32h40v64H32V288c53 0 96 43 96 96v64c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V384c0-53 43-96 96-96c28.8 0 54.6 12.7 72.2 32.7c5.6-10 13.9-18.4 23.8-24.1V272c0-61.9 50.1-112 112-112h8V96h40c17.7 0 32-14.3 32-32s-14.3-32-32-32H64zM488 96v64H408V96h80zM360 96v64H280V96h80zM232 96v64H152V96h80z", "M496 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "crosshairs-simple": [512, 512, [], "e59f", ["M256 64a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 448A256 256 0 1 0 256 0a256 256 0 1 0 0 512z", "M288 66.7c-10.4-1.7-21.1-2.7-32-2.7s-21.6 .9-32 2.7V128c0 17.7 14.3 32 32 32s32-14.3 32-32V66.7zM66.7 288H128c17.7 0 32-14.3 32-32s-14.3-32-32-32H66.7c-1.7 10.4-2.7 21.1-2.7 32s.9 21.6 2.7 32zM224 445.3c10.4 1.7 21.1 2.7 32 2.7s21.6-.9 32-2.7V384c0-17.7-14.3-32-32-32s-32 14.3-32 32v61.3zM445.3 224H384c-17.7 0-32 14.3-32 32s14.3 32 32 32h61.3c1.7-10.4 2.7-21.1 2.7-32s-.9-21.6-2.7-32z"]],
    "sack-dollar": [512, 512, [128176], "f81d", ["M192 96H320l47.4-71.1C374.5 14.2 366.9 0 354.1 0H157.9c-12.8 0-20.4 14.2-13.3 24.9L192 96zm128 32H192c-3.8 2.5-8.1 5.3-13 8.4l0 0 0 0C122.3 172.7 0 250.9 0 416c0 53 43 96 96 96H416c53 0 96-43 96-96c0-165.1-122.3-243.3-179-279.6c-4.8-3.1-9.2-5.9-13-8.4zm-64 68c11 0 20 9 20 20v13.9c7.5 1.2 14.6 2.9 21.1 4.7c10.7 2.8 17 13.8 14.2 24.5s-13.8 17-24.5 14.2c-11-2.9-21.6-5-31.2-5.2c-7.9-.1-16 1.8-21.5 5c-4.8 2.8-6.2 5.6-6.2 9.3c0 1.8 .1 3.5 5.3 6.7c6.3 3.8 15.5 6.7 28.3 10.5l.7 .2 0 0c11.2 3.4 25.6 7.7 37.1 15c12.9 8.1 24.3 21.3 24.6 41.6c.3 20.9-10.5 36.1-24.8 45c-7.2 4.5-15.2 7.3-23.2 9V424c0 11-9 20-20 20s-20-9-20-20V409.4c-10.3-2.2-20-5.5-28.2-8.4l0 0 0 0c-2.1-.7-4.1-1.4-6.1-2.1c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6c2.5 .8 4.9 1.7 7.2 2.4l0 0c13.6 4.6 24 8.1 35.1 8.5c8.6 .3 16.5-1.6 21.4-4.7c4.1-2.5 6-5.5 5.9-10.5c0-2.9-.8-5-5.9-8.2c-6.3-4-15.4-6.9-28-10.7l-1.7-.5c-10.9-3.3-24.6-7.4-35.6-14c-12.7-7.7-24.6-20.5-24.7-40.7c-.1-21.1 11.8-35.7 25.8-43.9c6.9-4.1 14.5-6.8 22.2-8.5V216c0-11 9-20 20-20z", "M192 96c-8.8 0-16 7.2-16 16s7.2 16 16 16H320c8.8 0 16-7.2 16-16s-7.2-16-16-16H192zm84 120c0-11-9-20-20-20s-20 9-20 20v14c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5l0 0c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1l0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4V424c0 11 9 20 20 20s20-9 20-20V410.2c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7V216z"]],
    "pen-to-square": [512, 512, ["edit"], "f044", ["M0 160c0-53 43-96 96-96h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H96c-17.7 0-32 14.3-32 32V416c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V320c0-17.7 14.3-32 32-32s32 14.3 32 32v96c0 53-43 96-96 96H96c-53 0-96-43-96-96V160z", "M392.4 21.7L362.3 51.7l97.9 97.9 30.1-30.1c21.9-21.9 21.9-57.3 0-79.2L471.6 21.7c-21.9-21.9-57.3-21.9-79.2 0zM339.7 74.3L172.4 241.7c-6.1 6.1-10.8 13.6-13.5 21.9l-29.6 88.8c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l88.8-29.6c8.2-2.7 15.7-7.4 21.9-13.5L437.7 172.3 339.7 74.3z"]],
    "square-sliders": [448, 512, ["sliders-h-square"], "f3f0", ["M384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0zm0-144c0 17.7-14.3 32-32 32l-32 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16L96 368c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0 0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 32 0c17.7 0 32 14.3 32 32zM352 144c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 160 0z", "M192 224c0 17.7-14.3 32-32 32s-32-14.3-32-32V128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96zM320 384c0 17.7-14.3 32-32 32s-32-14.3-32-32V288c0-17.7 14.3-32 32-32s32 14.3 32 32v96z"]],
    "car-side": [640, 512, [128663], "f5e4", ["M171.3 128H224v96H111.3l30.4-75.9c4.9-12.1 16.6-20.1 29.7-20.1zM272 224V128h81.2c9.7 0 18.9 4.4 25 12l67.2 84H272zM64 432a80 80 0 1 1 160 0A80 80 0 1 1 64 432zm432-80a80 80 0 1 1 0 160 80 80 0 1 1 0-160z", "M171.3 128H224v96H111.3l30.4-75.9c4.9-12.1 16.6-20.1 29.7-20.1zM272 224V128h81.2c9.7 0 18.9 4.4 25 12l67.2 84H272zm256.2 1l-100-125c-18.2-22.8-45.8-36-75-36H171.3c-39.3 0-74.6 23.9-89.1 60.3L40.6 228.4C16.8 237.8 0 260.9 0 288V400c0 17.7 14.3 32 32 32c0-61.9 50.1-112 112-112s112 50.1 112 112H384c0-61.9 50.1-112 112-112s112 50.1 112 112c17.7 0 32-14.3 32-32V352c0-65.2-48.8-119-111.8-127z"]],
    "message-middle-top": [512, 512, ["comment-middle-top-alt"], "e1e2", ["M343.5 96H448c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160c0-35.3 28.7-64 64-64H168.5L243.7 5.8c3-3.6 7.5-5.8 12.3-5.8s9.3 2.1 12.3 5.8L343.5 96z", ""]],
    "lightbulb-on": [640, 512, [], "f672", ["M449.2 297.8c-19.8 27.1-39.7 54.4-49.2 86.2H240c-9.6-31.9-29.5-59.1-49.2-86.2c-5.2-7.1-10.4-14.2-15.4-21.4C155.6 247.9 144 213.3 144 176C144 78.8 222.8 0 320 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4zM240 176c0-44.2 35.8-80 80-80c8.8 0 16-7.2 16-16s-7.2-16-16-16c-61.9 0-112 50.1-112 112c0 8.8 7.2 16 16 16s16-7.2 16-16z", "M69.3 4l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3S58.3-3.3 69.3 4zM597.3 44l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zM24 160H88c13.3 0 24 10.7 24 24s-10.7 24-24 24H24c-13.3 0-24-10.7-24-24s10.7-24 24-24zm528 0h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H552c-13.3 0-24-10.7-24-24s10.7-24 24-24zM117.3 332l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zm432-39.9l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3s22.3-14 33.3-6.7zM400 432c0 44.2-35.8 80-80 80s-80-35.8-80-80V384H400v48z"]],
    "knife": [512, 512, ["utensil-knife"], "f2e4", ["M459.5 7.3L201.4 265.4l59.9 59.9c12 12 28.3 18.7 45.3 18.7h11c17 0 33.2-6.8 45.3-18.7C455.7 233.9 512 186.1 512 96c0-24.5-6.7-57.4-11.4-77.6C498.1 7.5 488.2 0 477.1 0c-6.6 0-12.9 2.6-17.6 7.3z", "M217.4 249.4l-16 16 45.3 45.3-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l208-208z"]],
    "share-nodes": [448, 512, ["share-alt"], "f1e0", ["M285.4 197.1c-15.4-14.9-25.9-34.9-28.6-57.2l-94.1 47c15.4 14.9 25.9 34.9 28.6 57.2l94.1-47zm-94.1 70.8c-2.8 22.4-13.2 42.4-28.6 57.2l94.1 47c2.8-22.4 13.2-42.4 28.6-57.2l-94.1-47z", "M256 128a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zM0 256a96 96 0 1 1 192 0A96 96 0 1 1 0 256zm352 32a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]],
    "display-chart-up-circle-dollar": [640, 512, [], "e5e6", ["M64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64H240l-10.7 32H160c-17.7 0-32 14.3-32 32s14.3 32 32 32H394.8C349.5 480.1 320 427.5 320 368c0-5.4 .2-10.7 .7-16H64V64H512V192.7c22.9 2.1 44.5 8.5 64 18.5V64c0-35.3-28.7-64-64-64H64zM480 192.7V120c0-13.3-10.7-24-24-24H376c-13.3 0-24 10.7-24 24s10.7 24 24 24h22.1L304 238.1l-63-63c-9.4-9.4-24.6-9.4-33.9 0L103 279c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l87-87 63 63c4.5 4.5 10.6 7 17 7s12.5-2.5 17-7l111-111V200c0 1.3 .1 2.6 .3 3.9c15-5.8 31-9.7 47.7-11.2z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM472.1 339l0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2v10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16V438.1c-8.6-1.7-16.7-4.3-23.7-6.6l0 0c-1.7-.6-3.4-1.1-5-1.6c-8.4-2.6-13.2-11.6-10.5-20s11.6-13.2 20-10.5c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3V288c0-8.8 7.2-16 16-16s16 7.2 16 16v9.4c6.3 .9 12.3 2.3 17.9 3.7c8.6 2.1 13.8 10.8 11.7 19.4s-10.8 13.8-19.4 11.7c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"]],
    "wave-sine": [640, 512, [8767], "f899", ["M63.4 230.3l0-.1 .2-1c.2-.9 .5-2.4 1-4.3c1-3.8 2.5-9.4 4.6-16.2C73.6 195 80.3 177 90 159.4C110.2 122.8 137.8 96 176 96c29 0 49.1 14.4 67 44.4c19 31.8 31.9 75.4 46.3 124.5c.2 .8 .5 1.6 .7 2.4c13.5 46.2 28.4 97.5 52 137c25.1 42 63 75.6 122 75.6c73.8 0 118.2-53.2 142-96.6c12.3-22.4 20.6-44.5 25.7-60.8c2.6-8.2 4.5-15.1 5.7-20c.6-2.5 1.1-4.4 1.4-5.9c.2-.7 .3-1.3 .4-1.7l.1-.5 0-.2 0-.1 0 0c0 0 0 0-31.4-6.3l31.4 6.3c3.5-17.3-7.8-34.2-25.1-37.7s-34.2 7.8-37.7 25.1l0 0 0 .1-.2 1c-.2 .9-.5 2.4-1 4.3c-1 3.8-2.5 9.4-4.6 16.2c-4.3 13.7-11.1 31.6-20.8 49.2c-20.1 36.6-47.8 63.4-86 63.4c-29 0-49.1-14.4-67-44.4c-19-31.8-31.9-75.4-46.3-124.5c-.2-.8-.5-1.6-.7-2.4c-13.5-46.2-28.4-97.5-52-137C272.9 65.6 235 32 176 32C102.2 32 57.8 85.2 34 128.6C21.7 151 13.4 173 8.2 189.3c-2.6 8.2-4.5 15.1-5.7 20c-.6 2.5-1.1 4.4-1.4 5.9c-.2 .7-.3 1.3-.4 1.7l-.1 .5 0 .2 0 .1 0 0c0 0 0 0 31.4 6.3L.6 217.7c-3.5 17.3 7.8 34.2 25.1 37.7s34.2-7.8 37.7-25.1", ""]],
    "heart-circle-minus": [576, 512, [], "e4ff", ["M228.3 469.1L47.6 300.4C17.2 272.1 0 232.4 0 190.9v-5.8c0-69.9 50.5-129.5 119.4-141C165 36.5 211.4 51.4 244 84l12 12 12-12c32.6-32.6 79-47.5 124.6-39.9C461.5 55.6 512 115.2 512 185.1v5.8c0 6.6-.4 13.2-1.3 19.6C487 198.7 460.3 192 432 192c-97.2 0-176 78.8-176 176c0 36.6 11.2 70.6 30.3 98.7l-2.6 2.4c-7.5 7-17.4 10.9-27.7 10.9s-20.2-3.9-27.7-10.9z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm64-128l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16H496c8.8 0 16 7.2 16 16s-7.2 16-16 16z"]],
    "circle-w": [512, 512, [], "e12c", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM150.9 168.7L192 297.3l41.1-128.6c3.2-9.9 12.4-16.7 22.9-16.7s19.7 6.7 22.9 16.7L320 297.3l41.1-128.6c4-12.6 17.5-19.6 30.2-15.5s19.6 17.5 15.5 30.2l-64 200c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7L256 254.7 214.9 383.3c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7l-64-200c-4-12.6 2.9-26.1 15.5-30.2s26.1 2.9 30.2 15.5z", "M120.7 153.1c12.6-4 26.1 2.9 30.2 15.5L192 297.3l41.1-128.6c3.2-9.9 12.4-16.7 22.9-16.7s19.7 6.7 22.9 16.7L320 297.3l41.1-128.6c4-12.6 17.5-19.6 30.2-15.5s19.6 17.5 15.5 30.2l-64 200c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7L256 254.7 214.9 383.3c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7l-64-200c-4-12.6 2.9-26.1 15.5-30.2z"]],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 96c8.8 0 16 7.2 16 16v16h64V112c0-8.8 7.2-16 16-16s16 7.2 16 16v16h32c17.7 0 32 14.3 32 32v64V352c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V224 160c0-17.7 14.3-32 32-32h32V112c0-8.8 7.2-16 16-16z", "M192 112c0-8.8 7.2-16 16-16s16 7.2 16 16v16h64V112c0-8.8 7.2-16 16-16s16 7.2 16 16v16h32c17.7 0 32 14.3 32 32v64H128V160c0-17.7 14.3-32 32-32h32V112z"]],
    "hourglass-half": [384, 512, ["hourglass-2"], "f252", ["M32 437v11H96V437c0-25.5 10.1-49.9 28.1-67.9L192 301.3l67.9 67.9c18 18 28.1 42.4 28.1 67.9v11h64V437c0-42.4-16.9-83.1-46.9-113.1L237.3 256l67.9-67.9c30-30 46.9-70.7 46.9-113.1V64H288V75c0 25.5-10.1 49.9-28.1 67.9L192 210.7l-67.9-67.9C106.1 124.9 96 100.4 96 75V64H32V75c0 42.4 16.9 83.1 46.9 113.1L146.7 256 78.9 323.9l22.6 22.6L78.9 323.9C48.9 353.9 32 394.6 32 437z", "M0 32C0 49.7 14.3 64 32 64H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H32C14.3 0 0 14.3 0 32zM0 480c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H288V437c0-19-5.6-37.4-16-53H112c-10.3 15.6-16 34-16 53v11H32c-17.7 0-32 14.3-32 32zM259.9 142.9c4.6-4.6 8.6-9.6 12.1-14.9H112c3.5 5.3 7.6 10.3 12.1 14.9L192 210.7l67.9-67.9z"]],
    "microscope": [512, 512, [128300], "f610", ["M192 0c-17.7 0-32 14.3-32 32h96c0-17.7-14.3-32-32-32H192zM112 384c-8.8 0-16 7.2-16 16s7.2 16 16 16H304c8.8 0 16-7.2 16-16s-7.2-16-16-16H112z", "M128 64c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32V288c0 17.7-14.3 32-32 32c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32c-17.7 0-32-14.3-32-32V64zM512 320c0 49.2-18.5 94-48.9 128H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H320 32c-17.7 0-32-14.3-32-32s14.3-32 32-32H320c70.7 0 128-57.3 128-128s-57.3-128-128-128V128c106 0 192 86 192 192z"]],
    "sunset": [576, 512, [127751], "f767", ["M403.1 237.1c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L288 289.1l-90.3-62.3c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L153 345 45.1 364.9c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L86.1 464H161c7.9-63.1 61.7-112 127-112s119.1 48.9 127 112h74.9l51.3-74.3c3.1-4.5 3.7-10.2 1.6-15.2s-6.6-8.6-11.9-9.6L423 345 403.1 237.1zM382.7 464c-7.6-45.4-47.1-80-94.7-80s-87.1 34.6-94.7 80H382.7z", "M354.5 104.3L320 135.7V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V135.7l-34.5-31.3c-13.1-11.9-33.3-10.9-45.2 2.2s-10.9 33.3 2.2 45.2l88 80c12.2 11.1 30.8 11.1 43.1 0l88-80c13.1-11.9 14-32.1 2.2-45.2s-32.1-14-45.2-2.2zM24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24H552c13.3 0 24-10.7 24-24s-10.7-24-24-24H24z"]],
    "sink": [512, 512, [], "e06d", ["M32 288c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H32zm448 96H32v32c0 53 43 96 96 96H384c53 0 96-43 96-96V384z", "M288 96c0-17.7 14.3-32 32-32s32 14.3 32 32s14.3 32 32 32s32-14.3 32-32c0-53-43-96-96-96s-96 43-96 96V288h64V96zM56 208c-13.3 0-24 10.7-24 24s10.7 24 24 24h48c4.4 0 8 3.6 8 8v24h48V264c0-30.9-25.1-56-56-56H56zm344 56c0-4.4 3.6-8 8-8h56c13.3 0 24-10.7 24-24s-10.7-24-24-24H408c-30.9 0-56 25.1-56 56v24h48V264z"]],
    "calendar-exclamation": [448, 512, [], "f334", ["M0 192H448V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V192zM256 432a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-8-176c0-13.3-10.7-24-24-24s-24 10.7-24 24v96c0 13.3 10.7 24 24 24s24-10.7 24-24V256z", "M96 32c0-17.7 14.3-32 32-32s32 14.3 32 32V64H288V32c0-17.7 14.3-32 32-32s32 14.3 32 32V64h48c26.5 0 48 21.5 48 48v80H0V112C0 85.5 21.5 64 48 64H96V32zm96 400a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm56-176v96c0 13.3-10.7 24-24 24s-24-10.7-24-24V256c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "truck-container-empty": [640, 512, [], "e2b5", ["M96 352a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm160 0a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm288 0a64 64 0 1 0 0 128 64 64 0 1 0 0-128z", "M456 144c-13.3 0-24 10.7-24 24v88 32 16H32c-17.7 0-32 14.3-32 32v16c0 8.8 3.6 16.8 9.4 22.6C24.8 342.3 57.8 320 96 320c33.4 0 62.8 17 80 42.9C193.2 337 222.6 320 256 320c41.8 0 77.4 26.7 90.5 64H432h21.5c13.2-37.3 48.7-64 90.5-64c38.2 0 71.2 22.3 86.6 54.6c5.8-5.8 9.4-13.8 9.4-22.6V288 272 261.7c0-9.2-3.2-18.2-9-25.3l-58.8-71.8c-10.6-13-26.5-20.5-43.3-20.5H456zM585 256H480V192h48.8c2.4 0 4.7 1.1 6.2 2.9L585 256z"]],
    "hand-heart": [512, 512, [], "f4bc", ["M256 0c17.7 0 32 14.3 32 32V240c0 8.8 7.2 16 16 16s16-7.2 16-16V64c0-17.7 14.3-32 32-32s32 14.3 32 32V240c0 8.8 7.2 16 16 16s16-7.2 16-16V128c0-17.7 14.3-32 32-32s32 14.3 32 32V336c0 97.2-78.8 176-176 176H284.8c-59.6 0-116.9-22.9-160-64L12.4 341c-16-15.2-16.6-40.6-1.4-56.6s40.6-16.6 56.6-1.4l60.5 57.6c0-1.5-.1-3.1-.1-4.6V64c0-17.7 14.3-32 32-32s32 14.3 32 32V240c0 8.8 7.2 16 16 16s16-7.2 16-16V32c0-17.7 14.3-32 32-32zM208 362.6c0 12.1 5.1 23.6 14.1 31.6l55.2 49.7c6.1 5.5 15.3 5.5 21.4 0l55.2-49.7c9-8.1 14.1-19.6 14.1-31.6c0-23.5-19.1-42.6-42.6-42.6h-1.1c-14.6 0-28.3 7.3-36.4 19.5c-8.1-12.2-21.7-19.5-36.4-19.5h-1.1c-23.5 0-42.6 19.1-42.6 42.6z", "M250.6 320c-23.5 0-42.6 19.1-42.6 42.6c0 12.1 5.1 23.6 14.1 31.6l55.2 49.7c6.1 5.5 15.3 5.5 21.4 0l55.2-49.7c9-8.1 14.1-19.6 14.1-31.6c0-23.5-19.1-42.6-42.6-42.6h-1.1c-14.6 0-28.3 7.3-36.4 19.5c-8.1-12.2-21.7-19.5-36.4-19.5h-1.1z"]],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", ["M288 160H160v72c0 13.3-10.7 24-24 24s-24-10.7-24-24V160H48c-26.5 0-48 21.5-48 48V416c0 53 43 96 96 96H352c53 0 96-43 96-96V208c0-26.5-21.5-48-48-48H336v72c0 13.3-10.7 24-24 24s-24-10.7-24-24V160z", "M224 48c-35.3 0-64 28.7-64 64V232c0 13.3-10.7 24-24 24s-24-10.7-24-24V112C112 50.1 162.1 0 224 0s112 50.1 112 112V232c0 13.3-10.7 24-24 24s-24-10.7-24-24V112c0-35.3-28.7-64-64-64z"]],
    "arrow-down-z-a": [576, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", ["M352 96c-17.7 0-32-14.3-32-32s14.3-32 32-32H480c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9L429.3 160H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H352c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L402.7 96H352zm64 160c12.1 0 23.2 6.8 28.6 17.7l64 128 16 32c7.9 15.8 1.5 35-14.3 42.9s-35 1.5-42.9-14.3L460.2 448H371.8l-7.2 14.3c-7.9 15.8-27.1 22.2-42.9 14.3s-22.2-27.1-14.3-42.9l16-32 64-128c5.4-10.8 16.5-17.7 28.6-17.7zM395.8 400h40.4L416 359.6 395.8 400z", "M160 480c9 0 17.5-3.8 23.6-10.4l88-96c11.9-13 11.1-33.3-2-45.2s-33.3-11.1-45.2 2L192 365.7V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V365.7L95.6 330.4c-11.9-13-32.2-13.9-45.2-2s-13.9 32.2-2 45.2l88 96C142.5 476.2 151 480 160 480z"]],
    "mitten": [448, 512, [], "f7b5", ["M64 384c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V416c0-17.7-14.3-32-32-32H64z", "M314.7 234.7L283.2 108.9C267.2 44.9 209.7 0 143.8 0h-3.4C62.8 0 0 62.8 0 140.3c0 13 1.8 26 5.4 38.6L64 384H352l79.2-85.8c10.8-11.7 16.8-27 16.8-42.9c0-34.9-28.3-63.3-63.3-63.3H382c-19 0-37.2 8.2-49.7 22.6l-17.6 20.1z"]],
    "reply-clock": [640, 512, ["reply-time"], "e239", ["M511.2 319.4c-5 .4-10.1 .6-15.2 .6c-91.8 0-167.2-70.3-175.3-160H224V96c0-12.6-7.4-24.1-19-29.2s-25-3-34.4 5.4l-160 144C3.9 222.3 0 230.9 0 240s3.9 17.7 10.6 23.8l160 144c9.4 8.5 22.9 10.6 34.4 5.4s19-16.6 19-29.2V320h96c53 0 96 43 96 96c0 30.4-12.8 47.9-22.2 56.7c-5.5 5.1-9.8 12-9.8 19.5c0 10.9 8.8 19.7 19.7 19.7c2.8 0 5.6-.6 8.1-1.9C430.5 499.9 512 449.3 512 336c0-5.6-.3-11.2-.8-16.6z", "M496 288A144 144 0 1 0 496 0a144 144 0 1 0 0 288zM512 80v48h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H496c-8.8 0-16-7.2-16-16V80c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "person-rays": [512, 512, [], "e54d", ["M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 304V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V256.9l-28.6 47.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l58.3-97c17.4-28.9 48.6-46.6 82.3-46.6h29.7c33.7 0 64.9 17.7 82.3 46.6l58.3 97c9.1 15.1 4.2 34.8-10.9 43.9s-34.8 4.2-43.9-10.9L328 256.9V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H248z", "M41 7C31.6-2.3 16.4-2.3 7 7S-2.3 31.6 7 41l80 80c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L41 7zM471 7L391 87c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0zM7 505c9.4 9.4 24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L7 471c-9.4 9.4-9.4 24.6 0 33.9zm464 0c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l80 80z"]],
    "right": [448, 512, [11157, "arrow-alt-right"], "f356", ["M224 192V320L40 320c-22.1 0-40-17.9-40-40V232c0-22.1 17.9-40 40-40H224z", "M224 320h0l0 96c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 96h0V320z"]],
    "circle-f": [512, 512, [], "e10e", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H208v64h88c13.3 0 24 10.7 24 24s-10.7 24-24 24H208v72c0 13.3-10.7 24-24 24s-24-10.7-24-24V264 152c0-13.3 10.7-24 24-24z", "M160 152c0-13.3 10.7-24 24-24H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H208v64h88c13.3 0 24 10.7 24 24s-10.7 24-24 24H208v72c0 13.3-10.7 24-24 24s-24-10.7-24-24V264 152z"]],
    "users": [640, 512, [], "f0c0", ["M224 80A80 80 0 1 0 64 80a80 80 0 1 0 160 0zm368 0A80 80 0 1 0 432 80a80 80 0 1 0 160 0zM106.7 192C47.8 192 0 239.8 0 298.7C0 310.4 9.6 320 21.3 320H234.7c.2 0 .4 0 .7 0c-26.6-23.5-43.3-57.8-43.3-96c0-7.6 .7-15 1.9-22.3c-13.6-6.3-28.7-9.7-44.6-9.7H106.7zm298 128c.2 0 .4 0 .7 0H618.7c11.8 0 21.3-9.6 21.3-21.3C640 239.8 592.2 192 533.3 192H490.7c-15.9 0-31 3.5-44.6 9.7c1.3 7.2 1.9 14.7 1.9 22.3c0 38.2-16.8 72.5-43.3 96z", "M320 320a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm-58.7 32C187.7 352 128 411.7 128 485.3c0 14.7 11.9 26.7 26.7 26.7H485.3c14.7 0 26.7-11.9 26.7-26.7C512 411.7 452.3 352 378.7 352H261.3z"]],
    "face-pleading": [512, 512, [], "e386", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM302.7 427.9c6.6-5.9 7.1-16 1.2-22.6C294.7 395.1 278.7 384 256 384s-38.7 11.1-47.9 21.3c-5.9 6.6-5.4 16.7 1.2 22.6s16.7 5.4 22.6-1.2c4.7-5.3 12.7-10.7 24.1-10.7s19.4 5.4 24.1 10.7c5.9 6.6 16 7.1 22.6 1.2zM240 240c0-41.5-31.5-75.6-72-79.6c10-10.8 17.6-24.1 21.9-38.8l1.5-5.2c2.4-8.5-2.5-17.4-11-19.8s-17.4 2.5-19.8 11l-1.5 5.2c-7 24.7-28.1 42.7-53.6 45.9L94 160.1c-8.8 1.1-15 9.1-13.9 17.9c1 8.1 7.9 14 15.9 14c-10 13.4-16 30-16 48c0 44.2 35.8 80 80 80s80-35.8 80-80zm192 0c0-18-6-34.6-16-48c8 0 14.9-5.9 15.9-14c1.1-8.8-5.1-16.8-13.9-17.9l-11.5-1.4c-25.5-3.2-46.6-21.3-53.6-45.9l-1.5-5.2c-2.4-8.5-11.3-13.4-19.8-11s-13.4 11.3-11 19.8l1.5 5.2c4.2 14.8 11.8 28 21.9 38.8c-40.4 4-72 38.1-72 79.6c0 44.2 35.8 80 80 80s80-35.8 80-80z", "M191.4 116.4l-1.5 5.2c-10.6 37-42.2 64.1-80.4 68.9L98 191.9c-8.8 1.1-16.8-5.1-17.9-13.9s5.1-16.8 13.9-17.9l11.5-1.4c25.5-3.2 46.6-21.3 53.6-45.9l1.5-5.2c2.4-8.5 11.3-13.4 19.8-11s13.4 11.3 11 19.8zm129.2 0c-2.4-8.5 2.5-17.4 11-19.8s17.4 2.5 19.8 11l1.5 5.2c7 24.7 28.1 42.7 53.6 45.9l11.5 1.4c8.8 1.1 15 9.1 13.9 17.9s-9.1 15-17.9 13.9l-11.5-1.4c-38.2-4.8-69.8-31.9-80.4-68.9l-1.5-5.2zM128 232c17.7 0 32-14.3 32-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4c17.7 0 32-14.3 32-32z"]],
    "eye-slash": [640, 512, [], "f070", ["M360.8 380.3C339.4 392.8 314.6 400 288 400c-79.5 0-144-64.5-144-144c0-14.5 2.1-28.5 6.1-41.7L63.5 146c-29.4 34.7-49.9 70.8-61.1 97.6c-3.3 7.9-3.3 16.7 0 24.6C17.3 304 48.6 356 95.4 399.4C142.5 443.2 207.2 480 288 480c56.1 0 104.4-17.8 144.5-43.2l-71.7-56.5zM198.5 252.4c-3.7 .8-6.7 3.7-6.5 7.7c.3 6.9 1.3 13.8 3.2 20.7c13.7 51.2 66.4 81.6 117.6 67.9c1.9-.5 3.9-1.1 5.7-1.7l-120-94.6zm89-52.4l94.8 74.3c2.7-13.9 2.4-28.6-1.5-43.2c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7c2.1 6.4 3.3 13.2 3.3 20.3c0 2.7-.2 5.4-.5 8zM432 256c0 17.7-3.2 34.6-9 50.2l84.1 65.9c32.3-36.6 54.6-75.4 66.4-103.9c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C433.5 68.8 368.8 32 288 32c-60 0-111.1 20.3-152.8 48.7L207 136.9c23.1-15.7 51-24.9 81-24.9c79.5 0 144 64.5 144 144z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "flask-vial": [640, 512, [], "e4f3", ["M175 389.4l49-79.6V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H160 96 32C14.3 0 0 14.3 0 32S14.3 64 32 64V352c0 53 43 96 96 96c11.2 0 22-1.9 32-5.5c0-18.7 5.2-37.1 15-53.1zM96 64h64v96H96V64z", "M480 0H352 320c-17.7 0-32 14.3-32 32s14.3 32 32 32V214.9L202.3 406.2c-6.7 10.9-10.3 23.5-10.3 36.4c0 38.3 31.1 69.4 69.4 69.4H570.6c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L512 214.9V64c17.7 0 32-14.3 32-32s-14.3-32-32-32H480zM384 224V64h64V224c0 5.9 1.6 11.7 4.7 16.8L501.5 320h-171l48.8-79.2c3.1-5 4.7-10.8 4.7-16.8z"]],
    "police-box": [384, 512, [], "e021", ["M208 16c0-8.8-7.2-16-16-16s-16 7.2-16 16V32h32V16zM104 128c-4.4 0-8 3.6-8 8v24h32V128H104zm24 48H96v24c0 4.4 3.6 8 8 8h24V176zm16-48v32h32V136c0-4.4-3.6-8-8-8H144zm32 48H144v32h24c4.4 0 8-3.6 8-8V176zM24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24H360c13.3 0 24-10.7 24-24s-10.7-24-24-24H24zM208 136v24h32V128H216c-4.4 0-8 3.6-8 8zm0 40v24c0 4.4 3.6 8 8 8h24V176H208zm72-48H256v32h32V136c0-4.4-3.6-8-8-8zm-24 48v32h24c4.4 0 8-3.6 8-8V176H256z", "M96 32C78.3 32 64 46.3 64 64C46.3 64 32 78.3 32 96V464H352V96c0-17.7-14.3-32-32-32c0-17.7-14.3-32-32-32H96zm0 104c0-4.4 3.6-8 8-8h24v32H96V136zm0 40h32v32H104c-4.4 0-8-3.6-8-8V176zm72-48c4.4 0 8 3.6 8 8v24H144V128h24zm-24 48h32v24c0 4.4-3.6 8-8 8H144V176zm72-48h24v32H208V136c0-4.4 3.6-8 8-8zm24 48v32H216c-4.4 0-8-3.6-8-8V176h32zm16-48h24c4.4 0 8 3.6 8 8v24H256V128zm32 48v24c0 4.4-3.6 8-8 8H256V176h32zM96 256c0-8.8 7.2-16 16-16h48c8.8 0 16 7.2 16 16v48c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V256z"]],
    "cucumber": [512, 512, [129362], "e401", ["M376 112a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM280 272a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-136 8a24 24 0 1 1 0 48 24 24 0 1 1 0-48z", "M37.5 474.5c47.8 47.8 124 49.9 174.3 6.3c12.6 10.3 31.1 9.6 42.9-2.2c11.6-11.6 12.4-30 2.4-42.6L436 257c12.6 10.1 31 9.3 42.6-2.4c11.7-11.7 12.5-30.3 2.2-42.9c43.6-50.3 41.5-126.5-6.3-174.3c-50-50-131-50-181 0L172 159c-12.6-10.1-31-9.3-42.6 2.4s-12.4 30-2.4 42.6L37.5 293.5c-50 50-50 131 0 181zM400 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM304 248a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM120 304a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "head-side-brain": [512, 512, [], "f808", ["M0 224.2C0 100.6 100.2 0 224 0h24c95.2 0 181.2 69.3 197.3 160.2c2.3 13 6.8 25.7 15.1 36l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8H448v64c0 35.3-28.7 64-64 64H320v32c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V407.3c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2zM285.3 208H336c26.5 0 48-21.5 48-48s-21.5-48-48-48c-.9 0-1.8 0-2.7 .1C326.7 93.4 308.9 80 288 80c-8.6 0-16.6 2.2-23.5 6.2C255.9 72.8 241 64 224 64s-31.9 8.8-40.5 22.2c-7-3.9-15-6.2-23.5-6.2c-26.5 0-48 21.5-48 48c-26.5 0-48 21.5-48 48c0 20.9 13.4 38.7 32.1 45.3c0 .9-.1 1.8-.1 2.7c0 26.5 21.5 48 48 48c5.6 0 11-1 16-2.7V288c0 17.7 14.3 32 32 32s32-14.3 32-32V269.3c5 1.8 10.4 2.7 16 2.7c26.5 0 48-21.5 48-48c0-5.6-1-11-2.7-16zM160 176v2.7l-.1 0c0-.9 .1-1.8 .1-2.7z", "M336 208H285.3c1.8 5 2.7 10.4 2.7 16c0 26.5-21.5 48-48 48c-5.6 0-11-1-16-2.7V288c0 17.7-14.3 32-32 32s-32-14.3-32-32V269.3c-5 1.8-10.4 2.7-16 2.7c-26.5 0-48-21.5-48-48c0-.9 0-1.8 .1-2.7C77.4 214.7 64 196.9 64 176c0-26.5 21.5-48 48-48c0-26.5 21.5-48 48-48c8.6 0 16.6 2.2 23.5 6.2C192.1 72.8 207 64 224 64s31.9 8.8 40.5 22.2c7-3.9 15-6.2 23.5-6.2c20.9 0 38.7 13.4 45.3 32.1c.9 0 1.8-.1 2.7-.1c26.5 0 48 21.5 48 48s-21.5 48-48 48zM159.9 178.7l.1 0V176c0 .9 0 1.8-.1 2.7z"]],
    "hand": [512, 512, [129306, 9995, "hand-paper"], "f256", ["M256 0c17.7 0 32 14.3 32 32V240c0 8.8 7.2 16 16 16s16-7.2 16-16V64c0-17.7 14.3-32 32-32s32 14.3 32 32V240c0 8.8 7.2 16 16 16s16-7.2 16-16V128c0-17.7 14.3-32 32-32s32 14.3 32 32V336c0 97.2-78.8 176-176 176H284.8c-59.6 0-116.9-22.9-160-64L12.4 341c-16-15.2-16.6-40.6-1.4-56.6s40.6-16.6 56.6-1.4l60.5 57.6c0-1.5-.1-3.1-.1-4.6V64c0-17.7 14.3-32 32-32s32 14.3 32 32V240c0 8.8 7.2 16 16 16s16-7.2 16-16V32c0-17.7 14.3-32 32-32zM192 336c0 8.8 7.2 16 16 16h8c39.8 0 72 32.2 72 72v8c0 8.8 7.2 16 16 16s16-7.2 16-16v-8c0-27.9-11-53.3-29-72h77c8.8 0 16-7.2 16-16s-7.2-16-16-16H216h-8c-8.8 0-16 7.2-16 16z", "M208 320c-8.8 0-16 7.2-16 16s7.2 16 16 16h8c39.8 0 72 32.2 72 72v8c0 8.8 7.2 16 16 16s16-7.2 16-16v-8c0-27.9-11-53.3-29-72h77c8.8 0 16-7.2 16-16s-7.2-16-16-16H216h-8z"]],
    "person-biking-mountain": [640, 512, [128693, "biking-mountain"], "f84b", ["M96.2 276.6C97.9 264.9 107.9 256 120 256h16c12.1 0 22.1 8.9 23.8 20.6c7.6 2.2 14.9 5.3 21.7 9c9.4-7 22.8-6.3 31.3 2.3l11.3 11.3c8.6 8.6 9.3 21.9 2.3 31.3c3.7 6.8 6.8 14.1 9 21.7c11.6 1.7 20.6 11.7 20.6 23.8v16c0 12.1-8.9 22.1-20.6 23.8c-2.2 7.6-5.3 14.9-9 21.7c7 9.4 6.3 22.8-2.3 31.3l-11.3 11.3c-8.6 8.6-21.9 9.3-31.3 2.2c-6.8 3.7-14.1 6.8-21.7 9C158.1 503.1 148.1 512 136 512H120c-12.1 0-22.1-8.9-23.8-20.6c-7.6-2.2-14.9-5.3-21.7-9c-9.4 7.1-22.8 6.3-31.3-2.2L31.8 468.9c-8.6-8.6-9.3-21.9-2.3-31.3c-3.7-6.9-6.8-14.1-9-21.8C8.9 414.1 0 404.1 0 392V376c0-12.1 8.9-22.1 20.6-23.8c2.2-7.6 5.3-14.9 9-21.8c-7-9.4-6.3-22.8 2.3-31.3l11.3-11.3c8.6-8.6 21.9-9.3 31.3-2.3c6.8-3.7 14.1-6.8 21.7-9zM192 384A64 64 0 1 0 64 384a64 64 0 1 0 128 0zM480.2 276.6c1.7-11.6 11.7-20.6 23.8-20.6h16c12.1 0 22.1 8.9 23.8 20.6c7.6 2.2 14.9 5.3 21.8 9c9.4-7 22.8-6.3 31.3 2.3l11.3 11.3c8.6 8.6 9.3 21.9 2.2 31.3c3.7 6.8 6.8 14.1 9 21.7c11.6 1.7 20.6 11.7 20.6 23.8v16c0 12.1-8.9 22.1-20.6 23.8c-2.2 7.6-5.3 14.9-9 21.7c7 9.4 6.3 22.8-2.2 31.3l-11.3 11.3c-8.6 8.6-21.9 9.3-31.3 2.2c-6.9 3.7-14.1 6.8-21.8 9C542.1 503.1 532.1 512 520 512H504c-12.1 0-22.1-8.9-23.8-20.6c-7.6-2.2-14.9-5.3-21.7-9c-9.4 7.1-22.8 6.3-31.3-2.2l-11.3-11.3c-8.6-8.6-9.3-21.9-2.2-31.3c-3.7-6.9-6.8-14.1-9-21.8C392.9 414.1 384 404.1 384 392V376c0-12.1 8.9-22.1 20.6-23.8c2.2-7.6 5.3-14.9 9-21.8c-7-9.4-6.3-22.8 2.2-31.3l11.3-11.3c8.6-8.6 21.9-9.3 31.3-2.3c6.8-3.7 14.1-6.8 21.7-9zM576 384a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z", "M448 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM427.2 160l-61.8-48.8c-17.3-13.6-41.7-13.8-59.1-.3l-83.1 64.2c-30.7 23.8-28.5 70.8 4.3 91.6L288 305.1V416c0 17.7 14.3 32 32 32s32-14.3 32-32V288c0-10.7-5.3-20.7-14.2-26.6L295 232.9l60.3-48.5L396 217c5.7 4.5 12.7 7 20 7h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H427.2zm-238.8 6.7L290.8 89.9c7.2-5.4 8.5-15.7 2.9-22.8L278.8 48.4c-21.6-27-60.7-32-88.4-11.2L125.2 86.1c-7.2 5.4-8.5 15.7-2.9 22.8l44 55c5.4 6.7 15.2 8 22.1 2.8z"]],
    "utensils-slash": [640, 512, [], "e464", ["M544 401.1V352 240 32c0-17.7-14.3-32-32-32C496 0 384 32 384 176v99.7L544 401.1zM306.4 214.9c8.6-13.6 13.6-29.7 13.6-47c0-6.4-.7-12.8-2.1-19.1L287.6 12.5c-1.8-8-9.3-13.3-17.4-12.4S256 7.8 256 16V150.2c0 5.4-4.4 9.8-9.8 9.8c-5.1 0-9.3-3.9-9.8-9L223.9 14.6C223.2 6.3 216.3 0 208 0s-15.2 6.3-15.9 14.6l-9.4 103.3 123.8 97zM160 100.1V16c0-8.2-6.1-15-14.3-15.9s-15.6 4.5-17.4 12.4L116.5 66 160 100.1zm80 185L96.1 171.7c1.9 44.2 36.3 80 79.9 83.9V480c0 17.7 14.3 32 32 32s32-14.3 32-32V285.1z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "print-magnifying-glass": [640, 512, ["print-search"], "f81a", ["M128 64v96h64V64H418.7L448 93.3V160h64V93.3c0-17-6.7-33.3-18.7-45.3L464 18.7C452 6.7 435.7 0 418.7 0H192c-35.3 0-64 28.7-64 64zM352 192H128c-35.3 0-64 28.7-64 64v96c0 17.7 14.3 32 32 32h32v64c0 35.3 28.7 64 64 64H448c24.4 0 45.6-13.7 56.4-33.8l-6.3-6.3c-15.8 5.2-32.6 8-50.2 8c-36 0-69.3-11.9-96-32H192V384 368 352h99.2c-2.1-10.3-3.2-21-3.2-32c0-52.3 25.1-98.8 64-128z", "M528 320.1a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM519.9 426c-20.5 14-45.3 22.1-71.9 22.1c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 26.7-8.2 51.4-22.1 71.9L633 471.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L519.9 426z"]],
    "folder-bookmark": [512, 512, [], "e186", ["M448 480H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H192c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8V336c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L368 308l54.4 40.8c4.8 3.6 11.3 4.2 16.8 1.5s8.8-8.2 8.8-14.3V96c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64z", "M288 96V336c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L368 308l54.4 40.8c4.8 3.6 11.3 4.2 16.8 1.5s8.8-8.2 8.8-14.3V96H288z"]],
    "om": [512, 512, [128329], "f679", ["M379.3 4.7c-6.2-6.2-16.4-6.2-22.6 0l-16 16c-6.2 6.2-6.2 16.4 0 22.6l16 16c6.2 6.2 16.4 6.2 22.6 0l16-16c6.2-6.2 6.2-16.4 0-22.6l-16-16zm-98.4 62c-6-4-14-3.5-19.5 1.3s-7 12.7-3.7 19.2L272 80c-14.3 7.2-14.3 7.2-14.3 7.2l0 0 0 0 0 .1 .1 .2 .4 .7c.3 .6 .8 1.4 1.4 2.4c1.2 2 2.9 4.8 5.1 8.2c4.4 6.7 11.1 15.5 20 24.4C302.4 141.1 330.3 160 368 160c31.2 0 56.6-10.4 73.9-20.2c8.7-5 15.6-9.9 20.4-13.8c2.4-1.9 4.3-3.6 5.7-4.9c.7-.6 1.3-1.2 1.7-1.6l.6-.5 .2-.2 .1-.1 0 0 0 0c0 0 0 0-22.6-22.6l22.6 22.6c12.5-12.5 12.5-32.8 0-45.3c-12.4-12.4-32.6-12.5-45.1-.2c-.1 .1-.2 .2-.5 .4c-.5 .5-1.5 1.3-2.8 2.4c-2.7 2.2-6.8 5.2-12.1 8.2C399.4 90.4 384.8 96 368 96c-20.8 0-42.4-7-59.5-14.6c-8.4-3.7-15.4-7.5-20.3-10.3c-2.4-1.4-4.3-2.5-5.6-3.3c-.6-.4-1.1-.7-1.4-.9l-.3-.2 0 0 0 0 0 0z", "M115.2 169.6c8-6 17.9-9.6 28.8-9.6c26.5 0 48 21.5 48 48s-21.5 48-48 48H109.8c-7.6 0-13.8 6.2-13.8 13.8c0 1.5 .2 2.9 .7 4.4l8 24c4.4 13.1 16.6 21.9 30.4 21.9H144h16s0 0 0 0c35.3 0 64 28.7 64 64s-28.7 64-64 64c-50.8 0-82.7-21.5-102.2-42.8c-9.9-10.8-16.6-21.6-20.9-29.7c-2.1-4-3.6-7.3-4.5-9.6c-.5-1.1-.8-2-1-2.5l-.2-.5 0-.1c-2.6-7.8-10.7-12.3-18.7-10.5C4.4 354.2-.9 361.8 .1 370L16 368C.1 370 .1 370 .1 370l0 0 0 0 0 .1 .1 .4c0 .3 .1 .8 .2 1.3c.2 1.1 .4 2.7 .8 4.6c.8 3.9 2 9.4 3.9 15.9c3.8 13 10.3 30.4 21.3 48C48.7 476.2 89.4 512 160 512c70.7 0 128-57.3 128-128c0-23.3-6.2-45.2-17.1-64h22.6c25.5 0 49.9-10.1 67.9-28.1l26.5-26.5c6-6 14.1-9.4 22.6-9.4H416c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32c-25.7 0-41.4-12.5-51.2-25.6c-5-6.7-8.4-13.4-10.5-18.6c-1.1-2.5-1.8-4.6-2.2-6c-.2-.7-.4-1.2-.5-1.5l-.1-.3 0 0c0 0 0 0 0 0c-1.9-7.3-8.6-12.4-16.2-12.1c-7.6 .3-13.9 5.9-15.1 13.4L336 368c-15.8-2.6-15.8-2.6-15.8-2.6l0 0 0 0 0 .1-.1 .3-.1 .5-.1 .6c-.1 .9-.3 2.1-.4 3.6c-.3 3-.6 7.3-.6 12.4c0 10.1 1.1 23.9 5.8 38.1c4.8 14.3 13.4 29.3 28.6 40.7C368.7 473.3 389.3 480 416 480c53 0 96-43 96-96V288c0-53-43-96-96-96h-5.5c-25.5 0-49.9 10.1-67.9 28.1l-26.5 26.5c-6 6-14.1 9.4-22.6 9.4H245.2c6.9-14.5 10.8-30.8 10.8-48c0-61.9-50.1-112-112-112c-25.2 0-48.5 8.3-67.2 22.4c-14.1 10.6-17 30.7-6.4 44.8s30.7 17 44.8 6.4z"]],
    "pi": [448, 512, [], "f67e", ["M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32H96V284c0 39.7-9.3 78.9-27 114.5l-1.6 3.2c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l1.6-3.2C148.4 382.7 160 333.7 160 284V128H288V366.6c0 45 36.5 81.4 81.4 81.4c30.8 0 59-17.4 72.8-45l2.3-4.7c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3l-2.3 4.7c-3 5.9-9 9.6-15.6 9.6c-9.6 0-17.4-7.8-17.4-17.4V128h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z", ""]],
    "flask-round-potion": [448, 512, ["flask-potion"], "f6e1", ["M192 157.7c0 30.4-16.9 56.1-40.3 69.7C108.7 252.5 80 298.9 80 352c0 36.9 13.8 70.5 36.7 96H331.3c22.9-25.5 36.7-59.1 36.7-96c0-53.1-28.7-99.5-71.7-124.6c-23.4-13.6-40.3-39.3-40.3-69.7V64H192v93.7zM320 64v93.7c0 6 3.3 11.4 8.5 14.4C390.4 208.2 432 275.2 432 352c0 56-22.1 106.9-58.2 144.3C363.5 507 348.7 512 333.8 512H114.2c-14.9 0-29.7-5-40.1-15.7C38.1 458.9 16 408 16 352c0-76.8 41.6-143.8 103.5-179.9c5.2-3 8.5-8.4 8.5-14.4V64c-17.7 0-32-14.3-32-32s14.3-32 32-32h16H304h16c17.7 0 32 14.3 32 32s-14.3 32-32 32z", "M368 351.8c-58.6-1.7-85.4-12.6-109.9-22.6c-22-9-42.2-17.2-82.1-17.2c-42.3 0-73.4 9.2-94.5 18.8c-1 6.9-1.5 14-1.5 21.2c0 36.9 13.8 70.5 36.7 96H331.3c22.9-25.5 36.7-59.1 36.7-96c0-.1 0-.1 0-.2z"]],
    "face-shush": [512, 512, [], "e38c", ["M0 256C0 359.8 61.8 449.1 150.5 489.3c-4.2-10.3-6.5-21.5-6.5-33.3V432 408c0-37.3 23.2-69.2 56-82V275.9c-14.8-6.9-26.6-15.9-35.3-24.6c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0c3.7 3.7 8.1 7.4 13.3 10.9c4-27 27.3-47.6 55.4-47.6s51.3 20.7 55.4 47.6c5.2-3.5 9.6-7.3 13.3-10.9c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-8.7 8.7-20.5 17.7-35.3 24.6v58.3c17.9 11.7 31.3 29.7 37 50.9c16-3.2 33.3 .6 46.9 11.9c18.4 15.3 24.5 39.9 17.1 61.3c60.3-46.8 99-120 99-202.3C512 114.6 397.4 0 256 0S0 114.6 0 256zM176.4 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M272 416c0 13.3 10.7 24 24 24s24-10.7 24-24H272zm8-168c0-13.3-10.7-24-24-24s-24 10.7-24 24h48zm98.4 207.4c8.5-10.2 7.1-25.3-3.1-33.8s-25.3-7.1-33.8 3.1l36.9 30.7zm-44 15.4l18.4 15.4-18.4-15.4zM280 464H232v48h48V464zm-56-8V432H176v24h48zm0-24V408H176v24h48zm8-32h32V352H232v48zm40 8v8h48v-8H272zm21.8 60.3l-80-56-27.5 39.3 80 56 27.5-39.3zM232 248v72h48V248H232zm48 264h17.5V464H280v48zm72.8-25.9l25.6-30.7-36.9-30.7L316 455.4l36.9 30.7zM297.5 512c21.4 0 41.6-9.5 55.3-25.9L316 455.4c-4.6 5.5-11.3 8.6-18.4 8.6v48zM264 400c4.4 0 8 3.6 8 8h48c0-30.9-25.1-56-56-56v48zm-40 8c0-4.4 3.6-8 8-8V352c-30.9 0-56 25.1-56 56h48zm8 56c-4.4 0-8-3.6-8-8H176c0 30.9 25.1 56 56 56V464z"]],
    "worm": [512, 512, [], "e599", ["M288 96c0-53 43-96 96-96h38.4C471.9 0 512 40.1 512 89.6V176v16V360c0 83.9-68.1 152-152 152s-152-68.1-152-152V312c0-30.9-25.1-56-56-56s-56 25.1-56 56V464c0 26.5-21.5 48-48 48s-48-21.5-48-48V312c0-83.9 68.1-152 152-152s152 68.1 152 152v48c0 30.9 25.1 56 56 56s56-25.1 56-56V192H384c-53 0-96-43-96-96zm144-8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z", "M384 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "house-circle-xmark": [640, 512, [], "e50b", ["M496 192c-91.8 0-167.2 70.3-175.3 160l-.7 0H256c-17.7 0-32 14.3-32 32v64 24c0 22.1-17.9 40-40 40H160 128.1c-1.5 0-3-.1-4.5-.2c-1.2 .1-2.4 .2-3.6 .2H104c-22.1 0-40-17.9-40-40V360c0-.9 0-1.9 .1-2.8V287.6H32c-18 0-32-14-32-32.1c0-9 3-17 10-24L266.4 8c7-7 15-8 22-8s15 2 21 7L522.1 193.9c-8.5-1.3-17.3-1.9-26.1-1.9z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]],
    "plug": [384, 512, [128268], "f1e6", ["M128 32c0-17.7-14.3-32-32-32S64 14.3 64 32V160h64V32zm192 0c0-17.7-14.3-32-32-32s-32 14.3-32 32V160h64V32z", "M0 192c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32s-14.3 32-32 32v32c0 77.4-55 142-128 156.8V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V412.8C87 398 32 333.4 32 256V224c-17.7 0-32-14.3-32-32z"]],
    "calendar-circle-exclamation": [576, 512, [], "e46e", ["M96 32c0-17.7 14.3-32 32-32s32 14.3 32 32V64H288V32c0-17.7 14.3-32 32-32s32 14.3 32 32V64h48c26.5 0 48 21.5 48 48v48H0V112C0 85.5 21.5 64 48 64H96V32zM416 192.7c-89.7 8.1-160 83.5-160 175.3c0 59.5 29.6 112.1 74.8 144H48c-26.5 0-48-21.5-48-48V192H416v.7z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16V288z"]],
    "square-i": [448, 512, [], "e272", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm88 96h72 72c13.3 0 24 10.7 24 24s-10.7 24-24 24H248V336h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V176H152c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M128 152c0-13.3 10.7-24 24-24h72 72c13.3 0 24 10.7 24 24s-10.7 24-24 24H248V336h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V176H152c-13.3 0-24-10.7-24-24z"]],
    "chevron-up": [512, 512, [], "f077", ["M233.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 173.3 86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z", ""]],
    "face-saluting": [640, 512, [129761], "e484", ["M352 0c-18.4 0-36.3 1.9-53.5 5.6c12.6 27.9 3.8 61.6-22.4 79.4l-54.6 37c8.6 4.4 16.3 10.9 22.3 19.2c8.6 11.9 12.6 25.7 12.2 39.3c4.8-2.8 10.4-4.5 16.3-4.5c17.7 0 32 14.3 32 32s-14.3 32-32 32c-13.9 0-25.8-8.9-30.2-21.4c-3.5 4.4-7.7 8.5-12.5 12l-82.3 59.9c-13.9 10.1-29.5 16.6-45.6 19.6C126.5 425.5 229.1 512 352 512c141.4 0 256-114.6 256-256S493.4 0 352 0zM257.4 341c17.5 12.6 48.9 27 94.6 27s77.2-14.4 94.6-27c7.2-5.2 17.2-3.5 22.3 3.6s3.5 17.2-3.6 22.3c-22.7 16.4-60.7 33-113.4 33s-90.6-16.6-113.4-33c-7.2-5.2-8.8-15.2-3.6-22.3s15.2-8.8 22.3-3.6zm175-165a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M258.1 58.5c14.6-9.9 18.4-29.8 8.5-44.4S236.8-4.4 222.2 5.5L35.1 132.5c-44.3 30.1-47.1 94.4-5.6 128.2l1.5 1.2c28.1 22.9 68.2 24 97.5 2.7l82.3-59.9c14.3-10.4 17.5-30.4 7.1-44.7s-30.4-17.5-44.7-7.1L128 185.8V146.8L258.1 58.5z"]],
    "gauge-simple-low": [512, 512, ["tachometer-slow"], "f62c", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-35.3-28.7-64-64-64c-2.1 0-4.1 .1-6.1 .3L173.3 140.9c-6.1-11.8-20.6-16.3-32.4-10.2s-16.3 20.6-10.2 32.4l76.6 147.4C197.8 321.6 192 336.1 192 352c0 35.3 28.7 64 64 64s64-28.7 64-64z", "M173.3 140.9c-6.1-11.8-20.6-16.3-32.4-10.2s-16.3 20.6-10.2 32.4l76.6 147.4C197.8 321.6 192 336.1 192 352c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-2.1 0-4.1 .1-6.1 .3L173.3 140.9z"]],
    "face-persevering": [512, 512, [], "e385", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm60.1-101.3c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6C188.2 371.4 216.3 352 256 352s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2zm-104.8-310c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0zm89.4 22.6c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4zM133.5 210.7l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6c0-9 9.6-14.7 17.5-10.5zM396 221.1c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z", "M211.3 123.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-7.4 7.4c-18.9 18.9-43.2 31.4-69.5 35.7l-2.5 .4c-8.7 1.5-14.6 9.7-13.2 18.4s9.7 14.6 18.4 13.2l2.5-.4c32.9-5.5 63.3-21.1 86.8-44.7l7.4-7.4zm89.4 0l7.4 7.4c23.6 23.6 53.9 39.2 86.8 44.7l2.5 .4c8.7 1.5 17-4.4 18.4-13.2s-4.4-17-13.2-18.4l-2.5-.4c-26.3-4.4-50.6-16.9-69.5-35.7l-7.4-7.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6zM133.5 210.7c-7.9-4.2-17.5 1.5-17.5 10.5c0 2.8 1 5.5 2.8 7.6l36 43.2-36 43.2c-1.8 2.1-2.8 4.8-2.8 7.6c0 9 9.6 14.7 17.5 10.5l89.9-47.9c10.7-5.7 10.7-21.1 0-26.8l-89.9-47.9zM396 221.1c0-9-9.6-14.7-17.5-10.5l-89.9 47.9c-10.7 5.7-10.7 21.1 0 26.8l89.9 47.9c7.9 4.2 17.5-1.5 17.5-10.5c0-2.8-1-5.5-2.8-7.6l-36-43.2 36-43.2c1.8-2.1 2.8-4.8 2.8-7.6z"]],
    "circle-camera": [512, 512, ["camera-circle"], "e103", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM202.2 143.6c3.5-9.4 12.5-15.6 22.5-15.6h62.7c10 0 19 6.2 22.5 15.6L316 160h36c17.7 0 32 14.3 32 32V320c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V192c0-17.7 14.3-32 32-32h36l6.2-16.4z", "M202.2 143.6L196 160H160c-17.7 0-32 14.3-32 32V320c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32H316l-6.2-16.4c-3.5-9.4-12.5-15.6-22.5-15.6H224.6c-10 0-19 6.2-22.5 15.6zM256 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "hand-spock": [576, 512, [128406], "f259", ["M207.7 1.1c17.1-4.6 34.6 5.6 39.2 22.6l57 212.8C307 248 317.4 256 329.3 256c12.4 0 23.2-8.7 25.8-20.9L392.7 57.4c3.7-17.3 20.6-28.3 37.9-24.7s28.3 20.6 24.7 37.9l-36 170.3c-1.6 7.8 4.3 15.1 12.2 15.1c5.5 0 10.4-3.6 12-8.9l37.9-128.1c5-16.9 22.8-26.6 39.8-21.6s26.6 22.8 21.6 39.8L461.5 412c-16.7 56.6-67 96.2-125.3 99.7c-.1 0-.1 .1-.1 .1s-.1 .1-.1 .1h-8.2H316.8c-59.6 0-116.9-22.9-160-64L44.4 341c-16-15.2-16.6-40.6-1.4-56.6s40.6-16.6 56.6-1.4L155 335.8c6 5.7 15.6-.3 13.2-8.1L105.4 121.3c-5.1-16.9 4.4-34.8 21.3-39.9s34.8 4.4 39.9 21.3l43.5 143.1c1.9 6.1 7.5 10.3 13.9 10.3c9.5 0 16.4-9 14-18.2L185.1 40.3c-4.6-17.1 5.6-34.6 22.6-39.2zM224 336c0 8.8 7.2 16 16 16h8c39.8 0 72 32.2 72 72v8c0 8.8 7.2 16 16 16s16-7.2 16-16v-8c0-27.9-11-53.3-29-72h77c8.8 0 16-7.2 16-16s-7.2-16-16-16H248h-8c-8.8 0-16 7.2-16 16z", "M240 320c-8.8 0-16 7.2-16 16s7.2 16 16 16h8c39.8 0 72 32.2 72 72v8c0 8.8 7.2 16 16 16s16-7.2 16-16v-8c0-27.9-11-53.3-29-72h77c8.8 0 16-7.2 16-16s-7.2-16-16-16H248h-8z"]],
    "spider-web": [576, 512, [128376], "f719", ["M165.3 97.7L178 63.9l36.4 6.8L235.1 107l.8 .1c34.4 6.1 69.7 6.1 104.1 0l.8-.1 20.8-36.4L398 63.9l12.7 33.8-22.2 38.9 .7 2c11.5 32.5 28.5 62.8 50.4 89.4h44.6l23.3 28-23.3 28H439.6c-21.9 26.6-38.9 56.9-50.4 89.4l-.7 2 22.2 38.9L398 448.1l-36.4-6.8L340.9 405l-.8-.2c-34.4-6.1-69.7-6.1-104.1 0l-.8 .2-20.8 36.4L178 448.1l-12.7-33.8 22.2-38.9-.7-2c-11.5-32.5-28.5-62.8-50.4-89.4H91.8L68.4 256l23.3-28h44.6c21.9-26.6 38.9-56.9 50.4-89.4l.7-2L165.3 97.7zM239.8 228l-22.1-38.7c-6.4 13.4-13.7 26.3-21.8 38.7h43.9zM288 199.6L311.2 159c-15.4 1-30.9 1-46.3 0L288 199.6zM336.2 228h43.9c-8.1-12.4-15.4-25.3-21.8-38.7L336.2 228zm0 56l22.1 38.7c6.4-13.4 13.7-26.3 21.8-38.7H336.2zM288 312.4L264.8 353c15.4-1 30.9-1 46.3 0L288 312.4zM239.8 284H195.8c8.1 12.4 15.4 25.3 21.8 38.7L239.8 284z", "M133.8 22.2c4.8-12.7 18-20.2 31.4-17.7l69 12.9c35.6 6.7 72.1 6.7 107.6 0l69-12.9c13.4-2.5 26.6 5 31.4 17.7l28.9 77.2c11.5 30.7 28.1 59.2 49.1 84.4l45.3 54.3c8.7 10.4 8.7 25.5 0 35.9l-45.3 54.3c-21 25.2-37.6 53.7-49.1 84.4l-28.9 77.2c-4.8 12.7-18 20.2-31.4 17.7l-69-12.9c-35.6-6.7-72.1-6.7-107.6 0l-69 12.9c-13.4 2.5-26.6-5-31.4-17.7l-28.9-77.2C93.3 382 76.7 353.4 55.7 328.2L10.5 273.9c-8.7-10.4-8.7-25.5 0-35.9l45.3-54.3c21-25.2 37.6-53.7 49.1-84.4l28.9-77.2zM178 63.9L157.3 119c-13.7 36.6-33.5 70.6-58.5 100.6L68.4 256l30.3 36.4c25 30 44.8 64 58.5 100.6L178 448.1l45.9-8.6c42.4-7.9 85.9-7.9 128.3 0l45.9 8.6L418.7 393c13.7-36.6 33.5-70.6 58.5-100.6L507.6 256l-30.3-36.4c-25-30-44.8-64-58.5-100.6L398 63.9l-45.9 8.6c-42.4 7.9-85.9 7.9-128.3 0L178 63.9z"]],
    "circle-microphone": [512, 512, ["microphone-circle"], "e116", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 144c0-26.5 21.5-48 48-48s48 21.5 48 48V256c0 26.5-21.5 48-48 48s-48-21.5-48-48V144zm-64 80c8.8 0 16 7.2 16 16v16c0 53 43 96 96 96s96-43 96-96V240c0-8.8 7.2-16 16-16s16 7.2 16 16v16c0 65.3-48.9 119.1-112 127v17c0 8.8-7.2 16-16 16s-16-7.2-16-16V383c-63.1-7.9-112-61.7-112-127V240c0-8.8 7.2-16 16-16z", "M256 96c-26.5 0-48 21.5-48 48V256c0 26.5 21.5 48 48 48s48-21.5 48-48V144c0-26.5-21.5-48-48-48zM160 240c0-8.8-7.2-16-16-16s-16 7.2-16 16v16c0 65.3 48.9 119.1 112 127v17c0 8.8 7.2 16 16 16s16-7.2 16-16V383c63.1-7.9 112-61.7 112-127V240c0-8.8-7.2-16-16-16s-16 7.2-16 16v16c0 53-43 96-96 96s-96-43-96-96V240z"]],
    "book-arrow-up": [448, 512, [], "e0ba", ["M216 384H96c-17.7 0-32 14.3-32 32s14.3 32 32 32H216V384zm48 64H416V384H264v64z", "M96 0C43 0 0 43 0 96V416c0 53 43 96 96 96H216V448H96c-17.7 0-32-14.3-32-32s14.3-32 32-32H216l0-174.1-39 39c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l80-80c9.4-9.4 24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-39-39V384h88 64c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H384 96zM264 448v64H384h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H352 264z"]],
    "popsicle": [320, 512, [], "e43e", ["M160 0C71.6 0 0 71.6 0 160V336c0 26.5 21.5 48 48 48h80V192c0-17.7 14.3-32 32-32s32 14.3 32 32V384h80c26.5 0 48-21.5 48-48V160C320 71.6 248.4 0 160 0z", "M128 192c0-17.7 14.3-32 32-32s32 14.3 32 32V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V192z"]],
    "command": [512, 512, [], "e142", ["M320 128V96c0-53 43-96 96-96s96 43 96 96s-43 96-96 96H384V320H320V192 128zM192 320v64 32c0 53-43 96-96 96s-96-43-96-96s43-96 96-96h32V192h64V320zm-64 64H96c-17.7 0-32 14.3-32 32s14.3 32 32 32s32-14.3 32-32V384zM384 128h32c17.7 0 32-14.3 32-32s-14.3-32-32-32s-32 14.3-32 32v32z", "M0 96C0 43 43 0 96 0s96 43 96 96v32H320v64H192 128 96h0C43 192 0 149 0 96zM320 320h64 32c53 0 96 43 96 96s-43 96-96 96s-96-43-96-96V384H192V320H320zM128 128V96c0-17.7-14.3-32-32-32S64 78.3 64 96s14.3 32 32 32h32zM384 384v32c0 17.7 14.3 32 32 32s32-14.3 32-32s-14.3-32-32-32H384z"]],
    "blinds": [512, 512, [], "f8fb", ["M15 59.1L1.1 100.8c-.7 2.1-1.1 4.3-1.1 6.5C0 118.8 9.2 128 20.6 128H128V64H32c-6.3 0-12.1-1.8-17-4.9zM160 64v64H491.4c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L497 59.1c-4.9 3.1-10.8 4.9-17 4.9H160zM24 160L1.1 228.8c-.7 2.1-1.1 4.3-1.1 6.5C0 246.8 9.2 256 20.6 256H98.7c4.8-13.6 15.6-24.4 29.3-29.3V160H24zM144 320c-20.9 0-38.7-13.4-45.3-32H24L1.1 356.8c-.7 2.1-1.1 4.3-1.1 6.5C0 374.8 9.2 384 20.6 384H491.4c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 288H189.3c-6.6 18.6-24.4 32-45.3 32zm16-93.3c13.6 4.8 24.4 15.6 29.3 29.3H491.4c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 160H160v66.7zM20.6 512H491.4c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 416H24L1.1 484.8c-.7 2.1-1.1 4.3-1.1 6.5C0 502.8 9.2 512 20.6 512z", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64h96V226.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V64H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "stopwatch": [448, 512, [9201], "f2f2", ["M224 512a208 208 0 1 0 0-416 208 208 0 1 0 0 416zm24-320V320c0 13.3-10.7 24-24 24s-24-10.7-24-24V192c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M144 32c0-17.7 14.3-32 32-32h48 48c17.7 0 32 14.3 32 32s-14.3 32-32 32H256V98.4c-10.4-1.6-21.1-2.4-32-2.4s-21.6 .8-32 2.4V64H176c-17.7 0-32-14.3-32-32zM355.7 143l21.6-21.6c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-24.1 24.1c-11.7-18-26.2-34.1-42.8-47.7zM248 192V320c0 13.3-10.7 24-24 24s-24-10.7-24-24V192c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "saxophone": [640, 512, [127927], "f8dc", ["M246.7 176L171.4 306.1c-2.2 3.8-3.4 8.2-3.4 12.6v2.6c0 12.5 10.1 22.6 22.6 22.6c6 0 11.8-2.4 16-6.6L319 225l-8-8c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l8 8L367 177l-8-8c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l8 8L415 129l-8-8c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l8 8 44.3-44.3c12-12 28.3-18.7 45.3-18.7h30.3c15 0 29.5 5.2 41 14.8l24.3 20.3c3.7 3.1 5.9 7.7 5.9 12.6c0 9-7.3 16.3-16.3 16.3H559.5c-9.8 0-19 4.5-25.1 12.1L288.6 418.6C257.9 457.4 211.2 480 161.8 480C72.4 480 0 407.6 0 318.2v-3.1c0-12.7 1.5-25.4 4.4-37.8L28.2 176H24c-13.3 0-24-10.7-24-24s10.7-24 24-24H264c13.3 0 24 10.7 24 24s-10.7 24-24 24H246.7zM120 320a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm8-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48z", "M319 225L353 191l-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8zm48-48L401 143l-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8zm48-48L449 95l-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8zM152 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-32 96a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "square-2": [448, 512, [], "e257", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM190.7 184.7l-24.2 18.4c-10.5 8-25.6 6-33.6-4.5s-6-25.6 4.5-33.6l24.2-18.4c15.8-12 35.2-18.4 55.1-18.1l3.4 .1c46.5 .7 83.8 38.6 83.8 85.1c0 23.5-9.7 46-26.9 62.1L212.7 336H296c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-9.8 0-18.7-6-22.3-15.2s-1.3-19.6 5.9-26.3L244.3 240.6c7.5-7 11.7-16.8 11.7-27.1c0-20.3-16.3-36.8-36.6-37.1l-3.4-.1c-9.1-.1-18 2.8-25.3 8.3z", "M216 176.3c-9.1-.1-18 2.8-25.3 8.3l-24.2 18.4c-10.5 8-25.6 6-33.6-4.5s-6-25.6 4.5-33.6l24.2-18.4c15.8-12 35.2-18.4 55.1-18.1l3.4 .1c46.5 .7 83.8 38.6 83.8 85.1c0 23.5-9.7 46-26.9 62.1L212.7 336H296c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-9.8 0-18.7-6-22.3-15.2s-1.3-19.6 5.9-26.3L244.3 240.6c7.5-7 11.7-16.8 11.7-27.1c0-20.3-16.3-36.8-36.6-37.1l-3.4-.1z"]],
    "field-hockey-stick-ball": [512, 512, [127953, "field-hockey"], "f44c", ["M491.2 8.5c21.8 15.1 27.3 45 12.2 66.8L442.1 164l-79.9-53.3 62.2-90c15.1-21.8 45-27.3 66.8-12.2zM432 352a80 80 0 1 1 0 160 80 80 0 1 1 0-160z", "M442.1 164l-79.9-53.3L162 400.3c-6.7 9.7-17.7 15.4-29.4 15.5c-20 .1-36.1-16.2-36-36.1l0-2.2c.1-7.3 2.2-14.4 6.2-20.6l17.3-26.5c14.5-22.2 8.3-51.9-13.9-66.4s-51.9-8.3-66.4 13.9L22.5 304.3C8.4 325.8 .8 350.9 .6 376.7l0 2.2C.1 452.3 59.5 512 132.9 511.8c43.2-.1 83.5-21.4 108.1-56.9L442.1 164z"]],
    "arrow-up-square-triangle": [576, 512, ["sort-shapes-up-alt"], "f88b", ["M368 32h96c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H368c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48zm48 256c11 0 21.3 5.7 27.1 15l80 128c6.2 9.9 6.5 22.3 .9 32.5s-16.4 16.5-28 16.5H336c-11.6 0-22.3-6.3-28-16.5s-5.3-22.6 .9-32.5l80-128c5.8-9.4 16.1-15 27.1-15z", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V146.3L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32z"]],
    "face-scream": [640, 512, [], "e38b", ["M573.9 288.5c1.4-10.7 2.1-21.5 2.1-32.5C576 114.6 461.4 0 320 0S64 114.6 64 256c0 11 .7 21.9 2.1 32.6c20.6-2.5 41.7 3.5 57.8 16.9l0 0c57.5 48 87.8 118 98 187C252.1 505.1 285.2 512 320 512c34.8 0 68-6.9 98.2-19.5c10.2-69 40.4-139 98-187l0 0c16.1-13.4 37.2-19.4 57.8-17zM320 320c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V368c0-26.5 21.5-48 48-48zm-46.6-77c-22.5 36.9-62.8 54.7-90.1 39.8s-31.1-56.9-8.7-93.7s62.8-54.7 90.1-39.8s31.1 56.9 8.7 93.7zm183.3 39.8c-27.3 14.9-67.6-2.9-90.1-39.8s-18.6-78.8 8.7-93.7s67.6 2.9 90.1 39.8s18.6 78.8-8.7 93.7z", "M183.3 282.7c27.3 14.9 67.6-2.9 90.1-39.8s18.6-78.8-8.7-93.7s-67.6 2.9-90.1 39.8s-18.6 78.8 8.7 93.7zm273.4 0c27.3-14.9 31.1-56.9 8.7-93.7s-62.8-54.7-90.1-39.8s-31.1 56.9-8.7 93.7s62.8 54.7 90.1 39.8zM103.4 330.1C89.1 318.2 68 316.4 51.6 327c-20 13-25.6 39.5-12.4 59.3c26.4 40 43.6 75.3 43.2 125.7L192 512c-7-68.4-34.8-137-88.7-181.9zM588.5 327c-16.4-10.6-37.6-8.8-51.8 3.1C482.8 375 455 443.6 448 512l109.8 0c-.4-50.5 16.7-85.7 43.2-125.7c13.1-19.8 7.6-46.3-12.4-59.3z"]],
    "square-m": [448, 512, [], "e276", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm75.5 105.9L224 255l84.5-117.1c6.1-8.4 16.9-12 26.8-8.8s16.6 12.4 16.6 22.8V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V226.2l-60.5 83.8c-4.5 6.2-11.7 9.9-19.5 9.9s-14.9-3.7-19.5-9.9L144 226.2V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-10.4 6.7-19.6 16.6-22.8s20.7 .3 26.8 8.8z", "M112.6 129.2c9.9-3.2 20.7 .3 26.8 8.8L224 255l84.5-117.1c6.1-8.4 16.9-12 26.8-8.8s16.6 12.4 16.6 22.8V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V226.2l-60.5 83.8c-4.5 6.2-11.7 9.9-19.5 9.9s-14.9-3.7-19.5-9.9L144 226.2V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-10.4 6.7-19.6 16.6-22.8z"]],
    "camera-web": [448, 512, ["webcam"], "f832", ["M224 352a128 128 0 1 0 0-256 128 128 0 1 0 0 256zM176 224c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16s-7.2 16-16 16c-26.5 0-48 21.5-48 48z", "M448 224c0 79.5-41.4 149.3-103.8 189.1l58.2 40.7c11.4 8 16.4 22.5 12.2 35.8S398 512 384 512H64c-14 0-26.3-9.1-30.5-22.4s.7-27.8 12.2-35.8l58.2-40.7C41.4 373.3 0 303.5 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224zM224 384a160 160 0 1 0 0-320 160 160 0 1 0 0 320z"]],
    "comment-arrow-down": [512, 512, [], "e143", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zm24-296V270.1l31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31V152c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M256 128c13.3 0 24 10.7 24 24V270.1l31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31V152c0-13.3 10.7-24 24-24z"]],
    "lightbulb-cfl": [320, 512, [], "e5a6", ["M167.8 63L39.8 95C22.6 99.3 5.2 88.9 1 71.8S7.1 37.2 24.2 33l128-32c17.1-4.3 34.5 6.1 38.8 23.3s-6.1 34.5-23.3 38.8zM319 88.2c4.3 17.1-6.1 34.5-23.3 38.8l-256 64C22.6 195.3 5.2 184.9 1 167.8s6.1-34.5 23.3-38.8l256-64c17.1-4.3 34.5 6.1 38.8 23.3zm0 96c4.3 17.1-6.1 34.5-23.3 38.8L99.9 272 96 273 39.8 287C22.6 291.3 5.2 280.9 1 263.8s6.1-34.5 23.3-38.8l256-64c17.1-4.3 34.5 6.1 38.8 23.3zM96 306l48-12v90H96V306zm223-25.7c4.3 17.1-6.1 34.5-23.3 38.8l-64 16L224 337v47H176V308.7c0-.5 0-.9 0-1.4V304l.2 0c1.6-12.7 10.8-23.7 24-27l16-4 64-16c17.1-4.3 34.5 6.1 38.8 23.3z", "M96 384c-17.7 0-32 14.3-32 32v32c0 17.7 14.3 32 32 32h32c0 17.7 14.3 32 32 32s32-14.3 32-32h32c17.7 0 32-14.3 32-32V416c0-17.7-14.3-32-32-32H96z"]],
    "window-frame-open": [512, 512, [], "e050", ["M232 64H96V224H232V64zm48 160H416V64H280V224z", "M480 224V64c0-35.3-28.7-64-64-64H96C60.7 0 32 28.7 32 64V224v64H96 416h64V224zm-64 0H280V64H416V224zm-184 0H96V64H232V224zM96 448V320H32V448c-17.7 0-32 14.3-32 32s14.3 32 32 32H64 448h32c17.7 0 32-14.3 32-32s-14.3-32-32-32V320H416V448H96z"]],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm48.7-198.3c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448c-3.6 0-6.8-2.5-7.7-6s.6-7.2 3.8-9l0 0 0 0 0 0 0 0 .2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1 0 0 0 0 0 0c-2.5-1.4-4.1-4.1-4.1-7s1.6-5.6 4.1-7l0 0 0 0 0 0 0 0 0 0 .2-.1 .3-.2 .6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3-.5-.3-.2-.1 0 0 0 0 0 0c-3.2-1.8-4.7-5.5-3.8-9s4.1-6 7.7-6c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "bridge-circle-xmark": [640, 512, [], "e4cb", ["M32 64c0-17.7 14.3-32 32-32H576c17.7 0 32 14.3 32 32s-14.3 32-32 32H536v64h72v72.2C577.6 207.1 538.5 192 496 192c-69.1 0-128.9 39.8-157.7 97.7c-5.9-1.1-12-1.7-18.3-1.7c-53 0-96 43-96 96v64c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V384c0-53-43-96-96-96V160h72V96H64C46.3 96 32 81.7 32 64zM408 96v64h80V96H408zm-48 64V96H280v64h80zM152 96v64h80V96H152z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]],
    "period": [128, 512, [], "2e", ["M0 416a64 64 0 1 1 128 0A64 64 0 1 1 0 416z", ""]],
    "face-grin-tongue": [512, 512, [128539, "grin-tongue"], "f589", ["M174.5 498.8C73.1 464.7 0 368.9 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 112.9-73.1 208.7-174.5 242.8C346.7 484 352 466.6 352 448V401.1c24.3-17.5 43.6-41.6 55.4-69.6c5-11.8-7-22.5-19.3-18.7c-39.7 12.2-84.5 19-131.8 19s-92.1-6.8-131.8-19c-12.3-3.8-24.3 6.9-19.3 18.7c11.7 27.8 30.8 51.7 54.8 69.2V448c0 18.6 5.3 36 14.5 50.8zM208.4 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M208.4 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 448V402.6c0-14.7-11.9-26.6-26.6-26.6h-2c-11.3 0-21.1 7.9-23.6 18.9c-2.8 12.6-20.8 12.6-23.6 0c-2.5-11.1-12.3-18.9-23.6-18.9h-2c-14.7 0-26.6 11.9-26.6 26.6V448c0 35.3 28.7 64 64 64s64-28.7 64-64z"]],
    "up-to-dotted-line": [448, 512, [], "e457", ["M384 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm-96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM224 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM96 64a32 32 0 1 0 64 0A32 32 0 1 0 96 64zM32 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64z", "M196.7 139.3L73.9 262.1c-6.4 6.4-9.9 15-9.9 24C64 304.8 79.2 320 97.9 320H160V448c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V320h62.1c18.7 0 33.9-15.2 33.9-33.9c0-9-3.6-17.6-9.9-24L251.3 139.3c-7.2-7.2-17.1-11.3-27.3-11.3s-20.1 4.1-27.3 11.3z"]],
    "thought-bubble": [512, 512, [], "e32e", ["M144 480a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM32 512a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M374.8 80.3C355.9 33.2 309.8 0 256 0s-99.9 33.2-118.8 80.3c-3-.2-6.1-.3-9.2-.3C57.3 80 0 137.3 0 208s57.3 128 128 128c14.4 0 28.3-2.4 41.3-6.8C184.7 361.6 217.7 384 256 384s71.3-22.4 86.7-54.8c12.9 4.4 26.8 6.8 41.3 6.8c70.7 0 128-57.3 128-128s-57.3-128-128-128c-3.1 0-6.1 .1-9.2 .3z"]],
    "skeleton-ribs": [640, 512, [], "e5cb", ["M352 32V64H288V32c0-17.7 14.3-32 32-32s32 14.3 32 32zM479.9 376c-3 0-6-.5-9.1-1.4L352 339v40.9c-21.1-4.3-42.9-4.3-64 0v-42L160.3 372.7c1-22.4 5.1-45.9 11-69.3L288 271.6V231.9L186 254.6c9-26 19.4-50.6 29.3-72.1L288 166.3V128h64v38.3l72.7 16.2c9.9 21.4 20.2 46.1 29.3 72.1L352 231.9v40.3l117.8 35.3c5.6 23.2 9.3 46.4 10.1 68.5zM288 446.2c20.7-7.3 43.3-7.3 64 0V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V446.2zM64 80c35.3 0 64 28.7 64 64c0 20.1-9.5 39.1-25.6 51.2L76.8 214.4C68.7 220.4 64 229.9 64 240V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V240 144c0-35.3 28.7-64 64-64zm576 64v96V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V240c0-10.1-4.7-19.6-12.8-25.6l-25.6-19.2C521.5 183.1 512 164.1 512 144c0-35.3 28.7-64 64-64s64 28.7 64 64z", "M178.2 112.9C194.5 81.6 226.7 64 260.2 64H379.8c33.5 0 65.8 17.6 82.1 48.9C489.5 165.8 544 282.2 544 384v17c0 43.6-35.4 79-79 79c-15.1 0-30.1-2.7-44.2-8l-67.1-25.2c-21.7-8.2-45.7-8.2-67.4 0L219.2 472c-14.1 5.3-29.1 8-44.2 8c-43.6 0-79-35.4-79-79V384c0-101.8 54.5-218.2 82.2-271.1zM260.2 128c-11.4 0-20.8 5.9-25.3 14.5C207.2 195.6 160 299.4 160 384v17c0 8.3 6.7 15 15 15c7.4 0 14.8-1.3 21.7-3.9l67.1-25.2c36.2-13.6 76.1-13.6 112.4 0l67.1 25.2c7 2.6 14.3 3.9 21.7 3.9c8.3 0 15-6.7 15-15V384c0-84.6-47.2-188.4-74.9-241.5c-4.5-8.6-13.9-14.5-25.3-14.5H260.2z"]],
    "raygun": [576, 512, [], "e025", ["M64 24.6V74.8C78.5 67.9 94.8 64 112 64h80L102.2 4.1C98.2 1.4 93.4 0 88.6 0C75 0 64 11 64 24.6zM336 56c0-13.3-10.7-24-24-24s-24 10.7-24 24V296c0 13.3 10.7 24 24 24s24-10.7 24-24V56zm80 32c0-13.3-10.7-24-24-24s-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V88z", "M288 64H112C50.1 64 0 114.1 0 176s50.1 112 112 112h8.2L51.4 425.7c-7.9 15.8-1.5 35 14.3 42.9l80 40c15.8 7.9 35 1.5 42.9-14.3L288 295.6V64zM416 208h60.9l77.1 30.9c4.9 2 10.5 1.4 14.9-1.6s7-7.9 7-13.2V128c0-5.3-2.6-10.3-7-13.2s-10-3.6-14.9-1.6L476.9 144H416v64zM112 152a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm72 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]],
    "flute": [640, 512, [], "f8b9", ["M48 160H96V352H48c-26.5 0-48-21.5-48-48V208c0-26.5 21.5-48 48-48zM592 352H128V160H592c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48zM320 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z", "M128 160H96V352h32V160zM320 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm96 0a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "acorn": [448, 512, [], "f6ae", ["M400 192H48v32c0 78.1 30.5 201.9 165.9 252.4c6.5 2.4 13.7 2.4 20.2 0C369.5 425.9 400 302.1 400 224V192z", "M267.2 38.4c8-10.6 5.8-25.6-4.8-33.6s-25.6-5.8-33.6 4.8L224 16c-10.7 14.3-18 30.7-21.6 48H96C43 64 0 107 0 160c0 17.7 14.3 32 32 32H416c17.7 0 32-14.3 32-32c0-53-43-96-96-96H252.1c2.4-6.8 5.9-13.3 10.3-19.2l4.8-6.4z"]],
    "video-arrow-up-right": [576, 512, [], "e2c9", ["M64 64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zm88 96H264c13.3 0 24 10.7 24 24V296c0 13.3-10.7 24-24 24s-24-10.7-24-24V241.9L137 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l103-103H152c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M559.1 99.8c10.4 5.6 16.9 16.4 16.9 28.2V384c0 11.8-6.5 22.6-16.9 28.2s-23 5-32.9-1.6L384 315.8V196.2l142.2-94.8c9.8-6.5 22.4-7.2 32.9-1.6zM152 160H264c13.3 0 24 10.7 24 24V296c0 13.3-10.7 24-24 24s-24-10.7-24-24V241.9L137 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l103-103H152c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "grate-droplet": [576, 512, [], "e194", ["M64 32C28.7 32 0 60.7 0 96V256 416c0 35.3 28.7 64 64 64h64 96 96 24.2c-15.3-22.9-24.2-50.4-24.2-80c0-23.6 5.8-46.9 16.9-67.8l75.3-141.2c7.6-14.3 20.6-24.5 35.8-28.8V96c0-35.3-28.7-64-64-64H320 224 128 64zm0 64H96V224H64V96zm0 192H96V416H64V288zm96 128V288h32V416H160zm96 0V288h32V416H256zM384 224H352V96h32V224zM288 96V224H256V96h32zm-96 0V224H160V96h32z", "M365.2 347.3l75.3-141.2c4.6-8.7 13.7-14.1 23.5-14.1s18.9 5.4 23.5 14.1l75.3 141.2c8.7 16.2 13.2 34.3 13.2 52.7c0 61.9-50.1 112-112 112s-112-50.1-112-112c0-18.4 4.5-36.5 13.2-52.7z"]],
    "seal-exclamation": [512, 512, [], "e242", ["M222.1 18.4c18.7-18.7 49.1-18.7 67.9 0L335.5 64H400c26.5 0 48 21.5 48 48v64.5l45.6 45.6c18.7 18.7 18.7 49.1 0 67.9L448 335.5V400c0 26.5-21.5 48-48 48H335.5l-45.6 45.6c-18.7 18.7-49.1 18.7-67.9 0L176.5 448H112c-26.5 0-48-21.5-48-48V335.5L18.4 289.9c-18.7-18.7-18.7-49.1 0-67.9L64 176.5V112c0-26.5 21.5-48 48-48h64.5l45.6-45.6zM256 128c-13.3 0-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M280 152c0-13.3-10.7-24-24-24s-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152zM256 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "chess-bishop": [320, 512, [9821], "f43a", ["M258.7 432H61.3c-8.5 0-16.6 3.4-22.6 9.4l-32 32c-4.2 4.2-6.6 10-6.6 16C0 501.9 10.1 512 22.6 512H297.4c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16l-32-32c-6-6-14.1-9.4-22.6-9.4z", "M96 32c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32c0 16.1-11.9 29.4-27.4 31.7c22.4 21.4 51 52.8 74.2 90.9L164.7 260.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l99.4-99.4C301.8 215.6 312 250.7 312 288c0 47.4-30.8 72.3-56 84.7V432H64V372.7C38.8 360.3 8 335.4 8 288C8 190 78.4 106.8 123.4 63.7C107.9 61.4 96 48.1 96 32z"]],
    "message-sms": [512, 512, [], "e1e5", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zm202.9 80.8C196.4 147 192 153.1 192 160v96c0 8.8 7.2 16 16 16s16-7.2 16-16V208l19.2 25.6c3 4 7.8 6.4 12.8 6.4s9.8-2.4 12.8-6.4L288 208v48c0 8.8 7.2 16 16 16s16-7.2 16-16V160c0-6.9-4.4-13-10.9-15.2s-13.7 .1-17.9 5.6L256 197.3l-35.2-46.9c-4.1-5.5-11.3-7.8-17.9-5.6zm173.1 38c0-1.1 .2-1.6 .4-1.9c.3-.4 .9-1.2 2.4-2c3.1-1.8 8-3 12.9-2.9c6.1 .1 12.9 1.4 20.1 3.4c8.5 2.3 17.3-2.8 19.6-11.3s-2.8-17.3-11.3-19.6c-8.2-2.2-17.9-4.3-27.9-4.4c-9.3-.1-20.4 1.9-29.7 7.4c-9.9 5.9-18.6 16.4-18.5 31.6c.1 14.7 8.8 24 17.7 29.4c7.6 4.6 17.1 7.4 24.3 9.6l1.2 .4c8.5 2.6 14.2 4.5 18 6.9c2.7 1.7 2.7 2.4 2.7 3.1l0 .2c0 1.6-.3 2.3-.6 2.7c-.3 .5-.9 1.2-2.1 2c-2.8 1.7-7.5 2.9-12.8 2.8c-7-.2-13.5-2.4-22.6-5.5l0 0 0 0c-1.5-.5-3.2-1.1-4.9-1.6c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2c1.2 .4 2.6 .9 4 1.4l0 0 0 0c8.8 3 20.4 7 32.6 7.4c9.8 .3 21.2-1.6 30.7-7.6c10.2-6.4 18-17.3 17.8-32.3c-.2-14.7-8.5-24.2-17.6-29.9c-8-5-17.9-8-25.2-10.2l-.6-.2c-8.6-2.6-14.4-4.4-18.2-6.8c-1.6-1-2.1-1.6-2.2-1.7c0-.1 0-.2 0-.4zm-272 0c0-1.1 .2-1.6 .4-1.9c.3-.4 .9-1.2 2.4-2c3.1-1.8 8-3 12.9-2.9c6.6 .1 16.7 1.6 23.3 3.4c8.5 2.3 17.3-2.8 19.6-11.3s-2.8-17.3-11.3-19.6c-8.8-2.4-21.6-4.3-31.1-4.4c-9.3-.1-20.4 1.9-29.7 7.4C80.6 157.3 72 167.8 72 183c.1 14.7 8.8 24 17.7 29.4c7.6 4.6 17.1 7.4 24.3 9.6l0 0 1.2 .4c8.5 2.6 14.2 4.5 18 6.9c2.7 1.7 2.7 2.4 2.7 3.1l0 .2c0 1.6-.3 2.3-.6 2.7c-.3 .5-.9 1.2-2.1 2c-2.8 1.7-7.5 2.9-12.8 2.8c-7.2-.2-14.2-2.6-23.7-5.8l0 0 0 0c-1.3-.4-2.7-.9-4.1-1.4c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2c1.1 .4 2.4 .8 3.6 1.2l0 0 0 0c9 3.1 20.9 7.2 33.2 7.6c9.8 .3 21.2-1.6 30.7-7.6c10.2-6.4 18-17.3 17.8-32.3c-.2-14.7-8.5-24.2-17.6-29.9c-8-5-17.9-8-25.2-10.2l-.6-.2c-8.6-2.6-14.4-4.4-18.3-6.8c-1.6-1-2.1-1.6-2.2-1.7c0-.1 0-.2 0-.4z", "M220.8 150.4c-4.1-5.5-11.3-7.8-17.9-5.6S192 153.1 192 160v96c0 8.8 7.2 16 16 16s16-7.2 16-16V208l19.2 25.6c3 4 7.8 6.4 12.8 6.4s9.8-2.4 12.8-6.4L288 208v48c0 8.8 7.2 16 16 16s16-7.2 16-16V160c0-6.9-4.4-13-10.9-15.2s-13.7 .1-17.9 5.6L256 197.3l-35.2-46.9zM376.5 181c.3-.4 .9-1.2 2.4-2c3.1-1.8 8-3 12.9-2.9c6.1 .1 12.9 1.4 20.1 3.4c8.5 2.3 17.3-2.8 19.6-11.3s-2.8-17.3-11.3-19.6c-8.2-2.2-17.9-4.3-27.9-4.4c-9.3-.1-20.4 1.9-29.7 7.4c-9.9 5.9-18.6 16.4-18.5 31.6c.1 14.7 8.8 24 17.7 29.4c7.6 4.6 17.1 7.4 24.3 9.6l1.2 .4c8.5 2.6 14.2 4.5 18 6.9c2.7 1.7 2.7 2.4 2.7 3.1l0 .2c0 1.6-.3 2.3-.6 2.7c-.3 .5-.9 1.2-2.1 2c-2.8 1.7-7.5 2.9-12.8 2.8c-7-.2-13.5-2.4-22.6-5.5l0 0c-1.5-.5-3.2-1.1-4.9-1.6c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2c1.3 .4 2.6 .9 4 1.4l0 0c8.8 3 20.4 7 32.6 7.4c9.8 .3 21.2-1.6 30.7-7.6c10.2-6.4 18-17.3 17.8-32.3c-.2-14.7-8.5-24.2-17.6-29.9c-8-5-17.9-8-25.2-10.2l-.6-.2c-8.6-2.6-14.4-4.4-18.2-6.8c-1.6-1-2.1-1.6-2.2-1.7c0-.1 0-.2 0-.4c0-1.1 .2-1.6 .4-1.9zm-272 0c.3-.4 .9-1.2 2.4-2c3.1-1.8 8-3 12.9-2.9c6.6 .1 16.7 1.6 23.3 3.4c8.5 2.3 17.3-2.8 19.6-11.3s-2.8-17.3-11.3-19.6c-8.8-2.4-21.6-4.3-31.1-4.4c-9.3-.1-20.4 1.9-29.7 7.4C80.6 157.3 72 167.8 72 183c.1 14.7 8.8 24 17.7 29.4c7.6 4.6 17.1 7.4 24.3 9.6l0 0 0 0 1.2 .4c8.5 2.6 14.2 4.5 18 6.9c2.7 1.7 2.7 2.4 2.7 3.1l0 .2c0 1.6-.3 2.3-.6 2.7c-.3 .5-.9 1.2-2.1 2c-2.8 1.7-7.5 2.9-12.8 2.8c-7.2-.2-14.2-2.6-23.7-5.8l0 0 0 0c-1.3-.4-2.7-.9-4.1-1.4c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2c1.1 .4 2.4 .8 3.6 1.2l0 0 0 0 0 0c9 3.1 20.9 7.2 33.2 7.6c9.8 .3 21.2-1.6 30.7-7.6c10.2-6.4 18-17.3 17.8-32.3c-.2-14.7-8.5-24.2-17.6-29.9c-8-5-17.9-8-25.2-10.2l-.6-.2c-8.6-2.6-14.4-4.4-18.3-6.8c-1.6-1-2.1-1.6-2.2-1.7c0-.1 0-.2 0-.4c0-1.1 .2-1.6 .4-1.9z"]],
    "coffee-beans": [512, 512, [], "e13f", ["M278.4 235.4c-55.1-55.1-69.5-132.5-37.9-184.3c8.1 17.8 18.9 38.5 31.3 53.2c27.7 32.8 61.2 44.7 90.7 55.3l1 .4c30.1 10.8 56.2 20.3 78 46.2c10.9 12.8 21.4 33.6 29.5 52.3c1 2.3 2 4.6 2.9 6.8c-51.3 41.5-136.3 29.3-195.6-29.9zm181-181c55.1 55.1 69.5 132.5 37.9 184.3c-8.1-17.8-18.9-38.5-31.3-53.2c-27.7-32.8-61.2-44.7-90.7-55.3l-1-.4c-30.1-10.8-56.2-20.3-78-46.2c-10.9-12.8-21.4-33.6-29.5-52.3c-1-2.3-2-4.6-2.9-6.8C315.1-17 400.2-4.9 459.4 54.4zM0 352c0-77.9 44.5-142.8 103.5-157.1c-6.9 18.3-13.9 40.6-15.5 59.7c-3.6 42.8 11.6 74.9 25 103.2l.4 .9c13.7 28.9 25.3 54.1 22.5 87.8c-1.4 16.7-8.6 38.9-16.1 57.9c-.9 2.4-1.9 4.7-2.8 6.9C51.5 504.5 0 435.8 0 352zm256 0c0 77.9-44.5 142.8-103.5 157.1c6.9-18.3 13.9-40.6 15.5-59.8c3.6-42.8-11.6-74.9-25-103.2l-.4-.9c-13.7-28.9-25.3-54.1-22.5-87.8c1.4-16.7 8.6-38.9 16.1-57.9c.9-2.4 1.9-4.7 2.8-6.9C204.5 199.5 256 268.2 256 352z", "M471 258.5c1 2.3 2 4.6 2.9 6.8c2.8-2.3 5.5-4.7 8.1-7.3c5.9-5.9 11-12.4 15.2-19.4c-8.1-17.8-18.9-38.5-31.3-53.2c-27.7-32.8-61.2-44.7-90.7-55.3l-1-.4c-30.1-10.8-56.2-20.3-78-46.2c-10.9-12.8-21.4-33.6-29.5-52.3c-1-2.3-2-4.6-2.9-6.8c-2.8 2.3-5.5 4.7-8.1 7.3c-5.9 5.9-11 12.4-15.2 19.4c8.1 17.8 18.9 38.5 31.3 53.2c27.7 32.8 61.2 44.7 90.7 55.3l1 .4c30.1 10.8 56.2 20.3 78 46.2c10.9 12.8 21.4 33.6 29.5 52.3zM119.9 504.5c-.9 2.4-1.9 4.7-2.8 6.9c3.6 .4 7.2 .6 10.9 .6c8.4 0 16.6-1 24.5-2.9c6.9-18.3 13.9-40.6 15.5-59.8c3.6-42.8-11.6-74.9-25-103.2l-.4-.9c-13.7-28.9-25.3-54.1-22.5-87.8c1.4-16.7 8.6-38.9 16.1-57.9c.9-2.4 1.9-4.7 2.8-6.9c-3.6-.4-7.2-.6-10.9-.6c-8.4 0-16.6 1-24.5 2.9c-6.9 18.3-13.9 40.6-15.5 59.7c-3.6 42.8 11.6 74.9 25 103.2l.4 .9c13.7 28.9 25.3 54.1 22.5 87.8c-1.4 16.7-8.6 38.9-16.1 57.9z"]],
    "hat-witch": [576, 512, [], "f6e7", ["M553.4 416H22.6C10.1 416 0 426.1 0 438.6c0 6 2.4 11.7 6.9 15.6C25.9 470.3 82.6 512 160 512H416c77.4 0 134.1-41.7 153.1-57.8c4.6-3.9 6.9-9.6 6.9-15.6c0-12.5-10.1-22.6-22.6-22.6z", "M96 416L200.6 180.7c15.3-34.4 40.3-63.5 72-83.7L416.1 5c5.2-3.3 11.1-5 17.3-5h2.2c8 0 15.7 3 21.6 8.4l76.4 70.1c6.6 6.1 10.4 14.6 10.4 23.6v6.8c0 2.1-.2 4.2-.6 6.3l-12.2 60.8c-1.9 9.3-10.1 16.1-19.6 16.1c-9.2 0-17.2-6.2-19.4-15.1l-6.2-24.6C482.5 138 469.7 128 455 128H434.6c-11.5 0-22.1 6.2-27.8 16.1l-18.6 32.5c-2.8 4.8-4.2 10.3-4.2 15.9v.7c0 4.5 .9 8.9 2.8 13L480 416H352V368c0-26.5-21.5-48-48-48H272c-26.5 0-48 21.5-48 48v48H96zm160 0V368c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48H256z"]],
    "face-grin-wink": [512, 512, ["grin-wink"], "f58c", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM388.1 312.8c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19zm-16.9-79.2c-17.6-23.5-52.8-23.5-70.4 0c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4c30.4-40.5 91.2-40.5 121.6 0c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm124.4-6.4c17.6-23.5 52.8-23.5 70.4 0c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2z"]],
    "clock-three-thirty": [512, 512, [], "e357", ["M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V256c0-13.3 10.7-24 24-24H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H280V392c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M256 416c-13.3 0-24-10.7-24-24V256c0-13.3 10.7-24 24-24H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H280V392c0 13.3-10.7 24-24 24z"]],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", ["M502.6 9.4c12.5 12.5 12.5 32.8 0 45.3l-40 40c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l40-40c12.5-12.5 32.8-12.5 45.3 0zm-320 320c12.5 12.5 12.5 32.8 0 45.3l-128 128c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0z", "M128.7 227.5c6.2-56 53.7-99.5 111.3-99.5c61.9 0 112 50.1 112 112c0 29.3-11.2 55.9-29.6 75.9c-17 18.4-34.4 45.1-34.4 78V400c0 26.5-21.5 48-48 48c-17.7 0-32 14.3-32 32s14.3 32 32 32c61.9 0 112-50.1 112-112v-6.1c0-9.8 5.4-21.7 17.4-34.7C398.3 327.9 416 286 416 240c0-97.2-78.8-176-176-176C149.4 64 74.8 132.5 65.1 220.5c-1.9 17.6 10.7 33.4 28.3 35.3s33.4-10.7 35.3-28.3zM208 240c0-17.7 14.3-32 32-32s32 14.3 32 32c0 13.3 10.7 24 24 24s24-10.7 24-24c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 13.3 10.7 24 24 24s24-10.7 24-24z"]],
    "alarm-clock": [512, 512, [9200], "f34e", ["M256 512c50.3 0 96.8-16.6 134.2-44.6l35.2 35.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-35.2-35.2c28-37.4 44.6-83.8 44.6-134.2C480 164.3 379.7 64 256 64S32 164.3 32 288c0 50.3 16.6 96.8 44.6 134.2L41.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l35.2-35.2c37.4 28 83.8 44.6 134.1 44.6zm24-328v94.1l41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-4.5-4.5-7-10.6-7-17V184c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M14.9 146.4L160 25.4C143 9.6 120.2 0 95.2 0C42.6 0 0 42.6 0 95.2c0 18.8 5.5 36.3 14.9 51.1zM256 160c-13.3 0-24 10.7-24 24V288c0 6.4 2.5 12.5 7 17l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-41-41V184c0-13.3-10.7-24-24-24zM352 25.4L497.1 146.4C506.5 131.6 512 114 512 95.2C512 42.6 469.4 0 416.8 0C391.8 0 369 9.6 352 25.4z"]],
    "eclipse": [640, 512, [], "f749", ["M361.5 1.2c5 2.1 8.6 6.6 9.6 11.9l9.6 52.2c-34.2 15-63.7 38.9-85.4 68.8c-12.4-4-25.6-6.2-39.4-6.2c-70.7 0-128 57.3-128 128s57.3 128 128 128c13.7 0 27-2.2 39.4-6.2c21.7 29.9 51.1 53.9 85.4 68.8l-9.6 52.2c-1 5.3-4.6 9.8-9.6 11.9s-10.7 1.5-15.2-1.6L256 446.9l-90.3 62.3c-4.5 3.1-10.2 3.7-15.2 1.6s-8.6-6.6-9.6-11.9L121 391 13.1 371.1c-5.3-1-9.8-4.6-11.9-9.6s-1.5-10.7 1.6-15.2L65.1 256 2.8 165.7c-3.1-4.5-3.7-10.2-1.6-15.2s6.6-8.6 11.9-9.6L121 121 140.9 13.1c1-5.3 4.6-9.8 9.6-11.9s10.7-1.5 15.2 1.6L256 65.1 346.3 2.8c4.5-3.1 10.2-3.7 15.2-1.6zM278.1 162.6C264 190.7 256 222.4 256 256s8 65.3 22.1 93.4c-7.1 1.7-14.5 2.6-22.1 2.6c-53 0-96-43-96-96s43-96 96-96c7.6 0 15 .9 22.1 2.6z", "M464 80a176 176 0 1 0 0 352 176 176 0 1 0 0-352z"]],
    "face-relieved": [512, 512, [], "e389", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM187.3 356.7c13 13 35.8 27.3 68.7 27.3s55.6-14.3 68.7-27.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6C329.4 397.2 298.9 416 256 416s-73.4-18.8-91.3-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zM387.2 238.4c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0zm-262.4 0c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zM207.2 74.9c2.8 8.4-1.7 17.4-10.1 20.2l-6.3 2.1c-23.6 7.9-44 23.4-57.8 44.1l-7.6 11.5c-4.9 7.4-14.8 9.3-22.2 4.4s-9.3-14.8-4.4-22.2l7.6-11.5c17.8-26.6 43.9-46.6 74.3-56.7l6.3-2.1c8.4-2.8 17.4 1.7 20.2 10.1zM314.9 95.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l6.3 2.1c30.4 10.1 56.5 30.1 74.3 56.7l7.6 11.5c4.9 7.4 2.9 17.3-4.4 22.2s-17.3 2.9-22.2-4.4L379 141.4c-13.8-20.7-34.1-36.3-57.8-44.1l-6.3-2.1z", "M207.2 74.9c2.8 8.4-1.7 17.4-10.1 20.2l-6.3 2.1c-23.6 7.9-44 23.4-57.8 44.1l-7.6 11.5c-4.9 7.4-14.8 9.3-22.2 4.4s-9.3-14.8-4.4-22.2l7.6-11.5c17.8-26.6 43.9-46.6 74.3-56.7l6.3-2.1c8.4-2.8 17.4 1.7 20.2 10.1zM124.8 238.4c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zm192 0c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zM314.9 95.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l6.3 2.1c30.4 10.1 56.5 30.1 74.3 56.7l7.6 11.5c4.9 7.4 2.9 17.3-4.4 22.2s-17.3 2.9-22.2-4.4L379 141.4c-13.8-20.7-34.1-36.3-57.8-44.1l-6.3-2.1z"]],
    "road-circle-check": [640, 512, [], "e564", ["M288 32H213.2c-27.1 0-51.3 17.1-60.3 42.6L35.1 407.2c-2.1 5.9-3.1 12-3.1 18.2C32 455.5 56.5 480 86.6 480H288V416c0-17.7 14.3-32 32-32l.7 0c-.5-5.3-.7-10.6-.7-16c0-16.9 2.4-33.3 6.8-48.7c-2.2 .5-4.5 .7-6.8 .7c-17.7 0-32-14.3-32-32V224c0-17.7 14.3-32 32-32s32 14.3 32 32v42.8c31.9-45.2 84.5-74.8 144-74.8c11.6 0 22.9 1.1 33.8 3.2L487.1 74.6C478 49.1 453.9 32 426.8 32H352V96c0 17.7-14.3 32-32 32s-32-14.3-32-32V32z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "dice-five": [448, 512, [9860], "f523", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm64 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M96 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm0 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "octagon-minus": [512, 512, ["minus-octagon"], "f308", ["M140.6 21.2C154.1 7.7 172.4 .1 191.5 .1h129c19.1 0 37.4 7.6 50.9 21.1L490.8 140.6c13.5 13.5 21.1 31.8 21.1 50.9v129c0 19.1-7.6 37.4-21.1 50.9L371.4 490.8c-13.5 13.5-31.8 21.1-50.9 21.1h-129c-19.1 0-37.4-7.6-50.9-21.1L21.2 371.4C7.7 357.9 .1 339.6 .1 320.5v-129c0-19.1 7.6-37.4 21.1-50.9L140.6 21.2zM184 232c-13.3 0-24 10.7-24 24s10.7 24 24 24H328c13.3 0 24-10.7 24-24s-10.7-24-24-24H184z", "M160 256c0-13.3 10.7-24 24-24H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24z"]],
    "square-rss": [448, 512, ["rss-square"], "f143", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96z", "M120 112c-13.3 0-24 10.7-24 24s10.7 24 24 24c110.5 0 200 89.5 200 200c0 13.3 10.7 24 24 24s24-10.7 24-24c0-137-111-248-248-248zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24c57.4 0 104 46.6 104 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-83.9-68.1-152-152-152zm8 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "face-zany": [512, 512, [], "e3a4", ["M477.8 128c70.7 122.4 28.7 279-93.7 349.7c-8.5 4.9-17.2 9.3-26.1 13.2c6.4-12.9 10.1-27.5 10.1-42.9V391.7c49.1-40.9 70.1-105.6 55-165c-3.5-13.8-19.5-18.9-31.8-11.8L152.9 352.5c-12.3 7.1-15.9 23.5-5.7 33.4c8.8 8.6 18.5 16 28.9 22.2V448c0 21.1 6.8 40.6 18.4 56.5C129.3 488.3 70.6 446.7 34.4 384C-36.3 261.6 5.6 105 128.1 34.3S407.1 5.6 477.8 128zM192 224A64 64 0 1 0 64 224a64 64 0 1 0 128 0zm120 0a72 72 0 1 0 0-144 72 72 0 1 0 0 144z", "M296 104a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM104 224a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM336.1 402.6V448c0 35.3-28.7 64-64 64s-64-28.7-64-64V402.6c0-14.7 11.9-26.6 26.6-26.6h2c11.3 0 21.1 7.9 23.6 18.9c2.8 12.6 20.8 12.6 23.6 0c2.5-11.1 12.3-18.9 23.6-18.9h2c14.7 0 26.6 11.9 26.6 26.6z"]],
    "tricycle": [512, 512, [], "e5c3", ["M256 352c0-51.5 30.4-95.9 74.2-116.2l14 56.1c-19.4 12.9-32.2 35-32.2 60c0 39.8 32.2 72 72 72s72-32.2 72-72c0-37.5-28.6-68.2-65.2-71.7l-14-56.1c2.4-.1 4.8-.2 7.2-.2c70.7 0 128 57.3 128 128s-57.3 128-128 128s-128-57.3-128-128zm-88 16A56 56 0 1 0 56 368a56 56 0 1 0 112 0zM0 368a112 112 0 1 1 224 0A112 112 0 1 1 0 368z", "M256 56c0-13.3 10.7-24 24-24h73.6C388.1 32 416 59.9 416 94.4c0 18.2-8 35.5-21.8 47.3l-31.3 26.9 44.4 177.6c3.2 12.9-4.6 25.9-17.5 29.1s-25.9-4.6-29.1-17.5L319.3 192H307.2c-57.6 0-110.9 29.5-141.6 77.6c-14.3-7.8-30.5-12.6-47.8-13.5c1.2-2.3 2.5-4.5 3.9-6.7L77.6 176H56c-13.3 0-24-10.7-24-24s10.7-24 24-24h80c13.3 0 24 10.7 24 24s-10.7 24-24 24h-2.4l19.6 32.6c40-40.7 95.3-64.6 154.1-64.6h10.9c.7-.8 1.5-1.5 2.3-2.2L363 105.3c3.2-2.7 5-6.7 5-10.9c0-7.9-6.4-14.4-14.4-14.4H280c-13.3 0-24-10.7-24-24z"]],
    "land-mine-on": [640, 512, [], "e51b", ["M224 288c-17.7 0-32 14.3-32 32v32H448V320c0-17.7-14.3-32-32-32H224zm-66.3 96c-18.2 0-34.8 10.3-42.9 26.5L87.2 465.7C76.5 487 92 512 115.8 512H524.2c23.8 0 39.3-25 28.6-46.3l-27.6-55.2c-8.1-16.3-24.8-26.5-42.9-26.5H157.7z", "M320 0c13.3 0 24 10.7 24 24V168c0 13.3-10.7 24-24 24s-24-10.7-24-24V24c0-13.3 10.7-24 24-24zM36.3 138.3c7.5-10.9 22.5-13.6 33.4-6.1l104 72c10.9 7.5 13.6 22.5 6.1 33.4s-22.5 13.6-33.4 6.1l-104-72c-10.9-7.5-13.6-22.5-6.1-33.4zm534.1-6.1c10.9-7.5 25.8-4.8 33.4 6.1s4.8 25.8-6.1 33.4l-104 72c-10.9 7.5-25.8 4.8-33.4-6.1s-4.8-25.8 6.1-33.4l104-72z"]],
    "square-arrow-up-left": [448, 512, [], "e263", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM288 144c13.3 0 24 10.7 24 24s-10.7 24-24 24H193.9L329 327c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-135-135V328c0 13.3-10.7 24-24 24s-24-10.7-24-24V168c0-13.3 10.7-24 24-24H288z", "M136 144H288c13.3 0 24 10.7 24 24s-10.7 24-24 24H193.9L329 327c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-135-135V328c0 13.3-10.7 24-24 24s-24-10.7-24-24V168c0-13.3 10.7-24 24-24z"]],
    "i-cursor": [256, 512, [], "f246", ["M96 224H64c-17.7 0-32 14.3-32 32s14.3 32 32 32H96V224zm64 64h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H160v64z", "M29.3 63.9C11.7 62.4-1.4 47 .1 29.3S17-1.4 34.7 .1l8 .7C76.8 3.6 106.8 19.7 128 43.7c21.2-24 51.2-40 85.4-42.9l8-.7c17.6-1.5 33.1 11.6 34.5 29.2s-11.6 33.1-29.2 34.5l-8 .7C185.5 67.3 160 95 160 128.3V383.7c0 33.3 25.5 61 58.7 63.8l8 .7c17.6 1.5 30.7 16.9 29.2 34.5s-16.9 30.7-34.5 29.2l-8-.7c-34.1-2.8-64.2-18.9-85.4-42.9c-21.2 24-51.2 40.1-85.4 42.9l-8 .7C17 513.4 1.6 500.3 .1 482.7s11.6-33.1 29.2-34.5l8-.7C70.5 444.7 96 417 96 383.7V128.3c0-33.3-25.5-61-58.7-63.8l-8-.7z"]],
    "chart-mixed-up-circle-dollar": [576, 512, [], "e5d9", ["M400 0c-17.7 0-32 14.3-32 32s14.3 32 32 32h28.8L319.4 151.5 211.2 70.4c-11.7-8.8-27.8-8.5-39.2 .6L12 199c-13.8 11-16 31.2-5 45s31.2 16 45 5L192.6 136.5l108.2 81.1c11.7 8.8 27.8 8.5 39.2-.6L480 105v39c0 17.7 14.3 32 32 32s32-14.3 32-32V32c0-17.7-14.3-32-32-32H400zM160 256V448c0 17.7 14.3 32 32 32s32-14.3 32-32V256c0-17.7-14.3-32-32-32s-32 14.3-32 32zM32 352v96c0 17.7 14.3 32 32 32s32-14.3 32-32V352c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM408.1 339l0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2v10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16V438.1c-8.6-1.7-16.7-4.3-23.7-6.6l0 0c-1.7-.6-3.4-1.1-5-1.6c-8.4-2.6-13.2-11.6-10.5-20s11.6-13.2 20-10.5c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3V288c0-8.8 7.2-16 16-16s16 7.2 16 16v9.4c6.3 .9 12.3 2.3 17.9 3.7c8.6 2.1 13.8 10.8 11.7 19.4s-10.8 13.8-19.4 11.7c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"]],
    "salt-shaker": [384, 512, [129474], "e446", ["M36.6 192L.6 443.8c-.4 2.8-.6 5.6-.6 8.5c0 33 26.8 59.8 59.8 59.8H324.2c33 0 59.8-26.8 59.8-59.8c0-2.8-.2-5.7-.6-8.5L347.4 192H282.8l36.6 256H64.6l36.6-256H36.6z", "M101.2 192H282.8h64.7l-9.3-65.3C327.7 54 265.4 0 192 0S56.3 54 45.9 126.7L36.6 192h64.6zM176 64a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM144 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "stamp": [512, 512, [], "f5bf", ["M32 416v48c0 26.5 21.5 48 48 48H432c26.5 0 48-21.5 48-48V416H416v32H96V416H32z", "M312 201.8c0-17.4 9.2-33.2 19.9-47C344.5 138.5 352 118.1 352 96c0-53-43-96-96-96s-96 43-96 96c0 22.1 7.5 42.5 20.1 58.8c10.7 13.8 19.9 29.6 19.9 47c0 29.9-24.3 54.2-54.2 54.2H112C50.1 256 0 306.1 0 368v8c0 22.1 17.9 40 40 40H472c22.1 0 40-17.9 40-40v-8c0-61.9-50.1-112-112-112H366.2c-29.9 0-54.2-24.3-54.2-54.2z"]],
    "file-plus": [384, 512, [], "f319", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM192 240c-13.3 0-24 10.7-24 24v48H120c-13.3 0-24 10.7-24 24s10.7 24 24 24h48v48c0 13.3 10.7 24 24 24s24-10.7 24-24V360h48c13.3 0 24-10.7 24-24s-10.7-24-24-24H216V264c0-13.3-10.7-24-24-24z", "M384 160H256c-17.7 0-32-14.3-32-32V0L384 160zM192 240c13.3 0 24 10.7 24 24v48h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H216v48c0 13.3-10.7 24-24 24s-24-10.7-24-24V360H120c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V264c0-13.3 10.7-24 24-24z"]],
    "draw-square": [448, 512, [], "f5ef", ["M328.6 64H119.4c5.4 9.4 8.6 20.3 8.6 32s-3.1 22.6-8.6 32H328.6c-5.4-9.4-8.6-20.3-8.6-32s3.1-22.6 8.6-32zM352 151.4V360.6c9.4-5.4 20.3-8.6 32-8.6s22.6 3.1 32 8.6V151.4c-9.4 5.4-20.3 8.6-32 8.6s-22.6-3.1-32-8.6zM64 160c-11.7 0-22.6-3.1-32-8.6V360.6c9.4-5.4 20.3-8.6 32-8.6s22.6 3.1 32 8.6V151.4c-9.4 5.4-20.3 8.6-32 8.6zM328.6 448c-5.4-9.4-8.6-20.3-8.6-32s3.1-22.6 8.6-32H119.4c5.4 9.4 8.6 20.3 8.6 32s-3.1 22.6-8.6 32H328.6z", "M0 96a64 64 0 1 1 128 0A64 64 0 1 1 0 96zM64 352a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm320 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0-320a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]],
    "toilet-paper-under-slash": [640, 512, ["toilet-paper-reverse-slash"], "e2a1", ["M576 426.2V343.1c-9.9 19.5-23.2 38.2-39.9 51.8L576 426.2zm-66-51.7c22.6-14.8 41.4-46 53.1-86.4c8.2-28.2 12.8-61 12.8-96C576 86 533 0 480 0c-11.2 0-22 3.8-32 10.9c-37.3 26.4-64 97.5-64 181.1c0 33.8 4.4 65.5 12 93.1l114 89.3zM356.7 254.3c-3.1-19.9-4.7-40.8-4.7-62.3c0-56.9 11.5-110 31.5-150.1c7.5-15 17.1-29.7 28.7-41.9H160c-24.8 0-47.4 18.8-64.4 49.6L356.7 254.3zM528 512L406.2 416H224v48c0 26.5 21.5 48 48 48H528l.3 0H528zM64 192c0 106 43 192 96 192H365.5L66.5 148.4C64.9 162.4 64 177 64 192zm416 64c-17.7 0-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "stairs": [576, 512, [], "e289", ["M384 96h64v64H384V96zM256 224h64v64H256V224zM192 352v64H128V352h64z", "M416 32c-17.7 0-32 14.3-32 32V96h64 96c17.7 0 32-14.3 32-32s-14.3-32-32-32H416zM384 160H288c-17.7 0-32 14.3-32 32v32h64 96c17.7 0 32-14.3 32-32V160H384zM160 288c-17.7 0-32 14.3-32 32v32h64 96c17.7 0 32-14.3 32-32V288H256 160zm32 128H128 32c-17.7 0-32 14.3-32 32s14.3 32 32 32H160c17.7 0 32-14.3 32-32V416z"]],
    "drone-front": [640, 512, ["drone-alt"], "f860", ["M24 112c-13.3 0-24 10.7-24 24s10.7 24 24 24H264c13.3 0 24-10.7 24-24s-10.7-24-24-24H24zm352 0c-13.3 0-24 10.7-24 24s10.7 24 24 24H616c13.3 0 24-10.7 24-24s-10.7-24-24-24H376z", "M160 160H96v32 64c0 12.6 7.4 24.1 19 29.2l56.5 25.1c-17.8 21.5-27.5 48.5-27.5 76.4V392c0 13.3 10.7 24 24 24s24-10.7 24-24v-5.2c0-16.8 5.9-33.2 16.7-46.1l8.4-10.1L259 349.2c4.1 1.8 8.5 2.8 13 2.8h96c4.5 0 8.9-.9 13-2.8l41.9-18.6 8.4 10.1c10.8 12.9 16.7 29.3 16.7 46.1V392c0 13.3 10.7 24 24 24s24-10.7 24-24v-5.2c0-27.9-9.7-54.9-27.5-76.4L525 285.2c11.6-5.1 19-16.6 19-29.2V192 160H480v32 43.2l-17.8 7.9-40.6-23.7C390.7 201.5 355.7 192 320 192s-70.7 9.5-101.6 27.5l-40.6 23.7L160 235.2V192 160zm324.3-48h55.4c-5.5-9.6-15.9-16-27.7-16s-22.2 6.4-27.7 16zM128 96c-11.8 0-22.2 6.4-27.7 16h55.4c-5.5-9.6-15.9-16-27.7-16z"]],
    "glass-empty": [384, 512, [], "e191", ["M8.6 10.2C14.6 3.7 23.1 0 32 0H352c8.9 0 17.4 3.7 23.4 10.2s9.1 15.2 8.5 24.1L355.1 437.7c-3 41.9-37.8 74.3-79.8 74.3H108.7c-42 0-76.8-32.4-79.8-74.3L.1 34.3c-.6-8.9 2.4-17.6 8.5-24.1zM66.4 64L92.7 433.1c.6 8.4 7.6 14.9 16 14.9H275.3c8.4 0 15.4-6.5 16-14.9L317.6 64H66.4z", ""]],
    "dial-high": [576, 512, [], "e15c", ["M256 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M446.6 263.6c-11.6-77-78-136-158.2-136c-88.4 0-160 71.6-160 160s71.6 160 160 160c80.2 0 146.6-59 158.2-136l-158.2 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l158.2 0z"]],
    "user-helmet-safety": [448, 512, [128119, "user-construction", "user-hard-hat"], "f82c", ["M97 176c-.7 5.2-1 10.6-1 16c0 70.7 57.3 128 128 128s128-57.3 128-128c0-5.4-.3-10.8-1-16H97z", "M216 0c-13.3 0-24 10.7-24 24V80L163.6 23.1C125.6 43.5 99 82.6 96.2 128H96c-13.3 0-24 10.7-24 24s10.7 24 24 24H352c13.3 0 24-10.7 24-24s-10.7-24-24-24h-.2C349 82.6 322.4 43.5 284.4 23.1L256 80V24c0-13.3-10.7-24-24-24H216zM134.4 352C60.2 352 0 412.2 0 486.4C0 500.5 11.5 512 25.6 512H422.4c14.1 0 25.6-11.5 25.6-25.6C448 412.2 387.8 352 313.6 352H134.4z"]],
    "i": [320, 512, [105], "49", ["M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96h96V416H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H288c17.7 0 32-14.3 32-32s-14.3-32-32-32H192V96h96c17.7 0 32-14.3 32-32s-14.3-32-32-32H160 32z", ""]],
    "hryvnia-sign": [384, 512, [8372, "hryvnia"], "f6f2", ["M260.9 176H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H155.5l91.8-52.5c5.3-3 9.9-7 13.6-11.5zM99.8 272H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H52.3c7.5-26.1 24.2-49 47.5-64zm23.2 64H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H228.5l-91.8 52.5c-5.3 3-9.9 7-13.6 11.5zm161.1-96H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H331.7c-7.5 26.1-24.2 49-47.5 64z", "M179.6 96c-21 0-41.3 7.1-57.7 20.2L116 121c-13.8 11-33.9 8.8-45-5s-8.8-33.9 5-45l5.9-4.7C109.7 44.1 144.1 32 179.6 32H223c62.4 0 113 50.6 113 113c0 40.5-21.7 78-56.9 98.1L136.7 324.5c-15.3 8.7-24.7 25-24.7 42.5c0 27.1 21.9 49 49 49h43.4c21 0 41.3-7.1 57.7-20.2L268 391c13.8-11 33.9-8.8 45 5s8.8 33.9-5 45l-5.9 4.7c-27.7 22.2-62.2 34.3-97.7 34.3H161C98.6 480 48 429.4 48 367c0-40.6 21.7-78 56.9-98.1l142.4-81.4c15.3-8.7 24.7-25 24.7-42.5c0-27.1-21.9-49-49-49H179.6z"]],
    "arrow-down-left-and-arrow-up-right-to-center": [512, 512, [], "e092", ["M48 304c0-17.7 14.3-32 32-32H208c17.7 0 32 14.3 32 32V432c0 17.7-14.3 32-32 32s-32-14.3-32-32V381.3L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L130.7 336H80c-17.7 0-32-14.3-32-32z", "M502.6 9.4c12.5 12.5 12.5 32.8 0 45.3L381.3 176H432c17.7 0 32 14.3 32 32s-14.3 32-32 32H304c-17.7 0-32-14.3-32-32V80c0-17.7 14.3-32 32-32s32 14.3 32 32v50.7L457.4 9.4c12.5-12.5 32.8-12.5 45.3 0z"]],
    "pills": [576, 512, [], "f484", ["M224 256V224l0-80c0-61.9-50.1-112-112-112S0 82.1 0 144v80 32H32l160 0h32zM554.9 399.4C568.3 376 576 348.9 576 320c0-88.4-71.6-160-160-160c-28.9 0-56 7.7-79.4 21.1c-12.3 7.1-13.1 23.7-3.1 33.8L521.1 402.5c10 10 26.7 9.3 33.8-3.1zm-59.5 59.5c12.3-7.1 13.1-23.7 3.1-33.8L310.9 237.5c-10-10-26.7-9.3-33.8 3.1C263.7 264 256 291.1 256 320c0 88.4 71.6 160 160 160c28.9 0 56-7.7 79.4-21.1z", "M32 256H0v32 80c0 61.9 50.1 112 112 112s112-50.1 112-112V288 256H192 32z"]],
    "face-grin-wide": [512, 512, [128515, "grin-alt"], "f581", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM388.1 312.8c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19zM208 192c0 35.3-14.3 64-32 64s-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64zm128 64c-17.7 0-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64z", "M176 256c17.7 0 32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64s14.3 64 32 64zm160 0c17.7 0 32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64s14.3 64 32 64z"]],
    "tooth": [448, 512, [129463], "f5c9", ["M186.1 52.1C169.3 39.1 148.7 32 127.5 32C74.7 32 32 74.7 32 127.5v6.2c0 15.8 3.7 31.3 10.7 45.5l23.5 47.1c4.5 8.9 7.6 18.4 9.4 28.2l36.7 205.8c2 11.2 11.6 19.4 22.9 19.8s21.4-7.4 24-18.4l28.9-121.3C192.2 323.7 207 312 224 312s31.8 11.7 35.8 28.3l28.9 121.3c2.6 11.1 12.7 18.8 24 18.4s20.9-8.6 22.9-19.8l36.7-205.8c1.8-9.8 4.9-19.3 9.4-28.2l23.5-47.1c7.1-14.1 10.7-29.7 10.7-45.5v-2.1c0-55-44.6-99.6-99.6-99.6c-24.1 0-47.4 8.8-65.6 24.6l-3.2 2.8 19.5 15.2c7 5.4 8.2 15.5 2.8 22.5s-15.5 8.2-22.5 2.8l-24.4-19-37-28.8z", ""]],
    "basketball-hoop": [640, 512, [], "f435", ["M6.8 187C24.7 153.1 116.7 0 320 0S615.3 153.1 633.2 187c4.9 9.4 6.8 19.1 6.8 28V331.2c0 25.3-14.9 48.2-38 58.5l-96.4 42.9L526.2 288H528c13.3 0 24-10.7 24-24s-10.7-24-24-24H480V224 160c0-17.7-14.3-32-32-32H192c-17.7 0-32 14.3-32 32v64 16H112c-13.3 0-24 10.7-24 24s10.7 24 24 24h1.8l20.7 144.6L38 389.7C14.9 379.4 0 356.5 0 331.2V214.9c0-8.9 1.8-18.6 6.8-28zM192 240V224 160H448v64 16H192z", "M112 240c-13.3 0-24 10.7-24 24s10.7 24 24 24h34.1l7.2 50.3 22.9 160c.9 6.1 5.2 11.2 11.1 13s12.3 .1 16.5-4.4L255.6 451l52.8 56c3 3.2 7.2 5 11.6 5s8.6-1.8 11.6-5l52.8-56 51.9 55.9c4.2 4.5 10.6 6.2 16.5 4.4s10.2-6.9 11.1-13l22.9-160 7.2-50.3H528c13.3 0 24-10.7 24-24s-10.7-24-24-24H112zm349.6 48l-5.2 36.6-44-36.6h49.2zm-99.3 0l.6 .5L320 334.6l-42.8-46.1 .6-.5h84.4zm-134.5 0l-44 36.6L178.4 288h49.2zm159.8 21l48.7 40.5-51.6 54.7-42.7-46L387.5 309zm49.4 151.6l-30.5-32.9 41.5-44-11 76.8zM320 381.7l42.6 45.9L320 472.7l-42.6-45.2L320 381.7zm-21.8-23.5l-42.7 46-51.6-54.7L252.5 309l45.7 49.2zm-64.6 69.5l-30.5 32.9-11-76.8 41.5 44z"]],
    "objects-align-bottom": [512, 512, [], "e3bb", ["M112 384c-26.5 0-48-21.5-48-48L64 48C64 21.5 85.5 0 112 0l64 0c26.5 0 48 21.5 48 48l0 288c0 26.5-21.5 48-48 48l-64 0zm224 0c-26.5 0-48-21.5-48-48l0-160c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-64 0z", "M0 488c0 13.3 10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 464c-13.3 0-24 10.7-24 24z"]],
    "v": [384, 512, [118], "56", ["M19.7 34.5c16.3-6.8 35 .9 41.8 17.2L192 364.8 322.5 51.7c6.8-16.3 25.5-24 41.8-17.2s24 25.5 17.2 41.8l-160 384c-5 11.9-16.6 19.7-29.5 19.7s-24.6-7.8-29.5-19.7L2.5 76.3c-6.8-16.3 .9-35 17.2-41.8z", ""]],
    "sparkles": [512, 512, [10024], "f890", ["M327.5 85.2L384 64 405.2 7.5C406.9 3 411.2 0 416 0s9.1 3 10.8 7.5L448 64l56.5 21.2c4.5 1.7 7.5 6 7.5 10.8s-3 9.1-7.5 10.8L448 128l-21.2 56.5c-1.7 4.5-6 7.5-10.8 7.5s-9.1-3-10.8-7.5L384 128l-56.5-21.2c-4.5-1.7-7.5-6-7.5-10.8s3-9.1 7.5-10.8zm0 320L384 384l21.2-56.5c1.7-4.5 6-7.5 10.8-7.5s9.1 3 10.8 7.5L448 384l56.5 21.2c4.5 1.7 7.5 6 7.5 10.8s-3 9.1-7.5 10.8L448 448l-21.2 56.5c-1.7 4.5-6 7.5-10.8 7.5s-9.1-3-10.8-7.5L384 448l-56.5-21.2c-4.5-1.7-7.5-6-7.5-10.8s3-9.1 7.5-10.8z", "M205.1 73.3c-2.6-5.7-8.3-9.3-14.5-9.3s-11.9 3.6-14.5 9.3L123.4 187.4 9.3 240C3.6 242.6 0 248.3 0 254.6s3.6 11.9 9.3 14.5l114.1 52.7L176 435.8c2.6 5.7 8.3 9.3 14.5 9.3s11.9-3.6 14.5-9.3l52.7-114.1 114.1-52.7c5.7-2.6 9.3-8.3 9.3-14.5s-3.6-11.9-9.3-14.5L257.8 187.4 205.1 73.3z"]],
    "squid": [512, 512, [129425], "e450", ["M392.7 23.6c-49.9 15.2-90.2 34-122.4 54.7L257.3 19.5c-1.2-5.3 .4-10.8 4.2-14.7S270.7-.8 276 .3L392.7 23.6zm41.8 218.9c20.7-32.2 39.4-72.5 54.7-122.4l23.3 116.7c1.1 5.3-.6 10.8-4.5 14.6s-9.4 5.4-14.7 4.2l-58.9-13.1z", "M512.7 18.6c.8-5.1-.8-10.3-4.5-13.9S499.4-.6 494.3 .2c-238 39.7-322.1 146.4-334.5 226.5l-14-14-2-2-22.6-22.6c-6.2-6.2-6.2-16.4 0-22.6l56.4-56.4c18.9-18.9 18.7-49.5-.3-68.2L140.1 4.6c-6.3-6.1-16.3-6.1-22.5 .1l-2.8 2.8c-34 34-33.3 87.7-1.9 121L98.5 142.9c-18.7 18.7-18.7 49.1 0 67.9l22.6 22.6 0 0 5.7 5.7 0 0c9.3 9.4 9.3 24.5 0 33.9c-9.3 9.3-24.4 9.4-33.8 .2L76.5 256.6c-19.1-19.1-50.2-18.7-68.7 .9L4.4 261c-6.1 6.4-5.8 16.5 .6 22.6s16.5 5.8 22.6-.6l3.3-3.5c6.2-6.5 16.6-6.7 22.9-.3l10.6 10.6 .2 .2 22.6 22.6c10.1 10.2 9 26.9-2.4 35.8l-20 15.6c-3.5 2.7-7.7 4.2-12.1 4.2c-10.9 0-19.7-8.8-19.7-19.7V336c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 12.3C.9 376.8 24.1 400 52.6 400c11.5 0 22.7-3.8 31.8-10.9l28.2-21.9c9.4-7.3 22.8-6.5 31.2 1.9s9.3 21.8 1.9 31.2l-21.9 28.2c-7.1 9.1-10.9 20.3-10.9 31.8c0 28.6 23.2 51.7 51.7 51.7h12.3c8.8 0 16-7.2 16-16s-7.2-16-16-16H164.6c-10.9 0-19.7-8.8-19.7-19.7c0-4.4 1.5-8.7 4.2-12.1l15.6-20c8.8-11.4 25.6-12.4 35.8-2.3l.1 .1L223 448.3l.1 .1 9.9 9.9c6.5 6.5 6.2 17.2-.7 23.3l-2.8 2.5c-6.6 5.9-7.2 16-1.3 22.6s16 7.2 22.6 1.3l2.8-2.5c20.7-18.3 21.6-50.3 2.1-69.8l-9.9-9.9-5.7-5.7-.1-.1c-9.2-9.3-9.2-24.4 0-33.8l.1-.1 .1-.1c9.3-9.2 24.4-9.2 33.7 0l28.4 28.4c18.7 18.7 49.1 18.7 67.9 0L384.4 400c33.3 31.4 87 32.1 121-1.9l2.8-2.8c6.2-6.2 6.3-16.3 .1-22.5L472 335.7c-18.7-19-49.3-19.2-68.2-.3l-56.4 56.4c-6.2 6.2-16.4 6.2-22.6 0l-22.5-22.5-.1-.1-16-16C366.3 340.8 473 256.6 512.7 18.6zM168.9 280a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "leafy-green": [576, 512, [129388], "e41d", ["M109.3 421.5L94.2 436.6C84 426.2 78.3 412.3 78.3 397.8l0-12.9c0-14.7-5.8-28.8-16.3-39.2L35.7 319.3c-10.4-10.4-16.3-24.5-16.3-39.2V244.4c0-13.1-5.3-25.4-11-37.1c-15.2-31.1-9.9-69.6 15.9-95.4c2.1-2.1 4.3-4.1 6.5-5.9C50.6 89.9 70 69.6 83 47.7c4.1-6.9 9.1-13.4 15-19.3c37.9-37.9 99.4-37.9 137.3 0c5.9 5.9 10.9 12.4 15 19.3c1.2 2.1 2.5 4.1 3.9 6.2c-3.6 5.9-6.6 12.3-8.9 18.9c-4.9 14.3-10.6 28.6-21.3 39.3l-29.1 29.1c-12 12-18.7 28.3-18.7 45.3v43c0 17-6.7 33.3-18.7 45.3l-10.5 10.5c-12 12-18.7 28.3-18.7 45.3v45.7c0 17-6.7 33.3-18.7 45.3zM475.3 123.3L390.6 208H448c8.8 0 16 7.2 16 16s-7.2 16-16 16H358.6l-59.3 59.3-48 48c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L272 281.4V192c0-8.8 7.2-16 16-16s16 7.2 16 16v57.4l36.7-36.7 112-112c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z", "M572.5 140c-7.3 28.4-8.1 60.8-5 89.9c.3 3.3 .5 6.7 .5 10.1c0 42.1-27.1 77.9-64.9 90.8c-14.3 4.9-28.6 10.6-39.3 21.3l-29.1 29.1c-12 12-28.3 18.7-45.3 18.7h-43c-17 0-33.3 6.7-45.3 18.7l-10.5 10.5c-12 12-28.3 18.7-45.3 18.7H199.8c-17 0-33.3 6.7-45.3 18.7l-35.9 35.9c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l35.9-35.9c12-12 18.7-28.3 18.7-45.3V330.5c0-17 6.7-33.3 18.7-45.3l10.5-10.5c12-12 18.7-28.3 18.7-45.3v-43c0-17 6.7-33.3 18.7-45.3l29.1-29.1c10.7-10.7 16.4-25 21.3-39.3C258.1 35.1 293.9 8 336 8c3.4 0 6.8 .2 10.1 .5c29.1 3.1 61.5 2.3 89.9-5C445 1.2 454.3 0 464 0c61.9 0 112 50.1 112 112c0 9.7-1.2 19-3.5 28zm-97.2-16.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-112 112L304 249.4V192c0-8.8-7.2-16-16-16s-16 7.2-16 16v89.4l-43.3 43.3c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l48-48L358.6 240H448c8.8 0 16-7.2 16-16s-7.2-16-16-16H390.6l84.7-84.7z"]],
    "circle-arrow-up-right": [512, 512, [], "e0fc", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm368 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-94.1L185 361c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l135-135L184 192c-13.3 0-24-10.7-24-24s10.7-24 24-24l160 0c13.3 0 24 10.7 24 24l0 152z", "M368 168l0 152c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-94.1L185 361c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l135-135L184 192c-13.3 0-24-10.7-24-24s10.7-24 24-24l160 0c13.3 0 24 10.7 24 24z"]],
    "calendars": [512, 512, [], "e0d7", ["M96 192H512V368c0 26.5-21.5 48-48 48H144c-26.5 0-48-21.5-48-48V192z", "M224 0c-17.7 0-32 14.3-32 32V64H144c-26.5 0-48 21.5-48 48v80H512V112c0-26.5-21.5-48-48-48H416V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V64H256V32c0-17.7-14.3-32-32-32zM48 184c0-13.3-10.7-24-24-24s-24 10.7-24 24V392c0 66.3 53.7 120 120 120H392c13.3 0 24-10.7 24-24s-10.7-24-24-24H120c-39.8 0-72-32.2-72-72V184z"]],
    "bangladeshi-taka-sign": [384, 512, [], "e2e6", ["M64 160H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H64V160zm64 64h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H128v64z", "M.2 60C2.4 42.5 18.4 30.1 36 32.2l7.9 1c48 6 84.1 46.8 84.1 95.3V384c0 17.7 14.3 32 32 32h32c70.7 0 128-57.3 128-128V256c0-17.7-14.3-32-32-32H272c-17.7 0-32-14.3-32-32s14.3-32 32-32h16c53 0 96 43 96 96v32c0 106-86 192-192 192H160c-53 0-96-43-96-96V128.5c0-16.1-12-29.8-28-31.8l-7.9-1C10.5 93.6-1.9 77.6 .2 60z"]],
    "bicycle": [640, 512, [128690], "f206", ["M431.1 252.8C402.4 276.3 384 312 384 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-13.5 0-26.5 2.1-38.7 6l27.5 50.9c3.6-.6 7.4-.9 11.2-.9c39.8 0 72 32.2 72 72s-32.2 72-72 72s-72-32.2-72-72c0-18.6 7-35.5 18.6-48.3l-27.5-50.9zM128 224C57.3 224 0 281.3 0 352s57.3 128 128 128c65.3 0 119.1-48.9 127-112H198.2c-7.3 32.1-36 56-70.2 56c-39.8 0-72-32.2-72-72s32.2-72 72-72c1.7 0 3.4 .1 5.1 .2l26.2-52.3c-10-2.5-20.5-3.8-31.2-3.8z", "M312 32c-13.3 0-24 10.7-24 24s10.7 24 24 24h25.7l34.6 64H222.9l-27.4-38C191 99.7 183.7 96 176 96H120c-13.3 0-24 10.7-24 24s10.7 24 24 24h43.7l22.1 30.7-77 153.9c-9 18.1 4.1 39.4 24.3 39.4H304c8.5 0 16.3-4.5 20.7-11.8l84.8-143.5 81.4 150.7c6.3 11.7 20.9 16 32.5 9.7s16-20.9 9.7-32.5L375.4 48.8C369.8 38.4 359 32 347.2 32H312zM166.8 320l50.7-101.3 72.9 101.2-.1 .1H166.8zm90.6-128H365.9L317 274.8 257.4 192z"]],
    "hammer-war": [384, 512, [], "f6e4", ["M224 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V50.8l27.3 4.1c3.1 .5 6.3 .5 9.5 0L224 50.8V32zm0 237.2l-27.3-4.1c-3.1-.5-6.3-.5-9.5 0L160 269.2V480c0 17.7 14.3 32 32 32s32-14.3 32-32V269.2z", "M36.7 32.4c-9.2-1.4-18.6 1.3-25.6 7.4S0 54.7 0 64V256c0 9.3 4.1 18.2 11.1 24.2s16.4 8.8 25.6 7.4l150.5-22.6c3.1-.5 6.3-.5 9.5 0l150.5 22.6c9.2 1.4 18.6-1.3 25.6-7.4s11.1-14.9 11.1-24.2V64c0-9.3-4.1-18.2-11.1-24.2s-16.4-8.8-25.6-7.4L196.7 54.9c-3.1 .5-6.3 .5-9.5 0L36.7 32.4z"]],
    "circle-d": [512, 512, [], "e104", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128h72c70.7 0 128 57.3 128 128s-57.3 128-128 128H184c-13.3 0-24-10.7-24-24V152c0-13.3 10.7-24 24-24zm72 208c44.2 0 80-35.8 80-80s-35.8-80-80-80H208V336h48z", "M160 152c0-13.3 10.7-24 24-24h72c70.7 0 128 57.3 128 128s-57.3 128-128 128H184c-13.3 0-24-10.7-24-24V152zm48 24V336h48c44.2 0 80-35.8 80-80s-35.8-80-80-80H208z"]],
    "spider-black-widow": [512, 512, [], "f718", ["M158.4 32.6l-32.5 84.6c-1.1 3-.4 6.3 1.8 8.5L176 174.1v51.3l-24.9-8.3L93.7 159.7C78.1 144 73.1 120.6 81.1 100l32.5-84.6c4.8-12.4 18.6-18.5 31-13.8s18.5 18.6 13.8 31zM418.3 159.7l-57.4 57.4L336 225.4V174.1l48.3-48.3c2.2-2.2 2.9-5.6 1.8-8.5L353.6 32.6c-4.8-12.4 1.4-26.3 13.8-31s26.3 1.4 31 13.8L430.9 100c7.9 20.7 3 44.1-12.7 59.7zM218.4 307.2c-1.6-2.1-2.4-4.6-2.4-7.2c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12c0 2.6-.8 5.1-2.4 7.2L272 336l21.6 28.8c1.6 2.1 2.4 4.6 2.4 7.2c0 6.6-5.4 12-12 12H228c-6.6 0-12-5.4-12-12c0-2.6 .8-5.1 2.4-7.2L240 336l-21.6-28.8z", "M240 101.2c0-10.1-9.4-17.7-18.5-13.4C194.6 100.7 176 128.2 176 160v65.4L70.8 190.3c-2.4-.8-4.3-2.7-5.1-5.1L46.8 128.4C42.6 115.8 29 109 16.4 113.2S-3 131 1.2 143.6l18.9 56.8c5.6 16.7 18.7 29.8 35.4 35.4L116.1 256 55.6 276.2c-16.7 5.6-29.8 18.7-35.4 35.4L1.2 368.4C-3 381 3.8 394.6 16.4 398.8s26.2-2.6 30.4-15.2l18.9-56.8c.8-2.4 2.7-4.3 5.1-5.1l80.4-26.8L93.7 352.3C78.1 368 73.1 391.4 81.1 412l32.5 84.6c4.8 12.4 18.6 18.5 31 13.8s18.5-18.6 13.8-31l-32.5-84.6c-1.1-3-.4-6.3 1.8-8.5L160 353.9c1 52.1 43.6 94.1 96 94.1s95-41.9 96-94.1l32.3 32.3c2.2 2.2 2.9 5.6 1.8 8.5l-32.5 84.6c-4.8 12.4 1.4 26.3 13.8 31s26.3-1.4 31-13.8L430.9 412c7.9-20.7 3-44.1-12.7-59.7l-57.4-57.4 80.4 26.8c2.4 .8 4.3 2.7 5.1 5.1l18.9 56.8c4.2 12.6 17.8 19.4 30.4 15.2s19.4-17.8 15.2-30.4l-18.9-56.8c-5.6-16.7-18.7-29.8-35.4-35.4L395.9 256l60.5-20.2c16.7-5.6 29.8-18.7 35.4-35.4l18.9-56.8c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-18.9 56.8c-.8 2.4-2.7 4.3-5.1 5.1L336 225.4V160c0-31.8-18.6-59.3-45.5-72.2c-9.1-4.4-18.5 3.3-18.5 13.4V112c0 8.8-7.2 16-16 16s-16-7.2-16-16V101.2zm-21.6 206c-1.6-2.1-2.4-4.6-2.4-7.2c0-6.6 5.4-12 12-12h56c6.6 0 12 5.4 12 12c0 2.6-.8 5.1-2.4 7.2L272 336l21.6 28.8c1.6 2.1 2.4 4.6 2.4 7.2c0 6.6-5.4 12-12 12H228c-6.6 0-12-5.4-12-12c0-2.6 .8-5.1 2.4-7.2L240 336l-21.6-28.8z"]],
    "staff-snake": [384, 512, ["rod-asclepius", "rod-snake", "staff-aesculapius"], "e579", ["M222.5 48h-61H72 64 56C25.1 48 0 73.1 0 104s25.1 56 56 56H72c22.3 0 41.6-13.1 50.6-32H164h56 68c8.8 0 16 7.2 16 16s-7.2 16-16 16H219l-2.5 80H288c53 0 96-43 96-96s-43-96-96-96H222.5zm-55 192L165 160H152c-53 0-96 43-96 96s43 96 96 96h19 42 43c8.8 0 16 7.2 16 16s-7.2 16-16 16H212l-2.1 67.5-.4 12.5H256c53 0 96-43 96-96s-43-96-96-96H215.5h-47H152c-8.8 0-16-7.2-16-16s7.2-16 16-16h15.5zm6.6 211.5L172 384H136c-22.1 0-40 17.9-40 40s17.9 40 40 40h38.5l-.4-12.5zM64 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z", "M222.6 43.2L223 32c0-.7 0-1.3 0-1.9c-.5-16.6-14.1-30-31-30s-30.5 13.4-31 30c0 .6 0 1.3 0 1.9l.4 11.2 .1 4.8h61l.1-4.8zM215.5 272L220 128H164l4.5 144h47zM213 352H171l3.1 99.5 1.4 43.5 0 1c.3 8.9 7.6 16 16.5 16s16.2-7.1 16.5-16l0-1 1.4-43.5L213 352z"]],
    "pear": [512, 512, [], "e20c", ["M423.9 54.1C403.4 40.2 378.7 32 352 32c-30.7 0-58.9 10.8-81 28.9c-36.5 29.9-81.8 61.4-127.4 73.3c-32 8.3-62.3 25-87.3 50.1c-75 75-75 196.5 0 271.5s196.5 75 271.5 0c25.1-25.1 41.8-55.3 50.1-87.3c11.8-45.7 43.4-90.9 73.3-127.4c18-22.1 28.9-50.3 28.9-81c0-26.7-8.2-51.4-22.1-71.9L425 121c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l32.9-32.9zM304 304c8.8 0 16 7.2 16 16c0 70.7-57.3 128-128 128c-8.8 0-16-7.2-16-16s7.2-16 16-16c53 0 96-43 96-96c0-8.8 7.2-16 16-16z", "M505 7c9.4 9.4 9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L471 7c9.4-9.4 24.6-9.4 33.9 0z"]],
    "head-side-cough-slash": [640, 512, [], "e062", ["M0 224.2c0-38.7 9.8-75.1 27.1-106.9L341.8 365.3l-2.5 .3c-11 1.4-19.2 10.7-19.2 21.8c0 11.6 9 21.2 20.6 21.9l62 3.9 43 33.9C439.3 466.2 421.2 480 400 480H320v8c0 13.3-10.7 24-24 24H256v0H96c-17.7 0-32-14.3-32-32V407.3c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2zM89.6 44.9C127 16.7 173.5 0 224 0h24c95.2 0 181.2 69.3 197.3 160.2c2.3 13 6.8 25.7 15.1 36l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8H448v0 5.8L89.6 44.9zM616 360a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-88-24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88-72a24 24 0 1 1 0 48 24 24 0 1 1 0-48z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "triangle": [512, 512, [9650], "f2ec", ["M290.5 51.8C283.3 39.5 270.2 32 256 32s-27.3 7.5-34.5 19.8l-216 368c-7.3 12.4-7.3 27.7-.2 40.1S25.7 480 40 480H472c14.3 0 27.6-7.7 34.7-20.1s7-27.8-.2-40.1l-216-368z", ""]],
    "apartment": [576, 512, [], "e468", ["M176 0c-26.5 0-48 21.5-48 48V96H48C21.5 96 0 117.5 0 144V464c0 26.5 21.5 48 48 48h80 32 96V416c0-17.7 14.3-32 32-32s32 14.3 32 32v96h96 32 80c26.5 0 48-21.5 48-48V240c0-26.5-21.5-48-48-48H448V48c0-26.5-21.5-48-48-48H176zM368 320H336c-8.8 0-16-7.2-16-16V272c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16zm144 80c0 8.8-7.2 16-16 16H464c-8.8 0-16-7.2-16-16V368c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32zM112 320H80c-8.8 0-16-7.2-16-16V272c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16zm16 80c0 8.8-7.2 16-16 16H80c-8.8 0-16-7.2-16-16V368c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32zm112-80H208c-8.8 0-16-7.2-16-16V272c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16zM384 80v32c0 8.8-7.2 16-16 16H336c-8.8 0-16-7.2-16-16V80c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16zM240 64c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16V80c0-8.8 7.2-16 16-16h32zM384 208c0 8.8-7.2 16-16 16H336c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32zM496 320H464c-8.8 0-16-7.2-16-16V272c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16zM128 208c0 8.8-7.2 16-16 16H80c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32zm112 16H208c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16z", "M384 80c0-8.8-7.2-16-16-16H336c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V80zM112 320c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32zm272-16V272c0-8.8-7.2-16-16-16H336c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16zm128 96V368c0-8.8-7.2-16-16-16H464c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16zm-384 0V368c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16zm112-80c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32zm0-256H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V80c0-8.8-7.2-16-16-16zM384 208V176c0-8.8-7.2-16-16-16H336c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16zM496 320c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H464c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32zM128 208V176c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16zm112 16c8.8 0 16-7.2 16-16V176c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32z"]],
    "truck-medical": [640, 512, [128657, "ambulance"], "f0f9", ["M176 80c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48l48 0c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H240v48c0 8.8-7.2 16-16 16H192c-8.8 0-16-7.2-16-16V192H128c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16l48 0V80zM96 432a80 80 0 1 1 160 0A80 80 0 1 1 96 432zm288 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z", "M0 48C0 21.5 21.5 0 48 0H368c26.5 0 48 21.5 48 48V96h50.7c17 0 33.3 6.7 45.3 18.7L589.3 192c12 12 18.7 28.3 18.7 45.3V256v32 64c17.7 0 32 14.3 32 32s-14.3 32-32 32H576h-1.1c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96H286.9c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96H48c-26.5 0-48-21.5-48-48V48zM416 256H544V237.3L466.7 160H416v96zM176 80v48l-48 0c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h48v48c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V192h48c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H240V80c0-8.8-7.2-16-16-16H192c-8.8 0-16 7.2-16 16z"]],
    "pepper": [512, 512, [129745], "e432", ["M216.7 97.4c-.3-.1-.6-.1-.9-.2c-8.8-1.5-17.9-1.7-27.1-.6c-4 .5-7.9 1.2-11.9 2.2c-51.4 12.9-74.7 65-61.9 116.4l37.1 148.3c2.1 8.6-3.1 17.3-11.6 19.4s-17.3-3.1-19.4-11.6L83.8 223c-11.8-47 .4-94.4 31.3-125.2c-13.6-2.8-28-2.6-42.4 1C21.3 111.7-10 163.8 2.9 215.3l56 224c12.9 51.4 65 82.7 116.4 69.8c7-1.7 13.6-4.2 19.8-7.3c5.6-2.8 12.3-2.8 17.9 0c3 1.5 6 2.8 9.2 4c10.7 4 22.2 6.2 34 6.2c11.6 0 22.9-2.1 33.5-6.1c3.2-1.2 6.4-2.6 9.4-4.1c5.6-2.8 12.3-2.8 17.9 0c6.2 3.1 12.8 5.6 19.8 7.3c51.4 12.9 103.6-18.4 116.4-69.8l56-224c12.9-51.4-18.4-103.6-69.8-116.4c-23.2-5.8-46.5-2.6-66.3 7.3c-5.6 2.8-12.3 2.8-17.9 0c-6.2-3.1-12.8-5.6-19.8-7.3c-24.5-6.1-49.1-2.2-69.6 9c-6 3.3-13.4 3.3-19.4 0c-9.2-5-19.2-8.6-29.6-10.5z", "M252.6 11.7C245.8 .3 231-3.4 219.7 3.4s-15.1 21.6-8.2 32.9l10.3 17.2c6.7 11.2 10.3 24 10.3 37v10.9c4.9 1.8 9.7 3.9 14.3 6.4c6 3.3 13.4 3.3 19.4 0c4.6-2.5 9.4-4.7 14.3-6.4V90.6c0-21.7-5.9-43.1-17.1-61.7L252.6 11.7z"]],
    "piano": [512, 512, [], "f8d4", ["M0 448V352H64v96H448V352h64v96c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64z", "M0 192V352H96v48c0 8.8 7.2 16 16 16s16-7.2 16-16V352h32v48c0 8.8 7.2 16 16 16s16-7.2 16-16V352h32v48c0 8.8 7.2 16 16 16s16-7.2 16-16V352h64v48c0 8.8 7.2 16 16 16s16-7.2 16-16V352h32v48c0 8.8 7.2 16 16 16s16-7.2 16-16V352h96V327.6c0-24.2-13.7-46.4-35.4-57.2l-58.4-29.2c-21-10.5-34.2-31.9-34.2-55.4C384 83.2 300.8 0 198.3 0H192C86 0 0 86 0 192z"]],
    "gun-squirt": [576, 512, [], "e19d", ["M96 192c-17.7 0-32-14.3-32-32H480c0 17.7-14.3 32-32 32H96zM272 376H219l12-48h41V312c0-13.3 10.7-24 24-24s24 10.7 24 24v40 40c0 13.3-10.7 24-24 24s-24-10.7-24-24V376z", "M104 32c13.3 0 24 10.7 24 24v8H448c41.8 0 77.4 26.7 90.5 64H552c13.3 0 24 10.7 24 24v16c0 13.3-10.7 24-24 24H538.5c-13.2 37.3-48.7 64-90.5 64H249L199 455.8C195.5 470 182.7 480 168 480H64c-9.9 0-19.2-4.5-25.2-12.3s-8.2-17.9-5.8-27.5L79.4 254.6C34.3 246.7 0 207.3 0 160c0-47.6 34.6-87.1 80-94.7V56c0-13.3 10.7-24 24-24zm-8 96c-17.7 0-32 14.3-32 32s14.3 32 32 32H448c17.7 0 32-14.3 32-32s-14.3-32-32-32H96z"]],
    "wheat-awn-circle-exclamation": [640, 512, [], "e598", ["M505 7c-9.4-9.4-24.6-9.4-33.9 0L383 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l88-88c9.4-9.4 9.4-24.6 0-33.9zM295.3 262l31.9-31.9 12.2 12.2c6 6 12.6 11.1 19.7 15.2c27.5-34 67.3-57.5 112.6-63.8c-4.1-3.8-8.4-7.3-12.9-10.5L505 137c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-59.4 59.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L409 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L329.1 52.9c-3.7-5-7.8-9.8-12.4-14.3L294.2 16 271.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-22.6-22.6-22.6 22.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8L90.5 219.6 67.9 242.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l68.9-68.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l22.6-22.6-22.6-22.6c-21.8-21.8-49.6-34.1-78.1-36.9l31.9-31.9 12.2 12.2c22.5 22.5 53.3 31.5 82.4 27c0-1 0-2.1 0-3.1c0-33.1 9.1-64.1 25-90.6c-15.5-8.7-32.5-13.8-49.8-15.5z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16V288z"]],
    "snowman": [512, 512, [9731, 9924], "f7d0", ["M342.3 152.6c-2.8-3.4-3.3-8.1-1.2-12C348 127.2 352 112.1 352 96c0-53-43-96-96-96s-96 43-96 96c0 16.1 4 31.2 10.9 44.6c2 3.9 1.6 8.6-1.2 12C153.7 172 144 196.9 144 224c0 11.5 1.7 22.5 4.9 32.9c1.2 3.8 .1 8-2.8 10.8C115.3 296.9 96 338.2 96 384c0 44.7 18.3 85 47.8 114.1c9.9 9.7 23.7 13.9 37.5 13.9H330.7c13.9 0 27.7-4.2 37.5-13.9C397.7 469 416 428.7 416 384c0-45.8-19.3-87.1-50.1-116.3c-2.9-2.8-4-6.9-2.8-10.8c3.2-10.4 4.9-21.5 4.9-32.9c0-27.1-9.7-52-25.7-71.4zM208 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 128a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-16 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM272 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-32 43.2V120c0-8.8 7.2-16 16-16s16 7.2 16 16v3.2c0 3.2-.8 6.3-2.3 9l-9 16.9c-.9 1.7-2.7 2.8-4.7 2.8s-3.8-1.1-4.7-2.8l-9-16.9c-1.5-2.8-2.3-5.9-2.3-9z", "M224 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm32 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-16 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM272 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM80 96c13.3 0 24 10.7 24 24v40.2L152.6 181c-5.5 13.2-8.6 27.8-8.6 43c0 1.9 0 3.7 .1 5.6L70.5 198.1l-56-24C2.4 168.8-3.3 154.7 1.9 142.5s19.3-17.8 31.5-12.6L56 139.6V120c0-13.3 10.7-24 24-24zM368 224c0-15.2-3-29.8-8.6-43L408 160.2V120c0-13.3 10.7-24 24-24s24 10.7 24 24v19.6l22.5-9.7c12.2-5.2 26.3 .4 31.5 12.6s-.4 26.3-12.6 31.5l-56 24-73.6 31.5c.1-1.9 .1-3.7 .1-5.6z"]],
    "user-alien": [448, 512, [], "e04a", ["M64 167C64 74.8 135.6 0 224 0s160 74.8 160 167c0 101-106.6 185-139.2 208.3c-6.1 4.3-13.4 6.5-20.8 6.5s-14.7-2.1-20.8-6.5C170.6 352 64 268.1 64 167zm244.6 9c-37.9 0-68.6 30.7-68.6 68.6c0 6.3 5.1 11.4 11.4 11.4h16c37.9 0 68.6-30.7 68.6-68.6c0-6.3-5.1-11.4-11.4-11.4h-16zM208 244.6c0-37.9-30.7-68.6-68.6-68.6h-16c-6.3 0-11.4 5.1-11.4 11.4c0 37.9 30.7 68.6 68.6 68.6h16c6.3 0 11.4-5.1 11.4-11.4zM0 486.4C0 415 55.7 356.6 126.1 352.3c23.8 23.2 46.1 40.2 58.5 49.1c12 8.6 25.9 12.4 39.4 12.4s27.4-3.8 39.4-12.4c12.4-8.8 34.7-25.8 58.5-49.1C392.3 356.6 448 415 448 486.4c0 14.1-11.5 25.6-25.6 25.6H25.6C11.5 512 0 500.5 0 486.4z", "M139.4 176c37.9 0 68.6 30.7 68.6 68.6c0 6.3-5.1 11.4-11.4 11.4h-16c-37.9 0-68.6-30.7-68.6-68.6c0-6.3 5.1-11.4 11.4-11.4h16zm169.1 0h16c6.3 0 11.4 5.1 11.4 11.4c0 37.9-30.7 68.6-68.6 68.6h-16c-6.3 0-11.4-5.1-11.4-11.4c0-37.9 30.7-68.6 68.6-68.6z"]],
    "shield-check": [512, 512, [], "f2f7", ["M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c16.7 8 36.1 8 52.8 0C454.7 420.7 495.5 239.2 496 140c.1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM369 209L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z", "M369 175c9.4 9.4 9.4 24.6 0 33.9L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0z"]],
    "mortar-pestle": [512, 512, [], "f5a7", ["M502.6 54.6c11.8-11.8 12.6-30.8 1.6-43.5S474.5-3.7 461 6.2L213.7 188.5c-1.5 1.1-3 2.3-4.4 3.5H365.3L502.6 54.6z", "M0 224c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32c0 82.5-43.4 147.7-123.9 176.2c11.1 13.9 19.4 30.3 23.9 48.1c4.4 17.1-10.4 31.7-28.1 31.7H160c-17.7 0-32.4-14.6-28.1-31.7c4.5-17.8 12.8-34.1 23.9-48.1C75.4 403.7 32 338.5 32 256c-17.7 0-32-14.3-32-32z"]],
    "road-barrier": [640, 512, [], "e562", ["M405.2 96H330.8l-5.4 10.7L234.8 288h74.3l5.4-10.7L405.2 96zM362.8 288h74.3l5.4-10.7L533.2 96H458.8l-5.4 10.7L362.8 288zM202.8 96l-5.4 10.7L106.8 288h74.3l5.4-10.7L277.2 96H202.8zm288 192H576V117.7L490.8 288zM64 96V266.3L149.2 96H64z", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64V448c0 17.7 14.3 32 32 32s32-14.3 32-32V64zm576 0c0-17.7-14.3-32-32-32s-32 14.3-32 32V448c0 17.7 14.3 32 32 32s32-14.3 32-32V64z"]],
    "chart-candlestick": [512, 512, [], "e0e2", ["M32 32c17.7 0 32 14.3 32 32V400c0 8.8 7.2 16 16 16H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-44.2 0-80-35.8-80-80V64C0 46.3 14.3 32 32 32z", "M304 32c8.8 0 16 7.2 16 16V96c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32v48c0 8.8-7.2 16-16 16s-16-7.2-16-16V256c-17.7 0-32-14.3-32-32V128c0-17.7 14.3-32 32-32V48c0-8.8 7.2-16 16-16zM416 192V144c0-8.8 7.2-16 16-16s16 7.2 16 16v48c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32v48c0 8.8-7.2 16-16 16s-16-7.2-16-16V320c-17.7 0-32-14.3-32-32V224c0-17.7 14.3-32 32-32zM128 160c0-17.7 14.3-32 32-32V80c0-8.8 7.2-16 16-16s16 7.2 16 16v48c17.7 0 32 14.3 32 32V288c0 17.7-14.3 32-32 32v48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48c-17.7 0-32-14.3-32-32V160z"]],
    "briefcase-blank": [512, 512, [], "e0c8", ["M184 48c-4.4 0-8 3.6-8 8V96H128V56c0-30.9 25.1-56 56-56H328c30.9 0 56 25.1 56 56V96H336V56c0-4.4-3.6-8-8-8H184z", "M64 96C28.7 96 0 124.7 0 160V416c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H64z"]],
    "school": [640, 512, [127979], "f549", ["M337.8 5.4C327-1.8 313-1.8 302.2 5.4L166.3 96H48C21.5 96 0 117.5 0 144V464c0 26.5 21.5 48 48 48H592c26.5 0 48-21.5 48-48V144c0-26.5-21.5-48-48-48H473.7L337.8 5.4zM256 416c0-35.3 28.7-64 64-64s64 28.7 64 64v96H256V416zM96 192h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V208c0-8.8 7.2-16 16-16zm400 16c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H512c-8.8 0-16-7.2-16-16V208zM96 320h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V336c0-8.8 7.2-16 16-16zm400 16c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H512c-8.8 0-16-7.2-16-16V336zM320 88a88 88 0 1 1 0 176 88 88 0 1 1 0-176z", "M336 144v16h16c8.8 0 16 7.2 16 16s-7.2 16-16 16H320c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16s16 7.2 16 16zM80 208c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V208zm416 0c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H512c-8.8 0-16-7.2-16-16V208zM96 320h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V336c0-8.8 7.2-16 16-16zm400 16c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H512c-8.8 0-16-7.2-16-16V336z"]],
    "igloo": [576, 512, [], "f7ae", ["M288 32c10.8 0 21.5 .6 32 1.8V160H48.5C100.2 82.8 188.1 32 288 32zM527.5 160H352V39.1C424.9 55.7 487.2 99.8 527.5 160zM0 320c0-46 10.8-89.4 29.9-128H96V320L0 320zm197.5 0L128 320V192H448V320l-69.5 0c-13.2-37.3-48.7-64-90.5-64s-77.4 26.7-90.5 64zM384 352l192 0v80c0 26.5-21.5 48-48 48H384V352zM192 480H48c-26.5 0-48-21.5-48-48V352l192 0V480zM576 320l-96 0V192h66.1c19.2 38.6 29.9 82 29.9 128z", "M320 33.8c10.9 1.2 21.5 3 32 5.4V160H527.5c6.8 10.2 13 20.9 18.6 32H480V320h96v32l-192 0V480H352V352c0-35.3-28.7-64-64-64s-64 28.7-64 64V480H192V352L0 352V320H96V192H29.9c5.5-11.1 11.7-21.8 18.6-32H320V33.8zM197.5 320c13.2-37.3 48.7-64 90.5-64s77.4 26.7 90.5 64H448V192H128V320h69.5z"]],
    "bracket-round": [192, 512, ["parenthesis"], "28", ["M154.6 46.2c9.8 14.7 5.8 34.6-8.9 44.4C120.1 107.7 64 167 64 256s56.1 148.3 81.8 165.4c14.7 9.8 18.7 29.7 8.9 44.4s-29.7 18.7-44.4 8.9C71.9 449 0 371.8 0 256S71.9 62.9 110.2 37.4c14.7-9.8 34.6-5.8 44.4 8.9z", ""]],
    "joint": [640, 512, [], "f595", ["M448 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V43c0 55.2 21.9 108.1 60.9 147.1l21 21c9 9 14.1 21.2 14.1 33.9v11c0 17.7 14.3 32 32 32s32-14.3 32-32V245c0-29.7-11.8-58.2-32.8-79.2l-21-21C463.2 117.8 448 81.2 448 43V32zM576 256c0 17.7 14.3 32 32 32s32-14.3 32-32V245c0-55.2-21.9-108.1-60.9-147.1l-21-21c-9-9-14.1-21.2-14.1-33.9V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V43c0 29.7 11.8 58.2 32.8 79.2l21 21c27 27 42.2 63.6 42.2 101.8v11z", "M214.7 358c5.2-.8 10.5-.3 15.2 2c10.2 4.9 19.3 12 26.7 20.8L358.9 503.7c2.6 3.2 .5 8.3-3.6 8.3H288c-59.2 0-127.7-14.7-180.2-28.8C81.3 476 58.3 468.9 42 463.6c-8.2-2.7-14.7-4.9-19.2-6.5c-2.3-.8-4-1.4-5.2-1.8l-1.3-.5C6.8 451.5 0 442.6 0 432s6.8-19.5 16.3-22.7l1.3-.5c1.2-.4 3-1.1 5.2-1.8c4.5-1.6 11-3.8 19.2-6.5c16.3-5.4 39.2-12.5 65.7-19.6c31.7-8.5 69.2-17.3 106.9-22.8zM464 512H445c-23.7 0-46.3-10.5-61.5-28.8L281.1 360.3c-2.6-3.2-.6-8.2 3.5-8.3c1.1 0 2.3 0 3.4 0h48 19c23.7 0 46.3 10.5 61.5 28.8L518.9 503.7c2.6 3.2 .5 8.3-3.6 8.3H464zM444.7 352H600c22.1 0 40 17.9 40 40v80c0 21.4-16.8 38.9-37.9 39.9c-22.7-.8-44-11.2-58.6-28.7L441.1 360.3c-2.6-3.2-.5-8.3 3.6-8.3z"]],
    "horse-saddle": [576, 512, [], "f8c3", ["M160 128H320v48c0 38.7-27.5 71-64 78.4V328c0 8.8-7.2 16-16 16s-16-7.2-16-16V254.4c-36.5-7.4-64-39.7-64-78.4V128zM64 212.8c0 3.6 .2 7.1 .7 10.7C54.6 230.8 48 242.6 48 256v56c0 13.3-10.7 24-24 24s-24-10.7-24-24V256c0-44.6 33.2-81.5 76.3-87.2C68.5 181.6 64 196.7 64 212.8z", "M448 238.1V160h16l9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1V80c0-19.1-8.4-36.3-21.7-48H560c8.8 0 16-7.2 16-16s-7.2-16-16-16H480 448C377.3 0 320 57.3 320 128v48c0 38.7-27.5 71-64 78.4v74.7l51.7 14.8c4.1 1.2 8.2 2.1 12.3 2.8V480c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V315.7c19.2-19.2 31.5-45.7 32-75.7h0v-1.9zM224 254.4c-36.5-7.4-64-39.7-64-78.4V128H148.8C102 128 64 166 64 212.8c0 16.8 5 33.1 14.2 47.1l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9h33.7c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l.3 .1V254.4zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "mug-marshmallows": [512, 512, [], "f7b7", ["M197.7 125.7L200 128H344l2.3-2.3c3.6-3.6 5.7-8.5 5.7-13.7s-2-10-5.7-13.7L285.7 37.7C282 34 277.1 32 272 32s-10 2-13.7 5.7L197.7 98.3C194 102 192 106.9 192 112s2 10 5.7 13.7zM32 64v64H162.6c-1.7-5.1-2.6-10.5-2.6-16c0-13.6 5.4-26.7 15-36.3l36.8-36.8C206.4 34.6 199.5 32 192 32H64C46.3 32 32 46.3 32 64zm128 96H96v64c0 17.7 14.3 32 32 32s32-14.3 32-32V160z", "M96 160H32c-17.7 0-32 14.3-32 32V384c0 53 43 96 96 96H288c53 0 96-43 96-96h16c61.9 0 112-50.1 112-112s-50.1-112-112-112H352 160v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V160zM384 320V224h16c26.5 0 48 21.5 48 48s-21.5 48-48 48H384z"]],
    "filters": [640, 512, [], "e17e", ["M40 96H164.1c3.2 9 8.2 17.4 14.9 24.7L320 274v16.7l-32 34.8V448c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48c-8.1-6-12.8-15.5-12.8-25.6V325.5L10.6 163.1C-.2 151.4-3 134.5 3.4 119.9S24.1 96 40 96z", "M195.4 55.9C201.7 41.4 216.1 32 232 32H600c15.9 0 30.2 9.4 36.6 23.9s3.6 31.5-7.2 43.2L480 261.5V416c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48c-8.1-6-12.8-15.5-12.8-25.6V261.5L202.6 99.1c-10.7-11.7-13.6-28.6-7.2-43.2z"]],
    "bell-on": [640, 512, [128365], "f8fa", ["M320 0c-17.7 0-32 14.3-32 32V51.2C215 66 160 130.6 160 208v18.8c0 47-17.3 92.4-48.5 127.6l-7.4 8.3c-8.4 9.4-10.4 22.9-5.3 34.4S115.4 416 128 416H512c12.6 0 24-7.4 29.2-18.9s3.1-25-5.3-34.4l-7.4-8.3C497.3 319.2 480 273.9 480 226.8V208c0-77.4-55-142-128-156.8V32c0-17.7-14.3-32-32-32z", "M586.7 53.5c11.9-5.9 16.7-20.3 10.7-32.2s-20.3-16.7-32.2-10.7l-64 32c-11.9 5.9-16.7 20.3-10.7 32.2s20.3 16.7 32.2 10.7l64-32zM0 200c0 13.3 10.7 24 24 24h80c13.3 0 24-10.7 24-24s-10.7-24-24-24H24c-13.3 0-24 10.7-24 24zm512 0c0 13.3 10.7 24 24 24h80c13.3 0 24-10.7 24-24s-10.7-24-24-24H536c-13.3 0-24 10.7-24 24zM42.5 21.3c-5.9 11.9-1.1 26.3 10.7 32.2l64 32c11.9 5.9 26.3 1.1 32.2-10.7s1.1-26.3-10.7-32.2l-64-32C62.9 4.6 48.5 9.4 42.5 21.3zm322.7 472c12-12 18.7-28.3 18.7-45.3H320 256c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7z"]],
    "angle-right": [320, 512, [8250], "f105", ["M278.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L210.7 256 73.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z", ""]],
    "dial-med": [576, 512, [], "e15f", ["M256 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M264 129c-77 11.6-136 78-136 158.2c0 88.4 71.6 160 160 160s160-71.6 160-160C448 207 389 140.6 312 129l0 158.2c0 13.3-10.7 24-24 24s-24-10.7-24-24L264 129z"]],
    "horse": [576, 512, [128014], "f6f0", ["M76.3 168.8C68.5 181.6 64 196.7 64 212.8c0 3.6 .2 7.1 .7 10.7C54.6 230.8 48 242.6 48 256v56c0 13.3-10.7 24-24 24s-24-10.7-24-24V256c0-44.6 33.2-81.5 76.3-87.2z", "M448 238.1V160h16l9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1V80c0-19.1-8.4-36.3-21.7-48H560c8.8 0 16-7.2 16-16s-7.2-16-16-16H480 448C377.3 0 320 57.3 320 128H224 203.2 148.8C102 128 64 166 64 212.8c0 16.8 5 33.1 14.2 47.1l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9h33.7c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l84 24c4.1 1.2 8.2 2.1 12.3 2.8V480c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V315.7c19.2-19.2 31.5-45.7 32-75.7h0v-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "q": [448, 512, [113], "51", ["M64 256c0 88.4 71.6 160 160 160c28.9 0 56-7.7 79.4-21.1l-72-86.4c-11.3-13.6-9.5-33.8 4.1-45.1s33.8-9.5 45.1 4.1l70.9 85.1C371.9 325.8 384 292.3 384 256c0-88.4-71.6-160-160-160S64 167.6 64 256zM344.9 444.6C310 467 268.5 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32s224 100.3 224 224c0 56.1-20.6 107.4-54.7 146.7l47.3 56.8c11.3 13.6 9.5 33.8-4.1 45.1s-33.8 9.5-45.1-4.1l-46.6-55.9z", ""]],
    "monitor-waveform": [576, 512, ["monitor-heart-rate"], "f611", ["M512 96H64V256H192c6.1 0 11.6 3.4 14.3 8.8L224 300.2l49.7-99.4c2.7-5.4 8.3-8.8 14.3-8.8s11.6 3.4 14.3 8.8L329.9 256H400c8.8 0 16 7.2 16 16s-7.2 16-16 16H320c-6.1 0-11.6-3.4-14.3-8.8L288 243.8l-49.7 99.4c-2.7 5.4-8.3 8.8-14.3 8.8s-11.6-3.4-14.3-8.8L182.1 288H64V416H512V96z", "M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM512 96V416H64V96H512z"]],
    "link-simple": [576, 512, [], "e1cd", ["M160 256c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-17.7 0-32-14.3-32-32z", "M160 96C71.6 96 0 167.6 0 256s71.6 160 160 160h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H160c-53 0-96-43-96-96s43-96 96-96h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H160zm256 0H352c-17.7 0-32 14.3-32 32s14.3 32 32 32h64c53 0 96 43 96 96s-43 96-96 96H352c-17.7 0-32 14.3-32 32s14.3 32 32 32h64c88.4 0 160-71.6 160-160s-71.6-160-160-160z"]],
    "whistle": [640, 512, [], "f460", ["M288 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm92.7 111c-34.8 49-92 81-156.7 81C118 448 32 362 32 256S118 64 224 64c51 0 97.4 19.9 131.8 52.4c1.1 .5 2.2 1.2 3.2 2l62.4 48.3c5.1 4 7.3 10.6 5.6 16.9l-5.7 21.1c-3.2 11.7 1.1 24.2 10.8 31.5c9.6 7.2 22.7 7.9 33 1.7l17.7-10.6c5.7-3.4 12.8-3 18 1.1l128.6 99.6C636.1 333 640 341 640 349.4c0 6.8-2.5 13.4-7.1 18.4l-63.4 69.7c-6.1 6.7-14.7 10.5-23.7 10.5h-2c-5.2 0-10.2-1.2-14.8-3.6L380.7 367z", "M0 128c0 28.4 18.5 52.5 44.1 60.8c6.1-16.3 14.4-31.6 24.4-45.5c-1.4 .4-2.9 .6-4.5 .6c-8.8 0-16-7.2-16-16s7.2-16 16-16s16 7.2 16 16c0 .3 0 .7 0 1c11.4-12.9 24.5-24.3 39-33.8C107.8 76.5 87.4 64 64 64C28.7 64 0 92.7 0 128zM224 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "g": [448, 512, [103], "47", ["M224 96C135.6 96 64 167.6 64 256s71.6 160 160 160c77.4 0 142-55 156.8-128H256c-17.7 0-32-14.3-32-32s14.3-32 32-32H400c25.8 0 49.6 21.4 47.2 50.6C437.8 389.6 341.4 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32c57.4 0 109.7 21.6 149.3 57c13.2 11.8 14.3 32 2.5 45.2s-32 14.3-45.2 2.5C302.3 111.4 265 96 224 96z", ""]],
    "wine-glass-crack": [320, 512, ["fragile"], "f4bb", ["M64 0C47.4 0 33.5 12.8 32.1 29.3l-14 168.4c-6 72 42.5 135.2 109.9 150.6V448H80c-17.7 0-32 14.3-32 32s14.3 32 32 32h80 80c17.7 0 32-14.3 32-32s-14.3-32-32-32H192V348.4c67.4-15.4 115.9-78.6 109.9-150.6l-14-168.4C286.5 12.8 272.6 0 256 0H208l25.8 51.7c3.5 7.1 1.4 15.7-5.1 20.3l-58.4 40.9c-6 4.2-8.4 12-5.8 18.9l31.1 81c2.1 5.5-1.9 11.4-7.8 11.4c-2.4 0-4.7-1.1-6.3-2.9L92.1 118c-6.4-7.4-4.7-18.7 3.5-24l58.6-37.3c7.6-4.8 9.7-14.9 4.7-22.4L136 0H64z", "M154.2 56.8L95.7 94c-8.2 5.2-9.9 16.6-3.5 24l89.3 103.1c1.6 1.8 3.9 2.9 6.3 2.9c5.9 0 9.9-5.9 7.8-11.4l-31.1-81c-2.6-6.9-.3-14.6 5.8-18.9l58.4-40.9c6.5-4.5 8.7-13.2 5.1-20.3L208 0H136l22.9 34.4c5 7.5 2.8 17.6-4.7 22.4z"]],
    "slot-machine": [640, 512, [], "e3ce", ["M64 96C28.7 96 0 124.7 0 160V352c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H64zm16 80h59.9c23 0 38.5 23.5 29.4 44.6L126.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L115.6 224H80c-13.3 0-24-10.7-24-24s10.7-24 24-24zm120 24c0-13.3 10.7-24 24-24h59.9c23 0 38.5 23.5 29.4 44.6L270.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L259.6 224H224c-13.3 0-24-10.7-24-24zm168-24h59.9c23 0 38.5 23.5 29.4 44.6L414.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L403.6 224H368c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M128 0H384c35.3 0 64 28.7 64 64H64C64 28.7 92.7 0 128 0zM640 176c0 14.2-6.2 27-16 35.8V416c0 53-43 96-96 96H448 416 128c-35.3 0-64-28.7-64-64V416H448v32h80c17.7 0 32-14.3 32-32V211.8c-9.8-8.8-16-21.6-16-35.8c0-26.5 21.5-48 48-48s48 21.5 48 48z"]],
    "notes-medical": [512, 512, [], "f481", ["M96 96V352c0 35.3 28.7 64 64 64H357.5c17 0 33.3-6.7 45.3-18.7l58.5-58.5c12-12 18.7-28.3 18.7-45.3V96c0-35.3-28.7-64-64-64H160c-35.3 0-64 28.7-64 64zm160 48c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48h48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H320v48c0 8.8-7.2 16-16 16H272c-8.8 0-16-7.2-16-16V256H208c-8.8 0-16-7.2-16-16V208c0-8.8 7.2-16 16-16h48V144z", "M296 464c13.3 0 24 10.7 24 24s-10.7 24-24 24H136C60.9 512 0 451.1 0 376V152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 224c0 48.6 39.4 88 88 88H296zM256 144c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48l48 0c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H320v48c0 8.8-7.2 16-16 16H272c-8.8 0-16-7.2-16-16V256H208c-8.8 0-16-7.2-16-16V208c0-8.8 7.2-16 16-16l48 0V144z"]],
    "car-wash": [448, 512, [], "f5e6", ["M112 80c0 32-21.5 48-48 48s-48-21.5-48-48C16 48 64 0 64 0s48 48 48 80zm160 0c0 32-21.5 48-48 48s-48-21.5-48-48c0-32 48-80 48-80s48 48 48 80zm112 48c-26.5 0-48-21.5-48-48c0-32 48-80 48-80s48 48 48 80s-21.5 48-48 48z", "M138.8 234.6L119.7 288H328.3l-19.1-53.4c-2.3-6.4-8.3-10.6-15.1-10.6H153.8c-6.8 0-12.8 4.3-15.1 10.6zM50.2 292.4l28.3-79.3C89.9 181.3 120 160 153.8 160H294.2c33.8 0 64 21.3 75.3 53.1l28.3 79.3c20.1 8.5 34.2 28.4 34.2 51.6v40 64 32c0 17.7-14.3 32-32 32H384c-17.7 0-32-14.3-32-32V448H96v32c0 17.7-14.3 32-32 32H48c-17.7 0-32-14.3-32-32V448 384 344c0-23.2 14.1-43.1 34.2-51.6zM120 368a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm232 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "escalator": [640, 512, [], "e171", ["M405.9 175.8C417.5 165.6 432.5 160 448 160h96c35.3 0 64 28.7 64 64s-28.7 64-64 64H472L234.1 496.2C222.5 506.4 207.5 512 192 512H96c-35.3 0-64-28.7-64-64s28.7-64 64-64h72L405.9 175.8z", "M256 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm64 192v16.4l-128 112V192c0-35.3 28.7-64 64-64s64 28.7 64 64z"]],
    "comment-image": [512, 512, [], "e148", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM128 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm168-16c7.6 0 14.7 3.6 19.2 9.6l96 128c5.5 7.3 6.3 17 2.3 25.1s-12.4 13.3-21.5 13.3H200 120c-9.3 0-17.8-5.4-21.7-13.8s-2.7-18.4 3.3-25.5l40-48c4.6-5.5 11.3-8.6 18.4-8.6s13.9 3.2 18.4 8.6L199 257.3l77.8-103.7c4.5-6 11.6-9.6 19.2-9.6z", "M296 144c7.6 0 14.7 3.6 19.2 9.6l96 128c5.5 7.3 6.3 17 2.3 25.1s-12.4 13.3-21.5 13.3H200 120c-9.3 0-17.8-5.4-21.7-13.8s-2.7-18.4 3.3-25.5l40-48c4.6-5.5 11.3-8.6 18.4-8.6s13.9 3.2 18.4 8.6L199 257.3l77.8-103.7c4.5-6 11.6-9.6 19.2-9.6z"]],
    "temperature-half": [320, 512, [127777, "temperature-2", "thermometer-2", "thermometer-half"], "f2c9", ["M160 64c-26.5 0-48 21.5-48 48V276.5c0 17.3-7.1 31.9-15.3 42.5C86.2 332.6 80 349.5 80 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-18.5-6.2-35.4-16.7-48.9c-8.2-10.6-15.3-25.2-15.3-42.5V112c0-26.5-21.5-48-48-48zM48 112C48 50.2 98.1 0 160 0s112 50.1 112 112V276.5c0 .1 .1 .3 .2 .6c.2 .6 .8 1.6 1.7 2.8c18.9 24.4 30.1 55 30.1 88.1c0 79.5-64.5 144-144 144S16 447.5 16 368c0-33.2 11.2-63.8 30.1-88.1c.9-1.2 1.5-2.2 1.7-2.8c.1-.3 .2-.5 .2-.6V112z", "M176 208c0-8.8-7.2-16-16-16s-16 7.2-16 16V322.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V208z"]],
    "dong-sign": [384, 512, [], "e169", ["M256 64v64H224c-17.7 0-32-14.3-32-32s14.3-32 32-32h32zm64 64V64c17.7 0 32 14.3 32 32s-14.3 32-32 32zM0 480c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z", "M288 32c-17.7 0-32 14.3-32 32V177.1c-18.8-10.9-40.7-17.1-64-17.1c-70.7 0-128 57.3-128 128s57.3 128 128 128c24.5 0 47.4-6.9 66.8-18.8c5 11.1 16.2 18.8 29.2 18.8c17.7 0 32-14.3 32-32V288 64c0-17.7-14.3-32-32-32zM128 288a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]],
    "donut": [512, 512, [127849, "doughnut"], "e406", ["M171.3 123.3l-32 32c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l32-32c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm224 9.4l32 32c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-32-32c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-64 150.6l-32 32c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l32-32c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM197.7 372.4c18.4 7.8 38.3 11.7 58.3 11.6c20 .2 39.9-3.7 58.3-11.6c14.4-6 29.8-9 45.4-8.8c18.8 1.6 37.8-1.8 54.9-9.7s32-20.2 43-35.5c5.8-9 14.4-15.9 24.4-19.6c11.6-3.8 22-10.6 29.9-19.9V304c0 88.4-114.6 160-256 160S0 392.4 0 304V278.8c7.9 9.2 18.3 16.1 29.9 19.8c10 3.8 18.5 10.6 24.4 19.6c11 15.4 25.8 27.7 43 35.6s36.1 11.3 55 9.8c15.6-.2 31 2.9 45.4 8.8z", "M0 208C0 119.6 114.6 48 256 48s256 71.6 256 160v70.9c-7.9 9.2-18.3 16.1-29.9 19.9c-10 3.7-18.6 10.6-24.4 19.6c-11 15.4-25.8 27.6-43 35.5s-36.1 11.3-54.9 9.7c-15.6-.2-31 2.9-45.4 8.8C295.9 380.3 276 384.2 256 384c-20 .2-39.9-3.7-58.3-11.6c-14.4-6-29.8-9-45.4-8.8c-18.9 1.5-37.8-1.8-55-9.8s-32-20.2-43-35.6c-5.8-9-14.4-15.8-24.4-19.6C18.3 294.9 7.9 288 0 278.8V208zm320-16c0-17.7-28.7-32-64-32s-64 14.3-64 32s28.7 32 64 32s64-14.3 64-32zM283.3 84.7c-6.2-6.2-16.4-6.2-22.6 0l-16 16c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16-16c6.2-6.2 6.2-16.4 0-22.6zm-112 38.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-32 32c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32zm224 9.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zM64 192c-8.8 0-16 7.2-16 16s7.2 16 16 16H96c8.8 0 16-7.2 16-16s-7.2-16-16-16H64zm331.3 36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm-240 16c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm176 38.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-32 32c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32z"]],
    "capsules": [576, 512, [], "f46b", ["M224 256H192 160l-96 0H32 0V192 144C0 82.1 50.1 32 112 32s112 50.1 112 112l0 48v64zm85.1 83.7L256 262.2V98.3c4.6-4.7 9.7-9.1 15.3-13.1c50.7-36.2 120.5-23.6 156 28.1l66.6 97.1L309.1 339.7z", "M372.3 431.7l-63.1-92L361.6 303l0 0 79.9-55.9 0 0 52.4-36.7 61.9 90.2c35.5 51.7 23.2 123-27.5 159.2s-120.5 23.6-156-28.1zm116.4-22.4c.8-.5 1.6-1 2.4-1.6c.5-.4 1.1-.8 1.6-1.2l-4 2.8zM0 256H32 64h96 32 32v64 48c0 61.9-50.1 112-112 112S0 429.9 0 368V320 256z"]],
    "poo-storm": [448, 512, ["poo-bolt"], "f75a", ["M286.3 247.2c3.4-6.7 1.6-14.9-4.3-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7h70.1L129.7 488.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7H233.9l52.4-104.8z", "M222.4 5.9c3.5-4.3 9-6.5 14.5-5.7C283.9 6.5 320 46.7 320 95.4c0 5.7-.5 11.2-1.4 16.6H320c35.3 0 64 28.7 64 64c0 12-3.3 23.1-9 32.7c41.2 5.4 73 40.6 73 83.3c0 46.4-37.6 84-84 84H351.3c1.3-7.8 .7-16-2-23.9C342.5 332.9 324.4 320 304 320H285.7l29.3-58.5c10.1-20.2 4.8-44.6-12.8-58.8s-42.6-14.2-60.2-.2L82 330.5C68.9 341 62.4 357.5 64.3 373.7C27.4 364.8 0 331.6 0 292c0-42.7 31.8-77.9 73-83.3c-5.7-9.6-9-20.8-9-32.7c0-35.3 28.7-64 64-64h16.3c23.8 0 44-6.3 57.8-17C215.5 84.5 224 69.1 224 47.3c0-9.2-1.5-18-4.3-26.1c-1.8-5.2-.8-11.1 2.8-15.3z"]],
    "tally-1": [640, 512, [], "e294", ["", "M128 32c17.7 0 32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64c0-17.7 14.3-32 32-32z"]],
    "face-frown-open": [512, 512, [128550, "frown-open"], "f57a", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM179.3 385.4c-12.3 5.2-26.1-4.2-20.8-16.4c16.7-38.2 55.8-65.1 101.5-65.1c45.7 0 84.9 26.9 101.5 65.1c5.3 12.2-8.6 21.5-20.8 16.4c-24.4-10.3-51.8-16.1-80.7-16.1c-28.9 0-56.2 5.8-80.6 16.1z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "square-dashed": [448, 512, [], "e269", ["M96 32h32V96H96c-17.7 0-32 14.3-32 32v32H0V128C0 75 43 32 96 32zm0 384h32v64H96c-53 0-96-43-96-96V352H64v32c0 17.7 14.3 32 32 32zm256 64H320V416h32c17.7 0 32-14.3 32-32V352h64v32c0 53-43 96-96 96zm96-320H384V128c0-17.7-14.3-32-32-32H320V32h32c53 0 96 43 96 96v32z", "M0 192V320H64V192H0zm384 0V320h64V192H384zM160 480H288V416H160v64zm0-384H288V32H160V96z"]],
    "square-j": [448, 512, [], "e273", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM304 152V288c0 53-43 96-96 96s-96-43-96-96v-8c0-13.3 10.7-24 24-24s24 10.7 24 24v8c0 26.5 21.5 48 48 48s48-21.5 48-48V152c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M280 128c13.3 0 24 10.7 24 24V288c0 53-43 96-96 96s-96-43-96-96v-8c0-13.3 10.7-24 24-24s24 10.7 24 24v8c0 26.5 21.5 48 48 48s48-21.5 48-48V152c0-13.3 10.7-24 24-24z"]],
    "hand-point-up": [384, 512, [9757], "f0a6", ["M64 0C81.7 0 96 14.3 96 32V240H32V32C32 14.3 46.3 0 64 0zM224 312l0-.6c9.4 5.4 20.3 8.6 32 8.6c13.2 0 25.4-4 35.6-10.8c8.7 24.9 32.5 42.8 60.4 42.8c11.7 0 22.6-3.1 32-8.6V352c0 88.4-71.6 160-160 160H162.3c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363V336c0-35.3 28.7-64 64-64h88c22.1 0 40 17.9 40 40s-17.9 40-40 40H96c-8.8 0-16 7.2-16 16s7.2 16 16 16h56c39.8 0 72-32.2 72-72z", "M128 160c0-17.7 14.3-32 32-32s32 14.3 32 32v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V160zm96 32c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V192zm128 0c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V224c0-17.7 14.3-32 32-32z"]],
    "money-bill": [576, 512, [], "f0d6", ["M448 128H128c0 35.3-28.7 64-64 64V320c35.3 0 64 28.7 64 64H448c0-35.3 28.7-64 64-64V192c-35.3 0-64-28.7-64-64zM288 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192z", "M64 64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zm384 64c0 35.3 28.7 64 64 64V320c-35.3 0-64 28.7-64 64H128c0-35.3-28.7-64-64-64V192c35.3 0 64-28.7 64-64H448z"]],
    "arrow-up-big-small": [576, 512, ["sort-size-up"], "f88e", ["M368 32c-26.5 0-48 21.5-48 48V208c0 26.5 21.5 48 48 48H496c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H368zm0 288c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48V368c0-26.5-21.5-48-48-48H368z", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V146.3L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32z"]],
    "barcode-read": [576, 512, [], "f464", ["M48 56c0-4.4 3.6-8 8-8h80c13.3 0 24-10.7 24-24s-10.7-24-24-24H56C25.1 0 0 25.1 0 56v80c0 13.3 10.7 24 24 24s24-10.7 24-24V56zm480 0v80c0 13.3 10.7 24 24 24s24-10.7 24-24V56c0-30.9-25.1-56-56-56H440c-13.3 0-24 10.7-24 24s10.7 24 24 24h80c4.4 0 8 3.6 8 8zM56 464c-4.4 0-8-3.6-8-8V376c0-13.3-10.7-24-24-24s-24 10.7-24 24v80c0 30.9 25.1 56 56 56h80c13.3 0 24-10.7 24-24s-10.7-24-24-24H56zm472-8c0 4.4-3.6 8-8 8H440c-13.3 0-24 10.7-24 24s10.7 24 24 24h80c30.9 0 56-25.1 56-56V376c0-13.3-10.7-24-24-24s-24 10.7-24 24v80z", "M152 128c-13.3 0-24 10.7-24 24V360c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H152zm160 0c-13.3 0-24 10.7-24 24V360c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H312zm72 24V360c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H408c-13.3 0-24 10.7-24 24zM240 128c-8.8 0-16 7.2-16 16V368c0 8.8 7.2 16 16 16s16-7.2 16-16V144c0-8.8-7.2-16-16-16z"]],
    "baguette": [640, 512, [129366], "e3d8", ["M583 234.5c58.8-39.2 74.7-118.7 35.5-177.5S499.8-17.7 441 21.5L356.5 77.8l70.8 70.8c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L329.3 96l-88 58.7 74 74c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-78.6-78.6-88 58.7 77.2 77.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L98.9 249.6 57 277.5C-1.8 316.7-17.7 396.2 21.5 455s118.7 74.7 177.5 35.5l384-256z", "M356.5 77.8L329.3 95.9l75.4 75.4c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L356.5 77.8zM126.1 231.4L98.9 249.5l81.8 81.8c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-77.2-77.2zm115.2-76.8l-27.2 18.1 78.6 78.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-74-74z"]],
    "bowl-soft-serve": [512, 512, [], "e46b", ["M256 0h32c70.7 0 128 57.3 128 128c0 11.8-3.2 22.8-8.8 32.3C448 164 480 198.3 480 240c0 44.2-35.8 80-80 80H112c-44.2 0-80-35.8-80-80c0-41.7 32-76 72.8-79.7C99.2 150.8 96 139.8 96 128c0-35.3 28.7-64 64-64h81.3c17 0 30.7-13.7 30.7-30.7c0-6.1-1.8-12-5.2-17L256 0z", "M64 320c-8.8 0-16 7.2-16 16v8c0 57.4 46.6 104 104 104h30.1l-20.4 40.8c-1.1 2.3-1.7 4.7-1.7 7.2c0 2.9 .8 5.8 2.4 8.4c2.9 4.7 8.1 7.6 13.6 7.6H336c5.5 0 10.7-2.9 13.6-7.6c1.6-2.6 2.4-5.5 2.4-8.4c0-2.4-.6-4.9-1.7-7.2L329.9 448H360c57.4 0 104-46.6 104-104v-8c0-8.8-7.2-16-16-16H64z"]],
    "face-holding-back-tears": [512, 512, [129401], "e482", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM344.5 367.9c-6.7-5.8-16.8-5.1-22.6 1.6C309 384.4 287.1 400 256 400s-53-15.6-65.9-30.5c-5.8-6.7-15.9-7.4-22.6-1.6s-7.4 15.9-1.6 22.6C183.1 410.3 213.2 432 256 432s72.9-21.7 90.1-41.5c5.8-6.7 5.1-16.8-1.6-22.6zM240 272V240c0-41.5-31.5-75.6-72-79.6c10-10.8 17.6-24.1 21.9-38.8l1.5-5.2c2.4-8.5-2.5-17.4-11-19.8s-17.4 2.5-19.8 11l-1.5 5.2c-7 24.7-28.1 42.7-53.6 45.9L94 160.1c-8.8 1.1-15 9.1-13.9 17.9c1 8.1 7.9 14 15.9 14c-10 13.4-16 30-16 48s6 34.6 16 48v32c0 8.8 7.2 16 16 16s16-7.2 16-16v-6.7c9.8 4.3 20.6 6.7 32 6.7c18 0 34.6-6 48-16c0 8.8 7.2 16 16 16s16-7.2 16-16V288 272zm144 41.3V320c0 8.8 7.2 16 16 16s16-7.2 16-16V288c10-13.4 16-30 16-48s-6-34.6-16-48c8 0 14.9-5.9 15.9-14c1.1-8.8-5.1-16.8-13.9-17.9l-11.5-1.4c-25.5-3.2-46.6-21.3-53.6-45.9l-1.5-5.2c-2.4-8.5-11.3-13.4-19.8-11s-13.4 11.3-11 19.8l1.5 5.2c4.2 14.8 11.8 28 21.9 38.8c-40.4 4-72 38.1-72 79.6c0 44.2 35.8 80 80 80c11.4 0 22.2-2.4 32-6.7z", "M191.4 116.4l-1.5 5.2c-10.6 37-42.2 64.1-80.4 68.9L98 191.9c-8.8 1.1-16.8-5.1-17.9-13.9s5.1-16.8 13.9-17.9l11.5-1.4c25.5-3.2 46.6-21.3 53.6-45.9l1.5-5.2c2.4-8.5 11.3-13.4 19.8-11s13.4 11.3 11 19.8zm129.2 0c-2.4-8.5 2.5-17.4 11-19.8s17.4 2.5 19.8 11l1.5 5.2c7 24.7 28.1 42.7 53.6 45.9l11.5 1.4c8.8 1.1 15 9.1 13.9 17.9s-9.1 15-17.9 13.9l-11.5-1.4c-38.2-4.8-69.8-31.9-80.4-68.9l-1.5-5.2zM128 232c17.7 0 32-14.3 32-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4c17.7 0 32-14.3 32-32z"]],
    "square-up": [448, 512, [11014, "arrow-alt-square-up"], "f353", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm39.1 185.4l107.1-99.9c3.8-3.5 8.7-5.5 13.8-5.5s10.1 2 13.8 5.5l107.1 99.9c4.5 4.2 7.1 10.1 7.1 16.3c0 12.3-10 22.3-22.3 22.3H272v96c0 17.7-14.3 32-32 32H208c-17.7 0-32-14.3-32-32V256H118.3C106 256 96 246 96 233.7c0-6.2 2.6-12.1 7.1-16.3z", "M210.2 117.5L103.1 217.4c-4.5 4.2-7.1 10.1-7.1 16.3C96 246 106 256 118.3 256H176v96c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V256h57.7c12.3 0 22.3-10 22.3-22.3c0-6.2-2.6-12.1-7.1-16.3L237.8 117.5c-3.8-3.5-8.7-5.5-13.8-5.5s-10.1 2-13.8 5.5z"]],
    "train-subway-tunnel": [512, 512, ["subway-tunnel"], "e2a3", ["M256 0C114.6 0 0 114.6 0 256V448c0 35.3 28.7 64 64 64h41.4l64.3-64.3C137.3 444.5 112 417.2 112 384V192c0-35.3 28.7-64 64-64H336c35.3 0 64 28.7 64 64V384c0 33.2-25.3 60.5-57.7 63.7L406.6 512H448c35.3 0 64-28.7 64-64V256C512 114.6 397.4 0 256 0zM361.4 512l-64-64H214.6l-64 64H361.4zM184 192c-13.3 0-24 10.7-24 24v8 64 8c0 13.3 10.7 24 24 24h8 16 8c13.3 0 24-10.7 24-24v-8V224v-8c0-13.3-10.7-24-24-24h-8H192h-8zm88 24v8 64 8c0 13.3 10.7 24 24 24h8 16 8c13.3 0 24-10.7 24-24v-8V224v-8c0-13.3-10.7-24-24-24h-8H304h-8c-13.3 0-24 10.7-24 24z", "M112 192c0-35.3 28.7-64 64-64H336c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H176c-35.3 0-64-28.7-64-64V192zm48 24v8 64 8c0 13.3 10.7 24 24 24h8 16 8c13.3 0 24-10.7 24-24v-8V224v-8c0-13.3-10.7-24-24-24h-8H192h-8c-13.3 0-24 10.7-24 24zm136-24c-13.3 0-24 10.7-24 24v8 64 8c0 13.3 10.7 24 24 24h8 16 8c13.3 0 24-10.7 24-24v-8V224v-8c0-13.3-10.7-24-24-24h-8H304h-8zM208 376a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm120 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "square-exclamation": [448, 512, ["exclamation-square"], "f321", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm160 96c13.3 0 24 10.7 24 24V264c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-13.3 10.7-24 24-24zM192 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M248 152c0-13.3-10.7-24-24-24s-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152zM224 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "semicolon": [192, 512, [], "3b", ["M83.7 492.8L150.8 383c6-9.8 9.2-21.2 9.2-32.7c0-34.2-27.7-62.3-61.9-62.3c-29.2 0-54.4 20.4-60.6 49L10.4 463.6C5 488.5 24 512 49.5 512c14 0 26.9-7.3 34.2-19.2z", "M32 128a64 64 0 1 1 128 0A64 64 0 1 1 32 128z"]],
    "bookmark": [384, 512, [128278, 61591], "f02e", ["M192 288l-71.1 47.4c-10.6 7.1-24.9-.5-24.9-13.3V0H288V322.1c0 12.8-14.2 20.4-24.9 13.3L192 288z", "M0 487.7V48C0 21.5 21.5 0 48 0H96V322.1c0 12.8 14.2 20.4 24.9 13.3L192 288l71.1 47.4c10.6 7.1 24.9-.5 24.9-13.3V0h48c26.5 0 48 21.5 48 48V487.7c0 13.4-10.9 24.3-24.3 24.3c-5 0-9.9-1.5-14-4.4L192 400 38.3 507.6c-4.1 2.9-9 4.4-14 4.4C10.9 512 0 501.1 0 487.7z"]],
    "fan-table": [448, 512, [], "e004", ["M432 208c0 104-76.3 190.2-176 205.6V448H192V413.6C92.3 398.2 16 312 16 208C16 93.1 109.1 0 224 0S432 93.1 432 208zM224.3 166L184.9 68.5c-3.3-8.2-12.6-12.2-20.8-8.8C119 77.9 97.2 129.1 115.4 174.2c12.6 31.1 40.9 51.1 72.1 54.5l-64.8 82.9c-5.4 7-4.2 17 2.8 22.5c38.3 29.9 93.6 23.1 123.5-15.2c20.7-26.4 23.8-61 11.2-89.7l104.2 14.6c8.8 1.2 16.8-4.9 18.1-13.6c6.8-48.1-26.8-92.6-74.9-99.4c-33.2-4.7-64.7 9.9-83.3 35.1z", "M184.9 68.5L224.3 166c18.5-25.3 50-39.8 83.3-35.1c48.1 6.8 81.7 51.3 74.9 99.4c-1.2 8.8-9.3 14.8-18.1 13.6L260.2 229.2c12.6 28.7 9.5 63.2-11.2 89.7c-29.9 38.3-85.2 45.1-123.5 15.2c-7-5.4-8.2-15.5-2.8-22.5l64.8-82.9c-31.2-3.4-59.5-23.4-72.1-54.5C97.2 129.1 119 77.9 164.1 59.7c8.2-3.3 17.5 .6 20.8 8.8zM240 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM96 448H224 352c17.7 0 32 14.3 32 32s-14.3 32-32 32H224 96c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]],
    "align-justify": [448, 512, [], "f039", ["M32 352c-17.7 0-32-14.3-32-32s14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32zM32 96C14.3 96 0 81.7 0 64S14.3 32 32 32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32z", "M32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32zm0-256c-17.7 0-32-14.3-32-32s14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32z"]],
    "battery-low": [576, 512, ["battery-1"], "e0b1", ["M80 160c-8.8 0-16 7.2-16 16V336c0 8.8 7.2 16 16 16H464c8.8 0 16-7.2 16-16V176c0-8.8-7.2-16-16-16H80zM0 176c0-44.2 35.8-80 80-80H464c44.2 0 80 35.8 80 80v16c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32v16c0 44.2-35.8 80-80 80H80c-44.2 0-80-35.8-80-80V176z", "M96 192h64V320H96z"]],
    "credit-card-front": [576, 512, [], "f38a", ["M112 288c-8.8 0-16 7.2-16 16s7.2 16 16 16H464c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zM96 368c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm128 0c0 8.8 7.2 16 16 16H368c8.8 0 16-7.2 16-16s-7.2-16-16-16H240c-8.8 0-16 7.2-16 16z", "M0 96C0 60.7 28.7 32 64 32H512c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM112 288c-8.8 0-16 7.2-16 16s7.2 16 16 16H464c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zM96 368c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm128 0c0 8.8 7.2 16 16 16H368c8.8 0 16-7.2 16-16s-7.2-16-16-16H240c-8.8 0-16 7.2-16 16zM408 96c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h80c13.3 0 24-10.7 24-24V120c0-13.3-10.7-24-24-24H408z"]],
    "brain-arrow-curved-right": [640, 512, ["mind-share"], "f677", ["M184 0c30.9 0 56 25.1 56 56V456c0 30.9-25.1 56-56 56c-28.9 0-52.7-21.9-55.7-50.1c-5.2 1.4-10.7 2.1-16.3 2.1c-35.3 0-64-28.7-64-64c0-7.4 1.3-14.6 3.6-21.2C21.4 367.4 0 338.2 0 304c0-31.9 18.7-59.5 45.8-72.3C37.1 220.8 32 207 32 192c0-30.7 21.6-56.3 50.4-62.6C80.8 123.9 80 118 80 112c0-29.9 20.6-55.1 48.3-62.1C131.3 21.9 155.1 0 184 0zM328 0c28.9 0 52.6 21.9 55.7 49.9c27.8 7 48.3 32.1 48.3 62.1c0 6-.8 11.9-2.4 17.4c28.8 6.2 50.4 31.9 50.4 62.6c0 15-5.1 28.8-13.8 39.7c5.7 2.7 11.1 6.1 16 10c-1.4 4.6-2.2 9.4-2.2 14.3v16H448c-79.5 0-144 64.5-144 144c0 43.3 17.3 75 33.5 95.2c-3.1 .5-6.3 .8-9.5 .8c-30.9 0-56-25.1-56-56V56c0-30.9 25.1-56 56-56z", "M521.9 241.2c6-2.5 12.9-1.1 17.4 3.5l96 96c6.2 6.2 6.2 16.4 0 22.6l-96 96c-4.6 4.6-11.5 5.9-17.4 3.5s-9.9-8.3-9.9-14.8V400H464c-35.3 0-64 28.7-64 64v35.7c0 6.8-5.5 12.3-12.3 12.3c-2.4 0-4.8-.7-6.7-2.2c-10.5-8.2-45-39.5-45-93.8c0-61.9 50.1-112 112-112h64V256c0-6.5 3.9-12.3 9.9-14.8z"]],
    "umbrella-beach": [576, 512, [127958], "f5ca", ["M297.1 219.8l60.1 21.9L282.1 448H214l83.1-228.2z", "M434 269.7L223.5 193l3.3-9.1c18.1-49.8 45.6-95.6 80.9-135.1l4-4.5C335 18.3 371.8 8.9 404.8 20.6c.9 .3 1.9 .7 2.8 1.1c31.9 12.6 53.3 43 54.4 77.4l.2 6c1.7 52.9-6.8 105.7-24.9 155.5l-3.3 9.1zM287.8 23.1l-4 4.5c-38 42.5-67.6 91.9-87.1 145.5l-3.3 9.1-71-25.8c-18.1-6.6-26.4-27.7-15.3-43.4C153.7 47.1 228.8 7.3 308.4 4.9C300.9 10 294 16.1 287.8 23.1zM494 98.1c-.3-8.5-1.4-16.8-3.4-24.8c56.9 53 87.3 130 80.8 208.5c-1.6 19.2-21.5 30-39.6 23.4l-67.7-24.6 3.3-9.1c19.5-53.6 28.6-110.4 26.8-167.4l-.2-6zM32 448H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]],
    "helmet-un": [512, 512, [], "e503", ["M215.7 384L343.5 505.4c4.5 4.2 10.4 6.6 16.5 6.6h80c13.3 0 24-10.7 24-24s-10.7-24-24-24H369.6l-1.6-1.5V288H320V416.9L242.3 343l-14.6 25.1L218.4 384h-2.7z", "M479.5 224C471.2 98.9 367.2 0 240 0C107.5 0 0 107.5 0 240v56.3C0 344.8 39.2 384 87.7 384H200h18.4l9.3-15.9L274.4 288H448h32c17.7 0 32-14.3 32-32s-14.3-32-32-32h-.5zM285.3 103.1l34.7 52V112c0-8.8 7.2-16 16-16s16 7.2 16 16v96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4l-34.7-52V208c0 8.8-7.2 16-16 16s-16-7.2-16-16V112c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4zM160 112v64c0 8.8 7.2 16 16 16s16-7.2 16-16V112c0-8.8 7.2-16 16-16s16 7.2 16 16v64c0 26.5-21.5 48-48 48s-48-21.5-48-48V112c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "location-smile": [384, 512, ["map-marker-smile"], "f60d", ["M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM128 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-95.4 84.9c6.2 9.4 29.1 31.1 63.4 31.1s57.1-21.7 63.4-31.1c6.1-9.2 18.5-11.7 27.7-5.5s11.7 18.5 5.5 27.7C277.1 284.4 243.1 316 192 316s-85.1-31.6-96.6-48.9c-6.1-9.2-3.6-21.6 5.5-27.7s21.6-3.6 27.7 5.5z", "M160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128.6 244.9c-6.1-9.2-18.5-11.7-27.7-5.5s-11.7 18.5-5.5 27.7C106.9 284.4 140.9 316 192 316s85.1-31.6 96.6-48.9c6.1-9.2 3.6-21.6-5.5-27.7s-21.6-3.6-27.7 5.5c-6.2 9.4-29.1 31.1-63.4 31.1s-57.1-21.7-63.4-31.1z"]],
    "arrow-left-to-line": [448, 512, [8676, "arrow-to-left"], "f33e", ["M32 448c-17.7 0-32-14.3-32-32L0 96C0 78.3 14.3 64 32 64s32 14.3 32 32l0 320c0 17.7-14.3 32-32 32z", "M137.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L237.3 224 416 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-178.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128z"]],
    "bullseye": [512, 512, [], "f140", ["M256 176a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 224a144 144 0 1 0 0-288 144 144 0 1 0 0 288z", "M448 256A192 192 0 1 0 64 256a192 192 0 1 0 384 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "sushi": [576, 512, [127843, "nigiri"], "e48a", ["M32 384V369c8.5 .7 17.5-.3 26.4-3.4l193-66.9c20-6.9 41.6-7.1 61.7-.4l205.5 68.2c8.6 2.9 17.2 3.8 25.5 3.1V384c0 35.3-28.7 64-64 64c-19.1 0-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7C132.3 439.6 115.1 448 96 448c-35.3 0-64-28.7-64-64z", "M405.9 295.5L506.3 125.6c24.8 26.7 42.1 60.7 48.5 98.8l12.5 75.2c4 23.8-18.8 43.2-41.7 35.6L405.9 295.5zm76.2-191.9L374.8 285.2 323.1 268c-14.6-4.9-30-7-45.2-6.4L393.5 66.1c32.9 4.8 63.2 18 88.7 37.5zM246.6 64H357.5L235.6 270.4 96.1 318.7 246.6 64zm-37.2 0L49.4 334.8C27 341.5 5 322.3 8.9 298.9l12.4-74.4C36.6 132.2 116.1 64.6 209.5 64z"]],
    "message-captions": [512, 512, ["comment-alt-captions"], "e1de", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zM120 192c-13.3 0-24 10.7-24 24s10.7 24 24 24H264c13.3 0 24-10.7 24-24s-10.7-24-24-24H120zm224 0c-13.3 0-24 10.7-24 24s10.7 24 24 24h48c13.3 0 24-10.7 24-24s-10.7-24-24-24H344zM120 272c-13.3 0-24 10.7-24 24s10.7 24 24 24h48c13.3 0 24-10.7 24-24s-10.7-24-24-24H120zm128 0c-13.3 0-24 10.7-24 24s10.7 24 24 24H392c13.3 0 24-10.7 24-24s-10.7-24-24-24H248z", "M96 216c0-13.3 10.7-24 24-24H264c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24zm224 0c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H344c-13.3 0-24-10.7-24-24zM96 296c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24H392c13.3 0 24 10.7 24 24s-10.7 24-24 24H248c-13.3 0-24-10.7-24-24z"]],
    "trash-list": [640, 512, [], "e2b1", ["M362.6 466.8L384 96H32L53.4 466.8c1.5 25.4 22.5 45.2 47.9 45.2H314.7c25.4 0 46.5-19.8 47.9-45.2z", "M147.8 0c-12.1 0-23.2 6.8-28.6 17.7L112 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H384c17.7 0 32-14.3 32-32s-14.3-32-32-32H304l-7.2-14.3C291.4 6.8 280.3 0 268.2 0H147.8zM448 160c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H480c-17.7 0-32 14.3-32 32zm0 128c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32s-14.3-32-32-32H480c-17.7 0-32 14.3-32 32zm32 96c-17.7 0-32 14.3-32 32s14.3 32 32 32h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H480z"]],
    "bacon": [576, 512, [129363], "f7e5", ["M439.2 1.2c11.2-3.2 23.2-.1 31.4 8.1L518 56.7l-26.5 7.9c-58 16.6-98.1 39.6-129.6 67.4c-31.2 27.5-53.2 59.1-75.1 90.9l-2.3 3.3C241.6 288.7 195 356.6 72.8 417.7L37.9 435.2 9.4 406.6c-7.3-7.3-10.6-17.6-9-27.8s8.1-18.9 17.3-23.5C136.1 296.2 180.9 231 223.3 169.3l2.3-3.4c21.8-31.8 44.9-64.9 77.7-93.9c33.4-29.5 75.8-53.6 135.9-70.8zM61.8 459l25.4-12.7c129.5-64.7 179.9-138.1 223.8-202l2.2-3.3c22.1-32.1 42.1-60.5 69.9-85.1c27.5-24.3 63.4-45.2 117.3-60.6l0 0 .2-.1 43.1-12.9 23 23c8 8 11.2 19.7 8.3 30.7s-11.3 19.6-22.2 22.7c-51.9 14.8-85.6 34.7-111.1 57.2c-26.1 23-45.1 49.9-67.3 82.1l-2.2 3.2C327.8 365.9 275.5 442 142.3 508.6c-12.3 6.2-27.2 3.7-36.9-6L61.8 459z", "M518 56.7l-26.5 7.9c-58 16.6-98.1 39.6-129.6 67.4c-31.2 27.5-53.2 59.1-75.1 90.9l-2.3 3.3C241.6 288.7 195 356.6 72.8 417.7L37.9 435.2 61.8 459l25.4-12.7c129.5-64.7 179.9-138.1 223.8-202l2.2-3.3c22.1-32.1 42.1-60.5 69.9-85.1c27.5-24.3 63.4-45.2 117.3-60.6l0 0 .2-.1 43.1-12.9L518 56.7z"]],
    "option": [640, 512, [], "e318", ["M416 96c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H448c-17.7 0-32 14.3-32 32z", "M423 436c6.1 7.6 15.3 12 25 12H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H463.4L217 76c-6.1-7.6-15.3-12-25-12H32C14.3 64 0 78.3 0 96s14.3 32 32 32H176.6L423 436z"]],
    "hand-point-down": [384, 512, [], "f0a7", ["M64 512c17.7 0 32-14.3 32-32V272H32V480c0 17.7 14.3 32 32 32zM224 200l0 .6c9.4-5.4 20.3-8.6 32-8.6c13.2 0 25.4 4 35.6 10.8c8.7-24.9 32.5-42.8 60.4-42.8c11.7 0 22.6 3.1 32 8.6V160C384 71.6 312.4 0 224 0H162.3C119.8 0 79.1 16.9 49.1 46.9L37.5 58.5C13.5 82.5 0 115.1 0 149v27c0 35.3 28.7 64 64 64h88c22.1 0 40-17.9 40-40s-17.9-40-40-40H96c-8.8 0-16-7.2-16-16s7.2-16 16-16h56c39.8 0 72 32.2 72 72z", "M352 320c-17.7 0-32-14.3-32-32V224c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 17.7-14.3 32-32 32zm-128 0V256c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 17.7-14.3 32-32 32s-32-14.3-32-32zm-96 32V304c0-17.7 14.3-32 32-32s32 14.3 32 32v48c0 17.7-14.3 32-32 32s-32-14.3-32-32z"]],
    "arrow-up-from-bracket": [448, 512, [], "e09a", ["M32 320c17.7 0 32 14.3 32 32v64c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V352c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 53-43 96-96 96H96c-53 0-96-43-96-96V352c0-17.7 14.3-32 32-32z", "M201.4 9.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 109.3V320c0 17.7-14.3 32-32 32s-32-14.3-32-32V109.3l-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128z"]],
    "trash-plus": [448, 512, [], "e2b2", ["M416 96H32L53.4 466.8c1.5 25.4 22.5 45.2 47.9 45.2H346.7c25.4 0 46.5-19.8 47.9-45.2L416 96zM200 376V312H136c-13.3 0-24-10.7-24-24s10.7-24 24-24h64V200c0-13.3 10.7-24 24-24s24 10.7 24 24v64h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H248v64c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM200 376V312H136c-13.3 0-24-10.7-24-24s10.7-24 24-24h64V200c0-13.3 10.7-24 24-24s24 10.7 24 24v64h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H248v64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]],
    "objects-align-top": [512, 512, [], "e3c0", ["M112 128c-26.5 0-48 21.5-48 48V464c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48V176c0-26.5-21.5-48-48-48H112zm224 0c-26.5 0-48 21.5-48 48V336c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48V176c0-26.5-21.5-48-48-48H336z", "M0 24C0 10.7 10.7 0 24 0H488c13.3 0 24 10.7 24 24s-10.7 24-24 24H24C10.7 48 0 37.3 0 24z"]],
    "folder": [512, 512, [128193, 128447, 61716, "folder-blank"], "f07b", ["M64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H288c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64z", ""]],
    "face-anxious-sweat": [576, 512, [], "e36a", ["M288 512c141.4 0 256-114.6 256-256S429.4 0 288 0S32 114.6 32 256c0 1.1 0 2.2 0 3.3c16.3-7.1 36.4-2.8 48 12.8c7 9.2 18.1 24.6 27.7 40.7c4.8 8.1 9.6 17 13.2 25.7c3.4 8 7.1 19 7.1 30.5c0 24.5-11.1 46-28.4 60.3C146.4 480.2 213.5 512 288 512zM208 400c0-44.2 35.8-80 80-80s80 35.8 80 80c0 8.8-7.2 16-16 16H224c-8.8 0-16-7.2-16-16zM367.6 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-128 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM227.3 171.3l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm121.4-22.6c6.2-6.2 16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4c-6.2-6.2-6.2-16.4 0-22.6z", "M227.3 171.3l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM239.6 272a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm160 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM348.7 148.7c6.2-6.2 16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4c-6.2-6.2-6.2-16.4 0-22.6zM48 416c-26.5 0-48-21-48-47c0-20 28.6-60.4 41.6-77.7c3.2-4.4 9.6-4.4 12.8 0C67.6 308.6 96 349 96 369c0 26-21.5 47-48 47z"]],
    "credit-card-blank": [576, 512, [], "f389", ["M112 352c-8.8 0-16 7.2-16 16s7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zm128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16H368c8.8 0 16-7.2 16-16s-7.2-16-16-16H240z", "M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM96 368c0-8.8 7.2-16 16-16h64c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16zm128 0c0-8.8 7.2-16 16-16H368c8.8 0 16 7.2 16 16s-7.2 16-16 16H240c-8.8 0-16-7.2-16-16z"]],
    "file-waveform": [448, 512, ["file-medical-alt"], "f478", ["M64 64C64 28.7 92.7 0 128 0H288V128c0 17.7 14.3 32 32 32H448V448c0 35.3-28.7 64-64 64H128c-35.3 0-64-28.7-64-64V320h65.2l41.4 82.7c4.2 8.5 13 13.6 22.5 13.2s17.8-6.3 21.3-15.1l44.2-110.4 8.1 16.2c4.1 8.1 12.4 13.3 21.5 13.3h56c13.3 0 24-10.7 24-24s-10.7-24-24-24H302.8l-25.4-50.7c-4.2-8.5-13-13.6-22.5-13.2s-17.8 6.3-21.3 15.1L189.6 333.5l-24.1-48.2c-4.1-8.1-12.4-13.3-21.5-13.3H64V64z", "M448 160L288 0V128c0 17.7 14.3 32 32 32H448zM277.5 221.3c-4.2-8.5-13-13.6-22.5-13.2s-17.8 6.3-21.3 15.1L189.6 333.5l-24.1-48.2c-4.1-8.1-12.4-13.3-21.5-13.3H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H129.2l41.4 82.7c4.2 8.5 13 13.6 22.5 13.2s17.8-6.3 21.3-15.1l44.2-110.4 8.1 16.2c4.1 8.1 12.4 13.3 21.5 13.3h56c13.3 0 24-10.7 24-24s-10.7-24-24-24H302.8l-25.4-50.7z"]],
    "microchip-ai": [512, 512, [], "e1ec", ["M176 24c0-13.3-10.7-24-24-24s-24 10.7-24 24V64h48V24zM280 64V24c0-13.3-10.7-24-24-24s-24 10.7-24 24V64h48zm104 0V24c0-13.3-10.7-24-24-24s-24 10.7-24 24V64h48zm64 112h40c13.3 0 24-10.7 24-24s-10.7-24-24-24H448v48zm0 104h40c13.3 0 24-10.7 24-24s-10.7-24-24-24H448v48zm0 104h40c13.3 0 24-10.7 24-24s-10.7-24-24-24H448v48zM336 448v40c0 13.3 10.7 24 24 24s24-10.7 24-24V448H336zm-104 0v40c0 13.3 10.7 24 24 24s24-10.7 24-24V448H232zm-104 0v40c0 13.3 10.7 24 24 24s24-10.7 24-24V448H128zM64 336H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H64V336zm0-104H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H64V232zm0-104H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H64V128z", "M128 64c-35.3 0-64 28.7-64 64V384c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H128zm94.7 121.6l42 96 14 32c3.5 8.1-.1 17.5-8.2 21.1s-17.5-.2-21.1-8.2L239.5 304H176.5l-9.8 22.4c-3.5 8.1-13 11.8-21.1 8.2s-11.8-13-8.2-21.1l14-32 42-96c2.5-5.8 8.3-9.6 14.7-9.6s12.1 3.8 14.7 9.6zM208 231.9L190.5 272h35.1L208 231.9zM352 192V320c0 8.8-7.2 16-16 16s-16-7.2-16-16V192c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "mug": [576, 512, [], "f874", ["M416 320h32c70.7 0 128-57.3 128-128s-57.3-128-128-128H384c17.7 0 32 14.3 32 32v32h32c35.3 0 64 28.7 64 64s-28.7 64-64 64H416v64z", "M32 96c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32V352c0 53-43 96-96 96H128c-53 0-96-43-96-96V96z"]],
    "plane-up-slash": [640, 512, [], "e22e", ["M161.3 223.1L445.9 447.3c1.4 2.4 2.1 5.1 2.1 8V498c0 7.8-6.3 14-14 14c-1.3 0-2.6-.2-3.9-.5L320 480 209.9 511.5c-1.3 .4-2.6 .5-3.9 .5c-7.8 0-14-6.3-14-14V456c0-5 2.4-9.8 6.4-12.8L256 400V320L85.1 377C74.7 380.4 64 372.7 64 361.8V305.1c0-10.7 5.3-20.7 14.2-26.6l83.1-55.4zM554.9 377l-72.5-24.2-237-185.8L256 160V93.7C256 59.5 285 0 320 0c36 0 64 59.5 64 93.7l0 66.3L561.8 278.5c8.9 5.9 14.2 15.9 14.2 26.6v56.7c0 10.9-10.7 18.6-21.1 15.2z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "radiation": [512, 512, [], "f7b9", ["M208 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z", "M176 256c0-29.6 16.1-55.5 40-69.3L144 62c-8.8-15.3-28.6-20.7-42.7-10C47.8 92.7 10.7 154 2 224.1C-.2 241.6 14.3 256 32 256l144 0zm40 69.3L144 450.1c-8.8 15.3-3.7 35.1 12.6 41.9c30.6 12.9 64.2 20 99.4 20s68.9-7.1 99.4-20c16.3-6.9 21.4-26.6 12.6-41.9L296 325.3c-11.8 6.8-25.4 10.7-40 10.7s-28.2-3.9-40-10.7zM336 256l144 0c17.7 0 32.2-14.4 30-31.9C501.3 154 464.2 92.7 410.7 52c-14.1-10.7-33.8-5.3-42.7 10L296 186.7c23.9 13.8 40 39.7 40 69.3z"]],
    "pen-circle": [512, 512, [], "e20e", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM357.8 139.7l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-21.4 21.4-71-71 21.4-21.4c15.6-15.6 40.9-15.6 56.6 0zM151.9 289L257.1 183.8l71 71L222.9 359.9c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9z", "M301.2 139.7l-21.4 21.4 71 71 21.4-21.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-44 44L151.9 289c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L328.1 254.7l-71-71z"]],
    "bag-seedling": [512, 512, [], "e5f2", ["M64 64H448l18.6 74.5c8.9 35.5 13.4 72 13.4 108.7v17.7c0 36.6-4.5 73.1-13.4 108.7L448 448H64L45.4 373.5C36.5 338 32 301.5 32 264.8V247.2c0-36.6 4.5-73.1 13.4-108.7L64 64zm80 96c-8.8 0-16 7.2-16 16c0 59.2 45.9 107.6 104 111.7V328c0 13.3 10.7 24 24 24s24-10.7 24-24V287.7c58.1-4.1 104-52.6 104-111.7c0-8.8-7.2-16-16-16h-2c-47.3 0-88.4 26-110 64.5C234.4 186 193.3 160 146 160h-2z", "M38.6 38.6L64 64H448l25.4-25.4c4.2-4.2 6.6-10 6.6-16C480 10.1 469.9 0 457.4 0H54.6C42.1 0 32 10.1 32 22.6c0 6 2.4 11.8 6.6 16zm0 434.7c-4.2 4.2-6.6 10-6.6 16C32 501.9 42.1 512 54.6 512H457.4c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L448 448H64L38.6 473.4zM144 160c-8.8 0-16 7.2-16 16c0 59.2 45.9 107.6 104 111.7V328c0 13.3 10.7 24 24 24s24-10.7 24-24V287.7c58.1-4.1 104-52.6 104-111.7c0-8.8-7.2-16-16-16h-2c-47.3 0-88.4 26-110 64.5C234.4 186 193.3 160 146 160h-2z"]],
    "chart-simple": [448, 512, [], "e473", ["M160 80c0-26.5 21.5-48 48-48h32c26.5 0 48 21.5 48 48V432c0 26.5-21.5 48-48 48H208c-26.5 0-48-21.5-48-48V80z", "M368 96c-26.5 0-48 21.5-48 48V432c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V144c0-26.5-21.5-48-48-48H368zM48 224c-26.5 0-48 21.5-48 48V432c0 26.5 21.5 48 48 48H80c26.5 0 48-21.5 48-48V272c0-26.5-21.5-48-48-48H48z"]],
    "crutches": [640, 512, [], "f7f8", ["M470.6 9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160zm-256 0c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l1.4-1.4L188.2 345.4c2.7 2.7 5.5 5.1 8.4 7.5l17-17 10.1-45.5L101.3 168 168 101.3l86.3 86.3c5-7.9 10.9-15.3 17.6-22l25.4-25.4L213.3 56l1.4-1.4c12.5-12.5 12.5-32.8 0-45.3zM457.4 502.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64.1-64.1c-8.6 4-17.6 7.1-26.9 9.2l-44.5 9.9 90.2 90.2z", "M329.4 153.4L426.7 56 472 101.3 397.3 176 464 242.7 538.7 168 584 213.3l-97.3 97.3c0 0-.1 .1-.1 .1s-.1 .1-.1 .1l-34.7 34.7c-12.9 12.9-29.2 21.9-47.1 25.8L297.1 395.2c-5.9 1.3-11.4 4.3-15.7 8.6l-98.8 98.8c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l98.8-98.8c4.3-4.3 7.3-9.7 8.6-15.7l23.9-107.6c4-17.8 12.9-34.1 25.8-47.1l34.8-34.8zM352 221.3l-12.2 12.2c-4.3 4.3-7.3 9.7-8.6 15.7l-17 76.7 76.7-17c5.9-1.3 11.4-4.3 15.7-8.6L418.7 288 352 221.3z"]],
    "circle-parking": [512, 512, ["parking-circle"], "f615", ["M256 64a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 448A256 256 0 1 0 256 0a256 256 0 1 0 0 512z", "M240 192h48c17.7 0 32 14.3 32 32s-14.3 32-32 32H240V192zm0 128h48c53 0 96-43 96-96s-43-96-96-96H216c-22.1 0-40 17.9-40 40V288v64c0 17.7 14.3 32 32 32s32-14.3 32-32V320z"]],
    "mars-stroke": [512, 512, [9894], "f229", ["M128 304a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z", "M376 0c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l33.4 33.4L370.3 96.4 345 71c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l25.4 25.4L307.8 159c-28.4-19.5-62.7-31-99.8-31c-97.2 0-176 78.8-176 176s78.8 176 176 176s176-78.8 176-176c0-37-11.4-71.4-31-99.8l28.6-28.6L407 201c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-25.4-25.4 22.1-22.1L471 153c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2V24c0-13.3-10.7-24-24-24H376zm88 48h0v0l0 0zM96 304a112 112 0 1 1 224 0A112 112 0 1 1 96 304z"]],
    "leaf-oak": [512, 512, [], "f6f7", ["M470.6 258.4l-40.8 10.2c-6 1.5-8.1 9-3.7 13.4l22 22c17.7 17.7 17.7 46.3 0 64c-10.1 10.1-24.3 14.8-38.4 12.8l-75.1-10.7c-5.6-.8-9.5 5.4-6.4 10.1c13.9 20.8 11.1 48.5-6.6 66.2l-3.6 3.6c-17.9 17.9-45.2 22.3-67.8 11L219 445.5c-17.8-8.9-37.4-13.5-57.2-13.5H113.9L313.9 232.1c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L80 398.1l0-47.8c0-19.9-4.6-39.5-13.5-57.2L50.9 261.9c-11.3-22.6-6.9-49.9 11-67.8l3.6-3.6c17.7-17.7 45.4-20.4 66.2-6.6c4.7 3.1 10.9-.8 10.1-6.4l-10.7-75.1c-2-14.1 2.7-28.3 12.8-38.4c17.7-17.7 46.3-17.7 64 0l22 22c4.4 4.4 11.9 2.3 13.4-3.7l10.2-40.8C259.7 17.1 281.6 0 306.7 0c18.3 0 35.4 9.1 45.5 24.4l9.5 14.3c3.8 5.6 10.6 8.3 17.2 6.6l20.1-5c20.4-5.1 42 .9 56.9 15.8s20.9 36.5 15.8 56.9l-5 20.1c-1.6 6.6 1 13.4 6.6 17.2l14.3 9.5C502.9 169.9 512 187 512 205.3c0 25.1-17.1 47-41.4 53.1z", "M7 505c-9.4-9.4-9.4-24.6 0-33.9L279.9 198.1c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L41 505c-9.4 9.4-24.6 9.4-33.9 0z"]],
    "square-bolt": [448, 512, [], "e265", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm234.1 83.6c5.8 4.7 7.6 12.9 4.3 19.6L249.9 240H320c6.8 0 12.9 4.3 15.1 10.7s.2 13.5-5.1 17.8l-160 128c-5.9 4.7-14.2 4.7-20.1-.1s-7.6-12.9-4.3-19.6L198.1 272H128c-6.8 0-12.8-4.3-15.1-10.7s-.2-13.5 5.1-17.8l160-128c5.9-4.7 14.2-4.7 20.1 .1z", "M302.3 135.2c3.4-6.7 1.6-14.9-4.3-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7h70.1L145.7 376.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7H249.9l52.4-104.8z"]],
    "vial": [512, 512, [129514], "f492", ["M297.4 9.4c12.5-12.5 32.8-12.5 45.3 0l32 32 96 96 32 32c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-9.4-9.4L169.4 483.9c-18 18-42.4 28.1-67.9 28.1H96c-53 0-96-43-96-96v-5.5c0-25.5 10.1-49.9 28.1-67.9L306.7 64l-9.4-9.4c-12.5-12.5-12.5-32.8 0-45.3zM352 109.3L73.4 387.9c-6 6-9.4 14.1-9.4 22.6V416c0 17.7 14.3 32 32 32h5.5c8.5 0 16.6-3.4 22.6-9.4L402.7 160 352 109.3z", "M306.7 256H205.3L73.4 387.9c-6 6-9.4 14.1-9.4 22.6V416c0 17.7 14.3 32 32 32h5.5c8.5 0 16.6-3.4 22.6-9.4L306.7 256z"]],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-26.9-16.5-49.9-40-59.3V88c0-13.3-10.7-24-24-24s-24 10.7-24 24V292.7c-23.5 9.5-40 32.5-40 59.3c0 35.3 28.7 64 64 64s64-28.7 64-64zM144 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M280 88c0-13.3-10.7-24-24-24s-24 10.7-24 24V292.7c-23.5 9.5-40 32.5-40 59.3c0 35.3 28.7 64 64 64s64-28.7 64-64c0-26.9-16.5-49.9-40-59.3V88z"]],
    "wand-magic-sparkles": [576, 512, ["magic-wand-sparkles"], "e2ca", ["M234.7 42.7L248.8 5c1.1-3 4-5 7.2-5s6.1 2 7.2 5l14.1 37.7L315 56.8c3 1.1 5 4 5 7.2s-2 6.1-5 7.2L277.3 85.3 263.2 123c-1.1 3-4 5-7.2 5s-6.1-2-7.2-5L234.7 85.3 197 71.2c-3-1.1-5-4-5-7.2s2-6.1 5-7.2l37.7-14.1zm295.2 73.9L419.2 227.2l-39.6-39.6 105-105L461.4 59.3l-105 105-39.6-39.6L427.4 14.1c18.7-18.7 49.1-18.7 67.9 0l34.6 34.6c18.7 18.7 18.7 49.1 0 67.9zM7.5 117.2L64 96 85.2 39.5C86.9 35 91.2 32 96 32s9.1 3 10.8 7.5L128 96l56.5 21.2c4.5 1.7 7.5 6 7.5 10.8s-3 9.1-7.5 10.8L128 160l-21.2 56.5c-1.7 4.5-6 7.5-10.8 7.5s-9.1-3-10.8-7.5L64 160 7.5 138.8C3 137.1 0 132.8 0 128s3-9.1 7.5-10.8zm352 256L416 352l21.2-56.5c1.7-4.5 6-7.5 10.8-7.5s9.1 3 10.8 7.5L480 352l56.5 21.2c4.5 1.7 7.5 6 7.5 10.8s-3 9.1-7.5 10.8L480 416l-21.2 56.5c-1.7 4.5-6 7.5-10.8 7.5s-9.1-3-10.8-7.5L416 416l-56.5-21.2c-4.5-1.7-7.5-6-7.5-10.8s3-9.1 7.5-10.8z", "M419.2 227.2L316.7 124.7 46.1 395.4c-18.7 18.7-18.7 49.1 0 67.9l34.6 34.6c18.7 18.7 49.1 18.7 67.9 0L419.2 227.2z"]],
    "lambda": [448, 512, [], "f66e", ["M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96H140.2l16.4 32.7L18.8 434.9c-7.3 16.1-.1 35.1 16 42.3s35.1 .1 42.3-16L193.5 202.6l121 242c10.8 21.7 33 35.4 57.2 35.4H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H371.8L197.5 67.4C186.6 45.7 164.5 32 140.2 32H32z", ""]],
    "e": [320, 512, [101], "45", ["M64 32C28.7 32 0 60.7 0 96V256 416c0 35.3 28.7 64 64 64H288c17.7 0 32-14.3 32-32s-14.3-32-32-32H64V288H224c17.7 0 32-14.3 32-32s-14.3-32-32-32H64V96H288c17.7 0 32-14.3 32-32s-14.3-32-32-32H64z", ""]],
    "pizza": [576, 512, [127829], "f817", ["M108.9 403.1c81.2 81.2 212.9 81.2 294.2 0L278.6 278.6c-12.5-12.5-12.5-32.8 0-45.3L403.1 108.9c-81.2-81.2-212.9-81.2-294.2 0s-81.2 212.9 0 294.2zM128 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM479.6 120.4L366.6 233.4c-12.5 12.5-12.5 32.8 0 45.3l112 112c31.6-36.7 50.5-84.4 50.3-136.6c-.2-51-18.8-97.6-49.4-133.6zM416 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M403.1 403.1C365.4 440.7 313.4 464 256 464C141.1 464 48 370.9 48 256S141.1 48 256 48c57.4 0 109.4 23.3 147.1 60.9l11.3-11.3C426.9 85.1 427 64.7 413 53.8C369.7 20.1 315.2 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c59.2 0 113.7-20.1 157-53.8c13.9-10.9 13.8-31.3 1.3-43.8l-11.3-11.3zm75.5-12.5l9.9 9.9c13.1 13.1 34.7 12.5 44.9-3C560.3 357 576 308.3 576 256s-15.7-101-42.6-141.5c-10.2-15.4-31.8-16-44.9-3l-9.9 9.9C509.4 157.7 528 204.7 528 256s-18.6 98.3-49.4 134.6zM192 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM128 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM256 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM416 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", ["M64 84v34l-45.5 7.1C8.8 126.6 0 119.1 0 109.3C0 101.6 5.5 95 13.1 93.6L64 84zm0 58v34H16.2C7.3 176 0 168.7 0 159.7c0-8.8 7-16 15.7-16.2L64 142zm160 34V137l263.6-8.2C501 128.3 512 139 512 152.4c0 13-10.6 23.6-23.6 23.6H224zm0-83V54L484.4 5.2C498.7 2.5 512 13.5 512 28.1c0 11.5-8.4 21.2-19.7 23L224 93z", "M192 40c0-13.3-10.7-24-24-24s-24 10.7-24 24V224H112V56c0-13.3-10.7-24-24-24S64 42.7 64 56V224H33.6C15.4 224 .9 239.3 2 257.5c5.4 91.7 59.7 169.7 136.4 209.7l1.2 9.7c2.5 20 19.5 35 39.7 35H332.7c20.2 0 37.2-15 39.7-35l1.2-9.7c76.8-40 131-118 136.4-209.7c1.1-18.2-13.4-33.5-31.6-33.5H192V40z"]],
    "h3": [640, 512, [], "f315", ["M32 64c17.7 0 32 14.3 32 32V224H256V96c0-17.7 14.3-32 32-32s32 14.3 32 32V256 416c0 17.7-14.3 32-32 32s-32-14.3-32-32V288H64V416c0 17.7-14.3 32-32 32s-32-14.3-32-32V256 96C0 78.3 14.3 64 32 64z", "M368 96c0-17.7 14.3-32 32-32H592c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-89.5 89.5C589 210.8 640 263.4 640 328c0 66.3-53.7 120-120 120H455.4c-43 0-79.7-31.1-86.8-73.5l-.2-1.2c-2.9-17.4 8.9-33.9 26.3-36.8s33.9 8.9 36.8 26.3l.2 1.2c1.9 11.6 11.9 20.1 23.7 20.1H520c30.9 0 56-25.1 56-56s-25.1-56-56-56H448c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L514.7 128H400c-17.7 0-32-14.3-32-32z"]],
    "pen-clip": [512, 512, ["pen-alt"], "f305", ["M362.7 19.3c25-25 65.5-25 90.5 0l39.4 39.4c25 25 25 65.5 0 90.5L417.9 224 288 94.1l74.7-74.7z", "M207 114.9c9.4-9.4 24.6-9.4 33.9 0L254.1 128 99.5 282.5c-48 48-80.8 109.2-94.1 175.8l-5 25c-1.6 7.9 .9 16 6.6 21.7s13.8 8.1 21.7 6.6l25-5c66.6-13.3 127.8-46.1 175.8-94.1L401 241l17-17-1-1-16-16-96-96-17-17L274.9 81c-28.1-28.1-73.7-28.1-101.8 0L71 183c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L207 114.9z"]],
    "bridge-circle-exclamation": [640, 512, [], "e4ca", ["M32 64c0-17.7 14.3-32 32-32H576c17.7 0 32 14.3 32 32s-14.3 32-32 32H536v64h72v72.2C577.6 207.1 538.5 192 496 192c-69.1 0-128.9 39.8-157.7 97.7c-5.9-1.1-12-1.7-18.3-1.7c-53 0-96 43-96 96v64c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V384c0-53-43-96-96-96V160h72V96H64C46.3 96 32 81.7 32 64zM408 96v64h80V96H408zm-48 64V96H280v64h80zM152 96v64h80V96H152z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16V288z"]],
    "badge-percent": [512, 512, [], "f646", ["M256 0c36.8 0 68.8 20.7 84.9 51.1C373.8 41 411 49 437 75s34 63.3 23.9 96.1C491.3 187.2 512 219.2 512 256s-20.7 68.8-51.1 84.9C471 373.8 463 411 437 437s-63.3 34-96.1 23.9C324.8 491.3 292.8 512 256 512s-68.8-20.7-84.9-51.1C138.2 471 101 463 75 437s-34-63.3-23.9-96.1C20.7 324.8 0 292.8 0 256s20.7-68.8 51.1-84.9C41 138.2 49 101 75 75s63.3-34 96.1-23.9C187.2 20.7 219.2 0 256 0zM192 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM337 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L175 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L337 209z", "M224 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM337 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L175 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L337 209z"]],
    "user": [448, 512, [128100, 62144], "f007", ["M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128z", "M0 482.3C0 383.8 79.8 304 178.3 304h91.4C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7H29.7C13.3 512 0 498.7 0 482.3z"]],
    "sensor": [448, 512, [], "e028", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm48 88V264c0 13.3-10.7 24-24 24s-24-10.7-24-24V120c0-13.3 10.7-24 24-24s24 10.7 24 24zm96 0V264c0 13.3-10.7 24-24 24s-24-10.7-24-24V120c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M88 96c13.3 0 24 10.7 24 24V264c0 13.3-10.7 24-24 24s-24-10.7-24-24V120c0-13.3 10.7-24 24-24zm96 0c13.3 0 24 10.7 24 24V264c0 13.3-10.7 24-24 24s-24-10.7-24-24V120c0-13.3 10.7-24 24-24z"]],
    "comma": [192, 512, [], "2c", ["M160 350.4V349c0-33.7-27.3-61-61-61c-29.5 0-54.8 21.1-60.1 50.1l-22.2 122c-.5 2.6-.7 5.2-.7 7.9v8.2C16 495.9 32.1 512 51.9 512c12.5 0 24.1-6.5 30.6-17.2L150.8 383c6-9.8 9.2-21.1 9.2-32.6z", ""]],
    "school-circle-check": [640, 512, [], "e56b", ["M302.2 5.4c10.7-7.2 24.8-7.2 35.5 0L473.7 96H592c26.5 0 48 21.5 48 48V266.8C608.1 221.6 555.5 192 496 192c-38.5 0-74.2 12.4-103.1 33.4c9.6-14.1 15.1-31.1 15.1-49.4c0-48.6-39.4-88-88-88s-88 39.4-88 88s39.4 88 88 88c15.6 0 30.2-4 42.9-11.1c-23.4 27.1-38.8 61.4-42.2 99.1h-.5l-.3 0c-35.3 0-64 28.7-64 64v96h64v0H48c-26.5 0-48-21.5-48-48V144c0-26.5 21.5-48 48-48H166.3L302.2 5.4zM80 208v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V208c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16zm0 128v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V336c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16zM336 144v16h16c8.8 0 16 7.2 16 16s-7.2 16-16 16H320c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16s16 7.2 16 16z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "toilet-paper-under": [512, 512, ["toilet-paper-reverse"], "e2a0", ["M96 384C43 384 0 298 0 192S43 0 96 0H416c-53 0-96 86-96 192s43 192 96 192H128 96zM80 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm64 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z", "M320 195.9c1 104.2 43.6 188.1 96 188.1H160v80c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V192C512 86 469 0 416 0s-96 86-96 192c0 1.3 0 2.6 0 3.9zM448 192c0 35.3-14.3 64-32 64s-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64zM80 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm64 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "light-emergency": [448, 512, [], "e41f", ["M224 32C135.6 32 64 103.6 64 192V352H384V192c0-88.4-71.6-160-160-160zM144 192c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80z", "M32 352c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H416c17.7 0 32-14.3 32-32V384c0-17.7-14.3-32-32-32H32z"]],
    "arrow-down-to-arc": [512, 512, [], "e4ae", ["M448 256c0 106-86 192-192 192S64 362 64 256c0-17.7-14.3-32-32-32s-32 14.3-32 32C0 397.4 114.6 512 256 512s256-114.6 256-256c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M390.6 185.4c12.5 12.5 12.5 32.8 0 45.3l-112 112c-12.5 12.5-32.8 12.5-45.3 0l-112-112c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 242.7 224 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 210.7 57.4-57.4c12.5-12.5 32.8-12.5 45.3 0z"]],
    "dumpster": [576, 512, [], "f793", ["M140.5 32H49.7c-10.5 0-19.8 6.9-22.9 16.9L.9 133c-.6 2-.9 4.1-.9 6.1C0 150.7 9.3 160 20.9 160h94L140.5 32zm7 128H272V32H173.1L147.5 160zM304 32V160H428.5L402.9 32H304zm131.5 0l25.6 128h94c11.5 0 20.9-9.3 20.9-20.9c0-2.1-.3-4.1-.9-6.1L549.2 48.9C546.1 38.9 536.8 32 526.3 32H435.5z", "M64 448L44 288H32c-17.7 0-32-14.3-32-32s14.3-32 32-32h4l-4-32H544l-4 32h4c17.7 0 32 14.3 32 32s-14.3 32-32 32H532L512 448c0 17.7-14.3 32-32 32s-32-14.3-32-32H128c0 17.7-14.3 32-32 32s-32-14.3-32-32z"]],
    "van-shuttle": [640, 512, [128656, "shuttle-van"], "f5b6", ["M160 480a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm320 0a80 80 0 1 0 0-160 80 80 0 1 0 0 160z", "M64 104c0-4.4 3.6-8 8-8h88v96H64V104zm482 88H384V96h81.1L546 192zm-226 0H224V96h96v96zM72 32C32.2 32 0 64.2 0 104V336c0 26.5 21.5 48 48 48h1.1c7.8-54.3 54.4-96 110.9-96s103.1 41.7 110.9 96h98.3c7.8-54.3 54.4-96 110.9-96s103.1 41.7 110.9 96H592c26.5 0 48-21.5 48-48V227.7c0-15.1-5.3-29.7-15-41.2L514.1 54.8C501.9 40.3 484 32 465.1 32H352 192 72z"]],
    "building-user": [640, 512, [], "e4da", ["M0 48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V271.8v95.9c-38.2 21.4-64 62.3-64 109.2c0 12.9 3.6 24.9 9.9 35.1H240V432c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-26.5 0-48-21.5-48-48V48zM80 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H80zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H272zM64 112v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H176zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z", "M496 352a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm-50.9 32c-51.4 0-93.1 41.7-93.1 93.1c0 19.3 15.6 34.9 34.9 34.9H605.1c19.3 0 34.9-15.6 34.9-34.9c0-51.4-41.7-93.1-93.1-93.1H445.1z"]],
    "light-switch": [384, 512, [], "e017", ["M288 272H96V240H288v32z", "M0 64C0 28.7 28.7 0 64 0H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zm96 96V352c0 35.3 28.7 64 64 64h64c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H160c-35.3 0-64 28.7-64 64zM208 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm0 416a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "square-caret-left": [448, 512, ["caret-square-left"], "f191", ["M0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416zM128 256c0-6.7 2.8-13 7.7-17.6l112-104c7-6.5 17.2-8.2 25.9-4.4s14.4 12.5 14.4 22l0 208c0 9.5-5.7 18.2-14.4 22s-18.9 2.1-25.9-4.4l-112-104c-4.9-4.5-7.7-10.9-7.7-17.6z", "M135.7 238.4c-4.9 4.5-7.7 10.9-7.7 17.6s2.8 13 7.7 17.6l112 104c7 6.5 17.2 8.2 25.9 4.4s14.4-12.5 14.4-22l0-208c0-9.5-5.7-18.2-14.4-22s-18.9-2.1-25.9 4.4l-112 104z"]],
    "highlighter": [576, 512, [], "f591", ["M360.7 360.7L183.3 183.3l-35.7 26.3c-12.3 9-19.5 23.4-19.5 38.6V320l0 0L70.6 377.4c-12.5 12.5-12.5 32.8 0 45.3l50.7 50.7c12.5 12.5 32.8 12.5 45.3 0L224 416h71.7c15.3 0 29.6-7.2 38.6-19.5l26.3-35.7z", "M360.7 360.7L183.3 183.3 420.6 8.4C428 2.9 437 0 446.2 0c11.4 0 22.4 4.5 30.5 12.6l54.8 54.8c8.1 8.1 12.6 19 12.6 30.5c0 9.2-2.9 18.2-8.4 25.6L360.7 360.7zM7 466.3l56-56c1.5 4.5 4.1 8.7 7.6 12.2l50.7 50.7c3.6 3.6 7.8 6.1 12.2 7.6l-24 24c-4.5 4.5-10.6 7-17 7H24c-13.3 0-24-10.7-24-24v-4.7c0-6.4 2.5-12.5 7-17z"]],
    "wave-pulse": [640, 512, ["heart-rate"], "f5f8", ["M319.1 0c14.8-.4 27.9 9.3 31.8 23.6l74 271.2 17.7-35.4c10.8-21.7 33-35.4 57.2-35.4H608c17.7 0 32 14.3 32 32s-14.3 32-32 32H499.8L444.6 398.3c-5.9 11.9-18.6 18.8-31.8 17.5s-24.2-10.6-27.7-23.4L323.7 167.3 255.3 486.7c-3.1 14.4-15.5 24.8-30.2 25.3s-27.8-9.1-31.8-23.2L135.9 288H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H135.9c28.6 0 53.7 18.9 61.5 46.4L219.6 348 288.7 25.3C291.8 10.9 304.4 .4 319.1 0z", ""]],
    "key": [512, 512, [128273], "f084", ["M168.3 229.7L282.3 343.7l0 0s0 0 0 0L249 377c-4.5 4.5-10.6 7-17 7H192v40c0 13.3-10.7 24-24 24H128v40c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V408c0-6.4 2.5-12.5 7-17L168.3 229.7s0 0 0 0l0 0z", "M168.3 229.7L282.3 343.7l0 0c16.9 5.4 35 8.3 53.7 8.3c97.2 0 176-78.8 176-176S433.2 0 336 0S160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7l0 0zM336 136a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"]],
    "hat-santa": [640, 512, [], "f7a7", ["M560 160c-12.7 0-23 9.8-23.9 22.2c-9.4-8.1-23.7-7.7-32.6 1.2s-9.4 23.2-1.2 32.6C489.8 217 480 227.3 480 240s9.8 23 22.2 23.9c-8.1 9.4-7.7 23.7 1.2 32.6s23.2 9.4 32.6 1.2C537 310.2 547.3 320 560 320s23-9.8 23.9-22.2c9.4 8.1 23.7 7.7 32.6-1.2s9.4-23.2 1.2-32.6C630.2 263 640 252.7 640 240s-9.8-23-22.2-23.9c8.1-9.4 7.7-23.7-1.2-32.6s-23.2-9.4-32.6-1.2C583 169.8 572.7 160 560 160zM64 352c-35.3 0-64 28.7-64 64s28.7 64 64 64H448c35.3 0 64-28.7 64-64s-28.7-64-64-64H64z", "M64 352l85.7-214.2C175.2 73.9 237.1 32 305.9 32c49.5 0 96.5 21.8 128.5 59.6l74.3 87.8c-1.9 1.1-3.7 2.4-5.3 4c-8.9 8.9-9.4 23.2-1.2 32.6c-3.9 .3-7.5 1.5-10.7 3.4L402 192.6c-1.3-.4-2.7-.6-4-.6h-.8c-7.3 0-13.2 5.9-13.2 13.2c0 1.8 .4 3.7 1.1 5.4L448 352H64z"]],
    "tamale": [320, 512, [129748], "e451", ["M48.1 18.3C72.3 8.6 108.4 0 160 0s87.7 8.6 111.9 18.3c12.1 4.8 21 9.9 27.4 14.1c12.7 8.5 23.1 20.4 20.3 36.9L291.1 240H233.4L248 72.7c.4-4.4-2.9-8.3-7.3-8.7s-8.3 2.9-8.7 7.3L217.4 240H168l0-176c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 176H102.6L88 71.3c-.4-4.4-4.3-7.7-8.7-7.3s-7.7 4.3-7.3 8.7L86.6 240H28.9L.4 69.3C-2.3 52.8 8.1 40.8 20.8 32.4c6.3-4.2 15.3-9.3 27.4-14.1zM28.9 272H86.6L72 439.3c-.4 4.4 2.9 8.3 7.3 8.7s8.3-2.9 8.7-7.3l9.9-113.3c1.1 2.1 2.6 3.9 4.6 5.4c7.1 5.3 17.1 3.9 22.4-3.2L152 293.3 152 448c0 4.4 3.6 8 8 8s8-3.6 8-8l0-154.7 27.2 36.3c5.3 7.1 15.3 8.5 22.4 3.2c2-1.5 3.5-3.3 4.6-5.4L232 440.7c.4 4.4 4.3 7.7 8.7 7.3s7.7-4.3 7.3-8.7L233.4 272h57.7l28.4 170.7c1.7 10.2-1.6 20.6-8.9 27.9l0 0c-10.6 10.5-25.1 17.6-38.7 23C247.7 503.4 211.6 512 160 512s-87.7-8.6-111.9-18.3c-13.7-5.5-28.1-12.5-38.7-23l0 0c-7.3-7.3-10.6-17.7-8.9-27.9L28.9 272zm191.8 38.2L192 272h25.4l3.3 38.2zM102.6 272H128L99.3 310.2l3.3-38.2z", "M24 240c-8.8 0-16 7.2-16 16s7.2 16 16 16H128L99.2 310.4c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2L160 282.7l35.2 46.9c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4L192 272H296c8.8 0 16-7.2 16-16s-7.2-16-16-16H160 24z"]],
    "box-check": [448, 512, [], "f467", ["M93.7 32C75.5 32 58.9 42.3 50.7 58.5L0 160H208V32H93.7zM240 32V160H448L397.3 58.5C389.1 42.3 372.5 32 354.3 32H240z", "M448 160H240V32H208V160H0V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V160zM337 265L209 393c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L303 231c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]],
    "bullhorn": [512, 512, [128226, 128363], "f0a1", ["M480 32c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9L381.7 53c-48 48-113.1 75-181 75H192v32 32 96 32 32h8.7c67.9 0 133 27 181 75l43.6 43.6c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6V32z", "M0 192c0-35.3 28.7-64 64-64H192V320v32V480c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32l0-128c-35.3 0-64-28.7-64-64V192zm512 48c0 27.9-13.4 51.6-32 60.4V179.6c18.6 8.8 32 32.5 32 60.4z"]],
    "steak": [576, 512, [129385], "f824", ["M368 0c-38.3 0-72.3 12.4-99.2 37.4c-23.5 21.9-36.3 48.9-44.1 66.5c-4.4 10.1-8 18.9-11.2 26.6c-10.4 25.1-16.2 39.1-30 52.9c-23.1 23.1-50.4 36.9-77.7 50.7c-21.8 11-43.6 22.1-63.3 37.8C17.8 291.7 0 321.4 0 360c0 84.3 73.4 120.1 110 132.7c43.5 15 93.3 19.3 130 19.3c81.7 0 162.1-30.8 222.6-75.8C520.9 392.8 576 323.9 576 240c0-60.4-23.6-117.6-57.5-160C485.7 39 433 0 368 0zM236.3 448C167.4 448 64 430.5 64 369.5c0-29.8 19.8-38.3 51.7-51.9c31.1-13.3 73.6-31.5 120.6-79c28.1-28.5 41.9-62.8 54.2-93.4C308.4 100.7 323.1 64 374.2 64C443.1 64 512 151.3 512 238.5C512 343.3 370.9 448 236.3 448z", "M236.3 448C167.4 448 64 430.5 64 369.5c0-29.8 19.8-38.3 51.7-51.9c31.1-13.3 73.6-31.5 120.6-79c28.1-28.5 41.9-62.8 54.2-93.4C308.4 100.7 323.1 64 374.2 64C443.1 64 512 151.3 512 238.5C512 343.3 370.9 448 236.3 448zM384 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "location-crosshairs-slash": [640, 512, ["location-slash"], "f603", ["M509.3 288c-4 24-12.5 46.5-24.6 66.6l-51-40c9.1-17.6 14.2-37.5 14.2-58.7c0-70.7-57.3-128-128-128c-32.2 0-61.7 11.9-84.2 31.5l-51-40C212.4 92.3 248.1 73.3 288 66.7V32c0-17.7 14.3-32 32-32s32 14.3 32 32V66.7C432.4 80.1 495.9 143.6 509.3 224H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H509.3zM400 256c0 9.9-1.8 19.4-5.1 28.2L274.7 190c12.9-8.8 28.5-14 45.3-14c44.2 0 80 35.8 80 80zM358.2 378.2l56.8 44.7c-19.2 10.9-40.4 18.6-62.9 22.4V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V445.3C207.6 431.9 144.1 368.4 130.7 288H96c-17.7 0-32-14.3-32-32s14.3-32 32-32h34.7c1.2-7.2 2.8-14.3 4.8-21.3l56.8 44.7c-.2 2.8-.3 5.6-.3 8.5c0 70.7 57.3 128 128 128c13.3 0 26.1-2 38.2-5.8z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "person-dolly": [512, 512, [], "f4d0", ["M247.3 186.2c-3.2-12.9-16.2-20.7-29.1-17.5s-20.7 16.2-17.5 29.1l49.6 198.4c-16 11.6-26.3 30.5-26.3 51.7c0 35.3 28.7 64 64 64c32.3 0 59.1-24 63.4-55.1l134.4-33.6c12.9-3.2 20.7-16.2 17.5-29.1s-16.2-20.7-29.1-17.5L339.7 410.3c-10-13.7-25.3-23.3-42.8-25.7L247.3 186.2zM272 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm85.4-71.8L449 353.4c17.1-4.3 27.6-21.7 23.3-38.8L449.4 223c-4.3-17.1-21.7-27.6-38.8-23.3L319 222.6c-17.1 4.3-27.6 21.7-23.3 38.8L318.6 353c4.3 17.1 21.7 27.6 38.8 23.3z", "M80 96A48 48 0 1 0 80 0a48 48 0 1 0 0 96zM96 306.7V241.7l16.6 24.9c8.9 13.4 23.9 21.4 39.9 21.4h70.7l-16-64H161.1l-42.6-64c-13.3-20-35.8-32-59.9-32C26.2 128 0 154.2 0 186.6v88.1c0 17 6.7 33.3 18.7 45.3l79.4 79.4 14.3 85.9c2.9 17.4 19.4 29.2 36.8 26.3s29.2-19.4 26.3-36.8l-15.2-90.9c-1.6-9.9-6.3-19-13.4-26.1l-51-51zM0 346.5L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32v0V410.5l-64-64z"]],
    "globe": [512, 512, [127760], "f0ac", ["M352 256c0 22.2-1.2 43.6-3.3 64H163.3c-2.2-20.4-3.3-41.8-3.3-64s1.2-43.6 3.3-64H348.7c2.2 20.4 3.3 41.8 3.3 64zm28.8-64H503.9c5.3 20.5 8.1 41.9 8.1 64s-2.8 43.5-8.1 64H380.8c2.1-20.6 3.2-42 3.2-64s-1.1-43.4-3.2-64zm112.6-32H376.7c-10-63.9-29.8-117.4-55.3-151.6c78.3 20.7 142 77.5 171.9 151.6zm-149.1 0H167.7c6.1-36.4 15.5-68.6 27-94.7c10.5-23.6 22.2-40.7 33.5-51.5C239.4 3.2 248.7 0 256 0s16.6 3.2 27.8 13.8c11.3 10.8 23 27.9 33.5 51.5c11.6 26 20.9 58.2 27 94.7zm-209 0H18.6C48.6 85.9 112.2 29.1 190.6 8.4C165.1 42.6 145.3 96.1 135.3 160zM8.1 192H131.2c-2.1 20.6-3.2 42-3.2 64s1.1 43.4 3.2 64H8.1C2.8 299.5 0 278.1 0 256s2.8-43.5 8.1-64zM194.7 446.6c-11.6-26-20.9-58.2-27-94.6H344.3c-6.1 36.4-15.5 68.6-27 94.6c-10.5 23.6-22.2 40.7-33.5 51.5C272.6 508.8 263.3 512 256 512s-16.6-3.2-27.8-13.8c-11.3-10.8-23-27.9-33.5-51.5zM135.3 352c10 63.9 29.8 117.4 55.3 151.6C112.2 482.9 48.6 426.1 18.6 352H135.3zm358.1 0c-30 74.1-93.6 130.9-171.9 151.6c25.5-34.2 45.2-87.7 55.3-151.6H493.4z", "M344.3 352H167.7c6.1 36.4 15.5 68.6 27 94.6c10.5 23.6 22.2 40.7 33.5 51.5C239.4 508.8 248.7 512 256 512s16.6-3.2 27.8-13.8c11.3-10.8 23-27.9 33.5-51.5c11.6-26 20.9-58.2 27-94.6zM321.4 503.6c-20.9 5.5-42.8 8.4-65.4 8.4s-44.6-2.9-65.4-8.4c-25.5-34.2-45.2-87.7-55.3-151.6H18.6c-4.2-10.3-7.7-21-10.5-32H131.2c-2.1-20.6-3.2-42-3.2-64s1.1-43.4 3.2-64H8.1c2.8-11 6.4-21.7 10.5-32H135.3c10-63.9 29.8-117.4 55.3-151.6C211.4 2.9 233.4 0 256 0c-7.3 0-16.6 3.2-27.8 13.8c-11.3 10.8-23 27.9-33.5 51.5c-11.6 26-20.9 58.2-27 94.7H344.3c-6.1-36.4-15.5-68.6-27-94.7c-10.5-23.6-22.2-40.7-33.5-51.5C272.6 3.2 263.3 0 256 0c22.6 0 44.6 2.9 65.4 8.4c25.5 34.2 45.2 87.7 55.3 151.6H493.4c4.2 10.3 7.7 21 10.5 32H380.8c2.1 20.6 3.2 42 3.2 64s-1.1 43.4-3.2 64H503.9c-2.8 11-6.4 21.7-10.5 32H376.7c-10 63.9-29.8 117.4-55.3 151.6zM352 256c0-22.2-1.2-43.6-3.3-64H163.3c-2.2 20.4-3.3 41.8-3.3 64s1.2 43.6 3.3 64H348.7c2.2-20.4 3.3-41.8 3.3-64z"]],
    "synagogue": [640, 512, [128333], "f69b", ["M160 273.4L99.3 212.7c-6.2-6.2-16.4-6.2-22.6 0L14.1 275.3c-9 9-14.1 21.2-14.1 33.9V448c0 35.3 28.7 64 64 64h96V273.4zM480 512H592c26.5 0 48-21.5 48-48V309.3c0-12.7-5.1-24.9-14.1-33.9l-62.6-62.6c-6.2-6.2-16.4-6.2-22.6 0L480 273.4V512z", "M330.2 3.7c-5.9-4.9-14.6-4.9-20.5 0l-121 100.8C170.5 119.7 160 142.2 160 166V496v16h16 80V384c0-35.3 28.7-64 64-64s64 28.7 64 64V512h80 16V496 166c0-23.7-10.5-46.3-28.8-61.5L330.2 3.7zM313 124.3c3.1-5.4 10.9-5.4 13.9 0l15.9 28.1 32.3-.3c6.2-.1 10.1 6.7 7 12.1L365.7 192l16.4 27.8c3.2 5.4-.7 12.1-7 12.1l-32.3-.3L327 259.7c-3.1 5.4-10.9 5.4-13.9 0l-15.9-28.1-32.3 .3c-6.2 .1-10.1-6.7-7-12.1L274.3 192l-16.4-27.8c-3.2-5.4 .7-12.1 7-12.1l32.3 .3L313 124.3z"]],
    "file-chart-column": [384, 512, ["file-chart-line"], "f659", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM216 248c0-13.3-10.7-24-24-24s-24 10.7-24 24V424c0 13.3 10.7 24 24 24s24-10.7 24-24V248zm88 64c0-13.3-10.7-24-24-24s-24 10.7-24 24V424c0 13.3 10.7 24 24 24s24-10.7 24-24V312zM128 376c0-13.3-10.7-24-24-24s-24 10.7-24 24v48c0 13.3 10.7 24 24 24s24-10.7 24-24V376z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM216 248c0-13.3-10.7-24-24-24s-24 10.7-24 24V424c0 13.3 10.7 24 24 24s24-10.7 24-24V248zm88 64c0-13.3-10.7-24-24-24s-24 10.7-24 24V424c0 13.3 10.7 24 24 24s24-10.7 24-24V312zM128 376c0-13.3-10.7-24-24-24s-24 10.7-24 24v48c0 13.3 10.7 24 24 24s24-10.7 24-24V376z"]],
    "person-half-dress": [320, 512, [], "e548", ["M160 128V352h8V480c0 17.7 14.3 32 32 32s32-14.3 32-32V256.9l28.6 47.5c9.1 15.1 28.8 20 43.9 10.9s20-28.8 10.9-43.9l-58.3-97c-17.4-28.9-48.6-46.6-82.3-46.6H160zm0-32c26.5 0 48-21.5 48-48s-21.5-48-48-48c0 0 0 0 0 0V96s0 0 0 0z", "M160 96V0s0 0 0 0c-26.5 0-48 21.5-48 48s21.5 48 48 48c0 0 0 0 0 0zm0 32h-5.8c-39.3 0-75.7 20.6-96 54.3L4.6 271.5c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9l33.9-56.3L55 362.9C51.6 373.3 59.3 384 70.2 384H88v96c0 17.7 14.3 32 32 32s32-14.3 32-32V384h8V128z"]],
    "folder-image": [512, 512, [], "e18a", ["M448 480H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H192c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64zM176 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm120 0c-8 0-15.5 4-20 10.7l-56 84L202.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6h80 48H392c8.9 0 17-4.9 21.2-12.7s3.7-17.3-1.2-24.6l-96-144C311.5 228 304 224 296 224z", "M296 224c8 0 15.5 4 20 10.7l96 144c4.9 7.4 5.4 16.8 1.2 24.6S400.9 416 392 416H248 200 120c-9.2 0-17.6-5.3-21.6-13.6s-2.9-18.2 2.9-25.4l64-80c4.6-5.7 11.4-9 18.7-9s14.2 3.3 18.7 9l17.3 21.6 56-84C280.5 228 288 224 296 224z"]],
    "calendar-pen": [512, 512, ["calendar-edit"], "f333", ["M480 192H32V464c0 26.5 21.5 48 48 48H432c26.5 0 48-21.5 48-48V192zM340.8 267c14.7 14.7 14.7 38.6 0 53.3l-14.9 14.9L272.6 282 287.5 267c14.7-14.7 38.6-14.7 53.3 0zM178.1 376.5L250 304.6l53.3 53.3-71.9 71.9c-4.1 4.1-9.2 7-14.9 8.4l-36.6 9.2c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l9.2-36.6c1.4-5.6 4.3-10.8 8.4-14.9z", "M160 0c-17.7 0-32 14.3-32 32V64H80c-26.5 0-48 21.5-48 48v80H480V112c0-26.5-21.5-48-48-48H384V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V64H192V32c0-17.7-14.3-32-32-32zM340.8 267c-14.7-14.7-38.6-14.7-53.3 0L272.6 282l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3zM178.1 376.5c-4.1 4.1-7 9.2-8.4 14.9L160.5 428c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L250 304.6l-71.9 71.9z"]],
    "road-bridge": [640, 512, [], "e563", ["M288 96H32C14.3 96 0 110.3 0 128s14.3 32 32 32H72v64H0v96c53 0 96 43 96 96v64c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V416c0-53 43-96 96-96V224H248V160h40V96zM120 160h80v64H120V160z", "M608 0H352c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32zM504 224v64c0 13.3-10.7 24-24 24s-24-10.7-24-24V224c0-13.3 10.7-24 24-24s24 10.7 24 24zM480 360c13.3 0 24 10.7 24 24v64c0 13.3-10.7 24-24 24s-24-10.7-24-24V384c0-13.3 10.7-24 24-24zM504 64v64c0 13.3-10.7 24-24 24s-24-10.7-24-24V64c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "face-smile-tear": [512, 512, [], "e393", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm141.5 67.9c-6.7 5.8-7.4 15.9-1.6 22.6c22.2 25.7 61 53.5 116.1 53.5c8.8 0 16-7.2 16-16s-7.2-16-16-16c-43.4 0-74-21.8-91.9-42.5c-5.8-6.7-15.9-7.4-22.6-1.6zM352 416c26.5 0 48-21 48-47c0-20-28.6-60.4-41.6-77.7c-3.2-4.4-9.6-4.4-12.8 0C332.4 308.6 304 349 304 369c0 26 21.5 47 48 47zM208.4 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM400 369c0 26-21.5 47-48 47s-48-21-48-47c0-20 28.4-60.4 41.6-77.7c3.2-4.4 9.6-4.4 12.8 0C371.4 308.6 400 349 400 369zM336.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "message-plus": [512, 512, ["comment-alt-plus"], "f4a8", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zM232 296c0 13.3 10.7 24 24 24s24-10.7 24-24V232h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V120c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64v64z", "M232 232v64c0 13.3 10.7 24 24 24s24-10.7 24-24V232h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V120c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64z"]],
    "location-arrow": [448, 512, [], "f124", ["M429.6 92.1c4.9-11.9 2.1-25.6-7-34.7s-22.8-11.9-34.7-7l-352 144c-14.2 5.8-22.2 20.8-19.3 35.8s16.1 25.8 31.4 25.8H224V432c0 15.3 10.8 28.4 25.8 31.4s30-5.1 35.8-19.3l144-352z", ""]],
    "c": [384, 512, [99], "43", ["M329.1 142.9c-62.5-62.5-155.8-62.5-218.3 0s-62.5 163.8 0 226.3s155.8 62.5 218.3 0c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3c-87.5 87.5-221.3 87.5-308.8 0s-87.5-229.3 0-316.8s221.3-87.5 308.8 0c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0z", ""]],
    "tablet-button": [448, 512, [], "f10a", ["M448 384H0v64c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V384zM224 416a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M0 64C0 28.7 28.7 0 64 0H384c35.3 0 64 28.7 64 64V384H0V64z"]],
    "rectangle-history-circle-user": [640, 512, [], "e4a4", ["M394.8 512C349.5 480.1 320 427.5 320 368c0-97.2 78.8-176 176-176c2.5 0 5 .1 7.5 .2c-11-19.2-31.8-32.2-55.5-32.2L64 160c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64l330.8 0zM464 104c0-13.3-10.7-24-24-24L72 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l368 0c13.3 0 24-10.7 24-24zM416 24c0-13.3-10.7-24-24-24H120C106.7 0 96 10.7 96 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-32c-30.2 0-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7h65.2c21 0 38.9 13.7 45.1 32.7C553.5 468.1 526.2 480 496 480zm0-192a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "building-lock": [576, 512, [], "e4d6", ["M0 48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V193.6c-19.8 20.2-32 47.9-32 78.4v24.6c-19.1 11.1-32 31.7-32 55.4V480c0 11.7 3.1 22.6 8.6 32H240V432c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-26.5 0-48-21.5-48-48V48zM80 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H80zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H272zM64 112v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H176zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z", "M432 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H384c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "chart-line-up": [512, 512, [], "e0e5", ["M32 32c17.7 0 32 14.3 32 32V400c0 8.8 7.2 16 16 16H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-44.2 0-80-35.8-80-80V64C0 46.3 14.3 32 32 32z", "M406.6 246.6L439 279c15.1 15.1 41 4.4 41-17V152c0-13.3-10.7-24-24-24H345.9c-21.4 0-32.1 25.9-17 41l32.4 32.4L304 258.7l-73.4-73.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L208 253.3l73.4 73.4c12.5 12.5 32.8 12.5 45.3 0l80-80z"]],
    "mailbox": [576, 512, [128234], "f813", ["M512 448H224c35.3 0 64-28.7 64-64V208c0-79.5-64.5-144-144-144H432c79.5 0 144 64.5 144 144V384c0 35.3-28.7 64-64 64zM400 192c-8.8 0-16 7.2-16 16s7.2 16 16 16h48v48c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V208c0-8.8-7.2-16-16-16H464 400z", "M0 208C0 128.5 64.5 64 144 64s144 64.5 144 144V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V208zm64 0c0 8.8 7.2 16 16 16H208c8.8 0 16-7.2 16-16s-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zm336-16h64 32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H464c-8.8 0-16-7.2-16-16V224H400c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "truck-bolt": [640, 512, [], "e3d0", ["M266.3 51.7c5.7 4.8 7.4 12.8 4.1 19.4L233.9 144H288c6.9 0 13 4.4 15.2 10.9s-.1 13.7-5.6 17.9l-128 96c-5.9 4.5-14.2 4.2-19.9-.5s-7.4-12.8-4.1-19.4L182.1 176H128c-6.9 0-13-4.4-15.2-10.9s.1-13.7 5.6-17.9l128-96c5.9-4.5 14.2-4.2 19.9 .5zM96 432a80 80 0 1 1 160 0A80 80 0 1 1 96 432zm288 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z", "M0 48C0 21.5 21.5 0 48 0H368c26.5 0 48 21.5 48 48V96h50.7c17 0 33.3 6.7 45.3 18.7L589.3 192c12 12 18.7 28.3 18.7 45.3V256v32 64c17.7 0 32 14.3 32 32s-14.3 32-32 32H576h-1.1c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96H286.9c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96H48c-26.5 0-48-21.5-48-48V48zM416 256H544V237.3L466.7 160H416v96zM266.3 51.7c-5.7-4.8-13.9-5-19.9-.5l-128 96c-5.5 4.1-7.8 11.3-5.6 17.9s8.3 10.9 15.2 10.9h54.1l-36.4 72.8c-3.3 6.6-1.6 14.7 4.1 19.4s13.9 5 19.9 .5l128-96c5.5-4.1 7.8-11.3 5.6-17.9S294.9 144 288 144H233.9l36.4-72.8c3.3-6.6 1.6-14.7-4.1-19.4z"]],
    "pizza-slice": [512, 512, [], "f818", ["M432 400l0 1.6L20.1 511.5c-5.5 1.5-11.4-.1-15.4-4.1s-5.6-9.9-4.1-15.4L110.4 80l1.6 0c176.7 0 320 143.3 320 320zM208 240a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M169.7 .9c-22.8-1.6-41.9 14-47.5 34.7L110.4 80l1.6 0c176.7 0 320 143.3 320 320l0 1.6 44.4-11.8c20.8-5.5 36.3-24.7 34.7-47.5C498.5 159.5 352.5 13.5 169.7 .9zM208 240a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "money-bill-wave": [576, 512, [], "f53a", ["M512 160c-33.9 0-61.6-26.3-63.9-59.7c-40 .9-83.5 10.5-134.2 23.2c-4.6 1.2-9.4 2.3-14.2 3.6l0 0c-51.1 12.8-110.4 27.8-172.9 28.6C121.5 185.4 95.4 208 64 208V352c33.9 0 61.6 26.3 63.9 59.7c40-.9 83.5-10.5 134.2-23.2c4.7-1.2 9.4-2.3 14.2-3.6l0 0c51.1-12.8 110.4-27.8 172.9-28.6c5.5-29.8 31.6-52.4 63-52.4V160zM288 352c-44.2 0-80-43-80-96s35.8-96 80-96s80 43 80 96s-35.8 96-80 96z", "M0 112.5V422.3c0 18 10.1 35 27 41.3c87 32.5 174 10.3 261-11.9c79.8-20.3 159.6-40.7 239.3-18.9c23 6.3 48.7-9.5 48.7-33.4V89.7c0-18-10.1-35-27-41.3C462 15.9 375 38.1 288 60.3C208.2 80.6 128.4 100.9 48.7 79.1C25.6 72.8 0 88.6 0 112.5zM512 160V304c-31.4 0-57.5 22.6-63 52.4c-62.5 .8-121.8 15.7-172.9 28.6l0 0c-4.8 1.2-9.5 2.4-14.2 3.6c-50.7 12.6-94.1 22.2-134.2 23.2C125.6 378.3 97.9 352 64 352V208c31.4 0 57.5-22.6 63-52.4c62.5-.8 121.8-15.7 172.9-28.6l0 0c4.8-1.2 9.5-2.4 14.2-3.6c50.7-12.6 94.1-22.2 134.2-23.2c2.2 33.3 30 59.7 63.9 59.7z"]],
    "chart-area": [512, 512, ["area-chart"], "f1fe", ["M32 32c17.7 0 32 14.3 32 32V400c0 8.8 7.2 16 16 16H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-44.2 0-80-35.8-80-80V64C0 46.3 14.3 32 32 32z", "M448 352H160c-17.7 0-32-14.3-32-32V236c0-7.8 2.8-15.2 7.9-21.1l79.4-90.8c13-14.8 36.1-14.5 48.7 .6l39.2 47c9 10.8 25.4 11.6 35.4 1.6l21-21c13.2-13.2 34.8-12.4 46.9 1.8L472.3 231c5 5.8 7.7 13.2 7.7 20.8V320c0 17.7-14.3 32-32 32z"]],
    "house-flag": [640, 512, [], "e50d", ["M416 159L276.8 39.7c-12-10.3-29.7-10.3-41.7 0l-224 192C1 240.4-2.7 254.5 2 267.1S18.6 288 32 288H64V480c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V384c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32v96c0 17.7 14.3 32 32 32h64.8c.1 0 .1 0 .2 0h-1V159z", "M512 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V192 512h64V192H624c8.8 0 16-7.2 16-16V48c0-8.8-7.2-16-16-16H512z"]],
    "circle-three-quarters-stroke": [512, 512, [], "e5d4", ["M256 0C397.4 0 512 114.6 512 256H448c0-106-86-192-192-192V0z", "M256 0C114.6 0 0 114.6 0 256S114.6 512 256 512s256-114.6 256-256H288c-17.7 0-32-14.3-32-32V0z"]],
    "person-circle-minus": [576, 512, [], "e540", ["M160 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-8 384V352h16V480c0 17.7 14.3 32 32 32s32-14.3 32-32V256.9l28.6 47.5c1.4 2.3 3.1 4.5 4.9 6.3c7.9-23 20.5-43.9 36.6-61.5l-44.9-74.7c-17.4-28.9-48.6-46.6-82.3-46.6H145.1c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9L88 256.9V480c0 17.7 14.3 32 32 32s32-14.3 32-32z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm64-128l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16H496c8.8 0 16 7.2 16 16s-7.2 16-16 16z"]],
    "scalpel": [512, 512, [], "f61d", ["M169.4 320l-4.7 4.7-160 160c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9c18.1 0 84.1-8.4 145.9-33.1C222.5 454.6 288 410.9 288 336V320H272 176h-6.6z", "M441.2 0c-20.6 0-40.2 9-53.7 24.6L155.9 293.6c-4.1 4.7-5 11.4-2.4 17.1s8.3 9.3 14.5 9.3H300.9c13.9 0 27.1-6 36.3-16.5L493.8 122.9C505.5 109.4 512 92.1 512 74.2V70.8C512 31.7 480.3 0 441.2 0z"]],
    "ban": [512, 512, [128683, "cancel"], "f05e", ["M99.5 144.8L367.2 412.5c17.5-12.5 32.8-27.8 45.3-45.3L144.8 99.5C127.3 112 112 127.3 99.5 144.8z", "M256 64a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 448A256 256 0 1 0 256 0a256 256 0 1 0 0 512z"]],
    "bell-exclamation": [448, 512, [], "f848", ["M224 0c-17.7 0-32 14.3-32 32V51.2C119 66 64 130.6 64 208v18.8c0 47-17.3 92.4-48.5 127.6l-7.4 8.3c-8.4 9.4-10.4 22.9-5.3 34.4S19.4 416 32 416H416c12.6 0 24-7.4 29.2-18.9s3.1-25-5.3-34.4l-7.4-8.3C401.3 319.2 384 273.9 384 226.8V208c0-77.4-55-142-128-156.8V32c0-17.7-14.3-32-32-32zM192 320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm56-184v96c0 13.3-10.7 24-24 24s-24-10.7-24-24V136c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M224 112c-13.3 0-24 10.7-24 24v96c0 13.3 10.7 24 24 24s24-10.7 24-24V136c0-13.3-10.7-24-24-24zm32 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm13.3 173.3c12-12 18.7-28.3 18.7-45.3H224 160c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7z"]],
    "circle-bookmark": [512, 512, ["bookmark-circle"], "e100", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 176c0-26.5 21.5-48 48-48h96c26.5 0 48 21.5 48 48V368c0 6.2-3.5 11.8-9.1 14.4s-12.1 1.9-16.9-1.9l-70-56-70 56c-4.8 3.8-11.4 4.6-16.9 1.9s-9.1-8.3-9.1-14.4V176z", "M208 128c-26.5 0-48 21.5-48 48V368c0 6.2 3.5 11.8 9.1 14.4s12.1 1.9 16.9-1.9l70-56 70 56c4.8 3.8 11.4 4.6 16.9 1.9s9.1-8.3 9.1-14.4V176c0-26.5-21.5-48-48-48H208z"]],
    "egg-fried": [512, 512, [], "f7fc", ["M415.8 116c-42.4-10.9-101.2-45.1-131.5-76.7c-49-51-130-52.6-181-3.6C80.1 58 67.1 87 64.5 116.8C60.2 166.1 46.2 229.1 21.4 272C-22.7 348.5 3.5 446.4 80 490.6s174.4 18 218.6-58.6c18.8-32.5 66.1-60 103.3-65.2c20.5-2.9 40.6-10.8 58.4-24c56.8-42.1 68.7-122.3 26.6-179.1c-18.2-24.6-43.5-40.7-71-47.8zM224 128a112 112 0 1 1 0 224 112 112 0 1 1 0-224z", "M224 352a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM176 232c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-39.8 32.2-72 72-72c8.8 0 16 7.2 16 16s-7.2 16-16 16c-22.1 0-40 17.9-40 40z"]],
    "face-weary": [512, 512, [], "e3a1", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.7 328.7c22-22 53.9-40.7 91.3-40.7s69.3 18.7 91.3 40.7c11.1 11.1 20.1 23.4 26.4 35.4c6.2 11.7 10.3 24.4 10.3 35.9c0 5.2-2.6 10.2-6.9 13.2s-9.8 3.7-14.7 1.8l-20.5-7.7c-26.9-10.1-55.5-15.3-84.3-15.3h-3.2c-28.8 0-57.3 5.2-84.3 15.3L149.6 415c-4.9 1.8-10.4 1.2-14.7-1.8s-6.9-7.9-6.9-13.2c0-11.6 4.2-24.2 10.3-35.9c6.3-12 15.3-24.3 26.4-35.4zm46.6-164c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0zm89.4 22.6c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4z", "M211.3 187.3l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm89.4 0c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4z"]],
    "uniform-martial-arts": [640, 512, [], "e3d1", ["M180 0h28 9.6c12.3 0 23.5 7 28.8 18.1l61.1 126.7L253 288H144V133.1L98 216.7c-1.3 2.4-2 5-2 7.7V384c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V224.4c0-18.9 4.8-37.4 13.9-54L80.3 49.7C95.9 21.2 124.9 2.8 157 .3c1-.2 2-.3 3-.3h4.4H180zM389.1 20.6C393.8 8.2 405.7 0 419 0h13 28 15.6H480c1 0 2 .1 3 .3c32.1 2.5 61 20.9 76.7 49.5l66.4 120.7c9.1 16.5 13.9 35.1 13.9 54V384c0 17.7-14.3 32-32 32H576c-17.7 0-32-14.3-32-32V224.4c0-2.7-.7-5.3-2-7.7l-46-83.7V288H287.2l52.7-138.3L389.1 20.6zM496 448c0 35.3-28.7 64-64 64H208c-35.3 0-64-28.7-64-64V384h86.3l-14.2 21.4c-14.7 22.1-8.7 51.9 13.3 66.6s51.9 8.7 66.6-13.3L320 422.5l24.1 36.1c14.7 22.1 44.5 28 66.6 13.3s28-44.5 13.3-66.6L409.7 384H496v64z", "M496 288H144v64H290.1l-47.4 71.1c-4.9 7.4-2.9 17.3 4.4 22.2s17.3 2.9 22.2-4.4l50.7-76 50.7 76c4.9 7.4 14.8 9.3 22.2 4.4s9.3-14.8 4.4-22.2L349.9 352H496V288z"]],
    "camera-rotate": [640, 512, [], "e0d8", ["M213.1 64.8L202.7 96H128c-35.3 0-64 28.7-64 64V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H437.3L426.9 64.8C420.4 45.2 402.1 32 381.4 32H258.6c-20.7 0-39 13.2-45.5 32.8zM448 256c0 8.8-7.2 16-16 16H355.3c-6.2 0-11.3-5.1-11.3-11.3c0-3 1.2-5.9 3.3-8L371 229c-13.6-13.4-31.9-21-51-21c-19.2 0-37.7 7.6-51.3 21.3L249 249c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l19.7-19.7C257.4 172.7 288 160 320 160c31.8 0 62.4 12.6 85 35l23.7-23.7c2.1-2.1 5-3.3 8-3.3c6.2 0 11.3 5.1 11.3 11.3V256zM192 320c0-8.8 7.2-16 16-16h76.7c6.2 0 11.3 5.1 11.3 11.3c0 3-1.2 5.9-3.3 8L269 347c13.6 13.4 31.9 21 51 21c19.2 0 37.7-7.6 51.3-21.3L391 327c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-19.7 19.7C382.6 403.3 352 416 320 416c-31.8 0-62.4-12.6-85-35l-23.7 23.7c-2.1 2.1-5 3.3-8 3.3c-6.2 0-11.3-5.1-11.3-11.3V320z", "M448 179.3V256c0 8.8-7.2 16-16 16H355.3c-6.2 0-11.3-5.1-11.3-11.3c0-3 1.2-5.9 3.3-8L371 229c-13.6-13.4-31.9-21-51-21c-19.2 0-37.7 7.6-51.3 21.3L249 249c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l19.7-19.7C257.4 172.7 288 160 320 160c31.8 0 62.4 12.6 85 35l23.7-23.7c2.1-2.1 5-3.3 8-3.3c6.2 0 11.3 5.1 11.3 11.3zM192 396.7V320c0-8.8 7.2-16 16-16h76.7c6.2 0 11.3 5.1 11.3 11.3c0 3-1.2 5.9-3.3 8L269 347c13.6 13.4 31.9 21 51 21c19.2 0 37.7-7.6 51.3-21.3L391 327c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-19.7 19.7C382.6 403.3 352 416 320 416c-31.8 0-62.4-12.6-85-35l-23.7 23.7c-2.1 2.1-5 3.3-8 3.3c-6.2 0-11.3-5.1-11.3-11.3z"]],
    "sun-dust": [512, 512, [], "f764", ["M156.7 512c0 0-.1 0-.1 0h.1zM512 355.3c0 .1 0 .1 0 .2v-.2zM391 121L371.1 13.1c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L256 65.1 165.7 2.8c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L121 121 13.1 140.9c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L65.1 256 2.8 346.3c-3.1 4.5-3.7 10.2-1.6 15.2s6.6 8.6 11.9 9.6L121 391l44.5-44.5C142.3 323.3 128 291.3 128 256c0-70.7 57.3-128 128-128c35.3 0 67.3 14.3 90.5 37.5L391 121zm-67.1 67.1C306.5 170.7 282.5 160 256 160c-53 0-96 43-96 96c0 26.5 10.7 50.5 28.1 67.9L323.9 188.1z", "M480 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-80 80a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm112 48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM272 400a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM400 432a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM352 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "comment-text": [512, 512, [], "e14d", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM184 160h72 72c13.3 0 24 10.7 24 24s-10.7 24-24 24H280V312c0 13.3-10.7 24-24 24s-24-10.7-24-24V208H184c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M160 184c0-13.3 10.7-24 24-24h72 72c13.3 0 24 10.7 24 24s-10.7 24-24 24H280V312c0 13.3-10.7 24-24 24s-24-10.7-24-24V208H184c-13.3 0-24-10.7-24-24z"]],
    "spray-can-sparkles": [512, 512, ["air-freshener"], "f5d0", ["M384 48c0-1.4-1-3-2.2-3.6L352 32 339.6 2.2C339 1 337.4 0 336 0s-3 1-3.6 2.2L320 32 290.2 44.4C289 45 288 46.6 288 48c0 1.4 1 3 2.2 3.6L320 64l12.4 29.8C333 95 334.6 96 336 96s3-1 3.6-2.2L352 64l29.8-12.4C383 51 384 49.4 384 48zm76.4 45.8C461 95 462.6 96 464 96s3-1 3.6-2.2L480 64l29.8-12.4C511 51 512 49.4 512 48c0-1.4-1-3-2.2-3.6L480 32 467.6 2.2C467 1 465.4 0 464 0s-3 1-3.6 2.2L448 32 418.2 44.4C417 45 416 46.6 416 48c0 1.4 1 3 2.2 3.6L448 64l12.4 29.8zm7.2 100.4c-.6-1.2-2.2-2.2-3.6-2.2s-3 1-3.6 2.2L448 224l-29.8 12.4c-1.2 .6-2.2 2.2-2.2 3.6c0 1.4 1 3 2.2 3.6L448 256l12.4 29.8c.6 1.2 2.2 2.2 3.6 2.2s3-1 3.6-2.2L480 256l29.8-12.4c1.2-.6 2.2-2.2 2.2-3.6c0-1.4-1-3-2.2-3.6L480 224l-12.4-29.8zM448 144c0-1.4-1-3-2.2-3.6L416 128 403.6 98.2C403 97 401.4 96 400 96s-3 1-3.6 2.2L384 128l-29.8 12.4c-1.2 .6-2.2 2.2-2.2 3.6c0 1.4 1 3 2.2 3.6L384 160l12.4 29.8c.6 1.2 2.2 2.2 3.6 2.2s3-1 3.6-2.2L416 160l29.8-12.4c1.2-.6 2.2-2.2 2.2-3.6zM160 416a80 80 0 1 0 0-160 80 80 0 1 0 0 160z", "M128 0h64c17.7 0 32 14.3 32 32v96H96V32c0-17.7 14.3-32 32-32zM0 256c0-53 43-96 96-96H224c53 0 96 43 96 96V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V256zm240 80A80 80 0 1 0 80 336a80 80 0 1 0 160 0z"]],
    "signal-bars": [640, 512, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", ["", "M560 0c-26.5 0-48 21.5-48 48V464c0 26.5 21.5 48 48 48s48-21.5 48-48V48c0-26.5-21.5-48-48-48zM352 176V464c0 26.5 21.5 48 48 48s48-21.5 48-48V176c0-26.5-21.5-48-48-48s-48 21.5-48 48zM240 256c-26.5 0-48 21.5-48 48V464c0 26.5 21.5 48 48 48s48-21.5 48-48V304c0-26.5-21.5-48-48-48zM80 384c-26.5 0-48 21.5-48 48v32c0 26.5 21.5 48 48 48s48-21.5 48-48V432c0-26.5-21.5-48-48-48z"]],
    "diamond-exclamation": [512, 512, [], "e405", ["M227.7 11.7c15.6-15.6 40.9-15.6 56.6 0l216 216c15.6 15.6 15.6 40.9 0 56.6l-216 216c-15.6 15.6-40.9 15.6-56.6 0l-216-216c-15.6-15.6-15.6-40.9 0-56.6l216-216zM256 128c-13.3 0-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M280 152c0-13.3-10.7-24-24-24s-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152zM256 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "star": [576, 512, [11088, 61446], "f005", ["M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z", ""]],
    "dial-min": [576, 512, [], "e161", ["M256 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M192.8 416.7c62.6 46.2 151.3 41 208-15.7c62.5-62.5 62.5-163.8 0-226.3s-163.8-62.5-226.3 0c-56.7 56.7-62 145.4-15.7 208L270.8 270.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L192.8 416.7z"]],
    "repeat": [512, 512, [128257], "f363", ["M480 256c17.7 0 32 14.3 32 32c0 88.4-71.6 160-160 160H192l0 32c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-64-64c-12.5-12.5-12.5-32.8 0-45.3l64-64c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6v32H352c53 0 96-43 96-96c0-17.7 14.3-32 32-32z", "M32 256c-17.7 0-32-14.3-32-32C0 135.6 71.6 64 160 64H320l0-32c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l64 64c12.5 12.5 12.5 32.8 0 45.3l-64 64c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6V128H160c-53 0-96 43-96 96c0 17.7-14.3 32-32 32z"]],
    "cross": [384, 512, [128327, 10013], "f654", ["M176 0c-26.5 0-48 21.5-48 48v80H48c-26.5 0-48 21.5-48 48v32c0 26.5 21.5 48 48 48h80V464c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V256h80c26.5 0 48-21.5 48-48V176c0-26.5-21.5-48-48-48H256V48c0-26.5-21.5-48-48-48H176z", "M128 256H256v32H128V256z"]],
    "page-caret-down": [384, 512, ["file-caret-down"], "e429", ["M320 512c35.3 0 64-28.7 64-64V138.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0H64C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320zM192 352c-4.5 0-8.8-1.9-11.8-5.2l-75.7-82.6c-14.1-15.4-3.2-40.2 17.7-40.2l139.6 0c20.9 0 31.8 24.8 17.7 40.2l-75.7 82.6c-3 3.3-7.3 5.2-11.8 5.2z", "M180.2 346.8c3 3.3 7.3 5.2 11.8 5.2s8.8-1.9 11.8-5.2l75.7-82.6c14.1-15.4 3.2-40.2-17.7-40.2H122.2c-20.9 0-31.8 24.8-17.7 40.2l75.7 82.6z"]],
    "box": [448, 512, [128230], "f466", ["M93.7 32C75.5 32 58.9 42.3 50.7 58.5L0 160H208V32H93.7zM240 32V160H448L397.3 58.5C389.1 42.3 372.5 32 354.3 32H240z", "M240 160H448V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160H208V32h32V160z"]],
    "venus-mars": [640, 512, [9892], "f228", ["M271.9 360.6c19.3-10.1 36.9-23.1 52.1-38.4c20 18.5 46.7 29.8 76.1 29.8c61.9 0 112-50.1 112-112s-50.1-112-112-112c-7.2 0-14.3 .7-21.1 2c-4.9-21.5-13-41.7-24-60.2C369.3 66 384.4 64 400 64c37 0 71.4 11.4 99.8 31l20.6-20.6L487 41c-6.9-6.9-8.9-17.2-5.2-26.2S494.3 0 504 0H616c13.3 0 24 10.7 24 24V136c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-33.4-33.4L545 140.2c19.5 28.4 31 62.7 31 99.8c0 97.2-78.8 176-176 176c-50.5 0-96-21.3-128.1-55.4zM592 48l0 0h0v0zM176 96a80 80 0 1 1 0 160 80 80 0 1 1 0-160z", "M176 288a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM352 176c0 86.3-62.1 158.1-144 173.1V384h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H208v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V448H112c-17.7 0-32-14.3-32-32s14.3-32 32-32h32V349.1C62.1 334.1 0 262.3 0 176C0 78.8 78.8 0 176 0s176 78.8 176 176zm32 0c0-4.8-.2-9.6-.5-14.3c5.3-1.1 10.8-1.7 16.5-1.7c44.2 0 80 35.8 80 80s-35.8 80-80 80c-21.5 0-41-8.5-55.3-22.2C369.4 263.5 384 221.5 384 176z"]],
    "clock-seven-thirty": [512, 512, [], "e351", ["M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V335.3l-20 30c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l64-96c5.9-8.8 16.8-12.7 26.9-9.7s17 12.4 17 23V392c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M256 416c-13.3 0-24-10.7-24-24V335.3l-20 30c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l64-96c5.9-8.8 16.8-12.7 26.9-9.7s17 12.4 17 23V392c0 13.3-10.7 24-24 24z"]],
    "arrow-pointer": [320, 512, ["mouse-pointer"], "f245", ["M121.2 346l58.1 116.3c7.9 15.8 27.1 22.2 42.9 14.3s22.2-27.1 14.3-42.9L179.8 320H144l-22.8 26z", "M0 426V55.2C0 42.4 10.4 32 23.2 32c5.7 0 11.2 2.1 15.4 5.9l274 243.6c4.7 4.2 7.4 10.2 7.4 16.5c0 12.2-9.9 22.1-22.1 22.1H144L38.6 440.5C34.4 445.3 28.4 448 22 448c-12.2 0-22-9.9-22-22z"]],
    "clock-four-thirty": [512, 512, [], "e34b", ["M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V300.8L338.7 340c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3l-96-64c-7.4-4.9-16.8-5.4-24.6-1.2S232 247.1 232 256V392c0 13.3 10.7 24 24 24s24-10.7 24-24z", "M256 416c13.3 0 24-10.7 24-24V300.8L338.7 340c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3l-96-64c-7.4-4.9-16.8-5.4-24.6-1.2S232 247.1 232 256V392c0 13.3 10.7 24 24 24z"]],
    "signal-bars-good": [640, 512, ["signal-alt-3"], "f693", ["M512 48c0-26.5 21.5-48 48-48s48 21.5 48 48V464c0 26.5-21.5 48-48 48s-48-21.5-48-48V48z", "M400 128c-26.5 0-48 21.5-48 48V464c0 26.5 21.5 48 48 48s48-21.5 48-48V176c0-26.5-21.5-48-48-48zM192 304V464c0 26.5 21.5 48 48 48s48-21.5 48-48V304c0-26.5-21.5-48-48-48s-48 21.5-48 48zM32 432v32c0 26.5 21.5 48 48 48s48-21.5 48-48V432c0-26.5-21.5-48-48-48s-48 21.5-48 48z"]],
    "cactus": [512, 512, [127797], "f8a7", ["M96 144c0-26.5-21.5-48-48-48S0 117.5 0 144v64c0 61.9 50.1 112 112 112h48V224H112c-8.8 0-16-7.2-16-16V144zM416 272v64c0 8.8-7.2 16-16 16H352v96h48c61.9 0 112-50.1 112-112V272c0-26.5-21.5-48-48-48s-48 21.5-48 48z", "M160 96c0-53 43-96 96-96s96 43 96 96V464c0 26.5-21.5 48-48 48H208c-26.5 0-48-21.5-48-48V96zm80 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "lightbulb-gear": [576, 512, [], "e5fd", ["M240.6 384c2.3-13.3 10.5-24.9 21.4-31.8c-16.6-10.6-26.7-31.7-20-53.3c4-12.9 9.4-25.5 16.4-37.6s15.2-23.1 24.4-33c15.7-16.9 39.6-18.5 57.2-8.7v-.9c0-17.8 10.2-35.6 28-43.3C367.6 78.4 289 0 192 0C94.8 0 16 78.8 16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4l0 0c19.8 27.1 39.7 54.4 49.2 86.2H240.6zm5 32H112v16c0 44.2 35.8 80 80 80c35.2 0 65.1-22.8 75.8-54.4c-3.3-4.7-6.4-9.5-9.4-14.6c-5.1-8.8-9.3-17.8-12.8-27zM192 96c-44.2 0-80 35.8-80 80c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16z", "M383.3 203.4c-6.8 1.5-11.3 7.8-11.3 14.8v17.4c0 7.9-4.9 15-11.7 18.9c-6.8 3.9-15.2 4.5-22 .6l-13.6-7.8c-6.1-3.5-13.7-2.7-18.5 2.4c-7.5 8.1-14.3 17.2-20.1 27.2s-10.3 20.4-13.5 31c-2.1 6.7 1.1 13.7 7.2 17.2l14 8.1c6.5 3.8 10.1 11 10.1 18.6s-3.5 14.8-10.1 18.6l-14 8.1c-6.1 3.5-9.2 10.5-7.2 17.2c3.3 10.6 7.8 21 13.5 31s12.5 19.1 20.1 27.2c4.8 5.1 12.5 5.9 18.5 2.4l13.5-7.8c6.8-3.9 15.2-3.3 22 .6c6.9 3.9 11.7 11 11.7 18.9l0 17.4c0 7 4.5 13.3 11.3 14.8c10.5 2.4 21.5 3.7 32.7 3.7s22.2-1.3 32.7-3.7c6.8-1.5 11.3-7.8 11.3-14.8l0-17.7c0-7.8 4.8-14.8 11.6-18.7c6.7-3.9 15.1-4.5 21.8-.6l13.8 7.9c6.1 3.5 13.7 2.7 18.5-2.4c7.6-8.1 14.3-17.2 20.1-27.2s10.3-20.4 13.5-31c2.1-6.7-1.1-13.7-7.2-17.2l-14.4-8.3c-6.5-3.7-10-10.9-10-18.4s3.5-14.7 10-18.4l14.4-8.3c6.1-3.5 9.2-10.5 7.2-17.2c-3.3-10.6-7.8-21-13.5-31s-12.5-19.1-20.1-27.2c-4.8-5.1-12.5-5.9-18.5-2.4l-13.8 7.9c-6.7 3.9-15.1 3.3-21.8-.6c-6.8-3.9-11.6-10.9-11.6-18.7V218.2c0-7-4.5-13.3-11.3-14.8c-10.5-2.4-21.5-3.7-32.7-3.7s-22.2 1.3-32.7 3.7zM416 303.7a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "maximize": [512, 512, ["expand-arrows-alt"], "f31e", ["M56 32H200c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-40 40 79 79-64 64-79-79L73 217c-6.9 6.9-17.2 8.9-26.2 5.2S32 209.7 32 200V56c0-13.3 10.7-24 24-24zM256 320l64-64 79 79 40-40c6.9-6.9 17.2-8.9 26.2-5.2s14.8 12.5 14.8 22.2V456c0 13.3-10.7 24-24 24H312c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l40-40-79-79z", "M480 56V200c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-40-40L177 399l40 40c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8H56c-13.3 0-24-10.7-24-24V312c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l40 40L335 113 295 73c-6.9-6.9-8.9-17.2-5.2-26.2s12.5-14.8 22.2-14.8H456c13.3 0 24 10.7 24 24z"]],
    "charging-station": [576, 512, [], "f5e7", ["M32 64C32 28.7 60.7 0 96 0H256c35.3 0 64 28.7 64 64V448H32V64zm191.2 37.1c2.3-6.8-.3-14.3-6.3-18.3s-13.9-3.6-19.3 1.1l-112 96c-5.1 4.4-6.9 11.4-4.6 17.7s8.3 10.4 15 10.4h57.8l-25 74.9c-2.3 6.8 .3 14.3 6.3 18.3s13.9 3.6 19.3-1.1l112-96c5.1-4.4 6.9-11.4 4.6-17.7s-8.3-10.4-15-10.4H198.2l25-74.9z", "M480 80c0-8.8-7.2-16-16-16s-16 7.2-16 16v48H432c-8.8 0-16 7.2-16 16v32c0 35.8 23.5 66.1 56 76.3V376c0 13.3-10.7 24-24 24s-24-10.7-24-24V344c0-48.6-39.4-88-88-88H320v48h16c22.1 0 40 17.9 40 40v32c0 39.8 32.2 72 72 72s72-32.2 72-72V252.3c32.5-10.2 56-40.5 56-76.3V144c0-8.8-7.2-16-16-16H544V80c0-8.8-7.2-16-16-16s-16 7.2-16 16v48H480V80zM0 480c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32s-14.3-32-32-32H32c-17.7 0-32 14.3-32 32z"]],
    "shapes": [512, 512, ["triangle-circle-square"], "f61f", ["M288 0c-11.2 0-21.7 5.9-27.4 15.5l-96 160c-5.9 9.9-6.1 22.2-.4 32.2s16.3 16.2 27.8 16.2H384c11.5 0 22.2-6.2 27.8-16.2s5.5-22.3-.4-32.2l-96-160C309.7 5.9 299.2 0 288 0zM128 512a128 128 0 1 0 0-256 128 128 0 1 0 0 256z", "M328 272c-22.1 0-40 17.9-40 40V456c0 22.1 17.9 40 40 40H472c22.1 0 40-17.9 40-40V312c0-22.1-17.9-40-40-40H328z"]],
    "plane-tail": [512, 512, [], "e22c", ["M61.5 308.8L.8 39C-3.7 19 11.5 0 32 0h76.9c17.3 0 33.9 7 46 19.5L384 256H264.7c-7.9 0-15.8 1.1-23.4 3.2L61.5 308.8z", "M512 464V304 280 256H488 264.7c-7.9 0-15.8 1.1-23.4 3.2L45.9 313.1C18.8 320.5 0 345.2 0 373.4c0 26 16.1 49.3 40.4 58.5l196.1 74.4c10 3.8 20.5 5.7 31.2 5.7H488h24V488 464zM216 352H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H216c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "gauge-simple-max": [512, 512, ["tachometer-fastest"], "f62b", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm192 96c0-35.3 28.7-64 64-64c14.1 0 27.2 4.6 37.8 12.4l117.5-72.8c11.3-7 26.1-3.5 33 7.8s3.5 26.1-7.8 33L319.1 341.2c.6 3.5 .9 7.1 .9 10.8c0 35.3-28.7 64-64 64s-64-28.7-64-64z", "M411.4 227.6c11.3-7 26.1-3.5 33 7.8s3.5 26.1-7.8 33L319.1 341.2c.6 3.5 .9 7.1 .9 10.8c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c14.1 0 27.2 4.6 37.8 12.4l117.6-72.8z"]],
    "circle-u": [512, 512, [], "e127", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 168V288c0 35.3 28.7 64 64 64s64-28.7 64-64V168c0-13.3 10.7-24 24-24s24 10.7 24 24V288c0 61.9-50.1 112-112 112s-112-50.1-112-112V168c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M168 144c13.3 0 24 10.7 24 24V288c0 35.3 28.7 64 64 64s64-28.7 64-64V168c0-13.3 10.7-24 24-24s24 10.7 24 24V288c0 61.9-50.1 112-112 112s-112-50.1-112-112V168c0-13.3 10.7-24 24-24z"]],
    "shield-slash": [640, 512, [], "e24b", ["M320 0c4.6 0 9.2 1 13.4 2.9L521.7 82.8c22 9.3 38.4 31 38.3 57.2c-.3 58.7-14.7 146.2-62.1 225L131 77.4 306.7 2.9C310.8 1 315.4 0 320 0zM80.6 159.5L437.5 440.7c-25.2 24-55.3 45.4-91.1 62.5c-16.7 8-36.1 8-52.8 0C132 425.8 86.1 261.5 80.6 159.5z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "square-phone-hangup": [448, 512, ["phone-square-down"], "e27a", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM359.4 310c-5.3 8.6-16.8 12.3-26.7 8.5l-46.2-17.6c-8.7-3.3-14.1-11.6-13.1-20.3l2.9-26.7c-33.8-10.8-70.8-10.8-104.6 0l2.9 26.7c.9 8.7-4.4 16.9-13.1 20.3l-46.2 17.6c-9.9 3.8-21.4 .2-26.7-8.5L66.8 274.8C62 267 63.4 257.3 70.3 251c84.9-78.6 222.6-78.6 307.5 0c6.8 6.3 8.2 16.1 3.4 23.8L359.4 310z", "M332.7 318.5c9.9 3.8 21.4 .2 26.7-8.5l21.7-35.2c4.8-7.8 3.4-17.5-3.4-23.8c-84.9-78.6-222.6-78.6-307.5 0c-6.8 6.3-8.2 16.1-3.4 23.8L88.6 310c5.3 8.6 16.8 12.3 26.7 8.5l46.2-17.6c8.7-3.3 14.1-11.6 13.1-20.3L171.7 254c33.8-10.8 70.8-10.8 104.6 0l-2.9 26.7c-.9 8.7 4.4 16.9 13.1 20.3l46.2 17.6z"]],
    "arrow-up-left": [384, 512, [], "e09d", ["M96 205.3L297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L141.3 160H96v45.3z", "M32 128c0-17.7 14.3-32 32-32H288c17.7 0 32 14.3 32 32s-14.3 32-32 32H96V352c0 17.7-14.3 32-32 32s-32-14.3-32-32V128z"]],
    "transporter-1": [512, 512, [], "e043", ["M480 160l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L448 160l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7L448 192l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 192l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 160zM64 352l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 352 6.6 359.3C2.7 360.4 0 363.9 0 368s2.7 7.6 6.6 8.7L32 384l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 384l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 352zm112-32c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176z", "M304 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM216 512h80 88c17.7 0 32-14.3 32-32s-14.3-32-32-32H128c-17.7 0-32 14.3-32 32s14.3 32 32 32h88zM359 276c6.3 7.8 15.4 11.9 24.7 12h.3v0c7 0 14.1-2.3 20-7c13.8-11.1 16-31.2 5-45l-57.7-72c-18.2-22.7-45.8-36-74.9-36H235.6c-29.1 0-56.7 13.2-74.9 36L103 236c-11.1 13.8-8.8 33.9 5 45c5.9 4.7 13 7 20 7v0h.3c9.3-.1 18.5-4.2 24.7-12l31-38.7V288H328V237.3L359 276z"]],
    "peanuts": [640, 512, [129372], "e431", ["M560 0H492c-20.1 0-39.2 4-56.7 11.2c-17.4 7.2-33.7 17.8-47.8 32l-.4 .4C373 57.8 362.4 74 355.2 91.4c-4 9.5-6.9 19.6-8.8 30c-4.8 24.5-12.6 49.1-30.3 66.7s-42.2 25.4-66.7 30.3c-10.4 1.9-20.5 4.9-30 8.8c-17.5 7.2-33.9 17.9-48.1 32.1c-14.2 14.2-24.9 30.5-32.1 48C132 324.8 128 343.9 128 364v68c0 44.2 35.8 80 80 80h68c40.5 0 77.1-16.2 103.8-42.5c.6-.6 1.1-1.1 1.7-1.7c13.8-14 24.2-30.1 31.3-47.2c4-9.5 6.9-19.6 8.8-30c4.8-24.5 12.6-49.1 30.3-66.7s42.2-25.4 66.7-30.3c10.4-1.9 20.5-4.9 30-8.8c17.3-7.2 33.5-17.7 47.6-31.7l.9-.9C623.6 225.4 640 188.6 640 148V80c0-44.2-35.8-80-80-80zM524.8 128a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm0 64a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm-64 0a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm-224 224a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zM320 396.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zm0-64a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4z", "M161.7 28.3L212.6 5.7c33.1-14.7 71.8 .1 86.6 33.2l22.7 50.9c12.4 27.8 13.5 57.8 5.2 84.8c-3.1 4.8-6.7 9.4-10.9 13.5c-17.6 17.6-42.2 25.4-66.7 30.3c-10.4 1.9-20.5 4.9-30 8.8c-17.5 7.2-33.9 17.9-48.1 32.1c-14.2 14.2-24.9 30.5-32.1 48C132 324.8 128 343.9 128 364v68c0 23.4 10 44.4 26 59l-34.3 15.3c-33.1 14.7-71.8-.2-86.6-33.2L10.5 422.2C3.8 407.2 .4 391.5 0 376c-.4-15.5 2.2-31.3 8-46.6C14 314 22.7 300.5 33.4 289.3c5.8-6.1 12.3-11.7 19.5-16.6c16.7-11.8 32.5-25.8 39.8-44.9s5-40.1 .4-60c-2.1-8.4-3.2-17-3.4-25.4c-.4-15.4 2.1-31.1 7.9-46.4l.2-.5c5.9-15.3 14.5-28.7 25.2-39.9c10.7-11.2 23.6-20.6 38.7-27.3zM524.8 128a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm0 64a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm-64 0a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm-224 224a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zM320 396.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zm0-64a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4z"]],
    "shuffle": [512, 512, [128256, "random"], "f074", ["M438.6 41.4c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6V96H352c-30.2 0-58.7 14.2-76.8 38.4L224 202.7 264 256l62.4-83.2c6-8.1 15.5-12.8 25.6-12.8h32v32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c6-6 9.4-14.1 9.4-22.6s-3.4-16.6-9.4-22.6l-64-64zM224 309.3L184 256l-62.4 83.2c-6 8.1-15.5 12.8-25.6 12.8H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H96c30.2 0 58.7-14.2 76.8-38.4L224 309.3z", "M352 416c-30.2 0-58.7-14.2-76.8-38.4L121.6 172.8c-6-8.1-15.5-12.8-25.6-12.8H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H96c30.2 0 58.7 14.2 76.8 38.4L326.4 339.2c6 8.1 15.5 12.8 25.6 12.8h32V320c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l64 64c6 6 9.4 14.1 9.4 22.6s-3.4 16.6-9.4 22.6l-64 64c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6V416H352z"]],
    "person-running": [448, 512, [127939, "running"], "f70c", ["M146.1 228.4L91.2 352H32c-17.7 0-32 14.3-32 32s14.3 32 32 32h69.6c19 0 36.2-11.2 43.9-28.5l24.6-55.4-5.7-3.6c-25.1-15.7-36.1-46.5-26.8-74.5l8.5-25.6zm60.4 21.3c-.1 .2-.1 .5-.2 .7l.2-.7z", "M272 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM163.2 160c-14.1 0-27.5 5.6-37.5 15.5l-23.1 23.1c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l23.1-23.1C102.4 108.3 132.2 96 163.2 96c11.7 0 23.3 1.7 34.4 5.2l48.7 15c36.4 11.2 65.9 38 80.5 73.1l6.3 15c5 11.9 16.6 19.7 29.5 19.7H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H362.7c-38.8 0-73.7-23.3-88.6-59.1l-5.1-12.3L238 299l56.7 35.4c18.1 11.3 26.6 33.3 20.7 53.9L286.8 488.8c-4.9 17-22.6 26.8-39.6 22s-26.8-22.6-22-39.6l25.4-88.8-86.2-53.9c-25.1-15.7-36.1-46.5-26.8-74.5l31.2-93.7c-1.9-.2-3.7-.3-5.6-.3z"]],
    "mobile-retro": [320, 512, [], "e527", ["M0 64C0 28.7 28.7 0 64 0H256c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zm64 96v64c0 17.7 14.3 32 32 32H224c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H96c-17.7 0-32 14.3-32 32zM80 352a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56-56a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56-56a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM128 48c-8.8 0-16 7.2-16 16s7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H128z", "M64 160c0-17.7 14.3-32 32-32H224c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V160z"]],
    "grip-lines-vertical": [192, 512, [], "f7a5", ["M128 64c0-17.7 14.3-32 32-32s32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64z", "M0 64C0 46.3 14.3 32 32 32s32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64z"]],
    "bin-bottles-recycle": [640, 512, [], "e5f6", ["M128 24c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24v8c8.8 0 16 7.2 16 16s-7.2 16-16 16H128c-8.8 0-16-7.2-16-16s7.2-16 16-16V24zm0 72H256c24.9 0 47.6 9.5 64.6 25c1.1 1 2.2 2 3.2 3.1C341.3 141.5 352 165.5 352 192H32c0-53 43-96 96-96zm447.1 96H384c0-40.7-19-76.9-48.6-100.4c5.2-5.6 11.5-10.3 18.6-13.6l13.2-6.2c5.3-2.5 10.8-4.4 16.4-5.7V24c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24V66.1c5.6 1.3 11.1 3.2 16.4 5.7L541.2 78c21 9.9 34.4 31 34.4 54.2c0 12.3-3.7 23.8-10.1 33.3c5 7.8 8.4 16.9 9.6 26.5z", "M0 256c0-17.7 14.3-32 32-32H608c17.7 0 32 14.3 32 32s-14.3 32-32 32L583.8 457c-4.5 31.5-31.5 55-63.4 55h-401c-31.8 0-58.9-23.4-63.4-55L32 288c-17.7 0-32-14.3-32-32zm319.9 64c4.6 0 9 2.3 11.5 6.2l8.5 12.9c4.8 7.3 14.5 9.4 21.8 4.8c7.6-4.8 9.8-14.9 4.9-22.4l-8.5-12.9c-8.5-12.9-22.8-20.6-38.2-20.6c-15.3 0-29.6 7.7-38.1 20.4l-7.6 11.4c-5 7.5-2.8 17.7 4.8 22.4c7.3 4.6 17 2.5 21.8-4.7l7.6-11.4c2.6-3.8 6.9-6.1 11.5-6.1zm-59.4 48.4c-7.3-4.6-17-2.5-21.8 4.7l-7.9 11.9c-4.4 6.7-6.8 14.5-6.8 22.5c0 22.4 18.2 40.6 40.6 40.6h25.2c8.8 0 16-7.2 16-16s-7.2-16-16-16H264.6c-4.7 0-8.6-3.8-8.6-8.6c0-1.7 .5-3.3 1.4-4.7l7.9-11.9c5-7.5 2.8-17.7-4.8-22.4zM337.7 432c0 8.8 7.2 16 16 16h20.9c22.4 0 40.6-18.2 40.6-40.6c0-7.9-2.3-15.7-6.7-22.4l-6.6-10.1c-4.8-7.3-14.5-9.4-21.8-4.8c-7.6 4.8-9.8 14.9-4.9 22.4l6.6 10.1c.9 1.4 1.4 3.1 1.4 4.7c0 4.8-3.9 8.6-8.6 8.6H353.7c-8.8 0-16 7.2-16 16z"]],
    "arrow-up-from-square": [512, 512, [], "e09c", ["M80 96c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16H432c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16h-8c-17.7 0-32-14.3-32-32s14.3-32 32-32h8c44.2 0 80 35.8 80 80V432c0 44.2-35.8 80-80 80H80c-44.2 0-80-35.8-80-80V112C0 67.8 35.8 32 80 32h8c17.7 0 32 14.3 32 32s-14.3 32-32 32H80z", "M233.4 9.4c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L288 109.3V320c0 17.7-14.3 32-32 32s-32-14.3-32-32V109.3l-41.4 41.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l96-96z"]],
    "file-dashed-line": [640, 512, ["page-break"], "f877", ["M192 0c-35.3 0-64 28.7-64 64V256H512V160H384c-17.7 0-32-14.3-32-32V0H192zM512 368H128v80c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V368zM384 0V128H512L384 0z", "M32 312c0-13.3 10.7-24 24-24H168c13.3 0 24 10.7 24 24s-10.7 24-24 24H56c-13.3 0-24-10.7-24-24zm224 0c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24s-10.7 24-24 24H280c-13.3 0-24-10.7-24-24zm192 0c0-13.3 10.7-24 24-24H584c13.3 0 24 10.7 24 24s-10.7 24-24 24H472c-13.3 0-24-10.7-24-24z"]],
    "bracket-curly-right": [256, 512, [], "7d", ["M192 128c0-53-43-96-96-96H64C46.3 32 32 46.3 32 64s14.3 32 32 32H96c17.7 0 32 14.3 32 32v37.5c0 25.5 10.1 49.9 28.1 67.9L178.7 256l-22.6 22.6c-18 18-28.1 42.4-28.1 67.9V384c0 17.7-14.3 32-32 32H64c-17.7 0-32 14.3-32 32s14.3 32 32 32H96c53 0 96-43 96-96V346.5c0-8.5 3.4-16.6 9.4-22.6l45.3-45.3c12.5-12.5 12.5-32.8 0-45.3l-45.3-45.3c-6-6-9.4-14.1-9.4-22.6V128z", ""]],
    "spider": [512, 512, [128375], "f717", ["M144.6 1.6c-12.4-4.8-26.3 1.4-31 13.8L81.1 100c-7.9 20.7-3 44.1 12.7 59.7l57.4 57.4 24.9 8.3V174.1l-48.3-48.3c-2.2-2.2-2.9-5.6-1.8-8.5l32.5-84.6c4.8-12.4-1.4-26.3-13.8-31zM360.9 217.1l57.4-57.4c15.6-15.6 20.6-39 12.7-59.7L398.4 15.4C393.6 3 379.8-3.2 367.4 1.6s-18.5 18.6-13.8 31l32.5 84.6c1.1 3 .4 6.3-1.8 8.5L336 174.1v51.3l24.9-8.3z", "M221.5 87.8c9.1-4.4 18.5 3.3 18.5 13.4V112c0 8.8 7.2 16 16 16s16-7.2 16-16V101.2c0-10.1 9.4-17.7 18.5-13.4C317.4 100.7 336 128.2 336 160v65.4l105.2-35.1c2.4-.8 4.3-2.7 5.1-5.1l18.9-56.8c4.2-12.6 17.8-19.4 30.4-15.2s19.4 17.8 15.2 30.4l-18.9 56.8c-5.6 16.7-18.7 29.8-35.4 35.4L395.9 256l60.5 20.2c16.7 5.6 29.8 18.7 35.4 35.4l18.9 56.8c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-18.9-56.8c-.8-2.4-2.7-4.3-5.1-5.1l-80.4-26.8 57.4 57.4c15.6 15.6 20.6 39 12.7 59.7l-32.5 84.6c-4.8 12.4-18.6 18.5-31 13.8s-18.5-18.6-13.8-31l32.5-84.6c1.1-3 .4-6.3-1.8-8.5L352 353.9c-1 52.1-43.6 94.1-96 94.1s-95-41.9-96-94.1l-32.3 32.3c-2.2 2.2-2.9 5.6-1.8 8.5l32.5 84.6c4.8 12.4-1.4 26.3-13.8 31s-26.3-1.4-31-13.8L81.1 412c-7.9-20.7-3-44.1 12.7-59.7l57.4-57.4L70.8 321.7c-2.4 .8-4.3 2.7-5.1 5.1L46.8 383.6C42.6 396.2 29 403 16.4 398.8S-3 381 1.2 368.4l18.9-56.8c5.6-16.7 18.7-29.8 35.4-35.4L116.1 256 55.6 235.8c-16.7-5.6-29.8-18.7-35.4-35.4L1.2 143.6C-3 131 3.8 117.4 16.4 113.2s26.2 2.6 30.4 15.2l18.9 56.8c.8 2.4 2.7 4.3 5.1 5.1L176 225.4V160c0-31.8 18.6-59.3 45.5-72.2z"]],
    "clock-three": [512, 512, [], "e356", ["M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zM232 120V256c0 13.3 10.7 24 24 24H360c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M256 96c-13.3 0-24 10.7-24 24V256c0 13.3 10.7 24 24 24H360c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V120c0-13.3-10.7-24-24-24z"]],
    "hands-bound": [640, 512, [], "e4f9", ["M64 0C81.7 0 96 14.3 96 32V96v48.8l69.3 92.4c5.7 7.6 16.1 9.6 24.2 4.8c9.7-5.7 12.1-18.7 5.1-27.5L167 180c-10.8-13.5-8.9-33.3 4.4-44.5s33-9.8 44.5 3.2l46.7 52.5C279 209.7 288 233.4 288 258.1V320v32H131.6L46.3 252.5C37.1 241.8 32 228 32 213.9V192 155.8v-.7V96 32C32 14.3 46.3 0 64 0zm96 480H288v32H160V480zm192 0H480v32H352V480zM508.4 352H352V320 258.1c0-24.6 9-48.4 25.4-66.8l46.7-52.5c11.5-13 31.3-14.4 44.5-3.2s15.2 30.9 4.4 44.5l-27.6 34.5c-7 8.8-4.7 21.8 5.1 27.5c8.1 4.8 18.6 2.7 24.2-4.8L544 144.8V96 32c0-17.7 14.3-32 32-32s32 14.3 32 32V96v59.1 .7V192v21.9c0 14.2-5.1 27.9-14.3 38.7L508.4 352z", "M128 352c-13.3 0-24 10.7-24 24s10.7 24 24 24H512c13.3 0 24-10.7 24-24s-10.7-24-24-24H128zm0 80c-13.3 0-24 10.7-24 24s10.7 24 24 24H512c13.3 0 24-10.7 24-24s-10.7-24-24-24H128z"]],
    "scalpel-line-dashed": [576, 512, ["scalpel-path"], "f61e", ["M169.4 320l-4.7 4.7-160 160c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9c18.1 0 84.1-8.4 145.9-33.1C222.5 454.6 288 410.9 288 336V320H272 176h-6.6z", "M387.5 24.6C400.9 9 420.5 0 441.2 0C480.3 0 512 31.7 512 70.8v3.4c0 17.9-6.5 35.2-18.2 48.7L337.2 303.5C328 314 314.8 320 300.9 320H168c-6.3 0-11.9-3.6-14.5-9.3s-1.7-12.4 2.4-17.1L387.5 24.6zM240 480h64c8.8 0 16 7.2 16 16s-7.2 16-16 16H240c-8.8 0-16-7.2-16-16s7.2-16 16-16zm128 0h64c8.8 0 16 7.2 16 16s-7.2 16-16 16H368c-8.8 0-16-7.2-16-16s7.2-16 16-16zm128 0h64c8.8 0 16 7.2 16 16s-7.2 16-16 16H496c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "file-invoice-dollar": [384, 512, [], "f571", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM64 80c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zm128 72c-8.8 0-16 7.2-16 16v17.3c-8.3 1.5-16.7 4.3-24.1 8.7c-13 7.7-23.9 21.1-23.8 40.5c.1 18.4 10.8 30.1 22.7 37.3c10.5 6.3 23.8 10.4 34.8 13.7l0 0 1.6 .5c12.5 3.8 22.2 6.9 29 11.2c5.9 3.7 7.7 7 7.7 11.6c.1 6.6-2.7 10.8-7.8 14c-5.8 3.6-14.5 5.6-23.7 5.3c-11.8-.4-22.7-4.1-36.3-8.7l0 0 0 0 0 0c-2.3-.8-4.7-1.6-7.1-2.4c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2c2 .7 4.1 1.4 6.2 2.1l0 0c9.2 3.2 19.7 6.8 30.9 8.9V440c0 8.8 7.2 16 16 16s16-7.2 16-16V422.9c8.7-1.4 17.4-4.3 25.1-9.1c13.3-8.3 23.2-22.2 22.9-41.6c-.2-18.5-10.6-30.6-22.7-38.2c-11-6.9-25-11.2-36.3-14.6l0 0 0 0-.5-.1c-12.6-3.8-22.3-6.8-29.2-10.9c-6-3.6-7.2-6.4-7.3-10.1c0-5.4 2.4-9.4 8.1-12.8c6.2-3.7 15.1-5.7 23.6-5.5c10.1 .2 21 2.3 32.1 5.3c8.5 2.3 17.3-2.8 19.6-11.3s-2.8-17.3-11.3-19.6c-7.5-2-15.6-3.9-24.1-5.1V232c0-8.8-7.2-16-16-16z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM208 232c0-8.8-7.2-16-16-16s-16 7.2-16 16v17.3c-8.3 1.5-16.7 4.3-24.1 8.7c-13 7.7-23.9 21.1-23.8 40.5c.1 18.4 10.8 30.1 22.7 37.3c10.5 6.3 23.8 10.4 34.8 13.7l0 0 1.6 .5c12.5 3.8 22.2 6.9 29 11.2c5.9 3.7 7.7 7 7.7 11.6c.1 6.6-2.7 10.8-7.8 14c-5.8 3.6-14.5 5.6-23.7 5.3c-11.8-.4-22.7-4.1-36.3-8.7l0 0 0 0 0 0c-2.3-.8-4.7-1.6-7.1-2.4c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2c2 .7 4.1 1.4 6.2 2.1l0 0c9.2 3.2 19.7 6.8 30.9 8.9l0 17.8c0 8.8 7.2 16 16 16s16-7.2 16-16V422.9c8.7-1.4 17.4-4.3 25.1-9.1c13.3-8.3 23.2-22.2 22.9-41.6c-.2-18.5-10.6-30.6-22.7-38.2c-11-6.9-25-11.2-36.3-14.6l0 0 0 0-.5-.1c-12.6-3.8-22.3-6.8-29.2-10.9c-6-3.6-7.2-6.4-7.3-10.1c0-5.4 2.4-9.4 8.1-12.8c6.2-3.7 15.1-5.7 23.6-5.5c10.1 .2 21 2.3 32.1 5.3c8.5 2.3 17.3-2.8 19.6-11.3s-2.8-17.3-11.3-19.6c-7.5-2-15.6-3.9-24.1-5.1V232z"]],
    "pipe-smoking": [640, 512, [], "e3c4", ["M495.3 106.7C513.1 80 543.1 64 575.2 64H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H575.2C521.7 0 471.7 26.7 442 71.2L361.5 192c5.6 .3 11.2 2 16.2 5.3l24 16c5.8 3.9 9.9 9.3 12.2 15.4l81.3-122z", "M377.8 197.4c-14.7-9.8-34.6-5.8-44.4 8.9L256 322.3V272c0-26.5-21.5-48-48-48H48c-26.5 0-48 21.5-48 48v82.9C0 441.7 70.3 512 157.1 512c52.5 0 101.6-26.2 130.7-69.9L410.6 257.8c9.8-14.7 5.8-34.6-8.9-44.4l-24-16z"]],
    "face-astonished": [512, 512, [], "e36b", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-208c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V352c0-26.5 21.5-48 48-48zM144.4 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm141 .9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z", "M192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm-15.6 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM333 128.9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z"]],
    "window": [512, 512, [], "f40e", ["M160 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM512 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64V224l512 0V416zM288 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M64 32C28.7 32 0 60.7 0 96V224H512V96c0-35.3-28.7-64-64-64H64zM96 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM288 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "plane-circle-exclamation": [640, 512, [], "e556", ["M192 93.7C192 59.5 221 0 256 0c36 0 64 59.5 64 93.7v84.6l77.1 44.1C350.6 254 320 307.4 320 368c0 54.2 24.5 102.7 63.1 135c-2 5.3-7.1 9-13.1 9c-1.3 0-2.6-.2-3.9-.5L256 480 145.9 511.5c-1.3 .4-2.6 .5-3.9 .5c-7.8 0-14-6.3-14-14V456c0-5 2.4-9.8 6.4-12.8L192 400l0-70.9-171.6 49C10.2 381.1 0 373.4 0 362.8V297.3c0-5.7 3.1-11 8.1-13.9L192 178.3V93.7z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16V288z"]],
    "ear": [384, 512, [128066], "f5f0", ["M319.9 335.2c-18.2 16.3-30 39.1-35.1 62.9c-5.6 26.3-18.6 51.3-39 71.7c-56.2 56.2-147.4 56.2-203.6 0C14.1 441.7 0 404.9 0 368V192C0 86 86 0 192 0S384 86 384 192c0 56.9-24.8 108-64.1 143.2zM128 192c0-35.3 28.7-64 64-64s64 28.7 64 64v8c0 13.3 10.7 24 24 24s24-10.7 24-24v-8c0-61.9-50.1-112-112-112S80 130.1 80 192v20.2c0 21.2 12 40.6 31 50.1l14 7c1.8 .9 3 2.8 3 4.9c0 1.6-.7 3.2-2 4.2L88.6 309.6c-10.2 8.5-11.6 23.6-3.1 33.8s23.6 11.6 33.8 3.1l37.4-31.2C169 305.1 176 290.1 176 274.2c0-20.2-11.4-38.8-29.5-47.8l-14-7c-2.7-1.4-4.4-4.1-4.4-7.2V192z", "M192 128c-35.3 0-64 28.7-64 64v20.2c0 3 1.7 5.8 4.4 7.2l14 7c18.1 9.1 29.5 27.6 29.5 47.8c0 15.9-7 30.9-19.2 41.1l-37.4 31.2c-10.2 8.5-25.3 7.1-33.8-3.1s-7.1-25.3 3.1-33.8L126 278.4c1.2-1 2-2.6 2-4.2c0-2.1-1.2-4-3-4.9l-14-7c-19-9.5-31-28.9-31-50.1V192c0-61.9 50.1-112 112-112s112 50.1 112 112v8c0 13.3-10.7 24-24 24s-24-10.7-24-24v-8c0-35.3-28.7-64-64-64z"]],
    "file-lock": [576, 512, [], "e3a6", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384v33.6c-19.8 20.2-32 47.9-32 78.4v24.6c-19.1 11.1-32 31.7-32 55.4V480c0 11.4 3 22.2 8.3 31.5c-2.7 .3-5.5 .5-8.3 .5H64c-35.3 0-64-28.7-64-64V64z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zm80 80c17.7 0 32 14.3 32 32v48H432V272c0-17.7 14.3-32 32-32zm-80 32v48c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32H544c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32V272c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]],
    "diagram-venn": [640, 512, [], "e15a", ["M192 256c0-61 24.4-116.4 64-156.8c23.6 4.8 45.4 14.8 64 28.8c-38.9 29.2-64 75.7-64 128s25.1 98.8 64 128c-18.6 14-40.3 24-64 28.8C216.4 372.4 192 317 192 256zM384 412.8c39.6-40.4 64-95.7 64-156.8s-24.4-116.4-64-156.8c-8.6-8.8-17.9-16.9-27.9-24.1c-.5-.4-1-.7-1.5-1.1c-10.9-7.8-22.4-14.7-34.6-20.5C349.1 39.7 381.6 32 416 32c123.7 0 224 100.3 224 224s-100.3 224-224 224c-34.4 0-66.9-7.7-96-21.6c12.2-5.8 23.8-12.7 34.6-20.5c10.5-7.5 20.3-16 29.3-25.2z", "M352 352H288c-7.4-9.8-13.7-20.6-18.7-32H370.7c6.5-14.9 10.8-31.1 12.5-48H256.8c-.5-5.3-.8-10.6-.8-16s.3-10.7 .8-16H383.2c-1.7-16.9-6-33.1-12.5-48H269.3c5-11.4 11.3-22.2 18.7-32h64c-29.2-38.9-75.7-64-128-64C135.6 96 64 167.6 64 256s71.6 160 160 160c52.3 0 98.8-25.1 128-64zM0 256a224 224 0 1 1 448 0A224 224 0 1 1 0 256z"]],
    "x-ray": [512, 512, [], "f497", ["M480 96H32V416H480V96zM256 128c8.8 0 16 7.2 16 16v16h80c8.8 0 16 7.2 16 16s-7.2 16-16 16H272v32H384c8.8 0 16 7.2 16 16s-7.2 16-16 16H272v48c0 .4 0 .8 0 1.2l50.4-21.6c5.5-2.4 11.4-3.6 17.4-3.6h7.4c20.4 0 36.9 16.5 36.9 36.9c0 8.2-2.8 16.3-7.9 22.8l-19.4 24.8C347 376.8 332.1 384 316.4 384H195.6c-15.7 0-30.6-7.2-40.3-19.6l-19.4-24.8c-5.1-6.5-7.9-14.5-7.9-22.8c0-20.4 16.5-36.9 36.9-36.9h7.4c6 0 11.9 1.2 17.4 3.6L240 305.2c0-.4 0-.8 0-1.2V256H128c-8.8 0-16-7.2-16-16s7.2-16 16-16H240V192H160c-8.8 0-16-7.2-16-16s7.2-16 16-16h80V144c0-8.8 7.2-16 16-16zM208 352a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H32zm0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "goal-net": [640, 512, [], "e3ab", ["M160 144c0-8.8 7.2-16 16-16s16 7.2 16 16v48h64V144c0-8.8 7.2-16 16-16s16 7.2 16 16v48h64V144c0-8.8 7.2-16 16-16s16 7.2 16 16v48h64V144c0-8.8 7.2-16 16-16s16 7.2 16 16v48h48c8.8 0 16 7.2 16 16s-7.2 16-16 16H480v64h48c8.8 0 16 7.2 16 16s-7.2 16-16 16H480v64h48c8.8 0 16 7.2 16 16s-7.2 16-16 16H480v48c0 8.8-7.2 16-16 16s-16-7.2-16-16V416H384v48c0 8.8-7.2 16-16 16s-16-7.2-16-16V416H288v48c0 8.8-7.2 16-16 16s-16-7.2-16-16V416H192v48c0 8.8-7.2 16-16 16s-16-7.2-16-16V416H112c-8.8 0-16-7.2-16-16s7.2-16 16-16h48V320H112c-8.8 0-16-7.2-16-16s7.2-16 16-16h48V224H112c-8.8 0-16-7.2-16-16s7.2-16 16-16h48V144zm32 240h64V320H192v64zm96 0h64V320H288v64zm96 0h64V320H384v64zm64-160H384v64h64V224zm-96 0H288v64h64V224zm-96 0H192v64h64V224z", "M96 96c-17.7 0-32 14.3-32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V128C0 75 43 32 96 32H544c53 0 96 43 96 96V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V128c0-17.7-14.3-32-32-32H96z"]],
    "coffin-cross": [384, 512, [], "e051", ["M102.4 10.9l-91 104C4.1 123.3 0 134.2 0 145.4c0 4.4 .6 8.7 1.8 12.9L97.3 488.9c4 13.7 16.5 23.1 30.7 23.1H255.9c14.3 0 26.8-9.4 30.7-23.1l95.5-330.6c1.2-4.2 1.8-8.5 1.8-12.9c0-11.2-4.1-22.1-11.5-30.6l-91-104C275.5 4 266.7 0 257.5 0h-131c-9.2 0-18 4-24.1 10.9zM216 120v40h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H216V328c0 13.3-10.7 24-24 24s-24-10.7-24-24V208H120c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V120c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M216 120c0-13.3-10.7-24-24-24s-24 10.7-24 24v40H120c-13.3 0-24 10.7-24 24s10.7 24 24 24h48V328c0 13.3 10.7 24 24 24s24-10.7 24-24V208h48c13.3 0 24-10.7 24-24s-10.7-24-24-24H216V120z"]],
    "spell-check": [576, 512, [], "f891", ["M141.5 19.7C136.6 7.8 124.9 0 112 0S87.4 7.8 82.5 19.7l-66.7 160-13.3 32c-6.8 16.3 .9 35 17.2 41.8s35-.9 41.8-17.2L66.7 224h90.7l5.1 12.3c6.8 16.3 25.5 24 41.8 17.2s24-25.5 17.2-41.8l-13.3-32-66.7-160zM112 115.2L130.7 160H93.3L112 115.2zM288 0c-17.7 0-32 14.3-32 32v96 96c0 17.7 14.3 32 32 32h80c44.2 0 80-35.8 80-80c0-23.1-9.8-43.8-25.4-58.4c6-11.2 9.4-24 9.4-37.6c0-44.2-35.8-80-80-80H288zm80 80c0 8.8-7.2 16-16 16H320V64h32c8.8 0 16 7.2 16 16zM320 192V160h32 16c8.8 0 16 7.2 16 16s-7.2 16-16 16H320z", "M566.6 265.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0l-96-96c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L352 434.7 521.4 265.4c12.5-12.5 32.8-12.5 45.3 0z"]],
    "location-xmark": [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", ["M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM111 111c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z", "M145 111c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]],
    "circle-quarter-stroke": [512, 512, [], "e5d3", ["M64 256c0 106 86 192 192 192s192-86 192-192s-86-192-192-192V0C397.4 0 512 114.6 512 256s-114.6 256-256 256S0 397.4 0 256H64z", "M256 0C114.6 0 0 114.6 0 256l224 0c17.7 0 32-14.3 32-32L256 0z"]],
    "lasso": [576, 512, [], "f8c8", ["M576 176c0 97.2-128.9 176-288 176c-13.2 0-26.3-.5-39-1.6c4.6 12.8 7 26.5 7 40.6c0 66.8-54.2 121-121 121H64c-17.7 0-32-14.3-32-32s14.3-32 32-32h71c31.5 0 57-25.5 57-57c0-21.6-12.2-41.3-31.5-51l-46.8-23.4 .2-.4C44.7 284.1 0 233.2 0 176C0 78.8 128.9 0 288 0S576 78.8 576 176zM288 288c123.7 0 224-50.1 224-112s-100.3-112-224-112S64 114.1 64 176s100.3 112 224 112z", ""]],
    "slash": [640, 512, [], "f715", ["", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "person-to-portal": [512, 512, ["portal-enter"], "e022", ["M352.6 287.5c3.3 .3 6.7 .5 10.1 .5H384c17.7 0 32-14.3 32-32s-14.3-32-32-32H362.7c-3.5 0-6.8-.6-10-1.6C357.8 96.9 391.4 0 432 0c44.2 0 80 114.6 80 256s-35.8 256-80 256c-40.9 0-74.6-98-79.4-224.5z", "M320 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM125.7 175.5c9.9-9.9 23.4-15.5 37.5-15.5c1.9 0 3.8 .1 5.6 .3L137.6 254c-9.3 28 1.7 58.8 26.8 74.5l86.2 53.9-25.4 88.8c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l28.7-100.4c5.9-20.6-2.6-42.6-20.7-53.9L238 299l30.9-82.4 5.1 12.3C289 264.7 323.9 288 362.7 288H384c17.7 0 32-14.3 32-32s-14.3-32-32-32H362.7c-12.9 0-24.6-7.8-29.5-19.7l-6.3-15c-14.6-35.1-44.1-61.9-80.5-73.1l-48.7-15c-11.1-3.4-22.7-5.2-34.4-5.2c-31 0-60.8 12.3-82.7 34.3L57.4 153.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l23.1-23.1zM91.2 352H32c-17.7 0-32 14.3-32 32s14.3 32 32 32h69.6c19 0 36.2-11.2 43.9-28.5L157 361.6l-9.5-6c-17.5-10.9-30.5-26.8-37.9-44.9L91.2 352z"]],
    "calendar-star": [512, 512, [], "f736", ["M480 192H32V464c0 26.5 21.5 48 48 48H432c26.5 0 48-21.5 48-48V192zM265.3 250.9l23.6 47.8 52.7 7.7c8.5 1.2 11.9 11.7 5.8 17.7l-38.2 37.2 9 52.5c1.5 8.5-7.5 15-15.1 11L256 400l-47.2 24.8c-7.6 4-16.5-2.5-15.1-11l9-52.5-38.2-37.2c-6.2-6-2.8-16.5 5.8-17.7l52.7-7.7 23.6-47.8c3.8-7.7 14.8-7.7 18.7 0z", "M160 0c-17.7 0-32 14.3-32 32V64H80c-26.5 0-48 21.5-48 48v80H480V112c0-26.5-21.5-48-48-48H384V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V64H192V32c0-17.7-14.3-32-32-32zM265.3 250.9c-3.8-7.7-14.8-7.7-18.7 0l-23.6 47.8-52.7 7.7c-8.5 1.2-11.9 11.7-5.8 17.7l38.2 37.2-9 52.5c-1.5 8.5 7.5 15 15.1 11L256 400l47.2 24.8c7.6 4 16.5-2.5 15.1-11l-9-52.5 38.2-37.2c6.2-6 2.8-16.5-5.8-17.7l-52.7-7.7-23.6-47.8z"]],
    "computer-mouse": [384, 512, [128433, "mouse"], "f8cc", ["M0 192H176V0H160C71.6 0 0 71.6 0 160v32zm0 32V352c0 88.4 71.6 160 160 160h64c88.4 0 160-71.6 160-160V224H192 0zm384-32V160C384 71.6 312.4 0 224 0H208V192H384z", "M176 192H0v32H192 384V192H208V0H176V192z"]],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", ["M320 448c0-17.7 14.3-32 32-32l64 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c53 0 96 43 96 96l0 256c0 53-43 96-96 96l-64 0c-17.7 0-32-14.3-32-32z", "M342.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L242.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l210.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"]],
    "pegasus": [576, 512, [], "f703", ["M76.3 168.8C68.5 181.6 64 196.7 64 212.8c0 3.6 .2 7.1 .7 10.7C54.6 230.8 48 242.6 48 256v56c0 13.3-10.7 24-24 24s-24-10.7-24-24V256c0-44.6 33.2-81.5 76.3-87.2z", "M448 238.1V160h16l9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1V80c0-19.1-8.4-36.3-21.7-48H560c8.8 0 16-7.2 16-16s-7.2-16-16-16H480 448C378.4 0 321.7 55.6 320 124.8L184.9 34.7c-4.9-3.3-11.2-3.6-16.4-.8s-8.5 8.2-8.5 14.1c0 48.1 3.8 99.9 26 139.8c9.2 16.6 21.7 31.3 38.2 42.7c-7.2-2.5-14-5.4-20.3-8.8c-22.5-12.1-38.6-29.4-49.9-49.8c-7.3-13.2-12.7-27.8-16.5-43C96 134.3 64 169.8 64 212.8c0 16.8 5 33.1 14.2 47.1l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9h33.7c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l84 24c4.1 1.2 8.2 2.1 12.3 2.8V480c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V315.7c19.2-19.2 31.5-45.7 32-75.7h0v-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "files-medical": [448, 512, [], "f7fd", ["M352 0H160C124.7 0 96 28.7 96 64V352c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96H384c-17.7 0-32-14.3-32-32V0zM240 176c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48h48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H304v48c0 8.8-7.2 16-16 16H256c-8.8 0-16-7.2-16-16V288H192c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16h48V176z", "M352 64V0l96 96H384c-17.7 0-32-14.3-32-32zM24 96c13.3 0 24 10.7 24 24V376c0 48.6 39.4 88 88 88H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H136C60.9 512 0 451.1 0 376V120c0-13.3 10.7-24 24-24zm216 80c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v48h48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H304v48c0 8.8-7.2 16-16 16H256c-8.8 0-16-7.2-16-16V288H192c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16h48V176z"]],
    "nfc-lock": [576, 512, [], "e1f8", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H320V416H112c-26.5 0-48-21.5-48-48V144c0-26.5 21.5-48 48-48h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16 7.2-16 16V368c0 8.8 7.2 16 16 16H320V352c0-23.7 12.9-44.4 32-55.4V272 144c0-8.8-7.2-16-16-16H256c-8.8 0-16 7.2-16 16v66.7c18.6 6.6 32 24.4 32 45.3c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V144c0-26.5 21.5-48 48-48h80c26.5 0 48 21.5 48 48v49.6c16.8-17.1 39.1-28.9 64-32.5V96c0-35.3-28.7-64-64-64H64z", "M432 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H384c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "person-ski-lift": [512, 512, ["ski-lift"], "f7c8", ["M240 0c8.8 0 16 7.2 16 16V198.3l-32 8.5V16c0-8.8 7.2-16 16-16zM13.6 178.3c12-5.7 26.3-.7 32 11.3l65 135.8c8.3 17.4 28 26.4 46.6 21.3l36.5-9.9c12.8-3.5 26 4.1 29.5 16.8s-4.1 26-16.8 29.5l-36.5 9.9c-41 11.2-84.2-8.6-102.5-46.9L2.3 210.4c-5.7-12-.7-26.3 11.3-32zM488 288c13.3 0 24 10.7 24 24v1c0 33.5-20.9 63.4-52.3 75L128.3 510.5c-12.4 4.6-26.2-1.8-30.8-14.2s1.8-26.2 14.2-30.8L443.1 343c12.6-4.6 20.9-16.6 20.9-30v-1c0-13.3 10.7-24 24-24z", "M64 80a48 48 0 1 1 96 0A48 48 0 1 1 64 80zm36.4 138c-14.2-30.8 8.3-66 42.2-66c18.2 0 34.8 10.7 42.3 27.3l28.8 63.4 55.9-14.9c25.4-6.8 50.3 12.4 50.3 38.6V388.5l-64 23.7V297.7l-66.7 17.8c-22.6 6-46.2-5.1-55.9-26.3L100.4 218z"]],
    "square-6": [448, 512, [], "e25b", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM224 240a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm-96 48c0 53 43 96 96 96s96-43 96-96c0-44-29.6-81.1-70-92.4l29.6-25.4c10.1-8.6 11.2-23.8 2.6-33.8s-23.8-11.2-33.8-2.6l-81.6 70C142.2 224.8 128 255.6 128 288z", "M279.6 170.2c10.1-8.6 11.2-23.8 2.6-33.8s-23.8-11.2-33.8-2.6l-81.6 70C142.2 224.8 128 255.6 128 288c0 53 43 96 96 96s96-43 96-96c0-44-29.6-81.1-70-92.4l29.6-25.4zM272 288a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"]],
    "shop-slash": [640, 512, ["store-alt-slash"], "e070", ["M121.8 192L21 112.5 6.2 134.7c-4 6.1-6.2 13.2-6.2 20.4C0 175.5 16.5 192 36.8 192h85zM384 398.5l-64-50.4V384H128V224H64V384v80c0 26.5 21.5 48 48 48H336c26.5 0 48-21.5 48-48V398.5zM543.7 512c.1 0 .2 0 .3 0s.2 0 .3 0h-.6zM320 225.5l64 50.2V224H320v1.5zM512 376l64 50.2V224H512V376zM74.1 32.8L277.2 192H603.2c20.3 0 36.8-16.5 36.8-36.8c0-7.3-2.2-14.4-6.2-20.4L558.2 21.4C549.3 8 534.4 0 518.3 0H121.7c-16 0-31 8-39.9 21.4L74.1 32.8z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "wind-turbine": [512, 512, [], "f89b", ["M224 265.7V464H152c-13.3 0-24 10.7-24 24s10.7 24 24 24H360c13.3 0 24-10.7 24-24s-10.7-24-24-24H288V369.7l-64-104z", "M345.2 404.1c2.5 17.2-20.3 25.5-29.5 10.7L214 249.4c-1.8-2.9-4.5-5.2-7.7-6.5L25.7 171.4C9.5 165 13.7 141 31.1 140.6l194.1-5.4c3.5-.1 6.8-1.3 9.5-3.5L387 11c13.6-10.8 32.3 4.8 24 20.1L318.6 202c-1.6 3-2.3 6.5-1.8 9.9l28.4 192.1zM256 216a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "sliders-simple": [512, 512, [], "e253", ["M325.5 192L32 192c-17.7 0-32-14.3-32-32s14.3-32 32-32H325.5c-3.5 10-5.5 20.8-5.5 32s1.9 22 5.5 32zM186.5 384c3.5-10 5.5-20.8 5.5-32s-1.9-22-5.5-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H186.5z", "M416 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-128a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM96 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-128a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]],
    "grid-round": [448, 512, [], "e5da", ["M224 32a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM64 192a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm96 224a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM384 192a64 64 0 1 0 0 128 64 64 0 1 0 0-128z", "M128 96A64 64 0 1 1 0 96a64 64 0 1 1 128 0zm0 320A64 64 0 1 1 0 416a64 64 0 1 1 128 0zm96-96a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM448 96A64 64 0 1 1 320 96a64 64 0 1 1 128 0zM384 480a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"]],
    "badge-sheriff": [448, 512, [], "f8a2", ["M224 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128z", "M272 48c0 14.8-6.7 28-17.2 36.8l25 42.8c5.7 9.8 16.2 15.8 27.5 15.9l47.6 .2c6.7-18.5 24.4-31.7 45.2-31.7c26.5 0 48 21.5 48 48s-21.5 48-48 48c-5.9 0-11.6-1.1-16.9-3.1L363 240.1c-5.6 9.8-5.6 21.9 0 31.8l20.1 35.2c5.3-2 10.9-3.1 16.9-3.1c26.5 0 48 21.5 48 48s-21.5 48-48 48c-20.8 0-38.5-13.2-45.2-31.7l-47.6 .2c-11.3 0-21.8 6.1-27.5 15.9l-25 42.8c10.5 8.8 17.2 22 17.2 36.8c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-14.8 6.7-28 17.2-36.8l-25-42.8c-5.7-9.8-16.2-15.8-27.5-15.9l-47.6-.2C86.5 386.8 68.8 400 48 400c-26.5 0-48-21.5-48-48s21.5-48 48-48c5.9 0 11.6 1.1 16.9 3.1L85 271.9c5.6-9.8 5.6-21.9 0-31.8L64.9 204.9c-5.3 2-10.9 3.1-16.9 3.1c-26.5 0-48-21.5-48-48s21.5-48 48-48c20.8 0 38.5 13.2 45.2 31.7l47.6-.2c11.3 0 21.8-6.1 27.5-15.9l25-42.8C182.7 76 176 62.8 176 48c0-26.5 21.5-48 48-48s48 21.5 48 48zM224 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "server": [512, 512, [], "f233", ["M416 152a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM64 288c-35.3 0-64 28.7-64 64v64c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V352c0-35.3-28.7-64-64-64H64zm280 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z", "M64 32C28.7 32 0 60.7 0 96v64c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm280 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm48 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm32 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "virus-covid-slash": [640, 512, [], "e4a9", ["M472.1 344.7c11.4-19.5 19.1-41.4 22.3-64.7H528v16c0 13.3 10.7 24 24 24s24-10.7 24-24V216c0-13.3-10.7-24-24-24s-24 10.7-24 24v16H494.4c-4.2-30.7-16.3-58.8-34.1-82.3L484 125.9l11.3 11.3c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L472.7 46.7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L450.1 92l-23.8 23.8C402.8 97.9 374.7 85.8 344 81.6V48h16c13.3 0 24-10.7 24-24s-10.7-24-24-24H280c-13.3 0-24 10.7-24 24s10.7 24 24 24h16V81.6c-30.7 4.2-58.8 16.3-82.3 34.1L189.9 92l11.3-11.3c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L134.1 79.8 472.1 344.7zm-70.8 67.5L149.2 213.5c-1.5 6-2.7 12.2-3.5 18.5H112V216c0-13.3-10.7-24-24-24s-24 10.7-24 24v80c0 13.3 10.7 24 24 24s24-10.7 24-24V280h33.6c4.2 30.7 16.3 58.8 34.1 82.3L156 386.1l-11.3-11.3c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56.6 56.6c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L189.9 420l23.8-23.8c23.5 17.9 51.7 29.9 82.3 34.1V464H280c-13.3 0-24 10.7-24 24s10.7 24 24 24h80c13.3 0 24-10.7 24-24s-10.7-24-24-24H344V430.4c20.4-2.8 39.7-9.1 57.3-18.2z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "intersection": [384, 512, [8898], "f668", ["M32 480c17.7 0 32-14.3 32-32V224c0-70.7 57.3-128 128-128s128 57.3 128 128V448c0 17.7 14.3 32 32 32s32-14.3 32-32V224c0-106-86-192-192-192S0 118 0 224V448c0 17.7 14.3 32 32 32z", ""]],
    "shop-lock": [640, 512, [], "e4a5", ["M449.6 192H36.8C16.5 192 0 175.5 0 155.2c0-7.3 2.2-14.4 6.2-20.4L81.8 21.4C90.7 8 105.6 0 121.7 0H518.3c16.1 0 31 8 39.9 21.4l75.6 113.3c4 6.1 6.2 13.2 6.2 20.4c0 19.3-14.8 35.1-33.7 36.7C586.1 172.2 558.5 160 528 160c-30.5 0-58.2 12.2-78.4 32zM384 352v32 80c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48V384 224h64V384H320V224h64V352z", "M496 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "family": [512, 512, [], "e300", ["M128 0a64 64 0 1 1 0 128A64 64 0 1 1 128 0zM105.6 160h44.8c9.2 0 18.1 1.6 26.4 4.5c-.5 3.8-.8 7.6-.8 11.5c0 24.3 10.9 46.1 28 60.8c-35.7 18.7-60 56.1-60 99.2v16c0 28.4 12.4 54 32 71.6V480c0 6.1 .8 11.9 2.4 17.5c-8.7 9-20.9 14.5-34.4 14.5H112c-26.5 0-48-21.5-48-48V348.3c-26.5-9.5-44.7-35.8-42.2-65.6l4.1-49.3C29.3 191.9 64 160 105.6 160zM368 512c-13.5 0-25.7-5.6-34.4-14.5c1.6-5.6 2.4-11.4 2.4-17.5V423.6c19.6-17.6 32-43.1 32-71.6V336c0-43.1-24.3-80.5-60-99.2c17.1-14.7 28-36.5 28-60.8c0-2.4-.1-4.7-.3-7.1c9.6-5.7 20.8-8.9 32.6-8.9h31.4c28.6 0 53.7 18.9 61.5 46.4l39.1 136.8c5.8 20.4-9.5 40.8-30.8 40.8H448v80c0 26.5-21.5 48-48 48H368zM384 0a64 64 0 1 1 0 128A64 64 0 1 1 384 0z", "M208 176a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM176 336c0-44.2 35.8-80 80-80s80 35.8 80 80v16c0 23.7-12.9 44.4-32 55.4V480c0 17.7-14.3 32-32 32H240c-17.7 0-32-14.3-32-32V407.4c-19.1-11.1-32-31.7-32-55.4V336z"]],
    "hourglass-start": [384, 512, ["hourglass-1"], "f251", ["M32 437v11H96V437c0-25.5 10.1-49.9 28.1-67.9L192 301.3l67.9 67.9c18 18 28.1 42.4 28.1 67.9v11h64V437c0-42.4-16.9-83.1-46.9-113.1L237.3 256l67.9-67.9c30-30 46.9-70.7 46.9-113.1V64H288V75c0 25.5-10.1 49.9-28.1 67.9L192 210.7l-67.9-67.9C106.1 124.9 96 100.4 96 75V64H32V75c0 42.4 16.9 83.1 46.9 113.1L146.7 256 78.9 323.9l22.6 22.6L78.9 323.9C48.9 353.9 32 394.6 32 437z", "M0 480c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H32c-17.7 0-32 14.3-32 32zM0 32C0 49.7 14.3 64 32 64l64 0V75c0 25.5 10.1 49.9 28.1 67.9L192 210.7l67.9-67.9c18-18 28.1-42.4 28.1-67.9V64l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32H32C14.3 0 0 14.3 0 32z"]],
    "user-hair-buns": [448, 512, [], "e3d3", ["M224 80c14.6 19.4 37.8 32 64 32h32v64c0 53-43 96-96 96s-96-43-96-96V112h32c26.2 0 49.4-12.6 64-32z", "M109.8 70.1C131 28.5 174.1 0 224 0s93 28.5 114.2 70.1c6.8-3.9 14.7-6.1 23.1-6.1c25.8 0 46.7 20.9 46.7 46.7V136c0 30.9-25.1 56-56 56H318.7c.9-5.2 1.3-10.5 1.3-16V112H288c-26.2 0-49.4-12.6-64-32c-14.6 19.4-37.8 32-64 32H128v64c0 5.5 .5 10.8 1.3 16H96c-30.9 0-56-25.1-56-56V110.7C40 84.9 60.9 64 86.7 64c8.4 0 16.2 2.2 23.1 6.1zM0 481.3C0 392.2 72.2 320 161.3 320H286.7C375.8 320 448 392.2 448 481.3c0 17-13.8 30.7-30.7 30.7H30.7C13.8 512 0 498.2 0 481.3z"]],
    "blender-phone": [576, 512, [], "f6b6", ["M224 384L196.3 52C194 24 216.1 0 244.2 0H535c20.8 0 36.1 19.6 31 39.8L560 64H400c-8.8 0-16 7.2-16 16s7.2 16 16 16H552l-16 64H400c-8.8 0-16 7.2-16 16s7.2 16 16 16H528l-16 64H400c-8.8 0-16 7.2-16 16s7.2 16 16 16H504l-24 96H224z", "M147.5 30.7c10.8 6.7 15.3 21 10.6 33.4l-22 57.8c-4.2 10.9-14.5 17.6-25.3 16.4l-33.3-3.6c-13.6 42.2-13.6 88.4 0 130.7l33.3-3.6c10.9-1.2 21.2 5.5 25.3 16.4l22 57.8c4.7 12.4 .2 26.7-10.6 33.4l-44 27.2c-9.7 6-21.9 4.2-29.8-4.3C-24.6 286-24.6 114 73.7 7.8C81.6-.7 93.8-2.5 103.5 3.5l44 27.2zM560 64l-8 32H400c-8.8 0-16-7.2-16-16s7.2-16 16-16H560zm-24 96l-8 32H400c-8.8 0-16-7.2-16-16s7.2-16 16-16H536zm-24 96l-8 32H400c-8.8 0-16-7.2-16-16s7.2-16 16-16H512zM208 384H496c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48H208c-26.5 0-48-21.5-48-48V432c0-26.5 21.5-48 48-48zm144 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "hourglass-clock": [576, 512, [], "e41b", ["M0 32C0 14.3 14.3 0 32 0H64 320h32c17.7 0 32 14.3 32 32s-14.3 32-32 32V75c0 42.4-16.9 83.1-46.9 113.1L237.3 256l36 36c-11 23-17.2 48.8-17.2 76c0 59.5 29.6 112.1 74.8 144H320 64 32c-17.7 0-32-14.3-32-32s14.3-32 32-32V437c0-42.4 16.9-83.1 46.9-113.1L146.7 256 78.9 188.1C48.9 158.1 32 117.4 32 75V64C14.3 64 0 49.7 0 32zM96 64V75c0 19 5.6 37.4 16 53H272c10.3-15.6 16-34 16-53V64H96z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208v48h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H432c-8.8 0-16-7.2-16-16V304c0-8.8 7.2-16 16-16s16 7.2 16 16z"]],
    "person-seat-reclined": [512, 512, [], "e21f", ["M58.1 128.5c17.4-3.3 34.1 8.2 37.3 25.6l33.3 177.7c5.7 30.3 32.1 52.2 62.9 52.2H272c17.7 0 32 14.3 32 32s-14.3 32-32 32H191.7c-61.6 0-114.5-43.9-125.8-104.4L32.5 165.9c-3.3-17.4 8.2-34.1 25.6-37.3z", "M128 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM257 256l8 32h53.8c33.3 0 63.2 20.7 74.9 51.9l25.5 68 18.7-6.2c16.8-5.6 34.9 3.5 40.5 20.2s-3.5 34.9-20.2 40.5l-48 16c-16.3 5.4-34-3-40.1-19.1l-36.3-96.9c-2.3-6.2-8.3-10.4-15-10.4H240.7c-.5 0-.9 0-1.4 0H233c-29.4 0-55-20-62.1-48.5L149.8 219c-7.5-30 15.2-59 46.1-59c20.4 0 38.4 13 44.9 32H320c17.7 0 32 14.3 32 32s-14.3 32-32 32H257z"]],
    "paper-plane-top": [512, 512, ["paper-plane-alt", "send"], "e20a", ["M-1.2 83.5c-18-33.4 16.3-70.8 51.1-55.7L491.8 219.3c32.1 13.9 32.1 59.5 0 73.4L49.9 484.2c-34.8 15.1-69.1-22.3-51.1-55.7L75.2 286.6 266 262.7c3.4-.4 6-3.3 6-6.7s-2.6-6.3-6-6.7L75.2 225.4-1.2 83.5z", "M75.2 286.6L266 262.7c3.4-.4 6-3.3 6-6.7s-2.6-6.3-6-6.7L75.2 225.4l8.3 15.4c5.1 9.5 5.1 20.9 0 30.3l-8.3 15.4z"]],
    "message-arrow-up": [512, 512, ["comment-alt-arrow-up"], "e1dc", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zM280 296V177.9l31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31V296c0 13.3 10.7 24 24 24s24-10.7 24-24z", "M256 320c13.3 0 24-10.7 24-24V177.9l31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31V296c0 13.3 10.7 24 24 24z"]],
    "lightbulb-exclamation": [384, 512, [], "f671", ["M321.2 297.8c-19.8 27.1-39.7 54.4-49.2 86.2H112c-9.6-31.9-29.5-59.1-49.2-86.2c-5.2-7.1-10.4-14.2-15.4-21.4C27.6 247.9 16 213.3 16 176C16 78.8 94.8 0 192 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4zM192 64c-13.3 0-24 10.7-24 24V200c0 13.3 10.7 24 24 24s24-10.7 24-24V88c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M192 512c44.2 0 80-35.8 80-80V384H112v48c0 44.2 35.8 80 80 80z"]],
    "layer-minus": [576, 512, ["layer-group-minus"], "f5fe", ["M264.5 133.2c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 277.8C37.4 273.8 32 265.3 32 256s5.4-17.9 13.9-21.8l218.6-101zM476.9 337.6l53.2 24.6c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 405.8C37.4 401.8 32 393.3 32 384s5.4-17.9 13.9-21.8l53.2-24.6 152 70.2c23.4 10.8 50.4 10.8 73.8 0l152-70.2z", "M384 80c0-13.3 10.7-24 24-24H520c13.3 0 24 10.7 24 24s-10.7 24-24 24H408c-13.3 0-24-10.7-24-24z"]],
    "chart-pie-simple-circle-currency": [640, 512, [], "e604", ["M509.8 192.5c-4.6-.4-9.2-.5-13.8-.5c-46.8 0-89.3 18.2-120.8 48H272V16.6c0-9 7-16.6 16-16.6C401 0 494.5 83.7 509.8 192.5zM339.2 288c-12.3 24-19.2 51.2-19.2 80c0 42.5 15 81.4 40.1 111.8C324.8 500.3 283.8 512 240 512C107.5 512 0 404.6 0 272C0 156.5 81.5 60.1 190.2 37.2c18.1-3.8 33.8 11 33.8 29.5V288H339.2z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm25.4-169.4a35.9 35.9 0 1 0 -50.7 50.7 35.9 35.9 0 1 0 50.7-50.7zM460.7 426l-17.3 17.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L438 403.3c-13.2-21.6-13.2-49.1 0-70.7l-17.3-17.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L460.7 310c21.6-13.2 49.1-13.2 70.7 0l17.3-17.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L554 332.7c13.2 21.6 13.2 49.1 0 70.7l17.3 17.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L531.3 426c-21.6 13.2-49.1 13.2-70.7 0z"]],
    "circle-e": [512, 512, [], "e109", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H208v56h88c13.3 0 24 10.7 24 24s-10.7 24-24 24H208v56H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24V256 152c0-13.3 10.7-24 24-24z", "M160 152c0-13.3 10.7-24 24-24H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H208v56h88c13.3 0 24 10.7 24 24s-10.7 24-24 24H208v56H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24V256 152z"]],
    "building-wheat": [640, 512, [], "e4db", ["M0 48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48H240V432c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-26.5 0-48-21.5-48-48V48zM80 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H80zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H272zM64 112v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H176zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z", "M640 208l0-16-16 0c-44.2 0-80 35.8-80 80l0 16 16 0c44.2 0 80-35.8 80-80zm0 96l-16 0c-44.2 0-80 35.8-80 80l0 16 16 0c44.2 0 80-35.8 80-80l0-16zm0 112l-16 0c-44.2 0-80 35.8-80 80l0 16 16 0c44.2 0 80-35.8 80-80l0-16zM512 512l0-16c0-44.2-35.8-80-80-80l-16 0 0 16c0 44.2 35.8 80 80 80l16 0zm0-128c0-44.2-35.8-80-80-80l-16 0 0 16c0 44.2 35.8 80 80 80l16 0 0-16zm0-96l0-16c0-44.2-35.8-80-80-80l-16 0 0 16c0 44.2 35.8 80 80 80l16 0zM552 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104zm48 16c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24zM480 96c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32z"]],
    "gauge-max": [512, 512, ["tachometer-alt-fastest"], "f626", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM288 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM256 416c-35.3 0-64-28.7-64-64s28.7-64 64-64c14.1 0 27.2 4.6 37.8 12.4l117.5-72.8c11.3-7 26.1-3.5 33 7.8s3.5 26.1-7.8 33L319.1 341.2c.6 3.5 .9 7.1 .9 10.8c0 35.3-28.7 64-64 64zM400 144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM96 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm80-80a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M411.4 227.6c11.3-7 26.1-3.5 33 7.8s3.5 26.1-7.8 33L319.1 341.2c.6 3.5 .9 7.1 .9 10.8c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c14.1 0 27.2 4.6 37.8 12.4l117.6-72.8z"]],
    "person-breastfeeding": [448, 512, [], "e53a", ["M160 288c17.7 0 32 14.3 32 32v36.8c25.4 29.7 60.8 49.3 99.7 54.8l.8 .1c-9.1 19.6-4.1 43.6 13.5 57.7c6.4 5.1 13.7 8.3 21.2 9.7c-3.7 .9-7.7 1.1-11.7 .5L282.7 475c-9.1-1.3-18.1-3.2-27-5.6c2.2-19.5-7.7-39.1-26.2-48.4L128.1 370.4c-.1-.8-.1-1.6-.1-2.4V320c0-17.7 14.3-32 32-32zm72 44a44 44 0 1 1 88 0 44 44 0 1 1 -88 0z", "M224 0a80 80 0 1 1 0 160A80 80 0 1 1 224 0zM436.8 382.8L373.5 462c-16.6 20.7-46.8 24.1-67.5 7.5c-17.6-14.1-22.7-38.1-13.5-57.7l-.8-.1c-38.9-5.6-74.3-25.1-99.7-54.8V320c0-17.7-14.3-32-32-32s-32 14.3-32 32v48c0 .8 0 1.6 .1 2.4l101.4 50.7c23.7 11.9 33.3 40.7 21.5 64.4s-40.7 33.3-64.4 21.5L27.2 427.3c-1.1-.5-2.2-1.1-3.3-1.7c-4.9-2.8-9.2-6.4-12.6-10.6c-4.6-5.4-7.8-11.7-9.6-18.4c-3.3-12-1.9-25.2 4.8-36.6c.6-1.1 1.3-2.2 2-3.2L75.6 256.1c26.7-40.1 71.7-64.1 119.8-64.1h75.2c46.5 0 90.1 22.5 117.2 60.3l50.7 70.9c2.2 3 4 6.1 5.5 9.4c2.9 6.7 4.3 13.8 4 20.8c-.3 10.6-4.2 21-11.2 29.4zM320 332a44 44 0 1 0 -88 0 44 44 0 1 0 88 0z"]],
    "apostrophe": [192, 512, [], "27", ["M72 352c66.3 0 120-53.7 120-120V160 128 96c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96v64c0 35.3 28.7 64 64 64h64v8c0 30.9-25.1 56-56 56H64c-17.7 0-32 14.3-32 32s14.3 32 32 32h8z", ""]],
    "fire-hydrant": [384, 512, [], "e17f", ["M192 0c17.7 0 32 14.3 32 32v4c45 11.6 80.4 47 92 92h12c13.3 0 24 10.7 24 24s-10.7 24-24 24H56c-13.3 0-24-10.7-24-24s10.7-24 24-24H68c11.6-45 47-80.4 92-92V32c0-17.7 14.3-32 32-32zM16 304c0-17.7 14.3-32 32-32H64V400H48c-17.7 0-32-14.3-32-32V304zm320-32c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H320V272h16z", "M64 176H320V464h8c13.3 0 24 10.7 24 24s-10.7 24-24 24h-8H64 56c-13.3 0-24-10.7-24-24s10.7-24 24-24h8V176zM192 400a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", ["M320 448c0-17.7 14.3-32 32-32l64 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c53 0 96 43 96 96l0 256c0 53-43 96-96 96l-64 0c-17.7 0-32-14.3-32-32z", "M340.7 228.7L217.9 105.9c-6.4-6.4-15-9.9-24-9.9c-18.7 0-33.9 15.2-33.9 33.9l0 62.1L32 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0 0 62.1c0 18.7 15.2 33.9 33.9 33.9c9 0 17.6-3.6 24-9.9L340.7 283.3c7.2-7.2 11.3-17.1 11.3-27.3s-4.1-20.1-11.3-27.3z"]],
    "video-plus": [576, 512, [], "f4e1", ["M64 64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zM216 184v48h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H216v48c0 13.3-10.7 24-24 24s-24-10.7-24-24V280H120c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V184c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M559.1 99.8c10.4 5.6 16.9 16.4 16.9 28.2V384c0 11.8-6.5 22.6-16.9 28.2s-23 5-32.9-1.6L384 315.8V196.2l142.2-94.8c9.8-6.5 22.4-7.2 32.9-1.6zM216 184v48h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H216v48c0 13.3-10.7 24-24 24s-24-10.7-24-24V280H120c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V184c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "square-right": [448, 512, [10145, "arrow-alt-square-right"], "f352", ["M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM262.6 135.1l99.9 107.1c3.5 3.8 5.5 8.7 5.5 13.8s-2 10.1-5.5 13.8L262.6 376.9c-4.2 4.5-10.1 7.1-16.3 7.1C234 384 224 374 224 361.7l0-57.7-96 0c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l96 0 0-57.7c0-12.3 10-22.3 22.3-22.3c6.2 0 12.1 2.6 16.3 7.1z", "M362.5 242.2L262.6 135.1c-4.2-4.5-10.1-7.1-16.3-7.1C234 128 224 138 224 150.3l0 57.7-96 0c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l96 0 0 57.7c0 12.3 10 22.3 22.3 22.3c6.2 0 12.1-2.6 16.3-7.1l99.9-107.1c3.5-3.8 5.5-8.7 5.5-13.8s-2-10.1-5.5-13.8z"]],
    "comment-smile": [512, 512, [], "f4b4", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM192 144a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM150.5 270.1c9.9-8.8 25-8 33.9 1.9c17.6 19.7 43.1 32 71.6 32s53.9-12.3 71.6-32c8.8-9.9 24-10.7 33.9-1.9s10.7 24 1.9 33.9C337 333.4 298.6 352 256 352s-81-18.6-107.3-48c-8.8-9.9-8-25 1.9-33.9z", "M224 176a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM184.4 272c-8.8-9.9-24-10.7-33.9-1.9s-10.7 24-1.9 33.9c26.3 29.4 64.7 48 107.3 48s81-18.6 107.3-48c8.8-9.9 8-25-1.9-33.9s-25-8-33.9 1.9c-17.6 19.7-43.1 32-71.6 32s-53.9-12.3-71.6-32z"]],
    "venus": [384, 512, [9792], "f221", ["M112 176a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z", "M80 176a112 112 0 1 1 224 0A112 112 0 1 1 80 176zM224 349.1c81.9-15 144-86.8 144-173.1C368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1V384H128c-17.7 0-32 14.3-32 32s14.3 32 32 32h32v32c0 17.7 14.3 32 32 32s32-14.3 32-32V448h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H224V349.1z"]],
    "passport": [448, 512, [], "f5ab", ["M183 278.8c-6.8-17.1-12.9-40.4-14.6-70.8H129.3c5.3 31.4 25.8 57.6 53.7 70.8zm41.3 9.2c2.4-3.5 5.7-8.9 9.1-16.5c6-13.6 12.4-34.3 14.2-63.5H200.5c1.8 29.2 8.1 49.9 14.2 63.5c3.4 7.6 6.7 13 9.1 16.5c.1 0 .2 0 .3 0s.2 0 .3 0zm40.7-9.2c27.9-13.2 48.4-39.4 53.7-70.8H279.6c-1.6 30.4-7.7 53.8-14.6 70.8zM279.6 176h39.1c-5.3-31.4-25.8-57.6-53.7-70.8c6.8 17.1 12.9 40.4 14.6 70.8zM223.7 96c-2.4 3.5-5.7 8.9-9.1 16.5c-6 13.6-12.4 34.3-14.2 63.5h47.1c-1.8-29.2-8.1-49.9-14.2-63.5c-3.4-7.6-6.7-13-9.1-16.5c-.1 0-.2 0-.3 0s-.2 0-.3 0zM183 105.2c-27.9 13.2-48.4 39.4-53.7 70.8h39.1c1.6-30.4 7.7-53.8 14.6-70.8zM96 192a128 128 0 1 1 256 0A128 128 0 1 1 96 192z", "M0 64C0 28.7 28.7 0 64 0H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM183 278.8c-27.9-13.2-48.4-39.4-53.7-70.8h39.1c1.6 30.4 7.7 53.8 14.6 70.8zm41.3 9.2l-.3 0-.3 0c-2.4-3.5-5.7-8.9-9.1-16.5c-6-13.6-12.4-34.3-14.2-63.5h47.1c-1.8 29.2-8.1 49.9-14.2 63.5c-3.4 7.6-6.7 13-9.1 16.5zm40.7-9.2c6.8-17.1 12.9-40.4 14.6-70.8h39.1c-5.3 31.4-25.8 57.6-53.7 70.8zM279.6 176c-1.6-30.4-7.7-53.8-14.6-70.8c27.9 13.2 48.4 39.4 53.7 70.8H279.6zM223.7 96l.3 0 .3 0c2.4 3.5 5.7 8.9 9.1 16.5c6 13.6 12.4 34.3 14.2 63.5H200.5c1.8-29.2 8.1-49.9 14.2-63.5c3.4-7.6 6.7-13 9.1-16.5zM183 105.2c-6.8 17.1-12.9 40.4-14.6 70.8H129.3c5.3-31.4 25.8-57.6 53.7-70.8zM352 192A128 128 0 1 0 96 192a128 128 0 1 0 256 0zM112 384c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H112z"]],
    "inbox-in": [512, 512, [128229, "inbox-arrow-down"], "f310", ["M124.2 320H48c-26.5 0-48 21.5-48 48v96c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V368c0-26.5-21.5-48-48-48H387.8c-12.1 0-23.2 6.8-28.6 17.7l-14.3 28.6c-5.4 10.8-16.5 17.7-28.6 17.7H195.8c-12.1 0-23.2-6.8-28.6-17.7l-14.3-28.6c-5.4-10.8-16.5-17.7-28.6-17.7z", "M256 0c17.7 0 32 14.3 32 32V210.7l41.4-41.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-96 96c-12.5 12.5-32.8 12.5-45.3 0l-96-96c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 210.7V32c0-17.7 14.3-32 32-32z"]],
    "heart-pulse": [512, 512, ["heartbeat"], "f21e", ["M228.3 469.1L47.6 300.4c-4.2-3.9-8.2-8.1-11.9-12.4h87c22.6 0 43-13.6 51.7-34.5l10.5-25.2 49.3 109.5c3.8 8.5 12.1 14 21.4 14.1s17.8-5 22-13.3L320 253.7l1.7 3.4c9.5 19 28.9 31 50.1 31H476.3c-3.7 4.3-7.7 8.5-11.9 12.4L283.7 469.1c-7.5 7-17.4 10.9-27.7 10.9s-20.2-3.9-27.7-10.9zM503.7 240h-132c-3 0-5.8-1.7-7.2-4.4l-23.2-46.3c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-41.4 82.8L205.9 158.2c-3.9-8.7-12.7-14.3-22.2-14.1s-18.1 5.9-21.8 14.8l-31.8 76.3c-1.2 3-4.2 4.9-7.4 4.9H16c-2.6 0-5 .4-7.3 1.1C3 225.2 0 208.2 0 190.9v-5.8c0-69.9 50.5-129.5 119.4-141C165 36.5 211.4 51.4 244 84l12 12 12-12c32.6-32.6 79-47.5 124.6-39.9C461.5 55.6 512 115.2 512 185.1v5.8c0 16.9-2.8 33.5-8.3 49.1z", "M35.7 288h87c22.6 0 43-13.6 51.7-34.5l10.5-25.2 49.3 109.5c3.8 8.5 12.1 14 21.4 14.1s17.8-5 22-13.3L320 253.7l1.7 3.4c9.5 19 28.9 31 50.1 31H476.3c12.1-14.2 21.4-30.5 27.4-48h-132c-3 0-5.8-1.7-7.2-4.4l-23.2-46.3c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-41.4 82.8L205.9 158.2c-3.9-8.7-12.7-14.3-22.2-14.1s-18.1 5.9-21.8 14.8l-31.8 76.3c-1.2 3-4.2 4.9-7.4 4.9H16c-2.6 0-5 .4-7.3 1.1c6.1 17 15.2 32.9 27 46.9z"]],
    "circle-8": [512, 512, [], "e0f5", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM264 128H248c-39.8 0-72 32.2-72 72c0 15.7 5 30.1 13.5 42c-18 14.7-29.5 37-29.5 62c0 44.2 35.8 80 80 80h32c44.2 0 80-35.8 80-80c0-25-11.5-47.4-29.5-62c8.5-11.8 13.5-26.3 13.5-42c0-39.8-32.2-72-72-72zm-16 96c-13.2 0-24-10.8-24-24s10.7-24 24-24h16c13.3 0 24 10.7 24 24s-10.7 24-24 24c0 0 0 0 0 0H248s0 0 0 0zm16 48h8c17.7 0 32 14.3 32 32s-14.3 32-32 32H240c-17.7 0-32-14.3-32-32s14.3-32 32-32h8 16z", "M336 200c0-39.8-32.2-72-72-72H248c-39.8 0-72 32.2-72 72c0 15.7 5 30.1 13.5 42c-18 14.7-29.5 37-29.5 62c0 44.2 35.8 80 80 80h32c44.2 0 80-35.8 80-80c0-25-11.5-47.4-29.5-62c8.5-11.8 13.5-26.3 13.5-42zm-72 72h8c17.7 0 32 14.3 32 32s-14.3 32-32 32H240c-17.7 0-32-14.3-32-32s14.3-32 32-32h8c0 0 0 0 0 0h16c0 0 0 0 0 0zm0-48H248c-13.2 0-24-10.8-24-24s10.7-24 24-24h16c13.3 0 24 10.7 24 24s-10.7 24-24 24z"]],
    "clouds-moon": [640, 512, [], "f745", ["M352 160C352 71.7 423.4 0 511.5 0c4.6 0 9.1 .2 13.5 .6c7 .6 12.8 5.7 14.3 12.5s-1.6 13.9-7.7 17.3c-35.4 20.1-59.3 58.2-59.3 101.9c0 64.6 52.2 116.9 116.5 116.9c6.8 0 13.5-.6 20-1.7c6.9-1.2 13.8 2.2 17 8.5s1.9 13.8-3.1 18.7C594 302.8 554.8 320 511.5 320c-3.8 0-7.5-.1-11.2-.4c-11.3-9.9-24.2-17.8-38.5-23.2c-9.9-53.2-52.6-94.8-106.4-103c-2.3-10.8-3.5-22-3.5-33.4z", "M208.1 224c12.9 0 25.3 2.2 36.8 6.2c19.6-19.9 45.8-33.5 75-37.2l0-.9c0-35.3-28.6-64-64-64c-7.4 0-14.6 1.3-21.2 3.6c-11.5-30.1-40.6-51.6-74.8-51.6c-38.9 0-71.3 27.8-78.5 64.6c-3.1-.4-6.3-.6-9.5-.6c-39.8 0-72 32.2-72 72s32.2 72 72 72c16.1 0 30.9-5.3 42.9-14.1c20.1-30.1 54.3-49.9 93.2-49.9zM64 431.9c0 44.2 35.8 80 80 80H415.9c53 0 96-43 96-96c0-47.6-34.6-87-80-94.6l0-1.3c0-53-43-96-96-96c-34.9 0-65.4 18.6-82.2 46.4C240.8 261.3 225 256 208 256c-44.2 0-80 35.8-80 80c0 5.9 .6 11.7 1.9 17.2C92.4 359.9 64 392.6 64 431.9z"]],
    "clock-ten-thirty": [512, 512, [], "e355", ["M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V256c0-8-4-15.5-10.7-20l-96-64c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3L232 268.8V392c0 13.3 10.7 24 24 24s24-10.7 24-24z", "M256 416c13.3 0 24-10.7 24-24V256c0-8-4-15.5-10.7-20l-96-64c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3L232 268.8V392c0 13.3 10.7 24 24 24z"]],
    "people-carry-box": [640, 512, ["people-carry"], "f4ce", ["M248.6 319.2c-2.4-.6-4.7-1.4-7-2.5l-.6-.3c2.4 1.2 4.9 2.2 7.5 2.8zm134.7 .8H256.6c11.5-.2 22.5-6.7 28-17.7c7.9-15.8 1.5-35-14.3-42.9L224 236.2V160c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32v76.2l-46.3 23.2c-15.8 7.9-22.2 27.1-14.3 42.9c5.5 11 16.5 17.4 28 17.7zm8.5-1c2.5-.6 4.8-1.5 7-2.7l-.5 .3c-2.1 1.1-4.3 1.9-6.5 2.4z", "M176 48A48 48 0 1 0 80 48a48 48 0 1 0 96 0zM144 306.7V241.7l19 28.5c4.6 7 11 12.6 18.5 16.3l60.2 30.1c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9l-56.4-28.2L166.5 160c-13.3-20-35.8-32-59.9-32C74.2 128 48 154.2 48 186.6v88.1c0 17 6.7 33.3 18.7 45.3l79.4 79.4 14.3 85.9c2.9 17.4 19.4 29.2 36.8 26.3s29.2-19.4 26.3-36.8l-15.2-90.9c-1.6-9.9-6.3-19-13.4-26.1l-51-51zM2.3 468.1c-6.6 16.4 1.4 35 17.8 41.6s35-1.4 41.6-17.8l37.6-94L50.1 348.6 2.3 468.1zM464 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm32 258.7l-51 51c-7.1 7.1-11.8 16.2-13.4 26.1l-15.2 90.9c-2.9 17.4 8.9 33.9 26.3 36.8s33.9-8.9 36.8-26.3l14.3-85.9L573.3 320c12-12 18.7-28.3 18.7-45.3V186.6c0-32.4-26.2-58.6-58.6-58.6c-24.1 0-46.5 12-59.9 32l-47.4 71.1-56.4 28.2c-15.8 7.9-22.2 27.1-14.3 42.9s27.1 22.2 42.9 14.3l60.2-30.1c7.5-3.7 13.8-9.4 18.5-16.3l19-28.5v65.1zM637.7 468.1L589.9 348.6l-49.2 49.2 37.6 94c6.6 16.4 25.2 24.4 41.6 17.8s24.4-25.2 17.8-41.6z"]],
    "folder-user": [512, 512, [], "e18e", ["M512 416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H192c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8H448c35.3 0 64 28.7 64 64V416zM320 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM144 405.3c0 5.9 4.8 10.7 10.7 10.7H357.3c5.9 0 10.7-4.8 10.7-10.7c0-29.5-23.9-53.3-53.3-53.3H197.3c-29.5 0-53.3 23.9-53.3 53.3z", "M256 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-58.7 32c-29.5 0-53.3 23.9-53.3 53.3c0 5.9 4.8 10.7 10.7 10.7H357.3c5.9 0 10.7-4.8 10.7-10.7c0-29.5-23.9-53.3-53.3-53.3H197.3z"]],
    "trash-can-xmark": [448, 512, [], "e2ae", ["M416 96H32V448c0 35.3 28.7 64 64 64H352c35.3 0 64-28.7 64-64V96zM143 207c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM143 207c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z"]],
    "temperature-high": [512, 512, [], "f769", ["M144 64c-26.5 0-48 21.5-48 48V276.5c0 17.3-7.1 31.9-15.3 42.5C70.2 332.6 64 349.5 64 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-18.5-6.2-35.4-16.7-48.9c-8.2-10.6-15.3-25.2-15.3-42.5V112c0-26.5-21.5-48-48-48zM32 112C32 50.2 82.1 0 144 0s112 50.1 112 112V276.5c0 .1 .1 .3 .2 .6c.2 .6 .8 1.6 1.7 2.8c18.9 24.4 30.1 55 30.1 88.1c0 79.5-64.5 144-144 144S0 447.5 0 368c0-33.2 11.2-63.8 30.1-88.1c.9-1.2 1.5-2.2 1.7-2.8c.1-.3 .2-.5 .2-.6V112z", "M416 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 128A96 96 0 1 0 416 0a96 96 0 1 0 0 192zM144 96c-8.8 0-16 7.2-16 16V322.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V112c0-8.8-7.2-16-16-16z"]],
    "microchip": [512, 512, [], "f2db", ["M152 0c-13.3 0-24 10.7-24 24V64h48V24c0-13.3-10.7-24-24-24zm80 24V64h48V24c0-13.3-10.7-24-24-24s-24 10.7-24 24zm104 0V64h48V24c0-13.3-10.7-24-24-24s-24 10.7-24 24zM488 128H448v48h40c13.3 0 24-10.7 24-24s-10.7-24-24-24zm0 104H448v48h40c13.3 0 24-10.7 24-24s-10.7-24-24-24zm0 104H448v48h40c13.3 0 24-10.7 24-24s-10.7-24-24-24zM384 488V448H336v40c0 13.3 10.7 24 24 24s24-10.7 24-24zM280 448H232v40c0 13.3 10.7 24 24 24s24-10.7 24-24V448zm-104 0H128v40c0 13.3 10.7 24 24 24s24-10.7 24-24V448zM24 384H64V336H24c-13.3 0-24 10.7-24 24s10.7 24 24 24zM64 280V232H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H64zM24 128c-13.3 0-24 10.7-24 24s10.7 24 24 24H64V128H24zm328 32H160V352H352V160z", "M128 64c-35.3 0-64 28.7-64 64V384c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H128zm32 64H352c17.7 0 32 14.3 32 32V352c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32z"]],
    "left-long-to-line": [640, 512, [], "e41e", ["M32 64C14.3 64 0 78.3 0 96V416c0 17.7 14.3 32 32 32s32-14.3 32-32V96c0-17.7-14.3-32-32-32z", "M305.5 414c-8.8 3.8-19 2-26-4.6l-144-136c-4.8-4.5-7.5-10.8-7.5-17.4s2.7-12.9 7.5-17.4l144-136c7-6.6 17.2-8.4 26-4.6s14.5 12.5 14.5 22l0 72 288 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-288 0 0 72c0 9.6-5.7 18.2-14.5 22z"]],
    "crown": [576, 512, [128081], "f521", ["M248 72a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM0 136a40 40 0 1 1 80 0A40 40 0 1 1 0 136zM536 96a40 40 0 1 1 0 80 40 40 0 1 1 0-80z", "M504 160l-89.1 71.3c-15.9 12.7-39.5 7.5-48.6-10.7L309 106c-6.1 3.8-13.3 6-21 6s-14.9-2.2-21-6L209.7 220.6c-9.1 18.2-32.7 23.4-48.6 10.7L72 160c-7.2 9.5-18.5 15.8-31.3 16L86.4 427.4c5.5 30.4 32 52.6 63 52.6H426.6c30.9 0 57.4-22.1 63-52.6L535.3 176c-12.8-.2-24.1-6.5-31.3-16z"]],
    "weight-hanging": [512, 512, [], "f5cd", ["M224 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm122.5 32c3.5-10 5.5-20.8 5.5-32c0-53-43-96-96-96s-96 43-96 96c0 11.2 1.9 22 5.5 32H256h90.5z", "M120 128c-22 0-41.2 15-46.6 36.4l-72 288c-3.6 14.3-.4 29.5 8.7 41.2S33.2 512 48 512H464c14.8 0 28.7-6.8 37.8-18.5s12.3-26.8 8.7-41.2l-72-288C433.2 143 414 128 392 128H120z"]],
    "xmarks-lines": [640, 512, [], "e59a", ["M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H32zm0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z", "M177 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47L49 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47L15 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47zM273 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47zM463 175c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z"]],
    "file-prescription": [384, 512, [], "f572", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM104 196c-11 0-20 9-20 20v80 64c0 11 9 20 20 20s20-9 20-20V316h20c.7 .9 1.5 1.8 2.3 2.6l64.8 60.8-32.6 29.9c-8.1 7.5-8.7 20.1-1.2 28.3s20.1 8.7 28.3 1.2l34.9-32 33.9 31.8c8.1 7.6 20.7 7.1 28.3-.9s7.1-20.7-.9-28.3L270 379.7l31.6-28.9c8.1-7.5 8.7-20.1 1.2-28.3s-20.1-8.7-28.3-1.2l-33.8 31-43-40.3c22.4-8.7 38.3-30.5 38.3-55.9c0-33.1-26.9-60-60-60H104zm72 80H124V236h52c11 0 20 9 20 20s-9 20-20 20z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM104 196c-11 0-20 9-20 20v80 64c0 11 9 20 20 20s20-9 20-20V316h20c.7 .9 1.5 1.8 2.3 2.6l64.8 60.8-32.6 29.9c-8.1 7.5-8.7 20.1-1.2 28.3s20.1 8.7 28.3 1.2l34.9-32 33.9 31.8c8.1 7.6 20.7 7.1 28.3-.9s7.1-20.7-.9-28.3L270 379.7l31.6-28.9c8.1-7.5 8.7-20.1 1.2-28.3s-20.1-8.7-28.3-1.2l-33.8 31-43-40.3c22.4-8.7 38.3-30.5 38.3-55.9c0-33.1-26.9-60-60-60H104zm72 80H124V236h52c11 0 20 9 20 20s-9 20-20 20z"]],
    "calendar-range": [512, 512, [], "e0d6", ["M32 192H480V464c0 26.5-21.5 48-48 48H80c-26.5 0-48-21.5-48-48V192zm64 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm288 96a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM224 288c0 13.3 10.7 24 24 24H392c13.3 0 24-10.7 24-24s-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm40 104H120c-13.3 0-24 10.7-24 24s10.7 24 24 24H264c13.3 0 24-10.7 24-24s-10.7-24-24-24z", "M128 32c0-17.7 14.3-32 32-32s32 14.3 32 32V64H320V32c0-17.7 14.3-32 32-32s32 14.3 32 32V64h48c26.5 0 48 21.5 48 48v80H32V112c0-26.5 21.5-48 48-48h48V32zm32 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM384 448a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM224 288c0-13.3 10.7-24 24-24H392c13.3 0 24 10.7 24 24s-10.7 24-24 24H248c-13.3 0-24-10.7-24-24zm40 104c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24s10.7-24 24-24H264z"]],
    "flower-daffodil": [512, 512, [9880], "f800", ["M224 394.8V281.3c12.7-5.6 23.8-14.4 32-25.3c8.2 11 19.3 19.8 32 25.3V394.8c31.9-45.2 84.5-74.8 144-74.8h50.5c16.3 0 29.5 13.2 29.5 29.5C512 439.3 439.3 512 349.5 512H288 256 224 162.5C72.7 512 0 439.3 0 349.5C0 333.2 13.2 320 29.5 320H80c59.5 0 112.1 29.6 144 74.8z", "M320 288c-26.2 0-49.4-12.6-64-32c-14.6 19.4-37.8 32-64 32c-44.2 0-80-35.8-80-80c0-26.2 12.6-49.4 32-64c-19.4-14.6-32-37.8-32-64c0-44.2 35.8-80 80-80c26.2 0 49.4 12.6 64 32c14.6-19.4 37.8-32 64-32c44.2 0 80 35.8 80 80c0 26.2-12.6 49.4-32 64c19.4 14.6 32 37.8 32 64c0 44.2-35.8 80-80 80zm-64-96a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "hand-back-point-up": [448, 512, [], "e1a2", ["M136 0C113.9 0 96 17.9 96 40V240v7 73c0 8.8-7.2 16-16 16s-16-7.2-16-16V264.3c-2 1.4-3.9 3-5.8 4.5L39 284.8C24.4 297 16 315 16 334V372c0 38 16.9 74 46.1 98.3l5.4 4.5c28.8 24 65 37.1 102.4 37.1H288c70.7 0 128-57.3 128-128V320 288c0-26.5-21.5-48-48-48c-12.4 0-23.6 4.7-32.1 12.3C334 227.5 313.3 208 288 208c-12.4 0-23.6 4.7-32.1 12.3C254 195.5 233.3 176 208 176c-12.3 0-23.5 4.6-32 12.2V40c0-22.1-17.9-40-40-40z", ""]],
    "weight-scale": [512, 512, ["weight"], "f496", ["M80 176a176 176 0 1 1 352 0A176 176 0 1 1 80 176zm216 48c0-10.6-4.1-20.2-10.9-27.4l33.6-78.3c3.5-8.1-.3-17.5-8.4-21s-17.5 .3-21 8.4L255.7 184c-22 .1-39.7 18-39.7 40c0 22.1 17.9 40 40 40s40-17.9 40-40z", "M256 352c97.2 0 176-78.8 176-176c0-42.5-15.1-81.6-40.2-112H448c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128C0 92.7 28.7 64 64 64h56.2C95.1 94.4 80 133.5 80 176c0 97.2 78.8 176 176 176zm40-128c0 22.1-17.9 40-40 40s-40-17.9-40-40c0-22 17.8-39.9 39.7-40l33.6-78.3c3.5-8.1 12.9-11.9 21-8.4s11.9 12.9 8.4 21l-33.6 78.3c6.7 7.2 10.9 16.8 10.9 27.4z"]],
    "star-exclamation": [576, 512, [], "f2f3", ["M288.1 0c12.2 0 23.4 7 28.8 18l64.3 132.3 143.6 21.2c12 1.8 22 10.2 25.7 21.7s.7 24.2-7.9 32.7L438.5 329l24.6 145.7c2 12-3 24.2-12.9 31.3s-23 8-33.8 2.3L288.1 439.8 159.8 508.3C149 514 135.9 513.1 126 506s-14.9-19.3-12.9-31.3L137.8 329 33.6 225.9c-8.6-8.5-11.7-21.2-7.9-32.7s13.7-19.9 25.7-21.7L195 150.3 259.4 18c5.4-11 16.5-18 28.8-18zM288 128c-13.3 0-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M312 152c0-13.3-10.7-24-24-24s-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152zM288 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "books": [512, 512, [128218], "f5db", ["M0 32C0 14.3 14.3 0 32 0H96c17.7 0 32 14.3 32 32V96H0V32zm0 96H128V384H0V128zM0 416H128v64c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V416zM160 32c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32V96H160V32zm0 96H288V384H160V128zm0 288H288v64c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V416zM289.4 117.8L412.2 85l8.2 30.9L297.6 148.8l-8.2-30.9zm74.2 278.3l122.8-32.9 8.2 30.9L371.8 427l-8.2-30.9z", "M288 112.6l1.4 5.2L412.2 85 395.8 23.7c-4.5-17-22-27.1-38.9-22.6L295.5 17.6c-2.7 .7-5.2 1.8-7.5 3.1L288 96H160v32H288l0-15.4zm132.4 3.2L297.6 148.8l66 247.4 122.8-32.9-66-247.4zM388.2 488.3c4.5 17 22 27.1 38.9 22.6l61.4-16.5c16.9-4.6 27-22.1 22.5-39.1l-16.3-61.1L371.8 427l16.3 61.3zM0 96v32H128V96H0zM128 384H0v32H128V384zm160 0H160v32H288V384z"]],
    "user-group": [640, 512, [128101, "user-friends"], "f500", ["M609.3 512H471.4c5.4-9.4 8.6-20.3 8.6-32v-8c0-60.7-27.1-115.2-69.8-151.8c2.4-.1 4.7-.2 7.1-.2h61.4C567.8 320 640 392.2 640 481.3c0 17-13.8 30.7-30.7 30.7zM432 256c-31 0-59-12.6-79.3-32.9C372.4 196.5 384 163.6 384 128c0-26.8-6.6-52.1-18.3-74.3C384.3 40.1 407.2 32 432 32c61.9 0 112 50.1 112 112s-50.1 112-112 112z", "M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3z"]],
    "arrow-up-a-z": [576, 512, ["sort-alpha-up"], "f15e", ["M416 32c12.1 0 23.2 6.8 28.6 17.7l64 128 16 32c7.9 15.8 1.5 35-14.3 42.9s-35 1.5-42.9-14.3L460.2 224H371.8l-7.2 14.3c-7.9 15.8-27.1 22.2-42.9 14.3s-22.2-27.1-14.3-42.9l16-32 64-128C392.8 38.8 403.9 32 416 32zM395.8 176h40.4L416 135.6 395.8 176zM352 352c-17.7 0-32-14.3-32-32s14.3-32 32-32H480c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9L429.3 416H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H352c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L402.7 352H352z", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V146.3L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32z"]],
    "layer-plus": [576, 512, ["layer-group-plus"], "f5ff", ["M264.5 133.2c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 277.8C37.4 273.8 32 265.3 32 256s5.4-17.9 13.9-21.8l218.6-101zM476.9 337.6l53.2 24.6c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 405.8C37.4 401.8 32 393.3 32 384s5.4-17.9 13.9-21.8l53.2-24.6 152 70.2c23.4 10.8 50.4 10.8 73.8 0l152-70.2z", "M488 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32H408c-13.3 0-24 10.7-24 24s10.7 24 24 24h32l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24V104h32c13.3 0 24-10.7 24-24s-10.7-24-24-24H488V24z"]],
    "play-pause": [640, 512, [], "e22f", ["M416 64c17.7 0 32 14.3 32 32V416c0 17.7-14.3 32-32 32s-32-14.3-32-32V96c0-17.7 14.3-32 32-32zm128 0c17.7 0 32 14.3 32 32V416c0 17.7-14.3 32-32 32s-32-14.3-32-32V96c0-17.7 14.3-32 32-32z", "M116.5 71.4c-9.5-7.9-22.8-9.7-34.1-4.4S64 83.6 64 96V416c0 12.4 7.2 23.7 18.4 29s24.5 3.6 34.1-4.4l192-160c7.3-6.1 11.5-15.1 11.5-24.6s-4.2-18.5-11.5-24.6l-192-160z"]],
    "block-question": [448, 512, [], "e3dd", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm73.8 141.3c7.9-22.3 29.1-37.3 52.8-37.3h58.3c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L248 272.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24V258.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H190.6c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM192 360a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM48 104a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM376 80a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM48 408a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm328-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z", "M48 104a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm304 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM72 384a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm280 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM137.8 173.3c7.9-22.3 29.1-37.3 52.8-37.3h58.3c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L248 272.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24V258.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H190.6c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM192 360a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "snooze": [448, 512, [128164, "zzz"], "f880", ["M160 32c0-17.7 14.3-32 32-32h96c12.1 0 23.2 6.8 28.6 17.7s4.3 23.8-3 33.5L256 128h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-12.1 0-23.2-6.8-28.6-17.7s-4.3-23.8 3-33.5L224 64H192c-17.7 0-32-14.3-32-32zM288 256c0-17.7 14.3-32 32-32h96c12.1 0 23.2 6.8 28.6 17.7s4.3 23.8-3 33.5L384 352h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H320c-12.1 0-23.2-6.8-28.6-17.7s-4.3-23.8 3-33.5L352 288H320c-17.7 0-32-14.3-32-32z", "M0 288c0-17.7 14.3-32 32-32H192c12.4 0 23.7 7.2 29 18.4s3.6 24.5-4.4 34.1L100.3 448H192c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-12.4 0-23.7-7.2-29-18.4s-3.6-24.5 4.4-34.1L123.7 320H32c-17.7 0-32-14.3-32-32z"]],
    "scanner-image": [576, 512, [], "f8f3", ["M64 288c-35.3 0-64 28.7-64 64v64c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V352c0-35.3-28.7-64-64-64H64zm0 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M35.8 48.9c8.3-15.6 27.7-21.5 43.3-13.2L525.2 273.7c20.9 11.2 36.6 29.4 44.7 50.9C559.6 303 537.5 288 512 288H416L48.9 92.2C33.3 83.9 27.4 64.5 35.8 48.9zM96 352a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "tv-retro": [512, 512, [128250], "f401", ["M169 7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l55 55H80C35.8 96 0 131.8 0 176V432c0 44.2 35.8 80 80 80H432c44.2 0 80-35.8 80-80V176c0-44.2-35.8-80-80-80H321.9l55-55c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-87 87L169 7zM424 232a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM64 224c0-35.3 28.7-64 64-64H320c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H128c-35.3 0-64-28.7-64-64V224z", "M64 224c0-35.3 28.7-64 64-64H320c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H128c-35.3 0-64-28.7-64-64V224z"]],
    "square-t": [448, 512, [], "e280", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm56 112H224 328c13.3 0 24 10.7 24 24s-10.7 24-24 24H248V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V192H120c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M96 168c0-13.3 10.7-24 24-24H224 328c13.3 0 24 10.7 24 24s-10.7 24-24 24H248V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V192H120c-13.3 0-24-10.7-24-24z"]],
    "farm": [576, 512, ["barn-silo"], "f864", ["M160 270.3V480c0 17.7 14.3 32 32 32H304V448c0-26.5 21.5-48 48-48h32c26.5 0 48 21.5 48 48v64H544c17.7 0 32-14.3 32-32V270.3c0-4.2-.8-8.3-2.4-12.2L524.7 139.4c-3-7.4-8.7-13.3-15.9-16.7L381.7 62.5c-8.7-4.1-18.7-4.1-27.4 0L227.2 122.7c-7.2 3.4-12.9 9.4-15.9 16.7L162.4 258.1c-1.6 3.9-2.4 8-2.4 12.2zM344 224h48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H344c-13.3 0-24-10.7-24-24V248c0-13.3 10.7-24 24-24z", "M0 96H192c0-53-43-96-96-96S0 43 0 96zm181.4 32H0V464c0 26.5 21.5 48 48 48h88.6c-5.4-9.4-8.6-20.3-8.6-32V270.3c0-8.4 1.6-16.6 4.8-24.4l48.6-118zM344 224c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V248c0-13.3-10.7-24-24-24H344z"]],
    "chess-knight": [448, 512, [9822], "f441", ["M384 432H64L22.6 473.4c-4.2 4.2-6.6 10-6.6 16C16 501.9 26.1 512 38.6 512H409.4c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L384 432z", "M82.7 61.3L96 48 74.9 37.5C68.2 34.1 64 27.3 64 19.8C64 8.9 72.9 0 83.8 0H224C330 0 416 86 416 192v17.3c0 9.8-.7 19.5-2.2 29.2L384 432H64V418.7c0-31.7 15.7-61.4 41.9-79.3l112.6-76.8c10.5-7.2 10.9-22.6 .7-30.3c-6.6-5-15.7-5-22.3 0l-49.4 37c-2.3 1.7-4.8 3.2-7.3 4.5l-3.2 1.6c-15.4 7.7-33.8 6.6-48.1-3l-10.6-7C69.3 259.6 64 249.6 64 238.9V106.5c0-17 6.7-33.3 18.7-45.3zM140 136a20 20 0 1 0 0-40 20 20 0 1 0 0 40z"]],
    "bars-sort": [448, 512, [], "e0ae", ["M0 256c0-17.7 14.3-32 32-32H288c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z", "M448 96c0-17.7-14.3-32-32-32H32C14.3 64 0 78.3 0 96s14.3 32 32 32H416c17.7 0 32-14.3 32-32zM192 416c0-17.7-14.3-32-32-32H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H160c17.7 0 32-14.3 32-32z"]],
    "pallet-boxes": [640, 512, [57863, "palette-boxes", "pallet-alt"], "f483", ["M32 320c-17.7 0-32 14.3-32 32s14.3 32 32 32H64v64H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H96 320 544h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H576V384h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H544 320 96 32zm96 64H288v64H128V384zm224 0H512v64H352V384z", "M96 0C78.3 0 64 14.3 64 32V224c0 17.7 14.3 32 32 32H288c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H96zM416 64c-17.7 0-32 14.3-32 32V224c0 17.7 14.3 32 32 32H544c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32H416z"]],
    "face-laugh-squint": [512, 512, ["laugh-squint"], "f59b", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM96.8 314.1c-3.8-13.7 7.4-26.1 21.6-26.1H393.6c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zm36.7-199.4l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6c0-9 9.6-14.7 17.5-10.5zM396 125.1c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z", "M116 125.1c0-9 9.6-14.7 17.5-10.5l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm280 0c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z"]],
    "code-simple": [576, 512, [], "e13d", ["M361.4 73.4c-12.5 12.5-12.5 32.8 0 45.3L498.7 256 361.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0z", "M214.6 73.4c12.5 12.5 12.5 32.8 0 45.3L77.3 256 214.6 393.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3l160-160c12.5-12.5 32.8-12.5 45.3 0z"]],
    "bolt-slash": [640, 512, [], "e0b8", ["M154.8 218l88.9 70H160c-13.3 0-25.3-8.3-30-20.7s-1.1-26.6 8.9-35.3L154.8 218zm109.6 86.4L374.4 391 245.1 504.1c-11.2 9.8-27.8 10.6-39.9 1.8s-16.5-24.8-10.6-38.5l69.9-163zm236.6-24.3l-52.7 46.1L228.4 153.7 394.9 7.9c11.2-9.8 27.8-10.6 39.9-1.8s16.5 24.8 10.6 38.5L368.5 224H480c13.3 0 25.3 8.3 30 20.7s1.2 26.6-8.9 35.3z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "panel-fire": [640, 512, [], "e42f", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H337.6c-31-34.7-49.6-80.6-49.6-129.9c0-2 .1-4 .2-6.1c-.1 0-.1 0-.2 0c-13.3 0-24-10.7-24-24s10.7-24 24-24c3.5 0 6.9 .8 9.9 2.1c6.7-19 16.4-37.8 27.2-55.4c3.8-6.2 7.9-12.5 12.3-18.7H96c-17.7 0-32-14.3-32-32V128c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32v39.4c9-9.4 18.5-18.6 28.5-27.5c10-8.9 23-12.8 35.5-11.7V96c0-35.3-28.7-64-64-64H64zM96 296a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm72 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z", "M443.7 159.9c3.5 0 7 1.3 9.8 3.8c19.7 17.8 38.2 37 55.5 57.7c7.9-9.9 16.8-20.7 26.5-29.5c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 58.8 24.2 79c0 87.8-71.3 159.8-160 159.8c-89.7 0-160-72.1-160-159.8c0-26.4 12.7-60.7 32.4-92.6c20-32.4 48.1-66.1 81.4-95.8c2.8-2.5 6.4-3.8 10-3.7zm37.3 288c18 0 34-5 49-15c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78z"]],
    "binary-circle-check": [640, 512, [], "e33c", ["M336 32V160h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H304 256c-17.7 0-32-14.3-32-32s14.3-32 32-32h16V76.4l-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16C303.6-1.6 314.4 0 322.7 6s13.3 15.7 13.3 26zM112 320V448h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H80 32c-17.7 0-32-14.3-32-32s14.3-32 32-32H48V364.4l-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16c9.8-3.3 20.5-1.6 28.8 4.4s13.3 15.7 13.3 26zM0 64C0 28.7 28.7 0 64 0h64c35.3 0 64 28.7 64 64v96c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zm128 0H64v96h64V64zM256 288h64c6.2 0 12.2 .9 17.9 2.5c-11.2 22.9-17.6 48.6-17.9 75.7V352H256v96h64v0h19.2c7.8 15.3 17.8 29.3 29.5 41.5C357 503.3 339.5 512 320 512H256c-35.3 0-64-28.7-64-64V352c0-35.3 28.7-64 64-64zm64 96V369.8c0 4.8 .3 9.5 .7 14.2H320z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "comment-minus": [512, 512, [], "f4b1", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM184 216H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M160 240c0-13.3 10.7-24 24-24H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24z"]],
    "burrito": [512, 512, [127791], "f7ed", ["M33.9 270.1L251.4 52.6C274.4 82.3 288 119.6 288 160c0 18-2.7 35.4-7.7 51.7C258.2 283.7 191.2 336 112 336c-37.8 0-72.8-11.9-101.5-32.2c5.7-12.4 13.6-23.9 23.4-33.7zM352 224c40.4 0 77.7 13.6 107.4 36.6L241.9 478.1C220.2 499.8 190.7 512 160 512s-60.2-12.2-81.9-33.9L33.9 433.9C12.2 412.2 0 382.7 0 352c0-5.4 .4-10.7 1.1-16c32.1 20.3 70.1 32 110.9 32c90.5 0 167.5-57.8 196.1-138.5c14-3.6 28.7-5.5 43.9-5.5z", "M320 160c0-53.6-20.3-102.5-53.6-139.4C280.6 7.8 299.4 0 320 0c11.4 0 22.2 2.4 32 6.7C361.8 2.4 372.6 0 384 0c34.6 0 64.1 22 75.2 52.8C490 63.9 512 93.4 512 128c0 11.4-2.4 22.2-6.7 32c4.3 9.8 6.7 20.6 6.7 32c0 20.6-7.8 39.4-20.6 53.6C454.5 212.3 405.6 192 352 192c-11.9 0-23.6 1-34.9 2.9c1.9-11.4 2.9-23 2.9-34.9z"]],
    "violin": [640, 512, [127931], "f8ed", ["M544 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM496 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM417 177.7C398 166.5 375.7 160 352 160c-20.8 0-40.4 5-57.8 13.8c-6.7 3.4-9.1 11.4-7.7 18.8c1 5 1.5 10.2 1.5 15.4c0 44.2-35.8 80-80 80c-11.6 0-22.7-2.5-32.7-7c-7.4-3.3-16.6-2.4-21.3 4.3C137.6 308.7 128 337.2 128 368c0 26.7 7.3 51.7 19.9 73.1l50.5-37.9c6.4-4.8 15.3-4.1 20.9 1.5l16 16c5.6 5.6 6.3 14.5 1.5 20.9l-37.9 50.5C220.3 504.7 245.3 512 272 512c30.8 0 59.3-9.6 82.6-26.1c6.7-4.7 7.6-13.8 4.3-21.3c-4.5-10-7-21-7-32.7c0-44.2 35.8-80 80-80c5.3 0 10.5 .5 15.4 1.5c7.4 1.4 15.4-1 18.8-7.7c8.8-17.4 13.8-37 13.8-57.8c0-23.7-6.5-46-17.7-65l-23.7 23.7c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L417 177.7zM568 192a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm48-48a24 24 0 1 0 0-48 24 24 0 1 0 0 48z", "M630.6 54.6l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zM345 7c9.4 9.4 9.4 24.6 0 33.9L41 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L311 7c9.4-9.4 24.6-9.4 33.9 0zM219.3 404.7l16 16c5.6 5.6 6.3 14.5 1.5 20.9l-48 64c-2.8 3.7-7 6-11.7 6.4s-9.2-1.4-12.4-4.6l-32-32c-3.3-3.3-5-7.8-4.6-12.4s2.6-8.9 6.4-11.7l64-48c6.4-4.8 15.3-4.1 20.9 1.5z"]],
    "objects-column": [448, 512, [], "e3c1", ["M304 32c-26.5 0-48 21.5-48 48v32c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H304zm0 192c-26.5 0-48 21.5-48 48V432c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V272c0-26.5-21.5-48-48-48H304z", "M48 32C21.5 32 0 53.5 0 80V240c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H48zm0 320c-26.5 0-48 21.5-48 48v32c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V400c0-26.5-21.5-48-48-48H48z"]],
    "square-chevron-down": [448, 512, ["chevron-square-down"], "f329", ["M64 480c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64zM241 345L345 241c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-87 87-87-87c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L207 345c9.4 9.4 24.6 9.4 33.9 0z", "M207 345c9.4 9.4 24.6 9.4 33.9 0L345 241c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-87 87-87-87c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L207 345z"]],
    "comment-plus": [512, 512, [], "f4b2", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM232 328V264H168c-13.3 0-24-10.7-24-24s10.7-24 24-24h64V152c0-13.3 10.7-24 24-24s24 10.7 24 24v64h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H280v64c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M232 264v64c0 13.3 10.7 24 24 24s24-10.7 24-24V264h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V152c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64z"]],
    "triangle-instrument": [576, 512, ["triangle-music"], "f8e2", ["M320 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V69.9c-18 6.8-33.6 19.4-44.1 36.1L46.5 367.7C37 382.8 32 400.2 32 418c0 51.9 42.1 94 94 94H450c51.9 0 94-42.1 94-94c0-17.8-5-35.2-14.5-50.2L430.7 211.3l-46.4 46.4 91.1 144.2c3 4.8 4.6 10.4 4.6 16c0 16.6-13.5 30-30 30H126c-16.6 0-30-13.5-30-30c0-5.7 1.6-11.2 4.6-16L266 140.1c4.8-7.6 13.1-12.1 22-12.1s17.3 4.6 22 12.1l48 75.9 46.4-46.4L364.1 106C353.6 89.2 338 76.7 320 69.9V32z", "M537 105c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L306.8 267.2c-5.9-2.1-12.2-3.2-18.8-3.2c-30.9 0-56 25.1-56 56s25.1 56 56 56s56-25.1 56-56c0-6.6-1.1-12.9-3.2-18.8L537 105z"]],
    "wheelchair": [512, 512, [], "f193", ["M160 192c1.9 0 3.9 0 5.8 .1l9.8 49c-5.1-.7-10.3-1.1-15.6-1.1C98.1 240 48 290.1 48 352s50.1 112 112 112s112-50.1 112-112h48c0 88.4-71.6 160-160 160S0 440.4 0 352s71.6-160 160-160z", "M240 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm19.8 128l-1.9-9.7c-4.5-22.3-24-38.3-46.8-38.3c-30.1 0-52.7 27.5-46.8 57l23.1 115.5c6 29.9 32.2 51.4 62.8 51.4h5.1c.4 0 .8 0 1.3 0h94.1c6.7 0 12.6 4.1 15 10.4L402 459.2c6 16.1 23.8 24.6 40.1 19.1l48-16c16.8-5.6 25.8-23.7 20.2-40.5s-23.7-25.8-40.5-20.2l-18.7 6.2-25.5-68c-11.7-31.2-41.6-51.9-74.9-51.9H282.2l-9.6-48H336c17.7 0 32-14.3 32-32s-14.3-32-32-32H259.8z"]],
    "user-pilot-tie": [448, 512, [], "e2c1", ["M101.7 154.2C98 166.1 96 178.8 96 192c0 70.7 57.3 128 128 128s128-57.3 128-128c0-13.2-2-25.9-5.7-37.8C308.2 168.3 267 176 224 176s-84.2-7.7-122.3-21.8z", "M230.1 .8l152 40c8.6 2.3 15.3 9.1 17.3 17.8s-1 17.8-7.8 23.6l-23.8 20.4c.1 1 .1 2 .1 3.1v21.2c0 10.7-5.3 20.8-15.1 25.2c-24.1 10.8-68.6 24-128.9 24s-104.8-13.2-128.9-24C85.3 147.7 80 137.6 80 126.9V105.7c0-1 0-2.1 .1-3.1L56.4 82.2c-6.8-5.8-9.8-14.9-7.8-23.6s8.7-15.6 17.3-17.8l152-40c4-1.1 8.2-1.1 12.2 0zM161.7 72.8c-4 7.9-.7 17.5 7.2 21.5l48 24c4.5 2.3 9.8 2.3 14.3 0l48-24c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2L224 86.1 183.2 65.7c-7.9-4-17.5-.7-21.5 7.2zM208 416l-20.4-40.8c-5.3-10.6 2.4-23.2 14.3-23.2h44.2c11.9 0 19.6 12.5 14.3 23.2L240 416l12.2 48.9L315 360.3c3-5 8.6-8.1 14.4-7.4C396.2 360.8 448 417.5 448 486.4c0 14.1-11.5 25.6-25.6 25.6H256v0H192v0H25.6C11.5 512 0 500.5 0 486.4c0-68.9 51.8-125.6 118.6-133.5c5.8-.7 11.4 2.4 14.4 7.4l62.8 104.6L208 416zm128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H336z"]],
    "piano-keyboard": [576, 512, [127929], "f8d5", ["M0 224V384c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V224H512V384H432V315.7c-4.7 2.7-10.2 4.3-16 4.3s-11.3-1.6-16-4.3V384H304V315.7c-4.7 2.7-10.2 4.3-16 4.3s-11.3-1.6-16-4.3V384H176V315.7c-4.7 2.7-10.2 4.3-16 4.3s-11.3-1.6-16-4.3V384H64V224H0z", "M64 64C28.7 64 0 92.7 0 128v96H128v64c0 17.7 14.3 32 32 32s32-14.3 32-32V224h64v64c0 17.7 14.3 32 32 32s32-14.3 32-32V224h64v64c0 17.7 14.3 32 32 32s32-14.3 32-32V224H576V128c0-35.3-28.7-64-64-64H64z"]],
    "bed-empty": [640, 512, [128719], "f8f9", ["M64 224H96 544c24.3 0 46.6 9.1 63.5 24h.5v.4c19.6 17.6 32 43.1 32 71.6H64V256 224z", "M32 32c17.7 0 32 14.3 32 32V320H608h32v32 96c0 17.7-14.3 32-32 32s-32-14.3-32-32V416H64v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V64C0 46.3 14.3 32 32 32z"]],
    "circle-arrow-up": [512, 512, ["arrow-circle-up"], "f0aa", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM385 231c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-71-71V376c0 13.3-10.7 24-24 24s-24-10.7-24-24V193.9l-71 71c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 119c9.4-9.4 24.6-9.4 33.9 0L385 231z", "M239 119c9.4-9.4 24.6-9.4 33.9 0L385 231c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-71-71V376c0 13.3-10.7 24-24 24s-24-10.7-24-24V193.9l-71 71c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 119z"]],
    "toggle-on": [576, 512, [], "f205", ["M192 64C86 64 0 150 0 256S86 448 192 448H384c106 0 192-86 192-192s-86-192-192-192H192zm192 96a96 96 0 1 1 0 192 96 96 0 1 1 0-192z", "M288 256a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z"]],
    "rectangle-vertical": [384, 512, ["rectangle-portrait"], "f2fb", ["M320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L320 0z", ""]],
    "person-walking": [320, 512, [128694, "walking"], "f554", ["M109.6 295.8c2.6 9.8 7.6 19 14.7 26.7l30.3 33.1-27.7 69.2c-2.4 6-6 11.5-10.6 16.1L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L68.7 398l40.9-102.2z", "M208 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM123.7 200.5c1-.4 1.9-.8 2.9-1.2l-16.9 63.5c-5.6 21.1-.1 43.6 14.7 59.7l70.7 77.1 22 88.1c4.3 17.1 21.7 27.6 38.8 23.3s27.6-21.7 23.3-38.8l-23-92.1c-1.9-7.8-5.8-14.9-11.2-20.8l-49.5-54 19.3-65.5 9.6 23c4.4 10.6 12.5 19.3 22.8 24.5l26.7 13.3c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9L281 232.7l-15.3-36.8C248.5 154.8 208.3 128 163.7 128c-22.8 0-45.3 4.8-66.1 14l-8 3.5c-32.9 14.6-58.1 42.4-69.4 76.5l-2.6 7.8c-5.6 16.8 3.5 34.9 20.2 40.5s34.9-3.5 40.5-20.2l2.6-7.8c5.7-17.1 18.3-30.9 34.7-38.2l8-3.5z"]],
    "l": [320, 512, [108], "4c", ["M64 32c17.7 0 32 14.3 32 32V416H288c17.7 0 32 14.3 32 32s-14.3 32-32 32H64c-17.7 0-32-14.3-32-32V64c0-17.7 14.3-32 32-32z", ""]],
    "signal-stream": [576, 512, [], "f8dd", ["M113.1 116c11.1-13.8 8.8-33.9-5-45s-33.9-8.8-45 5C23.7 125.3 0 187.9 0 256s23.7 130.7 63.2 180c11.1 13.8 31.2 16 45 5s16-31.2 5-45C82.4 357.6 64 309 64 256s18.4-101.6 49.1-140zM512.8 76c-11.1-13.8-31.2-16-45-5s-16 31.2-5 45c30.7 38.4 49.1 87 49.1 140s-18.4 101.6-49.1 140c-11.1 13.8-8.8 33.9 5 45s33.9 8.8 45-5C552.3 386.7 576 324.1 576 256s-23.7-130.7-63.2-180zM204.5 181.3c11.8-13.2 10.7-33.4-2.5-45.2s-33.4-10.7-45.2 2.5C129 169.8 112 210.9 112 256s17 86.2 44.8 117.3c11.8 13.2 32 14.3 45.2 2.5s14.3-32 2.5-45.2c-17.8-19.8-28.5-46-28.5-74.7s10.8-54.8 28.5-74.7zm214.7-42.7c-11.8-13.2-32-14.3-45.2-2.5s-14.3 32-2.5 45.2c17.8 19.8 28.5 46 28.5 74.7s-10.8 54.8-28.5 74.7c-11.8 13.2-10.7 33.4 2.5 45.2s33.4 10.7 45.2-2.5C447 342.2 464 301.1 464 256s-17-86.2-44.8-117.3z", "M232 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"]],
    "down-to-bracket": [448, 512, [], "e4e7", ["M32 320c17.7 0 32 14.3 32 32v64c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V352c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 53-43 96-96 96H96c-53 0-96-43-96-96V352c0-17.7 14.3-32 32-32z", "M251.3 340.7L374.1 217.9c6.4-6.4 9.9-15 9.9-24c0-18.7-15.2-33.9-33.9-33.9L288 160l0-128c0-17.7-14.3-32-32-32L192 0c-17.7 0-32 14.3-32 32l0 128-62.1 0C79.2 160 64 175.2 64 193.9c0 9 3.6 17.6 9.9 24L196.7 340.7c7.2 7.2 17.1 11.3 27.3 11.3s20.1-4.1 27.3-11.3z"]],
    "circle-z": [512, 512, [], "e130", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128H328c8.9 0 17.1 5 21.3 12.9s3.6 17.5-1.5 24.8L229.8 336H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-8.9 0-17.1-5-21.3-12.9s-3.6-17.5 1.5-24.8L282.2 176H184c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M160 152c0-13.3 10.7-24 24-24H328c8.9 0 17.1 5 21.3 12.9s3.6 17.5-1.5 24.8L229.8 336H328c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-8.9 0-17.1-5-21.3-12.9s-3.6-17.5 1.5-24.8L282.2 176H184c-13.3 0-24-10.7-24-24z"]],
    "stars": [512, 512, [], "f762", ["M312 104l13.8 48.3c1.3 4.6 5.5 7.7 10.2 7.7s8.9-3.1 10.2-7.7L360 104l48.3-13.8c4.6-1.3 7.7-5.5 7.7-10.2s-3.1-8.9-7.7-10.2L360 56 346.2 7.7C344.9 3.1 340.7 0 336 0s-8.9 3.1-10.2 7.7L312 56 263.7 69.8c-4.6 1.3-7.7 5.5-7.7 10.2s3.1 8.9 7.7 10.2L312 104zM428.8 243.2l11 38.6c1 3.6 4.4 6.2 8.2 6.2s7.1-2.5 8.2-6.2l11-38.6 38.6-11c3.6-1 6.2-4.4 6.2-8.2s-2.5-7.1-6.2-8.2l-38.6-11-11-38.6c-1-3.6-4.4-6.2-8.2-6.2s-7.1 2.5-8.2 6.2l-11 38.6-38.6 11c-3.6 1-6.2 4.4-6.2 8.2s2.5 7.1 6.2 8.2l38.6 11z", "M213.4 157.4c-8.8-17.9-34.3-17.9-43.1 0l-46.3 94L20.5 266.5C.9 269.3-7 293.5 7.2 307.4l74.9 73.2L64.5 483.9c-3.4 19.6 17.2 34.6 34.8 25.3l92.6-48.8 92.6 48.8c17.6 9.3 38.2-5.7 34.8-25.3L301.6 380.6l74.9-73.2c14.2-13.9 6.4-38.1-13.3-40.9L259.7 251.4l-46.3-94z"]],
    "fire": [448, 512, [128293], "f06d", ["M159.3 5.4c7.8-7.3 19.9-7.2 27.7 .1c27.6 25.9 53.5 53.8 77.7 84c11-14.4 23.5-30.1 37-42.9c7.9-7.4 20.1-7.4 28 .1c34.6 33 63.9 76.6 84.5 118c20.3 40.8 33.8 82.5 33.8 111.9C448 404.2 348.2 512 224 512C98.4 512 0 404.1 0 276.5c0-38.4 17.8-85.3 45.4-131.7C73.3 97.7 112.7 48.6 159.3 5.4zM225.7 416c25.3 0 47.7-7 68.8-21c42.1-29.4 53.4-88.2 28.1-134.4c-4.5-9-16-9.6-22.5-2l-25.2 29.3c-6.6 7.6-18.5 7.4-24.7-.5c-16.5-21-46-58.5-62.8-79.8c-6.3-8-18.3-8.1-24.7-.1c-33.8 42.5-50.8 69.3-50.8 99.4C112 375.4 162.6 416 225.7 416z", "M294.5 395c-21.1 14-43.5 21-68.8 21C162.6 416 112 375.4 112 306.8c0-30.1 16.9-56.9 50.8-99.4c6.3-8 18.4-7.9 24.7 .1c16.8 21.3 46.3 58.8 62.8 79.8c6.2 7.9 18.1 8.1 24.7 .5l25.2-29.3c6.5-7.6 18-6.9 22.5 2c25.3 46.2 14 105-28.1 134.4z"]],
    "bed-pulse": [640, 512, ["procedures"], "f487", ["M332.7 160H320c-17.7 0-32 14.3-32 32V320v32h32H608h32V320 256c0-53-43-96-96-96H461.9l-11.2 23.8c-8.6 18.3-26.4 30.5-46.5 32s-39.5-8-50.7-24.8L332.7 160zM256 240A80 80 0 1 0 96 240a80 80 0 1 0 160 0z", "M483.2 9.6C478.1 2.9 469.9-.7 461.6 .1s-15.7 6-19.3 13.7l-45.9 97.5L372 74.7C367.5 68 360 64 352 64H216c-13.3 0-24 10.7-24 24s10.7 24 24 24H339.2L380 173.3c4.8 7.2 13.1 11.3 21.7 10.6s16.3-5.9 19.9-13.7l47-99.9 24.1 32.1c4.5 6 11.6 9.6 19.2 9.6H616c13.3 0 24-10.7 24-24s-10.7-24-24-24H524L483.2 9.6zM64 96c0-17.7-14.3-32-32-32S0 78.3 0 96V480c0 17.7 14.3 32 32 32s32-14.3 32-32V448H576v32c0 17.7 14.3 32 32 32s32-14.3 32-32V384 352H608 64V96z"]],
    "house-day": [640, 512, [], "e00e", ["M160.1-.1c5.9 0 11.3 3.2 14.1 8.4l27.6 51.2 55.7-16.7c5.6-1.7 11.7-.1 15.9 4s5.7 10.3 4 15.9l-16.7 55.7 35.3 19-64.7 59.7c5.6-10.9 8.7-23.3 8.7-36.3c0-44.2-35.8-80-80-80s-80 35.8-80 80s35.8 80 80 80c10.8 0 21.1-2.1 30.5-6l-41.7 38.5L133.1 288l-14.6-27.2L62.8 277.5c-5.6 1.7-11.7 .1-15.9-4s-5.7-10.3-4-15.9l16.7-55.7L8.3 174.3c-5.2-2.8-8.4-8.2-8.4-14.1s3.2-11.3 8.4-14.1l51.2-27.6L42.8 62.8c-1.7-5.6-.1-11.7 4-15.9s10.3-5.7 15.9-4l55.7 16.7L146 8.3c2.8-5.2 8.2-8.4 14.1-8.4zM160 112a48 48 0 1 1 0 96 48 48 0 1 1 0-96z", "M378.3 104.5c12.3-11.3 31.2-11.3 43.4 0l208 192c9.7 8.9 12.9 22.9 8.1 35.2S621.2 352 608 352H576V464c0 26.5-21.5 48-48 48H272c-26.5 0-48-21.5-48-48V352H192c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8.1-35.2l208-192zM368 288c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16V304c0-8.8-7.2-16-16-16H368z"]],
    "shuttle-space": [640, 512, ["space-shuttle"], "f197", ["M96 32v96H32V80c0-26.5 21.5-48 48-48H96zm0 352v96H80c-26.5 0-48-21.5-48-48V384H96zm32 96V380.3c16.1-5.1 30.1-15.1 40-28.3H405.3L245.2 448.1C210.4 469 170.6 480 130 480h-2zm0-348.3V32h2c40.6 0 80.4 11 115.2 31.9L405.3 160H168c-9.9-13.2-23.9-23.3-40-28.3z", "M0 168c0-22.1 17.9-40 40-40h64c26.2 0 49.4 12.6 64 32H456c69.3 0 135 22.7 179.2 81.6c6.4 8.5 6.4 20.3 0 28.8C591 329.3 525.3 352 456 352H168c-14.6 19.4-37.8 32-64 32H40c-22.1 0-40-17.9-40-40V328 184 168zM512 268.4V243.6c0-19.6-15.9-35.6-35.6-35.6c-2.5 0-4.4 2-4.4 4.4v87.1c0 2.5 2 4.4 4.4 4.4c19.6 0 35.6-15.9 35.6-35.6z"]],
    "shirt-long-sleeve": [640, 512, [], "e3c7", ["M320 112c61.9 0 112-50.1 112-112h28 15.6H480c1 0 2 .1 3 .3c32.1 2.5 61 20.9 76.7 49.5l66.4 120.7c9.1 16.5 13.9 35.1 13.9 54V384c0 17.7-14.3 32-32 32H576c-17.7 0-32-14.3-32-32V224.4c0-2.7-.7-5.3-2-7.7l-46-83.7V448c0 35.3-28.7 64-64 64H208c-35.3 0-64-28.7-64-64V133.1L98 216.7c-1.3 2.4-2 5-2 7.7V384c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V224.4c0-18.9 4.8-37.4 13.9-54L80.3 49.7C95.9 21.2 124.9 2.8 157 .3c1-.2 2-.3 3-.3h4.4H180h28c0 61.9 50.1 112 112 112z", "M208 0c0 61.9 50.1 112 112 112s112-50.1 112-112H400c0 44.2-35.8 80-80 80s-80-35.8-80-80H208z"]],
    "chart-pie-simple": [512, 512, ["chart-pie-alt"], "f64e", ["M224 49.6c0-9.2-7.8-16.6-17-15.4C90.1 50.3 0 150.7 0 272C0 404.6 107.5 512 240 512c121.4 0 221.7-90.1 237.7-207c1.3-9.2-6.1-17-15.4-17H224V49.6z", "M272 240H495.4c9 0 16.6-7 16.6-16C512 100.3 411.7 0 288 0c-9 0-16 7.6-16 16.6V240z"]],
    "face-laugh": [512, 512, ["laugh"], "f599", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM96.8 314.1c-3.8-13.7 7.4-26.1 21.6-26.1H393.6c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zM144.4 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M176.4 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", ["M461.4 461.1l16.2-27.9c-3 10.7-8.7 20.2-16.2 27.9zM480 224H144c-11.4 0-21.9 6-27.6 15.9l-112 192c-5.8 9.9-5.8 22.1-.1 32.1c1 1.7 2 3.2 3.2 4.6C2.8 463 0 455.8 0 448V96C0 60.7 28.7 32 64 32H181.5c17 0 33.3 6.7 45.3 18.7l26.5 26.5c12 12 28.3 18.7 45.3 18.7H416c35.3 0 64 28.7 64 64v64zM11.1 472.2c5.7 4.9 13.1 7.8 20.9 7.8c-8 0-15.3-2.9-20.9-7.8z", "M144 224c-11.4 0-21.9 6-27.6 15.9l-112 192c-5.8 9.9-5.8 22.1-.1 32.1S20.5 480 32 480H432c11.4 0 21.9-6 27.6-15.9l112-192c5.8-9.9 5.8-22.1 .1-32.1S555.5 224 544 224H144z"]],
    "album-collection-circle-user": [640, 512, [], "e48f", ["M56 0H456c13.3 0 24 10.7 24 24s-10.7 24-24 24H56C42.7 48 32 37.3 32 24S42.7 0 56 0zM12 176.2C21.1 165.9 34.2 160 48 160H464c13.8 0 26.9 5.9 36 16.2c4.2 4.8 7.4 10.3 9.4 16.3c-4.4-.3-8.9-.5-13.4-.5c-46.9 0-89.5 18.3-121 48.2C342.9 220.1 301.4 208 256 208C154.4 208 72 268.9 72 344s82.4 136 184 136c33.2 0 64.4-6.5 91.3-17.9c12.4 19.6 28.6 36.6 47.5 49.9H80c-24.2 0-44.6-18-47.6-42L.4 214c-1.7-13.7 2.5-27.4 11.6-37.7zM288 352c0 13.3-14.3 24-32 24s-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24zM16 104c0-13.3 10.7-24 24-24H472c13.3 0 24 10.7 24 24s-10.7 24-24 24H40c-13.3 0-24-10.7-24-24z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-32c-30.2 0-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7h65.2c21 0 38.9 13.7 45.1 32.7C553.5 468.1 526.2 480 496 480zm0-192a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]],
    "candy": [640, 512, [127852], "e3e7", ["M504 310.9c5.2-17.4 8-35.8 8-54.9s-2.8-37.5-8-54.9l93.2-46.6c10.5-5.3 23.3-2.1 30.2 7.4s5.8 22.7-2.5 31l-29.6 29.6 29.1 10.9C633.8 237 640 246 640 256s-6.2 19-15.6 22.5l-29.1 10.9L625 319c8.3 8.3 9.4 21.5 2.5 31s-19.7 12.7-30.2 7.4L504 310.9zM136 201.1c-5.2 17.4-8 35.8-8 54.9s2.8 37.5 8 54.9L42.7 357.5c-10.5 5.3-23.3 2.1-30.2-7.4s-5.8-22.7 2.5-31l29.6-29.6L15.6 278.5C6.2 275 0 266 0 256s6.2-19 15.6-22.5l29.1-10.9L15 193c-8.3-8.3-9.4-21.5-2.5-31s19.7-12.7 30.2-7.4L136 201.1z", "M318.1 64c-24.5 .2-47.9 5.1-69.4 13.7L419.9 420c20.3-12.4 38.2-28.5 52.6-47.3L318.1 64zM492.3 340.8C504.9 315.2 512 286.4 512 256c0-93.9-67.4-172.1-156.5-188.7L492.3 340.8zm-101 93.5L220.1 92c-20.3 12.4-38.2 28.5-52.6 47.3L321.9 448c24.5-.2 47.9-5.1 69.4-13.7zM284.5 444.7L147.7 171.2C135.1 196.8 128 225.6 128 256c0 93.9 67.4 172.1 156.5 188.7z"]],
    "bowl-hot": [512, 512, ["soup"], "f823", ["M176 24c0-13.3-10.7-24-24-24s-24 10.7-24 24v8c0 32.7 15.4 63.6 41.6 83.2C183.7 125.8 192 142.4 192 160v8c0 13.3 10.7 24 24 24s24-10.7 24-24v-8c0-32.7-15.4-63.6-41.6-83.2C184.3 66.2 176 49.6 176 32V24zm128 0c0-13.3-10.7-24-24-24s-24 10.7-24 24v8c0 32.7 15.4 63.6 41.6 83.2C311.7 125.8 320 142.4 320 160v8c0 13.3 10.7 24 24 24s24-10.7 24-24v-8c0-32.7-15.4-63.6-41.6-83.2C312.3 66.2 304 49.6 304 32V24z", "M33.6 224C15.4 224 .9 239.3 2 257.5c5.4 91.7 59.7 169.7 136.4 209.7l1.2 9.7c2.5 20 19.5 35 39.7 35H332.7c20.2 0 37.2-15 39.7-35l1.2-9.7c76.8-40 131-118 136.4-209.7c1.1-18.2-13.4-33.5-31.6-33.5H33.6z"]],
    "flatbread": [512, 512, [129747], "e40b", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM363.3 171.3l-192 192c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l192-192c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm-112-70.6c6.2 6.2 6.2 16.4 0 22.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0zm160 182.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z", "M251.3 100.7c6.2 6.2 6.2 16.4 0 22.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0zm112 48c6.2 6.2 6.2 16.4 0 22.6l-192 192c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l192-192c6.2-6.2 16.4-6.2 22.6 0zm48 134.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "heart-circle-plus": [576, 512, [], "e500", ["M507 208.7C484.3 198 458.8 192 432 192c-97.2 0-176 78.8-176 176c0 35.7 10.6 68.9 28.9 96.6l-5.4 5.6c-13 13-34 13-45.9 0L39.7 270.5c-55.9-57.9-52.9-153.8 10-207.8c53.9-47 136.8-38 186.8 13l20 21 19-21c49.9-50.9 131.8-59.9 187.8-13c42.9 37.4 57.5 95 43.8 146.1z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16v48H368c-8.8 0-16 7.2-16 16s7.2 16 16 16h48v48c0 8.8 7.2 16 16 16s16-7.2 16-16V384h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H448V304c0-8.8-7.2-16-16-16z"]],
    "code-fork": [448, 512, [], "e13b", ["M112 153.3c-9.8 4.3-20.6 6.7-32 6.7s-22.2-2.4-32-6.7V192c0 53 43 96 96 96h48v70.7c9.8-4.3 20.6-6.7 32-6.7s22.2 2.4 32 6.7V288h48c53 0 96-43 96-96V153.3c-9.8 4.3-20.6 6.7-32 6.7s-22.2-2.4-32-6.7V192c0 17.7-14.3 32-32 32H144c-17.7 0-32-14.3-32-32V153.3z", "M80 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104A80 80 0 1 0 80 0a80 80 0 1 0 0 160zM368 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104A80 80 0 1 0 368 0a80 80 0 1 0 0 160zM200 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]],
    "city": [640, 512, [127961], "f64f", ["M432 0c26.5 0 48 21.5 48 48V192H592c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48H432 336 304 48c-26.5 0-48-21.5-48-48V240 144c0-26.5 21.5-48 48-48H288V48c0-26.5 21.5-48 48-48h96zM560 352H528c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V368c0-8.8-7.2-16-16-16zM256 400V368c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16zM112 416c8.8 0 16-7.2 16-16V368c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32zM576 272c0-8.8-7.2-16-16-16H528c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V272zM240 160H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V176c0-8.8-7.2-16-16-16zM128 176c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V176zM240 320c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32zM128 304V272c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16zm272-48H368c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16zM416 80c0-8.8-7.2-16-16-16H368c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V80zm-16 80H368c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V176c0-8.8-7.2-16-16-16z", "M112 24c0-13.3-10.7-24-24-24S64 10.7 64 24V96h48V24zm112 0c0-13.3-10.7-24-24-24s-24 10.7-24 24V96h48V24zm16 136H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V176c0-8.8-7.2-16-16-16zM576 272c0-8.8-7.2-16-16-16H528c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V272zM112 416c8.8 0 16-7.2 16-16V368c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32zm144-16V368c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16zm320-32c0-8.8-7.2-16-16-16H528c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V368zM128 176c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V176zM240 320c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32zM128 304V272c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16z"]],
    "signal-bars-weak": [640, 512, ["signal-alt-1"], "f691", ["M560 0c-26.5 0-48 21.5-48 48V464c0 26.5 21.5 48 48 48s48-21.5 48-48V48c0-26.5-21.5-48-48-48zM352 176V464c0 26.5 21.5 48 48 48s48-21.5 48-48V176c0-26.5-21.5-48-48-48s-48 21.5-48 48zM192 304V464c0 26.5 21.5 48 48 48s48-21.5 48-48V304c0-26.5-21.5-48-48-48s-48 21.5-48 48z", "M32 432c0-26.5 21.5-48 48-48s48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V432z"]],
    "microphone-lines": [384, 512, [127897, "microphone-alt"], "f3c9", ["M208 96c-8.8 0-16 7.2-16 16s7.2 16 16 16h80V96H208zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16h80V160H208zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16h80V224H208zM64 216c0-13.3-10.7-24-24-24s-24 10.7-24 24v40c0 89.1 66.2 162.7 152 174.4V464H120c-13.3 0-24 10.7-24 24s10.7 24 24 24h72 72c13.3 0 24-10.7 24-24s-10.7-24-24-24H216V430.4c85.8-11.7 152-85.3 152-174.4V216c0-13.3-10.7-24-24-24s-24 10.7-24 24v40c0 70.7-57.3 128-128 128s-128-57.3-128-128V216z", "M192 0C139 0 96 43 96 96V256c0 53 43 96 96 96s96-43 96-96H208c-8.8 0-16-7.2-16-16s7.2-16 16-16h80V192H208c-8.8 0-16-7.2-16-16s7.2-16 16-16h80V128H208c-8.8 0-16-7.2-16-16s7.2-16 16-16h80c0-53-43-96-96-96z"]],
    "clock-twelve": [512, 512, [], "e358", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392V256c0 13.3-10.7 24-24 24s-24-10.7-24-24V120c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M256 96c13.3 0 24 10.7 24 24V256c0 13.3-10.7 24-24 24s-24-10.7-24-24V120c0-13.3 10.7-24 24-24z"]],
    "pepper-hot": [512, 512, [127798], "f816", ["M281.8 124.3c3.5 2.3 7.9 3.7 13 3.7l17.1 0c13.3 0 24 10.7 24 24v80c0 13.3 10.7 24 24 24h73.2c9.1 0 17.4 5.1 21.5 13.3l11.7 23.4c2 4.1 5 7.2 8.3 9.4C397.9 429.6 258.4 512 103.2 512H44.4C19.9 512 0 492.1 0 467.6c0-20.8 14.5-38.8 34.8-43.3l49.8-11.1c37.6-8.4 69.5-33.2 86.7-67.7L281.8 124.3z", "M461 12.3C454.5 .8 439.9-3.4 428.3 3s-15.8 21-9.3 32.6l4.8 8.7c9.7 17.5 11.5 37.6 6 55.8C406.8 87.3 380.3 80 352 80c-24.3 0-47.3 5.4-67.9 15.1c-19.3 9-10.5 32.9 10.8 32.9l17.1 0c13.3 0 24 10.7 24 24v80c0 13.3 10.7 24 24 24h73.2c9.1 0 17.4 5.1 21.5 13.3l11.7 23.4c8.2 16.4 30.7 17.5 36.8 .1c5.8-16.5 8.9-34.3 8.9-52.8c0-42.1-16.2-80.4-42.8-108.9c16.4-34.3 15.9-75.4-3.4-110L461 12.3z"]],
    "citrus-slice": [512, 512, [], "e2f5", ["M253.5 230.9c-3.7-3.7-4.4-9.4-2.4-14.3s6.5-8.5 11.8-8.5H448.2c8.6 0 15.8 6.8 15.5 15.5c-1.4 50.6-18.3 100.8-50.6 143c-5.6 7.3-16.3 7.7-22.9 1.1L253.5 230.9zM208 262.9c0-5.3 3.7-9.8 8.5-11.8s10.6-1.4 14.3 2.4L367.6 390.3c6.5 6.5 6.2 17.3-1.1 22.9c-42.2 32.3-92.5 49.2-143 50.6c-8.6 .2-15.5-6.9-15.5-15.5V262.9zM250.5 166c-2.6-5.9-2.1-13 2.5-17.6L366.3 35.1c4.6-4.6 20.1 1.2 24.7 5.8c33.4 33.4 55.3 73.9 65.7 116.6c2.3 9.6-5.2 18.5-15.1 18.5H264.5c-6.2 0-11.5-4.3-14-10zM148.4 253c4.6-4.6 11.7-5.2 17.6-2.5c5.7 2.5 10 7.8 10 14V441.7c0 9.9-8.9 17.4-18.5 15.1C114.8 446.3 74.4 424.4 41 391c-4.6-4.6-10.5-20.1-5.8-24.7L148.4 253z", "M7 391c9.4-9.4 24.6-9.4 33.9 0c96.9 96.9 253.6 97.1 350.4 .3s96.6-253.5-.3-350.4c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c115.6 115.6 116 302.6 .3 418.3S122.6 540.5 7 425c-9.4-9.4-9.4-24.6 0-33.9z"]],
    "sheep": [640, 512, [128017], "f711", ["M308.5 142.1c8 18.6 24.8 30.7 43.5 33.4V208c0 61.9 50.1 112 112 112h15.5c.3 2.6 .5 5.3 .5 8c0 35.3-28.7 64-64 64c-3.3 0-6.6-.3-9.8-.7c-6.8 28-32.1 48.7-62.2 48.7c-15 0-28.9-5.2-39.8-13.9c-11.7 13.4-29 21.9-48.2 21.9s-36.5-8.5-48.2-21.9C196.9 434.8 183 440 168 440c-30.1 0-55.3-20.8-62.2-48.7c-3.2 .5-6.5 .7-9.8 .7c-35.3 0-64-28.7-64-64c0-5.3 .7-10.5 1.9-15.5C13.7 301.7 0 280.5 0 256s13.7-45.7 33.9-56.5c-1.2-5-1.9-10.2-1.9-15.5c0-35.3 28.7-64 64-64c3.3 0 6.6 .3 9.8 .8C112.7 92.8 137.9 72 168 72c15 0 28.9 5.2 39.8 13.9C219.5 72.5 236.8 64 256 64c22.9 0 43 12 54.3 30.1c-7.5 14.4-8.7 31.9-1.8 47.9z", "M384 135.8l-14.5 6.2c-12.2 5.2-26.3-.4-31.5-12.6s.4-26.3 12.6-31.5l47.8-20.5C415.3 50.2 445.5 32 480 32s64.7 18.2 81.6 45.4l47.8 20.5c12.2 5.2 17.8 19.3 12.6 31.5s-19.3 17.8-31.5 12.6L576 135.8V208c0 44.2-35.8 80-80 80H464c-44.2 0-80-35.8-80-80V135.8zM464 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM115.1 485.9L97.5 392c2.8-.1 5.6-.3 8.3-.7c6.8 28 32.1 48.7 62.2 48.7c15 0 28.9-5.2 39.8-13.9l.2 .2V480c0 17.7-14.3 32-32 32H146.6c-15.4 0-28.6-11-31.5-26.1zM304 480V426.3l.2-.2C315.1 434.8 329 440 344 440c30.1 0 55.3-20.8 62.2-48.7c2.7 .4 5.5 .7 8.3 .7l-17.6 93.9C394.1 501 380.8 512 365.4 512H336c-17.7 0-32-14.3-32-32z"]],
    "unlock": [448, 512, [128275], "f09c", ["M224 64c-44.2 0-80 35.8-80 80v48H80V144C80 64.5 144.5 0 224 0c57.5 0 107 33.7 130.1 82.3c7.6 16 .8 35.1-15.2 42.6s-35.1 .8-42.6-15.2C283.4 82.6 255.9 64 224 64z", "M0 256c0-35.3 28.7-64 64-64H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256z"]],
    "colon-sign": [384, 512, [], "e140", ["M255 39.8l-6.5 25.8c-8.1-1-16.3-1.6-24.6-1.6c-14.5 0-28.6 1.6-42.1 4.6L193 24.2C197.2 7.1 214.6-3.3 231.8 1s27.6 21.7 23.3 38.8zm-22.1 88.5L171.8 372.9c-22.2-9.9-41.1-26-54.4-46.1l45.9-183.4C181.3 133.6 202 128 224 128c3 0 6 .1 8.9 .3zM199.6 381.7l62-248.1c14.3 4.4 27.5 11.2 39.2 20c6 4.5 13.2 6.6 20.2 6.4L266.8 376.7C253.4 381.4 239 384 224 384c-8.3 0-16.5-.8-24.4-2.3zm-43.5 54l-13 52.1c-4.3 17.1-21.7 27.6-38.8 23.3s-27.6-21.7-23.3-38.8l17.7-70.8c16.8 14.5 36.2 26.2 57.4 34.2zm28 8.2c12.9 2.7 26.2 4.2 39.9 4.2c8.6 0 17.1-.6 25.4-1.7L239 487.8c-4.3 17.1-21.7 27.6-38.8 23.3s-27.6-21.7-23.3-38.8l7.1-28.4zM336 100c-17.6-12.7-37.5-22.4-58.8-28.6L289 24.2C293.2 7.1 310.6-3.3 327.8 1s27.6 21.7 23.3 38.8L336 100z", "M224 128c-70.7 0-128 57.3-128 128s57.3 128 128 128c28.9 0 55.4-9.5 76.8-25.6c14.1-10.6 34.2-7.8 44.8 6.4s7.8 34.2-6.4 44.8C307.1 433.7 267.2 448 224 448C118 448 32 362 32 256S118 64 224 64c43.2 0 83.1 14.3 115.2 38.4c14.1 10.6 17 30.7 6.4 44.8s-30.7 17-44.8 6.4C279.4 137.5 252.9 128 224 128z"]],
    "headset": [512, 512, [], "f590", ["M48 256C48 141.1 141.1 48 256 48s208 93.1 208 208V400.1c0 22.1-17.9 40-40 40L313.6 440c-8.3-14.4-23.8-24-41.6-24H240c-26.5 0-48 21.5-48 48s21.5 48 48 48h32c17.8 0 33.3-9.7 41.6-24l110.4 .1c48.6 0 88.1-39.4 88.1-88V256C512 114.6 397.4 0 256 0S0 114.6 0 256v40c0 13.3 10.7 24 24 24s24-10.7 24-24V256z", "M144 208c-35.3 0-64 28.7-64 64v48c0 35.3 28.7 64 64 64h16c17.7 0 32-14.3 32-32V240c0-17.7-14.3-32-32-32H144zm224 0H352c-17.7 0-32 14.3-32 32V352c0 17.7 14.3 32 32 32h16c35.3 0 64-28.7 64-64V272c0-35.3-28.7-64-64-64z"]],
    "badger-honey": [640, 512, [129441], "f6b4", ["M502 122.2L570 160H467.5c-23.2 0-46 6.3-65.9 18.2L294.8 242.3c-14.9 9-32 13.7-49.4 13.7H192c-46.4 0-86.2-28.2-103.2-68.5C102 161.7 129 144 160 144H332.2c31 0 61.5-7.2 89.2-21.1l4.7-2.4c11.3-5.6 23.7-8.6 36.3-8.6c13.8 0 27.4 3.5 39.5 10.2zm51.2 154.9l-16.1-25.8c15.5-4.9 31.7-8.4 48.3-10.2c1.4-.1 2.8-.3 4.2-.6l-22.8 36.5c-3.1 5-10.4 5-13.6 0z", "M180.6 352l-16 37.3c-3 6.9-3.4 14.6-1.2 21.8l8.3 27.7c6.2 20.5-9.2 41.2-30.7 41.2H111.8c-14.1 0-26.6-9.3-30.7-22.8L68 413.5c-2.6-8.8-2.7-18.2-.2-27l16.8-59C69.1 316.2 56.2 301.4 47 284.3c-4.5 2.4-9.6 3.7-15 3.7c-17.7 0-32-14.3-32-32V224C0 153.3 57.3 96 128 96h32H332.2c23.5 0 46.7-5.5 67.8-16l4.7-2.4c17.9-9 37.7-13.6 57.8-13.6c22 0 43.6 5.6 62.8 16.3l81.9 45.5C627.4 137 640 158.4 640 181.6v3.8c0 14.5-5.8 28.4-16 38.6s-24.2 15.7-38.6 17.2C500.8 250 427.7 306.1 393 342.1l16.8 100.6C413 462.2 398 480 378.2 480H347.1c-15.6 0-29-11.3-31.6-26.7L298.7 352H180.6zM570 160l-68-37.8c-12.1-6.7-25.6-10.2-39.5-10.2c-12.6 0-25.1 2.9-36.3 8.6l-4.7 2.4c-27.7 13.9-58.3 21.1-89.2 21.1H160c-31 0-58 17.7-71.2 43.5c17 40.2 56.8 68.5 103.2 68.5h53.4c17.4 0 34.5-4.7 49.4-13.7l106.8-64.1c19.9-11.9 42.7-18.2 65.9-18.2h5.9c-.9 2.5-1.4 5.2-1.4 8c0 13.3 10.7 24 24 24s24-10.7 24-24c0-2.8-.5-5.5-1.4-8H570z"]],
    "h4": [640, 512, [], "f86a", ["M32 64c17.7 0 32 14.3 32 32V224H256V96c0-17.7 14.3-32 32-32s32 14.3 32 32V256 416c0 17.7-14.3 32-32 32s-32-14.3-32-32V288H64V416c0 17.7-14.3 32-32 32s-32-14.3-32-32V256 96C0 78.3 14.3 64 32 64z", "M479 103.8c4.3-17.1-6.1-34.5-23.3-38.8s-34.5 6.1-38.8 23.3l-48 192c-2.4 9.6-.2 19.7 5.8 27.5s15.4 12.3 25.2 12.3H576v96c0 17.7 14.3 32 32 32s32-14.3 32-32V96c0-17.7-14.3-32-32-32s-32 14.3-32 32V256H441L479 103.8z"]],
    "store-slash": [640, 512, [], "e071", ["M365.5 384H160V250.6c-11.2 3.5-23.2 5.4-35.6 5.4c-5.5 0-11-.4-16.3-1.1l-.1 0c-4.1-.6-8.1-1.3-12-2.3V384v64c0 35.3 28.7 64 64 64H480c12.9 0 24.8-3.8 34.9-10.3L365.5 384zM48.9 134.5c-6.1 40.6 19.5 82.8 63.3 88.7c4 .5 8.1 .8 12.1 .8c11 0 21.4-2 31-5.6L48.9 134.5zM480 350.9l64 50.2V384 252.6c-4 1-8 1.8-12.3 2.3l-.1 0c-5.3 .7-10.7 1.1-16.2 1.1c-12.4 0-24.3-1.9-35.4-5.3V350.9zM94.9 49.1L301.2 210.7c7-4.4 13.3-9.7 18.8-15.7c15.9 17.6 39.1 29 65.2 29c26.2 0 49.3-11.4 65.2-29c16 17.6 39.1 29 65.2 29c4.1 0 8.1-.3 12.1-.8c55.5-7.4 81.8-72.5 52.1-119.4L522.3 13.1C517.2 5 508.1 0 498.4 0H141.6c-9.7 0-18.8 5-23.9 13.1l-22.7 36z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "road-circle-xmark": [640, 512, [], "e566", ["M288 32H213.2c-27.1 0-51.3 17.1-60.3 42.6L35.1 407.2c-2.1 5.9-3.1 12-3.1 18.2C32 455.5 56.5 480 86.6 480H288V416c0-17.7 14.3-32 32-32l.7 0c-.5-5.3-.7-10.6-.7-16c0-16.9 2.4-33.3 6.8-48.7c-2.2 .5-4.5 .7-6.8 .7c-17.7 0-32-14.3-32-32V224c0-17.7 14.3-32 32-32s32 14.3 32 32v42.8c31.9-45.2 84.5-74.8 144-74.8c11.6 0 22.9 1.1 33.8 3.2L487.1 74.6C478 49.1 453.9 32 426.8 32H352V96c0 17.7-14.3 32-32 32s-32-14.3-32-32V32z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]],
    "signal-slash": [640, 512, [], "f695", ["M608 451.2V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V401.1l64 50.2zM480 350.9V128c0-17.7-14.3-32-32-32s-32 14.3-32 32V300.8l64 50.2zM352 250.6V224c0-17.7-14.3-32-32-32c-10.7 0-20.1 5.2-25.9 13.2L352 250.6zM576 512l-.3 0h.6l-.3 0zm-96-32v-5.8l-64-50.4V480c0 17.7 14.3 32 32 32s32-14.3 32-32zM352 373.3l-64-50.4V480c0 17.7 14.3 32 32 32s32-14.3 32-32V373.3zM192 288c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32s32-14.3 32-32V320c0-17.7-14.3-32-32-32zM96 416c0-17.7-14.3-32-32-32s-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V416z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "user-minus": [640, 512, [], "f503", ["M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3z", "M448 224c0-13.3 10.7-24 24-24H616c13.3 0 24 10.7 24 24s-10.7 24-24 24H472c-13.3 0-24-10.7-24-24z"]],
    "mars-stroke-up": [320, 512, [9896, "mars-stroke-v"], "f22a", ["M96 352a64 64 0 1 1 128 0A64 64 0 1 1 96 352z", "M148.7 4.7c6.2-6.2 16.4-6.2 22.6 0l64 64c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9H184v24h32c13.3 0 24 10.7 24 24s-10.7 24-24 24H184v24c0 .6 0 1.2-.1 1.8c77 11.6 136.1 78 136.1 158.2c0 88.4-71.6 160-160 160S0 440.4 0 352c0-80.2 59.1-146.7 136.1-158.2c0-.6-.1-1.2-.1-1.8V168H104c-13.3 0-24-10.7-24-24s10.7-24 24-24h32V96H96c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l64-64zM256 352A96 96 0 1 0 64 352a96 96 0 1 0 192 0z"]],
    "champagne-glasses": [640, 512, [129346, "glass-cheers"], "f79f", ["M195 1.9C179.9-3.6 163 3 155.6 17.3L76.9 170.2C48.1 226 66.5 292.5 115.3 326.8L84 413l-41-15c-16.6-6.1-35 2.5-41 19.1s2.5 35 19.1 41l71.1 25.9L163.3 510c16.6 6.1 35-2.5 41-19.1s-2.5-35-19.1-41l-41-15 31.3-86.2c59.4 5.2 116.2-33.9 130-95.2L320 188.8l14.6 64.7c13.8 61.3 70.6 100.4 130 95.2l31.3 86.2-41 15c-16.6 6.1-25.2 24.4-19.1 41s24.4 25.2 41 19.1l71.1-25.9L619 458.2c16.6-6.1 25.2-24.4 19.1-41s-24.4-25.2-41-19.1l-41 15-31.3-86.2c48.8-34.3 67.2-100.8 38.5-156.6L484.4 17.3C477.1 3 460.2-3.6 445.1 1.9L320 47.5 195 1.9zM133.7 199.6L199.6 71.7l75.1 27.4L243 239.4c-7.8 34.5-44 54.3-77.2 42.2s-48.2-50.6-32.1-82zm372.6 0c16.2 31.4 1.1 69.9-32.1 82s-69.4-7.7-77.2-42.2L365.4 99.1l75.1-27.4 65.9 127.8z", "M172.4 124.5l-38.7 75c-16.2 31.4-1.1 69.9 32.1 82s69.4-7.7 77.2-42.2L261.6 157l-89.2-32.5zm295.2 0L378.5 157 397 239.4c7.8 34.5 44 54.3 77.2 42.2s48.2-50.6 32.1-82l-38.7-75z"]],
    "taco": [512, 512, [127790], "f826", ["M480 480c17.7 0 32-14.3 32-32c0-141.4-114.6-256-256-256S0 306.6 0 448c0 17.7 14.3 32 32 32H480zM96 400a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z", "M237.2 38.4c11-8.6 26.5-8.6 37.5 0l44.1 34.2c5.6 4.4 12.6 6.6 19.7 6.4l55.8-1.7c14-.4 26.5 8.6 30.4 22.1l15.6 53.6c2 6.8 6.3 12.8 12.2 16.8L498.6 201c11.6 7.9 16.3 22.5 11.6 35.7l-27.8 91.6C439.4 247.2 354.1 192 256 192s-183.4 55.2-226.3 136.3L1.8 236.7c-4.7-13.1 0-27.8 11.6-35.7l46.1-31.4c5.9-4 10.2-9.9 12.2-16.8L87.3 99.3c3.9-13.4 16.4-22.5 30.4-22.1L173.4 79c7.1 .2 14.1-2 19.7-6.4l44.1-34.2z"]],
    "hexagon-plus": [512, 512, ["plus-hexagon"], "f300", ["M17.1 292c-12.9-22.3-12.9-49.7 0-72L105.4 67.1c12.9-22.3 36.6-36 62.4-36H344.3c25.7 0 49.5 13.7 62.4 36L494.9 220c12.9 22.3 12.9 49.7 0 72L406.6 444.9c-12.9 22.3-36.6 36-62.4 36H167.7c-25.7 0-49.5-13.7-62.4-36L17.1 292zM232 344c0 13.3 10.7 24 24 24s24-10.7 24-24V280h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V168c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64v64z", "M232 280v64c0 13.3 10.7 24 24 24s24-10.7 24-24V280h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V168c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64z"]],
    "clipboard": [384, 512, [128203], "f328", ["M113.6 64c-.2 .8-.3 1.6-.4 2.3C93.9 72.6 80 90.7 80 112v24c0 13.3 10.7 24 24 24h88 88c13.3 0 24-10.7 24-24V112c0-21.3-13.9-39.4-33.2-45.7c-.1-.8-.3-1.6-.4-2.3H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128C0 92.7 28.7 64 64 64h49.6z", "M192 0c-39.5 0-72.4 28.7-78.8 66.3C93.9 72.6 80 90.7 80 112v24c0 13.3 10.7 24 24 24h88 88c13.3 0 24-10.7 24-24V112c0-21.3-13.9-39.4-33.2-45.7C264.4 28.7 231.5 0 192 0zm0 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "house-circle-exclamation": [640, 512, [], "e50a", ["M496 192c-91.8 0-167.2 70.3-175.3 160l-.7 0H256c-17.7 0-32 14.3-32 32v64 24c0 22.1-17.9 40-40 40H160 128.1c-1.5 0-3-.1-4.5-.2c-1.2 .1-2.4 .2-3.6 .2H104c-22.1 0-40-17.9-40-40V360c0-.9 0-1.9 .1-2.8V287.6H32c-18 0-32-14-32-32.1c0-9 3-17 10-24L266.4 8c7-7 15-8 22-8s15 2 21 7L522.1 193.9c-8.5-1.3-17.3-1.9-26.1-1.9z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16V288z"]],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM216 392V289.9l31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31V392c0 13.3 10.7 24 24 24s24-10.7 24-24z", "M384 160H256c-17.7 0-32-14.3-32-32V0L384 160zM216 392c0 13.3-10.7 24-24 24s-24-10.7-24-24V289.9l-31 31c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l72-72c9.4-9.4 24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-31-31V392z"]],
    "wifi": [640, 512, ["wifi-3", "wifi-strong"], "f1eb", ["", "M54.2 202.9C123.2 136.7 216.8 96 320 96s196.8 40.7 265.8 106.9c12.8 12.2 33 11.8 45.2-.9s11.8-33-.9-45.2C549.7 79.5 440.4 32 320 32S90.3 79.5 9.8 156.7C-2.9 169-3.3 189.2 8.9 202s32.5 13.2 45.2 .9zM320 256c56.8 0 108.6 21.1 148.2 56c13.3 11.7 33.5 10.4 45.2-2.8s10.4-33.5-2.8-45.2C459.8 219.2 393 192 320 192s-139.8 27.2-190.5 72c-13.3 11.7-14.5 31.9-2.8 45.2s31.9 14.5 45.2 2.8c39.5-34.9 91.3-56 148.2-56zm64 160a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]],
    "messages": [640, 512, ["comments-alt"], "f4b6", ["M256 352v32c0 35.3 28.7 64 64 64H437.3l81.1 60.8c4.8 3.6 11.3 4.2 16.8 1.5s8.8-8.2 8.8-14.3V448h32c35.3 0 64-28.7 64-64V192c0-35.3-28.7-64-64-64H448V256c0 53-43 96-96 96H256z", "M0 64C0 28.7 28.7 0 64 0H352c35.3 0 64 28.7 64 64V256c0 35.3-28.7 64-64 64H202.7l-81.1 60.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V320H64c-35.3 0-64-28.7-64-64V64z"]],
    "bath": [512, 512, [128705, "bathtub"], "f2cd", ["M109.3 64C101.9 64 96 69.9 96 77.3V256H32V77.3C32 34.6 66.6 0 109.3 0c20.5 0 40.1 8.1 54.6 22.6l14.9 14.9C187.8 34 197.7 32 208 32c19.9 0 38 7.2 52 19.2c9.2-5.3 21.1-4 29 3.8c9.4 9.4 9.4 24.6 0 33.9L185 193c-9.4 9.4-24.6 9.4-33.9 0c-7.9-7.9-9.1-19.8-3.8-29c-12-14-19.2-32.1-19.2-52c0-10.3 2-20.2 5.5-29.2L118.6 67.9c-2.5-2.5-5.9-3.9-9.4-3.9z", "M32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H32zm448 96H32v16c0 28.4 12.4 54 32 71.6V480c0 17.7 14.3 32 32 32s32-14.3 32-32V464H384v16c0 17.7 14.3 32 32 32s32-14.3 32-32V439.6c19.6-17.6 32-43.1 32-71.6V352z"]],
    "umbrella-simple": [512, 512, ["umbrella-alt"], "e2bc", ["M288 288V430.6c0 45-36.5 81.4-81.4 81.4c-30.8 0-59-17.4-72.8-45l-2.3-4.7c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l2.3 4.7c3 5.9 9 9.6 15.6 9.6c9.6 0 17.4-7.8 17.4-17.4V288h64z", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32v2C108.2 48.4 16.4 140.2 2 256.1C-.2 273.6 14.3 288 32 288H480c17.7 0 32.2-14.4 30-31.9C495.6 140.2 403.8 48.4 288 34V32z"]],
    "rectangle-history-circle-plus": [640, 512, [], "e4a3", ["M394.8 512C349.5 480.1 320 427.5 320 368c0-97.2 78.8-176 176-176c2.5 0 5 .1 7.5 .2c-11-19.2-31.8-32.2-55.5-32.2L64 160c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64l330.8 0zM464 104c0-13.3-10.7-24-24-24L72 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l368 0c13.3 0 24-10.7 24-24zM416 24c0-13.3-10.7-24-24-24H120C106.7 0 96 10.7 96 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16v48H432c-8.8 0-16 7.2-16 16s7.2 16 16 16h48v48c0 8.8 7.2 16 16 16s16-7.2 16-16V384h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H512V304c0-8.8-7.2-16-16-16z"]],
    "underline": [448, 512, [], "f0cd", ["M48 32C30.3 32 16 46.3 16 64s14.3 32 32 32H64V224c0 88.4 71.6 160 160 160s160-71.6 160-160V96h16c17.7 0 32-14.3 32-32s-14.3-32-32-32H304c-17.7 0-32 14.3-32 32s14.3 32 32 32h16V224c0 53-43 96-96 96s-96-43-96-96V96h16c17.7 0 32-14.3 32-32s-14.3-32-32-32H48z", "M0 448c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z"]],
    "prescription-bottle-pill": [576, 512, [], "e5c0", ["M32 0C14.3 0 0 14.3 0 32V64C0 81.7 14.3 96 32 96H352c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H32zM352 128H32v64H144c8.8 0 16 7.2 16 16s-7.2 16-16 16H32v64H144c8.8 0 16 7.2 16 16s-7.2 16-16 16H32v64H144c8.8 0 16 7.2 16 16s-7.2 16-16 16H32v32c0 35.3 28.7 64 64 64H288c11.6 0 22.4-3.1 31.8-8.4c-39-32.3-63.8-81-63.8-135.6c0-68.4 39-127.7 96-156.8V128z", "M338.5 297.1c-10.1-10.1-27-9.2-33.7 3.4C294.1 320.6 288 343.6 288 368c0 79.5 64.5 144 144 144c24.4 0 47.4-6.1 67.5-16.8c12.6-6.7 13.5-23.6 3.4-33.7L338.5 297.1zM525.5 438.9c10.1 10.1 27 9.2 33.7-3.4C569.9 415.4 576 392.4 576 368c0-79.5-64.5-144-144-144c-24.4 0-47.4 6.1-67.5 16.8c-12.6 6.7-13.5 23.6-3.4 33.7L525.5 438.9z"]],
    "user-pen": [640, 512, ["user-edit"], "f4ff", ["M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM0 482.3C0 383.8 79.8 304 178.3 304h91.4c48.1 0 91.8 19.1 123.9 50.1l-40.3 40.3c-8.2 8.2-14 18.5-16.8 29.7l-15 60.1c-2.3 9.4-1.8 19 1.4 27.8H29.7C13.3 512 0 498.7 0 482.3z", "M557.2 235.7l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-52 52L375.9 417c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L576.1 358.7l-71-71z"]],
    "binary-slash": [640, 512, [], "e33e", ["M384 398.5l-63.9-50.3c-.1 1.3-.1 2.5-.1 3.8v96c0 35.3 28.7 64 64 64h64c20.1 0 38.1-9.3 49.8-23.8l-51-40.2H384V398.5zM399.7 288L512 376V352c0-35.3-28.7-64-64-64H399.7zM236.4 160L298 208.3c13.5-11.7 22-29 22-48.3V64c0-35.3-28.7-64-64-64H192c-35.3 0-64 28.7-64 64V75l64 50.2V64h64v96H236.4zM464 32c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2V160H384c-17.7 0-32 14.3-32 32s14.3 32 32 32h48 48c17.7 0 32-14.3 32-32s-14.3-32-32-32H464V32zM240 320c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2V448H160c-17.7 0-32 14.3-32 32s14.3 32 32 32h48 48c17.7 0 32-14.3 32-32s-14.3-32-32-32H240V320z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "square-o": [448, 512, [], "e278", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm80 224a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zm80 128a128 128 0 1 1 0-256 128 128 0 1 1 0 256z", "M224 176a80 80 0 1 0 0 160 80 80 0 1 0 0-160zm128 80A128 128 0 1 1 96 256a128 128 0 1 1 256 0z"]],
    "signature": [640, 512, [], "f5b7", ["M64 368H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H64.3c-.2-2.8-.3-5.6-.3-8.5V368zm219.5 48H616c13.3 0 24-10.7 24-24s-10.7-24-24-24H305.9c-6.7 16.3-14.2 32.3-22.3 48z", "M224 96c-17.7 0-32 14.3-32 32v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V128c0-53 43-96 96-96s96 43 96 96v7.8c0 20.8-1.2 41.6-3.6 62.3l122.4-36.7c11.4-3.4 23.8-.2 32.2 8.4s11.2 21.1 7.4 32.4l-18 53.9H544c17.7 0 32 14.3 32 32s-14.3 32-32 32H416c-10.3 0-19.9-4.9-26-13.3s-7.7-19.1-4.4-28.8l12.5-37.5-94.4 28.3c-11.9 52.8-31.6 103.5-58.4 150.5l-13.9 24.3c-12.9 22.6-36.9 36.5-62.9 36.5c-40 0-72.5-32.5-72.5-72.5V335.6c0-42.4 27.8-79.8 68.4-92l84.4-25.3c4.8-27.2 7.1-54.9 7.1-82.5V128c0-17.7-14.3-32-32-32zm7.8 194.3l-49 14.7C169.3 309 160 321.5 160 335.6v71.9c0 4.7 3.8 8.5 8.5 8.5c3 0 5.9-1.6 7.4-4.3l13.9-24.3c17.6-30.8 31.7-63.4 42.1-97.2z"]],
    "stroopwafel": [512, 512, [], "f551", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM312.6 63.7c-6.2-6.2-16.4-6.2-22.6 0L256 97.6 222.1 63.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l33.9 33.9-45.3 45.3-56.6-56.6c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l56.6 56.6-45.3 45.3L86.3 199.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L97.6 256 63.7 289.9c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l33.9-33.9 45.3 45.3-56.6 56.6c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l56.6-56.6 45.3 45.3-33.9 33.9c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L256 414.4l33.9 33.9c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-33.9-33.9 45.3-45.3 56.6 56.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-56.6-56.6 45.3-45.3 33.9 33.9c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L414.4 256l33.9-33.9c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-33.9 33.9-45.3-45.3 56.6-56.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-56.6 56.6-45.3-45.3 33.9-33.9c6.2-6.2 6.2-16.4 0-22.6zM142.9 256l45.3-45.3L233.4 256l-45.3 45.3L142.9 256zm67.9 67.9L256 278.6l45.3 45.3L256 369.1l-45.3-45.3zM278.6 256l45.3-45.3L369.1 256l-45.3 45.3L278.6 256zm22.6-67.9L256 233.4l-45.3-45.3L256 142.9l45.3 45.3z", "M425.7 312.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L414.4 256l33.9-33.9c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-33.9 33.9-45.3-45.3 56.6-56.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-56.6 56.6-45.3-45.3 33.9-33.9c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L256 97.6 222.1 63.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l33.9 33.9-45.3 45.3-56.6-56.6c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l56.6 56.6-45.3 45.3L86.3 199.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L97.6 256 63.7 289.9c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l33.9-33.9 45.3 45.3-56.6 56.6c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l56.6-56.6 45.3 45.3-33.9 33.9c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L256 414.4l33.9 33.9c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-33.9-33.9 45.3-45.3 56.6 56.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-56.6-56.6 45.3-45.3 33.9 33.9zM256 369.1l-45.3-45.3L256 278.6l45.3 45.3L256 369.1zm-67.9-67.9L142.9 256l45.3-45.3L233.4 256l-45.3 45.3zM256 233.4l-45.3-45.3L256 142.9l45.3 45.3L256 233.4zm67.9 67.9L278.6 256l45.3-45.3L369.1 256l-45.3 45.3z"]],
    "bold": [384, 512, [], "f032", ["M0 64C0 46.3 14.3 32 32 32H80 96 224c70.7 0 128 57.3 128 128c0 31.3-11.3 60.1-30 82.3c37.1 22.4 62 63.1 62 109.7c0 70.7-57.3 128-128 128H96 80 32c-17.7 0-32-14.3-32-32s14.3-32 32-32H48V256 96H32C14.3 96 0 81.7 0 64zM224 224c35.3 0 64-28.7 64-64s-28.7-64-64-64H112V224H224zM112 288V416H256c35.3 0 64-28.7 64-64s-28.7-64-64-64H224 112z", ""]],
    "anchor-lock": [640, 512, [], "e4ad", ["M288 64a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm96 32c0 33.4-17 62.8-42.9 80H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H320V448h48c5.5 0 10.8-.5 16-1.3V480c0 11 2.7 21.3 7.6 30.3c-7.7 1.1-15.6 1.7-23.6 1.7H288 208c-88.4 0-160-71.6-160-160v-6.1l-7 7c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l56-56c9.4-9.4 24.6-9.4 33.9 0l56 56c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-7-7V352c0 53 43 96 96 96h48V240H224c-17.7 0-32-14.3-32-32s14.3-32 32-32h10.9C209 158.8 192 129.4 192 96c0-53 43-96 96-96s96 43 96 96z", "M496 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "building-ngo": [384, 512, [], "e4d7", ["M48 0C21.5 0 0 21.5 0 48V464c0 26.5 21.5 48 48 48h96V432c0-26.5 21.5-48 48-48s48 21.5 48 48v80h96c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H48zM64 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H80c-8.8 0-16-7.2-16-16V240zm112-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H176c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H272c-8.8 0-16-7.2-16-16V240zM168 64h48c8.8 0 16 7.2 16 16s-7.2 16-16 16H184v64h16V144c0-8.8 7.2-16 16-16s16 7.2 16 16v24c0 13.3-10.7 24-24 24H176c-13.3 0-24-10.7-24-24V80c0-8.8 7.2-16 16-16zM304 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16s16-7.2 16-16V112c0-8.8-7.2-16-16-16zm-48 16c0-26.5 21.5-48 48-48s48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V112zM61.3 71.1l34.7 52V80c0-8.8 7.2-16 16-16s16 7.2 16 16v96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4L64 132.8V176c0 8.8-7.2 16-16 16s-16-7.2-16-16V80c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4z", "M61.3 71.1c-3.9-5.9-11.2-8.5-17.9-6.4S32 72.9 32 80v96c0 8.8 7.2 16 16 16s16-7.2 16-16V132.8l34.7 52c3.9 5.9 11.2 8.5 17.9 6.4s11.4-8.3 11.4-15.3V80c0-8.8-7.2-16-16-16s-16 7.2-16 16v43.2l-34.7-52zM152 80v88c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V144c0-8.8-7.2-16-16-16s-16 7.2-16 16v16H184V96h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H168c-8.8 0-16 7.2-16 16zM304 96c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V112c0-8.8 7.2-16 16-16zm-48 16v32c0 26.5 21.5 48 48 48s48-21.5 48-48V112c0-26.5-21.5-48-48-48s-48 21.5-48 48z"]],
    "transporter-3": [512, 512, [], "e045", ["M480 32L472.7 6.6C471.6 2.7 468.1 0 464 0s-7.6 2.7-8.7 6.6L448 32l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7L448 64l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 64l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 32zM64 128l-7.3-25.4C55.6 98.7 52.1 96 48 96s-7.6 2.7-8.7 6.6L32 128 6.6 135.3C2.7 136.4 0 139.9 0 144s2.7 7.6 6.6 8.7L32 160l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 160l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 128zm112 0c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zm-32 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H368c8.8 0 16-7.2 16-16s-7.2-16-16-16H144zm-32 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H400c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zm64 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176z", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm8 464H128c-17.7 0-32-14.3-32-32s14.3-32 32-32H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H296 216zM96 256.5v-1c0 .3 0 .7 0 1z"]],
    "engine-warning": [640, 512, ["engine-exclamation"], "f5f2", ["M424 88c0-13.3-10.7-24-24-24H208c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0v32h48V112l72 0c13.3 0 24-10.7 24-24zM24 136c-13.3 0-24 10.7-24 24V352c0 13.3 10.7 24 24 24s24-10.7 24-24V280H96V232H48V160c0-13.3-10.7-24-24-24zm552 56c-17.7 0-32 14.3-32 32V416c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H576z", "M128 144c-17.7 0-32 14.3-32 32V352c0 17.7 14.3 32 32 32h44.8l32 40c12.1 15.2 30.5 24 50 24H448c35.3 0 64-28.7 64-64V238.8c0-19.4-8.8-37.8-24-50L449.5 158c-11.3-9.1-25.4-14-40-14H208 160 128zm196 64v88c0 11-9 20-20 20s-20-9-20-20V208c0-11 9-20 20-20s20 9 20 20zM304 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "circle-down-right": [512, 512, [], "e108", ["M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zm96 198.6V336c0 8.8-7.2 16-16 16H198.6c-12.5 0-22.6-10.1-22.6-22.6c0-6 2.4-11.8 6.6-16L216 280l-66.3-66.3C146 210 144 205.1 144 200s2-10 5.7-13.7l36.7-36.7c3.6-3.6 8.5-5.7 13.7-5.7s10 2 13.7 5.7L280 216l33.4-33.4c4.2-4.2 10-6.6 16-6.6c12.5 0 22.6 10.1 22.6 22.6z", "M352 336V198.6c0-12.5-10.1-22.6-22.6-22.6c-6 0-11.8 2.4-16 6.6L280 216l-66.3-66.3C210 146 205.1 144 200 144s-10 2-13.7 5.7l-36.7 36.7C146 190 144 194.9 144 200s2 10 5.7 13.7L216 280l-33.4 33.4c-4.2 4.2-6.6 10-6.6 16c0 12.5 10.1 22.6 22.6 22.6H336c8.8 0 16-7.2 16-16z"]],
    "square-k": [448, 512, [], "e274", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM313.1 168.8l-73 74.3 75.3 102.7c7.8 10.7 5.5 25.7-5.2 33.5s-25.7 5.5-33.5-5.2L206 277.8l-30 30.5V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V298.5 152c0-13.3 10.7-24 24-24s24 10.7 24 24v87.8L278.9 135.2c9.3-9.5 24.5-9.6 33.9-.3s9.6 24.5 .3 33.9z", "M312.8 134.9c9.5 9.3 9.6 24.5 .3 33.9l-73 74.3 75.3 102.7c7.8 10.7 5.5 25.7-5.2 33.5s-25.7 5.5-33.5-5.2L206 277.8l-30 30.5V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V298.5 152c0-13.3 10.7-24 24-24s24 10.7 24 24v87.8L278.9 135.2c9.3-9.5 24.5-9.6 33.9-.3z"]],
    "manat-sign": [384, 512, [], "e1d5", ["M192 32c-17.7 0-32 14.3-32 32V98.7c10.4-1.7 21.1-2.7 32-2.7s21.6 .9 32 2.7V64c0-17.7-14.3-32-32-32zm32 132c-10.2-2.6-21-4-32-4s-21.8 1.4-32 4V448c0 17.7 14.3 32 32 32s32-14.3 32-32V164z", "M0 288C0 182 86 96 192 96s192 86 192 192V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V288c0-70.7-57.3-128-128-128s-128 57.3-128 128V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V288z"]],
    "money-check-pen": [640, 512, ["money-check-edit"], "f872", ["M0 128C0 92.7 28.7 64 64 64H512c35.3 0 64 28.7 64 64v64.6c-15.2 2-29.8 8.8-41.4 20.5L353.3 394.3c-8.2 8.2-14 18.5-16.8 29.7l-6 23.9H64c-35.3 0-64-28.7-64-64V128zM96 304c0 8.8 7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm16-112c-8.8 0-16 7.2-16 16s7.2 16 16 16H432c8.8 0 16-7.2 16-16s-7.2-16-16-16H112z", "M557.2 235.7l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-52 52L375.9 417c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L576.1 358.7l-71-71z"]],
    "not-equal": [448, 512, [], "f53e", ["M260.2 144l-42.7 64H48c-17.7 0-32-14.3-32-32s14.3-32 32-32H260.2zM153.5 304l-42.7 64H48c-17.7 0-32-14.3-32-32s14.3-32 32-32H153.5zm34.3 64l42.7-64H400c17.7 0 32 14.3 32 32s-14.3 32-32 32H187.8zM294.5 208l42.7-64H400c17.7 0 32 14.3 32 32s-14.3 32-32 32H294.5z", "M369.8 37.4c14.7 9.8 18.7 29.7 8.9 44.4l-256 384c-9.8 14.7-29.7 18.7-44.4 8.9s-18.7-29.7-8.9-44.4l256-384c9.8-14.7 29.7-18.7 44.4-8.9z"]],
    "border-top-left": [448, 512, ["border-style"], "f853", ["M416 128a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 96a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM128 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-96-64a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm192 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M32 480c-17.7 0-32-14.3-32-32L0 112C0 67.8 35.8 32 80 32l336 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 96c-8.8 0-16 7.2-16 16l0 336c0 17.7-14.3 32-32 32z"]],
    "map-location-dot": [576, 512, ["map-marked-alt"], "f5a0", ["M416 503V200.4c3.5-6.9 6.7-13.8 9.6-20.6c.5-1.2 1-2.5 1.5-3.7l116-46.4C558.9 123.4 576 135 576 152V422.8c0 9.8-6 18.6-15.1 22.3L416 503zM15.1 187.3l122.6-49c2.4 14.1 7.2 28.3 12.8 41.5c2.9 6.8 6.1 13.7 9.6 20.6V451.8L32.9 502.7C17.1 509 0 497.4 0 480.4V209.6c0-9.8 6-18.6 15.1-22.3zM384 255V504.3L192 449.4V255c20.5 31.3 42.3 59.6 56.2 77c20.5 25.6 59.1 25.6 79.6 0c13.9-17.4 35.7-45.7 56.2-77z", "M302.8 312C334.9 271.9 408 174.6 408 120C408 53.7 354.3 0 288 0S168 53.7 168 120c0 54.6 73.1 151.9 105.2 192c7.7 9.6 22 9.6 29.6 0zM288 72a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]],
    "tilde": [448, 512, [63135], "7e", ["M99.9 192C80.1 192 64 208.1 64 227.9V320c0 17.7-14.3 32-32 32s-32-14.3-32-32V227.9C0 172.7 44.7 128 99.9 128c26.5 0 51.9 10.5 70.6 29.3L322.7 309.5c6.7 6.7 15.9 10.5 25.4 10.5c19.8 0 35.9-16.1 35.9-35.9V192c0-17.7 14.3-32 32-32s32 14.3 32 32v92.1c0 55.2-44.7 99.9-99.9 99.9c-26.5 0-51.9-10.5-70.6-29.3L125.3 202.5c-6.7-6.7-15.9-10.5-25.4-10.5z", ""]],
    "jedi": [576, 512, [], "f669", ["M246 315.7l-21.2-31.9c-2.1-3.2-1.7-7.4 1-10.1s6.9-3.1 10.1-1l29.5 19.7c2.1 1.4 4.9 0 5-2.6L279.7 8c.1-4.5 3.8-8 8.3-8s8.1 3.5 8.3 8l9.4 281.9c.1 2.5 2.9 3.9 5 2.6l29.5-19.7c3.2-2.1 7.4-1.7 10.1 1s3.1 6.9 1 10.1L330 315.7c-1.3 1.9-.2 4.5 2 4.9l37.6 7.5c3.7 .7 6.4 4 6.4 7.8s-2.7 7.1-6.4 7.8L332 351.4c-2.2 .4-3.3 3-2 4.9l21.2 31.9c2.1 3.2 1.7 7.4-1 10.1s-6.9 3.1-10.1 1l-26.3-17.6c-2.2-1.4-5.1 .2-5 2.8l2.1 61.5c-7.4 1.3-15.1 2-22.9 2s-15.4-.7-22.9-2l2.1-61.5c.1-2.6-2.8-4.2-5-2.8l-26.3 17.6c-3.2 2.1-7.4 1.7-10.1-1s-3.1-6.9-1-10.1L246 356.3c1.3-1.9 .2-4.5-2-4.9l-37.6-7.5c-3.7-.7-6.4-4-6.4-7.8s2.7-7.1 6.4-7.8l37.6-7.5c2.2-.4 3.3-3 2-4.9z", "M376.2 201.9c-7.5 5.8-8 17.9-1 24.4C400.3 249.6 416 283 416 320c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-37 15.7-70.4 40.8-93.7c7-6.5 6.5-18.6-1-24.4C165.9 175.5 144 134.3 144 88c0-16.8 2.9-33 8.2-48c4.6-13-10.2-30-21.4-22C77.3 56 38.1 112.8 22.9 178.8c-.5 2.1 .2 4.3 1.7 5.9l28.4 28.4c4 4 1.2 10.9-4.5 10.9h-26c-3.4 0-6.2 2.6-6.3 6c-.1 3.3-.2 6.6-.2 10c0 17.5 1.7 34.7 4.8 51.3c.2 1.2 .8 2.4 1.7 3.3l46.5 46.5c4 4 1.2 10.9-4.5 10.9H50c-4.6 0-7.7 4.8-5.7 9C88.8 450.5 181.2 512 288 512s199.2-61.5 243.7-151c2.1-4.2-1-9-5.7-9H511.4c-5.7 0-8.6-6.9-4.5-10.9l46.5-46.5c.9-.9 1.5-2 1.7-3.3c3.2-16.6 4.8-33.8 4.8-51.3c0-3.3-.1-6.7-.2-10c-.1-3.4-2.9-6-6.3-6h-26c-5.7 0-8.6-6.9-4.5-10.9l28.4-28.4c1.5-1.5 2.2-3.8 1.7-5.9C537.9 112.8 498.7 56 445.2 18c-11.3-8-26 8.9-21.4 22c5.3 15 8.2 31.2 8.2 48c0 46.3-21.9 87.5-55.8 113.9z"]],
    "square-poll-vertical": [448, 512, ["poll"], "f681", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm64 192c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V256c0-17.7 14.3-32 32-32zm64-64c0-17.7 14.3-32 32-32s32 14.3 32 32V352c0 17.7-14.3 32-32 32s-32-14.3-32-32V160zM320 288c17.7 0 32 14.3 32 32v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V320c0-17.7 14.3-32 32-32z", "M192 160c0-17.7 14.3-32 32-32s32 14.3 32 32V352c0 17.7-14.3 32-32 32s-32-14.3-32-32V160zM96 256c0-17.7 14.3-32 32-32s32 14.3 32 32v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V256zm224 32c17.7 0 32 14.3 32 32v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V320c0-17.7 14.3-32 32-32z"]],
    "arrow-down-square-triangle": [576, 512, ["sort-shapes-down-alt"], "f889", ["M368 32h96c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H368c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48zm48 256c11 0 21.3 5.7 27.1 15l80 128c6.2 9.9 6.5 22.3 .9 32.5s-16.4 16.5-28 16.5H336c-11.6 0-22.3-6.3-28-16.5s-5.3-22.6 .9-32.5l80-128c5.8-9.4 16.1-15 27.1-15z", "M160 480c9 0 17.5-3.8 23.6-10.4l88-96c11.9-13 11.1-33.3-2-45.2s-33.3-11.1-45.2 2L192 365.7V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V365.7L95.6 330.4c-11.9-13-32.2-13.9-45.2-2s-13.9 32.2-2 45.2l88 96C142.5 476.2 151 480 160 480z"]],
    "mug-hot": [512, 512, [9749], "f7b6", ["M112 24c0-13.3-10.7-24-24-24S64 10.7 64 24c0 38.9 23.4 59.4 39.1 73.1l1.1 1C120.5 112.3 128 119.9 128 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-38.9-23.4-59.4-39.1-73.1l-1.1-1C119.5 47.7 112 40.1 112 24zm112 0c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 38.9 23.4 59.4 39.1 73.1l1.1 1C232.5 112.3 240 119.9 240 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-38.9-23.4-59.4-39.1-73.1l-1.1-1C231.5 47.7 224 40.1 224 24z", "M32 192c-17.7 0-32 14.3-32 32V416c0 53 43 96 96 96H288c53 0 96-43 96-96h16c61.9 0 112-50.1 112-112s-50.1-112-112-112H352 32zm352 64h16c26.5 0 48 21.5 48 48s-21.5 48-48 48H384V256z"]],
    "dog-leashed": [576, 512, [129454], "f6d4", ["M101 4.4c6.4-6.1 16.5-5.8 22.6 .6L281.3 170.5l148.9 62.7c8.1 3.4 12 12.8 8.5 21s-12.8 12-21 8.5L288 208.1V384c0 8.8-7.2 16-16 16s-16-7.2-16-16V190.4L100.4 27c-6.1-6.4-5.8-16.5 .6-22.6z", "M256 192H144 128 98c-14.7 0-27.5-10-31-24.2L63 152.2c-4.3-17.1-21.7-27.6-38.8-23.3S-3.3 150.6 1 167.8l3.9 15.5c7.8 31.2 30.4 55.6 59.2 66.5V480c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V364.8c24 12.3 51.2 19.2 80 19.2c5.4 0 10.7-.2 16-.7V192zm32 185.4c11.2-3.2 21.9-7.4 32-12.6V480c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32l0-218L288 208.1V377.4zM420.5 229.2l6.2-37.2H448h16 32c44.2 0 80-35.8 80-80V88c0-13.3-10.7-24-24-24H496L478.1 46.1c-9-9-21.2-14.1-33.9-14.1H392L375.1 9.5c-4.5-6-11.5-9.5-19-9.5c-11.6 0-21.5 8.4-23.4 19.8l-26.8 161 114.6 48.3zM432 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "car-battery": [512, 512, ["battery-car"], "f5df", ["M0 160c0-35.3 28.7-64 64-64H448c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160zm368 16c-8.8 0-16 7.2-16 16v32H320c-8.8 0-16 7.2-16 16s7.2 16 16 16h32v32c0 8.8 7.2 16 16 16s16-7.2 16-16V256h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H384V192c0-8.8-7.2-16-16-16zM96 224c-8.8 0-16 7.2-16 16s7.2 16 16 16h96c8.8 0 16-7.2 16-16s-7.2-16-16-16H96z", "M80 96c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32H80zm224 0c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32H304z"]],
    "face-downcast-sweat": [512, 512, [], "e371", ["M256 0c-51.4 0-99.3 15.2-139.4 41.2c1.5 3.1 3 6.2 4.3 9.3c3.4 8 7.1 19 7.1 30.5c0 44.3-36.6 79-80 79c-9.6 0-18.8-1.7-27.4-4.8C7.3 186.1 0 220.2 0 256C0 397.4 114.6 512 256 512s256-114.6 256-256S397.4 0 256 0zM195.9 410.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6C188.2 371.4 216.3 352 256 352s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7z", "M48 128C21.5 128 0 107 0 81C0 61 28.6 20.6 41.6 3.3c3.2-4.4 9.6-4.4 12.8 0C67.6 20.6 96 61 96 81c0 26-21.5 47-48 47zM96 272c0-8.8 7.2-16 16-16h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16zm192 0c0-8.8 7.2-16 16-16h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H304c-8.8 0-16-7.2-16-16z"]],
    "mailbox-flag-up": [576, 512, [], "e5bb", ["M400 224c-8.8 0-16-7.2-16-16V96 64H144c79.5 0 144 64.5 144 144V384c0 35.3-28.7 64-64 64H512c35.3 0 64-28.7 64-64V208c0-56.5-32.6-105.5-80-129V96c0 8.8-7.2 16-16 16H416v96c0 8.8-7.2 16-16 16z", "M400 224c-8.8 0-16-7.2-16-16V96 48c0-8.8 7.2-16 16-16h80c8.8 0 16 7.2 16 16V96c0 8.8-7.2 16-16 16H416v96c0 8.8-7.2 16-16 16zM0 208C0 128.5 64.5 64 144 64s144 64.5 144 144V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V208zm64 0c0 8.8 7.2 16 16 16H208c8.8 0 16-7.2 16-16s-7.2-16-16-16H80c-8.8 0-16 7.2-16 16z"]],
    "memo-circle-info": [576, 512, [], "e49a", ["M64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c3.3 0 6.6-.3 9.7-.7C285.1 479.3 256 427.1 256 368c0-80.6 54.1-148.5 128-169.4V64c0-35.3-28.7-64-64-64H64zM80 128H304c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16s7.2-16 16-16zM64 240c0-8.8 7.2-16 16-16H240c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-40 56c-8.8 0-16 7.2-16 16s7.2 16 16 16h0v48h0c-8.8 0-16 7.2-16 16s7.2 16 16 16h16 16c8.8 0 16-7.2 16-16s-7.2-16-16-16V368c0-8.8-7.2-16-16-16H416z"]],
    "gift": [512, 512, [127873], "f06b", ["M73.6 128c14.6 28.5 44.2 48 78.4 48h64 8v80H32c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32H73.6zM480 256H288V176h72c34.2 0 63.8-19.5 78.4-48H480c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32zM32 288H224V512H80c-26.5 0-48-21.5-48-48V288zM288 512V288H480V464c0 26.5-21.5 48-48 48H288z", "M190.5 68.8L225.3 128H224h-8H152c-22.1 0-40-17.9-40-40s17.9-40 40-40h2.2c14.9 0 28.8 7.9 36.3 20.8zM256 85.5l-24.1-41C215.7 16.9 186.1 0 154.2 0H152C103.4 0 64 39.4 64 88s39.4 88 88 88h64 8v80h64V176h72c48.6 0 88-39.4 88-88s-39.4-88-88-88h-2.2c-31.9 0-61.5 16.9-77.7 44.4L256 85.5zm65.5-16.7C329.1 55.9 342.9 48 357.8 48H360c22.1 0 40 17.9 40 40s-17.9 40-40 40H286.7l34.8-59.2zM288 512V288H224V512h64z"]],
    "dice-two": [448, 512, [9857], "f528", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM352 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M128 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM320 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "volume": [576, 512, [128265, "volume-medium"], "f6a8", ["M471.3 110.5c8.4-10.3 23.5-11.8 33.8-3.5c43.2 35.2 70.9 88.9 70.9 149s-27.7 113.8-70.9 149c-10.3 8.4-25.4 6.8-33.8-3.5s-6.8-25.4 3.5-33.8C507.3 341.3 528 301.1 528 256s-20.7-85.3-53.2-111.8c-10.3-8.4-11.8-23.5-3.5-33.8zM410.8 185c8.4-10.3 23.5-11.8 33.8-3.5C466.1 199.1 480 225.9 480 256s-13.9 56.9-35.4 74.5c-10.3 8.4-25.4 6.8-33.8-3.5s-6.8-25.4 3.5-33.8C425.1 284.4 432 271 432 256s-6.9-28.4-17.7-37.3c-10.3-8.4-11.8-23.5-3.5-33.8z", "M352 64c0-12.6-7.4-24-18.9-29.2s-25-3.1-34.4 5.3L163.8 160H96c-35.3 0-64 28.7-64 64v64c0 35.3 28.7 64 64 64h67.8L298.7 471.9c9.4 8.4 22.9 10.4 34.4 5.3S352 460.6 352 448V64z"]],
    "transporter-5": [512, 512, [], "e2a6", ["M480 32L472.7 6.6C471.6 2.7 468.1 0 464 0s-7.6 2.7-8.7 6.6L448 32l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7L448 64l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 64l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 32zM64 160l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 160 6.6 167.3C2.7 168.4 0 171.9 0 176s2.7 7.6 6.6 8.7L32 192l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 192l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 160zM224 0c-8.8 0-16 7.2-16 16s7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H224zM176 128c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zM112 256c-8.8 0-16 7.2-16 16s7.2 16 16 16H400c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zm64 128c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176z", "M96 480c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H128c-17.7 0-32-14.3-32-32z"]],
    "gauge-circle-bolt": [640, 512, [], "e496", ["M504 192.2c-2.6-.1-5.3-.2-8-.2c-97.2 0-176 78.8-176 176c0 45.9 17.6 87.7 46.4 119C333 503 295.5 512 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0C375.4 0 475.6 81.7 504 192.2zM256 416c35.3 0 64-28.7 64-64c0-26.9-16.5-49.9-40-59.3V88c0-13.3-10.7-24-24-24s-24 10.7-24 24V292.7c-23.5 9.5-40 32.5-40 59.3c0 35.3 28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM368 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm194.5-66.2c2.8-5 1.7-11.1-2.6-14.9s-10.6-4-15.1-.6l-96 72c-4.1 3.1-5.8 8.5-4.2 13.4s6.2 8.2 11.4 8.2h35.6l-30.1 54.2c-2.8 5-1.7 11.1 2.6 14.9s10.6 4 15.1 .6l96-72c4.1-3.1 5.8-8.5 4.2-13.4s-6.2-8.2-11.4-8.2H516.4l30.1-54.2z"]],
    "coin-front": [512, 512, [], "e3fc", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM256 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320zm0 352a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm24-264c0-13.3-10.7-24-24-24s-24 10.7-24 24V328c0 13.3 10.7 24 24 24s24-10.7 24-24V184z", "M256 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320zm0 352a192 192 0 1 0 0-384 192 192 0 1 0 0 384z"]],
    "file-slash": [640, 512, [], "e3a7", ["M0 448V96L384 398.5V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64zM384 275.7L38.8 5.1C46.6 1.8 55.1 0 64 0H224V128c0 17.7 14.3 32 32 32H384V275.7zM256 0L384 128H256V0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "message-arrow-up-right": [512, 512, [], "e1dd", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zm200 64c-13.3 0-24 10.7-24 24s10.7 24 24 24h54.1l-87 87c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l87-87V264c0 13.3 10.7 24 24 24s24-10.7 24-24V152c0-13.3-10.7-24-24-24H200z", "M176 152c0-13.3 10.7-24 24-24H312c13.3 0 24 10.7 24 24V264c0 13.3-10.7 24-24 24s-24-10.7-24-24V209.9l-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l87-87H200c-13.3 0-24-10.7-24-24z"]],
    "treasure-chest": [576, 512, [], "f723", ["M96 36V256H0V160C0 100.4 40.8 50.2 96 36zM224 256H160V32H416V256H352V224c0-17.7-14.3-32-32-32H256c-17.7 0-32 14.3-32 32v32zm256 0V36c55.2 14.2 96 64.3 96 124v96H480zM0 288H96V480H48c-26.5 0-48-21.5-48-48V288zM416 480H160V288h64v32c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V288h64V480zm64 0V288h96V432c0 26.5-21.5 48-48 48H480z", "M160 32V256H96V36c10.2-2.6 21-4 32-4h32zM416 256V32h32c11 0 21.8 1.4 32 4V256H416zM224 224c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32H256c-17.7 0-32-14.3-32-32V224zm64 0c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16s16-7.2 16-16V240c0-8.8-7.2-16-16-16zM160 480H96V288h64V480zm256 0V288h64V480H416z"]],
    "chess-queen": [512, 512, [9819], "f445", ["M400 432H112L70.6 473.4c-4.2 4.2-6.6 10-6.6 16C64 501.9 74.1 512 86.6 512H425.4c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L400 432z", "M312 56A56 56 0 1 0 200 56a56 56 0 1 0 112 0zM164.3 120c-15.3 0-27 10.8-30.2 23.8c-7 27.8-32.2 48.3-62.1 48.3c-10.8 0-20.9-2.7-29.8-7.3c-8.4-4.4-19-4.5-27.7 .9C2.1 193.3-2.4 209.2 4.3 222.2L112.4 432H128h38.4H345.6 384h15.6L507.7 222.2c6.7-13 2.2-28.9-10.2-36.5c-8.7-5.4-19.3-5.4-27.7-.9c-8.9 4.7-19 7.3-29.8 7.3c-29.9 0-55.1-20.5-62.1-48.3c-3.3-13-15-23.8-30.2-23.8c-12.3 0-22.6 7.2-27.7 17c-12 23.2-36.2 39-64 39s-52-15.8-64-39c-5.1-9.8-15.4-17-27.7-17zM256 224l0 0 0 0s0 0 0 0z"]],
    "paintbrush-fine": [576, 512, ["paint-brush-alt", "paint-brush-fine", "paintbrush-alt"], "f5a9", ["M205 291.8l0 0 0 0c-9.2-2.5-19-3.8-29-3.8c-61.9 0-112 50.1-112 112c0 3.9 .2 7.8 .6 11.6C66.4 429.1 54.4 448 36.8 448H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H176c61.9 0 112-50.1 112-112c0-10-1.3-19.7-3.8-29l0 0 0 0c0-.1 0-.1-.1-.2l-78.9-78.9c-.1 0-.1 0-.2-.1z", "M559.6 95.6c21.9-21.9 21.9-57.3 0-79.2s-57.3-21.9-79.2 0L205.1 291.7l79.2 79.2L559.6 95.6z"]],
    "glasses": [576, 512, [], "f530", ["M223.4 314l-3.2 57.5c-1.9 33.9-29.9 60.5-63.9 60.5H112c-35.3 0-64-28.7-64-64V314.2c27.2-11.8 58.2-18.2 87.7-18.2c29.4 0 60.4 6.3 87.7 18zm129.2 0c27.3-11.7 58.3-18 87.7-18c29.5 0 60.5 6.4 87.7 18.2V368c0 35.3-28.7 64-64 64H419.7c-34 0-62-26.5-63.9-60.5L352.6 314z", "M118.6 80c-11.5 0-21.4 7.9-24 19.1L57.1 259.8c25.6-7.8 52.6-11.8 78.6-11.8c40.1 0 82.2 9.6 118.5 27.3c5.8 2.9 10.4 7.3 13.5 12.7h40.6c3.1-5.4 7.7-9.8 13.5-12.7c36.2-17.8 78.4-27.3 118.5-27.3c26 0 53 4.1 78.6 11.8L481.4 99.1c-2.6-11.2-12.6-19.1-24-19.1c-3.1 0-6.2 .6-9.2 1.8L416.9 94.3c-12.3 4.9-26.3-1.1-31.2-13.4s1.1-26.3 13.4-31.2l31.3-12.5c8.6-3.4 17.7-5.2 27-5.2c33.8 0 63.1 23.3 70.8 56.2l43.9 188c1.7 7.3 2.9 14.7 3.5 22.2c.3 1.8 .5 3.7 .5 5.6v5.2c0 .5 0 1 0 1.5V352c0 .2 0 .4 0 .6V368c0 61.9-50.1 112-112 112H419.7c-59.4 0-108.5-46.4-111.8-105.8L306.6 352H269.4l-1.2 22.2C264.9 433.6 215.8 480 156.3 480H112C50.1 480 0 429.9 0 368V352 310.7 304c0-1.9 .2-3.8 .5-5.7c.6-7.4 1.8-14.8 3.5-22.1l43.9-188C55.5 55.3 84.8 32 118.6 32c9.2 0 18.4 1.8 27 5.2l31.3 12.5c12.3 4.9 18.3 18.9 13.4 31.2s-18.9 18.3-31.2 13.4L127.8 81.8c-2.9-1.2-6-1.8-9.2-1.8zM48 352v16c0 35.3 28.7 64 64 64h44.3c34 0 62-26.5 63.9-60.5l3.2-57.5c-27.3-11.7-58.3-18-87.7-18c-29.5 0-60.5 6.4-87.7 18.2V352zm392.3-56c-29.4 0-60.4 6.3-87.7 18l3.2 57.5c1.9 33.9 29.9 60.5 63.9 60.5H464c35.3 0 64-28.7 64-64V314.2c-27.2-11.8-58.2-18.2-87.7-18.2z"]],
    "hood-cloak": [576, 512, [], "f6ef", ["M160 320c0-70.7 57.3-128 128-128s128 57.3 128 128V512H160V320z", "M432 0H288h0c-9.8 0-66 0-120.2 37.7C111.4 76.9 64 151.8 64 288c0 58.5-14.6 101.6-28.6 129.7c-7 14.1-14 24.5-19 31.1c-2.5 3.3-4.5 5.7-5.7 7.1c-.6 .7-1.1 1.2-1.3 1.4l-.2 .2c-9 9.1-11.7 22.8-6.8 34.7c5 12 16.6 19.8 29.6 19.8H160V320c0-70.7 57.3-128 128-128s128 57.3 128 128V512H544c12.9 0 24.6-7.8 29.6-19.8c4.9-11.9 2.2-25.6-6.8-34.7l0 0 0 0 0 0-.1-.1c-.2-.2-.7-.7-1.3-1.4c-1.3-1.4-3.2-3.8-5.7-7.1c-5-6.6-11.9-17-19-31.1C526.6 389.6 512 346.5 512 288c0-103.1-46.5-172.8-95.8-217.2l32-29c7.3-6.7 9.8-17.2 6.2-26.4S441.9 0 432 0z"]],
    "square-quote": [448, 512, [], "e329", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm64 128h48c17.7 0 32 14.3 32 32v24 24 39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7V272H128c-17.7 0-32-14.3-32-32V192c0-17.7 14.3-32 32-32zm224 80v39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7V272H272c-17.7 0-32-14.3-32-32V192c0-17.7 14.3-32 32-32h48c17.7 0 32 14.3 32 32v24 24z", "M96 192c0-17.7 14.3-32 32-32h48c17.7 0 32 14.3 32 32v24 24 39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7V272H128c-17.7 0-32-14.3-32-32V192zm256 87.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7V272H272c-17.7 0-32-14.3-32-32V192c0-17.7 14.3-32 32-32h48c17.7 0 32 14.3 32 32v24 24 39.3z"]],
    "up-left": [384, 512, [], "e2bd", ["M238.6 206.6L372.7 340.7c7.2 7.2 11.3 17.1 11.3 27.3s-4.1 20.1-11.3 27.3l-41.4 41.4c-7.2 7.2-17.1 11.3-27.3 11.3s-20.1-4.1-27.3-11.3L142.6 302.6l96-96z", "M48 80H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-240 240c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6V112c0-17.7 14.3-32 32-32z"]],
    "bring-front": [640, 512, [], "f857", ["M192 64H64V192h96v64H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H192c35.3 0 64 28.7 64 64V96H224c-11.7 0-22.6 3.1-32 8.6V64zM384 416h32c11.7 0 22.6-3.1 32-8.6V448H576V320H480V256h96c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H448c-35.3 0-64-28.7-64-64V416z", "M224 96c-35.3 0-64 28.7-64 64V352c0 35.3 28.7 64 64 64H416c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H224z"]],
    "chess-board": [448, 512, [], "f43c", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM384 96V416H64V96H384z", "M192 96H128v64H64v64h64v64H64v64h64v64h64V352h64v64h64V352h64V288H320V224h64V160H320V96H256v64H192V96zm0 128H128V160h64v64zm64 0v64h64v64H256V288H192v64H128V288h64V224h64zm0 0V160h64v64H256z"]],
    "burger-cheese": [512, 512, [127828, "cheeseburger"], "f7f1", ["M32 194.9C32 211 45 224 61.1 224H450.9c16.1 0 29.1-13 29.1-29.1c0-1.9-.2-3.7-.6-5.6C474.1 168.3 433.2 32 256 32S37.9 168.3 32.6 189.3c-.5 1.9-.6 3.7-.6 5.6zM128 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm240 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM256 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM32 400v16c0 35.3 28.7 64 64 64H416c35.3 0 64-28.7 64-64V400c0-8.8-7.2-16-16-16H48c-8.8 0-16 7.2-16 16zM234 262.7l68.2 45.5c10.7 7.2 24.8 7.2 35.5 0L406 262.7c6.5-4.4 14.2-6.7 22.1-6.7H211.9c7.9 0 15.6 2.3 22.1 6.7z", "M302.2 308.2L234 262.7c-6.5-4.4-14.2-6.7-22.1-6.7H208c0 0-.1 0-.1 0H64c-26.5 0-48 21.5-48 48s21.5 48 48 48H448c26.5 0 48-21.5 48-48s-21.5-48-48-48H432.1c0 0-.1 0-.1 0h-3.9c-7.9 0-15.6 2.3-22.1 6.7l-68.2 45.5c-10.7 7.2-24.8 7.2-35.5 0z"]],
    "building-circle-check": [640, 512, [], "e4d2", ["M0 48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V232.2c-39.1 32.3-64 81.1-64 135.8c0 49.5 20.4 94.2 53.3 126.2C364.5 505.1 351.1 512 336 512H240V432c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-26.5 0-48-21.5-48-48V48zM80 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H80zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H272zM64 112v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H176zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "repeat-1": [512, 512, [128258], "f365", ["", "M0 224c0 17.7 14.3 32 32 32s32-14.3 32-32c0-53 43-96 96-96H320v32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9S320 19.1 320 32V64H160C71.6 64 0 135.6 0 224zm512 64c0-17.7-14.3-32-32-32s-32 14.3-32 32c0 53-43 96-96 96H192V352c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6V448H352c88.4 0 160-71.6 160-160zM278 196.5c6.3 4.5 10 11.8 10 19.5v80c0 13.3-10.7 24-24 24s-24-10.7-24-24V248c-10 0-19.4-6.4-22.8-16.4c-4.2-12.6 2.6-26.2 15.2-30.4l24-8c7.3-2.4 15.4-1.2 21.6 3.3z"]],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", ["M0 448c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H32c-17.7 0-32 14.3-32 32z", "M169.4 342.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 242.7V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V242.7L86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128z"]],
    "grid-5": [448, 512, [], "e199", ["M96 48c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16V80c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V48zM16 128H48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H16c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zm0 192H48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H16c-8.8 0-16-7.2-16-16V336c0-8.8 7.2-16 16-16zm96-96h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16zM96 432c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V432zM208 128h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zM192 336c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16V336zM304 32h32c8.8 0 16 7.2 16 16V80c0 8.8-7.2 16-16 16H304c-8.8 0-16-7.2-16-16V48c0-8.8 7.2-16 16-16zM288 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H304c-8.8 0-16-7.2-16-16V240zm16 176h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H304c-8.8 0-16-7.2-16-16V432c0-8.8 7.2-16 16-16zm80-272c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H400c-8.8 0-16-7.2-16-16V144zm16 176h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H400c-8.8 0-16-7.2-16-16V336c0-8.8 7.2-16 16-16z", "M0 48c0-8.8 7.2-16 16-16H48c8.8 0 16 7.2 16 16V80c0 8.8-7.2 16-16 16H16C7.2 96 0 88.8 0 80V48zM0 240c0-8.8 7.2-16 16-16H48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H16c-8.8 0-16-7.2-16-16V240zM16 416H48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H16c-8.8 0-16-7.2-16-16V432c0-8.8 7.2-16 16-16zM96 144c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V144zm16 176h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V336c0-8.8 7.2-16 16-16zM192 48c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16V80c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16V48zm16 176h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16V240c0-8.8 7.2-16 16-16zM192 432c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H208c-8.8 0-16-7.2-16-16V432zM304 128h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H304c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zM288 336c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H304c-8.8 0-16-7.2-16-16V336zM400 32h32c8.8 0 16 7.2 16 16V80c0 8.8-7.2 16-16 16H400c-8.8 0-16-7.2-16-16V48c0-8.8 7.2-16 16-16zM384 240c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H400c-8.8 0-16-7.2-16-16V240zm16 176h32c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H400c-8.8 0-16-7.2-16-16V432c0-8.8 7.2-16 16-16z"]],
    "right-long-to-line": [640, 512, [], "e444", ["M608 64c17.7 0 32 14.3 32 32V416c0 17.7-14.3 32-32 32s-32-14.3-32-32V96c0-17.7 14.3-32 32-32z", "M334.5 414c8.8 3.8 19 2 26-4.6l144-136c4.8-4.5 7.5-10.8 7.5-17.4s-2.7-12.9-7.5-17.4l-144-136c-7-6.6-17.2-8.4-26-4.6s-14.5 12.5-14.5 22l0 72L32 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l288 0 0 72c0 9.6 5.7 18.2 14.5 22z"]],
    "person-chalkboard": [640, 512, [], "e53d", ["M144 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 304V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V256.9L91.4 304.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l58.3-97c17.4-28.9 48.6-46.6 82.3-46.6h65.9H400c17.7 0 32 14.3 32 32s-14.3 32-32 32H264V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H184z", "M384 128V64H576V256H384V192H320v80c0 26.5 21.5 48 48 48H592c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H368c-26.5 0-48 21.5-48 48v80h64z"]],
    "mars-stroke-right": [640, 512, [9897, "mars-stroke-h"], "f22b", ["M128 256a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z", "M208 368a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm174.4-88C370.7 365.8 297.1 432 208 432c-97.2 0-176-78.8-176-176s78.8-176 176-176c89.1 0 162.7 66.2 174.4 152H416V176c0-13.3 10.7-24 24-24s24 10.7 24 24v56h32V176c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c-6.9 6.9-17.2 8.9-26.2 5.2s-14.8-12.5-14.8-22.2V280H464v56c0 13.3-10.7 24-24 24s-24-10.7-24-24V280H382.4z"]],
    "hand-back-fist": [448, 512, ["hand-rock"], "f255", ["M144 0C117.5 0 96 21.5 96 48V96v28.5V176c0 8.8-7.2 16-16 16s-16-7.2-16-16V149.3l-9 7.5C40.4 169 32 187 32 206V244c0 38 16.9 74 46.1 98.3L128 384v96c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V374.7c46.9-19 80-65 80-118.7V176 160 144c0-26.5-21.5-48-48-48c-12.4 0-23.6 4.7-32.1 12.3C350 83.5 329.3 64 304 64c-12.4 0-23.6 4.7-32.1 12.3C270 51.5 249.3 32 224 32c-12.4 0-23.6 4.7-32.1 12.3C190 19.5 169.3 0 144 0z", ""]],
    "grid-round-5": [448, 512, [], "e5de", ["M160 64A32 32 0 1 1 96 64a32 32 0 1 1 64 0zM32 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm96-96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-256a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM320 96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM320 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM448 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64z", "M64 64A32 32 0 1 1 0 64a32 32 0 1 1 64 0zm0 192A32 32 0 1 1 0 256a32 32 0 1 1 64 0zM32 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM160 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM128 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM256 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-256a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]],
    "tally": [640, 512, ["tally-5"], "f69c", ["M128 32c-17.7 0-32 14.3-32 32V296.9l64-21.3V64c0-17.7-14.3-32-32-32zM96 364.4V448c0 17.7 14.3 32 32 32s32-14.3 32-32V343.1L96 364.4zm128-42.7V448c0 17.7 14.3 32 32 32s32-14.3 32-32V300.4l-64 21.3zm128-42.7V448c0 17.7 14.3 32 32 32s32-14.3 32-32V257.7l-64 21.3zm64-88.8V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V211.6l64-21.3zm64 46.1V448c0 17.7 14.3 32 32 32s32-14.3 32-32V215.1l-64 21.3zm64-88.8V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V168.9l64-21.3zM288 232.9V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V254.3l64-21.3z", "M638.4 149.9c5.6 16.8-3.5 34.9-20.2 40.5l-576 192c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l576-192c16.8-5.6 34.9 3.5 40.5 20.2z"]],
    "square-caret-up": [448, 512, ["caret-square-up"], "f151", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM224 160c6.7 0 13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9s-12.5 14.4-22 14.4H120c-9.5 0-18.2-5.7-22-14.4s-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7z", "M241.6 167.7c-4.5-4.9-10.9-7.7-17.6-7.7s-13 2.8-17.6 7.7l-104 112c-6.5 7-8.2 17.2-4.4 25.9s12.5 14.4 22 14.4H328c9.5 0 18.2-5.7 22-14.4s2.1-18.9-4.4-25.9l-104-112z"]],
    "cloud-showers-water": [576, 512, [], "e4e4", ["M132.3 259.4c-11.4-6.8-26.1-3.1-32.9 8.2l-48 80c-6.8 11.4-3.1 26.1 8.2 32.9s26.1 3.1 32.9-8.2l48-80c6.8-11.4 3.1-26.1-8.2-32.9zm336 0c-11.4-6.8-26.1-3.1-32.9 8.2l-48 80c-6.8 11.4-3.1 26.1 8.2 32.9s26.1 3.1 32.9-8.2l48-80c6.8-11.4 3.1-26.1-8.2-32.9zM252.6 292.3c6.8-11.4 3.1-26.1-8.2-32.9s-26.1-3.1-32.9 8.2l-48 80c-6.8 11.4-3.1 26.1 8.2 32.9s26.1 3.1 32.9-8.2l48-80zm103.8-32.9c-11.4-6.8-26.1-3.1-32.9 8.2l-48 80c-6.8 11.4-3.1 26.1 8.2 32.9s26.1 3.1 32.9-8.2l48-80c6.8-11.4 3.1-26.1-8.2-32.9zM306.5 421.9c-11.1-7.9-25.9-7.9-37 0C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1l0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7l0 0C439.4 437.2 410.9 448 384 448c-27.5 0-55-10.6-77.5-26.1z", "M311.2 55.7C295.9 22.8 262.6 0 224 0c-53 0-96 43-96 96c-35.3 0-64 28.7-64 64s28.7 64 64 64H448c35.3 0 64-28.7 64-64s-28.7-64-64-64h-1.6C439 59.5 406.7 32 368 32c-22.2 0-42.3 9.1-56.8 23.7z"]],
    "chart-bar": [512, 512, ["bar-chart"], "f080", ["M32 32c17.7 0 32 14.3 32 32V400c0 8.8 7.2 16 16 16H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-44.2 0-80-35.8-80-80V64C0 46.3 14.3 32 32 32z", "M160 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L160 96zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32H288c17.7 0 32-14.3 32-32s-14.3-32-32-32H160zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H160z"]],
    "hands-bubbles": [576, 512, ["hands-wash"], "e05e", ["M416 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM64 128c-17.7 0-32 14.4-32 32l.1 72.6c.1 52.2 24 101 64 133.1c-.1-1.9-.1-3.8-.1-5.7v-8c0-71.8 37-138.6 97.9-176.7l60.2-37.6c8.6-5.4 17.9-8.4 27.3-9.4l45.9-79.5c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8L218.3 141.7c-3.3 5.7-10.7 7.7-16.4 4.4s-7.7-10.7-4.4-16.4l51.5-89.1c6.6-11.5 2.7-26.2-8.8-32.8S214 5 207.4 16.5L149.9 116l0 0 0 0L96 209.3 96 160c0-17.7-14.4-32-32-32zm278.3 30.1c.9 1.4 1.7 2.9 2.5 4.4l28.9-50c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8L307.5 131c13.9 4.5 26.4 13.7 34.7 27zm36.2-5.9l-26.8 46.4c-.6 6-2.1 11.8-4.3 17.4H352h13.3l0 0H397l23-39.8c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8zM544 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM112 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96z", "M315.1 175c-9.4-15-29.1-19.5-44.1-10.2l-60.2 37.6C159.3 234.7 128 291.2 128 352v8c0 8.9 .8 17.6 2.2 26.1c35.4 8.2 61.8 40 61.8 77.9c0 6.3-.7 12.5-2.1 18.4C215.1 501 246.3 512 280 512H456c13.3 0 24-10.7 24-24s-10.7-24-24-24H364c-6.6 0-12-5.4-12-12s5.4-12 12-12H488c13.3 0 24-10.7 24-24s-10.7-24-24-24H364c-6.6 0-12-5.4-12-12s5.4-12 12-12H520c13.3 0 24-10.7 24-24s-10.7-24-24-24H364c-6.6 0-12-5.4-12-12s5.4-12 12-12H488c13.3 0 24-10.7 24-24s-10.7-24-24-24H352l0 0 0 0H258.8L305 219.1c15-9.4 19.5-29.1 10.2-44.1z"]],
    "less-than-equal": [448, 512, [], "f537", ["M413.7 52.1c6.6 16.4-1.4 35-17.8 41.6L150.2 192l245.7 98.3c16.4 6.6 24.4 25.2 17.8 41.6s-25.2 24.4-41.6 17.8l-320-128C40 216.9 32 205.1 32 192s8-24.9 20.1-29.7l320-128c16.4-6.6 35 1.4 41.6 17.8z", "M0 448c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z"]],
    "train": [448, 512, [128646], "f238", ["M96 64C78.3 64 64 78.3 64 96v96c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32H96zM35.1 492.9C28.1 499.9 33.1 512 43 512H82.7c8.5 0 16.6-3.4 22.6-9.4L160 448H96c-5.1 0-10-.4-14.9-1.1l-46 46zm307.5 9.7c6 6 14.1 9.4 22.6 9.4H405c10 0 15-12.1 7.9-19.1l-46-46c-4.8 .8-9.8 1.1-14.9 1.1H288l54.6 54.6z", "M0 96C0 43 43 0 96 0H352c53 0 96 43 96 96V352c0 53-43 96-96 96H96c-53 0-96-43-96-96V96zm64 0v96c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32H96C78.3 64 64 78.3 64 96zM224 384a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "up-from-dotted-line": [448, 512, [], "e456", ["M0 448a32 32 0 1 1 64 0A32 32 0 1 1 0 448zm96 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M196.7 43.3L73.9 166.1c-6.4 6.4-9.9 15-9.9 24C64 208.8 79.2 224 97.9 224H160V352c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V224h62.1c18.7 0 33.9-15.2 33.9-33.9c0-9-3.6-17.6-9.9-24L251.3 43.3C244.1 36.1 234.2 32 224 32s-20.1 4.1-27.3 11.3z"]],
    "eye-low-vision": [640, 512, ["low-vision"], "f2a8", ["M605.5 268.3c-13.4 32.3-40.3 77.8-79.9 118.4l-79.1-62C457.7 304.3 464 280.9 464 256c0-79.5-64.5-144-144-144c-37.3 0-71.4 14.2-96.9 37.5L150.7 92.8C195 58.3 251.8 32 320 32c80.8 0 145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6zM416 256c0 13.7-2.9 26.7-8 38.5l-94.6-74.1c4.2-8.5 6.6-18.2 6.6-28.3c0-11.5-3-22.3-8.4-31.6c2.8-.2 5.5-.4 8.4-.4c53 0 96 43 96 96z", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L38.8 5.1zM33.1 247.8c-1.8 6.8-1.3 14 1.4 20.5c14.9 35.7 46.2 87.7 93 131.1C174.5 443.2 239.2 480 320 480c3.1 0 6.1-.1 9.2-.2L33.1 247.8zM393.6 469.4c18.7-5.5 36.2-13 52.6-21.8L83.1 161.5c-11 14.4-20.5 28.7-28.4 42.2l339 265.7z"]],
    "traffic-light-go": [320, 512, [], "f638", ["M160 320a48 48 0 1 1 0 96 48 48 0 1 1 0-96z", "M64 0C28.7 0 0 28.7 0 64V352c0 88.4 71.6 160 160 160s160-71.6 160-160V64c0-35.3-28.7-64-64-64H64zm96 416a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm48-176a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-48-80a48 48 0 1 1 0-96 48 48 0 1 1 0 96z"]],
    "face-exhaling": [576, 512, [], "e480", ["M256 512c55.8 0 107.4-17.9 149.5-48.2c-10.5-9.3-17.9-22.1-20.5-36.5l-42.2-12.7C329.3 410.6 320 398.1 320 384s9.3-26.6 22.8-30.6L385 340.7c5.3-30 31.5-52.7 63-52.7c.7 0 1.4 0 2.1 0c13.2-14.7 32.3-24 53.7-24c2.7 0 5.4 .2 8.1 .5c.1-2.8 .1-5.6 .1-8.5C512 114.6 397.4 0 256 0S0 114.6 0 256S114.6 512 256 512zM195.2 238.4c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0zm121.6 0c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zM256 344a40 40 0 1 1 0 80 40 40 0 1 1 0-80z", "M543.5 336c0 .8 0 1.7-.1 2.5c19 6.4 32.6 24.4 32.6 45.5s-13.6 39.1-32.6 45.5c.1 .8 .1 1.7 .1 2.5c0 22.1-17.9 40-39.9 40c-14.2 0-26.6-7.4-33.7-18.5c-4.4 1.6-9.1 2.5-14 2.5c-22.1 0-39.9-17.9-39.9-40c0-2.7 .3-5.3 .8-7.8l-56.9-14.2c-4.6-1.1-7.8-5.2-7.8-9.9s3.2-8.8 7.8-9.9L415.9 360c0-22.1 17.9-40 39.9-40c3.6 0 7.2 .5 10.5 1.4c5.8-14.9 20.3-25.4 37.2-25.4c22.1 0 39.9 17.9 39.9 40z"]],
    "sensor-fire": [640, 512, [], "e02a", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64v32.2c-12.6-1.2-25.5 2.7-35.5 11.7c-35.4 31.6-65.6 67.7-87.3 102.8C304.3 276.5 288 314.9 288 350.1c0 49.3 18.6 95.2 49.6 129.9H64c-35.3 0-64-28.7-64-64V96zm88 0c-13.3 0-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V120c0-13.3-10.7-24-24-24zm96 0c-13.3 0-24 10.7-24 24V264c0 13.3 10.7 24 24 24s24-10.7 24-24V120c0-13.3-10.7-24-24-24z", "M433.8 163.6c5.6-5 14.2-5 19.8 0c19.7 17.8 38.2 37 55.5 57.7c7.9-9.9 16.8-20.7 26.5-29.5c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 56.7 24.2 76.9c0 87.8-71.3 161.9-160 161.9c-89.7 0-160-74.2-160-161.9c0-26.4 12.7-58.6 32.4-90.6c20-32.4 48.1-66.1 81.4-95.8zM481 447.9c18 0 34-5 49-15c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78z"]],
    "user-unlock": [640, 512, [], "e058", ["M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM0 482.3C0 383.8 79.8 304 178.3 304h91.4c43.6 0 83.6 15.7 114.6 41.7c-.2 2.1-.3 4.2-.3 6.3V480c0 11.7 3.1 22.6 8.6 32H29.7C13.3 512 0 498.7 0 482.3z", "M528 240c-17.7 0-32 14.3-32 32v48h16 48 48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32V272c0-44.2 35.8-80 80-80s80 35.8 80 80H560c0-17.7-14.3-32-32-32z"]],
    "hexagon-divide": [512, 512, [], "e1ad", ["M17.1 292c-12.9-22.3-12.9-49.7 0-72L105.4 67.1c12.9-22.3 36.6-36 62.4-36H344.3c25.7 0 49.5 13.7 62.4 36L494.9 220c12.9 22.3 12.9 49.7 0 72L406.6 444.9c-12.9 22.3-36.6 36-62.4 36H167.7c-25.7 0-49.5-13.7-62.4-36L17.1 292zM256 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-88 40c-13.3 0-24 10.7-24 24s10.7 24 24 24H344c13.3 0 24-10.7 24-24s-10.7-24-24-24H168zM288 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M224 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-80 96c0-13.3 10.7-24 24-24H344c13.3 0 24 10.7 24 24s-10.7 24-24 24H168c-13.3 0-24-10.7-24-24zm112 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "00": [640, 512, [], "e467", ["M352 176c0-79.5 64.5-144 144-144s144 64.5 144 144V336c0 79.5-64.5 144-144 144s-144-64.5-144-144V176zM496 96c-44.2 0-80 35.8-80 80V336c0 44.2 35.8 80 80 80s80-35.8 80-80V176c0-44.2-35.8-80-80-80z", "M0 176C0 96.5 64.5 32 144 32s144 64.5 144 144V336c0 79.5-64.5 144-144 144S0 415.5 0 336V176zM144 96c-44.2 0-80 35.8-80 80V336c0 44.2 35.8 80 80 80s80-35.8 80-80V176c0-44.2-35.8-80-80-80z"]],
    "crow": [640, 512, [], "f520", ["M544 120V88c0-21.3-7.5-40.8-20.1-56H574c29.4 0 55 20 62.1 48.5L640 96l-96 24zM355.2 384c16.9-.3 33.4-2.8 49-7.1l42 102c5 12.3-.8 26.3-13.1 31.3s-26.3-.8-31.3-13.1L355.2 384zm-96 0h51.9l39.1 94.9c5 12.3-.8 26.3-13.1 31.3s-26.3-.8-31.3-13.1L259.2 384z", "M456 0c-48.6 0-88 39.4-88 88v29.2L12.5 390.6c-14 10.8-16.6 30.9-5.9 44.9s30.9 16.6 44.9 5.9L126.1 384H352c106 0 192-86 192-192V128 88c0-48.6-39.4-88-88-88zm0 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "cassette-betamax": [576, 512, ["betamax"], "f8a4", ["M0 160H576V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160zM256 320A96 96 0 1 0 64 320a96 96 0 1 0 192 0zm96-96c-17.7 0-32 14.3-32 32V384c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32H352z", "M64 32C28.7 32 0 60.7 0 96v64H576V96c0-35.3-28.7-64-64-64H64zM192 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]],
    "sailboat": [576, 512, [], "e445", ["M256 16c0-7 4.5-13.2 11.2-15.3s13.9 .4 17.9 6.1l224 320c3.4 4.9 3.8 11.3 1.1 16.6s-8.2 8.6-14.2 8.6H272c-8.8 0-16-7.2-16-16V16zm-32 96V336c0 8.8-7.2 16-16 16H80c-5.7 0-11-3-13.8-8s-2.9-11-.1-16l128-224c3.6-6.3 11-9.4 18-7.5s11.9 8.2 11.9 15.5z", "M5.7 404.3C2.8 394.1 10.5 384 21.1 384H554.9c10.6 0 18.3 10.1 15.4 20.3l-4 14.3C550.7 473.9 500.4 512 443 512H133C75.6 512 25.3 473.9 9.7 418.7l-4-14.3z"]],
    "window-restore": [512, 512, [], "f2d2", ["M208 64H432c8.8 0 16 7.2 16 16V304c0 8.8-7.2 16-16 16H416v64h16c44.2 0 80-35.8 80-80V80c0-44.2-35.8-80-80-80H208c-44.2 0-80 35.8-80 80V96h64V80c0-8.8 7.2-16 16-16z", "M64 128c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V192c0-35.3-28.7-64-64-64H64zm32 64H288c17.7 0 32 14.3 32 32s-14.3 32-32 32H96c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]],
    "nfc-magnifying-glass": [640, 512, [], "e1f9", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c8.7 0 17-1.7 24.6-4.9c-35.9-9.1-67-30.3-88.6-59.1H112c-26.5 0-48-21.5-48-48V144c0-26.5 21.5-48 48-48h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16 7.2-16 16V368c0 8.8 7.2 16 16 16H301.3c-8.6-19.6-13.3-41.2-13.3-64c0-52.3 25.1-98.8 64-128V144c0-8.8-7.2-16-16-16H256c-8.8 0-16 7.2-16 16v66.7c18.6 6.6 32 24.4 32 45.3c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V144c0-26.5 21.5-48 48-48h80c26.5 0 48 21.5 48 48v29.3c19.6-8.6 41.2-13.3 64-13.3V96c0-35.3-28.7-64-64-64H64z", "M528 320.1a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM519.9 426c-20.5 14-45.3 22.1-71.9 22.1c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 26.7-8.2 51.4-22.1 71.9L633 471.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L519.9 426z"]],
    "file-binary": [384, 512, [], "e175", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM112 256c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V304c0-26.5-21.5-48-48-48H112zM96 304c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V304zm144-48c-8.8 0-16 7.2-16 16s7.2 16 16 16h16v96H240c-8.8 0-16 7.2-16 16s7.2 16 16 16h32 32c8.8 0 16-7.2 16-16s-7.2-16-16-16H288V272c0-8.8-7.2-16-16-16H240z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM112 256c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V304c0-26.5-21.5-48-48-48H112zM96 304c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H112c-8.8 0-16-7.2-16-16V304zm144-48c-8.8 0-16 7.2-16 16s7.2 16 16 16h16v96H240c-8.8 0-16 7.2-16 16s7.2 16 16 16h32 32c8.8 0 16-7.2 16-16s-7.2-16-16-16H288V272c0-8.8-7.2-16-16-16H240z"]],
    "circle-v": [512, 512, [], "e12a", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM173.5 157.3L256 322.3l82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-104-208c-5.9-11.9-1.1-26.3 10.7-32.2s26.3-1.1 32.2 10.7z", "M141.3 146.5c11.9-5.9 26.3-1.1 32.2 10.7L256 322.3l82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-104-208c-5.9-11.9-1.1-26.3 10.7-32.2z"]],
    "square-plus": [448, 512, [61846, "plus-square"], "f0fe", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM200 344V280H136c-13.3 0-24-10.7-24-24s10.7-24 24-24h64V168c0-13.3 10.7-24 24-24s24 10.7 24 24v64h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H248v64c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M200 280v64c0 13.3 10.7 24 24 24s24-10.7 24-24V280h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H248V168c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H136c-13.3 0-24 10.7-24 24s10.7 24 24 24h64z"]],
    "bowl-scoops": [448, 512, [127813], "e3df", ["M242.3 146.6C230.7 164.2 224 185.3 224 208c0 17.2 3.9 33.5 10.8 48H437.2c6.9-14.5 10.8-30.8 10.8-48c0-61.9-50.1-112-112-112l-1.1 0c-38.7 .4-72.7 20.4-92.6 50.6zM10.8 256H200.2c-5.3-15-8.2-31.2-8.2-48c0-22 4.9-42.8 13.7-61.4c-19.8-30.2-53.8-50.2-92.6-50.6L112 96C50.1 96 0 146.1 0 208c0 17.2 3.9 33.5 10.8 48zM224 0c-44.8 0-83.5 26.3-101.4 64.4c40.9 3 77.1 23 101.4 53.1c24.3-30.1 60.5-50.1 101.4-53.1C307.5 26.3 268.8 0 224 0z", "M4 261.4c3-3.4 7.4-5.4 12-5.4H432c4.6 0 9 2 12 5.4s4.5 8 3.9 12.6l-2 15.9C436.9 361.9 375.6 416 303 416H262.6l68.7 68.7c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9H128c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4L185.4 416H145C72.4 416 11.1 361.9 2.1 289.9L.1 274c-.6-4.6 .8-9.1 3.9-12.6z"]],
    "mistletoe": [576, 512, [], "f7b4", ["M312 24c0-13.3-10.7-24-24-24s-24 10.7-24 24v94.1l-98 98L91.3 230.4C38.3 240.6 0 287 0 341c0 41.4 33.6 75 75 75c50.5 0 94.3-33.5 108.1-81.2c-4.5-6.5-7.1-14.3-7.1-22.8c0-14.2 7.4-26.6 18.5-33.7l5.4-28.2L264 185.9v72.4c14.7 13.2 24 32.3 24 53.7c0 39.8-32.2 72-72 72c-7.2 0-14.2-1.1-20.8-3c-2.1 8.4-3.2 17.1-3.2 25.9V416c0 53 43 96 96 96s96-43 96-96v-9.1c0-25.1-9-49.4-25.3-68.4L312 284V185.9L376.1 250l14.4 74.7C400.6 377.7 447 416 501 416c41.4 0 75-33.6 75-75c0-54-38.3-100.3-91.3-110.5L410 216.1l-98-98V24z", "M376 112a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM216 352a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]],
    "custard": [576, 512, [127854], "e403", ["M476.7 193.3C453.9 184.9 424 176 400 176c-22.7 0-39.4 8-56 16s-33.3 16-56 16s-39.4-8-56-16s-33.3-16-56-16c-24 0-53.9 8.9-76.7 17.3l-35 157.5L512 352 476.7 193.3z", "M396.7 64H179.3c-30 0-56 20.8-62.5 50.1L99.3 193.3C122.1 184.9 152 176 176 176c22.7 0 39.4 8 56 16s33.3 16 56 16s39.4-8 56-16s33.3-16 56-16c24 0 53.9 8.9 76.7 17.3l-17.6-79.2C452.6 84.8 426.7 64 396.7 64zM32 384c-17.7 0-32 14.3-32 32s14.3 32 32 32H544c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "lacrosse-stick": [512, 512, [], "e3b5", ["M145.4 321.4l-136 136c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l136-136c-18.7-11-34.3-26.6-45.3-45.3z", "M264.8 117.7l-3.3 11.5c-5.6 19.6-15.1 37.9-27.8 53.9L205.8 218c-8.9 11.1-13.8 25-13.8 39.2c0 34.7 28.1 62.8 62.8 62.8c14.3 0 28.1-4.9 39.2-13.8l34.9-27.9c15.9-12.8 34.3-22.2 53.9-27.8l11.5-3.3c31.8-9.1 53.7-38.1 53.7-71.2h0c0-.1 0-.2 0-.3c0-19.9-13.6-48.1-38.6-73.1s-53.2-38.6-73.1-38.6c-.1 0-.2 0-.3 0v0c-33.1 0-62.1 21.9-71.2 53.7zM512 176h0c0 61.6-40.9 115.8-100.1 132.7L400.3 312c-11.5 3.3-22.2 8.8-31.5 16.2l-34.9 27.9c-22.5 18-50.4 27.8-79.2 27.8c-70 0-126.8-56.8-126.8-126.8c0-28.8 9.8-56.7 27.8-79.2l27.9-34.9c7.4-9.3 13-20 16.2-31.5l3.3-11.5C220.2 40.9 274.4 0 336 0V0c.1 0 .2 0 .3 0c43.8 0 87.4 26.4 118.4 57.3s57.3 74.5 57.3 118.4c0 .1 0 .2 0 .3z"]],
    "hockey-mask": [448, 512, [], "f6ee", ["M0 240C0 111 64 0 224 0S448 111 448 240c0 192-48 272-224 272S0 432 0 240zM160 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM176 344a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0 64a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72-104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM312 80a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM272 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM128 272c35.3 0 64-28.7 64-64c0-17.7-14.3-32-32-32H96c-17.7 0-32 14.3-32 32c0 35.3 28.7 64 64 64zm256-64c0-17.7-14.3-32-32-32H288c-17.7 0-32 14.3-32 32c0 35.3 28.7 64 64 64s64-28.7 64-64z", "M136 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88 24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM152 320a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm0 64a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm72-104a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM288 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM248 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "sunrise": [576, 512, [127749], "f766", ["M403.1 237.1c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L288 289.1l-90.3-62.3c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L153 345 45.1 364.9c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L86.1 464H161c7.9-63.1 61.7-112 127-112s119.1 48.9 127 112h74.9l51.3-74.3c3.1-4.5 3.7-10.2 1.6-15.2s-6.6-8.6-11.9-9.6L423 345 403.1 237.1zM382.7 464c-7.6-45.4-47.1-80-94.7-80s-87.1 34.6-94.7 80H382.7z", "M354.5 135.7L320 104.3V208c0 17.7-14.3 32-32 32s-32-14.3-32-32V104.3l-34.5 31.3c-13.1 11.9-33.3 10.9-45.2-2.2s-10.9-33.3 2.2-45.2l88-80c12.2-11.1 30.8-11.1 43.1 0l88 80c13.1 11.9 14 32.1 2.2 45.2s-32.1 14-45.2 2.2zM24 464H552c13.3 0 24 10.7 24 24s-10.7 24-24 24H24c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "panel-ews": [512, 512, [], "e42e", ["M64 0C28.7 0 0 28.7 0 64V288H16c44.2 0 80 35.8 80 80v16c0 17.7 14.3 32 32 32s32-14.3 32-32V352c-17.7 0-32-14.3-32-32V288c0-17.7 14.3-32 32-32h32c17.7 0 32 14.3 32 32v32c0 17.7-14.3 32-32 32v32c0 35.3-28.7 64-64 64s-64-28.7-64-64V368c0-26.5-21.5-48-48-48H0V448c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zm48 64h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16zm192 0h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H304c-8.8 0-16-7.2-16-16s7.2-16 16-16zM112 128h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16zm192 0h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H304c-8.8 0-16-7.2-16-16s7.2-16 16-16zm16 128h64c17.7 0 32 14.3 32 32V416c0 17.7-14.3 32-32 32H320c-17.7 0-32-14.3-32-32V288c0-17.7 14.3-32 32-32z", "M128 288c0-17.7 14.3-32 32-32h32c17.7 0 32 14.3 32 32v32c0 17.7-14.3 32-32 32v32c0 35.3-28.7 64-64 64s-64-28.7-64-64V368c0-26.5-21.5-48-48-48H0V288H16c44.2 0 80 35.8 80 80v16c0 17.7 14.3 32 32 32s32-14.3 32-32V352c-17.7 0-32-14.3-32-32V288zm192-32h64c17.7 0 32 14.3 32 32V416c0 17.7-14.3 32-32 32H320c-17.7 0-32-14.3-32-32V288c0-17.7 14.3-32 32-32z"]],
    "torii-gate": [512, 512, [9961], "f6a1", ["M64 128h64v96H64V128zm160 0h64v96H224V128zm160 0h64v96H384V128zM64 480V256h64V480c0 17.7-14.3 32-32 32s-32-14.3-32-32zm320 0V256h64V480c0 17.7-14.3 32-32 32s-32-14.3-32-32z", "M0 13.4V80c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V13.4C512 6 506 0 498.6 0c-1.7 0-3.4 .3-5 1l-49 19.6C425.7 28.1 405.5 32 385.2 32H126.8c-20.4 0-40.5-3.9-59.4-11.4L18.4 1c-1.6-.6-3.3-1-5-1C6 0 0 6 0 13.4zM32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "cloud-exclamation": [640, 512, [], "e491", ["M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zM320 160c-13.3 0-24 10.7-24 24V296c0 13.3 10.7 24 24 24s24-10.7 24-24V184c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M344 184c0-13.3-10.7-24-24-24s-24 10.7-24 24V296c0 13.3 10.7 24 24 24s24-10.7 24-24V184zM320 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "message-lines": [512, 512, ["comment-alt-lines"], "f4a6", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zm152 80c-13.3 0-24 10.7-24 24s10.7 24 24 24H360c13.3 0 24-10.7 24-24s-10.7-24-24-24H152zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24H264c13.3 0 24-10.7 24-24s-10.7-24-24-24H152z", "M128 168c0-13.3 10.7-24 24-24H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24H264c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24z"]],
    "frog": [576, 512, [], "f52e", ["M447.7 104.5c.2 2.5 .3 5 .3 7.5c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-5 .5-9.8 1.3-14.5C127 112.9 0 249.6 0 416c0 35.3 28.7 64 64 64H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H261.8l37.1-37.1c3.4-3.4 6.4-7.1 9-10.9c18.7-28 15.7-66.2-9-90.9c-24.6-24.6-62.6-27.7-90.5-9.2c-4 2.6-7.8 5.7-11.3 9.2l-.1 .1-.1 .1L123 347.6c-6.4 6.1-16.5 5.8-22.6-.6s-5.8-16.5 .6-22.6l73.6-70.1c40.6-40.5 106.4-40.4 146.9 .1c28.6 28.6 37.1 69.7 25.4 105.7L457.4 470.6c6 6 14.1 9.4 22.6 9.4h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H493.3l-92.5-92.5 144.5-82.1c18.9-10.8 30.7-30.9 30.7-52.7c0-26.6-17.3-50.1-42.8-57.9l-85.6-26.3z", "M368 192a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-104a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "bucket": [448, 512, [], "e4cf", ["M200 48C142.6 48 96 94.6 96 152v40H48V152C48 68.1 116.1 0 200 0h48c83.9 0 152 68.1 152 152v40H352V152c0-57.4-46.6-104-104-104H200z", "M32 192c-17.7 0-32 14.3-32 32s14.3 32 32 32h5.1L59.5 469c2.6 24.4 23.2 43 47.7 43H340.8c24.6 0 45.2-18.5 47.7-43l22.4-213H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "floppy-disk-pen": [576, 512, [], "e182", ["M0 96C0 60.7 28.7 32 64 32H306.7c17 0 33.3 6.7 45.3 18.7L429.3 128c12 12 18.7 28.3 18.7 45.3v62.4L289.3 394.3c-8.2 8.2-14 18.5-16.8 29.7l-14 55.9H64c-35.3 0-64-28.7-64-64V96zm96 0c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H288c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H96zM288 352a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z", "M493.2 235.8l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-52 52L311.9 417.1c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L512.1 358.8l-71-71z"]],
    "image": [512, 512, [], "f03e", ["M0 96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM323.8 202.5c-4.5-6.6-11.9-10.5-19.8-10.5s-15.4 3.9-19.8 10.5l-87 127.6L170.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6h96 32H424c8.9 0 17.1-4.9 21.2-12.8s3.6-17.4-1.4-24.7l-120-176zM112 192a48 48 0 1 0 0-96 48 48 0 1 0 0 96z", "M323.8 202.5c-4.5-6.6-11.9-10.5-19.8-10.5s-15.4 3.9-19.8 10.5l-87 127.6L170.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6h96 32H424c8.9 0 17.1-4.9 21.2-12.8s3.6-17.4-1.4-24.7l-120-176z"]],
    "window-frame": [512, 512, [129695], "e04f", ["M232 288V448H96V288H232zM96 224V64H232V224H96zM280 64H416V224H280V64zM416 288V448H280V288H416z", "M32 256V64C32 28.7 60.7 0 96 0H416c35.3 0 64 28.7 64 64V256 448c17.7 0 32 14.3 32 32s-14.3 32-32 32H416 96 32c-17.7 0-32-14.3-32-32s14.3-32 32-32V256zm384 32H280V448H416V288zm-184 0H96V448H232V288zm48-64H416V64H280V224zM232 64H96V224H232V64z"]],
    "microphone": [384, 512, [], "f130", ["M40 192c13.3 0 24 10.7 24 24v40c0 70.7 57.3 128 128 128s128-57.3 128-128V216c0-13.3 10.7-24 24-24s24 10.7 24 24v40c0 89.1-66.2 162.7-152 174.4V464h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H192 120c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V430.4C82.2 418.7 16 345.1 16 256V216c0-13.3 10.7-24 24-24z", "M96 96c0-53 43-96 96-96s96 43 96 96V256c0 53-43 96-96 96s-96-43-96-96V96z"]],
    "cow": [640, 512, [128004], "f6c8", ["M64 224h8v38.4C72 294.2 46.2 320 14.4 320C6.4 320 0 313.6 0 305.6V288c0-35.3 28.7-64 64-64zM192 327.8c.1-30.8 25.2-55.8 56-55.8h48c30.8 0 55.9 24.9 56 55.8c-9.9 6.6-20.6 12-32 16.1V368c0 8.8-7.2 16-16 16s-16-7.2-16-16V351.1c-5.3 .6-10.6 .9-16 .9s-10.7-.3-16-.9V368c0 8.8-7.2 16-16 16s-16-7.2-16-16V343.8c-11.4-4-22.1-9.4-32-16.1z", "M72 184c0-24.3 12.1-45.8 30.5-58.9C98.3 135.9 96 147.7 96 160v64 32V416c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V328v-.2s0 0 0 0c.1-30.8 25.2-55.8 56-55.8h48c30.8 0 55.9 24.9 56 55.8c0 0 0 0 0 0v.2 88c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V256l32 32v49.5c0 9.5 2.8 18.7 8.1 26.6L530 427c8.8 13.1 23.5 21 39.3 21c22.5 0 41.9-15.9 46.3-38l20.3-101.6c2.6-13-.3-26.5-8-37.3l-3.9-5.5V184c0-13.3-10.7-24-24-24s-24 10.7-24 24v14.4l-52.9-74.1C496 86.5 452.4 64 405.9 64H272 256 192 144C77.7 64 24 117.7 24 184v54c11-8.8 24.9-14 40-14h8V184zM576 320a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM190.1 190.1l-23.4-23.4c-4.2-4.2-6.6-10-6.6-16c0-12.5 10.1-22.6 22.6-22.6H361.4c12.5 0 22.6 10.1 22.6 22.6c0 6-2.4 11.8-6.6 16l-23.4 23.4C332.2 211.8 302.7 224 272 224s-60.2-12.2-81.9-33.9z"]],
    "file-zip": [512, 512, [], "e5ee", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V304H240c-35.3 0-64 28.7-64 64V512H64c-35.3 0-64-28.7-64-64V64z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM240 352c-8.8 0-16 7.2-16 16s7.2 16 16 16h38.1L225.7 488.8c-2.5 5-2.2 10.9 .7 15.6s8.1 7.6 13.6 7.6h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H265.9l52.4-104.8c2.5-5 2.2-10.9-.7-15.6s-8.1-7.6-13.6-7.6H240zm144 16c0-8.8-7.2-16-16-16s-16 7.2-16 16V496c0 8.8 7.2 16 16 16s16-7.2 16-16V368zm32 0v80 48c0 8.8 7.2 16 16 16s16-7.2 16-16V464h8c30.9 0 56-25.1 56-56s-25.1-56-56-56H432c-8.8 0-16 7.2-16 16zm32 64V384h8c13.3 0 24 10.7 24 24s-10.7 24-24 24h-8z"]],
    "square-ring": [448, 512, [], "e44f", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM224 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320z", "M224 160a96 96 0 1 0 0 192 96 96 0 1 0 0-192zm160 96A160 160 0 1 1 64 256a160 160 0 1 1 320 0z"]],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", ["M0 64C0 81.7 14.3 96 32 96H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H32C14.3 32 0 46.3 0 64z", "M164.7 468.7L41.9 345.9c-6.4-6.4-9.9-15-9.9-24C32 303.2 47.2 288 65.9 288H128V160c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32V288h62.1c18.7 0 33.9 15.2 33.9 33.9c0 9-3.6 17.6-9.9 24L219.3 468.7c-7.2 7.2-17.1 11.3-27.3 11.3s-20.1-4.1-27.3-11.3z"]],
    "caret-up": [320, 512, [], "f0d8", ["M182.6 137.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8H288c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128z", ""]],
    "shield-xmark": [512, 512, ["shield-times"], "e24c", ["M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c16.7 8 36.1 8 52.8 0C454.7 420.7 495.5 239.2 496 140c.1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM175 175c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z", "M209 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]],
    "screwdriver": [512, 512, [129691], "f54a", ["M433.4 5C442.9-2.4 456.4-1.5 465 7l40 40c8.5 8.5 9.4 22 2.1 31.6l-80 104c-4.5 5.9-11.6 9.4-19 9.4H353.9l-109 109c-3.6-7.1-8.4-13.7-14.3-19.7s-12.6-10.7-19.7-14.3l109-109V104c0-7.5 3.5-14.5 9.4-19l104-80z", "M230.6 281.4c-30.2-30.2-79.1-30.2-109.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l112-112c30.2-30.2 30.2-79.1 0-109.3z"]],
    "circle-sort-down": [512, 512, ["sort-circle-down"], "e031", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM267.3 100.7c-6.2-6.2-16.4-6.2-22.6 0l-96 96c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9H352c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-96-96zM244.7 411.3c6.2 6.2 16.4 6.2 22.6 0l96-96c4.6-4.6 5.9-11.5 3.5-17.4s-8.3-9.9-14.8-9.9H160c-6.5 0-12.3 3.9-14.8 9.9s-1.1 12.9 3.5 17.4l96 96z", "M267.3 411.3c-6.2 6.2-16.4 6.2-22.6 0l-96-96c-4.6-4.6-5.9-11.5-3.5-17.4s8.3-9.9 14.8-9.9H352c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-96 96z"]],
    "folder-closed": [512, 512, [], "e185", ["M0 192H512V160c0-35.3-28.7-64-64-64H288c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32H64C28.7 32 0 60.7 0 96v96z", "M0 192L0 416c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V192H0z"]],
    "house-tsunami": [576, 512, [], "e515", ["M80.8 136.5C104.9 93.8 152.6 64 209 64c16.9 0 33.1 2.7 48.2 7.7c16.8 5.5 34.9-3.6 40.4-20.4s-3.6-34.9-20.4-40.4C255.8 3.8 232.8 0 209 0C95.2 0 0 88 0 200c0 91.6 53.5 172.1 142.2 194.1c13.4 3.8 27.5 5.9 42.2 5.9c.7 0 1.4 0 2.1-.1c1.8 0 3.7 .1 5.5 .1c0 0 .1 0 .1 0c31.9 0 60.5-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.5-27.3-10.1-39.2-1.7l0 0C439.4 325.2 410.9 336 384 336c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 325.4 219.5 336 192 336l0 0c-12.4 0-24-1.5-34.9-4.3C121.6 320.2 96 287 96 248c0-48.5 39.5-88 88.4-88c13.5 0 26.1 3 37.5 8.3c16 7.5 35.1 .6 42.5-15.5s.6-35.1-15.5-42.5C229.3 101.1 207.4 96 184.4 96c-40 0-76.4 15.4-103.6 40.5zM384 448c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1l0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7l0 0C439.4 437.2 410.9 448 384 448z", "M332.8 118.4c-8.1 6-12.8 15.5-12.8 25.6V265c1.6 1 3.3 2 4.8 3.1c18.4 12.7 39.6 20.3 59.2 20.3c19 0 41.2-7.9 59.2-20.3c23.8-16.7 55.8-15.3 78.1 3.4c10.6 8.8 24.2 15.6 37.3 18.6c5.8 1.4 11.2 3.4 16.2 6.2c.7-2.7 1.1-5.5 1.1-8.4l-.4-144c0-10-4.7-19.4-12.7-25.5l-95.5-72c-11.4-8.6-27.1-8.6-38.5 0l-96 72z"]],
    "square-nfi": [448, 512, [], "e576", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm75.7 64.6C68.8 162.5 64 168.8 64 176V336c0 8.8 7.2 16 16 16s16-7.2 16-16V233.8l66.3 110.5c3.7 6.2 11.1 9.1 18 7.2s11.7-8.2 11.7-15.4V176c0-8.8-7.2-16-16-16s-16 7.2-16 16V278.2L93.7 167.8c-3.7-6.2-11.1-9.1-18-7.2zM224 176v64 96c0 8.8 7.2 16 16 16s16-7.2 16-16V256h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H256V192h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H240c-8.8 0-16 7.2-16 16zm160 0c0-8.8-7.2-16-16-16s-16 7.2-16 16V336c0 8.8 7.2 16 16 16s16-7.2 16-16V176z", "M93.7 167.8c-3.7-6.2-11.1-9.1-18-7.2S64 168.8 64 176V336c0 8.8 7.2 16 16 16s16-7.2 16-16V233.8l66.3 110.5c3.7 6.2 11.1 9.1 18 7.2s11.7-8.2 11.7-15.4V176c0-8.8-7.2-16-16-16s-16 7.2-16 16V278.2L93.7 167.8zM240 160c-8.8 0-16 7.2-16 16v64 96c0 8.8 7.2 16 16 16s16-7.2 16-16V256h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H256V192h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H240zm144 16c0-8.8-7.2-16-16-16s-16 7.2-16 16V336c0 8.8 7.2 16 16 16s16-7.2 16-16V176z"]],
    "forklift": [640, 512, [], "f47a", ["M544 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V416c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32s-14.3-32-32-32H544V32zM160 432A80 80 0 1 0 0 432a80 80 0 1 0 160 0zm256 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z", "M160 160l96 96h94L281.4 64H160v96zm-64 0V48c0-26.5 21.5-48 48-48H292.7c20.3 0 38.4 12.8 45.2 31.9l75.3 210.8c1.8 5.2 2.8 10.6 2.8 16.1v94.8c-20.3-20.7-48.7-33.6-80-33.6c-56.4 0-103.1 41.7-110.9 96H190.9c-7.8-54.3-54.4-96-110.9-96c-31.3 0-59.7 12.9-80 33.6V208c0-26.5 21.5-48 48-48H96z"]],
    "arrow-up-from-ground-water": [576, 512, [], "e4b5", ["M48 192H192V416.5c-19 0-41.2-7.9-59.1-20.3c-23.8-16.7-55.8-15.3-78.1 3.4c-10.6 8.8-24.2 15.6-37.3 18.6C11.2 419.6 5.3 421.9 0 425V240c0-26.5 21.5-48 48-48zM576 425c-5.3-3.1-11.2-5.4-17.5-6.9c-13.1-3.1-26.7-9.8-37.3-18.6c-22.2-18.7-54.3-20.1-78.1-3.4c-18 12.4-40.1 20.3-59.2 20.3c0 0 0 0 0 0V192H528c26.5 0 48 21.5 48 48V425z", "M320 320c0 17.7-14.3 32-32 32s-32-14.3-32-32V109.3l-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l80-80c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L320 109.3V320zM306.5 421.9C329 437.4 356.5 448 384 448c26.9 0 55.4-10.8 77.4-26.1l0 0c11.9-8.5 28.1-7.8 39.2 1.7c14.4 11.9 32.5 21 50.6 25.2c17.2 4 27.9 21.2 23.9 38.4s-21.2 27.9-38.4 23.9c-24.5-5.7-44.9-16.5-58.2-25C449.5 501.7 417 512 384 512c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9c-33 0-65.5-10.3-94.5-25.8c-13.4 8.4-33.7 19.3-58.2 25c-17.2 4-34.4-6.7-38.4-23.9s6.7-34.4 23.9-38.4c18.1-4.2 36.2-13.3 50.6-25.2c11.1-9.4 27.3-10.1 39.2-1.7l0 0C136.7 437.2 165.1 448 192 448c27.5 0 55-10.6 77.5-26.1c11.1-7.9 25.9-7.9 37 0z"]],
    "bracket-square-right": [192, 512, [], "5d", ["M192 96c0-35.3-28.7-64-64-64H64C46.3 32 32 46.3 32 64s14.3 32 32 32h64V416H64c-17.7 0-32 14.3-32 32s14.3 32 32 32h64c35.3 0 64-28.7 64-64V96z", ""]],
    "martini-glass": [512, 512, [127864, "glass-martini-alt"], "f57b", ["M2.4 19.8C7.4 7.8 19.1 0 32 0H480c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9L288 269.3V448h64c17.7 0 32 14.3 32 32s-14.3 32-32 32H256 160c-17.7 0-32-14.3-32-32s14.3-32 32-32h64V269.3L9.4 54.6C.2 45.5-2.5 31.7 2.4 19.8zM256 210.7L402.7 64H109.3L256 210.7z", "M338.7 128L256 210.7 173.3 128H338.7z"]],
    "rotate-left": [512, 512, ["rotate-back", "rotate-backward", "undo-alt"], "f2ea", ["M98.6 96.6l45.3 45.3c62.6-61.5 163.1-61.2 225.3 1c62.5 62.5 62.5 163.8 0 226.3s-163.8 62.5-226.3 0c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3c87.5 87.5 229.3 87.5 316.8 0s87.5-229.3 0-316.8c-87.2-87.2-228.3-87.5-315.8-1z", "M168 224H40c-13.3 0-24-10.7-24-24V72c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2L185 183c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8z"]],
    "table-columns": [512, 512, ["columns"], "f0db", ["M224 160h64V416H224V160z", "M64 160l0 256H448V160L64 160zm0 320c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64L64 480z"]],
    "square-a": [448, 512, [], "e25f", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm160 96c9.1 0 17.4 5.1 21.5 13.3l104 208c5.9 11.9 1.1 26.3-10.7 32.2s-26.3 1.1-32.2-10.7L289.2 336H158.8l-17.4 34.7c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l104-208c4.1-8.1 12.4-13.3 21.5-13.3zm0 77.7L182.8 288h82.3L224 205.7z", "M245.5 141.3c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-104 208c-5.9 11.9-1.1 26.3 10.7 32.2s26.3 1.1 32.2-10.7L158.8 336H289.2l17.4 34.7c5.9 11.9 20.3 16.7 32.2 10.7s16.7-20.3 10.7-32.2l-104-208zM265.2 288H182.8L224 205.7 265.2 288z"]],
    "tick": [128, 512, [], "e32f", ["M0 98.3V96C0 60.7 28.7 32 64 32s64 28.7 64 64v2.3c0 3.8-.3 7.6-1 11.4L101.5 256.5C98.3 274.7 82.5 288 64 288s-34.3-13.3-37.5-31.5L1 109.6c-.7-3.8-1-7.5-1-11.4z", ""]],
    "lemon": [448, 512, [127819], "f094", ["M448 96c0-35.3-28.7-64-64-64c-6.6 0-13 1-19 2.9c-22.5 7-48.1 14.9-71 9c-75.2-19.1-156.4 11-213.7 68.3S-7.2 250.8 11.9 326c5.8 22.9-2 48.4-9 71C1 403 0 409.4 0 416c0 35.3 28.7 64 64 64c6.6 0 13-1 19.1-2.9c22.5-7 48.1-14.9 71-9c75.2 19.1 156.4-11 213.7-68.3s87.5-138.5 68.3-213.7c-5.8-22.9 2-48.4 9-71c1.9-6 2.9-12.4 2.9-19.1zM212.5 127.4c-54.6 16-101.1 62.5-117.1 117.1C92.9 253 84 257.8 75.5 255.4S62.2 244 64.6 235.5c19.1-65.1 73.7-119.8 138.9-138.9c8.5-2.5 17.4 2.4 19.9 10.9s-2.4 17.4-10.9 19.9z", "M223.4 107.5c2.5 8.5-2.4 17.4-10.9 19.9c-54.6 16-101.1 62.5-117.1 117.1C92.9 253 84 257.8 75.5 255.4S62.2 244 64.6 235.5c19.1-65.1 73.7-119.8 138.9-138.9c8.5-2.5 17.4 2.4 19.9 10.9z"]],
    "head-side-mask": [576, 512, [], "e063", ["M39.7 165.7c-5 18.7-7.7 38.3-7.7 58.5c0 49.9 16.6 98.2 46.9 137.3c10.2 13.2 17.1 29 17.1 45.8V480c0 17.7 14.3 32 32 32H272V338.2L39.7 165.7zm18.2-46.3L284.9 288H544v.2c0-.1 0-.1 0-.2c0-10-3.4-19.6-9.6-27.4l-44.8-65.7c-6.5-9.6-10-20.7-11.9-32.2C462.8 70.6 376.1 0 280 0H256C170.1 0 95.5 48.4 57.9 119.4zM352 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M20.7 121.7c7.9-10.6 22.9-12.9 33.6-5L284.9 288H544v21.6c0 6.9-1.1 13.7-3.3 20.2L528 368H368c-8.8 0-16 7.2-16 16s7.2 16 16 16H517.3l-10.7 32H368c-8.8 0-16 7.2-16 16s7.2 16 16 16H496l-1.4 4.2c-8.7 26.1-33.2 43.8-60.7 43.8H272V338.2L25.7 155.3c-10.6-7.9-12.9-22.9-5-33.6z"]],
    "handshake": [640, 512, [], "f2b5", ["M512 352V128h-1.5l-71-47.3C423.2 69.8 404.1 64 384.5 64c-20.7 0-40.9 6.5-57.7 18.5l-98.6 70.4c-21.6 15.4-26.6 45.4-11.2 67s45.4 26.6 67 11.2l57.2-40.8L496.4 332.6c6 5.5 10.3 12.2 12.8 19.4H512zm32 0c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V144c0-8.8-7.2-16-16-16H544V352zm48-32a16 16 0 1 1 0 32 16 16 0 1 1 0-32z", "M156.2 352H128V128l72-48c15.6-10.4 34-16 52.8-16c22.7 0 44.7 8.1 61.9 22.9l2.7 2.3-89.3 63.8c-21.6 15.4-26.6 45.4-11.2 67s45.4 26.6 67 11.2l57.2-40.8 13.1 12L496.4 332.6c5.5 5 9.6 11.1 12.1 17.5c6.6 16.6 3.7 36.2-9.2 50.3c-17.9 19.5-48.3 20.9-67.8 2.9l-7.8-7.1c-.9 10.1-5 20.1-12.4 28.2c-17.9 19.5-48.3 20.9-67.8 2.9l-17-15.6c-1.9 7.4-5.6 14.5-11.1 20.6c-17.9 19.6-48.2 21-67.8 3.1L156.2 352zM0 144c0-8.8 7.2-16 16-16H96V352c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V144zM64 336a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "gem": [512, 512, [128142], "f3a5", ["M116.7 33.8c4.5-6.1 11.7-9.8 19.3-9.8H376c7.6 0 14.8 3.6 19.3 9.8l112 152c6.8 9.2 6.1 21.9-1.5 30.4l-232 256c-4.5 5-11 7.9-17.8 7.9s-13.2-2.9-17.8-7.9l-232-256c-7.7-8.5-8.3-21.2-1.5-30.4l112-152zm38.5 39.8c-3.3 2.5-4.2 7-2.1 10.5l57.4 95.6L63.3 192c-4.1 .3-7.3 3.8-7.3 8s3.2 7.6 7.3 8l192 16c.4 0 .9 0 1.3 0l192-16c4.1-.3 7.3-3.8 7.3-8s-3.2-7.6-7.3-8L301.5 179.8l57.4-95.6c2.1-3.5 1.2-8.1-2.1-10.5s-7.9-2-10.7 1L256 172.2 165.9 74.6c-2.8-3-7.4-3.4-10.7-1z", "M165.9 74.6c-2.8-3-7.4-3.4-10.7-1s-4.2 7-2.1 10.5l57.4 95.6L63.3 192c-4.1 .3-7.3 3.8-7.3 8s3.2 7.6 7.3 8l192 16c.4 0 .9 0 1.3 0l192-16c4.1-.3 7.3-3.8 7.3-8s-3.2-7.6-7.3-8L301.5 179.8l57.4-95.6c2.1-3.5 1.2-8.1-2.1-10.5s-7.9-2-10.7 1L256 172.2 165.9 74.6z"]],
    "dolly": [576, 512, ["dolly-box"], "f472", ["M244.8 134.5c-5.5-16.8 3.7-34.9 20.5-40.3L311 79.4l19.8 60.9 60.9-19.8L371.8 59.6l45.7-14.8c16.8-5.5 34.9 3.7 40.3 20.5l49.4 152.2c5.5 16.8-3.7 34.9-20.5 40.3L334.5 307.2c-16.8 5.5-34.9-3.7-40.3-20.5L244.8 134.5zM256 320a96 96 0 1 1 0 192 96 96 0 1 1 0-192z", "M0 32C0 14.3 14.3 0 32 0h72.9c27.5 0 52 17.6 60.7 43.8L257.7 320c-.6 0-1.2 0-1.7 0c-22.2 0-42.7 7.6-59 20.2L104.9 64H32C14.3 64 0 49.7 0 32zM352 416c0-22.2-7.6-42.7-20.2-59l202.1-67.4c16.8-5.6 34.9 3.5 40.5 20.2s-3.5 34.9-20.2 40.5L352 417.7c0-.6 0-1.2 0-1.7zM371.8 59.6l19.8 60.9-60.9 19.8L311 79.4l60.9-19.8z"]],
    "smoking": [640, 512, [128684], "f48d", ["M448 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V43c0 55.2 21.9 108.1 60.9 147.1l21 21c9 9 14.1 21.2 14.1 33.9v11c0 17.7 14.3 32 32 32s32-14.3 32-32V245c0-29.7-11.8-58.2-32.8-79.2l-21-21C463.2 117.8 448 81.2 448 43V32zM576 256c0 17.7 14.3 32 32 32s32-14.3 32-32V245c0-55.2-21.9-108.1-60.9-147.1l-21-21c-9-9-14.1-21.2-14.1-33.9V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V43c0 29.7 11.8 58.2 32.8 79.2l21 21c27 27 42.2 63.6 42.2 101.8v11z", "M64 352c-35.3 0-64 28.7-64 64v32c0 35.3 28.7 64 64 64H416c17.7 0 32-14.3 32-32V384c0-17.7-14.3-32-32-32H64zm160 64H384v32H224V416zm320-32c0-17.7-14.3-32-32-32s-32 14.3-32 32v96c0 17.7 14.3 32 32 32s32-14.3 32-32V384zm96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32v96c0 17.7 14.3 32 32 32s32-14.3 32-32V384z"]],
    "minimize": [512, 512, ["compress-arrows-alt"], "f78c", ["M456 224H312c-13.3 0-24-10.7-24-24V56c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l40 40L442.3 5.7C446 2 450.9 0 456 0s10 2 13.7 5.7l36.7 36.7C510 46 512 50.9 512 56s-2 10-5.7 13.7L433 143l40 40c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8zM56 288H200c13.3 0 24 10.7 24 24V456c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-40-40L69.7 506.3C66 510 61.1 512 56 512s-10-2-13.7-5.7L5.7 469.7C2 466 0 461.1 0 456s2-10 5.7-13.7L79 369 39 329c-6.9-6.9-8.9-17.2-5.2-26.2s12.5-14.8 22.2-14.8z", "M56 224H200c13.3 0 24-10.7 24-24V56c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2L143 79 69.7 5.7C66 2 61.1 0 56 0S46 2 42.3 5.7L5.7 42.3C2 46 0 50.9 0 56s2 10 5.7 13.7L79 143 39 183c-6.9 6.9-8.9 17.2-5.2 26.2s12.5 14.8 22.2 14.8zm400 64H312c-13.3 0-24 10.7-24 24V456c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l40-40 73.4 73.4c3.6 3.6 8.5 5.7 13.7 5.7s10-2 13.7-5.7l36.7-36.7c3.6-3.6 5.7-8.5 5.7-13.7s-2-10-5.7-13.7L433 369l40-40c6.9-6.9 8.9-17.2 5.2-26.2s-12.5-14.8-22.2-14.8z"]],
    "refrigerator": [384, 512, [], "e026", ["M288 160H0v32H288V160zm96 0H320v32h64V160z", "M96 0C43 0 0 43 0 96v64H288V112c0-8.8 7.2-16 16-16s16 7.2 16 16v48h64V96c0-53-43-96-96-96H96zM384 192H320V368c0 8.8-7.2 16-16 16s-16-7.2-16-16V192H0V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V192z"]],
    "monument": [384, 512, [], "f5a6", ["M0 480c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z", "M203.3 4.7c-6.2-6.2-16.4-6.2-22.6 0l-80 80c-2.5 2.5-4.1 5.8-4.6 9.3L51.9 448H332.1L287.9 94c-.4-3.5-2-6.8-4.6-9.3l-80-80zM128 296c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24s-10.7 24-24 24H152c-13.3 0-24-10.7-24-24z"]],
    "octagon-xmark": [512, 512, ["times-octagon", "xmark-octagon"], "f2f0", ["M140.6 21.2C154.1 7.7 172.4 .1 191.5 .1h129c19.1 0 37.4 7.6 50.9 21.1L490.8 140.6c13.5 13.5 21.1 31.8 21.1 50.9v129c0 19.1-7.6 37.4-21.1 50.9L371.4 490.8c-13.5 13.5-31.8 21.1-50.9 21.1h-129c-19.1 0-37.4-7.6-50.9-21.1L21.2 371.4C7.7 357.9 .1 339.6 .1 320.5v-129c0-19.1 7.6-37.4 21.1-50.9L140.6 21.2zM175 175c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z", "M209 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]],
    "align-slash": [640, 512, [], "f846", ["M406.2 416l81.2 64H128c-17.7 0-32-14.3-32-32s14.3-32 32-32H406.2zM243.7 288l81.2 64H128c-17.7 0-32-14.3-32-32s14.3-32 32-32H243.7zm-143-112.7L162.5 224H128c-17.7 0-32-14.3-32-32c0-6.1 1.7-11.8 4.7-16.7zM399.7 288H512c17.7 0 32 14.3 32 32s-14.3 32-32 32H481.4l-81.7-64zM236.4 160H512c17.7 0 32 14.3 32 32s-14.3 32-32 32H318.1l-81.7-64zM512 96H154.8L98.4 51.8C103.2 40.2 114.6 32 128 32H512c17.7 0 32 14.3 32 32s-14.3 32-32 32z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "snowplow": [640, 512, [], "f7d2", ["M368 352c26.5 0 48 21.5 48 48s-21.5 48-48 48H112c-26.5 0-48-21.5-48-48s21.5-48 48-48H368zM112 288C50.1 288 0 338.1 0 400s50.1 112 112 112H368c61.9 0 112-50.1 112-112s-50.1-112-112-112H112z", "M298.9 64l68.6 160H256l-64-64V64H298.9zM445.1 242.7l-87.4-204C347.6 15.3 324.5 0 298.9 0H176c-26.5 0-48 21.5-48 48V160H96c-17.7 0-32 14.3-32 32V298.8c14.5-6.9 30.8-10.8 48-10.8H368c44.7 0 83.2 26.2 101.2 64H512v50.7c0 17 6.7 33.3 18.7 45.3l54.6 54.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L576 402.7V320 235.2L633 164c11-13.8 8.8-33.9-5-45s-33.9-8.8-45 5l-57 71.2c-9.1 11.3-14 25.4-14 40V288H448V256.7c.1-2.4-.2-4.8-.6-7.1s-1.2-4.7-2.2-6.8zM144 400a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm216 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-56-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM200 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "angles-right": [512, 512, [187, "angle-double-right"], "f101", ["M278.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L210.7 256 73.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z", "M470.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L402.7 256 265.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z"]],
    "truck-ramp-couch": [640, 512, ["truck-couch"], "f4dd", ["M294.5 209.2c8.7-2.3 17.4-2.1 25.5 .2V334.8l-38.7 10.4L126.7 386.6 64.9 403.2c-17.1 4.6-34.6-5.6-39.2-22.6L13.3 334.2c-6.9-25.6 8.3-51.9 33.9-58.8s51.9 8.3 58.8 33.9l4.1 15.5 154.5-41.4-4.1-15.5c-6.9-25.6 8.3-51.9 33.9-58.8zM8 252.8c-9.1-34.1 11.1-69.2 45.3-78.4l185.5-49.7c34.1-9.1 69.2 11.1 78.4 45.3l1.7 6.4c-10.6-1.6-21.6-1.1-32.6 1.9c-37.4 10-61.5 44.9-59.2 82.1L131.2 286c-16.6-33.4-54.9-51.5-92.3-41.5c-11 2.9-20.8 8-29.2 14.7L8 252.8zM544 320a96 96 0 1 1 0 192 96 96 0 1 1 0-192z", "M416.7 402.5C423.4 338.2 477.9 288 544 288c38.2 0 72.5 16.8 96 43.3V0H416c-35.3 0-64 28.7-64 64V353.8L31.6 441.1c-17.1 4.6-27.1 22.2-22.5 39.3s22.2 27.1 39.3 22.5L416.7 402.5z"]],
    "cannabis": [512, 512, [], "f55f", ["M256 0c5.3 0 10.3 2.7 13.3 7.1c15.8 23.5 36.7 63.7 49.2 109c7.2 26.4 11.8 55.2 10.4 84c11.5-8.8 23.7-16.7 35.8-23.6c41-23.3 84.4-36.9 112.2-42.5c5.2-1 10.7 .6 14.4 4.4s5.4 9.2 4.4 14.5c-5.6 27.7-19.3 70.9-42.7 111.7c-9.1 15.9-19.9 31.7-32.4 46.3c27.8 6.6 52.4 17.3 67.2 25.5c5.1 2.8 8.2 8.2 8.2 14s-3.2 11.2-8.2 14c-15.2 8.4-40.9 19.5-69.8 26.1c-20.2 4.6-42.9 7.2-65.2 4.6l8.3 33.1c1.5 6.1-.6 12.4-5.5 16.4s-11.6 4.6-17.2 1.9L280 417.2V376c0-13.3-10.7-24-24-24s-24 10.7-24 24v41.2l-58.5 29.1c-5.6 2.8-12.3 2.1-17.2-1.9s-7-10.3-5.5-16.4l8.3-33.1c-22.2 2.6-45 0-65.2-4.6c-28.9-6.6-54.6-17.6-69.8-26.1c-5.1-2.8-8.2-8.2-8.2-14s3.2-11.2 8.2-14c14.8-8.2 39.4-18.8 67.2-25.5C78.9 296.3 68.1 280.5 59 264.6c-23.4-40.8-37.1-84-42.7-111.7c-1.1-5.2 .6-10.7 4.4-14.5s9.2-5.4 14.4-4.4c27.9 5.5 71.2 19.2 112.2 42.5c12.1 6.9 24.3 14.7 35.8 23.6c-1.4-28.7 3.1-57.6 10.4-84c12.5-45.3 33.4-85.5 49.2-109c3-4.4 8-7.1 13.3-7.1z", "M280 376c0-13.3-10.7-24-24-24s-24 10.7-24 24V488c0 13.3 10.7 24 24 24s24-10.7 24-24V376z"]],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM188.3 147.1c-7.6 4.2-12.3 12.3-12.3 20.9V344c0 8.7 4.7 16.7 12.3 20.9s16.8 4.1 24.3-.5l144-88c7.1-4.4 11.5-12.1 11.5-20.5s-4.4-16.1-11.5-20.5l-144-88c-7.4-4.5-16.7-4.7-24.3-.5z", "M212.5 147.5c-7.4-4.5-16.7-4.7-24.3-.5s-12.3 12.3-12.3 20.9V344c0 8.7 4.7 16.7 12.3 20.9s16.8 4.1 24.3-.5l144-88c7.1-4.4 11.5-12.1 11.5-20.5s-4.4-16.1-11.5-20.5l-144-88z"]],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", ["M169.4 297.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L109.3 448H160c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32s32 14.3 32 32v50.7L169.4 297.4z", "M320 32c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32V160c0 17.7-14.3 32-32 32s-32-14.3-32-32V109.3L342.6 214.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L402.7 64H352c-17.7 0-32-14.3-32-32z"]],
    "tablets": [640, 512, [], "f490", ["M591.4 248.8L391.2 48.6c-6.7-6.7-6.2-17.8 1.8-22.9C418.1 9.4 447.9 0 480 0c88.4 0 160 71.6 160 160c0 32.1-9.4 61.9-25.7 87c-5.2 7.9-16.2 8.5-22.9 1.8zm-22.6 22.6c6.7 6.7 6.2 17.8-1.8 22.9c-25 16.3-54.9 25.7-87 25.7c-88.4 0-160-71.6-160-160c0-32.1 9.4-61.9 25.7-87c5.2-7.9 16.2-8.5 22.9-1.8L568.8 271.4z", "M316.5 385.5c2-9.3-5.5-17.5-15-17.5H18.5c-9.5 0-16.9 8.2-15 17.5C18.9 457.8 83.1 512 160 512s141.1-54.2 156.5-126.5zm0-66.9C301.1 246.2 236.9 192 160 192S18.9 246.2 3.5 318.5c-2 9.3 5.5 17.5 15 17.5H301.5c9.5 0 16.9-8.2 15-17.5z"]],
    "360-degrees": [640, 512, [], "e2dc", ["M576 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M0 96C0 78.3 14.3 64 32 64H160c12.1 0 23.2 6.8 28.6 17.7s4.3 23.8-3 33.5l-63.7 84.9C163 216.7 192 257 192 304v48c0 53-43 96-96 96H90.5c-25.5 0-49.9-10.1-67.9-28.1L9.4 406.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l13.3 13.3c6 6 14.1 9.4 22.6 9.4H96c17.7 0 32-14.3 32-32V304c0-26.5-21.5-48-48-48H64c-12.1 0-23.2-6.8-28.6-17.7s-4.3-23.8 3-33.5L96 128H32C14.3 128 0 113.7 0 96zm496 32c-8.8 0-16 7.2-16 16V368c0 8.8 7.2 16 16 16s16-7.2 16-16V144c0-8.8-7.2-16-16-16zm0 320c-44.2 0-80-35.8-80-80V144c0-44.2 35.8-80 80-80s80 35.8 80 80V368c0 44.2-35.8 80-80 80zM320 128c-17.7 0-32 14.3-32 32v33.6c5.2-1 10.5-1.6 16-1.6c44.2 0 80 35.8 80 80v96c0 44.2-35.8 80-80 80s-80-35.8-80-80V288.2c0-.1 0-.2 0-.2V160c0-53 43-96 96-96c17.7 0 32 14.3 32 32s-14.3 32-32 32zM288 272v96c0 8.8 7.2 16 16 16s16-7.2 16-16V272c0-8.8-7.2-16-16-16s-16 7.2-16 16z"]],
    "ethernet": [512, 512, [], "f796", ["M0 224V416c0 17.7 14.3 32 32 32H96V336c0-8.8 7.2-16 16-16s16 7.2 16 16V448h64V336c0-8.8 7.2-16 16-16s16 7.2 16 16V448h64V336c0-8.8 7.2-16 16-16s16 7.2 16 16V448h64V336c0-8.8 7.2-16 16-16s16 7.2 16 16V448h64c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H448V160c0-17.7-14.3-32-32-32H384V96c0-17.7-14.3-32-32-32H160c-17.7 0-32 14.3-32 32v32H96c-17.7 0-32 14.3-32 32v32H32c-17.7 0-32 14.3-32 32z", "M112 320c8.8 0 16 7.2 16 16V448H96V336c0-8.8 7.2-16 16-16zm96 0c8.8 0 16 7.2 16 16V448H192V336c0-8.8 7.2-16 16-16zm96 0c8.8 0 16 7.2 16 16V448H288V336c0-8.8 7.2-16 16-16zm96 0c8.8 0 16 7.2 16 16V448H384V336c0-8.8 7.2-16 16-16z"]],
    "euro-sign": [320, 512, [8364, "eur", "euro"], "f153", ["M48.1 272H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H60.3c-7.1-20.1-11.3-41.6-12.1-64zm82 64H256c17.7 0 32-14.3 32-32s-14.3-32-32-32H112.2c1.2 23.1 7.5 44.8 17.9 64zm-17.9-96H256c17.7 0 32-14.3 32-32s-14.3-32-32-32H130.1c-10.4 19.2-16.7 40.9-17.9 64zM60.3 176H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H48.1c.8-22.4 5-43.9 12.1-64z", "M48 248C48 128.7 144.7 32 264 32h24c17.7 0 32 14.3 32 32s-14.3 32-32 32H264c-83.9 0-152 68.1-152 152v16c0 83.9 68.1 152 152 152h24c17.7 0 32 14.3 32 32s-14.3 32-32 32H264C144.7 480 48 383.3 48 264V248z"]],
    "chair": [448, 512, [129681], "f6c0", ["M248 48H200V288H152V58.7c-23.9 13.8-40 39.7-40 69.3V288H64V128C64 57.3 121.3 0 192 0h64c70.7 0 128 57.3 128 128V288H336V128c0-29.6-16.1-55.5-40-69.3V288H248V48zM32 480V384H96v96c0 17.7-14.3 32-32 32s-32-14.3-32-32zm384-96v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V384h64z", "M19.4 305.7C24.8 294.8 35.9 288 48 288H400c12.1 0 23.2 6.8 28.6 17.7l16 32c5 9.9 4.4 21.7-1.4 31.1s-16.1 15.2-27.2 15.2H32c-11.1 0-21.4-5.7-27.2-15.2s-6.4-21.2-1.4-31.1l16-32z"]],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z", "M369 175c9.4 9.4 9.4 24.6 0 33.9L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0z"]],
    "square-dashed-circle-plus": [576, 512, [], "e5c2", ["M128 32V96H96c-17.7 0-32 14.3-32 32v32H0V128C0 75 43 32 96 32h32zM0 320V192H64V320H0zm0 32H64v32c0 17.7 14.3 32 32 32h32v64H96c-53 0-96-43-96-96V352zM448 192.7c-5.3-.5-10.6-.7-16-.7c-16.6 0-32.7 2.3-48 6.6V128c0-17.7-14.3-32-32-32H320V32h32c53 0 96 43 96 96v64.7zM262.6 416c5.5 19.3 14.1 37.2 25.4 53.2V480H160V416H262.6zM288 96H160V32H288V96z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16v48H368c-8.8 0-16 7.2-16 16s7.2 16 16 16h48v48c0 8.8 7.2 16 16 16s16-7.2 16-16V384h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H448V304c0-8.8-7.2-16-16-16z"]],
    "money-simple-from-bracket": [640, 512, [], "e313", ["M512 448l0-352L128 96l0 352c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64zM224 272c0-44.2 43-80 96-80s96 35.8 96 80s-43 80-96 80s-96-35.8-96-80z", "M96 64C78.3 64 64 78.3 64 96v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V96C0 43 43 0 96 0H544c53 0 96 43 96 96v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V96c0-17.7-14.3-32-32-32H96z"]],
    "bat": [576, 512, [], "f6b5", ["M235.6 52.8l10.8 14.4c6 8.1 15.5 12.8 25.6 12.8h32c10.1 0 19.6-4.7 25.6-12.8l10.8-14.4c2.3-3 5.8-4.8 9.6-4.8c5.8 0 10.8 4.1 11.8 9.8l19 101.4-25.5 12.1c-6.4 3.1-13.5 4.7-20.6 4.7H241.2c-7.1 0-14.2-1.6-20.6-4.7l-25.5-12.1 19-101.4c1.1-5.7 6-9.8 11.8-9.8c3.8 0 7.4 1.8 9.6 4.8z", "M334.8 176H241.2c-7.1 0-14.2-1.6-20.6-4.7L123.4 125c-16.2-7.7-35.5-3.6-47.1 10C27.1 192.4 0 265.6 0 341.2v37.6c0 9.7 10.2 16 18.9 11.7l63.8-31.9c7.5-3.7 16.6-1.1 20.9 6.1l29.8 49.7c5.4 8.9 17.7 10.4 25 3.1l36.6-36.6c6.8-6.8 18.1-6.1 24 1.6l56.2 73.1c6.4 8.3 19 8.3 25.4 0l56.2-73.1c5.9-7.7 17.2-8.4 24-1.6l36.6 36.6c7.4 7.4 19.7 5.8 25-3.1l29.8-49.7c4.3-7.2 13.4-9.8 20.9-6.1l63.8 31.9c8.7 4.3 18.9-2 18.9-11.7V341.2c0-75.6-27.1-148.8-76.3-206.2c-11.6-13.6-30.9-17.7-47.1-10l-97.2 46.3c-6.4 3.1-13.5 4.7-20.6 4.7z"]],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 160H320c17.7 0 32 14.3 32 32V320c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V192c0-17.7 14.3-32 32-32z", ""]],
    "head-side-headphones": [512, 512, [], "f8c2", ["M160 9.3V86.6c0 12.4-7.4 23.3-17.4 30.5C114.4 137.4 96 170.6 96 208c0 61.9 50.1 112 112 112s112-50.1 112-112c0-37.4-18.4-70.6-46.6-90.9c-10-7.2-17.4-18.2-17.4-30.5V.2c92 3.7 173.6 71.7 189.3 160c2.3 13 6.8 25.7 15.1 36l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8H448v64c0 35.3-28.7 64-64 64H320v32c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V407.3c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2C0 122.8 67.4 36.9 160 9.3z", "M256 64V.2c-2.7-.1-5.3-.2-8-.2H224c-22.2 0-43.7 3.2-64 9.3V64 86.6c0 12.4-7.4 23.3-17.4 30.5C114.4 137.4 96 170.6 96 208c0 61.9 50.1 112 112 112s112-50.1 112-112c0-37.4-18.4-70.6-46.6-90.9c-10-7.2-17.4-18.2-17.4-30.5V64zM144 208a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm96 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "phone-rotary": [512, 512, [9742], "f8d3", ["M0 141.3V176c0 17.7 14.3 32 32 32H74.3c13.1 0 24.9-8 29.7-20.1l19.4-48.6c2.9-7.3 8.4-13.2 15.7-16c18.6-7 59.5-19.3 116.8-19.3s98.2 12.3 116.8 19.3c7.3 2.8 12.8 8.7 15.7 16L408 187.9c4.9 12.1 16.6 20.1 29.7 20.1H480c17.7 0 32-14.3 32-32V141.3c0-8.5-3.4-16.6-9.9-22.1C473.8 95.4 386.1 32 256 32S38.2 95.4 9.9 119.2C3.4 124.6 0 132.8 0 141.3zM256 384a72 72 0 1 0 0-144 72 72 0 1 0 0 144z", "M32 401v31c0 26.5 21.5 48 48 48H432c26.5 0 48-21.5 48-48V401c0-11.1-2.9-22.1-8.4-31.8l-101.1-177C359 172.3 337.8 160 314.9 160H197.1c-23 0-44.2 12.3-55.6 32.2L40.4 369.2C34.9 378.9 32 389.9 32 401zM256 240a72 72 0 1 1 0 144 72 72 0 1 1 0-144z"]],
    "compass-drafting": [512, 512, ["drafting-compass"], "f568", ["M99.3 256.1L66.5 312.9C53.7 301.6 41.8 289.3 31.2 276c-11.1-13.8-8.8-33.9 5-45s33.9-8.8 45 5c5.7 7.1 11.8 13.8 18.2 20.1zm55.9 109.8l32.7-56.4c21.5 6.8 44.3 10.5 68.1 10.5c70.7 0 133.8-32.7 174.9-84c11.1-13.8 31.2-16 45-5s16 31.2 5 45C428.1 341.8 347 384 256 384c-35.4 0-69.4-6.4-100.7-18.1z", "M343.2 136.2c5.6-12.2 8.8-25.8 8.8-40.2c0-53-43-96-96-96s-96 43-96 96c0 14.3 3.1 27.9 8.8 40.2L6.5 416.5C2.2 423.9 0 432.2 0 440.6V496c0 5.5 2.9 10.7 7.6 13.6s10.6 3.2 15.6 .7l55.4-27.7c8.4-4.2 15.4-10.8 20.1-18.9L256 192h0c0 0 0 0 0 0l68 117.5c33.7-10.7 63.9-29.2 88.6-53.4L343.2 136.2zM224 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM356.7 365.9l56.6 97.8c4.7 8.1 11.7 14.7 20.1 18.9l55.4 27.7c5 2.5 10.9 2.2 15.6-.7s7.6-8.1 7.6-13.6V440.6c0-8.4-2.2-16.7-6.5-24.1l-60-103.7c-25.9 22.7-55.9 40.8-88.8 53z"]],
    "plate-wheat": [512, 512, [], "e55a", ["M160 48c0-8.8 7.2-16 16-16c44.2 0 80 35.8 80 80v16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80V48zM32 88c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H56c-13.3 0-24-10.7-24-24zM0 160c0-13.3 10.7-24 24-24H136c13.3 0 24 10.7 24 24s-10.7 24-24 24H24c-13.3 0-24-10.7-24-24zm56 48h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H56c-13.3 0-24-10.7-24-24s10.7-24 24-24zM288 32c44.2 0 80 35.8 80 80v16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80V48c0-8.8 7.2-16 16-16zm96 16c0-8.8 7.2-16 16-16c44.2 0 80 35.8 80 80v16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80V48zm80 128c8.8 0 16 7.2 16 16v16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16V256c0-44.2 35.8-80 80-80zm-96 16v16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16V256c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16zM240 176c8.8 0 16 7.2 16 16v16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16V256c0-44.2 35.8-80 80-80z", "M27.8 320C13 320 1.6 332.9 3.5 347.6C9.7 397.8 47.8 437 96 446v2c0 17.7 14.3 32 32 32H384c17.7 0 32-14.3 32-32v-2c48.2-9 86.3-48.2 92.6-98.4c1.8-14.7-9.6-27.6-24.4-27.6H27.8z"]],
    "calendar-circle-minus": [576, 512, [], "e46f", ["M96 32c0-17.7 14.3-32 32-32s32 14.3 32 32V64H288V32c0-17.7 14.3-32 32-32s32 14.3 32 32V64h48c26.5 0 48 21.5 48 48v48H0V112C0 85.5 21.5 64 48 64H96V32zM416 192.7c-89.7 8.1-160 83.5-160 175.3c0 59.5 29.6 112.1 74.8 144H48c-26.5 0-48-21.5-48-48V192H416v.7z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm64-128l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16H496c8.8 0 16 7.2 16 16s-7.2 16-16 16z"]],
    "chopsticks": [640, 512, [], "e3f7", ["M235.8 153.5L3.4 486.1c-5.5 6.9-4.3 17 2.7 22.5s17 4.3 22.5-2.7l267.8-304-60.5-48.4zM419 211L133.6 483.9c-6.7 5.8-7.5 15.8-1.7 22.6s15.9 7.5 22.6 1.7L472.3 264.3 419 211z", "M296.3 201.9l-60.5-48.4L330.3 18.3C339 7.2 352.7 0 368 0c26.5 0 48 21.5 48 48c0 11.2-3.8 21.5-10.3 29.7L296.3 201.9zm175.9 62.4L419 211 560.8 75.6C569.2 68.4 580.1 64 592 64c26.5 0 48 21.5 48 48c0 14.6-6.5 27.6-16.8 36.4l-151 115.8z"]],
    "car-wrench": [512, 512, ["car-mechanic"], "f5e3", ["M163.8 112c-6.4 0-12 3.8-15.3 9.3C134.5 144.5 109.1 160 80 160c-28.1 0-52.8-14.5-67.1-36.4C7 114.6 14.7 104 25.5 104H56c13.3 0 24-10.7 24-24s-10.7-24-24-24H25.5C14.7 56 7 45.4 12.9 36.4C27.2 14.5 51.9 0 80 0c29.1 0 54.5 15.5 68.5 38.7c3.3 5.4 8.9 9.3 15.3 9.3H348.2c6.4 0 12-3.8 15.3-9.3C377.5 15.5 402.9 0 432 0c28.1 0 52.8 14.5 67.1 36.4c5.9 9-1.7 19.6-12.5 19.6H456c-13.3 0-24 10.7-24 24s10.7 24 24 24h30.5c10.8 0 18.4 10.6 12.5 19.6c-14.3 21.9-39 36.4-67.1 36.4c-29.1 0-54.5-15.5-68.5-38.7c-3.3-5.4-8.9-9.3-15.3-9.3H163.8z", "M170.8 234.6L151.7 288H360.3l-19.1-53.4c-2.3-6.4-8.3-10.6-15.1-10.6H185.8c-6.8 0-12.8 4.3-15.1 10.6zM82.2 292.4l28.3-79.3C121.9 181.3 152 160 185.8 160H326.2c33.8 0 64 21.3 75.3 53.1l28.3 79.3c20.1 8.5 34.2 28.4 34.2 51.6v40 64 32c0 17.7-14.3 32-32 32H416c-17.7 0-32-14.3-32-32V448H128v32c0 17.7-14.3 32-32 32H80c-17.7 0-32-14.3-32-32V448 384 344c0-23.2 14.1-43.1 34.2-51.6zM152 368a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm232 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]],
    "icicles": [512, 512, [], "f7ad", ["M336 160l61.2 336.4c1.6 9 9.5 15.6 18.7 15.6c9.3 0 17.2-6.7 18.8-15.9L511.6 34.4c.3-1.6 .4-3.2 .4-4.9C512 13.2 498.8 0 482.4 0H342.1c-1.6 0-3.2 .1-4.8 .4c13.8 2.3 24.3 14.3 24.3 28.7c0 1.9-.2 3.8-.6 5.7L336 160l0 0z", "M75.8 304.8L1 35.7c-.7-2.5-1-5-1-7.5C0 12.6 12.6 0 28.2 0H332.5c16.1 0 29.1 13 29.1 29.1c0 1.9-.2 3.8-.6 5.7L336 160 307.2 303.9c-1.9 9.3-10.1 16.1-19.6 16.1c-9.2 0-17.2-6.2-19.4-15.1L240 192 210.6 368.2c-1.5 9.1-9.4 15.8-18.6 15.8s-17.1-6.7-18.6-15.8L144 192 115.9 304.3c-2.3 9.2-10.6 15.7-20.1 15.7c-9.3 0-17.5-6.2-20-15.2z"]],
    "person-shelter": [512, 512, [], "e54f", ["M296 168a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM248 488V400h16v88c0 13.3 10.7 24 24 24s24-10.7 24-24V313.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3H246.2c-32.4 0-62.1 17.8-77.5 46.3l-37.9 70.3c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L200 313.5V488c0 13.3 10.7 24 24 24s24-10.7 24-24z", "M240.1 4.2c9.8-5.6 21.9-5.6 31.8 0l224 128c10 5.7 16.1 16.3 16.1 27.8V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V178.6L256 68.9 64 178.6V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-11.5 6.2-22.1 16.1-27.8l224-128z"]],
    "neuter": [384, 512, [9906], "f22c", ["M112 176a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z", "M80 176a112 112 0 1 1 224 0A112 112 0 1 1 80 176zM224 349.1c81.9-15 144-86.8 144-173.1C368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1V480c0 17.7 14.3 32 32 32s32-14.3 32-32V349.1z"]],
    "id-badge": [384, 512, [], "f2c1", ["M64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zm96 320h64c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16c0-44.2 35.8-80 80-80zm-32-96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM144 64h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H144c-8.8 0-16-7.2-16-16s7.2-16 16-16z", "M192 288a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-44.2 0-80 35.8-80 80c0 8.8 7.2 16 16 16H288c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80H160z"]],
    "kazoo": [640, 512, [], "f8c7", ["M592 256c0 55.7-31.7 104.1-78 128h94c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H514c46.3 23.9 78 72.3 78 128zM224 384H382c-46.3-23.9-78-72.3-78-128s31.7-104.1 78-128H224c-3 0-6 .4-9 1.3l-192 56C9.4 189.3 0 201.8 0 216v80c0 14.2 9.4 26.7 23 30.7l192 56c2.9 .8 5.9 1.3 9 1.3zM427.3 212.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L425.4 256l-20.7 20.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L448 278.6l20.7 20.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L470.6 256l20.7-20.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L448 233.4l-20.7-20.7z", "M448 400a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-240a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]],
    "marker": [512, 512, [], "f5a1", ["M305 337L175 207 99.5 282.5c-48 48-80.8 109.2-94.1 175.8l-5 25c-1.6 7.9 .9 16 6.6 21.7s13.8 8.1 21.7 6.6l25-5c66.6-13.3 127.8-46.1 175.8-94.1L305 337z", "M481 31C445.1-4.8 386.9-4.8 351 31l-15 15L322.9 33C294.8 4.9 249.2 4.9 221.1 33L135 119c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L255 66.9c9.4-9.4 24.6-9.4 33.9 0L302.1 80 175 207 305 337 481 161c35.9-35.9 35.9-94.1 0-129.9z"]],
    "bin-bottles": [640, 512, [], "e5f5", ["M128 24c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24v8c8.8 0 16 7.2 16 16s-7.2 16-16 16H128c-8.8 0-16-7.2-16-16s7.2-16 16-16V24zm0 72H256c24.9 0 47.6 9.5 64.6 25c1.1 1 2.2 2 3.2 3.1C341.3 141.5 352 165.5 352 192H32c0-53 43-96 96-96zm447.1 96H384c0-40.7-19-76.9-48.6-100.4c5.2-5.6 11.5-10.3 18.6-13.6l13.2-6.2c5.3-2.5 10.8-4.4 16.4-5.7V24c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24V66.1c5.6 1.3 11.1 3.2 16.4 5.7L541.2 78c21 9.9 34.4 31 34.4 54.2c0 12.3-3.7 23.8-10.1 33.3c5 7.8 8.4 16.9 9.6 26.5z", "M32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32L56.2 457c4.5 31.5 31.5 55 63.4 55h401c31.8 0 58.9-23.4 63.4-55L608 288c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "face-laugh-beam": [512, 512, [128513, "laugh-beam"], "f59a", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM96.8 314.1c-3.8-13.7 7.4-26.1 21.6-26.1H393.6c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zM217.6 212.8l0 0 0 0-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2 0 0 0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l0 0 0 0zm160 0l0 0-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2 0 0 0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l0 0 0 0 0 0z", "M217.6 212.8l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 172.4 120 190.1 120 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0zm160 0l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 172.4 280 190.1 280 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0z"]],
    "square-arrow-down-left": [448, 512, [], "e261", ["M64 480c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64zM288 368c13.3 0 24-10.7 24-24s-10.7-24-24-24H193.9L329 185c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-135 135V184c0-13.3-10.7-24-24-24s-24 10.7-24 24V344c0 13.3 10.7 24 24 24H288z", "M136 368H288c13.3 0 24-10.7 24-24s-10.7-24-24-24H193.9L329 185c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-135 135V184c0-13.3-10.7-24-24-24s-24 10.7-24 24V344c0 13.3 10.7 24 24 24z"]],
    "battery-bolt": [576, 512, [], "f376", ["M299.2 96l-80 64H80c-8.8 0-16 7.2-16 16V336c0 8.8 7.2 16 16 16h90.3l-5.3 10.5c-8.9 17.8-5.8 39 7.2 53.5H80c-44.2 0-80-35.8-80-80V176c0-44.2 35.8-80 80-80H299.2zm25.7 256H464c8.8 0 16-7.2 16-16V176c0-8.8-7.2-16-16-16H373.7l5.3-10.5c8.9-17.8 5.8-39-7.2-53.5H464c44.2 0 80 35.8 80 80v16c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32v16c0 44.2-35.8 80-80 80H244.8l80-64z", "M350.3 135.2c3.4-6.7 1.6-14.9-4.2-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7h70.1L193.7 376.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7H297.9l52.4-104.8z"]],
    "tree-large": [448, 512, [], "f7dd", ["M210.6 5.9L62 169.4c-3.9 4.2-6 9.8-6 15.5C56 197.7 66.3 208 79.1 208H104L28.5 313.7c-2.9 4.1-4.5 9-4.5 14.1C24 341.1 34.8 352 48.2 352H80L3.8 474c-2.5 4-3.8 8.5-3.8 13.2C0 500.9 11.1 512 24.9 512H192V224c0-17.7 14.3-32 32-32s32 14.3 32 32V512H423.1c13.7 0 24.9-11.1 24.9-24.9c0-4.7-1.3-9.2-3.8-13.2L368 352h31.8c13.4 0 24.2-10.9 24.2-24.2c0-5-1.6-10-4.5-14.1L344 208h24.9c12.7 0 23.1-10.3 23.1-23.1c0-5.7-2.1-11.3-6-15.5L237.4 5.9C234 2.1 229.1 0 224 0s-10 2.1-13.4 5.9z", "M224 192c17.7 0 32 14.3 32 32V512H192V224c0-17.7 14.3-32 32-32z"]],
    "helicopter-symbol": [512, 512, [], "e502", ["M510 224C495.6 108.2 403.8 16.4 288 2V66.7C368.4 80.1 431.9 143.6 445.3 224H510zm-64.7 64C431.9 368.4 368.4 431.9 288 445.4V510c115.8-14.4 207.6-106.2 222-222H445.3zM66.7 288H2C16.4 403.8 108.2 495.6 224 510V445.4C143.6 431.9 80.1 368.4 66.7 288zm0-64C80.1 143.6 143.6 80.1 224 66.7V2C108.2 16.4 16.4 108.2 2 224H66.7z", "M176 128c17.7 0 32 14.3 32 32v64h96V160c0-17.7 14.3-32 32-32s32 14.3 32 32V352c0 17.7-14.3 32-32 32s-32-14.3-32-32V288H208v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-17.7 14.3-32 32-32z"]],
    "aperture": [512, 512, [], "e2df", ["M336.4 12.9C400.2 34 453 79.5 483.5 138.4c5.2 10.1-2.5 21.6-13.8 21.6H265.2c-12.3 0-20-13.3-13.9-24l67-116c3.6-6.3 11.1-9.4 18-7.1zM0 256c0-50.9 14.9-98.3 40.5-138.2c6.1-9.5 19.9-8.6 25.6 1.2L168.2 296c6.2 10.7-1.5 24-13.9 24H20.5c-7.3 0-13.7-4.9-15.2-12.1C1.8 291.2 0 273.8 0 256zM256 512c-4 0-7.9-.1-11.9-.3c-11.3-.5-17.5-12.9-11.8-22.8L334.5 312c6.2-10.7 21.6-10.7 27.7 0l66.9 115.9c3.6 6.3 2.6 14.3-2.9 19.2C381.1 487.5 321.4 512 256 512z", "M256 0c4 0 7.9 .1 11.9 .3c11.3 .5 17.4 12.9 11.8 22.8L177.5 200c-6.2 10.7-21.6 10.7-27.7 0L82.8 84.1c-3.6-6.3-2.6-14.3 2.9-19.2C130.9 24.5 190.6 0 256 0zM193.6 492c-3.6 6.3-11.1 9.4-18 7.1C111.8 478 59 432.5 28.5 373.6C23.3 363.5 31 352 42.3 352H246.8c12.3 0 20 13.3 13.9 24l-67 116zm277.9-97.8c-6.1 9.5-19.9 8.6-25.6-1.2L343.8 216c-6.2-10.7 1.5-24 13.9-24H491.5c7.3 0 13.7 4.9 15.2 12.1c3.5 16.8 5.3 34.1 5.3 51.9c0 50.9-14.9 98.3-40.5 138.2z"]],
    "universal-access": [512, 512, [], "f29a", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm161.5-86.1c-12.2-5.2-26.3 .4-31.5 12.6s.4 26.3 12.6 31.5l11.9 5.1c17.3 7.4 35.2 12.9 53.6 16.3v50.1c0 4.3-.7 8.6-2.1 12.6l-28.7 86.1c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l24.4-73.2c1.3-3.8 4.8-6.4 8.8-6.4s7.6 2.6 8.8 6.4l24.4 73.2c4.2 12.6 17.8 19.4 30.4 15.2s19.4-17.8 15.2-30.4l-28.7-86.1c-1.4-4.1-2.1-8.3-2.1-12.6V235.5c18.4-3.5 36.3-8.9 53.6-16.3l11.9-5.1c12.2-5.2 17.8-19.3 12.6-31.5s-19.3-17.8-31.5-12.6L338.7 175c-26.1 11.2-54.2 17-82.7 17s-56.5-5.8-82.7-17l-11.9-5.1zM256 160a40 40 0 1 0 0-80 40 40 0 1 0 0 80z", "M256 80a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM129.9 182.5c5.2-12.2 19.3-17.8 31.5-12.6l11.9 5.1c26.1 11.2 54.2 17 82.7 17s56.5-5.8 82.7-17l11.9-5.1c12.2-5.2 26.3 .4 31.5 12.6s-.4 26.3-12.6 31.5l-11.9 5.1c-17.3 7.4-35.2 12.9-53.6 16.3v50.1c0 4.3 .7 8.6 2.1 12.6l28.7 86.1c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-24.4-73.2c-1.3-3.8-4.8-6.4-8.8-6.4s-7.6 2.6-8.8 6.4l-24.4 73.2c-4.2 12.6-17.8 19.4-30.4 15.2s-19.4-17.8-15.2-30.4l28.7-86.1c1.4-4.1 2.1-8.3 2.1-12.6V235.5c-18.4-3.5-36.3-8.9-53.6-16.3l-11.9-5.1c-12.2-5.2-17.8-19.3-12.6-31.5z"]],
    "gear-complex": [512, 512, [], "e5e9", ["M192 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z", "M305.4 21.8c-1.3-10.4-9.1-18.8-19.5-20C276.1 .6 266.1 0 256 0c-11.1 0-22.1 .7-32.8 2.1c-10.3 1.3-18 9.7-19.3 20l-2.9 23.1c-.8 6.4-5.4 11.6-11.5 13.7c-9.6 3.2-19 7.2-27.9 11.7c-5.8 3-12.8 2.5-18-1.5l-18-14c-8.2-6.4-19.7-6.8-27.9-.4c-16.6 13-31.5 28-44.4 44.7c-6.3 8.2-5.9 19.6 .5 27.8l14.2 18.3c4 5.1 4.4 12 1.5 17.8c-4.4 8.8-8.2 17.9-11.3 27.4c-2 6.2-7.3 10.8-13.7 11.6l-22.8 2.9c-10.3 1.3-18.7 9.1-20 19.4C.7 234.8 0 245.3 0 256c0 10.6 .6 21.1 1.9 31.4c1.3 10.3 9.7 18.1 20 19.4l22.8 2.9c6.4 .8 11.7 5.4 13.7 11.6c3.1 9.5 6.9 18.7 11.3 27.5c2.9 5.8 2.4 12.7-1.5 17.8L54 384.8c-6.4 8.2-6.8 19.6-.5 27.8c12.9 16.7 27.8 31.7 44.4 44.7c8.2 6.4 19.7 6 27.9-.4l18-14c5.1-4 12.2-4.4 18-1.5c9 4.6 18.3 8.5 27.9 11.7c6.1 2.1 10.7 7.3 11.5 13.7l2.9 23.1c1.3 10.3 9 18.7 19.3 20c10.7 1.4 21.7 2.1 32.8 2.1c10.1 0 20.1-.6 29.9-1.7c10.4-1.2 18.2-9.7 19.5-20l2.8-22.5c.8-6.5 5.5-11.8 11.7-13.8c10-3.2 19.7-7.2 29-11.8c5.8-2.9 12.7-2.4 17.8 1.5L385 457.9c8.2 6.4 19.6 6.8 27.8 .5c2.8-2.2 5.5-4.4 8.2-6.7L451.7 421c1.8-2.2 3.6-4.4 5.4-6.6c6.5-8.2 6-19.7-.4-27.9l-14-17.9c-4-5.1-4.4-12.2-1.5-18c4.8-9.4 9-19.3 12.3-29.5c2-6.2 7.3-10.8 13.7-11.6l22.8-2.8c10.3-1.3 18.8-9.1 20-19.4c.2-1.7 .4-3.5 .6-5.2V230.1c-.2-1.7-.4-3.5-.6-5.2c-1.3-10.3-9.7-18.1-20-19.4l-22.8-2.8c-6.4-.8-11.7-5.4-13.7-11.6c-3.4-10.2-7.5-20.1-12.3-29.5c-3-5.8-2.5-12.8 1.5-18l14-17.9c6.4-8.2 6.8-19.7 .4-27.9c-1.8-2.2-3.6-4.4-5.4-6.6L421 60.3c-2.7-2.3-5.4-4.5-8.2-6.7c-8.2-6.4-19.6-5.9-27.8 .5L366.7 68.3c-5.1 4-12.1 4.4-17.8 1.5c-9.3-4.6-19-8.6-29-11.8c-6.2-2-10.9-7.3-11.7-13.7l-2.8-22.5zM256 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]],
    "file-magnifying-glass": [384, 512, ["file-search"], "f865", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM272 304c0-53-43-96-96-96s-96 43-96 96s43 96 96 96c17.8 0 34.4-4.8 48.7-13.2L263 425.1c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-38.3-38.3c8.5-14.3 13.3-31 13.3-48.9zm-96-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z", "M384 160H256c-17.7 0-32-14.3-32-32V0L384 160zM272 304c0 17.8-4.9 34.5-13.3 48.9L297 391.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-38.4-38.4C210.4 395.2 193.8 400 176 400c-53 0-96-43-96-96s43-96 96-96s96 43 96 96zm-96 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]],
    "up-right": [384, 512, [], "e2be", ["M145.4 206.6L11.3 340.7C4.1 347.9 0 357.8 0 368s4.1 20.1 11.3 27.3l41.4 41.4C59.9 443.9 69.8 448 80 448s20.1-4.1 27.3-11.3L241.4 302.6l-96-96z", "M336 80H96c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l240 240c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6V112c0-17.7-14.3-32-32-32z"]],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM377 271c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-87-87-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 167c9.4-9.4 24.6-9.4 33.9 0L377 271z", "M239 167c9.4-9.4 24.6-9.4 33.9 0L377 271c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-87-87-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 167z"]],
    "user-police": [448, 512, [], "e333", ["M101.7 154.2C98 166.1 96 178.8 96 192c0 70.7 57.3 128 128 128s128-57.3 128-128c0-13.2-2-25.9-5.7-37.8C308.2 168.3 267 176 224 176s-84.2-7.7-122.3-21.8z", "M230.1 .8c-4-1.1-8.2-1.1-12.2 0l-152 40c-8.6 2.3-15.3 9.1-17.3 17.8s1 17.8 7.8 23.6l23.8 20.4c-.1 1-.1 2-.1 3.1v21.2c0 10.7 5.3 20.8 15.1 25.2c24.1 10.8 68.6 24 128.9 24s104.8-13.2 128.9-24c9.8-4.4 15.1-14.5 15.1-25.2V105.7c0-1-.1-2.1-.1-3.1l23.8-20.4c6.8-5.8 9.8-14.9 7.8-23.6s-8.7-15.6-17.3-17.8l-152-40zM227 48.6l32 12.8c3 1.2 5 4.2 5 7.4c0 17.2-7 46.1-36.9 58.6c-2 .8-4.2 .8-6.2 0C191 114.9 184 86 184 68.8c0-3.3 2-6.2 5-7.4l32-12.8c1.9-.8 4-.8 5.9 0zm-84.9 306c-2.2-1.7-4.9-2.6-7.7-2.6C60.2 352 0 412.2 0 486.4C0 500.5 11.5 512 25.6 512H422.4c14.1 0 25.6-11.5 25.6-25.6C448 412.2 387.8 352 313.6 352c-2.8 0-5.5 .9-7.7 2.6l-72.3 54.2c-5.7 4.3-13.5 4.3-19.2 0l-72.3-54.2zm217.5 59l5.4 16.6 17.4 0c3.5 0 6.6 2.2 7.6 5.5s-.1 6.9-2.9 9L373 454.8l5.4 16.6c1.1 3.3-.1 6.9-2.9 9s-6.6 2-9.4 0L352 470.1l-14.1 10.3c-2.8 2-6.6 2.1-9.4 0s-4-5.7-2.9-9l5.4-16.6-14.1-10.2c-2.8-2-4-5.7-2.9-9s4.2-5.5 7.6-5.5l17.4 0 5.4-16.6c1.1-3.3 4.1-5.5 7.6-5.5s6.5 2.2 7.6 5.5z"]],
    "lari-sign": [384, 512, [], "e1c8", ["M144 32c-17.7 0-32 14.3-32 32v49.4c19.8-9.1 41.3-14.9 64-16.8L176 64c0-17.7-14.3-32-32-32zM112 188.1V256c0 17.7 14.3 32 32 32s32-14.3 32-32l0-95c-24 3-46 12.7-64 27.1zM208 161v95c0 17.7 14.3 32 32 32s32-14.3 32-32V188.1c-18-14.4-40-24.1-64-27.1zm64-47.6V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V96.7c22.7 1.9 44.2 7.7 64 16.8z", "M64 288c0-70.7 57.3-128 128-128c61.9 0 113.6 44 125.4 102.4c3.5 17.3 20.4 28.5 37.7 25s28.5-20.4 25-37.7C362.4 162 284.9 96 192 96C86 96 0 182 0 288c0 49.2 18.5 94 48.9 128H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H192 352c17.7 0 32-14.3 32-32s-14.3-32-32-32H192c-70.7 0-128-57.3-128-128z"]],
    "volcano": [512, 512, [127755], "f770", ["M173.3 343.1l17.8-11.9c11-7.3 23.9-11.2 37.1-11.2c17.8 0 34.8 7.1 47.3 19.6l34.5 34.5c6.3 6.3 14.9 9.9 23.8 9.9c11.3 0 21.8-5.6 28-15l37.2-55.8 99.6 112c8.5 9.6 13.2 21.9 13.2 34.7c0 28.8-23.4 52.2-52.2 52.2H52.2C23.4 512 0 488.6 0 459.8c0-12.8 4.7-25.1 13.2-34.7l83.6-94 17.9 12c8.7 5.8 18.9 8.9 29.3 8.9s20.6-3.1 29.3-8.9z", "M160 144c14.7 0 28.3-5 39.1-13.3l32 48C236.7 187 246 192 256 192s19.3-5 24.9-13.3l32-48C323.7 139 337.3 144 352 144c35.3 0 64-28.7 64-64s-28.7-64-64-64c-15.7 0-30 5.6-41.2 15C299.6 12.4 279.3 0 256 0s-43.6 12.4-54.8 31C190 21.6 175.7 16 160 16c-35.3 0-64 28.7-64 64s28.7 64 64 64zm31.1 187.2c11-7.3 23.9-11.2 37.1-11.2c17.8 0 34.8 7.1 47.3 19.6l34.5 34.5c6.3 6.3 14.9 9.9 23.8 9.9c11.3 0 21.8-5.6 28-15l37.2-55.8-50.6-56.9c-18.2-20.5-44.3-32.2-71.8-32.2H235.1c-27.4 0-53.5 11.7-71.8 32.2L96.7 331.2l17.9 12c8.7 5.8 18.9 8.9 29.3 8.9s20.6-3.1 29.3-8.9l17.8-11.9z"]],
    "teddy-bear": [576, 512, [], "e3cf", ["M236.6 36.7C228.7 15.3 208.2 0 184 0c-30.9 0-56 25.1-56 56c0 20.2 10.7 37.9 26.7 47.7c9.1-37.9 40.4-58.5 81.9-67zM448 56c0-30.9-25.1-56-56-56c-24.2 0-44.7 15.3-52.6 36.7c41.5 8.5 72.8 29.1 81.9 67C437.3 93.9 448 76.2 448 56zM288 224c35.3 0 64-21.5 64-48s-28.7-48-64-48s-64 21.5-64 48s28.7 48 64 48zm0-32c-17.7 0-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24s-14.3 24-32 24zM192 416H384c0-35.3-28.7-64-64-64H256c-35.3 0-64 28.7-64 64z", "M288 256c-75.1 0-136-57.3-136-128s60.9-96 136-96s136 25.3 136 96s-60.9 128-136 128zM240 128a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm0 64c0-26.5-28.7-48-64-48s-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48zm-32-8c0 13.3-14.3 24-32 24s-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24zM50.3 178.3c20.8-16.4 51-12.8 67.4 8L143.5 219c73.7 93.5 215.4 93.5 289.1 0l25.8-32.7c16.4-20.8 46.6-24.4 67.4-8s24.4 46.6 8 67.4l-25.8 32.7c-17.7 22.4-37.9 41.3-59.9 56.7V400h16.6c3.9-27.1 27.2-48 55.4-48c30.9 0 56 25.1 56 56c0 2.7-.2 5.4-.6 8l-13 53.3c-5.8 23.8-26.3 40.9-50.4 42.6v.1h-4H480 96 68 64v-.1c-24.1-1.7-44.6-18.8-50.4-42.6L.6 416c-.4-2.6-.6-5.3-.6-8c0-30.9 25.1-56 56-56c28.2 0 51.6 20.9 55.4 48H128V335.1c-22-15.4-42.3-34.3-59.9-56.7L42.3 245.7c-16.4-20.8-12.8-51 8-67.4zM256 352c-35.3 0-64 28.7-64 64H384c0-35.3-28.7-64-64-64H256z"]],
    "stocking": [384, 512, [], "f7d5", ["M96 96V238.9c0 10.7-5.3 20.7-14.2 26.6L55.7 282.9C20.9 306.1 0 345.1 0 386.9v2.2C0 457 55 512 122.8 512c24.2 0 48-7.2 68.1-20.6l66-44c-20.4-20.3-33-48.3-33-79.4c0-61.9 50.1-112 112-112c5.4 0 10.8 .4 16 1.1V96H96z", "M96 0C78.3 0 64 14.3 64 32V64c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H96zM352 315.5V257.1c-5.2-.7-10.6-1.1-16-1.1c-61.9 0-112 50.1-112 112c0 31 12.6 59.1 33 79.4L295 422c35.6-23.7 57-63.7 57-106.5z"]],
    "person-walking-dashed-line-arrow-right": [640, 512, [], "e553", ["", "M392 0c13.3 0 24 10.7 24 24V72c0 13.3-10.7 24-24 24s-24-10.7-24-24V24c0-13.3 10.7-24 24-24zM505.4 153.4c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3l-80 80c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L530.7 288H384c-17.7 0-32-14.3-32-32s14.3-32 32-32H530.7l-25.4-25.4c-12.5-12.5-12.5-32.8 0-45.3zM416 152v16c0 13.3-10.7 24-24 24s-24-10.7-24-24V152c0-13.3 10.7-24 24-24s24 10.7 24 24zM392 320c13.3 0 24 10.7 24 24v16c0 13.3-10.7 24-24 24s-24-10.7-24-24V344c0-13.3 10.7-24 24-24zm24 120v48c0 13.3-10.7 24-24 24s-24-10.7-24-24V440c0-13.3 10.7-24 24-24s24 10.7 24 24zM160 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM126.5 199.3c-1 .4-1.9 .8-2.9 1.2l-8 3.5c-16.4 7.3-29 21.2-34.7 38.2l-2.6 7.8c-5.6 16.8-23.7 25.8-40.5 20.2s-25.8-23.7-20.2-40.5l2.6-7.8c11.4-34.1 36.6-61.9 69.4-76.5l8-3.5c20.8-9.2 43.3-14 66.1-14c44.6 0 84.8 26.8 101.9 67.9L281 232.7l21.4 10.7c15.8 7.9 22.2 27.1 14.3 42.9s-27.1 22.2-42.9 14.3L247 287.3c-10.3-5.2-18.4-13.8-22.8-24.5l-9.6-23-19.3 65.5 49.5 54c5.4 5.9 9.2 13 11.2 20.8l23 92.1c4.3 17.1-6.1 34.5-23.3 38.8s-34.5-6.1-38.8-23.3l-22-88.1-70.7-77.1c-14.8-16.1-20.3-38.6-14.7-59.7l16.9-63.5zM68.7 398l25-62.4c2.1 3 4.5 5.8 7 8.6l40.7 44.4-14.5 36.2c-2.4 6-6 11.5-10.6 16.1L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L68.7 398z"]],
    "image-slash": [640, 512, [], "e1b7", ["M64.7 86.4l63.9 50.1c-.4 2.5-.6 5-.6 7.5c0 26.5 21.5 48 48 48c6.6 0 12.9-1.3 18.6-3.8L301 271.6l-20.4 29.9L259 273.4c-4.4-5.8-11.2-9.2-18.5-9.4s-14.2 3-18.9 8.5l-88 104c-6 7.1-7.4 17.1-3.5 25.6s12.4 13.9 21.8 13.9h96 72H485.2l65.3 51.1c-10.7 8.1-24 12.9-38.5 12.9H128c-35.3 0-64-28.7-64-64V96c0-3.3 .2-6.5 .7-9.6zM223.6 150c.2-2 .4-4 .4-6c0-26.5-21.5-48-48-48c-6.1 0-11.9 1.1-17.2 3.2L89.5 44.9C100.2 36.8 113.6 32 128 32H512c35.3 0 64 28.7 64 64V416c0 3.3-.2 6.5-.7 9.6l-75.9-59.5L387.8 202.5c-4.5-6.6-11.9-10.5-19.8-10.5s-15.4 3.9-19.8 10.5l-20 29.4L223.6 150z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "mask-snorkel": [576, 512, [], "e3b7", ["M576 64c0-17.7-14.3-32-32-32s-32 14.3-32 32v96h64V64zm0 128H512V367.4c0 44.5-36.1 80.6-80.6 80.6c-39.4 0-73-28.5-79.5-67.4l-.3-1.9c-2.9-17.4-19.4-29.2-36.8-26.3s-29.2 19.4-26.3 36.8l.3 1.9c11.6 69.7 72 120.8 142.6 120.8C511.3 512 576 447.3 576 367.4V192z", "M64 64C28.7 64 0 92.7 0 128v96c0 35.3 28.7 64 64 64h79.7c28.6 0 53.7-18.9 61.5-46.4l3.4-11.7c4.4-15.5 26.3-15.5 30.8 0l3.4 11.7c7.8 27.5 33 46.4 61.5 46.4H384c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zm512 96H512v32h64V160z"]],
    "smoke": [640, 512, [], "f760", ["M144 192c-29.2 0-56.7 7.1-80.9 19.6C43.7 189.2 32 160 32 128C32 57.3 89.3 0 160 0c40.1 0 75.9 18.4 99.3 47.3C277.4 37.5 298 32 320 32c44.3 0 83.4 22.5 106.4 56.8c-11.5 7.3-22 16-31.2 25.9C372.7 102.8 347.2 96 320 96c-66.5 0-123.5 40.6-147.7 98.3c-9.2-1.5-18.7-2.3-28.3-2.3zm320 64c-5.2 0-10.3 .3-15.4 .8C419.5 217.5 372.7 192 320 192c-31.5 0-60.9 9.1-85.7 24.9c-9.6-5.8-19.8-10.6-30.5-14.5C224 158.5 268.4 128 320 128c31.3 0 60.1 11.3 82.3 30c22.4-37.1 63.1-62 109.7-62c70.7 0 128 57.3 128 128c0 42.2-20.4 79.6-51.9 102.9C563.1 284.5 516.9 256 464 256z", "M0 368c0 79.5 64.5 144 144 144H464c61.9 0 112-50.1 112-112s-50.1-112-112-112c-10.7 0-21 1.5-30.8 4.3C411.8 251.7 369.1 224 320 224c-32.6 0-62.4 12.2-85.1 32.3C210.1 236.1 178.5 224 144 224C64.5 224 0 288.5 0 368z"]],
    "sterling-sign": [320, 512, [163, "gbp", "pound-sign"], "f154", ["M48 224H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H48V224zm64 64H224c17.7 0 32-14.3 32-32s-14.3-32-32-32H112v64z", "M176.4 96c-35.5 0-64.4 28.8-64.4 64.4V332.5c0 29-7.9 57.5-22.8 82.3l-.7 1.1H288c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-11.5 0-22.2-6.2-27.8-16.2s-5.5-22.3 .4-32.2l29.8-49.6c9-14.9 13.7-32 13.7-49.4V160.4C48 89.5 105.5 32 176.4 32c13.8 0 27.5 2.2 40.6 6.6l81.2 27.1c16.8 5.6 25.8 23.7 20.2 40.5s-23.7 25.8-40.5 20.2L196.7 99.3c-6.6-2.2-13.4-3.3-20.4-3.3z"]],
    "battery-exclamation": [576, 512, [], "e0b0", ["M80 96C35.8 96 0 131.8 0 176V336c0 44.2 35.8 80 80 80H198.7c-4.3-9.8-6.7-20.6-6.7-32s2.4-22.2 6.7-32H80c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16H208V96H80zM345.3 416H464c44.2 0 80-35.8 80-80V320c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32V176c0-44.2-35.8-80-80-80H336v64H464c8.8 0 16 7.2 16 16V336c0 8.8-7.2 16-16 16H345.3c4.3 9.8 6.7 20.6 6.7 32s-2.4 22.2-6.7 32z", "M296 120c0-13.3-10.7-24-24-24s-24 10.7-24 24V296c0 13.3 10.7 24 24 24s24-10.7 24-24V120zM272 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "viruses": [640, 512, [], "e076", ["M192 0c13.3 0 24 10.7 24 24V37.5c0 35.6 43.1 53.5 68.3 28.3l9.5-9.5c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-9.5 9.5C293 124.9 310.9 168 346.5 168H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H346.5c-35.6 0-53.5 43.1-28.3 68.3l9.5 9.5c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-9.5-9.5C259.1 293 216 310.9 216 346.5V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V346.5c0-35.6-43.1-53.5-68.3-28.3l-9.5 9.5c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l9.5-9.5C91 259.1 73.1 216 37.5 216H24c-13.3 0-24-10.7-24-24s10.7-24 24-24H37.5c35.6 0 53.5-43.1 28.3-68.3l-9.5-9.5c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l9.5 9.5C124.9 91 168 73.1 168 37.5V24c0-13.3 10.7-24 24-24zm48 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-48-64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM480 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M160 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352 48c0-8.8-7.2-16-16-16s-16 7.2-16 16c0 33-39.9 49.5-63.2 26.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6C417.5 312.1 401 352 368 352c-8.8 0-16 7.2-16 16s7.2 16 16 16c33 0 49.5 39.9 26.2 63.2c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0C440.1 446.5 480 463 480 496c0 8.8 7.2 16 16 16s16-7.2 16-16c0-33 39.9-49.5 63.2-26.2c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6C574.5 423.9 591 384 624 384c8.8 0 16-7.2 16-16s-7.2-16-16-16c-33 0-49.5-39.9-26.2-63.2c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0C551.9 289.5 512 273 512 240zM448 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "square-person-confined": [448, 512, [], "e577", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm96 112a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm80 104c0-30.9 25.1-56 56-56s56 25.1 56 56V350.1c0 36.4-29.5 65.9-65.9 65.9c-17.5 0-34.3-6.9-46.6-19.3L184.8 342l-28.1 56.3c-7.9 15.8-27.1 22.2-42.9 14.3s-22.2-27.1-14.3-42.9l48-96c4.6-9.2 13.3-15.6 23.5-17.3s20.5 1.7 27.8 9L240 306.7V248z", "M208 192a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm88 0c-30.9 0-56 25.1-56 56v58.7l-41.4-41.4c-7.3-7.3-17.6-10.6-27.8-9s-18.9 8.1-23.5 17.3l-48 96c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3L184.8 342l54.7 54.7c12.4 12.4 29.1 19.3 46.6 19.3c36.4 0 65.9-29.5 65.9-65.9V248c0-30.9-25.1-56-56-56z"]],
    "user-tie": [448, 512, [], "f508", ["M352 128A128 128 0 1 1 96 128a128 128 0 1 1 256 0z", "M190.5 328.2l18.6 31L175.8 483.1 136.3 321.9C59.1 333.9 0 400.7 0 481.3c0 17 13.8 30.7 30.7 30.7H182.9h82.3H417.3c17 0 30.7-13.8 30.7-30.7c0-80.6-59.1-147.4-136.3-159.4L272.2 483.1 238.9 359.2l18.6-31c6.4-10.7-1.3-24.2-13.7-24.2H224 204.3c-12.4 0-20.1 13.6-13.7 24.2z"]],
    "arrow-down-long": [384, 512, ["long-arrow-down"], "f175", ["M160 402.7V32c0-17.7 14.3-32 32-32s32 14.3 32 32V402.7l-32 32-32-32z", "M169.4 502.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 434.7 86.6 329.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128z"]],
    "tent-arrow-down-to-line": [640, 512, [], "e57e", ["M403.4 134.5c-11.5-8.7-27.3-8.7-38.8 0l-168 128c-6.6 5-11 12.5-12.3 20.7l-24 160-.7 4.7H384V320l76.8 128H608c.1 0 .2 0 .4 0l-.7-4.7-24-160c-1.2-8.2-5.6-15.7-12.3-20.7l-168-128z", "M240.1 145.8c9.9-8.9 10.7-24 1.8-33.9s-24-10.7-33.9-1.8l-39.9 36L168 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 122.1-39.9-36c-9.9-8.9-25-8.1-33.9 1.8s-8.1 25 1.8 33.9l80 72c9.1 8.2 23 8.2 32.1 0l80-72zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"]],
    "certificate": [512, 512, [], "f0a3", ["M211 7.3C205 1 196-1.4 187.6 .8s-14.9 8.9-17.1 17.3L154.7 80.6l-62-17.5c-8.4-2.4-17.4 0-23.5 6.1s-8.5 15.1-6.1 23.5l17.5 62L18.1 170.6c-8.4 2.1-15 8.7-17.3 17.1S1 205 7.3 211l46.2 45L7.3 301C1 307-1.4 316 .8 324.4s8.9 14.9 17.3 17.1l62.5 15.8-17.5 62c-2.4 8.4 0 17.4 6.1 23.5s15.1 8.5 23.5 6.1l62-17.5 15.8 62.5c2.1 8.4 8.7 15 17.1 17.3s17.3-.2 23.4-6.4l45-46.2 45 46.2c6.1 6.2 15 8.7 23.4 6.4s14.9-8.9 17.1-17.3l15.8-62.5 62 17.5c8.4 2.4 17.4 0 23.5-6.1s8.5-15.1 6.1-23.5l-17.5-62 62.5-15.8c8.4-2.1 15-8.7 17.3-17.1s-.2-17.4-6.4-23.4l-46.2-45 46.2-45c6.2-6.1 8.7-15 6.4-23.4s-8.9-14.9-17.3-17.1l-62.5-15.8 17.5-62c2.4-8.4 0-17.4-6.1-23.5s-15.1-8.5-23.5-6.1l-62 17.5L341.4 18.1c-2.1-8.4-8.7-15-17.1-17.3S307 1 301 7.3L256 53.5 211 7.3z", ""]],
    "crystal-ball": [448, 512, [], "e362", ["M362.6 400c52-41 85.4-104.6 85.4-176C448 100.3 347.7 0 224 0S0 100.3 0 224c0 71.4 33.4 135 85.4 176H362.6zM152.5 84.3c2.6-7 12.4-7 15 0l9.8 26.4 26.4 9.8c7 2.6 7 12.4 0 15l-26.4 9.8-9.8 26.4c-2.6 7-12.4 7-15 0l-9.8-26.4-26.4-9.8c-7-2.6-7-12.4 0-15l26.4-9.8 9.8-26.4zm159 48l18.4 49.8 49.8 18.4c7 2.6 7 12.4 0 15l-49.8 18.4-18.4 49.8c-2.6 7-12.4 7-15 0l-18.4-49.8-49.8-18.4c-7-2.6-7-12.4 0-15l49.8-18.4 18.4-49.8c2.6-7 12.4-7 15 0z", "M362.6 400H85.4L21.7 473.4c-3.7 4.2-5.7 9.7-5.7 15.3C16 501.6 26.4 512 39.3 512H408.7c12.9 0 23.3-10.4 23.3-23.3c0-5.6-2-11-5.7-15.3L362.6 400z"]],
    "reply-all": [576, 512, ["mail-reply-all"], "f122", ["M205 34.8c11.5 5.1 19 16.6 19 29.2v43.3l-85.4 76.9c-6.7 6.1-10.6 14.7-10.6 23.8s3.9 17.7 10.6 23.8L224 308.7V352c0 12.6-7.4 24.1-19 29.2s-25 3-34.4-5.4l-160-144C3.9 225.7 0 217.1 0 208s3.9-17.7 10.6-23.8l160-144c9.4-8.5 22.9-10.6 34.4-5.4z", "M333 34.8c11.5 5.1 19 16.6 19 29.2v64h48c97.2 0 176 78.8 176 176c0 113.3-81.5 163.9-100.2 174.1c-2.5 1.4-5.3 1.9-8.1 1.9c-10.9 0-19.7-8.9-19.7-19.7c0-7.5 4.3-14.4 9.8-19.5c9.4-8.8 22.2-26.4 22.2-56.7c0-53-43-96-96-96H352v64c0 12.6-7.4 24.1-19 29.2s-25 3-34.4-5.4l-160-144c-6.7-6.1-10.6-14.7-10.6-23.8s3.9-17.7 10.6-23.8l160-144c9.4-8.5 22.9-10.6 34.4-5.4z"]],
    "suitcase": [512, 512, [129523], "f0f2", ["M96 96h32V480H96V96zm288 0h32V480H384V96z", "M176 56V96H336V56c0-4.4-3.6-8-8-8H184c-4.4 0-8 3.6-8 8zM128 96V56c0-30.9 25.1-56 56-56H328c30.9 0 56 25.1 56 56V96v32V480H128V128 96zM64 96H96V480H64c-35.3 0-64-28.7-64-64V160c0-35.3 28.7-64 64-64zM448 480H416V96h32c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64z"]],
    "person-skating": [448, 512, ["skating"], "f7c5", ["M135.2 478.3c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2l-6.2 3.1c-9.2 4.6-20.4 2.8-27.7-4.5L27.3 388.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l59.6 59.6c17 17 43.1 21.3 64.6 10.5l6.2-3.1zm280.4-10.4c2.1-8.6-3.1-17.3-11.6-19.4s-17.3 3.1-19.4 11.6l-.4 1.7c-2.7 10.7-12.3 18.2-23.3 18.2H272c-8.8 0-16 7.2-16 16s7.2 16 16 16h88.8c25.7 0 48.1-17.5 54.3-42.4l.4-1.7z", "M352 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM128 128c0-17.7 14.3-32 32-32H319.4c43.6 0 64.6 53.4 32.8 83.1l-74.4 69.4 60.2 60.2c9 9 14.1 21.2 14.1 33.9V416c0 17.7-14.3 32-32 32s-32-14.3-32-32V349.3l-77.9-77.8c-26.6-26.6-24.6-70.3 4.3-94.4l20.4-17H160c-17.7 0-32-14.3-32-32zM81.4 353.4l86.9-86.9c4.6 10 11 19.3 19.3 27.5l21.8 21.8-82.7 82.7c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3z"]],
    "star-shooting": [512, 512, [127776], "e036", ["M313 7c-9.4-9.4-24.6-9.4-33.9 0L231 55c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48c9.4-9.4 9.4-24.6 0-33.9zM505 199c-9.4-9.4-24.6-9.4-33.9 0l-48 48c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48c9.4-9.4 9.4-24.6 0-33.9zM505 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L327 151c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L505 41z", "M213.4 157.4c-8.8-17.9-34.3-17.9-43.1 0l-46.3 94L20.5 266.5C.9 269.3-7 293.5 7.2 307.4l74.9 73.2L64.5 483.9c-3.4 19.6 17.2 34.6 34.8 25.3l92.6-48.8 92.6 48.8c17.6 9.3 38.2-5.7 34.8-25.3L301.6 380.6l74.9-73.2c14.2-13.9 6.4-38.1-13.3-40.9L259.7 251.4l-46.3-94z"]],
    "binary-lock": [640, 512, [], "e33d", ["M336 32c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2V160H256c-17.7 0-32 14.3-32 32s14.3 32 32 32h48 48c17.7 0 32-14.3 32-32s-14.3-32-32-32H336V32zM112 320c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16C5.1 311.2-3.9 329.4 1.7 346.1s23.7 25.8 40.5 20.2l5.9-2V448H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H80h48c17.7 0 32-14.3 32-32s-14.3-32-32-32H112V320zM0 64v96c0 35.3 28.7 64 64 64h64c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64zm128 0v96H64V64h64zM256 288c-35.3 0-64 28.7-64 64v96c0 35.3 28.7 64 64 64h64c35.3 0 64-28.7 64-64V352c0-35.3-28.7-64-64-64H256zm0 64h64v96H256V352z", "M496 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "filter-circle-dollar": [576, 512, ["funnel-dollar"], "f662", ["M40 0C24.5 0 10.5 8.9 3.9 22.9S-.7 53.4 9 65.3L192 288.9V368c0 10.1 4.7 19.6 12.8 25.6l64 48c1.5 1.1 3 2.1 4.7 2.9C262.3 421.4 256 395.4 256 368c0-85 60.2-155.9 140.4-172.4L503 65.3c9.8-12 11.8-28.5 5.2-42.5S487.5 0 472 0H40z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM408.1 339l0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2v10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16V438.1c-8.6-1.7-16.7-4.3-23.7-6.6l0 0c-1.7-.6-3.4-1.1-5-1.6c-8.4-2.6-13.2-11.6-10.5-20s11.6-13.2 20-10.5c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3V288c0-8.8 7.2-16 16-16s16 7.2 16 16v9.4c6.3 .9 12.3 2.3 17.9 3.7c8.6 2.1 13.8 10.8 11.7 19.4s-10.8 13.8-19.4 11.7c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"]],
    "camera-retro": [512, 512, [128247], "f083", ["M0 128v32H256 512V96c0-35.3-28.7-64-64-64H271.1c-9.9 0-19.7 2.3-28.6 6.8L192 64H64C28.7 64 0 92.7 0 128z", "M64 48c0-8.8 7.2-16 16-16h64c8.8 0 16 7.2 16 16V64H64V48zM0 416V160H512V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64zm256-16a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"]],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", ["M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM385 281c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-71 71V136c0-13.3-10.7-24-24-24s-24 10.7-24 24V318.1l-71-71c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L239 393c9.4 9.4 24.6 9.4 33.9 0L385 281z", "M239 393c9.4 9.4 24.6 9.4 33.9 0L385 281c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-71 71V136c0-13.3-10.7-24-24-24s-24 10.7-24 24V318.1l-71-71c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L239 393z"]],
    "comment-pen": [512, 512, ["comment-edit"], "f4ae", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zm84.8-293c14.7 14.7 14.7 38.6 0 53.3l-14.9 14.9L272.6 170 287.5 155c14.7-14.7 38.6-14.7 53.3 0zM178.1 264.5L250 192.6l53.3 53.3-71.9 71.9c-4.1 4.1-9.2 7-14.9 8.4l-36.6 9.2c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l9.2-36.7c1.4-5.6 4.3-10.8 8.4-14.9z", "M287.5 155L272.6 170l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3s-38.6-14.7-53.3 0zM250 192.6l-71.9 71.9c-4.1 4.1-7 9.2-8.4 14.9L160.5 316c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L250 192.6z"]],
    "file-import": [512, 512, ["arrow-right-to-file"], "f56f", ["M128 64c0-35.3 28.7-64 64-64H352V128c0 17.7 14.3 32 32 32H512V448c0 35.3-28.7 64-64 64H192c-35.3 0-64-28.7-64-64V336H302.1l-39 39c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l39 39H128V64z", "M512 160L352 0V128c0 17.7 14.3 32 32 32H512zM297 215c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l39 39H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H302.1l-39 39c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9l-80-80z"]],
    "banjo": [512, 512, [129685], "f8a3", ["M24 320a168 168 0 1 1 336 0A168 168 0 1 1 24 320zm280 0A112 112 0 1 0 80 320a112 112 0 1 0 224 0zM155.3 308.7l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z", "M465 7c-9.4-9.4-24.6-9.4-33.9 0L383 55c-2.4 2.4-4.3 5.3-5.5 8.5l-15.4 41L286 180.7c2.2 1.5 4.4 3.1 6.6 4.7c12.9 9.6 24.3 21.1 33.9 33.9c1.6 2.2 3.2 4.4 4.7 6.6l76.1-76.1 41-15.4c3.2-1.2 6.1-3.1 8.5-5.5l48-48c9.4-9.4 9.4-24.6 0-33.9L465 7zM192 128c-13.3 0-24 10.7-24 24v1.7c7.8-1.1 15.9-1.7 24-1.7s16.2 .6 24 1.7V152c0-13.3-10.7-24-24-24zM360 320c0 8.1-.6 16.2-1.7 24H360c13.3 0 24-10.7 24-24s-10.7-24-24-24h-1.7c1.1 7.8 1.7 15.9 1.7 24zM292.6 454.6l1.2 1.2c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-1.2-1.2c-9.6 12.9-21.1 24.3-33.9 33.9zM192 488c-8.1 0-16.2-.6-24-1.7V488c0 13.3 10.7 24 24 24s24-10.7 24-24v-1.7c-7.8 1.1-15.9 1.7-24 1.7zM57.4 420.6l-1.2 1.2c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l1.2-1.2c-12.9-9.6-24.3-21.1-33.9-33.9zM24 320c0-8.1 .6-16.2 1.7-24H24c-13.3 0-24 10.7-24 24s10.7 24 24 24h1.7c-1.1-7.8-1.7-15.9-1.7-24zM91.4 185.4l-1.2-1.2c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l1.2 1.2c9.6-12.9 21.1-24.3 33.9-33.9zm41.3 123.2c-6.2 6.2-6.2 16.4 0 22.6l48 48c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-48-48c-6.2-6.2-16.4-6.2-22.6 0z"]],
    "square-arrow-up-right": [448, 512, ["external-link-square"], "f14c", ["M384 32c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384zM160 144c-13.3 0-24 10.7-24 24s10.7 24 24 24h94.1L119 327c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l135-135V328c0 13.3 10.7 24 24 24s24-10.7 24-24V168c0-13.3-10.7-24-24-24H160z", "M312 144H160c-13.3 0-24 10.7-24 24s10.7 24 24 24h94.1L119 327c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l135-135V328c0 13.3 10.7 24 24 24s24-10.7 24-24V168c0-13.3-10.7-24-24-24z"]],
    "light-emergency-on": [640, 512, [], "e420", ["M320 32c-88.4 0-160 71.6-160 160V352H480V192c0-88.4-71.6-160-160-160zM240 192c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80z", "M69.3 36c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3l48 32c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3l-48-32zM597.3 76c11-7.4 14-22.3 6.7-33.3s-22.3-14-33.3-6.7l-48 32c-11 7.4-14 22.3-6.7 33.3s22.3 14 33.3 6.7l48-32zM24 192c-13.3 0-24 10.7-24 24s10.7 24 24 24H88c13.3 0 24-10.7 24-24s-10.7-24-24-24H24zm528 0c-13.3 0-24 10.7-24 24s10.7 24 24 24h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H552zM128 352c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H512c17.7 0 32-14.3 32-32V384c0-17.7-14.3-32-32-32H128z"]],
    "kerning": [640, 512, [], "f86f", ["M17.7 99.4c15.8-7.9 35-1.5 42.9 14.3L160 312.4l99.4-198.8c7.9-15.8 27.1-22.2 42.9-14.3s22.2 27.1 14.3 42.9l-128 256C183.2 409.2 172.1 416 160 416s-23.2-6.8-28.6-17.7l-128-256c-7.9-15.8-1.5-35 14.3-42.9zm320 313.2c-15.8-7.9-22.2-27.1-14.3-42.9l128-256C456.8 102.8 467.9 96 480 96s23.2 6.8 28.6 17.7l128 256c7.9 15.8 1.5 35-14.3 42.9s-35 1.5-42.9-14.3L556.2 352H403.8l-23.2 46.3c-7.9 15.8-27.1 22.2-42.9 14.3zM524.2 288L480 199.6 435.8 288h88.4z", "M447.2 1.7c7.9 4 11.1 13.6 7.2 21.5l-240 480c-4 7.9-13.6 11.1-21.5 7.2s-11.1-13.6-7.2-21.5l240-480c4-7.9 13.6-11.1 21.5-7.2z"]],
    "box-open": [640, 512, [], "f49e", ["M17.2 125.5c-9 17.9 .6 39.6 19.8 45.1l163.3 46.7c13.9 4 28.8-1.9 36.2-14.3L320 64 75.2 33.4c-6.7-.8-13.3 2.7-16.3 8.7L17.2 125.5zm605.5 0L581.1 42.1c-3-6.1-9.6-9.6-16.3-8.7L320 64l83.4 139c7.4 12.4 22.3 18.3 36.2 14.3l163.3-46.7c19.3-5.5 28.8-27.2 19.8-45.1z", "M320 64L236.6 203c-7.4 12.4-22.3 18.3-36.2 14.3L64 178.3V378.5c0 22 15 41.2 36.4 46.6l204.1 51c10.2 2.6 20.9 2.6 31 0l204.1-51c21.4-5.3 36.4-24.5 36.4-46.6V178.3l-136.4 39c-13.9 4-28.8-1.9-36.2-14.3L320 64z"]],
    "square-f": [448, 512, [], "e270", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm88 96H296c13.3 0 24 10.7 24 24s-10.7 24-24 24H176v64h88c13.3 0 24 10.7 24 24s-10.7 24-24 24H176v72c0 13.3-10.7 24-24 24s-24-10.7-24-24V264 152c0-13.3 10.7-24 24-24z", "M128 152c0-13.3 10.7-24 24-24H296c13.3 0 24 10.7 24 24s-10.7 24-24 24H176v64h88c13.3 0 24 10.7 24 24s-10.7 24-24 24H176v72c0 13.3-10.7 24-24 24s-24-10.7-24-24V264 152z"]],
    "scroll": [576, 512, [128220], "f70e", ["M128 96V400c0 44.2 35.8 80 80 80s80-35.8 80-80V384c0-17.7 14.3-32 32-32H480V96c0-35.3-28.7-64-64-64H64c35.3 0 64 28.7 64 64z", "M128 160H32c-17.7 0-32-14.3-32-32V96C0 60.7 28.7 32 64 32s64 28.7 64 64v64zM288 400V384c0-17.7 14.3-32 32-32H544c17.7 0 32 14.3 32 32c0 53-43 96-96 96H208c44.2 0 80-35.8 80-80z"]],
    "spa": [576, 512, [], "f5bb", ["M183.1 235.3c44 27.1 80.3 65.5 104.9 111.6c24.5-46 60.9-84.5 104.9-111.6c-19.6-113-73.8-178.8-91.3-197.7C298 33.9 293.1 32 288 32s-10 1.9-13.5 5.6c-17.5 18.8-71.8 84.7-91.3 197.7z", "M267.9 480H288h20.1C456.1 480 576 360.1 576 212.1c0-11.1-9-20.1-20.1-20.1H546c-110.8 0-208.5 62-258 154.9C238.5 254 140.8 192 30 192H20.1C9 192 0 201 0 212.1C0 360.1 119.9 480 267.9 480z"]],
    "arrow-left-from-line": [448, 512, [8612, "arrow-from-right"], "f344", ["M416 448c-17.7 0-32-14.3-32-32l0-320c0-17.7 14.3-32 32-32s32 14.3 32 32l0 320c0 17.7-14.3 32-32 32z", "M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L109.3 224l66.7 0 112 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-112 0-66.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128z"]],
    "strawberry": [512, 512, [], "e32b", ["M192.2 64C96.2 64 0 160 0 336C0 464 48 512 176 512c176 0 272-96 272-192c0-32.8-12.5-65.5-37.5-90.5l-128-128C257.6 76.6 224.9 64.1 192.2 64zm-10.8 74.5c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm55.3 98.3c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-32 96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-32 96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm104.7-66.3c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm32-96c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm55.3 98.3c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-224-96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-23.3 61.7c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7z", "M481.5 1.9c12.2 5.2 17.8 19.3 12.6 31.5c-13.4 31.2-36.9 59-56.3 78.7c32.8 1.8 57.4 18 68.2 26.6c4 3.2 6 8.1 6 13.2s-2 10-6 13.3C495 174.4 469.7 192 440 192c-40 0-55.3-15.3-80-40s-40-40-40-80c0-29.7 17.6-55 26.7-66c3.3-4 8.2-6 13.3-6s10 2 13.2 6C382.3 17.4 400 44.3 400 80c0 .7 0 1.4 0 2.1c.7-.7 1.4-1.3 2-2c18.2-18.2 37.7-41.7 47.9-65.5c5.2-12.2 19.3-17.8 31.5-12.6zm-300 136.6c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm55.3 98.3c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-32 96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-32 96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm104.7-66.3c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm32-96c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm55.3 98.3c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-224-96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-23.3 61.7c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7z"]],
    "location-pin-lock": [512, 512, [], "e51f", ["M256 446.8c-15.3 20.6-29.3 38.6-40.3 52.3c-12.3 15.3-35.1 15.3-47.4 0C117 435 0 279.4 0 192C0 86 86 0 192 0c95.7 0 175 70 189.6 161.5C328.5 170.3 288 216.4 288 272v24.6c-19.1 11.1-32 31.7-32 55.4v94.8zM256 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z", "M368 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H320c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "pause": [320, 512, [9208], "f04c", ["M48 64C21.5 64 0 85.5 0 112V400c0 26.5 21.5 48 48 48H80c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48H48zm192 0c-26.5 0-48 21.5-48 48V400c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48H240z", ""]],
    "clock-eight-thirty": [512, 512, [], "e346", ["M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V300.8L173.3 340c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l96-64c7.4-4.9 16.8-5.4 24.6-1.2S280 247.1 280 256V392c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M256 416c-13.3 0-24-10.7-24-24V300.8L173.3 340c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l96-64c7.4-4.9 16.8-5.4 24.6-1.2S280 247.1 280 256V392c0 13.3-10.7 24-24 24z"]],
    "plane-engines": [576, 512, [9992, "plane-alt"], "f3de", ["M368 192L265.3 15.9C259.5 6 249 0 237.6 0H181.3C170.7 0 163 10.2 166 20.5L216 192H368zm0 128H216L166 491.5c-3 10.2 4.7 20.5 15.4 20.5h56.3c11.4 0 21.9-6 27.6-15.9L368 320z", "M576 256c0-35-59.5-64-93.7-64L112 192 68.8 134.4c-3-4-7.8-6.4-12.8-6.4l-42 0c-7.8 0-14 6.3-14 14c0 1.3 .2 2.6 .5 3.9l22.7 79.3C9.8 229 0 241.4 0 256s9.8 27 23.2 30.8L.5 366.1c-.4 1.3-.5 2.6-.5 3.9c0 7.8 6.3 14 14 14l42 0c5 0 9.8-2.4 12.8-6.4L112 320l370.3 0c34.2 0 93.7-28 93.7-64zM329.8 126.5C342.7 122.3 352 110.3 352 96c0-17.7-14.3-32-32-32l-26.7 0 36.4 62.5zm0 259L293.3 448l26.7 0c17.7 0 32-14.3 32-32c0-14.3-9.3-26.3-22.2-30.5z"]],
    "hill-avalanche": [576, 512, [], "e507", ["M439.7 401.9c34.2 23.1 81.1 19.5 111.4-10.8c34.4-34.4 34.4-90.1 0-124.4s-90.1-34.4-124.5 0l33.9 33.9c15.6-15.6 40.9-15.6 56.6 0s15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-81.7-81.7C401.2 261.3 416 236.4 416 208c0-33.9-21.1-62.9-50.9-74.5c1.9-6.8 2.9-14 2.9-21.5c0-44.2-35.8-80-80-80c-27.3 0-51.5 13.7-65.9 34.6C216.3 46.6 197.9 32 176 32c-26.5 0-48 21.5-48 48c0 4 .5 7.9 1.4 11.6L439.7 401.9zM480 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M54.6 73.4c-9.2-9.2-22.9-11.9-34.9-6.9S0 83.1 0 96V480c0 17.7 14.3 32 32 32H416c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-384-384z"]],
    "temperature-empty": [320, 512, ["temperature-0", "thermometer-0", "thermometer-empty"], "f2cb", ["M160 64c-26.5 0-48 21.5-48 48V276.5c0 17.3-7.1 31.9-15.3 42.5C86.2 332.6 80 349.5 80 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-18.5-6.2-35.4-16.7-48.9c-8.2-10.6-15.3-25.2-15.3-42.5V112c0-26.5-21.5-48-48-48zM48 112C48 50.2 98.1 0 160 0s112 50.1 112 112V276.5c0 .1 .1 .3 .2 .6c.2 .6 .8 1.6 1.7 2.8c18.9 24.4 30.1 55 30.1 88.1c0 79.5-64.5 144-144 144S16 447.5 16 368c0-33.2 11.2-63.8 30.1-88.1c.9-1.2 1.5-2.2 1.7-2.8c.1-.3 .2-.5 .2-.6V112z", "M112 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"]],
    "bomb": [512, 512, [128163], "f1e2", ["M504.8 69.2L459.1 52.4 442.6 6.5C440.7 2.6 436.5 0 432.1 0s-8.5 2.6-10.4 6.5L405.2 52.4l-46 16.8c-4.3 1.6-7.3 5.9-7.2 10.4c0 4.5 3 8.7 7.2 10.2l45.7 16.8 16.8 45.8c1.5 4.4 5.8 7.5 10.4 7.5s8.9-3.1 10.4-7.5l16.5-45.8 45.7-16.8c4.2-1.5 7.2-5.7 7.2-10.2c0-4.6-3-8.9-7.2-10.4z", "M281.4 105.4c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3l-2.9 2.9c7.9 22 12.2 45.7 12.2 70.5c0 114.9-93.1 208-208 208S0 418.9 0 304S93.1 96 208 96c24.7 0 48.5 4.3 70.5 12.3l2.9-2.9zM96 296c0-57.4 46.6-104 104-104h8c8.8 0 16-7.2 16-16s-7.2-16-16-16h-8c-75.1 0-136 60.9-136 136v8c0 8.8 7.2 16 16 16s16-7.2 16-16v-8z"]],
    "gauge-low": [512, 512, ["tachometer-alt-slow"], "f627", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-.6 0-1.3 0-1.9 0L190 142.3c-5.3-12.1-19.5-17.6-31.6-12.3s-17.6 19.5-12.3 31.6l64.1 145.7C198.9 318.9 192 334.6 192 352c0 35.3 28.7 64 64 64zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M190 142.3c-5.3-12.1-19.5-17.6-31.6-12.3s-17.6 19.5-12.3 31.6l64.1 145.7C198.9 318.9 192 334.6 192 352c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-.6 0-1.3 0-1.9 0L190 142.3z"]],
    "registered": [512, 512, [174], "f25d", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 152c0-13.3 10.7-24 24-24h88c44.2 0 80 35.8 80 80c0 28-14.4 52.7-36.3 67l34.1 75.1c5.5 12.1 .1 26.3-11.9 31.8s-26.3 .1-31.8-11.9L268.9 288H208v72c0 13.3-10.7 24-24 24s-24-10.7-24-24V264 152zm48 88h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H208v64z", "M184 128c-13.3 0-24 10.7-24 24V264v96c0 13.3 10.7 24 24 24s24-10.7 24-24V288h60.9l37.2 81.9c5.5 12.1 19.7 17.4 31.8 11.9s17.4-19.7 11.9-31.8L315.7 275c21.8-14.3 36.3-39 36.3-67c0-44.2-35.8-80-80-80H184zm88 112H208V176h64c17.7 0 32 14.3 32 32s-14.3 32-32 32z"]],
    "trash-can-plus": [448, 512, [], "e2ac", ["M416 96H32V448c0 35.3 28.7 64 64 64H352c35.3 0 64-28.7 64-64V96zM200 376V312H136c-13.3 0-24-10.7-24-24s10.7-24 24-24h64V200c0-13.3 10.7-24 24-24s24 10.7 24 24v64h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H248v64c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM200 376V312H136c-13.3 0-24-10.7-24-24s10.7-24 24-24h64V200c0-13.3 10.7-24 24-24s24 10.7 24 24v64h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H248v64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm80 256h64c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16H80c-8.8 0-16-7.2-16-16c0-44.2 35.8-80 80-80zm-32-96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256-32H496c8.8 0 16 7.2 16 16s-7.2 16-16 16H368c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64H496c8.8 0 16 7.2 16 16s-7.2 16-16 16H368c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64H496c8.8 0 16 7.2 16 16s-7.2 16-16 16H368c-8.8 0-16-7.2-16-16s7.2-16 16-16z", "M176 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-44.2 0-80 35.8-80 80c0 8.8 7.2 16 16 16H272c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80H144z"]],
    "scale-unbalanced-flip": [640, 512, ["balance-scale-right"], "f516", ["M117.9 62.4c-16.8-5.6-25.8-23.7-20.2-40.5s23.7-25.8 40.5-20.2l113 37.7C265 15.8 290.7 0 320 0c44.2 0 80 35.8 80 80c0 3-.2 5.9-.5 8.8l122.6 40.9c16.8 5.6 25.8 23.7 20.2 40.5s-23.7 25.8-40.5 20.2L366.4 145.2c-4.5 3.2-9.3 5.9-14.4 8.2V480c0 17.7-14.3 32-32 32H128c-17.7 0-32-14.3-32-32s14.3-32 32-32H288V153.3c-21-9.2-37.2-27-44.2-49l-125.9-42z", "M128 163.8L55.6 288H200.4L128 163.8zM254 305.1C243.2 350 190.9 384 128 384S12.8 350 2 305.1c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1zm256.9-13.3L438.4 416H583.3L510.8 291.8zm126 141.3C626 478 573.7 512 510.8 512s-115.2-34-126-78.9c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1z"]],
    "globe-snow": [448, 512, [], "f7a3", ["M448 224c0 71.4-33.4 135-85.4 176H256V352h64c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4L262.6 256H288c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-64-64c-6.2-6.2-16.4-6.2-22.6 0l-64 64c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9h25.4l-68.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9h64v48H85.4C33.4 359 0 295.4 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224zM256 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 112a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z", "M235.3 164.7c-6.2-6.2-16.4-6.2-22.6 0l-64 64c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9h25.4l-68.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9h64v48H85.4L21.7 473.4c-3.7 4.2-5.7 9.7-5.7 15.3C16 501.6 26.4 512 39.3 512H408.7c12.9 0 23.3-10.4 23.3-23.3c0-5.6-2-11-5.7-15.3L362.6 400H256V352h64c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4L262.6 256H288c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-64-64z"]],
    "subscript": [512, 512, [], "f12c", ["M0 96C0 78.3 14.3 64 32 64H64c10.4 0 20.2 5.1 26.2 13.6L176 200.2 261.8 77.6c6-8.6 15.8-13.6 26.2-13.6h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H304.7L215.1 256l89.6 128H320c17.7 0 32 14.3 32 32s-14.3 32-32 32H288c-10.4 0-20.2-5.1-26.2-13.6L176 311.8 90.2 434.4C84.2 442.9 74.4 448 64 448H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H47.3l89.6-128L47.3 128H32C14.3 128 0 113.7 0 96z", "M464.8 292.8c9.4 5.8 15.2 16.1 15.2 27.2V448c17.7 0 32 14.3 32 32s-14.3 32-32 32H448 416c-17.7 0-32-14.3-32-32s14.3-32 32-32V368c-11.7 0-23-6.5-28.6-17.7c-7.9-15.8-1.5-35 14.3-42.9l32-16c9.9-5 21.7-4.4 31.1 1.4z"]],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", ["M227.7 11.7c15.6-15.6 40.9-15.6 56.6 0l216 216c15.6 15.6 15.6 40.9 0 56.6l-216 216c-15.6 15.6-40.9 15.6-56.6 0l-216-216c-15.6-15.6-15.6-40.9 0-56.6l216-216zm87.6 137c-4.6-4.6-11.5-5.9-17.4-3.5s-9.9 8.3-9.9 14.8v56H224c-35.3 0-64 28.7-64 64v48c0 13.3 10.7 24 24 24s24-10.7 24-24V280c0-8.8 7.2-16 16-16h64v56c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l80-80c6.2-6.2 6.2-16.4 0-22.6l-80-80z", "M297.9 145.2c6-2.5 12.9-1.1 17.4 3.5l80 80c6.2 6.2 6.2 16.4 0 22.6l-80 80c-4.6 4.6-11.5 5.9-17.4 3.5s-9.9-8.3-9.9-14.8V264H224c-8.8 0-16 7.2-16 16v48c0 13.3-10.7 24-24 24s-24-10.7-24-24V280c0-35.3 28.7-64 64-64h64V160c0-6.5 3.9-12.3 9.9-14.8z"]],
    "integral": [320, 512, [], "f667", ["M216 64c-13.3 0-24 10.7-24 24V424c0 48.6-39.4 88-88 88s-88-39.4-88-88v-8c0-17.7 14.3-32 32-32s32 14.3 32 32v8c0 13.3 10.7 24 24 24s24-10.7 24-24V88c0-48.6 39.4-88 88-88s88 39.4 88 88v8c0 17.7-14.3 32-32 32s-32-14.3-32-32V88c0-13.3-10.7-24-24-24z", ""]],
    "burst": [512, 512, [], "e4dc", ["M7 7c8.2-8.2 21-9.4 30.5-2.8l163.3 112 32.3-99.6C236.4 6.7 245.6 0 256 0s19.6 6.7 22.8 16.6l34.5 106.5 70.4-25.7c8.8-3.2 18.6-1 25.2 5.6s8.8 16.4 5.6 25.2l-25.7 70.4 106.5 34.5c9.9 3.2 16.6 12.4 16.6 22.8s-6.7 19.6-16.6 22.8L392.3 312.2l52.9 100.6c4.9 9.3 3.2 20.7-4.3 28.1s-18.8 9.2-28.1 4.3L312.2 392.3 278.8 495.4c-3.2 9.9-12.4 16.6-22.8 16.6s-19.6-6.7-22.8-16.6L199.8 392.3 99.2 445.2c-9.3 4.9-20.7 3.2-28.1-4.3s-9.2-18.8-4.3-28.1l52.9-100.6L16.6 278.8C6.7 275.6 0 266.4 0 256s6.7-19.6 16.6-22.8l99.6-32.3L4.2 37.6C-2.3 28-1.1 15.2 7 7zM285.1 185.8L256 96l-29.1 89.8L96 96l89.8 130.9L96 256l89.8 29.1-45.6 86.8 86.8-45.6L256 416l29.1-89.8 86.8 45.6-45.6-86.8L416 256l-89.8-29.1 23.6-64.7-64.7 23.6z", "M256 96l29.1 89.8 64.7-23.6-23.6 64.7L416 256l-89.8 29.1 45.6 86.8-86.8-45.6L256 416l-29.1-89.8-86.8 45.6 45.6-86.8L96 256l89.8-29.1L96 96l130.9 89.8L256 96z"]],
    "house-laptop": [640, 512, ["laptop-house"], "e066", ["M261.7 8.5c-12.3-11.3-31.2-11.3-43.4 0l-208 192c-9.7 8.9-12.9 22.9-8.1 35.2S18.8 256 32 256H64V368c0 26.5 21.5 48 48 48H272V288H208c-8.8 0-16-7.2-16-16V208c0-8.8 7.2-16 16-16h64c8.8 0 16 7.2 16 16v37.7c11.7-13.3 28.9-21.7 48-21.7H480c0-8.8-3.6-17.3-10.3-23.5l-208-192z", "M352 448H544V304H352V448zm-48 0V288c0-17.7 14.3-32 32-32H560c17.7 0 32 14.3 32 32V448h32c8.8 0 16 7.2 16 16c0 26.5-21.5 48-48 48H544 352 304c-26.5 0-48-21.5-48-48c0-8.8 7.2-16 16-16h32z"]],
    "face-tired": [512, 512, [128555, "tired"], "f5c8", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.7 328.7c22-22 53.9-40.7 91.3-40.7s69.3 18.7 91.3 40.7c11.1 11.1 20.1 23.4 26.4 35.4c6.2 11.7 10.3 24.4 10.3 35.9c0 5.2-2.6 10.2-6.9 13.2s-9.8 3.7-14.7 1.8l-20.5-7.7c-26.9-10.1-55.5-15.3-84.3-15.3h-3.2c-28.8 0-57.3 5.2-84.3 15.3L149.6 415c-4.9 1.8-10.4 1.2-14.7-1.8s-6.9-7.9-6.9-13.2c0-11.6 4.2-24.2 10.3-35.9c6.3-12 15.3-24.3 26.4-35.4zm-31.2-182l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6c0-9 9.6-14.7 17.5-10.5zM396 157.1c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z", "M116 157.1c0-9 9.6-14.7 17.5-10.5l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm280 0c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z"]],
    "money-bills": [640, 512, [], "e1f3", ["M48 120c0-13.3-10.7-24-24-24S0 106.7 0 120V360c0 66.3 53.7 120 120 120H520c13.3 0 24-10.7 24-24s-10.7-24-24-24H120c-39.8 0-72-32.2-72-72V120zM224 96c0 35.3-28.7 64-64 64v96c35.3 0 64 28.7 64 64H512c0-35.3 28.7-64 64-64V160c-35.3 0-64-28.7-64-64H224zm64 112a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z", "M160 32c-35.3 0-64 28.7-64 64V320c0 35.3 28.7 64 64 64H576c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H160zM512 96c0 35.3 28.7 64 64 64v96c-35.3 0-64 28.7-64 64H224c0-35.3-28.7-64-64-64V160c35.3 0 64-28.7 64-64H512z"]],
    "blinds-raised": [512, 512, [], "f8fd", ["M128 128H20.4C9.1 128 0 118.9 0 107.6c0-2.4 .4-4.7 1.2-7L32 16H480l30.8 84.6c.8 2.2 1.2 4.6 1.2 7c0 11.3-9.1 20.4-20.4 20.4H160V32H128v96zm0 32v64H20.1C9 224 0 215 0 203.9c0-2.6 .5-5.1 1.4-7.5L16 160H128zm32 64V160H496l14.6 36.4c1 2.4 1.4 4.9 1.4 7.5c0 11.1-9 20.1-20.1 20.1H160z", "M0 32C0 14.3 14.3 0 32 0H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H160V418.7c18.6 6.6 32 24.4 32 45.3c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V64H32C14.3 64 0 49.7 0 32z"]],
    "smog": [640, 512, [], "f75f", ["M640 392c0-13.3-10.7-24-24-24H280c-13.3 0-24 10.7-24 24s10.7 24 24 24H616c13.3 0 24-10.7 24-24zm-64 96c0-13.3-10.7-24-24-24H440c-13.3 0-24 10.7-24 24s10.7 24 24 24H552c13.3 0 24-10.7 24-24zm-192 0c0-13.3-10.7-24-24-24H24c-13.3 0-24 10.7-24 24s10.7 24 24 24H360c13.3 0 24-10.7 24-24zM200 368H96c-13.3 0-24 10.7-24 24s10.7 24 24 24H200c13.3 0 24-10.7 24-24s-10.7-24-24-24z", "M176 288C96.5 288 32 223.5 32 144S96.5 0 176 0c34.5 0 66.1 12.1 90.9 32.3C289.6 12.2 319.4 0 352 0c49.1 0 91.8 27.7 113.2 68.3C475 65.5 485.3 64 496 64c61.9 0 112 50.1 112 112s-50.1 112-112 112H468.7c-22.6 19.9-52.2 32-84.7 32s-62.1-12.1-84.7-32H176z"]],
    "ufo-beam": [576, 512, [], "e048", ["M288 192c110.8 0 144-53.3 144-53.3C432 74.7 385.9 0 288 0S144 74.7 144 138.7c0 0 33.2 53.3 144 53.3zM2.3 477.7c-5.7 12-.6 26.3 11.4 32s26.3 .6 32-11.4l92.2-194.7c-16.7-4-32.3-8.6-46.6-13.8L2.3 477.7zm528 20.5c5.7 12 20 17.1 32 11.4s17.1-20 11.4-32l-89-187.9c-14.2 5.2-29.9 9.8-46.6 13.8l92.2 194.7z", "M288 192c110.8 0 144-53.3 144-53.3c0-9.3-1-18.8-2.9-28.3C516.8 129.5 576 166.1 576 208c0 61.9-128.9 112-288 112S0 269.9 0 208c0-41.9 59.2-78.5 146.9-97.7c-2 9.5-2.9 19-2.9 28.3c0 0 33.2 53.3 144 53.3zM120 208a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm360 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM312 256a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-368c6.7 0 13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9s-12.5 14.4-22 14.4H152c-9.5 0-18.2-5.7-22-14.4s-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7z", "M273.6 151.7c-4.5-4.9-10.9-7.7-17.6-7.7s-13 2.8-17.6 7.7l-104 112c-6.5 7-8.2 17.2-4.4 25.9s12.5 14.4 22 14.4H360c9.5 0 18.2-5.7 22-14.4s2.1-18.9-4.4-25.9l-104-112z"]],
    "user-vneck-hair-long": [448, 512, [], "e463", ["M257.9 66.2C241 93.7 210.6 112 176 112H128l0 32c0 53 43 96 96 96s96-43 96-96l0-48h-8c-22.8 0-42.8-11.9-54.1-29.8z", "M176 112H128h0v32c0 53 43 96 96 96s96-43 96-96V128h0V96h-8c-22.8 0-42.8-11.9-54.1-29.8C241 93.7 210.6 112 176 112zm48 160H70.6C58.1 272 48 261.9 48 249.4c0-6 2.4-11.8 6.6-16l3.9-3.9c24-24 37.5-56.6 37.5-90.5V128h0C96 57.3 153.3 0 224 0c70.6 0 127.8 57.1 128 127.6v.8l0 .2V139c0 33.9 13.5 66.5 37.5 90.5l3.9 3.9c4.2 4.2 6.6 10 6.6 16c0 12.5-10.1 22.6-22.6 22.6H224zm-78.1 42.9L210.7 412c6.3 9.5 20.3 9.5 26.6 0l64.8-97.1c3.5-5.2 9.8-8 15.9-6.6c74.5 17.2 130 84 130 163.7v8c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32v-8c0-79.7 55.5-146.5 130-163.7c6.1-1.4 12.4 1.4 15.9 6.6z"]],
    "square-a-lock": [576, 512, [], "e44d", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64v65.1c-54.3 7.8-96 54.4-96 110.9v24.6c-9.9 5.7-18.1 14-23.8 24L245.8 141.9c-3.9-8.5-12.4-13.9-21.8-13.9s-17.9 5.4-21.8 13.9l-96 208c-5.6 12-.3 26.3 11.7 31.8s26.3 .3 31.8-11.7l12-26.1H286.2l12 26.1c4 8.8 12.7 13.9 21.8 13.9v96H64c-35.3 0-64-28.7-64-64V96zM264 296H184l40-86.7L264 296z", "M432 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H384c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "crutch": [512, 512, [], "f7f7", ["M297.4 9.4c12.5-12.5 32.8-12.5 45.3 0l160 160c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3z", "M201.4 153.4L298.7 56 344 101.3 269.3 176 336 242.7 410.7 168 456 213.3l-97.3 97.3c0 0-.1 .1-.1 .1s-.1 .1-.1 .1l-34.7 34.7c-12.9 12.9-29.2 21.9-47.1 25.8L169.1 395.2c-5.9 1.3-11.4 4.3-15.7 8.6L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l98.8-98.8c4.3-4.3 7.3-9.7 8.6-15.7l23.9-107.6c4-17.8 12.9-34.1 25.8-47.1l34.8-34.8zM224 221.3l-12.2 12.2c-4.3 4.3-7.3 9.7-8.6 15.7l-17 76.7 76.7-17c5.9-1.3 11.4-4.3 15.7-8.6L290.7 288 224 221.3z"]],
    "gas-pump-slash": [640, 512, [], "f5f4", ["M558.6 412.5C569.5 397.9 576 379.7 576 360V224 192 168 154.5c0-17-6.7-33.3-18.7-45.3L480 32c-8.8-8.8-23.2-8.8-32 0s-8.8 23.2 0 32l32 32v64c0 29.8 20.4 54.9 48 62V360c0 8.5-2.7 16.4-7.2 22.9l37.8 29.6zM384 275.7V64c0-35.3-28.7-64-64-64H160c-30.9 0-56.7 21.9-62.7 51L384 275.7zM96 171.6V416H384V398.5L96 171.6zM64 480c0 17.7 14.3 32 32 32H384c17.7 0 32-14.3 32-32s-14.3-32-32-32H96c-17.7 0-32 14.3-32 32z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "font-awesome": [448, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", ["M64 140.7c15.3-3 28.2-7.9 41.2-12.8c21.2-8 42.5-15.9 74-15.9c31.4 0 53 8 74.6 16c21.6 8 43.3 16 74.7 16c20.4 0 35.6-3 55.5-9.3v208c-19.9 6.3-35.1 9.3-55.5 9.3c-31.4 0-53.1-8-74.7-16c-21.6-8-43.3-16-74.6-16c-20.6 0-36.6 3.6-51.2 8.2v64c14.6-4.6 30.6-8.2 51.2-8.2c31.4 0 53 8 74.6 16c21.6 8 43.3 16 74.7 16s50-6.8 93.3-22.5c7.8-2.9 16.5-6 26.2-9.5V48c-9.7 3.5-18.4 6.6-26.2 9.5C378.6 73.2 360 80 328.5 80s-53.1-8-74.7-16c-21.6-8-43.3-16-74.6-16c-31.5 0-52.8 8-74 15.9c-13 4.9-25.9 9.7-41.2 12.8v64z", "M64 76.7V64c0-17.7-14.3-32-32-32S0 46.3 0 64V448c0 17.7 14.3 32 32 32s32-14.3 32-32V140.7v-64z"]],
    "cloud-arrow-up": [640, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", ["M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zm79-217c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39V392c0 13.3 10.7 24 24 24s24-10.7 24-24V257.9l39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0l-80 80z", "M223 297c-9.4-9.4-9.4-24.6 0-33.9l80-80c9.4-9.4 24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-39-39L344 392c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-134.1-39 39c-9.4 9.4-24.6 9.4-33.9 0z"]],
    "palette": [512, 512, [127912], "f53f", ["M512 256c0 .9 0 1.8 0 2.7c-.4 36.5-33.6 61.3-70.1 61.3H344c-26.5 0-48 21.5-48 48c0 3.4 .4 6.7 1 9.9c2.1 10.2 6.5 20 10.8 29.9c6.1 13.8 12.1 27.5 12.1 42c0 31.8-21.6 60.7-53.4 62c-3.5 .1-7 .2-10.6 .2C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256zM128 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z", "M224 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-96 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM384 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "transporter-4": [512, 512, [], "e2a5", ["M224 0c-8.8 0-16 7.2-16 16s7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H224zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H224zm-48 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zm-32 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H368c8.8 0 16-7.2 16-16s-7.2-16-16-16H144zm-32 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H400c8.8 0 16-7.2 16-16s-7.2-16-16-16H112zm64 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zM480 160l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L448 160l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7L448 192l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 192l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 160zM56.7 358.6c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 384 6.6 391.3C2.7 392.4 0 395.9 0 400s2.7 7.6 6.6 8.7L32 416l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 416l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 384l-7.3-25.4z", "M128 448c-17.7 0-32 14.3-32 32s14.3 32 32 32H384c17.7 0 32-14.3 32-32s-14.3-32-32-32H128z"]],
    "chart-mixed-up-circle-currency": [576, 512, [], "e5d8", ["M400 0c-17.7 0-32 14.3-32 32s14.3 32 32 32h28.8L319.4 151.5 211.2 70.4c-11.7-8.8-27.8-8.5-39.2 .6L12 199c-13.8 11-16 31.2-5 45s31.2 16 45 5L192.6 136.5l108.2 81.1c11.7 8.8 27.8 8.5 39.2-.6L480 105v39c0 17.7 14.3 32 32 32s32-14.3 32-32V32c0-17.7-14.3-32-32-32H400zM160 256V448c0 17.7 14.3 32 32 32s32-14.3 32-32V256c0-17.7-14.3-32-32-32s-32 14.3-32 32zM32 352v96c0 17.7 14.3 32 32 32s32-14.3 32-32V352c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm25.4-169.4a35.9 35.9 0 1 0 -50.7 50.7 35.9 35.9 0 1 0 50.7-50.7zM396.7 426l-17.3 17.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L374 403.3c-13.2-21.6-13.2-49.1 0-70.7l-17.3-17.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L396.7 310c21.6-13.2 49.1-13.2 70.7 0l17.3-17.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L490 332.7c13.2 21.6 13.2 49.1 0 70.7l17.3 17.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L467.3 426c-21.6 13.2-49.1 13.2-70.7 0z"]],
    "objects-align-right": [512, 512, [], "e3bf", ["M384 112c0-26.5-21.5-48-48-48L48 64C21.5 64 0 85.5 0 112l0 64c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-64zm0 224c0-26.5-21.5-48-48-48l-160 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l160 0c26.5 0 48-21.5 48-48l0-64z", "M488 0c13.3 0 24 10.7 24 24l0 464c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-464c0-13.3 10.7-24 24-24z"]],
    "arrows-turn-right": [448, 512, [], "e4c0", ["M246.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L242.7 352H96c-53 0-96 43-96 96v32c0 17.7 14.3 32 32 32s32-14.3 32-32V448c0-17.7 14.3-32 32-32H242.7l-41.4 41.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3l-96-96z", "M342.6 9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.7 96H128C57.3 96 0 153.3 0 224v32c0 17.7 14.3 32 32 32s32-14.3 32-32V224c0-35.3 28.7-64 64-64H338.7l-41.4 41.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3l-96-96z"]],
    "vest": [448, 512, [], "e085", ["M224 88c-31.4 0-55.4-8.3-72.8-18.3L131.6 10.9C129.5 4.6 123.7 .3 117.1 0c.4 0 .8 0 1.2 0c18.8 0 34.1 9.7 44.1 18.8C171.6 27.2 190.8 40 224 40s52.4-12.8 61.7-21.2C295.7 9.7 311 0 329.7 0c.4 0 .8 0 1.2 0c-6.6 .3-12.4 4.6-14.6 10.9L296.8 69.7C279.4 79.7 255.4 88 224 88zM123.3 356.7c6.2 6.2 6.2 16.4 0 22.6l-48 48c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l48-48c6.2-6.2 16.4-6.2 22.6 0zm201.4 0c6.2-6.2 16.4-6.2 22.6 0l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6z", "M131.6 10.9C129.5 4.4 123.4 0 116.5 0H112C85.5 0 64 21.5 64 48v97.5c0 9.5-2.8 18.7-8.1 26.6L8.1 243.9C2.8 251.8 0 261.1 0 270.5V464c0 26.5 21.5 48 48 48H176c9.9 0 19-3 26.7-8.1C195.9 492.2 192 478.5 192 464V295.8c0-8.6 1.4-17.1 4.1-25.3l11-33.1L131.6 10.9zM224 295.8V464c0 26.5 21.5 48 48 48H400c26.5 0 48-21.5 48-48V270.5c0-9.5-2.8-18.7-8.1-26.6l-47.9-71.8c-5.3-7.9-8.1-17.1-8.1-26.6V48c0-26.5-21.5-48-48-48h-4.5c-6.9 0-13 4.4-15.2 10.9L226.5 280.6c-1.6 4.9-2.5 10-2.5 15.2zm123.3 60.9l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-246.6 0c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-48 48c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l48-48z"]],
    "pig": [640, 512, [128022], "f706", ["M513.5 32c8 0 14.5 6.5 14.5 14.5V78c0 19.7-9 37.8-23.6 49.7c6.4 4.9 12.7 10.1 18.6 15.7c17.6-15.9 28.5-38.6 29-63.3h40c8.8 0 16 7.2 16 16v16c0 32.8-24.6 59.8-56.3 63.5l6.8 9C570 200 585 212.5 602.2 221.1L608 224h8c13.3 0 24 10.7 24 24v96c0 13.3-10.7 24-24 24H572.5c-22.2 21.2-49.7 36.2-79.8 43.3l-13 45.5C475.8 470.5 463.3 480 449 480H416c-17.7 0-32-14.3-32-32V416H320 272v32c0 17.7-14.3 32-32 32H207c-14.3 0-26.8-9.5-30.8-23.2L155 382.4C110.3 358 80 310.5 80 256V240c0-88.4 71.6-160 160-160H362.4c14.5 0 28.8 1.3 42.7 3.9c8.1-19.5 25.4-34.4 47-39.1l58.4-12.5c1-.2 2-.3 3-.3zM476 256a20 20 0 1 0 0-40 20 20 0 1 0 0 40z", "M80 240c0-11 1.1-21.7 3.2-32H47.4c-8.5 0-15.4-6.9-15.4-15.4c0-7.1 4.8-13.3 11.7-15l8.2-2c8.6-2.1 13.8-10.8 11.6-19.4s-10.8-13.8-19.4-11.6l-8.2 2C14.8 151.8 0 170.8 0 192.6C0 218.8 21.2 240 47.4 240H80zm396 16a20 20 0 1 0 0-40 20 20 0 1 0 0 40z"]],
    "inbox-full": [512, 512, [], "e1ba", ["M121 96H391l48 192H387.8c-12.1 0-23.2 6.8-28.6 17.7l-14.3 28.6c-5.4 10.8-16.5 17.7-28.6 17.7H195.8c-12.1 0-23.2-6.8-28.6-17.7l-14.3-28.6c-5.4-10.8-16.5-17.7-28.6-17.7H73L121 96zm55 48c-8.8 0-16 7.2-16 16s7.2 16 16 16H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zm-32 80c-8.8 0-16 7.2-16 16s7.2 16 16 16H368c8.8 0 16-7.2 16-16s-7.2-16-16-16H144z", "M121 32C91.6 32 66 52 58.9 80.5L1.9 308.4C.6 313.5 0 318.7 0 323.9V416c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V323.9c0-5.2-.6-10.4-1.9-15.5l-57-227.9C446 52 420.4 32 391 32H121zm0 64H391l48 192H387.8c-12.1 0-23.2 6.8-28.6 17.7l-14.3 28.6c-5.4 10.8-16.5 17.7-28.6 17.7H195.8c-12.1 0-23.2-6.8-28.6-17.7l-14.3-28.6c-5.4-10.8-16.5-17.7-28.6-17.7H73L121 96z"]],
    "circle-envelope": [512, 512, ["envelope-circle"], "e10c", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM128 192c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32v9.3L264.7 255.6c-2.7 1.2-5.7 1.9-8.7 1.9s-5.9-.6-8.7-1.9L128 201.3V192zm149.9 92.7L384 236.5V320c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V236.5l106.1 48.3c6.9 3.1 14.3 4.8 21.9 4.8s15-1.6 21.9-4.8z", "M160 160c-17.7 0-32 14.3-32 32v9.3l119.3 54.3c2.7 1.2 5.7 1.9 8.7 1.9s5.9-.6 8.7-1.9L384 201.3V192c0-17.7-14.3-32-32-32H160zm224 76.5L277.9 284.7c-6.9 3.1-14.3 4.8-21.9 4.8s-15-1.6-21.9-4.8L128 236.5V320c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V236.5z"]],
    "triangle-person-digging": [640, 512, ["construction"], "f85d", ["M354.5 51.8C347.3 39.5 334.2 32 320 32s-27.3 7.5-34.5 19.8l-216 368c-7.3 12.4-7.3 27.7-.2 40.1S89.7 480 104 480H536c14.3 0 27.6-7.7 34.7-20.1s7-27.8-.2-40.1l-216-368zM216.9 304.7l15.6 9.8 64 40c4.7 2.9 7.5 8.1 7.5 13.6v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V376.9l-40.9-25.5-24.5 55.2c-3.6 8.1-13 11.7-21.1 8.1s-11.7-13-8.1-21.1l32-72 7.5-16.8zm112-45.7l19.7 49.2L402 339l16.3-27.2c2.9-4.8 8.1-7.8 13.7-7.8s10.8 2.9 13.7 7.8l48 80c3 4.9 3 11.1 .2 16.1s-8.2 8.1-13.9 8.1H384c-5.8 0-11.1-3.1-13.9-8.1s-2.8-11.2 .2-16.1l15.2-25.4L232 277.9c-3.8-2.2-6.6-5.9-7.6-10.2s-.2-8.8 2.3-12.5l4.2-6.4c10.3-15.5 27.7-24.8 46.3-24.8c22.7 0 43.2 13.8 51.6 34.9zM288 184a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z", "M288 184a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm40.8 74.9l19.7 49.2L402 339l16.3-27.2c2.9-4.8 8.1-7.8 13.7-7.8s10.8 2.9 13.7 7.8l48 80c3 4.9 3 11.1 .2 16.1s-8.2 8.1-13.9 8.1H384c-5.8 0-11.1-3.1-13.9-8.1s-2.8-11.2 .2-16.1l15.2-25.4L232 277.9c-3.8-2.2-6.6-5.9-7.6-10.2s-.2-8.8 2.3-12.5l4.2-6.4c10.3-15.5 27.7-24.8 46.3-24.8c22.7 0 43.2 13.8 51.6 34.9zm-96.3 55.5l64 40c4.7 2.9 7.5 8.1 7.5 13.6v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V376.9l-40.9-25.5-24.5 55.2c-3.6 8.1-13 11.7-21.1 8.1s-11.7-13-8.1-21.1l32-72 7.5-16.8 15.6 9.8z"]],
    "ferry": [576, 512, [], "e4ea", ["M269.5 421.9c11.1-7.9 25.9-7.9 37 0C329 437.4 356.5 448 384 448c26.9 0 55.3-10.8 77.4-26.1l0 0c11.9-8.5 28.1-7.8 39.2 1.7c14.4 11.9 32.5 21 50.6 25.2c17.2 4 27.9 21.2 23.9 38.4s-21.2 27.9-38.4 23.9c-24.5-5.7-44.9-16.5-58.2-25C449.5 501.7 417 512 384 512c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9c-33 0-65.5-10.3-94.5-25.8c-13.4 8.4-33.7 19.3-58.2 25c-17.2 4-34.4-6.7-38.4-23.9s6.7-34.4 23.9-38.4c18.1-4.2 36.2-13.3 50.6-25.2c11.1-9.4 27.3-10.1 39.2-1.7l0 0C136.7 437.2 165.1 448 192 448c27.5 0 55-10.6 77.5-26.1z", "M192 32H116.9C96.3 32 85.3 56.3 98.8 71.8L120 96H456l21.2-24.2C490.8 56.3 479.7 32 459.1 32H384c0-17.7-14.3-32-32-32H224c-17.7 0-32 14.3-32 32zm288 96H96c-17.7 0-32 14.3-32 32V283.5c0 13.3 4.2 26.3 11.9 37.2l51.4 71.9c1.9 1.1 3.8 2.2 5.6 3.5c15.5 10.7 34 18 51 19.9h16.6c18.2-1.9 35.8-9.7 50.6-19.9c22.1-15.5 51.6-15.5 73.7 0c15.8 10.9 33.7 18.1 50.8 19.9h16.5c17-1.8 35.6-9.2 51-19.9c1.8-1.3 3.6-2.4 5.5-3.5l51.4-71.9c7.8-10.9 11.9-23.9 11.9-37.2V160c0-17.7-14.3-32-32-32zm-32 64v96H128V192H448z"]],
    "bullseye-arrow": [512, 512, [127919], "f648", ["M335.2 244.7c.5 3.7 .8 7.5 .8 11.3c0 44.2-35.8 80-80 80s-80-35.8-80-80s35.8-80 80-80c3.8 0 7.6 .3 11.3 .8l31.2-31.2L293.7 117c-12-3.3-24.7-5-37.7-5c-79.5 0-144 64.5-144 144s64.5 144 144 144s144-64.5 144-144c0-13.1-1.7-25.7-5-37.7l-28.6-4.8-31.2 31.2zm110.1-20.8c1.8 10.4 2.7 21.1 2.7 32.1c0 106-86 192-192 192S64 362 64 256S150 64 256 64c10.9 0 21.6 .9 32.1 2.7l9.3-9.3 43.1-43.1C314 5 285.6 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512s256-114.6 256-256c0-29.6-5-58-14.3-84.5l-43.1 43.1-9.3 9.3z", "M331.2 146.9l-8.4-50.7c-1.7-10.2 1.6-20.6 8.9-27.9l51.2-51.2C391 9 404.7 11.9 409 22.5L432 80l57.5 23c10.7 4.3 13.5 18 5.4 26.2l-51.2 51.2c-7.3 7.3-17.7 10.6-27.9 8.9l-50.7-8.4L273 273c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l92.1-92.1z"]],
    "arrows-down-to-people": [640, 512, [], "e4b9", ["M360 200a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM184 296a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm312 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM200 441.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-36.3-67.5c1.7-1.7 3.2-3.6 4.3-5.8L264 345.5V400c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V345.5l26.9 49.9c1.2 2.2 2.6 4.1 4.3 5.8l-36.3 67.5c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L440 441.5V480c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V441.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3H486.2c-16.3 0-31.9 4.5-45.4 12.6l-33.6-62.3c-15.3-28.5-45.1-46.3-77.5-46.3H310.2c-32.4 0-62.1 17.8-77.5 46.3l-33.6 62.3c-13.5-8.1-29.1-12.6-45.4-12.6H134.2c-32.4 0-62.1 17.8-77.5 46.3L18.9 468.6c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L88 441.5V480c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V441.5z", "M144 0c-13.3 0-24 10.7-24 24V142.1L97 119c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23V24c0-13.3-10.7-24-24-24zM415 153l64 64c9.4 9.4 24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23V24c0-13.3-10.7-24-24-24s-24 10.7-24 24V142.1l-23-23c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9z"]],
    "seedling": [512, 512, [127793, "sprout"], "f4d8", ["M480 0c17.7 0 32 14.3 32 32c0 123.7-100.3 224-224 224h-2.3c-5.9-41.1-22.9-78.7-48-109.4C269.2 61 351.5 0 448 0h32z", "M32 64C14.3 64 0 78.3 0 96C0 219.7 100.3 320 224 320V480c0 17.7 14.3 32 32 32s32-14.3 32-32V320 288C288 164.3 187.7 64 64 64H32z"]],
    "clock-seven": [512, 512, [], "e350", ["M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zM232 120V248.7l-60 90c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l64-96c2.6-3.9 4-8.6 4-13.3V120c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M256 96c-13.3 0-24 10.7-24 24V248.7l-60 90c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l64-96c2.6-3.9 4-8.6 4-13.3V120c0-13.3-10.7-24-24-24z"]],
    "left-right": [512, 512, [8596, "arrows-alt-h"], "f337", ["M512 256c0-6.7-2.8-13-7.7-17.6l-112-104c-7-6.5-17.2-8.2-25.9-4.4s-14.4 12.5-14.4 22l0 56-96 0 0 96 96 0 0 56c0 9.5 5.7 18.2 14.4 22s18.9 2.1 25.9-4.4l112-104c4.9-4.5 7.7-10.9 7.7-17.6z", "M0 256c0-6.7 2.8-13 7.7-17.6l112-104c7-6.5 17.2-8.2 25.9-4.4s14.4 12.5 14.4 22l0 56 96 0 0 96-96 0 0 56c0 9.5-5.7 18.2-14.4 22s-18.9 2.1-25.9-4.4l-112-104C2.8 269 0 262.7 0 256z"]],
    "boxes-packing": [640, 512, [], "e4c7", ["M304 0c-26.5 0-48 21.5-48 48v80H368c26.5 0 48 21.5 48 48v32c0 20.9-13.4 38.7-32 45.3V496c0 5.6-1 11-2.7 16H592c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H304zM571.3 324.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L512 310.6V432c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-121.4-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l64-64c6.2-6.2 16.4-6.2 22.6 0l64 64z", "M16 160H368c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H16c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16zm16 96H352V480c0 17.7-14.3 32-32 32H64c-17.7 0-32-14.3-32-32V256zm96 80c0 8.8 7.2 16 16 16h96c8.8 0 16-7.2 16-16s-7.2-16-16-16H144c-8.8 0-16 7.2-16 16z"]],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", ["M512 256A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM231 127c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-71 71L376 232c13.3 0 24 10.7 24 24s-10.7 24-24 24l-182.1 0 71 71c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L119 273c-9.4-9.4-9.4-24.6 0-33.9L231 127z", "M119 273c-9.4-9.4-9.4-24.6 0-33.9L231 127c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-71 71L376 232c13.3 0 24 10.7 24 24s-10.7 24-24 24l-182.1 0 71 71c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L119 273z"]],
    "flashlight": [640, 512, [128294], "f8b8", ["M576 96c-112 0-192 64-192 64H48c-26.5 0-48 21.5-48 48v96c0 26.5 21.5 48 48 48H384s80 64 192 64V96zM224 256c0-17.7 14.3-32 32-32h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H256c-17.7 0-32-14.3-32-32z", "M608 96H576V416h32c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32zM256 224c-17.7 0-32 14.3-32 32s14.3 32 32 32h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H256z"]],
    "group-arrows-rotate": [512, 512, [], "e4f6", ["M222.7 32.2c5 16.9-4.6 34.8-21.5 39.8c-14.6 4.3-28.5 10.4-41.4 17.9c.2 2 .3 4.1 .3 6.1c0 35.3-28.7 64-64 64c-2.1 0-4.1-.1-6.1-.3c-7.5 12.9-13.6 26.8-17.9 41.4c-5 16.9-22.9 26.6-39.8 21.5s-26.6-22.9-21.5-39.8c6.4-21.5 15.5-41.8 27-60.6C34 114.3 32 105.4 32 96c0-35.3 28.7-64 64-64c9.4 0 18.3 2 26.3 5.6c18.7-11.5 39-20.6 60.6-27c16.9-5 34.8 4.6 39.8 21.5zm66.7 0c5-16.9 22.9-26.6 39.8-21.5c21.5 6.4 41.8 15.5 60.6 27c8-3.6 16.9-5.6 26.3-5.6c35.3 0 64 28.7 64 64c0 9.4-2 18.3-5.6 26.3c11.5 18.7 20.6 39 27 60.6c5 16.9-4.6 34.8-21.5 39.8s-34.8-4.6-39.8-21.5c-4.3-14.6-10.4-28.5-17.9-41.4c-2 .2-4.1 .3-6.2 .3c-35.3 0-64-28.7-64-64c0-2.1 .1-4.1 .3-6.1c-12.9-7.5-26.8-13.6-41.4-17.9c-16.9-5-26.6-22.9-21.5-39.8zM32.1 289.3c16.9-5 34.8 4.6 39.8 21.5c4.3 14.6 10.4 28.5 17.9 41.4c2-.2 4.1-.3 6.2-.3c35.3 0 64 28.7 64 64c0 2.1-.1 4.1-.3 6.2c12.9 7.5 26.8 13.6 41.4 17.9c16.9 5 26.6 22.9 21.5 39.8s-22.9 26.6-39.8 21.5c-21.5-6.4-41.8-15.5-60.6-27c-8 3.6-16.9 5.6-26.3 5.6c-35.3 0-64-28.7-64-64c0-9.4 2-18.3 5.6-26.3c-11.5-18.7-20.6-39-27-60.6c-5-16.9 4.6-34.8 21.5-39.8zm447.7 0c16.9 5 26.6 22.9 21.5 39.8c-6.4 21.5-15.5 41.8-27 60.6c3.6 8 5.6 16.9 5.6 26.3c0 35.3-28.7 64-64 64c-9.4 0-18.3-2-26.3-5.6c-18.7 11.5-39 20.6-60.6 27c-16.9 5-34.8-4.6-39.8-21.5s4.6-34.8 21.5-39.8c14.6-4.3 28.5-10.4 41.4-17.9c-.2-2-.3-4.1-.3-6.2c0-35.3 28.7-64 64-64c2.1 0 4.1 .1 6.2 .3c7.5-12.9 13.6-26.8 17.9-41.4c5-16.9 22.9-26.6 39.8-21.5z", "M227.7 313.8c-20.8-10.6-34.9-32.2-34.9-57c0-15.6 5.6-29.9 14.9-41.1L223 231c6.6 6.6 17.8 1.9 17.8-7.4l0-60.5c0-5.7-4.7-10.4-10.4-10.4l-60.5 0c-9.3 0-13.9 11.2-7.4 17.8l11.2 11.2c-17.9 19.8-28.9 46.2-28.9 75.1c0 43.6 24.9 81.3 61.1 99.8c11.8 6 26.3 1.4 32.3-10.4s1.4-26.3-10.4-32.3zm93.1-58.6c0 15.6-5.6 29.9-14.9 41.1L290.6 281c-6.6-6.6-17.8-1.9-17.8 7.4l0 60.5c0 5.7 4.7 10.4 10.4 10.4l60.5 0c9.3 0 13.9-11.2 7.4-17.8l-11.2-11.2c17.9-19.8 28.9-46.2 28.9-75.1c0-43.6-24.9-81.3-61.1-99.8c-11.8-6-26.3-1.4-32.3 10.4s-1.4 26.3 10.4 32.3c20.8 10.6 34.9 32.2 34.9 57z"]],
    "bowl-food": [512, 512, [], "e4c6", ["M8.6 224C3.1 214.6 0 203.7 0 192c0-35.3 28.7-64 64-64c.5 0 1.1 0 1.6 0C73 91.5 105.3 64 144 64c15 0 29 4.1 40.9 11.2C198.2 49.6 225.1 32 256 32s57.8 17.6 71.1 43.2C339 68.1 353 64 368 64c38.7 0 71 27.5 78.4 64c.5 0 1.1 0 1.6 0c35.3 0 64 28.7 64 64c0 11.7-3.1 22.6-8.6 32H8.6z", "M27.4 256C12.3 256 0 268.3 0 283.4c0 70.5 44.4 130.7 106.7 154.1l1.8 14.4c2 16 15.6 28 31.8 28H371.8c16.1 0 29.8-12 31.8-28l1.8-14.4C467.6 414.1 512 353.9 512 283.4c0-15.1-12.3-27.4-27.4-27.4H27.4z"]],
    "square-9": [448, 512, [], "e25e", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM224 272a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm-26 44.4l-29.6 25.4c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l81.6-70C305.8 287.2 320 256.4 320 224c0-53-43-96-96-96s-96 43-96 96c0 44 29.6 81.1 70 92.4z", "M272 224a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-74 92.4l-29.6 25.4c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l81.6-70C305.8 287.2 320 256.4 320 224c0-53-43-96-96-96s-96 43-96 96c0 44 29.6 81.1 70 92.4z"]],
    "candy-cane": [512, 512, [], "f786", ["M288.1 18.8c-2.4 1.3-4.8 2.7-7.1 4.2L254.1 39.7c-30 18.7-39.1 58.2-20.4 88.2s58.2 39.1 88.2 20.4l7.7-4.8-.8-2.4-40-120-.8-2.3zm70.2 109.4c.9-.1 1.8-.2 2.7-.2c.1 0 .3 0 .4 0l0 0 11.3-11.3 80-80 3.2-3.2C429.9 12.6 396.9 0 361 0c-14.7 0-29.3 2.2-43.3 6.3l1.5 4.6 39.1 117.2zm120.2-72l-3.2 3.2-80 80L384 150.6l0 0c0 .1 0 .3 0 .4v.1l5.1 1.7 118.8 39.6c2.7-11.6 4.1-23.6 4.1-35.8V151c0-35.9-12.6-69-33.5-94.9zm18.9 166.5L378.9 183.2l-7.8-2.6c-.2 .1-.4 .3-.6 .4l-71 44.4 117 73.1 3.8 2.4 18.1-11.3c26.2-16.3 46.4-39.7 59-66.8zm-107.3 97L271.5 245.6l-2.2-1.4-77 48.1 112.2 70.1 8.6 5.4 77-48.1zm-107.2 67L162.1 311.2l-73 45.6 111.4 69.6 9.4 5.9 73-45.6zM179.7 451.2L58.9 375.7l-28.8 18C.1 412.5-9 451.9 9.7 481.9s58.2 39.1 88.2 20.4l81.8-51.1z", "M329.6 143.5l-.8-2.4-40-120-.8-2.3c9.4-5.2 19.3-9.4 29.6-12.4l1.5 4.6 39.1 117.2c-3.4 .4-6.6 1.5-9.5 3.3l-19.1 12zm54.4 7.2c-.2-12.4-10.2-22.4-22.6-22.6l0 0 11.3-11.3 80-80 3.2-3.2c8.3 6.7 15.9 14.3 22.6 22.6l-3.2 3.2-80 80L384 150.6l0 0zm-12.9 29.9c8-5.3 12.9-14.3 12.9-23.9v-5.5l5.1 1.7 118.8 39.6c-2.5 10.5-6 20.6-10.5 30.2L378.9 183.2l-7.8-2.6zM269.3 244.2l30.2-18.9 117 73.1 3.8 2.4-30.2 18.9L271.5 245.6l-2.2-1.4zm-107.2 67l30.2-18.9 112.2 70.1 8.6 5.4-30.2 18.9L162.1 311.2zM58.9 375.7l30.2-18.9 111.4 69.6 9.4 5.9-30.2 18.9L58.9 375.7z"]],
    "arrow-down-wide-short": [576, 512, ["sort-amount-asc", "sort-amount-down"], "f160", ["M288 448c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H320c-17.7 0-32 14.3-32 32zm0-128c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32s-14.3-32-32-32H320c-17.7 0-32 14.3-32 32zm0-128c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H320c-17.7 0-32 14.3-32 32zm0-128c0 17.7 14.3 32 32 32H544c17.7 0 32-14.3 32-32s-14.3-32-32-32H320c-17.7 0-32 14.3-32 32z", "M128 480c9 0 17.5-3.8 23.6-10.4l88-96c11.9-13 11.1-33.3-2-45.2s-33.3-11.1-45.2 2L160 365.7V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V365.7L63.6 330.4c-11.9-13-32.2-13.9-45.2-2s-13.9 32.2-2 45.2l88 96C110.5 476.2 119 480 128 480z"]],
    "square-dollar": [448, 512, ["dollar-square", "usd-square"], "f2e9", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM244.8 133.6v14.2c9.7 1.2 19.4 3.9 29 6.6c1.9 .5 3.7 1 5.6 1.6c11.5 3.2 18.3 15.1 15.1 26.6s-15.1 18.2-26.6 15.1c-1.6-.4-3.1-.9-4.7-1.3c-7-2-14-3.9-21.1-5.3c-13.2-2.5-28.5-1.3-40.8 4c-11 4.8-20.1 16.4-7.6 24.4c9.8 6.3 21.8 9.5 33.2 12.6c2.4 .6 4.7 1.3 7 1.9c15.6 4.4 35.5 10.1 50.4 20.3c19.4 13.3 28.5 34.9 24.2 58.1c-4.1 22.4-19.7 37.1-38.4 44.7c-7.8 3.2-16.3 5.2-25.2 6.2l0 15.2c0 11.9-9.7 21.6-21.6 21.6s-21.6-9.7-21.6-21.6l0-17.4c-14.5-3.3-28.7-7.9-42.8-12.5c-11.3-3.7-17.5-16-13.7-27.3s16-17.5 27.3-13.7c2.5 .8 5 1.7 7.5 2.5c11.3 3.8 22.9 7.7 34.5 9.6c17 2.5 30.6 1 39.5-2.6c12-4.8 17.7-19.1 5.9-27.1c-10.1-6.9-22.6-10.3-34.5-13.5c-2.3-.6-4.5-1.2-6.8-1.9c-15.1-4.3-34-9.6-48.2-18.7c-19.5-12.5-29.4-33.3-25.2-56.4c4-21.8 21-36.3 39-44.1c5.5-2.4 11.4-4.3 17.5-5.7V133.6c0-11.9 9.7-21.6 21.6-21.6s21.6 9.7 21.6 21.6z", "M223.2 112c11.9 0 21.6 9.7 21.6 21.6v14.2c11.6 1.4 23.2 5 34.5 8.2c11.5 3.2 18.3 15.1 15.1 26.6s-15.1 18.2-26.6 15.1c-8.5-2.3-17.1-4.9-25.8-6.6c-13.2-2.5-28.5-1.3-40.8 4c-11 4.8-20.1 16.4-7.6 24.4c11.9 7.6 26.8 10.7 40.1 14.5c15.6 4.4 35.5 10.1 50.4 20.3c19.4 13.3 28.5 34.9 24.2 58.1c-4.1 22.4-19.7 37.1-38.4 44.7c-7.8 3.2-16.3 5.2-25.2 6.2l0 15.2c0 11.9-9.7 21.6-21.6 21.6s-21.6-9.7-21.6-21.6l0-17.4c-14.5-3.3-28.7-7.9-42.8-12.5c-11.3-3.7-17.5-16-13.7-27.3s16-17.5 27.3-13.7c13.7 4.5 27.8 9.9 42 12.1c17 2.5 30.6 1 39.5-2.6c12-4.8 17.7-19.1 5.9-27.1c-12-8.2-27.5-11.5-41.3-15.4c-15.1-4.3-34-9.6-48.2-18.7c-19.5-12.5-29.4-33.3-25.2-56.4c4-21.8 21-36.3 39-44.1c5.5-2.4 11.4-4.3 17.5-5.7V133.6c0-11.9 9.7-21.6 21.6-21.6z"]],
    "phone-arrow-right": [512, 512, [], "e5be", ["M164.9 24.6c-7.7-18.6-28-28.5-47.4-23.2l-88 24C12.1 30.2 0 46 0 64C0 311.4 200.6 512 448 512c18 0 33.8-12.1 38.6-29.5l24-88c5.3-19.4-4.6-39.7-23.2-47.4l-96-40c-16.3-6.8-35.2-2.1-46.3 11.6L304.7 368C234.3 334.7 177.3 277.7 144 207.3L193.3 167c13.7-11.2 18.4-30 11.6-46.3l-40-96z", "M391 7c9.4-9.4 24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l39-39H312c-13.3 0-24-10.7-24-24s10.7-24 24-24H430.1L391 41c-9.4-9.4-9.4-24.6 0-33.9z"]],
    "hand-holding-seedling": [576, 512, [], "f4bf", ["M559.7 392.2c17.8-13.1 21.6-38.1 8.5-55.9s-38.1-21.6-55.9-8.5L392.6 416H272c-8.8 0-16-7.2-16-16s7.2-16 16-16h16 64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288 272 193.7c-29.1 0-57.3 9.9-80 28L68.8 384H32c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H192 352.5c29 0 57.3-9.3 80.7-26.5l126.6-93.3zm-366.1-8.3a.5 .5 0 1 1 -.9 .2 .5 .5 0 1 1 .9-.2z", "M96 14.5C96 6.5 102.5 0 110.5 0H160c88.4 0 160 71.6 160 160v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V160H241.5C161.1 160 96 94.9 96 14.5zm384 0C480 89 424.1 150.3 352 159c-.2-44.9-15.9-86.2-42-118.8C338.2 15.2 375.3 0 416 0h49.5c8 0 14.5 6.5 14.5 14.5z"]],
    "message-check": [512, 512, ["comment-alt-check"], "f4a2", ["M0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V416H64c-35.3 0-64-28.7-64-64V64zm369 89c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 153z", "M369 119c9.4 9.4 9.4 24.6 0 33.9L241 281c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 119c9.4-9.4 24.6-9.4 33.9 0z"]],
    "cloud-bolt": [512, 512, [127785, "thunderstorm"], "f76c", ["M334.3 247.2c3.4-6.7 1.6-14.9-4.2-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7h70.1L177.7 488.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7H281.9l52.4-104.8z", "M96 320c-53 0-96-43-96-96c0-42.5 27.6-78.6 65.9-91.2C64.7 126.1 64 119.1 64 112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80c0 5.5-.6 10.8-1.6 16c.5 0 1.1 0 1.6 0c53 0 96 43 96 96s-43 96-96 96H352 333.7l29.3-58.5c10.1-20.2 4.8-44.6-12.8-58.8s-42.6-14.2-60.2-.2L143.2 320H96z"]],
    "chart-line-up-down": [512, 512, [], "e5d7", ["M32 32c17.7 0 32 14.3 32 32V400c0 8.8 7.2 16 16 16H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-44.2 0-80-35.8-80-80V64C0 46.3 14.3 32 32 32z", "M358.6 102.6l18.7 18.7L288 210.7l-57.4-57.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L208 221.3l57.4 57.4c12.5 12.5 32.8 12.5 45.3 0l112-112 18.7 18.7c4.2 4.2 10 6.6 16 6.6c12.5 0 22.6-10.1 22.6-22.6V96.2v-.3V80c0-8.8-7.2-16-16-16H374.6C362.1 64 352 74.1 352 86.6c0 6 2.4 11.8 6.6 16zm64 178.7l-34.7-34.7-45.3 45.3 34.7 34.7-18.7 18.7c-4.2 4.2-6.6 10-6.6 16c0 12.5 10.1 22.6 22.6 22.6l89.4 0c8.8 0 16-7.2 16-16V278.6c0-12.5-10.1-22.6-22.6-22.6c-6 0-11.8 2.4-16 6.6l-18.7 18.7z"]],
    "text-slash": [640, 512, ["remove-format"], "f87d", ["M355.7 253.5L400.2 96H503L497 120.2c-4.3 17.1 6.1 34.5 23.3 38.8s34.5-6.1 38.8-23.3l11-44.1C577.6 61.3 554.7 32 523.5 32H376.1h-.3H204.5c-22 0-41.2 15-46.6 36.4l-6.3 25.2 55.1 43.2c.1-.3 .2-.7 .3-1L217 96H333.7L301.3 210.8l54.4 42.7zM327.3 353.9L272.9 311 243.3 416H192c-17.7 0-32 14.3-32 32s14.3 32 32 32H352c17.7 0 32-14.3 32-32s-14.3-32-32-32H309.8l17.6-62.1z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "watch": [384, 512, [8986], "f2e1", ["M192 448a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm24-272v67.2L253.3 268c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32C172 271.5 168 264 168 256V176c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M64 48C64 21.5 85.5 0 112 0H272c26.5 0 48 21.5 48 48v64.9C286 82.5 241.2 64 192 64s-94 18.5-128 48.9V48zM192 448c49.2 0 94-18.5 128-48.9V464c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48V399.1C98 429.5 142.8 448 192 448zm24-272v67.2L253.3 268c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32C172 271.5 168 264 168 256V176c0-13.3 10.7-24 24-24s24 10.7 24 24z"]],
    "circle-down-left": [512, 512, [], "e107", ["M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM160 198.6V336c0 8.8 7.2 16 16 16H313.4c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L296 280l66.3-66.3c3.6-3.6 5.7-8.5 5.7-13.7s-2-10-5.7-13.7l-36.7-36.7C322 146 317.1 144 312 144s-10 2-13.7 5.7L232 216l-33.4-33.4c-4.2-4.2-10-6.6-16-6.6c-12.5 0-22.6 10.1-22.6 22.6z", "M160 336V198.6c0-12.5 10.1-22.6 22.6-22.6c6 0 11.8 2.4 16 6.6L232 216l66.3-66.3c3.6-3.6 8.5-5.7 13.7-5.7s10 2 13.7 5.7l36.7 36.7c3.6 3.6 5.7 8.5 5.7 13.7s-2 10-5.7 13.7L296 280l33.4 33.4c4.2 4.2 6.6 10 6.6 16c0 12.5-10.1 22.6-22.6 22.6H176c-8.8 0-16-7.2-16-16z"]],
    "text": [448, 512, [], "f893", ["M64 96v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V80C0 53.5 21.5 32 48 32H224 400c26.5 0 48 21.5 48 48v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V96H256l0 320h48c17.7 0 32 14.3 32 32s-14.3 32-32 32H144c-17.7 0-32-14.3-32-32s14.3-32 32-32h48l0-320H64z", ""]],
    "projector": [640, 512, [], "f8d6", ["M440 24c0-13.3-10.7-24-24-24s-24 10.7-24 24v80c0 13.3 10.7 24 24 24s24-10.7 24-24V24zM281 39c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56 56c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L281 39zM585 73c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L495 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l56-56zm-9 247c0 64-37.5 119.2-91.8 144.8l5.7 23c3.6 14.2 16.4 24.2 31 24.2h14c14.7 0 27.5-10 31-24.2L576 448c35.3 0 64-28.7 64-64V256c0-35.3-28.7-64-64-64H512c38.9 29.2 64 75.7 64 128zM160 448H320c-38.9-29.2-64-75.7-64-128s25.1-98.8 64-128H64c-35.3 0-64 28.7-64 64V384c0 35.3 28.7 64 64 64l9.9 39.8C77.5 502 90.3 512 105 512h14c14.7 0 27.5-10 31-24.2L160 448zM64 320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M512 320a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm-256 0a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zM96 288a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "face-smile-wink": [512, 512, [128521, "smile-wink"], "f4da", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.1 325.5C182 346.2 212.6 368 256 368s74-21.8 91.9-42.5c5.8-6.7 15.9-7.4 22.6-1.6s7.4 15.9 1.6 22.6C349.8 372.1 311.1 400 256 400s-93.8-27.9-116.1-53.5c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm156.4 25.6c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4c30.4-40.5 91.2-40.5 121.6 0c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2c-17.6-23.5-52.8-23.5-70.4 0z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm124.4-6.4c17.6-23.5 52.8-23.5 70.4 0c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2z"]],
    "tombstone-blank": [448, 512, [129702, "tombstone-alt"], "f721", ["M32 192C32 86 118 0 224 0S416 86 416 192V448H32V192z", "M0 480c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z"]],
    "chess-king-piece": [256, 512, ["chess-king-alt"], "f440", ["M208 416H48L4.8 473.6C1.7 477.8 0 482.8 0 488c0 13.3 10.7 24 24 24H232c13.3 0 24-10.7 24-24c0-5.2-1.7-10.2-4.8-14.4L208 416z", "M128 0c8.8 0 16 7.2 16 16V32h16c8.8 0 16 7.2 16 16s-7.2 16-16 16H144V96h51.8c11.2 0 20.2 9.1 20.2 20.2c0 2.5-.5 4.9-1.3 7.3L182.2 208H184c13.3 0 24 10.7 24 24s-10.7 24-24 24h-2.7L208 416H48L74.7 256H72c-13.3 0-24-10.7-24-24s10.7-24 24-24h1.8L41.3 123.5c-.9-2.3-1.3-4.8-1.3-7.3C40 105.1 49.1 96 60.2 96H112V64H96c-8.8 0-16-7.2-16-16s7.2-16 16-16h16V16c0-8.8 7.2-16 16-16z"]],
    "circle-6": [512, 512, [], "e0f3", ["M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256-16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm-96 48c0 53 43 96 96 96s96-43 96-96c0-44-29.6-81.1-70-92.4l29.6-25.4c10.1-8.6 11.2-23.8 2.6-33.8s-23.8-11.2-33.8-2.6l-81.6 70C174.2 224.8 160 255.6 160 288z", "M311.6 170.2c10.1-8.6 11.2-23.8 2.6-33.8s-23.8-11.2-33.8-2.6l-81.6 70C174.2 224.8 160 255.6 160 288c0 53 43 96 96 96s96-43 96-96c0-44-29.6-81.1-70-92.4l29.6-25.4zM304 288a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"]],
    "left": [448, 512, ["arrow-alt-left"], "f355", ["M224 320V192H408c22.1 0 40 17.9 40 40v48c0 22.1-17.9 40-40 40l-184 0z", "M224 192h0V96c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-160 160c-12.5 12.5-12.5 32.8 0 45.3l160 160c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6V320h0V192z"]],
    "file-word": [384, 512, [], "f1c2", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM111 257.1c-3.8-12.7-17.2-19.9-29.9-16.1s-19.9 17.2-16.1 29.9l48 160c3 10 12 16.9 22.4 17.1s19.8-6.2 23.2-16.1L192 336.6l33.3 95.3c3.4 9.8 12.8 16.3 23.2 16.1s19.5-7.1 22.4-17.1l48-160c3.8-12.7-3.4-26.1-16.1-29.9s-26.1 3.4-29.9 16.1l-26.8 89.2-31.6-90.3c-3.4-9.6-12.5-16.1-22.7-16.1s-19.3 6.4-22.7 16.1l-31.6 90.3L111 257.1z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM111 257.1c-3.8-12.7-17.2-19.9-29.9-16.1s-19.9 17.2-16.1 29.9l48 160c3 10 12 16.9 22.4 17.1s19.8-6.2 23.2-16.1L192 336.6l33.3 95.3c3.4 9.8 12.8 16.3 23.2 16.1s19.5-7.1 22.4-17.1l48-160c3.8-12.7-3.4-26.1-16.1-29.9s-26.1 3.4-29.9 16.1l-26.8 89.2-31.6-90.3c-3.4-9.6-12.5-16.1-22.7-16.1s-19.3 6.4-22.7 16.1l-31.6 90.3L111 257.1z"]],
    "file-powerpoint": [384, 512, [], "f1c4", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM136 240c-13.3 0-24 10.7-24 24V368v56c0 13.3 10.7 24 24 24s24-10.7 24-24V392h44c42 0 76-34 76-76s-34-76-76-76H136zm68 104H160V288h44c15.5 0 28 12.5 28 28s-12.5 28-28 28z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM136 240c-13.3 0-24 10.7-24 24V368v56c0 13.3 10.7 24 24 24s24-10.7 24-24V392h44c42 0 76-34 76-76s-34-76-76-76H136zm68 104H160V288h44c15.5 0 28 12.5 28 28s-12.5 28-28 28z"]],
    "square-down": [448, 512, [11015, "arrow-alt-square-down"], "f350", ["M64 480c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64zm39.1-185.4l107.1 99.9c3.8 3.5 8.7 5.5 13.8 5.5s10.1-2 13.8-5.5l107.1-99.9c4.5-4.2 7.1-10.1 7.1-16.3c0-12.3-10-22.3-22.3-22.3H272V160c0-17.7-14.3-32-32-32H208c-17.7 0-32 14.3-32 32v96H118.3C106 256 96 266 96 278.3c0 6.2 2.6 12.1 7.1 16.3z", "M210.2 394.5L103.1 294.6c-4.5-4.2-7.1-10.1-7.1-16.3C96 266 106 256 118.3 256H176V160c0-17.7 14.3-32 32-32h32c17.7 0 32 14.3 32 32v96h57.7c12.3 0 22.3 10 22.3 22.3c0 6.2-2.6 12.1-7.1 16.3L237.8 394.5c-3.8 3.5-8.7 5.5-13.8 5.5s-10.1-2-13.8-5.5z"]],
    "objects-align-center-vertical": [512, 512, [], "e3bd", ["M64 432c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-352c0-26.5-21.5-48-48-48l-64 0C85.5 32 64 53.5 64 80l0 352zm224-64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48l0 224z", "M24 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0 0 48-40 0zm264 0l-64 0 0-48 64 0 0 48zm160 0l0-48 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0z"]],
    "arrows-left-right": [512, 512, ["arrows-h"], "f07e", ["M502.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-96 96c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L402.7 288 256 288l0-64 146.7 0-41.4-41.4c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l96 96z", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 288 256 288l0-64-146.7 0 41.4-41.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-96 96z"]],
    "house-lock": [640, 512, [], "e510", ["M392.6 512c-5.4-9.4-8.6-20.3-8.6-32V352c0-23.7 12.9-44.4 32-55.4V272c0-48.8 31.2-90.3 74.7-105.7L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24c0 18 14 32.1 32 32.1h32v69.7c-.1 .9-.1 1.8-.1 2.8V472c0 22.1 17.9 40 40 40h16c1.2 0 2.4-.1 3.6-.2c1.5 .1 3 .2 4.5 .2H160h24c22.1 0 40-17.9 40-40V448 384c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32v64 24c0 22.1 17.9 40 40 40h.6z", "M496 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "cloud-arrow-down": [640, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", ["M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zm79-167l80 80c9.4 9.4 24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-39 39V184c0-13.3-10.7-24-24-24s-24 10.7-24 24V318.1l-39-39c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9z", "M223 279c-9.4 9.4-9.4 24.6 0 33.9l80 80c9.4 9.4 24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-39 39L344 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 134.1-39-39c-9.4-9.4-24.6-9.4-33.9 0z"]],
    "wreath": [448, 512, [], "f7e2", ["M182.6 0c15.8 0 30.2 5.7 41.4 15.2C235.2 5.7 249.6 0 265.4 0c27.9 0 51.6 17.8 60.3 42.6c5.8-1.7 11.9-2.6 18.2-2.6c35.3 0 64 28.7 64 64c0 6.3-.9 12.5-2.6 18.2c24.8 8.8 42.6 32.5 42.6 60.3c0 15.8-5.7 30.2-15.2 41.4c9.5 11.2 15.2 25.6 15.2 41.4c0 27.9-17.8 51.6-42.6 60.3c1.7 5.8 2.6 11.9 2.6 18.2c0 35.3-28.7 64-64 64c-6.3 0-12.5-.9-18.2-2.6c-1.5 4.2-3.4 8.3-5.8 12.1V403.8c0-10.9-8.9-19.8-19.8-19.8c-2.8 0-5.5 .6-8 1.7L224 416l-68.2-30.3c-2.5-1.1-5.3-1.7-8-1.7c-10.9 0-19.8 8.9-19.8 19.8v13.6c-2.3-3.8-4.3-7.8-5.8-12.1c-5.8 1.7-11.9 2.6-18.2 2.6c-35.3 0-64-28.7-64-64c0-6.3 .9-12.5 2.6-18.2C17.8 317 0 293.3 0 265.4c0-15.8 5.7-30.2 15.2-41.4C5.7 212.8 0 198.4 0 182.6c0-27.9 17.8-51.6 42.6-60.3C40.9 116.5 40 110.3 40 104c0-35.3 28.7-64 64-64c6.3 0 12.5 .9 18.2 2.6C131 17.8 154.7 0 182.6 0zM203 142.4c-5.7 6-13.6 9.4-21.9 9.1c-16.6-.6-30.2 13-29.6 29.6c.3 8.3-3 16.3-9.1 21.9c-12.1 11.3-12.1 30.6 0 41.9c6 5.7 9.4 13.6 9.1 21.9c-.6 16.6 13 30.2 29.6 29.6c8.3-.3 16.3 3 21.9 9.1c11.3 12.1 30.6 12.1 41.9 0c5.7-6 13.6-9.4 21.9-9.1c16.6 .6 30.2-13 29.6-29.6c-.3-8.3 3-16.3 9.1-21.9c12.1-11.3 12.1-30.6 0-41.9c-6-5.7-9.4-13.6-9.1-21.9c.6-16.6-13-30.2-29.6-29.6c-8.3 .3-16.3-3-21.9-9.1c-11.3-12.1-30.6-12.1-41.9 0z", "M128 492.2V403.8c0-10.9 8.9-19.8 19.8-19.8c2.8 0 5.5 .6 8 1.7L224 416l68.2-30.3c2.5-1.1 5.3-1.7 8-1.7c10.9 0 19.8 8.9 19.8 19.8v88.4c0 10.9-8.9 19.8-19.8 19.8c-2.8 0-5.5-.6-8-1.7L224 480l-68.2 30.3c-2.5 1.1-5.3 1.7-8 1.7c-10.9 0-19.8-8.9-19.8-19.8z"]],
    "children": [640, 512, [], "e4e1", ["M544 64A64 64 0 1 0 416 64a64 64 0 1 0 128 0zM472 480V384h16v96c0 17.7 14.3 32 32 32s32-14.3 32-32V300.5L564.9 321c9.4 15 29.2 19.4 44.1 10s19.4-29.2 10-44.1l-51.7-82.1c-17.6-27.9-48.3-44.9-81.2-44.9H473.8c-33 0-63.7 16.9-81.2 44.9L340.9 287c-9.4 15-4.9 34.7 10 44.1s34.7 4.9 44.1-10L408 300.5V480c0 17.7 14.3 32 32 32s32-14.3 32-32z", "M224 64A64 64 0 1 0 96 64a64 64 0 1 0 128 0zM88 400v80c0 17.7 14.3 32 32 32s32-14.3 32-32V400h16v80c0 17.7 14.3 32 32 32s32-14.3 32-32V400h17.8c10.9 0 18.6-10.7 15.2-21.1l-31.1-93.4 28.6 37.8c10.7 14.1 30.8 16.8 44.8 6.2s16.8-30.7 6.2-44.8L254.6 207c-22.4-29.6-57.5-47-94.6-47s-72.2 17.4-94.6 47L6.5 284.7c-10.7 14.1-7.9 34.2 6.2 44.8s34.2 7.9 44.8-6.2l28.7-37.8L55 378.9C51.6 389.3 59.3 400 70.2 400H88z"]],
    "meter-droplet": [640, 512, [], "e1ea", ["M400.6 467.3C359.5 495.5 309.7 512 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0C366.8 0 461.2 70.4 496.8 169c-8.5 5.3-15.7 12.9-20.6 22.1L400.9 332.2C389.8 353.1 384 376.4 384 400c0 24.3 6 47.2 16.6 67.3zM160 128c-17.7 0-32 14.3-32 32v32c0 17.7 14.3 32 32 32s32-14.3 32-32V160c0-17.7-14.3-32-32-32zm96 0c-17.7 0-32 14.3-32 32v32c0 17.7 14.3 32 32 32s32-14.3 32-32V160c0-17.7-14.3-32-32-32zm96 0c-17.7 0-32 14.3-32 32v32c0 17.7 14.3 32 32 32s32-14.3 32-32V160c0-17.7-14.3-32-32-32z", "M429.2 347.3l75.3-141.2c4.6-8.7 13.7-14.1 23.5-14.1s18.9 5.4 23.5 14.1l75.3 141.2c8.7 16.2 13.2 34.3 13.2 52.7c0 61.9-50.1 112-112 112s-112-50.1-112-112c0-18.4 4.5-36.5 13.2-52.7z"]],
    "chalkboard": [576, 512, ["blackboard"], "f51b", ["M96 32C60.7 32 32 60.7 32 96V416c-17.7 0-32 14.3-32 32s14.3 32 32 32H544c17.7 0 32-14.3 32-32s-14.3-32-32-32V96c0-35.3-28.7-64-64-64H96zM480 416H96V96l384 0V416z", "M480 96H96V416H224V384c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32v32h64V96z"]],
    "user-large-slash": [640, 512, ["user-alt-slash"], "f4fa", ["M464 144C464 64.5 399.5 0 320 0C250.4 0 192.4 49.3 178.9 114.9L381.9 274c48.5-23.2 82.1-72.7 82.1-130zm81.5 368H528L284.3 320h-59C136.2 320 64 392.2 64 481.3c0 17 13.8 30.7 30.7 30.7H545.3l.3 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "signal-strong": [640, 512, ["signal-4"], "f68f", ["M576 0c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V32c0-17.7 14.3-32 32-32z", "M480 128c0-17.7-14.3-32-32-32s-32 14.3-32 32V480c0 17.7 14.3 32 32 32s32-14.3 32-32V128zM352 224c0-17.7-14.3-32-32-32s-32 14.3-32 32V480c0 17.7 14.3 32 32 32s32-14.3 32-32V224zM192 288c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32s32-14.3 32-32V320c0-17.7-14.3-32-32-32zM96 416c0-17.7-14.3-32-32-32s-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V416z"]],
    "lollipop": [512, 512, [127853, "lollypop"], "e424", ["M303.2 348.5c17.5-12.5 32.8-27.8 45.3-45.3L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L303.2 348.5z", "M48 192c0 57.4 46.6 104 104 104h8c53 0 96-43 96-96v-8c0-35.3-28.7-64-64-64s-64 28.7-64 64c0 13.3 10.7 24 24 24s24-10.7 24-24v-8c0-13.3 10.7-24 24-24s24 10.7 24 24v8c0 39.8-32.2 72-72 72s-72-32.2-72-72c0-61.9 50.1-112 112-112s112 50.1 112 112v8c0 61.6-38.7 114.2-93.2 134.8C281.4 325.6 336 265.2 336 192c0-79.5-64.5-144-144-144S48 112.5 48 192zM0 192a192 192 0 1 1 384 0A192 192 0 1 1 0 192z"]],
    "list-tree": [512, 512, [], "e1d2", ["M160 96c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-17.7 0-32-14.3-32-32zM288 256c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H320c-17.7 0-32-14.3-32-32zm32 128H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H320c-17.7 0-32-14.3-32-32s14.3-32 32-32z", "M24 48C10.7 48 0 58.7 0 72v48c0 13.3 10.7 24 24 24V256 384c0 30.9 25.1 56 56 56h48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V392c0-13.3-10.7-24-24-24H152c-13.3 0-24 10.7-24 24H80c-4.4 0-8-3.6-8-8V280h56c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V232c0-13.3-10.7-24-24-24H152c-13.3 0-24 10.7-24 24H72V144c13.3 0 24-10.7 24-24V72c0-13.3-10.7-24-24-24H24z"]],
    "envelope-open": [512, 512, [62135], "f2b6", ["M256 65.9L64 208.1v47.4L222.5 373c9.7 7.2 21.4 11 33.5 11s23.8-3.9 33.5-11L448 255.5V208.1L256 65.9z", "M64 208.1L256 65.9 448 208.1v47.4L289.5 373c-9.7 7.2-21.4 11-33.5 11s-23.8-3.9-33.5-11L64 255.5V208.1zM256 0c-12.1 0-23.8 3.9-33.5 11L25.9 156.7C9.6 168.8 0 187.8 0 208.1V448c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V208.1c0-20.3-9.6-39.4-25.9-51.4L289.5 11C279.8 3.9 268.1 0 256 0z"]],
    "draw-circle": [512, 512, [], "f5ed", ["M320 64c0 15.1-5.2 29-14 40c48.2 15.8 86.2 53.9 102 102c11-8.8 24.8-14 40-14c8.5 0 16.6 1.7 24.1 4.7c-20.8-76-80.7-135.9-156.7-156.7c3 7.4 4.7 15.5 4.7 24.1zM472.1 315.3c-7.4 3-15.6 4.7-24.1 4.7c-15.1 0-29-5.2-40-14c-15.8 48.2-53.9 86.2-102 102c8.8 11 14 24.8 14 40c0 8.5-1.7 16.6-4.7 24.1c76-20.8 135.9-80.7 156.7-156.7zM196.7 472.1c-3-7.4-4.7-15.6-4.7-24.1c0-15.1 5.2-29 14-40c-48.2-15.8-86.2-53.9-102-102c-11 8.8-24.8 14-40 14c-8.5 0-16.6-1.7-24.1-4.7c20.8 76 80.7 135.9 156.7 156.7zm0-432.1c-76 20.8-135.9 80.7-156.7 156.7c7.4-3 15.6-4.7 24.1-4.7c15.1 0 29 5.2 40 14c15.8-48.2 53.9-86.2 102-102c-8.8-11-14-24.8-14-40c0-8.5 1.7-16.6 4.7-24.1z", "M256 128A64 64 0 1 0 256 0a64 64 0 1 0 0 128zm0 384a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM128 256A64 64 0 1 0 0 256a64 64 0 1 0 128 0zm320 64a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "cat-space": [640, 512, [], "e001", ["M288 160a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zm64 0c0 53 43 96 96 96s96-43 96-96V42.7c0-5.9-4.8-10.7-10.7-10.7c-3.4 0-6.5 1.6-8.5 4.3l-40 53.3c-3 4-7.8 6.4-12.8 6.4H424c-5 0-9.8-2.4-12.8-6.4l-40-53.3c-2-2.7-5.2-4.3-8.5-4.3c-5.9 0-10.7 4.8-10.7 10.7V160zM231.5 12.3l10.7 28.8c.8 2.2 2.5 3.9 4.7 4.7l28.8 10.7c7 2.6 7 12.4 0 15L246.9 82.2c-2.2 .8-3.9 2.5-4.7 4.7l-10.7 28.8c-2.6 7-12.4 7-15 0L205.8 86.9c-.8-2.2-2.5-3.9-4.7-4.7L172.3 71.5c-7-2.6-7-12.4 0-15l28.8-10.7c2.2-.8 3.9-2.5 4.7-4.7l10.7-28.8c2.6-7 12.4-7 15 0z", "M352 42.7c0-5.9 4.8-10.7 10.7-10.7c3.4 0 6.5 1.6 8.5 4.3l40 53.3c3 4 7.8 6.4 12.8 6.4h48c5 0 9.8-2.4 12.8-6.4l40-53.3c2-2.7 5.2-4.3 8.5-4.3c5.9 0 10.7 4.8 10.7 10.7V160c0 53-43 96-96 96s-96-43-96-96V42.7zM416 176a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM160 277.8c29.4-44.3 76.8-75.6 131.6-83.8C307.3 266.1 371.3 320 448 320c11 0 21.7-1.1 32-3.2V352 480c0 17.7-14.3 32-32 32s-32-14.3-32-32V386.1L300 448h36c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-53 0-96-43-96-96V192.5c0-16.1-12-29.8-28-31.8l-7.9-1c-17.5-2.2-30-18.2-27.8-35.7s18.2-30 35.7-27.8l7.9 1c48 6 84.1 46.8 84.1 95.3v85.3z"]],
    "handshake-simple-slash": [640, 512, ["handshake-alt-slash"], "e05f", ["M495.8 363.3c-1.1-11.3-6.3-22.3-15.3-30.7l-134.2-123-23.4 18.2L495.8 363.3zM296.9 207.4l77.2-60.1c7-5.4 17-4.2 22.5 2.8s4.2 17-2.8 22.5l-20.9 16.2L550.2 352H592c26.5 0 48-21.5 48-48V176c0-26.5-21.5-48-48-48H516h-4-.7l-3.9-2.5L434.8 79c-15.3-9.8-33.2-15-51.4-15c-21.8 0-43 7.5-60 21.2l-89.7 72.6 63.2 49.6zm-89.1-69.8l81.8-66.2c-11.6-4.9-24.1-7.4-36.8-7.4C234 64 215.7 69.6 200 80l-35.5 23.7 43.3 34zM413.6 421.9L41.2 128.5C17.9 131.8 0 151.8 0 176V304c0 26.5 21.5 48 48 48H156.2l91.4 83.4c19.6 17.9 49.9 16.5 67.8-3.1c5.5-6.1 9.2-13.2 11.1-20.6l17 15.6c19.5 17.9 49.9 16.6 67.8-2.9c.8-.8 1.5-1.7 2.2-2.6z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "rabbit-running": [576, 512, ["rabbit-fast"], "f709", ["M458.6 37.2l2.2 2.1c36.2 35.5 52.3 86.2 43.9 135.5c5.1 2.9 9.9 6.3 14.5 10L553.8 213c14 11.4 22.2 28.6 22.2 46.7c0 33.3-27 60.3-60.3 60.3H414.4l-6.4 3.7-56 32.4V340.5c0-57.2-37.9-107.4-92.8-123.1l-30.8-8.8c-8.5-2.4-17.4 2.5-19.8 11s2.5 17.4 11 19.8l30.8 8.8C291.6 260 320 297.6 320 340.5V384h15.2H352h64c17.7 0 32 14.3 32 32s-14.3 32-32 32H300.4c-16 0-31.4-6-43.2-16.8L115 300.8c-34.8-31.9-42.4-84-18.1-124.5l2.1-3.4C115.7 145 145.7 128 178.2 128c35.6 0 70.6 9.3 101.5 26.9L384.8 215c1.2-7.8 3.9-15.1 7.6-21.8c-37.1-18.3-66.5-50.2-81.4-89.7c-4.4-11.6 .4-24.9 11.2-31.1c5.6-3.2 12.3-4.2 18.5-2.6l3.4 .9C391.3 82.6 429.4 116 447.8 160c.6 0 1.1 0 1.7 0c8.5 0 16.9 1 25 2.9c-10.3-31-29-58.1-53.3-78.8c.4-11.9 2.3-23.9 5.5-35.6l.8-2.9c1.8-6.3 6.8-11.3 13.1-13s13.2 .1 17.9 4.7zM142.2 421.4l32.9-22 48.6 44.5-46 30.7c-14.7 9.8-34.6 5.8-44.4-8.9s-5.8-34.6 8.9-44.4zM512 240a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z", "M99 172.9l.3-.4C89 159.9 73.4 152 56 152c-30.9 0-56 25.1-56 56s25.1 56 56 56c11.3 0 21.8-3.3 30.6-9.1c-7.4-25.8-4.3-54.3 10.3-78.6l2.1-3.4zM496 256a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "memo-pad": [448, 512, [], "e1da", ["M448 128H0V448c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V128zM112 208H336c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 96H336c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 96h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16z", "M448 128H0V64C0 28.7 28.7 0 64 0H384c35.3 0 64 28.7 64 64v64zM112 208H336c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 96H336c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 96h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "mattress-pillow": [640, 512, [], "e525", ["M64 448l192 0 0-384H64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64zM96 128h64c17.7 0 32 14.3 32 32V352c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32z", "M256 64H576c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H256V64z"]],
    "alarm-plus": [512, 512, [], "f844", ["M390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6L86.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l35.2-35.2C48.6 384.8 32 338.3 32 288C32 164.3 132.3 64 256 64s224 100.3 224 224c0 50.3-16.6 96.8-44.6 134.2l35.2 35.2c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-35.2-35.2zM256 176c-13.3 0-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64v64c0 13.3 10.7 24 24 24s24-10.7 24-24V312h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V200c0-13.3-10.7-24-24-24z", "M14.9 146.4L160 25.4C143 9.6 120.2 0 95.2 0C42.6 0 0 42.6 0 95.2c0 18.8 5.5 36.3 14.9 51.1zM280 200c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H168c-13.3 0-24 10.7-24 24s10.7 24 24 24h64v64c0 13.3 10.7 24 24 24s24-10.7 24-24V312h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H280V200zM352 25.4L497.1 146.4C506.5 131.6 512 114 512 95.2C512 42.6 469.4 0 416.8 0C391.8 0 369 9.6 352 25.4z"]],
    "alicorn": [640, 512, [], "f6b0", ["M560 90.7l73.6-24.5c3.8-1.3 6.4-4.8 6.4-8.8c0-5.1-4.2-9.3-9.3-9.3H551.4c5.4 9.4 8.6 20.3 8.6 32V90.7zM48 256c0-13.4 6.6-25.2 16.7-32.5c-.4-3.5-.7-7.1-.7-10.7c0-16.1 4.5-31.2 12.3-44.1C33.2 174.5 0 211.4 0 256v56c0 13.3 10.7 24 24 24s24-10.7 24-24V256z", "M448 238.1V160l9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1V80c0-19.1-8.4-36.3-21.7-48H544c8.8 0 16-7.2 16-16s-7.2-16-16-16H480 464 448C378.4 0 321.7 55.6 320 124.8L184.9 34.7c-4.9-3.3-11.2-3.6-16.4-.8s-8.5 8.2-8.5 14.1c0 48.1 3.8 99.9 26 139.8c9.2 16.6 21.7 31.3 38.2 42.7c-7.2-2.5-14-5.4-20.3-8.8c-22.5-12.1-38.6-29.4-49.9-49.8c-7.3-13.2-12.7-27.8-16.5-43C96 134.3 64 169.8 64 212.8c0 16.8 5 33.1 14.2 47.1l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9h33.7c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l84 24c4.1 1.2 8.2 2.1 12.3 2.8V480c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V315.7c19.2-19.2 31.5-45.7 32-75.7h0v-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "comment-question": [512, 512, [], "e14b", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM169.8 149.3c7.9-22.3 29.1-37.3 52.8-37.3h58.3c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L280 248.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24V234.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H222.6c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM224 336a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M222.6 112c-23.7 0-44.8 14.9-52.8 37.3l-.4 1.2c-4.4 12.5 2.1 26.2 14.6 30.6s26.2-2.1 30.6-14.6l.4-1.2c1.1-3.2 4.2-5.3 7.5-5.3h58.3c8.4 0 15.1 6.8 15.1 15.1c0 5.4-2.9 10.4-7.6 13.1l-44.3 25.4c-7.5 4.3-12.1 12.2-12.1 20.8V248c0 13.3 10.7 24 24 24c13.1 0 23.8-10.5 24-23.6l32.3-18.5c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1H222.6zM256 368a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "gingerbread-man": [448, 512, [], "f79d", ["M296.9 158.5c-5.2 6-1.2 17.5 6.7 17.5H368c35.3 0 64 28.7 64 64s-28.7 64-64 64H347.1c-19 0-29.4 22.2-17.2 36.7L385.2 407c22.6 27.2 19 67.5-8.2 90.1s-67.5 19-90.1-8.2l-45.6-54.8c-9-10.7-25.5-10.7-34.4 0L161.2 489c-22.6 27.2-63 30.8-90.1 8.2s-30.8-63-8.2-90.1l55.2-66.3c12.2-14.6 1.8-36.7-17.2-36.7H80c-35.3 0-64-28.7-64-64s28.7-64 64-64h64.4c7.9 0 11.9-11.5 6.7-17.5C136.7 141.7 128 119.9 128 96c0-53 43-96 96-96s96 43 96 96c0 23.9-8.7 45.7-23.1 62.5zM192 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-16-48a16 16 0 1 0 0-32 16 16 0 1 0 0 32z", "M208 224a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm0 128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16-80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]],
    "guarani-sign": [384, 512, [], "e19a", ["M192 0c-17.7 0-32 14.3-32 32V66.7c10.4-1.7 21.1-2.7 32-2.7s21.6 .9 32 2.7V32c0-17.7-14.3-32-32-32zm32 132c-10.2-2.6-20.9-4-32-4s-21.8 1.4-32 4V380c10.2 2.6 21 4 32 4s21.8-1.4 32-4V288 224 132zm0 313.3c-10.4 1.7-21.1 2.7-32 2.7s-21.6-.9-32-2.7V480c0 17.7 14.3 32 32 32s32-14.3 32-32V445.3z", "M192 128c-70.7 0-128 57.3-128 128s57.3 128 128 128c59.6 0 109.8-40.8 124-96H224V224H352c17.7 0 32 14.3 32 32c0 106-86 192-192 192S0 362 0 256S86 64 192 64c52.3 0 99.8 21 134.4 54.9c12.6 12.4 12.8 32.6 .5 45.3s-32.6 12.8-45.3 .4C258.5 141.9 226.9 128 192 128z"]],
    "burger-fries": [640, 512, [], "e0cd", ["M167.6 2.4c4.7-2.9 10.6-3.2 15.6-.7l32 16c5.4 2.7 8.8 8.1 8.8 14.1v238c-9.2 1.4-19.8 2.2-32 2.2s-22.8-.8-32-2.2V206.7l0 0V16c0-5.5 2.9-10.7 7.6-13.6zM128 261c-4.8-2.1-8.7-4.4-11.8-6.6c-12-8.4-16.7-18-18.7-24.3c-.4-1.1-.8-2.3-1.2-3.4l-32-192c-1.2-6.9 2.3-13.8 8.6-16.9l32-16c4.5-2.3 9.9-2.3 14.4 .1s7.7 6.6 8.5 11.6l.2 1.3V261zM58.2 193c-3.2-.7-6.6-1-10.2-1H21.4c-1.6 0-3.2 .1-4.7 .2L.2 98.8C-.7 93.4 1.1 88 5.1 84.3s9.5-5.1 14.8-3.8l20.4 5.1L58.2 193zm312.1-18.1c-13.8 4.9-26.1 10.7-37.1 17.2c-2.1 .1-4.1 .3-6.1 .7L346.2 85l17.9-4.5c5.3-1.3 10.8 .1 14.8 3.8s5.8 9.1 4.8 14.5l-13.4 76.1zM256.1 295.2c.7 16.8 8.4 31.7 20.2 42.1C263.8 348.9 256 365.5 256 384c0 16.7 6.4 32 17 43.4c-10.4 8.8-17 21.9-17 36.6c0 18 6 34.6 16 48H89.2c-14.8 0-27.6-10.1-31.1-24.5L.6 250.5c-.4-1.7-.6-3.3-.6-5.1C0 233.6 9.6 224 21.4 224H48c8.8 0 16.3 7.2 18.9 15.7C74.3 263 100.3 304 192 304c26.4 0 47.4-3.4 64.1-8.8zm14.1-42.6c-.8 .6-1.5 1.2-2.4 1.7c-3.2 2.2-7.1 4.5-11.8 6.6V54.6l.2-1.4C257.3 47 262 42 268.1 40.5l32-8c5.3-1.3 10.8 .1 14.8 3.8s5.8 9.1 4.8 14.5L289.4 223c-1.1 2.4-2.1 4.7-2.8 7c-.1 .3-.2 .6-.3 .9c-6.7 7.7-12 15.1-16.1 21.6z", "M612.5 319.8c15.2 0 27.5-12.3 27.5-27.5c0-3-.5-5.9-1.7-8.6c-8.1-18.4-48.4-91.9-174.3-91.9s-166.2 73.5-174.3 91.9c-1.2 2.7-1.7 5.7-1.7 8.6c0 15.2 12.3 27.5 27.5 27.5H612.5zM368 255.8a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96-32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-240 128c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H320c-17.7 0-32 14.3-32 32zm0 80c0 26.5 21.5 48 48 48H592c26.5 0 48-21.5 48-48c0-8.8-7.2-16-16-16H304c-8.8 0-16 7.2-16 16z"]],
    "mug-tea": [576, 512, [], "f875", ["M144 114.7V64h32v50.7c0 8.5 3.4 16.6 9.4 22.6l29.3 29.3c6 6 9.4 14.1 9.4 22.6V256c0 17.7-14.3 32-32 32H128c-17.7 0-32-14.3-32-32V189.3c0-8.5 3.4-16.6 9.4-22.6l29.3-29.3c6-6 9.4-14.1 9.4-22.6z", "M144 64v50.7c0 8.5-3.4 16.6-9.4 22.6l-29.3 29.3c-6 6-9.4 14.1-9.4 22.6V256c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V189.3c0-8.5-3.4-16.6-9.4-22.6l-29.3-29.3c-6-6-9.4-14.1-9.4-22.6V64H384h64c70.7 0 128 57.3 128 128s-57.3 128-128 128H416v32c0 53-43 96-96 96H128c-53 0-96-43-96-96V96c0-17.7 14.3-32 32-32h80zM416 256h32c35.3 0 64-28.7 64-64s-28.7-64-64-64H416V256z"]],
    "border-top": [448, 512, [], "f855", ["M64 160A32 32 0 1 0 0 160a32 32 0 1 0 64 0zm384 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-256 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM64 352A32 32 0 1 0 0 352a32 32 0 1 0 64 0zm320 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm-128 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM0 256a32 32 0 1 0 64 0A32 32 0 1 0 0 256zm448 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-256 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM64 448A32 32 0 1 0 0 448a32 32 0 1 0 64 0zm320 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm-128 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M0 64C0 46.3 14.3 32 32 32H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64z"]],
    "arrows-rotate": [512, 512, [128472, "refresh", "sync"], "f021", ["M80 396.9V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V320c0-17.7 14.3-32 32-32H176c17.7 0 32 14.3 32 32s-14.3 32-32 32H125.6l17.2 17.1c62.5 62.5 163.8 62.5 226.3 0c17.5-17.5 30.1-38 37.8-59.8c5.9-16.7 24.2-25.4 40.8-19.5s25.4 24.2 19.5 40.8c-10.8 30.6-28.4 59.3-52.9 83.8c-87.5 87.5-229.3 87.5-316.7 0L80 396.9z", "M105.1 202.6c7.7-21.8 20.2-42.3 37.8-59.8c62.5-62.5 163.8-62.5 226.3 0L386.3 160H336c-17.7 0-32 14.3-32 32s14.3 32 32 32H463.5c0 0 0 0 0 0h.4c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32s-32 14.3-32 32v51.2L414.4 97.6c-87.5-87.5-229.3-87.5-316.8 0C73.2 122 55.6 150.7 44.8 181.4c-5.9 16.7 2.9 34.9 19.5 40.8s34.9-2.9 40.8-19.5z"]],
    "circle-book-open": [512, 512, ["book-circle"], "e0ff", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 336c-23.1 0-41 11.1-46.3 14.8c-1.1 .8-2.4 1.2-3.7 1.2c-3.3 0-5.9-2.7-5.9-5.9V185.3c0-5.8 3.1-11.1 8.3-13.5c10.4-4.7 29.1-11.9 47.7-11.9s37.2 7.1 47.7 11.9c5.2 2.4 8.3 7.7 8.3 13.5V346.1c0 3.3-2.7 5.9-5.9 5.9c-1.3 0-2.6-.4-3.7-1.2C225 347.1 207.1 336 184 336zm144 0c-23.1 0-41 11.1-46.3 14.8c-1.1 .8-2.4 1.2-3.7 1.2c-3.3 0-5.9-2.7-5.9-5.9V185.3c0-5.8 3.1-11.1 8.3-13.5c10.4-4.7 29.1-11.9 47.7-11.9s37.2 7.1 47.7 11.9c5.2 2.4 8.3 7.7 8.3 13.5V346.1c0 3.3-2.7 5.9-5.9 5.9c-1.3 0-2.6-.4-3.7-1.2C369 347.1 351.1 336 328 336z", "M230.3 350.8C225 347.1 207.1 336 184 336s-41 11.1-46.3 14.8c-1.1 .8-2.4 1.2-3.7 1.2c-3.3 0-5.9-2.7-5.9-5.9V185.3c0-5.8 3.1-11.1 8.3-13.5c10.4-4.7 29.1-11.9 47.7-11.9s37.2 7.1 47.7 11.9c5.2 2.4 8.3 7.7 8.3 13.5V346.1c0 3.3-2.7 5.9-5.9 5.9c-1.3 0-2.6-.4-3.7-1.2zm144 0C369 347.1 351.1 336 328 336s-41 11.1-46.3 14.8c-1.1 .8-2.4 1.2-3.7 1.2c-3.3 0-5.9-2.7-5.9-5.9V185.3c0-5.8 3.1-11.1 8.3-13.5c10.4-4.7 29.1-11.9 47.7-11.9s37.2 7.1 47.7 11.9c5.2 2.4 8.3 7.7 8.3 13.5V346.1c0 3.3-2.7 5.9-5.9 5.9c-1.3 0-2.6-.4-3.7-1.2z"]],
    "arrows-to-dotted-line": [448, 512, [], "e0a6", ["M64 256A32 32 0 1 1 0 256a32 32 0 1 1 64 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm128-32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64z", "M224 0c17.7 0 32 14.3 32 32V64h32c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8h32V32c0-17.7 14.3-32 32-32zM137.4 393.4l64-64c12.5-12.5 32.8-12.5 45.3 0l64 64c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H256v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V448H160c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9z"]],
    "fire-extinguisher": [512, 512, [129519], "f134", ["M289 56H224v48h65c-.7-2.6-1-5.2-1-8V64c0-2.8 .4-5.4 1-8zM2.5 159.5c-5.8 11.9-.9 26.3 11.1 32.1s26.3 .9 32.1-11.1C62 146.9 91.8 121.1 128 110V60.4C72.7 72.6 26.7 109.8 2.5 159.5zM288 416H64v32c0 35.3 28.7 64 64 64h96c35.3 0 64-28.7 64-64V416z", "M500.3 7.3C507.7 13.3 512 22.4 512 32v96c0 9.6-4.3 18.7-11.7 24.7s-17.2 8.5-26.6 6.6l-160-32c-15-3-25.7-16.1-25.7-31.4V64c0-15.3 10.8-28.4 25.7-31.4l160-32c9.4-1.9 19.1 .6 26.6 6.6zM128 32c0-17.7 14.3-32 32-32h32c17.7 0 32 14.3 32 32V138.8c37.8 18 64 56.5 64 101.2V416H64V240c0-44.7 26.2-83.2 64-101.2V32zm48 64a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "garage-open": [640, 512, [], "e00b", ["M194.1 320l-5.2 15c-17.2 9.5-28.9 27.9-28.9 49v96c0 17.7 14.3 32 32 32s32-14.3 32-32V464H416v16c0 17.7 14.3 32 32 32s32-14.3 32-32V384c0-21.1-11.7-39.5-28.9-49l-5.2-15H395l2.8 8H242.2l2.8-8H194.1zM240 376a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm136 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z", "M0 488V171.3c0-26.2 15.9-49.7 40.2-59.4L308.1 4.8c7.6-3.1 16.1-3.1 23.8 0L599.8 111.9c24.3 9.7 40.2 33.3 40.2 59.4V488c0 13.3-10.7 24-24 24H568c-13.3 0-24-10.7-24-24V224c0-17.7-14.3-32-32-32H128c-17.7 0-32 14.3-32 32V488c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24zM512 224v64H128V224H512z"]],
    "shelves-empty": [640, 512, [], "e246", ["M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32V192 448v32c0 17.7 14.3 32 32 32s32-14.3 32-32H576c0 17.7 14.3 32 32 32s32-14.3 32-32V448 192 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V160H64V32zm0 192H576V416H64V224z", ""]],
    "cruzeiro-sign": [448, 512, [], "e152", ["M256 416V320v-8.7c0-12.8 10.4-23.3 23.3-23.3c4.6 0 9.1 1.4 12.9 3.9l10.1 6.7c14.7 9.8 34.6 5.8 44.4-8.9s5.8-34.6-8.9-44.4l-10.1-6.7c-14.3-9.6-31.2-14.7-48.4-14.7c-12.4 0-24.2 2.6-34.9 7.3c-5.5-4.5-12.6-7.3-20.3-7.3c-17.7 0-32 14.3-32 32v55.3V320v82.7c19.6 8.6 41.2 13.3 64 13.3z", "M256 96C167.6 96 96 167.6 96 256s71.6 160 160 160c41 0 78.3-15.4 106.7-40.7c13.2-11.8 33.4-10.7 45.2 2.5s10.7 33.4-2.5 45.2c-39.6 35.5-92 57-149.3 57C132.3 480 32 379.7 32 256S132.3 32 256 32c57.4 0 109.7 21.6 149.3 57c13.2 11.8 14.3 32 2.5 45.2s-32 14.3-45.2 2.5C334.3 111.4 297 96 256 96z"]],
    "watch-apple": [384, 512, [], "e2cb", ["M80 64C35.8 64 0 99.8 0 144V368c0 44.2 35.8 80 80 80H304c44.2 0 80-35.8 80-80V144c0-44.2-35.8-80-80-80H80zM192 213.3a42.7 42.7 0 1 1 0 85.3 42.7 42.7 0 1 1 0-85.3zM213.3 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-74.7-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm74.7-160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-74.7-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm224-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M112.3 0C85.6 0 64 21.6 64 48.3V65.6c5.2-1 10.5-1.6 16-1.6H304c5.5 0 10.8 .6 16 1.6V48.3C320 21.6 298.4 0 271.7 0H112.3zM64 464c0 26.5 21.5 48 48 48H272c26.5 0 48-21.5 48-48V446.4c-5.2 1-10.5 1.6-16 1.6H80c-5.5 0-10.8-.6-16-1.6V464zm181.3-80a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32-224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "watch-calculator": [384, 512, [], "f8f0", ["M80 64C35.8 64 0 99.8 0 144V368c0 44.2 35.8 80 80 80H304c44.2 0 80-35.8 80-80V144c0-44.2-35.8-80-80-80H80zm0 64H304c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H80c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16zm32 144a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm128-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM88 384a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm128-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48z", "M112.3 0C85.6 0 64 21.6 64 48.3V65.6c5.2-1 10.5-1.6 16-1.6H304c5.5 0 10.8 .6 16 1.6V48.3C320 21.6 298.4 0 271.7 0H112.3zM64 464c0 26.5 21.5 48 48 48H272c26.5 0 48-21.5 48-48V446.4c-5.2 1-10.5 1.6-16 1.6H80c-5.5 0-10.8-.6-16-1.6V464zm0-192a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm104 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm128-24a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM64 360a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm128-24a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm80 24a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z"]],
    "list-dropdown": [512, 512, [], "e1cf", ["M128 232c-13.3 0-24 10.7-24 24s10.7 24 24 24H384c13.3 0 24-10.7 24-24s-10.7-24-24-24H128zm0 88c-13.3 0-24 10.7-24 24s10.7 24 24 24H384c13.3 0 24-10.7 24-24s-10.7-24-24-24H128z", "M0 96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm64 96V416H448V192H64zM363.3 96c-7.1 0-10.7 8.6-5.7 13.7l36.7 36.7c3.1 3.1 8.2 3.1 11.3 0l36.7-36.7c5-5 1.5-13.7-5.7-13.7H363.3z"]],
    "cabinet-filing": [448, 512, [128452], "f64b", ["M0 64C0 28.7 28.7 0 64 0H384c35.3 0 64 28.7 64 64V240H0V64zM0 272H448V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V272zM128 128v16c0 8.8 7.2 16 16 16s16-7.2 16-16V128H288v16c0 8.8 7.2 16 16 16s16-7.2 16-16V128c0-17.7-14.3-32-32-32H160c-17.7 0-32 14.3-32 32zm0 256v16c0 8.8 7.2 16 16 16s16-7.2 16-16V384H288v16c0 8.8 7.2 16 16 16s16-7.2 16-16V384c0-17.7-14.3-32-32-32H160c-17.7 0-32 14.3-32 32z", "M160 96c-17.7 0-32 14.3-32 32v16c0 8.8 7.2 16 16 16s16-7.2 16-16V128H288v16c0 8.8 7.2 16 16 16s16-7.2 16-16V128c0-17.7-14.3-32-32-32H160zm0 256c-17.7 0-32 14.3-32 32v16c0 8.8 7.2 16 16 16s16-7.2 16-16V384H288v16c0 8.8 7.2 16 16 16s16-7.2 16-16V384c0-17.7-14.3-32-32-32H160zM0 272H448V240H0v32z"]],
    "burger-soda": [640, 512, [], "f858", ["M194.8 43.2C200.8 17.9 223.4 0 249.3 0H280c13.3 0 24 10.7 24 24s-10.7 24-24 24H249.3c-3.7 0-6.9 2.6-7.8 6.2L224.2 128H352c17.7 0 32 14.3 32 32c0 3.9-.7 7.6-2 11.1c-18.5 5.5-34.7 12.7-48.6 20.9H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H174.9l20-84.8zM292.6 224c-18.4 19.1-28 37.5-32.2 47c-3.4 7.7-4.4 15.3-4.4 21.5c0 17.8 7.9 33.9 20.3 44.8C263.8 348.9 256 365.5 256 384c0 16.7 6.4 32 17 43.4c-10.4 8.8-17 21.9-17 36.6c0 18 6 34.6 16 48H108.2c-25 0-45.8-19.1-47.8-44L40 224H292.6z", "M612.5 319.8c15.2 0 27.5-12.3 27.5-27.5c0-3-.5-5.9-1.7-8.6c-8.1-18.4-48.4-91.9-174.3-91.9s-166.2 73.5-174.3 91.9c-1.2 2.7-1.7 5.7-1.7 8.6c0 15.2 12.3 27.5 27.5 27.5H612.5zM368 255.8a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96-32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-240 128c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H320c-17.7 0-32 14.3-32 32zm0 80c0 26.5 21.5 48 48 48H592c26.5 0 48-21.5 48-48c0-8.8-7.2-16-16-16H304c-8.8 0-16 7.2-16 16z"]],
    "square-arrow-up": [448, 512, ["arrow-square-up"], "f33c", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm177 87L353 231c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-71-71V376c0 13.3-10.7 24-24 24s-24-10.7-24-24V193.9l-71 71c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L207 119c9.4-9.4 24.6-9.4 33.9 0z", "M207 119c9.4-9.4 24.6-9.4 33.9 0L353 231c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-71-71V376c0 13.3-10.7 24-24 24s-24-10.7-24-24V193.9l-71 71c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L207 119z"]],
    "greater-than-equal": [448, 512, [], "f532", ["M34.3 52.1c-6.6 16.4 1.4 35 17.8 41.6L297.8 192 52.1 290.3c-16.4 6.6-24.4 25.2-17.8 41.6s25.2 24.4 41.6 17.8l320-128C408 216.9 416 205.1 416 192s-8-24.9-20.1-29.7l-320-128c-16.4-6.6-35 1.4-41.6 17.8z", "M448 448c0-17.7-14.3-32-32-32H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H416c17.7 0 32-14.3 32-32z"]],
    "pallet-box": [640, 512, [], "e208", ["M256 0V16v96c0 5.9 3.2 11.3 8.5 14.1s11.5 2.5 16.4-.8L320 99.2l39.1 26.1c4.9 3.3 11.2 3.6 16.4 .8s8.5-8.2 8.5-14.1V16 0H368 272 256zM32 320c-17.7 0-32 14.3-32 32s14.3 32 32 32H64v64H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H96 320 544h64c17.7 0 32-14.3 32-32s-14.3-32-32-32H576V384h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H544 320 96 32zm96 128V384H288v64H128zm224 0V384H512v64H352z", "M256 0H176c-26.5 0-48 21.5-48 48V208c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H384V112c0 5.9-3.2 11.3-8.5 14.1s-11.5 2.5-16.4-.8L320 99.2l-39.1 26.1c-4.9 3.3-11.2 3.6-16.4 .8s-8.5-8.2-8.5-14.1V0z"]],
    "face-confounded": [512, 512, [], "e36c", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM116 205.1c0-9 9.6-14.7 17.5-10.5l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm262.5-10.5c7.9-4.2 17.5 1.5 17.5 10.5c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9zm-161.6 160L256 380.8l39.1-26.1c5.4-3.6 12.4-3.6 17.8 0l40.3 26.8 23.7-11.8c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5l-32 16c-5.1 2.6-11.3 2.2-16-1L304 387.2l-39.1 26.1c-5.4 3.6-12.4 3.6-17.8 0L208 387.2l-39.1 26.1c-4.8 3.2-10.9 3.6-16 1l-32-16c-7.9-4-11.1-13.6-7.2-21.5s13.6-11.1 21.5-7.2l23.7 11.8 40.3-26.8c5.4-3.6 12.4-3.6 17.8 0z", "M116 205.1c0-9 9.6-14.7 17.5-10.5l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm280 0c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z"]],
    "shield-halved": [512, 512, ["shield-alt"], "f3ed", ["M256 0c.2 0 .5 0 .7 0c4.6 0 9.2 1 13.4 2.9L458.4 82.8c22 9.3 38.4 31 38.3 57.2c-.5 99.2-41.3 280.7-213.6 363.2c-8.3 4-17.4 6-26.4 6V0H256z", "M256.7 0c-.2 0-.5 0-.7 0c-4.6 0-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c8.3 4 17.4 6 26.4 6V0h.7z"]],
    "truck-plow": [640, 512, [], "f7de", ["M128 480a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm224 0a80 80 0 1 0 0-160 80 80 0 1 0 0 160z", "M269.9 96l57.6 96H192V96h77.9zm132.2 96L324.8 63.1C313.2 43.8 292.4 32 269.9 32H176c-26.5 0-48 21.5-48 48V192H32c-17.7 0-32 14.3-32 32v96c0 16 11.7 29.2 27 31.6C45 314 83.5 288 128 288c44.7 0 83.2 26.2 101.2 64h21.6c18-37.8 56.5-64 101.2-64s83.2 26.2 101.2 64H512v16c0 7.3 2.5 14.3 7 20l64 80c11 13.8 31.2 16 45 5s16-31.2 5-45l-57-71.2V320 187.2L633 116c11-13.8 8.8-33.9-5-45s-33.9-8.8-45 5l-64 80c-4.5 5.7-7 12.7-7 20V288H480V224c0-17.7-14.3-32-32-32H402.1z"]],
    "book-atlas": [448, 512, ["atlas"], "f558", ["M64 416c0-17.7 14.3-32 32-32H416v64H96c-17.7 0-32-14.3-32-32z", "M96 0C43 0 0 43 0 96V416c0 53 43 96 96 96H384h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H352 256 96c-17.7 0-32-14.3-32-32s14.3-32 32-32H256h96 64c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H384 96zM247.4 283.8c3.8-3.7 8-10 11.8-18.9c6.2-14.5 10.8-34.3 12.2-56.9h-63c1.5 22.6 6 42.4 12.2 56.9c3.8 8.9 8 15.2 11.8 18.9c3.7 3.7 6.2 4.2 7.4 4.2s3.7-.5 7.4-4.2zm42.7-9.9c23.2-14.2 39.9-38 44.5-65.9H303.5c-1.4 24.7-6.1 47.5-13.4 65.9zm0-163.8c7.3 18.3 12 41.1 13.4 65.9h31.1c-4.7-27.9-21.4-51.7-44.5-65.9zM112 192a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm33.3 16c4.7 27.9 21.4 51.7 44.5 65.9c-7.3-18.3-12-41.1-13.4-65.9H145.3zm31.1-32c1.4-24.7 6.1-47.5 13.4-65.9c-23.2 14.2-39.9 38-44.5 65.9h31.1zm56.1-75.8c-3.8 3.7-8 10-11.8 18.9c-6.2 14.5-10.8 34.3-12.2 56.9h63c-1.5-22.6-6-42.4-12.2-56.9c-3.8-8.9-8-15.2-11.8-18.9c-3.7-3.7-6.2-4.2-7.4-4.2s-3.7 .5-7.4 4.2z"]],
    "virus": [512, 512, [], "e074", ["M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V43.5c0 49.9-60.3 74.9-95.6 39.6L120.2 75C107.7 62.5 87.5 62.5 75 75s-12.5 32.8 0 45.3l8.2 8.2C118.4 163.7 93.4 224 43.5 224H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H43.5c49.9 0 74.9 60.3 39.6 95.6L75 391.8c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l8.2-8.2c35.3-35.3 95.6-10.3 95.6 39.6V480c0 17.7 14.3 32 32 32s32-14.3 32-32V468.5c0-49.9 60.3-74.9 95.6-39.6l8.2 8.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-8.2-8.2c-35.3-35.3-10.3-95.6 39.6-95.6H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H468.5c-49.9 0-74.9-60.3-39.6-95.6l8.2-8.2c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-8.2 8.2C348.3 118.4 288 93.4 288 43.5V32zM176 224a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm128 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48z", "M224 176a48 48 0 1 0 0 96 48 48 0 1 0 0-96z"]],
    "grid-round-2": [512, 512, [], "e5db", ["M384 32a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM128 288a96 96 0 1 0 0 192 96 96 0 1 0 0-192z", "M128 32a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM384 288a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]],
    "comment-middle-top": [512, 512, [], "e14a", ["M188.3 103.3l44.5-89C237.2 5.5 246.2 0 256 0s18.8 5.5 23.2 14.3l44.5 89C432.2 127.5 512 208.2 512 304c0 114.9-114.6 208-256 208S0 418.9 0 304c0-95.8 79.8-176.5 188.3-200.7z", ""]],
    "envelope-circle-check": [640, 512, [], "e4e8", ["M0 112C0 85.5 21.5 64 48 64H464c26.5 0 48 21.5 48 48c0 15.1-7.1 29.3-19.2 38.4l-13.9 10.4c-66.6 6.4-122.4 50-146.3 109.8l-57.4 43c-11.4 8.5-27 8.5-38.4 0L19.2 150.4C7.1 141.3 0 127.1 0 112zM320.8 319.4c-.5 5.5-.8 11-.8 16.6c0 42.5 15.1 81.6 40.2 112H64c-35.3 0-64-28.7-64-64V176L217.6 339.2c22.8 17.1 54 17.1 76.8 0l26.4-19.8z", "M496 480a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 353.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "layer-group": [576, 512, [], "f5fd", ["M324.9 279.8l152-70.2 53.2 24.6c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 277.8C37.4 273.8 32 265.3 32 256s5.4-17.9 13.9-21.8l53.2-24.6 152 70.2c23.4 10.8 50.4 10.8 73.8 0z", "M264.5 5.2c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 149.8C37.4 145.8 32 137.3 32 128s5.4-17.9 13.9-21.8L264.5 5.2zM476.9 337.6l53.2 24.6c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 405.8C37.4 401.8 32 393.3 32 384s5.4-17.9 13.9-21.8l53.2-24.6 152 70.2c23.4 10.8 50.4 10.8 73.8 0l152-70.2z"]],
    "restroom-simple": [640, 512, [], "e23a", ["M128 128A64 64 0 1 0 128 0a64 64 0 1 0 0 128zm-22.4 32c-41.6 0-76.3 31.9-79.7 73.4l-4.1 49.3c-2.5 29.8 15.7 56.1 42.2 65.6V464c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V348.3c26.5-9.5 44.7-35.8 42.2-65.6l-4.1-49.3C226.7 191.9 192 160 150.4 160H105.6zM512 128A64 64 0 1 0 512 0a64 64 0 1 0 0 128zm-15.7 32c-28.6 0-53.7 18.9-61.5 46.4L395.7 343.2c-5.8 20.4 9.5 40.8 30.8 40.8H448v80c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V384h21.6c21.3 0 36.6-20.3 30.8-40.8L589.3 206.4c-7.8-27.5-33-46.4-61.5-46.4H496.3z", "M320 0c13.3 0 24 10.7 24 24V488c0 13.3-10.7 24-24 24s-24-10.7-24-24V24c0-13.3 10.7-24 24-24z"]],
    "arrows-to-dot": [512, 512, [], "e4be", ["", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 50.7-9.4-9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L288 82.7 288 32zM393.4 342.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H429.3l9.4-9.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64zM118.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4L32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32H82.7l-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64zm50.7 269.3c12.5 12.5 32.8 12.5 45.3 0l9.4-9.4 0 50.7c0 17.7 14.3 32 32 32s32-14.3 32-32V429.3l9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3zM256 224a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"]],
    "border-outer": [448, 512, [], "f851", ["M256 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-96 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm128-32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64z", "M384 96V416H64L64 96H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64z"]],
    "hashtag-lock": [576, 512, [], "e415", ["M207.6 69.3c2.9-17.4-8.9-33.9-26.3-36.8s-33.9 8.9-36.8 26.3L132.9 128H64c-17.7 0-32 14.3-32 32s14.3 32 32 32h58.2L100.9 320H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H90.2l-9.8 58.7c-2.9 17.4 8.9 33.9 26.3 36.8s33.9-8.9 36.8-26.3L155.1 384h95.1l-9.8 58.7c-2.9 17.4 8.9 33.9 26.3 36.8s33.9-8.9 36.8-26.3L320 354.7V352c0-8.1 1.5-15.9 4.3-23.1L347.1 192h38.5c16.6-16.3 38.2-27.4 62.4-30.9c0-.4 0-.8 0-1.1c0-17.7-14.3-32-32-32H357.8l9.8-58.7c2.9-17.4-8.9-33.9-26.3-36.8s-33.9 8.9-36.8 26.3L292.9 128H197.8l9.8-58.7zM165.8 320l21.3-128h95.1L260.9 320H165.8z", "M432 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H384c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "clock-two-thirty": [512, 512, [], "e35b", ["M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V256c0-8 4-15.5 10.7-20l96-64c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3L280 268.8V392c0 13.3-10.7 24-24 24s-24-10.7-24-24z", "M256 416c-13.3 0-24-10.7-24-24V256c0-8 4-15.5 10.7-20l96-64c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3L280 268.8V392c0 13.3-10.7 24-24 24z"]],
    "archway": [512, 512, [], "f557", ["M480 96H32v64H480V96zm0 96H32V416c-17.7 0-32 14.3-32 32s14.3 32 32 32h96 32V416 352c0-53 43-96 96-96s96 43 96 96v64 64h32 96c17.7 0 32-14.3 32-32s-14.3-32-32-32V192z", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H32zM480 160H32v32H480V160z"]],
    "heart-circle-check": [576, 512, [], "e4fd", ["M228.3 469.1L47.6 300.4C17.2 272.1 0 232.4 0 190.9v-5.8c0-69.9 50.5-129.5 119.4-141C165 36.5 211.4 51.4 244 84l12 12 12-12c32.6-32.6 79-47.5 124.6-39.9C461.5 55.6 512 115.2 512 185.1v5.8c0 6.6-.4 13.2-1.3 19.6C487 198.7 460.3 192 432 192c-97.2 0-176 78.8-176 176c0 36.6 11.2 70.6 30.3 98.7l-2.6 2.4c-7.5 7-17.4 10.9-27.7 10.9s-20.2-3.9-27.7-10.9z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L416 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "house-chimney-crack": [576, 512, ["house-damage"], "f6f1", ["M64.1 448L64 270.5l224-196L512.1 270.6l.4 177.3c.1 35.4-28.6 64.1-64 64.1H326.4L288 448l80.8-67.3c7.8-6.5 7.6-18.6-.4-24.9L250.6 263.2c-14.6-11.5-33.8 7-22.8 22L288 368l-85.5 71.2c-6.1 5-7.5 13.8-3.5 20.5L230.4 512H128.1c-35.3 0-64-28.6-64-64z", "M309.1 7.9C297-2.6 279-2.6 266.9 7.9l-256 224c-13.3 11.6-14.6 31.9-3 45.2s31.9 14.6 45.2 3L288 74.5 522.9 280.1c13.3 11.6 33.5 10.3 45.2-3s10.3-33.5-3-45.2L512 185.5V64c0-17.7-14.3-32-32-32H448c-17.7 0-32 14.3-32 32v37.5L309.1 7.9z"]],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM96 48c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zM66.1 335.9c-1.4 5.4-2.1 10.9-2.1 16.4c0 35.2 28.8 63.7 64 63.7s64-28.5 64-63.7c0-5.5-.7-11.1-2.1-16.4l-23.5-88.2c-3.7-14-16.4-23.8-30.9-23.8H120.6c-14.5 0-27.2 9.7-30.9 23.8L66.1 335.9z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM96 48c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm-6.3 71.8L66.1 335.9c-1.4 5.4-2.1 10.9-2.1 16.4c0 35.2 28.8 63.7 64 63.7s64-28.5 64-63.7c0-5.5-.7-11.1-2.1-16.4l-23.5-88.2c-3.7-14-16.4-23.8-30.9-23.8H120.6c-14.5 0-27.2 9.7-30.9 23.8zM112 336h32c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]],
    "heart-half": [512, 512, [], "e1ab", ["M256 480V96l12-12c32.6-32.6 79-47.5 124.6-39.9C461.5 55.6 512 115.2 512 185.1v5.8c0 41.5-17.2 81.2-47.6 109.5L283.7 469.1c-7.5 7-17.4 10.9-27.7 10.9z", "M256 96L244 84l0 0c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1v5.8c0 41.5 17.2 81.2 47.6 109.5L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9l0-50.7 0-265.4V96z"]],
    "comment-check": [512, 512, [], "f4ac", ["M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM369 193L241 321c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 159c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z", "M369 159c9.4 9.4 9.4 24.6 0 33.9L241 321c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 159c9.4-9.4 24.6-9.4 33.9 0z"]],
    "square": [448, 512, [9632, 9723, 9724, 61590], "f0c8", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96z", ""]],
    "memo": [384, 512, [], "e1d8", ["M0 64C0 28.7 28.7 0 64 0H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zm64 80c0 8.8 7.2 16 16 16H304c8.8 0 16-7.2 16-16s-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16s7.2 16 16 16H304c8.8 0 16-7.2 16-16s-7.2-16-16-16H80zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16H208c8.8 0 16-7.2 16-16s-7.2-16-16-16H80z", "M80 128c-8.8 0-16 7.2-16 16s7.2 16 16 16H304c8.8 0 16-7.2 16-16s-7.2-16-16-16H80zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16H304c8.8 0 16-7.2 16-16s-7.2-16-16-16H80zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16H208c8.8 0 16-7.2 16-16s-7.2-16-16-16H80z"]],
    "martini-glass-empty": [512, 512, ["glass-martini"], "f000", ["M32 0C19.1 0 7.4 7.8 2.4 19.8s-2.2 25.7 6.9 34.9L224 269.3V448H160c-17.7 0-32 14.3-32 32s14.3 32 32 32h96 96c17.7 0 32-14.3 32-32s-14.3-32-32-32H288V269.3L502.6 54.6c9.2-9.2 11.9-22.9 6.9-34.9S492.9 0 480 0H32zM256 210.7L109.3 64H402.7L256 210.7z", ""]],
    "couch": [640, 512, [], "f4b8", ["M192 32C121.3 32 64 89.3 64 160v66.7c18.6 6.6 32 24.4 32 45.3v80H544V272c0-20.9 13.4-38.7 32-45.3V160c0-70.7-57.3-128-128-128H192z", "M48 224c-26.5 0-48 21.5-48 48V448c0 17.7 14.3 32 32 32H64c17.7 0 32-14.3 32-32H544c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V272c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H96V272c0-26.5-21.5-48-48-48z"]],
    "cedi-sign": [384, 512, [], "e0df", ["M256 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V66.7c10.4-1.7 21.1-2.7 32-2.7s21.6 .9 32 2.7V32zm0 100c-10.2-2.6-20.9-4-32-4c-11 0-21.8 1.4-32 4V380c10.2 2.6 21 4 32 4c11.1 0 21.8-1.4 32-4V132zm0 313.3c-10.4 1.7-21.1 2.7-32 2.7s-21.6-.9-32-2.7V480c0 17.7 14.3 32 32 32s32-14.3 32-32V445.3z", "M224 128c-70.7 0-128 57.3-128 128s57.3 128 128 128c28.9 0 55.4-9.5 76.8-25.6c14.1-10.6 34.2-7.8 44.8 6.4s7.8 34.2-6.4 44.8C307.1 433.7 267.2 448 224 448C118 448 32 362 32 256S118 64 224 64c43.2 0 83.1 14.3 115.2 38.4c14.1 10.6 17 30.7 6.4 44.8s-30.7 17-44.8 6.4C279.4 137.5 252.9 128 224 128z"]],
    "italic": [384, 512, [], "f033", ["M128 64c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H293.3L160 416h64c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H90.7L224 96H160c-17.7 0-32-14.3-32-32z", ""]],
    "glass-citrus": [512, 512, [], "f869", ["M8.3 138.5C14.3 131.8 23 128 32 128H320c9 0 17.7 3.8 23.7 10.5s9 15.7 8.1 24.7L322.7 454.4C319.5 487.1 291.9 512 259 512H93c-32.9 0-60.4-24.9-63.7-57.6L.2 163.2c-.9-9 2-18 8.1-24.7zM67.4 192L93 448 259 448l25.6-256H67.4z", "M448 144c0 44.2-35.8 80-80 80c-7.6 0-15-1.1-21.9-3l-6.4 64.3c9.2 1.8 18.7 2.8 28.4 2.8c79.5 0 144-64.5 144-144S447.5 0 368 0C293.9 0 232.8 56 224.9 128h64.7C297 91.5 329.3 64 368 64c44.2 0 80 35.8 80 80zM73.8 256L93 448 259 448l19.2-192H73.8z"]],
    "calendar-lines-pen": [576, 512, [], "e472", ["M96 32V64H48C21.5 64 0 85.5 0 112v48H448V112c0-26.5-21.5-48-48-48H352V32c0-17.7-14.3-32-32-32s-32 14.3-32 32V64H160V32c0-17.7-14.3-32-32-32S96 14.3 96 32zM448 192H0V464c0 26.5 21.5 48 48 48H258.8c-3.1-8.8-3.7-18.4-1.4-27.8l15-60.1c2.8-11.3 8.6-21.5 16.8-29.7L448 235.6V192zM96 296c0-13.3 10.7-24 24-24H264c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24zm24 72h80c13.3 0 24 10.7 24 24s-10.7 24-24 24H120c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M493.2 235.7l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-52 52L311.9 417c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L512.1 358.7l-71-71z"]],
    "church": [640, 512, [9962], "f51d", ["M160 256L24.9 330.3C9.5 338.8 0 354.9 0 372.4V464c0 26.5 21.5 48 48 48H160V256zM480 512H592c26.5 0 48-21.5 48-48V372.4c0-17.5-9.5-33.6-24.9-42.1L480 256V512z", "M320 0c13.3 0 24 10.7 24 24V48h32c13.3 0 24 10.7 24 24s-10.7 24-24 24H344v46.4L456.7 210c14.5 8.7 23.3 24.3 23.3 41.2V512H384V416c0-35.3-28.7-64-64-64s-64 28.7-64 64v96H160V251.2c0-16.9 8.8-32.5 23.3-41.2L296 142.4V96H264c-13.3 0-24-10.7-24-24s10.7-24 24-24h32V24c0-13.3 10.7-24 24-24z"]],
    "person-snowmobiling": [640, 512, ["snowmobile"], "f7d1", ["M288 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 288H264l-72-32 32-48 29.3 29.3c12 12 28.3 18.7 45.3 18.7H312l48-64H304l-61.7-55.6c-11.8-10.6-27-16.4-42.8-16.4h-.9c-23.7 0-45.5 13.1-56.6 34.1l-35.3 66.6c-11.4 21.6-9.4 47.8 5.3 67.4zM450 416l36 48H440c-13.3 0-24 10.7-24 24s10.7 24 24 24H576c6.4 0 12.5-2.5 17-7l40-40c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-33 33H546l-46-61.3L480 416H450zM0 464c0 26.5 21.5 48 48 48H272c26.5 0 48-21.5 48-48s-21.5-48-48-48H48c-26.5 0-48 21.5-48 48z", "M373.5 85.3c-5.9-11.9-20.3-16.7-32.2-10.7s-16.7 20.3-10.7 32.2l37.4 74.7L288 288H99.8c-12.1 0-23.2 6.8-28.6 17.7l-32 64c-2.5 5-3.6 10.2-3.4 15.2c4-.6 8.1-.9 12.3-.9H272c26.2 0 49.4 12.6 64 32H480l88.9-59.3c4.5-3 7.1-8 7.1-13.3V265.9c0-6.1-3.4-11.6-8.8-14.3L419.8 177.9 373.5 85.3z"]],
    "face-hushed": [512, 512, [], "e37b", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM179 160.9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16c-4.4 0-8.8 .3-13 .9zm141-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8c-4.3-.6-8.6-.9-13-.9zM256 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96z", "M192 160c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm-15.6 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM333 160.9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z"]],
    "comments-dollar": [640, 512, [], "f653", ["M208 352c114.9 0 208-78.8 208-176S322.9 0 208 0S0 78.8 0 176c0 38.6 14.7 74.3 39.6 103.4c-3.5 9.4-8.7 17.7-14.2 24.7c-4.8 6.2-9.7 11-13.3 14.3c-1.8 1.6-3.3 2.9-4.3 3.7c-.5 .4-.9 .7-1.1 .8l-.2 .2 0 0 0 0C1 327.2-1.4 334.4 .8 340.9S9.1 352 16 352c21.8 0 43.8-5.6 62.1-12.5c9.2-3.5 17.8-7.4 25.2-11.4C134.1 343.3 169.8 352 208 352zM228 72V85.9c7.5 1.2 14.6 2.9 21.1 4.7c10.7 2.8 17 13.8 14.2 24.5s-13.8 17-24.5 14.2c-11-2.9-21.6-5-31.2-5.2c-7.9-.1-16 1.8-21.5 5c-4.8 2.8-6.2 5.6-6.2 9.3c0 1.8 .1 3.5 5.3 6.7c6.3 3.8 15.5 6.7 28.3 10.5l.7 .2c11.2 3.4 25.6 7.7 37.1 15c12.9 8.1 24.3 21.3 24.6 41.6c.3 20.9-10.5 36.1-24.8 45c-7.2 4.5-15.2 7.3-23.2 9V280c0 11-9 20-20 20s-20-9-20-20V265.4c-10.3-2.2-20-5.5-28.2-8.4l0 0 0 0c-2.1-.7-4.1-1.4-6.1-2.1c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6c2.5 .8 4.9 1.7 7.2 2.4c13.6 4.6 24 8.1 35.1 8.5c8.6 .3 16.5-1.6 21.4-4.7c4.1-2.5 6-5.5 5.9-10.5c0-2.9-.8-5-5.9-8.2c-6.3-4-15.4-6.9-28-10.7l-1.7-.5c-10.9-3.3-24.6-7.4-35.6-14c-12.7-7.7-24.6-20.5-24.7-40.7c-.1-21.1 11.8-35.7 25.8-43.9c6.9-4.1 14.5-6.8 22.2-8.5V72c0-11 9-20 20-20s20 9 20 20z", "M228 72c0-11-9-20-20-20s-20 9-20 20V86c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1l0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4V280c0 11 9 20 20 20s20-9 20-20V266.2c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7V72zM448 176c0 112.3-99.1 196.9-216.5 207C255.8 457.4 336.4 512 432 512c38.2 0 73.9-8.7 104.7-23.9c7.5 4 16 7.9 25.2 11.4c18.3 6.9 40.3 12.5 62.1 12.5c6.9 0 13.1-4.5 15.2-11.1c2.1-6.6-.2-13.8-5.8-17.9l0 0 0 0-.2-.2c-.2-.2-.6-.4-1.1-.8c-1-.8-2.5-2-4.3-3.7c-3.6-3.3-8.5-8.1-13.3-14.3c-5.5-7-10.7-15.4-14.2-24.7c24.9-29 39.6-64.7 39.6-103.4c0-92.8-84.9-168.9-192.6-175.5c.4 5.1 .6 10.3 .6 15.5z"]],
    "pickaxe": [512, 512, [], "e5bf", ["M360.2 208.8L54.2 503.1c-12.6 12.1-32.5 11.9-44.8-.4S-3.1 470.4 8.9 457.8l294.2-306c9.9 8.6 19.8 17.7 29.5 27.5s18.9 19.7 27.5 29.5zm100.2-96.3c-16.9-23.4-37.5-43.9-60.9-60.9l9.4-9.8c6-6.2 14.2-9.7 22.8-9.8s16.9 3.3 22.9 9.4l16 16c6.1 6.1 9.5 14.3 9.4 22.9s-3.6 16.8-9.8 22.8l-9.8 9.4z", "M462.4 373.5l0 0 0 0c2.3 6.2 8.2 10.4 14.8 10.5s12.6-3.9 15.1-10C505 342.5 512 308 512 272C512 121.8 390.2 0 240 0c-36 0-70.5 7-102 19.8c-6.1 2.5-10.1 8.5-10 15.1s4.3 12.5 10.5 14.8l0 0 0 0 .2 .1 .8 .3c.7 .3 1.8 .7 3.3 1.3c2.9 1.2 7.2 3 12.7 5.5c11 5 26.7 12.6 45.3 23.1c37.3 21 86 53.6 132 99.5s78.5 94.7 99.5 132c10.5 18.6 18.1 34.3 23.1 45.3c2.5 5.5 4.3 9.8 5.5 12.7c.6 1.4 1 2.5 1.3 3.3l.3 .8 .1 .2z"]],
    "link-simple-slash": [640, 512, [], "e1ce", ["M121 191.4c-15.5 17.1-25 39.7-25 64.6c0 53 43 96 96 96h64c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-88.4 0-160-71.6-160-160c0-39.9 14.6-76.3 38.7-104.3L121 191.4zM399.7 288l-81.7-64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H399.7zM532.4 392l-56.3-44.1c39.3-12 67.9-48.6 67.9-91.8c0-53-43-96-96-96H384c-17.7 0-32-14.3-32-32s14.3-32 32-32h64c88.4 0 160 71.6 160 160c0 57.4-30.2 107.7-75.6 136zm-296-232L159.1 99.4C169.7 97.2 180.7 96 192 96h64c17.7 0 32 14.3 32 32s-14.3 32-32 32H236.4z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "democrat": [640, 512, [], "f747", ["M192 320H544v32 64 64c0 17.7-14.3 32-32 32H480c-17.7 0-32-14.3-32-32V416H288v64c0 17.7-14.3 32-32 32H224c-17.7 0-32-14.3-32-32V416 352 320z", "M64 32c0-8.9 3.8-20.9 6.2-27.3C71.2 1.8 74 0 77 0c1.9 0 3.8 .7 5.2 2.1L128 45.7 173.8 2.1C175.2 .7 177.1 0 179 0c3 0 5.8 1.8 6.8 4.7c2.4 6.5 6.2 18.4 6.2 27.3c0 26.5-21.9 42-29.5 46.6l76.2 72.6c6 5.7 13.9 8.8 22.1 8.8H480l32 0c40.3 0 78.2 19 102.4 51.2l19.2 25.6c10.6 14.1 7.7 34.2-6.4 44.8s-34.2 7.7-44.8-6.4l-19.2-25.6c-5.3-7-11.8-12.8-19.2-17V320H192l-40.4-94.3c-3.9-9.2-15.3-12.6-23.6-7l-42.1 28c-9.1 6.1-19.7 9.3-30.7 9.3h-2C23.9 256 0 232.1 0 202.7c0-12.1 4.1-23.8 11.7-33.3L87.6 74.6C78.1 67.4 64 53.2 64 32zM260.9 210.9c-.9-1.8-2.8-2.9-4.8-2.9s-3.9 1.1-4.8 2.9l-10.5 20.5-23.5 3.3c-2 .3-3.7 1.6-4.3 3.5s-.1 3.9 1.3 5.3l17 16-4 22.6c-.3 1.9 .5 3.9 2.1 5s3.8 1.3 5.6 .4l21-10.7 21 10.7c1.8 .9 4 .8 5.6-.4s2.5-3.1 2.1-5l-4-22.6 17-16c1.5-1.4 2-3.4 1.3-5.3s-2.3-3.2-4.3-3.5l-23.5-3.3-10.5-20.5zM368.1 208c-2 0-3.9 1.1-4.8 2.9l-10.5 20.5-23.5 3.3c-2 .3-3.7 1.6-4.3 3.5s-.1 3.9 1.3 5.3l17 16-4 22.6c-.3 1.9 .5 3.9 2.1 5s3.8 1.3 5.6 .4l21-10.7 21 10.7c1.8 .9 4 .8 5.6-.4s2.5-3.1 2.1-5l-4-22.6 17-16c1.5-1.4 2-3.4 1.4-5.3s-2.3-3.2-4.3-3.5l-23.5-3.3-10.5-20.5c-.9-1.8-2.8-2.9-4.8-2.9zm116.8 2.9c-.9-1.8-2.8-2.9-4.8-2.9s-3.9 1.1-4.8 2.9l-10.5 20.5-23.5 3.3c-2 .3-3.7 1.6-4.3 3.5s-.1 3.9 1.3 5.3l17 16-4 22.6c-.3 1.9 .5 3.9 2.1 5s3.8 1.3 5.6 .4l21-10.7 21 10.7c1.8 .9 4 .8 5.6-.4s2.5-3.1 2.1-5l-4-22.6 17-16c1.5-1.4 2-3.4 1.4-5.3s-2.3-3.2-4.3-3.5l-23.5-3.3-10.5-20.5z"]],
    "face-confused": [512, 512, [], "e36d", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM171.1 395.6l-1.1 .9c-6.9 5.5-17 4.4-22.5-2.5s-4.4-17 2.5-22.5l1.1-.9C205 327.5 272 304 341 304h11c8.8 0 16 7.2 16 16s-7.2 16-16 16H341c-61.8 0-121.7 21-169.9 59.6zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "pinball": [448, 512, [], "e229", ["", "M412.1 463.4c-7.2 13.2-23.1 19.9-37.9 15L66.3 379.3c-12.1-3.9-22.8-10-32-17.7c-40.6-34.1-46-94.7-11.9-135.3s94.6-45.9 135.2-11.8l246 208.3c12.6 9.8 15.8 27.1 8.4 40.6zM96 320a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM352 32a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]],
    "z": [384, 512, [122], "5a", ["M0 64C0 46.3 14.3 32 32 32H352c12.4 0 23.7 7.2 29 18.4s3.6 24.5-4.4 34.1L100.3 416H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-12.4 0-23.7-7.2-29-18.4s-3.6-24.5 4.4-34.1L283.7 96H32C14.3 96 0 81.7 0 64z", ""]],
    "person-skiing": [512, 512, [9975, "skiing"], "f7c9", ["M174.3 71.2l-8.3 16.5 177.1 83 8.4 25.1c2.6 7.9 7.2 14.9 13.2 20.3l-3.6-1.7L151.7 116.3l-9.4 18.9c-4 7.9-13.6 11.1-21.5 7.2s-11.1-13.6-7.2-21.5l9.1-18.1-17.5-8.2c-8-3.8-11.4-13.3-7.7-21.3s13.3-11.4 21.3-7.7l18.3 8.6 8.6-17.2c4-7.9 13.6-11.1 21.5-7.2s11.1 13.6 7.2 21.5zM2.7 268.9c6.1-11.8 20.6-16.3 32.4-10.2L418.5 457.8c13.6 7.1 29.8 7.2 43.6 .3l15.2-7.6c11.9-5.9 26.3-1.1 32.2 10.7s1.1 26.3-10.7 32.2l-15.2 7.6c-27.5 13.7-59.9 13.5-87.2-.7L12.9 301.3C1.2 295.2-3.4 280.7 2.7 268.9z", "M428.7 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-35.6 22.1c-11.6-34.9-50.3-52.9-84.5-39.2l-83.4 33.4c-1.2 .5-2.3 1-3.5 1.5l121.4 56.9 1 2.9 7.4 22.2c2.6 7.9 7.2 14.9 13.2 20.3l0 0c3.2 2.9 6.9 5.4 10.8 7.4l58.1 29c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9l-52.1-26.1-17.1-51.2zM203.7 216.9l75.1 75.1-46.2 69.2L289.8 391l49.5-74.3c12.7-19 10.2-44.4-6-60.6l-39.3-39.3-108.8-52c-2 18.3 3.7 37.5 18.4 52.1z"]],
    "deer": [512, 512, [129420], "f78e", ["M240 0c8.8 0 16 7.2 16 16V40c0 13.3 10.7 24 24 24h8 8c13.3 0 24-10.7 24-24V16c0-8.8 7.2-16 16-16s16 7.2 16 16V40c0 8.6-1.9 16.7-5.4 24H352c8.8 0 16 7.2 16 16s-7.2 16-16 16H296h-8-8c-30.9 0-56-25.1-56-56V16c0-8.8 7.2-16 16-16zM456 0c8.8 0 16 7.2 16 16V40c0 21.7-12.3 40.4-30.3 49.8C428.3 77 411.5 68.6 393.4 65.4c2-.9 4.2-1.4 6.6-1.4h16c13.3 0 24-10.7 24-24V16c0-8.8 7.2-16 16-16z", "M320 96l32 0c8.8 0 16-7.2 16-16c0-5.6-2.9-10.6-7.3-13.5c5.3-1.7 10.9-2.5 16.6-2.5c24.8 0 48.6 9.9 66.2 27.4l55.3 55.3c8.5 8.5 13.3 20 13.3 32c0 25-20.3 45.3-45.3 45.3H416h-5.3L384 304v64V480c0 17.7-14.3 32-32 32H320c-17.7 0-32-14.3-32-32V368H251.7c-28.8 0-55.3-9.8-76.3-26.4c-2.1 16.9-9.8 32.6-21.9 44.8L142.9 397c-4.6 4.6-6.2 11.5-4 17.7l19.3 54.7c7.3 20.8-8.1 42.6-30.2 42.6H94.1c-13.6 0-25.7-8.6-30.2-21.4l-15.5-44c-11.4-32.4-7.4-67.8 10-96.3C65 339.4 65 324.9 56 315.9c-3-3-5.7-6.1-8.1-9.5c-1.3 12.9-12.7 22.5-25.7 21.5C8.9 326.9-.9 315.4 .1 302.2L2.4 272c4.2-54.2 49.3-96 103.7-96h7.9H128h64c.6 0 1.2 0 1.7 0c.8 0 1.7 0 2.5 0H302.4l9.6-32H274c-9.9 0-18-8-18-18c0-8.2 5.6-15.4 13.6-17.4L320 96zm96 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]],
    "input-pipe": [640, 512, [], "e1be", ["M576 128V384H64V128H576zM64 64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H576c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64z", "M104 184c0-13.3 10.7-24 24-24s24 10.7 24 24V328c0 13.3-10.7 24-24 24s-24-10.7-24-24V184z"]],
    "road-lock": [640, 512, [], "e567", ["M213.2 32H288V96c0 17.7 14.3 32 32 32s32-14.3 32-32V32h74.8c27.1 0 51.3 17.1 60.3 42.6l30.4 85.9C460.6 165.8 416 213.7 416 272v24.6c-19.1 11.1-32 31.7-32 55.4V480H352V416c0-17.7-14.3-32-32-32s-32 14.3-32 32v64H86.6C56.5 480 32 455.5 32 425.4c0-6.2 1.1-12.4 3.1-18.2L152.9 74.6C162 49.1 186.1 32 213.2 32zM320 192c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V224c0-17.7-14.3-32-32-32z", "M496 272v48h64V272c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48V272c0-44.2 35.8-80 80-80s80 35.8 80 80v48c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32z"]],
    "a": [384, 512, [97], "41", ["M221.5 51.7C216.6 39.8 204.9 32 192 32s-24.6 7.8-29.5 19.7l-120 288-40 96c-6.8 16.3 .9 35 17.2 41.8s35-.9 41.8-17.2L93.3 384H290.7l31.8 76.3c6.8 16.3 25.5 24 41.8 17.2s24-25.5 17.2-41.8l-40-96-120-288zM264 320H120l72-172.8L264 320z", ""]],
    "bookmark-slash": [640, 512, [], "e0c2", ["M512 376V48c0-26.5-21.5-48-48-48H176c-26.5 0-48 21.5-48 48V75L512 376zm-2.2 121.7L128 196.8V487.7c0 13.4 10.9 24.3 24.3 24.3c5 0 9.9-1.5 14-4.4L320 400 473.7 507.6c4.1 2.9 9 4.4 14 4.4c9.9 0 18.4-5.9 22.2-14.3z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "temperature-arrow-down": [576, 512, ["temperature-down"], "e03f", ["M176 64c-26.5 0-48 21.5-48 48V276.5c0 17.3-7.1 31.9-15.3 42.5C102.2 332.6 96 349.5 96 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-18.5-6.2-35.4-16.7-48.9c-8.2-10.6-15.3-25.2-15.3-42.5V112c0-26.5-21.5-48-48-48zM64 112C64 50.2 114.1 0 176 0s112 50.1 112 112V276.5c0 .1 .1 .3 .2 .6c.2 .6 .8 1.6 1.7 2.8c18.9 24.4 30.1 55 30.1 88.1c0 79.5-64.5 144-144 144S32 447.5 32 368c0-33.2 11.2-63.8 30.1-88.1c.9-1.2 1.5-2.2 1.7-2.8c.1-.3 .2-.5 .2-.6V112z", "M480 352h32c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8h32V64c0-17.7 14.3-32 32-32s32 14.3 32 32V352zM224 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V272c0-8.8 7.2-16 16-16s16 7.2 16 16v50.7c18.6 6.6 32 24.4 32 45.3z"]],
    "mace": [512, 512, [], "f6f8", ["M171.9 294.9L9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L217.1 340.1c-18.4-11.3-34-26.8-45.3-45.3z", "M272.8 10.9L244.8 95c-40.4 13.5-72.3 45.4-85.8 85.8l-84.1 28C68.4 211 64 217.1 64 224s4.4 13 10.9 15.2l84.1 28c13.5 40.4 45.4 72.3 85.8 85.8l28 84.1c2.2 6.5 8.3 10.9 15.2 10.9s13-4.4 15.2-10.9l28-84.1c40.4-13.5 72.3-45.4 85.8-85.8l84.1-28c6.5-2.2 10.9-8.3 10.9-15.2s-4.4-13-10.9-15.2l-84.1-28c-13.5-40.4-45.4-72.3-85.8-85.8l-28-84.1C301 4.4 294.9 0 288 0s-13 4.4-15.2 10.9zM288 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]],
    "feather-pointed": [512, 512, ["feather-alt"], "f56b", ["M41 505l81.3-81.3c10 7.6 21 13.7 33.3 17C200.3 452.8 270 454.5 338 409.4c12.2-8.1 5.8-25.4-8.8-25.4l-16.1 0c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l97.7-29.3c3.4-1 6.4-3.1 8.4-6.1c4.4-6.4 8.6-12.9 12.6-19.6c6.2-10.3-1.5-23-13.5-23l-38.6 0c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l80.9-24.3c4.6-1.4 8.4-4.8 10.2-9.3C494.5 163 507.8 86.1 511.9 36.8c.8-9.9-3-19.6-10-26.6s-16.7-10.8-26.6-10C391.5 7 228.5 40.5 137.4 131.6C57.3 211.7 56.7 302.3 71.3 356.4c3.3 12.2 9.4 23.2 17 33.3L7 471c-9.4 9.4-9.4 24.6 0 33.9c4.7 4.7 10.8 7 17 7c.6 0 1.2 0 1.8-.1c3.4-.3 6.7-1.2 9.8-2.9c1.9-1.1 3.7-2.4 5.4-4z", "M24 512c-6.2 0-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9L311 167c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L41 505c-4.7 4.7-10.8 7-17 7z"]],
    "sausage": [512, 512, [], "f820", ["M320 160c0-42 26.9-77.7 64.5-90.7L369.2 27.4c-.8-2.2-1.2-4.6-1.2-7C368 9.1 377.1 0 388.4 0h55.2C454.9 0 464 9.1 464 20.4c0 2.4-.4 4.7-1.2 7L447.5 69.3C485.1 82.3 512 118 512 160c0 194.4-157.6 352-352 352c-42 0-77.7-26.9-90.7-64.5L27.4 462.8c-2.2 .8-4.6 1.2-7 1.2C9.1 464 0 454.9 0 443.6V388.4C0 377.1 9.1 368 20.4 368c2.4 0 4.7 .4 7 1.2l41.9 15.2C82.3 346.9 118 320 160 320c88.4 0 160-71.6 160-160zm80 0c0-8.8-7.2-16-16-16s-16 7.2-16 16c0 114.9-93.1 208-208 208c-8.8 0-16 7.2-16 16s7.2 16 16 16c132.5 0 240-107.5 240-240z", "M384 144c8.8 0 16 7.2 16 16c0 132.5-107.5 240-240 240c-8.8 0-16-7.2-16-16s7.2-16 16-16c114.9 0 208-93.1 208-208c0-8.8 7.2-16 16-16z"]],
    "trash-can-clock": [576, 512, [], "e2aa", ["M32 96H416v96.7c-29.3 2.6-56.6 12.5-80 27.7V176c0-8.8-7.2-16-16-16s-16 7.2-16 16v71.2c-29.8 31.5-48 74-48 120.8c0 59.5 29.6 112.1 74.8 144H96c-35.3 0-64-28.7-64-64V96zm96 64c-8.8 0-16 7.2-16 16V400c0 8.8 7.2 16 16 16s16-7.2 16-16V176c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V400c0 8.8 7.2 16 16 16s16-7.2 16-16V176c0-8.8-7.2-16-16-16z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H448V304c0-8.8-7.2-16-16-16z"]],
    "p": [320, 512, [112], "50", ["M0 96C0 60.7 28.7 32 64 32h96c88.4 0 160 71.6 160 160s-71.6 160-160 160H64v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V320 96zM64 288h96c53 0 96-43 96-96s-43-96-96-96H64V288z", ""]],
    "broom-wide": [512, 512, [], "e5d1", ["M502.6 54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-128 128 45.3 45.3 128-128z", "M313.6 121.6c-15.2-15.2-38.5-18.4-57.3-8l-32.5 18L380.4 288.1l18-32.5c10.4-18.7 7.1-42.1-8-57.3l-76.8-76.8zM187.5 151.8L16.4 246.9C6.3 252.5 0 263.2 0 274.8c0 8.5 3.4 16.6 9.3 22.6l43.2 43.2c2.1 2.1 5.3 2.9 8.2 1.9l52.1-17.4c6.3-2.1 12.2 3.9 10.1 10.1l-17.4 52.1c-1 2.9-.2 6 1.9 8.2L214.7 502.7c6 6 14.1 9.3 22.6 9.3c11.6 0 22.3-6.3 27.9-16.4l95.1-171.1L187.5 151.8z"]],
    "snowflake": [448, 512, [10052, 10054], "f2dc", ["M192 62.1v67.9L143 81c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l15 15zM130.6 164.5L71.7 130.1l-5.2-19.3c-3.4-12.8 4.2-26 17-29.4s26 4.2 29.4 17l17.7 66.1zM41.2 186.4l58.4 34.1L31.9 238.6c-12.8 3.4-26-4.2-29.4-17s4.2-26 17-29.4l21.7-5.8zM99.6 291.5L41.2 325.6l-21.7-5.8c-12.8-3.4-20.4-16.6-17-29.4s16.6-20.4 29.4-17l67.7 18.1zM71.7 381.9l58.9-34.4-17.7 66.1c-3.4 12.8-16.6 20.4-29.4 17s-20.4-16.6-17-29.4l5.2-19.3zm120.3 .2v67.9l-15 15c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l49-49zm64 67.9V382.1l49 49c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-15-15zm61.4-102.4l58.9 34.4 5.2 19.3c3.4 12.8-4.2 26-17 29.4s-26-4.2-29.4-17l-17.7-66.1zm89.4-21.9l-58.4-34.1 67.7-18.1c12.8-3.4 26 4.2 29.4 17s-4.2 26-17 29.4l-21.7 5.8zM348.4 220.5l58.4-34.1 21.7 5.8c12.8 3.4 20.4 16.6 17 29.4s-16.6 20.4-29.4 17l-67.7-18.1zm27.9-90.4l-58.9 34.4 17.7-66.1c3.4-12.8 16.6-20.4 29.4-17s20.4 16.6 17 29.4l-5.2 19.3zM256 129.9V62.1l15-15c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-49 49z", "M224 0c17.7 0 32 14.3 32 32V200.3l143.9-83.9c15.3-8.9 34.9-3.7 43.8 11.5s3.8 34.9-11.5 43.8L287.5 256l144.6 84.4c15.3 8.9 20.4 28.5 11.5 43.8s-28.5 20.4-43.8 11.5L256 311.7V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V311.7L48.1 395.6c-15.3 8.9-34.9 3.7-43.8-11.5s-3.7-34.9 11.5-43.8L160.5 256 15.9 171.6C.6 162.7-4.5 143.1 4.4 127.9s28.5-20.4 43.8-11.5L192 200.3V32c0-17.7 14.3-32 32-32z"]],
    "stomach": [512, 512, [], "f623", ["M216.5 415.4l-1.7-1.4c53.2-9.5 94.9-51.9 103.6-105.4c8.6-2.5 17.8-4.5 25.6-4.6c16.8-.3 28.4 7.9 40 16s23.2 16.2 40 16c6.5-.1 13.9-1.5 21.1-3.3C431.9 398.5 373.7 448 304 448c-24 0-40.5-4.2-53.1-9.8c-12.8-5.7-23.1-13.3-34.4-22.8z", "M160 0c17.7 0 32 14.3 32 32V96c0 35.3 28.7 64 64 64h17.1c22.1-38.3 63.5-64 110.9-64c70.7 0 128 57.3 128 128v80c0 114.9-93.1 208-208 208c-32 0-57.5-5.8-78.9-15.2c-21.2-9.3-36.9-21.7-49.6-32.2c-1.8-1.5-3.6-3-5.3-4.4l0 0C148 441.5 136.6 432 112 432c-26.5 0-48 21.5-48 48c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-70.7 57.3-128 128-128h64c35.3 0 64-28.7 64-64V224c-70.7 0-128-57.3-128-128V32c0-17.7 14.3-32 32-32zm54.8 414c.6 .5 1.1 1 1.7 1.4c11.4 9.5 21.6 17.1 34.4 22.8c12.6 5.5 29.1 9.8 53.1 9.8c79.5 0 144-64.5 144-144V224c0-35.3-28.7-64-64-64s-64 28.7-64 64v64c0 62.9-45.4 115.2-105.2 126z"]],
    "newspaper": [512, 512, [128240], "f1ea", ["M96 96c0-35.3 28.7-64 64-64H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H96 48c26.5 0 48-21.5 48-48V96zm64 24v80c0 13.3 10.7 24 24 24H296c13.3 0 24-10.7 24-24V120c0-13.3-10.7-24-24-24H184c-13.3 0-24 10.7-24 24zm208-8c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H384c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H384c-8.8 0-16 7.2-16 16zM160 304c0 8.8 7.2 16 16 16H432c8.8 0 16-7.2 16-16s-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16H432c8.8 0 16-7.2 16-16s-7.2-16-16-16H176c-8.8 0-16 7.2-16 16z", "M0 160V432c0 26.5 21.5 48 48 48s48-21.5 48-48V96H64C28.7 96 0 124.7 0 160zM384 96c-8.8 0-16 7.2-16 16s7.2 16 16 16h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H384zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H384zM176 288c-8.8 0-16 7.2-16 16s7.2 16 16 16H432c8.8 0 16-7.2 16-16s-7.2-16-16-16H176zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16H432c8.8 0 16-7.2 16-16s-7.2-16-16-16H176z"]],
    "rectangle-ad": [576, 512, ["ad"], "f641", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM229.5 173.3l72 144c5.9 11.9 1.1 26.3-10.7 32.2s-26.3 1.1-32.2-10.7L253.2 328H162.8l-5.4 10.7c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l72-144c4.1-8.1 12.4-13.3 21.5-13.3s17.4 5.1 21.5 13.3zM208 237.7L186.8 280h42.3L208 237.7zM392 256a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm24-43.9V184c0-13.3 10.7-24 24-24s24 10.7 24 24v96 48c0 13.3-10.7 24-24 24c-6.6 0-12.6-2.7-17-7c-9.4 4.5-19.9 7-31 7c-39.8 0-72-32.2-72-72s32.2-72 72-72c8.4 0 16.5 1.4 24 4.1z", "M208 160c9.1 0 17.4 5.1 21.5 13.3l72 144c5.9 11.9 1.1 26.3-10.7 32.2s-26.3 1.1-32.2-10.7L253.2 328H162.8l-5.4 10.7c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l72-144c4.1-8.1 12.4-13.3 21.5-13.3zm21.2 120L208 237.7 186.8 280h42.3zM392 256a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm24-43.9V184c0-13.3 10.7-24 24-24s24 10.7 24 24v96 48c0 13.3-10.7 24-24 24c-6.6 0-12.6-2.7-17-7c-9.4 4.5-19.9 7-31 7c-39.8 0-72-32.2-72-72s32.2-72 72-72c8.4 0 16.5 1.4 24 4.1z"]],
    "guitar-electric": [512, 512, [127928], "f8be", ["M233.4 450.1c7.5-25.2 22.5-65.6 47.2-90.6c10-10.1 20-16 28.3-19.3c.4-.2 .8-.3 1.1-.5c11.3-4.6 23-9.4 31.6-18l21.6-21.8c6.5-6.6 6.5-17.3 0-23.8s-17.3-6.6-25.8-3c-14.6 6.2-39.3 8.7-68.5-20.9L257 240.2c-31.9-32.2-20.7-64.5-10-82c4.8-7.9 4.8-18.7-1.7-25.3s-17.1-6.6-23.6 0l-29.9 30.2c-9.1 9.2-14.7 21.5-20.2 33.5c-1.2 2.6-2.3 5.1-3.5 7.6c-3.5 7.3-8.9 15.7-17.1 24c-24.7 25-64.7 40.2-89.6 47.7c-14.5 4.4-28.1 11.7-38.7 22.4c-30 30.4-30 79.6 0 110l79.9 80.8c30 30.4 78.7 30.4 108.8 0c10.7-10.8 17.9-24.5 22.2-39.2zM195.3 268.7l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-64 64l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z", "M352 81.1v33.6L243.8 223c3.2 5.7 7.5 11.5 13.2 17.2l11.8 11.9c7 7.1 13.8 12.3 20.2 16.1L461.3 96H464c26.5 0 48-21.5 48-48s-21.5-48-48-48h-1.1c-9.7 0-19.2 2.9-27.3 8.3L366.2 54.5C357.3 60.4 352 70.4 352 81.1zM195.3 268.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l48 48c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-48-48zm-64 64c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l48 48c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-48-48z"]],
    "arrow-turn-down-right": [512, 512, [], "e3d6", ["M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64V224c0 53 43 96 96 96H402.7l32-32-32-32H96c-17.7 0-32-14.3-32-32V64z", "M329.4 137.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3l-128 128c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L434.7 288 329.4 182.6c-12.5-12.5-12.5-32.8 0-45.3z"]],
    "moon-cloud": [640, 512, [], "f754", ["M256.5 240.3C264.5 124 361.2 32 479.5 32c6.4 0 12.7 .3 19 .8c7 .6 12.8 5.7 14.3 12.5s-1.6 13.9-7.7 17.3c-53.3 30.2-89.3 87.6-89.3 153.3c0 97.2 78.6 176 175.5 176c10.3 0 20.3-.9 30.1-2.6c6.9-1.2 13.8 2.2 17 8.5s1.9 13.8-3.1 18.7C595 455.8 540 480 479.5 480c-60.9 0-116.1-24.4-156.4-64c17.9-18.7 29-44.1 29-72c0-54.6-42-99.3-95.5-103.7z", "M0 352c0 35.3 28.7 64 64 64H248c39.8 0 72-32.2 72-72s-32.2-72-72-72c-10.1 0-19.7 2.1-28.4 5.8C208.8 246.5 179 224 144 224c-38.7 0-71 27.5-78.4 64c-.5 0-1.1 0-1.6 0c-35.3 0-64 28.7-64 64z"]],
    "bread-slice-butter": [512, 512, [], "e3e1", ["M233.4 214.6l-50.7 50.7c-12.5 12.5-12.5 32.8 0 45.3l50.7 50.7c12.5 12.5 32.8 12.5 45.3 0l50.7-50.7c12.5-12.5 12.5-32.8 0-45.3l-50.7-50.7c-12.5-12.5-32.8-12.5-45.3 0z", "M0 192C0 64 192 32 256 32s256 32 256 160c0 35.3-28.7 64-64 64V432c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48V256c-35.3 0-64-28.7-64-64zm182.6 73.4c-12.5 12.5-12.5 32.8 0 45.3l50.7 50.7c12.5 12.5 32.8 12.5 45.3 0l50.7-50.7c12.5-12.5 12.5-32.8 0-45.3l-50.7-50.7c-12.5-12.5-32.8-12.5-45.3 0l-50.7 50.7z"]],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM281 385c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l71-71L136 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l182.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L393 239c9.4 9.4 9.4 24.6 0 33.9L281 385z", "M393 239c9.4 9.4 9.4 24.6 0 33.9L281 385c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l71-71L136 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l182.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L393 239z"]],
    "user-group-crown": [640, 512, ["users-crown"], "f6a5", ["M432 256c-27.7 0-53-10.1-72.6-26.7c.5-.8 1-1.5 1.4-2.3c12.1-19.9 20-42.6 22.4-67c.5-5.3 .8-10.6 .8-16V42.8C398.5 35.9 414.8 32 432 32c61.9 0 112 50.1 112 112s-50.1 112-112 112zM609.3 512H471.4c5.4-9.4 8.6-20.3 8.6-32v-8c0-60.7-27.1-115.2-69.8-151.8c2.4-.1 4.7-.2 7.1-.2h61.4C567.8 320 640 392.2 640 481.3c0 17-13.8 30.7-30.7 30.7zM352 128v16c0 70.7-57.3 128-128 128s-128-57.3-128-128V128H352z", "M352 80v48H320 304 144 128 96V80 42.3v-.1V39 16c0-8.8 7.2-16 16-16h2.4c3.6 0 7.2 1.2 10 3.5L140 16l3 2.4c.3 .2 .6 .4 .8 .6l.1 .1c10.2 7.5 23.8 8.3 34.9 2L209.1 4c4.6-2.6 9.7-4 14.9-4s10.4 1.4 14.9 4l30.2 17.2c11 6.3 24.7 5.5 34.9-2l.1-.1c.3-.2 .6-.4 .8-.6l3-2.4L323.6 3.5c2.8-2.3 6.4-3.5 10-3.5H336c8.8 0 16 7.2 16 16V39v3.2 .1V80zM0 472c0-92.8 75.2-168 168-168H280c92.8 0 168 75.2 168 168v8c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32v-8z"]],
    "circle-i": [512, 512, [], "e111", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128h72 72c13.3 0 24 10.7 24 24s-10.7 24-24 24H280V336h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V176H184c-13.3 0-24-10.7-24-24s10.7-24 24-24z", "M160 152c0-13.3 10.7-24 24-24h72 72c13.3 0 24 10.7 24 24s-10.7 24-24 24H280V336h48c13.3 0 24 10.7 24 24s-10.7 24-24 24H184c-13.3 0-24-10.7-24-24s10.7-24 24-24h48V176H184c-13.3 0-24-10.7-24-24z"]],
    "toilet-paper-check": [640, 512, [], "e5b2", ["M20.2 495.8C25.8 505.8 36.5 512 48 512H317.9c22.3 0 45.4-12.1 55.4-36.1C388.7 439 416 350.8 416 192C416 86 459 0 512 0H160C107 0 64 86 64 192c0 85.3-.4 193.7-43.5 271.6c-5.9 9.9-6.1 22.1-.4 32.2zM313 193l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-40-40c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l23 23 55-55c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z", "M399.6 384H512c53 0 96-86 96-192S565 0 512 0s-96 86-96 192c0 81.9-7.3 145-16.4 192zM544 192c0 35.3-14.3 64-32 64s-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64z"]],
    "filter-circle-xmark": [576, 512, [], "e17b", ["M40 0C24.5 0 10.5 8.9 3.9 22.9S-.7 53.4 9 65.3L192 288.9V368c0 10.1 4.7 19.6 12.8 25.6l64 48c1.5 1.1 3 2.1 4.7 2.9C262.3 421.4 256 395.4 256 368c0-85 60.2-155.9 140.4-172.4L503 65.3c9.8-12 11.8-28.5 5.2-42.5S487.5 0 472 0H40z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L432 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L409.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L432 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L454.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]],
    "locust": [576, 512, [], "e520", ["M312 32c-13.3 0-24 10.7-24 24s10.7 24 24 24h16c98.7 0 180.6 71.4 197 165.4c29.8 11.6 51 40.6 51 74.6V280C576 143 465 32 328 32H312z", "M286.1 142.5c-3.3-7.8-10.5-13.2-18.9-14.3s-16.7 2.3-22 8.9l-240 304c-8.2 10.4-6.4 25.5 4 33.7s25.5 6.4 33.7-4l79.4-100.5 43 16.4-40.5 55c-7.9 10.7-5.6 25.7 5.1 33.6s25.7 5.6 33.6-5.1L215.1 400h74.5l-29.3 42.3c-7.5 10.9-4.8 25.8 6.1 33.4s25.8 4.8 33.4-6.1L348 400h80.4l38.8 67.9c6.6 11.5 21.2 15.5 32.7 8.9s15.5-21.2 8.9-32.7L483.6 400H496c44.2 0 80-35.8 80-80s-35.8-80-80-80H431.8l-41.8-97.5c-3.4-7.9-10.8-13.4-19.3-14.4s-17 2.7-22.1 9.6l-40.9 55.5-21.7-50.7zM379.6 240H333l29.5-40 17.1 40zm-106.3 0H225.1l32.7-41.5 16.9 39.5-1.4 1.9zm-146.6 0H88.8C57.4 240 32 265.4 32 296.8c0 15.5 6.3 30 16.9 40.4L126.7 240zM480 320a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]],
    "sort": [320, 512, ["unsorted"], "f0dc", ["M182.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128z", "M182.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8H288c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128z"]],
    "list-ol": [512, 512, ["list-1-2", "list-numeric"], "f0cb", ["M192 96c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H224c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32H488c17.7 0 32 14.3 32 32s-14.3 32-32 32H224c-17.7 0-32-14.3-32-32zm32 128H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H224c-17.7 0-32-14.3-32-32s14.3-32 32-32z", "M48 32C34.7 32 24 42.8 24 56s10.7 24 24 24h8v96H40c-13.3 0-24 10.7-24 24s10.7 24 24 24h80c13.3 0 24-10.7 24-24s-10.7-24-24-24H104V56c0-13.3-10.7-24-24-24H48zM62.6 342.4c5.7-8.1 17.5-8.6 24-1.2c5.2 5.9 5 14.7-.3 20.5l-72 78c-6.5 7-8.2 17.2-4.3 25.9s12.5 14.4 22 14.4h88c13.3 0 24-10.7 24-24s-10.7-24-24-24H86.8l34.8-37.7c22-23.8 22.4-60.3 1.1-84.7c-26.9-30.7-75.4-28.4-99.2 4.9L12.5 330.1c-7.7 10.8-5.2 25.8 5.6 33.5s25.8 5.2 33.5-5.6l11.1-15.6z"]],
    "chart-waterfall": [512, 512, [], "e0eb", ["M32 32c17.7 0 32 14.3 32 32V400c0 8.8 7.2 16 16 16H480c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-44.2 0-80-35.8-80-80V64C0 46.3 14.3 32 32 32z", "M352 64c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-64 96c0-17.7-14.3-32-32-32s-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V160zm-96 96c0-17.7-14.3-32-32-32s-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V256zM480 96c0-17.7-14.3-32-32-32s-32 14.3-32 32V320c0 17.7 14.3 32 32 32s32-14.3 32-32V96z"]],
    "sparkle": [448, 512, [], "e5d6", ["M245.8 45.9C241.9 37.4 233.4 32 224 32s-17.9 5.4-21.8 13.9L142.7 174.7 13.9 234.2C5.4 238.1 0 246.6 0 256s5.4 17.9 13.9 21.8l128.8 59.5 59.5 128.8c3.9 8.5 12.4 13.9 21.8 13.9s17.9-5.4 21.8-13.9l59.5-128.8 128.8-59.5c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8L305.3 174.7 245.8 45.9z", ""]],
    "face-party": [640, 512, [], "e383", ["M531.7 400C485.6 467.6 408 512 320 512C178.6 512 64 397.4 64 256S178.6 0 320 0C433.4 0 529.7 73.8 563.3 176H560c-44.2 0-80 35.8-80 80c0 18 6 34.6 16 48H416c-1 0-2 0-3 .1c-1.2-2.3-2.7-4.4-4.3-6.4c-4.3-5.2-10.1-9.7-16.7-13.4C378.7 276.9 361.4 272 344 272c-3.6 0-6.8 2.5-7.7 6s.6 7.2 3.8 9l0 0 0 0 0 0 .2 .1c.2 .1 .5 .3 .9 .5c.8 .5 2 1.2 3.4 2.1c2.8 1.9 6.5 4.5 10.2 7.6c3.7 3.1 7.2 6.6 9.6 10.1c2.5 3.5 3.5 6.4 3.5 8.6s-1 5-3.5 8.6c-2.5 3.5-5.9 6.9-9.6 10.1c-3.7 3.1-7.4 5.7-10.2 7.6c-1.4 .9-2.6 1.6-3.4 2.1c-.4 .2-.7 .4-.9 .5l-.2 .1 0 0 0 0 0 0 0 0 0 0c-2.5 1.4-4.1 4.1-4.1 7s1.6 5.6 4.1 7l0 0 0 0 0 0 .2 .1c.2 .1 .5 .3 .9 .5c.8 .5 2 1.2 3.4 2.1c2.8 1.9 6.5 4.5 10.2 7.6c3.7 3.1 7.2 6.6 9.6 10.1c2.5 3.5 3.5 6.4 3.5 8.6s-1 5-3.5 8.6c-2.5 3.5-5.9 6.9-9.6 10.1c-3.7 3.1-7.4 5.7-10.2 7.6c-1.4 .9-2.6 1.6-3.4 2.1c-.4 .2-.7 .4-.9 .5l-.2 .1 0 0 0 0 0 0 0 0c-3.2 1.8-4.7 5.5-3.8 9s4.1 6 7.7 6c17.4 0 34.7-4.9 47.9-12.3c6.6-3.7 12.5-8.2 16.7-13.4c1.6-2 3.1-4.1 4.3-6.4c1 .1 2 .1 3 .1H531.7zM275.2 233.6c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2c17.6-23.5 52.8-23.5 70.4 0zm89.6 0c17.6-23.5 52.8-23.5 70.4 0c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2z", "M51.3 152.2l-20-52C46.6 71.8 66 46 88.8 23.4L132 37.8C96.5 68.5 68.5 107.7 51.3 152.2zM55.1 12.2C40.9 27.6 28 44.4 16.6 62.1L1.1 21.7C-1.2 16 .2 9.4 4.4 4.9S15.2-1.1 21.1 .8L55.1 12.2zM204.8 233.6c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4c30.4-40.5 91.2-40.5 121.6 0c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2c-17.6-23.5-52.8-23.5-70.4 0zm160 0c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4c30.4-40.5 91.2-40.5 121.6 0c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2c-17.6-23.5-52.8-23.5-70.4 0zM512 256c0-26.5 21.5-48 48-48h32c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H400c-8.8 0-16-7.2-16-16s7.2-16 16-16H592c8.8 0 16-7.2 16-16V256c0-8.8-7.2-16-16-16H560c-8.8 0-16 7.2-16 16s7.2 16 16 16h16c8.8 0 16 7.2 16 16s-7.2 16-16 16H560c-26.5 0-48-21.5-48-48z"]],
    "kidneys": [640, 512, [], "f5fb", ["M196.3 233c-1.4-16.8 3.2-33.5 12.8-47.3l64 32c19 9.5 31 28.9 31 50.1V488c0 13.3-10.7 24-24 24s-24-10.7-24-24V267.8c0-3-1.7-5.8-4.4-7.2L196.3 233zm234.7-47.3c9.6 13.7 14.2 30.4 12.8 47.3l-55.3 27.7c-2.7 1.4-4.4 4.1-4.4 7.2V488c0 13.3-10.7 24-24 24s-24-10.7-24-24V267.8c0-21.2 12-40.6 31-50.1l64-32z", "M87.7 23.8C106.5 6.3 130.5 0 152 0h3.2c19.9 0 39.4 5.9 55.9 16.9l3.4 2.3C240.4 36.5 256 65.6 256 96.7c0 22.8-8.4 44.8-23.5 61.9l-18.2 20.5c-13.4 15.1-19.9 35.1-17.9 55.1l4.1 41.2c5.8 58.1-39.8 108.5-98.2 108.5c-46.5 0-88.2-32.9-95.3-80.9C3.5 278.7 0 248.9 0 224C0 119.6 56.4 52.8 87.7 23.8zm464.6 0C583.6 52.8 640 119.6 640 224c0 24.9-3.5 54.7-7.1 79.1c-7.1 48-48.8 80.9-95.3 80.9c-58.4 0-104-50.4-98.2-108.5l4.1-41.2c2-20.1-4.5-40.1-17.9-55.1l-18.2-20.5C392.4 141.6 384 119.6 384 96.7c0-31.2 15.6-60.2 41.5-77.5l3.4-2.3C445.5 5.9 464.9 0 484.8 0H488c21.5 0 45.5 6.3 64.3 23.8z"]],
    "wifi-exclamation": [640, 512, [], "e2cf", ["M253.2 37c-8.6 13.7-13.1 30.1-11.9 47.6l1.4 19.3c-72.3 14.8-137.2 49.9-188.5 99.1c-12.8 12.2-33 11.8-45.2-.9s-11.8-33 .9-45.2C75.1 94.1 159.4 51 253.2 37zm133.7 0c93.8 14 178 57.1 243.3 119.8c12.8 12.2 13.2 32.5 .9 45.2s-32.5 13.2-45.2 .9c-51.3-49.2-116.2-84.3-188.5-99.1l1.4-19.3c1.2-17.4-3.3-33.9-11.9-47.6zM249.6 200.7l4.7 65.1c-30.8 9.4-58.8 25.4-82.4 46.2c-13.3 11.7-33.5 10.4-45.2-2.8s-10.4-33.5 2.8-45.2c33.9-29.9 74.9-52 120.1-63.3zm136.2 65.1l4.6-65.1c45.2 11.4 86.2 33.4 120.1 63.3c13.2 11.7 14.5 31.9 2.8 45.2s-31.9 14.5-45.2 2.8c-23.6-20.8-51.6-36.7-82.4-46.2z", "M320 32c-27.2 0-48.7 23.1-46.8 50.2l14.9 208C289.3 307 303.2 320 320 320s30.7-13 31.9-29.7l14.9-208C368.7 55.1 347.2 32 320 32zm0 448a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "chart-network": [640, 512, [], "f78a", ["M276.4 100.7C264.9 117.2 245.7 128 224 128c-1.9 0-3.7-.1-5.6-.2l29.2 62.5C221.8 210.4 203 239 195.6 272H119.4c5.4 9.4 8.6 20.3 8.6 32s-3.1 22.6-8.6 32h76.1c14.6 64.1 71.9 112 140.4 112c40.8 0 77.7-17 103.9-44.3L512 446.9c.4-23.6 13.6-44.1 32.9-54.9l-72-43.2c4.6-14.1 7.1-29.2 7.1-44.8c0-20.3-4.2-39.7-11.8-57.2l82-60.2c-20.5-9-35.3-28.5-37.8-51.6l-82.1 60.2C405 173.3 372.1 160 336 160c-10.4 0-20.6 1.1-30.4 3.2l-29.2-62.5zM336 256a48 48 0 1 1 0 96 48 48 0 1 1 0-96z", "M224 128A64 64 0 1 0 224 0a64 64 0 1 0 0 128zm352 64a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm64 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM64 368a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]],
    "person-dress-burst": [640, 512, [], "e544", ["M176 8c6.6 0 12.4 4 14.9 10.1l29.4 74 76.2-23.1c6.3-1.9 13.1 .2 17.2 5.3s4.6 12.2 1.4 17.9l-39.5 69.1 65.6 45.1c5.4 3.7 8 10.3 6.5 16.7s-6.7 11.2-13.1 12.2l-78.7 12.2 5.6 79.4c.5 6.5-3.1 12.7-9 15.5s-12.9 1.8-17.8-2.6L176 286.1l-58.6 53.9c-4.8 4.4-11.9 5.5-17.8 2.6s-9.5-9-9-15.5l5.6-79.4L17.6 235.4c-6.5-1-11.7-5.9-13.1-12.2s1.1-13 6.5-16.7l65.6-45.1L37 92.2c-3.3-5.7-2.7-12.8 1.4-17.9s10.9-7.2 17.2-5.3l76.2 23.1 29.4-74C163.6 12 169.4 8 176 8z", "M480 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM408 384H390.2c-10.9 0-18.6-10.7-15.2-21.1l38.3-114.8-33.9 56.3c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l53.6-89.2c20.3-33.7 56.7-54.3 96-54.3h11.6c39.3 0 75.7 20.6 96 54.3l53.6 89.2c9.1 15.1 4.2 34.8-10.9 43.9s-34.8 4.2-43.9-10.9l-33.9-56.3L585 362.9c3.5 10.4-4.3 21.1-15.2 21.1H552v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V384H472v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V384z"]],
    "dice-d4": [512, 512, [], "f6d0", ["M240 16c0-7-4.5-13.2-11.2-15.3s-13.9 .3-17.9 6.1l-208 296c-4.7 6.7-3.6 15.8 2.5 21.2l208 184c4.7 4.2 11.4 5.2 17.2 2.6s9.4-8.3 9.4-14.6V16z", "M272 16c0-7 4.5-13.2 11.2-15.3s13.9 .3 17.9 6.1l208 296c4.7 6.7 3.6 15.8-2.5 21.2l-208 184c-4.7 4.2-11.4 5.2-17.2 2.6s-9.4-8.3-9.4-14.6V16z"]],
    "money-check-dollar": [576, 512, ["money-check-alt"], "f53d", ["M64 64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zM272 192H496c8.8 0 16 7.2 16 16s-7.2 16-16 16H272c-8.8 0-16-7.2-16-16s7.2-16 16-16zM256 304c0-8.8 7.2-16 16-16H496c8.8 0 16 7.2 16 16s-7.2 16-16 16H272c-8.8 0-16-7.2-16-16zM164 152v13.9c7.5 1.2 14.6 2.9 21.1 4.7c10.7 2.8 17 13.8 14.2 24.5s-13.8 17-24.5 14.2c-11-2.9-21.6-5-31.2-5.2c-7.9-.1-16 1.8-21.5 5c-4.8 2.8-6.2 5.6-6.2 9.3c0 1.8 .1 3.5 5.3 6.7c6.3 3.8 15.5 6.7 28.3 10.5l.7 .2c11.2 3.4 25.6 7.7 37.1 15c12.9 8.1 24.3 21.3 24.6 41.6c.3 20.9-10.5 36.1-24.8 45c-7.2 4.5-15.2 7.3-23.2 9V360c0 11-9 20-20 20s-20-9-20-20V345.4c-10.3-2.2-20-5.5-28.2-8.4l0 0 0 0c-2.1-.7-4.1-1.4-6.1-2.1c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6c2.5 .8 4.9 1.7 7.2 2.4c13.6 4.6 24 8.1 35.1 8.5c8.6 .3 16.5-1.6 21.4-4.7c4.1-2.5 6-5.5 5.9-10.5c0-2.9-.8-5-5.9-8.2c-6.3-4-15.4-6.9-28-10.7l-1.7-.5c-10.9-3.3-24.6-7.4-35.6-14c-12.7-7.7-24.6-20.5-24.7-40.7c-.1-21.1 11.8-35.7 25.8-43.9c6.9-4.1 14.5-6.8 22.2-8.5V152c0-11 9-20 20-20s20 9 20 20z", "M164 152c0-11-9-20-20-20s-20 9-20 20v14c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1l0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4V360c0 11 9 20 20 20s20-9 20-20V346.2c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7V152zm108 40c-8.8 0-16 7.2-16 16s7.2 16 16 16H496c8.8 0 16-7.2 16-16s-7.2-16-16-16H272z"]],
    "vector-square": [448, 512, [], "f5cb", ["M320 64H128v64H320V64zm0 320H128v64H320V384zM32 160V352H96V160H32zm384 0H352V352h64V160z", "M368 80h32v32H368V80zM352 32c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32H352zM48 432V400H80v32H48zM0 384v64c0 17.7 14.3 32 32 32H96c17.7 0 32-14.3 32-32V384c0-17.7-14.3-32-32-32H32c-17.7 0-32 14.3-32 32zm368 48V400h32v32H368zm-48-48v64c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V384c0-17.7-14.3-32-32-32H352c-17.7 0-32 14.3-32 32zM48 112V80H80v32H48zM0 64v64c0 17.7 14.3 32 32 32H96c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32H32C14.3 32 0 46.3 0 64z"]],
    "bread-slice": [512, 512, [], "f7ec", ["M0 192C0 64 192 32 256 32s256 32 256 160c0 35.3-28.7 64-64 64V432c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48V256c-35.3 0-64-28.7-64-64zM128 400a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm0-96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm96 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M144 384a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm0-96a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm96 96a16 16 0 1 0 0 32 16 16 0 1 0 0-32z"]],
    "language": [640, 512, [], "f1ab", ["M0 128C0 92.7 28.7 64 64 64H320V448H64c-35.3 0-64-28.7-64-64V128zm160 36c-7.9 0-15.1 4.7-18.3 11.9l-64 144c-4.5 10.1 .1 21.9 10.2 26.4s21.9-.1 26.4-10.2l8.9-20.1h73.6l8.9 20.1c4.5 10.1 16.3 14.6 26.4 10.2s14.6-16.3 10.2-26.4l-64-144c-3.2-7.2-10.4-11.9-18.3-11.9zM141 276l19-42.8L179 276H141z", "M640 128c0-35.3-28.7-64-64-64H320V448H576c35.3 0 64-28.7 64-64V128zM500 184v4h44 16c11 0 20 9 20 20s-9 20-20 20h-2l-1.6 4.5c-8.9 24.4-22.4 46.6-39.6 65.4c.9 .6 1.8 1.1 2.7 1.6l18.9 11.3c9.5 5.7 12.5 18 6.9 27.4s-18 12.5-27.4 6.9l-18.9-11.3c-4.5-2.7-8.8-5.5-13.1-8.5c-10.6 7.5-21.9 14-34 19.4l-3.6 1.6c-10.1 4.5-21.9-.1-26.4-10.2s.1-21.9 10.2-26.4l3.6-1.6c6.4-2.9 12.6-6.1 18.5-9.8l-12.2-12.2c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0l14.6 14.6 .5 .5c12.4-13.1 22.5-28.3 29.8-45H480 408c-11 0-20-9-20-20s9-20 20-20h52v-4c0-11 9-20 20-20s20 9 20 20zM160 164c-7.9 0-15.1 4.7-18.3 11.9l-64 144c-4.5 10.1 .1 21.9 10.2 26.4s21.9-.1 26.4-10.2l8.9-20.1h73.6l8.9 20.1c4.5 10.1 16.3 14.6 26.4 10.2s14.6-16.3 10.2-26.4l-64-144c-3.2-7.2-10.4-11.9-18.3-11.9zm0 69.2L179 276H141l19-42.8z"]],
    "wheat-awn-slash": [640, 512, [], "e338", ["M362.5 258.8l28.7-28.7 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0L550.5 231c6.2-6.2 6.2-16.4 0-22.6L539.2 197c-5.2-5.2-10.6-9.8-16.4-13.9L569 137c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-59.4 59.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L473 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L393.1 52.9c-3.7-5-7.8-9.8-12.4-14.3L369.5 27.3c-6.2-6.2-16.4-6.2-22.6 0L335.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-11.3-11.3c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-3.3 3.3-6.3 6.8-9 10.4l137.8 108zm-68.7 68.7l-50.6-39.9-29.5 29.5c-3.4-27.3-15.5-53.8-36.5-74.8L165.8 231c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L73.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l68.9-68.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-11.3-11.3c-21.8-21.8-49.6-34.1-78.1-36.9l36.3-36.3zM569 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L447 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l88-88z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]],
    "face-kiss-wink-heart": [512, 512, [128536, "kiss-wink-heart"], "f598", ["M512 256c0 29.3-4.9 57.4-14 83.7c-11.1-4.7-23.5-6.6-36.2-5c-13.7-33.8-50.3-54.4-87.5-44c-40.1 11.2-61.9 53.1-51.8 92.1l22.9 89.3c1.9 7.6 5.6 14.2 10.4 19.7c-30.6 13-64.4 20.2-99.7 20.2C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256zM288.7 313.7c-4.3-5.2-10.1-9.7-16.7-13.4C258.7 292.9 241.4 288 224 288c-3.6 0-6.8 2.5-7.7 6s.6 7.2 3.8 9l0 0 0 0 0 0 .2 .1c.2 .1 .5 .3 .9 .5c.8 .5 2 1.2 3.4 2.1c2.8 1.9 6.5 4.5 10.2 7.6c3.7 3.1 7.2 6.6 9.6 10.1c2.5 3.5 3.5 6.4 3.5 8.6s-1 5-3.5 8.6c-2.5 3.5-5.9 6.9-9.6 10.1c-3.7 3.1-7.4 5.7-10.2 7.6c-1.4 .9-2.6 1.6-3.4 2.1c-.4 .2-.7 .4-.9 .5l-.2 .1 0 0 0 0 0 0 0 0 0 0c-2.5 1.4-4.1 4.1-4.1 7s1.6 5.6 4.1 7l0 0 0 0 0 0 .2 .1 .3 .2 .6 .4c.8 .5 2 1.2 3.4 2.1c2.8 1.9 6.5 4.5 10.2 7.6c3.7 3.1 7.2 6.6 9.6 10.1c2.5 3.5 3.5 6.4 3.5 8.6s-1 5-3.5 8.6c-2.5 3.5-5.9 6.9-9.6 10.1c-3.7 3.1-7.4 5.7-10.2 7.6c-1.4 .9-2.6 1.6-3.4 2.1c-.4 .2-.7 .4-.9 .5l-.2 .1 0 0 0 0 0 0 0 0c-3.2 1.8-4.7 5.5-3.8 9s4.1 6 7.7 6c17.4 0 34.7-4.9 47.9-12.3c6.6-3.7 12.5-8.2 16.7-13.4c4.3-5.1 7.3-11.4 7.3-18.3s-3.1-13.2-7.3-18.3c-4.3-5.2-10.1-9.7-16.7-13.4c-2.7-1.5-5.7-3-8.7-4.3c3.1-1.3 6-2.7 8.7-4.3c6.6-3.7 12.5-8.2 16.7-13.4c4.3-5.1 7.3-11.4 7.3-18.3s-3.1-13.2-7.3-18.3zM208.4 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm92.4 25.6c17.6-23.5 52.8-23.5 70.4 0c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2z", "M208.4 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm162.8 25.6c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2c17.6-23.5 52.8-23.5 70.4 0zM434 352.3c-6-23.2-28.8-37-51.1-30.8s-35.4 30.1-29.5 53.4l22.9 89.3c2.2 8.7 11.2 13.9 19.8 11.4l84.9-23.8c22.2-6.2 35.4-30.1 29.5-53.4s-28.8-37-51.1-30.8l-20.2 5.6-5.4-21z"]],
    "dagger": [384, 512, [], "f6cb", ["M152 192H128v24V414.8c0 10.5 2.9 20.8 8.5 29.7l35.1 56.2c4.4 7 12.1 11.3 20.4 11.3s16-4.3 20.4-11.3l35.1-56.2c5.6-8.9 8.5-19.2 8.5-29.7V216 192H232 152z", "M224 32c0-17.7-14.3-32-32-32s-32 14.3-32 32v96H48c-26.5 0-48 21.5-48 48s21.5 48 48 48c20.9 0 38.7-13.4 45.3-32H192h98.7c6.6 18.6 24.4 32 45.3 32c26.5 0 48-21.5 48-48s-21.5-48-48-48H224V32z"]],
    "podium": [448, 512, [], "f680", ["M310.7 512H137.3c-32.6 0-60-24.5-63.6-56.9L44.4 192H403.6L374.3 455.1c-3.6 32.4-31 56.9-63.6 56.9z", "M182.4 72H168c-22.1 0-40 17.9-40 40v32H424c13.3 0 24 10.7 24 24s-10.7 24-24 24H24c-13.3 0-24-10.7-24-24s10.7-24 24-24H80V112c0-48.6 39.4-88 88-88h14.4C190.7 9.7 206.2 0 224 0h64c26.5 0 48 21.5 48 48s-21.5 48-48 48H224c-17.8 0-33.3-9.7-41.6-24z"]],
    "memo-circle-check": [576, 512, [], "e1d9", ["M64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c3.3 0 6.6-.3 9.7-.7C285.1 479.3 256 427.1 256 368c0-80.6 54.1-148.5 128-169.4V64c0-35.3-28.7-64-64-64H64zM80 128H304c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16s7.2-16 16-16zM64 240c0-8.8 7.2-16 16-16H240c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16h96c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L416 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]],
    "route-highway": [448, 512, [], "f61a", ["M32 192H416c0 1.1 0 2.2 0 3.2c0 14.9 2.8 29.7 8.4 43.6l14.3 35.7c6.2 15.4 9.3 31.9 9.3 48.5c0 49.5-28 94.8-72.2 116.9L238.3 508.6c-9 4.5-19.6 4.5-28.6 0L72.2 439.9C28 417.8 0 372.5 0 323c0-16.6 3.2-33.1 9.3-48.5l14.3-35.7C29.2 225 32 210.2 32 195.2c0-1.1 0-2.2 0-3.2zM384 323l0 .1v-.2l0 .1z", "M240.5 4.6c-10.1-6.1-22.8-6.1-32.9 0l-4.7 2.8c-37.5 22.5-84 24.3-123.1 4.7l-1.4-.7c-15.2-7.6-33.7-2-42.1 12.7l-32 56c-5.3 9.3-5.6 20.6-.8 30.2l16.2 32.5C27.3 158.1 31.5 174.9 32 192H416c.5-17.1 4.7-33.9 12.3-49.2l16.2-32.5c4.8-9.6 4.5-20.9-.8-30.2l-32-56c-8.4-14.7-26.9-20.3-42.1-12.7l-1.4 .7c-39.1 19.6-85.6 17.8-123.1-4.7l-4.7-2.8z"]],
    "down-to-line": [384, 512, ["arrow-alt-to-bottom"], "f34a", ["M0 448c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32s-14.3 32-32 32H32c-17.7 0-32-14.3-32-32z", "M219.3 372.7L342.1 249.9c6.4-6.4 9.9-15 9.9-24c0-18.7-15.2-33.9-33.9-33.9L256 192l0-128c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 128-62.1 0C47.2 192 32 207.2 32 225.9c0 9 3.6 17.6 9.9 24L164.7 372.7c7.2 7.2 17.1 11.3 27.3 11.3s20.1-4.1 27.3-11.3z"]],
    "filter": [512, 512, [], "f0b0", ["M3.9 54.9C10.5 40.9 24.5 32 40 32H472c15.5 0 29.5 8.9 36.1 22.9s4.6 30.5-5.2 42.5L320 320.9V448c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48c-8.1-6-12.8-15.5-12.8-25.6V320.9L9 97.3C-.7 85.4-2.8 68.8 3.9 54.9z", ""]],
    "square-g": [448, 512, [], "e271", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm80 224c0 44.2 35.8 80 80 80c35.8 0 66.1-23.5 76.3-56H248c-13.3 0-24-10.7-24-24s10.7-24 24-24h80c13.3 0 24 10.7 24 24c0 70.7-57.3 128-128 128s-128-57.3-128-128s57.3-128 128-128c32.8 0 62.7 12.3 85.3 32.6c9.9 8.8 10.7 24 1.9 33.9s-24 10.7-33.9 1.9C263.2 183.7 244.5 176 224 176c-44.2 0-80 35.8-80 80z", "M224 176c-44.2 0-80 35.8-80 80s35.8 80 80 80c35.8 0 66.1-23.5 76.3-56H248c-13.3 0-24-10.7-24-24s10.7-24 24-24h80c13.3 0 24 10.7 24 24c0 70.7-57.3 128-128 128s-128-57.3-128-128s57.3-128 128-128c32.8 0 62.7 12.3 85.3 32.6c9.9 8.8 10.7 24 1.9 33.9s-24 10.7-33.9 1.9C263.2 183.7 244.5 176 224 176z"]],
    "circle-phone": [512, 512, ["phone-circle"], "e11b", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM186.7 128.7c9.7-2.6 19.9 2.3 23.7 11.6l20 48c3.4 8.2 1 17.6-5.8 23.2L200 231.7c16.6 35.2 45.1 63.7 80.3 80.3l20.2-24.7c5.6-6.8 15-9.2 23.2-5.8l48 20c9.3 3.9 14.2 14 11.6 23.7l-12 44C368.9 378 361 384 352 384c-123.7 0-224-100.3-224-224c0-9 6-16.9 14.7-19.3l44-12z", "M210.5 140.3c-3.9-9.3-14-14.2-23.7-11.6l-44 12C134 143.1 128 151 128 160c0 123.7 100.3 224 224 224c9 0 16.9-6 19.3-14.7l12-44c2.6-9.7-2.3-19.9-11.6-23.7l-48-20c-8.2-3.4-17.6-1-23.2 5.8L280.3 312c-35.2-16.6-63.7-45.1-80.3-80.3l24.7-20.2c6.8-5.6 9.2-15 5.8-23.2l-20-48z"]],
    "clipboard-prescription": [384, 512, [], "f5e8", ["M113.2 66.3c.1-.8 .3-1.6 .4-2.3H64C28.7 64 0 92.7 0 128V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H270.4c.2 .8 .3 1.6 .4 2.3C290.1 72.6 304 90.7 304 112v24c0 13.3-10.7 24-24 24H192 104c-13.3 0-24-10.7-24-24V112c0-21.3 13.9-39.4 33.2-45.7zM104 196h72c33.1 0 60 26.9 60 60c0 25.5-15.9 47.2-38.3 55.9l43 40.3 33.8-31c8.1-7.5 20.8-6.9 28.3 1.2s6.9 20.8-1.2 28.3L270 379.7l31.7 29.7c8.1 7.6 8.5 20.2 .9 28.3s-20.2 8.5-28.3 .9l-33.9-31.8-34.9 32c-8.1 7.5-20.8 6.9-28.3-1.2s-6.9-20.8 1.2-28.3l32.6-29.9-64.8-60.8c-.9-.8-1.6-1.7-2.3-2.6H124v44c0 11-9 20-20 20s-20-9-20-20V296 216c0-11 9-20 20-20zm72 80c11 0 20-9 20-20s-9-20-20-20H124v40h52z", "M113.2 66.3C93.9 72.6 80 90.7 80 112v24c0 13.3 10.7 24 24 24h88 88c13.3 0 24-10.7 24-24V112c0-21.3-13.9-39.4-33.2-45.7C264.4 28.7 231.5 0 192 0s-72.4 28.7-78.8 66.3zM168 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM104 196c-11 0-20 9-20 20v80 64c0 11 9 20 20 20s20-9 20-20V316h20c.7 .9 1.5 1.8 2.3 2.6l64.8 60.8-32.6 29.9c-8.1 7.5-8.7 20.1-1.2 28.3s20.1 8.7 28.3 1.2l34.9-32 33.9 31.8c8.1 7.6 20.7 7.1 28.3-.9s7.1-20.7-.9-28.3L270 379.7l31.6-28.9c8.1-7.5 8.7-20.1 1.2-28.3s-20.1-8.7-28.3-1.2l-33.8 31-43-40.3c22.4-8.7 38.3-30.5 38.3-55.9c0-33.1-26.9-60-60-60H104zm72 80H124V236h52c11 0 20 9 20 20s-9 20-20 20z"]],
    "user-nurse-hair": [448, 512, [], "e45d", ["M192 176H120c-8.5 0-16.6-1.9-23.8-5.3C99.4 236 153.4 288 219.6 288h8.8C296.7 288 352 232.7 352 164.4c0-1.5 0-3-.1-4.4H328c-22.8 0-42.8-11.9-54.1-29.8C257 157.7 226.6 176 192 176z", "M96 96v32 42.6c7.3 3.5 15.4 5.4 24 5.4h72c34.6 0 65-18.3 81.9-45.8C285.2 148.1 305.2 160 328 160h24V128 96 70.2c0-13.3-8.3-25.3-20.8-30l-96-36c-7.2-2.7-15.2-2.7-22.5 0l-96 36C104.3 44.9 96 56.8 96 70.2V96zm45.3 240.2c-7.6-8.1-18.9-11.9-29.4-8.5C47 348.5 0 409.4 0 481.3c0 17 13.8 30.7 30.7 30.7H417.3c17 0 30.7-13.8 30.7-30.7c0-71.9-47-132.7-111.9-153.6c-10.5-3.4-21.8 .4-29.4 8.5l-71 75.5c-6.3 6.7-17 6.7-23.3 0l-71-75.5zM208 48c0-4.4 3.6-8 8-8h16c4.4 0 8 3.6 8 8V64h16c4.4 0 8 3.6 8 8V88c0 4.4-3.6 8-8 8H240v16c0 4.4-3.6 8-8 8H216c-4.4 0-8-3.6-8-8V96H192c-4.4 0-8-3.6-8-8V72c0-4.4 3.6-8 8-8h16V48z"]],
    "question": [320, 512, [10067, 10068, 61736], "3f", ["M120 440a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z", "M144 96c-35.3 0-64 28.7-64 64c0 17.7-14.3 32-32 32s-32-14.3-32-32C16 89.3 73.3 32 144 32h32c70.7 0 128 57.3 128 128v3.6c0 43.6-22.1 84.1-58.8 107.7L203 298.4c-6.9 4.4-11 12-11 20.2V320c0 17.7-14.3 32-32 32s-32-14.3-32-32v-1.4c0-29.9 15.2-57.8 40.4-74l42.2-27.1c18.3-11.8 29.4-32.1 29.4-53.8V160c0-35.3-28.7-64-64-64H144z"]],
    "file-signature": [576, 512, [], "f573", ["M64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V390.8l-1.1 1.1c-4.1 4.1-9.2 7-14.9 8.4L310 414.9c-1.8 .7-3.9 1.1-6 1.1H240c-6.1 0-11.6-3.4-14.3-8.8l-8.8-17.7c-1.7-3.4-5.1-5.5-8.8-5.5s-7.2 2.1-8.8 5.5l-8.8 17.7c-2.9 5.9-9.2 9.4-15.7 8.8s-12.1-5.1-13.9-11.3L144 349l-9.8 32.8c-6.1 20.3-24.8 34.2-46 34.2H80c-8.8 0-16-7.2-16-16s7.2-16 16-16h8.2c7.1 0 13.3-4.6 15.3-11.4l14.9-49.5c3.4-11.3 13.8-19.1 25.6-19.1s22.2 7.7 25.6 19.1l11.6 38.6c7.4-6.2 16.8-9.7 26.8-9.7c15.9 0 30.4 9 37.5 23.2l4.4 8.8h41.6l12-48.2c1.4-5.6 4.3-10.8 8.4-14.9L384 248.9V160H256c-17.7 0-32-14.3-32-32V0H64z", "M384 160H256c-17.7 0-32-14.3-32-32V0L384 160zm165.8-20.3l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-29.4 29.4-71-71 29.4-29.4c15.6-15.6 40.9-15.6 56.6 0zM311.9 321L441.1 191.8l71 71L382.9 391.9c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9z"]],
    "toggle-large-on": [576, 512, [], "e5b1", ["M192 64C86 64 0 150 0 256S86 448 192 448H384c106 0 192-86 192-192s-86-192-192-192H192zm192 64a128 128 0 1 1 0 256 128 128 0 1 1 0-256z", "M384 128a128 128 0 1 0 0 256 128 128 0 1 0 0-256z"]],
    "up-down-left-right": [512, 512, ["arrows-alt"], "f0b2", ["M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8h32v96l64 0V128h32c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-64-64zM288 288l-64 0v96H192c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8H288V288z", "M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l64-64c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 32 256 0 0-32c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l64 64c12.5 12.5 12.5 32.8 0 45.3l-64 64c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-32-256 0 0 32c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-64-64z"]],
    "dryer-heat": [448, 512, ["dryer-alt"], "f862", ["M160 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-3.3 124.7c6.2-6.2 16.4-6.2 22.6 0L200 233.4c10.2 10.2 16 24.1 16 38.6s-5.8 28.4-16 38.6l-9.4 9.4c-4.2 4.2-6.6 10-6.6 16s2.4 11.8 6.6 16l20.7 20.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L168 374.6c-10.2-10.2-16-24.1-16-38.6s5.8-28.4 16-38.6l9.4-9.4c4.2-4.2 6.6-10 6.6-16s-2.4-11.8-6.6-16l-20.7-20.7c-6.2-6.2-6.2-16.4 0-22.6zm102.6 0L280 233.4c10.2 10.2 16 24.1 16 38.6s-5.8 28.4-16 38.6l-9.4 9.4c-4.2 4.2-6.6 10-6.6 16s2.4 11.8 6.6 16l20.7 20.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L248 374.6c-10.2-10.2-16-24.1-16-38.6s5.8-28.4 16-38.6l9.4-9.4c4.2-4.2 6.6-10 6.6-16s-2.4-11.8-6.6-16l-20.7-20.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z", "M64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM224 160a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM64 88a24 24 0 1 1 48 0A24 24 0 1 1 64 88zM184 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "house-chimney-user": [576, 512, [], "e065", ["M64 270.5L64.1 448c0 35.3 28.7 64 64 64H448.5c35.4 0 64.1-28.7 64-64.1l-.4-177.3L288 74.5 64 270.5zM288 192a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM176 432c0-44.2 35.8-80 80-80h64c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16H192c-8.8 0-16-7.2-16-16z", "M309.1 7.9C297-2.6 279-2.6 266.9 7.9l-256 224c-13.3 11.6-14.6 31.9-3 45.2s31.9 14.6 45.2 3L288 74.5 522.9 280.1c13.3 11.6 33.5 10.3 45.2-3s10.3-33.5-3-45.2L512 185.5V64c0-17.7-14.3-32-32-32H448c-17.7 0-32 14.3-32 32v37.5L309.1 7.9zM352 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm-96 96c-44.2 0-80 35.8-80 80c0 8.8 7.2 16 16 16H384c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80H256z"]],
    "hand-holding-heart": [576, 512, [], "f4be", ["M559.7 392.2c17.8-13.1 21.6-38.1 8.5-55.9s-38.1-21.6-55.9-8.5L392.6 416H272c-8.8 0-16-7.2-16-16s7.2-16 16-16h16 64c17.7 0 32-14.3 32-32s-14.3-32-32-32H288 272 193.7c-29.1 0-57.3 9.9-80 28L68.8 384H32c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H192 352.5c29 0 57.3-9.3 80.7-26.5l126.6-93.3zm-366.1-8.3a.5 .5 0 1 1 -.9 .2 .5 .5 0 1 1 .9-.2z", "M224.6 0C182.3 0 148 34.3 148 76.6c0 20.3 8.1 39.8 22.4 54.1L273.9 234.1c7.8 7.8 20.5 7.8 28.3 0L405.6 130.7C419.9 116.4 428 96.9 428 76.6C428 34.3 393.7 0 351.4 0c-20.3 0-39.8 8.1-54.1 22.4L288 31.7l-9.3-9.3C264.4 8.1 244.9 0 224.6 0z"]],
    "arrow-up-small-big": [576, 512, ["sort-size-up-alt"], "f88f", ["M368 32c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H368zm0 224c-26.5 0-48 21.5-48 48V432c0 26.5 21.5 48 48 48H496c26.5 0 48-21.5 48-48V304c0-26.5-21.5-48-48-48H368z", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V146.3L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32z"]],
    "train-track": [576, 512, [], "e453", ["M147.6 96l-21.3 64H112c-17.7 0-32-14.3-32-32s14.3-32 32-32h35.6zM104.9 224L83.6 288H72c-17.7 0-32-14.3-32-32s14.3-32 32-32h32.9zm46.1 64l21.3-64H403.6l21.3 64H151.1zM62.3 352L40.9 416H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H62.3zm46.1 64l21.3-64H446.3l21.3 64H108.4zm426.7 0l-21.3-64H544c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8.9zM492.4 288l-21.3-64H504c17.7 0 32 14.3 32 32s-14.3 32-32 32H492.4zM449.7 160L428.4 96H464c17.7 0 32 14.3 32 32s-14.3 32-32 32H449.7zM360.9 96l21.3 64H193.7l21.3-64H360.9z", "M202.1 33.6c16.8 5.6 25.8 23.7 20.2 40.5l-128 384c-5.6 16.8-23.7 25.8-40.5 20.2s-25.8-23.7-20.2-40.5l128-384c5.6-16.8 23.7-25.8 40.5-20.2zm171.8 0c16.8-5.6 34.9 3.5 40.5 20.2l128 384c5.6 16.8-3.5 34.9-20.2 40.5s-34.9-3.5-40.5-20.2l-128-384c-5.6-16.8 3.5-34.9 20.2-40.5z"]],
    "puzzle-piece": [512, 512, [129513], "f12e", ["M192 104.8c0-9.2-5.8-17.3-13.2-22.8C167.2 73.3 160 61.3 160 48c0-26.5 28.7-48 64-48s64 21.5 64 48c0 13.3-7.2 25.3-18.8 34c-7.4 5.5-13.2 13.6-13.2 22.8v0c0 12.8 10.4 23.2 23.2 23.2H336c26.5 0 48 21.5 48 48v56.8c0 12.8 10.4 23.2 23.2 23.2v0c9.2 0 17.3-5.8 22.8-13.2c8.7-11.6 20.7-18.8 34-18.8c26.5 0 48 28.7 48 64s-21.5 64-48 64c-13.3 0-25.3-7.2-34-18.8c-5.5-7.4-13.6-13.2-22.8-13.2v0c-12.8 0-23.2 10.4-23.2 23.2V464c0 26.5-21.5 48-48 48H279.2c-12.8 0-23.2-10.4-23.2-23.2v0c0-9.2 5.8-17.3 13.2-22.8c11.6-8.7 18.8-20.7 18.8-34c0-26.5-28.7-48-64-48s-64 21.5-64 48c0 13.3 7.2 25.3 18.8 34c7.4 5.5 13.2 13.6 13.2 22.8v0c0 12.8-10.4 23.2-23.2 23.2H48c-26.5 0-48-21.5-48-48V343.2C0 330.4 10.4 320 23.2 320v0c9.2 0 17.3 5.8 22.8 13.2C54.7 344.8 66.7 352 80 352c26.5 0 48-28.7 48-64s-21.5-64-48-64c-13.3 0-25.3 7.2-34 18.8C40.5 250.2 32.4 256 23.2 256v0C10.4 256 0 245.6 0 232.8V176c0-26.5 21.5-48 48-48H168.8c12.8 0 23.2-10.4 23.2-23.2v0z", ""]],
    "money-check": [576, 512, [], "f53c", ["M64 64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zm48 160H304c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16s7.2-16 16-16zM96 336c0-8.8 7.2-16 16-16H464c8.8 0 16 7.2 16 16s-7.2 16-16 16H112c-8.8 0-16-7.2-16-16zM408 160h48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H408c-13.3 0-24-10.7-24-24V184c0-13.3 10.7-24 24-24z", "M408 160c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V184c0-13.3-10.7-24-24-24H408zM112 224c-8.8 0-16 7.2-16 16s7.2 16 16 16H304c8.8 0 16-7.2 16-16s-7.2-16-16-16H112z"]],
    "star-half-stroke": [640, 512, ["star-half-alt"], "f5c0", ["M320.1 376.3l-.1 .1v63.5l.1-.1 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L470.5 329 574.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L413.2 150.3 348.9 18C343.6 7 332.4 0 320.1 0c-.5 0-1.1 0-1.6 0H320V87.1l.1-.3 42.7 87.9 12.9 26.6 29.3 4.3 96.1 14.2-70.1 69.3-20.7 20.5 4.8 28.7 16.5 97.6-85.2-45.5-26.4-14.1zM178.3 512c-1.1 .1-2.1 .1-3.2 0h3.2z", "M321.7 0H320V87.1 376.4v63.5L191.8 508.3C181 514 167.9 513.1 158 506s-14.9-19.3-12.9-31.3L169.8 329 65.6 225.9c-8.6-8.5-11.7-21.2-7.9-32.7s13.7-19.9 25.7-21.7L227 150.3 291.4 18c5.4-11 16.5-18 28.8-18c.5 0 1.1 0 1.6 0zM465.2 512c-1.1 .1-2.1 .1-3.2 0h3.2z"]],
    "file-exclamation": [384, 512, [], "f31a", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM192 192c-13.3 0-24 10.7-24 24V328c0 13.3 10.7 24 24 24s24-10.7 24-24V216c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM192 192c-13.3 0-24 10.7-24 24V328c0 13.3 10.7 24 24 24s24-10.7 24-24V216c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]],
    "code": [640, 512, [], "f121", ["M392.8 1.2c-17-4.9-34.7 5-39.6 22l-128 448c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l128-448c4.9-17-5-34.7-22-39.6z", "M473.4 121.4c-12.5 12.5-12.5 32.8 0 45.3L562.7 256l-89.4 89.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l112-112c12.5-12.5 12.5-32.8 0-45.3l-112-112c-12.5-12.5-32.8-12.5-45.3 0zm-306.7 0c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3l112 112c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256l89.4-89.4c12.5-12.5 12.5-32.8 0-45.3z"]],
    "whiskey-glass": [512, 512, [129347, "glass-whiskey"], "f7a0", ["M7.8 43.1C13.9 36 22.7 32 32 32H480c9.3 0 18.1 4 24.2 11.1s8.8 16.4 7.5 25.5l-50 342.9c-5.7 39.3-39.4 68.5-79.2 68.5h-253c-39.7 0-73.4-29.1-79.2-68.5L.3 68.6C-1 59.4 1.7 50.1 7.8 43.1zM69 96l44.7 306.3c1.1 7.9 7.9 13.7 15.8 13.7h253c7.9 0 14.7-5.8 15.8-13.7L443 96H69z", "M424.3 224H87.7l26 178.3c1.1 7.9 7.9 13.7 15.8 13.7h253c7.9 0 14.7-5.8 15.8-13.7l26-178.3z"]],
    "moon-stars": [512, 512, [], "f755", ["M284.8 99.2l11 38.6c1 3.6 4.4 6.2 8.2 6.2s7.1-2.5 8.2-6.2l11-38.6 38.6-11c3.6-1 6.2-4.4 6.2-8.2s-2.5-7.1-6.2-8.2l-38.6-11-11-38.6c-1-3.6-4.4-6.2-8.2-6.2s-7.1 2.5-8.2 6.2l-11 38.6-38.6 11c-3.6 1-6.2 4.4-6.2 8.2s2.5 7.1 6.2 8.2l38.6 11zM387.2 252.8l16.6 58c1.6 5.5 6.6 9.2 12.2 9.2s10.7-3.8 12.2-9.2l16.6-58 58-16.6c5.5-1.6 9.2-6.6 9.2-12.2s-3.8-10.7-9.2-12.2l-58-16.6-16.6-58c-1.6-5.5-6.6-9.2-12.2-9.2s-10.7 3.8-12.2 9.2l-16.6 58-58 16.6c-5.5 1.6-9.2 6.6-9.2 12.2s3.8 10.7 9.2 12.2l58 16.6z", "M191.8 128C85.8 128 0 214.1 0 320.2S85.8 512.4 191.8 512.4c52 0 99.1-20.7 133.6-54.4c5-4.9 6.3-12.5 3.1-18.7s-10.1-9.7-17-8.5c-8.1 1.4-16.5 2.2-25.1 2.2c-80.7 0-146.2-65.6-146.2-146.6c0-54.8 30-102.6 74.4-127.8c6.1-3.5 9.2-10.5 7.7-17.3s-7.3-11.9-14.3-12.5c-5.4-.5-10.8-.7-16.3-.7z"]],
    "building-circle-exclamation": [640, 512, [], "e4d3", ["M0 48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V232.2c-39.1 32.3-64 81.1-64 135.8c0 49.5 20.4 94.2 53.3 126.2C364.5 505.1 351.1 512 336 512H240V432c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-26.5 0-48-21.5-48-48V48zM80 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H80zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H272zM64 112v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H176zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16v80c0 8.8 7.2 16 16 16s16-7.2 16-16V288z"]],
    "clothes-hanger": [640, 512, [], "e136", ["M209.8 84.8C222.3 35 267.1 0 318.5 0H320c61.9 0 112 50.1 112 112v6.3c0 36.5-17.8 70.8-47.8 91.8l-8.3 5.8L608.2 377.2C628.1 391 640 413.7 640 438c0 40.9-33.1 74-74 74H74c-40.9 0-74-33.1-74-74c0-24.2 11.9-47 31.8-60.8L301.6 189.8l.1-.1 45.8-32c12.8-9 20.5-23.7 20.5-39.3V112c0-26.5-21.5-48-48-48h-1.5c-22 0-41.2 15-46.6 36.4l-.9 3.4c-4.3 17.1-21.7 27.6-38.8 23.3s-27.6-21.7-23.3-38.8l.9-3.4zM320 255L68.3 429.7c-2.7 1.9-4.3 4.9-4.3 8.2c0 5.5 4.5 10 10 10H566c5.5 0 10-4.5 10-10c0-3.3-1.6-6.4-4.3-8.2L320 255z", ""]],
    "mobile-notch": [384, 512, ["mobile-iphone"], "e1ee", ["M256 64V80c0 8.8-7.2 16-16 16H144c-8.8 0-16-7.2-16-16V64H96c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16H288c8.8 0 16-7.2 16-16V80c0-8.8-7.2-16-16-16H256zM16 80C16 35.8 51.8 0 96 0H288c44.2 0 80 35.8 80 80V432c0 44.2-35.8 80-80 80H96c-44.2 0-80-35.8-80-80V80z", "M128 64H96c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16H288c8.8 0 16-7.2 16-16V80c0-8.8-7.2-16-16-16H256V80c0 8.8-7.2 16-16 16H144c-8.8 0-16-7.2-16-16V64z"]],
    "magnifying-glass-chart": [512, 512, [], "e522", ["M208 416A208 208 0 1 0 208 0a208 208 0 1 0 0 416zM104 216c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24V216zm80-96c0-13.3 10.7-24 24-24s24 10.7 24 24V280c0 13.3-10.7 24-24 24s-24-10.7-24-24V120zm80 64c0-13.3 10.7-24 24-24s24 10.7 24 24v96c0 13.3-10.7 24-24 24s-24-10.7-24-24V184z", "M104 216c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24V216zm80-96c0-13.3 10.7-24 24-24s24 10.7 24 24V280c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-160zm80 64c0-13.3 10.7-24 24-24s24 10.7 24 24v96c0 13.3-10.7 24-24 24s-24-10.7-24-24V184zM457.4 502.6L330.7 376C348 363.3 363.3 348 376 330.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0z"]],
    "arrow-up-right-from-square": [512, 512, ["external-link"], "f08e", ["M0 112C0 67.8 35.8 32 80 32H192c17.7 0 32 14.3 32 32s-14.3 32-32 32H80c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16H400c8.8 0 16-7.2 16-16V320c0-17.7 14.3-32 32-32s32 14.3 32 32V432c0 44.2-35.8 80-80 80H80c-44.2 0-80-35.8-80-80V112z", "M288 32c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32V192c0 17.7-14.3 32-32 32s-32-14.3-32-32V109.3L246.6 310.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L402.7 64H320c-17.7 0-32-14.3-32-32z"]],
    "cubes-stacked": [448, 512, [], "e4e6", ["M71 250.7c-8.8-15.3-3.6-34.9 11.7-43.7l55.4-32c15.3-8.8 34.9-3.6 43.7 11.7l32 55.4c8.8 15.3 3.6 34.9-11.7 43.7l-55.4 32c-15.3 8.8-34.9 3.6-43.7-11.7L71 250.7zM320 384c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H352c-17.7 0-32-14.3-32-32V384zM32 352H96c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V384c0-17.7 14.3-32 32-32z", "M224 32c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32H224zm32 192v64c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H288c-17.7 0-32 14.3-32 32zM160 384v64c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V384c0-17.7-14.3-32-32-32H192c-17.7 0-32 14.3-32 32z"]],
    "images-user": [576, 512, [], "e1b9", ["M160 32c-35.3 0-64 28.7-64 64V320c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H160zM272 160a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM224 301.7c0-25.2 20.5-45.7 45.7-45.7H402.3c25.2 0 45.7 20.5 45.7 45.7c0 10.1-8.2 18.3-18.3 18.3H242.3c-10.1 0-18.3-8.2-18.3-18.3z", "M48 120c0-13.3-10.7-24-24-24S0 106.7 0 120V344c0 75.1 60.9 136 136 136H456c13.3 0 24-10.7 24-24s-10.7-24-24-24H136c-48.6 0-88-39.4-88-88V120zm352 40a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM224 301.7c0 10.1 8.2 18.3 18.3 18.3H429.7c10.1 0 18.3-8.2 18.3-18.3c0-25.2-20.5-45.7-45.7-45.7H269.7c-25.2 0-45.7 20.5-45.7 45.7z"]],
    "won-sign": [512, 512, [8361, "krw", "won"], "f159", ["M51.6 224H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H72.9L51.6 224zM167 288l16-64h-64l21.3 64H167zm66 0h46l-16-64H249l-16 64zm96-64l16 64h26.6l21.3-64H329zm131.4 0l-21.3 64H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H460.4z", "M21.9 33.6c16.8-5.6 34.9 3.5 40.5 20.2l93.2 279.7L225 56.2C228.5 42 241.3 32 256 32s27.5 10 31 24.2l69.3 277.4L449.6 53.9c5.6-16.8 23.7-25.8 40.5-20.2s25.8 23.7 20.2 40.5l-128 384c-4.5 13.5-17.4 22.4-31.6 21.9s-26.4-10.4-29.8-24.2L256 195.9 191 455.8c-3.5 13.8-15.6 23.7-29.8 24.2s-27.1-8.4-31.6-21.9L1.6 74.1C-3.9 57.4 5.1 39.2 21.9 33.6z"]],
    "image-polaroid-user": [448, 512, [], "e1b6", ["M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM96 96H352c17.7 0 32 14.3 32 32V320c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V128c0-17.7 14.3-32 32-32z", "M96 96c-17.7 0-32 14.3-32 32V320c0 17.7 14.3 32 32 32h16c0-35.3 28.7-64 64-64h96c35.3 0 64 28.7 64 64h16c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H96zm64 96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]],
    "virus-covid": [512, 512, [], "e4a8", ["M192 24c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24s-10.7 24-24 24H280V73.6c32.9 4.3 63 17.2 88 36.5L386.1 92 374.8 80.6c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l56.6 56.6c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L420 125.9 402 144c19.2 25 32.2 55.2 36.5 88H464V216c0-13.3 10.7-24 24-24s24 10.7 24 24v80c0 13.3-10.7 24-24 24s-24-10.7-24-24V280H438.4c-4.3 32.9-17.2 63-36.5 88L420 386.1l11.3-11.3c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-56.6 56.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L386.1 420 368 402c-25 19.2-55.2 32.2-88 36.5V464h16c13.3 0 24 10.7 24 24s-10.7 24-24 24H216c-13.3 0-24-10.7-24-24s10.7-24 24-24h16V438.4c-32.9-4.3-63-17.2-88-36.5L125.9 420l11.3 11.3c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L46.7 408.7c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L92 386.1 110 368c-19.2-25-32.2-55.2-36.5-88H48v16c0 13.3-10.7 24-24 24s-24-10.7-24-24V216c0-13.3 10.7-24 24-24s24 10.7 24 24v16H73.6c4.3-32.9 17.2-63 36.5-88L92 125.9 80.6 137.2c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l56.6-56.6c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L125.9 92 144 110c25-19.2 55.2-32.2 88-36.5V48H216c-13.3 0-24-10.7-24-24zm48 200a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm64 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48z", "M192 176a48 48 0 1 0 0 96 48 48 0 1 0 0-96z"]],
    "square-ellipsis": [448, 512, [], "e26e", ["M0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416zM192 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-64 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm160-32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z", "M128 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm96 0a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm64-32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "pie": [576, 512, [129383], "f705", ["M47.3 301.9L81.4 404.2c8.7 26.1 33.2 43.8 60.7 43.8H433.9c27.5 0 52-17.6 60.7-43.8l34.1-102.3c-11.7-2.6-22.8-7.2-32.2-12.1c-7-3.6-12.7-7.3-16.6-10c-2-1.4-3.5-2.5-4.5-3.2c-.5-.4-.9-.7-1.1-.8l-.2-.2 0 0 0 0 0 0 0 0 0 0 0 0c-6.1-4.9-14.8-4.7-20.7 .4l-.1 .1c-.2 .2-.5 .4-.9 .8c-.9 .7-2.2 1.8-4.1 3.1c-3.7 2.6-9.1 6.2-16.1 9.8C418.2 297 398.7 304 376 304s-42.2-7-56.1-14.2c-7-3.6-12.4-7.2-16.1-9.8c-1.8-1.3-3.2-2.4-4.1-3.1c-.4-.4-.7-.6-.9-.8l-.1-.1 0 0c-6.1-5.4-15.2-5.4-21.2 0l-.1 .1c-.2 .2-.5 .4-.9 .8c-.9 .7-2.2 1.8-4.1 3.1c-3.7 2.6-9.1 6.2-16.1 9.8C242.2 297 222.7 304 200 304s-42.2-7-56.1-14.2c-7-3.6-12.4-7.2-16.1-9.8c-1.8-1.3-3.2-2.4-4.1-3.1c-.4-.4-.7-.6-.9-.8l-.2-.1 0 0c-5.9-5.2-14.6-5.4-20.7-.4l0 0 0 0-.2 .2c-.2 .2-.6 .5-1.1 .8c-1 .7-2.5 1.9-4.5 3.2c-4 2.7-9.7 6.4-16.7 10c-9.4 4.9-20.5 9.5-32.2 12.1zm54.6-26.3l20.7 .4s0 0 0 0l-20.7-.4z", "M544 240c-7.6 0-14.3-4.9-17-12C490 132.1 397 64 288 64S86 132.1 49 228c-2.7 7.1-9.4 12-17 12c-17.7 0-32 14.3-32 32c0 17.2 13.6 31.3 30.7 32c17.7-.5 35-7 48.7-14.2c7-3.6 12.7-7.3 16.7-10c2-1.4 3.5-2.5 4.5-3.2c.5-.4 .9-.7 1.1-.8l.2-.2 0 0 20.7 .4 0 0 .2 .1c.2 .2 .5 .4 .9 .8c.9 .7 2.2 1.8 4.1 3.1c3.7 2.6 9.1 6.2 16.1 9.8c14 7.2 33.4 14.2 56.1 14.2s42.2-7 56.1-14.2c7-3.6 12.4-7.2 16.1-9.8c1.8-1.3 3.2-2.4 4.1-3.1c.4-.4 .7-.6 .9-.8l.1-.1c6.1-5.4 15.2-5.4 21.2 0l0 0 .1 .1c.2 .2 .5 .4 .9 .8c.9 .7 2.2 1.8 4.1 3.1c3.7 2.6 9.1 6.2 16.1 9.8c14 7.2 33.4 14.2 56.1 14.2s42.2-7 56.1-14.2c7-3.6 12.4-7.2 16.1-9.8c1.8-1.3 3.2-2.4 4.1-3.1c.4-.4 .7-.6 .9-.8l.1-.1c5.9-5.2 14.6-5.4 20.7-.4l0 0 0 0 0 0 0 0 0 0 0 0 .2 .2c.2 .2 .6 .5 1.1 .8c1 .7 2.5 1.9 4.5 3.2c4 2.7 9.7 6.4 16.7 10c13.7 7.2 31.1 13.7 48.7 14.2c17.1-.7 30.7-14.7 30.7-32c0-17.7-14.3-32-32-32zM122.6 276c-5.9-5.2-14.6-5.4-20.7-.4l0 0 20.7 .4s0 0 0 0zm76.6-146.3c7.9 4 11.1 13.6 7.2 21.5l-16 32c-4 7.9-13.6 11.1-21.5 7.2s-11.1-13.6-7.2-21.5l16-32c4-7.9 13.6-11.1 21.5-7.2zm177.7 0c7.9-4 17.5-.7 21.5 7.2l16 32c4 7.9 .7 17.5-7.2 21.5s-17.5 .7-21.5-7.2l-16-32c-4-7.9-.7-17.5 7.2-21.5zM288 128c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V144c0-8.8 7.2-16 16-16z"]],
    "chess-knight-piece": [320, 512, ["chess-knight-alt"], "f442", ["M272 416H48L4.8 473.6C1.7 477.8 0 482.8 0 488c0 13.3 10.7 24 24 24H296c13.3 0 24-10.7 24-24c0-5.2-1.7-10.2-4.8-14.4L272 416z", "M50.7 109.3l6.9-6.9L40.7 94C35.4 91.3 32 85.8 32 79.8C32 71.1 39.1 64 47.8 64h81.5C225.8 64 304 142.2 304 238.7c0 11.5-1.1 23-3.4 34.3L272 416H48V389.7c0-29.8 13.8-57.9 37.5-76.1l71.2-54.7c8.1-6.2 8-18.5-.2-24.7c-5.5-4.1-13.1-4.1-18.6 0L99.1 263.3c-2 1.5-4.2 2.9-6.5 4c-13.7 6.9-30 5.8-42.8-2.7l-3.5-2.4C37.3 256.4 32 246.4 32 235.7V154.5c0-17 6.7-33.3 18.7-45.3zm42.1 63.5a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]],
    "austral-sign": [448, 512, [], "e0a9", ["M122.7 224L96 288H32c-17.7 0-32-14.3-32-32s14.3-32 32-32h90.7zm-40 96L56 384H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H82.7zm42.7 64L152 320H296l26.7 64H125.3zM392 384l-26.7-64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H392zm-40-96l-26.7-64H416c17.7 0 32 14.3 32 32s-14.3 32-32 32H352zM192 224h64l26.7 64H165.3L192 224z", "M224 32c12.9 0 24.6 7.8 29.5 19.7l160 384c6.8 16.3-.9 35-17.2 41.8s-35-.9-41.8-17.2L224 147.2 93.5 460.3c-6.8 16.3-25.5 24-41.8 17.2s-24-25.5-17.2-41.8l160-384C199.4 39.8 211.1 32 224 32z"]],
    "cloud-plus": [640, 512, [], "e35e", ["M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zM296 376c0 13.3 10.7 24 24 24s24-10.7 24-24V312h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H344V200c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H232c-13.3 0-24 10.7-24 24s10.7 24 24 24h64v64z", "M296 312v64c0 13.3 10.7 24 24 24s24-10.7 24-24V312h64c13.3 0 24-10.7 24-24s-10.7-24-24-24H344V200c0-13.3-10.7-24-24-24s-24 10.7-24 24v64H232c-13.3 0-24 10.7-24 24s10.7 24 24 24h64z"]],
    "f": [320, 512, [102], "46", ["M64 32C28.7 32 0 60.7 0 96V256 448c0 17.7 14.3 32 32 32s32-14.3 32-32V288H224c17.7 0 32-14.3 32-32s-14.3-32-32-32H64V96H288c17.7 0 32-14.3 32-32s-14.3-32-32-32H64z", ""]],
    "leaf": [512, 512, [], "f06c", ["M96.4 260.1C102.5 168.5 178.8 96 272 96l104 0c42.7 0 79.9-23.9 98.8-59.1c3.5-6.5 13.6-6.8 16.2 .1c13.5 36.5 21.1 77 21.1 119.6C512 317.1 405.1 447.3 273 448l-1 0c-81.7 0-150.4-55.7-170.2-131.2C131.7 289 171.9 272 216 272h72c13.3 0 24-10.7 24-24s-10.7-24-24-24H216c-44.2 0-85.4 13.3-119.6 36.1z", "M216 272c-92.8 0-168 75.2-168 168v16c0 13.3-10.7 24-24 24s-24-10.7-24-24V440C0 320.7 96.7 224 216 224h72c13.3 0 24 10.7 24 24s-10.7 24-24 24H216z"]],
    "bed-bunk": [576, 512, [], "f8f8", ["M192 48A48 48 0 1 0 96 48a48 48 0 1 0 96 0zm0 256a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM256 0c-17.7 0-32 14.3-32 32v96H576C576 57.3 518.7 0 448 0H256zM240 256c-8.8 0-16 7.2-16 16V384H512V256H240z", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32v96 64V480c0 17.7 14.3 32 32 32s32-14.3 32-32V448H256 512v32c0 17.7 14.3 32 32 32s32-14.3 32-32V448 416 288 192 160 128H544 256 64V32zM512 288v96H256 64V192H256 512v96z"]],
    "road": [576, 512, [128739], "f018", ["M256 32h64V96c0 17.7-14.3 32-32 32s-32-14.3-32-32V32zm32 160c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V224c0-17.7 14.3-32 32-32zm0 192c17.7 0 32 14.3 32 32v64H256V416c0-17.7 14.3-32 32-32z", "M256 32H181.2c-27.1 0-51.3 17.1-60.3 42.6L3.1 407.2C1.1 413 0 419.2 0 425.4C0 455.5 24.5 480 54.6 480H256V416c0-17.7 14.3-32 32-32s32 14.3 32 32v64H521.4c30.2 0 54.6-24.5 54.6-54.6c0-6.2-1.1-12.4-3.1-18.2L455.1 74.6C446 49.1 421.9 32 394.8 32H320V96c0 17.7-14.3 32-32 32s-32-14.3-32-32V32zm64 192v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V224c0-17.7 14.3-32 32-32s32 14.3 32 32z"]],
    "taxi": [512, 512, [128662, "cab"], "f1ba", ["M192 0H320c17.7 0 32 14.3 32 32V64H160V32c0-17.7 14.3-32 32-32zM135.2 149.4c4.5-12.8 16.6-21.4 30.2-21.4H346.6c13.6 0 25.7 8.6 30.2 21.4L402.9 224H109.1l26.1-74.6zM96 432v48c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V432H96zm320 0h96v48c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V432z", "M135.2 149.4L109.1 224H402.9l-26.1-74.6c-4.5-12.8-16.6-21.4-30.2-21.4H165.4c-13.6 0-25.7 8.6-30.2 21.4zM39.6 228.8L74.8 128.3C88.3 89.8 124.6 64 165.4 64H346.6c40.8 0 77.1 25.8 90.6 64.3l35.2 100.5c23.2 9.6 39.6 32.5 39.6 59.2V432H0V288c0-26.7 16.4-49.6 39.6-59.2zM128 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]],
    "person-circle-plus": [576, 512, [], "e541", ["M160 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-8 384V352h16V480c0 17.7 14.3 32 32 32s32-14.3 32-32V256.9l28.6 47.5c1.4 2.3 3.1 4.5 4.9 6.3c7.9-23 20.5-43.9 36.6-61.5l-44.9-74.7c-17.4-28.9-48.6-46.6-82.3-46.6H145.1c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9L88 256.9V480c0 17.7 14.3 32 32 32s32-14.3 32-32z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16v48H368c-8.8 0-16 7.2-16 16s7.2 16 16 16h48v48c0 8.8 7.2 16 16 16s16-7.2 16-16V384h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H448V304c0-8.8-7.2-16-16-16z"]],
    "chart-pie": [576, 512, ["pie-chart"], "f200", ["M32 272C32 150.7 122.1 50.3 239 34.3c9.2-1.3 17 6.1 17 15.4V288L412.5 444.5c6.7 6.7 6.2 17.7-1.5 23.1C371.8 495.6 323.8 512 272 512C139.5 512 32 404.6 32 272z", "M527.4 240H304V16.6c0-9 7-16.6 16-16.6C443.7 0 544 100.3 544 224c0 9-7.6 16-16.6 16zm31 48c9.3 0 16.6 7.8 15.4 17c-7.7 55.9-34.6 105.6-73.9 142.3c-6 5.6-15.4 5.2-21.2-.7L320 288H558.4z"]],
    "bolt-lightning": [384, 512, [], "e0b7", ["", "M0 256L28.5 28c2-16 15.6-28 31.8-28H228.9c15 0 27.1 12.1 27.1 27.1c0 3.2-.6 6.5-1.7 9.5L208 160H347.3c20.2 0 36.7 16.4 36.7 36.7c0 7.4-2.2 14.6-6.4 20.7l-192.2 281c-5.9 8.6-15.6 13.7-25.9 13.7h-2.9c-15.7 0-28.5-12.8-28.5-28.5c0-2.3 .3-4.6 .9-6.9L176 288H32c-17.7 0-32-14.3-32-32z"]],
    "clock-eight": [512, 512, [], "e345", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392V256c0 8-4 15.5-10.7 20l-96 64c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3L232 243.2V120c0-13.3 10.7-24 24-24s24 10.7 24 24z", "M256 96c13.3 0 24 10.7 24 24V256c0 8-4 15.5-10.7 20l-96 64c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3L232 243.2V120c0-13.3 10.7-24 24-24z"]],
    "sack-xmark": [512, 512, [], "e56a", ["M192 96H320l47.4-71.1C374.5 14.2 366.9 0 354.1 0H157.9c-12.8 0-20.4 14.2-13.3 24.9L192 96zm128 32H192c-3.8 2.5-8.1 5.3-13 8.4l0 0 0 0C122.3 172.7 0 250.9 0 416c0 53 43 96 96 96H416c53 0 96-43 96-96c0-165.1-122.3-243.3-179-279.6c-4.8-3.1-9.2-5.9-13-8.4zM289.9 320l47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47z", "M192 96H320c8.8 0 16 7.2 16 16s-7.2 16-16 16H192c-8.8 0-16-7.2-16-16s7.2-16 16-16zM175 401c-9.4-9.4-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0z"]],
    "file-excel": [384, 512, [], "f1c3", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM155.7 250.2c-7.6-10.9-22.6-13.5-33.4-5.9s-13.5 22.6-5.9 33.4L162.7 344l-46.4 66.2c-7.6 10.9-5 25.8 5.9 33.4s25.8 5 33.4-5.9L192 385.8l36.3 51.9c7.6 10.9 22.6 13.5 33.4 5.9s13.5-22.6 5.9-33.4L221.3 344l46.4-66.2c7.6-10.9 5-25.8-5.9-33.4s-25.8-5-33.4 5.9L192 302.1l-36.3-51.9z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM155.7 250.2c-7.6-10.9-22.6-13.5-33.4-5.9s-13.5 22.6-5.9 33.4L162.7 344l-46.4 66.2c-7.6 10.9-5 25.8 5.9 33.4s25.8 5 33.4-5.9L192 385.8l36.3 51.9c7.6 10.9 22.6 13.5 33.4 5.9s13.5-22.6 5.9-33.4L221.3 344l46.4-66.2c7.6-10.9 5-25.8-5.9-33.4s-25.8-5-33.4 5.9L192 302.1l-36.3-51.9z"]],
    "file-contract": [384, 512, [], "f56c", ["M0 64C0 28.7 28.7 0 64 0H224V128c0 17.7 14.3 32 32 32H384V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zm80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H80zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H80zm54.2 253.8L144 349l16.7 55.6c1.9 6.3 7.4 10.8 13.9 11.3s12.8-2.9 15.7-8.8l8.8-17.7c1.7-3.4 5.1-5.5 8.8-5.5s7.2 2.1 8.8 5.5l8.8 17.7c2.7 5.4 8.3 8.8 14.3 8.8h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H249.9l-4.4-8.8C238.4 361 223.9 352 208 352c-10 0-19.4 3.5-26.8 9.7l-11.6-38.6C166.2 311.7 155.8 304 144 304s-22.2 7.7-25.6 19.1l-14.9 49.5c-2 6.8-8.3 11.4-15.3 11.4H80c-8.8 0-16 7.2-16 16s7.2 16 16 16h8.2c21.2 0 39.9-13.9 46-34.2z", "M384 160L224 0V128c0 17.7 14.3 32 32 32H384zM134.2 381.8L144 349l16.7 55.6c1.9 6.3 7.4 10.8 13.9 11.3s12.8-2.9 15.7-8.8l8.8-17.7c1.7-3.4 5.1-5.5 8.8-5.5s7.2 2.1 8.8 5.5l8.8 17.7c2.7 5.4 8.3 8.8 14.3 8.8h64c8.8 0 16-7.2 16-16s-7.2-16-16-16H249.9l-4.4-8.8C238.4 361 223.9 352 208 352c-10 0-19.4 3.5-26.8 9.7l-11.6-38.6C166.2 311.7 155.8 304 144 304s-22.2 7.7-25.6 19.1l-14.9 49.5c-2 6.8-8.3 11.4-15.3 11.4H80c-8.8 0-16 7.2-16 16s7.2 16 16 16h8.2c21.2 0 39.9-13.9 46-34.2z"]],
    "fish-fins": [576, 512, [], "e4f2", ["M182 150.4C221.3 120.9 273.7 96 336 96s114.7 24.9 154 54.4c39.2 29.4 67.2 64.7 81.6 89.5c5.8 9.9 5.8 22.2 0 32.1c-14.4 24.8-42.5 60.1-81.6 89.5C450.7 391.1 398.3 416 336 416s-114.7-24.9-154-54.4c-15.3-11.5-29-23.9-40.7-36.3L48.1 379.6c-12.5 7.3-28.4 5.3-38.7-4.9S-3 348.7 4.2 336.1L50 256 4.2 175.9c-7.2-12.6-5-28.4 5.3-38.6s26.1-12.2 38.7-4.9l93.1 54.3c11.8-12.3 25.4-24.8 40.7-36.3zM448 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z", "M238.9 36.9C227.7 44 222 57.3 224.6 70.3l9.7 48.6C264.1 105.1 298.2 96 336 96c5.7 0 11.3 .2 16.8 .6L275.2 38.4c-10.6-8-25-8.5-36.3-1.5zm-4.6 356.2l-9.7 48.6c-2.6 13 3.1 26.3 14.3 33.3s25.6 6.5 36.3-1.5l77.6-58.2c-5.5 .4-11.1 .6-16.8 .6c-37.8 0-71.9-9.1-101.7-22.9z"]],
    "circle-q": [512, 512, [], "e11e", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176 256c0 44.2 35.8 80 80 80c13.4 0 25.9-3.3 37-9.1l-30-30c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l30 30c5.8-11.1 9.1-23.7 9.1-37c0-44.2-35.8-80-80-80s-80 35.8-80 80zm208 0c0 26.7-8.2 51.4-22.1 71.9L377 343c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-15.1-15.1c-20.5 14-45.3 22.1-71.9 22.1c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128z", "M256 176c44.2 0 80 35.8 80 80c0 13.4-3.3 25.9-9.1 37l-30-30c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l30 30c-11.1 5.8-23.7 9.1-37 9.1c-44.2 0-80-35.8-80-80s35.8-80 80-80zM361.9 327.9c14-20.5 22.1-45.3 22.1-71.9c0-70.7-57.3-128-128-128s-128 57.3-128 128s57.3 128 128 128c26.7 0 51.4-8.2 71.9-22.1L343 377c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-15.1-15.1z"]],
    "building-flag": [640, 512, [], "e4d5", ["M0 48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48H240V432c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-26.5 0-48-21.5-48-48V48zM80 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H80zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H272zM64 112v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H80c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H176zm80 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H272c-8.8 0-16 7.2-16 16z", "M480 32c0-17.7-14.3-32-32-32s-32 14.3-32 32V512h64V192H624c8.8 0 16-7.2 16-16V48c0-8.8-7.2-16-16-16H480z"]],
    "face-grin-beam": [512, 512, [128516, "grin-beam"], "f582", ["M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM388.1 312.8c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19zm-170.5-84l0 0 0 0-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2 0 0 0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l0 0 0 0zm160 0l0 0-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2 0 0 0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l0 0 0 0 0 0z", "M217.6 228.8l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 188.4 120 206.1 120 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0zm160 0l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 188.4 280 206.1 280 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0z"]],
    "object-ungroup": [640, 512, [], "f248", ["M608 279.4c19.1-11.1 32-31.7 32-55.4c0-35.3-28.7-64-64-64c-23.7 0-44.4 12.9-55.4 32H416v40.6c9.7 5.6 17.8 13.7 23.4 23.4h81.1c5.6 9.7 13.7 17.8 23.4 23.4V392.6c-9.7 5.6-17.8 13.7-23.4 23.4H311.4c-5.6-9.7-13.7-17.8-23.4-23.4V320H224v72.6c-19.1 11.1-32 31.7-32 55.4c0 35.3 28.7 64 64 64c23.7 0 44.4-12.9 55.4-32H520.6c11.1 19.1 31.7 32 55.4 32c35.3 0 64-28.7 64-64c0-23.7-12.9-44.4-32-55.4V279.4z", "M0 64c0 23.7 12.9 44.4 32 55.4V232.6C12.9 243.6 0 264.3 0 288c0 35.3 28.7 64 64 64c23.7 0 44.4-12.9 55.4-32H328.6c11.1 19.1 31.7 32 55.4 32c35.3 0 64-28.7 64-64c0-23.7-12.9-44.4-32-55.4V119.4c19.1-11.1 32-31.7 32-55.4c0-35.3-28.7-64-64-64c-23.7 0-44.4 12.9-55.4 32H119.4C108.4 12.9 87.7 0 64 0C28.7 0 0 28.7 0 64zM328.6 96c5.6 9.7 13.7 17.8 23.4 23.4V232.6c-9.7 5.6-17.8 13.7-23.4 23.4H119.4c-5.6-9.7-13.7-17.8-23.4-23.4V119.4c9.7-5.6 17.8-13.7 23.4-23.4H328.6z"]],
    "face-disguise": [512, 512, [], "e370", ["M512 256c0 141.4-114.6 256-256 256S0 397.4 0 256c0-16.4 1.5-32.5 4.5-48H72c0 50.1 38.4 91.2 87.3 95.6c-9.6 7.9-15.3 19.7-15.3 32.4c0 15.9 9 30.4 23.1 37.5L147.5 398c-5.5 6.9-4.4 17 2.5 22.5s17 4.4 22.5-2.5l23.9-29.9 7.3 3.6-10.5 26.3c-3.3 8.2 .7 17.5 8.9 20.8s17.5-.7 20.8-8.9l10-24.9c2.4 .7 4.8 1.3 7.2 1.8V432c0 8.8 7.2 16 16 16s16-7.2 16-16V406.8c2.4-.5 4.8-1.1 7.2-1.8l10 24.9c3.3 8.2 12.6 12.2 20.8 8.9s12.2-12.6 8.9-20.8l-10.5-26.3 7.3-3.6L339.5 418c5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5l-19.6-24.5C359 366.4 368 351.9 368 336c0-12.7-5.7-24.5-15.3-32.4c49-4.4 87.3-45.5 87.3-95.6h67.5c3 15.5 4.5 31.6 4.5 48zM256 0C369.4 0 465.7 73.8 499.3 176H434.5c-5.3-14.9-14.1-28-25.4-38.5l5.2-10.3c4-7.9 .7-17.5-7.2-21.5s-17.5-.7-21.5 7.2l-3.5 7c-4.6-2-9.3-3.6-14.2-4.9V96c0-8.8-7.2-16-16-16s-16 7.2-16 16v16.3c-4.4 .4-8.7 1-13 2l-4.7-9.5c-4-7.9-13.6-11.1-21.5-7.2s-11.1 13.6-7.2 21.5l3.6 7.3c-16.4 10.2-29.5 25.3-37.3 43.1c-7.8-17.9-20.9-32.9-37.3-43.1l3.6-7.3c4-7.9 .7-17.5-7.2-21.5s-17.5-.7-21.5 7.2l-4.7 9.5c-4.2-.9-8.6-1.6-13-2V96c0-8.8-7.2-16-16-16s-16 7.2-16 16v19c-4.9 1.3-9.6 2.9-14.2 4.9l-3.5-7c-4-7.9-13.6-11.1-21.5-7.2s-11.1 13.6-7.2 21.5l5.2 10.3C91.5 148 82.7 161.1 77.5 176H12.7C46.3 73.8 142.6 0 256 0z", "M160 80c8.8 0 16 7.2 16 16v16.3c4.4 .4 8.7 1 13 2l4.7-9.5c4-7.9 13.6-11.1 21.5-7.2s11.1 13.6 7.2 21.5l-3.6 7.3c16.4 10.2 29.5 25.3 37.3 43.1c7.8-17.9 20.9-32.9 37.3-43.1l-3.6-7.3c-4-7.9-.7-17.5 7.2-21.5s17.5-.7 21.5 7.2l4.7 9.5c4.2-.9 8.6-1.6 13-2V96c0-8.8 7.2-16 16-16s16 7.2 16 16v19c4.9 1.3 9.6 2.9 14.2 4.9l3.5-7c4-7.9 13.6-11.1 21.5-7.2s11.1 13.6 7.2 21.5l-5.2 10.3c11.3 10.5 20.1 23.7 25.4 38.5H496c8.8 0 16 7.2 16 16s-7.2 16-16 16H440c0 50.1-38.4 91.2-87.3 95.6c9.6 7.9 15.3 19.7 15.3 32.4c0 15.9-9 30.4-23.1 37.5L364.5 398c5.5 6.9 4.4 17-2.5 22.5s-17 4.4-22.5-2.5l-23.9-29.9-7.3 3.6 10.5 26.3c3.3 8.2-.7 17.5-8.9 20.8s-17.5-.7-20.8-8.9l-10-24.9c-2.4 .7-4.8 1.3-7.2 1.8V432c0 8.8-7.2 16-16 16s-16-7.2-16-16V406.8c-2.4-.5-4.8-1.1-7.2-1.8l-10 24.9c-3.3 8.2-12.6 12.2-20.8 8.9s-12.2-12.6-8.9-20.8l10.5-26.3-7.3-3.6L172.5 418c-5.5 6.9-15.6 8-22.5 2.5s-8-15.6-2.5-22.5l19.6-24.5C153 366.4 144 351.9 144 336c0-12.7 5.7-24.5 15.3-32.4C110.4 299.2 72 258.1 72 208H16c-8.8 0-16-7.2-16-16s7.2-16 16-16H77.5c5.3-14.9 14.1-28 25.4-38.5l-5.2-10.3c-4-7.9-.7-17.5 7.2-21.5s17.5-.7 21.5 7.2l3.5 7c4.6-2 9.3-3.6 14.2-4.9V96c0-8.8 7.2-16 16-16zM317.9 266.5c7.9 3.5 16.8 5.5 26.1 5.5c35.3 0 64-28.7 64-64s-28.7-64-64-64s-64 28.7-64 64c0 2.5 .1 4.9 .4 7.3c5.4 3.6 10.1 8.4 13.5 14.1l21.4 35.7c1.1 .6 1.9 1 2.6 1.3zM232 208c0-35.3-28.7-64-64-64s-64 28.7-64 64s28.7 64 64 64c9.3 0 18.1-2 26.1-5.5c.6-.3 1.5-.7 2.6-1.3L218 229.5c3.5-5.8 8.1-10.6 13.5-14.1c.3-2.4 .4-4.9 .4-7.3zm24 32c-4.3 0-8.3 2.3-10.5 6l-39.8 66.3-2.4 4-4.2 2.1-17.7 8.8c-3.4 1.7-5.5 5.1-5.5 8.8s2.1 7.2 5.5 8.8l53.1 26.5c13.5 6.8 29.4 6.8 42.9 0l53.1-26.5c3.4-1.7 5.5-5.1 5.5-8.8s-2.1-7.2-5.5-8.8l-17.7-8.8-4.2-2.1-2.4-4L266.5 246c-2.2-3.7-6.2-6-10.5-6zM144 216a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm200-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]],
    "circle-arrow-down-right": [512, 512, [], "e0fa", ["M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM192 368c-13.3 0-24-10.7-24-24s10.7-24 24-24h94.1L151 185c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l135 135V184c0-13.3 10.7-24 24-24s24 10.7 24 24V344c0 13.3-10.7 24-24 24H192z", "M344 368H192c-13.3 0-24-10.7-24-24s10.7-24 24-24h94.1L151 185c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l135 135V184c0-13.3 10.7-24 24-24s24 10.7 24 24V344c0 13.3-10.7 24-24 24z"]],
    "alien-8bit": [576, 512, [128126, "alien-monster"], "f8f6", ["M96 48c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16V64h48c8.8 0 16 7.2 16 16v48H352V80c0-8.8 7.2-16 16-16h48V48c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16V80c0 8.8-7.2 16-16 16H416v32 32h48c8.8 0 16 7.2 16 16v48h32V144c0-8.8 7.2-16 16-16h32c8.8 0 16 7.2 16 16V272c0 8.8-7.2 16-16 16H512v80c0 8.8-7.2 16-16 16H448v80c0 8.8-7.2 16-16 16H384 336c-8.8 0-16-7.2-16-16V432c0-8.8 7.2-16 16-16h48V384H192v32h48c8.8 0 16 7.2 16 16v32c0 8.8-7.2 16-16 16H192 144c-8.8 0-16-7.2-16-16V384H80c-8.8 0-16-7.2-16-16V288H16c-8.8 0-16-7.2-16-16V144c0-8.8 7.2-16 16-16H48c8.8 0 16 7.2 16 16v80H96V176c0-8.8 7.2-16 16-16h48V128 96H112c-8.8 0-16-7.2-16-16V48zm64 192v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm192 0v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H368c-8.8 0-16 7.2-16 16z", "M176 224c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H176zm192 0c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H368z"]],
    "hand-point-ribbon": [448, 512, [], "e1a6", ["M64 32C64 14.3 78.3 0 96 0s32 14.3 32 32L64 32zm0 208V160h64v80H64zm192-48c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V192zm-64-64c17.7 0 32 14.3 32 32v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V160c0-17.7 14.3-32 32-32zm160 96c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 17.7-14.3 32-32 32s-32-14.3-32-32V224zm-96 88l0-.6c9.4 5.4 20.3 8.6 32 8.6c13.2 0 25.4-4 35.6-10.8c8.7 24.9 32.5 42.8 60.4 42.8c11.7 0 22.6-3.1 32-8.6V352c0 88.4-71.6 160-160 160H194.3c-42.4 0-83.1-16.9-113.1-46.9L69.5 453.5C45.5 429.5 32 396.9 32 363V336c0-35.3 28.7-64 64-64h88c22.1 0 40 17.9 40 40s-17.9 40-40 40H128c-8.8 0-16 7.2-16 16s7.2 16 16 16h56c39.8 0 72-32.2 72-72z", "M176 112V48c0-8.8-7.2-16-16-16H11.8C5.3 32 0 37.3 0 43.8c0 3.9 1.9 7.5 5.1 9.7L43.6 80 5.1 106.5c-3.2 2.2-5.1 5.8-5.1 9.7C0 122.7 5.3 128 11.8 128H160c8.8 0 16-7.2 16-16z"]],
    "poop": [512, 512, [], "f619", ["M268.9 .9c-5.5-.7-11 1.4-14.5 5.7s-4.6 10.1-2.8 15.4c2.8 8.2 4.3 16.9 4.3 26.1c0 44.1-35.7 79.9-79.8 80H160c-35.3 0-64 28.7-64 64c0 5.5 .7 10.9 2 16H414c1.3-5.1 2-10.5 2-16c0-35.3-28.7-64-64-64h-5.5c3.5-10 5.5-20.8 5.5-32c0-48.6-36.2-88.8-83.1-95.1zM394.3 240H117.7s0 0 0 0H104c-39.8 0-72 32.2-72 72c0 8.4 1.4 16.5 4.1 24H475.9c2.7-7.5 4.1-15.6 4.1-24c0-39.8-32.2-72-72-72H394.3s0 0 0 0zm58.9 128H58.7c.4 .3 .8 .7 1.3 1c-34.1 5.7-60 35.3-60 71c0 14.8 4.5 28.6 12.1 40H499.9c7.7-11.4 12.1-25.2 12.1-40c0-35.7-25.9-65.3-60-71c.4-.3 .8-.7 1.3-1zM440.2 512H71.8c.1 0 .1 0 .2 0H440c.1 0 .1 0 .2 0z", "M117.7 240c-9.4-8.3-16.4-19.4-19.7-32H414c-3.2 12.6-10.2 23.7-19.7 32H117.7zM58.7 368c-10.2-8.3-18.2-19.3-22.6-32H475.9c-4.5 12.7-12.4 23.7-22.6 32H58.7zM71.8 512c-24.9-.1-46.8-12.8-59.7-32H499.9c-12.9 19.2-34.8 31.9-59.7 32H71.8z"]],
    "object-exclude": [512, 512, [], "e49c", ["M224 160c-35.3 0-64 28.7-64 64V352H288c35.3 0 64-28.7 64-64V160H224zm80 48v96H208V208h96z", "M64 0C28.7 0 0 28.7 0 64V288c0 35.3 28.7 64 64 64h96v96c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V224c0-35.3-28.7-64-64-64H352V64c0-35.3-28.7-64-64-64H64zM352 160V288c0 35.3-28.7 64-64 64H160V224c0-35.3 28.7-64 64-64H352z"]],
    "telescope": [576, 512, [128301], "e03e", ["M361 76.6c.7 2.4 1.7 4.8 3 7.1L460 250c.2 .4 .5 .8 .7 1.2l-77.5 41.6C377.8 253.9 344.4 224 304 224c-44.2 0-80 35.8-80 80c0 20.1 7.4 38.5 19.7 52.5l-5.8 14.2-88.4 47.4c-15.2 8.2-34.2 2.8-42.8-12.2l-.8-1.4L61.7 430.1c-11.5 6.6-26.2 2.7-32.8-8.8L3.1 376.4c-6.6-11.5-2.7-26.2 8.8-32.8l44.1-25.5-4-6.9c-8.5-14.8-4-33.7 10.4-42.9L361 76.6z", "M375.7 40c-15.3 8.8-20.6 28.4-11.7 43.7L460 250c8.8 15.3 28.4 20.5 43.7 11.7l55.4-32c15.3-8.8 20.5-28.4 11.7-43.7l-96-166.3C466 4.4 446.4-.8 431.1 8L375.7 40zM364.3 356.5C376.6 342.5 384 324.1 384 304c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 20.1 7.4 38.5 19.7 52.5L193.8 478.9c-5 12.3 .9 26.3 13.2 31.3s26.3-.9 31.3-13.2l47-115.3c6 1.5 12.3 2.2 18.8 2.2s12.8-.8 18.8-2.2l47 115.3c5 12.3 19 18.2 31.3 13.2s18.2-19 13.2-31.3L364.3 356.5zM272 304a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]],
    "location-pin": [384, 512, ["map-marker"], "f041", ["M384 192c0 87.4-117 243-168.3 307.2c-12.3 15.3-35.1 15.3-47.4 0C117 435 0 279.4 0 192C0 86 86 0 192 0S384 86 384 192z", ""]],
    "square-list": [448, 512, [], "e489", ["M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32-128a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-248c-13.3 0-24 10.7-24 24s10.7 24 24 24H352c13.3 0 24-10.7 24-24s-10.7-24-24-24H192zM168 352c0 13.3 10.7 24 24 24H352c13.3 0 24-10.7 24-24s-10.7-24-24-24H192c-13.3 0-24 10.7-24 24zm24-120c-13.3 0-24 10.7-24 24s10.7 24 24 24H352c13.3 0 24-10.7 24-24s-10.7-24-24-24H192z", "M168 160c0-13.3 10.7-24 24-24H352c13.3 0 24 10.7 24 24s-10.7 24-24 24H192c-13.3 0-24-10.7-24-24zm0 192c0-13.3 10.7-24 24-24H352c13.3 0 24 10.7 24 24s-10.7 24-24 24H192c-13.3 0-24-10.7-24-24zm24-120H352c13.3 0 24 10.7 24 24s-10.7 24-24 24H192c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]],
    "kaaba": [576, 512, [128331], "f66b", ["M60 120L288 48.8 516 120 288 191.2 60 120zM0 229.2l52.8 16.5c8.4 2.6 13.1 11.6 10.5 20s-11.6 13.1-20 10.5L0 262.8V229.2zm576 33.5l-43.2 13.5c-8.4 2.6-17.4-2.1-20-10.5s2.1-17.4 10.5-20L576 229.2v33.5zM96.7 276.2c2.6-8.4 11.6-13.1 20-10.5l64 20c8.4 2.6 13.1 11.6 10.5 20s-11.6 13.1-20 10.5l-64-20c-8.4-2.6-13.1-11.6-10.5-20zm382.5 0c2.6 8.4-2.1 17.4-10.5 20l-64 20c-8.4 2.6-17.4-2.1-20-10.5s2.1-17.4 10.5-20l64-20c8.4-2.6 17.4 2.1 20 10.5zm-254.5 40c2.6-8.4 11.6-13.1 20-10.5l38.5 12c3.1 1 6.4 1 9.5 0l38.5-12c8.4-2.6 17.4 2.1 20 10.5s-2.1 17.4-10.5 20l-38.5 12c-9.3 2.9-19.3 2.9-28.6 0l-38.5-12c-8.4-2.6-13.1-11.6-10.5-20z", "M60 120l228 71.2L516 120 288 48.8 60 120zM278.5 1.5c6.2-1.9 12.9-1.9 19.1 0l256 80C566.9 85.6 576 98 576 112v16 0 21.2L292.8 237.7c-3.1 1-6.4 1-9.5 0L0 149.2V128 112C0 98 9.1 85.6 22.5 81.5l256-80zm23.9 266.8L576 182.8v46.5l-52.8 16.5c-8.4 2.6-13.1 11.6-10.5 20s11.6 13.1 20 10.5L576 262.8V400c0 14-9.1 26.4-22.5 30.5l-256 80c-6.2 1.9-12.9 1.9-19.1 0l-256-80C9.1 426.4 0 414 0 400V262.8l43.2 13.5c8.4 2.6 17.4-2.1 20-10.5s-2.1-17.4-10.5-20L0 229.2V182.8l273.7 85.5c9.3 2.9 19.3 2.9 28.6 0zm-185.5-2.6c-8.4