/*!
 * Font Awesome Pro 6.4.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2023 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      enumerableOnly && (symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      })), keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = null != arguments[i] ? arguments[i] : {};
      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  var _familyProxy, _familyProxy2, _familyProxy3, _familyProxy4, _familyProxy5;

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();
  var FAMILY_CLASSIC = 'classic';
  var FAMILY_SHARP = 'sharp';
  var FAMILIES = [FAMILY_CLASSIC, FAMILY_SHARP];

  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[FAMILY_CLASSIC];
      }
    });
  }
  var PREFIX_TO_STYLE = familyProxy((_familyProxy = {}, _defineProperty(_familyProxy, FAMILY_CLASSIC, {
    'fa': 'solid',
    'fas': 'solid',
    'fa-solid': 'solid',
    'far': 'regular',
    'fa-regular': 'regular',
    'fal': 'light',
    'fa-light': 'light',
    'fat': 'thin',
    'fa-thin': 'thin',
    'fad': 'duotone',
    'fa-duotone': 'duotone',
    'fab': 'brands',
    'fa-brands': 'brands',
    'fak': 'kit',
    'fa-kit': 'kit'
  }), _defineProperty(_familyProxy, FAMILY_SHARP, {
    'fa': 'solid',
    'fass': 'solid',
    'fa-solid': 'solid',
    'fasr': 'regular',
    'fa-regular': 'regular',
    'fasl': 'light',
    'fa-light': 'light'
  }), _familyProxy));
  var STYLE_TO_PREFIX = familyProxy((_familyProxy2 = {}, _defineProperty(_familyProxy2, FAMILY_CLASSIC, {
    'solid': 'fas',
    'regular': 'far',
    'light': 'fal',
    'thin': 'fat',
    'duotone': 'fad',
    'brands': 'fab',
    'kit': 'fak'
  }), _defineProperty(_familyProxy2, FAMILY_SHARP, {
    'solid': 'fass',
    'regular': 'fasr',
    'light': 'fasl'
  }), _familyProxy2));
  var PREFIX_TO_LONG_STYLE = familyProxy((_familyProxy3 = {}, _defineProperty(_familyProxy3, FAMILY_CLASSIC, {
    'fab': 'fa-brands',
    'fad': 'fa-duotone',
    'fak': 'fa-kit',
    'fal': 'fa-light',
    'far': 'fa-regular',
    'fas': 'fa-solid',
    'fat': 'fa-thin'
  }), _defineProperty(_familyProxy3, FAMILY_SHARP, {
    'fass': 'fa-solid',
    'fasr': 'fa-regular',
    'fasl': 'fa-light'
  }), _familyProxy3));
  var LONG_STYLE_TO_PREFIX = familyProxy((_familyProxy4 = {}, _defineProperty(_familyProxy4, FAMILY_CLASSIC, {
    'fa-brands': 'fab',
    'fa-duotone': 'fad',
    'fa-kit': 'fak',
    'fa-light': 'fal',
    'fa-regular': 'far',
    'fa-solid': 'fas',
    'fa-thin': 'fat'
  }), _defineProperty(_familyProxy4, FAMILY_SHARP, {
    'fa-solid': 'fass',
    'fa-regular': 'fasr',
    'fa-light': 'fasl'
  }), _familyProxy4));
  var FONT_WEIGHT_TO_PREFIX = familyProxy((_familyProxy5 = {}, _defineProperty(_familyProxy5, FAMILY_CLASSIC, {
    '900': 'fas',
    '400': 'far',
    'normal': 'far',
    '300': 'fal',
    '100': 'fat'
  }), _defineProperty(_familyProxy5, FAMILY_SHARP, {
    '900': 'fass',
    '400': 'fasr',
    '300': 'fasl'
  }), _familyProxy5));
  var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
  var DUOTONE_CLASSES = {
    GROUP: 'duotone-group',
    SWAP_OPACITY: 'swap-opacity',
    PRIMARY: 'primary',
    SECONDARY: 'secondary'
  };
  var prefixes = new Set();
  Object.keys(STYLE_TO_PREFIX[FAMILY_CLASSIC]).map(prefixes.add.bind(prefixes));
  Object.keys(STYLE_TO_PREFIX[FAMILY_SHARP]).map(prefixes.add.bind(prefixes));
  var RESERVED_CLASSES = [].concat(FAMILIES, _toConsumableArray(prefixes), ['2xs', 'xs', 'sm', 'lg', 'xl', '2xl', 'beat', 'border', 'fade', 'beat-fade', 'bounce', 'flip-both', 'flip-horizontal', 'flip-vertical', 'flip', 'fw', 'inverse', 'layers-counter', 'layers-text', 'layers', 'li', 'pull-left', 'pull-right', 'pulse', 'rotate-180', 'rotate-270', 'rotate-90', 'rotate-by', 'shake', 'spin-pulse', 'spin-reverse', 'spin', 'stack-1x', 'stack-2x', 'stack', 'ul', DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY]).concat(oneToTen.map(function (n) {
    return "".concat(n, "x");
  })).concat(oneToTwenty.map(function (n) {
    return "w-".concat(n);
  }));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});
  }

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160V320c0 88.4-71.6 160-160 160S0 408.4 0 320V192zM160 48C80.5 48 16 112.5 16 192V320c0 79.5 64.5 144 144 144s144-64.5 144-144V192c0-79.5-64.5-144-144-144z"],
    "1": [256, 512, [], "31", "M136 40c0-2.8-1.5-5.4-3.9-6.9s-5.4-1.5-7.9-.2L20.2 89c-3.9 2.1-5.3 6.9-3.3 10.8s6.9 5.3 10.8 3.3L120 53.4V464H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H120 248c4.4 0 8-3.6 8-8s-3.6-8-8-8H136V40z"],
    "2": [320, 512, [], "32", "M147 48c-30.7 0-60.6 11.3-83.5 31.7L29.3 110c-3.3 2.9-8.4 2.6-11.3-.7s-2.6-8.4 .7-11.3L52.8 67.7C78.7 44.7 112.4 32 147 32c77.4 0 141 62.8 141 140.3c0 40.3-17.3 78.6-47.5 105.2L29.2 464H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-3.3 0-6.3-2.1-7.5-5.2s-.3-6.6 2.2-8.8L229.9 265.5C256.7 241.9 272 208 272 172.3C272 103.7 215.7 48 147 48z"],
    "3": [320, 512, [], "33", "M0 40c0-4.4 3.6-8 8-8H288c3.3 0 6.3 2.1 7.5 5.2s.3 6.6-2.2 8.8L93 224h99c70.7 0 128 57.3 128 128s-57.3 128-128 128H90c-38.4 0-73.1-22.9-88.2-58.2L.6 419.2c-1.7-4.1 .1-8.8 4.2-10.5s8.8 .1 10.5 4.2l1.1 2.7C29.1 444.9 58 464 90 464H192c61.9 0 112-50.1 112-112s-50.1-112-112-112H72c-3.3 0-6.3-2.1-7.5-5.2s-.3-6.6 2.2-8.8L267 48H8c-4.4 0-8-3.6-8-8z"],
    "4": [384, 512, [], "34", "M159.2 43.4c1.9-4 .2-8.8-3.8-10.7s-8.8-.2-10.7 3.8L.8 340.6c-1.2 2.5-1 5.4 .5 7.7s4 3.7 6.8 3.7H304V472c0 4.4 3.6 8 8 8s8-3.6 8-8V352h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H320V136c0-4.4-3.6-8-8-8s-8 3.6-8 8V336H20.6L159.2 43.4z"],
    "5": [320, 512, [], "35", "M48.2 38.1c.9-3.6 4.1-6.1 7.8-6.1H280c4.4 0 8 3.6 8 8s-3.6 8-8 8H62.2l-44 176H192c70.7 0 128 57.3 128 128s-57.3 128-128 128H95.7c-37.3 0-71.8-20-90.3-52.4L1.1 420c-2.2-3.8-.9-8.7 3-10.9s8.7-.9 10.9 3l4.4 7.6C35 447.1 64.1 464 95.7 464H192c61.9 0 112-50.1 112-112s-50.1-112-112-112H8c-2.5 0-4.8-1.1-6.3-3.1S-.4 232.4 .2 230.1l48-192z"],
    "6": [320, 512, [], "36", "M16 320a144 144 0 1 1 288 0A144 144 0 1 1 16 320zm84.6-148.6L221.8 45.5c3.1-3.2 3-8.2-.2-11.3s-8.2-3-11.3 .2L46.6 204.4C16.7 235.4 0 276.9 0 320c0 88.4 71.6 160 160 160s160-71.6 160-160s-71.6-160-160-160c-21 0-41.1 4-59.4 11.4z"],
    "7": [320, 512, [], "37", "M0 40c0-4.4 3.6-8 8-8H312c2.9 0 5.6 1.6 7 4.1s1.3 5.7-.2 8.1l-272 432c-2.4 3.7-7.3 4.9-11 2.5s-4.9-7.3-2.5-11L297.5 48H8c-4.4 0-8-3.6-8-8z"],
    "8": [320, 512, [], "38", "M296 148c0-64.1-51.9-116-116-116H140C75.9 32 24 83.9 24 148c0 45.2 25.9 84.4 63.6 103.5C37.3 264.2 0 309.7 0 364c0 64.1 51.9 116 116 116h88c64.1 0 116-51.9 116-116c0-54.3-37.3-99.8-87.6-112.5C270.1 232.4 296 193.2 296 148zM180.1 264H204c55.2 0 100 44.8 100 100s-44.8 100-100 100H116C60.8 464 16 419.2 16 364s44.8-100 100-100h23.9c0 0 0 0 .1 0h40c0 0 0 0 .1 0zm0-16c0 0 0 0-.1 0H140c0 0 0 0-.1 0C84.7 248 40 203.2 40 148C40 92.8 84.8 48 140 48l40 0c55.2 0 100 44.8 100 100c0 55.2-44.7 100-99.9 100z"],
    "9": [320, 512, [], "39", "M304 192A144 144 0 1 1 16 192a144 144 0 1 1 288 0zM219.4 340.6L98.2 466.5c-3.1 3.2-3 8.2 .2 11.3s8.2 3 11.3-.2L273.4 307.6C303.3 276.6 320 235.1 320 192c0-88.4-71.6-160-160-160S0 103.6 0 192s71.6 160 160 160c21 0 41.1-4 59.4-11.4z"],
    "fill-drip": [576, 512, [], "f576", "M34.3 2.3c3.1-3.1 8.2-3.1 11.3 0L151 107.7l81.4-81.4c21.9-21.9 57.3-21.9 79.2 0L485.7 200.4c21.9 21.9 21.9 57.3 0 79.2L283.9 481.4c-37.5 37.5-98.3 37.5-135.8 0L30.6 363.9c-37.5-37.5-37.5-98.3 0-135.8L139.7 119 34.3 13.7c-3.1-3.1-3.1-8.2 0-11.3zm208 219.3L151 130.3 41.9 239.4C28.4 253 20.7 270.3 18.9 288H454.6l19.7-19.7c15.6-15.6 15.6-40.9 0-56.6L300.3 37.7c-15.6-15.6-40.9-15.6-56.6 0L162.3 119l91.3 91.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0zM18.9 304c1.8 17.7 9.4 35 23 48.6L159.4 470.1c31.2 31.2 81.9 31.2 113.1 0L438.6 304H18.9zM560 448c0-3.4-1.2-9.4-4.4-18c-3-8.3-7.4-17.7-12.5-27.6c-9.9-19.2-22-39.1-31.2-53.4c-9.1 14.3-21.3 34.1-31.2 53.4c-5.1 9.9-9.4 19.3-12.5 27.6c-3.2 8.6-4.4 14.6-4.4 18c0 26.5 21.5 48 48 48s48-21.5 48-48zm16 0c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-25.2 32.6-79.6 51.2-108.7c6-9.4 19.5-9.4 25.5 0C543.4 368.4 576 422.8 576 448z"],
    "arrows-to-circle": [640, 512, [], "e4bd", "M13.7 2.3C10.5-.8 5.5-.8 2.3 2.3s-3.1 8.2 0 11.3L164.7 176H72c-4.4 0-8 3.6-8 8s3.6 8 8 8H184c4.4 0 8-3.6 8-8V72c0-4.4-3.6-8-8-8s-8 3.6-8 8v92.7L13.7 2.3zm612.7 0L464 164.7V72c0-4.4-3.6-8-8-8s-8 3.6-8 8V184c0 4.4 3.6 8 8 8H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H475.3L637.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0zM320 176a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm136 96c4.4 0 8-3.6 8-8V347.3L626.3 509.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L475.3 336H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H456c-4.4 0-8 3.6-8 8V440c0 4.4 3.6 8 8 8zm-272 0c4.4 0 8-3.6 8-8V328c0-4.4-3.6-8-8-8H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h92.7L2.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L176 347.3V440c0 4.4 3.6 8 8 8z"],
    "circle-chevron-right": [512, 512, ["chevron-circle-right"], "f138", "M496 256A240 240 0 1 1 16 256a240 240 0 1 1 480 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM221.7 381.7l120-120c3.1-3.1 3.1-8.2 0-11.3l-120-120c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L324.7 256 210.3 370.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0z"],
    "wagon-covered": [640, 512, [], "f8ee", "M631.9 69.7C645 37 619.6 1.8 584.4 4L451.5 12.3c-23.1 1.4-43.1 13.7-55.2 31.6C388.2 22.9 367.8 8 344 8H296c-23.8 0-44.2 14.9-52.3 35.9C231.6 26 211.6 13.7 188.5 12.3L55.6 4C20.4 1.8-5 37 8.1 69.7L76.2 240H72c-4.4 0-8 3.6-8 8v40c0 4.4 3.6 8 8 8s8-3.6 8-8V256h2.6H88 248h8l128 0h8H552h5.4l2.6 0v32c0 4.4 3.6 8 8 8s8-3.6 8-8V248c0-4.4-3.6-8-8-8h-4.2L631.9 69.7zM546.6 240H400V84.1c0-29.6 23-54 52.5-55.9l132.9-8.3c23.5-1.5 40.4 22 31.7 43.8L546.6 240zM240 240H93.4L22.9 63.8c-8.7-21.8 8.3-45.3 31.7-43.8l132.9 8.3C217 30.1 240 54.6 240 84.1V240zm16 0V84.1 64c0-22.1 17.9-40 40-40h48c22.1 0 40 17.9 40 40V240H256zm-80 48c-61.9 0-112 50.1-112 112s50.1 112 112 112c56.4 0 103.1-41.7 110.9-96h66.3c7.8 54.3 54.4 96 110.9 96c61.9 0 112-50.1 112-112s-50.1-112-112-112s-112 50.1-112 112H288c0-61.9-50.1-112-112-112zM368 400.4V400h0c0-53 43-96 96-96s96 43 96 96s-43 96-96 96c-52.9 0-95.8-42.8-96-95.6zM80 400a96 96 0 1 1 192 0A96 96 0 1 1 80 400zm104-72c0-4.4-3.6-8-8-8s-8 3.6-8 8v64H104c-4.4 0-8 3.6-8 8s3.6 8 8 8h64v64c0 4.4 3.6 8 8 8s8-3.6 8-8V408h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H184V328zm280-8c-4.4 0-8 3.6-8 8v64H392c-4.4 0-8 3.6-8 8s3.6 8 8 8h64v64c0 4.4 3.6 8 8 8s8-3.6 8-8V408h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H472V328c0-4.4-3.6-8-8-8z"],
    "line-height": [576, 512, [], "f871", "M101.4 34.1c-3.1-2.8-7.7-2.8-10.8 0l-88 80c-3.3 3-3.5 8-.5 11.3s8 3.5 11.3 .5L88 58.1V453.9L13.4 386.1c-3.3-3-8.3-2.7-11.3 .5s-2.7 8.3 .5 11.3l88 80c3.1 2.8 7.7 2.8 10.8 0l88-80c3.3-3 3.5-8 .5-11.3s-8-3.5-11.3-.5L104 453.9V58.1l74.6 67.8c3.3 3 8.3 2.7 11.3-.5s2.7-8.3-.5-11.3l-88-80zM264 88c-4.4 0-8 3.6-8 8s3.6 8 8 8H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H264zm-8 160c-4.4 0-8 3.6-8 8s3.6 8 8 8H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H256zm0 168c0 4.4 3.6 8 8 8H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H264c-4.4 0-8 3.6-8 8z"],
    "bagel": [640, 512, [129391], "e3d7", "M432 400c106 0 192-86 192-192s-86-192-192-192c-56.1 0-106.6 24.1-141.7 62.5c-5.4-2-11-3.8-16.6-5.4C311.8 28.4 368.6 0 432 0C546.9 0 640 93.1 640 208s-93.1 208-208 208c-3.9 0-7.7-.1-11.5-.3c2.7-5.1 5.2-10.4 7.6-15.7c1.3 0 2.6 0 4 0zM325.9 92.7c4.4-12.5 16.1-20.9 29.3-21.3l22.8-.6c6.2-.2 12.1-2.1 17.2-5.6l18.8-12.9c10.9-7.5 25.3-7.5 36.2 0l18.8 12.9c5.1 3.5 11 5.4 17.2 5.6l22.8 .6c13.2 .4 24.8 8.8 29.3 21.3l7.6 21.4c2.1 5.8 5.8 10.9 10.6 14.6l18 13.9c10.5 8.1 14.9 21.7 11.2 34.4L579.1 199c-1.7 5.9-1.7 12.2 0 18.1l6.4 21.8c3.7 12.7-.7 26.3-11.2 34.4l-18 13.9c-4.9 3.8-8.6 8.8-10.6 14.6l-7.6 21.5c-4.4 12.5-16.1 20.9-29.3 21.3l-22.8 .6c-6.2 .2-12.1 2.1-17.2 5.6l-18.8 12.9c-3.3 2.3-7 3.9-10.8 4.8c1.8-6.5 3.4-13.2 4.6-19.9l15.9-10.9c7.6-5.2 16.6-8.1 25.8-8.4l22.8-.6c6.6-.2 12.4-4.4 14.6-10.6l7.6-21.4c3.1-8.7 8.6-16.3 15.9-22l18-13.9c5.2-4 7.5-10.9 5.6-17.2l-6.4-21.8c-2.6-8.9-2.6-18.3 0-27.1l6.4-21.8c1.9-6.3-.4-13.2-5.6-17.2l-18-13.9c-7.3-5.6-12.9-13.3-15.9-22L523 98.1c-2.2-6.2-8-10.4-14.6-10.6l-22.8-.6c-9.2-.3-18.2-3.2-25.8-8.4L441 65.6c-5.4-3.7-12.6-3.7-18.1 0L404.2 78.5c-7.6 5.2-16.6 8.1-25.8 8.4l-22.8 .6c-6.6 .2-12.4 4.4-14.6 10.6l-1.8 4.9c-4.6-3-9.2-5.8-14-8.5l.6-1.8zM496 208c0 30.6-21.5 56.3-50.3 62.5c-.7-5.3-1.7-10.6-2.7-15.8c21.2-5 37.1-24 37.1-46.7c0-26.5-21.5-48-48-48c-9.7 0-18.8 2.9-26.3 7.9c-3-4.4-6.2-8.7-9.5-12.9c10.2-6.9 22.6-11 35.9-11c35.3 0 64 28.7 64 64zm-96 96A192 192 0 1 0 16 304a192 192 0 1 0 384 0zM0 304a208 208 0 1 1 416 0A208 208 0 1 1 0 304zm208-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm48 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM128 192a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm192 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM112 384a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm128 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48-16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM80 256a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "transporter-7": [512, 512, [], "e2a8", "M472 40c0-4.4-3.6-8-8-8s-8 3.6-8 8V72H424c-4.4 0-8 3.6-8 8s3.6 8 8 8h32v32c0 4.4 3.6 8 8 8s8-3.6 8-8V88h32c4.4 0 8-3.6 8-8s-3.6-8-8-8H472V40zM56 264c0-4.4-3.6-8-8-8s-8 3.6-8 8v32H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H40v32c0 4.4 3.6 8 8 8s8-3.6 8-8V312H88c4.4 0 8-3.6 8-8s-3.6-8-8-8H56V264zm56 232c0-17.7 14.3-32 32-32H368c17.7 0 32 14.3 32 32v8c0 4.4 3.6 8 8 8s8-3.6 8-8v-8c0-26.5-21.5-48-48-48H144c-26.5 0-48 21.5-48 48v8c0 4.4 3.6 8 8 8s8-3.6 8-8v-8z"],
    "at": [512, 512, [61946], "40", "M256 16C123.5 16 16 123.5 16 256s107.5 240 240 240c4.4 0 8 3.6 8 8s-3.6 8-8 8C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256l0 20c0 46.4-37.6 84-84 84c-36.8 0-68.1-23.6-79.4-56.6C331.3 337 296.4 360 256 360c-57.4 0-104-46.6-104-104s46.6-104 104-104c37.1 0 69.6 19.4 88 48.5V168c0-4.4 3.6-8 8-8s8 3.6 8 8v88 20c0 37.6 30.4 68 68 68s68-30.4 68-68l0-20C496 123.5 388.5 16 256 16zm88 240a88 88 0 1 0 -176 0 88 88 0 1 0 176 0z"],
    "rectangles-mixed": [576, 512, [], "e323", "M272 48c17.7 0 32 14.3 32 32V208c0 17.7-14.3 32-32 32H48c-17.7 0-32-14.3-32-32V80c0-17.7 14.3-32 32-32H272zM48 32C21.5 32 0 53.5 0 80V208c0 26.5 21.5 48 48 48H272c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H48zM528 48c17.7 0 32 14.3 32 32V336c0 17.7-14.3 32-32 32H432c-17.7 0-32-14.3-32-32V80c0-17.7 14.3-32 32-32h96zM432 32c-26.5 0-48 21.5-48 48V336c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H432zM112 320H288c17.7 0 32 14.3 32 32v80c0 17.7-14.3 32-32 32H112c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32zM64 352v80c0 26.5 21.5 48 48 48H288c26.5 0 48-21.5 48-48V352c0-26.5-21.5-48-48-48H112c-26.5 0-48 21.5-48 48z"],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", "M290.3 210.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L496 27.3V152c0 4.4 3.6 8 8 8s8-3.6 8-8V8c0-4.4-3.6-8-8-8H360c-4.4 0-8 3.6-8 8s3.6 8 8 8H484.7L290.3 210.3zm7.5 172.1c6.6 3.1 14.6 1.3 19.2-4.3l40.4-49.3c6.7-8.2 18-11 27.8-7l96 40c11.1 4.6 17.1 16.8 13.9 28.5l-24 88C468.3 488.8 458.8 496 448 496C209.4 496 16 302.6 16 64c0-10.8 7.2-20.3 17.7-23.2l88-24c11.6-3.2 23.8 2.8 28.5 13.9l40 96c4.1 9.8 1.3 21.1-7 27.8l-49.3 40.4c-5.7 4.7-7.5 12.6-4.3 19.2c34.8 73.8 94.5 133.5 168.3 168.3zM345 318.7L304.7 368C234.2 334.7 177.2 277.7 144 207.3L193.3 167c13.7-11.2 18.4-30 11.6-46.3l-40-96c-7.7-18.6-28-28.5-47.4-23.2l-88 24C12.1 30.2 0 46 0 64C0 311.4 200.6 512 448 512c18 0 33.8-12.1 38.6-29.5l24-88c5.3-19.4-4.6-39.7-23.2-47.4l-96-40c-16.3-6.8-35.2-2.1-46.3 11.6z"],
    "trash-can": [448, 512, [61460, "trash-alt"], "f2ed", "M157.4 27.3L134.4 64H313.6l-23-36.7c-4.4-7-12.1-11.3-20.4-11.3H177.7c-8.3 0-16 4.3-20.4 11.3zM115.6 64l28.2-45.2C151.1 7.1 163.9 0 177.7 0h92.5c13.8 0 26.6 7.1 33.9 18.8L332.4 64H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H115.6zM40 112c4.4 0 8 3.6 8 8V440c0 30.9 25.1 56 56 56H344c30.9 0 56-25.1 56-56V120c0-4.4 3.6-8 8-8s8 3.6 8 8V440c0 39.8-32.2 72-72 72H104c-39.8 0-72-32.2-72-72V120c0-4.4 3.6-8 8-8zm96 48V416c0 4.4-3.6 8-8 8s-8-3.6-8-8V160c0-4.4 3.6-8 8-8s8 3.6 8 8zm96 0V416c0 4.4-3.6 8-8 8s-8-3.6-8-8V160c0-4.4 3.6-8 8-8s8 3.6 8 8zm96 0V416c0 4.4-3.6 8-8 8s-8-3.6-8-8V160c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "circle-l": [512, 512, [], "e114", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176 136c0-4.4-3.6-8-8-8s-8 3.6-8 8V360c0 13.3 10.7 24 24 24H344c4.4 0 8-3.6 8-8s-3.6-8-8-8H184c-4.4 0-8-3.6-8-8V136z"],
    "head-side-goggles": [512, 512, ["head-vr"], "f6ea", "M16 224H0c.2 52.4 17.1 100.7 47.4 138.8C57.5 375.5 64 390.2 64 405.3V504c0 4.4 3.6 8 8 8s8-3.6 8-8V405.3c0-19.8-8.5-37.8-20.1-52.4C32 317.7 16.2 273 16 224zM39.1 96.8C16.8 101 0 120.5 0 144c0 26.5 21.5 48 48 48H222.2c15.7 24.1 42.9 40 73.8 40H408h64c22.1 0 40-17.9 40-40V96c0-22.1-17.9-40-40-40H408 378.4C342 21.4 292.3 0 239.7 0H222.9C146.6 0 79.2 38.3 39.1 96.8zM59.5 96c37.9-48.7 97-80 163.5-80h16.8C282 16 322.2 31 354 56H296c-30.9 0-58.1 15.9-73.8 40H59.5zM490.1 256c3.8 5.8 5.9 12.7 5.9 19.8c0 20-16.2 36.2-36.2 36.2H440c-4.4 0-8 3.6-8 8v72c0 22.1-17.9 40-40 40H312c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8s8-3.6 8-8V448h72c30.9 0 56-25.1 56-56V328h11.8c28.8 0 52.2-23.4 52.2-52.2c0-6.9-1.4-13.6-3.9-19.8h-18zM296 72H400V216H296c-39.8 0-72-32.2-72-72s32.2-72 72-72zM416 216V72h56c13.3 0 24 10.7 24 24v96c0 13.3-10.7 24-24 24H416zM208 144c0 11.3 2.1 22.1 6 32H48c-17.7 0-32-14.3-32-32s14.3-32 32-32H214c-3.9 9.9-6 20.7-6 32z"],
    "text-height": [576, 512, [], "f034", "M485.7 34.3c-3.1-3.1-8.2-3.1-11.3 0l-80 80c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L472 59.3l0 393.4-66.3-66.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l80 80c3.1 3.1 8.2 3.1 11.3 0l80-80c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L488 452.7l0-393.4 66.3 66.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-80-80zM16 56c0-4.4 3.6-8 8-8H152l0 416H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h88 88c4.4 0 8-3.6 8-8s-3.6-8-8-8H168l0-416H296c4.4 0 8 3.6 8 8v48c0 4.4 3.6 8 8 8s8-3.6 8-8V56c0-13.3-10.7-24-24-24H160 24C10.7 32 0 42.7 0 56v48c0 4.4 3.6 8 8 8s8-3.6 8-8V56z"],
    "user-xmark": [640, 512, ["user-times"], "f235", "M112 128a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM16 482.3C16 392.7 88.7 320 178.3 320h91.4C359.3 320 432 392.7 432 482.3c0 7.6-6.1 13.7-13.7 13.7H29.7c-7.6 0-13.7-6.1-13.7-13.7zM224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3zM450.3 130.3c-3.1 3.1-3.1 8.2 0 11.3L516.7 208l-66.3 66.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L528 219.3l66.3 66.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L539.3 208l66.3-66.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L528 196.7l-66.3-66.3c-3.1-3.1-8.2-3.1-11.3 0z"],
    "face-hand-yawn": [512, 512, [], "e379", "M256 16C123.5 16 16 123.5 16 256c0 80.6 39.7 151.9 100.7 195.4c3.6 2.6 4.4 7.6 1.9 11.2s-7.6 4.4-11.2 1.9C42.4 418 0 342 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 106.3-64.7 197.4-156.9 236.1c-4.1 1.7-8.8-.2-10.5-4.3s.2-8.8 4.3-10.5C435.3 441 496 355.6 496 256C496 123.5 388.5 16 256 16zm6.1 323.3l-4.7 4.7c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l4.7-4.7 46.6-46.6c2.3-2.3 3.8-5.2 4.4-8.3c1-5-.5-10.4-4.4-14.3c-6.2-6.2-16.4-6.2-22.6 0l-79 79c-5 5-13.7 1.5-13.7-5.7V314.4c0-11-9-20-20-20s-20 9-20 20V368v32.8c0 52.6 42.6 95.2 95.2 95.2c25.2 0 49.5-10 67.3-27.9l56.8-56.8c6.2-6.2 6.2-16.4 0-22.6c-3.9-3.9-9.3-5.4-14.3-4.4c-3 .6-5.9 2-8.3 4.4l-14.6 14.6-4.7 4.7c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l4.7-4.7 14.6-14.6 9.2-9.2 22.8-22.8c6.2-6.2 6.2-16.4 0-22.6c-3.9-3.9-9.3-5.4-14.3-4.4c-3 .6-5.9 2-8.3 4.4l-46.6 46.6-4.7 4.7c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l4.7-4.7 46.6-46.6 9.2-9.2 6.8-6.8c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-6.8 6.8-9.2 9.2-46.6 46.6zm56.1-77.9c12.4-8.3 29.4-7 40.4 4s12.3 28 4 40.4c4.4 1.5 8.5 4.1 12 7.6c12.5 12.5 12.5 32.8 0 45.3L363.2 370c4.2 1.6 8.1 4 11.4 7.3c12.5 12.5 12.5 32.8 0 45.3l-56.8 56.8C297 500.3 268.7 512 239.2 512C177.8 512 128 462.2 128 400.8V368 314.4c0-19.9 16.1-36 36-36s36 16.1 36 36v.3l65.4-65.4c12.5-12.5 32.8-12.5 45.3 0c3.5 3.5 6 7.6 7.6 12zm-143.3 .5c-1.7 4.1-6.4 6-10.5 4.3s-6-6.4-4.3-10.5C175.9 218.3 212.8 192 256 192c30.8 0 58.5 13.4 77.5 34.7c2.9 3.3 2.7 8.3-.6 11.3s-8.3 2.7-11.3-.6c-16.1-18-39.5-29.3-65.6-29.3c-36.5 0-67.8 22.2-81.1 53.9zM206.2 107c2.8 3.4 2.2 8.5-1.2 11.2l-80 64c-3.4 2.8-8.5 2.2-11.2-1.2s-2.2-8.5 1.2-11.2l80-64c3.4-2.8 8.5-2.2 11.2 1.2zM307 118.2c-3.5-2.8-4-7.8-1.2-11.2s7.8-4 11.2-1.2l80 64c3.4 2.8 4 7.8 1.2 11.2s-7.8 4-11.2 1.2l-80-64z"],
    "gauge-simple-min": [512, 512, ["tachometer-slowest"], "f62d", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112c35.3 0 64-28.7 64-64s-28.7-64-64-64c-18.8 0-35.7 8.1-47.4 21l-108-75.6c-3.6-2.5-8.6-1.7-11.1 2s-1.7 8.6 2 11.1l108 75.6c-4.7 8.9-7.4 19.1-7.4 29.9c0 35.3 28.7 64 64 64z"],
    "stethoscope": [576, 512, [129658], "f0f1", "M127.5 5.2c1.6 4.1-.5 8.7-4.7 10.3L79.6 31.7C70.2 35.2 64 44.2 64 54.2V192c0 70.7 57.3 128 128 128s128-57.3 128-128V54.2c0-10-6.2-19-15.6-22.5L261.2 15.5c-4.1-1.6-6.2-6.2-4.7-10.3s6.2-6.2 10.3-4.7L310 16.7c15.6 5.9 26 20.8 26 37.5V192c0 76.8-60.2 139.6-136 143.8c0 .1 0 .1 0 .2v24c0 75.1 60.9 136 136 136s136-60.9 136-136V255.5c-31.6-3.9-56-30.9-56-63.5c0-35.3 28.7-64 64-64s64 28.7 64 64c0 32.6-24.4 59.6-56 63.5V360c0 83.9-68.1 152-152 152s-152-68.1-152-152V336c0-.1 0-.1 0-.2C108.2 331.6 48 268.8 48 192V54.2c0-16.7 10.3-31.6 26-37.5L117.2 .5c4.1-1.6 8.7 .5 10.3 4.7zM480 144a48 48 0 1 0 0 96 48 48 0 1 0 0-96z"],
    "coffin": [384, 512, [9904], "f6c6", "M114.5 21.5c3-3.5 7.4-5.5 12-5.5h131c4.6 0 9 2 12 5.5l91 104c4.8 5.5 7.5 12.7 7.5 20c0 2.9-.4 5.7-1.2 8.4L271.3 484.4c-2 6.8-8.2 11.6-15.4 11.6H128.1c-7.1 0-13.4-4.7-15.4-11.6L17.2 153.9c-.8-2.7-1.2-5.6-1.2-8.4c0-7.4 2.7-14.5 7.5-20l91-104zm-12-10.5l-91 104C4.1 123.3 0 134.2 0 145.4c0 4.4 .6 8.7 1.8 12.9L97.3 488.9c4 13.7 16.5 23.1 30.7 23.1H255.9c14.3 0 26.8-9.4 30.7-23.1l95.5-330.6c1.2-4.2 1.8-8.5 1.8-12.9c0-11.2-4.1-22.1-11.5-30.6l-91-104C275.5 4 266.7 0 257.5 0h-131c-9.2 0-18 4-24.1 10.9z"],
    "message": [512, 512, ["comment-alt"], "f27a", "M160 400c8.8 0 16 7.2 16 16v80l123.7-92.8c2.8-2.1 6.1-3.2 9.6-3.2H448c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H64C37.5 16 16 37.5 16 64V352c0 26.5 21.5 48 48 48h96zM0 64C0 28.7 28.7 0 64 0H448c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H309.3L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V432 416H144 64c-35.3 0-64-28.7-64-64V64z"],
    "salad": [512, 512, [129367, "bowl-salad"], "f81e", "M240 16c-41.6 0-77.6 24.5-94.2 59.9c-1.4 3-4.6 4.9-7.9 4.6c-3.2-.3-6.5-.4-9.9-.4C66.1 80 16 130.1 16 192c0 23.8 7.4 45.9 20.1 64h-19C6.2 237.2 0 215.3 0 192C0 121.3 57.3 64 128 64c1.9 0 3.9 0 5.8 .1C153.9 26 193.9 0 240 0c46.7 0 87.2 26.7 107 65.7c6.8-1.1 13.8-1.7 21-1.7c41.2 0 77.9 19.5 101.3 49.7c-11.9-6.5-24.8-11.4-38.4-14.4C413 87.1 391.3 80 368 80c-8.2 0-16.2 .9-23.8 2.5c-3.7 .8-7.5-1.1-9-4.6C319 41.4 282.5 16 240 16zM400 144c-53 0-96 43-96 96c0 5.5 .5 10.8 1.3 16H289.1c-.7-5.2-1.1-10.6-1.1-16c0-61.9 50.1-112 112-112s112 50.1 112 112c0 5.4-.4 10.8-1.1 16H494.7c.9-5.2 1.3-10.5 1.3-16c0-53-43-96-96-96zM112 464.7c.4 17.3 14.6 31.3 32 31.3H368c17.4 0 31.6-13.9 32-31.3c.1-6.1 3.8-11.6 9.3-14.2c51.2-23.5 86.7-75.2 86.7-135.1c0-6.3-5.1-11.4-11.4-11.4H27.4c-6.3 0-11.4 5.1-11.4 11.4c0 59.9 35.5 111.6 86.7 135.1c5.6 2.6 9.2 8.1 9.3 14.2zM27.4 288H484.6c15.1 0 27.4 12.3 27.4 27.4c0 66.4-39.4 123.7-96 149.7c-.6 26-21.8 46.9-48 46.9H144c-26.1 0-47.4-20.9-48-46.9c-56.7-26-96-83.2-96-149.7C0 300.3 12.3 288 27.4 288zM248 104V248c0 4.4-3.6 8-8 8s-8-3.6-8-8V104c0-4.4 3.6-8 8-8s8 3.6 8 8zM93.7 146.3l96 96c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-96-96c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0z"],
    "info": [192, 512, [], "f129", "M80 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-64a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM32 184c0-4.4 3.6-8 8-8H96c4.4 0 8 3.6 8 8V464h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H88V192H40c-4.4 0-8-3.6-8-8z"],
    "robot-astromech": [512, 512, [], "e2d2", "M256 0C176.5 0 112 64.5 112 144v32H88c-30.9 0-56 25.1-56 56V422.1L2.2 481.7C.8 484.6 0 487.8 0 491.1C0 502.6 9.4 512 20.9 512H104c13.3 0 24-10.7 24-24V389l50 56.3c1.5 1.7 3.7 2.7 6 2.7H328c2.3 0 4.5-1 6-2.7L384 389v99c0 13.3 10.7 24 24 24h83.1c11.6 0 20.9-9.4 20.9-20.9c0-3.3-.8-6.5-2.2-9.4L480 422.1V232c0-30.9-25.1-56-56-56H400V144C400 64.5 335.5 0 256 0zM400 192h24c22.1 0 40 17.9 40 40V424c0 1.2 .3 2.5 .8 3.6l30.6 61.3c.3 .7 .5 1.4 .5 2.2c0 2.7-2.2 4.9-4.9 4.9H408c-4.4 0-8-3.6-8-8V368 192zm-16 0V365l-59.6 67H187.6L128 365V192H384zm-272 0V368 488c0 4.4-3.6 8-8 8H20.9c-2.7 0-4.9-2.2-4.9-4.9c0-.8 .2-1.5 .5-2.2l30.6-61.3c.6-1.1 .8-2.3 .8-3.6V232c0-22.1 17.9-40 40-40h24zm16-48c0-70.7 57.3-128 128-128s128 57.3 128 128v32H128V144zm72-48a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm40 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM192 248c0 4.4 3.6 8 8 8H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H200c-4.4 0-8 3.6-8 8zm0 64c0 4.4 3.6 8 8 8H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H200c-4.4 0-8 3.6-8 8z"],
    "ring-diamond": [384, 512, [], "e5ab", "M132.7 10.1C137.2 3.7 144.5 0 152.2 0h79.5c7.8 0 15 3.7 19.5 10.1l32 44.8c3.9 5.4 4 12.6 .3 18.2l-41.1 61.7C324 156.9 384 231.4 384 320c0 106-86 192-192 192S0 426 0 320c0-88.6 60-163.1 141.5-185.3L100.4 73c-3.7-5.5-3.6-12.8 .3-18.2l32-44.8zM265.1 72H118.9l39.3 59c11-1.9 22.2-3 33.7-3s22.8 1 33.7 3l39.3-59zm-.6-16L238.3 19.4c-1.5-2.1-3.9-3.4-6.5-3.4H152.2c-2.6 0-5 1.2-6.5 3.4L119.5 56H264.5zM192 496a176 176 0 1 0 0-352 176 176 0 1 0 0 352z"],
    "fondue-pot": [512, 512, [129749], "e40d", "M292.2 16.6c-8.5-2.3-17.3 2.7-19.6 11.2l-24 88c-2.3 8.5 2.7 17.3 11.2 19.6s17.3-2.7 19.6-11.2l24-88c2.3-8.5-2.7-17.3-11.2-19.6zm164.4 1.9c-7.5-4.7-17.3-2.5-22.1 4.9l-56 88c-4.7 7.5-2.5 17.3 4.9 22.1s17.3 2.5 22.1-4.9l56-88c4.7-7.5 2.5-17.3-4.9-22.1zM318.9 40.4l-24 88c-4.1 15-18.2 24.6-33.1 23.5L248.4 192H231.6l15-45.1c-11.4-7.4-17.2-21.5-13.5-35.3l24-88c4.7-17.1 22.2-27.1 39.3-22.5s27.1 22.2 22.5 39.3zm62.6 109.8L353.6 192H334.4l33.8-50.7c-9.3-10.4-11-26.1-3.1-38.5l56-88C430.5-.1 450.3-4.5 465.2 5s19.3 29.3 9.8 44.2l-56 88c-8.1 12.8-23.8 17.8-37.5 13zM32 240c-8.8 0-16 7.2-16 16v64c0 79.5 64.5 144 144 144H288c79.5 0 144-64.5 144-144V240H168v48c0 13.3-10.7 24-24 24s-24-10.7-24-24V277.5c0-3.1-2.5-5.5-5.5-5.5h-4.3c-3.4 0-6.2 2.8-6.2 6.2V320c0 13.3-10.7 24-24 24s-24-10.7-24-24V240H32zm0-16H56 72h80 16H432h16 56c4.4 0 8 3.6 8 8s-3.6 8-8 8H448v80c0 52.3-25.1 98.8-64 128v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V458.6c-23.5 13.6-50.9 21.4-80 21.4H160c-29.1 0-56.5-7.8-80-21.4V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V448C25.1 418.8 0 372.3 0 320V256c0-17.7 14.3-32 32-32zm40 32v22.2V320c0 4.4 3.6 8 8 8s8-3.6 8-8V278.1c0-12.2 9.9-22.2 22.2-22.2h4.3c11.9 0 21.5 9.6 21.5 21.5V288c0 4.4 3.6 8 8 8s8-3.6 8-8V277.5 256 240H136 114.5h-4.3H88 72v16z"],
    "theta": [384, 512, [], "f69e", "M40 256c0-62.7 17.5-119 45.4-159.5C113.4 56 151.2 32 192 32s78.6 24 106.6 64.5C326.5 137 344 193.3 344 256s-17.5 119-45.4 159.5C270.6 456 232.8 480 192 480s-78.6-24-106.6-64.5C57.5 375 40 318.7 40 256zM192 16c-47.6 0-89.8 28-119.7 71.4C42.3 130.9 24 190.5 24 256s18.3 125.1 48.3 168.6C102.2 468 144.4 496 192 496s89.8-28 119.7-71.4C341.7 381.1 360 321.5 360 256s-18.3-125.1-48.3-168.6C281.8 44 239.6 16 192 16zM96 248c-4.4 0-8 3.6-8 8s3.6 8 8 8H288c4.4 0 8-3.6 8-8s-3.6-8-8-8H96z"],
    "face-hand-peeking": [640, 512, [129763], "e481", "M320 16c-57.7 0-110.5 20.3-151.9 54.2c-3.4 2.8-8.5 2.3-11.3-1.1s-2.3-8.5 1.1-11.3C202.1 21.7 258.5 0 320 0c79.9 0 151.3 36.6 198.2 93.9c2.8 3.4 2.3 8.5-1.1 11.3s-8.5 2.3-11.3-1.1C461.8 50.3 394.9 16 320 16zM92.6 355.3c4-1.9 8.8-.2 10.7 3.8C141.8 440.1 224.4 496 320 496c74.9 0 141.8-34.3 185.8-88.1c2.8-3.4 7.8-3.9 11.3-1.1s3.9 7.8 1.1 11.3C471.3 475.4 399.9 512 320 512c-102 0-190.1-59.7-231.2-146c-1.9-4-.2-8.8 3.8-10.7zm-52-200.3L101.7 94c14.1-14.1 36.9-14.1 50.9 0s14.1 36.9 0 50.9L137.5 160H232c17.7 0 32 14.3 32 32c0 3.9-.7 7.7-2 11.2c10.7 5.2 18 16.1 18 28.8s-7.4 23.6-18 28.8c1.3 3.5 2 7.3 2 11.2c0 17.7-14.3 32-32 32H214.7c.8 2.8 1.3 5.8 1.3 8.9c0 17.7-14.3 32-32 32H119.2c-29.5 0-57.8-11.7-78.6-32.6C-2.5 269.2-2.9 199.5 39.6 156l.1-.1 0 0 .8-.8 0 0zM197.3 304c-2.9-4.3-7.8-7.1-13.3-7.1h-3.3H170c-2.5 0-4.5-2-4.5-4.5s2-4.5 4.5-4.5h10.7H184h20.1H232c8.8 0 16-7.2 16-16c0-2.9-.8-5.6-2.1-8c-2.8-4.8-7.9-8-13.9-8H180.9 169.6c-2.2 0-4-1.8-4-4s1.8-4 4-4h11.3l51.1 0h16c1.5 0 3-.2 4.4-.6c6.7-1.9 11.6-8.1 11.6-15.4s-4.9-13.5-11.6-15.4c-1.4-.4-2.9-.6-4.4-.6H232 180.9 169.6c-2.2 0-4-1.8-4-4s1.8-4 4-4h11.3l51.1 0c5.9 0 11.1-3.2 13.9-8c1.4-2.4 2.1-5.1 2.1-8c0-8.8-7.2-16-16-16H118.2c-7.1 0-10.7-8.6-5.7-13.7l28.8-28.8c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0L51.9 166.4l-.8 .8C14.7 204.4 15 264.1 51.9 301c17.9 17.9 42.1 27.9 67.3 27.9H184c8.8 0 16-7.2 16-16c0-3.3-1-6.4-2.7-8.9zM599.4 195.1l0 0 .8 .8 .1 .1 0 0c42.5 43.5 42.2 113.2-.9 156.3c-20.9 20.9-49.1 32.6-78.6 32.6H456c-17.7 0-32-14.3-32-32c0-3.1 .4-6.1 1.3-8.9H408c-17.7 0-32-14.3-32-32c0-3.9 .7-7.7 2-11.2c-10.7-5.2-18-16.1-18-28.8c0-17.7 14.3-32 32-32l66.5 0-53.1-38c-14.4-10.3-17.7-30.3-7.4-44.6s30.3-17.7 44.6-7.4l52.3 37.3c-4.4-12.6-1.6-27.2 8.5-37.3c14.1-14.1 36.9-14.1 50.9 0l45.1 45.1zM387.6 287.4c1.4 .4 2.9 .6 4.4 .6h16 56.7H476c2.2 0 4 1.8 4 4s-1.8 4-4 4H464.7 408c-5.9 0-11.1 3.2-13.9 8c-1.4 2.4-2.1 5.1-2.1 8c0 8.8 7.2 16 16 16h27.9l20.1 0h8.9 10.7c2.5 0 4.5 2 4.5 4.5s-2 4.5-4.5 4.5H464.9 456c-5.5 0-10.4 2.8-13.3 7.1c-1.7 2.5-2.7 5.6-2.7 8.9c0 8.8 7.2 16 16 16h64.8c25.2 0 49.5-10 67.3-27.9c36.9-36.9 37.2-96.6 .8-133.8l-.8-.8L543 161.3c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3l14.8 14.8c6.6 6.6 2.7 18-6.6 19c-2.8 .3-5.6-.4-7.8-2L433.3 163c-7.2-5.1-17.2-3.5-22.3 3.7s-3.5 17.2 3.7 22.3l59.7 42.6c3.5 2.5 5.6 6.6 5.6 10.9c0 7.4-6 13.4-13.4 13.4H392c-8.8 0-16 7.2-16 16c0 7.3 4.9 13.5 11.6 15.4zM264 400c0 7.3 4.8 15.1 15 21.5c10.1 6.3 24.6 10.5 41 10.5s30.9-4.2 41-10.5c10.2-6.4 15-14.2 15-21.5s-4.8-15.1-15-21.5c-10.1-6.3-24.6-10.5-41-10.5s-30.9 4.2-41 10.5c-10.2 6.4-15 14.2-15 21.5zm56-48c18.9 0 36.5 4.8 49.5 12.9C382.4 373 392 385.2 392 400s-9.6 27-22.5 35.1c-13 8.2-30.6 12.9-49.5 12.9s-36.5-4.8-49.5-12.9C257.6 427 248 414.8 248 400s9.6-27 22.5-35.1c13-8.2 30.6-12.9 49.5-12.9zm38.9-187.4c2.2 3.8 .9 8.7-2.9 10.9c-16.8 9.7-28 27.8-28 48.5c0 7.4 1.4 14.5 4 21c1.7 4.1-.3 8.8-4.4 10.4s-8.8-.3-10.4-4.4c-3.4-8.3-5.2-17.4-5.2-26.9c0-26.7 14.5-49.9 36-62.4c3.8-2.2 8.7-.9 10.9 2.9zM384 208a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "square-user": [448, 512, [], "e283", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48V448c0-70.7-57.3-128-128-128H192c-70.7 0-128 57.3-128 128l0 16c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM368 464H80V448c0-61.9 50.1-112 112-112h64c61.9 0 112 50.1 112 112v16zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM304 208a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-80-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "down-left-and-up-right-to-center": [512, 512, ["compress-alt"], "f422", "M470.6 11.3c-12.5-12.5-32.8-12.5-45.3 0L352 84.7 326.6 59.3c-12.5-12.5-32.8-12.5-45.3 0c-6 6-9.4 14.1-9.4 22.6V208c0 17.7 14.3 32 32 32H430.1c8.5 0 16.6-3.4 22.6-9.4c12.5-12.5 12.5-32.8 0-45.3L427.3 160l73.4-73.4c12.5-12.5 12.5-32.8 0-45.3L470.6 11.3zM436.7 22.6c6.2-6.2 16.4-6.2 22.6 0l30.1 30.1c6.2 6.2 6.2 16.4 0 22.6l-79 79c-3.1 3.1-3.1 8.2 0 11.3l31 31c6.2 6.2 6.2 16.4 0 22.6c-3 3-7.1 4.7-11.3 4.7H304c-8.8 0-16-7.2-16-16V82c0-4.2 1.7-8.3 4.7-11.3c6.2-6.2 16.4-6.2 22.6 0l31 31c3.1 3.1 8.2 3.1 11.3 0l79-79zM41.4 500.7c12.5 12.5 32.8 12.5 45.3 0L160 427.3l25.4 25.4c12.5 12.5 32.8 12.5 45.3 0c6-6 9.4-14.1 9.4-22.6V304c0-17.7-14.3-32-32-32H81.9c-8.5 0-16.6 3.4-22.6 9.4c-12.5 12.5-12.5 32.8 0 45.3L84.7 352 11.3 425.4c-12.5 12.5-12.5 32.8 0 45.3l30.1 30.1zm33.9-11.3c-6.2 6.2-16.4 6.2-22.6 0L22.6 459.3c-6.2-6.2-6.2-16.4 0-22.6l79-79c3.1-3.1 3.1-8.2 0-11.3l-31-31c-6.2-6.2-6.2-16.4 0-22.6c3-3 7.1-4.7 11.3-4.7H208c8.8 0 16 7.2 16 16V430.1c0 4.2-1.7 8.3-4.7 11.3c-6.2 6.2-16.4 6.2-22.6 0l-31-31c-3.1-3.1-8.2-3.1-11.3 0l-79 79z"],
    "explosion": [576, 512, [], "e4e9", "M543.7 10.1c1-3.8-.9-7.9-4.6-9.4s-7.9-.2-10 3.2L339.3 315.3 295.8 134.1c-.9-3.6-4.1-6.1-7.8-6.1s-6.9 2.5-7.8 6.1L235.6 320.2 109.7 194.3c-2.6-2.6-6.6-3.1-9.7-1.2s-4.6 5.6-3.6 9.1L141 358.5 33.1 344.1c-3.3-.4-6.6 1.2-8.1 4.2s-1.1 6.6 1.2 9.1l80 88L123 464h21.6l-26.7-29.4L52.7 362.8l98.3 13.1c2.7 .4 5.3-.7 7.1-2.7s2.4-4.8 1.6-7.4L120.2 227.5 234.3 341.7c2 2 5 2.8 7.8 2s4.9-3 5.6-5.8L288 170.3l40.2 167.6c.8 3.1 3.3 5.5 6.5 6s6.4-1 8.1-3.7L514 59.4 432.3 365.9c-.7 2.6 0 5.4 1.8 7.4s4.5 3 7.2 2.6l81.7-12.6-64.8 71.3L431.4 464H453l16.9-18.6 80-88c2.3-2.5 2.7-6.2 1.1-9.2s-4.9-4.6-8.3-4.1l-91.9 14.1L543.7 10.1zM296 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V88c0 4.4 3.6 8 8 8s8-3.6 8-8V8zM8 496c-4.4 0-8 3.6-8 8s3.6 8 8 8H199.9c0 0 0 0 .1 0s0 0 .1 0H375.9c0 0 0 0 .1 0s0 0 .1 0H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H383.7c-4.1-49.3-45.3-88-95.7-88s-91.6 38.7-95.7 88H8zm200.4 0c4-40.4 38.1-72 79.6-72s75.6 31.6 79.6 72H208.4z"],
    "file-lines": [384, 512, [128441, 128462, 61686, "file-alt", "file-text"], "f15c", "M64 496c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48H64zM358.6 157.3c.9 .9 1.7 1.8 2.4 2.7H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64zm40 256c-4.4 0-8 3.6-8 8s3.6 8 8 8H280c4.4 0 8-3.6 8-8s-3.6-8-8-8H104zm0 64c-4.4 0-8 3.6-8 8s3.6 8 8 8H280c4.4 0 8-3.6 8-8s-3.6-8-8-8H104zm0 64c-4.4 0-8 3.6-8 8s3.6 8 8 8H280c4.4 0 8-3.6 8-8s-3.6-8-8-8H104z"],
    "wave-square": [640, 512, [], "f83e", "M184 48c-13.3 0-24 10.7-24 24V224c0 22.1-17.9 40-40 40H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H120c13.3 0 24-10.7 24-24V72c0-22.1 17.9-40 40-40H288c22.1 0 40 17.9 40 40V440c0 13.3 10.7 24 24 24H456c13.3 0 24-10.7 24-24V288c0-22.1 17.9-40 40-40H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H520c-13.3 0-24 10.7-24 24V440c0 22.1-17.9 40-40 40H352c-22.1 0-40-17.9-40-40V72c0-13.3-10.7-24-24-24H184z"],
    "ring": [512, 512, [], "f70b", "M84.1 114.3C127.7 93.3 188.5 80 256 80s128.3 13.3 171.9 34.3C472 135.7 496 163.7 496 192c0 18.7-10.5 37.3-30.4 53.9c-9.2-6.6-19.6-12.6-30.8-18C388.7 205.6 325.4 192 256 192s-132.7 13.6-178.8 35.9c-11.2 5.4-21.5 11.4-30.8 18C26.5 229.3 16 210.7 16 192c0-28.3 24-56.3 68.1-77.7zM511.5 184c-4.1-34.4-34.3-63.5-76.7-84.1C388.7 77.6 325.4 64 256 64S123.3 77.6 77.2 99.9C34.8 120.5 4.6 149.6 .5 184H0v8V320.5c0 37.8 31.6 69.7 77.2 91.7C123.3 434.5 186.6 448 256 448s132.7-13.5 178.8-35.8c45.6-22 77.2-53.9 77.2-91.7V192v-8h-.5zM496 237.2v83.3c0 28.2-24 56-68.1 77.3C384.3 418.8 323.6 432 256 432s-128.3-13.2-171.9-34.2C40 376.5 16 348.7 16 320.5V237.2c13.6 18.4 35.1 34.2 61.2 46.8C123.3 306.4 186.6 320 256 320s132.7-13.6 178.8-35.9c26.1-12.6 47.5-28.5 61.2-46.8zM84.1 269.7c-8.9-4.3-17-8.9-24.2-13.7c7.2-4.8 15.3-9.4 24.2-13.7C127.7 221.3 188.5 208 256 208s128.3 13.3 171.9 34.3c8.9 4.3 17 8.9 24.2 13.7c-7.2 4.8-15.3 9.4-24.2 13.7C384.3 290.7 323.5 304 256 304s-128.3-13.3-171.9-34.3z"],
    "building-un": [384, 512, [], "e4d9", "M48 16C30.3 16 16 30.3 16 48V464c0 17.7 14.3 32 32 32h96V416c0-26.5 21.5-48 48-48s48 21.5 48 48v80h96c17.7 0 32-14.3 32-32V48c0-17.7-14.3-32-32-32H48zM224 496V416c0-17.7-14.3-32-32-32s-32 14.3-32 32v80h64zm-80 16H48c-26.5 0-48-21.5-48-48V48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48H240 224 160 144zM104 232h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H104c-13.3 0-24-10.7-24-24V256c0-13.3 10.7-24 24-24zm-8 24v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V256c0-4.4-3.6-8-8-8H104c-4.4 0-8 3.6-8 8zm128 0c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H248c-13.3 0-24-10.7-24-24V256zm24-8c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V256c0-4.4-3.6-8-8-8H248zM230.7 59.6l49.3 74V64c0-4.4 3.6-8 8-8s8 3.6 8 8v96c0 3.5-2.3 6.6-5.7 7.7s-7-.3-9-3.2L232 90.4V160c0 4.4-3.6 8-8 8s-8-3.6-8-8V64c0-3.5 2.3-6.6 5.7-7.7s7 .3 9 3.2zM104 64v64c0 13.3 10.7 24 24 24s24-10.7 24-24V64c0-4.4 3.6-8 8-8s8 3.6 8 8v64c0 22.1-17.9 40-40 40s-40-17.9-40-40V64c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "dice-three": [448, 512, [9858], "f527", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm144 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 272a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM336 352a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "tire-pressure-warning": [512, 512, [], "f633", "M424 0c-4.4 0-8 3.6-8 8V35.6c0 41 9.5 81.4 27.9 118.1l5 9.9c.1 .2 .2 .3 .2 .5c18.3 31.4 37.6 75.1 36.9 124.7c-.6 48.6-20.4 103.7-81.1 159.3H107.1C46.4 392.4 26.6 337.2 26 288.7c-.6-49.5 18.6-93.2 36.9-124.7c.1-.1 .2-.3 .2-.5l5-9.9C86.5 117 96 76.6 96 35.6V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V35.6c0 38.5-9 76.5-26.2 110.9L49 156.2C30 188.8 9.3 235.3 10 288.9c.7 53.3 22.6 112.5 86 170.6V504c0 4.4 3.6 8 8 8s8-3.6 8-8V464h88v40c0 4.4 3.6 8 8 8s8-3.6 8-8V464h80v40c0 4.4 3.6 8 8 8s8-3.6 8-8V464h88v40c0 4.4 3.6 8 8 8s8-3.6 8-8V459.5c63.4-58.2 85.3-117.3 86-170.6c.7-53.6-20-100.2-39-132.7l-4.9-9.7C441 112 432 74.1 432 35.6V8c0-4.4-3.6-8-8-8zM256 96c-4.4 0-8 3.6-8 8V264c0 4.4 3.6 8 8 8s8-3.6 8-8V104c0-4.4-3.6-8-8-8zm16 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "wifi-fair": [640, 512, ["wifi-2"], "f6ab", "M133.5 282c48.7-45.9 114.3-74 186.5-74s137.8 28.1 186.5 74c3.2 3 8.3 2.9 11.3-.3s2.9-8.3-.3-11.3C465.9 221.8 396.4 192 320 192s-145.9 29.8-197.5 78.4c-3.2 3-3.4 8.1-.3 11.3s8.1 3.4 11.3 .3zM272 416a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M128 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H64C28.7 64 0 92.7 0 128v48 16 96 16 96 16 32c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V416 400 304 288 192 176 128c0-35.3-28.7-64-64-64H336V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H128V8zM432 288H304V192H432v96zM288 192v96H160V192H288zm-144 0v96H16V192H144zM16 304H144v96H16V304zm0 112H144v80H64c-26.5 0-48-21.5-48-48V416zm144 80V416H288v80H160zm144 0V416H432v32c0 26.5-21.5 48-48 48H304zm128-96H304V304H432v96zM112 80v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80H320v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80h48c26.5 0 48 21.5 48 48v48H16V128c0-26.5 21.5-48 48-48h48zM288 400H160V304H288v96z"],
    "mp3-player": [384, 512, [], "f8ce", "M64 16C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48H320c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H64zM0 64C0 28.7 28.7 0 64 0H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM96 80c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16H288c8.8 0 16-7.2 16-16V96c0-8.8-7.2-16-16-16H96zM64 96c0-17.7 14.3-32 32-32H288c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V96zM192 432a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm0-208a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm16 112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "anchor-circle-check": [640, 512, [], "e4aa", "M352 80A64 64 0 1 1 224 80a64 64 0 1 1 128 0zM288 0c-44.2 0-80 35.8-80 80c0 41.5 31.6 75.6 72 79.6c0 .1 0 .3 0 .4v48H200c-4.4 0-8 3.6-8 8s3.6 8 8 8h80V496h-8C170.4 496 88 413.6 88 312V284.8l58.1 64.5c3 3.3 8 3.6 11.3 .6s3.6-8 .6-11.3l-72-80C84.4 257 82.3 256 80 256s-4.4 1-5.9 2.6l-72 80c-3 3.3-2.7 8.3 .6 11.3s8.3 2.7 11.3-.6L72 284.8V312c0 110.5 89.5 200 200 200h16 16c25.9 0 50.7-4.9 73.4-13.9c-4.3-3.9-8.5-8.1-12.4-12.5C346 492.3 325.4 496 304 496h-8V224h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H296V160c0-.1 0-.3 0-.4c40.4-4 72-38.1 72-79.6c0-44.2-35.8-80-80-80zM496 240a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm69.7-189.7c-3.1-3.1-8.2-3.1-11.3 0L480 396.7l-42.3-42.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l48 48c3.1 3.1 8.2 3.1 11.3 0l80-80c3.1-3.1 3.1-8.2 0-11.3z"],
    "tally-4": [640, 512, [], "e297", "M136 40c0-4.4-3.6-8-8-8s-8 3.6-8 8V472c0 4.4 3.6 8 8 8s8-3.6 8-8V40zm128 0c0-4.4-3.6-8-8-8s-8 3.6-8 8V472c0 4.4 3.6 8 8 8s8-3.6 8-8V40zm120-8c-4.4 0-8 3.6-8 8V472c0 4.4 3.6 8 8 8s8-3.6 8-8V40c0-4.4-3.6-8-8-8zm136 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V472c0 4.4 3.6 8 8 8s8-3.6 8-8V40z"],
    "rectangle-history": [512, 512, [], "e4a2", "M496 192c0-26.5-21.5-48-48-48L64 144c-26.5 0-48 21.5-48 48l0 256c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48l0-256zm-48-64c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192c0-35.3 28.7-64 64-64l384 0zm8-64c4.4 0 8 3.6 8 8s-3.6 8-8 8L56 80c-4.4 0-8-3.6-8-8s3.6-8 8-8l400 0zM408 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L104 16c-4.4 0-8-3.6-8-8s3.6-8 8-8L408 0z"],
    "building-circle-arrow-right": [640, 512, [], "e4d1", "M48 16H336c17.7 0 32 14.3 32 32V247.2c5-5.3 10.4-10.3 16-15V48c0-26.5-21.5-48-48-48H48C21.5 0 0 21.5 0 48V464c0 26.5 21.5 48 48 48h96 16 64 16 96c15.1 0 28.5-6.9 37.3-17.8c-3.9-3.8-7.6-7.7-11.1-11.8c-5.8 8.2-15.4 13.6-26.2 13.6H240V416c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-17.7 0-32-14.3-32-32V48c0-17.7 14.3-32 32-32zM224 496H160V416c0-17.7 14.3-32 32-32s32 14.3 32 32v80zM104 232c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H104zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V256zm128 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V256c0-4.4 3.6-8 8-8zM104 104c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H104zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V128zm128 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V128c0-4.4 3.6-8 8-8zM496 240a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm2.3-213.7c-3.1 3.1-3.1 8.2 0 11.3L548.7 360H424c-4.4 0-8 3.6-8 8s3.6 8 8 8H548.7l-50.3 50.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l64-64c3.1-3.1 3.1-8.2 0-11.3l-64-64c-3.1-3.1-8.2-3.1-11.3 0z"],
    "volleyball": [512, 512, [127952, "volleyball-ball"], "f45f", "M452.3 394.2c-95.6 35.4-205.8 25.6-295.8-34.3c-18.6 27.9-32.5 58.5-41.3 90.6C154.7 479.1 203.4 496 256 496c81.1 0 152.8-40.2 196.3-101.8zm14.5-23.2c12.3-22.4 21-47 25.6-73.1C415 316.4 330.8 307 256.1 265.2c-36.3 21.6-66.6 49.5-90.4 81.5c91.9 61 205.9 67.2 301 24.2zm28-90.2c.8-8.1 1.3-16.4 1.3-24.8c0-119.9-88-219.3-202.9-237.2c69.8 68.2 108.5 166.8 96.9 271c35.4 2.9 70.8-.2 104.7-9.1zM266.5 16.2c-3.5-.2-7-.2-10.5-.2c-28.8 0-56.4 5.1-81.9 14.4c54.8 57.7 88.7 135.4 89.9 221c35.1 19.6 72.5 31.7 110.1 36.8C386 181.5 342.6 81.2 266.5 16.2zM158.1 36.8C74.3 74.3 16 158.3 16 256c0 22.5 3.1 44.4 8.9 65.1c30.2-90.9 96.9-169.8 187.9-208.4l.3-.1c-14.5-28-33.1-53.5-55.1-75.7zM33.9 347.1c14.8 36.2 38.2 67.9 67.7 92.7c10.1-34 25.6-66.3 46.3-95.7c25.7-36.5 59.3-68.3 100.1-92.6c-.6-44.4-10.5-86.5-27.8-124.5l-1 .4C125.5 167.1 58.9 251.8 33.9 347.1zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "sun-haze": [640, 512, [], "f765", "M229.7 2.8c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L185 121 77.1 140.8c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L129.1 256 107 288h19.4l18.9-27.5c1.9-2.7 1.9-6.3 0-9.1L80 156.6l113.3-20.8c3.3-.6 5.8-3.2 6.4-6.4L220.6 16l94.9 65.4c2.7 1.9 6.3 1.9 9.1 0L419.4 16l20.8 113.3c.6 3.3 3.2 5.8 6.4 6.4L560 156.6l-65.4 94.9c-1.9 2.7-1.9 6.3 0 9.1L513.5 288H533l-22.1-32 62.3-90.3c3.1-4.5 3.7-10.2 1.6-15.2l-7.4 3.1 7.4-3.1c-2.1-5-6.6-8.6-11.9-9.6L455 121 435.1 13.1c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L320 65.1 229.7 2.8zM432 256c0-61.9-50.1-112-112-112s-112 50.1-112 112c0 11.1 1.6 21.9 4.6 32h16.8c-3.5-10-5.5-20.8-5.5-32c0-53 43-96 96-96s96 43 96 96c0 11.2-1.9 22-5.5 32h16.8c3-10.1 4.6-20.9 4.6-32zM72 320c-4.4 0-8 3.6-8 8s3.6 8 8 8H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H72zm416 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H488zM8 408c-4.4 0-8 3.6-8 8s3.6 8 8 8H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H8zm64 88c-4.4 0-8 3.6-8 8s3.6 8 8 8H216c4.4 0 8-3.6 8-8s-3.6-8-8-8H72zm192 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H264z"],
    "text-size": [640, 512, [], "f894", "M16 56c0-4.4 3.6-8 8-8H184l0 416H104c-4.4 0-8 3.6-8 8s3.6 8 8 8h88 88c4.4 0 8-3.6 8-8s-3.6-8-8-8H200l0-416H360c4.4 0 8 3.6 8 8v48c0 4.4 3.6 8 8 8s8-3.6 8-8V56c0-13.3-10.7-24-24-24H192 24C10.7 32 0 42.7 0 56v48c0 4.4 3.6 8 8 8s8-3.6 8-8V56zM336 248c0-4.4 3.6-8 8-8H472l0 224H392c-4.4 0-8 3.6-8 8s3.6 8 8 8h88 88c4.4 0 8-3.6 8-8s-3.6-8-8-8H488l0-224H616c4.4 0 8 3.6 8 8v48c0 4.4 3.6 8 8 8s8-3.6 8-8V248c0-13.3-10.7-24-24-24H480 344c-13.3 0-24 10.7-24 24v48c0 4.4 3.6 8 8 8s8-3.6 8-8V248z"],
    "ufo": [640, 512, [128760], "e047", "M168 236.7c-5.8 5.5-5.8 5.5-5.8 5.5l0 0 0 0 .1 .1 .2 .2 .5 .5c.4 .4 1 .9 1.8 1.6c1.5 1.3 3.8 3.2 6.8 5.4c6 4.4 15.1 10.1 27.8 15.7C224.5 276.9 263.6 288 320 288s95.5-11.1 120.7-22.4c12.6-5.7 21.7-11.3 27.8-15.7c3-2.2 5.3-4 6.8-5.4c.8-.7 1.4-1.2 1.8-1.6l.5-.5 .2-.2 .1-.1 0 0 0 0s0 0-5.8-5.5l5.8 5.5c1.3-1.3 2-3 2.2-4.8C488.4 139.7 410.9 64 320 64s-168.4 75.7-160 173.4c.2 1.8 .9 3.5 2.2 4.8l5.8-5.5zm296.3-3.7c-1.2 1-2.9 2.4-5.2 4c-5.2 3.8-13.4 8.9-24.9 14.1c-23.1 10.4-60 21-114.2 21s-91.1-10.6-114.2-21c-11.6-5.2-19.7-10.3-24.9-14.1c-2.3-1.6-4-3-5.2-4C170 146.7 238.9 80 320 80s150 66.7 144.3 152.9zM128 328a16 16 0 1 1 0-32 16 16 0 1 1 0 32zM96 312a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm224 64a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32-16a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm240-48a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM130.6 204.4c4.2-1.4 6.4-6 5-10.2s-6-6.4-10.2-5c-37.1 12.7-68.2 29-90.1 48.2S0 279.1 0 304c0 21.4 10 41.2 26.8 58.5c16.7 17.3 40.6 32.4 69.4 45C153.9 432.6 233 448 320 448s166.1-15.4 223.8-40.5c28.8-12.6 52.7-27.7 69.4-45C630 345.2 640 325.4 640 304c0-24.9-13.4-47.5-35.3-66.6s-52.9-35.5-90.1-48.2c-4.2-1.4-8.7 .8-10.2 5s.8 8.7 5 10.2c35.9 12.2 64.9 27.7 84.7 45.1C614 266.8 624 285.3 624 304c0 16.1-7.5 32.1-22.3 47.4c-14.8 15.3-36.7 29.4-64.3 41.5C482.2 416.9 405.3 432 320 432s-162.2-15.1-217.4-39.2c-27.6-12-49.5-26.2-64.3-41.5C23.5 336.1 16 320.1 16 304c0-18.7 10-37.2 29.9-54.6s48.8-32.8 84.7-45.1z"],
    "fork": [512, 512, ["utensil-fork"], "f2e3", "M401.1 20.2c3.6-2.6 4.4-7.6 1.9-11.2s-7.6-4.4-11.2-1.9L277.3 89c-3.2 2.3-6.3 4.9-9.1 7.7l-7.6 7.6c-28.1 28.1-28.1 73.7 0 101.8l17 17L3 497.7c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L289 234.3l17 17c28.1 28.1 73.7 28.1 101.8 0l7.6-7.6c2.8-2.8 5.4-5.8 7.7-9.1l81.8-114.5c2.6-3.6 1.7-8.6-1.9-11.2s-8.6-1.7-11.2 1.9L410 225.4c-1.8 2.5-3.8 4.9-6 7l-7.6 7.6c-21.9 21.9-57.3 21.9-79.2 0L272 194.7c-21.9-21.9-21.9-57.3 0-79.2l7.6-7.6c2.2-2.2 4.5-4.2 7-6L401.1 20.2zm34.7 33.4c3.3-3 3.5-8 .6-11.3s-8-3.5-11.3-.6L306.2 149.2c-3.3 3-3.5 8-.6 11.3s8 3.5 11.3 .6L435.8 53.6zM470.3 87c3-3.3 2.7-8.3-.6-11.3s-8.3-2.7-11.3 .6L350.9 195c-3 3.3-2.7 8.3 .6 11.3s8.3 2.7 11.3-.6L470.3 87z"],
    "arrows-up-to-line": [576, 512, [], "e4c2", "M8 48l560 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8zM2.3 242.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L120 147.3 120 472c0 4.4 3.6 8 8 8s8-3.6 8-8l0-324.7L242.3 253.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-120-120c-3.1-3.1-8.2-3.1-11.3 0l-120 120zm320 11.3c3.1 3.1 8.2 3.1 11.3 0L440 147.3 440 472c0 4.4 3.6 8 8 8s8-3.6 8-8l0-324.7L562.3 253.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-120-120c-3.1-3.1-8.2-3.1-11.3 0l-120 120c-3.1 3.1-3.1 8.2 0 11.3z"],
    "mobile-signal": [512, 512, [], "e1ef", "M96 16H288c26.5 0 48 21.5 48 48V272.1c5.2-3.7 10.5-7.2 16-10.4V64c0-35.3-28.7-64-64-64H96C60.7 0 32 28.7 32 64V448c0 35.3 28.7 64 64 64H224V496H96c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48zm48 416c-4.4 0-8 3.6-8 8s3.6 8 8 8h83c.8-5.4 1.8-10.7 2.9-16H144zM504 256c-137 0-248 111-248 248c0 4.4 3.6 8 8 8s8-3.6 8-8c0-128.1 103.9-232 232-232c4.4 0 8-3.6 8-8s-3.6-8-8-8zm-8 224a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-48 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-120c0-4.4-3.6-8-8-8c-83.9 0-152 68.1-152 152c0 4.4 3.6 8 8 8s8-3.6 8-8c0-75.1 60.9-136 136-136c4.4 0 8-3.6 8-8z"],
    "barcode-scan": [640, 512, [], "f465", "M64 40V192H80V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zm0 432c0 4.4 3.6 8 8 8s8-3.6 8-8V320H64V472zm64 0V320H112V472c0 4.4 3.6 8 8 8s8-3.6 8-8zM112 40V192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zm64 432c0 4.4 3.6 8 8 8s8-3.6 8-8V320H176V472zm0-432V192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zm72 432c0 4.4 3.6 8 8 8s8-3.6 8-8V320H248V472zm0-432V192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zm72 432c0 4.4 3.6 8 8 8s8-3.6 8-8V320H320V472zm0-432V192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zm48 432c0 4.4 3.6 8 8 8s8-3.6 8-8V320H368V472zm0-432V192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zm80 432c0 4.4 3.6 8 8 8s8-3.6 8-8V320H448V472zm0-432V192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zm64 432c0 4.4 3.6 8 8 8s8-3.6 8-8V320H512V472zm0-432V192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zm48 432c0 4.4 3.6 8 8 8s8-3.6 8-8V320H560V472zm0-432V192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8zM0 256c0 4.4 3.6 8 8 8l624 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 248c-4.4 0-8 3.6-8 8z"],
    "sort-down": [320, 512, ["sort-desc"], "f0dd", "M144.6 457.4c4 4.2 9.6 6.6 15.4 6.6s11.4-2.4 15.4-6.6L300.5 325.3c2.2-2.3 3.5-5.4 3.5-8.7c0-7-5.6-12.6-12.6-12.6H28.6c-7 0-12.6 5.6-12.6 12.6c0 3.2 1.2 6.3 3.5 8.7L144.6 457.4zm-11.6 11L7.8 336.3C2.8 331 0 323.9 0 316.6C0 300.8 12.8 288 28.6 288H291.4c15.8 0 28.6 12.8 28.6 28.6c0 7.3-2.8 14.4-7.8 19.7L187 468.4c-7 7.4-16.8 11.6-27 11.6s-20-4.2-27-11.6z"],
    "folder-arrow-down": [512, 512, ["folder-download"], "e053", "M496 416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H197.5c12.7 0 24.9 5.1 33.9 14.1l35.9 35.9c9 9 21.2 14.1 33.9 14.1H448c26.5 0 48 21.5 48 48V416zM64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H301.3c-8.5 0-16.6-3.4-22.6-9.4L242.7 50.7c-12-12-28.3-18.7-45.3-18.7H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64zM264 184c0-4.4-3.6-8-8-8s-8 3.6-8 8V372.7l-74.3-74.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l88 88c3.1 3.1 8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L264 372.7V184z"],
    "circle-minus": [512, 512, ["minus-circle"], "f056", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 248c-4.4 0-8 3.6-8 8s3.6 8 8 8H352c4.4 0 8-3.6 8-8s-3.6-8-8-8H160z"],
    "face-icicles": [512, 512, [], "e37c", "M256 16C123.5 16 16 123.5 16 256V401l8.6-20.2c1.7-4.1 6.4-5.9 10.5-4.2s5.9 6.4 4.2 10.5l-24 56c-1.5 3.5-5.2 5.4-9 4.7s-6.4-4-6.4-7.8V256C0 114.6 114.6 0 256 0S512 114.6 512 256V504c0 3.8-2.7 7.1-6.4 7.8s-7.5-1.2-9-4.7l-24-56c-1.7-4.1 .1-8.8 4.2-10.5s8.8 .1 10.5 4.2L496 465V256C496 123.5 388.5 16 256 16zM168 304c-22.1 0-40 17.9-40 40s17.9 40 40 40h8V304h-8zm24 80h56V304H192v80zm96 0h16 16V304H264v80h24zm0 16H168c-30.9 0-56-25.1-56-56s25.1-56 56-56H344c30.9 0 56 25.1 56 56c0 15.3-6.1 29.1-16 39.2V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V394.6c-7.3 3.5-15.4 5.4-24 5.4H304v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V400zm96-56c0-22.1-17.9-40-40-40h-8v80h8c9 0 17.3-3 24-8v0h0c9.7-7.3 16-18.9 16-32zM160.4 208a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-3 291.2c4.2-1.4 8.7 .8 10.2 5s-.8 8.7-5 10.2C312.7 507.2 284.9 512 256 512c-78.4 0-148.7-35.3-195.6-90.8c-2.9-3.4-2.4-8.4 .9-11.3s8.4-2.4 11.3 .9C116.7 462.9 182.5 496 256 496c27.1 0 53.1-4.5 77.4-12.8zm74.5-41.4c21.2-17.4 39.4-38.3 53.7-61.9c2.3-3.8 7.2-5 11-2.7s5 7.2 2.7 11c-15.2 25.2-34.6 47.5-57.3 66.1c-3.4 2.8-8.5 2.3-11.3-1.1s-2.3-8.5 1.1-11.3zM106.1 192.3c4.3 1.2 6.8 5.6 5.6 9.8l-24 88c-.9 3.3-3.8 5.6-7.2 5.9s-6.6-1.7-7.9-4.8l-24-56c-1.7-4.1 .1-8.8 4.2-10.5s8.8 .1 10.5 4.2l15 34.9 18-65.9c1.2-4.3 5.6-6.8 9.8-5.6zM352.3 74.1c-1.2-4.3 1.4-8.7 5.6-9.8s8.7 1.4 9.8 5.6l18 65.9 15-34.9c1.7-4.1 6.4-5.9 10.5-4.2s5.9 6.4 4.2 10.5l-24 56c-1.3 3.1-4.5 5.1-7.9 4.8s-6.3-2.6-7.2-5.9l-24-88z"],
    "shovel": [512, 512, [], "f713", "M410.3 2.3c3.1-3.1 8.2-3.1 11.3 0l88 88c3.1 3.1 3.1 8.2 0 11.3l-37.8 37.8c-13.2 13.2-31 20.6-49.7 20.6c-16.5 0-31.7-5.7-43.7-15.2L229.7 293.7l67.7 67.7c12.5 12.5 12.5 32.8 0 45.3l-58.5 58.5c-30 30-70.7 46.9-113.1 46.9H32c-17.7 0-32-14.3-32-32V386.3c0-42.4 16.9-83.1 46.9-113.1l58.5-58.5c12.5-12.5 32.8-12.5 45.3 0l67.7 67.7L367.2 133.5c-9.5-12-15.2-27.2-15.2-43.7c0-18.6 7.4-36.5 20.6-49.7L410.3 2.3zm5.7 17L383.9 51.4C373.7 61.6 368 75.4 368 89.8c0 29.9 24.3 54.2 54.2 54.2c14.4 0 28.2-5.7 38.3-15.9L492.7 96 416 19.3zM16 480c0 8.8 7.2 16 16 16h93.7c38.2 0 74.8-15.2 101.8-42.2l58.5-58.5c6.2-6.2 6.2-16.4 0-22.6L139.3 225.9c-6.2-6.2-16.4-6.2-22.6 0L58.2 284.5c-27 27-42.2 63.6-42.2 101.8V480z"],
    "door-open": [576, 512, [], "f52b", "M304 496H96 80V86.2C80 71.3 90.3 58.4 104.8 55l166-38.3c2-.5 4-.7 6.1-.7c15 0 27.1 12.1 27.1 27.1V496zM64 86.2V496H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H64 80 96 304h16V496 43.1C320 19.3 300.7 0 276.9 0c-3.3 0-6.5 .4-9.7 1.1l-166 38.3C79.4 44.4 64 63.8 64 86.2zM472 80c13.3 0 24 10.7 24 24V504c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H512V104c0-22.1-17.9-40-40-40H352V80H472zM232 216c-9.7 0-17.9 5.3-23.4 12.6s-8.6 17-8.6 27.4s3.2 20.1 8.6 27.4s13.7 12.6 23.4 12.6s17.9-5.3 23.4-12.6s8.6-17 8.6-27.4s-3.2-20.1-8.6-27.4s-13.7-12.6-23.4-12.6zm-16 40c0-7.2 2.2-13.5 5.4-17.8s7-6.2 10.6-6.2s7.4 1.9 10.6 6.2s5.4 10.6 5.4 17.8s-2.2 13.5-5.4 17.8s-7 6.2-10.6 6.2s-7.4-1.9-10.6-6.2s-5.4-10.6-5.4-17.8z"],
    "films": [576, 512, [], "e17a", "M224 288V216H448v72 80H224V288zm0-88V128 48H448v80 72H224zm240 80V216h96v64H464zm0-144h96v64H464V136zm112 72v-8V136v-8-8V96c0-35.3-28.7-64-64-64H464h-8-8H224h-8-8H160c-35.3 0-64 28.7-64 64v24 8 8 64 8 8 64 8 8 24c0 35.3 28.7 64 64 64h48 8 8H448h8 8 48c35.3 0 64-28.7 64-64V296v-8-8V216v-8zM560 96v24H464V48h48c26.5 0 48 21.5 48 48zM160 48h48v72H112V96c0-26.5 21.5-48 48-48zm-48 88h96v64H112V136zm96 80v64H112V216h96zM112 320V296h96v72H160c-26.5 0-48-21.5-48-48zm400 48H464V296h96v24c0 26.5-21.5 48-48 48zM0 192V416c0 35.3 28.7 64 64 64H416c35.3 0 64-28.7 64-64H464c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V192c0-26.5 21.5-48 48-48V128c-35.3 0-64 28.7-64 64z"],
    "right-from-bracket": [512, 512, ["sign-out-alt"], "f2f5", "M492.7 248c2.1 2.1 3.3 5 3.3 8s-1.2 5.9-3.3 8L360.6 395.8c-2.7 2.7-6.4 4.2-10.2 4.2c-8 0-14.4-6.5-14.4-14.4l0-73.6c0-4.4-3.6-8-8-8l-136 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l136 0c4.4 0 8-3.6 8-8l0-73.6c0-8 6.5-14.4 14.4-14.4c3.8 0 7.5 1.5 10.2 4.2L492.7 248zm19.3 8c0-7.2-2.9-14.2-8-19.3L371.9 104.9c-5.7-5.7-13.4-8.9-21.5-8.9c-16.8 0-30.4 13.6-30.4 30.4l0 65.6-128 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0 0 65.6c0 16.8 13.6 30.4 30.4 30.4c8.1 0 15.8-3.2 21.5-8.9L504 275.3c5.1-5.1 8-12.1 8-19.3zM184 48c4.4 0 8-3.6 8-8s-3.6-8-8-8L88 32C39.4 32 0 71.4 0 120L0 392c0 48.6 39.4 88 88 88l96 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-96 0c-39.8 0-72-32.2-72-72l0-272c0-39.8 32.2-72 72-72l96 0z"],
    "face-glasses": [512, 512, [], "e377", "M256 496C123.5 496 16 388.5 16 256c0-28.1 4.8-55 13.7-80H50.7C49 181 48 186.4 48 192v64c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V192c0-5.6-1-11-2.7-16h37.5c-1.8 5-2.7 10.4-2.7 16v64c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V192c0-5.6-1-11-2.7-16h21.1c8.8 25 13.7 51.9 13.7 80c0 132.5-107.5 240-240 240zM227.8 160c-8.8-9.8-21.6-16-35.8-16H96c-14.2 0-27 6.2-35.8 16H36C73 75.2 157.6 16 256 16s183 59.2 220 144H451.8c-8.8-9.8-21.6-16-35.8-16H320c-14.2 0-27 6.2-35.8 16H227.8zM256 0C148.6 0 56.6 66.2 18.6 160H8c-4.4 0-8 3.6-8 8s3.6 8 8 8h4.7C4.5 201.2 0 228.1 0 256C0 397.4 114.6 512 256 512s256-114.6 256-256c0-27.9-4.5-54.8-12.7-80H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H493.4C455.4 66.2 363.4 0 256 0zM139.4 337.4c-3.6 2.5-4.5 7.5-2 11.1c22.4 32 61.9 67.4 118.6 67.4s96.1-35.4 118.6-67.4c2.5-3.6 1.7-8.6-2-11.1s-8.6-1.7-11.1 2C340.6 369.2 305.4 400 256 400s-84.6-30.8-105.4-60.6c-2.5-3.6-7.5-4.5-11.1-2zM64 192c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V192zm256-32h96c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H320c-17.7 0-32-14.3-32-32V192c0-17.7 14.3-32 32-32zM192.4 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm144 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "nfc": [448, 512, [], "e1f7", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm40 96h48c4.4 0 8-3.6 8-8s-3.6-8-8-8H104c-13.3 0-24 10.7-24 24V376c0 13.3 10.7 24 24 24H344c13.3 0 24-10.7 24-24V136c0-13.3-10.7-24-24-24H240c-13.3 0-24 10.7-24 24v80.8c-18.3 3.7-32 19.8-32 39.2c0 22.1 17.9 40 40 40s40-17.9 40-40c0-19.4-13.7-35.5-32-39.2V136c0-4.4 3.6-8 8-8H344c4.4 0 8 3.6 8 8V376c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V136c0-4.4 3.6-8 8-8zM224 280a24 24 0 1 1 0-48 24 24 0 1 1 0 48z"],
    "atom": [512, 512, [9883], "f5d2", "M338 424.7c-25.7-4.7-53.5-13.5-82-25.9c-28.6 12.5-56.3 21.3-82 25.9c.8 1.8 1.6 3.6 2.5 5.4C197.3 474 225 496 256 496s58.7-22 79.5-65.8c.8-1.8 1.7-3.6 2.5-5.4zM256 512c-42.8 0-76.4-32.7-98.4-84.8c-52.7 6.1-95-6.8-115.2-43.2C21.7 346.9 33 301.2 66 256c-33-45.2-44.3-90.9-23.6-128c20.2-36.3 62.5-49.3 115.2-43.2C179.6 32.7 213.2 0 256 0s76.4 32.7 98.4 84.8c52.7-6.1 95 6.8 115.2 43.2c20.7 37.1 9.4 82.8-23.6 128c33 45.2 44.3 90.9 23.6 128c-20.2 36.3-62.5 49.3-115.2 43.2c-22 52.1-55.6 84.8-98.4 84.8zM236.3 389.7c-13.9-6.8-27.9-14.4-42-22.8c-15.7-9.4-30.6-19.3-44.5-29.5c4 26.6 10.1 51 18 72.3c21.3-3.6 44.4-10.3 68.5-19.9zm107.9 19.9c7.8-21.2 13.9-45.6 18-72.3c-13.9 10.3-28.8 20.2-44.5 29.5c-14 8.4-28.1 16-42 22.8c24.1 9.6 47.2 16.3 68.5 19.9zm-34.7-56.4c20.1-12 38.7-24.8 55.6-38.1c2-18.8 3-38.6 3-59s-1-40.2-3-59c-16.9-13.3-35.5-26.1-55.6-38.1c-18-10.8-35.9-20.2-53.4-28.2c-17.5 8-35.4 17.4-53.4 28.2c-20.1 12-38.7 24.8-55.6 38.1c-2 18.8-3 38.6-3 59s1 40.2 3 59c16.9 13.3 35.5 26.1 55.6 38.1c18 10.8 35.9 20.2 53.4 28.2c17.5-8 35.4-17.4 53.4-28.2zm51 58.6c.9 .1 1.8 .2 2.7 .2c46.3 3.9 77.6-9 92.5-35.8c15.1-27.1 9.9-62.3-16.6-102.3c-1.1-1.6-2.1-3.2-3.3-4.8c-15.3 18.5-34 36.8-55.6 54.2c-3.8 32.5-10.5 62.4-19.7 88.3zm21.9-111.1C399.2 286 413.8 271 425.8 256c-12-15-26.7-30-43.5-44.7c1.1 14.5 1.7 29.4 1.7 44.7s-.6 30.2-1.7 44.7zM439 238c26.6-40 31.7-75.2 16.6-102.3C440.7 109 409.3 96.2 363.1 100c-.9 .1-1.8 .2-2.7 .2c9.2 26 15.9 55.9 19.7 88.3c21.6 17.5 40.3 35.7 55.6 54.2c1.1-1.6 2.2-3.2 3.3-4.8zM335.5 81.8C314.7 38 287 16 256 16s-58.7 22-79.5 65.8c-.8 1.8-1.7 3.6-2.5 5.4c25.7 4.7 53.5 13.5 82 25.9c28.6-12.5 56.3-21.3 82-25.9c-.8-1.8-1.6-3.6-2.5-5.4zm8.6 20.6c-21.3 3.6-44.4 10.3-68.5 19.9c13.9 6.8 27.9 14.4 42 22.8c15.7 9.4 30.6 19.3 44.5 29.5c-4-26.6-10.1-51-18-72.3zm-176.4 0c-7.8 21.2-13.9 45.6-18 72.3c13.9-10.3 28.8-20.1 44.5-29.5c14-8.4 28.1-16 42-22.8c-24.1-9.6-47.2-16.3-68.5-19.9zm-16.2-2.2c-.9-.1-1.8-.2-2.7-.2c-46.3-3.9-77.6 9-92.5 35.7C41.3 162.8 46.5 198.1 73 238c1.1 1.6 2.1 3.2 3.3 4.8c15.3-18.5 34-36.8 55.6-54.2c3.8-32.5 10.5-62.4 19.7-88.3zM131.8 323.4c-21.6-17.5-40.3-35.7-55.6-54.2c-1.1 1.6-2.2 3.2-3.3 4.8c-26.6 40-31.7 75.2-16.6 102.3c14.9 26.8 46.3 39.6 92.5 35.8c.9-.1 1.8-.2 2.7-.2c-9.2-26-15.9-55.9-19.7-88.3zm-2.2-112.1C112.8 226 98.2 241 86.2 256c12 15 26.7 30 43.5 44.7c-1.1-14.5-1.7-29.4-1.7-44.7s.6-30.2 1.7-44.7zM256 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm32 48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "soap": [512, 512, [129532], "e06e", "M240 48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM96 192H225.3c.9 5.5 2.3 10.9 4.1 16H96c-44.2 0-80 35.8-80 80V416c0 44.2 35.8 80 80 80H416c44.2 0 80-35.8 80-80V288c0-44.2-35.8-80-80-80h-5.5c1.8-5.1 3.2-10.5 4.1-16H416c53 0 96 43 96 96V416c0 53-43 96-96 96H96c-53 0-96-43-96-96V288c0-53 43-96 96-96zM80 352c0-44.2 35.8-80 80-80H320h32c44.2 0 80 35.8 80 80s-35.8 80-80 80H160c-44.2 0-80-35.8-80-80zm16 0c0 35.3 28.7 64 64 64H352c35.3 0 64-28.7 64-64s-28.7-64-64-64H160c-35.3 0-64 28.7-64 64zM384 48a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM368 176a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-112 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "icons": [512, 512, ["heart-music-camera-bolt"], "f86d", "M496 27.5c0-5-4.6-8.8-9.6-7.8l-128 25.6c-3.7 .7-6.4 4-6.4 7.8V208v0c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48c19.1 0 36.3 6.3 48 16.3V53.1c0-11.4 8.1-21.3 19.3-23.5L483.3 4C498.1 1 512 12.4 512 27.5V176v0c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48c19.1 0 36.3 6.3 48 16.3V27.5zM323.7 186.9c-8.6-6.4-21.1-10.9-35.7-10.9s-27.1 4.4-35.7 10.9s-12.3 14.1-12.3 21.1s3.8 14.7 12.3 21.1s21.1 10.9 35.7 10.9s27.1-4.4 35.7-10.9s12.3-14.1 12.3-21.1v0c0-7.1-3.8-14.7-12.3-21.1zm160-32c-8.6-6.4-21.1-10.9-35.7-10.9s-27.1 4.4-35.7 10.9s-12.3 14.1-12.3 21.1s3.8 14.7 12.3 21.1s21.1 10.9 35.7 10.9s27.1-4.4 35.7-10.9s12.3-14.1 12.3-21.1v0c0-7.1-3.8-14.7-12.3-21.1zM473.6 256c8.7 0 14.7 8.6 11.8 16.8l-34 95.2h41.9c10.4 0 18.7 8.4 18.7 18.7c0 5.8-2.7 11.2-7.2 14.8L366.1 509.4c-2.2 1.7-4.9 2.6-7.7 2.6c-8.7 0-14.7-8.6-11.8-16.8l34-95.2H338.2c-10 0-18.2-8.1-18.2-18.2c0-5.6 2.6-10.9 7-14.3L465.8 258.7c2.2-1.7 4.9-2.7 7.7-2.7zM336.8 380.1c-.5 .4-.8 1-.8 1.7c0 1.2 1 2.2 2.2 2.2H392c2.6 0 5 1.3 6.5 3.4s1.9 4.8 1 7.3l-33.8 94.7L494.9 388.9c.7-.5 1.1-1.3 1.1-2.2c0-1.5-1.2-2.7-2.7-2.7H440c-2.6 0-5-1.3-6.5-3.4s-1.9-4.8-1-7.3l33.8-94.7L336.8 380.1zM72 320H48c-17.7 0-32 14.3-32 32V464c0 17.7 14.3 32 32 32H240c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32H216c-6.1 0-11.6-3.4-14.3-8.8l-7.2-14.3c-2.7-5.4-8.3-8.8-14.3-8.8H107.8c-6.1 0-11.6 3.4-14.3 8.8l-7.2 14.3c-2.7 5.4-8.3 8.8-14.3 8.8zm136.8-30.3L216 304h24c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V352c0-26.5 21.5-48 48-48H72l7.2-14.3c5.4-10.8 16.5-17.7 28.6-17.7h72.4c12.1 0 23.2 6.8 28.6 17.7zM104 408a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm40 56a56 56 0 1 1 0-112 56 56 0 1 1 0 112zM116.7 43.3l-6-6C98 24.7 80 18.9 62.4 21.8C35.6 26.3 16 49.4 16 76.5v2.9c0 16.3 6.8 31.9 18.7 43.1l90.4 84.3c.8 .7 1.8 1.2 2.9 1.2s2.1-.4 2.9-1.2l90.4-84.3C233.2 111.4 240 95.8 240 79.5V76.5c0-27.1-19.6-50.3-46.4-54.7C176 18.9 158 24.7 145.3 37.3l-6 6L128 54.6 116.7 43.3zM59.7 6c22.8-3.8 46 3.6 62.3 20l6 6 6-6C150.3 9.7 173.5 2.3 196.3 6C230.7 11.8 256 41.6 256 76.5v2.9c0 20.8-8.6 40.6-23.8 54.8l-90.4 84.3c-3.8 3.5-8.7 5.5-13.8 5.5s-10.1-2-13.8-5.5L23.8 134.2C8.6 120 0 100.2 0 79.5V76.5C0 41.6 25.3 11.8 59.7 6z"],
    "microphone-lines-slash": [640, 512, ["microphone-alt-slash"], "f539", "M387.6 401.1l-14.3-11.3C356.8 396.4 338.8 400 320 400c-79.5 0-144-64.5-144-144V234l-16-12.6V256c0 85.7 67.4 155.6 152 159.8V496H232c-4.4 0-8 3.6-8 8s3.6 8 8 8h88 88c4.4 0 8-3.6 8-8s-3.6-8-8-8H328V415.8c21.2-1 41.3-6.2 59.6-14.7zM240 101.1V96c0-44.2 35.8-80 80-80s80 35.8 80 80v16H328c-4.4 0-8 3.6-8 8s3.6 8 8 8h72v48H334.9l20.3 16H400v35.4l16 12.6V184 120 96c0-53-43-96-96-96c-50.6 0-92 39.1-95.7 88.7L240 101.1zM476.8 288c2.1-10.4 3.2-21.1 3.2-32V200c0-4.4-3.6-8-8-8s-8 3.6-8 8v56c0 7.1-.5 14-1.5 20.8L476.8 288zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "closed-captioning-slash": [640, 512, [], "e135", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM608 391.6V96c0-35.3-28.7-64-64-64H152.5l20.3 16H544c26.5 0 48 21.5 48 48V379l16 12.6zM370.9 204.4C385.5 187 407.5 176 432 176c24.8 0 47 11.3 61.6 29c2.8 3.4 7.9 3.9 11.3 1.1s3.9-7.9 1.1-11.3c-17.6-21.2-44.2-34.8-74-34.8c-29.6 0-56.1 13.4-73.7 34.5l12.6 9.9zM48 133L32 120.4V416c0 35.3 28.7 64 64 64H487.5l-20.3-16H96c-26.5 0-48-21.5-48-48V133zM278.3 314.8C264 328 244.9 336 224 336c-44.2 0-80-35.8-80-80c0-14.2 3.7-27.6 10.2-39.1l-12.7-10C132.9 221.2 128 238 128 256c0 53 43 96 96 96c26 0 49.7-10.4 67-27.2l-12.7-10z"],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", "M256 0c4.4 0 8 3.6 8 8V248H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H264V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V264H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H248V8c0-4.4 3.6-8 8-8zm88 104h48V56 40c0-4.4 3.6-8 8-8s8 3.6 8 8V56v48h48 16c4.4 0 8 3.6 8 8s-3.6 8-8 8H456 408v48 16c0 4.4-3.6 8-8 8s-8-3.6-8-8V168 120H344 328c-4.4 0-8-3.6-8-8s3.6-8 8-8h16zM50.7 338.7c3.1-3.1 8.2-3.1 11.3 0L112 388.7l49.9-49.9c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L123.3 400l49.9 49.9c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L112 411.3 62.1 461.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L100.7 400 50.7 350.1c-3.1-3.1-3.1-8.2 0-11.3zM40 104H184c4.4 0 8 3.6 8 8s-3.6 8-8 8H40c-4.4 0-8-3.6-8-8s3.6-8 8-8zM328 360H472c4.4 0 8 3.6 8 8s-3.6 8-8 8H328c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 64H472c4.4 0 8 3.6 8 8s-3.6 8-8 8H328c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "bridge-circle-check": [640, 512, [], "e4c9", "M40 32c-4.4 0-8 3.6-8 8s3.6 8 8 8h80v96H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H600c4.4 0 8-3.6 8-8s-3.6-8-8-8H520V48h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H40zM504 48v96H392V48H504zM376 48v96H264V48H376zM248 48v96H136V48H248zM40 256c-4.4 0-8 3.6-8 8s3.6 8 8 8H64c39.8 0 72 32.2 72 72v96c0 22.1 17.9 40 40 40h32c22.1 0 40-17.9 40-40V344c0-39.8 32.2-72 72-72c9 0 17.6 1.6 25.5 4.7c2.8-4.7 5.9-9.2 9.1-13.6C344 258.5 332.3 256 320 256c-48.6 0-88 39.4-88 88v96c0 13.3-10.7 24-24 24H176c-13.3 0-24-10.7-24-24V344c0-48.6-39.4-88-88-88H40zm456-16a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm69.7-189.7c-3.1-3.1-8.2-3.1-11.3 0L480 396.7l-42.3-42.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l48 48c3.1 3.1 8.2 3.1 11.3 0l80-80c3.1-3.1 3.1-8.2 0-11.3z"],
    "sliders-up": [512, 512, ["sliders-v"], "f3f1", "M96 0c4.4 0 8 3.6 8 8V96.5c31.6 3.9 56 30.9 56 63.5s-24.4 59.6-56 63.5V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V223.5c-31.6-3.9-56-30.9-56-63.5s24.4-59.6 56-63.5V8c0-4.4 3.6-8 8-8zm0 208a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM256 400a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm64-48c0 32.6-24.4 59.6-56 63.5V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V415.5c-31.6-3.9-56-30.9-56-63.5s24.4-59.6 56-63.5V8c0-4.4 3.6-8 8-8s8 3.6 8 8V288.5c31.6 3.9 56 30.9 56 63.5zM464 192a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-40 63.5V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V255.5c-31.6-3.9-56-30.9-56-63.5s24.4-59.6 56-63.5V8c0-4.4 3.6-8 8-8s8 3.6 8 8V128.5c31.6 3.9 56 30.9 56 63.5s-24.4 59.6-56 63.5z"],
    "location-minus": [384, 512, ["map-marker-minus"], "f609", "M368 192c0-97.2-78.8-176-176-176S16 94.8 16 192c0 18.7 6.4 42.5 17.8 69.6c11.3 26.9 27.1 55.8 44.7 84.3c35.2 57 76.8 111.4 102.3 143.2c5.9 7.3 16.6 7.3 22.4 0c25.5-31.8 67.1-86.2 102.3-143.2c17.6-28.5 33.4-57.4 44.7-84.3C361.6 234.5 368 210.7 368 192zm16 0c0 87.4-117 243-168.3 307.2c-12.3 15.3-35.1 15.3-47.4 0C117 435 0 279.4 0 192C0 86 86 0 192 0S384 86 384 192zM96 184H288c4.4 0 8 3.6 8 8s-3.6 8-8 8H96c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "pump-medical": [448, 512, [], "e06a", "M168 0h48c22.1 0 40 17.9 40 40V56h60.1c14.9 0 29.1 5.9 39.6 16.4l41.9 41.9c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L344.4 83.7C336.9 76.2 326.7 72 316.1 72H256v56H240V40c0-13.3-10.7-24-24-24H168c-13.3 0-24 10.7-24 24v88H128V40c0-22.1 17.9-40 40-40zM69.6 220L50.9 444c-2.3 28 19.8 52 47.8 52H285.2c28.1 0 50.2-24 47.8-52L314.4 220c-2.1-24.9-22.9-44-47.8-44H117.4c-25 0-45.8 19.1-47.8 44zm-15.9-1.3c2.8-33.2 30.5-58.7 63.8-58.7H266.6c33.3 0 61 25.5 63.8 58.7l18.7 224c3.1 37.3-26.3 69.3-63.8 69.3H98.8c-37.4 0-66.9-32-63.8-69.3l18.7-224zM168 256h48c4.4 0 8 3.6 8 8v40h40c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H224v40c0 4.4-3.6 8-8 8H168c-4.4 0-8-3.6-8-8V368H120c-4.4 0-8-3.6-8-8V312c0-4.4 3.6-8 8-8h40V264c0-4.4 3.6-8 8-8zm8 56v8h-8H128v32h40 8v8 40h32V360v-8h8 40V320H216h-8v-8V272H176v40z"],
    "fingerprint": [512, 512, [], "f577", "M16 256C16 123.5 123.5 16 256 16c77.9 0 147.2 37.1 191 94.7c2.7 3.5 7.7 4.2 11.2 1.5s4.2-7.7 1.5-11.2C413 39.6 339.1 0 256 0C114.6 0 0 114.6 0 256v56c0 4.4 3.6 8 8 8s8-3.6 8-8V256zm484.8-75c-1.3-4.2-5.8-6.6-10-5.3s-6.6 5.8-5.3 10c6.8 22.2 10.5 45.9 10.5 70.4v56c0 4.4 3.6 8 8 8s8-3.6 8-8V256c0-26.1-3.9-51.3-11.2-75zM256 80c-26.5 0-51.6 5.8-74.1 16.3c-4.7 2.2-5.8 8.2-2.4 12.1c2.4 2.8 6.5 3.6 9.9 2.1C209.6 101.2 232.2 96 256 96c88.4 0 160 71.6 160 160v24.9c0 31.5-2.2 62.8-6.6 93.8c-.7 4.9 3.1 9.2 8 9.2c3.9 0 7.3-2.9 7.9-6.8c4.5-31.8 6.8-64 6.8-96.3V256c0-97.2-78.8-176-176-176zM139.5 135.6c-3-3.5-8.3-3.8-11.5-.4c-29.8 31.5-48 74-48 120.8v24.9c0 31.4-4.4 62.6-13 92.6c-1.5 5.2 2.3 10.4 7.7 10.4c3.5 0 6.6-2.3 7.5-5.6C91.4 346.7 96 313.9 96 280.9V256c0-42.3 16.4-80.7 43.1-109.3c2.9-3.1 3.1-7.9 .4-11.1zM256 160c-53 0-96 43-96 96v24.9c0 42.3-6.4 84.3-19.1 124.5c-1.6 5.2 2.2 10.6 7.7 10.6c3.4 0 6.5-2.2 7.5-5.5c13.2-41.9 19.9-85.6 19.9-129.6V256c0-44.2 35.8-80 80-80s80 35.8 80 80v24.9c0 42.2-4.5 84.2-13.4 125.3c-1.1 5 2.7 9.8 7.8 9.8c3.7 0 7-2.6 7.7-6.2c9.2-42.2 13.8-85.4 13.8-128.9V256c0-53-43-96-96-96zm8 96c0-4.4-3.6-8-8-8s-8 3.6-8 8v24.9c0 61.9-11.4 123.2-33.6 180.9l-5.9 15.3c-1.6 4.1 .5 8.8 4.6 10.3s8.8-.5 10.3-4.6l5.9-15.3C252.3 408 264 344.8 264 280.9V256z"],
    "ski-boot": [512, 512, [], "e3cc", "M391.8 9.9c1.1-4.3-1.5-8.6-5.8-9.7s-8.6 1.5-9.7 5.8L369.8 32H122.5c-19.2 0-35.7 13.7-39.3 32.5L7.3 464.5C2.7 489.2 21.6 512 46.6 512H472h32c4.4 0 8-3.6 8-8s-3.6-8-8-8H480V392.5c0-22.9-13.9-43.5-35.2-52L321.5 291.2 383.7 42.1l.1-.3 8-31.8zM235.4 48H365.8l-36 144H256c-4.4 0-8 3.6-8 8s3.6 8 8 8h69.8l-20 80H224c-4.4 0-8 3.6-8 8s3.6 8 8 8h86.5l128.4 51.4c15.2 6.1 25.1 20.8 25.1 37.1V496H46.6c-15 0-26.4-13.7-23.6-28.5L55.6 296c1.2 .1 2.3-.1 3.5-.6c56.4-23.4 140.3-85 176.2-245.6c.1-.6 .2-1.2 .2-1.7zm-16.2 0C185.6 196.2 110.5 254.7 59 278L98.9 67.5C101.1 56.2 111 48 122.5 48h96.7z"],
    "standard-definition": [576, 512, ["rectangle-sd"], "e28a", "M512 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H512zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM312 168V344c0 4.4 3.6 8 8 8h64c53 0 96-43 96-96s-43-96-96-96H320c-4.4 0-8 3.6-8 8zm16 8h56c44.2 0 80 35.8 80 80s-35.8 80-80 80H328V176zm-176.2 3.1c13.2-4.3 31.2-4.5 52.5-1.6c6.5 .9 26.5 4.2 33 5.7c4.3 1 8.6-1.7 9.6-6s-1.7-8.6-6-9.6c-7.1-1.6-27.6-5-34.4-5.9c-22.1-3-43-3.1-59.6 2.2c-17.2 5.6-29.9 17.3-33.9 36.9l0 0-.1 .4c-1.5 10.5-.1 19.6 4 27.4c4.1 7.7 10.5 13.4 17.8 17.7c14 8.3 33.1 12.8 50.6 16.9l.8 .2c18.5 4.3 35.3 8.3 46.9 15.2c5.6 3.4 9.5 7.1 11.9 11.5c2.3 4.3 3.4 9.8 2.3 17.5c-1 6.8-3.5 11.8-7.1 15.6c-3.6 3.8-8.7 6.8-15.3 8.9c-13.4 4.3-31.9 4.4-53.2 1.5c-10.5-1.5-28.2-6.6-41.7-10.6l0 0c-2.9-.8-5.5-1.6-7.9-2.3c-4.2-1.2-8.7 1.3-9.9 5.5s1.2 8.7 5.5 9.9c2.1 .6 4.6 1.3 7.2 2.1c13.4 3.9 32.7 9.6 44.5 11.2l0 0c22 3 43.4 3.2 60.2-2.1c8.5-2.7 16.2-6.9 22.1-13.2c6-6.4 9.8-14.5 11.2-24.2c1.5-10.5 .1-19.6-4-27.4c-4.1-7.7-10.5-13.4-17.8-17.7c-14-8.3-33.1-12.8-50.6-16.9l-.8-.2c-18.5-4.3-35.3-8.3-46.9-15.2c-5.6-3.4-9.6-7.1-11.9-11.5c-2.3-4.2-3.4-9.7-2.3-17.3c2.7-13 10.6-20.6 23.1-24.7z"],
    "h1": [576, 512, [], "f313", "M496 72c0-2.9-1.6-5.6-4.1-7s-5.7-1.3-8.1 .2l-64 40c-3.7 2.3-4.9 7.3-2.5 11s7.3 4.9 11 2.5L480 86.4V432H424c-4.4 0-8 3.6-8 8s3.6 8 8 8h64 64c4.4 0 8-3.6 8-8s-3.6-8-8-8H496V72zM16 72c0-4.4-3.6-8-8-8s-8 3.6-8 8V248 440c0 4.4 3.6 8 8 8s8-3.6 8-8V256H304V440c0 4.4 3.6 8 8 8s8-3.6 8-8V248 72c0-4.4-3.6-8-8-8s-8 3.6-8 8V240H16V72z"],
    "hand-point-right": [512, 512, [], "f0a4", "M464 128c17.7 0 32 14.3 32 32s-14.3 32-32 32l-152 0-56 0 0-56c0-2.7-.1-5.4-.4-8L464 128zM240 192l0 0 0 16 0 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-72c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 72c0 18.5 10.5 34.6 25.9 42.6C175 291.4 168 304.9 168 320s7 28.6 17.9 37.4c-15.4 8-25.9 24.1-25.9 42.6c0 12.3 4.6 23.5 12.2 32L152 432C76.9 432 16 371.1 16 296l0-80C16 140.9 76.9 80 152 80l32 0c30.9 0 56 25.1 56 56l0 56zm16 16l56 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-31.9 0c0 0 0 0-.1 0l-36.2 0c7.6-8.5 12.2-19.7 12.2-32l0-32zm91.8 0L464 208c26.5 0 48-21.5 48-48s-21.5-48-48-48l-212.1 0C242 84 215.3 64 184 64l-32 0C68.1 64 0 132.1 0 216l0 80c0 83.9 68.1 152 152 152l56 0 24 0 32 0c26.5 0 48-21.5 48-48c0-13.8-5.8-26.3-15.2-35c18.2-6.8 31.2-24.4 31.2-45c0-12.4-4.7-23.6-12.3-32.1C340.5 286 360 265.3 360 240c0-12.3-4.6-23.5-12.2-32zM240 288l40 0c17.7 0 32 14.3 32 32c0 17.7-14.3 32-32 32l-16 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l24 0zm-8 144l-24 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0z"],
    "magnifying-glass-location": [512, 512, ["search-location"], "f689", "M208 16a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 400c54.6 0 104.2-21 141.3-55.4l149 149c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-149-149C395 312.2 416 262.6 416 208C416 93.1 322.9 0 208 0S0 93.1 0 208S93.1 416 208 416zm40.1-170.5c-13.4 23.4-29.3 44.4-40.1 57.7c-10.8-13.3-26.7-34.4-40.1-57.7C153.9 220.9 144 196.1 144 176c0-35.3 28.7-64 64-64s64 28.7 64 64c0 20.1-9.9 44.9-23.9 69.5zm-28.7 69.1c22.1-27 68.6-89.8 68.6-138.6c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 48.8 46.5 111.6 68.6 138.6c6 7.3 16.8 7.3 22.7 0zM224 176a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "message-bot": [640, 512, [], "e3b8", "M224 400c8.8 0 16 7.2 16 16v80l123.7-92.8c2.8-2.1 6.1-3.2 9.6-3.2H480c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H160c-26.5 0-48 21.5-48 48V352c0 26.5 21.5 48 48 48h64zM96 64c0-35.3 28.7-64 64-64H480c35.3 0 64 28.7 64 64V184h33c3.6-13.8 16.1-24 31-24c17.7 0 32 14.3 32 32s-14.3 32-32 32c-14.9 0-27.4-10.2-31-24H544V352c0 35.3-28.7 64-64 64H373.3L249.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V432 416H208 160c-35.3 0-64-28.7-64-64V200H63c-3.6 13.8-16.1 24-31 24c-17.7 0-32-14.3-32-32s14.3-32 32-32c14.9 0 27.4 10.2 31 24H96V64zM32 208a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm592-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM176 96c-8.8 0-16 7.2-16 16V272c0 8.8 7.2 16 16 16H464c8.8 0 16-7.2 16-16V112c0-8.8-7.2-16-16-16H176zm-32 16c0-17.7 14.3-32 32-32H464c17.7 0 32 14.3 32 32V272c0 17.7-14.3 32-32 32H176c-17.7 0-32-14.3-32-32V112zm80 56a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm40 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm128 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 40a40 40 0 1 1 0-80 40 40 0 1 1 0 80z"],
    "forward-step": [320, 512, ["step-forward"], "f051", "M272 72c0-4.4 3.6-8 8-8s8 3.6 8 8V256 440c0 4.4-3.6 8-8 8s-8-3.6-8-8V277.6L80.2 441c-5.3 4.5-12 7-19 7C45.1 448 32 434.9 32 418.8V93.2C32 77.1 45.1 64 61.2 64c6.9 0 13.7 2.5 19 7L272 234.4V72zm0 184c0-.4-.2-.8-.5-1L69.8 83.2c-2.4-2-5.4-3.2-8.6-3.2C53.9 80 48 85.9 48 93.2V418.8c0 7.3 5.9 13.2 13.2 13.2c3.1 0 6.2-1.1 8.6-3.2L271.5 257c.3-.3 .5-.6 .5-1z"],
    "face-smile-beam": [512, 512, [128522, "smile-beam"], "f5b8", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm150.6 67.4C171.4 353.2 206.6 384 256 384s84.6-30.8 105.4-60.6c2.5-3.6 7.5-4.5 11.1-2s4.5 7.5 2 11.1C352.1 364.6 312.7 400 256 400s-96.1-35.4-118.6-67.4c-2.5-3.6-1.7-8.6 2-11.1s8.6-1.7 11.1 2zm.4-137.7c-7.4 11.4-12.7 26.3-15.2 39.8c-.8 4.3-5 7.2-9.3 6.4s-7.2-5-6.4-9.3c2.8-15 8.7-32 17.6-45.6c8.7-13.3 21.5-25 38.3-25s29.6 11.7 38.3 25c8.8 13.5 14.8 30.6 17.6 45.6c.8 4.3-2 8.5-6.4 9.3s-8.5-2-9.3-6.4c-2.5-13.5-7.8-28.4-15.2-39.8c-7.6-11.6-16.1-17.7-24.9-17.7s-17.3 6.1-24.9 17.7zm144.8 39.8c-.8 4.3-5 7.2-9.3 6.4s-7.2-5-6.4-9.3c2.8-15 8.7-32 17.6-45.6c8.7-13.3 21.5-25 38.3-25s29.6 11.7 38.3 25c8.8 13.5 14.8 30.6 17.6 45.6c.8 4.3-2 8.5-6.4 9.3s-8.5-2-9.3-6.4c-2.5-13.5-7.8-28.4-15.2-39.8c-7.6-11.6-16.1-17.7-24.9-17.7s-17.3 6.1-24.9 17.7c-7.4 11.4-12.7 26.3-15.2 39.8z"],
    "light-ceiling": [512, 512, [], "e016", "M256 0c4.4 0 8 3.6 8 8V160.1C390.9 164 494.6 260.3 510 384.1c2.2 17.5-12.4 31.9-30 31.9H32C14.3 416-.2 401.6 2 384.1C17.4 260.3 121.1 164 248 160.1V8c0-4.4 3.6-8 8-8zM17.9 386c-.8 6.7 4.7 14 14.1 14H480c9.4 0 15-7.3 14.2-14C479.4 267.6 378.4 176 256 176S32.6 267.6 17.9 386zM256 512c-35.3 0-64-28.7-64-64h16c0 26.5 21.5 48 48 48s48-21.5 48-48h16c0 35.3-28.7 64-64 64z"],
    "message-exclamation": [512, 512, ["comment-alt-exclamation"], "f4a5", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM256 80c-4.4 0-8 3.6-8 8V248c0 4.4 3.6 8 8 8s8-3.6 8-8V88c0-4.4-3.6-8-8-8zm16 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "bowl-scoop": [448, 512, [127847, "bowl-shaved-ice"], "e3de", "M416 224c0-106-86-192-192-192S32 118 32 224H48c0-97.2 78.8-176 176-176s176 78.8 176 176h16zM17.9 280.7c-.5-4.6 3.1-8.7 7.7-8.7H422.4c4.6 0 8.3 4 7.7 8.7c-7.5 67.9-65 119.3-133.3 119.3H264c-3.2 0-6.2 1.9-7.4 4.9s-.6 6.4 1.7 8.7L335 490.3c.6 .6 1 1.5 1 2.3c0 1.8-1.5 3.3-3.3 3.3H115.3c-1.8 0-3.3-1.5-3.3-3.3c0-.9 .3-1.7 1-2.3l76.7-76.7c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9H151.2C82.9 400 25.4 348.6 17.9 280.7zM25.6 256C11.5 256 .4 268.3 2 282.4C10.4 358.5 74.7 416 151.2 416h13.4l-63 63c-3.6 3.6-5.7 8.5-5.7 13.7c0 10.7 8.6 19.3 19.3 19.3H332.7c10.7 0 19.3-8.6 19.3-19.3c0-5.1-2-10-5.7-13.7l-63-63h13.4c76.5 0 140.8-57.5 149.2-133.6c1.6-14.1-9.5-26.4-23.7-26.4H25.6z"],
    "square-x": [448, 512, [], "e286", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm126 34.8l98 113 98-113c2.9-3.3 7.9-3.7 11.3-.8s3.7 7.9 .8 11.3L234.6 256 334 370.8c2.9 3.3 2.5 8.4-.8 11.3s-8.4 2.5-11.3-.8l-98-113-98 113c-2.9 3.3-7.9 3.7-11.3 .8s-3.7-7.9-.8-11.3L213.4 256 114 141.2c-2.9-3.3-2.5-8.4 .8-11.3s8.4-2.5 11.3 .8z"],
    "utility-pole-double": [512, 512, [], "e2c4", "M264 16c4.4 0 8 3.6 8 8V80H240V24c0-4.4 3.6-8 8-8h16zm-40 8V80H80V40c0-4.4-3.6-8-8-8s-8 3.6-8 8V80H16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8V80 96v16c0 17.7 14.3 32 32 32h69.5L224 228.2V272H80V232c0-4.4-3.6-8-8-8s-8 3.6-8 8v40H16V232c0-4.4-3.6-8-8-8s-8 3.6-8 8v40 16 16c0 17.7 14.3 32 32 32h69.5L224 420.2V504c0 4.4 3.6 8 8 8s8-3.6 8-8V416.1c0-.1 0-.1 0-.2V336h32v79.9c0 .1 0 .1 0 .2V504c0 4.4 3.6 8 8 8s8-3.6 8-8V420.2L410.5 336H480c17.7 0 32-14.3 32-32V288 272 232c0-4.4-3.6-8-8-8s-8 3.6-8 8v40H448V232c0-4.4-3.6-8-8-8s-8 3.6-8 8v40H288V228.2L410.5 144H480c17.7 0 32-14.3 32-32V96 80 40c0-4.4-3.6-8-8-8s-8 3.6-8 8V80H448V40c0-4.4-3.6-8-8-8s-8 3.6-8 8V80H288V24c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zM408.1 128c-.1 0-.1 0-.2 0H288 272 240 224 104.1c-.1 0-.1 0-.2 0H32c-8.8 0-16-7.2-16-16V96H224h16 32 16H496v16c0 8.8-7.2 16-16 16H408.1zM129.8 144H224v64.8L129.8 144zM240 224.1c0-.1 0-.1 0-.2V144h32v79.9c0 .1 0 .1 0 .2V272H240V224.1zm48-15.3V144h94.2L288 208.8zM408.1 320c-.1 0-.1 0-.2 0H280 232 104.1c-.1 0-.1 0-.2 0H32c-8.8 0-16-7.2-16-16V288H224h16 32 16H496v16c0 8.8-7.2 16-16 16H408.1zM129.8 336H224v64.8L129.8 336zm252.5 0L288 400.8V336h94.2z"],
    "flag-checkered": [448, 512, [127937], "f11e", "M16 8c0-4.4-3.6-8-8-8S0 3.6 0 8V64 383.5 400 504c0 4.4 3.6 8 8 8s8-3.6 8-8V396l112.3-28.1c41.1-10.3 84.6-5.5 122.5 13.4c44.2 22.1 95.5 24.8 141.7 7.4l34.7-13c12.5-4.7 20.8-16.6 20.8-30V54.8c0-17.8-18.8-29.4-34.7-21.5l-19.7 9.8c-46.3 23.2-100.8 23.2-147.1 0c-35.1-17.6-75.4-22-113.5-12.5L16 60V8zm0 68.5l112-28v93.2L16 166.1V76.5zm0 106l112-24.3v87.6L16 270.1V182.4zm128-27.8l17.8-3.9c19.7-4.3 40.1-3.5 59.4 2.1l65.7 19.3c5.7 1.7 11.4 3 17.2 4.1V264c-4.3-.9-8.5-1.9-12.7-3.1l-65.7-19.3c-21.9-6.4-45-7.3-67.3-2.4L144 242.2V154.6zm176 23.8c16.5 1.4 33.1 .4 49.4-3.1L432 161.9v87.6l-66 14.1c-15.2 3.3-30.7 4.1-46 2.7V178.4zM304 280.3V382c-15.9-2.6-31.4-7.6-46.1-14.9c-35.3-17.7-75.1-24-113.9-18.5V258.6l17.8-3.9c19.7-4.3 40.1-3.5 59.4 2.1l65.7 19.3c5.7 1.7 11.4 3 17.2 4.1zm16 103.5V282.4c16.5 1.4 33.1 .4 49.4-3.1L432 265.9v79.9c0 6.7-4.1 12.6-10.4 15l-34.7 13c-21.6 8.1-44.4 11.4-66.9 10zm0-221.4V76.6c27.7 0 55.3-6.4 80.7-19.1l19.7-9.8c5.3-2.7 11.6 1.2 11.6 7.2v90.7l-66 14.1c-15.2 3.3-30.7 4.1-46 2.7zM304 75.9V160c-4.3-.9-8.5-1.9-12.7-3.1l-65.7-19.3c-21.9-6.4-45-7.3-67.3-2.4L144 138.2V44.7c32.2-6.4 65.8-1.9 95.3 12.8c20.5 10.3 42.5 16.4 64.7 18.3zM16 286.4l112-24.3v89.4c-1.2 .3-2.4 .6-3.6 .9L16 379.5V286.4z"],
    "chevrons-up": [512, 512, ["chevron-double-up"], "f325", "M261.7 50.3c-3.1-3.1-8.2-3.1-11.3 0l-216 216c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L256 67.3 466.3 277.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-216-216zm216 408l-216-216c-3.1-3.1-8.2-3.1-11.3 0l-216 216c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L256 259.3 466.3 469.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3z"],
    "football": [512, 512, [127944, "football-ball"], "f44e", "M441.3 36.9c-53.1-7.6-100-8.7-141.4-4.2L478.4 211.1c6.3-50.2 3.7-99.9-3.4-141.8c-1.3-7.9-5.4-15.4-11.7-21.4c-6.2-6-13.9-9.8-22.1-11zM214.5 52.1C152 75.3 108.6 114.9 79.7 162c-22.5 36.7-36.1 77.8-43.2 119.2l1.2 1.2 192 192 2.4 2.4c23.8-3.8 45.6-9.5 65.5-16.9C360 436.7 403.4 397.1 432.3 350c22.5-36.7 36.1-77.8 43.2-119.2l-1.2-1.2-192-192L280 35.3c-23.8 3.8-45.6 9.5-65.5 16.9zM33.6 300.9c-6.3 50.2-3.7 99.8 3.4 141.8c1.3 7.9 5.4 15.4 11.7 21.4c6.2 6 13.9 9.8 22.1 11c53.1 7.6 100 8.7 141.4 4.2L33.6 300.9zM443.6 21c11.7 1.7 22.4 7.2 30.9 15.3s14.4 18.7 16.4 30.3c14.1 84 11.2 200.1-44.9 291.7c-30.6 50-76.8 92-142.9 116.5C241.4 497.8 164 504.7 68.4 490.9c-11.7-1.7-22.4-7.2-30.9-15.3s-14.4-18.7-16.4-30.3C7.1 361.3 9.9 245.2 66 153.6c30.6-50 76.8-92 142.9-116.5C270.6 14.2 348 7.3 443.6 21zM285.7 162.3l64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm-56 56l64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm-56 56l64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0z"],
    "user-vneck": [448, 512, [], "e461", "M224 240a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM352 128A128 128 0 1 1 96 128a128 128 0 1 1 256 0zM198.4 408.5l-63.7-84.9C66.8 338.8 16 399.5 16 472v8c0 8.8 7.2 16 16 16H416c8.8 0 16-7.2 16-16v-8c0-72.5-50.8-133.2-118.7-148.4l-63.7 84.9c-12.8 17.1-38.4 17.1-51.2 0zM132.1 307.8c5.8-1.3 11.7 1.2 15.3 5.9l63.9 85.2c6.4 8.5 19.2 8.5 25.6 0l63.9-85.2c3.6-4.7 9.5-7.2 15.3-5.9C391.4 324.3 448 391.5 448 472v8c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32v-8c0-80.5 56.6-147.7 132.1-164.1z"],
    "school-circle-exclamation": [640, 512, [], "e56c", "M496 240a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-8-144c0-4.4-3.6-8-8-8s-8 3.6-8 8v96c0 4.4 3.6 8 8 8s8-3.6 8-8V288zM324.6 1.4c-2.8-1.9-6.4-1.9-9.2 0L157.5 112H56c-30.9 0-56 25.1-56 56V456c0 30.9 25.1 56 56 56H256h16 96 16 10.8c-6.9-4.9-13.4-10.2-19.6-16H368 304 272V384c0-26.5 21.5-48 48-48c1 0 1.9 0 2.9 .1c1-5.3 2.2-10.6 3.6-15.8c-2.1-.2-4.3-.3-6.5-.3c-35.3 0-64 28.7-64 64V496H56c-22.1 0-40-17.9-40-40V168c0-22.1 17.9-40 40-40H160c1.6 0 3.2-.5 4.6-1.4L320 17.8 475.4 126.6c1.3 .9 2.9 1.4 4.6 1.4H584c22.1 0 40 17.9 40 40v79.2c5.8 6.1 11.1 12.7 16 19.6V168c0-30.9-25.1-56-56-56H482.5L324.6 1.4zM64 216v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V216c0-13.3-10.7-24-24-24H88c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H88c-4.4 0-8-3.6-8-8V216c0-4.4 3.6-8 8-8zm168-32a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm144 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-80-40c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h24c4.4 0 8-3.6 8-8s-3.6-8-8-8H328V144c0-4.4-3.6-8-8-8zM88 320c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V344c0-13.3-10.7-24-24-24H88zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H88c-4.4 0-8-3.6-8-8V344z"],
    "crop": [512, 512, [], "f125", "M416 107.3l93.7-93.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L404.7 96 160 96c-4.4 0-8 3.6-8 8s3.6 8 8 8l228.7 0L112 388.7V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V96H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H96V392c0 13.3 10.7 24 24 24H352c4.4 0 8-3.6 8-8s-3.6-8-8-8H123.3L400 123.3 400 504c0 4.4 3.6 8 8 8s8-3.6 8-8V416h88c4.4 0 8-3.6 8-8s-3.6-8-8-8H416l0-292.7z"],
    "angles-down": [448, 512, ["angle-double-down"], "f103", "M405.7 93.7l-176 176c-3.1 3.1-8.2 3.1-11.3 0l-176-176c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L224 252.7 394.3 82.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zm0 192l-176 176c-3.1 3.1-8.2 3.1-11.3 0l-176-176c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L224 444.7 394.3 274.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "users-rectangle": [640, 512, [], "e594", "M72 0C32.2 0 0 32.2 0 72V440c0 39.8 32.2 72 72 72H568c39.8 0 72-32.2 72-72V72c0-39.8-32.2-72-72-72H72zM16 72c0-30.9 25.1-56 56-56H568c30.9 0 56 25.1 56 56V440c0 30.9-25.1 56-56 56H72c-30.9 0-56-25.1-56-56V72zM272 192a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM224 360c0-30.9 25.1-56 56-56h80c30.9 0 56 25.1 56 56c0 4.4-3.6 8-8 8H232c-4.4 0-8-3.6-8-8zm96-104a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-40 32c-39.8 0-72 32.2-72 72c0 13.3 10.7 24 24 24H408c13.3 0 24-10.7 24-24c0-39.8-32.2-72-72-72H280zM152 272h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H152c-30.9 0-56 25.1-56 56c0 17.7 14.3 32 32 32h32c4.4 0 8-3.6 8-8s-3.6-8-8-8H128c-8.8 0-16-7.2-16-16c0-22.1 17.9-40 40-40zm-8-96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm264 96c22.1 0 40 17.9 40 40c0 8.8-7.2 16-16 16H480c-4.4 0-8 3.6-8 8s3.6 8 8 8h32c17.7 0 32-14.3 32-32c0-30.9-25.1-56-56-56H424c-4.4 0-8 3.6-8 8s3.6 8 8 8h64zm8-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-80 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z"],
    "people-roof": [640, 512, [], "e537", "M324.4 1.3c-2.7-1.8-6.2-1.8-8.9 0l-312 208c-3.7 2.5-4.7 7.4-2.2 11.1s7.4 4.7 11.1 2.2L320 17.6l307.6 205c3.7 2.5 8.6 1.5 11.1-2.2s1.5-8.6-2.2-11.1l-312-208zM496 272a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm-5.1 32h12.8c32.5 0 62.4 17.9 77.6 46.6l28 52.6c2.7 5.1 .7 11.5-4.5 14.1c-4.8 2.4-10.7 .7-13.5-3.9l-39.3-65.4c-1.8-3.1-5.5-4.6-9-3.6s-5.9 4.1-5.9 7.7l0 64c0 8.8-7.2 16-16 16h-48c-8.8 0-16-7.2-16-16V416c0-3.6-2.4-6.7-5.9-7.7s-7.1 .5-9 3.6l-39.3 65.4c-2.8 4.6-8.6 6.3-13.5 3.9c-5.2-2.6-7.2-9-4.5-14.1l28-52.6c15.3-28.7 45.1-46.6 77.6-46.6zm-91.8 39.1l-28 52.6c-7 13.1-1.8 29.3 11.5 35.9c12.3 6.2 27.3 1.8 34.3-10l24.4-40.7V480c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32l0-35.1 24.4 40.7c7.1 11.8 22 16.2 34.3 10c13.2-6.6 18.4-22.9 11.5-35.9l-28-52.6c-18.1-33.9-53.4-55.1-91.8-55.1H490.9c-38.4 0-73.7 21.2-91.8 55.1zM120 296a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM61.3 414.6c15.3-28.7 45.1-46.6 77.6-46.6h12.8c32.5 0 62.4 17.9 77.6 46.6l28 52.6c2.7 5.1 .7 11.5-4.5 14.1c-4.8 2.4-10.7 .7-13.5-3.9l-39.3-65.4c-1.8-3.1-5.5-4.6-9-3.6s-5.9 4.1-5.9 7.7l0 64c0 8.8-7.2 16-16 16h-48c-8.8 0-16-7.2-16-16V416c0-3.6-2.4-6.7-5.9-7.7s-7.1 .5-9 3.6L51.2 477.3c-2.8 4.6-8.6 6.3-13.5 3.9c-5.2-2.6-7.2-9-4.5-14.1l28-52.6zM138.9 352c-38.4 0-73.7 21.2-91.8 55.1l-28 52.6c-7 13.1-1.8 29.3 11.5 35.9c12.3 6.2 27.3 1.8 34.3-10l24.4-40.7V480c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32l0-35.1 24.4 40.7c7.1 11.8 22 16.2 34.3 10c13.2-6.6 18.4-22.9 11.5-35.9l-28-52.6c-18.1-33.9-53.4-55.1-91.8-55.1H138.9zM320 160a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm-5.1 32h12.8c32.5 0 62.4 17.9 77.6 46.6l0 0 0 .1 20 36.6c2.1 3.9 7 5.3 10.9 3.2s5.3-7 3.2-10.9l-20-36.5c-18.1-33.9-53.4-55-91.7-55H314.9c-38.4 0-73.7 21.2-91.7 55l-20 36.5c-2.1 3.9-.7 8.7 3.2 10.9s8.7 .7 10.9-3.2l20-36.6 0 0 0-.1c15.3-28.7 45.1-46.6 77.6-46.6zm-39.4 40.3c-3.4-1-7.1 .4-9 3.4l-31.3 49.5c-2.4 3.7-1.2 8.7 2.5 11s8.7 1.3 11-2.5l16.5-26.1V392c0 4.4 3.6 8 8 8s8-3.6 8-8V304c0-3.6-2.4-6.7-5.8-7.7zm91.5 0c-3.4 1-5.8 4.1-5.8 7.7l0 88c0 4.4 3.6 8 8 8s8-3.6 8-8l0-60.4 16.5 26.1c2.4 3.7 7.3 4.8 11 2.5s4.8-7.3 2.5-11l-31.3-49.5c-1.9-3-5.6-4.4-9-3.4z"],
    "square-arrow-right": [448, 512, ["arrow-square-right"], "f33b", "M432 96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320zM384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM349.7 261.7l-104 104c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L324.7 264 104 264c-4.4 0-8-3.6-8-8s3.6-8 8-8l220.7 0-90.3-90.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l104 104c3.1 3.1 3.1 8.2 0 11.3z"],
    "location-plus": [384, 512, ["map-marker-plus"], "f60a", "M368 192c0-97.2-78.8-176-176-176S16 94.8 16 192c0 18.7 6.4 42.5 17.8 69.6c11.3 26.9 27.1 55.8 44.7 84.3c35.2 57 76.8 111.4 102.3 143.2c5.9 7.3 16.6 7.3 22.4 0c25.5-31.8 67.1-86.2 102.3-143.2c17.6-28.5 33.4-57.4 44.7-84.3C361.6 234.5 368 210.7 368 192zm16 0c0 87.4-117 243-168.3 307.2c-12.3 15.3-35.1 15.3-47.4 0C117 435 0 279.4 0 192C0 86 86 0 192 0S384 86 384 192zM184 288V200H96c-4.4 0-8-3.6-8-8s3.6-8 8-8h88V96c0-4.4 3.6-8 8-8s8 3.6 8 8v88h88c4.4 0 8 3.6 8 8s-3.6 8-8 8H200v88c0 4.4-3.6 8-8 8s-8-3.6-8-8z"],
    "lightbulb-exclamation-on": [640, 512, [], "e1ca", "M44.1 1.1l80 48c3.8 2.3 5 7.2 2.7 11s-7.2 5-11 2.7l-80-48c-3.8-2.3-5-7.2-2.7-11s7.2-5 11-2.7zm560 13.7l-80 48c-3.8 2.3-8.7 1-11-2.7s-1-8.7 2.7-11l80-48c3.8-2.3 8.7-1 11 2.7s1 8.7-2.7 11zM8 160H88c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8zm544 0h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H552c-4.4 0-8-3.6-8-8s3.6-8 8-8zM124.1 270.9l-80 48c-3.8 2.3-8.7 1-11-2.7s-1-8.7 2.7-11l80-48c3.8-2.3 8.7-1 11 2.7s1 8.7-2.7 11zm400-13.7l80 48c3.8 2.3 5 7.2 2.7 11s-7.2 5-11 2.7l-80-48c-3.8-2.3-5-7.2-2.7-11s7.2-5 11-2.7zm-72.6 10.1c18-25.9 28.5-57.3 28.5-91.2c0-88.4-71.6-160-160-160s-160 71.6-160 160c0 33.9 10.5 65.3 28.5 91.2c4.5 6.5 9.5 13.3 14.5 20.2l0 0 0 0c12.5 17.2 25.9 35.5 36.3 54.4c7.4 13.5 11.6 27.8 14 42.2H237c-2.2-12-5.9-23.7-11.8-34.5c-9.9-18-22.2-34.9-34.5-51.8l0 0 0 0 0 0c-5.2-7.1-10.4-14.2-15.4-21.4C155.6 247.9 144 213.3 144 176C144 78.8 222.8 0 320 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4l0 0 0 0 0 0 0 0c-12.3 16.8-24.6 33.7-34.5 51.8c-5.9 10.8-9.6 22.5-11.8 34.5H386.7c2.4-14.4 6.6-28.7 14-42.2c10.4-19 23.7-37.3 36.3-54.4c5-6.9 10-13.7 14.5-20.2zM320 496c35.3 0 64-28.7 64-64H256c0 35.3 28.7 64 64 64zm-80-69.3c0-5.9 4.8-10.7 10.7-10.7H389.3c5.9 0 10.7 4.8 10.7 10.7V432c0 44.2-35.8 80-80 80s-80-35.8-80-80v-5.3zM328 104V264c0 4.4-3.6 8-8 8s-8-3.6-8-8V104c0-4.4 3.6-8 8-8s8 3.6 8 8zm-8 200a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "people-line": [640, 512, [], "e534", "M320 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-64a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-5.1 112c-32.5 0-62.4 17.9-77.6 46.6l0 .1 0 0-20 36.6c-2.1 3.9-7 5.3-10.9 3.2s-5.3-7-3.2-10.9l20-36.5c18.1-33.9 53.3-55 91.7-55h12.8c38.4 0 73.7 21.2 91.7 55l20 36.5c2.1 3.9 .7 8.7-3.2 10.9s-8.7 .7-10.9-3.2l-20-36.6 0-.1 0 0c-15.3-28.7-45.1-46.6-77.6-46.6H314.9zm-39.4 40.3c3.4 1 5.8 4.1 5.8 7.7v88c0 4.4-3.6 8-8 8s-8-3.6-8-8V219.6l-16.5 26.1c-2.4 3.7-7.3 4.8-11 2.5s-4.8-7.3-2.5-11l31.3-49.5c1.9-3 5.6-4.4 9-3.4zm91.5 0c3.4-1 7.1 .4 9 3.4l31.3 49.5c2.4 3.7 1.2 8.7-2.5 11s-8.7 1.2-11-2.5l-16.5-26.1 0 60.4c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-88c0-3.6 2.4-6.7 5.8-7.7zM496 208a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-64a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-5.1 112c-32.5 0-62.4 17.9-77.6 46.6l-28 52.6c-2.7 5.1-.7 11.5 4.5 14.1c4.8 2.4 10.7 .7 13.5-3.9l39.3-65.5c1.9-3.1 5.5-4.6 9-3.6s5.9 4.1 5.9 7.7v64c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16l0-64c0-3.6 2.4-6.7 5.9-7.7s7.1 .5 9 3.6l39.3 65.5c2.8 4.6 8.6 6.3 13.5 3.9c5.2-2.6 7.2-9 4.5-14.1l-28-52.6c-15.3-28.7-45.1-46.6-77.6-46.6H490.9zm-91.8 39.1c18.1-33.9 53.4-55.1 91.8-55.1h12.8c38.4 0 73.7 21.2 91.8 55.1l28 52.6c7 13.1 1.8 29.3-11.5 35.9c-12.3 6.2-27.3 1.8-34.3-10l-24.4-40.7 0 35.1c0 17.7-14.3 32-32 32h-48c-17.7 0-32-14.3-32-32V332.9l-24.4 40.7c-7.1 11.8-22 16.2-34.3 10c-13.2-6.6-18.4-22.9-11.5-35.9l28-52.6zM8 464H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8zM168 184a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-64 0a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM61.3 302.6l-28 52.6c-2.7 5.1-.7 11.5 4.5 14.1c4.8 2.4 10.7 .7 13.5-3.9l39.3-65.5c1.8-3.1 5.5-4.6 9-3.6s5.9 4.1 5.9 7.7v64c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16l0-64c0-3.6 2.4-6.7 5.9-7.7s7.1 .5 9 3.6l39.3 65.5c2.8 4.6 8.6 6.3 13.5 3.9c5.2-2.6 7.2-9 4.5-14.1l-28-52.6c-15.3-28.7-45.1-46.6-77.6-46.6H138.9c-32.5 0-62.4 17.9-77.6 46.6zM138.9 240h12.8c38.4 0 73.7 21.2 91.8 55.1l28 52.6c7 13.1 1.8 29.3-11.5 35.9c-12.3 6.2-27.3 1.8-34.3-10l-24.4-40.7 0 35.1c0 17.7-14.3 32-32 32h-48c-17.7 0-32-14.3-32-32V332.9L64.9 373.6c-7.1 11.8-22 16.2-34.3 10c-13.2-6.6-18.4-22.9-11.5-35.9l28-52.6c18.1-33.9 53.4-55.1 91.8-55.1z"],
    "beer-mug-empty": [512, 512, ["beer"], "f0fc", "M352 48c8.8 0 16 7.2 16 16v40V367.8v.4V416c0 26.5-21.5 48-48 48H96c-26.5 0-48-21.5-48-48V64c0-8.8 7.2-16 16-16H352zm32 368V373.2l84.9-37.1c26.2-11.5 43.1-37.4 43.1-66V152c0-30.9-25.1-56-56-56H384V64c0-17.7-14.3-32-32-32H64C46.3 32 32 46.3 32 64V416c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64zm78.4-94.6L384 355.8V112h72c22.1 0 40 17.9 40 40V270.1c0 22.2-13.2 42.4-33.6 51.3zM144 136c0-4.4-3.6-8-8-8s-8 3.6-8 8V376c0 4.4 3.6 8 8 8s8-3.6 8-8V136zm72 0c0-4.4-3.6-8-8-8s-8 3.6-8 8V376c0 4.4 3.6 8 8 8s8-3.6 8-8V136zm72 0c0-4.4-3.6-8-8-8s-8 3.6-8 8V376c0 4.4 3.6 8 8 8s8-3.6 8-8V136z"],
    "crate-empty": [512, 512, [], "e151", "M496 376v80c0 22.1-17.9 40-40 40H56c-22.1 0-40-17.9-40-40V376H496zm0-16H16V280c0-22.1 17.9-40 40-40H456c22.1 0 40 17.9 40 40v80zm16 0V280c0-30.9-25.1-56-56-56H56c-30.9 0-56 25.1-56 56v80 8 8 80c0 30.9 25.1 56 56 56H456c30.9 0 56-25.1 56-56V376v-8-8zM96 304a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm336 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 432a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm336 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "diagram-predecessor": [512, 512, [], "e477", "M496 416c0 26.5-21.5 48-48 48L64 464c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l384 0c26.5 0 48 21.5 48 48l0 64zm-48 64c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64L64 288c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l384 0zM272 160c0 26.5-21.5 48-48 48L64 208c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l128 0 32 0c26.5 0 48 21.5 48 48l0 64zm16-64c0-19.1-8.4-36.3-21.7-48L368 48c22.1 0 40 17.9 40 40l0 116.7-50.3-50.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l64 64c3.1 3.1 8.2 3.1 11.3 0l64-64c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L424 204.7 424 88c0-30.9-25.1-56-56-56L224 32l-32 0L64 32C28.7 32 0 60.7 0 96l0 64c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-64zM72 384c0 4.4 3.6 8 8 8l352 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 376c-4.4 0-8 3.6-8 8zm8-264c-4.4 0-8 3.6-8 8s3.6 8 8 8l128 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L80 120z"],
    "transporter": [512, 512, [], "e042", "M472 8V40h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H472V88c0 4.4-3.6 8-8 8s-8-3.6-8-8V56H424c-4.4 0-8-3.6-8-8s3.6-8 8-8h32V8c0-4.4 3.6-8 8-8s8 3.6 8 8zM56 72v32H88c4.4 0 8 3.6 8 8s-3.6 8-8 8H56v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V120H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H40V72c0-4.4 3.6-8 8-8s8 3.6 8 8zm56 424v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-26.5 21.5-48 48-48H368c26.5 0 48 21.5 48 48v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-17.7-14.3-32-32-32H144c-17.7 0-32 14.3-32 32zM256 16a32 32 0 1 0 0 64.1A32 32 0 1 0 256 16zm0 80c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48s-21.5 48-48 48m-20.4 48c-24.3 0-47.2 11-62.4 30l-57.7 72c-5.5 6.9-4.4 17 2.5 22.5s17 4.4 22.5-2.5l45.3-56.5c2.1-2.7 5.7-3.7 8.9-2.5s5.3 4.2 5.3 7.5V416H184V237.3L153 276c-11.1 13.8-31.2 16-45 5s-16-31.2-5-45l57.7-72c18.2-22.7 45.8-36 74.9-36h40.7c29.1 0 56.7 13.2 74.9 36L409 236c11 13.8 8.8 33.9-5 45s-33.9 8.8-45-5l-31-38.7V416H312V214.5c0-3.4 2.1-6.4 5.3-7.5s6.8-.1 8.9 2.5L371.5 266c5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5l-57.7-72c-15.2-18.9-38.1-30-62.4-30H235.6zM248 416H232V328c0-13.3 10.7-24 24-24s24 10.7 24 24v88H264V328c0-4.4-3.6-8-8-8s-8 3.6-8 8v88z"],
    "calendar-circle-user": [576, 512, [], "e471", "M128 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H64C28.7 64 0 92.7 0 128v48 16V448c0 35.3 28.7 64 64 64H330.8c-6.9-4.9-13.5-10.2-19.6-16H64c-26.5 0-48-21.5-48-48V192H352h80 16V176 128c0-35.3-28.7-64-64-64H336V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H128V8zM112 80v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80H320v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80h48c26.5 0 48 21.5 48 48v48H16V128c0-26.5 21.5-48 48-48h48zM509.9 469.6C488.3 486.2 461.3 496 432 496s-56.3-9.8-77.9-26.4l3.3-6.6c9.5-19 28.9-31 50.1-31h48.9c21.2 0 40.6 12 50.1 31l3.3 6.6zm12.4-10.9l-1.5-2.9c-12.2-24.4-37.1-39.8-64.4-39.8H407.6c-27.3 0-52.2 15.4-64.4 39.8l-1.5 2.9C318.4 435.5 304 403.5 304 368c0-70.7 57.3-128 128-128s128 57.3 128 128c0 35.5-14.4 67.5-37.7 90.7zM576 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 304a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "arrow-up-long": [384, 512, ["long-arrow-up"], "f176", "M197.7 2.3c-3.1-3.1-8.2-3.1-11.3 0l-152 152c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L184 27.3V504c0 4.4 3.6 8 8 8s8-3.6 8-8V27.3L338.3 165.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-152-152z"],
    "person-carry-box": [384, 512, ["person-carry"], "f4cf", "M91.4 226.4c-6.7 2-11.4 8.3-11.4 15.3v65.1c0 4.2 1.7 8.3 4.7 11.3l51 51c4.7 4.7 7.8 10.8 8.9 17.4l15.2 90.9c1.5 8.7-4.4 17-13.2 18.4s-17-4.4-18.4-13.2l-14.3-85.9c-.5-3.3-2.1-6.3-4.5-8.7L30.1 308.7c-9-9-14.1-21.2-14.1-33.9V186.6C16 163.1 35.1 144 58.6 144c18.7 0 36.2 9.3 46.5 24.9l42.6 64c3 4.5 8 7.1 13.3 7.1H224c8.8 0 16 7.2 16 16s-7.2 16-16 16H196.3 152.6c-10.7 0-20.7-5.3-26.6-14.3l-16.6-24.9c-3.9-5.9-11.2-8.5-17.9-6.4zM251.7 272c2.7-4.7 4.3-10.2 4.3-16c0-17.7-14.3-32-32-32H161.1l-42.6-64c-13.3-20-35.8-32-59.9-32C26.2 128 0 154.2 0 186.6v88.1c0 17 6.7 33.3 18.7 45.3l79.4 79.4 14.3 85.9c2.9 17.4 19.4 29.2 36.8 26.3s29.2-19.4 26.3-36.8l-15.2-90.9c-1.6-9.9-6.3-19-13.4-26.1l-51-51V270.5 241.7l16 24 .6 .9c8.9 13.4 23.9 21.4 39.9 21.4H224 352c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H224c-17.7 0-32 14.3-32 32v64h16V128c0-8.8 7.2-16 16-16H352c8.8 0 16 7.2 16 16V256c0 8.8-7.2 16-16 16H288 251.7zM80 16a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm48 32A48 48 0 1 0 32 48a48 48 0 1 0 96 0zM0 346.5L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-69.5-16-16L48 480c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-117.5-16-16z"],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", "M209.1 8.5c72.9 68 128.7 152.4 162.7 246.1l.7 1.9c7.6 20.9 11.5 42.9 11.5 65.1C384 426.7 297.2 512 192 512S0 426.7 0 321.6c0-22.2 3.9-44.2 11.5-65.1l.7-1.9C46.2 160.8 102 76.5 174.9 8.5l3.3-3C181.9 2 186.9 0 192 0s10.1 2 13.8 5.5l3.3 3zM356.8 260C323.6 168.7 269.2 86.5 198.2 20.2l-3.3-3c-.8-.7-1.8-1.2-2.9-1.2s-2.1 .4-2.9 1.2l-3.3 3C114.8 86.5 60.4 168.7 27.2 260l-.7 1.9C19.6 281 16 301.2 16 321.6C16 417.7 95.5 496 192 496s176-78.3 176-174.4c0-20.3-3.6-40.5-10.5-59.6l-.7-1.9zm-60.4 23.4c5 11.3 7.6 23.7 7.6 36C304 381.2 254 432 192 432s-112-50.8-112-112.5c0-12.4 2.6-24.7 7.6-36l1.9-4.3c16.5-37.2 39.8-71.1 68.6-99.9l8.9-8.9c6.6-6.6 15.6-10.3 24.9-10.3s18.3 3.7 24.9 10.3l8.9 8.9c28.8 28.8 52.1 62.7 68.6 99.9l1.9 4.3zM205.6 181.6C202 178 197.1 176 192 176s-10 2-13.6 5.6l-8.9 8.9c-27.4 27.4-49.6 59.7-65.3 95.1l-1.9 4.3c-4.1 9.3-6.2 19.4-6.2 29.5c0 53 43 96.5 96 96.5s96-43.5 96-96.5c0-10.1-2.1-20.3-6.2-29.5l-1.9-4.3c-15.8-35.4-37.9-67.7-65.3-95.1l-8.9-8.9z"],
    "person": [320, 512, [129485, "male"], "f183", "M160 96a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm0-96a56 56 0 1 1 0 112A56 56 0 1 1 160 0zM141.1 144c-21.5 0-41.1 12.3-50.4 31.7L23.2 315.5c-1.9 4-6.7 5.6-10.7 3.7s-5.6-6.7-3.7-10.7L76.3 168.7c12-24.9 37.2-40.7 64.8-40.7h37.8c27.6 0 52.8 15.8 64.8 40.7l67.5 139.8c1.9 4 .3 8.8-3.7 10.7s-8.8 .3-10.7-3.7L229.3 175.7C220 156.3 200.4 144 178.9 144H141.1zM104 248V480c0 8.8 7.2 16 16 16s16-7.2 16-16V360c0-13.3 10.7-24 24-24s24 10.7 24 24V480c0 8.8 7.2 16 16 16s16-7.2 16-16V248c0-4.4 3.6-8 8-8s8 3.6 8 8V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V360c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V248c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "laptop": [640, 512, [128187], "f109", "M512 48H128c-26.5 0-48 21.5-48 48V352H64V96c0-35.3 28.7-64 64-64H512c35.3 0 64 28.7 64 64V352H560V96c0-26.5-21.5-48-48-48zM19.2 400c-1.8 0-3.2 1.4-3.2 3.2C16 436.8 43.2 464 76.8 464H563.2c33.6 0 60.8-27.2 60.8-60.8c0-1.8-1.4-3.2-3.2-3.2H19.2zM0 403.2C0 392.6 8.6 384 19.2 384H620.8c10.6 0 19.2 8.6 19.2 19.2c0 42.4-34.4 76.8-76.8 76.8H76.8C34.4 480 0 445.6 0 403.2z"],
    "file-csv": [512, 512, [], "f6dd", "M64 496h48v16H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H204.1c12.7 0 24.9 5.1 33.9 14.1L369.9 145.9c9 9 14.1 21.2 14.1 33.9V304H368V179.9c0-1.3-.1-2.6-.2-3.9H248c-22.1 0-40-17.9-40-40V16.2c-1.3-.2-2.6-.2-3.9-.2H64C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48zM361.1 160c-.8-1-1.6-1.9-2.4-2.7L226.7 25.4c-.9-.9-1.8-1.7-2.7-2.4V136c0 13.3 10.7 24 24 24H361.1zM200 368h16c17.7 0 32 14.3 32 32v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-8.8-7.2-16-16-16H200c-8.8 0-16 7.2-16 16v80c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-8c0-4.4 3.6-8 8-8s8 3.6 8 8v8c0 17.7-14.3 32-32 32H200c-17.7 0-32-14.3-32-32V400c0-17.7 14.3-32 32-32zm133.1 0H368c4.4 0 8 3.6 8 8s-3.6 8-8 8H333.1c-11.7 0-21.1 9.4-21.1 21.1c0 8.3 4.9 15.9 12.5 19.3L362 441c13.4 6 22 19.2 22 33.9c0 20.5-16.6 37.1-37.1 37.1H304c-4.4 0-8-3.6-8-8s3.6-8 8-8h42.9c11.7 0 21.1-9.4 21.1-21.1c0-8.3-4.9-15.9-12.5-19.3L318 439c-13.4-6-22-19.2-22-33.9c0-20.5 16.6-37.1 37.1-37.1zm98.9 0c4.4 0 8 3.6 8 8v31.6c0 29.1 8.3 57.5 24 82c15.7-24.5 24-52.9 24-82V376c0-4.4 3.6-8 8-8s8 3.6 8 8v31.6c0 33.2-9.8 65.6-28.2 93.2l-5.1 7.7c-1.5 2.2-4 3.6-6.7 3.6s-5.2-1.3-6.7-3.6l-5.1-7.7c-18.4-27.6-28.2-60-28.2-93.2V376c0-4.4 3.6-8 8-8z"],
    "menorah": [640, 512, [], "f676", "M17.4 56c-.9 2.1-1.4 4.4-1.4 6.8V64c0 8.8 7.2 16 16 16s16-7.2 16-16V62.8c0-2.3-.5-4.6-1.4-6.8L32 22 17.4 56zM2.7 49.7L20.8 7.4C22.8 2.9 27.1 0 32 0s9.2 2.9 11.2 7.4L61.3 49.7c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32S0 81.7 0 64V62.8c0-4.5 .9-8.9 2.7-13.1zM32 128c4.4 0 8 3.6 8 8l0 176c0 30.9 25.1 56 56 56h24V136c0-4.4 3.6-8 8-8s8 3.6 8 8V368h80V136c0-4.4 3.6-8 8-8s8 3.6 8 8V368h80l0-232c0-4.4 3.6-8 8-8s8 3.6 8 8l0 232h80V136c0-4.4 3.6-8 8-8s8 3.6 8 8V368h80V136c0-4.4 3.6-8 8-8s8 3.6 8 8V368h24c30.9 0 56-25.1 56-56l0-176c0-4.4 3.6-8 8-8s8 3.6 8 8l0 176c0 39.8-32.2 72-72 72H328V496H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H320 136c-4.4 0-8-3.6-8-8s3.6-8 8-8H312V384H96c-39.8 0-72-32.2-72-72l0-176c0-4.4 3.6-8 8-8zM128 22L113.4 56c-.9 2.1-1.4 4.4-1.4 6.8V64c0 8.8 7.2 16 16 16s16-7.2 16-16V62.8c0-2.3-.5-4.6-1.4-6.8L128 22zM116.8 7.4C118.8 2.9 123.1 0 128 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1L116.8 7.4zM209.4 56c-.9 2.1-1.4 4.4-1.4 6.8V64c0 8.8 7.2 16 16 16s16-7.2 16-16V62.8c0-2.3-.5-4.6-1.4-6.8L224 22 209.4 56zm-14.7-6.3L212.8 7.4C214.8 2.9 219.1 0 224 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1zM320 22L305.4 56c-.9 2.1-1.4 4.4-1.4 6.8V64c0 8.8 7.2 16 16 16s16-7.2 16-16V62.8c0-2.3-.5-4.6-1.4-6.8L320 22zM308.8 7.4C310.8 2.9 315.1 0 320 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1L308.8 7.4zM401.4 56c-.9 2.1-1.4 4.4-1.4 6.8V64c0 8.8 7.2 16 16 16s16-7.2 16-16V62.8c0-2.3-.5-4.6-1.4-6.8L416 22 401.4 56zm-14.7-6.3L404.8 7.4C406.8 2.9 411.1 0 416 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1zM512 22L497.4 56c-.9 2.1-1.4 4.4-1.4 6.8V64c0 8.8 7.2 16 16 16s16-7.2 16-16V62.8c0-2.3-.5-4.6-1.4-6.8L512 22zM500.8 7.4C502.8 2.9 507.1 0 512 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1L500.8 7.4zM593.4 56c-.9 2.1-1.4 4.4-1.4 6.8V64c0 8.8 7.2 16 16 16s16-7.2 16-16V62.8c0-2.3-.5-4.6-1.4-6.8L608 22 593.4 56zm-14.7-6.3L596.8 7.4C598.8 2.9 603.1 0 608 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1V64c0 17.7-14.3 32-32 32s-32-14.3-32-32V62.8c0-4.5 .9-8.9 2.7-13.1z"],
    "union": [384, 512, [8899], "f6a2", "M24 32c4.4 0 8 3.6 8 8V304c0 88.4 71.6 160 160 160s160-71.6 160-160V40c0-4.4 3.6-8 8-8s8 3.6 8 8V304c0 97.2-78.8 176-176 176S16 401.2 16 304V40c0-4.4 3.6-8 8-8z"],
    "chevrons-left": [512, 512, ["chevron-double-left"], "f323", "M50.3 250.3c-3.1 3.1-3.1 8.2 0 11.3l216 216c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L67.3 256 277.7 45.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-216 216zm408-216l-216 216c-3.1 3.1-3.1 8.2 0 11.3l216 216c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L259.3 256 469.7 45.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0z"],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-329.1l-17.7-18c-29.4-29.8-77-29.8-106.4 0s-29.4 78.2 0 108L233.5 376.1c6.2 6.3 14.3 9.4 22.5 9.4s16.3-3.1 22.5-9.4L380.1 272.9c29.4-29.8 29.4-78.2 0-108s-77-29.8-106.4 0l-17.7 18zm5.7 17l23.4-23.8c23.1-23.5 60.5-23.5 83.6 0c23.2 23.6 23.2 61.9 0 85.5L267.1 364.9c-3.1 3.1-7.1 4.7-11.1 4.7s-8-1.5-11.1-4.7L143.3 261.7c-23.2-23.6-23.2-61.9 0-85.5c23.1-23.5 60.5-23.5 83.6 0l23.4 23.8c3.1 3.2 8.3 3.2 11.4 0z"],
    "truck-plane": [640, 512, [], "e58f", "M177.7 33.3C188.2 16.2 204.2 0 224 0c20.2 0 36.3 16.2 46.7 33.3C281.3 50.9 288 72.6 288 89.2l0 22.8c-6.1 4.6-11.4 9.9-16 16l0-38.8c0-13-5.6-31.9-15-47.5c-9.7-16-21.6-25.6-33-25.6c-10.9 0-22.8 9.6-32.7 25.7C181.7 57.3 176 76.2 176 89.2V176l0 7.7 0 132.1 0 36.1 0 48c0 2.5-1.2 4.9-3.2 6.4l-57.6 43.2c-2 1.5-3.2 3.9-3.2 6.4v34.1c0 3.3 2.6 5.9 5.9 5.9c.6 0 1.2-.1 1.7-.3l102-31.4c1.5-.5 3.2-.5 4.7 0l71.6 22c2 1.1 4 2.1 6.1 3V504c0 .3 0 .7 0 1l-80-24.6L124.4 511c-2.1 .6-4.3 1-6.4 1c-12.1 0-21.9-9.8-21.9-21.9V456c0-7.6 3.6-14.7 9.6-19.2L160 396l0-44 0-25.6L30.4 362.1C15.1 366.3 0 354.8 0 339V290.9c0-14.6 7.9-28 20.7-35L160 179v-3V89.2c0-16.6 7-38.3 17.7-55.9zM160 197.3L28.4 269.9c-7.7 4.2-12.4 12.3-12.4 21L16 339c0 5.3 5 9.1 10.1 7.7L160 309.8V197.3zM592 144H336c-17.7 0-32 14.3-32 32V416c0 13 7.7 24.2 18.8 29.2c-1.8-4-2.8-8.5-2.8-13.2V376c0-21.2 11.8-39.7 29.3-49.2l3.4-11.4L365 274.2c6.1-20.3 24.8-34.2 46-34.2H517c21.2 0 39.9 13.9 46 34.2l12.4 41.2 3.4 11.4c17.4 9.5 29.3 28 29.3 49.2v56c0 4.7-1 9.2-2.8 13.2c11.1-5 18.8-16.2 18.8-29.2V176c0-17.7-14.3-32-32-32zM576 464H352v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V464c-26.5 0-48-21.5-48-48V176c0-26.5 21.5-48 48-48H592c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V464zm0-16c8.8 0 16-7.2 16-16V376c0-22.1-17.9-40-40-40H376c-22.1 0-40 17.9-40 40v56c0 8.8 7.2 16 16 16H576zM552 320h8l-4.8-16-7.6-25.2C543.6 265.3 531.1 256 517 256H411c-14.1 0-26.6 9.3-30.6 22.8L372.8 304 368 320h8 8.7H543.3 552zM400 396a12 12 0 1 0 -24 0 12 12 0 1 0 24 0zm-40 0a28 28 0 1 1 56 0 28 28 0 1 1 -56 0zm180 12a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm0-40a28 28 0 1 1 0 56 28 28 0 1 1 0-56z"],
    "record-vinyl": [512, 512, [], "f8d9", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM384 256a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM256 144a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 128a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "bring-forward": [512, 512, [], "f856", "M224 496H448c26.5 0 48-21.5 48-48V224c0-26.5-21.5-48-48-48H384V160h64c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H224c-35.3 0-64-28.7-64-64V384h16v64c0 26.5 21.5 48 48 48zm64-160c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H64C37.5 16 16 37.5 16 64V288c0 26.5 21.5 48 48 48H288zm0 16H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H288c35.3 0 64 28.7 64 64V288c0 35.3-28.7 64-64 64zm-16-96V96c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16V256c0 8.8 7.2 16 16 16H256c8.8 0 16-7.2 16-16zm16 0c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32H256c17.7 0 32 14.3 32 32V256z"],
    "square-p": [448, 512, [], "e279", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm152 32h88c48.6 0 88 39.4 88 88s-39.4 88-88 88H144v72c0 4.4-3.6 8-8 8s-8-3.6-8-8V296 152c0-13.3 10.7-24 24-24zm88 160c39.8 0 72-32.2 72-72s-32.2-72-72-72H152c-4.4 0-8 3.6-8 8V288h96z"],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256.3 91.8c-43 0-84.1-5.5-121.5-15.4c-3.9-1-7.1 .3-8.7 1.8c-.7 .7-.9 1.2-.9 1.4l0 0c0 .1-.1 .7 .5 1.9c25 46.8 74.1 78.5 130.5 78.5s105.5-31.7 130.5-78.5c.7-1.2 .6-1.8 .5-1.9l0 0c0-.2-.2-.7-.9-1.4c-1.6-1.5-4.8-2.8-8.7-1.8c-37.4 9.9-78.4 15.4-121.5 15.4zm144.6-2.7C373.2 396.8 318.8 432 256.3 432s-116.9-35.2-144.6-86.9c-9.1-17 8.7-33.1 27.3-28.2c36 9.6 75.6 14.9 117.3 14.9s81.4-5.3 117.3-14.9c18.6-4.9 36.4 11.2 27.3 28.2zM160 112c3.1 0 5.9 1.8 7.2 4.6l21.2 44.4 48.7 6.4c3.1 .4 5.6 2.5 6.6 5.5s.1 6.2-2.1 8.3l-35.7 33.8 9 48.3c.6 3-.7 6.1-3.2 7.9s-5.8 2-8.5 .6L160 248.3l-43.2 23.5c-2.7 1.5-6 1.3-8.5-.6s-3.7-4.9-3.2-7.9l9-48.3L78.4 181.1c-2.2-2.1-3.1-5.3-2.1-8.3s3.5-5.1 6.6-5.5l48.7-6.4 21.2-44.4c1.3-2.8 4.1-4.6 7.2-4.6zm0 26.6l-15.8 33.2c-1.2 2.4-3.5 4.1-6.2 4.5L101.6 181l26.6 25.3c2 1.9 2.9 4.6 2.4 7.3l-6.7 36.1 32.3-17.5c2.4-1.3 5.3-1.3 7.6 0l32.3 17.5-6.7-36.1c-.5-2.7 .4-5.4 2.4-7.3L218.4 181 182 176.2c-2.7-.4-5-2-6.2-4.5L160 138.6zm199.2-22l21.2 44.4 48.7 6.4c3.1 .4 5.6 2.5 6.6 5.5s.1 6.2-2.1 8.3l-35.7 33.8 9 48.3c.6 3-.7 6.1-3.2 7.9s-5.8 2-8.5 .6L352 248.3l-43.2 23.5c-2.7 1.5-6 1.3-8.5-.6s-3.7-4.9-3.2-7.9l9-48.3-35.7-33.8c-2.2-2.1-3.1-5.3-2.1-8.3s3.5-5.1 6.6-5.5l48.7-6.4 21.2-44.4c1.3-2.8 4.1-4.6 7.2-4.6s5.9 1.8 7.2 4.6zm-23 55.2c-1.2 2.4-3.5 4.1-6.2 4.5L293.6 181l26.6 25.3c2 1.9 2.9 4.6 2.4 7.3l-6.7 36.1 32.3-17.5c2.4-1.3 5.3-1.3 7.6 0l32.3 17.5-6.7-36.1c-.5-2.7 .4-5.4 2.4-7.3L410.4 181 374 176.2c-2.7-.4-5-2-6.2-4.5L352 138.6l-15.8 33.2z"],
    "sigma": [384, 512, [8721], "f68b", "M.7 36.7C2 33.8 4.8 32 8 32H352c17.7 0 32 14.3 32 32v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V64c0-8.8-7.2-16-16-16H25.8L206 250.7c2.7 3 2.7 7.6 0 10.6L25.8 464H352c8.8 0 16-7.2 16-16V384c0-4.4 3.6-8 8-8s8 3.6 8 8v64c0 17.7-14.3 32-32 32H8c-3.2 0-6-1.8-7.3-4.7s-.8-6.2 1.3-8.6L189.3 256 2 45.3C-.1 43-.6 39.6 .7 36.7z"],
    "camera-movie": [576, 512, [127909, 127910], "f8a9", "M16 128C16 66.1 66.1 16 128 16c47.6 0 88.4 29.7 104.5 71.7c1.2 3.1 4.2 5.1 7.5 5.1s6.3-2 7.5-5.1C263.6 45.7 304.4 16 352 16c61.9 0 112 50.1 112 112s-50.1 112-112 112H128C66.1 240 16 189.9 16 128zM128 0C57.3 0 0 57.3 0 128s57.3 128 128 128H352c70.7 0 128-57.3 128-128S422.7 0 352 0c-48.2 0-90.2 26.6-112 66C218.2 26.6 176.2 0 128 0zM536.5 512c21.8 0 39.5-17.7 39.5-39.5V291.9c0-23-20.6-40.4-43.3-36.6c-3.2 .5-6.2 1.5-9.1 2.8L448 292v17.5l82.2-37c1.7-.7 3.4-1.3 5.2-1.6c12.9-2.1 24.6 7.8 24.6 20.9V472.5c0 13-10.5 23.5-23.5 23.5c-3.3 0-6.6-.7-9.7-2.1L448 458.5V476l72.3 32.5c5.1 2.3 10.6 3.5 16.2 3.5zM64 336H32c-8.8 0-16-7.2-16-16s7.2-16 16-16H64h64H352c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H128c-26.5 0-48-21.5-48-48V352c0-8.8-7.2-16-16-16zM48 352H64v16 80c0 35.3 28.7 64 64 64H352c35.3 0 64-28.7 64-64V352c0-35.3-28.7-64-64-64H128 64 32c-17.7 0-32 14.3-32 32s14.3 32 32 32H48zM128 80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm176-64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "bong": [448, 512, [], "f55c", "M128 199.1c0 12.7-7.4 23.5-17.8 29C72.9 247.7 43.5 280.4 28 320H356c-15.5-39.6-44.9-72.3-82.2-91.9c-10.4-5.4-17.8-16.3-17.8-29V16H128V199.1zM272 16V199.1c0 6.3 3.7 11.9 9.2 14.8c21.6 11.4 40.8 26.7 56.5 45.1c.2-.2 .4-.5 .6-.7L396.7 200l-26.3-26.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l32 32 32 32c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L408 211.3l-58.3 58.3c-.7 .7-1.4 1.2-2.2 1.6c23 31.7 36.6 70.6 36.6 112.8c0 39.4-11.9 76.1-32.2 106.5c-9.6 14.4-26.5 21.5-43.8 21.5H76.1c-17.3 0-34.2-7.1-43.8-21.5l13.3-8.9c6 9 17.3 14.3 30.5 14.3H307.9c13.3 0 24.5-5.4 30.5-14.3C357.1 453.7 368 420.2 368 384c0-16.7-2.3-32.8-6.7-48.1c-.4 .1-.9 .1-1.3 .1H24c-.5 0-.9 0-1.3-.1C18.3 351.2 16 367.3 16 384c0 36.2 10.9 69.7 29.6 97.7l-13.3 8.9C11.9 460.1 0 423.4 0 384c0-73.8 41.7-137.9 102.8-170.1c5.5-2.9 9.2-8.5 9.2-14.8V16L88 16c-4.4 0-8-3.6-8-8s3.6-8 8-8h40H256h40c4.4 0 8 3.6 8 8s-3.6 8-8 8H272z"],
    "clarinet": [640, 512, [], "f8ad", "M224 136c0-4.4 3.6-8 8-8h32H368 472h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H480v48h79.5c4.2 0 8.3-1.1 11.9-3.2l47.2-27c2.2-1.2 4.6-1.9 7.1-1.9c7.9 0 14.3 6.4 14.3 14.3V369.7c0 7.9-6.4 14.3-14.3 14.3c-2.5 0-4.9-.6-7.1-1.9l-47.2-27c-3.6-2.1-7.7-3.2-11.9-3.2H101.6c-4.7 0-9.3-.8-13.7-2.4L5.3 319.5C2.1 318.4 0 315.4 0 312V232c0-3.4 2.1-6.4 5.3-7.5L88 194.4c4.4-1.6 9-2.4 13.7-2.4H256V144H232c-4.4 0-8-3.6-8-8zm240 8H376v48h88V144zm-104 0H272v48h88V144zM101.6 208c-2.8 0-5.6 .5-8.2 1.4L16 237.6v68.8l77.4 28.2c2.6 1 5.4 1.4 8.2 1.4H559.5c7 0 13.8 1.8 19.8 5.3L624 366.8V177.2l-44.7 25.5c-6 3.5-12.9 5.3-19.8 5.3H472 368 264 101.6zM272 256a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm112-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "truck-flatbed": [640, 512, [], "e2b6", "M400 120c0-13.3 10.7-24 24-24h50.7c10.6 0 20.8 4.2 28.3 11.7L596.3 201c7.5 7.5 11.7 17.7 11.7 28.3V400h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H575.6c.2 2.6 .4 5.3 .4 8c0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8H239.6c.2 2.6 .4 5.3 .4 8c0 48.6-39.4 88-88 88s-88-39.4-88-88c0-2.7 .1-5.4 .4-8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H67.3c10.4-36.9 44.4-64 84.7-64s74.2 27.1 84.7 64H400V120zm16 253.4c15.9-22.6 42.2-37.4 72-37.4c40.3 0 74.2 27.1 84.7 64H592V232H416V373.4zM416 216H588c-.9-1.3-1.9-2.6-3-3.7L491.7 119c-4.5-4.5-10.6-7-17-7H424c-4.4 0-8 3.6-8 8v96zM152 496a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm408-72a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"],
    "spaghetti-monster-flying": [640, 512, ["pastafarianism"], "f67b", "M192 16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm32.5 103.1C243.4 108 256 87.5 256 64c0-35.3-28.7-64-64-64s-64 28.7-64 64s28.7 64 64 64c6.2 0 12.2-.9 17.8-2.5l12.9 25.9c-25.5 14.1-44.8 32.8-60.7 51.4c-7.7 9-14.6 17.9-20.9 26.1l0 0 0 0-.5 .6c-6.5 8.5-12.5 16.1-18.3 22.6C110.6 265.4 100.8 272 90.1 272c-15.5 0-23.5-11.5-34.3-28.3l-.7-1.1C45.4 227.5 32.9 208 8 208c-4.4 0-8 3.6-8 8s3.6 8 8 8c15.5 0 23.5 11.5 34.3 28.3l.7 1.1c9.6 15 22.1 34.5 47.1 34.5c18 0 31.9-11.4 44.2-25.2l.3-.3c1.6 2.8 3.5 6.1 5.7 9.7c6.6 10.7 16.1 24.4 28.7 38.5c-3.6 9.6-6.5 19.4-9.3 28.6l0 0 0 0 0 0 0 0 0 0-1.3 4.3c-3.4 11.1-6.6 21.2-10.6 29.9c-4 8.6-8.5 15.1-14 19.5c-5.3 4.3-12.1 6.9-21.7 6.9c-13.3 0-26.8-6.4-43.5-14.3l-2.1-1C49.5 376.8 30 368 8 368c-4.4 0-8 3.6-8 8s3.6 8 8 8c18 0 34.5 7.2 51.6 15.2l3.3 1.6C78.3 408.1 95 416 112 416c12.9 0 23.3-3.7 31.7-10.4c8.2-6.6 14-15.6 18.5-25.3c4.5-9.7 8-20.8 11.4-31.9L175 344l0 0c2-6.8 4.1-13.5 6.4-20.2c21.5 21.2 50 41.8 85.8 52.5c-5.6 17.9-17.3 47.4-33.3 72.9c-8.4 13.4-17.8 25.3-27.8 33.7s-20.1 13-30.1 13c-4.4 0-8 3.6-8 8s3.6 8 8 8c15.1 0 28.7-6.9 40.4-16.8s22.1-23.3 31-37.4c17.1-27.3 29.5-58.7 35.3-77.5c11.7 2.4 24.2 3.8 37.3 3.8s25.6-1.3 37.3-3.8c5.8 18.8 18.1 50.2 35.3 77.5c8.9 14.1 19.3 27.5 31 37.4s25.3 16.8 40.4 16.8c4.4 0 8-3.6 8-8s-3.6-8-8-8c-10 0-20.1-4.6-30.1-13s-19.4-20.4-27.8-33.7c-16-25.5-27.7-55-33.3-72.9c35.8-10.7 64.3-31.3 85.8-52.5c2.3 6.7 4.3 13.4 6.4 20.2l0 0 1.3 4.4c3.4 11.1 6.9 22.2 11.4 31.9c4.5 9.8 10.3 18.8 18.5 25.3c8.4 6.7 18.8 10.4 31.7 10.4c17 0 33.7-7.9 49.1-15.2l3.3-1.6C597.5 391.2 614 384 632 384c4.4 0 8-3.6 8-8s-3.6-8-8-8c-22 0-41.5 8.8-58.4 16.8l-2.1 1C554.8 393.6 541.3 400 528 400c-9.6 0-16.4-2.7-21.7-6.9c-5.5-4.4-10-10.9-14-19.5c-4-8.6-7.2-18.7-10.6-29.9l-1.3-4.3 0 0c-2.8-9.2-5.8-19-9.3-28.6c12.5-14.2 22-27.9 28.7-38.5c2.2-3.6 4.2-6.9 5.7-9.7l.3 .3C518 276.6 531.9 288 549.9 288c24.9 0 37.4-19.5 47.1-34.5l.7-1.1C608.5 235.5 616.5 224 632 224c4.4 0 8-3.6 8-8s-3.6-8-8-8c-24.9 0-37.4 19.5-47 34.5l-.7 1.1c-10.8 16.8-18.8 28.3-34.3 28.3c-10.7 0-20.5-6.6-32.3-19.8c-5.8-6.5-11.7-14.1-18.3-22.6l-.5-.6 0 0 0 0 0 0c-6.4-8.2-13.3-17.2-20.9-26.1c-15.9-18.6-35.2-37.4-60.7-51.4l12.9-25.9c5.7 1.6 11.6 2.5 17.8 2.5c35.3 0 64-28.7 64-64s-28.7-64-64-64s-64 28.7-64 64c0 23.5 12.6 44 31.5 55.1l-12.6 25.1c-22.7-10-49.8-16.3-82.9-16.3s-60.3 6.3-82.9 16.3l-12.6-25.1zM448 16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM145.8 249.8l-.3-.5c2.6-3.2 5.1-6.6 7.7-9.9l.4-.5 0 0 0 0c6.4-8.3 13.1-17 20.5-25.6c29.9-34.9 71-69.2 145.8-69.2s115.9 34.3 145.8 69.2c7.4 8.6 14.1 17.3 20.5 25.6l.4 .5c2.6 3.4 5.2 6.7 7.7 9.9l-.3 .5c-1.8 3.4-4.5 8.2-8.1 14c-7.2 11.7-18.2 27.2-32.9 42.7C423.8 337.6 379.8 368 320 368s-103.8-30.4-133.2-61.5c-14.7-15.5-25.6-31.1-32.9-42.7c-3.6-5.8-6.3-10.7-8.1-14zM208 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM448 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "arrow-down-up-across-line": [576, 512, [], "e4af", "M154.3 509.7c3.1 3.1 8.2 3.1 11.3 0l96-96c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L168 484.7V264H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H424V27.3l82.3 82.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-96-96c-3.1-3.1-8.2-3.1-11.3 0l-96 96c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L408 27.3V248H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H152V484.7L69.7 402.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l96 96zM152 192h16V40c0-4.4-3.6-8-8-8s-8 3.6-8 8V192zM424 320H408V472c0 4.4 3.6 8 8 8s8-3.6 8-8V320z"],
    "leaf-heart": [512, 512, [], "f4cb", "M272 112c-88.4 0-160 71.6-160 160s71.6 160 160 160h0l.9 0C393.5 431.4 496 311.3 496 156.6c0-35.1-5.3-68.5-15-99.3C457.8 90.3 419.5 112 376 112l-104 0zm1 336l-1 0c-97.1 0-175.9-78.7-176-175.8C47.7 305.4 16 361 16 424v48c0 4.4-3.6 8-8 8s-8-3.6-8-8V424c0-72.8 38.9-136.5 97.1-171.5C106.8 164.5 181.4 96 272 96l104 0c42.7 0 79.9-23.9 98.8-59.1c3.5-6.5 13.6-6.8 16.2 .1c13.5 36.5 21.1 77 21.1 119.6C512 317.1 405.1 447.3 273 448zM204.6 240.6c0 9.3 3.6 18.3 10 25.1l67.6 71.7c1.5 1.6 3.6 2.5 5.8 2.5s4.3-.9 5.8-2.5l67.6-71.7c6.4-6.8 10-15.8 10-25.1c0-20.2-16.4-36.6-36.6-36.6h-.6c-9.7 0-19 3.8-26 10.5l-14.6 14.2c-3.1 3-8 3-11.2 0l-14.6-14.2c-7-6.8-16.3-10.5-26-10.5h-.6c-20.2 0-36.6 16.4-36.6 36.6zM241.2 188h.6c13.9 0 27.2 5.4 37.1 15.1l9 8.8 9-8.8c9.9-9.7 23.3-15.1 37.1-15.1h.6c29.1 0 52.6 23.6 52.6 52.6c0 13.4-5.1 26.3-14.3 36.1l-67.6 71.7c-4.5 4.8-10.9 7.5-17.5 7.5s-12.9-2.7-17.5-7.5l-67.6-71.7c-9.2-9.8-14.3-22.7-14.3-36.1c0-29.1 23.6-52.6 52.6-52.6z"],
    "house-building": [640, 512, [], "e1b1", "M384 16H576c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H409.3c-2.5 5.7-5.6 11.1-9.3 16H576c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H384c-35.3 0-64 28.7-64 64v89.9l16 14.7V64c0-26.5 21.5-48 48-48zm32 272h24c13.3 0 24-10.7 24-24V232c0-13.3-10.7-24-24-24H408c-7.7 0-14.5 3.6-18.9 9.2l1 .9c3.8 3.5 7.3 7.3 10.3 11.5c1-3.2 4.1-5.6 7.6-5.6h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H415.8c.1 1.7 .2 3.4 .2 5.1V288zm0 112h24c13.3 0 24-10.7 24-24V344c0-13.3-10.7-24-24-24H416v16h24c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H416v16zM520 208c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V232c0-13.3-10.7-24-24-24H520zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H520c-4.4 0-8-3.6-8-8V232zM496 344v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V344c0-13.3-10.7-24-24-24H520c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H520c-4.4 0-8-3.6-8-8V344c0-4.4 3.6-8 8-8zM408 96c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V120c0-13.3-10.7-24-24-24H408zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H408c-4.4 0-8-3.6-8-8V120zm96 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V120c0-13.3-10.7-24-24-24H520c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H520c-4.4 0-8-3.6-8-8V120c0-4.4 3.6-8 8-8zM16 280.6c0-11.2 4.7-21.9 13-29.5L165 126.5c15.3-14 38.8-14 54.1 0L355 251.1c8.3 7.6 13 18.3 13 29.5V456c0 22.1-17.9 40-40 40H56c-22.1 0-40-17.9-40-40V280.6zM0 456c0 30.9 25.1 56 56 56H328c30.9 0 56-25.1 56-56V280.6c0-15.7-6.6-30.7-18.2-41.3l-136-124.7c-21.4-19.6-54.3-19.6-75.7 0L18.2 239.4C6.6 250 0 264.9 0 280.6V456zM224 280c4.4 0 8 3.6 8 8v64c0 4.4-3.6 8-8 8H160c-4.4 0-8-3.6-8-8V288c0-4.4 3.6-8 8-8h64zm-64-16c-13.3 0-24 10.7-24 24v64c0 13.3 10.7 24 24 24h64c13.3 0 24-10.7 24-24V288c0-13.3-10.7-24-24-24H160z"],
    "cheese-swiss": [512, 512, [129472], "f7f0", "M495.9 240H403.8c-8.8-9.8-21.6-16-35.8-16s-27 6.2-35.8 16H27.3l141-101.9c-.2 1.9-.4 3.9-.4 5.9c0 26.5 21.5 48 48 48s48-21.5 48-48c0-23.3-16.6-42.7-38.6-47.1l64.9-46.9c1.9-1.3 4.1-2.1 6.4-2.1C404.3 48 492 133.3 495.9 240zM16 256H322.7c-1.8 5-2.7 10.4-2.7 16c0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1-11-2.7-16H496V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V256.4l0-.4zm320 16a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm176-16v-8.7C512 128.4 415.6 32 296.7 32c-5.7 0-11.2 1.8-15.8 5.1L13.3 230.4C4.9 236.4 0 246.1 0 256.4V416c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V256zM176 336a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm8-272a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "spoon": [512, 512, [129348, 61873, "utensil-spoon"], "f2e5", "M263.4 216.6l32 32c15.6 15.6 36 23.4 56.4 23.4c33.8 0 69.7-20.5 97.8-54.2c28-33.5 46.3-78 46.3-121.8c0-44.2-35.8-80-80-80c-43.7 0-88.2 18.3-121.8 46.3C260.5 90.5 240 126.4 240 160.2c0 20.4 7.8 40.8 23.4 56.4zm-11.3 11.3c-18.7-18.7-28.1-43.2-28.1-67.7C224 80 320 0 416 0c53 0 96 43 96 96c0 96-80 192-160.2 192c-24.5 0-49-9.4-67.7-28.1l-10.3-10.3L13.7 509.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L262.5 238.2l-10.3-10.3z"],
    "jar-wheat": [320, 512, [], "e517", "M240 16c8.8 0 16 7.2 16 16V64H64V32c0-8.8 7.2-16 16-16H240zM48 64v2C20.4 73.1 0 98.2 0 128V448c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64V128c0-29.8-20.4-54.9-48-62V64 32c0-17.7-14.3-32-32-32H80C62.3 0 48 14.3 48 32V64zM64 80H256c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V128c0-26.5 21.5-48 48-48zM192 208H168c0-35.3 28.7-64 64-64h24c0 35.3-28.7 64-64 64zm-32-34.9C147 146.4 119.7 128 88 128l-24 0c-8.8 0-16 7.2-16 16c0 44.2 35.8 80 80 80h24 16 24c44.2 0 80-35.8 80-80c0-8.8-7.2-16-16-16H232c-31.7 0-59 18.4-72 45.1zM152 208H128c-35.3 0-64-28.7-64-64H88c35.3 0 64 28.7 64 64zm16 104c0-35.3 28.7-64 64-64h24c0 35.3-28.7 64-64 64H168zM88 232H64c-8.8 0-16 7.2-16 16c0 44.2 35.8 80 80 80h24 16 24c44.2 0 80-35.8 80-80c0-8.8-7.2-16-16-16H232c-31.7 0-59 18.4-72 45.1C147 250.4 119.7 232 88 232zm40 80c-35.3 0-64-28.7-64-64H88c35.3 0 64 28.7 64 64H128zm64 104H168c0-35.3 28.7-64 64-64h24c0 35.3-28.7 64-64 64zm-24 16h24c44.2 0 80-35.8 80-80c0-8.8-7.2-16-16-16H232c-31.7 0-59 18.4-72 45.1C147 354.4 119.7 336 88 336H64c-8.8 0-16 7.2-16 16c0 44.2 35.8 80 80 80h24v24c0 4.4 3.6 8 8 8s8-3.6 8-8V432zM88 352c35.3 0 64 28.7 64 64H128c-35.3 0-64-28.7-64-64H88z"],
    "envelopes-bulk": [640, 512, ["mail-bulk"], "f674", "M432 16c17.7 0 32 14.3 32 32V80h16V48c0-26.5-21.5-48-48-48H112C85.5 0 64 21.5 64 48V192H80V48c0-17.7 14.3-32 32-32H432zM240 128H592c17.7 0 32 14.3 32 32V368c0 17.7-14.3 32-32 32H416v16H592c26.5 0 48-21.5 48-48V160c0-26.5-21.5-48-48-48H240c-26.5 0-48 21.5-48 48v32h16V160c0-17.7 14.3-32 32-32zM16 272c0-17.7 14.3-32 32-32H336c17.7 0 32 14.3 32 32v19.1l-4.8 3.5L201.7 414.3c-2.8 2.1-6.2 3.2-9.7 3.2s-6.9-1.1-9.7-3.2L20.8 294.6 16 291.1V272zM211.2 427.1L368 311V464c0 17.7-14.3 32-32 32H48c-17.7 0-32-14.3-32-32V311L172.8 427.1c5.6 4.1 12.3 6.3 19.2 6.3s13.6-2.2 19.2-6.3zM0 272V464c0 26.5 21.5 48 48 48H336c26.5 0 48-21.5 48-48V272c0-26.5-21.5-48-48-48H48c-26.5 0-48 21.5-48 48zm528-96c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V200c0-13.3-10.7-24-24-24H528zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H528c-4.4 0-8-3.6-8-8V200z"],
    "file-circle-exclamation": [576, 512, [], "e4eb", "M64 496H311.2c5.8 5.5 12 10.6 18.5 15.3c-3.2 .5-6.4 .7-9.7 .7H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H204.1c12.7 0 24.9 5.1 33.9 14.1L369.9 145.9c9 9 14.1 21.2 14.1 33.9v18.7c-5.4 1.5-10.8 3.3-16 5.4V179.9c0-1.3-.1-2.6-.2-3.9H248c-22.1 0-40-17.9-40-40V16.2c-1.3-.2-2.6-.2-3.9-.2H64C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48zM361.1 160c-.8-1-1.6-1.9-2.4-2.7L226.7 25.4c-.9-.9-1.8-1.7-2.7-2.4V136c0 13.3 10.7 24 24 24H361.1zM560 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0-136c4.4 0 8 3.6 8 8v96c0 4.4-3.6 8-8 8s-8-3.6-8-8V288c0-4.4 3.6-8 8-8z"],
    "bow-arrow": [512, 512, [127993], "f6b9", "M511.9 9.3c.4-2.5-.4-5.1-2.2-7s-4.4-2.7-7-2.2l-144 24c-3 .5-5.4 2.6-6.3 5.4s-.2 6 2 8.1L408.7 92 162.3 338.3c-1.4-.7-2.9-1.2-4.5-1.6l-64-16c-8.2-2-16.8 .4-22.8 6.3L7 391c-6.1 6.1-8.5 15-6.2 23.4s8.9 14.8 17.3 16.9l50 12.5 12.5 50c2.1 8.4 8.5 15 16.9 17.3s17.3 0 23.4-6.2l64-64c6-6 8.4-14.6 6.3-22.8l-16-64c-.4-1.6-.9-3.1-1.6-4.5L420 103.3l54.3 54.3c2.1 2.1 5.2 2.9 8.1 2s5-3.3 5.4-6.3l24-144zm-37.2 126l-98-98L494.3 17.7 474.7 135.4zM192 64C132.3 64 77.5 84.4 33.9 118.6L21.7 106.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L174.1 281.4l11.3-11.3L45.3 130C85.9 98.7 136.8 80 192 80c51.8 0 99.8 16.4 139.1 44.4l11.5-11.5C300.3 82.1 248.3 64 192 64zM387.6 180.9C415.6 220.2 432 268.2 432 320c0 55.2-18.7 106.1-50 146.7l-140-140-11.3 11.3L394.3 501.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-12.3-12.3C427.6 434.5 448 379.7 448 320c0-56.3-18.1-108.3-48.9-150.5l-11.5 11.5zM83.7 439.9c-1.4-5.7-5.9-10.2-11.6-11.6l-50-12.5c-2.8-.7-5-2.8-5.8-5.6s0-5.8 2.1-7.8l64-64c2-2 4.9-2.8 7.6-2.1l64 16c2.9 .7 5.1 3 5.8 5.8l16 64c.7 2.7-.1 5.6-2.1 7.6l-64 64c-2 2-5 2.8-7.8 2.1s-4.9-3-5.6-5.8l-12.5-50z"],
    "cart-xmark": [576, 512, [], "e0dd", "M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8H45.7C57.1 16 67 24.1 69.2 35.4l59.4 303.4c5.1 26.3 28.2 45.2 55 45.2H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H183.5c-19.1 0-35.6-13.5-39.3-32.3L134.9 288h339c26 0 48.6-17.9 54.5-43.3L575.8 41.8c1-4.3-1.7-8.6-6-9.6s-8.6 1.7-9.6 6L512.9 241.1c-4.2 18.1-20.4 30.9-39 30.9H131.8L84.9 32.3C81.2 13.5 64.8 0 45.7 0H8zM144 464a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm240-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM257.8 81.8c-3.1 3.1-3.1 8.2 0 11.3L308.7 144l-50.9 50.9c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L320 155.3l50.9 50.9c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L331.3 144l50.9-50.9c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L320 132.7 269.1 81.8c-3.1-3.1-8.2-3.1-11.3 0z"],
    "hexagon-xmark": [512, 512, ["times-hexagon", "xmark-hexagon"], "f2ee", "M400.8 450.8l0 0L497.1 284c2.5-4.3 4.4-8.9 5.6-13.6c2-7.7 2.4-15.7 1.1-23.6c-1.1-6.5-3.3-12.9-6.7-18.8L400.8 61.2c-10-17.3-28.5-28-48.5-28H159.7c-20 0-38.5 10.7-48.5 28L14.9 228c-3.9 6.7-6.3 14.1-7.1 21.6c-1.4 11.8 1 23.9 7.1 34.4l96.3 166.8c10 17.3 28.5 28 48.5 28H352.3c20 0 38.5-10.7 48.5-28zM483.2 236c2.7 4.6 4.4 9.7 5 14.8l-2.7 20.4c-.7 1.6-1.4 3.2-2.3 4.8L386.9 442.8c-7.1 12.4-20.4 20-34.6 20H159.7c-14.3 0-27.5-7.6-34.6-20L28.8 276c-3.6-6.2-5.4-13.1-5.4-20c0-3.4 .4-6.8 1.3-10.1c.9-3.4 2.2-6.8 4.1-9.9L125.1 69.2c7.1-12.4 20.4-20 34.6-20l192.6 0c14.3 0 27.5 7.6 34.6 20L483.2 236zM178.3 178.3c-3.1 3.1-3.1 8.2 0 11.3L244.7 256l-66.3 66.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L256 267.3l66.3 66.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L267.3 256l66.3-66.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L256 244.7l-66.3-66.3c-3.1-3.1-8.2-3.1-11.3 0z"],
    "circle-h": [512, 512, [9405, "hospital-symbol"], "f47e", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm80-376V248H176V136c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 240c0 4.4 3.6 8 8 8s8-3.6 8-8l0-112H336V376c0 4.4 3.6 8 8 8s8-3.6 8-8V256 136c0-4.4-3.6-8-8-8s-8 3.6-8 8z"],
    "merge": [512, 512, [], "e526", "M0 72c0-4.4 3.6-8 8-8H96h47.3c13.1 0 25.4 6.4 32.8 17.2L285 237.7c4.5 6.4 11.8 10.3 19.7 10.3H480h4.7l-66.3-66.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l80 80c3.1 3.1 3.1 8.2 0 11.3l-80 80c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L484.7 264H480 304.7c-7.9 0-15.2 3.8-19.7 10.3L176.1 430.8c-7.5 10.7-19.7 17.2-32.8 17.2H96 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H96h47.3c7.9 0 15.2-3.8 19.7-10.3L271.9 265.2c2.5-3.6 5.5-6.6 8.8-9.2c-3.4-2.5-6.4-5.6-8.8-9.2L163 90.3C158.5 83.8 151.1 80 143.3 80H96 8c-4.4 0-8-3.6-8-8z"],
    "pager": [512, 512, [128223], "f815", "M448 80c26.5 0 48 21.5 48 48V384c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V128c0-26.5 21.5-48 48-48H448zM64 64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H64zm0 264c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H72c-4.4 0-8 3.6-8 8zm128 0c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H200c-4.4 0-8 3.6-8 8zM96 144H416c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V160c0-8.8 7.2-16 16-16zM64 160v64c0 17.7 14.3 32 32 32H416c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H96c-17.7 0-32 14.3-32 32z"],
    "cart-minus": [576, 512, [], "e0db", "M0 8C0 3.6 3.6 0 8 0H45.7C64.8 0 81.2 13.5 84.9 32.3L131.8 272H473.9c18.6 0 34.7-12.8 39-30.9L560.2 38.2c1-4.3 5.3-7 9.6-6s7 5.3 6 9.6L528.4 244.7c-5.9 25.3-28.5 43.3-54.5 43.3h-339l9.3 47.7c3.7 18.8 20.1 32.3 39.3 32.3H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H183.5c-26.8 0-49.8-19-55-45.2L69.2 35.4C67 24.1 57.1 16 45.7 16H8c-4.4 0-8-3.6-8-8zM176 496a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm320 48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM240 128H400c4.4 0 8 3.6 8 8s-3.6 8-8 8H240c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M96 16C69.5 16 48 37.5 48 64V448c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H96zM32 64C32 28.7 60.7 0 96 0H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V64zM288 192a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-112 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm24 112c-30.9 0-56 25.1-56 56c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-39.8 32.2-72 72-72h80c39.8 0 72 32.2 72 72c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-30.9-25.1-56-56-56H200zM504 80v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V80c0-4.4 3.6-8 8-8s8 3.6 8 8zm-8 120c4.4 0 8 3.6 8 8v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V208c0-4.4 3.6-8 8-8zm8 136v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V336c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "pan-frying": [576, 512, [127859], "e42c", "M224 432C109.1 432 16 338.9 16 224S109.1 16 224 16s208 93.1 208 208c0 28.4-5.7 55.4-16 80l-.4 .9c-2 4.7-4.1 9.2-6.4 13.7c-9.9 19.3-22.7 36.8-37.8 52.1l-.3 .3c-3.7 3.7-7.5 7.2-11.4 10.6C323.3 413 275.8 432 224 432zm0 16c56 0 107.3-20.6 146.5-54.6l89.6 97.1c12.6 13.7 30.4 21.5 49.1 21.5c36.9 0 66.8-30.3 66.8-67.2c0-22.8-11.5-44.3-30.7-56.8L429.7 312.9C441.5 285.6 448 255.6 448 224C448 100.3 347.7 0 224 0S0 100.3 0 224S100.3 448 224 448zm247.9 31.7l-89.7-97.1c16.1-16.1 29.8-34.7 40.5-55.1l113.9 74c14.5 9.5 23.4 25.9 23.4 43.3c0 28.2-22.9 51.2-50.8 51.2c-14.2 0-27.7-5.9-37.3-16.3zM496 448a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM323.9 138.5c-8.7-2.2-20-7.1-31-13.6s-20.9-13.8-27.1-20.3c-30.6-31.9-81.3-32.9-113.1-2.2c-14.5 13.9-22.6 32.1-24.3 50.7c-2.1 23.5-8.7 52.4-19.4 71C82.4 269.9 98.1 328.6 144 355.1s104.6 10.8 131.1-35.1c2.9-5.1 8.9-10.9 16.9-15.8c7.9-4.9 16.4-8 23.1-9c12.8-1.8 25.4-6.7 36.5-15c35.5-26.3 42.9-76.4 16.6-111.9c-11.4-15.3-27.2-25.5-44.4-29.8zm-4 15.5c13.7 3.5 26.4 11.6 35.5 23.9c21 28.4 15.1 68.5-13.3 89.5c-8.9 6.6-18.9 10.5-29.2 12c-18.6 2.6-42.2 16.3-51.6 32.6c-22.1 38.3-71 51.4-109.3 29.3s-51.4-71-29.3-109.3c12.4-21.4 19.4-53 21.5-77.6c1.3-14.9 7.8-29.4 19.4-40.5c25.5-24.5 66-23.7 90.5 1.8c15.2 15.8 44.5 32.9 65.8 38.4zM184 224a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"],
    "grid": [448, 512, ["grid-3"], "e195", "M88 48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V72c0-13.3 10.7-24 24-24H88zM40 32C17.9 32 0 49.9 0 72v48c0 22.1 17.9 40 40 40H88c22.1 0 40-17.9 40-40V72c0-22.1-17.9-40-40-40H40zM88 208c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V232c0-13.3 10.7-24 24-24H88zM40 192c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40H88c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40H40zm0 176H88c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V392c0-13.3 10.7-24 24-24zM0 392v48c0 22.1 17.9 40 40 40H88c22.1 0 40-17.9 40-40V392c0-22.1-17.9-40-40-40H40c-22.1 0-40 17.9-40 40zM248 48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H200c-13.3 0-24-10.7-24-24V72c0-13.3 10.7-24 24-24h48zM200 32c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V72c0-22.1-17.9-40-40-40H200zm0 176h48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H200c-13.3 0-24-10.7-24-24V232c0-13.3 10.7-24 24-24zm-40 24v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40H200c-22.1 0-40 17.9-40 40zm88 136c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H200c-13.3 0-24-10.7-24-24V392c0-13.3 10.7-24 24-24h48zm-48-16c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V392c0-22.1-17.9-40-40-40H200zM360 48h48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H360c-13.3 0-24-10.7-24-24V72c0-13.3 10.7-24 24-24zM320 72v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V72c0-22.1-17.9-40-40-40H360c-22.1 0-40 17.9-40 40zm88 136c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H360c-13.3 0-24-10.7-24-24V232c0-13.3 10.7-24 24-24h48zm-48-16c-22.1 0-40 17.9-40 40v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40H360zm0 176h48c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H360c-13.3 0-24-10.7-24-24V392c0-13.3 10.7-24 24-24zm-40 24v48c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V392c0-22.1-17.9-40-40-40H360c-22.1 0-40 17.9-40 40z"],
    "football-helmet": [512, 512, [], "f44f", "M279.1 237c-22.3 2.8-39.1 21.8-39.1 44.3c0 6.9 1.6 13.8 4.7 19.9l38.2 76.4c3.3 6.7 5.1 14 5.1 21.5v.9c0 26.5-21.5 48-48 48h-2.9c-6.5 0-12.9-1.3-18.9-3.9l-93.9-40.2c-6-2.6-12.4-3.9-18.9-3.9h-14c-4.7 0-8.7-2-11-4.9C50.1 356.9 32 308.6 32 256C32 132.3 132.3 32 256 32c104 0 191.4 70.8 216.7 166.9c1.7 6.3-2.8 14.2-12.2 15.4L279.1 237zm183.4-6.8c17.5-2.2 30.2-18.3 25.7-35.3C461.1 91.9 367.4 16 256 16C123.5 16 16 123.5 16 256c0 56.3 19.4 108.1 51.9 149.1c5.7 7.1 14.4 10.9 23.5 10.9h14c4.3 0 8.6 .9 12.6 2.6l93.9 40.2c8 3.4 16.5 5.2 25.2 5.2H240c35.3 0 64-28.7 64-64v-.9c0-9.9-2.3-19.7-6.8-28.6L280 336h52l12.1 57.5C354.1 452.7 405.3 496 465.3 496H473c21.5 0 39-17.5 39-39V392 360c0-22.1-17.9-40-40-40H345l-15.4-73.2 132.9-16.6zM313.7 248.8l15 71.2H272l-13-26c-2-4-3-8.4-3-12.8c0-14.4 10.7-26.6 25.1-28.4l32.6-4.1zM176 320a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm320 16H358.5l-10.1-48H472c13.3 0 24 10.7 24 24v24zm-30.7 96c-49 0-91.4-33.3-103.5-80H496v57c0 12.7-10.3 23-23 23h-7.7z"],
    "hand-love": [512, 512, [], "e1a5", "M192 16c-17.7 0-32 14.3-32 32V335.4c0 3.2-1.9 6.2-4.9 7.4s-6.4 .6-8.7-1.7L86.6 281.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L145.1 430.4c42 42 99 65.6 158.4 65.6H312c81.4 0 147.9-64 151.8-144.4c0-.5 .1-.9 .2-1.4V344 112c0-17.7-14.3-32-32-32s-32 14.3-32 32v72 56 64c0 26.5-21.5 48-48 48c-16.7 0-31.4-8.5-40-21.5c-8.6 12.9-23.3 21.5-40 21.5c-26.5 0-48-21.5-48-48l0-96.1L224 88l0 0V48c0-17.7-14.3-32-32-32zM304 304V240 216l0-8c0-17.7-14.3-32-32-32c-17.6 0-32 14.3-32 31.9V304c0 17.7 14.3 32 32 32s32-14.3 32-32zm16-64v64c0 17.7 14.3 32 32 32s32-14.3 32-32V240c0-17.7-14.3-32-32-32s-32 14.3-32 32zm64-35.8V184 112c0-26.5 21.5-48 48-48s48 21.5 48 48V344v8c0 .8-.1 1.5-.3 2.2C474.4 442.2 401.4 512 312 512h-8.5c-63.7 0-124.7-25.3-169.7-70.3L30.1 337.9c-18.7-18.7-18.7-49.1 0-67.9s49.1-18.7 67.9 0L144 316.1V48c0-26.5 21.5-48 48-48s48 21.5 48 48l0 40 0 84.2c8.5-7.6 19.7-12.2 32-12.2c25.3 0 46 19.5 47.9 44.3c8.5-7.7 19.8-12.3 32.1-12.3c12.3 0 23.5 4.6 32 12.2z"],
    "trees": [640, 512, [], "f724", "M198 19L310 146.5c1.3 1.5 2 3.4 2 5.4c0 4.5-3.6 8.1-8.1 8.1H248c-3.3 0-6.2 2-7.4 5.1s-.4 6.5 2 8.8L341.6 267c1.5 1.4 2.4 3.4 2.4 5.5c0 4.1-3.4 7.5-7.5 7.5H272c-3.3 0-6.2 2-7.4 5.1s-.4 6.5 2 8.8L365.6 387c1.5 1.4 2.4 3.4 2.4 5.5c0 4.2-3.4 7.5-7.5 7.5H235.3 200V200c0-4.4-3.6-8-8-8s-8 3.6-8 8V400H148.7 23.5c-4.1 0-7.5-3.4-7.5-7.5c0-2.1 .9-4.1 2.4-5.5l99.1-93.2c2.4-2.2 3.2-5.7 2-8.8s-4.2-5.1-7.4-5.1H47.5c-4.2 0-7.5-3.4-7.5-7.5c0-2.1 .9-4.1 2.4-5.5l99.1-93.2c2.4-2.2 3.2-5.7 2-8.8s-4.2-5.1-7.4-5.1H80.1c-4.5 0-8.1-3.6-8.1-8.1c0-2 .7-3.9 2-5.4L186 19c3.2-3.6 8.8-3.6 12 0zM148.7 416H184v88c0 4.4 3.6 8 8 8s8-3.6 8-8V416h35.3H360.5c13 0 23.5-10.5 23.5-23.5c0-6.5-2.7-12.7-7.4-17.1L292.2 296h44.3c13 0 23.5-10.5 23.5-23.5c0-6.5-2.7-12.7-7.4-17.1L268.2 176h35.7c13.3 0 24.1-10.8 24.1-24.1c0-5.9-2.1-11.5-6-15.9L210 8.4c-9.6-10.9-26.5-10.9-36.1 0L62 135.9c-3.9 4.4-6 10.1-6 15.9C56 165.2 66.8 176 80.1 176h35.7L31.4 255.4C26.7 259.8 24 266 24 272.5c0 13 10.5 23.5 23.5 23.5H91.8L7.4 375.4C2.7 379.8 0 386 0 392.5c0 13 10.5 23.5 23.5 23.5H148.7zM429.9 8.7l-84 97.4c-2.9 3.3-2.5 8.4 .8 11.3s8.4 2.5 11.3-.8l84-97.4c3.2-3.7 8.9-3.7 12.1-.1L566 146.5c1.3 1.5 2 3.4 2 5.4c0 4.5-3.6 8.1-8.1 8.1H504c-3.3 0-6.2 2-7.4 5.1s-.4 6.5 2 8.8L597.6 267c1.5 1.4 2.4 3.4 2.4 5.5c0 4.1-3.4 7.5-7.5 7.5H528c-3.3 0-6.2 2-7.4 5.1s-.4 6.5 2 8.8L621.6 387c1.5 1.4 2.4 3.4 2.4 5.5c0 4.2-3.4 7.5-7.5 7.5H456V200c0-4.4-3.6-8-8-8s-8 3.6-8 8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V416H616.5c13 0 23.5-10.5 23.5-23.5c0-6.5-2.7-12.7-7.4-17.1L548.2 296h44.3c13 0 23.5-10.5 23.5-23.5c0-6.5-2.7-12.7-7.4-17.1L524.2 176h35.7c13.3 0 24.1-10.8 24.1-24.1c0-5.9-2.1-11.5-6-15.9L466.1 8.5c-9.6-11-26.7-10.9-36.2 .2z"],
    "strikethrough": [512, 512, [], "f0cc", "M113.9 125.9c5.6-30.4 26.3-52.3 57.8-65c31.8-12.9 74.4-16.3 121.9-9.3C308.2 53.8 353.2 62 368 65.8c4.3 1.1 8.6-1.5 9.7-5.8s-1.5-8.6-5.8-9.7c-15.5-3.9-61.1-12.3-76-14.5c-49.3-7.3-95-4-130.3 10.3c-35.5 14.4-60.8 40.2-67.6 77.2l0 0-.1 .4c-2.8 22.3 .6 41.1 9.1 57c8.4 15.8 21.5 28.1 37.1 38.1c25.8 16.5 59.7 27.4 93.8 37.2H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H295.4c-11-3.4-22.2-6.6-33.3-9.7l-2.2-.6c-40.4-11.5-79.3-22.5-107.2-40.4c-14-9-24.8-19.4-31.6-32.1c-6.7-12.5-9.7-27.9-7.3-47.2zM394 336.5c5.8 13 7.8 29 4.1 49.3c-5.6 30.5-26.2 52.4-57.9 65.3c-31.8 12.9-74.4 16.3-121.9 9.3c-24.2-3.7-64.7-16.8-94.7-26.5l0 0 0 0c-6.3-2-12.2-3.9-17.3-5.5c-4.2-1.3-8.7 1-10 5.2s1 8.7 5.2 10c4.8 1.5 10.4 3.3 16.6 5.3l0 0c29.9 9.7 72.2 23.3 97.8 27.3l0 0c49.3 7.3 95 4 130.3-10.3c35.5-14.4 60.8-40.2 67.6-77.2c4.2-22.9 2.1-42.2-5.3-58.7c-1.6-3.5-3.3-6.8-5.3-10H383.5c4.3 5.1 7.8 10.6 10.5 16.5z"],
    "page": [384, 512, [], "e428", "M64 496H320c26.5 0 48-21.5 48-48V138.5c0-12.7-5.1-24.9-14.1-33.9L279.4 30.1c-9-9-21.2-14.1-33.9-14.1H64C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48zm256 16H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H245.5c17 0 33.3 6.7 45.3 18.7l74.5 74.5c12 12 18.7 28.3 18.7 45.3V448c0 35.3-28.7 64-64 64z"],
    "k": [320, 512, [107], "4b", "M317.6 45.7c3.2-3.1 3.2-8.1 .2-11.3s-8.1-3.2-11.3-.2L16 317V40c0-4.4-3.6-8-8-8s-8 3.6-8 8V336 472c0 4.4 3.6 8 8 8s8-3.6 8-8V339.4L124.9 233.3 305.6 476.8c2.6 3.5 7.6 4.3 11.2 1.7s4.3-7.6 1.7-11.2L136.5 222 317.6 45.7z"],
    "diagram-previous": [512, 512, [], "e478", "M496 352c0-26.5-21.5-48-48-48L64 304c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l384 0c26.5 0 48-21.5 48-48V352zm-48-64c35.3 0 64 28.7 64 64v64c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V352c0-35.3 28.7-64 64-64H248V163.3l-50.3 50.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l64-64c3.1-3.1 8.2-3.1 11.3 0l64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L264 163.3V288H448zM512 96v64c0 35.3-28.7 64-64 64H400c-4.4 0-8-3.6-8-8s3.6-8 8-8h48c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96l0 64c0 26.5 21.5 48 48 48h48c4.4 0 8 3.6 8 8s-3.6 8-8 8H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64z"],
    "gauge-min": [512, 512, ["tachometer-alt-slowest"], "f628", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM272 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM208 352a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0c0-35.3-28.7-64-64-64c-18.8 0-35.7 8.1-47.4 21l-108-75.6c-3.6-2.5-8.6-1.7-11.1 2s-1.7 8.6 2 11.1l108 75.6c-4.7 8.9-7.4 19.1-7.4 29.9c0 35.3 28.7 64 64 64s64-28.7 64-64zM160 128a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM416 256a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM384 128a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "folder-grid": [512, 512, [], "e188", "M448 464H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H197.5c12.7 0 24.9 5.1 33.9 14.1l35.9 35.9c9 9 21.2 14.1 33.9 14.1H448c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48zM64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H301.3c-8.5 0-16.6-3.4-22.6-9.4L242.7 50.7c-12-12-28.3-18.7-45.3-18.7H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64zm40-224h48c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V264c0-4.4 3.6-8 8-8zm-24 8v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V264c0-13.3-10.7-24-24-24H104c-13.3 0-24 10.7-24 24zm152-8h48c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H232c-4.4 0-8-3.6-8-8V264c0-4.4 3.6-8 8-8zm-24 8v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V264c0-13.3-10.7-24-24-24H232c-13.3 0-24 10.7-24 24zm200-8c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8V264c0-4.4 3.6-8 8-8h48zm-48-16c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V264c0-13.3-10.7-24-24-24H360z"],
    "eggplant": [512, 512, [], "e16c", "M509.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L460.9 39.7C448.6 29.9 433 24 416 24H304c-13.3 0-24 10.7-24 24v5.8c0 21.3 17.3 38.5 38.5 38.5h10.9c6.4 0 11.6 5.2 11.6 11.6c0 37 30 66.9 66.9 66.9c6.4 0 11.6 5.2 11.6 11.6v10.9c0 21.3 17.3 38.5 38.5 38.5H464c13.3 0 24-10.7 24-24V96c0-17-5.9-32.6-15.7-44.9l37.4-37.4zM304 40H416c30.9 0 56 25.1 56 56V208c0 4.4-3.6 8-8 8h-5.8c-12.5 0-22.5-10.1-22.5-22.5V182.5c0-15.3-12.4-27.6-27.6-27.6c-28.1 0-50.9-22.8-50.9-50.9c0-15.3-12.4-27.6-27.6-27.6H318.5c-12.5 0-22.5-10.1-22.5-22.5V48c0-4.4 3.6-8 8-8zM169.9 139.3c32.9-16 66-32 94.7-52.2c2.5 4.8 5.5 9.2 8.8 13.3c-10.1 7.1-20.5 13.6-31.2 19.7c-20.9 12-44 23.2-66.4 34.1l0 0 0 0 0 0c-14.2 6.9-28.1 13.7-41 20.4c-34.5 18-64.4 37.1-85.7 62.2C28.5 261.2 15.4 292.2 16 335.8C17.3 422.6 88.9 495.9 176.4 496c74.3 .1 139-50.1 189.8-120.2c28-38.6 50.9-82.2 68.2-124.3c5 1.8 10.3 3.1 15.7 3.8C400.8 377 304.5 512.2 176.4 512C79.9 511.9 1.4 431.3 0 336C-1.6 222.5 83.4 181.3 169.9 139.3z"],
    "ram": [640, 512, [128015], "f70a", "M352 48c0-26.5 21.5-48 48-48s48 21.5 48 48V68c8.9-2.6 18.3-4 28-4c12.7 0 24.8 2.4 36 6.7V48c0-26.5 21.5-48 48-48s48 21.5 48 48v8c0 4.4-3.6 8-8 8s-8-3.6-8-8V48c0-17.7-14.3-32-32-32s-32 14.3-32 32V78.6c17.3 10.5 31.1 26.2 39.4 44.8L618.3 158c8.6 5.8 13.7 15.5 13.7 25.9c0 24-26 39.1-46.8 27.2l-9.2-5.3V240c0 53-43 96-96 96h-8c-53 0-96-43-96-96V205.8l-9.2 5.3C346 223 320 207.9 320 183.9c0-10.4 5.1-20 13.7-25.9l50.9-34.7c9.5-21.4 26.4-38.9 47.4-49.2V48c0-17.7-14.3-32-32-32s-32 14.3-32 32v8c0 4.4-3.6 8-8 8s-8-3.6-8-8V48zM304.2 69.9c6.9-5.5 15-9.6 23.9-11.9c.3 5.6 2.1 10.8 5 15.3c-7 1.6-13.4 4.8-18.9 9.2c-6.7 5.3-16.4 4.4-22-2C283.3 70.3 270.4 64 256 64s-27.3 6.3-36.1 16.4c-5.6 6.4-15.3 7.3-22 2C189.7 75.9 179.3 72 168 72c-22.5 0-41.5 15.6-46.6 36.5c-2 8.1-9.8 13.3-18 12c-2.4-.4-4.9-.6-7.4-.6c-26.5 0-48 21.5-48 48c0 4 .5 7.9 1.4 11.6c1.8 7.1-1.5 14.5-8 18C26.3 205.7 16 221.7 16 240s10.3 34.3 25.4 42.4c6.5 3.5 9.8 10.9 8 18C48.5 304.1 48 308 48 312c0 26.5 21.5 48 48 48c2.5 0 5-.2 7.4-.6c8.2-1.3 16 4 18 12c5.1 21 24.1 36.6 46.6 36.6c11.3 0 21.7-3.9 29.8-10.4c6.7-5.3 16.4-4.4 22 2c8.8 10.1 21.7 16.4 36.1 16.4s27.3-6.3 36.1-16.4c5.6-6.4 15.3-7.3 22-2c8.2 6.5 18.5 10.4 29.8 10.4c22.5 0 41.5-15.6 46.6-36.6c2-8.1 9.8-13.3 18-12c2.4 .4 4.9 .6 7.4 .6c3.9 0 7.6-.5 11.2-1.3c7.6 3 15.5 5.4 23.7 6.9c-8.4 5.5-18.1 9-28.5 10.1L397.6 481.2c-4.3 18.1-20.4 30.8-38.9 30.8H344c-22.1 0-40-17.9-40-40V448c0-4.4 3.6-8 8-8s8 3.6 8 8v24c0 13.3 10.7 24 24 24h14.7c11.1 0 20.8-7.7 23.4-18.5l23.4-99.4C397.6 404.6 373.1 424 344 424c-15 0-28.9-5.2-39.8-13.9c-11.7 13.4-29 21.9-48.2 21.9s-36.5-8.5-48.2-21.9C196.9 418.8 183 424 168 424c-29.1 0-53.6-19.4-61.4-45.9L130 477.5c2.6 10.8 12.2 18.5 23.4 18.5H168c13.3 0 24-10.7 24-24V448c0-4.4 3.6-8 8-8s8 3.6 8 8v24c0 22.1-17.9 40-40 40H153.3c-18.6 0-34.7-12.8-38.9-30.8L89.6 375.7C57.3 372.5 32 345.2 32 312c0-5.3 .7-10.5 1.9-15.5C13.7 285.7 0 264.5 0 240s13.7-45.7 33.9-56.5c-1.2-5-1.9-10.2-1.9-15.5c0-35.3 28.7-64 64-64c3.3 0 6.6 .3 9.8 .8C112.7 76.8 137.9 56 168 56c15 0 28.9 5.2 39.8 13.9C219.5 56.5 236.8 48 256 48s36.5 8.5 48.2 21.9zM560 164c0-46.4-37.6-84-84-84s-84 37.6-84 84v76c0 44.2 35.8 80 80 80h8c44.2 0 80-35.8 80-80V164zm16 0v23.4l17.1 9.8c10.2 5.8 22.9-1.5 22.9-13.3c0-5.1-2.5-9.8-6.7-12.6l-34.6-23.6c.9 5.3 1.3 10.8 1.3 16.3zM377.3 147.7l-34.6 23.6c-4.2 2.8-6.7 7.6-6.7 12.6c0 11.7 12.7 19.1 22.9 13.3l17.1-9.8V164c0-5.6 .5-11 1.3-16.3zM448 176a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "landmark-flag": [512, 512, [], "e51c", "M352 16V80H256V40 16h96zM256 96h96c8.8 0 16-7.2 16-16V16c0-8.8-7.2-16-16-16H256c-8.8 0-16 7.2-16 16V56 80 96v48H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H472c4.4 0 8-3.6 8-8s-3.6-8-8-8H256V96zM80 200c0-4.4-3.6-8-8-8s-8 3.6-8 8V376c0 4.4 3.6 8 8 8H440c4.4 0 8-3.6 8-8V200c0-4.4-3.6-8-8-8s-8 3.6-8 8V368H328V200c0-4.4-3.6-8-8-8s-8 3.6-8 8V368H200V200c0-4.4-3.6-8-8-8s-8 3.6-8 8V368H80V200zM40 432c-4.4 0-8 3.6-8 8s3.6 8 8 8H472c4.4 0 8-3.6 8-8s-3.6-8-8-8H40zM8 496c-4.4 0-8 3.6-8 8s3.6 8 8 8H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H8z"],
    "lips": [576, 512, [128068, 128482], "f600", "M278.1 113.8c5.8 4.6 14 4.6 19.8 0C322.1 94.7 348.8 80 376 80c18.2 0 37.5 6.9 57.2 17.7c19.6 10.8 38.1 24.8 54.6 37.6c18.5 14.4 35.8 30.1 48.6 44.5C550 195.1 560 209.6 560 224c0 15.7-7.5 32.8-16.4 50.7l14.3 7.2-14.3-7.2c-10.3 20.6-25.5 44.7-45.5 67.8C458.4 388.4 398.4 432 320 432H256c-78.4 0-138.4-43.6-178.1-89.5c-24.6-28.5-45.8-61.3-57.4-96C17.9 238.6 16 230.6 16 224c0-14.4 10-28.9 23.5-44.1c12.8-14.4 30.1-30.1 48.6-44.5c16.5-12.9 35.1-26.8 54.6-37.6C162.5 86.9 181.8 80 200 80c27.2 0 53.9 14.7 78.1 33.8zM510.2 352.9c20.9-24.2 36.8-49.4 47.7-71.1C566.6 264.3 576 244 576 224c0-21.1-14.2-39.7-27.6-54.8c-13.6-15.3-31.7-31.7-50.8-46.5C464.5 97 420 64 376 64c-32.7 0-63 17.5-88 37.3C263 81.5 232.7 64 200 64c-44 0-88.5 33-121.6 58.7c-19.1 14.8-37.1 31.2-50.8 46.5C14.2 184.3 0 202.9 0 224c0 9.2 2.6 19.1 5.3 27.5c12.4 37.3 34.9 71.9 60.4 101.4C107.2 400.9 171.3 448 256 448h64c84.7 0 148.8-47.1 190.2-95.1zM353.9 209.3c2.6-.8 5.3-1.3 7.8-1.2c38.7 .4 67.5 5.6 86.3 11.4c9.5 2.9 16.2 5.9 20.5 8.4c.7 .4 1.2 .8 1.7 1.1c-1.8 2.4-4.7 5.6-8.6 9.4c-7.9 7.8-19.9 17.7-35.7 27.5C394.6 285.3 348 304 288 304s-106.6-18.7-138.1-38.2c-15.8-9.8-27.7-19.7-35.7-27.5c-3.9-3.8-6.7-7-8.6-9.4c.5-.3 1.1-.7 1.7-1.1c4.2-2.5 11-5.5 20.5-8.4c18.8-5.8 47.6-11 86.3-11.4c2.6 0 5.2 .4 7.8 1.2c11.7 3.6 43 12.7 65.9 12.7s54.2-9.1 65.9-12.7zm119 21.7a.4 .4 0 1 0 -.6 .4 .4 .4 0 1 0 .6-.4zm-369.8 0a.3 .3 0 1 0 .6 .3 .3 .3 0 1 0 -.6-.3zM362 192c-4.4 0-8.8 .7-12.8 1.9c-11.9 3.7-41 12-61.2 12s-49.2-8.3-61.2-12c-4-1.3-8.3-2-12.8-1.9c-40 .4-70.3 5.8-90.8 12.1c-10.2 3.1-18.2 6.6-23.8 9.8c-2.8 1.6-5.2 3.3-7.1 5.2c-1.5 1.4-4.3 4.5-4.3 8.8c0 1.7 .5 3 .7 3.7c.3 .8 .7 1.6 1.1 2.3c.8 1.4 1.8 2.9 3 4.4c2.4 3.1 5.8 7 10.2 11.3c8.8 8.6 21.7 19.3 38.5 29.6C175.1 300.2 224.6 320 288 320s112.9-19.8 146.5-40.6c16.8-10.4 29.7-21 38.5-29.6c4.4-4.3 7.8-8.2 10.2-11.3c1.2-1.6 2.2-3.1 3-4.4c.4-.7 .8-1.5 1.1-2.3c.3-.7 .7-2.1 .7-3.7c0-4.3-2.8-7.4-4.2-8.8c-1.9-1.8-4.3-3.6-7.1-5.2c-5.6-3.3-13.6-6.7-23.8-9.8C432.3 197.9 402 192.5 362 192z"],
    "pencil": [512, 512, [9999, 61504, "pencil-alt"], "f303", "M395 25.9c12.5-12.5 32.8-12.5 45.3 0l45.8 45.8c12.5 12.5 12.5 32.8 0 45.3l-66.9 66.9L328.1 92.8 395 25.9zm-78.2 78.2l91.1 91.1L164.7 438.4c-1.5 1.5-3.1 3-4.7 4.4V408c0-4.4-3.6-8-8-8H112V360c0-4.4-3.6-8-8-8H69.2c1.4-1.6 2.9-3.2 4.4-4.7L316.8 104.1zM51.4 384.7c1.7-5.8 4-11.4 6.8-16.7H96v40c0 4.4 3.6 8 8 8h40v37.7c-5.3 2.8-10.9 5.1-16.7 6.8L19.8 492.2 51.4 384.7zm400.1-370c-18.7-18.7-49.1-18.7-67.9 0L62.3 336C50 348.3 41 363.5 36.1 380.2L.3 501.7c-.8 2.8-.1 5.8 2 7.9s5.1 2.8 7.9 2l121.6-35.8c16.7-4.9 31.9-13.9 44.2-26.2L497.4 128.3c18.7-18.7 18.7-49.1 0-67.9L451.5 14.6zM317.7 173.1c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-144 144c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l144-144z"],
    "backward": [512, 512, [9194], "f04a", "M258 80c-3 0-5.8 .9-8.2 2.7L19.3 249.5C17.2 251 16 253.4 16 256s1.2 5 3.3 6.5L249.7 429.3c2.4 1.7 5.3 2.7 8.2 2.7c7.8 0 14-6.3 14-14V94c0-7.8-6.3-14-14-14zm0-16c16.6 0 30 13.5 30 30V197.4L464.3 69.7C469.5 66 475.6 64 482 64c16.6 0 30 13.5 30 30V418c0 16.6-13.4 30-30 30c-6.3 0-12.5-2-17.6-5.7L288 314.6V418c0 16.6-13.5 30-30 30c-6.3 0-12.5-2-17.6-5.7L9.9 275.4C3.7 270.9 0 263.7 0 256s3.7-14.9 9.9-19.4L240.3 69.7C245.5 66 251.6 64 258 64zm30 230.8L473.7 429.3c2.4 1.7 5.3 2.7 8.2 2.7c7.8 0 14-6.3 14-14V94c0-7.8-6.3-14-14-14c-3 0-5.8 .9-8.2 2.7L288 217.2v77.7z"],
    "caret-right": [256, 512, [], "f0da", "M233.4 240.6c4.2 4 6.6 9.6 6.6 15.4s-2.4 11.4-6.6 15.4L101.3 396.5c-2.3 2.2-5.4 3.5-8.7 3.5c-7 0-12.6-5.6-12.6-12.6l0-262.8c0-7 5.6-12.6 12.6-12.6c3.2 0 6.3 1.2 8.7 3.5L233.4 240.6zm11-11.6L112.3 103.8C107 98.8 99.9 96 92.6 96C76.8 96 64 108.8 64 124.6l0 262.8C64 403.2 76.8 416 92.6 416c7.3 0 14.4-2.8 19.7-7.8L244.4 283c7.4-7 11.6-16.8 11.6-27s-4.2-20-11.6-27z"],
    "comments": [640, 512, [128490, 61670], "f086", "M16 176C16 90 99.4 16 208 16s192 74 192 160s-83.4 160-192 160c-35.3 0-69.6-8.4-101.3-24c-2.3-1.1-5-1.1-7.3 .1C73.3 325.9 44.8 336 16 336l.1-.1c18.7-14.2 32.2-33.9 40.2-55.4c1-2.7 .5-5.8-1.4-8C31.1 244.8 16 212.1 16 176zM208 0C93.1 0 0 78.8 0 176c0 39.2 15.7 74.1 39.6 103.2C32.4 296.5 21.2 312 6.5 323.1C1 327.2-1.3 334.4 .8 340.9C2.9 347.5 9.1 352 16 352c31 0 60.8-10.3 87.3-23.9C136.1 343.6 171.5 352 208 352c114.9 0 208-78.8 208-176S322.9 0 208 0zM448 176.5c100.7 6.8 176 77.8 176 159.5c0 36.1-15.1 68.9-38.9 96.5c-1.9 2.2-2.4 5.3-1.4 8c8 21.5 21.4 41.2 40.2 55.4l.1 .1c-28.8 0-57.3-10.1-83.4-23.9c-2.3-1.2-5-1.2-7.3-.1c-31.7 15.7-65.9 24-101.3 24c-89 0-161-49.7-184.2-114.9c-5.4 .8-10.8 1.4-16.3 1.9C255.8 457.4 336.3 512 432 512c36.5 0 71.9-8.4 104.7-23.9C563.2 501.7 593 512 624 512c6.9 0 13.1-4.5 15.2-11.1c2.1-6.6-.2-13.7-5.7-17.8c-14.7-11.2-25.9-26.6-33.1-43.9C624.3 410.1 640 375.2 640 336c0-92.8-84.9-168.9-192.6-175.5c.4 5.1 .6 10.3 .6 15.5l0 .5z"],
    "paste": [512, 512, ["file-clipboard"], "f0ea", "M128.6 41.6C131.6 27 144.5 16 160 16s28.4 11 31.4 25.6c.8 3.7 4 6.4 7.8 6.4H216c13.3 0 24 10.7 24 24V88c0 4.4-3.6 8-8 8H88c-4.4 0-8-3.6-8-8V72c0-13.3 10.7-24 24-24h16.8c3.8 0 7.1-2.7 7.8-6.4zM160 0c-20.9 0-38.7 13.4-45.3 32H104c-13.1 0-24.7 6.3-32 16H64C28.7 48 0 76.7 0 112V384c0 35.3 28.7 64 64 64H192V432H64c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h.8c-.5 2.6-.8 5.3-.8 8V88c0 13.3 10.7 24 24 24H232c13.3 0 24-10.7 24-24V72c0-2.7-.3-5.4-.8-8h.8c20.9 0 38.7 13.4 45.3 32H318c-7.1-27.6-32.2-48-62-48h-8c-7.3-9.7-18.9-16-32-16H205.3C198.7 13.4 180.9 0 160 0zM448 496H288c-26.5 0-48-21.5-48-48V192c0-26.5 21.5-48 48-48H396.1c8.5 0 16.6 3.4 22.6 9.4l67.9 67.9c6 6 9.4 14.1 9.4 22.6V448c0 26.5-21.5 48-48 48zM288 512H448c35.3 0 64-28.7 64-64V243.9c0-12.7-5.1-24.9-14.1-33.9l-67.9-67.9c-9-9-21.2-14.1-33.9-14.1H288c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64z"],
    "desktop-arrow-down": [576, 512, [], "e155", "M64 0H248V16H64C37.5 16 16 37.5 16 64V352c0 26.5 21.5 48 48 48H231.8h.3H343.9h.3H512c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H328V0H512c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H353.4l13.3 80H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H360 216 136c-4.4 0-8-3.6-8-8s3.6-8 8-8h73.2l13.3-80H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0zM80 64H248V80H80l0 192H496V80H328V64H496c8.8 0 16 7.2 16 16V272c0 8.8-7.2 16-16 16H80c-8.8 0-16-7.2-16-16V80c0-8.8 7.2-16 16-16zM225.4 496H350.6l-13.3-80H238.8l-13.3 80zM296 8V212.7l74.3-74.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-88 88c-3.1 3.1-8.2 3.1-11.3 0l-88-88c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L280 212.7V8c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "code-pull-request": [512, 512, [], "e13c", "M32 64a48 48 0 1 1 96 0A48 48 0 1 1 32 64zm56 63.5c31.6-3.9 56-30.9 56-63.5c0-35.3-28.7-64-64-64S16 28.7 16 64c0 32.6 24.4 59.6 56 63.5v257c-31.6 3.9-56 30.9-56 63.5c0 35.3 28.7 64 64 64s64-28.7 64-64c0-32.6-24.4-59.6-56-63.5v-257zM32 448a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm400-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112c35.3 0 64-28.7 64-64c0-32.6-24.4-59.6-56-63.5V192c0-57.4-46.6-104-104-104H244.7l72.7-66.1c3.3-3 3.5-8 .5-11.3s-8-3.5-11.3-.5l-88 80C217 91.6 216 93.7 216 96s1 4.4 2.6 5.9l88 80c3.3 3 8.3 2.7 11.3-.5s2.7-8.3-.5-11.3L244.7 104H336c48.6 0 88 39.4 88 88V384.5c-31.6 3.9-56 30.9-56 63.5c0 35.3 28.7 64 64 64z"],
    "pumpkin": [576, 512, [], "f707", "M292.5 16c.2 0 .3 0 .5 .1l42.3 18.1c.5 .2 .8 .7 .8 1.2V111c5.5 1.6 10.8 3.5 16 5.7V35.4c0-6.9-4.1-13.2-10.5-15.9L299.3 1.4c-2.2-.9-4.5-1.4-6.8-1.4h-1.2c-6.9 0-13.1 4.1-15.8 10.4L230 114.3c6.5-2.4 13.2-4.4 20.1-6l40-91.5c.2-.5 .7-.8 1.2-.8h1.2zM188.3 136.8c5-3.7 10.1-7.1 15.5-10.2C186.6 117.2 167.8 112 148 112c-41.8 0-79 23.3-105.5 59.5S0 257.5 0 312s16.1 104.2 42.5 140.5S106.2 512 148 512c25.5 0 49.3-8.7 70-23.6c20.7 15 44.5 23.6 70 23.6s49.3-8.7 70-23.6c20.7 15 44.5 23.6 70 23.6c41.8 0 79-23.3 105.5-59.5S576 366.5 576 312s-16.1-104.2-42.5-140.5S469.8 112 428 112c-19.8 0-38.6 5.2-55.8 14.6c5.4 3.1 10.5 6.5 15.5 10.2c12.8-5.7 26.3-8.8 40.3-8.8c35.5 0 68.3 19.7 92.5 52.9S560 260.5 560 312s-15.2 97.8-39.5 131c-24.2 33.2-57.1 53-92.5 53c-23.5 0-45.7-8.6-65-24c-2.9-2.3-7-2.3-9.9 0c-19.4 15.4-41.6 24-65 24s-45.7-8.6-65-24c-2.9-2.3-7-2.3-9.9 0c-19.4 15.4-41.6 24-65 24c-35.5 0-68.3-19.7-92.5-53C31.2 409.8 16 363.5 16 312s15.2-97.8 39.5-131.1S112.5 128 148 128c14 0 27.5 3.1 40.3 8.8zM288 152c41.2 0 77.6 20.8 99.2 52.5c2.5 3.7 7.5 4.6 11.1 2.1s4.6-7.5 2.1-11.1C376 159.6 334.7 136 288 136s-88 23.6-112.4 59.5c-2.5 3.7-1.5 8.6 2.1 11.1s8.6 1.5 11.1-2.1c21.6-31.7 58-52.5 99.2-52.5z"],
    "clipboard-list": [384, 512, [], "f46d", "M120.4 64c4-36 34.5-64 71.6-64s67.6 28 71.6 64H272c20.9 0 38.7 13.4 45.3 32H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160c0-35.3 28.7-64 64-64h2.7C73.3 77.4 91.1 64 112 64h8.4zM64 112c-26.5 0-48 21.5-48 48V448c0 26.5 21.5 48 48 48H320c26.5 0 48-21.5 48-48V160c0-26.5-21.5-48-48-48v16c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V112zM192 16c-30.9 0-56 25.1-56 56c0 4.4-3.6 8-8 8H112c-17.7 0-32 14.3-32 32v16c0 8.8 7.2 16 16 16H288c8.8 0 16-7.2 16-16V112c0-17.7-14.3-32-32-32H256c-4.4 0-8-3.6-8-8c0-30.9-25.1-56-56-56zM176 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM160 224c0-4.4 3.6-8 8-8H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8zm0 96c0-4.4 3.6-8 8-8H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8zM96 400a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM80 320a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM96 208a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "pen-field": [640, 512, [], "e211", "M596.5 31.8l11.9 11.9c15.6 15.6 15.6 40.9 0 56.6L568 140.7 499.7 72.4l40-40.5c15.6-15.8 41-15.8 56.7-.2zm-264 209.8l156-157.8L556.7 152 399.9 308.9c-5.5 5.5-12.5 9.3-20.1 10.9l-73.5 15.4 15.5-73.7c1.6-7.5 5.3-14.4 10.7-19.9zM528.4 20.7L321.1 230.3c-7.6 7.7-12.8 17.3-15 27.9l-18 85.6c-.6 2.6 .3 5.4 2.2 7.3s4.7 2.7 7.3 2.2l85.5-17.9c10.6-2.2 20.4-7.5 28.1-15.2L619.7 111.6c21.9-21.9 21.9-57.3 0-79.2L607.8 20.5c-22-22-57.6-21.9-79.4 .2zM56 128c-30.9 0-56 25.1-56 56V456c0 30.9 25.1 56 56 56H520c30.9 0 56-25.1 56-56V264c0-4.4-3.6-8-8-8s-8 3.6-8 8V456c0 22.1-17.9 40-40 40H56c-22.1 0-40-17.9-40-40V184c0-22.1 17.9-40 40-40H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H56zm72 208a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "blueberries": [512, 512, [], "e2e8", "M383.9 328.7c65-20.3 112.1-81 112.1-152.7c0-88.4-71.6-160-160-160c-71.7 0-132.4 47.1-152.7 112.1c-2.4-.1-4.8-.1-7.3-.1c-3.2 0-6.3 .1-9.4 .2C187.4 54.2 255.4 0 336 0c97.2 0 176 78.8 176 176c0 80.6-54.2 148.6-128.2 169.4c.1-3.1 .2-6.3 .2-9.4c0-2.4 0-4.9-.1-7.3zM336 336A160 160 0 1 0 16 336a160 160 0 1 0 320 0zM0 336a176 176 0 1 1 352 0A176 176 0 1 1 0 336zm168-96v40h40c4.4 0 8 3.6 8 8s-3.6 8-8 8H168v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V296H112c-4.4 0-8-3.6-8-8s3.6-8 8-8h40V240c0-4.4 3.6-8 8-8s8 3.6 8 8zM360 80v40h40c4.4 0 8 3.6 8 8s-3.6 8-8 8H360v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V136H304c-4.4 0-8-3.6-8-8s3.6-8 8-8h40V80c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "truck-ramp-box": [640, 512, ["truck-loading"], "f4de", "M352 72c0-39.8 32.2-72 72-72H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H424c-30.9 0-56 25.1-56 56V392.5l50.1-14.4C428.3 326.8 473.6 288 528 288c61.9 0 112 50.1 112 112s-50.1 112-112 112s-112-50.1-112-112c0-1.5 0-3.1 .1-4.6L10.2 511.7c-4.2 1.2-8.7-1.2-9.9-5.5s1.2-8.7 5.5-9.9L352 397.1V72zM624 400a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM204.4 142.6l-38.6 10.4 18.6 69.5c2.3 8.5-2.8 17.3-11.3 19.6l-46.4 12.4c-8.5 2.3-17.3-2.8-19.6-11.3L88.5 173.6 49.9 184c-8.5 2.3-13.6 11.1-11.3 19.6L80 358.1c2.3 8.5 11.1 13.6 19.6 11.3L254.1 328c8.5-2.3 13.6-11.1 11.3-19.6L224 153.9c-2.3-8.5-11.1-13.6-19.6-11.3zM104 169.5L122.6 239 169 226.6l-18.6-69.5L104 169.5zm-58.2-1l154.5-41.4c17.1-4.6 34.6 5.6 39.2 22.6l41.4 154.5c4.6 17.1-5.6 34.6-22.6 39.2L103.7 384.9c-17.1 4.6-34.6-5.6-39.2-22.6L23.1 207.7c-4.6-17.1 5.6-34.6 22.6-39.2z"],
    "note": [448, 512, [], "e1ff", "M384 48c26.5 0 48 21.5 48 48V316.1c0 1.3-.1 2.6-.2 3.9H336c-26.5 0-48 21.5-48 48v95.8c-1.3 .2-2.6 .2-3.9 .2H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM306.7 454.6c-.9 .9-1.8 1.7-2.7 2.4V368c0-17.7 14.3-32 32-32h89.1c-.8 1-1.6 1.9-2.4 2.7L306.7 454.6zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H284.1c12.7 0 24.9-5.1 33.9-14.1L433.9 350.1c9-9 14.1-21.2 14.1-33.9V96c0-35.3-28.7-64-64-64H64zM96 400a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm0-48a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM80 128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 272a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm0-48a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "arrow-down-to-square": [512, 512, [], "e096", "M373.7 221.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L264 308.7V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V308.7l-98.3-98.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l112 112c3.1 3.1 8.2 3.1 11.3 0l112-112zM56 32C25.1 32 0 57.1 0 88V456c0 30.9 25.1 56 56 56H456c30.9 0 56-25.1 56-56V88c0-30.9-25.1-56-56-56H408c-4.4 0-8 3.6-8 8s3.6 8 8 8h48c22.1 0 40 17.9 40 40V456c0 22.1-17.9 40-40 40H56c-22.1 0-40-17.9-40-40V88c0-22.1 17.9-40 40-40h48c4.4 0 8-3.6 8-8s-3.6-8-8-8H56z"],
    "user-check": [640, 512, [], "f4fc", "M112 128a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM16 482.3C16 392.7 88.7 320 178.3 320h91.4C359.3 320 432 392.7 432 482.3c0 7.6-6.1 13.7-13.7 13.7H29.7c-7.6 0-13.7-6.1-13.7-13.7zM224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3zM629.7 149.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L496 260.7l-58.3-58.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l64 64c3.1 3.1 8.2 3.1 11.3 0l128-128z"],
    "cloud-xmark": [640, 512, [], "e35f", "M522.7 220.8c3.4-8.9 5.3-18.6 5.3-28.8c0-44.2-35.8-80-80-80c-16.5 0-31.7 5-44.4 13.5c-3.7 2.5-8.2 3.3-12.5 2.3s-8-3.8-10.2-7.6C355.9 77 309.3 48 256 48c-79.5 0-144 64.5-144 144c0 2.5 .1 4.9 .2 7.3c.4 7.1-4 13.5-10.7 15.9C51.7 232.7 16 280.2 16 336c0 70.7 57.3 128 128 128H512c61.9 0 112-50.1 112-112c0-54.2-38.5-99.4-89.6-109.8c-4.6-.9-8.6-3.9-10.9-8s-2.6-9.1-.9-13.4zM256 32c53.6 0 101 26.3 130 66.7c3.1 4.3 6 8.8 8.7 13.4c3.5-2.4 7.2-4.5 11-6.4C418.5 99.5 432.8 96 448 96c53 0 96 43 96 96c0 6.6-.7 13-1.9 19.2c-1.1 5.3-2.6 10.5-4.5 15.4c5.3 1.1 10.5 2.5 15.5 4.2C603.6 247.9 640 295.7 640 352c0 70.7-57.3 128-128 128H144C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160zM242.3 210.3c3.1-3.1 8.2-3.1 11.3 0L320 276.7l66.3-66.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L331.3 288l66.3 66.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L320 299.3l-66.3 66.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L308.7 288l-66.3-66.3c-3.1-3.1-3.1-8.2 0-11.3z"],
    "vial-virus": [512, 512, [], "e597", "M0 40c0-4.4 3.6-8 8-8H248c4.4 0 8 3.6 8 8s-3.6 8-8 8H224V224c0 4.4-3.6 8-8 8s-8-3.6-8-8V208H48V384c0 44.2 35.8 80 80 80c22.9 0 43.6-9.6 58.2-25.1c3-3.2 8.1-3.4 11.3-.3s3.4 8.1 .3 11.3C180.3 468.4 155.5 480 128 480c-53 0-96-43-96-96V48H8c-4.4 0-8-3.6-8-8zM48 192H208V48H48V192zM472.5 324.2c4.5 2.4 9.7 3.9 15.5 3.9c13.3 0 24 10.7 24 24s-10.7 24-24 24c-28.8 0-43.2 34.8-22.9 55.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-20.4-20.4-55.2-5.9-55.2 22.9c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-28.8-34.8-43.2-55.2-22.9c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9c20.4-20.4 5.9-55.2-22.9-55.2c-13.3 0-24-10.7-24-24s10.7-24 24-24c28.8 0 43.2-34.8 22.9-55.2c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c20.4 20.4 55.2 5.9 55.2-22.9c0-13.3 10.7-24 24-24s24 10.7 24 24c0 28.8 34.8 43.3 55.2 22.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-16.3 16.3-10.4 41.7 7.3 51.4zM352 208c-4.4 0-8 3.6-8 8c0 43.1-52.1 64.6-82.5 34.2c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3C280.6 292 259.1 344 216 344c-4.4 0-8 3.6-8 8s3.6 8 8 8c43.1 0 64.6 52.1 34.2 82.5c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0c30.5-30.5 82.5-8.9 82.5 34.2c0 4.4 3.6 8 8 8s8-3.6 8-8c0-43.1 52.1-64.6 82.5-34.2c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3C423.4 412.1 445 360 488.1 360c4.4 0 8-3.6 8-8s-3.6-8-8-8c-43.1 0-64.6-52.1-34.2-82.5c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0C412.1 280.6 360 259.1 360 216c0-4.4-3.6-8-8-8zM336 320a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "book-blank": [448, 512, [128213, 128215, 128216, 128217, "book-alt"], "f5d9", "M0 56C0 25.1 25.1 0 56 0H408c22.1 0 40 17.9 40 40V376c0 19.4-13.7 35.5-32 39.2V496h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H56c-30.9 0-56-25.1-56-56V56zM56 416c-22.1 0-40 17.9-40 40s17.9 40 40 40H400V416H56zm-40 .8C26.2 406.4 40.3 400 56 400h56V16H56C33.9 16 16 33.9 16 56V416.8zM128 16V400H408c13.3 0 24-10.7 24-24V40c0-13.3-10.7-24-24-24H128z"],
    "golf-flag-hole": [512, 512, [], "e3ac", "M131.8 1.2c2.4-1.5 5.3-1.6 7.8-.4l240 120c2.7 1.4 4.4 4.1 4.4 7.2s-1.7 5.8-4.4 7.2L144 252.9v61.5c33.8-6.7 71.8-10.5 112-10.5c141.4 0 256 46.6 256 104s-114.6 104-256 104S0 465.4 0 408c0-32.8 37.5-62.1 96-81.2v16.9c-5.2 1.8-10.2 3.7-15 5.6c-22 9-38.8 19.2-49.8 29.8C20.2 389.6 16 399.4 16 408s4.2 18.4 15.2 28.9c11 10.6 27.8 20.8 49.8 29.8C125 484.6 186.8 496 256 496s131-11.4 175-29.3c22-9 38.8-19.2 49.8-29.8c11-10.5 15.2-20.3 15.2-28.9s-4.2-18.4-15.2-28.9c-11-10.6-27.8-20.8-49.8-29.8C387 331.4 325.2 320 256 320c-40.6 0-78.6 3.9-112 10.8v50.7c17.2-12.9 46.6-21.5 80-21.5c53 0 96 21.5 96 48s-43 48-96 48s-96-21.5-96-48V334.4 317.9 248 8c0-2.8 1.4-5.3 3.8-6.8zM144 408c0 3.9 3.6 11.8 19.3 19.6C178 435 199.4 440 224 440s46-5 60.7-12.4c15.7-7.8 19.3-15.7 19.3-19.6s-3.6-11.8-19.3-19.6C270 381 248.6 376 224 376s-46 5-60.7 12.4C147.6 396.2 144 404.1 144 408zm0-172.9L358.1 128 144 20.9V235.1z"],
    "message-arrow-down": [512, 512, ["comment-alt-arrow-down"], "e1db", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM264 104c0-4.4-3.6-8-8-8s-8 3.6-8 8V276.7l-74.3-74.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l88 88c3.1 3.1 8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L264 276.7V104z"],
    "face-unamused": [512, 512, [], "e39f", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM322.1 397.4C309.3 383.1 287.3 368 256 368s-53.3 15.1-66.1 29.4c-3 3.3-8 3.6-11.3 .6s-3.6-8-.6-11.3C193.1 370 219.1 352 256 352s62.9 18 77.9 34.6c3 3.3 2.7 8.3-.6 11.3s-8.3 2.7-11.3-.6zM104 192h72c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32c0-5.8 1.6-11.3 4.3-16H104c-4.4 0-8-3.6-8-8s3.6-8 8-8zm72 16a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm112-8c0-4.4 3.6-8 8-8h72c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32c0-5.8 1.6-11.3 4.3-16H296c-4.4 0-8-3.6-8-8zm64 24a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z"],
    "sheet-plastic": [384, 512, [], "e571", "M320 16c26.5 0 48 21.5 48 48V332.1c0 1.3-.1 2.6-.2 3.9H248c-22.1 0-40 17.9-40 40V495.8c-1.3 .2-2.6 .2-3.9 .2H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H320zm41.1 336c-.8 1-1.6 1.9-2.4 2.7L226.7 486.6c-.9 .9-1.8 1.7-2.7 2.4V376c0-13.3 10.7-24 24-24H361.1zM0 448c0 35.3 28.7 64 64 64H204.1c12.7 0 24.9-5.1 33.9-14.1L369.9 366.1c9-9 14.1-21.2 14.1-33.9V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64V448zM173.7 66.3c-3.1-3.1-8.2-3.1-11.3 0l-96 96c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l96-96c3.1-3.1 3.1-8.2 0-11.3zm96 43.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-160 160c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l160-160z"],
    "circle-9": [512, 512, [], "e0f6", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM210 381.3c2.9 3.3 8 3.7 11.3 .8l97.9-85.7c8.7-7.6 15.9-16.6 21.2-26.6c7.4-13.6 11.6-29.2 11.6-45.8c0-53-43-96-96-96s-96 43-96 96s43 96 96 96c4.3 0 8.6-.3 12.8-.8L210.7 370c-3.3 2.9-3.7 8-.8 11.3zM255.9 304a80 80 0 1 1 .1-160 80 80 0 1 1 -.1 160z"],
    "blog": [512, 512, [], "f781", "M200 32c-4.4 0-8 3.6-8 8s3.6 8 8 8c145.8 0 264 118.2 264 264c0 4.4 3.6 8 8 8s8-3.6 8-8C480 157.4 354.6 32 200 32zm0 96c-4.4 0-8 3.6-8 8s3.6 8 8 8c92.8 0 168 75.2 168 168c0 4.4 3.6 8 8 8s8-3.6 8-8c0-101.6-82.4-184-184-184zM16 104c0-4.4-3.6-8-8-8s-8 3.6-8 8V368c0 79.5 64.5 144 144 144s144-64.5 144-144s-64.5-144-144-144h-8c-4.4 0-8 3.6-8 8s3.6 8 8 8h8c70.7 0 128 57.3 128 128s-57.3 128-128 128S16 438.7 16 368V104z"],
    "user-ninja": [448, 512, [129399], "f504", "M336 128a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm16 0c0 70.7-57.3 128-128 128c-69.6 0-126.2-55.5-128-124.7L45.7 181.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L92.7 112 34.3 53.7c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L99.9 96.6C113.9 41.1 164.2 0 224 0c70.7 0 128 57.3 128 128zM298 317.2c6.7-8.8 18.6-11.9 28.7-7.4l13.4 5.9C405.6 344.2 448 409 448 480.5c0 17.4-14.1 31.5-31.5 31.5H31.5C14.1 512 0 497.9 0 480.5c0-71.5 42.4-136.3 107.9-165l13.4-5.8c10.1-4.4 22-1.4 28.7 7.5l73.9 97.2L298 317.2zM234 427.6L286 496H416.5c8.5 0 15.5-6.9 15.5-15.5c0-65.2-38.6-124.2-98.3-150.3l-13.4-5.9c-3.4-1.5-7.3-.5-9.6 2.5L234 427.6zM265.9 496L137.3 326.9c-2.2-2.9-6.2-4-9.6-2.5l-13.4 5.8C54.6 356.3 16 415.4 16 480.5c0 8.5 6.9 15.5 15.5 15.5H265.9zM160 112c0 8.8 7.2 16 16 16h96c8.8 0 16-7.2 16-16s-7.2-16-16-16H176c-8.8 0-16 7.2-16 16zm-16 0c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H176c-17.7 0-32-14.3-32-32z"],
    "pencil-slash": [640, 512, [], "e215", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM319.6 347.4l-90.9 90.9c-1.5 1.5-3.1 3-4.7 4.4V408c0-4.4-3.6-8-8-8H176V360c0-4.4-3.6-8-8-8H133.2c1.4-1.6 2.9-3.2 4.4-4.7l80.2-80.2-12.6-10L126.3 336c-12.3 12.3-21.3 27.5-26.2 44.2L64.3 501.7c-.8 2.8-.1 5.8 2 7.9s5.1 2.8 7.9 2l121.6-35.8c16.7-4.9 31.9-13.9 44.2-26.2l92.2-92.2-12.6-10zm128-332.8L307.7 154.6l12.6 10 60.4-60.4 91.1 91.1-49.7 49.7 12.6 10L561.4 128.3c18.7-18.7 18.7-49.1 0-67.9L515.5 14.6c-18.7-18.7-49.1-18.7-67.9 0zm56.6 11.3l45.8 45.8c12.5 12.5 12.5 32.8 0 45.3l-66.9 66.9L392.1 92.8 459 25.9c12.5-12.5 32.8-12.5 45.3 0zM122.3 368H160v40c0 4.4 3.6 8 8 8h40v37.7c-5.3 2.8-10.9 5.1-16.7 6.8L83.8 492.2l31.6-107.5c1.7-5.8 4-11.4 6.8-16.7z"],
    "bowling-pins": [512, 512, [], "f437", "M88 64c0-26.5 21.5-48 48-48s48 21.5 48 48v.9c0 14.4-2.3 28.8-6.9 42.5l-7.2 21.7c-3.3 10-5.3 20.4-6 30.9H108.1c-.6-10.5-2.6-20.9-6-30.9l-7.2-21.7C90.3 93.7 88 79.3 88 64.9V64zm20 112h56c.4 5 1 9.9 2 14.9c1.5 7.6 3.8 15.1 6.7 22.3l38.5 93.6c8.4 20.4 12.7 42.2 12.7 64.2c0 28.2-7.1 56-20.6 80.8L179.3 496H92.7L68.6 451.7C55.1 426.9 48 399.2 48 371c0-22 4.3-43.8 12.7-64.2l38.5-93.6c3-7.2 5.2-14.6 6.7-22.3c1-4.9 1.7-9.9 2-14.9zM136 0C100.7 0 72 28.7 72 64v.9c0 16.2 2.6 32.2 7.7 47.5L87 134.2c5.8 17.3 6.9 35.7 3.3 53.6C89 194.3 87 200.8 84.5 207L45.9 300.6C36.7 322.9 32 346.8 32 371c0 30.9 7.8 61.3 22.5 88.4l24.2 44.3c2.8 5.1 8.2 8.3 14 8.3h86.5c5.9 0 11.2-3.2 14-8.3l24.2-44.3C232.2 432.3 240 401.8 240 371c0-24.1-4.7-48-13.9-70.3L187.5 207c-2.6-6.2-4.5-12.7-5.8-19.3c-3.6-17.8-2.4-36.3 3.3-53.6l7.2-21.7c5.1-15.3 7.7-31.4 7.7-47.5V64c0-35.3-28.7-64-64-64zM328 64c0-26.5 21.5-48 48-48s48 21.5 48 48v.9c0 14.4-2.3 28.8-6.9 42.5l-7.2 21.7c-3.3 10-5.3 20.4-6 30.9H348.1c-.6-10.5-2.6-20.9-6-30.9l-7.2-21.7c-4.6-13.7-6.9-28-6.9-42.5V64zm20 112h56c.4 5 1 9.9 2 14.9c1.5 7.6 3.8 15.1 6.7 22.3l38.5 93.6c8.4 20.4 12.7 42.2 12.7 64.2c0 28.2-7.1 56-20.6 80.8L419.3 496H332.7l-24.2-44.3C295.1 426.9 288 399.2 288 371c0-22 4.3-43.8 12.7-64.2l38.5-93.6c3-7.2 5.2-14.6 6.7-22.3c1-4.9 1.7-9.9 2-14.9zM376 0c-35.3 0-64 28.7-64 64v.9c0 16.2 2.6 32.2 7.7 47.5l7.2 21.7c5.8 17.3 6.9 35.7 3.3 53.6c-1.3 6.6-3.3 13.1-5.8 19.3l-38.5 93.6C276.7 322.9 272 346.8 272 371c0 30.9 7.8 61.3 22.5 88.4l24.2 44.3c2.8 5.1 8.2 8.3 14 8.3h86.5c5.9 0 11.2-3.2 14-8.3l24.2-44.3C472.2 432.3 480 401.8 480 371c0-24.1-4.7-48-13.9-70.3L427.5 207c-2.6-6.2-4.5-12.7-5.8-19.3c-3.6-17.8-2.4-36.3 3.3-53.6l7.2-21.7c5.1-15.3 7.7-31.4 7.7-47.5V64c0-35.3-28.7-64-64-64z"],
    "person-arrow-up-from-line": [640, 512, [], "e539", "M232 56a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-96 0a56 56 0 1 1 112 0A56 56 0 1 1 136 56zM122.7 175.7L55.2 315.5c-1.9 4-6.7 5.6-10.7 3.7s-5.6-6.7-3.7-10.7l67.5-139.8c12-24.9 37.2-40.7 64.8-40.7h37.8c27.6 0 52.8 15.8 64.8 40.7l67.5 139.8c1.9 4 .3 8.8-3.7 10.7s-8.8 .3-10.7-3.7L261.3 175.7C252 156.3 232.4 144 210.9 144H173.1c-21.5 0-41.1 12.3-50.4 31.7zM128 240c4.4 0 8 3.6 8 8V480c0 8.8 7.2 16 16 16s16-7.2 16-16V360c0-13.3 10.7-24 24-24s24 10.7 24 24V480c0 8.8 7.2 16 16 16s16-7.2 16-16V248c0-4.4 3.6-8 8-8s8 3.6 8 8V480c0 5.8-1.6 11.3-4.3 16H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H124.3c-2.7-4.7-4.3-10.2-4.3-16V248c0-4.4 3.6-8 8-8zm51.7 256h24.6c-2.7-4.7-4.3-10.2-4.3-16V360c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 5.8-1.6 11.3-4.3 16zM597.9 138.6c3 3.2 2.8 8.3-.5 11.3s-8.3 2.8-11.3-.5L504 60.5 504 408c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-347.5-82.1 89c-3 3.2-8.1 3.4-11.3 .5s-3.4-8.1-.5-11.3l96-104c1.5-1.6 3.6-2.6 5.9-2.6s4.4 .9 5.9 2.6l96 104z"],
    "down-right": [384, 512, [], "e16b", "M336 416c8.8 0 16-7.2 16-16V164.3c0-11.2-9.1-20.3-20.3-20.3c-5.4 0-10.5 2.1-14.3 5.9l-75.7 75.7c-3.1 3.1-8.2 3.1-11.3 0L93.7 89c-5.7-5.7-13.5-9-21.7-9s-15.9 3.2-21.7 9L25 114.4c-5.7 5.7-9 13.5-9 21.7s3.2 15.9 9 21.7L161.7 294.3c1.5 1.5 2.3 3.5 2.3 5.7s-.8 4.2-2.3 5.7L85.9 381.4c-3.8 3.8-5.9 9-5.9 14.3c0 11.2 9.1 20.3 20.3 20.3H336zm32-16c0 17.7-14.3 32-32 32H100.3c-20 0-36.3-16.2-36.3-36.3c0-9.6 3.8-18.9 10.6-25.7L144.7 300 13.7 169C4.9 160.2 0 148.4 0 136s4.9-24.2 13.7-33L39 77.7C47.8 68.9 59.6 64 72 64s24.2 4.9 33 13.7l131 131 70.1-70.1c6.8-6.8 16-10.6 25.7-10.6c20 0 36.3 16.2 36.3 36.3V400z"],
    "scroll-torah": [640, 512, ["torah"], "f6a0", "M96 56c0-22.1-17.9-40-40-40S16 33.9 16 56V456c0 22.1 17.9 40 40 40s40-17.9 40-40V56zM0 56C0 25.1 25.1 0 56 0c22.3 0 41.6 13.1 50.6 32H533.4c9-18.9 28.3-32 50.6-32c30.9 0 56 25.1 56 56V456c0 30.9-25.1 56-56 56c-22.3 0-41.6-13.1-50.6-32H106.6c-9 18.9-28.3 32-50.6 32c-30.9 0-56-25.1-56-56V56zM111.4 464H528.6c-.4-2.6-.6-5.3-.6-8V56c0-2.7 .2-5.4 .6-8H111.4c.4 2.6 .6 5.3 .6 8V456c0 2.7-.2 5.4-.6 8zM200 313.7c0-2.5 .7-5 1.9-7.2L231.4 256l-29.4-50.5c-1.3-2.2-1.9-4.7-1.9-7.2c0-7.9 6.4-14.3 14.3-14.3h59l32.6-55.9c2.9-5 8.3-8.1 14.1-8.1s11.2 3.1 14.1 8.1L366.7 184h59c7.9 0 14.3 6.4 14.3 14.3c0 2.5-.7 5-1.9 7.2L408.6 256l29.4 50.5c1.3 2.2 1.9 4.7 1.9 7.2c0 7.9-6.4 14.3-14.3 14.3h-59l-32.6 55.9c-2.9 5-8.3 8.1-14.1 8.1s-11.2-3.1-14.1-8.1L273.3 328h-59c-7.9 0-14.3-6.4-14.3-14.3zm119.7 62.1c.1 .1 .2 .2 .3 .2s.2-.1 .3-.2L348.2 328H291.8l27.9 47.8zM249.9 256l32.6 56h75l32.6-56-32.6-56h-75l-32.6 56zm149.5 15.9L376 312h46.7l-23.4-40.1zM422.7 200H376l23.4 40.1L422.7 200zM320.3 136.2c-.1-.1-.2-.2-.3-.2s-.2 .1-.3 .2L291.8 184h56.3l-27.9-47.8zM217.3 200l23.4 40.1L264 200H217.3zM264 312l-23.4-40.1L217.3 312H264zM624 56c0-22.1-17.9-40-40-40s-40 17.9-40 40V456c0 22.1 17.9 40 40 40s40-17.9 40-40V56z"],
    "webhook": [576, 512, [], "e5d5", "M176 128c0-61.9 50.1-112 112-112s112 50.1 112 112c0 4.4 3.6 8 8 8s8-3.6 8-8C416 57.3 358.7 0 288 0S160 57.3 160 128c0 42.7 20.9 80.6 53.1 103.8c.2 .1 .3 .3 .3 .4c0 .1 0 .1 0 .1l0 0-58.5 93.6c-8.2-3.8-17.3-5.9-26.9-5.9c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64c0-20-9.2-37.9-23.6-49.6l58.5-93.6c4.7-7.6 2.2-17.1-4.5-22C194.3 198.5 176 165.4 176 128zm0 256.1a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM288 176a48 48 0 1 1 0-96 48 48 0 1 1 0 96zM224 128c0 35.3 28.7 64 64 64c9.6 0 18.7-2.1 26.9-5.9l58.5 93.6c4.8 7.6 14.4 9.5 21.7 5.6c15.7-8.5 33.8-13.3 52.9-13.3c61.9 0 112 50.1 112 112s-50.1 112-112 112c-21.8 0-42.2-6.2-59.4-17c-3.7-2.3-8.7-1.2-11 2.5s-1.2 8.7 2.5 11C399.8 504.9 423.1 512 448 512c70.7 0 128-57.3 128-128s-57.3-128-128-128c-21.9 0-42.5 5.5-60.5 15.2c-.2 .1-.4 .1-.5 .1l-.1 0 0 0 0 0-58.5-93.6C342.8 165.9 352 148 352 128c0-35.3-28.7-64-64-64s-64 28.7-64 64zM68.3 289.2c3.7-2.4 4.9-7.3 2.5-11s-7.3-4.9-11-2.5C23.9 298.4 0 338.4 0 384c0 70.7 57.3 128 128 128c67.8 0 123.3-52.8 127.7-119.5c0-.2 .1-.4 .2-.5c0 0 .1-.1 .1-.1h0H384.5c3.9 31.6 30.9 56 63.5 56c35.3 0 64-28.7 64-64s-28.7-64-64-64c-32.6 0-59.6 24.4-63.5 56H256c-9 0-15.7 7.2-16.2 15.5C235.9 449.8 187.3 496 128 496C66.1 496 16 445.9 16 384c0-39.9 20.8-74.9 52.3-94.8zM496 384a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"],
    "blinds-open": [512, 512, [], "f8fc", "M480 16c8.8 0 16 7.2 16 16V64c0 8.8-7.2 16-16 16H152 136 32c-8.8 0-16-7.2-16-16V32c0-8.8 7.2-16 16-16H480zM32 96H136v80 16 64.7c-22.7 3.8-40 23.6-40 47.3c0 12.3 4.6 23.5 12.2 32c.6 .7 1.2 1.3 1.8 1.9c8.7 8.7 20.7 14.1 33.9 14.1c14.2 0 27-6.2 35.8-16c7.6-8.5 12.2-19.7 12.2-32c0-23.8-17.3-43.5-40-47.3V192 176 96H480c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H32C14.3 0 0 14.3 0 32V64C0 81.7 14.3 96 32 96zM144 272a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM8 176c-4.4 0-8 3.6-8 8s3.6 8 8 8h96V176H8zM8 336c-4.4 0-8 3.6-8 8s3.6 8 8 8H80c-3.7-4.9-6.8-10.3-9.3-16H8zm496 16c4.4 0 8-3.6 8-8s-3.6-8-8-8H217.3c-2.5 5.7-5.6 11.1-9.3 16H504zm0-160c4.4 0 8-3.6 8-8s-3.6-8-8-8H184v16H504zM0 504c0 4.4 3.6 8 8 8H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H8c-4.4 0-8 3.6-8 8z"],
    "fence": [512, 512, [], "e303", "M72 32c2.5 0 4.9 1.2 6.4 3.2l44.8 59.7c3.1 4.2 4.8 9.2 4.8 14.4V160h72V109.3c0-5.2 1.7-10.2 4.8-14.4l44.8-59.7c1.5-2 3.9-3.2 6.4-3.2s4.9 1.2 6.4 3.2l44.8 59.7c3.1 4.2 4.8 9.2 4.8 14.4V160h72V109.3c0-5.2 1.7-10.2 4.8-14.4l44.8-59.7c1.5-2 3.9-3.2 6.4-3.2s4.9 1.2 6.4 3.2l44.8 59.7c3.1 4.2 4.8 9.2 4.8 14.4V456c0 13.3-10.7 24-24 24H408c-13.3 0-24-10.7-24-24V368H312v88c0 13.3-10.7 24-24 24H224c-13.3 0-24-10.7-24-24V368H128v88c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V109.3c0-5.2 1.7-10.2 4.8-14.4L65.6 35.2c1.5-2 3.9-3.2 6.4-3.2zM312 352h72V176H312V352zM200 176H128V352h72V176zM72 53.3L33.6 104.5c-1 1.4-1.6 3.1-1.6 4.8V456c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V109.3c0-1.7-.6-3.4-1.6-4.8L72 53.3zm368 0l-38.4 51.2c-1 1.4-1.6 3.1-1.6 4.8V456c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V109.3c0-1.7-.6-3.4-1.6-4.8L440 53.3zM217.6 104.5c-1 1.4-1.6 3.1-1.6 4.8V456c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V109.3c0-1.7-.6-3.4-1.6-4.8L256 53.3l-38.4 51.2z"],
    "up": [384, 512, ["arrow-alt-up"], "f357", "M192 48c8.1 0 15.9 3.2 21.7 9L362.1 205.4c3.8 3.8 5.9 9 5.9 14.3c0 11.2-9.1 20.3-20.3 20.3H248c-4.4 0-8 3.6-8 8V440c0 13.3-10.7 24-24 24H168c-13.3 0-24-10.7-24-24V248c0-4.4-3.6-8-8-8H36.3C25.1 240 16 230.9 16 219.7c0-5.4 2.1-10.5 5.9-14.3L170.3 57c5.7-5.7 13.5-9 21.7-9zM384 219.7c0-9.6-3.8-18.9-10.6-25.7L225 45.6C216.2 36.9 204.4 32 192 32s-24.2 4.9-33 13.7L10.6 194.1C3.8 200.9 0 210.1 0 219.7c0 20 16.2 36.3 36.3 36.3H128V440c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V256h91.7c20 0 36.3-16.2 36.3-36.3z"],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", "M573.7 2.3c3.1 3.1 3.1 8.2 0 11.3L343.3 244 386 286.7c3.8 3.8 6 9 6 14.4c0 10.3-7.6 18.9-17.8 20.2L336.5 326l2.5 32.7c3.2 41.4-11.9 82.2-41.3 111.6C271 497 234.8 512 197 512L21.9 512C9.8 512 0 502.2 0 490.1c0-6.4 2.8-12.5 7.7-16.6L93.3 400 112 384l-24.6 0-6.1 0c-9.6 0-17.3-7.8-17.3-17.3c0-29.9 11.9-58.5 33-79.7l8.7-8.7c29.4-29.4 70.2-44.5 111.6-41.3l32.7 2.5 4.7-37.7c1.3-10.2 9.9-17.8 20.2-17.8c5.4 0 10.6 2.1 14.4 6L332 232.7 562.3 2.3c3.1-3.1 8.2-3.1 11.3 0zM270.6 203.8l-5.6 45.1 62.1 62.1 45.1-5.6c2.2-.3 3.8-2.1 3.8-4.3c0-1.2-.5-2.3-1.3-3.1L278 201.3c-.8-.8-1.9-1.3-3.1-1.3c-2.2 0-4 1.6-4.3 3.8zM216.1 253c-36.8-2.8-73 10.6-99 36.6l-8.7 8.7C90.2 316.4 80 341 80 366.7c0 .7 .6 1.3 1.3 1.3H112c6.7 0 12.7 4.2 15 10.4s.5 13.3-4.6 17.7L18.1 485.6c-1.3 1.1-2.1 2.8-2.1 4.5c0 3.3 2.6 5.9 5.9 5.9L197 496c33.5 0 65.7-13.3 89.4-37c26.1-26.1 39.5-62.3 36.6-99l-2.5-32.8-71.6-71.6L216.1 253zM528 432a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm-144 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "drumstick": [512, 512, [127831], "f6d6", "M176 185.9C176 92.1 252.1 16 345.9 16C428.8 16 496 83.2 496 166.1C496 259.9 419.9 336 326.1 336h-97c-29.3 0-53.1-23.8-53.1-53.1v-97zM345.9 0C243.2 0 160 83.2 160 185.9v97c0 .6 0 1.2 0 1.8l-45.8 45.8c-3.1 3.1-9.6 3.6-15.7-.3C88.6 323.7 76.7 320 64 320c-35.3 0-64 28.7-64 64s28.7 64 64 64c0 35.3 28.7 64 64 64s64-28.7 64-64c0-12.7-3.7-24.6-10.1-34.6c-3.9-6.1-3.4-12.6-.3-15.7L227.3 352c.6 0 1.2 0 1.8 0h97C428.8 352 512 268.8 512 166.1C512 74.4 437.6 0 345.9 0zM208 348.7l-37.7 37.7c-10.3 10.3-8.2 25.8-1.8 35.6c4.8 7.5 7.6 16.4 7.6 25.9c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-8.7-7.3-16-16-16c-26.5 0-48-21.5-48-48s21.5-48 48-48c9.6 0 18.5 2.8 25.9 7.6c9.8 6.3 25.3 8.5 35.6-1.8L163.3 304c6.8 21.2 23.5 37.9 44.7 44.7z"],
    "square-v": [448, 512, [], "e284", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm111.2 52.4L224 374.1 336.8 148.4c2-4 6.8-5.6 10.7-3.6s5.6 6.8 3.6 10.7l-120 240c-1.4 2.7-4.1 4.4-7.2 4.4s-5.8-1.7-7.2-4.4l-120-240c-2-4-.4-8.8 3.6-10.7s8.8-.4 10.7 3.6z"],
    "face-awesome": [512, 512, ["gave-dandy"], "e409", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 208c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V192c0-30.9 25.1-56 56-56c.9 0 1.8 0 2.8 .1c-6.6 5.9-10.8 14.4-10.8 23.9c0 17.7 14.3 32 32 32c12.8 0 23.8-7.5 28.9-18.3c2 5.7 3.1 11.9 3.1 18.3v16zm-56-88c-39.8 0-72 32.2-72 72v16c0 17.7 14.3 32 32 32h80c17.7 0 32-14.3 32-32V192c0-39.8-32.2-72-72-72zm40 40a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm184 8a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-21.2-39.9c-6.6 5.9-10.8 14.4-10.8 23.9c0 17.7 14.3 32 32 32c15.1 0 27.8-10.5 31.1-24.5c5.6 9.5 8.9 20.7 8.9 32.5v17.9c0 7.8-6.3 14.1-14.1 14.1H286.1c-7.8 0-14.1-6.3-14.1-14.1V192c0-35.3 28.7-64 64-64c.9 0 1.8 0 2.8 .1zM256 192v17.9c0 16.6 13.5 30.1 30.1 30.1h99.8c16.6 0 30.1-13.5 30.1-30.1V192c0-44.2-35.8-80-80-80s-80 35.8-80 80zm4.7 240H248c-2.1 0-4.3 0-6.4-.1c7.5-36.4 39.7-63.9 78.4-63.9c17.7 0 34.1 5.8 47.3 15.5c-6.1 7.5-13.1 14.3-20.7 20.3c-24.2 17.7-53.9 28.2-86 28.2zm-35.1-1.6C154 420.2 96.9 361.8 89.5 288h305c6.4 0 11.4 5.5 10.8 11.9c-2.4 26.9-12.1 51.5-26.9 72C362.3 359.4 342 352 320 352c-47 0-86.1 33.8-94.4 78.4zm130.7-13.8c36-26.5 60.7-67.7 65-115.3c1.4-15.7-11-29.3-26.8-29.3H88.1c-8.6 0-15.4 7.5-14.6 16c8.2 90.2 83.9 160 174.5 160h12.7 4.7c34.2 0 65.8-11.7 90.9-31.4z"],
    "dial-off": [576, 512, [], "e162", "M272 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM280 288V431.8c-75.8-4.2-136-66.9-136-143.8c0-79.5 64.5-144 144-144s144 64.5 144 144c0 76.8-60.2 139.6-136 143.8V288c0-4.4-3.6-8-8-8s-8 3.6-8 8zm8 160a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM544 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM16 288a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0A32 32 0 1 0 0 288a32 32 0 1 0 64 0zM96 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM464 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 464a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm368-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "toggle-off": [576, 512, [], "f204", "M416 112c79.5 0 144 64.5 144 144s-64.5 144-144 144H160C80.5 400 16 335.5 16 256s64.5-144 144-144H416zM576 256c0-88.4-71.6-160-160-160H160C71.6 96 0 167.6 0 256s71.6 160 160 160H416c88.4 0 160-71.6 160-160zm-336 0A80 80 0 1 1 80 256a80 80 0 1 1 160 0zM64 256a96 96 0 1 0 192 0A96 96 0 1 0 64 256z"],
    "face-smile-horns": [640, 512, [], "e391", "M320 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496c141.4 0 256-114.6 256-256c0-27.9-4.5-54.8-12.7-79.9C616.4 111.7 634 38.9 639.8 9.6c.6-3.2-.7-6.4-3.4-8.2s-6.2-1.8-8.9 0C607.3 14.9 577.1 26.5 547 35.4c-27.3 8.2-53.8 14-71.6 17.2C432.4 19.6 378.5 0 320 0S207.6 19.6 164.5 52.6c-17.7-3.2-44.3-9-71.6-17.2c-30-9-60.2-20.6-80.5-34.1C9.7-.5 6.2-.4 3.5 1.4S-.5 6.4 .2 9.6C6 38.9 23.6 111.7 76.7 176.1C68.5 201.2 64 228.1 64 256c0 141.4 114.6 256 256 256zM556.8 158.6c-14.7-35.7-37.2-67.3-65.4-92.7c17-3.5 38.4-8.5 60.2-15.1c23.6-7.1 48.3-16 68.6-26.6c-8 32.4-25.5 85.4-63.4 134.4zM88.4 50.8c21.8 6.5 43.2 11.6 60.2 15.1c-28.2 25.4-50.7 57.1-65.4 92.7C45.3 109.6 27.8 56.6 19.8 24.2C40.1 34.8 64.7 43.7 88.4 50.8zm115 302.7c-3.6 2.5-4.5 7.5-2 11.1c22.4 32 61.9 67.4 118.6 67.4s96.1-35.4 118.6-67.4c2.5-3.6 1.7-8.6-2-11.1s-8.6-1.7-11.1 2C404.6 385.2 369.4 416 320 416s-84.6-30.8-105.4-60.6c-2.5-3.6-7.5-4.5-11.1-2zm37-65.4a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm176-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM194.5 200.4c-4.2-1.4-8.7 .9-10.1 5.1s.9 8.7 5.1 10.1l96 32c4.2 1.4 8.7-.9 10.1-5.1s-.9-8.7-5.1-10.1l-96-32zm256 15.2c4.2-1.4 6.5-5.9 5.1-10.1s-5.9-6.5-10.1-5.1l-96 32c-4.2 1.4-6.5 5.9-5.1 10.1s5.9 6.5 10.1 5.1l96-32z"],
    "box-archive": [512, 512, ["archive"], "f187", "M480 48H32c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16H48 464h16c8.8 0 16-7.2 16-16V64c0-8.8-7.2-16-16-16zm0 96H464 48 32c-17.7 0-32-14.3-32-32V64C0 46.3 14.3 32 32 32H480c17.7 0 32 14.3 32 32v48c0 17.7-14.3 32-32 32zM160 232c0-4.4 3.6-8 8-8H344c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8zm304-56h16V416c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V176H48V416c0 26.5 21.5 48 48 48H416c26.5 0 48-21.5 48-48V176z"],
    "grapes": [512, 512, [], "e306", "M358.7 18.6C350.6 28.4 336 49.7 336 74c0 17.2 3.3 28.4 8.8 37.9c5.7 9.8 14.1 18.3 25.6 29.8s19.9 19.8 29.8 25.6c9.5 5.5 20.7 8.8 37.9 8.8c24.3 0 45.6-14.6 55.4-22.7c1.5-1.3 2.6-3.4 2.6-6s-1-4.7-2.5-5.9c-9.8-7.8-32.7-22.8-62.8-22.8c-14 0-22.3 1.8-26.8 3.3c-2.2 .7-3.5 1.4-4.1 1.8c-.2 .1-.3 .2-.4 .3c-3.1 2.8-8 2.7-11-.3s-3.1-7.8-.3-11c0-.1 .1-.2 .2-.4c.4-.6 1-1.9 1.8-4.1c1.5-4.5 3.3-12.8 3.3-26.8c0-30.1-15-53-22.8-62.8c-1.2-1.5-3.2-2.5-5.9-2.5s-4.7 1-6 2.6zm50.7 62.8c0 9.7-.8 17.3-1.9 23.2c5.9-1.1 13.5-1.9 23.2-1.9c35.3 0 61.7 17.5 72.8 26.3c5.9 4.7 8.6 11.6 8.6 18.4s-2.7 13.7-8.4 18.4C493.1 174.3 468.1 192 438 192c-19.5 0-33.6-3.8-45.9-10.9c-11.8-6.9-21.6-16.7-32.6-27.6l-.5-.5-.5-.5 0 0c-11-10.9-20.8-20.8-27.6-32.6C323.8 107.6 320 93.5 320 74c0-30.1 17.7-55.1 26.3-65.6C351 2.7 357.9 0 364.7 0s13.7 2.7 18.4 8.6c8.8 11.1 26.3 37.4 26.3 72.8zM288 152a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM152 176a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM128 312a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM96 456a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm144-32a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm136-24a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM264 288a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm136-24a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM248 96a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM56 176a56 56 0 1 1 112 0A56 56 0 1 1 56 176zm32 80a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM56 400a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm144-32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm80 32a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zM224 232a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm80 32a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"],
    "person-drowning": [576, 512, [], "e545", "M197.3 241.8c4.5 3.5 6.7 9.2 5.9 14.8L185 384.1c-5.1-.5-10.4-1.5-15.7-2.9l18.1-126.9C140.8 217.5 112 160.7 112 98.7V72c0-22.1 17.9-40 40-40s40 17.9 40 40V98.7c0 52.1 34 98 83.8 113.2c40.2 12.2 83 13.6 123.9 3.8l95-22.6c21.5-5.1 43.1 8.2 48.2 29.6s-8.2 43.1-29.6 48.2l-95 22.6c-12.9 3.1-25.8 5.3-38.9 6.7l-14.9 81.8c-5.1-1.2-10.3-2.8-15.4-4.9l14.5-79.8c1.3-7 7-12.3 14-13c12.4-1.4 24.7-3.5 36.9-6.4l95-22.6c12.9-3.1 20.9-16 17.8-28.9s-16-20.9-28.9-17.8l-95 22.6c-43.7 10.4-89.3 9-132.3-4.1C214.6 210 176 157.8 176 98.7V72c0-13.3-10.7-24-24-24s-24 10.7-24 24V98.7c0 57 26.4 109.2 69.3 143zM320 176a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-64-48a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm38.6 275.4c8 11.2 17.5 21.4 27.6 30.7C339.5 449.8 361.5 464 384 464s44.6-14.2 61.8-29.9c10.1-9.2 19.7-19.5 27.6-30.7c1.5-2.1 3.9-3.4 6.6-3.4s5.1 1.3 6.6 3.4c7.3 10.3 15.9 19.6 25 28.3c15.7 14.8 36.1 29.2 57.4 31.9c4.4 .6 7.5 4.6 6.9 8.9s-4.6 7.5-8.9 6.9c-26.5-3.3-50-20.7-66.4-36.1c-8.8-8.3-15.9-16.4-20.6-22.2c-5.2 6.4-13.3 15.6-23.4 24.8c-18 16.3-43.9 34.1-72.6 34.1s-54.6-17.8-72.6-34.1c-10.2-9.2-18.2-18.4-23.4-24.8l0 0 0 0c-5.2 6.4-13.3 15.6-23.4 24.8c-18 16.3-43.9 34.1-72.6 34.1s-54.6-17.8-72.6-34.1c-10.2-9.2-18.2-18.4-23.4-24.8c-4.7 5.8-11.8 13.9-20.6 22.2C59 458.7 35.5 476.1 9 479.4c-4.4 .6-8.4-2.6-8.9-6.9s2.6-8.4 6.9-8.9c21.3-2.7 41.7-17.1 57.4-31.9c9.1-8.6 17.7-18 25-28.3c1.5-2.1 3.9-3.4 6.6-3.4s5.1 1.3 6.6 3.4c7.9 11.2 17.5 21.5 27.6 30.7C147.4 449.8 169.5 464 192 464s44.6-14.2 61.8-29.9c10.1-9.2 19.6-19.5 27.6-30.7c3-4.3 10.2-4.3 13.2 0z"],
    "dial-max": [576, 512, [], "e15e", "M272 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM282.3 293.7L384 395.3c-56.5 50.7-143.5 48.8-197.8-5.5c-56.2-56.2-56.2-147.4 0-203.6s147.4-56.2 203.6 0c54.3 54.3 56.2 141.3 5.5 197.8L293.7 282.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3zM401.1 401.1A160 160 0 1 0 174.9 174.9 160 160 0 1 0 401.1 401.1zM544 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM16 288a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0A32 32 0 1 0 0 288a32 32 0 1 0 64 0zM96 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM464 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 464a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm368-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "circle-m": [512, 512, [], "e115", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM142.5 131.4c-2-2.8-5.6-4-9-3s-5.6 4.1-5.6 7.6V376c0 4.4 3.6 8 8 8s8-3.6 8-8V161L249.5 308.6c1.5 2.1 3.9 3.4 6.5 3.4s5-1.2 6.5-3.4L368 161V376c0 4.4 3.6 8 8 8s8-3.6 8-8V136c0-3.5-2.2-6.6-5.6-7.6s-6.9 .1-9 3L256 290.2 142.5 131.4z"],
    "calendar-image": [448, 512, [], "e0d4", "M120 0c4.4 0 8 3.6 8 8V64H320V8c0-4.4 3.6-8 8-8s8 3.6 8 8V64h48c35.3 0 64 28.7 64 64v48 16V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V192 176 128C0 92.7 28.7 64 64 64h48V8c0-4.4 3.6-8 8-8zM432 192H16V448c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V192zM112 120V80H64c-26.5 0-48 21.5-48 48v48H432V128c0-26.5-21.5-48-48-48H336v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V80H128v40c0 4.4-3.6 8-8 8s-8-3.6-8-8zM262.8 286.9c-3.2-4.5-9.9-4.4-13 .2l-59.2 85.5c-1.4 2-3.5 3.2-5.9 3.4s-4.7-.6-6.4-2.3L151.7 347c-3.5-3.5-9.3-3-12.2 1l-51 71.3c-3.8 5.3 0 12.6 6.5 12.6H352.6c6.5 0 10.3-7.4 6.5-12.7L262.8 286.9zm-26.2-9c9.4-13.6 29.4-13.8 39.1-.5L372 409.9c11.5 15.9 .2 38.1-19.4 38.1H95.1c-19.5 0-30.9-22.1-19.5-37.9l51-71.3c8.6-12.1 26-13.5 36.5-3l19.9 19.9L236.6 278zM96 272a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", "M256 16a240 240 0 1 0 0 480 240 240 0 1 0 0-480zm0 496A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm0-160c-7.3 0-14.3-3-19.3-8.4L134.8 234.4c-4.4-4.7-6.8-10.8-6.8-17.2c0-13.9 11.3-25.2 25.2-25.2H358.8c13.9 0 25.2 11.3 25.2 25.2c0 6.4-2.4 12.5-6.8 17.2L275.3 343.6c-5 5.4-12 8.4-19.3 8.4zM153.2 208c-5.1 0-9.2 4.1-9.2 9.2c0 2.3 .9 4.6 2.5 6.3L248.4 332.7c2 2.1 4.7 3.3 7.6 3.3s5.6-1.2 7.6-3.3L365.5 223.5c1.6-1.7 2.5-4 2.5-6.3c0-5.1-4.1-9.2-9.2-9.2H153.2z"],
    "arrow-down-9-1": [576, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", "M427.9 184.1A68 68 0 1 1 428 48a68 68 0 1 1 -.1 136.1zM428 200c7.5 0 14.8-1 21.7-2.8L410 242.7c-2.9 3.3-2.6 8.4 .8 11.3s8.4 2.6 11.3-.8l65-74.6c6.3-7.3 11.6-15.4 15.6-24c6-11.6 9.4-24.7 9.4-38.7c0-.6 0-1.3 0-1.9c0-.7 0-1.4 0-2.1h-.1C509.8 67.5 473 32 428 32c-46.4 0-84 37.6-84 84s37.6 84 84 84zM165.7 477.7l112-112c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L168 452.7V40c0-4.4-3.6-8-8-8s-8 3.6-8 8V452.7L53.7 354.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l112 112c3.1 3.1 8.2 3.1 11.3 0zM436.4 289.3c-2.2-1.5-5.1-1.7-7.6-.7l-56 24c-4.1 1.7-5.9 6.4-4.2 10.5s6.4 5.9 10.5 4.2L424 308.1V464H376c-4.4 0-8 3.6-8 8s3.6 8 8 8h56 56c4.4 0 8-3.6 8-8s-3.6-8-8-8H440V296c0-2.7-1.4-5.2-3.6-6.7z"],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", "M256 16C123.5 16 16 123.5 16 256c0 99.6 60.7 185 147.1 221.4c4.1 1.7 6 6.4 4.3 10.5s-6.4 6-10.5 4.3C64.7 453.4 0 362.3 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 106.3-64.7 197.4-156.9 236.1c-4.1 1.7-8.8-.2-10.5-4.3s.2-8.8 4.3-10.5C435.3 441 496 355.6 496 256C496 123.5 388.5 16 256 16zM128.8 164.4c2-4 6.8-5.6 10.7-3.6l80 40c2.7 1.4 4.4 4.1 4.4 7.2s-1.7 5.8-4.4 7.2l-80 40c-4 2-8.8 .4-10.7-3.6s-.4-8.8 3.6-10.7L198.1 208l-65.7-32.8c-4-2-5.6-6.8-3.6-10.7zM184 409.9c0-23.2 18.8-41.9 41.9-41.9c11.1 0 21.8 4.4 29.7 12.3l.4 .4 .4-.4c7.9-7.9 18.5-12.3 29.7-12.3c23.2 0 41.9 18.8 41.9 41.9V440c0 39.8-32.2 72-72 72s-72-32.2-72-72V409.9zm64-14.6l-3.7-3.7c-4.9-4.9-11.5-7.6-18.3-7.6c-14.3 0-25.9 11.6-25.9 25.9V440c0 30.9 25.1 56 56 56s56-25.1 56-56V409.9c0-14.3-11.6-25.9-25.9-25.9c-6.9 0-13.5 2.7-18.3 7.6l-3.7 3.7V424c0 4.4-3.6 8-8 8s-8-3.6-8-8V395.3zM372.4 160.8c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7L313.9 208l65.7 32.8c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-80-40c-2.7-1.4-4.4-4.1-4.4-7.2s1.7-5.8 4.4-7.2l80-40zM149.4 321c32.6 8.1 68.6 12.6 106.6 12.6s74-4.5 106.6-12.6c11.1-2.8 22.3 .3 29.6 6.9c3.7 3.4 6.5 7.8 7.5 13.1c1 5.3 0 10.9-2.9 16.1c-10 17.5-23.6 32.9-39.8 45.3c-3.5 2.7-8.5 2-11.2-1.5s-2-8.5 1.5-11.2c14.6-11.2 26.7-25 35.7-40.6c1.2-2.1 1.3-3.8 1.1-5.1c-.3-1.4-1.1-2.9-2.6-4.3c-3.1-2.9-8.8-4.7-14.9-3.2c-33.9 8.4-71.2 13.1-110.4 13.1s-76.5-4.7-110.4-13.1c-6.1-1.5-11.7 .3-14.9 3.2c-1.5 1.4-2.3 2.9-2.6 4.3c-.2 1.3-.1 3 1.1 5.1c8.9 15.6 21.1 29.4 35.7 40.6c3.5 2.7 4.2 7.7 1.5 11.2s-7.7 4.2-11.2 1.5c-16.2-12.4-29.8-27.8-39.8-45.3c-3-5.2-3.9-10.7-2.9-16.1c1-5.2 3.8-9.7 7.5-13.1c7.3-6.7 18.5-9.7 29.6-6.9z"],
    "shish-kebab": [512, 512, [], "f821", "M352 88c0-39.8 32.2-72 72-72s72 32.2 72 72c0 16.2-5.4 31.2-14.4 43.2c-2.7 3.5-1.9 8.5 1.6 11.2s8.5 1.9 11.2-1.6c11-14.7 17.6-33 17.6-52.8c0-48.6-39.4-88-88-88s-88 39.4-88 88c0 11.7 2.3 22.9 6.4 33.1c6.2 15.2 5.8 31.3-3.3 40.4l-24.8 24.8L264 136c-17.7-17.7-46.3-17.7-64 0l-32 32c-17.7 17.7-17.7 46.3 0 64L280 344c17.7 17.7 46.3 17.7 64 0l32-32c17.7-17.7 17.7-46.3 0-64l-50.3-50.3 24.8-24.8c15.9-15.9 13.9-40.2 6.8-57.8c-3.4-8.3-5.3-17.5-5.3-27.1zM101.7 421.7L152 472c17.7 17.7 46.3 17.7 64 0l40-40c17.7-17.7 17.7-46.3 0-64L144 256c-17.7-17.7-46.3-17.7-64 0L40 296c-17.7 17.7-17.7 46.3 0 64l50.3 50.3-88 88c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l88-88zm77.7-201c-11.4-11.4-11.4-29.9 0-41.4l32-32c11.4-11.4 29.9-11.4 41.4 0l112 112c11.4 11.4 11.4 29.9 0 41.4l-32 32c-11.4 11.4-29.9 11.4-41.4 0l-112-112zm-128 128c-11.4-11.4-11.4-29.9 0-41.4l40-40c11.4-11.4 29.9-11.4 41.4 0l112 112c11.4 11.4 11.4 29.9 0 41.4l-40 40c-11.4 11.4-29.9 11.4-41.4 0l-112-112z"],
    "spray-can": [512, 512, [], "f5bd", "M96 40v80 8h16v-8V40c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24v80 8h16v-8V40c0-22.1-17.9-40-40-40H136C113.9 0 96 17.9 96 40zM224 176c44.2 0 80 35.8 80 80V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V256c0-44.2 35.8-80 80-80H224zM96 160c-53 0-96 43-96 96V448c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64V256c0-53-43-96-96-96H96zM232 336A72 72 0 1 1 88 336a72 72 0 1 1 144 0zm-72-88a88 88 0 1 0 0 176 88 88 0 1 0 0-176zM320 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM512 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM496 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM400 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "alarm-snooze": [512, 512, [], "f845", "M157.4 25c3.2 3 3.4 8.1 .4 11.3s-8.1 3.4-11.3 .4C132.7 23.9 114.1 16 93.7 16C50.8 16 16 50.8 16 93.7c0 15.4 4.4 29.7 12.1 41.7c2.4 3.7 1.3 8.7-2.4 11s-8.7 1.3-11-2.4C5.4 129.5 0 112.2 0 93.7C0 42 42 0 93.7 0c24.6 0 47 9.5 63.7 25zm-54.1 427L45.7 509.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l57.7-57.7C54.8 400.6 32 347 32 288C32 164.3 132.3 64 256 64s224 100.3 224 224c0 59-22.8 112.6-60.1 152.6l57.7 57.7c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-57.7-57.7C368.6 489.2 315 512 256 512s-112.6-22.8-152.6-60.1zM464 288A208 208 0 1 0 48 288a208 208 0 1 0 416 0zM354.6 25C371.3 9.5 393.7 0 418.3 0C470 0 512 42 512 93.7c0 18.5-5.4 35.8-14.6 50.3c-2.4 3.7-7.3 4.8-11 2.4s-4.8-7.3-2.4-11c7.7-12 12.1-26.3 12.1-41.7C496 50.8 461.2 16 418.3 16c-20.4 0-39 7.9-52.8 20.7c-3.2 3-8.3 2.8-11.3-.4s-2.8-8.3 .4-11.3zM192 192H320c3 0 5.8 1.7 7.1 4.4s1.1 5.9-.7 8.3L207.7 368H320c4.4 0 8 3.6 8 8s-3.6 8-8 8H192c-3 0-5.8-1.7-7.1-4.4s-1.1-5.9 .7-8.3L304.3 208H192c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "scarecrow": [448, 512, [], "f70d", "M224 16a88 88 0 1 1 0 176 88 88 0 1 1 0-176zm0 192c43.3 0 80.4-26.4 96-64h91l-10.2 20.4c-1.7 3.5-.7 7.7 2.4 10L426.7 192l-23.5 17.6c-3.1 2.3-4.1 6.5-2.4 10L411.1 240H331.5c-15.1 0-26.5 13.9-23.5 28.7l25 124.8-49.4-24.7c-2.4-1.2-5.2-1.1-7.5 .2l-52 29.7-52-29.7c-2.3-1.3-5.2-1.4-7.5-.2l-49.4 24.7 25-124.8c3-14.9-8.4-28.7-23.5-28.7H36.9l10.2-20.4c1.7-3.5 .7-7.7-2.4-10L21.3 192l23.5-17.6c3.1-2.3 4.1-6.5 2.4-10L36.9 144h91c15.7 37.6 52.8 64 96 64zm200-80H325.2c1.8-7.7 2.8-15.7 2.8-24C328 46.6 281.4 0 224 0S120 46.6 120 104c0 8.3 1 16.3 2.8 24H24c-2.8 0-5.3 1.4-6.8 3.8s-1.6 5.3-.4 7.8l13 26-26.7 20c-2 1.5-3.2 3.9-3.2 6.4s1.2 4.9 3.2 6.4l26.7 20-13 26c-1.2 2.5-1.1 5.4 .4 7.8s4 3.8 6.8 3.8h92.5c5 0 8.8 4.6 7.8 9.6L96.2 406.4c-.6 3 .6 6.1 3 7.9s5.7 2.2 8.4 .8l60.2-30.1L220 414.9c2.5 1.4 5.5 1.4 7.9 0l52.3-29.9 60.2 30.1c2.7 1.4 6 1.1 8.4-.8s3.6-4.9 3-7.9L323.7 265.6c-1-5 2.8-9.6 7.8-9.6H424c2.8 0 5.3-1.4 6.8-3.8s1.6-5.3 .3-7.8l-13-26 26.7-20c2-1.5 3.2-3.9 3.2-6.4s-1.2-4.9-3.2-6.4l-26.7-20 13-26c1.2-2.5 1.1-5.4-.3-7.8s-4-3.8-6.8-3.8zM208 88a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM216 504c0 4.4 3.6 8 8 8s8-3.6 8-8V435.1c-5.3 1.2-10.7 1.2-16 0V504z"],
    "truck-monster": [640, 512, [], "f63b", "M256 16c-8.8 0-16 7.2-16 16v96H471.2L387.4 24.9C382.8 19.3 376 16 368.8 16H256zM88 128H224V32c0-17.7 14.3-32 32-32H368.8c12 0 23.4 5.4 31 14.8l92 113.2H552c30.9 0 56 25.1 56 56v67.8c2 1.9 3.9 3.9 5.8 5.9c3 3.2 2.9 8.3-.3 11.3s-8.3 2.9-11.3-.3C571.5 236.2 528.1 216 480 216c-59 0-110.8 30.4-140.8 76.4c-1.5 2.3-4 3.6-6.7 3.6H307.5c-2.7 0-5.2-1.4-6.7-3.6C270.8 246.4 219 216 160 216c-48.1 0-91.5 20.2-122.2 52.7c-3 3.2-8.1 3.4-11.3 .3s-3.4-8.1-.3-11.3c1.9-2 3.8-4 5.8-5.9V184c0-30.9 25.1-56 56-56zM48 238c31-23.8 69.9-38 112-38c63 0 118.7 31.7 151.8 80h16.4c33.1-48.3 88.8-80 151.8-80c42.1 0 81 14.2 112 38V184c0-22.1-17.9-40-40-40H488.1h-.1H232 88c-22.1 0-40 17.9-40 40v54zm106 26c-7.7 0-14.2 5.5-15.7 12.8c-.6 2.9-2.7 5.3-5.6 6.1c-6.8 2-13.2 4.7-19.3 8c-2.6 1.4-5.8 1.3-8.3-.3c-6.2-4.1-14.7-3.4-20.1 2L76.6 301c-5.5 5.5-6.2 13.9-2 20.1c1.6 2.5 1.8 5.7 .3 8.3c-3.3 6.1-6 12.5-8 19.3c-.8 2.9-3.2 5-6.1 5.6C53.5 355.8 48 362.3 48 370v12c0 7.7 5.5 14.2 12.8 15.7c2.9 .6 5.3 2.7 6.1 5.6c2 6.8 4.7 13.2 8 19.3c1.4 2.6 1.3 5.8-.3 8.3c-4.1 6.2-3.4 14.7 2 20.1l8.5 8.5c5.5 5.5 13.9 6.2 20.1 2c2.5-1.6 5.7-1.8 8.3-.3c6.1 3.3 12.5 6 19.3 8c2.9 .8 5 3.2 5.6 6.1c1.5 7.3 7.9 12.8 15.7 12.8h12c7.7 0 14.2-5.5 15.7-12.8c.6-2.9 2.7-5.3 5.6-6.1c6.8-2 13.2-4.7 19.3-8c2.6-1.4 5.8-1.3 8.3 .3c6.2 4.1 14.7 3.4 20.1-2l8.5-8.5c5.5-5.5 6.2-13.9 2-20.1c-1.6-2.5-1.8-5.7-.3-8.3c3.3-6.1 6-12.5 8-19.3c.8-2.9 3.2-5 6.1-5.6c7.3-1.5 12.8-7.9 12.8-15.7V370c0-7.7-5.5-14.2-12.8-15.7c-2.9-.6-5.3-2.7-6.1-5.6c-2-6.8-4.7-13.2-8-19.3c-1.4-2.6-1.3-5.8 .3-8.3c4.1-6.2 3.4-14.7-2-20.1l-8.5-8.5c-5.5-5.5-13.9-6.2-20.1-2c-2.5 1.6-5.7 1.8-8.3 .3c-6.1-3.3-12.5-6-19.3-8c-2.9-.8-5-3.2-5.6-6.1c-1.5-7.3-7.9-12.8-15.7-12.8H154zm-30 4.9c4.5-12.2 16.2-20.9 30-20.9h12c13.8 0 25.5 8.7 30 20.9c4.9 1.7 9.7 3.6 14.3 5.9c11.8-5.4 26.2-3.3 36 6.5l8.5 8.5c9.7 9.7 11.9 24.2 6.5 36c2.3 4.6 4.3 9.4 5.9 14.3c12.2 4.5 20.9 16.2 20.9 30v12c0 13.8-8.7 25.5-20.9 30c-1.7 4.9-3.6 9.7-5.9 14.3c5.4 11.8 3.3 26.2-6.5 36l-8.5 8.5c-9.7 9.7-24.2 11.9-36 6.5c-4.6 2.3-9.4 4.3-14.3 5.9c-4.5 12.2-16.2 20.9-30 20.9H154c-13.8 0-25.5-8.7-30-20.9c-4.9-1.7-9.7-3.6-14.3-5.9c-11.8 5.4-26.2 3.3-36-6.5l-8.5-8.5c-9.7-9.7-11.9-24.2-6.5-36c-2.3-4.6-4.3-9.4-5.9-14.3C40.7 407.5 32 395.8 32 382V370c0-13.8 8.7-25.5 20.9-30c1.7-4.9 3.6-9.7 5.9-14.3c-5.4-11.8-3.3-26.2 6.5-36l8.5-8.5c9.7-9.7 24.2-11.9 36-6.5c4.6-2.3 9.4-4.3 14.3-5.9zM160 336a40 40 0 1 0 0 80 40 40 0 1 0 0-80zm56 40a56 56 0 1 1 -112 0 56 56 0 1 1 112 0zm242.3-99.2c-.6 2.9-2.7 5.3-5.6 6.1c-6.8 2-13.2 4.7-19.3 8c-2.6 1.4-5.8 1.3-8.3-.3c-6.2-4.1-14.7-3.4-20.1 2l-8.5 8.5c-5.5 5.5-6.2 13.9-2 20.1c1.6 2.5 1.8 5.7 .3 8.3c-3.3 6.1-6 12.5-8 19.3c-.8 2.9-3.2 5-6.1 5.6c-7.3 1.5-12.8 7.9-12.8 15.7v12c0 7.7 5.5 14.2 12.8 15.7c2.9 .6 5.3 2.7 6.1 5.6c2 6.8 4.7 13.2 8 19.3c1.4 2.6 1.3 5.8-.3 8.3c-4.1 6.2-3.4 14.7 2 20.1l8.5 8.5c5.5 5.5 13.9 6.2 20.1 2c2.5-1.6 5.7-1.8 8.3-.3c6.1 3.3 12.5 6 19.3 8c2.9 .8 5 3.2 5.6 6.1c1.5 7.3 7.9 12.8 15.7 12.8h12c7.7 0 14.2-5.5 15.7-12.8c.6-2.9 2.7-5.3 5.6-6.1c6.8-2 13.2-4.7 19.3-8c2.6-1.4 5.8-1.3 8.3 .3c6.2 4.1 14.7 3.4 20.1-2l8.5-8.5c5.5-5.5 6.2-13.9 2-20.1c-1.6-2.5-1.8-5.7-.3-8.3c3.3-6.1 6-12.5 8-19.3c.8-2.9 3.2-5 6.1-5.6c7.3-1.5 12.8-7.9 12.8-15.7V370c0-7.7-5.5-14.2-12.8-15.7c-2.9-.6-5.3-2.7-6.1-5.6c-2-6.8-4.7-13.2-8-19.3c-1.4-2.6-1.3-5.8 .3-8.3c4.1-6.2 3.4-14.7-2-20.1l-8.5-8.5c-5.5-5.5-13.9-6.2-20.1-2c-2.5 1.6-5.7 1.8-8.3 .3c-6.1-3.3-12.5-6-19.3-8c-2.9-.8-5-3.2-5.6-6.1c-1.5-7.3-7.9-12.8-15.7-12.8H474c-7.7 0-14.2 5.5-15.7 12.8zM474 248h12c13.8 0 25.5 8.7 30 20.9c4.9 1.7 9.7 3.6 14.3 5.9c11.8-5.4 26.2-3.3 36 6.5l8.5 8.5c9.7 9.7 11.9 24.2 6.5 36c2.3 4.6 4.3 9.4 5.9 14.3c12.2 4.5 20.9 16.2 20.9 30v12c0 13.8-8.7 25.5-20.9 30c-1.7 4.9-3.6 9.7-5.9 14.3c5.4 11.8 3.3 26.2-6.5 36l-8.5 8.5c-9.7 9.7-24.2 11.9-36 6.5c-4.6 2.3-9.4 4.3-14.3 5.9c-4.5 12.2-16.2 20.9-30 20.9H474c-13.8 0-25.5-8.7-30-20.9c-4.9-1.7-9.7-3.6-14.3-5.9c-11.8 5.4-26.2 3.3-36-6.5l-8.5-8.5c-9.7-9.7-11.9-24.2-6.5-36c-2.3-4.6-4.3-9.4-5.9-14.3c-12.2-4.5-20.9-16.2-20.9-30V370c0-13.8 8.7-25.5 20.9-30c1.7-4.9 3.6-9.7 5.9-14.3c-5.4-11.8-3.3-26.2 6.5-36l8.5-8.5c9.7-9.7 24.2-11.9 36-6.5c4.6-2.3 9.4-4.3 14.3-5.9c4.5-12.2 16.2-20.9 30-20.9zM440 376a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm40 56a56 56 0 1 1 0-112 56 56 0 1 1 0 112z"],
    "gift-card": [576, 512, [], "f663", "M405.1 16c-20.3 0-39.2 10.5-50 27.7L302.4 128H328h80c30.9 0 56-25.1 56-56s-25.1-56-56-56h-2.9zM273.6 128L220.9 43.7C210.1 26.5 191.2 16 170.9 16H168c-30.9 0-56 25.1-56 56s25.1 56 56 56h80 25.6zm14.4-7.1l53.6-85.7C355.3 13.3 379.3 0 405.1 0H408c39.8 0 72 32.2 72 72c0 22.6-10.4 42.8-26.7 56H512c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V192c0-35.3 28.7-64 64-64h58.7C106.4 114.8 96 94.6 96 72c0-39.8 32.2-72 72-72h2.9c25.8 0 49.8 13.3 63.5 35.2L288 120.9zM168 144H64c-26.5 0-48 21.5-48 48v96H560V192c0-26.5-21.5-48-48-48H408 328 305.1l69.1 82.9c2.8 3.4 2.4 8.4-1 11.3s-8.4 2.4-11.3-1L288 148.5l-73.9 88.6c-2.8 3.4-7.9 3.9-11.3 1s-3.9-7.9-1-11.3L270.9 144H248 168zM16 304v96H560V304H16zM560 448V416H16v32c0 26.5 21.5 48 48 48H512c26.5 0 48-21.5 48-48z"],
    "w": [576, 512, [119], "57", "M5.4 32.5c4.2-1.5 8.7 .7 10.2 4.9L159.4 446l121-408.3c1-3.4 4.1-5.7 7.7-5.7s6.7 2.3 7.7 5.7L416.7 446 560.5 37.3c1.5-4.2 6-6.4 10.2-4.9s6.4 6 4.9 10.2l-152 432c-1.2 3.3-4.3 5.4-7.7 5.3s-6.5-2.4-7.5-5.7L288 68.2 167.7 474.3c-1 3.3-4 5.6-7.5 5.7s-6.6-2.1-7.7-5.3L.5 42.7c-1.5-4.2 .7-8.7 4.9-10.2z"],
    "code-pull-request-draft": [448, 512, [], "e3fa", "M32 64a48 48 0 1 1 96 0A48 48 0 1 1 32 64zm56 63.5c31.6-3.9 56-30.9 56-63.5c0-35.3-28.7-64-64-64S16 28.7 16 64c0 32.6 24.4 59.6 56 63.5v257c-31.6 3.9-56 30.9-56 63.5c0 35.3 28.7 64 64 64s64-28.7 64-64c0-32.6-24.4-59.6-56-63.5v-257zM32 448a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-456a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 64a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM344 240a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0z"],
    "square-b": [448, 512, [], "e264", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm128 56c0-13.3 10.7-24 24-24h84c37.6 0 68 30.4 68 68c0 22.1-10.6 41.8-26.9 54.2c29.3 7.6 50.9 34.2 50.9 65.8c0 37.6-30.4 68-68 68H152c-13.3 0-24-10.7-24-24V256 152zm160 44c0-28.7-23.3-52-52-52H152c-4.4 0-8 3.6-8 8v96h92c28.7 0 52-23.3 52-52zM144 360c0 4.4 3.6 8 8 8H260c28.7 0 52-23.3 52-52s-23.3-52-52-52H236 144v96z"],
    "elephant": [640, 512, [128024], "f6da", "M208 111.8C208 58.9 250.9 16 303.8 16c50.1 0 91.7 38.6 95.6 88.5l.6 8.1c.3 4.4 4.2 7.7 8.6 7.4s7.7-4.2 7.4-8.6l-.6-8.1c-1.6-20.5-8.6-39.4-19.6-55.2C469.1 50 528 110.1 528 184V328c0 4.4 3.6 8 8 8s8-3.6 8-8V184c0-83.9-68.1-152-152-152h-9.8C361.9 12.2 334.2 0 303.8 0c-30.6 0-58.2 12.3-78.4 32.1C118 35.6 32 123.7 32 232v32c0 25.9-7.6 52.9-15.5 73.7c-3.9 10.3-7.8 19-10.7 25c-1.5 3-2.7 5.4-3.5 7c-.4 .8-.7 1.4-1 1.8l-.2 .4-.1 .1 0 0 0 0 0 0c-2.2 3.9-.8 8.7 3.1 10.9s8.7 .8 10.9-3.1L8 376c7 3.9 7 3.9 7 3.9l0 0 0 0 0 0 .1-.1 .3-.5c.3-.5 .6-1.1 1.1-2c.9-1.7 2.2-4.3 3.7-7.5c3.1-6.4 7.2-15.5 11.3-26.3C39.6 321.8 48 292.7 48 264V232c0-94.6 71.4-172.5 163.2-182.8C199.1 67 192 88.6 192 111.8c0 58.4 45 107 103.3 111.5l8.1 .6c4.4 .3 8.3-3 8.6-7.4s-3-8.3-7.4-8.6l-8.1-.6c-49.9-3.8-88.5-45.5-88.5-95.6zM416 304c0-4.4-3.6-8-8-8s-8 3.6-8 8V472c0 13.3-10.7 24-24 24H328c-13.3 0-24-10.7-24-24V397.5c1.6-1 3.1-2 4.6-3c3.6-2.5 4.5-7.5 2-11.1s-7.5-4.5-11.1-2C282.6 393.1 262.1 400 240 400s-42.6-6.9-59.4-18.6c-3.6-2.5-8.6-1.6-11.1 2s-1.6 8.6 2 11.1c1.5 1 3 2.1 4.6 3V472c0 13.3-10.7 24-24 24H104c-13.3 0-24-10.7-24-24V336c0-4.4-3.6-8-8-8s-8 3.6-8 8V472c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V406c14.7 6.4 30.9 10 48 10s33.3-3.6 48-10v66c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V341.3c16.8 18.6 38.9 32.3 64 38.7v18.5c0 45 36.5 81.4 81.4 81.4c30.8 0 59-17.4 72.8-45l2.3-4.7c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3l-2.3 4.7c-3 5.9-9 9.6-15.6 9.6c-9.6 0-17.4-7.8-17.4-17.4V380c23.3-5.9 44.1-18.2 60.4-34.8c3.1-3.2 3-8.2-.1-11.3s-8.2-3-11.3 .1c-20.6 21-49.2 34-81 34c-40.4 0-75.9-21.2-96-53.1V304zm112 79v15.5c0 18.5 15 33.4 33.4 33.4c12.7 0 24.2-7.2 29.9-18.5l2.3-4.7c4-7.9 13.6-11.1 21.5-7.2s11.1 13.6 7.2 21.5l-2.3 4.7C608.9 450 586.2 464 561.4 464c-36.1 0-65.4-29.3-65.4-65.4V383c5.2 .6 10.6 1 16 1s10.8-.3 16-1zM480 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "earth-africa": [512, 512, [127757, "globe-africa"], "f57c", "M496 256c0-13.8-1.2-27.3-3.4-40.5l-65.2-13c-4.1-.8-8.3 1.2-10.2 5c-7.6 15.1-25.1 22.4-41.2 17L362 219.8c-4.8-1.6-10-.3-13.6 3.2c-.6 .6-.6 1.5 0 2.1l33.5 33.5c6.5 6.5 10.2 15.4 10.2 24.6c0 16-10.9 29.9-26.3 33.7l-5.3 1.3c-.2 0-.3 .2-.3 .4v12.1c0 15.6-5.1 30.7-14.4 43.2L320 408c-7.6 10.1-19.4 16-32 16c-22.1 0-40-17.9-40-40V336c0-4.4-3.6-8-8-8H208c-30.9 0-56-25.1-56-56V244c0-15.1 7.1-29.3 19.2-38.4l39.4-29.5c7-5.2 15.5-8.1 24.2-8.1c4.3 0 8.6 .7 12.7 2.1l32 10.7c5.8 1.9 12 2.2 17.9 .7l35.4-8.8c6.6-1.7 11.3-7.6 11.3-14.4c0-5.6-3.2-10.8-8.2-13.3l-29.2-14.6c-.6-.3-1.3-.2-1.8 .3l-3.9 3.9c-6.1 6.1-14.4 9.5-23.1 9.5c-5.1 0-10.1-1.2-14.6-3.4L248 132.9c-3.4-1.7-7.5-.8-9.8 2.2l-13.6 17c-8.5 10.6-24.3 11.5-33.9 1.9c-4.3-4.3-6.7-10.1-6.7-16.1V96.5c0-4.2-1.1-8.3-3.2-11.9L154.5 38.5C72.7 76.7 16 159.7 16 256c0 132.5 107.5 240 240 240s240-107.5 240-240zm-6.9-57.5C463.3 93.7 368.7 16 256 16c-30.6 0-59.8 5.7-86.7 16.1l25.4 44.5c3.5 6 5.3 12.9 5.3 19.8v41.4c0 1.8 .7 3.5 2 4.8c2.9 2.9 7.6 2.6 10.1-.6l13.6-17c7.1-8.8 19.4-11.5 29.5-6.5l15.2 7.6c2.3 1.2 4.8 1.8 7.4 1.8c4.4 0 8.6-1.7 11.7-4.9l3.9-3.9c5.3-5.3 13.5-6.7 20.2-3.3l29.2 14.6c10.5 5.2 17.1 15.9 17.1 27.6c0 14.2-9.6 26.5-23.4 30l-35.4 8.8c-8.9 2.2-18.2 1.9-26.8-1l-32-10.7c-2.5-.8-5.1-1.2-7.7-1.2c-5.3 0-10.4 1.7-14.6 4.9l-39.4 29.5c-8.1 6-12.8 15.5-12.8 25.6v28c0 22.1 17.9 40 40 40h32c13.3 0 24 10.7 24 24v48c0 13.3 10.7 24 24 24c7.6 0 14.7-3.6 19.2-9.6l25.6-34.1c7.3-9.7 11.2-21.5 11.2-33.6V318.6c0-7.5 5.1-14.1 12.5-16l5.3-1.3c8.4-2.1 14.2-9.6 14.2-18.2c0-5-2-9.8-5.5-13.3L337 236.3c-6.8-6.8-6.8-17.9 0-24.7c7.8-7.8 19.5-10.6 30-7.1l14.1 4.7c8.5 2.8 17.8-1 21.8-9c5.1-10.2 16.4-15.7 27.6-13.5l58.5 11.7zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "rainbow": [640, 512, [127752], "f75b", "M320 48C152.1 48 16 184.1 16 352V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V352C0 175.3 143.3 32 320 32s320 143.3 320 320V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V352C624 184.1 487.9 48 320 48zm0 192c-61.9 0-112 50.1-112 112V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V352c0-70.7 57.3-128 128-128s128 57.3 128 128V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V352c0-61.9-50.1-112-112-112zM104 360V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V360c0-128.1 103.9-232 232-232s232 103.9 232 232V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V360c0-119.3-96.7-216-216-216s-216 96.7-216 216z"],
    "circle-notch": [512, 512, [], "f1ce", "M199.7 14.3c1.1 4.3-1.4 8.7-5.7 9.8C91.5 51.4 16 144.9 16 256c0 132.5 107.5 240 240 240s240-107.5 240-240c0-111.1-75.5-204.6-178.1-231.9c-4.3-1.1-6.8-5.5-5.7-9.8s5.5-6.8 9.8-5.7C431.4 37.7 512 137.4 512 256c0 141.4-114.6 256-256 256S0 397.4 0 256C0 137.4 80.6 37.7 189.9 8.6c4.3-1.1 8.7 1.4 9.8 5.7z"],
    "tablet-screen-button": [448, 512, ["tablet-alt"], "f3fa", "M384 16c26.5 0 48 21.5 48 48V352H16V64c0-26.5 21.5-48 48-48H384zm48 352v80c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V368H432zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM224 448a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32-16a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"],
    "paw": [512, 512, [], "f1b0", "M212.5 148.3c-4.7 13.9-13.3 22.8-23.6 26.2c-10.3 3.4-22.7 1.3-34.9-7.1s-23.2-22.7-29.4-41.2s-5.9-36.4-1.2-50.3c4.7-13.9 13.3-22.8 23.6-26.2c10.3-3.4 22.7-1.3 34.9 7.1s23.2 22.7 29.4 41.2s5.9 36.4 1.2 50.3zm-18.6 41.4c32.3-10.6 46.9-53.9 32.6-96.8S174.4 23.8 142.1 34.3s-46.9 53.9-32.6 96.8s52.1 69.1 84.4 58.5zm-98.3 56c-1.4 11.4-6.5 19.3-13.4 23.2c-6.9 4-16.4 4.5-27.2-.1s-21.7-13.9-29.6-27.4s-10.5-27.6-9.1-39c1.4-11.4 6.5-19.3 13.4-23.2c6.9-4 16.4-4.5 27.2 .1s21.7 13.9 29.6 27.4s10.5 27.6 9.1 39zm-5.5 37.1c24.5-14 29.1-51.7 10.2-84.1s-54-47.3-78.5-33.3s-29.1 51.7-10.2 84.1s54 47.3 78.5 33.3zM256 240c33.5 0 121.3 30.7 171.8 166.8c2.9 7.7 4.2 16.2 4.2 24.9v4.4c0 15.4-12.5 27.9-27.9 27.9c-11.7 0-23.3-1.8-34.5-5.3l-80.2-25.1c-21.8-6.8-45.1-6.8-66.8 0l-80.2 25.1c-11.2 3.5-22.8 5.3-34.5 5.3C92.5 464 80 451.5 80 436.1v-4.4c0-8.8 1.3-17.2 4.2-24.9C134.7 270.7 222.5 240 256 240zm0-16c-41.3 0-134.4 35.9-186.8 177.2c-3.6 9.7-5.2 20.1-5.2 30.5v4.4c0 24.2 19.7 43.9 43.9 43.9c13.3 0 26.6-2 39.3-6l80.2-25.1c18.6-5.8 38.6-5.8 57.3 0L364.8 474c12.7 4 26 6 39.3 6c24.2 0 43.9-19.7 43.9-43.9v-4.4c0-10.4-1.6-20.8-5.2-30.5C390.4 259.9 297.3 224 256 224zm169.5-17.4c7.9-13.5 18.8-22.8 29.6-27.4s20.2-4 27.2-.1c6.9 4 12.1 11.8 13.4 23.2c1.4 11.4-1.2 25.5-9.1 39s-18.8 22.8-29.6 27.4s-20.2 4-27.2 .1c-6.9-4-12.1-11.8-13.4-23.2c-1.4-11.4 1.2-25.5 9.1-39zm-13.8-8c-18.9 32.4-14.3 70.1 10.2 84.1s59.7-.9 78.5-33.3s14.3-70.1-10.2-84.1s-59.7 .9-78.5 33.3zM292.7 97.9c6.2-18.5 17.2-32.8 29.4-41.2s24.5-10.5 34.9-7.1c10.3 3.4 18.9 12.3 23.6 26.2c4.7 13.9 5 31.9-1.2 50.3s-17.2 32.8-29.4 41.2s-24.5 10.5-34.9 7.1c-10.3-3.4-18.9-12.3-23.6-26.2c-4.7-13.9-5-31.9 1.2-50.3zm-15.2-5.1c-14.3 42.9 .3 86.2 32.6 96.8s70.1-15.6 84.4-58.5s-.3-86.2-32.6-96.8S291.8 50 277.5 92.9z"],
    "message-question": [512, 512, [], "e1e3", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM168 136l0 6.5c0 4.4 3.6 8 8 8s8-3.6 8-8l0-6.5c0-22.1 17.9-40 40-40h56.2c26.4 0 47.8 21.4 47.8 47.8c0 16.1-8.1 31.1-21.5 39.9l-54.9 36.2c-2.2 1.5-3.6 4-3.6 6.7V256c0 4.4 3.6 8 8 8s8-3.6 8-8V230.9L315.3 197c17.9-11.8 28.7-31.8 28.7-53.3c0-35.2-28.6-63.8-63.8-63.8H224c-30.9 0-56 25.1-56 56zM272 304a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "cloud": [640, 512, [9729], "f0c2", "M523.6 234.2c2.3 4.1 6.2 7.1 10.9 8C585.5 252.6 624 297.8 624 352c0 61.9-50.1 112-112 112H144C73.3 464 16 406.7 16 336c0-55.8 35.7-103.3 85.5-120.8c6.7-2.4 11-8.8 10.7-15.9c-.1-2.4-.2-4.9-.2-7.3c0-79.5 64.5-144 144-144c53.3 0 99.9 29 124.8 72.2c2.2 3.8 5.9 6.6 10.2 7.6s8.8 .2 12.5-2.3c12.7-8.5 28-13.5 44.4-13.5c44.2 0 80 35.8 80 80c0 10.2-1.9 19.9-5.3 28.8c-1.7 4.4-1.4 9.3 .9 13.4zM386 98.7C357 58.3 309.6 32 256 32C167.6 32 96 103.6 96 192c0 2.7 .1 5.4 .2 8.1C40.2 219.8 0 273.2 0 336c0 79.5 64.5 144 144 144H512c70.7 0 128-57.3 128-128c0-56.3-36.4-104.1-86.9-121.3c-5-1.7-10.2-3.1-15.5-4.2c1.9-5 3.4-10.1 4.5-15.4c1.3-6.2 1.9-12.6 1.9-19.2c0-53-43-96-96-96c-15.2 0-29.5 3.5-42.3 9.8c-3.8 1.9-7.5 4-11 6.4c-2.7-4.6-5.6-9.1-8.7-13.4z"],
    "trowel-bricks": [512, 512, [], "e58a", "M232.4 18.4c-4.7-2.9-10.6-3.2-15.6-.7l-192 96c-5.4 2.7-8.8 8.3-8.8 14.3s3.4 11.6 8.8 14.3l192 96c5 2.5 10.9 2.2 15.6-.7s7.6-8.1 7.6-13.6V32c0-5.5-2.9-10.7-7.6-13.6zM256 32v88h88v-8c0-17.7 14.3-32 32-32h88c26.5 0 48 21.5 48 48s-21.5 48-48 48H376c-17.7 0-32-14.3-32-32v-8H256v88c0 11.1-5.7 21.4-15.2 27.2s-21.2 6.4-31.1 1.4l-192-96C6.8 151.2 0 140.1 0 128s6.8-23.2 17.7-28.6l192-96c9.9-5 21.7-4.4 31.1 1.4S256 20.9 256 32zM360 144c0 8.8 7.2 16 16 16h88c17.7 0 32-14.3 32-32s-14.3-32-32-32H376c-8.8 0-16 7.2-16 16v16 16zM288 384H240V496H480c8.8 0 16-7.2 16-16V408v-8V384H304 288zm-64-16h16 32 16V352 272c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32V400v8 72c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V400c0-17.7 14.3-32 32-32H224zm0 16H32c-8.8 0-16 7.2-16 16v80c0 8.8 7.2 16 16 16H224V384zm272-16V272c0-8.8-7.2-16-16-16H320c-8.8 0-16 7.2-16 16v96H496z"],
    "square-3": [448, 512, [], "e258", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm136 32H296c3.3 0 6.3 2.1 7.5 5.2s.3 6.6-2.2 8.8L189.4 239.9l58.1-.3c40-.2 72.5 32.2 72.5 72.2c0 39.9-32.3 72.2-72.2 72.2H176.7c-18.2 0-34.8-10.3-42.9-26.5l-4.9-9.9c-2-4-.4-8.8 3.6-10.7s8.8-.4 10.7 3.6l4.9 9.9c5.4 10.8 16.5 17.7 28.6 17.7h71.1c31 0 56.2-25.2 56.2-56.2c0-31.1-25.3-56.3-56.4-56.2L168 256c-3.3 0-6.3-2-7.5-5.2s-.3-6.7 2.2-8.9l112-98H136c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "face-flushed": [512, 512, [128563, "flushed"], "f579", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM192 368H320c4.4 0 8 3.6 8 8s-3.6 8-8 8H192c-4.4 0-8-3.6-8-8s3.6-8 8-8zm-32-80a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-144a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm256 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm-144 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM160.4 208a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm192 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32z"],
    "hospital-user": [576, 512, [], "f80d", "M0 56C0 25.1 25.1 0 56 0H264c30.9 0 56 25.1 56 56V271.8 336v31.8c-5.6 3.1-11 6.7-16 10.7V336 56c0-22.1-17.9-40-40-40H56C33.9 16 16 33.9 16 56V272H152c4.4 0 8 3.6 8 8s-3.6 8-8 8H16v80H152c4.4 0 8 3.6 8 8s-3.6 8-8 8H16v72c0 22.1 17.9 40 40 40H258.8c1.7 5.7 4.1 11.1 7.2 16H56c-30.9 0-56-25.1-56-56V56zm152 0h16c13.3 0 24 10.7 24 24V96h16c13.3 0 24 10.7 24 24v16c0 13.3-10.7 24-24 24H192v16c0 13.3-10.7 24-24 24H152c-13.3 0-24-10.7-24-24V160H112c-13.3 0-24-10.7-24-24V120c0-13.3 10.7-24 24-24h16V80c0-13.3 10.7-24 24-24zm-8 24v24c0 4.4-3.6 8-8 8H112c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h24c4.4 0 8 3.6 8 8v24c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V152c0-4.4 3.6-8 8-8h24c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8H184c-4.4 0-8-3.6-8-8V80c0-4.4-3.6-8-8-8H152c-4.4 0-8 3.6-8 8zM496 272a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM304 477.1c0 10.4 8.5 18.9 18.9 18.9H541.1c10.4 0 18.9-8.5 18.9-18.9c0-42.6-34.5-77.1-77.1-77.1H381.1c-42.6 0-77.1 34.5-77.1 77.1zM432 192a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM381.1 384H482.9c51.4 0 93.1 41.7 93.1 93.1c0 19.3-15.6 34.9-34.9 34.9H322.9c-19.3 0-34.9-15.6-34.9-34.9c0-51.4 41.7-93.1 93.1-93.1z"],
    "microwave": [576, 512, [], "e01b", "M512 48c26.5 0 48 21.5 48 48V384c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H512zM64 32C28.7 32 0 60.7 0 96V384c0 35.3 28.7 64 64 64l0 24c0 4.4 3.6 8 8 8s8-3.6 8-8V448H496v24c0 4.4 3.6 8 8 8s8-3.6 8-8V448c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm432 72V376c0 4.4 3.6 8 8 8s8-3.6 8-8V104c0-4.4-3.6-8-8-8s-8 3.6-8 8zM104 128H408c4.4 0 8 3.6 8 8V344c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V136c0-4.4 3.6-8 8-8zm-24 8V344c0 13.3 10.7 24 24 24H408c13.3 0 24-10.7 24-24V136c0-13.3-10.7-24-24-24H104c-13.3 0-24 10.7-24 24z"],
    "chf-sign": [640, 512, [], "e602", "M0 114.4C0 68.9 36.9 32 82.4 32h3c33.7 0 63.5 21.5 74.2 53.5c1.4 4.2-.9 8.7-5.1 10.1s-8.7-.9-10.1-5.1C135.9 65.1 112.2 48 85.4 48h-3C45.7 48 16 77.7 16 114.4V397.6C16 434.3 45.7 464 82.4 464h3c26.8 0 50.5-17.1 59-42.5c1.4-4.2 5.9-6.5 10.1-5.1s6.5 5.9 5.1 10.1C148.9 458.5 119.1 480 85.4 480h-3C36.9 480 0 443.1 0 397.6V114.4zM216 32c4.4 0 8 3.6 8 8V240H384V40c0-4.4 3.6-8 8-8s8 3.6 8 8V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V256H224V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V40c0-4.4 3.6-8 8-8zm232 8c0-4.4 3.6-8 8-8H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H464V240H600c4.4 0 8 3.6 8 8s-3.6 8-8 8H464V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V40z"],
    "tent-arrow-left-right": [576, 512, [], "e57f", "M477.4 2.1c-3.3-3-8.3-2.8-11.3 .5s-2.8 8.3 .5 11.3L547.4 88 28.6 88l80.8-74.1c3.3-3 3.5-8 .5-11.3s-8-3.5-11.3-.5l-96 88C.9 91.6 0 93.8 0 96s.9 4.4 2.6 5.9l96 88c3.3 3 8.3 2.8 11.3-.5s2.8-8.3-.5-11.3L28.6 104l518.9 0-80.8 74.1c-3.3 3-3.5 8-.5 11.3s8 3.5 11.3 .5l96-88c1.7-1.5 2.6-3.7 2.6-5.9s-.9-4.4-2.6-5.9l-96-88zM292.6 161.5c-2.8-2-6.5-2-9.2 0L103 289.3c-9.2 6.5-15.2 16.7-16.6 27.9l-18 150.1C65.5 491 84.1 512 108.1 512H399.9h.3 67.8c24 0 42.6-21 39.7-44.8l-18-150.1c-1.3-11.2-7.4-21.3-16.6-27.9L292.6 161.5zM296 317.8V183.5L463.8 302.3c5.5 3.9 9.1 10 10 16.7l18 150.1c1.7 14.3-9.4 26.9-23.8 26.9H404.5L296 317.8zm0 30.8L385.8 496H296V348.5zm-16-28.4V496H108.1c-14.4 0-25.5-12.6-23.8-26.9l18-150.1c.8-6.7 4.4-12.8 10-16.7L280 183.5V319.9c0 .1 0 .2 0 .3z"],
    "cart-circle-arrow-up": [640, 512, [], "e3f0", "M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8H57.8l94.4 362c.9 3.5 4.1 6 7.7 6H320.7c-.5-5.3-.7-10.6-.7-16H166.2l-20.9-80H339.2c2.8-5.5 5.9-10.8 9.3-16H141.1L82.7 48H541.8c10.6 0 18.3 10.1 15.4 20.3L521.8 193.9c5.3 .8 10.6 1.8 15.8 3.1l35-124.3C578.3 52.3 563 32 541.8 32H78.5L71.7 6c-.9-3.5-4.1-6-7.7-6H8zM176 432a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM368 368a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-213.7-2.3c3.1 3.1 8.2 3.1 11.3 0L488 315.3V440c0 4.4 3.6 8 8 8s8-3.6 8-8V315.3l50.3 50.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-64-64c-3.1-3.1-8.2-3.1-11.3 0l-64 64c-3.1 3.1-3.1 8.2 0 11.3z"],
    "trash-clock": [576, 512, [], "e2b0", "M177.7 16h92.5c8.3 0 16 4.3 20.4 11.3l23 36.7H134.4l23-36.7c4.4-7 12.1-11.3 20.4-11.3zm-33.9 2.8L115.6 64H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H332.4L304.2 18.8C296.9 7.1 284.1 0 270.3 0H177.7c-13.8 0-26.6 7.1-33.9 18.8zM48 119.3c-.4-4.4-4.2-7.7-8.6-7.3s-7.7 4.2-7.3 8.6l28.3 340c2.4 29 26.7 51.4 55.8 51.4H330.8c-6.9-4.9-13.5-10.2-19.6-16h-195c-20.8 0-38.1-15.9-39.9-36.7L48 119.3zm368 1.3c.4-4.4-2.9-8.3-7.3-8.6s-8.3 2.9-8.6 7.3l-6.4 76.9c5.3-1.2 10.8-2.1 16.3-2.8l6.1-72.7zM432 240a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-224c-4.4 0-8 3.6-8 8v72c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H440V296c0-4.4-3.6-8-8-8z"],
    "gavel": [512, 512, ["legal"], "f0e3", "M301.7 2.3c3.1 3.1 3.1 8.2 0 11.3L291.3 24 488 220.7l10.3-10.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-16 16-112 112-16 16c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L364.7 344 168 147.3l-10.3 10.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l16-16 112-112 16-16c3.1-3.1 8.2-3.1 11.3 0zM179.3 136L376 332.7 476.7 232 280 35.3 179.3 136zm-24 172.7c-6.2-6.2-16.4-6.2-22.6 0l-112 112c-6.2 6.2-6.2 16.4 0 22.6l48 48c6.2 6.2 16.4 6.2 22.6 0l112-112c6.2-6.2 6.2-16.4 0-22.6l-48-48zm-33.9-11.3c12.5-12.5 32.8-12.5 45.3 0L185 315.7l53.1-53.1 11.3 11.3L196.3 327l18.3 18.3c12.5 12.5 12.5 32.8 0 45.3l-112 112c-12.5 12.5-32.8 12.5-45.3 0l-48-48c-12.5-12.5-12.5-32.8 0-45.3l112-112z"],
    "sprinkler-ceiling": [384, 512, [], "e44c", "M0 0V96c0 3.6 2.5 6.8 6 7.7l122 31.8V119L16 89.8V0H0zM256 119v16.5l122-31.8c3.5-.9 6-4.1 6-7.7V0H368V89.8L256 119zM192 48c8.8 0 16 7.2 16 16V240H176V64c0-8.8 7.2-16 16-16zm32 192V64c0-17.7-14.3-32-32-32s-32 14.3-32 32V240H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h96 48 96c4.4 0 8-3.6 8-8s-3.6-8-8-8H224zM144 352a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM80 416a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm176-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-64 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-32 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm144-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80-48a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM32 464A16 16 0 1 0 0 464a16 16 0 1 0 32 0z"],
    "browsers": [576, 512, [], "e0cb", "M512 16c26.5 0 48 21.5 48 48V96H200V48 16H512zM160 16h24V48 96H112V64c0-26.5 21.5-48 48-48zM112 352V112h80H560V352c0 26.5-21.5 48-48 48H160c-26.5 0-48-21.5-48-48zM160 0C124.7 0 96 28.7 96 64V352c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H160zM16 104c0-4.4-3.6-8-8-8s-8 3.6-8 8V392c0 66.3 53.7 120 120 120H472c4.4 0 8-3.6 8-8s-3.6-8-8-8H120C62.6 496 16 449.4 16 392V104z"],
    "trillium": [448, 512, [], "e588", "M207.5 11.1c8.7-8.2 22-8.2 30.7 0c12.1 11.4 33.2 32.8 51.3 59.3c18 26.3 33.7 58.6 33.7 91.7c0 12.2-2.2 23.8-6.1 34.6c13 1.6 26 5.8 38 12.7l-2.5 4.4 2.5-4.4c28.6 16.5 48.8 46.3 62.6 75.1c13.9 28.9 21.9 57.9 25.7 74.1c2.7 11.6-3.9 23.1-15.4 26.6c-15.9 4.8-45 12.4-77 14.8c-31.8 2.4-67.6-.1-96.3-16.6c-13.1-7.6-23.8-17.6-32-29.2c-8.1 11.6-18.9 21.7-32 29.2c-28.6 16.5-64.5 19.1-96.3 16.6c-32-2.4-61.1-10-77-14.8c-11.4-3.4-18.1-15-15.3-26.6c3.8-16.2 11.8-45.2 25.7-74.1c13.8-28.8 33.9-58.5 62.6-75.1l0 0c12.1-7 25.1-11.2 38.2-12.8c-4-10.8-6.1-22.5-6.1-34.6c0-33.1 15.7-65.4 33.7-91.7c18.1-26.5 39.2-47.9 51.3-59.3zm19.7 11.7c-2.6-2.4-6.2-2.4-8.8 0c-11.7 11-31.9 31.5-49.1 56.6c-17.3 25.3-30.9 54.4-30.9 82.7c0 13.8 3.3 26.8 9.1 38.3c1.3 2.5 1.1 5.4-.3 7.8s-4 3.8-6.8 3.8c-14.3 0-28.8 3.7-42.1 11.3c-2.6 1.5-5.1 3.1-7.5 4.8l0 0s0 0 0 0c-20.8 14.9-36.7 38.5-48.6 63.3C29.1 319 21.4 346.7 17.7 362.3c-.8 3.4 1 6.6 4.4 7.6l-2.3 7.7 2.3-7.7c15.4 4.6 43.2 11.9 73.6 14.2c30.6 2.3 62.6-.4 87.1-14.6c14.6-8.4 25.7-20.5 32.9-34.5c1.4-2.7 4.1-4.3 7.1-4.3s5.7 1.7 7.1 4.3c7.2 13.9 18.3 26 32.9 34.5c24.5 14.2 56.5 16.9 87.1 14.6c30.4-2.3 58.2-9.5 73.6-14.2c3.4-1 5.2-4.2 4.4-7.6c-3.7-15.6-11.3-43.3-24.5-70.8c-13.3-27.7-31.6-54-56.1-68.1c-13.2-7.6-27.7-11.3-41.9-11.3c-2.8 0-5.4-1.5-6.8-3.8s-1.6-5.3-.3-7.8c5.8-11.5 9.1-24.5 9.1-38.3c0-28.3-13.6-57.4-30.9-82.7c-17.2-25.2-37.4-45.7-49.1-56.6zM224 208a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm48 32a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM433.1 129c-13.9-1.5-43.5-1.8-82.2 13.6c-.7-5.4-1.7-10.8-2.9-16c42.1-16.1 74.3-15 89.2-13.2c9.6 1.2 15.3 11 11.5 19.9c-5.7 13.7-20.7 41.6-55 69.8c-4.2-3.5-8.6-6.8-13.2-9.9c32.4-25.8 46.9-51.4 52.6-64.2zM10.9 113.3c14.9-1.9 47.1-2.9 89.2 13.2c-1.2 5.3-2.2 10.6-2.9 16c-38.7-15.3-68.2-15-82.2-13.6c5.7 12.8 20.1 38.4 52.5 64.1c-4.6 3.1-9 6.4-13.2 9.9C20.1 174.8 5.1 146.9-.6 133.2c-3.8-9 1.9-18.7 11.5-19.9zM211.7 500.7c-8.6-12.9-24.2-40.6-31.6-79.9c5.1-1.9 10.2-4 15.1-6.5c6.4 36.9 20.5 63.1 28.8 75.9c8.2-12.8 22.4-39 28.7-75.8c4.9 2.5 10 4.6 15.1 6.4c-7.4 39.3-23 66.9-31.6 79.9c-5.9 8.9-18.6 8.9-24.5 0z"],
    "music-slash": [640, 512, [], "f8d1", "M364.1 199.1L560 138.8V323.8c-17.2-21.6-46.6-35.8-80-35.8c-1.1 0-2.1 0-3.2 0l22.5 17.8c29.2 5.7 50.6 24.2 57.9 45.7L576 366.4V128.2v-.4V15c0-8.3-6.7-15-15-15c-1.5 0-3 .2-4.4 .7L256.9 92.9c-5.9 1.8-10.7 5.8-13.7 10.8l12.9 10.2c.7-2.7 2.7-4.9 5.4-5.7L560 16.4V122.1l-211.1 65 15.3 12zM240 284.6V387.8c-17.2-21.6-46.6-35.8-80-35.8c-53 0-96 35.8-96 80s43 80 96 80s96-35.8 96-80V297.2l-16-12.6zM160 368c47 0 80 31.3 80 64s-33 64-80 64s-80-31.3-80-64s33-64 80-64zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "truck-ramp": [640, 512, [], "f4e0", "M424 0c-39.8 0-72 32.2-72 72V397.1L5.8 496.3c-4.2 1.2-6.7 5.6-5.5 9.9s5.6 6.7 9.9 5.5L416.1 395.4c-.1 1.5-.1 3-.1 4.6c0 61.9 50.1 112 112 112s112-50.1 112-112s-50.1-112-112-112c-54.4 0-99.7 38.8-109.9 90.2L368 392.5V72c0-30.9 25.1-56 56-56H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H424zM528 304a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "binoculars": [512, 512, [], "f1e5", "M128 48c-8.8 0-16 7.2-16 16V96h80V64c0-8.8-7.2-16-16-16H128zM96 97.1V64c0-17.7 14.3-32 32-32h48c17.7 0 32 14.3 32 32V97.4c9.3 3.3 16 12.2 16 22.6v8h64v-8c0-10.4 6.7-19.3 16-22.6V64c0-17.7 14.3-32 32-32h48c17.7 0 32 14.3 32 32V97.1c19.5 4.3 34.7 20.4 37.3 40.9L459 184c3.3 26.4 12.1 51.8 25.8 74.6c17.8 29.7 27.2 63.7 27.2 98.3V432c0 26.5-21.5 48-48 48H336c-26.5 0-48-21.5-48-48V288H224V432c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V356.9c0-34.6 9.4-68.6 27.2-98.3C40.9 235.8 49.7 210.4 53 184L58.7 138c2.6-20.5 17.8-36.6 37.3-40.9zM106.4 112c-16.1 0-29.8 12-31.8 28l-5.7 45.9c-3.6 28.6-13.1 56.2-27.9 80.9c-16.3 27.2-25 58.4-25 90.1V432c0 17.7 14.3 32 32 32H176c17.7 0 32-14.3 32-32V280 136 120c0-4.4-3.6-8-8-8h-8H112h-5.6zm299.3 0H400 320h-8c-4.4 0-8 3.6-8 8v16V280 432c0 17.7 14.3 32 32 32H464c17.7 0 32-14.3 32-32V356.9c0-31.7-8.6-62.9-25-90.1c-14.8-24.7-24.3-52.3-27.9-80.9L437.4 140c-2-16-15.6-28-31.8-28zM320 96h80V64c0-8.8-7.2-16-16-16H336c-8.8 0-16 7.2-16 16V96zM224 272h64V144H224V272z"],
    "microphone-slash": [640, 512, [], "f131", "M387.6 401.1l-14.3-11.3C356.8 396.4 338.8 400 320 400c-79.5 0-144-64.5-144-144V234l-16-12.6V256c0 85.7 67.4 155.6 152 159.8V496H232c-4.4 0-8 3.6-8 8s3.6 8 8 8h88 88c4.4 0 8-3.6 8-8s-3.6-8-8-8H328V415.8c21.2-1 41.3-6.2 59.6-14.7zM240 101.1V96c0-44.2 35.8-80 80-80s80 35.8 80 80V227.4l16 12.6V96c0-53-43-96-96-96c-50.6 0-92 39.1-95.7 88.7L240 101.1zM476.8 288c2.1-10.4 3.2-21.1 3.2-32V200c0-4.4-3.6-8-8-8s-8 3.6-8 8v56c0 7.1-.5 14-1.5 20.8L476.8 288zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "box-tissue": [512, 512, [], "e05b", "M92.5 16H208c16.3 0 25.3 4.7 31.5 10.6c7.1 6.7 11.9 16 18.2 28.5l.5 1c5.7 11.3 12.8 25.5 24.3 36.5C295.3 104.7 312.3 112 336 112h85.2c6 0 10.8 4.8 10.8 10.8c0 1.4-.3 2.7-.8 4L369.1 282.1 360.4 304H148.5l-5-19.9L80.4 31.5c-.2-1-.4-2-.4-3C80 21.6 85.6 16 92.5 16zM408 304H377.6l6.4-16 62.1-155.2c1.3-3.2 1.9-6.6 1.9-10C448 108 436 96 421.2 96H336c-40 0-52-24-64-48S248 0 208 0H92.5C76.8 0 64 12.8 64 28.5c0 2.3 .3 4.7 .9 6.9L128 288l4 16H104c-4.4 0-8 3.6-8 8s3.6 8 8 8H408c4.4 0 8-3.6 8-8s-3.6-8-8-8zm29.7-64H464c17.7 0 32 14.3 32 32V384H16V272c0-17.7 14.3-32 32-32H83l-4-16H48c-26.5 0-48 21.5-48 48V464c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V272c0-26.5-21.5-48-48-48H444.1l-6.4 16zM16 400H496v64c0 17.7-14.3 32-32 32H48c-17.7 0-32-14.3-32-32V400z"],
    "circle-c": [512, 512, [], "e101", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.8 335.2c-43.7-43.7-43.7-114.7 0-158.4s114.7-43.7 158.4 0c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3c-50-50-131-50-181 0s-50 131 0 181s131 50 181 0c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0c-43.7 43.7-114.7 43.7-158.4 0z"],
    "star-christmas": [512, 512, [], "f7d4", "M256 16c-3.6 0-6.8 2.5-7.7 6L202.6 196.9c-.7 2.8-2.9 5-5.7 5.7L22 248.3c-3.5 .9-6 4.1-6 7.7s2.5 6.8 6 7.7l174.9 45.6c2.8 .7 5 2.9 5.7 5.7L248.3 490c.9 3.5 4.1 6 7.7 6s6.8-2.5 7.7-6l45.6-174.9c.7-2.8 2.9-5 5.7-5.7L490 263.7c3.5-.9 6-4.1 6-7.7s-2.5-6.8-6-7.7L315.1 202.6c-2.8-.7-5-2.9-5.7-5.7L263.7 22c-.9-3.5-4.1-6-7.7-6zm-23.2 1.9C235.5 7.4 245.1 0 256 0s20.5 7.4 23.2 17.9l44.4 170.4 170.4 44.4c10.6 2.8 17.9 12.3 17.9 23.2s-7.4 20.5-17.9 23.2L323.7 323.7 279.2 494.1C276.5 504.6 266.9 512 256 512s-20.5-7.4-23.2-17.9L188.3 323.7 17.9 279.2C7.4 276.5 0 266.9 0 256s7.4-20.5 17.9-23.2l170.4-44.4L232.8 17.9zM354.3 354.3c3.1-3.1 8.2-3.1 11.3 0l80 80c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-80-80c-3.1-3.1-3.1-8.2 0-11.3zm0-208l80-80c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-80 80c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3zm-288-80c3.1-3.1 8.2-3.1 11.3 0l80 80c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-80-80c-3.1-3.1-3.1-8.2 0-11.3zm0 368l80-80c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-80 80c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3z"],
    "chart-bullet": [512, 512, [], "e0e1", "M280 32c4.4 0 8 3.6 8 8V64H464c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H288v24c0 4.4-3.6 8-8 8s-8-3.6-8-8V224H48c-26.5 0-48-21.5-48-48V112C0 85.5 21.5 64 48 64H272V40c0-4.4 3.6-8 8-8zM160 80V208H272V80H160zm128 0V208H464c17.7 0 32-14.3 32-32V112c0-17.7-14.3-32-32-32H288zM144 80H48c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32h96V80zM376 256c4.4 0 8 3.6 8 8v24h80c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H384v24c0 4.4-3.6 8-8 8s-8-3.6-8-8V448H48c-26.5 0-48-21.5-48-48V336c0-26.5 21.5-48 48-48H368V264c0-4.4 3.6-8 8-8zM224 304V432H368V304H224zm160 0V432h80c17.7 0 32-14.3 32-32V336c0-17.7-14.3-32-32-32H384zm-176 0H48c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H208V304z"],
    "motorcycle": [640, 512, [127949], "f21c", "M455.6 48H480c8.8 0 16 7.2 16 16V96c0 8.8-7.2 16-16 16H397.9L387.9 92.4l58.5-41.5c2.7-1.9 5.9-2.9 9.2-2.9zm-49.5 80H480c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32H455.6c-6.6 0-13.1 2.1-18.5 5.9L380.5 78 363.6 45c-4.1-8-12.4-13-21.4-13H264c-4.4 0-8 3.6-8 8s3.6 8 8 8h78.2c3 0 5.8 1.7 7.1 4.3l18 35-111.6 79-30.3-18.9c-20.3-12.7-43.9-19.5-67.8-19.5H64c-17.7 0-32 14.3-32 32s14.3 32 32 32h47.8c94.2 0 171.7 74.2 175.8 168.4l.3 8c.2 4.3 3.7 7.7 8 7.7h48c4.4 0 8-3.6 8-8V352c0-59.2 32.2-110.9 79.9-138.6L446.6 242C409.1 264.3 384 305.2 384 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-18.2 0-35.5 3.8-51.2 10.6L406.1 128zM216.9 161l34.7 21.7c2.7 1.7 6.2 1.8 9-.2l114-80.8 50 97.4C371.7 229.5 336 286.6 336 352v8H303.7l0-.3C299.2 257 214.6 176 111.8 176H64c-8.8 0-16-7.2-16-16s7.2-16 16-16h93.6c21 0 41.6 5.9 59.4 17zm237 95.2l51 99.4c2 3.9 6.8 5.5 10.8 3.5s5.5-6.8 3.5-10.8l-51-99.4c13.5-5.7 28.3-8.9 43.9-8.9c61.9 0 112 50.1 112 112s-50.1 112-112 112s-112-50.1-112-112c0-40.6 21.6-76.1 53.9-95.8zM239.7 360c-4.1 58.1-52.6 104-111.7 104C66.1 464 16 413.9 16 352s50.1-112 112-112c59.2 0 107.6 45.9 111.7 104H191.5c-3.9-31.6-30.9-56-63.5-56c-35.3 0-64 28.7-64 64s28.7 64 64 64c32.6 0 59.6-24.4 63.5-56h48.2zm-64.4 0c-3.8 22.7-23.6 40-47.3 40c-26.5 0-48-21.5-48-48s21.5-48 48-48c23.8 0 43.5 17.3 47.3 40H128c-4.4 0-8 3.6-8 8s3.6 8 8 8h47.3zm80.7-8A128 128 0 1 0 0 352a128 128 0 1 0 256 0z"],
    "tree-christmas": [448, 512, [127876], "f7db", "M222 17.3L204.7 56.6c-.8 1.8-2.3 3.3-4.1 4.1L161.3 78c-.8 .4-1.3 1.2-1.3 2s.5 1.7 1.3 2l39.2 17.3c1.8 .8 3.3 2.3 4.1 4.1L222 142.7c.4 .8 1.2 1.3 2 1.3s1.7-.5 2-1.3l17.3-39.2c.8-1.8 2.3-3.3 4.1-4.1L286.7 82c.8-.4 1.3-1.2 1.3-2s-.5-1.7-1.3-2L247.4 60.7c-1.8-.8-3.3-2.3-4.1-4.1L226 17.3c-.4-.8-1.2-1.3-2-1.3s-1.7 .5-2 1.3zM224 0c7.2 0 13.8 4.3 16.7 10.9l16.1 36.4 36.4 16.1C299.7 66.2 304 72.8 304 80s-4.3 13.8-10.9 16.7l-36.4 16.1-16.1 36.4c-2.9 6.6-9.5 10.9-16.7 10.9s-13.8-4.3-16.7-10.9l-16.1-36.4L154.9 96.7C148.3 93.8 144 87.2 144 80s4.3-13.8 10.9-16.7l36.4-16.1 16.1-36.4C210.2 4.3 216.8 0 224 0zM167 137l2.1 4.7L42.7 313.5c-1.8 2.4-2.7 5.4-2.7 8.4c0 7.8 6.3 14.1 14.1 14.1H94.9c3 0 5.7 1.6 7.1 4.2s1.2 5.8-.4 8.2L18.5 473.1c-1.6 2.4-2.5 5.3-2.5 8.2c0 8.1 6.6 14.7 14.7 14.7H417.3c8.1 0 14.7-6.6 14.7-14.7c0-2.9-.9-5.7-2.5-8.2L346.4 348.4c-1.6-2.5-1.8-5.6-.4-8.2s4.1-4.2 7.1-4.2h40.8c7.8 0 14.1-6.3 14.1-14.1c0-3-1-5.9-2.7-8.4L278.9 141.7 281 137l10.8-4.8L418.1 304c3.8 5.2 5.9 11.4 5.9 17.8c0 16.6-13.5 30.1-30.1 30.1H368l74.8 112.3c3.4 5 5.2 11 5.2 17c0 17-13.7 30.7-30.7 30.7H30.7C13.7 512 0 498.3 0 481.3c0-6.1 1.8-12 5.2-17L80 352H54.1C37.5 352 24 338.5 24 321.9c0-6.4 2.1-12.7 5.9-17.8L156.2 132.2 167 137zm-7 135a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM272 384a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "tire-flat": [512, 512, [], "f632", "M496 288c0 43.9-11.8 85-32.3 120.4c-6.7 11.6-2.1 25.2 7.6 31.7l8.9-13.3-8.9 13.3 13.3 8.9c7.1 4.8 11.4 12.8 11.4 21.4c0 14.2-11.5 25.7-25.7 25.7H380 132 41.7C27.5 496 16 484.5 16 470.3c0-8.6 4.3-16.6 11.4-21.4l13.3-8.9-8.9-13.3 8.9 13.3c9.7-6.4 14.3-20.1 7.6-31.7C27.8 373 16 331.9 16 288C16 155.5 123.5 48 256 48s240 107.5 240 240zM31.9 426.7l-13.3 8.9C7 443.4 0 456.4 0 470.3c0 23 18.7 41.7 41.7 41.7H132 380h90.3c23 0 41.7-18.7 41.7-41.7c0-13.9-7-27-18.6-34.7l-13.3-8.9c-3.4-2.3-4.7-6.8-2.6-10.3C499.4 378.7 512 334.8 512 288C512 146.6 397.4 32 256 32S0 146.6 0 288c0 46.8 12.6 90.7 34.5 128.4c2 3.5 .8 8-2.6 10.3zM400 288c0 12.8-1.7 25.2-4.8 37l-76.4-24.9c.8-3.9 1.1-8 1.1-12.1c0-18.4-7.7-34.9-20.1-46.6l47.2-65C379.4 202.8 400 243 400 288zm-86.1 27.3l76.4 24.9c-20 51.4-68.6 88.5-126.3 91.6l0-80.3c22.1-2.7 40.8-16.8 50-36.2zm-66 36.2l0 80.3c-57.6-3.2-106.3-40.2-126.2-91.6l76.4-24.9c9.2 19.4 27.7 33.4 49.8 36.2zM112 288c0-45 20.6-85.2 52.9-111.6l38 52.3 9.2 12.7C199.7 253.1 192 269.6 192 288c0 4.1 .4 8.2 1.1 12.1L116.8 325c-3.1-11.8-4.8-24.2-4.8-37zm144-64c-11.2 0-21.8 2.9-31 8l-9.2-12.6-38-52.3c22.5-14.6 49.3-23 78.1-23s55.6 8.5 78.1 23L287 232c-9.2-5.1-19.7-8-31-8zm160 64A160 160 0 1 0 96 288a160 160 0 1 0 320 0zm-208 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "sunglasses": [576, 512, [128374], "f892", "M70.8 77.7c4.4-17.5 20-29.7 38-29.7c6.1 0 12.1 1.4 17.5 4.1l22 11c4 2 8.8 .4 10.7-3.6s.4-8.8-3.6-10.7l-22-11C125.9 34 117.4 32 108.9 32C83.5 32 61.4 49.2 55.3 73.8L6 271.1C3 282.9 1.2 294.9 .4 306.9c-.3 1.7-.4 3.4-.4 5.1v7.6V336v32c0 61.9 50.1 112 112 112h44.3c59.4 0 108.5-46.4 111.8-105.8l3.8-60.4c.2-3.3-.2-6.6-1-9.8h34c-.8 3.1-1.2 6.4-1 9.8l3.8 60.4C311.1 433.6 360.2 480 419.7 480H464c61.9 0 112-50.1 112-112V336 319.6 312c0-1.7-.1-3.4-.4-5.1c-.8-12.1-2.6-24-5.6-35.8L520.7 73.8C514.6 49.2 492.5 32 467.1 32c-8.6 0-17 2-24.7 5.8l-22 11c-4 2-5.6 6.8-3.6 10.7s6.8 5.6 10.7 3.6l22-11c5.4-2.7 11.4-4.1 17.5-4.1c18 0 33.7 12.2 38 29.7L554.5 275c.6 2.4 1.2 4.9 1.7 7.3C520.6 265.2 479.5 256 440.3 256c-40.1 0-82.2 9.6-118.5 27.3c-2.7 1.4-5.2 3.1-7.4 5.1c-.8-.2-1.6-.4-2.4-.4H264c-.8 0-1.7 .1-2.4 .4c-2.2-2-4.7-3.7-7.4-5.1C217.9 265.6 175.8 256 135.7 256c-39.1 0-80.3 9.2-115.9 26.3c.5-2.5 1.1-4.9 1.7-7.3L70.8 77.7zM16 319.6c0-3.6 .1-7.2 .3-10.8c1-4.7 4-8.9 8.5-11.1C58.5 281 98.1 272 135.7 272c37.7 0 77.4 9 111.4 25.7c5.7 2.9 9.2 8.9 8.9 15.2l-3.8 60.4 0 0 0 .1c-2.8 50.9-44.9 90.7-95.9 90.7H112c-16.8 0-32.6-4.3-46.4-11.9l114.2-61c3.9-2.1 5.4-6.9 3.3-10.8s-6.9-5.4-10.8-3.3l-116 62-5.5 3c-13.6-11.3-24-26.3-29.8-43.4l110.6-55.3c4-2 5.6-6.8 3.6-10.7s-6.8-5.6-10.7-3.6L17.1 382.5c-.7-4.7-1.1-9.6-1.1-14.5V336 319.6zm535.2-21.9c4.4 2.2 7.5 6.4 8.5 11.1c.2 3.6 .3 7.2 .3 10.8V336v32c0 53-43 96-96 96H419.7c-17.5 0-34-4.7-48.2-12.9l112.3-60c3.9-2.1 5.4-6.9 3.3-10.8s-6.9-5.4-10.8-3.3l-116 62-3.3 1.7c-13.3-11.5-23.4-26.6-28.9-43.8l107.5-53.7c4-2 5.6-6.8 3.6-10.7s-6.8-5.6-10.7-3.6L324.5 380.8c-.3-2.5-.6-4.9-.7-7.5l0-.1 0 0L320 312.8c-.3-6.3 3.2-12.3 8.9-15.2c34-16.6 73.7-25.7 111.4-25.7c37.5 0 77.2 9 110.9 25.7z"],
    "badge": [512, 512, [], "f335", "M256 16c-32.6 0-60.9 18.3-75.2 45.2c-1.8 3.4-5.7 5-9.4 3.9c-29.1-8.9-62.1-1.9-85.1 21.1s-30.1 56-21.1 85.1c1.1 3.7-.5 7.6-3.9 9.4C34.3 195.1 16 223.4 16 256s18.3 60.9 45.2 75.2c3.4 1.8 5 5.8 3.9 9.4c-8.9 29.1-1.9 62.1 21.1 85.1s56 30.1 85.1 21.1c3.7-1.1 7.6 .5 9.4 3.9C195.1 477.7 223.4 496 256 496s60.9-18.3 75.2-45.2c1.8-3.4 5.8-5 9.4-3.9c29.1 8.9 62.1 1.9 85.1-21.1s30.1-56 21.1-85.1c-1.1-3.7 .5-7.6 3.9-9.4C477.7 316.9 496 288.6 496 256s-18.3-60.9-45.2-75.2c-3.4-1.8-5-5.7-3.9-9.4c8.9-29.1 1.9-62.1-21.1-85.1s-56-30.1-85.1-21.1c-3.7 1.1-7.6-.5-9.4-3.9C316.9 34.3 288.6 16 256 16zM169.9 48.2C187.7 19.3 219.6 0 256 0s68.3 19.3 86.1 48.2c33-7.9 69.2 1.1 94.9 26.8s34.7 62 26.8 94.9C492.7 187.7 512 219.6 512 256s-19.3 68.3-48.2 86.1c7.9 33-1.1 69.2-26.8 94.9s-61.9 34.7-94.9 26.8C324.3 492.7 292.4 512 256 512s-68.3-19.3-86.1-48.2c-33 7.9-69.2-1.1-94.9-26.8s-34.7-61.9-26.8-94.9C19.3 324.3 0 292.4 0 256s19.3-68.3 48.2-86.1c-7.9-33 1.1-69.2 26.8-94.9s61.9-34.7 94.9-26.8z"],
    "message-pen": [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM164.6 299.4c4 4 9.7 5.6 15.2 4.2l36.7-9.2c5.6-1.4 10.8-4.3 14.9-8.4L341 176.4c14.7-14.7 14.7-38.6 0-53.4s-38.6-14.7-53.4 0L178 232.6c-4.1 4.1-7 9.2-8.4 14.9l-9.2 36.7c-1.4 5.5 .2 11.2 4.2 15.2zm15.7-28.9l4.8-19.1c.7-2.8 2.2-5.4 4.2-7.4L275 158.3 305.7 189 220 274.7c-2.1 2.1-4.6 3.5-7.4 4.2l-19.1 4.8-17.6 4.4 4.4-17.6zM329.7 165.1L317 177.7 286.3 147l12.6-12.6c8.5-8.5 22.3-8.5 30.7 0s8.5 22.3 0 30.7z"],
    "bell-concierge": [512, 512, [128718, "concierge-bell"], "f562", "M200 64c-4.4 0-8 3.6-8 8s3.6 8 8 8h48v64.1C128 148.4 32 247 32 368v32H48V368c0-114.9 93.1-208 208-208s208 93.1 208 208v32h16V368c0-121-96-219.6-216-223.9V80h48c4.4 0 8-3.6 8-8s-3.6-8-8-8H256 200zM8 432c-4.4 0-8 3.6-8 8s3.6 8 8 8H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H8z"],
    "pen-ruler": [512, 512, ["pencil-ruler"], "f5ae", "M440.2 25.9c-12.5-12.5-32.8-12.5-45.3 0L328.1 92.8l91.1 91.1L486.1 117c12.5-12.5 12.5-32.8 0-45.3L440.2 25.9zM73.6 347.3c-10.4 10.4-18 23.3-22.2 37.4L19.8 492.2l107.5-31.6c14.1-4.2 27-11.8 37.4-22.2L407.9 195.2l-91.1-91.1L73.6 347.3zm310-332.7c18.7-18.7 49.1-18.7 67.9 0l45.8 45.8c18.7 18.7 18.7 49.1 0 67.9L176 449.7c-12.3 12.3-27.5 21.3-44.2 26.2L10.3 511.7c-2.8 .8-5.8 .1-7.9-2s-2.8-5.1-2-7.9L36.1 380.2C41 363.5 50 348.3 62.3 336L383.7 14.6zM156.3 33c-15.6-15.6-40.9-15.6-56.6 0L33 99.7c-15.6 15.6-15.6 40.9 0 56.6l76.5 76.5L98.2 244.1 21.7 167.6c-21.9-21.9-21.9-57.3 0-79.2L88.4 21.7c21.9-21.9 57.3-21.9 79.2 0l76.5 76.5-11.3 11.3L195.3 72l-53.7 53.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L184 60.7 156.3 33zM267.9 413.8l11.3-11.3L355.7 479c15.6 15.6 40.9 15.6 56.6 0L479 412.3c15.6-15.6 15.6-40.9 0-56.6L451.3 328l-53.7 53.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L440 316.7l-37.5-37.5 11.3-11.3 76.5 76.5c21.9 21.9 21.9 57.3 0 79.2l-66.7 66.7c-21.9 21.9-57.3 21.9-79.2 0l-76.5-76.5z"],
    "arrow-progress": [512, 512, [], "e5df", "M448 16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112A64 64 0 1 0 448 0a64 64 0 1 0 0 128zM104 56C46.6 56 0 102.6 0 160s46.6 104 104 104H408c48.6 0 88 39.4 88 88c0 46.1-35.4 83.9-80.5 87.7C411.4 408.3 384.5 384 352 384c-35.3 0-64 28.7-64 64s28.7 64 64 64c32.7 0 59.7-24.6 63.5-56.3C469.5 451.9 512 406.9 512 352c0-57.4-46.6-104-104-104H104c-48.6 0-88-39.4-88-88s39.4-88 88-88H320l-44.8 33.6c-3.5 2.7-4.3 7.7-1.6 11.2s7.7 4.3 11.2 1.6l64-48c2-1.5 3.2-3.9 3.2-6.4s-1.2-4.9-3.2-6.4l-64-48c-3.5-2.7-8.5-1.9-11.2 1.6s-1.9 8.5 1.6 11.2L320 56H104zm23.5 384c-3.9-31.6-30.9-56-63.5-56c-35.3 0-64 28.7-64 64s28.7 64 64 64c32.6 0 59.6-24.4 63.5-56H224l-44.8 33.6c-3.5 2.6-4.3 7.7-1.6 11.2s7.7 4.2 11.2 1.6l64-48c2-1.5 3.2-3.9 3.2-6.4s-1.2-4.9-3.2-6.4l-64-48c-3.5-2.6-8.5-1.9-11.2 1.6s-1.9 8.6 1.6 11.2L224 440H127.5zM16 448a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", "M32 120c0-4.4 3.6-8 8-8H64c4.4 0 8 3.6 8 8v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V120c0-4.4 3.6-8 8-8h31.5c4.4 0 8 3.6 8 8v16c0 13.3 10.7 24 24 24H224c13.3 0 24-10.7 24-24V120c0-4.4 3.6-8 8-8h24c4.4 0 8 3.6 8 8V226.2c0 1.9-.7 3.7-1.9 5.1l-36.3 43.5c-1.3 1.6-2 3.6-1.8 5.6L254.5 384h16l-6.3-101.3 34.3-41.1c3.6-4.3 5.6-9.7 5.6-15.4V120c0-13.3-10.7-24-24-24H256c-13.3 0-24 10.7-24 24v16c0 4.4-3.6 8-8 8H207.5c-4.4 0-8-3.6-8-8V120c0-13.3-10.7-24-24-24H144c-13.3 0-24 10.7-24 24v16c0 4.4-3.6 8-8 8H96c-4.4 0-8-3.6-8-8V120c0-13.3-10.7-24-24-24H40c-13.3 0-24 10.7-24 24V226.2c0 5.6 2 11.1 5.6 15.4l34.3 41.1L49.5 384h16L72 280.5c.1-2-.5-4.1-1.8-5.6L33.9 231.3c-1.2-1.4-1.9-3.2-1.9-5.1V120zm4.7 306.1L4.5 471.2C1.6 475.2 0 480.1 0 485.1V488c0 13.3 10.7 24 24 24H296c13.3 0 24-10.7 24-24v-2.9c0-5-1.6-9.9-4.5-13.9l-32.2-45.1c-4.5-6.3-11.8-10.1-19.5-10.1H56.2c-7.8 0-15 3.7-19.5 10.1zM56.2 432H263.8c2.6 0 5 1.2 6.5 3.4l32.2 45.1c1 1.4 1.5 3 1.5 4.6V488c0 4.4-3.6 8-8 8H24c-4.4 0-8-3.6-8-8v-2.9c0-1.7 .5-3.3 1.5-4.6l32.2-45.1c1.5-2.1 3.9-3.4 6.5-3.4zM160 224c-17.7 0-32 14.3-32 32v40c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V256c0-17.7-14.3-32-32-32zm-16 32c0-8.8 7.2-16 16-16s16 7.2 16 16v32H144V256z"],
    "square-root": [576, 512, [8730], "f697", "M386.6 48c-17.2 0-32.5 11-37.9 27.4L215.6 474.5c-1 3.1-3.8 5.2-7 5.4s-6.3-1.5-7.7-4.4L89.7 253.3C85.6 245.1 77.3 240 68.2 240H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H68.2c15.2 0 29 8.6 35.8 22.1l102.5 205 127-380.9c7.6-22.9 29-38.3 53.1-38.3H568c4.4 0 8 3.6 8 8s-3.6 8-8 8H386.6z"],
    "album-collection-circle-plus": [640, 512, [], "e48e", "M64 0H448c17.7 0 32 14.3 32 32v8c0 4.4-3.6 8-8 8s-8-3.6-8-8V32c0-8.8-7.2-16-16-16H64c-8.8 0-16 7.2-16 16v8c0 4.4-3.6 8-8 8s-8-3.6-8-8V32C32 14.3 46.3 0 64 0zM16 112c0-17.7 14.3-32 32-32H464c17.7 0 32 14.3 32 32v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-8.8-7.2-16-16-16H48c-8.8 0-16 7.2-16 16v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8zM4.2 212.6C1.5 184.4 23.7 160 52 160H460c21.2 0 38.9 13.6 45.4 32.2c-3.1-.2-6.2-.2-9.4-.2c-2.7 0-5.5 .1-8.2 .2C482.4 182.6 472 176 460 176H52c-18.9 0-33.6 16.2-31.9 35L44.5 467c1.6 16.4 15.4 29 31.9 29H375.2c6.1 5.8 12.7 11.1 19.6 16H76.4c-24.7 0-45.4-18.8-47.8-43.4L4.2 212.6zM256 208c45.1 0 86.3 12.7 117.4 33.7c-3.9 3.8-7.6 7.7-11.1 11.8C334.3 235.3 297.2 224 256 224c-45.5 0-86 13.8-114.9 35.5S96 309.7 96 340s16.3 58.9 45.1 80.5S210.5 456 256 456c29.2 0 56.3-5.7 79.6-15.5c2.2 4.9 4.6 9.7 7.3 14.3C317.2 465.8 287.6 472 256 472c-97.2 0-176-59.1-176-132s78.8-132 176-132zm25.8 160.6c-7.3 4.9-16.5 7.4-25.8 7.4s-18.5-2.5-25.8-7.4C223 363.8 216 355.4 216 344s7-19.8 14.2-24.6c7.3-4.9 16.5-7.4 25.8-7.4s18.5 2.5 25.8 7.4C289 324.2 296 332.6 296 344s-7 19.8-14.2 24.6zM256 360c13.3 0 24-7.2 24-16s-10.7-16-24-16s-24 7.2-24 16s10.7 16 24 16zm368 8a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm152-72v64h64c4.4 0 8 3.6 8 8s-3.6 8-8 8H504v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V376H424c-4.4 0-8-3.6-8-8s3.6-8 8-8h64V296c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "people-arrows": [640, 512, ["people-arrows-left-right"], "e068", "M128 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM128 0a64 64 0 1 1 0 128A64 64 0 1 1 128 0zM105.6 176c-33.3 0-61 25.5-63.8 58.7L37.7 284c-2.3 28 19.8 52 47.8 52H112h31.4l16 16H152V480c0 8.8 7.2 16 16 16s16-7.2 16-16V376.6l16 16V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H120V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V344.8c-22.1-11.5-36.4-35.4-34.2-62.1l4.1-49.3C29.3 191.9 64 160 105.6 160h44.8c28.7 0 54.1 15.2 68.2 38.2c-2.4 1.6-4.8 3.4-6.9 5.5l-5.3 5.3c-11-19.8-32-33-56-33H105.6zM440 480V392.6l16-16V480c0 8.8 7.2 16 16 16s16-7.2 16-16V352h-7.4l16-16H528h26.4c28.1 0 50.2-24 47.8-52l-4.1-49.3c-2.8-33.2-30.5-58.7-63.8-58.7H489.6c-24 0-45.1 13.2-56 33l-5.3-5.3c-2.1-2.1-4.4-4-6.9-5.5c14.1-23 39.5-38.2 68.2-38.2h44.8c41.6 0 76.3 31.9 79.7 73.4l4.1 49.3c2.2 26.7-12.2 50.6-34.2 62.1V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H504V480c0 17.7-14.3 32-32 32s-32-14.3-32-32zM104 352H85.6c-4.7 0-9.2-.5-13.6-1.4V480c0 8.8 7.2 16 16 16s16-7.2 16-16V352zM512 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM512 0a64 64 0 1 1 0 128A64 64 0 1 1 512 0zm56 480V350.6c-4.4 .9-8.9 1.4-13.6 1.4H536V480c0 8.8 7.2 16 16 16s16-7.2 16-16zM245.7 237.7L187.3 296H452.7l-58.3-58.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l72 72c3.1 3.1 3.1 8.2 0 11.3l-72 72c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L452.7 312H187.3l58.3 58.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-72-72c-3.1-3.1-3.1-8.2 0-11.3l72-72c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "face-angry-horns": [640, 512, [], "e368", "M320 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496c141.4 0 256-114.6 256-256c0-27.9-4.5-54.8-12.7-79.9C616.4 111.7 634 38.9 639.8 9.6c.6-3.2-.7-6.4-3.4-8.2s-6.2-1.8-8.9 0C607.3 14.9 577.1 26.5 547 35.4c-27.3 8.2-53.8 14-71.6 17.2C432.4 19.6 378.5 0 320 0S207.6 19.6 164.5 52.6c-17.7-3.2-44.3-9-71.6-17.2c-30-9-60.2-20.6-80.5-34.1C9.7-.5 6.2-.4 3.5 1.4S-.5 6.4 .2 9.6C6 38.9 23.6 111.7 76.7 176.1C68.5 201.2 64 228.1 64 256c0 141.4 114.6 256 256 256zM556.8 158.6c-14.7-35.7-37.2-67.3-65.4-92.7c17-3.5 38.4-8.5 60.2-15.1c23.6-7.1 48.3-16 68.6-26.6c-8 32.4-25.5 85.4-63.4 134.4zM88.4 50.8c21.8 6.5 43.2 11.6 60.2 15.1c-28.2 25.4-50.7 57.1-65.4 92.7C45.3 109.6 27.8 56.6 19.8 24.2C40.1 34.8 64.7 43.7 88.4 50.8zm309 363.2c3.3-3 3.5-8 .6-11.3c-15-16.7-41-34.6-77.9-34.6s-62.9 18-77.9 34.6c-3 3.3-2.7 8.3 .6 11.3s8.3 2.7 11.3-.6C266.7 399.1 288.7 384 320 384s53.3 15.1 66.1 29.4c3 3.3 8 3.6 11.3 .6zM240.4 288a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm176-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM194.5 200.4c-4.2-1.4-8.7 .9-10.1 5.1s.9 8.7 5.1 10.1l96 32c4.2 1.4 8.7-.9 10.1-5.1s-.9-8.7-5.1-10.1l-96-32zm256 15.2c4.2-1.4 6.5-5.9 5.1-10.1s-5.9-6.5-10.1-5.1l-96 32c-4.2 1.4-6.5 5.9-5.1 10.1s5.9 6.5 10.1 5.1l96-32z"],
    "mars-and-venus-burst": [640, 512, [], "e523", "M512 8c0 4.4 3.6 8 8 8h92.7l-97.2 97.2C486.3 82.9 445.4 64 400 64c-88.4 0-160 71.6-160 160c0 85.7 67.4 155.6 152 159.8l0 .2v48H344c-4.4 0-8 3.6-8 8s3.6 8 8 8h48v56c0 4.4 3.6 8 8 8s8-3.6 8-8V448h48c4.4 0 8-3.6 8-8s-3.6-8-8-8H408V384l0-.2c84.6-4.2 152-74.1 152-159.8c0-37.2-12.7-71.5-34-98.7l98-98V120c0 4.4 3.6 8 8 8s8-3.6 8-8V8c0-4.4-3.6-8-8-8H520c-4.4 0-8 3.6-8 8zM256 224a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zM161.5 20.5L130.1 88.7l-72.9-18C43.9 67.4 32.9 81.2 39.1 93.4L73 160.8l-53.7 46c-10 8.5-6 24.8 6.8 27.8l67.2 15.3L92 325c-.2 13.7 15.7 21.3 26.2 12.6L176 289.8l57.9 47.9c4.2 3.5 9.3 4.4 13.8 3.3c-6.5-8.5-12.3-17.5-17.3-26.9l-49.2-40.7c-3-2.4-7.2-2.4-10.2 0l-63 52.1 1.5-81.7c.1-3.8-2.5-7.1-6.2-7.9L29.7 218.9l58.5-50.1c2.8-2.4 3.6-6.4 1.9-9.7l-36.8-73 79.3 19.6c3.7 .9 7.6-.9 9.2-4.4L176 27.2l34.1 74.2c1.6 3.5 5.5 5.3 9.2 4.4l37-9.1c7.1-8 14.9-15.5 23.3-22.2L221.9 88.7 190.5 20.5c-5.7-12.4-23.4-12.4-29.1 0z"],
    "tombstone": [448, 512, [], "f720", "M400 464V192c0-97.2-78.8-176-176-176S48 94.8 48 192V464H32V192C32 86 118 0 224 0S416 86 416 192V464H400zM0 504c0-4.4 3.6-8 8-8H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8zM232 136v72h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H232V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V224H136c-4.4 0-8-3.6-8-8s3.6-8 8-8h80V136c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "square-caret-right": [448, 512, ["caret-square-right"], "f152", "M432 96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320zM384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM320 256c0 7.3-3 14.3-8.4 19.3L202.4 377.2c-4.7 4.4-10.8 6.8-17.2 6.8c-13.9 0-25.2-11.3-25.2-25.2l0-205.6c0-13.9 11.3-25.2 25.2-25.2c6.4 0 12.5 2.4 17.2 6.8L311.6 236.7c5.4 5 8.4 12 8.4 19.3zM176 153.2l0 205.6c0 5.1 4.1 9.2 9.2 9.2c2.3 0 4.6-.9 6.3-2.5L300.7 263.6c2.1-2 3.3-4.7 3.3-7.6s-1.2-5.6-3.3-7.6L191.5 146.5c-1.7-1.6-4-2.5-6.3-2.5c-5.1 0-9.2 4.1-9.2 9.2z"],
    "scissors": [512, 512, [9984, 9986, 9988, "cut"], "f0c4", "M510.1 445.2c2.9-3.4 2.4-8.4-.9-11.3l-179.6-152c-3.4-2.9-8.4-2.4-11.3 .9s-2.4 8.4 .9 11.3l179.6 152c3.4 2.9 8.4 2.4 11.3-.9zM286.5 245.5l-82.5-69.8C216.6 157.7 224 135.7 224 112C224 50.1 173.9 0 112 0S0 50.1 0 112s50.1 112 112 112c32.4 0 61.6-13.8 82.1-35.8L274.2 256l-80.1 67.8c-20.5-22-49.6-35.8-82.1-35.8C50.1 288 0 338.1 0 400s50.1 112 112 112s112-50.1 112-112c0-23.7-7.4-45.7-19.9-63.8L509.2 78.1c3.4-2.9 3.8-7.9 .9-11.3s-7.9-3.8-11.3-.9L286.5 245.5zM112 208a96 96 0 1 1 0-192 96 96 0 1 1 0 192zm0 96a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "list-music": [512, 512, [], "f8c9", "M496 16.4L389.5 51.9c-3.3 1.1-5.5 4.1-5.5 7.6V174.3L490.5 140c3.3-1.1 5.5-4.1 5.5-7.6V16.4zM384 190.7V432c0 44.2-50.1 80-112 80s-112-35.8-112-80s50.1-80 112-80c40.7 0 76.4 15.5 96 38.8V59.5c0-10.3 6.6-19.5 16.4-22.8l108-36c1.5-.5 3.1-.8 4.7-.8C505.3 0 512 6.7 512 14.9V132.3c0 10.4-6.7 19.6-16.6 22.8L386.5 190.3c-.8 .3-1.6 .4-2.5 .4zM341.9 388.5C324.6 376.1 300 368 272 368s-52.6 8.1-69.9 20.5c-17.3 12.3-26.1 28-26.1 43.5s8.8 31.2 26.1 43.5C219.4 487.9 244 496 272 496s52.6-8.1 69.9-20.5c17.3-12.3 26.1-28 26.1-43.5s-8.8-31.2-26.1-43.5zM8 64H280c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8zM8 192H280c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8zM8 320H152c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "sun-plant-wilt": [640, 512, [], "e57a", "M160 0c-2.9 0-5.6 1.6-7 4.2L120.5 64.5 54.8 44.9c-2.8-.8-5.9-.1-8 2s-2.9 5.1-2 8l19.7 65.6L4.2 153c-2.6 1.4-4.2 4.1-4.2 7s1.6 5.6 4.2 7l60.3 32.5L44.9 265.2c-.8 2.8-.1 5.9 2 8s5.1 2.9 8 2l65.6-19.7L153 315.8c1.4 2.6 4.1 4.2 7 4.2s5.6-1.6 7-4.2l32.5-60.3 65.6 19.7c2.8 .8 5.9 .1 8-2s2.9-5.1 2-8l-19.7-65.6L315.8 167c2.6-1.4 4.2-4.1 4.2-7s-1.6-5.6-4.2-7l-60.3-32.5 19.7-65.6c.8-2.8 .1-5.9-2-8s-5.1-2.9-8-2L199.5 64.5 167 4.2c-1.4-2.6-4.1-4.2-7-4.2zm0 24.9l28.6 53c1.8 3.3 5.7 5 9.3 3.9l57.7-17.3-17.3 57.7c-1.1 3.6 .5 7.5 3.9 9.3l53 28.6-53 28.6c-3.3 1.8-5 5.7-3.9 9.3l17.3 57.7-57.7-17.3c-3.6-1.1-7.5 .5-9.3 3.9l-28.6 53-28.6-53c-1.8-3.3-5.7-5-9.3-3.9L64.4 255.6l17.3-57.7c1.1-3.6-.5-7.5-3.9-9.3L24.9 160l53-28.6c3.3-1.8 5-5.7 3.9-9.3L64.4 64.4l57.7 17.3c3.6 1.1 7.5-.5 9.3-3.9l28.6-53zm48.6 136.3a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-48-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM496 160c0-22.1 17.9-40 40-40s40 17.9 40 40v56.5c-12.6 1.5-23.8 6.6-32.3 15.1c-10.2 10.3-15.7 25-15.7 42.5c0 12.1 6.4 26.9 15.3 41.1c9.1 14.5 21.5 29.7 35.2 42.6c3.1 2.9 7.9 2.9 11 0c13.7-13 26.2-28.2 35.2-42.7c8.9-14.2 15.3-29.1 15.3-41c0-17.5-5.5-32.1-15.7-42.5c-8.5-8.6-19.6-13.6-32.3-15.1V160c0-30.9-25.1-56-56-56s-56 25.1-56 56v56.2c-12.5-14.8-31.1-24.2-52-24.2c-37.6 0-68 30.4-68 68v20.5c-12.6 1.5-23.8 6.6-32.3 15.1c-10.2 10.3-15.7 25-15.7 42.5c0 12.1 6.4 26.9 15.3 41.1c9.1 14.5 21.5 29.7 35.2 42.6c3.1 2.9 7.9 2.9 11 0c13.7-13 26.2-28.2 35.2-42.7c8.9-14.2 15.3-29.1 15.3-41c0-17.5-5.5-32.1-15.7-42.5c-8.5-8.6-19.6-13.6-32.3-15.1V260c0-28.7 23.3-52 52-52s52 23.3 52 52v20V496H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H488 632c4.4 0 8-3.6 8-8s-3.6-8-8-8H496V280 260 160zm88 72c12.3 0 22.2 4 28.9 10.8S624 260 624 274c0 7.3-4.3 18.9-12.9 32.6C604 318 594.6 330 584 340.8c-10.6-10.8-20.1-22.7-27.1-34.1C548.3 293.1 544 281.5 544 274c0-14.1 4.4-24.4 11.1-31.2S571.7 232 584 232zM395.1 370.6C388 382 378.6 394 368 404.8c-10.6-10.8-20.1-22.7-27.1-34.1c-8.5-13.6-12.8-25.3-12.8-32.7c0-14.1 4.4-24.4 11.1-31.2S355.7 296 368 296s22.2 4 28.9 10.8s11.1 17.2 11.1 31.2c0 7.3-4.3 18.9-12.9 32.6z"],
    "toilets-portable": [576, 512, [], "e584", "M56 16H200c22.1 0 40 17.9 40 40V96H16V56c0-22.1 17.9-40 40-40zm184 96V448H16V112H240zM16 504V464H240v40c0 4.4 3.6 8 8 8s8-3.6 8-8V56c0-30.9-25.1-56-56-56H56C25.1 0 0 25.1 0 56V504c0 4.4 3.6 8 8 8s8-3.6 8-8zM176 240v64c0 13.3 10.7 24 24 24h16c4.4 0 8-3.6 8-8s-3.6-8-8-8H200c-4.4 0-8-3.6-8-8V240c0-4.4 3.6-8 8-8h16c4.4 0 8-3.6 8-8s-3.6-8-8-8H200c-13.3 0-24 10.7-24 24zM376 16H520c22.1 0 40 17.9 40 40V96H336V56c0-22.1 17.9-40 40-40zm184 96V448H336V112H560zM336 504V464H560v40c0 4.4 3.6 8 8 8s8-3.6 8-8V56c0-30.9-25.1-56-56-56H376c-30.9 0-56 25.1-56 56V504c0 4.4 3.6 8 8 8s8-3.6 8-8zM496 240v64c0 13.3 10.7 24 24 24h16c4.4 0 8-3.6 8-8s-3.6-8-8-8H520c-4.4 0-8-3.6-8-8V240c0-4.4 3.6-8 8-8h16c4.4 0 8-3.6 8-8s-3.6-8-8-8H520c-13.3 0-24 10.7-24 24z"],
    "hockey-puck": [512, 512, [], "f453", "M16 179.5c0 12.2 5.7 24.4 17.2 36.2c11.6 11.9 28.8 22.9 50.6 32.4C127.5 267 188.3 278.9 256 278.9s128.5-11.9 172.2-30.8c21.8-9.5 39-20.5 50.6-32.4c9.5-9.8 15.1-19.8 16.7-29.9V184h.3c.2-1.5 .3-3 .3-4.5c0-12.2-5.7-24.4-17.2-36.2c-11.6-11.9-28.8-22.9-50.6-32.4C384.5 91.9 323.7 80 256 80s-128.5 11.9-172.2 30.8c-21.8 9.5-39 20.5-50.6 32.4C21.7 155.1 16 167.3 16 179.5zm479.5 41.6c-1.6 2-3.4 3.9-5.2 5.8c-13.5 13.8-32.7 25.9-55.7 35.9c-46.1 20-109.2 32.1-178.5 32.1s-132.4-12.2-178.5-32.1c-23-10-42.2-22.1-55.7-35.9c-2-2.1-4-4.2-5.8-6.4V332.6c0 12.1 5.6 24.4 17.2 36.2c11.6 11.9 28.7 22.9 50.5 32.4c43.6 18.9 104.4 30.8 172 30.8s128.4-11.9 172-30.8c21.8-9.5 39-20.5 50.6-32.4c11.5-11.8 17.2-24.1 17.2-36.2V221.1zM.2 184c-.1-1.5-.2-3-.2-4.5C0 162 8.2 145.9 21.8 132c13.5-13.8 32.7-25.9 55.7-35.9C123.6 76.2 186.7 64 256 64s132.4 12.2 178.5 32.1c23 10 42.2 22.1 55.7 35.9C503.8 145.9 512 162 512 179.5c0 2.6-.2 5.1-.5 7.6V332.6c0 17.5-8.2 33.5-21.7 47.4c-13.5 13.8-32.6 25.9-55.6 35.9C388 435.9 325 448 255.7 448s-132.3-12.1-178.4-32.1c-23-10-42.1-22.1-55.6-35.9C8.2 366.2 0 350.1 0 332.6V184H.2z"],
    "mustache": [640, 512, [], "e5bc", "M235.8 112c-30.2 0-59.2 12.9-79.6 35c-34 36.8-91.2 41.3-129.9 9.6L13.1 145.8c-3.4-2.8-8.5-2.3-11.3 1.1C.6 148.4 0 150.2 0 152H0v8 43.7C0 307.7 84.3 392 188.3 392c45.6 0 89.7-16.6 124-46.6l7.8-6.8 7.8 6.8c34.3 30 78.4 46.6 124 46.6c104 0 188.3-84.3 188.3-188.3V160v-8h0c0-1.8-.6-3.6-1.8-5.1c-2.8-3.4-7.8-3.9-11.3-1.1l-13.2 10.8c-38.7 31.6-95.9 27.2-129.9-9.6c-20.4-22.1-49.4-35-79.6-35c-25.3 0-49.7 8.9-69.1 25L320 149.6 304.9 137c-19.4-16.2-43.9-25-69.2-25zM624 168.9v34.9C624 298.9 546.9 376 451.7 376c-41.7 0-82-15.1-113.4-42.6l-13-11.4c-3-2.6-7.5-2.6-10.5 0l-13 11.4C270.3 360.9 230 376 188.3 376C93.1 376 16 298.9 16 203.7V168.9l.2 .1c45.3 37.1 112.2 31.8 151.8-11.1C185.4 139 210.1 128 235.8 128c21.5 0 42.4 7.5 58.9 21.3l20.2 16.8c3 2.5 7.3 2.5 10.2 0l20.2-16.8c16.5-13.8 37.4-21.3 58.9-21.3c25.7 0 50.4 11 67.8 29.9c39.6 42.9 106.5 48.2 151.8 11.1l.2-.1z"],
    "hyphen": [320, 512, [], "2d", "M0 256c0-4.4 3.6-8 8-8H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8z"],
    "table": [512, 512, [], "f0ce", "M16 96c0-26.5 21.5-48 48-48l384 0c26.5 0 48 21.5 48 48l0 64L16 160l0-64zm232 80l0 128L16 304l0-128 232 0zm16 0l232 0 0 128-232 0 0-128zM248 320l0 144L64 464c-26.5 0-48-21.5-48-48l0-96 232 0zm16 144l0-144 232 0 0 96c0 26.5-21.5 48-48 48l-184 0zM0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"],
    "user-chef": [448, 512, [], "e3d2", "M124 0C90.9 0 64 26.9 64 60c0 23 13 43 32 53.1V152v24c0 70.7 57.3 128 128 128s128-57.3 128-128V152 113.1C371 103 384 83 384 60c0-33.1-26.9-60-60-60c-21.4 0-40.2 11.2-50.8 28.1C262.6 11.2 243.8 0 222.4 0C202 0 184 10.1 173.2 25.7C162.4 10.1 144.4 0 124 0zM112 176V160H336v16c0 61.9-50.1 112-112 112s-112-50.1-112-112zM80 60c0-24.3 19.7-44 44-44c19.3 0 35.7 12.4 41.6 29.7c1.1 3.2 4.1 5.4 7.6 5.4s6.5-2.2 7.6-5.4C186.7 28.4 203.1 16 222.4 16c21 0 38.7 14.8 43 34.6c.8 3.7 4.1 6.3 7.8 6.3s7-2.6 7.8-6.3C285.3 30.8 303 16 324 16c24.3 0 44 19.7 44 44c0 18.3-11.2 34-27.1 40.6c-3 1.2-4.9 4.2-4.9 7.4v36H112V108c0-3.2-1.9-6.1-4.9-7.4C91.2 94 80 78.3 80 60zm32 272.8c0-2.6 2.1-4.8 4.8-4.8c.8 0 1.6 .2 2.3 .6l88.4 47.6-58.5 31.7c-12.9 7-20.9 20.5-20.9 35.2V496H25c-5 0-9-4-9-9c0-54 38.5-98.9 89.5-108.9c3.8-.7 6.5-4 6.5-7.8V332.8zM144 496V443.1c0-8.8 4.8-16.9 12.6-21.1l172.6-93.5c.6-.3 1.3-.5 2-.5c2.6 0 4.8 2.1 4.8 4.8v37.4c0 3.8 2.7 7.1 6.5 7.8c51 10 89.5 55 89.5 108.9c0 5-4 9-9 9H144zM324.3 313.2l-.1-.2-2.4 1.3c-.2 .1-.3 .2-.5 .2L224 366.9l-97.4-52.4c-3-1.6-6.4-2.5-9.9-2.5c-11.5 0-20.8 9.3-20.8 20.8v31C40.8 377.7 0 427.5 0 487c0 13.8 11.2 25 25 25H423c13.8 0 25-11.2 25-25c0-59.5-40.8-109.4-96-123.2v-31c0-11.5-9.3-20.8-20.8-20.8c-2.4 0-4.7 .4-6.9 1.2zM240 444a12 12 0 1 0 0-24 12 12 0 1 0 0 24zm76-12a12 12 0 1 0 -24 0 12 12 0 1 0 24 0z"],
    "message-image": [512, 512, ["comment-alt-image"], "e1e0", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM168 128a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-40-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm167.7 40c2.6 0 5 1.3 6.5 3.4L407.2 297.4c.5 .7 .8 1.5 .8 2.4c0 2.3-1.9 4.2-4.2 4.2h-296c-2.1 0-3.8-1.7-3.8-3.8c0-.9 .3-1.7 .8-2.4l56.5-70.6c1.6-2 4-3.1 6.5-3.1c2.6 0 5.1 1.2 6.7 3.3l19.1 25.5c1.5 2 3.8 3.2 6.3 3.2s4.8-1.1 6.4-3.1L289.5 147c1.5-1.9 3.8-3 6.2-3zm-18.8-6.9l-76.8 97.7-12.9-17.1c-4.6-6.1-11.8-9.7-19.5-9.7c-7.4 0-14.4 3.4-19 9.1L92.3 287.8c-2.8 3.5-4.3 7.9-4.3 12.4c0 11 8.9 19.8 19.8 19.8h296c11.1 0 20.2-9 20.2-20.2c0-4.1-1.3-8.2-3.6-11.6L315.3 138.2c-4.5-6.4-11.8-10.2-19.6-10.2c-7.3 0-14.3 3.4-18.8 9.1z"],
    "users-medical": [640, 512, [], "f830", "M208 80A64 64 0 1 0 80 80a64 64 0 1 0 128 0zM64 80a80 80 0 1 1 160 0A80 80 0 1 1 64 80zM320 304a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-176a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM261.3 368C196.5 368 144 420.5 144 485.3c0 5.9 4.8 10.7 10.7 10.7h310c1 5.7 2.9 11.1 5.8 16H154.7c-14.7 0-26.7-11.9-26.7-26.7C128 411.7 187.7 352 261.3 352H378.7c8.1 0 16.1 .7 23.8 2.1c-3.5 4.4-6.3 9.5-8.1 14.9c-5.1-.7-10.4-1-15.7-1H261.3zM512 144a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM512 0a80 80 0 1 1 0 160A80 80 0 1 1 512 0zm24 208H447c-.7-5.4-1.7-10.8-3-16h92c57.4 0 104 46.6 104 104c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-48.6-39.4-88-88-88zm-343 0H104c-48.6 0-88 39.4-88 88c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-57.4 46.6-104 104-104h92c-1.3 5.2-2.4 10.6-3 16zM504 312v56c0 4.4-3.6 8-8 8H440c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h56c4.4 0 8 3.6 8 8v56c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V432c0-4.4 3.6-8 8-8h56c4.4 0 8-3.6 8-8V384c0-4.4-3.6-8-8-8H560c-4.4 0-8-3.6-8-8V312c0-4.4-3.6-8-8-8H512c-4.4 0-8 3.6-8 8zm8-24h32c13.3 0 24 10.7 24 24v48h48c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H568v48c0 13.3-10.7 24-24 24H512c-13.3 0-24-10.7-24-24V440H440c-13.3 0-24-10.7-24-24V384c0-13.3 10.7-24 24-24h48V312c0-13.3 10.7-24 24-24z"],
    "sensor-triangle-exclamation": [640, 512, ["sensor-alert"], "e029", "M64 48H384c26.5 0 48 21.5 48 48v33.8c5.2-1.2 10.6-1.8 16-1.8V96c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H225c-.6-4-1-8.1-1-12.3c0-1.2 0-2.5 .1-3.7H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48zm32 56c0-4.4-3.6-8-8-8s-8 3.6-8 8V280c0 4.4 3.6 8 8 8s8-3.6 8-8V104zm64 0c0-4.4-3.6-8-8-8s-8 3.6-8 8V280c0 4.4 3.6 8 8 8s8-3.6 8-8V104zM275.7 453.7l150.4-265c4.5-7.9 12.9-12.8 21.9-12.8s17.5 4.9 21.9 12.8l150.4 265c2.4 4.3 3.7 9.1 3.7 14c0 15.6-12.7 28.3-28.3 28.3H300.3c-15.6 0-28.3-12.7-28.3-28.3c0-4.9 1.3-9.7 3.7-14zM412.2 180.9l-150.4 265c-3.8 6.7-5.8 14.2-5.8 21.9c0 24.5 19.8 44.3 44.3 44.3H595.7c24.5 0 44.3-19.8 44.3-44.3c0-7.7-2-15.2-5.8-21.9l-150.4-265C476.5 168 462.8 160 448 160s-28.5 8-35.8 20.9zM456 288c0-4.4-3.6-8-8-8s-8 3.6-8 8v96c0 4.4 3.6 8 8 8s8-3.6 8-8V288zm-8 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "magnifying-glass-arrow-right": [512, 512, [], "e521", "M208 16a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 400c54.6 0 104.2-21 141.3-55.4l149 149c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-149-149C395 312.2 416 262.6 416 208C416 93.1 322.9 0 208 0S0 93.1 0 208S93.1 416 208 416zm29.7-293.7c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L292.7 200H104c-4.4 0-8 3.6-8 8s3.6 8 8 8H292.7l-66.3 66.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l80-80c3.1-3.1 3.1-8.2 0-11.3l-80-80z"],
    "tachograph-digital": [640, 512, ["digital-tachograph"], "f566", "M64 80c-26.5 0-48 21.5-48 48V384c0 26.5 21.5 48 48 48H576c26.5 0 48-21.5 48-48V128c0-26.5-21.5-48-48-48H64zM0 128C0 92.7 28.7 64 64 64H576c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128zm96 16c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16H320c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16H96zM64 160c0-17.7 14.3-32 32-32H320c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V160zm0 216c0-4.4 3.6-8 8-8H344c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-4.4 0-8-3.6-8-8zm320 0c0-4.4 3.6-8 8-8H568c4.4 0 8 3.6 8 8s-3.6 8-8 8H392c-4.4 0-8-3.6-8-8zM80 288a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "face-mask": [576, 512, [], "e37f", "M480 400c-43.8 58.3-113.5 96-192 96s-148.2-37.7-192-96h48.6c3.9 27.1 27.2 48 55.4 48H376c28.2 0 51.6-20.9 55.4-48H480zm11-16H488 432V312c0-6.2-1-12.1-2.8-17.7l98.4-52.5c.3 4.7 .4 9.4 .4 14.2c0 47.1-13.5 91-36.9 128zM526 224.6L422 280c-10.1-14.5-26.9-24-46-24H200c-19 0-35.9 9.5-46 24L50 224.6C65.4 106.9 166.1 16 288 16s222.6 90.9 238 208.6zm15-8C522 93.9 416 0 288 0S54 93.9 35 216.6c-3.8-1.5-8.1 0-10.1 3.6c-2.1 3.9-.6 8.7 3.3 10.8l4.7 2.5c-.6 7.4-1 14.9-1 22.4c0 141.4 114.6 256 256 256s256-114.6 256-256c0-7.6-.3-15-1-22.4l4.7-2.5c3.9-2.1 5.4-6.9 3.3-10.8c-1.9-3.7-6.3-5.2-10.1-3.6zM48.4 241.8l98.4 52.5c-1.8 5.6-2.8 11.5-2.8 17.7v72H88 84.9C61.5 347 48 303.1 48 256c0-4.8 .1-9.5 .4-14.2zM376 272c22.1 0 40 17.9 40 40v80c0 22.1-17.9 40-40 40H200c-22.1 0-40-17.9-40-40V312c0-22.1 17.9-40 40-40H376zM184 320c0 4.4 3.6 8 8 8H384c4.4 0 8-3.6 8-8s-3.6-8-8-8H192c-4.4 0-8 3.6-8 8zm0 64c0 4.4 3.6 8 8 8H384c4.4 0 8-3.6 8-8s-3.6-8-8-8H192c-4.4 0-8 3.6-8 8zm56-216c4.4 0 8-3.6 8-8s-3.6-8-8-8c-53.3 0-89.5 22.1-101.7 34.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0c9.1-9.1 41.2-29.7 90.3-29.7zm186.3 29.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3C425.5 174.1 389.3 152 336 152c-4.4 0-8 3.6-8 8s3.6 8 8 8c49.1 0 81.2 20.5 90.3 29.7z"],
    "pickleball": [576, 512, [], "e435", "M374.9 39.4c-31.3-31.2-82-31.2-113.3 0L103.7 196.8c-18.4 18.3-23.8 45.8-13.9 69.7l28.3 67.8c7.5 17.9 3.4 38.6-10.4 52.3L39.1 455.1c-9.4 9.4-9.4 24.5 0 33.9s24.6 9.4 34 0L142 420.4c13.7-13.7 34.3-17.8 52.2-10.4l66.5 27.3c7.1 2.9 14.6 4.5 22 4.7c2.1 5.4 4.5 10.7 7.2 15.9c-11.8 .7-23.9-1.2-35.3-5.8l-66.5-27.3c-12-4.9-25.7-2.2-34.8 7L84.4 500.3c-15.6 15.6-41 15.6-56.7 0s-15.6-40.9 0-56.5l68.7-68.5c9.2-9.2 11.9-22.9 6.9-34.9L75.1 272.7c-12.5-29.9-5.6-64.3 17.3-87.2L250.3 28.1c37.5-37.4 98.4-37.4 135.9 0L499.8 141.3c29.4 29.3 35.8 72.9 19.1 108.4c-4.5-2.9-9.1-5.6-13.9-8.1c13.1-29.3 7.6-65-16.5-89L374.9 39.4zM280.4 332.6c-2 5.8-3.6 11.7-4.9 17.7L138.6 213.9c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L280.4 332.6zM431.9 496.1a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm0-240a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm-64 128a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm64 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0-48a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm80 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-64-64a16 16 0 1 1 0-32 16 16 0 1 1 0 32z"],
    "star-sharp-half": [576, 512, [], "e28c", "M280 34.4l-48.4 152c-1.1 3.3-4.1 5.6-7.6 5.6H50.9c-1.6 0-2.9 1.3-2.9 2.9c0 .9 .4 1.7 1 2.2L189.1 313.9c2.5 2.1 3.5 5.4 2.5 8.5L139.4 494.1c-.3 .9 .4 1.9 1.4 1.9c.3 0 .6-.1 .9-.3L280 388.1V34.4zM271.4 8.8c1.7-5.2 6.5-8.8 12-8.8c7 0 12.6 5.7 12.6 12.6V392c0 2.5-1.1 4.8-3.1 6.3l-141.4 110c-3.1 2.4-6.8 3.7-10.7 3.7c-11.7 0-20.1-11.3-16.7-22.5l50.7-166.7L38.8 209.4c-4.3-3.6-6.8-8.9-6.8-14.5c0-10.4 8.5-18.9 18.9-18.9H218.2L271.4 8.8z"],
    "users-slash": [640, 512, [], "e073", "M144 16c33.9 0 61.7 26.4 63.9 59.7l15.7 12.4c.3-2.7 .4-5.4 .4-8.2c0-44.2-35.8-80-80-80c-9.3 0-18.1 1.6-26.4 4.5l15.7 12.4c3.5-.6 7-.9 10.7-.9zM104 192C46.6 192 0 238.6 0 296c0 4.4 3.6 8 8 8s8-3.6 8-8c0-48.6 39.4-88 88-88h39l-20.3-16H104zM261.3 352C187.7 352 128 411.7 128 485.3c0 14.7 11.9 26.7 26.7 26.7H485.3c10.5 0 19.6-6.1 23.9-14.9l-13.3-10.5c-.6 5.3-5.1 9.4-10.6 9.4H154.7c-5.9 0-10.7-4.8-10.7-10.7C144 420.5 196.5 368 261.3 368h84.3l-20.3-16H261.3zM416 224c0-53-43-96-96-96c-13 0-25.4 2.6-36.7 7.3L298.2 147c6.9-2 14.3-3 21.8-3c44.2 0 80 35.8 80 80c0 1.1 0 2.3-.1 3.4l14.9 11.8c.8-4.9 1.2-10 1.2-15.1zM512 16a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 144A80 80 0 1 0 512 0a80 80 0 1 0 0 160zm24 48c48.6 0 88 39.4 88 88c0 4.4 3.6 8 8 8s8-3.6 8-8c0-57.4-46.6-104-104-104H444c1.3 5.2 2.4 10.6 3 16h89zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "clover": [448, 512, [], "e139", "M171.3 48c-21.5 0-39 17.5-39 39v4.1c0 8.8 2.1 17.5 6.1 25.4l44.7 87.9c1.6 3.1 1 6.8-1.5 9.3s-6.2 3-9.3 1.5L84.5 170.4c-7.9-4-16.5-6.1-25.4-6.1H55c-21.5 0-39 17.5-39 39c0 10.3 4.1 20.3 11.4 27.6l19.5 19.5c3.1 3.1 3.1 8.2 0 11.3L27.4 281.1C20.1 288.4 16 298.4 16 308.7c0 21.5 17.5 39 39 39h4.1c8.8 0 17.5-2.1 25.4-6.1l87.9-44.7c3.1-1.6 6.8-1 9.3 1.5s3 6.2 1.5 9.3l-44.7 87.9c-4 7.9-6.1 16.6-6.1 25.4V425c0 21.5 17.5 39 39 39c10.3 0 20.3-4.1 27.6-11.4l19.5-19.5c1.5-1.5 3.5-2.3 5.7-2.3s4.2 .8 5.7 2.3l19.5 19.5c7.3 7.3 17.2 11.4 27.6 11.4c21.5 0 39-17.5 39-39v-4.1c0-8.8-2.1-17.5-6.1-25.4l-44.7-87.9c-1.6-3.1-1-6.8 1.5-9.3s6.2-3 9.3-1.5l87.9 44.7c7.9 4 16.6 6.1 25.4 6.1H393c21.5 0 39-17.5 39-39c0-10.3-4.1-20.3-11.4-27.6l-19.5-19.5c-1.5-1.5-2.3-3.5-2.3-5.7s.8-4.2 2.3-5.7l19.5-19.5c7.3-7.3 11.4-17.2 11.4-27.6c0-21.5-17.5-39-39-39h-4c-8.9 0-17.6 2.1-25.5 6.2l-86.6 44.6c-3.1 1.6-6.8 1-9.3-1.4s-3.1-6.2-1.5-9.3l43.8-88c3.9-7.8 5.9-16.3 5.9-25V87c0-21.5-17.5-39-39-39c-10.3 0-20.3 4.1-27.6 11.4L229.7 78.9c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3L198.9 59.4C191.6 52.1 181.6 48 171.3 48zm-55 39c0-30.4 24.6-55 55-55c14.6 0 28.6 5.8 38.9 16.1L224 61.9l13.8-13.8C248.1 37.8 262.1 32 276.7 32c30.4 0 55 24.6 55 55v4.4c0 11.2-2.6 22.2-7.5 32.1l-32.9 66.2 64.9-33.4c10.2-5.2 21.4-8 32.9-8h4c30.4 0 55 24.6 55 55c0 14.6-5.8 28.6-16.1 38.9L418.1 256l13.8 13.8c10.3 10.3 16.1 24.3 16.1 38.9c0 30.4-24.6 55-55 55h-4.1c-11.3 0-22.5-2.7-32.6-7.8l-66-33.6 33.6 66c5.1 10.1 7.8 21.3 7.8 32.6V425c0 30.4-24.6 55-55 55c-14.6 0-28.6-5.8-38.9-16.1L224 450.1l-13.8 13.8c-10.3 10.3-24.3 16.1-38.9 16.1c-30.4 0-55-24.6-55-55v-4.1c0-11.3 2.7-22.5 7.8-32.6l33.6-66-66 33.6c-10.1 5.1-21.3 7.8-32.6 7.8H55c-30.4 0-55-24.6-55-55c0-14.6 5.8-28.6 16.1-38.9L29.9 256 16.1 242.2C5.8 231.9 0 217.9 0 203.3c0-30.4 24.6-55 55-55h4.1c11.3 0 22.5 2.7 32.6 7.8l66 33.6-33.6-66c-5.1-10.1-7.8-21.3-7.8-32.6V87z"],
    "meat": [512, 512, [127830], "f814", "M271.1 31.1c-15 15-19.1 40-11.1 70.3c7.9 30.1 27.5 63.7 57.2 93.4s63.4 49.3 93.4 57.2c30.3 8 55.3 3.8 70.3-11.1c9.6-9.6 14.7-23.3 15.1-40c-.2-10.9-1.9-21.6-4.5-31.6c-1.4-5.4-3.1-10.7-5.1-16.1c-9.9-25.3-27.4-52-51.5-76.1c-23.7-23.7-50-41-75-51c-5.7-2.2-11.5-4.1-17.2-5.6c-10.4-2.7-21.5-4.4-32.8-4.5c-16.1 .6-29.4 5.7-38.7 15.1zM406.5 267.5c-33.3-8.8-69.3-30-100.7-61.4s-52.6-67.4-61.4-100.7c-6.2-23.7-6.3-46.8 1.8-65.6l-.9 .9L197.9 88.2C163.4 122.7 144 169.5 144 218.3V296c0 39.8 32.2 72 72 72h77.7c48.8 0 95.6-19.4 130.1-53.8l47.6-47.6 0 0c.3-.3 .7-.7 1-1c-18.9 8.2-42.1 8.2-65.9 1.9zM446.8 65.3c24.4 24.4 43.4 52.9 54.5 82.3c2.5 6.4 4.6 12.7 6.2 19c3.1 11.8 4.7 23.4 4.5 34.5c.4 26.4-6.9 54.5-29.3 77l0 0-47.6 47.6C397.6 363 346.8 384 293.7 384H216c-6.4 0-12.7-.7-18.7-2c-.4 .3-.7 .6-1 1l-14.7 14.7c-3.1 3.1-3.6 9.6 .3 15.7c6.4 10 10.1 21.9 10.1 34.6c0 35.3-28.7 64-64 64s-64-28.7-64-64c-35.3 0-64-28.7-64-64s28.7-64 64-64c12.7 0 24.6 3.7 34.6 10.1c6.1 3.9 12.6 3.4 15.7 .3L129 315.7c.3-.3 .7-.7 1-1.1c-1.3-6-2-12.2-2-18.6V218.3c0-53 21.1-103.9 58.6-141.4l47.5-47.5c22-22 49.5-29.4 75.5-29.4c11.5-.4 23.6 1.2 35.9 4.4c6.7 1.8 13.4 4 20.3 6.7c28.9 11.1 57 30 81 54zM135.6 331.8l-10 10c-10.3 10.3-25.8 8.2-35.6 1.8C82.5 338.8 73.6 336 64 336c-26.5 0-48 21.5-48 48s21.5 48 48 48c8.7 0 16 7.3 16 16c0 26.5 21.5 48 48 48s48-21.5 48-48c0-9.6-2.8-18.5-7.6-25.9c-6.3-9.8-8.5-25.3 1.8-35.6l10-10c-19.9-8.8-35.8-24.8-44.7-44.7zM354 114c-1.6 1.6-2.9 5.3-1.2 11.8c1.7 6.3 5.9 13.8 12.7 20.6s14.3 11.1 20.6 12.7c6.5 1.7 10.2 .4 11.8-1.2s2.9-5.3 1.2-11.8c-1.7-6.3-5.9-13.8-12.7-20.6s-14.3-11.1-20.6-12.7c-6.5-1.7-10.2-.4-11.8 1.2zm43.8 .2c8.5 8.5 14.4 18.4 16.9 27.9c2.4 9.3 1.9 19.9-5.4 27.2s-17.9 7.8-27.2 5.4c-9.5-2.5-19.4-8.4-27.9-16.9s-14.4-18.4-16.9-27.9c-2.4-9.3-1.9-19.9 5.4-27.2s17.9-7.8 27.2-5.4c9.5 2.5 19.4 8.4 27.9 16.9z"],
    "reply": [512, 512, [61714, "mail-reply"], "f3e5", "M224 144c-8.8 0-16-7.2-16-16V64c0-6.3-3.7-12-9.5-14.6s-12.5-1.5-17.2 2.7l-160 144c-3.4 3-5.3 7.4-5.3 11.9s1.9 8.9 5.3 11.9l160 144c4.7 4.2 11.4 5.3 17.2 2.7s9.5-8.3 9.5-14.6V288c0-8.8 7.2-16 16-16h96c61.9 0 112 50.1 112 112c0 35.5-15.2 57.1-27.3 68.4c-3.7 3.5-4.7 6.5-4.7 7.8c0 2.1 1.7 3.7 3.7 3.7c.3 0 .5 0 .6 0c17.1-9.3 91.8-55.7 91.8-160c0-88.4-71.6-160-160-160H224zm0 160v48c0 12.6-7.4 24.1-19 29.2s-25 3-34.4-5.4l-160-144C3.9 225.7 0 217.1 0 208s3.9-17.7 10.6-23.8l160-144c9.4-8.5 22.9-10.6 34.4-5.4s19 16.6 19 29.2v48 16h16 96c97.2 0 176 78.8 176 176c0 113.3-81.5 163.9-100.2 174.1c-2.5 1.4-5.3 1.9-8.1 1.9c-10.9 0-19.7-8.9-19.7-19.7c0-7.5 4.3-14.4 9.8-19.5c9.4-8.8 22.2-26.4 22.2-56.7c0-53-43-96-96-96H240 224v16z"],
    "star-and-crescent": [512, 512, [9770], "f699", "M16 256C16 123.5 123.5 16 256 16c31 0 60.6 5.9 87.7 16.5c-5.2-.4-10.4-.5-15.7-.5C204.3 32 104 132.3 104 256s100.3 224 224 224c5.3 0 10.5-.2 15.7-.5C316.6 490.1 287 496 256 496C123.5 496 16 388.5 16 256zM256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c33 0 64.6-6.3 93.6-17.7c7.4-2.9 11.5-10.7 9.8-18.4s-8.8-13-16.7-12.4c-4.8 .3-9.7 .5-14.6 .5c-114.9 0-208-93.1-208-208s93.1-208 208-208c4.9 0 9.8 .2 14.6 .5c7.9 .5 15-4.7 16.7-12.4s-2.4-15.5-9.8-18.4C320.6 6.3 289 0 256 0zM358.3 208.3L384 156.2l25.7 52.2c3.7 7.6 10.9 12.8 19.3 14l57.6 8.4-41.6 40.6c-6 5.9-8.8 14.4-7.4 22.7l9.8 57.3-51.5-27.1c-7.5-3.9-16.4-3.9-23.8 0l-51.5 27.1 9.8-57.3c1.4-8.3-1.3-16.8-7.4-22.7l-41.6-40.6 57.6-8.4c8.3-1.2 15.5-6.4 19.3-14zm17.1-70.9l-31.5 63.8c-1.4 2.8-4.1 4.8-7.2 5.3l-70.4 10.2c-7.9 1.1-11 10.8-5.3 16.4l50.9 49.6c2.3 2.2 3.3 5.4 2.8 8.5l-12 70.1c-1.3 7.8 6.9 13.8 13.9 10.1l63-33.1c2.8-1.5 6.1-1.5 8.9 0l63 33.1c7 3.7 15.3-2.3 13.9-10.1l-12-70.1c-.5-3.1 .5-6.3 2.8-8.5L507 233.1c5.7-5.6 2.6-15.2-5.3-16.4l-70.4-10.2c-3.1-.5-5.8-2.4-7.2-5.3l-31.5-63.8c-3.5-7.1-13.7-7.1-17.2 0z"],
    "empty-set": [512, 512, [8709, 216], "f656", "M485.7 37.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L408.6 92.1C368.6 54.8 315 32 256 32C132.3 32 32 132.3 32 256c0 59 22.8 112.6 60.1 152.6L26.3 474.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l65.7-65.7C143.4 457.2 197 480 256 480c123.7 0 224-100.3 224-224c0-59-22.8-112.6-60.1-152.6l65.7-65.7zm-88.3 65.7L103.4 397.3C69 360.2 48 310.6 48 256C48 141.1 141.1 48 256 48c54.6 0 104.2 21 141.3 55.4zM114.7 408.6L408.6 114.7C443 151.8 464 201.4 464 256c0 114.9-93.1 208-208 208c-54.6 0-104.2-21-141.3-55.4z"],
    "house-fire": [640, 512, [], "e50c", "M293.3 2c-3-2.7-7.6-2.7-10.6 0L2.7 250c-3.3 2.9-3.6 8-.7 11.3s8 3.6 11.3 .7L64 217.1V448c0 35.3 28.7 64 64 64H374.3c-7.9-5.3-15.3-11.1-22.3-17.5V496H224V328c0-4.4 3.6-8 8-8h59.6c1.2-5.3 2.7-10.7 4.4-16H232c-13.3 0-24 10.7-24 24V496H128c-26.5 0-48-21.5-48-48V202.9L288 18.7 419.2 134.9c5.3-3.2 11.1-5.3 17-6.3L293.3 2zM509.2 237.5c4.8-.1 9.4-2.3 12.3-6c7.6-9.5 15.6-19.2 23.9-26.9c22.7 21 42.2 49 56.2 76c14 27.1 22.4 55.2 22.4 71.6c0 79-64.1 143.8-144 143.8c-80.8 0-144-64.8-144-143.8c0-22.2 11-53.4 30-84.2c18.9-30.7 45.8-63 77.6-91.5c18.9 17.1 36.6 35.5 53.1 55.3c3.1 3.7 7.7 5.8 12.5 5.8zm-10.8-28.4c-14.2-16.1-29.1-31.2-44.9-45.3c-2.8-2.5-6.3-3.7-9.8-3.8c-3.6 0-7.2 1.2-10 3.7c-33.2 29.7-61.4 63.4-81.4 95.8c-19.7 31.9-32.4 66.2-32.4 92.6C320 439.9 390.3 512 480 512c88.7 0 160-72 160-159.8c0-20.2-9.6-50.9-24.2-79c-14.8-28.5-35.7-58.5-60.4-81.1c-5.6-5.1-14.4-5.2-20 0c-5.6 5.1-11 11-16.1 16.9c-3.6 4.2-7.1 8.5-10.3 12.6c-3.5-4.2-7-8.3-10.6-12.4zM441.7 256c-2.4 0-4.7 1.1-6.2 3c-16.5 20.4-29.3 36.8-37.9 51.6c-8.7 15-13.5 28.8-13.5 43.9c0 29.1 10.8 52.8 28.7 69.2c17.8 16.3 42.2 24.9 68.7 24.9c21.5 0 40.7-6 58.5-17.9l0 0 .2-.1c36.7-25.7 46.1-76.6 24.6-116.2l0-.1 0 0c-2.2-4.3-4.6-9.3-8.4-14.3c-1.5-1.9-3.7-3.1-6.1-3.2s-4.8 .9-6.3 2.8l-33.4 38.9-4-5.2-22.5-28.7c-16.5-21.1-33.7-42.9-35.9-45.7c-1.5-1.9-3.8-3-6.2-3zm68.4 95.2l-6.3 4.9c1.5 1.9 3.7 3 6.1 3.1s4.7-1 6.2-2.8l32.6-38c.5 1.1 1.1 2.1 1.7 3.3l0 0 .1 .3c18.1 33.2 9.8 74.9-19.6 95.5c-15.3 10.2-31.4 15.2-49.5 15.2c-23.1 0-43.5-7.4-57.9-20.7c-14.4-13.1-23.5-32.5-23.5-57.4c0-11.4 3.5-22.4 11.3-35.8c6.9-11.8 16.9-25.1 30.3-41.8c6.9 8.8 18.4 23.4 29.6 37.8l22.5 28.7 7.3 9.3 2 2.6 .5 .7 .1 .2 0 0 0 0 0 0 6.3-4.9z"],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM128 248H320c4.4 0 8 3.6 8 8s-3.6 8-8 8H128c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "helicopter": [640, 512, [128641], "f533", "M136 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H352V144H132.5L96.2 83.4C89 71.4 75.9 64 61.9 64H36.5C20.9 64 9.4 78.7 13.2 93.8l23.2 93c3 11.9 11.3 21.9 22.6 26.9l123.3 54.8c3.2 1.4 6 3.5 8.3 6.1l97.8 111.8C296 395 307 400 318.5 400h.5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .5 .4 .5 .4 .5 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .5 .4 .4 .5 .5 .5 .5 .5 .5 .5 .5 .5c22.1 0 40-17.9 40-40V280c0-75.1-60.9-136-136-136H368V16H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H136zM36.5 80H61.9c8.4 0 16.2 4.4 20.6 11.7l38.7 64.5c1.4 2.4 4 3.9 6.9 3.9H352V384h-.3-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H341h-.4-.5-.4-.5-.5-.5-.5-.5H337h-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5H332h-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5H326h-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5-.5H319h-.5c-6.9 0-13.5-3-18.1-8.2L202.7 264c-3.8-4.4-8.6-7.9-13.9-10.2L65.5 199c-6.8-3-11.7-8.9-13.5-16.1l-23.2-93c-1.3-5 2.6-9.9 7.8-9.9zM368.2 384H368V160h72c66.3 0 120 53.7 120 120v80c0 13.2-10.8 24-24 24h-.5-.5-.5-.5-.5-.5-.5-.5-.5-.4H531h-.5-.4-.4-.4-.4-.4-.4-.4H527h-.4-.4-.4-.4-.4-.4-.4-.4H523h-.4-.4-.4-.4-.4-.4-.4-.4H519h-.4-.4-.4-.4-.4-.4H516h-.4-.4-.4-.4-.4-.4-.4-.4H512h-.4-.4-.4-.4-.4-.4H509h-.4-.4-.4-.4-.4-.4H506h-.4-.4-.4-.4-.4-.4H503h-.4-.4-.4-.4-.4-.4H500h-.4-.4-.4-.4-.4-.4H497h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H489h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H484h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H479h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H474h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H467h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H460h-.4-.4-.4-.4H458h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H449h-.4-.4-.4-.4H447h-.4-.4-.4-.4H445h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H436h-.4-.4-.4-.4H434h-.4-.4-.4-.4H432h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H423h-.4-.4-.4-.4H421h-.4-.4-.4-.4H419h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H412h-.4-.4-.4-.4H410h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H405h-.4-.4-.4-.4H403h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H398h-.4-.4-.4-.4H396h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H391h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H386h-.4-.4-.4-.4-.4-.4H383h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4H378h-.4-.4-.4-.4-.4-.4H375h-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4zm269.9 77.1c2.8-3.4 2.4-8.4-1-11.3s-8.4-2.4-11.3 1l-20.8 25c-10.6 12.8-26.4 20.2-43 20.2H232c-4.4 0-8 3.6-8 8s3.6 8 8 8H562c21.4 0 41.6-9.5 55.3-25.9l20.8-25z"],
    "bird": [512, 512, [], "e469", "M240 104c0-48.6 39.4-88 88-88c41.1 0 75.6 28.2 85.3 66.3l-.3 .5 .5 .3c1.6 6.7 2.5 13.8 2.5 21v80c0 110.3-90.8 200-201.3 200C105.5 384 16 295.5 16 186.7c0-5.9 4.8-10.7 10.7-10.7H192c26.5 0 48-21.5 48-48V104zm192 0c0-3.4-.2-6.8-.5-10.2L488.5 128 432 161.9V104zm0 80v-3.5l76.1-45.7c2.4-1.4 3.9-4 3.9-6.9s-1.5-5.4-3.9-6.9l-80-48-.9-.6C413.8 30.5 374.5 0 328 0C270.6 0 224 46.6 224 104v24c0 17.7-14.3 32-32 32H26.7C11.9 160 0 171.9 0 186.7C0 292.2 77.7 379.8 178.6 397l62.5 111c2.2 3.8 7 5.2 10.9 3s5.2-7 3-10.9L198.3 399.4c5.4 .4 10.9 .6 16.4 .6c18.8 0 37-2.4 54.4-6.9l68.1 115c2.2 3.8 7.2 5.1 11 2.8s5.1-7.2 2.8-11l-66-111.5C370.1 359.3 432 278.8 432 184zm-96-56a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "compass": [512, 512, [129517], "f14e", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm95.1-381.5L204.6 179.4c-11.9 4-21.3 13.4-25.3 25.3L130.5 351.1c-6.3 18.8 11.6 36.6 30.4 30.4l146.5-48.8c11.9-4 21.3-13.4 25.3-25.3l48.8-146.5c6.3-18.8-11.6-36.6-30.4-30.4zm15.2 25.3L317.5 302.3c-2.4 7.2-8 12.8-15.2 15.2L155.8 366.3c-6.3 2.1-12.2-3.9-10.1-10.1l48.8-146.5c2.4-7.2 8-12.8 15.2-15.2l146.5-48.8c6.3-2.1 12.2 3.9 10.1 10.1zM240 256a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", "M64 464c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64zM0 416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416zm224-64c7.3 0 14.3-3 19.3-8.4L345.2 234.4c4.4-4.7 6.8-10.8 6.8-17.2c0-13.9-11.3-25.2-25.2-25.2H121.2C107.3 192 96 203.3 96 217.2c0 6.4 2.4 12.5 6.8 17.2L204.7 343.6c5 5.4 12 8.4 19.3 8.4zM121.2 208H326.8c5.1 0 9.2 4.1 9.2 9.2c0 2.3-.9 4.6-2.5 6.3L231.6 332.7c-2 2.1-4.7 3.3-7.6 3.3s-5.6-1.2-7.6-3.3L114.5 223.5c-1.6-1.7-2.5-4-2.5-6.3c0-5.1 4.1-9.2 9.2-9.2z"],
    "heart-half-stroke": [512, 512, ["heart-half-alt"], "e1ac", "M282.4 105.2c25.4-34.9 68.3-53.2 111.2-47.6C451.9 65.3 496 115 496 173.6c0 30.3-11.7 59.3-32.8 81.1L264.7 460.4c-.2 .2-.5 .5-.7 .7V130.6l18.4-25.4zM248 130.6V460.5c0 0 0 0 0 0L48.9 254.7C27.8 232.9 16 203.8 16 173.5C16 114.9 60.1 65.3 118.3 57.7c42.9-5.6 85.8 12.6 111.2 47.6L248 130.6zM395.7 41.8c-48.6-6.3-97.3 14.3-126.2 54L256 114.4 242.5 95.8c-28.9-39.7-77.6-60.4-126.2-54C50.2 50.4 0 106.8 0 173.5c0 34.5 13.4 67.6 37.4 92.3L236.5 471.6c5.2 5.4 12.4 8.4 19.9 8.4c7.5 0 14.7-3.1 19.9-8.5L474.8 265.8C498.6 241.1 512 208 512 173.6c0-66.8-50.2-123.2-116.3-131.8z"],
    "file-circle-question": [576, 512, [], "e4ef", "M64 496H311.2c5.8 5.5 12 10.6 18.5 15.3c-3.2 .5-6.4 .7-9.7 .7H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H204.1c12.7 0 24.9 5.1 33.9 14.1L369.9 145.9c9 9 14.1 21.2 14.1 33.9v18.7c-5.4 1.5-10.8 3.3-16 5.4V179.9c0-1.3-.1-2.6-.2-3.9H248c-22.1 0-40-17.9-40-40V16.2c-1.3-.2-2.6-.2-3.9-.2H64C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48zM361.1 160c-.8-1-1.6-1.9-2.4-2.7L226.7 25.4c-.9-.9-1.8-1.7-2.7-2.4V136c0 13.3 10.7 24 24 24H361.1zM560 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-64-98.1c0-20.9 17-37.9 37.9-37.9h43.3c25.9 0 46.9 21 46.9 46.9c0 18.4-10.8 35.2-27.6 42.7L440 382.4V392c0 4.4-3.6 8-8 8s-8-3.6-8-8V377.2c0-3.1 1.8-6 4.7-7.3L461.8 355c11.1-5 18.2-16 18.2-28.2c0-17.1-13.8-30.9-30.9-30.9H405.9c-12.1 0-21.9 9.8-21.9 21.9V320c0 4.4-3.6 8-8 8s-8-3.6-8-8v-2.1z"],
    "laptop-code": [640, 512, [], "f5fc", "M128 48H512c26.5 0 48 21.5 48 48V352h16V96c0-35.3-28.7-64-64-64H128C92.7 32 64 60.7 64 96V352H80V96c0-26.5 21.5-48 48-48zM620.8 400c1.8 0 3.2 1.4 3.2 3.2c0 33.6-27.2 60.8-60.8 60.8H76.8C43.2 464 16 436.8 16 403.2c0-1.8 1.4-3.2 3.2-3.2H620.8zM19.2 384C8.6 384 0 392.6 0 403.2C0 445.6 34.4 480 76.8 480H563.2c42.4 0 76.8-34.4 76.8-76.8c0-10.6-8.6-19.2-19.2-19.2H19.2zM269.7 157.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-64 64c-3.1 3.1-3.1 8.2 0 11.3l64 64c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L211.3 216l58.3-58.3zm112-11.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L428.7 216l-58.3 58.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l64-64c3.1-3.1 3.1-8.2 0-11.3l-64-64z"],
    "joystick": [448, 512, [128377], "f8c5", "M320 112a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm16 0c0 59.2-45.9 107.6-104 111.7V352H384c35.3 0 64 28.7 64 64v32c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V416c0-35.3 28.7-64 64-64H216V223.7c-58.1-4.1-104-52.6-104-111.7C112 50.1 162.1 0 224 0s112 50.1 112 112zM64 312c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-4.4 0-8-3.6-8-8zM432 416c0-26.5-21.5-48-48-48H64c-26.5 0-48 21.5-48 48v32c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V416zM192 80a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "grill-fire": [576, 512, [], "e5a4", "M408 48H40C26.7 48 16 58.7 16 72V96c0 114.9 93.1 208 208 208c2.7 0 5.4-.1 8-.2c-1.7 5.4-3.2 10.8-4.4 16.1c-1.2 0-2.4 0-3.6 0c-24.1 0-47.4-3.8-69.2-10.9l-24.1 53.1c8.5 5.5 15.7 13 20.7 21.8H227c1 5.4 2.1 10.7 3.5 16H158c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c7.1 0 13.9 1.2 20.3 3.3l23.5-51.7C57.8 270.3 0 189.9 0 96V72C0 49.9 17.9 32 40 32H408c22.1 0 40 17.9 40 40V96c0 24.1-3.8 47.3-10.9 69.1c-4.2-4.3-8.5-8.5-12.9-12.7c5-17.9 7.7-36.8 7.7-56.4V72c0-13.3-10.7-24-24-24zM96 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM445.2 237.5c-4.8 .1-9.4-2.1-12.5-5.8c-16.5-19.9-34.2-38.3-53.1-55.3c-31.8 28.6-58.7 60.8-77.6 91.5c-19 30.8-30 62.1-30 84.2c0 79 63.2 143.8 144 143.8c79.9 0 144-64.8 144-143.8c0-16.5-8.3-44.5-22.4-71.6c-14-26.9-33.5-54.9-56.2-76c-8.3 7.7-16.3 17.4-23.9 26.9c-3 3.8-7.5 6-12.3 6zm-10.8-28.4c3.6 4.1 7.1 8.2 10.6 12.4c3.3-4.1 6.7-8.4 10.3-12.6c5.1-5.9 10.5-11.8 16.1-16.9c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 58.8 24.2 79C576 440 504.7 512 416 512c-89.7 0-160-72.1-160-159.8c0-26.4 12.7-60.7 32.4-92.6c20-32.4 48.1-66.1 81.4-95.8c2.8-2.5 6.4-3.8 10-3.7c3.5 0 7 1.3 9.8 3.8c15.8 14.2 30.7 29.3 44.9 45.3zM377.7 256c2.4 0 4.7 1.1 6.2 3c2.2 2.8 19.4 24.6 35.9 45.7l22.5 28.7 4 5.2 33.4-38.9c1.6-1.8 3.9-2.9 6.3-2.8s4.7 1.3 6.1 3.2c3.7 5 6.2 10 8.4 14.3l0 0 0 .1c21.5 39.6 12.2 90.5-24.6 116.2l-.2 .1 0 0c-17.8 11.9-37 17.9-58.5 17.9c-26.5 0-50.9-8.6-68.7-24.9c-17.9-16.4-28.7-40.1-28.7-69.2c0-15.1 4.8-28.9 13.5-43.9c8.6-14.8 21.4-31.3 37.9-51.6c1.5-1.9 3.8-3 6.2-3zm68.4 95.2l-6.3 4.9 0 0 0 0 0 0-.1-.2-.5-.7-2-2.6-7.3-9.3-22.5-28.7c-11.3-14.4-22.7-29-29.6-37.8c-13.4 16.7-23.4 30-30.3 41.8c-7.8 13.4-11.3 24.4-11.3 35.8c0 24.9 9.1 44.3 23.5 57.4c14.5 13.2 34.8 20.7 57.9 20.7c18.2 0 34.3-5 49.5-15.2c29.4-20.6 37.7-62.3 19.6-95.5l-.1-.3 0 0c-.6-1.1-1.1-2.2-1.7-3.3l-32.6 38c-1.6 1.8-3.9 2.8-6.2 2.8s-4.6-1.2-6.1-3.1l6.3-4.9z"],
    "rectangle-vertical-history": [576, 512, [], "e237", "M256 16c-26.5 0-48 21.5-48 48V448c0 26.5 21.5 48 48 48H512c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H256zM192 64c0-35.3 28.7-64 64-64H512c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H256c-35.3 0-64-28.7-64-64V64zM96 56c0-4.4 3.6-8 8-8s8 3.6 8 8V456c0 4.4-3.6 8-8 8s-8-3.6-8-8V56zM0 104c0-4.4 3.6-8 8-8s8 3.6 8 8V408c0 4.4-3.6 8-8 8s-8-3.6-8-8V104z"],
    "swatchbook": [512, 512, [], "f5c3", "M0 416c0 53 43 96 96 96s96-43 96-96V40c0-22.1-17.9-40-40-40H40C17.9 0 0 17.9 0 40V416zm96 80c-44.2 0-80-35.8-80-80L16 40c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24V416c0 44.2-35.8 80-80 80zm376 16c22.1 0 40-17.9 40-40V360c0-22.1-17.9-40-40-40H357.9l-16 16H472c13.3 0 24 10.7 24 24V472c0 13.3-10.7 24-24 24H195.9c-4.6 5.8-9.7 11.1-15.3 16H472zM223.8 423.3L430.3 216.7c15.6-15.6 15.6-40.9 0-56.6L351.1 81c-15.6-15.6-40.9-15.6-56.6 0L224 151.5v22.6l81.9-81.9c9.4-9.4 24.6-9.4 33.9 0L419 171.5c9.4 9.4 9.4 24.6 0 33.9l-195 195V416c0 2.4-.1 4.9-.2 7.3zM120 48H72C58.7 48 48 58.7 48 72v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V72c0-13.3-10.7-24-24-24zM64 72c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H72c-4.4 0-8-3.6-8-8V72zm8 104c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h48c13.3 0 24-10.7 24-24V200c0-13.3-10.7-24-24-24H72zm0 16h48c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H72c-4.4 0-8-3.6-8-8V200c0-4.4 3.6-8 8-8zm40 224a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM96 384a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "prescription-bottle": [384, 512, [], "f485", "M344 16c13.3 0 24 10.7 24 24V88c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V40c0-13.3 10.7-24 24-24H344zM40 0C17.9 0 0 17.9 0 40V88c0 22.1 17.9 40 40 40H344c22.1 0 40-17.9 40-40V40c0-22.1-17.9-40-40-40H40zM32 408v40c0 35.3 28.7 64 64 64H288c35.3 0 64-28.7 64-64V160H336V448c0 26.5-21.5 48-48 48H96c-26.5 0-48-21.5-48-48V416H152c4.4 0 8-3.6 8-8s-3.6-8-8-8H48V320H152c4.4 0 8-3.6 8-8s-3.6-8-8-8H48V224H152c4.4 0 8-3.6 8-8s-3.6-8-8-8H48V160H32v56 96 96z"],
    "bars": [448, 512, ["navicon"], "f0c9", "M0 88c0-4.4 3.6-8 8-8H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8zM0 248c0-4.4 3.6-8 8-8H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8zM448 408c0 4.4-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H440c4.4 0 8 3.6 8 8z"],
    "keyboard-left": [640, 512, [], "e1c3", "M576 80c26.5 0 48 21.5 48 48V384c0 26.5-21.5 48-48 48H224c-26.5 0-48-21.5-48-48V128c0-26.5 21.5-48 48-48H576zM224 64c-35.3 0-64 28.7-64 64V384c0 35.3 28.7 64 64 64H576c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64H224zm40 272c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V344c0-4.4 3.6-8 8-8h16zm-16-16c-13.3 0-24 10.7-24 24v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V344c0-13.3-10.7-24-24-24H248zm96 16H456c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H344c-4.4 0-8-3.6-8-8V344c0-4.4 3.6-8 8-8zm-24 8v16c0 13.3 10.7 24 24 24H456c13.3 0 24-10.7 24-24V344c0-13.3-10.7-24-24-24H344c-13.3 0-24 10.7-24 24zM264 240c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V248c0-4.4 3.6-8 8-8h16zm-16-16c-13.3 0-24 10.7-24 24v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V248c0-13.3-10.7-24-24-24H248zm96 16h16c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H344c-4.4 0-8-3.6-8-8V248c0-4.4 3.6-8 8-8zm-24 8v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V248c0-13.3-10.7-24-24-24H344c-13.3 0-24 10.7-24 24zm136-8c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H440c-4.4 0-8-3.6-8-8V248c0-4.4 3.6-8 8-8h16zm-16-16c-13.3 0-24 10.7-24 24v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V248c0-13.3-10.7-24-24-24H440zm96 16h16c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H536c-4.4 0-8-3.6-8-8V248c0-4.4 3.6-8 8-8zm-24 8v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V248c0-13.3-10.7-24-24-24H536c-13.3 0-24 10.7-24 24zm40 88c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H536c-4.4 0-8-3.6-8-8V344c0-4.4 3.6-8 8-8h16zm-16-16c-13.3 0-24 10.7-24 24v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V344c0-13.3-10.7-24-24-24H536zM248 144h16c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V152c0-4.4 3.6-8 8-8zm-24 8v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm136-8c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H344c-4.4 0-8-3.6-8-8V152c0-4.4 3.6-8 8-8h16zm-16-16c-13.3 0-24 10.7-24 24v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H344zm96 16h16c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H440c-4.4 0-8-3.6-8-8V152c0-4.4 3.6-8 8-8zm-24 8v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H440c-13.3 0-24 10.7-24 24zm136-8c4.4 0 8 3.6 8 8v16c0 4.4-3.6 8-8 8H536c-4.4 0-8-3.6-8-8V152c0-4.4 3.6-8 8-8h16zm-16-16c-13.3 0-24 10.7-24 24v16c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V152c0-13.3-10.7-24-24-24H536zM101.7 173.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-88 88c-3.1 3.1-3.1 8.2 0 11.3l88 88c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L19.3 256l82.3-82.3z"],
    "people-group": [640, 512, [], "e533", "M88 88a40 40 0 1 1 80 0A40 40 0 1 1 88 88zm96 0A56 56 0 1 0 72 88a56 56 0 1 0 112 0zm288 0a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0A56 56 0 1 0 456 88a56 56 0 1 0 112 0zM64 256c-4.4 0-8 3.6-8 8v98.2c-24.2-16.9-40-45-40-76.7c0-51.7 41.9-93.5 93.5-93.5h36.9c18.8 0 36.3 5.6 51 15.1c3.7-4 7.6-7.8 11.7-11.4c-17.8-12.4-39.4-19.7-62.7-19.7H109.5C49 176 0 225 0 285.5c0 41.1 22.6 76.8 56 95.6V432c0 17.7 14.3 32 32 32h80c17.7 0 32-14.3 32-32V403.6c-5.9-6.2-11.3-12.8-16-20V432c0 8.8-7.2 16-16 16H88c-8.8 0-16-7.2-16-16V264c0-4.4-3.6-8-8-8zM440 432c0 17.7 14.3 32 32 32h80c17.7 0 32-14.3 32-32V381.1c33.4-18.7 56-54.5 56-95.6C640 225 591 176 530.5 176H493.5c-23.3 0-44.9 7.3-62.7 19.7c4.1 3.6 8 7.4 11.7 11.4c14.7-9.6 32.2-15.1 51-15.1h36.9c51.7 0 93.5 41.9 93.5 93.5c0 31.7-15.8 59.8-40 76.7V264c0-4.4-3.6-8-8-8s-8 3.6-8 8V432c0 8.8-7.2 16-16 16H472c-8.8 0-16-7.2-16-16V383.6c-4.7 7.1-10.1 13.8-16 20V432zM272 96a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0A64 64 0 1 0 256 96a64 64 0 1 0 128 0zM256 272c-4.4 0-8 3.6-8 8v98.2c-24.2-16.9-40-45-40-76.7c0-51.7 41.9-93.5 93.5-93.5h36.9c51.7 0 93.5 41.9 93.5 93.5c0 31.7-15.8 59.8-40 76.7V280c0-4.4-3.6-8-8-8s-8 3.6-8 8V448c0 8.8-7.2 16-16 16H280c-8.8 0-16-7.2-16-16V280c0-4.4-3.6-8-8-8zm-8 125.1V448c0 17.7 14.3 32 32 32h80c17.7 0 32-14.3 32-32V397.1c33.4-18.7 56-54.5 56-95.6C448 241 399 192 338.5 192H301.5C241 192 192 241 192 301.5c0 41.1 22.6 76.8 56 95.6z"],
    "hourglass-end": [384, 512, [8987, "hourglass-3"], "f253", "M0 8C0 3.6 3.6 0 8 0H40 344h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H352V76.7c0 29.9-9.8 58.9-28 82.6l-74 96.7 74 96.7c18.1 23.7 28 52.8 28 82.6V496h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H344 40 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32V435.3c0-29.9 9.8-58.9 28-82.6l74-96.7L60 159.3c-18.1-23.7-28-52.8-28-82.6L32 16H8c-4.4 0-8-3.6-8-8zm48 8l0 60.7c0 26.3 8.7 52 24.7 72.9l77.7 101.6c2.2 2.9 2.2 6.9 0 9.7L72.7 362.4C56.7 383.4 48 409 48 435.3V496H336V435.3c0-26.3-8.7-52-24.7-72.9L233.6 260.9c-2.2-2.9-2.2-6.9 0-9.7l77.7-101.6c16-20.9 24.7-46.5 24.7-72.9V16H48zM198.4 283.2l83.2 110.9c9.3 12.5 14.4 27.6 14.4 43.2V456c0 4.4-3.6 8-8 8H96c-4.4 0-8-3.6-8-8V437.3c0-15.6 5.1-30.7 14.4-43.2l83.2-110.9c1.5-2 3.9-3.2 6.4-3.2s4.9 1.2 6.4 3.2zM115.2 403.7c-7.3 9.7-11.2 21.5-11.2 33.6V448H280V437.3c0-12.1-3.9-23.9-11.2-33.6L192 301.3 115.2 403.7z"],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", "M282.4 105.2c25.4-34.9 68.3-53.2 111.2-47.6C451.9 65.3 496 115 496 173.6c0 30.3-11.7 59.3-32.8 81.1L264.7 460.4c-2.2 2.3-5.2 3.6-8.4 3.6s-6.2-1.3-8.4-3.6L48.9 254.7C27.8 232.9 16 203.8 16 173.5C16 114.9 60.1 65.3 118.3 57.7c42.9-5.6 85.8 12.6 111.2 47.6L248 130.6V144c0 2.1 .8 4.2 2.3 5.7l41.1 41.1-87.9 58.6c-1.9 1.2-3.1 3.2-3.5 5.4s.3 4.5 1.7 6.2l64 80c2.8 3.4 7.8 4 11.2 1.2s4-7.8 1.2-11.2l-58.5-73.2 88.7-59.2c2-1.3 3.3-3.5 3.5-5.9s-.6-4.8-2.3-6.4L264 140.7V130.6l18.4-25.4zM395.7 41.8c-48.6-6.3-97.3 14.3-126.2 54L256 114.4 242.5 95.8c-28.9-39.7-77.6-60.4-126.2-54C50.2 50.4 0 106.8 0 173.5c0 34.5 13.4 67.6 37.4 92.3L236.5 471.6c5.2 5.4 12.4 8.4 19.9 8.4c7.5 0 14.7-3.1 19.9-8.5L474.8 265.8C498.6 241.1 512 208 512 173.6c0-66.8-50.2-123.2-116.3-131.8z"],
    "face-beam-hand-over-mouth": [512, 512, [129325], "e47c", "M16 256C16 123.5 123.5 16 256 16s240 107.5 240 240c0 99.6-60.7 185-147.1 221.4c-4.1 1.7-6 6.4-4.3 10.5s6.4 6 10.5 4.3C447.3 453.4 512 362.3 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256c0 86 42.4 162 107.3 208.4c3.6 2.6 8.6 1.7 11.2-1.9s1.7-8.6-1.9-11.2C55.7 407.9 16 336.6 16 256zm119.7-46.5c2.5-13.5 7.8-28.4 15.2-39.8c7.6-11.6 16.1-17.7 24.9-17.7s17.3 6.1 24.9 17.7c7.4 11.4 12.7 26.3 15.2 39.8c.8 4.3 5 7.2 9.3 6.4s7.2-5 6.4-9.3c-2.8-15-8.7-32-17.6-45.6c-8.7-13.3-21.5-25-38.3-25s-29.6 11.7-38.3 25c-8.8 13.5-14.8 30.6-17.6 45.6c-.8 4.3 2 8.5 6.4 9.3s8.5-2 9.3-6.4zm175.2-39.8c7.6-11.6 16.1-17.7 24.9-17.7s17.3 6.1 24.9 17.7c7.4 11.4 12.7 26.3 15.2 39.8c.8 4.3 5 7.2 9.3 6.4s7.2-5 6.4-9.3c-2.8-15-8.7-32-17.6-45.6c-8.7-13.3-21.5-25-38.3-25s-29.6 11.7-38.3 25c-8.8 13.5-14.8 30.6-17.6 45.6c-.8 4.3 2 8.5 6.4 9.3s8.5-2 9.3-6.4c2.5-13.5 7.8-28.4 15.2-39.8zm-2.2 123l9.2-9.2 6.8-6.8c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-6.8 6.8-9.2 9.2-46.6 46.6-4.7 4.7c-2.6 2.6-2.6 6.8 0 9.4s6.8 2.6 9.4 0l4.7-4.7 46.6-46.6c2.3-2.3 5.2-3.8 8.3-4.4c5-1 10.4 .5 14.3 4.4c6.2 6.2 6.2 16.4 0 22.6l-22.8 22.8-9.2 9.2-14.6 14.6-4.7 4.7c-2.6 2.6-2.6 6.8 0 9.4s6.8 2.6 9.4 0l4.7-4.7 14.6-14.6c2.3-2.3 5.2-3.8 8.3-4.4c5-1 10.4 .5 14.3 4.4c6.2 6.2 6.2 16.4 0 22.6l-56.8 56.8C288.7 486 264.4 496 239.2 496c-52.6 0-95.2-42.6-95.2-95.2V368 314.4c0-11 9-20 20-20s20 9 20 20v19.7c0 7.1 8.6 10.7 13.7 5.7l79-79c6.2-6.2 16.4-6.2 22.6 0c3.9 3.9 5.4 9.3 4.4 14.3c-.6 3-2 5.9-4.4 8.3l-46.6 46.6-4.7 4.7c-2.6 2.6-2.6 6.8 0 9.4s6.8 2.6 9.4 0l4.7-4.7 46.6-46.6zm1.9-43.3c-12.5-12.5-32.8-12.5-45.3 0L200 314.7v-.3c0-19.9-16.1-36-36-36s-36 16.1-36 36V368v32.8C128 462.2 177.8 512 239.2 512c29.5 0 57.8-11.7 78.6-32.6l56.8-56.8c12.5-12.5 12.5-32.8 0-45.3c-3.3-3.3-7.2-5.8-11.4-7.3l11.4-11.4c12.5-12.5 12.5-32.8 0-45.3c-3.5-3.5-7.6-6-12-7.6c8.3-12.4 7-29.4-4-40.4s-28-12.3-40.4-4c-1.5-4.4-4.1-8.5-7.6-12z"],
    "droplet-percent": [384, 512, ["humidity"], "f750", "M192 496C94.8 496 16 417.2 16 320c0-19.5 7.1-44.9 19.6-73.8c12.4-28.6 29.3-59.2 47.7-88.8c36.6-59.2 77.9-112.9 95.9-135.7c2.8-3.5 7-5.6 11.9-5.6h1.8c4.9 0 9.1 2.1 11.9 5.6c18.1 22.8 59.3 76.6 95.9 135.7c18.3 29.6 35.3 60.2 47.7 88.8C360.9 275.1 368 300.5 368 320c0 97.2-78.8 176-176 176zM0 320C0 426 86 512 192 512s192-86 192-192c0-91.2-130.2-262.3-166.6-308.3C211.4 4.2 202.5 0 192.9 0h-1.8c-9.6 0-18.5 4.2-24.5 11.7C130.2 57.7 0 228.8 0 320zm269.7-66.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-144 144c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l144-144zM176 272a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-32-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm96 144a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "square-up-right": [448, 512, [8599, "external-link-square-alt"], "f360", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zm64 48c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96zM320 168V295c0 5-4 9-9 9c-2.4 0-4.7-.9-6.3-2.6l-35-35c-3.1-3.1-8.2-3.1-11.3 0L176 348.7c-2.1 2.1-5 3.3-8 3.3s-5.9-1.2-8-3.3L131.3 320c-2.1-2.1-3.3-5-3.3-8s1.2-5.9 3.3-8l82.3-82.3c3.1-3.1 3.1-8.2 0-11.3l-35-35c-1.7-1.7-2.6-4-2.6-6.3c0-5 4-9 9-9H312c4.4 0 8 3.6 8 8zm-8-24H185c-13.8 0-25 11.2-25 25c0 6.6 2.6 13 7.3 17.7L196.7 216 120 292.7c-5.1 5.1-8 12.1-8 19.3s2.9 14.2 8 19.3L148.7 360c5.1 5.1 12.1 8 19.3 8s14.2-2.9 19.3-8L264 283.3l29.4 29.4c4.7 4.7 11 7.3 17.7 7.3c13.8 0 25-11.2 25-25V168c0-13.3-10.7-24-24-24z"],
    "face-kiss-beam": [512, 512, [128537, "kiss-beam"], "f597", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm241.4 16.1c11.4 2.1 22.8 5.4 33.6 9.8c8.4 3.4 17.2 7.9 24.2 13.7c6.9 5.9 12.8 14 12.8 24.4c0 10.2-6.4 17.5-13.4 22.4c-5.9 4.1-13.2 7.3-20.3 9.6c7.1 2.4 14.4 5.5 20.3 9.6c7 4.9 13.4 12.2 13.4 22.4c0 11-5.6 19.5-12.7 25.8c-7 6.2-16 10.6-24.5 13.7c-10.8 4.1-22.3 6.9-33.7 8.4l-.1 0c-4.4 .5-8.4-2.6-9-6.9s2.6-8.4 6.9-8.9c10.3-1.4 20.5-3.9 30.2-7.6c7.6-2.8 14.6-6.4 19.5-10.8c4.9-4.3 7.3-8.7 7.3-13.7c0-2.6-1.6-5.7-6.6-9.2c-5-3.5-12-6.4-19.7-8.7c-7.6-2.3-15.2-3.8-21-4.8c-2.2-.4-4-.5-5.5-.7c-2.3-.2-4.1-.4-5.9-1.1c-3.1-1.1-5.3-4.2-5.3-7.5s2.2-6.4 5.3-7.5c1.8-.6 3.6-.8 5.9-1.1l0 0 0 0c1.6-.2 3.3-.3 5.5-.7c5.8-1 13.4-2.5 21-4.8c7.7-2.3 14.7-5.2 19.7-8.7c5-3.5 6.6-6.6 6.6-9.2c0-3.8-2.1-7.9-7.2-12.2c-5.1-4.3-12.2-8-19.8-11.1c-7.6-3-15.2-5.3-21-6.7c-4.3-1.1-6.9-1.7-9.4-2.1c-4.3-.8-7.3-4.9-6.5-9.3s4.9-7.2 9.3-6.5zm-90.5-86.4c-7.4 11.4-12.7 26.3-15.2 39.8c-.8 4.3-5 7.2-9.3 6.4s-7.2-5-6.4-9.3c2.8-15 8.7-32 17.6-45.6c8.7-13.3 21.5-25 38.3-25s29.6 11.7 38.3 25c8.8 13.5 14.8 30.6 17.6 45.6c.8 4.3-2 8.5-6.4 9.3s-8.5-2-9.3-6.4c-2.5-13.5-7.8-28.4-15.2-39.8c-7.6-11.6-16.1-17.7-24.9-17.7s-17.3 6.1-24.9 17.7zm144.8 39.8c-.8 4.3-5 7.2-9.3 6.4s-7.2-5-6.4-9.3c2.8-15 8.7-32 17.6-45.6c8.7-13.3 21.5-25 38.3-25s29.6 11.7 38.3 25c8.8 13.5 14.8 30.6 17.6 45.6c.8 4.3-2 8.5-6.4 9.3s-8.5-2-9.3-6.4c-2.5-13.5-7.8-28.4-15.2-39.8c-7.6-11.6-16.1-17.7-24.9-17.7s-17.3 6.1-24.9 17.7c-7.4 11.4-12.7 26.3-15.2 39.8z"],
    "corn": [512, 512, [127805], "f6c7", "M453.9 0c-15.1 0-29 5.8-39.3 15.3C406.4 10.9 397 8.4 387 8.4c-20.2 0-38 10.3-48.4 25.9c-3.3-.6-6.6-.9-10.1-.9c-20.2 0-38 10.3-48.4 25.9c-3.3-.6-6.6-.9-10.1-.9c-20.8 0-39 10.9-49.3 27.3c3.6 4.9 7 9.8 10.3 14.9c6.3-15.3 21.4-26.1 39-26.1c4.1 0 8 .6 11.8 1.7c3.7 1.1 7.6-.6 9.3-4c7-13.5 21.2-22.7 37.4-22.7c4.1 0 8 .6 11.8 1.7c3.7 1.1 7.6-.6 9.3-4c7-13.5 21.2-22.7 37.4-22.7c9 0 17.4 2.8 24.2 7.6c3.4 2.4 8 1.8 10.7-1.3c7.7-9 19.2-14.7 32-14.7C477.1 16 496 34.9 496 58.1c0 12.8-5.7 24.2-14.7 32c-3.1 2.7-3.7 7.3-1.3 10.7c4.8 6.8 7.6 15.2 7.6 24.2c0 16.3-9.2 30.4-22.7 37.4c-3.4 1.8-5.1 5.7-4 9.3c1.1 3.7 1.7 7.7 1.7 11.8c0 16.3-9.2 30.4-22.7 37.4c-3.4 1.8-5.1 5.7-4 9.3c1.1 3.7 1.7 7.7 1.7 11.8c0 13.4-6.2 25.3-16 33c4.1 3.4 8.2 7 12.1 10.8c12.2-10.7 19.9-26.3 19.9-43.8c0-3.4-.3-6.8-.9-10.1c15.6-10.4 25.9-28.2 25.9-48.4c0-3.4-.3-6.8-.9-10.1c15.6-10.4 25.9-28.2 25.9-48.4c0-10-2.5-19.3-6.9-27.6C506.2 87.1 512 73.3 512 58.1C512 26 486 0 453.9 0zm-299 66.3c-2-2-4.8-2.8-7.5-2.1s-4.9 2.6-5.8 5.3l-22.9 68.7c-1 3-2.6 5.8-4.7 8.2L33.6 238.2C12 263 0 294.8 0 327.8V346c0 34.2 12.9 67.1 36.1 92.2l27.7 30c25.7 27.9 62 43.8 99.9 43.8h15.6c36.1 0 70.7-14.3 96.2-39.8l73.8-73.8c2.5-2.5 5.5-4.4 8.8-5.6L442.7 362c2.6-.9 4.5-3.1 5.1-5.8s-.2-5.5-2.2-7.4l-30.2-30.2c-35.4-35.4-83.3-55.2-133.3-55.2c-14.2 0-28.2 1.6-41.8 4.7v-7c0-70-27.8-137.2-77.3-186.7l-8.1-8.1zm69.4 205h3.5c-29.6 8.9-56.7 25-79 47.2L44.2 423.2C26 401.7 16 374.3 16 346V327.8c0-29.1 10.6-57.1 29.7-79l80.4-91.9c3.5-4 6.2-8.7 7.8-13.7l18.8-56.4c45.8 46.4 71.6 109 71.6 174.3v10.3zM75.6 457.4L49.8 429.5l5.4 5.4 105-105c32.4-32.4 76.2-50.5 122-50.5s89.6 18.2 122 50.5l21.3 21.3-72.9 26.5c-5.5 2-10.5 5.2-14.6 9.3l-73.8 73.8c-22.5 22.5-53 35.1-84.9 35.1H163.7c-33.5 0-65.5-14-88.2-38.6z"],
    "roller-coaster": [640, 512, [], "e324", "M136 48c-8.2 0-16.2 .8-24 2.4V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V54.8C49.4 71.3 16 115.8 16 168V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V168C0 92.9 60.9 32 136 32h6.5c43.1 0 83.7 20.4 109.3 55.1l140.6 190c27.4 37 70.8 58.9 116.9 58.9H512c61.9 0 112-50.1 112-112c0-50.7-33.7-93.6-80-107.4V280c0 4.4-3.6 8-8 8s-8-3.6-8-8V113.1c-5.2-.7-10.6-1.1-16-1.1H494.2c-15.8 0-31.5 2.9-46.2 8.5V248c0 4.4-3.6 8-8 8s-8-3.6-8-8V127.9c-1.6 .8-3.1 1.7-4.6 2.6l-47.3 28.4c-3.8 2.3-8.7 1-11-2.7s-1-8.7 2.7-11l47.3-28.4c22.7-13.6 48.6-20.8 75-20.8H512c70.7 0 128 57.3 128 128V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V286c-19.4 34.9-54.6 59.8-96 65V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V352h-2.7c-33.8 0-66.4-10.6-93.3-29.7V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V309.4c-7.4-6.9-14.3-14.4-20.4-22.7L304 184.5V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V162.9L238.9 96.6C230.3 85 219.8 75.2 208 67.5V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V58.7c-15.4-7-32.2-10.7-49.5-10.7H136z"],
    "photo-film-music": [640, 512, [], "e228", "M544 16H224c-26.5 0-48 21.5-48 48V288c0 18.6 10.6 34.7 26 42.7l.1-.2 .2-.2L431 101.7c9.4-9.4 24.6-9.4 33.9 0l59.8 59.8-17 5.7L453.7 113c-3.1-3.1-8.2-3.1-11.3 0L219.5 335.8c1.5 .1 3 .2 4.5 .2H400v16H224c-35.3 0-64-28.7-64-64V64c0-35.3 28.7-64 64-64H544c35.3 0 64 28.7 64 64v70.7c-3.2 .5-6.5 1.2-9.7 2.3l-6.3 2.1V64c0-26.5-21.5-48-48-48zM264 96a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 40a40 40 0 1 1 0-80 40 40 0 1 1 0 80zM128 96v16 80 80 72 40 48H295.8c-2.6 5-4.6 10.3-6 16H128h-8-8H64c-35.3 0-64-28.7-64-64V352v-8-8V280v-8-8V200v-8-8V160c0-35.3 28.7-64 64-64h48 8 8zM112 280H16v56h96V280zm0 152V352H16v32c0 26.5 21.5 48 48 48h48zM64 112c-26.5 0-48 21.5-48 48v24h96V112H64zM16 264h96V200H16v64zm608-73.8c0-5.5-5.4-9.3-10.5-7.6l-160 53.3c-3.3 1.1-5.5 4.1-5.5 7.6v49.4l176-58.7v-44zm0 60.9L448 309.8V464c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48c19.1 0 36.3 6.3 48 16.2V304 243.5c0-10.3 6.6-19.5 16.4-22.8l160-53.3c15.5-5.2 31.6 6.4 31.6 22.8V240 392c0 .9-.1 1.7-.4 2.5c.3 1.8 .4 3.6 .4 5.5c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48c19.1 0 36.3 6.3 48 16.2V251.1zM624 400c0-7.1-3.8-14.7-12.3-21.1s-21.1-10.9-35.7-10.9s-27.1 4.4-35.7 10.9s-12.3 14.1-12.3 21.1s3.8 14.7 12.3 21.1s21.1 10.9 35.7 10.9s27.1-4.4 35.7-10.9s12.3-14.1 12.3-21.1zM432 464c0-7.1-3.8-14.7-12.3-21.1s-21.1-10.9-35.7-10.9s-27.1 4.4-35.7 10.9s-12.3 14.1-12.3 21.1s3.8 14.7 12.3 21.1s21.1 10.9 35.7 10.9s27.1-4.4 35.7-10.9s12.3-14.1 12.3-21.1z"],
    "radar": [512, 512, [], "e024", "M256 16C123.5 16 16 123.5 16 256s107.5 240 240 240s240-107.5 240-240c0-4.4 3.6-8 8-8s8 3.6 8 8c0 141.4-114.6 256-256 256S0 397.4 0 256S114.6 0 256 0c67.8 0 129.5 26.4 175.3 69.4l43.1-43.1c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-224 224c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l33.5-33.5c-7.8-5.6-17.4-8.9-27.8-8.9c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48c0-4.4 3.6-8 8-8s8 3.6 8 8c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c14.8 0 28.4 5 39.2 13.4L352 148.7c-25.5-22.8-59.1-36.7-96-36.7c-57.9 0-107.8 34.1-130.7 83.4c-1.9 4-6.6 5.7-10.6 3.9s-5.7-6.6-3.9-10.6C136.3 133.9 191.7 96 256 96c41.3 0 79 15.7 107.3 41.3L420 80.7C377 40.6 319.4 16 256 16zM96 216a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm96 160a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm40 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM416 256c0 64.3-37.9 119.7-92.6 145.2c-4 1.9-8.8 .1-10.6-3.9s-.1-8.8 3.9-10.6C365.9 363.8 400 313.9 400 256c0-4.4 3.6-8 8-8s8 3.6 8 8zM125.3 316.6c14.3 30.8 39.2 55.7 70 70c4 1.9 5.7 6.6 3.9 10.6s-6.6 5.7-10.6 3.9c-34.2-15.9-61.9-43.6-77.8-77.8c-1.9-4-.1-8.8 3.9-10.6s8.8-.1 10.6 3.9z"],
    "sickle": [512, 512, [], "f822", "M320 0C214 0 128 86 128 192c0 68 35.3 127.7 88.6 161.8c3.2 2 7.3 1.6 10-1.1l37.9-37.9c2.6-2.6 3.1-6.6 1.2-9.7C254.5 286 248 263.8 248 240c0-70.7 57.3-128 128-128c55.5 0 102.7 35.3 120.5 84.6c1.3 3.6 5 5.8 8.9 5.2s6.6-3.9 6.7-7.8c0-.7 0-1.3 0-2C512 86 426 0 320 0zM144 192c0-97.2 78.8-176 176-176c84.4 0 154.9 59.4 172 138.7C465.8 119.1 423.6 96 376 96c-79.5 0-144 64.5-144 144c0 24.5 6.1 47.6 16.9 67.8l-29 29C174 305 144 252 144 192zM117.7 298.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L116.7 320 10.8 425.9C3.9 432.8 0 442.2 0 452s3.9 19.2 10.8 26.1l23 23C40.8 508.1 50.2 512 60 512s19.2-3.9 26.1-10.8L192 395.3l10.3 10.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-16-16-64-64-16-16zM22.1 437.2L128 331.3 180.7 384 74.8 489.9c-3.9 3.9-9.3 6.1-14.8 6.1s-10.9-2.2-14.8-6.1l-23-23c-3.9-3.9-6.1-9.3-6.1-14.8s2.2-10.9 6.1-14.8z"],
    "film": [512, 512, [127902], "f008", "M112 48v56H16V96c0-26.5 21.5-48 48-48h48zm0 152H16V120h96v80zM0 208v8 80 8 8 80 8 8 8c0 35.3 28.7 64 64 64h48 8 8H384h8 8 48c35.3 0 64-28.7 64-64v-8-8-8V312v-8-8V216v-8-8V120v-8-8V96c0-35.3-28.7-64-64-64H400h-8-8H128h-8-8H64C28.7 32 0 60.7 0 96v8 8 8 80 8zm16 8h96v40 40H16V216zm112 48H384v40 96 64H128V400 304 264zm256-16H128V208 112 48H384v64 96 40zm16 8V216h96v80H400V256zM16 392V312h96v80H16zm0 24v-8h96v56H64c-26.5 0-48-21.5-48-48zM400 104V48h48c26.5 0 48 21.5 48 48v8H400zm0 96V120h96v80H400zm0 192V312h96v80H400zm0 72V408h96v8c0 26.5-21.5 48-48 48H400z"],
    "coconut": [512, 512, [], "e2f6", "M270.6 24.6C318.6 9.8 358.2 14.2 381 37s27.2 62.3 12.4 110.4c-14.7 47.7-47.8 101.5-96.1 149.8s-102.2 81.4-149.8 96.1C99.3 408.2 59.8 403.8 37 381S9.8 318.6 24.6 270.6c14.7-47.7 47.8-101.5 96.1-149.8s102.2-81.4 149.8-96.1zm121.7 1C363.2-3.4 316.1-6.2 265.9 9.3C215.2 24.9 159.2 59.7 109.4 109.4S24.9 215.2 9.3 265.9C-6.2 316.1-3.4 363.2 25.7 392.3l43.8 43.8C118.1 484.7 184 512 252.8 512C395.9 512 512 395.9 512 252.8c0-68.8-27.3-134.7-75.9-183.3L392.3 25.7zm23.5 46.1l9 9c45.6 45.6 71.2 107.5 71.2 172c0 12.6-1 25-2.8 37.1l-47.5-47.5c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l55.2 55.2c-9.9 42-30.7 79.8-59.2 110.2c-.2-.2-.4-.5-.6-.7l-64-64c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l64 64c.2 .2 .5 .4 .7 .6c-30.4 28.5-68.2 49.3-110.2 59.2l-55.2-55.2c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l47.5 47.5c-12.1 1.9-24.5 2.8-37.1 2.8c-64.5 0-126.4-25.6-172-71.2l-9-9c23.9 4.6 51.6 1.7 80.3-7.2c50.6-15.6 106.6-50.3 156.4-100.1s84.5-105.8 100.1-156.4c8.9-28.7 11.7-56.4 7.2-80.3zm-86.3 8.8c3.9 3.9 6.7 10.4 6.7 21.3c-.1 10.9-3.2 24.9-9.9 41.1c-13.3 32.4-39.6 71-75.9 107.3s-74.9 62.6-107.3 76c-16.2 6.7-30.2 9.8-41.1 9.9c-10.8 .1-17.4-2.8-21.3-6.7s-6.7-10.4-6.7-21.3c.1-10.9 3.2-24.9 9.9-41.1c13.3-32.4 39.6-71 76-107.3s74.9-62.6 107.3-76c16.2-6.7 30.2-9.8 41.1-9.9c10.8-.1 17.4 2.8 21.3 6.7zm11.3-11.3c-31.2-31.2-117.4 4.2-192.3 79.2s-110.4 161.1-79.2 192.3s117.4-4.2 192.3-79.2s110.4-161.1 79.2-192.3z"],
    "ruler-horizontal": [640, 512, [], "f547", "M16 320c0 26.5 21.5 48 48 48l512 0c26.5 0 48-21.5 48-48V192c0-26.5-21.5-48-48-48H520v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V144l-80 0v48 32c0 4.4-3.6 8-8 8s-8-3.6-8-8V192 144H328v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V144H232v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V144l-80 0v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V144l-56 0c-26.5 0-48 21.5-48 48l0 128zM512 128h64c35.3 0 64 28.7 64 64V320c0 35.3-28.7 64-64 64L64 384c-35.3 0-64-28.7-64-64V192c0-35.3 28.7-64 64-64H224h96 96 96z"],
    "shield-cross": [512, 512, [9960], "f712", "M237.3 22.6c12-5.1 25.5-5.1 37.5 0l176.7 75c16.6 7.1 28.6 23.2 28.5 42.4c-.5 96.6-40.3 270.2-204.5 348.8c-12.3 5.9-26.7 5.9-39 0C72.3 410.1 32.5 236.5 32 139.9c-.1-19.1 11.9-35.3 28.5-42.4l176.7-75zM281 7.8c-16-6.8-34-6.8-50 0L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c16.7 8 36.1 8 52.8 0C454.8 420.7 495.5 239.2 496 140c.1-26.2-16.3-47.9-38.3-57.2L281 7.8zM264 104c0-4.4-3.6-8-8-8s-8 3.6-8 8v80H104c-4.4 0-8 3.6-8 8s3.6 8 8 8H248V408c0 4.4 3.6 8 8 8s8-3.6 8-8V200H408c4.4 0 8-3.6 8-8s-3.6-8-8-8H264V104z"],
    "cassette-tape": [576, 512, [128429], "f8ab", "M512 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H470l-23.7-83c-4.9-17.2-20.6-29-38.5-29H168.1c-17.9 0-33.6 11.8-38.5 29L106 464H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H512zM453.4 464H122.6l22.5-78.6c2.9-10.3 12.4-17.4 23.1-17.4H407.9c10.7 0 20.1 7.1 23.1 17.4L453.4 464zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm96 144a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm42.3 96c13.3-11.7 21.7-28.9 21.7-48s-8.4-36.3-21.7-48H373.7c-13.3 11.7-21.7 28.9-21.7 48s8.4 36.3 21.7 48H202.3zM160 288H416c35.3 0 64-28.7 64-64s-28.7-64-64-64H160c-35.3 0-64 28.7-64 64s28.7 64 64 64zM416 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "square-terminal": [448, 512, [], "e32a", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM97.9 154.8c-2.9 3.4-2.5 8.4 .9 11.3L203.7 256 98.8 345.9c-3.4 2.9-3.7 7.9-.9 11.3s7.9 3.7 11.3 .9l112-96c1.8-1.5 2.8-3.7 2.8-6.1s-1-4.6-2.8-6.1l-112-96c-3.4-2.9-8.4-2.5-11.3 .9zM200 368c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H200z"],
    "people-robbery": [576, 512, [], "e536", "M464.6 160.1c34.2-18 60.4-49.9 70.2-89.3l8.7-34.9c2.1-8.6-3.1-17.3-11.6-19.4s-17.3 3.1-19.4 11.6L503.8 63c-11.9 47.6-54.7 81-103.8 81s-91.9-33.4-103.8-81l-8.7-34.9c-2.1-8.6-10.8-13.8-19.4-11.6s-13.8 10.8-11.6 19.4l8.7 34.9c9.9 39.4 36 71.4 70.2 89.4c5.3 2.8 8.6 8.2 8.6 14.2V480c0 8.8 7.2 16 16 16s16-7.2 16-16V352c0-8.8 7.2-16 16-16h16c8.8 0 16 7.2 16 16V480c0 8.8 7.2 16 16 16s16-7.2 16-16V174.3c0-5.9 3.3-11.4 8.6-14.2zm85.8-85.5c-11 44-40.2 79.6-78.3 99.6V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V368 352H392v16V480v0c0 17.7-14.3 32-32 32s-32-14.3-32-32V174.3c-38.1-20-67.3-55.7-78.3-99.6L241 39.8C236.7 22.6 247.1 5.2 264.2 1s34.5 6.1 38.8 23.3l8.7 34.9C321.9 99.6 358.3 128 400 128h0l.4 0c41.6-.2 77.8-28.5 87.9-68.9L497 24.2C501.2 7.1 518.6-3.3 535.8 1s27.6 21.7 23.3 38.8l-8.7 34.9zM344 56c0-30.9 25.1-56 56-56s56 25.1 56 56c0 30.8-24.9 55.8-55.7 56l-.3 0 0 0-.3 0c-30.8-.2-55.7-25.2-55.7-56zm96 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM196.1 232.6l-37.4-58.9c-11.7-18.5-32.1-29.7-54-29.7H72c-26.5 0-48 21.5-48 48v95.9l0 .5 0 .1h0V480c0 8.8 7.2 16 16 16s16-7.2 16-16V352c0-8.8 7.2-16 16-16H88c8.8 0 16 7.2 16 16V480c0 8.8 7.2 16 16 16s16-7.2 16-16V252.7c0-7.1 4.7-13.4 11.5-15.4s14.2 .8 18 6.8l13 20.5c2.9 4.6 8 7.4 13.5 7.4h48c8.8 0 16-7.2 16-16s-7.2-16-16-16H209.6c-5.5 0-10.6-2.8-13.5-7.4zM8 192c0-35.3 28.7-64 64-64h8 24.7c27.4 0 52.9 14 67.5 37.1L209.6 224H240c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-9.3 0-18-4-24-10.8c-1.1-1.2-2.1-2.6-3-4l-13-20.5v28.7 1.1V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V368 352H72v16l0 112c0 17.7-14.3 32-32 32s-32-14.3-32-32V288.6l0-.6V192zM120 56A40 40 0 1 0 40 56a40 40 0 1 0 80 0zM24 56a56 56 0 1 1 112 0A56 56 0 1 1 24 56z"],
    "lightbulb": [384, 512, [128161], "f0eb", "M323.5 267.2c18-25.9 28.5-57.3 28.5-91.2c0-88.4-71.6-160-160-160S32 87.6 32 176c0 33.9 10.5 65.3 28.5 91.2c4.5 6.5 9.5 13.3 14.5 20.2l0 0 0 0c12.5 17.2 25.9 35.5 36.3 54.4c7.4 13.5 11.6 27.8 14 42.2H109c-2.2-12-5.9-23.7-11.8-34.5c-9.9-18-22.2-34.9-34.5-51.8l0 0 0 0 0 0c-5.2-7.1-10.4-14.2-15.4-21.4C27.6 247.9 16 213.3 16 176C16 78.8 94.8 0 192 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4l0 0 0 0c-12.3 16.8-24.6 33.7-34.5 51.8c-5.9 10.8-9.6 22.5-11.8 34.5H258.7c2.4-14.4 6.6-28.7 14-42.2c10.4-19 23.7-37.3 36.3-54.4c5-6.9 10-13.7 14.5-20.2zM184 80c-48.6 0-88 39.4-88 88c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-57.4 46.6-104 104-104c4.4 0 8 3.6 8 8s-3.6 8-8 8zM128 432c0 35.3 28.7 64 64 64s64-28.7 64-64H128zm-16 0v-5.3c0-5.9 4.8-10.7 10.7-10.7H261.3c5.9 0 10.7 4.8 10.7 10.7V432c0 44.2-35.8 80-80 80s-80-35.8-80-80z"],
    "caret-left": [256, 512, [], "f0d9", "M22.6 271.4c-4.2-4-6.6-9.6-6.6-15.4s2.4-11.4 6.6-15.4L154.7 115.5c2.3-2.2 5.4-3.5 8.7-3.5c7 0 12.6 5.6 12.6 12.6l0 262.8c0 7-5.6 12.6-12.6 12.6c-3.2 0-6.3-1.2-8.7-3.5L22.6 271.4zM11.6 283L143.7 408.2c5.3 5 12.4 7.8 19.7 7.8c15.8 0 28.6-12.8 28.6-28.6l0-262.8c0-15.8-12.8-28.6-28.6-28.6c-7.3 0-14.4 2.8-19.7 7.8L11.6 229C4.2 236 0 245.8 0 256s4.2 20 11.6 27z"],
    "comment-middle": [512, 512, [], "e149", "M202.6 401.5l44.5 89c1.7 3.4 5.1 5.5 8.8 5.5s7.2-2.1 8.8-5.5l44.5-89c2.2-4.3 6.1-7.4 10.8-8.5C423.8 370 496 294.1 496 208C496 104.9 391.8 16 256 16S16 104.9 16 208c0 86.1 72.2 162 175.8 185c4.7 1 8.7 4.2 10.8 8.5zm121 7.2l-44.5 89c-4.4 8.8-13.3 14.3-23.2 14.3s-18.8-5.5-23.2-14.3l-44.5-89C79.8 384.5 0 303.8 0 208C0 93.1 114.6 0 256 0S512 93.1 512 208c0 95.8-79.8 176.5-188.3 200.7z"],
    "trash-can-list": [640, 512, [], "e2ab", "M169.7 16h76.5c8.3 0 16 4.3 20.4 11.3l23 36.7H126.4l23-36.7c4.4-7 12.1-11.3 20.4-11.3zm-33.9 2.8L107.6 64H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H408c4.4 0 8-3.6 8-8s-3.6-8-8-8H308.4L280.2 18.8C272.9 7.1 260.1 0 246.3 0H169.7c-13.8 0-26.6 7.1-33.9 18.8zM48 120c0-4.4-3.6-8-8-8s-8 3.6-8 8V440c0 39.8 32.2 72 72 72H312c39.8 0 72-32.2 72-72V120c0-4.4-3.6-8-8-8s-8 3.6-8 8V440c0 30.9-25.1 56-56 56H104c-30.9 0-56-25.1-56-56V120zm112 32c-4.4 0-8 3.6-8 8V416c0 4.4 3.6 8 8 8s8-3.6 8-8V160c0-4.4-3.6-8-8-8zm96 0c-4.4 0-8 3.6-8 8V416c0 4.4 3.6 8 8 8s8-3.6 8-8V160c0-4.4-3.6-8-8-8zm200-24c-4.4 0-8 3.6-8 8s3.6 8 8 8H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H456zm0 128c-4.4 0-8 3.6-8 8s3.6 8 8 8H600c4.4 0 8-3.6 8-8s-3.6-8-8-8H456zm-8 136c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H456c-4.4 0-8 3.6-8 8z"],
    "block": [448, 512, [], "e46a", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm32 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm272 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 400a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm272 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-384c-4.4 0-8 3.6-8 8V296c0 4.4 3.6 8 8 8s8-3.6 8-8V136c0-4.4-3.6-8-8-8zm16 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "school-circle-xmark": [640, 512, [], "e56d", "M315.4 1.4c2.8-1.9 6.4-1.9 9.2 0L482.5 112H584c30.9 0 56 25.1 56 56v98.8c-4.9-6.9-10.2-13.5-16-19.6V168c0-22.1-17.9-40-40-40H480c-1.6 0-3.2-.5-4.6-1.4L320 17.8 164.6 126.6c-1.3 .9-2.9 1.4-4.6 1.4H56c-22.1 0-40 17.9-40 40V456c0 22.1 17.9 40 40 40H256V384c0-35.3 28.7-64 64-64c2.2 0 4.4 .1 6.5 .3c-1.4 5.2-2.7 10.4-3.6 15.8c-1-.1-1.9-.1-2.9-.1c-26.5 0-48 21.5-48 48V496h32 64 7.2c6.1 5.8 12.7 11.1 19.6 16H384 368 272 256 56c-30.9 0-56-25.1-56-56V168c0-30.9 25.1-56 56-56H157.5L315.4 1.4zM88 192h32c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H88c-13.3 0-24-10.7-24-24V216c0-13.3 10.7-24 24-24zm-8 24v48c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V216c0-4.4-3.6-8-8-8H88c-4.4 0-8 3.6-8 8zm240 24a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-144a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm8 48v24h16c4.4 0 8 3.6 8 8s-3.6 8-8 8H320c-4.4 0-8-3.6-8-8V144c0-4.4 3.6-8 8-8s8 3.6 8 8zM64 344c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H88c-13.3 0-24-10.7-24-24V344zm24-8c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V344c0-4.4-3.6-8-8-8H88zm536 32a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm205.7-50.3L507.3 368l50.3 50.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L496 379.3l-50.3 50.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L484.7 368l-50.3-50.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L496 356.7l50.3-50.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "arrow-right-from-bracket": [512, 512, ["sign-out"], "f08b", "M509.7 261.7c3.1-3.1 3.1-8.2 0-11.3l-136-136c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L484.7 248 168 248c-4.4 0-8 3.6-8 8s3.6 8 8 8l316.7 0L362.3 386.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l136-136zM184 48c4.4 0 8-3.6 8-8s-3.6-8-8-8L88 32C39.4 32 0 71.4 0 120L0 392c0 48.6 39.4 88 88 88l96 0c4.4 0 8-3.6 8-8s-3.6-8-8-8l-96 0c-39.8 0-72-32.2-72-72l0-272c0-39.8 32.2-72 72-72l96 0z"],
    "face-frown-slight": [512, 512, [], "e376", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM361.4 396.6C340.6 366.8 305.4 336 256 336s-84.6 30.8-105.4 60.6c-2.5 3.6-7.5 4.5-11.1 2s-4.5-7.5-2-11.1c22.4-32 61.9-67.4 118.6-67.4s96.1 35.4 118.6 67.4c2.5 3.6 1.7 8.6-2 11.1s-8.6 1.7-11.1-2zM160.4 208a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "circle-chevron-down": [512, 512, ["chevron-circle-down"], "f13a", "M256 16a240 240 0 1 0 0 480 240 240 0 1 0 0-480zm0 496A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM381.7 221.7l-120 120c-3.1 3.1-8.2 3.1-11.3 0l-120-120c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L256 324.7 370.3 210.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "sidebar-flip": [512, 512, [], "e24f", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H288V48H64zm384 0H304V464H448c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48zm0-16c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H448zm-8 64c4.4 0 8 3.6 8 8s-3.6 8-8 8H360c-4.4 0-8-3.6-8-8s3.6-8 8-8h80zm8 72c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8s3.6-8 8-8h80c4.4 0 8 3.6 8 8zm-8 56c4.4 0 8 3.6 8 8s-3.6 8-8 8H360c-4.4 0-8-3.6-8-8s3.6-8 8-8h80z"],
    "unlock-keyhole": [448, 512, ["unlock-alt"], "f13e", "M224 16c-61.9 0-112 50.1-112 112v64H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256c0-35.3 28.7-64 64-64H96V128C96 57.3 153.3 0 224 0c58.9 0 108.5 39.8 123.4 93.9c1.2 4.3-1.3 8.7-5.6 9.8s-8.7-1.3-9.8-5.6C318.9 50.8 275.5 16 224 16zM64 208c-26.5 0-48 21.5-48 48V448c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V256c0-26.5-21.5-48-48-48H112 96 64zM272 352c0-8.8-7.2-16-16-16H192c-8.8 0-16 7.2-16 16s7.2 16 16 16h64c8.8 0 16-7.2 16-16zm-16-32c17.7 0 32 14.3 32 32s-14.3 32-32 32H192c-17.7 0-32-14.3-32-32s14.3-32 32-32h64z"],
    "temperature-list": [512, 512, [], "e299", "M160 16c-35.3 0-64 28.7-64 64V243.8c0 8.4-4.4 15.7-10.7 20.3C53 287.3 32 325.2 32 368c0 70.7 57.3 128 128 128s128-57.3 128-128c0-42.8-21-80.7-53.3-104c-6.3-4.6-10.7-11.9-10.7-20.3V80c0-35.3-28.7-64-64-64zM80 80c0-44.2 35.8-80 80-80s80 35.8 80 80V243.8c0 2.7 1.4 5.4 4 7.3c36.3 26.1 60 68.8 60 117c0 79.5-64.5 144-144 144S16 447.5 16 368c0-48.2 23.7-90.8 60-117c2.6-1.9 4-4.6 4-7.3V80zm80 336a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM328 32H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H328c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 128H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H328c-4.4 0-8-3.6-8-8s3.6-8 8-8zm32 128H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H360c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "cloud-showers-heavy": [512, 512, [], "f740", "M398.7 124.8c.8-4.1 1.3-8.4 1.3-12.8c0-35.3-28.7-64-64-64c-19.5 0-36.9 8.7-48.6 22.4c-3.5 4-8.7 6.1-13.9 5.5s-9.9-3.8-12.4-8.5C245 36.8 212.9 16 176 16c-53 0-96 43-96 96c0 6.1 .6 12.1 1.7 17.9c1.5 7.9-3.1 15.6-10.7 18.1C39 158.5 16 188.6 16 224c0 44.2 35.8 80 80 80H416c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.4 0-.9 0-1.3 0c-4.8 .1-9.5-2-12.6-5.8s-4.3-8.7-3.4-13.4zM176 0c37.1 0 70 18.1 90.4 45.9c3.3 4.5 6.2 9.2 8.8 14.1c3.6-4.2 7.6-8 12-11.4C300.7 38.2 317.6 32 336 32c44.2 0 80 35.8 80 80c0 5.5-.6 10.8-1.6 16c.5 0 1.1 0 1.6 0c4.9 0 9.8 .4 14.5 1.1c46.2 7 81.5 46.8 81.5 94.9c0 53-43 96-96 96H96c-53 0-96-43-96-96c0-42.5 27.6-78.6 65.9-91.2C64.7 126.1 64 119.1 64 112C64 50.1 114.1 0 176 0zM87.2 363.6l-72 144c-2 4-6.8 5.6-10.7 3.6s-5.6-6.8-3.6-10.7l72-144c2-4 6.8-5.6 10.7-3.6s5.6 6.8 3.6 10.7zm120 0l-72 144c-2 4-6.8 5.6-10.7 3.6s-5.6-6.8-3.6-10.7l72-144c2-4 6.8-5.6 10.7-3.6s5.6 6.8 3.6 10.7zm112 0l-72 144c-2 4-6.8 5.6-10.7 3.6s-5.6-6.8-3.6-10.7l72-144c2-4 6.8-5.6 10.7-3.6s5.6 6.8 3.6 10.7zm120 0l-72 144c-2 4-6.8 5.6-10.7 3.6s-5.6-6.8-3.6-10.7l72-144c2-4 6.8-5.6 10.7-3.6s5.6 6.8 3.6 10.7z"],
    "headphones-simple": [512, 512, ["headphones-alt"], "f58f", "M16 288C16 155.5 123.5 48 256 48s240 107.5 240 240v88c0 4.4 3.6 8 8 8s8-3.6 8-8V288C512 146.6 397.4 32 256 32S0 146.6 0 288v88c0 4.4 3.6 8 8 8s8-3.6 8-8V288zm128-16c8.8 0 16 7.2 16 16V448c0 8.8-7.2 16-16 16H128c-35.3 0-64-28.7-64-64V336c0-35.3 28.7-64 64-64h16zm-16-16c-44.2 0-80 35.8-80 80v64c0 44.2 35.8 80 80 80h16c17.7 0 32-14.3 32-32V288c0-17.7-14.3-32-32-32H128zm240 16h16c35.3 0 64 28.7 64 64v64c0 35.3-28.7 64-64 64H368c-8.8 0-16-7.2-16-16V288c0-8.8 7.2-16 16-16zm16-16H368c-17.7 0-32 14.3-32 32V448c0 17.7 14.3 32 32 32h16c44.2 0 80-35.8 80-80V336c0-44.2-35.8-80-80-80z"],
    "sitemap": [576, 512, [], "f0e8", "M320 48c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H256c-17.7 0-32-14.3-32-32V80c0-17.7 14.3-32 32-32h64zM256 32c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h24v56H112c-22.1 0-40 17.9-40 40v32H48c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48V368c0-26.5-21.5-48-48-48H88V288c0-13.3 10.7-24 24-24H280v56H256c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48V368c0-26.5-21.5-48-48-48H296V264H464c13.3 0 24 10.7 24 24v32H464c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48V368c0-26.5-21.5-48-48-48H504V288c0-22.1-17.9-40-40-40H296V192h24c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H256zM48 336h64c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H48c-17.7 0-32-14.3-32-32V368c0-17.7 14.3-32 32-32zm208 0h64c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H256c-17.7 0-32-14.3-32-32V368c0-17.7 14.3-32 32-32zm208 0h64c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H464c-17.7 0-32-14.3-32-32V368c0-17.7 14.3-32 32-32z"],
    "pipe-section": [640, 512, [], "e438", "M48 384c0 8.8-7.2 16-16 16s-16-7.2-16-16V128c0-8.8 7.2-16 16-16s16 7.2 16 16V384zM32 96C14.3 96 0 110.3 0 128V384c0 17.7 14.3 32 32 32s32-14.3 32-32H576c0 17.7 14.3 32 32 32s32-14.3 32-32V128c0-17.7-14.3-32-32-32s-32 14.3-32 32L64 128c0-17.7-14.3-32-32-32zm544 48V368H64V144H576zm48-16V384c0 8.8-7.2 16-16 16s-16-7.2-16-16V128c0-8.8 7.2-16 16-16s16 7.2 16 16z"],
    "space-station-moon-construction": [512, 512, ["space-station-moon-alt"], "e034", "M256 16C123.5 16 16 123.5 16 256c0 12.4 .9 24.5 2.7 36.4C92.4 320.6 172.4 336 256 336s163.6-15.4 237.3-43.6c1.4-9.3 2.3-18.7 2.6-28.4H416c-4.4 0-8-3.6-8-8s3.6-8 8-8h88c4.4 0 8 3.6 8 8c0 14.8-1.3 29.2-3.7 43.3c-.4 2.5-2 4.7-4.3 5.8l-1.4 .7c-.2 .1-.5 .2-.7 .3C425.7 335.8 342.7 352 256 352c-82.1 0-160.8-14.6-233.7-41.2C47.1 416.9 142.3 496 256 496c82 0 154.5-41.2 197.8-104H400c-4.4 0-8-3.6-8-8s3.6-8 8-8h68.5c2.9 0 5.5 1.6 7 4.1s1.4 5.6-.1 8.1C430.5 462.3 349 512 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0c78.4 0 148.7 35.3 195.6 90.8c2 2.4 2.5 5.7 1.1 8.5s-4.1 4.6-7.3 4.6H360c-4.4 0-8-3.6-8-8s3.6-8 8-8h67.4C383.8 43.6 323.1 16 256 16zm88 136c0-4.4 3.6-8 8-8h96c4.4 0 8 3.6 8 8s-3.6 8-8 8H352c-4.4 0-8-3.6-8-8zm0 48c0-4.4 3.6-8 8-8h96c4.4 0 8 3.6 8 8s-3.6 8-8 8H352c-4.4 0-8-3.6-8-8zM192 224a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-144a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "circle-dollar-to-slot": [512, 512, ["donate"], "f4b9", "M448 208A192 192 0 1 0 64 208a192 192 0 1 0 384 0zM48 208a208 208 0 1 1 416 0A208 208 0 1 1 48 208zm0 160H77.1c5 5.6 10.2 10.9 15.7 16H48c-17.7 0-32 14.3-32 32v48c0 17.7 14.3 32 32 32H464c17.7 0 32-14.3 32-32V416c0-17.7-14.3-32-32-32H419.2c5.5-5.1 10.7-10.4 15.7-16H464c26.5 0 48 21.5 48 48v48c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V416c0-26.5 21.5-48 48-48zM256.9 93.3c4.4 0 8 3.6 8 8v19.3c2.3 .2 4.5 .5 6.8 .9c5.3 .8 21.5 4 27.2 5.5c4.3 1.1 6.8 5.5 5.7 9.8s-5.5 6.8-9.8 5.7c-4.9-1.3-20.5-4.3-25.6-5.1c-15.8-2.5-29.7-.6-39.9 4c-10.1 4.6-15.9 11.5-17.3 19.5c-1.1 6.2-.3 10.7 1.3 14.1c1.7 3.5 4.6 6.7 8.9 9.6c8.9 6.1 21.9 10 36.7 14.4l.4 .1c14.2 4.3 30.1 9.1 41.6 17.5c5.9 4.3 11 9.8 14.1 16.9c3.1 7.2 3.9 15.4 2.3 24.6c-2.7 15.6-12.9 26.5-26.7 32.4c-7.6 3.3-16.4 5.1-25.8 5.5v18.8c0 4.4-3.6 8-8 8s-8-3.6-8-8V295.4c-2.3-.2-4.5-.5-6.8-.9l0 0c-9.5-1.5-25-6.8-35.4-10.4l0 0 0 0c-2.1-.7-4-1.4-5.6-1.9c-4.2-1.4-6.5-5.9-5.1-10.1s5.9-6.5 10.1-5.1c1.9 .6 4.1 1.4 6.3 2.1l0 0c10.6 3.6 24.1 8.2 32.1 9.5c16 2.5 29.9 1.2 39.8-3.1c9.7-4.2 15.6-11 17.3-20.4c1.2-6.7 .4-11.7-1.2-15.5c-1.7-3.9-4.6-7.2-8.8-10.3c-8.9-6.4-21.9-10.6-36.8-15.1l-1.8-.5c-13.6-4.1-28.7-8.6-39.6-16.1c-5.9-4-11.1-9.2-14.4-16c-3.3-6.9-4.2-14.8-2.6-23.7c2.5-14.5 12.9-25.2 26.4-31.4c7.7-3.5 16.5-5.6 26.1-6.3V101.3c0-4.4 3.6-8 8-8zM64 440H448c4.4 0 8 3.6 8 8s-3.6 8-8 8H64c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "memory": [576, 512, [], "f538", "M16 128c0-26.5 21.5-48 48-48H512c26.5 0 48 21.5 48 48v7.4c0 .1-.1 .3-.3 .6c-.4 .7-1.3 1.5-2.5 2.4C539.6 149.7 528 169.5 528 192s11.6 42.3 29.2 53.7c1.3 .8 2.1 1.7 2.5 2.4c.2 .3 .3 .5 .3 .6V320H16V248.6c0-.1 .1-.3 .3-.6c.4-.7 1.3-1.5 2.5-2.4C36.4 234.3 48 214.5 48 192s-11.6-42.3-29.2-53.7c-1.3-.8-2.1-1.7-2.5-2.4c-.2-.3-.3-.5-.3-.6V128zm0 208H560v80c0 8.8-7.2 16-16 16H480V400c0-4.4-3.6-8-8-8s-8 3.6-8 8v32H352V400c0-4.4-3.6-8-8-8s-8 3.6-8 8v32H240V400c0-4.4-3.6-8-8-8s-8 3.6-8 8v32H112V400c0-4.4-3.6-8-8-8s-8 3.6-8 8v32H32c-8.8 0-16-7.2-16-16V336zM32 448h72H232 344 472h72c17.7 0 32-14.3 32-32V248.6c0-6.8-4.4-12.6-10.1-16.3C552.7 223.7 544 208.9 544 192s8.7-31.7 21.9-40.3c5.7-3.7 10.1-9.5 10.1-16.3V128c0-35.3-28.7-64-64-64H64C28.7 64 0 92.7 0 128v7.4c0 6.8 4.4 12.6 10.1 16.3C23.3 160.3 32 175.1 32 192s-8.7 31.7-21.9 40.3C4.4 236 0 241.8 0 248.6V416c0 17.7 14.3 32 32 32zM160 144c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V160c0-8.8 7.2-16 16-16zm128 0c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V160c0-8.8 7.2-16 16-16zm128 0c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16s-16-7.2-16-16V160c0-8.8 7.2-16 16-16zM160 128c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V160c0-17.7-14.3-32-32-32zm128 0c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V160c0-17.7-14.3-32-32-32zm128 0c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32s32-14.3 32-32V160c0-17.7-14.3-32-32-32z"],
    "face-sleeping": [512, 512, [], "e38d", "M16 256C16 123.5 123.5 16 256 16c35.4 0 69.1 7.7 99.3 21.4c4 1.8 8.8 .1 10.6-4s.1-8.8-4-10.6C329.6 8.2 293.8 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512s256-114.6 256-256c0-37.8-8.2-73.6-22.9-105.9c-1.8-4-6.6-5.8-10.6-4s-5.8 6.6-4 10.6C488.3 186.9 496 220.6 496 256c0 132.5-107.5 240-240 240S16 388.5 16 256zM224 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM424 16h60.7L418.3 82.3c-2.3 2.3-3 5.7-1.7 8.7s4.2 4.9 7.4 4.9h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H443.3l66.3-66.3c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9H424c-4.4 0-8 3.6-8 8s3.6 8 8 8zM288 104c0 4.4 3.6 8 8 8h60.7l-66.3 66.3c-2.3 2.3-3 5.7-1.7 8.7s4.2 4.9 7.4 4.9h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H315.3l66.3-66.3c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9H296c-4.4 0-8 3.6-8 8zm63.6 168c-14.6 0-30.2-8.6-41-27.9c-2.2-3.9-7-5.2-10.9-3.1s-5.2 7-3.1 10.9c13.1 23.4 33.6 36.1 55 36.1s41.8-12.7 55-36.1c2.2-3.9 .8-8.7-3.1-10.9s-8.7-.8-10.9 3.1c-10.9 19.3-26.4 27.9-41 27.9zm-233-27.9c-2.2-3.9-7-5.2-10.9-3.1s-5.2 7-3.1 10.9c13.1 23.4 33.6 36.1 55 36.1s41.8-12.7 55-36.1c2.2-3.9 .8-8.7-3.1-10.9s-8.7-.8-10.9 3.1c-10.9 19.3-26.4 27.9-41 27.9s-30.2-8.6-41-27.9z"],
    "road-spikes": [640, 512, [], "e568", "M580.2 336c12.8 0 20.4-14.2 13.3-24.9L464 116.8V280v56H580.2zM448 256V116.8c0-15.8 20.5-22 29.3-8.9L606.8 302.2c14.2 21.3-1.1 49.7-26.6 49.7H464v0H448 336v0H320 208 192 80 64V336 116.8c0-15.8 20.5-22 29.3-8.9L192 256V116.8c0-15.8 20.5-22 29.3-8.9L320 256V116.8c0-15.8 20.5-22 29.3-8.9L448 256zm0 28.8l-112-168V280v56H448v0V284.8zM320 336v0V284.8l-112-168V280v56H320zM80 116.8V336H192V284.8L80 116.8zM0 440c0-4.4 3.6-8 8-8H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8z"],
    "fire-burner": [640, 512, [], "e4f1", "M349.2 77.5c-4.8 .1-9.4-2.1-12.5-5.8c-16.5-19.9-34.2-38.3-53.1-55.3C251.8 44.9 225 77.2 206 107.9c-19 30.8-30 62.1-30 84.2c0 79 63.2 143.8 144 143.8c79.9 0 144-64.8 144-143.8c0-16.5-8.3-44.5-22.4-71.6c-14-26.9-33.5-54.9-56.2-76c-8.3 7.7-16.3 17.4-23.9 26.9c-3 3.8-7.5 6-12.3 6zM338.4 49.1c3.6 4.1 7.1 8.2 10.6 12.4c3.3-4.1 6.7-8.4 10.3-12.6c5.1-5.9 10.5-11.8 16.1-16.9c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 58.8 24.2 79C480 280 408.7 352 320 352c-89.7 0-160-72.1-160-159.8c0-26.4 12.7-60.7 32.4-92.6c20-32.4 48.1-66.1 81.4-95.8c2.8-2.5 6.4-3.8 10-3.7c3.5 0 7 1.3 9.8 3.8c15.8 14.2 30.7 29.3 44.9 45.3zM281.7 96c2.4 0 4.7 1.1 6.2 3c2.2 2.8 19.4 24.6 35.9 45.7l22.5 28.7 4 5.2 33.4-38.9c1.6-1.8 3.9-2.9 6.3-2.8s4.7 1.3 6.1 3.2c3.7 5 6.2 10 8.4 14.3l0 0 0 .1c21.5 39.6 12.2 90.5-24.6 116.2l-.2 .1 0 0c-17.8 11.9-37 17.9-58.5 17.9c-26.5 0-50.9-8.6-68.7-24.9c-17.9-16.4-28.7-40.1-28.7-69.2c0-15.1 4.8-28.9 13.5-43.9c8.6-14.8 21.4-31.3 37.9-51.6c1.5-1.9 3.8-3 6.2-3zm68.4 95.2l-6.3 4.9 0 0 0 0 0 0-.1-.2-.5-.7-2-2.6-7.3-9.3-22.5-28.7c-11.3-14.4-22.7-29-29.6-37.8c-13.4 16.7-23.4 30-30.3 41.8c-7.8 13.4-11.3 24.4-11.3 35.8c0 24.9 9.1 44.3 23.5 57.4c14.5 13.2 34.8 20.7 57.9 20.7c18.2 0 34.3-5 49.5-15.2c29.4-20.6 37.7-62.3 19.6-95.5l-.1-.3 0 0c-.6-1.1-1.1-2.2-1.7-3.3l-32.6 38c-1.6 1.8-3.9 2.8-6.2 2.8s-4.6-1.2-6.1-3.1l6.3-4.9zM32 264c0-4.4 3.6-8 8-8H88c4.4 0 8 3.6 8 8s-3.6 8-8 8H48V384H592V272H552c-4.4 0-8-3.6-8-8s3.6-8 8-8h48c4.4 0 8 3.6 8 8V384c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V416c0-17.7 14.3-32 32-32V264zm0 136c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16H608c8.8 0 16-7.2 16-16V416c0-8.8-7.2-16-16-16h-8H40 32zm288 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm112 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM192 432a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "squirrel": [512, 512, [], "f71a", "M140.3 16C71.6 16 16 71.6 16 140.3s55.6 124.3 124.3 124.3c13.1 0 25.2 7.1 31.5 18.6c7.9 14.3 4.5 31.1-4 43.2c-12.3 17.5-19.6 38.9-19.6 61.9C148.3 447.8 196.5 496 256 496H361.2c42 0 76-34 76-76s-34-76-76-76c-8 0-15.6 1.2-22.8 3.5c-4.2 1.3-8.7-1-10-5.2s1-8.7 5.2-10c8.7-2.7 18-4.2 27.6-4.2c17.1 0 33.1 4.7 46.8 12.8V240c0-4.4 3.6-8 8-8h16.5c25.6 0 48.7-15.3 58.8-38.8l4.5-10.5-.6-5.9C491.6 140 460.6 112 423.6 112H408c-4.4 0-8-3.6-8-8V80c-13.3 0-24 10.7-24 24c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-13.3-10.7-24-24-24V96v8 44.2c0 37.9-6.8 64.1-20.2 87.9c-11.4 20.4-27.6 39-47.2 61.6c-2.8 3.2-5.7 6.6-8.7 10l-11.2 13C233 338.9 224 367.1 224 392c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-28.1 10-60.2 28.6-81.8l11.2-13c3-3.5 5.9-6.8 8.7-10l0 0c19.8-22.8 34.8-40 45.3-58.9c11.8-21.1 18.1-44.4 18.1-80.1V104 96 80c0-8.8 7.2-16 16-16c13.1 0 24.7 6.3 32 16c7.3-9.7 18.9-16 32-16c8.8 0 16 7.2 16 16V96h7.6c45.2 0 83.1 34.3 87.6 79.2l.8 8c.1 1.3-.1 2.7-.6 3.9l-5.3 12.4c-12.6 29.4-41.5 48.5-73.5 48.5H424V352h-.8c18.5 16.8 30 41.1 30 68c0 31.6-15.9 59.4-40.1 76H472c4.4 0 8 3.6 8 8s-3.6 8-8 8H361.2 256c-68.3 0-123.7-55.4-123.7-123.7c0-26.5 8.3-51 22.5-71.1c6-8.5 7.2-18.6 3-26.3c-3.5-6.4-10.2-10.3-17.5-10.3C62.8 280.5 0 217.7 0 140.3S62.8 0 140.3 0s140.3 62.8 140.3 140.3v33.1c0 4.4-3.6 8-8 8s-8-3.6-8-8V140.3C264.5 71.6 208.9 16 140.3 16zM416 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "arrow-up-to-line": [384, 512, ["arrow-to-top"], "f341", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H8zm189.7 98.3c-3.1-3.1-8.2-3.1-11.3 0l-136 136c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L184 155.3V472c0 4.4 3.6 8 8 8s8-3.6 8-8V155.3L322.3 277.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-136-136z"],
    "flag": [448, 512, [127988, 61725], "f024", "M16 8c0-4.4-3.6-8-8-8S0 3.6 0 8V64 383.5 400 504c0 4.4 3.6 8 8 8s8-3.6 8-8V396l112.3-28.1c41.1-10.3 84.6-5.5 122.5 13.4c44.2 22.1 95.5 24.8 141.7 7.4l34.7-13c12.5-4.7 20.8-16.6 20.8-30V54.8c0-17.8-18.8-29.4-34.7-21.5l-19.7 9.8c-46.3 23.2-100.8 23.2-147.1 0c-35.1-17.6-75.4-22-113.5-12.5L16 60V8zm0 68.5L136.8 46.3c34.4-8.6 70.7-4.6 102.4 11.2c50.8 25.4 110.6 25.4 161.5 0l19.7-9.8c5.3-2.7 11.6 1.2 11.6 7.2v291c0 6.7-4.1 12.6-10.4 15l-34.7 13c-42.1 15.8-88.8 13.3-129-6.8c-41.3-20.7-88.7-25.9-133.5-14.7L16 379.5V76.5z"],
    "face-cowboy-hat": [512, 512, [], "e36e", "M375 110.9C359 62.1 330.2 0 296 0c-8.9 0-17.4 4.2-25.4 11.2c-8.2 7.2-21.1 7.2-29.3 0C233.4 4.2 224.9 0 216 0c-34.2 0-63 62.1-79 110.9c-34.9-10.6-66.1-25.7-91.9-44.2C42.6 65 39.7 64 36.7 64C27.7 64 21 72.3 23.8 80.7C50.8 163.2 144.5 224 256 224s205.2-60.8 232.2-143.3C491 72.3 484.3 64 475.3 64c-3 0-6 1-8.4 2.8c-25.8 18.5-57 33.6-91.9 44.2zm-15.4 4.3c-32.1 8.3-67 12.8-103.5 12.8s-71.4-4.5-103.5-12.8c6-18.2 13.8-38.1 22.9-55.6c7.2-13.9 14.9-25.4 22.5-33.2c7.8-8 13.9-10.4 18.1-10.4c3.6 0 8.5 1.7 14.8 7.2c14.2 12.5 36.2 12.5 50.4 0c6.3-5.5 11.2-7.2 14.8-7.2c4.3 0 10.3 2.4 18.1 10.4c7.7 7.8 15.3 19.3 22.5 33.2c9.1 17.5 16.9 37.4 22.9 55.6zM42 84.1c55.2 37.3 131 59.9 214 59.9s158.7-22.6 214-59.9C442.2 154.3 358.4 208 256 208S69.8 154.3 42 84.1zM75.8 200C58.1 230.6 48 266.1 48 304c0 114.9 93.1 208 208 208s208-93.1 208-208c0-37.9-10.1-73.4-27.8-104c-4.3 3.1-8.7 6.1-13.3 9c16 28 25.1 60.4 25.1 94.9c0 106-86 192-192 192S64 410 64 304c0-34.5 9.1-66.9 25.1-94.9c-4.5-2.9-9-5.9-13.3-9zM256.2 378.3c35.6 0 69.8-4.3 101.1-12.1c4-1 7.3 .4 8.7 1.9c.7 .7 .7 1.1 .7 1.1s0 .1 0 .3s-.2 .6-.5 1.3C344 408.7 303 434 256.2 434s-87.8-25.3-110-63.2c-.4-.7-.5-1.1-.5-1.3s0-.3 0-.3s.1-.4 .7-1.1c1.5-1.5 4.7-2.9 8.7-1.9c31.3 7.8 65.4 12.1 101.1 12.1zm123.8 .5c9.7-16.6-7.9-32.8-26.6-28.2c-30 7.5-62.8 11.6-97.2 11.6s-67.2-4.1-97.2-11.6c-18.7-4.7-36.3 11.6-26.6 28.2c25 42.6 71.1 71.1 123.8 71.1s98.8-28.6 123.8-71.1zM192 272a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm144 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "hanukiah": [640, 512, [128334], "f6e6", "M336 64c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C307.5 44 304 54.5 304 64c0 8.8 7.2 16 16 16s16-7.2 16-16zM320 96c-17.7 0-32-14.3-32-32c0-26.2 18.9-52.4 25.7-61c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3c6.8 8.6 25.7 34.8 25.7 61c0 17.7-14.3 32-32 32zm-80 0c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5.1-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C211.5 76 208 86.5 208 96c0 8.8 7.2 16 16 16s16-7.2 16-16zm-16 32c-17.7 0-32-14.3-32-32c0 17.7-14.3 32-32 32s-32-14.3-32-32c0 17.7-14.3 32-32 32s-32-14.3-32-32c0 17.7-14.3 32-32 32S0 113.7 0 96C0 69.8 18.9 43.6 25.7 35c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3C45.1 43.6 64 69.8 64 96c0-26.2 18.9-52.4 25.7-61c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3c6.8 8.6 25.7 34.8 25.7 61c0-26.2 18.9-52.4 25.7-61c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3c6.8 8.6 25.7 34.8 25.7 61c0-26.2 18.9-52.4 25.7-61c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3c6.8 8.6 25.7 34.8 25.7 61c0 17.7-14.3 32-32 32zm192-16c8.8 0 16-7.2 16-16c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C403.5 76 400 86.5 400 96c0 8.8 7.2 16 16 16zm32-16c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-26.2 18.9-52.4 25.7-61c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3c6.8 8.6 25.7 34.8 25.7 61zm64 0c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-26.2 18.9-52.4 25.7-61c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3c6.8 8.6 25.7 34.8 25.7 61zm64 0c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-26.2 18.9-52.4 25.7-61c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3c6.8 8.6 25.7 34.8 25.7 61zm0 0c0-26.2 18.9-52.4 25.7-61c1.5-1.9 3.8-3 6.3-3s4.8 1 6.3 3c6.8 8.6 25.7 34.8 25.7 61c0 17.7-14.3 32-32 32s-32-14.3-32-32zm48 0c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C595.5 76 592 86.5 592 96c0 8.8 7.2 16 16 16s16-7.2 16-16zm-80 16c8.8 0 16-7.2 16-16c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C531.5 76 528 86.5 528 96c0 8.8 7.2 16 16 16zM496 96c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C467.5 76 464 86.5 464 96c0 8.8 7.2 16 16 16s16-7.2 16-16zM160 112c8.8 0 16-7.2 16-16c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5.1-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C147.5 76 144 86.5 144 96c0 8.8 7.2 16 16 16zM112 96c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5.1-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C83.5 76 80 86.5 80 96c0 8.8 7.2 16 16 16s16-7.2 16-16zM32 112c8.8 0 16-7.2 16-16c0-9.5-3.5-20-8.5-29.8c-2.4-4.7-5.1-9-7.5-12.6c-2.4 3.6-5 7.9-7.5 12.6C19.5 76 16 86.5 16 96c0 8.8 7.2 16 16 16zm288 16c4.4 0 8 3.6 8 8l0 232h80V168c0-4.4 3.6-8 8-8s8 3.6 8 8V368h48V168c0-4.4 3.6-8 8-8s8 3.6 8 8V368h48V168c0-4.4 3.6-8 8-8s8 3.6 8 8V367.4c27.1-3.9 48-27.2 48-55.4l0-144c0-4.4 3.6-8 8-8s8 3.6 8 8l0 144c0 39.8-32.2 72-72 72H328V496H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H320 136c-4.4 0-8-3.6-8-8s3.6-8 8-8H312V384H96c-39.8 0-72-32.2-72-72l0-144c0-4.4 3.6-8 8-8s8 3.6 8 8l0 144c0 28.2 20.9 51.6 48 55.4V168c0-4.4 3.6-8 8-8s8 3.6 8 8V368h48V168c0-4.4 3.6-8 8-8s8 3.6 8 8V368h48V168c0-4.4 3.6-8 8-8s8 3.6 8 8V368h80l0-232c0-4.4 3.6-8 8-8z"],
    "chart-scatter-3d": [512, 512, [], "e0e8", "M48 64A16 16 0 1 1 16 64a16 16 0 1 1 32 0zM32 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm232 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V284.3L34.8 465.9c-3.4 2.9-3.8 7.9-.9 11.3s7.9 3.8 11.3 .9L256 298.5 466.8 478.1c3.4 2.9 8.4 2.5 11.3-.9s2.5-8.4-.9-11.3L264 284.3V40zM400 64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM384 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 240a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32-16a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm144-96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM128 176a16 16 0 1 1 0-32 16 16 0 1 1 0 32zM96 160a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM32 272a16 16 0 1 1 0-32 16 16 0 1 1 0 32zM0 256a32 32 0 1 0 64 0A32 32 0 1 0 0 256zM272 448a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64z"],
    "display-chart-up": [576, 512, [], "e5e3", "M64 16C37.5 16 16 37.5 16 64V352c0 26.5 21.5 48 48 48H231.8h.3H343.9h.3H512c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H64zM222.6 416H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H512c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H353.4l13.3 80H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H360 216 136c-4.4 0-8-3.6-8-8s3.6-8 8-8h73.2l13.3-80zm16.2 0l-13.3 80H350.6l-13.3-80H238.8zM496 80H80l0 256H496V80zM80 64H496c8.8 0 16 7.2 16 16V336c0 8.8-7.2 16-16 16H80c-8.8 0-16-7.2-16-16V80c0-8.8 7.2-16 16-16zm272 64h88c4.4 0 8 3.6 8 8v88c0 4.4-3.6 8-8 8s-8-3.6-8-8V155.3L325.7 261.7c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3L240 187.3 133.7 293.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l112-112c3.1-3.1 8.2-3.1 11.3 0L320 244.7 420.7 144H352c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "square-code": [448, 512, [], "e267", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM266.3 170.3c-3.1 3.1-3.1 8.2 0 11.3L340.7 256l-74.3 74.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l80-80c3.1-3.1 3.1-8.2 0-11.3l-80-80c-3.1-3.1-8.2-3.1-11.3 0zm-84.7 11.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-80 80c-3.1 3.1-3.1 8.2 0 11.3l80 80c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L107.3 256l74.3-74.3z"],
    "feather": [512, 512, [129718], "f52d", "M339.2 161.4c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L299.3 224h181c10.2-19.6 15.7-41.5 15.7-64c0-36.7-14.6-72-40.6-97.9l-5.5-5.5C424 30.6 388.7 16 352 16s-72 14.6-97.9 40.6L150.3 160.3C105.3 205.3 80 266.4 80 330v90.6L339.2 161.4zM283.3 240l-80 80H393.4l62.1-62.1c5.6-5.6 10.6-11.6 15.1-17.9H283.3zM400 336l-37 37c-48 48-113.1 75-181 75H75.3L13.7 509.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L64 436.7V330c0-67.9 27-133 75-181L242.7 45.3C271.7 16.3 311 0 352 0s80.3 16.3 109.3 45.3l5.5 5.5C495.7 79.7 512 119 512 160s-16.3 80.3-45.3 109.3L400 336zm-22.6 0H187.3l-96 96H182c63.7 0 124.7-25.3 169.7-70.3L377.4 336z"],
    "volume-low": [448, 512, [128264, "volume-down"], "f027", "M281 51.5c2.5-2.2 5.8-3.5 9.2-3.5c7.6 0 13.8 6.2 13.8 13.8V450.2c0 7.6-6.2 13.8-13.8 13.8c-3.4 0-6.6-1.2-9.2-3.5L143.2 338c-1.5-1.3-3.4-2-5.3-2H56c-22.1 0-40-17.9-40-40V216c0-22.1 17.9-40 40-40h81.9c2 0 3.9-.7 5.3-2L281 51.5zM290.2 32c-7.3 0-14.3 2.7-19.8 7.5L134.9 160H56c-30.9 0-56 25.1-56 56v80c0 30.9 25.1 56 56 56h78.9L270.4 472.5c5.5 4.8 12.5 7.5 19.8 7.5c16.5 0 29.8-13.3 29.8-29.8V61.8C320 45.3 306.7 32 290.2 32zM409.7 179.2c-3.5-2.7-8.5-1.9-11.2 1.6s-1.9 8.5 1.6 11.2c19.4 14.6 31.9 37.8 31.9 64s-12.5 49.4-31.9 64c-3.5 2.7-4.2 7.7-1.6 11.2s7.7 4.2 11.2 1.6C432.9 315.2 448 287.4 448 256s-15.1-59.2-38.3-76.8z"],
    "xmark-to-slot": [576, 512, ["times-to-slot", "vote-nay"], "f771", "M144 48c-17.7 0-32 14.3-32 32V408H464V80c0-17.7-14.3-32-32-32H144zM480 80V408h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H480 464 112 96 64c-4.4 0-8-3.6-8-8s3.6-8 8-8H96V80c0-26.5 21.5-48 48-48H432c26.5 0 48 21.5 48 48zM48 352H64v16H48c-17.7 0-32 14.3-32 32v32c0 17.7 14.3 32 32 32H528c17.7 0 32-14.3 32-32V400c0-17.7-14.3-32-32-32H512V352h16c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V400c0-26.5 21.5-48 48-48zM210.3 146.3c3.1-3.1 8.2-3.1 11.3 0L288 212.7l66.3-66.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L299.3 224l66.3 66.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L288 235.3l-66.3 66.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L276.7 224l-66.3-66.3c-3.1-3.1-3.1-8.2 0-11.3z"],
    "box-taped": [448, 512, ["box-alt"], "f49a", "M240 48h3L270 176H178L205 48h3 8 16 8zM160 192v80c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V192h16H432V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V192H144h16zm112 0v80c0 8.8-7.2 16-16 16H192c-8.8 0-16-7.2-16-16V192h96zm32-16H286.3L259.4 48h83c19 0 36.2 11.2 43.9 28.5l41.6 93.6c.9 1.9 1.6 3.9 2.2 5.9H304zm-160 0H18c.6-2 1.3-4 2.2-5.9L61.7 76.5C69.4 59.2 86.6 48 105.6 48h83L161.7 176H144zM256 32H192 105.6C80.3 32 57.4 46.9 47.1 70L5.5 163.6c-3.6 8.2-5.5 17-5.5 26V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V189.6c0-9-1.9-17.8-5.5-26L400.9 70c-10.3-23.1-33.2-38-58.5-38H256z"],
    "comment-slash": [640, 512, [], "f4b3", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM409.4 418.3C382 427.1 351.8 432 320 432c-35.2 0-68.6-6.1-98.7-17c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8c-22.9 10-49.6 18-75.2 18l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C92 450 98 442 104 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C95.9 318.8 80 280.7 80 240c0-24.1 5.7-47.4 16.1-69L83.2 160.8C70.8 185.2 64 212 64 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0 0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c37.1 0 72.4-6.4 104.2-18l-14.9-11.7zM320 32c-47.7 0-92.4 10.6-130.7 29.1l14 11C237.6 56.8 277.2 48 320 48c135.8 0 240 88.9 240 192c0 32.5-10.4 63.6-28.8 91l12.7 10c20.5-29.9 32.1-64.3 32.1-101C576 125.1 461.4 32 320 32z"],
    "swords": [512, 512, [9876], "f71d", "M142.1 278.6l11.3 11.3L119.3 324 188 392.7l34.1-34.1 11.3 11.3L199.3 404l19 19c9.4 9.4 9.4 24.6 0 33.9l-12.9 12.9c-7 7-17.6 9-26.7 5l-56.9-25.3L67.3 504c-5.1 5.1-12.1 8-19.3 8s-14.2-2.9-19.3-8L8 483.3c-5.1-5.1-8-12.1-8-19.3s2.9-14.2 8-19.3l54.5-54.5L37.2 333.3c-4-9.1-2.1-19.7 5-26.7L55 293.7c9.4-9.4 24.6-9.4 33.9 0l19 19 34.1-34.1zm216.6-56.6L467.8 112.8c8.3-8.3 13.7-18.9 15.6-30.4l10.8-64.7L429.5 28.5c-11.5 1.9-22.1 7.4-30.4 15.6L289.9 153.4l-11.3-11.3L387.8 32.8c10.6-10.6 24.3-17.6 39.1-20.1L502.7 .1c2.6-.4 5.1 .4 7 2.2s2.7 4.4 2.2 7L499.3 85.1c-2.5 14.8-9.5 28.5-20.1 39.1L369.9 233.4l-11.3-11.3zM77.7 305c-3.1-3.1-8.2-3.1-11.3 0L53.4 317.9c-2.3 2.3-3 5.9-1.7 8.9l27.5 62c1.3 3 .7 6.6-1.7 8.9L19.3 456c-2.1 2.1-3.3 5-3.3 8s1.2 5.9 3.3 8L40 492.7c2.1 2.1 5 3.3 8 3.3s5.9-1.2 8-3.3l58.3-58.3c2.3-2.3 5.9-3 8.9-1.7l62 27.5c3 1.3 6.6 .7 8.9-1.7L207 445.7c3.1-3.1 3.1-8.2 0-11.3L77.7 305zM.1 9.3c-.4-2.5 .4-5.1 2.2-7S6.8-.3 9.3 .1L85.1 12.7c14.8 2.5 28.5 9.5 39.1 20.1L381.4 290.1l-11.3 11.3L112.8 44.2C104.6 35.9 94 30.4 82.5 28.5L17.7 17.7 28.5 82.5c1.9 11.5 7.4 22.1 15.6 30.4L301.4 370.1l-11.3 11.3L32.8 124.2C22.2 113.5 15.2 99.9 12.7 85.1L.1 9.3zM457 293.7l12.9 12.9c7 7 9 17.6 5 26.7l-25.3 56.9L504 444.7c5.1 5.1 8 12.1 8 19.3s-2.9 14.2-8 19.3L483.3 504c-5.1 5.1-12.1 8-19.3 8s-14.2-2.9-19.3-8l-54.5-54.5-56.9 25.3c-9.1 4-19.7 2.1-26.7-5L293.7 457c-9.4-9.4-9.4-24.6 0-33.9L423 293.7c9.4-9.4 24.6-9.4 33.9 0zM434.3 305L305 434.3c-3.1 3.1-3.1 8.2 0 11.3l12.9 12.9c2.3 2.3 5.9 3 8.9 1.7l62-27.5c3-1.3 6.6-.7 8.9 1.7L456 492.7c2.1 2.1 5 3.3 8 3.3s5.9-1.2 8-3.3L492.7 472c2.1-2.1 3.3-5 3.3-8s-1.2-5.9-3.3-8l-58.3-58.3c-2.3-2.3-3-5.9-1.7-8.9l27.5-62c1.3-3 .7-6.6-1.7-8.9L445.7 305c-3.1-3.1-8.2-3.1-11.3 0z"],
    "cloud-sun-rain": [640, 512, [127782], "f743", "M137.2 2.9c-4.5-3.2-10.3-3.8-15.4-1.6s-8.7 6.7-9.6 12.1L98.1 98.1 13.4 112.2c-5.4 .9-10 4.5-12.1 9.6s-1.5 10.9 1.6 15.4L52.5 208 2.9 278.8c-3.2 4.5-3.8 10.3-1.6 15.4s6.7 8.7 12.1 9.6l84.7 14.1 14.1 84.7c.9 5.4 4.5 10 9.6 12.1s10.9 1.5 15.4-1.6l56-39.2c-3.6-4-6.9-8.1-10-12.5l-40.6 28.4L128 400l-2.9-17.5-11.2-67.2c-1.1-6.7-6.4-12-13.2-13.2L33.5 290.9 16 288l10.2-14.5 39.4-56.3c3.9-5.5 3.9-12.8 0-18.4L26.2 142.5 16 128l17.5-2.9 67.2-11.2c6.7-1.1 12-6.4 13.2-13.2l11.2-67.2L128 16l14.5 10.2 56.3 39.4c5.5 3.9 12.8 3.9 18.4 0l56.3-39.4L288 16l2.9 17.5 8.4 50.4c4.8-3 9.7-5.7 14.9-8.1L303.8 13.4c-.9-5.4-4.5-10-9.6-12.1s-10.9-1.5-15.4 1.6L208 52.5 137.2 2.9zM208 112c-53 0-96 43-96 96c0 35.6 19.3 66.6 48 83.2c0-1.1 0-2.2 0-3.2c0-5.2 .3-10.3 .9-15.3C141 258.1 128 234.6 128 208c0-44.2 35.8-80 80-80c15.7 0 30.4 4.5 42.8 12.4c2.2-4.9 4.6-9.7 7.4-14.3c-14.6-9-31.8-14.1-50.2-14.1zm60.2 305.2c-3.8-2.3-8.7-1-11 2.7l-48 80c-2.3 3.8-1 8.7 2.7 11s8.7 1 11-2.7l48-80c2.3-3.8 1-8.7-2.7-11zm96 0c-3.8-2.3-8.7-1-11 2.7l-48 80c-2.3 3.8-1 8.7 2.7 11s8.7 1 11-2.7l48-80c2.3-3.8 1-8.7-2.7-11zm96 0c-3.8-2.3-8.7-1-11 2.7l-48 80c-2.3 3.8-1 8.7 2.7 11s8.7 1 11-2.7l48-80c2.3-3.8 1-8.7-2.7-11zm96 0c-3.8-2.3-8.7-1-11 2.7l-48 80c-2.3 3.8-1 8.7 2.7 11s8.7 1 11-2.7l48-80c2.3-3.8 1-8.7-2.7-11zM288 192c0-44.2 35.8-80 80-80c32 0 59.6 18.8 72.4 46c1.1 2.3 3.2 3.9 5.7 4.4s5.1-.2 6.9-1.9c11.4-10.3 26.4-16.5 42.9-16.5c35.3 0 64 28.7 64 64c0 7.5-1.3 14.7-3.7 21.4c-.8 2.4-.5 5 .9 7.1s3.7 3.4 6.2 3.5c33.7 1.8 60.5 29.7 60.5 63.9c0 35.3-28.7 64-64 64c-.7 0-1.5 0-2.2 0l0 0h-.3H291v0l-.3 0c-.9 0-1.8 0-2.8 0c-44.2 0-80-35.8-80-80c0-41.8 32.1-76.2 73.1-79.7c2.1-.2 4.1-1.2 5.5-2.8s2-3.8 1.8-5.9c-.2-2.5-.4-5-.4-7.6zm80-96c-53 0-96 43-96 96l0 1.3c-45.4 7.6-80 47.1-80 94.7c0 53 43 96 96 96c1.1 0 2.1 0 3.2-.1H557.3c.9 0 1.8 0 2.6 0c44.2 0 80-35.8 80-80c0-39.3-28.4-72.1-65.8-78.7c1.2-5.6 1.9-11.3 1.9-17.2c0-44.2-35.8-80-80-80c-17 0-32.8 5.3-45.8 14.4C433.4 114.6 402.8 96 368 96z"],
    "album": [448, 512, [128189], "f89f", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm160 80a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 304a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM208 256a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "circle-n": [512, 512, [], "e118", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM158 130.8c-2.2-2.5-5.7-3.4-8.8-2.3s-5.2 4.2-5.2 7.5V376c0 4.4 3.6 8 8 8s8-3.6 8-8V157.4L354 381.2c2.2 2.5 5.7 3.4 8.8 2.3s5.2-4.2 5.2-7.5V136c0-4.4-3.6-8-8-8s-8 3.6-8 8V354.6L158 130.8z"],
    "compress": [448, 512, [], "f066", "M152 32c4.4 0 8 3.6 8 8V184c0 4.4-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H144V40c0-4.4 3.6-8 8-8zm144 0c4.4 0 8 3.6 8 8V176H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H296c-4.4 0-8-3.6-8-8V40c0-4.4 3.6-8 8-8zM0 328c0-4.4 3.6-8 8-8H152c4.4 0 8 3.6 8 8V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V336H8c-4.4 0-8-3.6-8-8zm288 0c0-4.4 3.6-8 8-8H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H304V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V328z"],
    "wheat-awn": [512, 512, ["wheat-alt"], "e2cd", "M413.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-48 48c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l48-48zm96 0c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-112 112-49.4 49.4c5.7-38.7-6.4-79.4-36.1-109.1L289.5 43.3c-6.2-6.2-16.4-6.2-22.6 0L255.5 54.6c-37.5 37.5-37.5 98.3 0 135.8l27.4 27.4-47.8 47.8c5.7-38.7-6.4-79.4-36.1-109.1l-11.3-11.3c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-37.5 37.5-37.5 98.3 0 135.8l27.4 27.4-47.8 47.8c5.7-38.7-6.4-79.4-36.1-109.1L85.8 247c-6.2-6.2-16.4-6.2-22.6 0L51.9 258.3c-37.5 37.5-37.5 98.3 0 135.8l27.4 27.4L2.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l76.9-76.9 29.2 29.2c37.5 37.5 98.3 37.5 135.8 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-11.3-11.3C224.7 385.8 182 374 142.1 381.2l50.3-50.3 29.2 29.2c37.5 37.5 98.3 37.5 135.8 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-11.3-11.3c-30.9-30.9-73.5-42.7-113.4-35.4l50.3-50.3 29.2 29.2c37.5 37.5 98.3 37.5 135.8 0L470.5 247c6.2-6.2 6.2-16.4 0-22.6L459.2 213c-30.9-30.9-73.5-42.7-113.4-35.4l51.9-51.9 112-112zM321.3 202c41.5-19.3 92.3-11.9 126.5 22.3l11.3 11.3L447.9 247c-31.2 31.2-81.9 31.2-113.1 0l-29.2-29.2L321.3 202zM219.5 303.8c41.5-19.3 92.3-11.9 126.5 22.3l11.3 11.3L346 348.8c-31.2 31.2-81.9 31.2-113.1 0l-29.2-29.2 15.8-15.8zM117.7 405.6c41.5-19.3 92.3-11.9 126.5 22.3l11.3 11.3-11.3 11.3c-31.2 31.2-81.9 31.2-113.1 0l-29.2-29.2 15.8-15.8zm-27.1 4.5L63.2 382.7C32 351.5 32 300.8 63.2 269.6l11.3-11.3 11.3 11.3c32.5 32.5 40.9 80 25 120.2L90.6 410.1zM192.4 308.3L165 280.9c-31.2-31.2-31.2-81.9 0-113.1l11.3-11.3 11.3 11.3c32.5 32.5 40.9 80 25 120.2l-20.3 20.3zM294.2 206.5l-27.4-27.4c-31.2-31.2-31.2-81.9 0-113.1l11.3-11.3 11.3 11.3c32.5 32.5 40.9 80 25 120.2l-20.3 20.3zm215.4-96.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-48 48c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l48-48z"],
    "ankh": [320, 512, [9765], "f644", "M48 128c0 54.1 28.9 98.3 59.5 129.9c15.2 15.7 30.4 27.8 41.9 36c4.1 3 7.7 5.4 10.7 7.3c2.9-1.9 6.5-4.3 10.7-7.3c11.4-8.2 26.7-20.4 41.9-36C243.1 226.3 272 182.1 272 128c0-61.9-50.1-112-112-112S48 66.1 48 128zm88.1 176C99 276.5 32 214.8 32 128C32 57.3 89.3 0 160 0s128 57.3 128 128c0 86.8-67 148.5-104.1 176H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H168V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V320H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H136.1z"],
    "hands-holding-child": [640, 512, [], "e4fa", "M375 152c-5-4.3-12.2-5-18-1.8s-9.1 9.5-8.3 16.1L359.9 255c.5 4.4-2.6 8.4-6.9 8.9s-8.4-2.6-8.9-6.9l-4.4-35c-1-8-7.8-14-15.9-14h-7.6c-8.1 0-14.9 6-15.9 14l-4.4 35c-.5 4.4-4.5 7.5-8.9 6.9s-7.5-4.5-6.9-8.9l11.1-88.8c.8-6.5-2.5-12.9-8.3-16.1s-12.9-2.4-18 1.8l-19.8 16.7c-3.4 2.9-8.4 2.4-11.3-.9s-2.4-8.4 .9-11.3l41.5-35.1c7.2-6.1 16.4-9.5 25.8-9.5h35.6c9.5 0 18.6 3.3 25.8 9.5l41.5 35.1c3.4 2.9 3.8 7.9 .9 11.3s-7.9 3.8-11.3 .9L375 152zM360 40a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm24.5 141c10.1 8.6 25.3 7.3 33.8-2.8s7.3-25.3-2.8-33.8L374 109.2C363.9 100.7 351.1 96 337.8 96H320 302.2c-13.2 0-26 4.7-36.2 13.2l-41.5 35.1c-10.1 8.6-11.4 23.7-2.8 33.8s23.7 11.4 33.8 2.8l1.8-1.5 18-15.2-2.9 23.4L264.2 253c-1.6 13.2 7.7 25.1 20.8 26.8s25.1-7.7 26.8-20.8l.1-1 4.1-33 .1-1h7.6l.1 1 4.1 33 .1 1c1.6 13.2 13.6 22.5 26.8 20.8s22.5-13.6 20.8-26.8l-8.2-65.3-2.9-23.4 18 15.2 1.8 1.5zM296 40a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM96 112c0-26.5-21.5-48-48-48S0 85.5 0 112V344.2c0 27.6 11 54 30.5 73.5l91.9 91.9c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L41.8 406.5C25.3 390 16 367.6 16 344.2V112c0-17.7 14.3-32 32-32s32 14.3 32 32V259c0 20.7 8.2 40.6 22.9 55.2l19.5 19.5 55.9 55.9 0 0 8 8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-8-8 0 0-55.9-55.9 0 0c-10.6-10.6-11.3-27.6-1.5-39.1c10.9-12.7 30.3-13.5 42.2-1.6l92.8 92.7c13.3 13.3 20.8 31.4 20.8 50.3V504c0 4.4 3.6 8 8 8s8-3.6 8-8V424.8c0-23.1-9.2-45.3-25.5-61.6l-92.8-92.8c-18.4-18.4-48.7-17.3-65.6 2.5c-6.2 7.2-9.7 15.9-10.6 24.7C100.8 286.7 96 273.1 96 259V112zM592 64c-26.5 0-48 21.5-48 48V259c0 14.1-4.8 27.8-13.5 38.7c-.9-8.8-4.4-17.5-10.6-24.7c-17-19.8-47.2-21-65.6-2.5l-92.7 92.8c-16.3 16.3-25.5 38.5-25.5 61.6V504c0 4.4 3.6 8 8 8s8-3.6 8-8V424.8c0-18.9 7.5-37 20.8-50.3l92.8-92.7c11.8-11.9 31.3-11.1 42.2 1.6c9.8 11.4 9.1 28.4-1.5 39.1l0 0-55.9 55.9 0 0-8 8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l8-8 55.9-55.9 19.5-19.5C551.8 299.5 560 279.7 560 259V112c0-17.7 14.3-32 32-32s32 14.3 32 32V344.2c0 23.3-9.3 45.7-25.8 62.2l-91.9 91.9c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l91.9-91.9c19.5-19.5 30.5-46 30.5-73.5V112c0-26.5-21.5-48-48-48z"],
    "asterisk": [384, 512, [10033, 61545], "2a", "M192 32c4.4 0 8 3.6 8 8V241.2L371.6 129.3c3.7-2.4 8.7-1.4 11.1 2.3s1.4 8.7-2.3 11.1L206.6 256 380.4 369.3c3.7 2.4 4.7 7.4 2.3 11.1s-7.4 4.7-11.1 2.3L200 270.8V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V270.8L12.4 382.7c-3.7 2.4-8.7 1.4-11.1-2.3s-1.4-8.7 2.3-11.1L177.4 256 3.6 142.7c-3.7-2.4-4.7-7.4-2.3-11.1s7.4-4.7 11.1-2.3L184 241.2V40c0-4.4 3.6-8 8-8z"],
    "key-skeleton-left-right": [640, 512, [], "e3b4", "M624 112a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm16 0c0 61.9-50.1 112-112 112s-112-50.1-112-112l-144 0v72c0 4.4-3.6 8-8 8s-8-3.6-8-8V112l-80 0 0 72c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8l249.1 0C424.9 41.7 471.6 0 528 0c61.9 0 112 50.1 112 112zM16 400a96 96 0 1 0 192 0A96 96 0 1 0 16 400zM0 400c0-61.9 50.1-112 112-112s112 50.1 112 112l144 0V328c0-4.4 3.6-8 8-8s8 3.6 8 8v72l80 0 0-72c0-4.4 3.6-8 8-8s8 3.6 8 8l0 80c0 4.4-3.6 8-8 8l-249.1 0c-7.8 54.3-54.4 96-110.9 96C50.1 512 0 461.9 0 400z"],
    "comment-lines": [512, 512, [], "f4b0", "M157.3 415c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8C68.3 456 41.6 464 16 464l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C28 450 34 442 40 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C31.9 318.8 16 280.7 16 240C16 136.9 120.2 48 256 48s240 88.9 240 192s-104.2 192-240 192c-35.2 0-68.6-6.1-98.7-17zM4.7 452.7l0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0zM136 184c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H136zm0 96c-4.4 0-8 3.6-8 8s3.6 8 8 8H280c4.4 0 8-3.6 8-8s-3.6-8-8-8H136z"],
    "luchador-mask": [448, 512, ["luchador", "mask-luchador"], "f455", "M432 352c0 79.5-64.5 144-144 144H160C80.5 496 16 431.5 16 352V224C16 109.1 109.1 16 224 16s208 93.1 208 208V352zM224 0C100.3 0 0 100.3 0 224V352c0 88.4 71.6 160 160 160H288c88.4 0 160-71.6 160-160V224C448 100.3 347.7 0 224 0zM56 184v24c0 48.6 39.4 88 88 88h27.1l-8 16H152c-39.8 0-72 32.2-72 72s32.2 72 72 72h72 72c39.8 0 72-32.2 72-72s-32.2-72-72-72H284.9l-8-16h30.2c50.6 0 90.8-42.6 87.8-93.2l-1.2-21.2C392.5 160.5 375 144 353.8 144H290.3c-24.1 0-46.6 12-59.9 32.1l-6.3 9.5-6.3-9.5c-13.4-20-35.8-32.1-59.9-32.1H96c-22.1 0-40 17.9-40 40zm40-24h61.7c18.7 0 36.2 9.4 46.6 24.9l13 19.5c1.5 2.2 4 3.6 6.7 3.6s5.2-1.3 6.7-3.6l13-19.5C254 169.4 271.5 160 290.3 160h63.6c12.7 0 23.2 9.9 24 22.6l1.2 21.2c2.4 41.4-30.4 76.2-71.9 76.2H264c-2.8 0-5.3 1.4-6.8 3.8s-1.6 5.3-.4 7.8l16 32c1.4 2.7 4.1 4.4 7.2 4.4h16c30.9 0 56 25.1 56 56s-25.1 56-56 56H224 152c-30.9 0-56-25.1-56-56s25.1-56 56-56h16c3 0 5.8-1.7 7.2-4.4l16-32c1.2-2.5 1.1-5.4-.4-7.8s-4-3.8-6.8-3.8H144c-39.8 0-72-32.2-72-72V184c0-13.3 10.7-24 24-24zm96 80H152c-22.1 0-40-17.9-40-40h40c22.1 0 40 17.9 40 40zm0 16c8.8 0 16-7.2 16-16c0-30.9-25.1-56-56-56H112c-8.8 0-16 7.2-16 16c0 30.9 25.1 56 56 56h40zm104-16H256c0-22.1 17.9-40 40-40h40c0 22.1-17.9 40-40 40zm0 16c30.9 0 56-25.1 56-56c0-8.8-7.2-16-16-16H296c-30.9 0-56 25.1-56 56c0 8.8 7.2 16 16 16h40zM136 384c0-8.8 7.2-16 16-16H296c8.8 0 16 7.2 16 16s-7.2 16-16 16H152c-8.8 0-16-7.2-16-16zm-16 0c0 17.7 14.3 32 32 32H296c17.7 0 32-14.3 32-32s-14.3-32-32-32H152c-17.7 0-32 14.3-32 32z"],
    "square-check": [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM325.7 197.7l-128 128c-3.1 3.1-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L192 308.7 314.3 186.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "shredder": [512, 512, [], "f68a", "M80 64V192H432V90.5c0-12.7-5.1-24.9-14.1-33.9L391.4 30.1c-9-9-21.2-14.1-33.9-14.1H128c-26.5 0-48 21.5-48 48zM64 192V64C64 28.7 92.7 0 128 0H357.5c17 0 33.3 6.7 45.3 18.7l26.5 26.5c12 12 18.7 28.3 18.7 45.3V192c35.3 0 64 28.7 64 64v96c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V256c0-35.3 28.7-64 64-64zm0 16c-26.5 0-48 21.5-48 48v96c0 8.8 7.2 16 16 16H480c8.8 0 16-7.2 16-16V256c0-26.5-21.5-48-48-48H64zm352 64a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM56 504V416H72v88c0 4.4-3.6 8-8 8s-8-3.6-8-8zm96 0V416h16v88c0 4.4-3.6 8-8 8s-8-3.6-8-8zm96 0V416h16v88c0 4.4-3.6 8-8 8s-8-3.6-8-8zm96 0V416h16v88c0 4.4-3.6 8-8 8s-8-3.6-8-8zm96 0V416h16v88c0 4.4-3.6 8-8 8s-8-3.6-8-8z"],
    "book-open-cover": [640, 512, ["book-open-alt"], "e0c0", "M329.4 433l217.7-43.5c7.5-1.5 12.9-8.1 12.9-15.7V33.5c0-9.7-8.6-17.2-18.2-15.9L322.2 47.9l-1.1 .1H328V433.3c.5-.1 .9-.2 1.4-.3zM312 48h6.9l-1.1-.1L98.2 17.6C88.6 16.3 80 23.8 80 33.5V373.8c0 7.6 5.4 14.2 12.9 15.7L310.6 433c.5 .1 .9 .2 1.4 .3V48zM539.6 1.8C558.9-.8 576 14.1 576 33.5V373.8c0 15.3-10.8 28.4-25.7 31.4L332.6 448.7c-8.3 1.7-16.8 1.7-25.1 0L89.7 405.1c-15-3-25.7-16.1-25.7-31.4V33.5C64 14.1 81.1-.8 100.4 1.8L320 32 539.6 1.8zM0 65.5c0-17.9 14.6-32 32-32v16c-8.7 0-16 7-16 16V418.6c0 7.6 5.4 14.2 12.9 15.7l281.7 56.3c6.2 1.2 12.6 1.2 18.8 0l281.7-56.3c7.5-1.5 12.9-8.1 12.9-15.7V65.5c0-9-7.3-16-16-16v-16c17.4 0 32 14.1 32 32V418.6c0 15.3-10.8 28.4-25.7 31.4L332.6 506.3c-8.3 1.7-16.8 1.7-25.1 0L25.7 449.9C10.8 447 0 433.8 0 418.6V65.5z"],
    "sandwich": [512, 512, [129386], "f81f", "M480 80c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H32c-8.8 0-16-7.2-16-16V96c0-8.8 7.2-16 16-16H480zM32 64C14.3 64 0 78.3 0 96v64c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32H32zm0 272H245.6l70 46.7c2.7 1.8 6.2 1.8 8.9 0l70-46.7H480c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H32c-8.8 0-16-7.2-16-16V352c0-8.8 7.2-16 16-16zM0 352v64c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32H392c-1.6 0-3.1 .5-4.4 1.3l-67.6 45-67.6-45c-1.3-.9-2.9-1.3-4.4-1.3H32c-17.7 0-32 14.3-32 32zm8-64c10.1 0 20.2-3.6 29.7-8.3c8.5-4.2 17.3-9.6 25.9-14.9l3.3-2c20-12.2 38.8-22.8 56.8-22.8c22.1 0 40 10.6 60.4 22.7l.3 .2C204.5 274.8 226.9 288 256 288s51.5-13.2 71.6-25.1l.3-.2c20.5-12.1 38.3-22.7 60.4-22.7c18 0 36.8 10.6 56.8 22.8l3.3 2c8.6 5.3 17.4 10.7 25.9 14.9c9.6 4.7 19.7 8.3 29.7 8.3c4.4 0 8-3.6 8-8s-3.6-8-8-8c-6.4 0-13.9-2.4-22.7-6.7c-7.8-3.8-15.9-8.8-24.6-14.1l-3.3-2c-19.2-11.8-41.8-25.2-65.1-25.2c-26.6 0-47.8 12.6-67.2 24.1l-1.7 1C299.1 261.2 280.2 272 256 272s-43.1-10.8-63.4-22.9l-1.7-1c-19.4-11.5-40.6-24.1-67.2-24.1c-23.3 0-45.9 13.4-65.1 25.2l-3.3 2c-8.7 5.3-16.8 10.3-24.6 14.1C21.9 269.6 14.4 272 8 272c-4.4 0-8 3.6-8 8s3.6 8 8 8z"],
    "peseta-sign": [384, 512, [], "e221", "M79.3 32C62 32 48 46 48 63.3V176H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H48V312 472c0 4.4 3.6 8 8 8s8-3.6 8-8V320H192c74.1 0 135.2-56 143.1-128H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H336c0-79.5-64.5-144-144-144H79.3zM320 176H64V63.3C64 54.9 70.9 48 79.3 48H192c70.7 0 128 57.3 128 128zM64 192H319c-7.9 63.1-61.7 112-127 112H64V192z"],
    "square-parking-slash": [640, 512, ["parking-slash"], "f617", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM487.1 479.6L467.3 464H160c-26.5 0-48-21.5-48-48V183.5L96 170.9V416c0 35.3 28.7 64 64 64H480c2.4 0 4.7-.1 7.1-.4zM152.9 32.4L172.7 48H480c26.5 0 48 21.5 48 48V328.5l16 12.6V96c0-35.3-28.7-64-64-64H160c-2.4 0-4.7 .1-7.1 .4zM240 284.6V296v80c0 4.4 3.6 8 8 8s8-3.6 8-8V352 304v-6.8l-16-12.6zm192-31.9c5.1-11.2 8-23.6 8-36.7c0-48.6-39.4-88-88-88H274.1l20.3 16 57.7 0c39.8 0 72 32.2 72 72c0 9.3-1.8 18.2-5 26.4l13 10.3z"],
    "train-tunnel": [512, 512, [], "e454", "M256 16C123.5 16 16 123.5 16 256V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V256C0 114.6 114.6 0 256 0S512 114.6 512 256V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V256C496 123.5 388.5 16 256 16zM192 144c-35.3 0-64 28.7-64 64V368c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V208c0-35.3-28.7-64-64-64H192zm0-16H320c44.2 0 80 35.8 80 80V368c0 38.2-26.8 70.2-62.6 78.1l52.2 52.2c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L316.7 448H195.3l-61.7 61.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l52.2-52.2C138.8 438.2 112 406.2 112 368V208c0-44.2 35.8-80 80-80zm80 248a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM192 208c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16H320c8.8 0 16-7.2 16-16V224c0-8.8-7.2-16-16-16H192zm-32 16c0-17.7 14.3-32 32-32H320c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V224z"],
    "heading": [448, 512, ["header"], "f1dc", "M0 40c0-4.4 3.6-8 8-8H72h64c4.4 0 8 3.6 8 8s-3.6 8-8 8H80V240H368V48H312c-4.4 0-8-3.6-8-8s3.6-8 8-8h64 64c4.4 0 8 3.6 8 8s-3.6 8-8 8H384V248 464h56c4.4 0 8 3.6 8 8s-3.6 8-8 8H376 312c-4.4 0-8-3.6-8-8s3.6-8 8-8h56V256H80V464h56c4.4 0 8 3.6 8 8s-3.6 8-8 8H72 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H64V248 48H8c-4.4 0-8-3.6-8-8z"],
    "ghost": [384, 512, [128123], "f6e2", "M242.7 506c3.3 3.8 8.2 6 13.3 6s9.9-2.2 13.3-6l29.3-33.4c11.6-13.3 32.1-14 44.5-1.5l2.3 2.3c4.2 4.2 10 6.6 16 6.6c12.5 0 22.6-10.1 22.6-22.6V192C384 86 298 0 192 0S0 86 0 192V457.4C0 469.9 10.1 480 22.6 480c6 0 11.8-2.4 16-6.6l2.3-2.3c12.5-12.5 32.9-11.8 44.5 1.5L114.7 506c3.3 3.8 8.2 6 13.3 6s9.9-2.2 13.3-6l26.6-30.5c12.7-14.6 35.4-14.6 48.2 0L242.7 506zM27.3 462.1c-1.2 1.2-2.9 1.9-4.7 1.9c-3.7 0-6.6-3-6.6-6.6V192C16 94.8 94.8 16 192 16s176 78.8 176 176V457.4c0 3.7-3 6.6-6.6 6.6c-1.8 0-3.4-.7-4.7-1.9l-2.3-2.3c-19-19-50.2-18-67.9 2.3l-29.3 33.4c-.3 .4-.8 .6-1.2 .6s-.9-.2-1.2-.6L228.1 465c-19.1-21.9-53.1-21.9-72.2 0l-26.6 30.5c-.3 .4-.8 .6-1.2 .6s-.9-.2-1.2-.6L97.5 462c-17.7-20.2-48.9-21.3-67.9-2.3l-2.3 2.3zM128 216a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM88 192a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm192 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-24-40a40 40 0 1 0 0 80 40 40 0 1 0 0-80z"],
    "face-anguished": [512, 512, [], "e369", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm251.8 64h8.4c46.3 0 83.8 37.5 83.8 83.8c0 6.7-5.5 12.2-12.2 12.2H180.2c-6.7 0-12.2-5.5-12.2-12.2c0-46.3 37.5-83.8 83.8-83.8zm8.4 16h-8.4c-36.2 0-65.7 28.3-67.7 64H327.9c-2-35.7-31.5-64-67.7-64zM160.4 224a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM200 103.5c.3 4.4-3.1 8.2-7.5 8.5c-32.5 2-61.6 16.5-82.7 38.7c-3 3.2-8.1 3.3-11.3 .3s-3.3-8.1-.3-11.3c23.7-25.1 56.6-41.4 93.3-43.7c4.4-.3 8.2 3.1 8.5 7.5zM319.5 112c-4.4-.3-7.8-4.1-7.5-8.5s4.1-7.8 8.5-7.5c36.7 2.3 69.6 18.6 93.3 43.7c3 3.2 2.9 8.3-.3 11.3s-8.3 2.9-11.3-.3C381.1 128.5 352 114 319.5 112z"],
    "hockey-sticks": [640, 512, [], "f454", "M511.1 11.7c2-3.9 .5-8.8-3.4-10.8s-8.8-.5-10.8 3.4L328.3 330.7H48c-26.5 0-48 21.5-48 48V464c0 26.5 21.5 48 48 48H218.5c20.9 0 40.1-11.7 49.8-30.3l242.9-470zM112 346.7H320L254 474.4c-6.9 13.3-20.6 21.6-35.5 21.6H112V346.7zm-16 0V496H48c-17.7 0-32-14.3-32-32V378.7c0-17.7 14.3-32 32-32H96zm199.2-48L143.1 4.3c-2-3.9-6.9-5.5-10.8-3.4s-5.5 6.9-3.4 10.8l148.3 287h18zM338 416.4l33.7 65.3c9.6 18.6 28.8 30.3 49.8 30.3H592c26.5 0 48-21.5 48-48V378.7c0-26.5-21.5-48-48-48H382.3l-8.3 16H528V496H421.5c-15 0-28.7-8.3-35.5-21.6L347 399l-9 17.4zm254-69.7c17.7 0 32 14.3 32 32V464c0 17.7-14.3 32-32 32H544V346.7h48z"],
    "abacus": [576, 512, [129518], "f640", "M440 48V96h8c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8v40H560V96c0-26.5-21.5-48-48-48H440zM416 160c-17.7 0-32-14.3-32-32s14.3-32 32-32h8V48H280V96h8c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8v40H424V160h-8zM264 96V48H152V96h8c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8v40H264V160h-8c-17.7 0-32-14.3-32-32s14.3-32 32-32h8zM128 160c-17.7 0-32-14.3-32-32s14.3-32 32-32h8V48H64C37.5 48 16 69.5 16 96V200H136V160h-8zM144 32H272 432h80c35.3 0 64 28.7 64 64V208 416c0 35.3-28.7 64-64 64H432 272 144 64c-35.3 0-64-28.7-64-64V208 96C0 60.7 28.7 32 64 32h80zM16 216V416c0 26.5 21.5 48 48 48h72V416h-8c-17.7 0-32-14.3-32-32s14.3-32 32-32h8V320h-8c-17.7 0-32-14.3-32-32s14.3-32 32-32h8V216H16zM152 464H264V416h-8c-17.7 0-32-14.3-32-32s14.3-32 32-32h8V320h-8c-17.7 0-32-14.3-32-32s14.3-32 32-32h8V216H152v40h8c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8v32h8c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8v48zm128-48v48H424V416h-8c-17.7 0-32-14.3-32-32s14.3-32 32-32h8V216H280v40h8c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8v32h8c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8zm160-64h8c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8v48h72c26.5 0 48-21.5 48-48V216H440V352zM128 112c-8.8 0-16 7.2-16 16s7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H128zM112 288c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H128c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16s7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H128zM240 128c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H256c-8.8 0-16 7.2-16 16zm16 144c-8.8 0-16 7.2-16 16s7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H256zM240 384c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H256c-8.8 0-16 7.2-16 16zM416 112c-8.8 0-16 7.2-16 16s7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H416zM400 384c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H416c-8.8 0-16 7.2-16 16z"],
    "film-simple": [512, 512, ["film-alt"], "f3a0", "M112 104V48H64C37.5 48 16 69.5 16 96v8h96zM16 120v80h96V120H16zM0 216v-8-8V120v-8-8V96C0 60.7 28.7 32 64 32h48 8 8H384h8 8 48c35.3 0 64 28.7 64 64v8 8 8 80 8 8 80 8 8 80 8 8 8c0 35.3-28.7 64-64 64H400h-8-8H128h-8-8H64c-35.3 0-64-28.7-64-64v-8-8-8V312v-8-8V216zm16 80h96V216H16v80zm0 16v80h96V312H16zm96 96H16v8c0 26.5 21.5 48 48 48h48V408zm16 56H384V400 304 208 112 48H128v64 96 96 96 64zM400 48v56h96V96c0-26.5-21.5-48-48-48H400zm96 72H400v80h96V120zm0 96H400v80h96V216zm0 96H400v80h96V312zm0 96H400v56h48c26.5 0 48-21.5 48-48v-8z"],
    "list": [512, 512, ["list-squares"], "f03a", "M40 64c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8H88c4.4 0 8-3.6 8-8V72c0-4.4-3.6-8-8-8H40zM16 72c0-13.3 10.7-24 24-24H88c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V72zM176 88H496c4.4 0 8 3.6 8 8s-3.6 8-8 8H176c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 160H496c4.4 0 8 3.6 8 8s-3.6 8-8 8H176c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 160H496c4.4 0 8 3.6 8 8s-3.6 8-8 8H176c-4.4 0-8-3.6-8-8s3.6-8 8-8zM88 224H40c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8H88c4.4 0 8-3.6 8-8V232c0-4.4-3.6-8-8-8zM40 208H88c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V232c0-13.3 10.7-24 24-24zm0 176c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8H88c4.4 0 8-3.6 8-8V392c0-4.4-3.6-8-8-8H40zm-24 8c0-13.3 10.7-24 24-24H88c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V392z"],
    "tree-palm": [576, 512, [127796], "f82b", "M168 16c77.7 0 122.4 37.2 141.2 73.1c1 1.9 2.7 3.3 4.8 3.9s4.3 .4 6.1-.6C342.6 80.2 371.7 72 408 72c96 0 141.6 56.9 150.4 97.8c.3 1.6-.1 2.9-1.1 4c-1.1 1.2-3 2.1-5.3 2.1H492.5l-21.7-36.1c-1.4-2.4-4.1-3.9-6.9-3.9s-5.4 1.5-6.9 3.9L435.5 176H328 265.1c-2.1 0-4.2 .9-5.7 2.4L107.2 333.7c-1.6 1.6-3.5 2.3-5.1 2.2c-1.4-.1-2.7-.7-3.6-2.1c-21.9-34.1-30.7-101.7 29-162.6c.6-.6 1.2-1.3 1.9-1.9c32-31.7 65.6-43.6 94.8-44.5c4.4-.1 7.8-3.9 7.7-8.3s-3.8-8-8.1-7.8c-16.2 .5-33.3 3.9-50.7 11.3H116.5L94.9 83.9c-1.4-2.4-4-3.9-6.9-3.9s-5.4 1.5-6.9 3.9L59.5 120H24c-2.3 0-4.1-.9-5.3-2.1c-1-1.1-1.5-2.5-1.1-4C26.4 72.9 72 16 168 16zM112 136h32.3c-9.1 6.3-18.2 13.9-27.1 22.9l-1 1C50.9 226.5 59.4 302.4 85.1 342.4c8.2 12.7 24.6 11.6 33.5 2.4l121.6-124c2.4 10.9 4.3 23.7 5.3 38.4c3.5 49.4-2.3 119.6-27.9 211.3c-5.7 20.5 9.4 41.5 31.1 41.5h82.2c16 0 30-12 31.3-28.5c7.5-98.1-14.3-210.3-46.3-291.5H298.5c32.3 79.2 55.1 192.2 47.6 290.3c-.6 7.7-7.2 13.7-15.3 13.7H248.6C238 496 230 485.5 233 474.8c26-93 32.2-165.1 28.5-216.7c-1.4-19.8-4.3-36.7-8.1-50.7L268.5 192H328 440c2.8 0 5.4-1.5 6.9-3.9L464 159.5l17.1 28.6c1.4 2.4 4 3.9 6.9 3.9h64c12.7 0 25.2-10.8 22-25.5C563.6 117.8 511.2 56 408 56c-35.3 0-64.7 7.2-88.5 18.7C296 36 246.8 0 168 0C64.8 0 12.4 61.8 2 110.5C-1.2 125.2 11.3 136 24 136H64c2.8 0 5.4-1.5 6.9-3.9L88 103.5l17.1 28.6c1.4 2.4 4 3.9 6.9 3.9z"],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zm64 48c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96zM291.2 136.4l44 12c5.2 1.4 8.8 6.2 8.8 11.6c0 119.3-96.7 216-216 216c-5.4 0-10.2-3.6-11.6-8.8l-12-44c-1.6-5.8 1.4-11.9 7-14.2l48-20c4.9-2 10.5-.6 13.9 3.5l20.2 24.7c2.3 2.8 6.3 3.7 9.6 2.2c36.9-17.4 66.7-47.3 84.2-84.2c1.6-3.3 .7-7.3-2.2-9.6l-24.7-20.2c-4.1-3.4-5.5-9-3.5-13.9l20-48c2.3-5.6 8.4-8.5 14.2-7zm-29 .8l-20 48c-4.8 11.4-1.5 24.6 8.1 32.4L270 233.8c-15.2 29.1-39.1 53-68.2 68.2l-16.1-19.7c-7.8-9.6-21-12.9-32.4-8.1l-48 20c-13 5.4-19.9 19.6-16.2 33.2l12 44c3.3 12.2 14.4 20.6 27 20.6c128.1 0 232-103.9 232-232c0-12.6-8.5-23.7-20.6-27l-44-12c-13.6-3.7-27.8 3.3-33.2 16.2z"],
    "cart-plus": [576, 512, [], "f217", "M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8H45.7C57.1 16 67 24.1 69.2 35.4l59.4 303.4c5.1 26.3 28.2 45.2 55 45.2H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H183.5c-19.1 0-35.6-13.5-39.3-32.3L134.9 288h339c26 0 48.6-17.9 54.5-43.3L575.8 41.8c1-4.3-1.7-8.6-6-9.6s-8.6 1.7-9.6 6L512.9 241.1c-4.2 18.1-20.4 30.9-39 30.9H131.8L84.9 32.3C81.2 13.5 64.8 0 45.7 0H8zM144 464a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm240-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM232 144c0 4.4 3.6 8 8 8h72v72c0 4.4 3.6 8 8 8s8-3.6 8-8V152h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H328V64c0-4.4-3.6-8-8-8s-8 3.6-8 8v72H240c-4.4 0-8 3.6-8 8z"],
    "gamepad": [640, 512, [], "f11b", "M192 80C94.8 80 16 158.8 16 256s78.8 176 176 176H448c97.2 0 176-78.8 176-176s-78.8-176-176-176H192zM0 256C0 150 86 64 192 64H448c106 0 192 86 192 192s-86 192-192 192H192C86 448 0 362 0 256zm200-64v56h56c4.4 0 8 3.6 8 8s-3.6 8-8 8H200v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V264H128c-4.4 0-8-3.6-8-8s3.6-8 8-8h56V192c0-4.4 3.6-8 8-8s8 3.6 8 8zM392 304a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm40 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm64-160a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "border-center-v": [448, 512, [], "f89d", "M216 472c0 4.4 3.6 8 8 8s8-3.6 8-8l0-432c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 432zM48 448a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm384 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM48 352a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm384 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM400 160a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM48 160a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm352 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM48 256a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM400 64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM16 64a16 16 0 1 0 32 0A16 16 0 1 0 16 64zM304 256a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM336 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM304 448a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zM144 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM112 448a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm32-192a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "circle-dot": [512, 512, [128280, "dot-circle"], "f192", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm336 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-176 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z"],
    "clipboard-medical": [384, 512, [], "e133", "M192 0c-37.1 0-67.6 28-71.6 64H112C91.1 64 73.3 77.4 66.7 96H64C28.7 96 0 124.7 0 160V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64h-2.7c-6.6-18.6-24.4-32-45.3-32h-8.4c-4-36-34.5-64-71.6-64zM16 160c0-26.5 21.5-48 48-48v16c0 17.7 14.3 32 32 32H288c17.7 0 32-14.3 32-32V112c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V160zM136 72c0-30.9 25.1-56 56-56s56 25.1 56 56c0 4.4 3.6 8 8 8h16c17.7 0 32 14.3 32 32v16c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V112c0-17.7 14.3-32 32-32h16c4.4 0 8-3.6 8-8zm56 24a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM168 232c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H224c-4.4 0-8 3.6-8 8v56c0 4.4-3.6 8-8 8H176c-4.4 0-8-3.6-8-8V352c0-4.4-3.6-8-8-8H104c-4.4 0-8-3.6-8-8V304c0-4.4 3.6-8 8-8h56c4.4 0 8-3.6 8-8V232zm8-24c-13.3 0-24 10.7-24 24v48H104c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h48v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V360h48c13.3 0 24-10.7 24-24V304c0-13.3-10.7-24-24-24H232V232c0-13.3-10.7-24-24-24H176z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm200 96a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm56 72a72 72 0 1 1 0-144 72 72 0 1 1 0 144zM106.3 138.3c3.1-3.1 8.2-3.1 11.3 0L160 180.7l42.3-42.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L171.3 192l42.3 42.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L160 203.3l-42.3 42.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L148.7 192l-42.3-42.3c-3.1-3.1-3.1-8.2 0-11.3zm192 0c3.1-3.1 8.2-3.1 11.3 0L352 180.7l42.3-42.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L363.3 192l42.3 42.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L352 203.3l-42.3 42.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L340.7 192l-42.3-42.3c-3.1-3.1-3.1-8.2 0-11.3z"],
    "egg": [384, 512, [129370], "f7fb", "M192 480C96.4 480 16 386.9 16 288c0-53.4 15.4-118.6 45.8-169.8C92.1 66.9 135.7 32 192 32s99.9 34.9 130.2 86.2C352.6 169.4 368 234.6 368 288c0 98.9-80.4 192-176 192zM0 288C0 394 86 496 192 496s192-102 192-208c0-112-64-272-192-272S0 176 0 288zM141.4 120.1c3.3-3 3.5-8 .5-11.3s-8-3.5-11.3-.5c-22.6 20.6-39.2 50.2-50.1 80.9C69.5 220 64 252.6 64 280c0 4.4 3.6 8 8 8s8-3.6 8-8c0-25.4 5.2-56.3 15.5-85.4c10.4-29.2 25.8-56.2 45.9-74.5z"],
    "up-to-line": [384, 512, ["arrow-alt-to-top"], "f34d", "M8 40H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H8c-4.4 0-8 3.6-8 8s3.6 8 8 8zM184 147.3c2.1-2.1 5-3.3 8-3.3s5.9 1.2 8 3.3L331.8 279.4c2.7 2.7 4.2 6.4 4.2 10.2c0 8-6.5 14.4-14.4 14.4H248c-4.4 0-8 3.6-8 8V448c0 8.8-7.2 16-16 16H160c-8.8 0-16-7.2-16-16V312c0-4.4-3.6-8-8-8H62.4c-8 0-14.4-6.5-14.4-14.4c0-3.8 1.5-7.5 4.2-10.2L184 147.3zm8-19.3c-7.2 0-14.2 2.9-19.3 8L40.9 268.1c-5.7 5.7-8.9 13.4-8.9 21.5C32 306.4 45.6 320 62.4 320H128V448c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V320h65.6c16.8 0 30.4-13.6 30.4-30.4c0-8.1-3.2-15.8-8.9-21.5L211.3 136c-5.1-5.1-12.1-8-19.3-8z"],
    "house-medical-circle-xmark": [640, 512, [], "e513", "M282.7 2c3-2.7 7.6-2.7 10.6 0l215 190.4c-4.1-.3-8.2-.4-12.3-.4c-4 0-8 .1-11.9 .4L288 18.7 80 202.9V448c0 26.5 21.5 48 48 48H375.2c6.1 5.8 12.7 11.1 19.6 16H128c-35.3 0-64-28.7-64-64V217.1L13.3 262c-3.3 2.9-8.4 2.6-11.3-.7S-.6 252.9 2.7 250L282.7 2zm84.6 246c-4.7 5.1-9.1 10.4-13.3 16H320c-4.4 0-8-3.6-8-8V200c0-4.4-3.6-8-8-8H272c-4.4 0-8 3.6-8 8v56c0 4.4-3.6 8-8 8H200c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h56c4.4 0 8 3.6 8 8v56c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8h8.2c.2 5.5 .7 10.9 1.5 16.3C317.3 397 311 400 304 400H272c-13.3 0-24-10.7-24-24V328H200c-13.3 0-24-10.7-24-24V272c0-13.3 10.7-24 24-24h48V200c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v48h39.3zM624 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm155.3 0l50.3 50.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L496 379.3l-50.3 50.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L484.7 368l-50.3-50.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L496 356.7l50.3-50.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L507.3 368z"],
    "watch-fitness": [384, 512, [], "f63e", "M80 40V64H304l0-24c0-13.3-10.7-24-24-24H104C90.7 16 80 26.7 80 40zM64 65.6V40C64 17.9 81.9 0 104 0H280c22.1 0 40 17.9 40 40V65.6c36.5 7.4 64 39.7 64 78.4V368c0 38.7-27.5 71-64 78.4V472c0 22.1-17.9 40-40 40l-176 0c-22.1 0-40-17.9-40-40l0-25.6C27.5 439 0 406.7 0 368V144c0-38.7 27.5-71 64-78.4zM80 472c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24V448H80l0 24zm224-40c35.3 0 64-28.7 64-64V144c0-35.3-28.7-64-64-64H80c-35.3 0-64 28.7-64 64V368c0 35.3 28.6 64 63.9 64l.1 0H304zM96 217.9v.6c0 10.6 4 20.9 11.2 28.8l78.9 86.1c1.5 1.7 3.7 2.6 5.9 2.6s4.4-.9 5.9-2.6l78.9-86.1c7.2-7.8 11.2-18.1 11.2-28.8v-.6c0-23.2-18.8-41.9-41.9-41.9c-11.1 0-21.8 4.4-29.7 12.3L197.7 207c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3l-18.7-18.7c-7.9-7.9-18.5-12.3-29.7-12.3C114.8 176 96 194.8 96 217.9zM137.9 160c15.4 0 30.1 6.1 41 17L192 190.1 205.1 177c10.9-10.9 25.6-17 41-17c32 0 57.9 25.9 57.9 57.9v.6c0 14.7-5.5 28.8-15.4 39.6l-78.9 86.1c-4.5 5-11 7.8-17.7 7.8s-13.1-2.8-17.7-7.8L95.4 258.1C85.5 247.3 80 233.2 80 218.6v-.6c0-32 25.9-57.9 57.9-57.9z"],
    "clock-nine-thirty": [512, 512, [], "e34d", "M16 256a240 240 0 1 1 480 0A240 240 0 1 1 16 256zm496 0A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM264 408V256c0-4.4-3.6-8-8-8H136c-4.4 0-8 3.6-8 8s3.6 8 8 8H248V408c0 4.4 3.6 8 8 8s8-3.6 8-8z"],
    "campground": [576, 512, [9978], "f6bb", "M397.2 1.9c3.4 2.9 3.8 7.9 .9 11.3L298.5 131 530.8 405.8c8.5 10.1 13.2 22.9 13.2 36.2V472c0 22.1-17.9 40-40 40H288 72c-22.1 0-40-17.9-40-40V441.9c0-13.2 4.7-26 13.2-36.2L277.5 131 177.9 13.2c-2.9-3.4-2.4-8.4 .9-11.3s8.4-2.4 11.3 .9L288 118.6 385.9 2.8c2.9-3.4 7.9-3.8 11.3-.9zM57.5 416.1c-6.1 7.2-9.5 16.4-9.5 25.8V472c0 13.3 10.7 24 24 24h68.1L281.7 315.1c1.5-1.9 3.8-3.1 6.3-3.1s4.8 1.1 6.3 3.1L435.9 496H504c13.3 0 24-10.7 24-24V441.9c0-9.5-3.4-18.6-9.5-25.8L288 143.4 57.5 416.1zm103 79.9H288 415.6L288 333 160.4 496z"],
    "folder-plus": [512, 512, [], "f65e", "M496 416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H197.5c12.7 0 24.9 5.1 33.9 14.1l35.9 35.9c9 9 21.2 14.1 33.9 14.1H448c26.5 0 48 21.5 48 48V416zM64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H301.3c-8.5 0-16.6-3.4-22.6-9.4L242.7 50.7c-12-12-28.3-18.7-45.3-18.7H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64zm184-96c0 4.4 3.6 8 8 8s8-3.6 8-8V296h88c4.4 0 8-3.6 8-8s-3.6-8-8-8H264V192c0-4.4-3.6-8-8-8s-8 3.6-8 8v88H160c-4.4 0-8 3.6-8 8s3.6 8 8 8h88v88z"],
    "jug": [448, 512, [], "f8c6", "M288 16c8.8 0 16 7.2 16 16s-7.2 16-16 16H160c-8.8 0-16-7.2-16-16s7.2-16 16-16H288zM128 32c0 11.8 6.4 22.2 16 27.7V64 85c0 7.1-2.4 14-6.7 19.6L59 205.3c-17.5 22.5-27 50.1-27 78.6V448c0 35.3 28.7 64 64 64H352c35.3 0 64-28.7 64-64V283.9c0-21.8-5.6-43.1-16-61.9c27.6-7.1 48-32.2 48-62c0-35.3-28.7-64-64-64c-23.6 0-44.2 12.8-55.3 31.8l-18-23.1C306.4 99 304 92.1 304 85V64 59.7c9.6-5.5 16-15.9 16-27.7c0-17.7-14.3-32-32-32H160c-17.7 0-32 14.3-32 32zm32 32H288V85c0 10.7 3.6 21 10.1 29.5l78.3 100.7C391.7 234.8 400 259 400 283.9V448c0 26.5-21.5 48-48 48H96c-26.5 0-48-21.5-48-48V283.9c0-24.9 8.3-49.1 23.6-68.8l78.3-100.7C156.4 106.1 160 95.7 160 85V64zM390.7 207.5c-.5-.7-1.1-1.5-1.7-2.2l-49.4-63.6c7.2-17.5 24.4-29.8 44.4-29.8c26.5 0 48 21.5 48 48c0 24.2-18 44.3-41.3 47.5zM128 304H320c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H128c-8.8 0-16-7.2-16-16V320c0-8.8 7.2-16 16-16zM96 320v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V320c0-17.7-14.3-32-32-32H128c-17.7 0-32 14.3-32 32z"],
    "futbol": [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", "M307.2 490.5c0 0 0-.1 0-.1l24.5-96.7c.1-.3 .2-.7 .3-1c2-7 2.7-14.9-1.6-20.7l-22.7-31.2c-1.5-2-4.1-4-6.6-3.6c-1.1 .2-2.3 .2-3.4 .2H214.3c-1.2 0-2.3-.1-3.4-.2c-2.5-.4-5.1 1.6-6.6 3.6L181.6 372c-4.3 5.9-3.6 13.8-1.6 20.7c.1 .3 .2 .7 .3 1l24.5 96.7c0 .1 0 .1 0 .1c16.5 3.6 33.6 5.5 51.2 5.5s34.7-1.9 51.2-5.5zm17.7-4.5c52.8-15.8 97.9-49.2 128.6-93.4l-90.9-6c-3.4-.2-6.8 .7-9.5 2.7l-.1 .1-.1 .1c-2.7 2-4.7 4.9-5.5 8.2L324.8 486zM463.2 377.2c17.1-29.1 28.2-62.1 31.6-97.4c0 0-.1 0-.1-.1l-84.4-53.1c-.3-.2-.6-.4-.9-.6c-6-4.1-13.3-7.1-20.2-4.9L352.6 233c-2.4 .8-5.1 2.7-5.5 5.2c-.2 1.1-.5 2.2-.8 3.3l-25.8 79.3c-.4 1.1-.8 2.2-1.3 3.2c-1.1 2.2-.1 5.4 1.4 7.4l22.7 31.2c4.3 5.9 12 7.7 19.2 7.9c.3 0 .7 0 1 .1l99.5 6.6c0 0 .1 0 .1 0zm32.7-115.6c0-1.8 .1-3.7 .1-5.5c0-54.7-18.3-105.2-49.1-145.5L413 195c-1.3 3.2-1.4 6.8-.3 10.1s3.3 6.1 6.2 7.9l77.1 48.5zM435.2 96.4c-22.8-25.6-51-46.3-82.8-60.2c0 0-.1 .1-.1 .1l-76.6 63.8c-.3 .2-.5 .4-.8 .6c-5.7 4.4-10.9 10.5-10.9 17.7l0 38.5c0 2.5 1 5.6 3.2 6.8c1 .5 2 1.1 2.9 1.8l67.5 49c.9 .7 1.8 1.4 2.6 2.2c1.8 1.7 5.1 1.7 7.5 1l36.7-11.9c6.9-2.2 11-9 13.5-15.8c.1-.3 .2-.6 .4-1l37-92.6c0 0 0-.1 0-.1zM335.5 29.5C310.6 20.7 283.9 16 256 16s-54.6 4.7-79.5 13.5l70 58.3c2.7 2.2 6 3.4 9.5 3.4s6.8-1.2 9.5-3.4l70-58.3zM159.6 36.2c-31.8 14-60 34.6-82.8 60.2c0 0 0 .1 0 .1l37 92.6c.1 .3 .3 .6 .4 1c2.5 6.8 6.6 13.6 13.5 15.8l36.7 11.9c2.4 .8 5.7 .8 7.5-1c.8-.8 1.7-1.5 2.6-2.2l67.5-49c.9-.7 1.9-1.3 2.9-1.8c2.2-1.2 3.2-4.3 3.2-6.8V118.5c0-7.2-5.2-13.3-10.9-17.7c-.3-.2-.5-.4-.8-.6L159.7 36.3c0 0-.1-.1-.1-.1zM65.1 110.5C34.3 150.8 16 201.3 16 256c0 1.9 0 3.7 .1 5.5L93.1 213c2.9-1.8 5.1-4.7 6.2-7.9s1-6.9-.3-10.1L65.1 110.5zm-48 169.3C20.6 315 31.7 348 48.8 377.2c0 0 .1 0 .1 0l99.5-6.6c.3 0 .7 0 1-.1c7.2-.2 15-2.1 19.2-7.9l22.7-31.2c1.5-2 2.5-5.1 1.4-7.4c-.5-1-.9-2.1-1.3-3.2l-25.8-79.3c-.4-1.1-.6-2.2-.8-3.3c-.4-2.5-3.1-4.4-5.5-5.2l-36.7-11.9c-6.9-2.2-14.2 .8-20.2 4.9c-.3 .2-.6 .4-.9 .6L17.3 279.7c0 0-.1 0-.1 .1zM58.6 392.5c30.7 44.2 75.8 77.7 128.6 93.4l-22.3-88.4c-.8-3.3-2.8-6.2-5.5-8.3l-.1-.1-.1-.1c-2.8-2-6.2-2.9-9.6-2.7l-90.9 6zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm251.3-77.4l-67.5 49c-2.8 2-4 5.6-2.9 8.9l25.8 79.4c1.1 3.3 4.1 5.5 7.6 5.5l83.4 0c3.5 0 6.5-2.2 7.6-5.5l25.8-79.4c1.1-3.3-.1-6.9-2.9-8.9l-67.5-49c-2.8-2-6.6-2-9.4 0z"],
    "snow-blowing": [640, 512, [], "f761", "M184 72c0-4.4-3.6-8-8-8s-8 3.6-8 8v52.7L133.7 90.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L168 147.3v94.8L85.9 194.7 69.2 132.4c-1.1-4.3-5.5-6.8-9.8-5.7s-6.8 5.5-5.7 9.8l12.6 46.9L20.7 157.1c-3.8-2.2-8.7-.9-10.9 2.9s-.9 8.7 2.9 10.9l45.6 26.3L11.4 209.8c-4.3 1.1-6.8 5.5-5.7 9.8s5.5 6.8 9.8 5.7l62.4-16.7L160 256 77.9 303.4 15.5 286.7c-4.3-1.1-8.7 1.4-9.8 5.7s1.4 8.7 5.7 9.8l46.9 12.6L12.7 341.1c-3.8 2.2-5.1 7.1-2.9 10.9s7.1 5.1 10.9 2.9l45.6-26.3L53.7 375.5c-1.1 4.3 1.4 8.7 5.7 9.8s8.7-1.4 9.8-5.7l16.7-62.4L168 269.9v94.8l-45.7 45.7c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L168 387.3V440c0 4.4 3.6 8 8 8s8-3.6 8-8V387.3l34.3 34.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L184 364.7V269.9l82.1 47.4 16.7 62.4c1.1 4.3 5.5 6.8 9.8 5.7s6.8-5.5 5.7-9.8l-12.6-46.9 45.6 26.3c3.8 2.2 8.7 .9 10.9-2.9s.9-8.7-2.9-10.9l-45.6-26.3 46.9-12.6c4.3-1.1 6.8-5.5 5.7-9.8s-5.5-6.8-9.8-5.7l-62.4 16.7L192 256l82.1-47.4 62.4 16.7c4.3 1.1 8.7-1.4 9.8-5.7s-1.4-8.7-5.7-9.8l-46.9-12.6 45.6-26.3c3.8-2.2 5.1-7.1 2.9-10.9s-7.1-5.1-10.9-2.9l-45.6 26.3 12.6-46.9c1.1-4.3-1.4-8.7-5.7-9.8s-8.7 1.4-9.8 5.7l-16.7 62.4L184 242.1V147.3l45.7-45.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L184 124.7V72zm296 0c0 4.4 3.6 8 8 8h72c35.3 0 64 28.7 64 64s-28.7 64-64 64H392c-4.4 0-8 3.6-8 8s3.6 8 8 8H560c44.2 0 80-35.8 80-80s-35.8-80-80-80H488c-4.4 0-8 3.6-8 8zm0 368c0 4.4 3.6 8 8 8h72c44.2 0 80-35.8 80-80s-35.8-80-80-80H392c-4.4 0-8 3.6-8 8s3.6 8 8 8H560c35.3 0 64 28.7 64 64s-28.7 64-64 64H488c-4.4 0-8 3.6-8 8z"],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", "M295.7 376c-10.6 0-20.9-1.7-30.5-4.9l0-.1c-1.6-.5-3.1-1.1-4.6-1.7l-53.8-53.8c-.6-1.5-1.2-3.1-1.7-4.6l-.1 0c-3.2-9.6-5-19.8-5-30.5c0-30.6 14.6-59.4 39.4-77.4L483.7 25.2c19.1-13.9 45.5-11.8 62.2 4.9s18.8 43.1 4.9 62.2L373.1 336.6c-18 24.8-46.8 39.4-77.4 39.4zm-43 8c2.2 7.6 3.3 15.7 3.3 24c0 46.3-35.7 84.2-81.1 87.7c-.7 .1-1.3 .1-1.9 .3h-5H32c-8.8 0-16-7.2-16-16s7.2-16 16-16h4c14.6 0 26.2-7.7 33.6-17.4c7.3-9.6 11.2-22 10.6-34.3c-.1-1.4-.1-2.8-.1-4.3c0-48.6 39.4-88 88-88c8.3 0 16.4 1.2 24 3.3L252.7 384zm17.6 5.1c8.2 1.9 16.7 2.9 25.4 2.9c35.7 0 69.3-17.1 90.4-46L563.7 101.6c18.5-25.5 15.8-60.6-6.5-82.9s-57.4-25-82.9-6.5L230 190c-28.9 21-46 54.6-46 90.3c0 8.7 1 17.3 2.9 25.4c-6.1-1.1-12.4-1.7-18.9-1.7c-57.4 0-104 46.6-104 104c0 1.7 0 3.4 .1 5c.8 17.1-11 35-28.2 35H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H168h7.8c.1 0 .2-.1 .2-.2s.1-.2 .1-.2c53.6-4.2 95.9-49 95.9-103.7c0-6.5-.6-12.8-1.7-18.9z"],
    "lock": [448, 512, [128274], "f023", "M112 128v64H336V128c0-61.9-50.1-112-112-112s-112 50.1-112 112zM96 192V128C96 57.3 153.3 0 224 0s128 57.3 128 128v64h32c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256c0-35.3 28.7-64 64-64H96zm0 16H64c-26.5 0-48 21.5-48 48V448c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V256c0-26.5-21.5-48-48-48H352 336 112 96z"],
    "arrow-down-from-line": [384, 512, [8615, "arrow-from-top"], "f345", "M197.7 477.7c-3.1 3.1-8.2 3.1-11.3 0l-136-136c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L184 452.7V136c0-4.4 3.6-8 8-8s8 3.6 8 8V452.7L322.3 330.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-136 136zM8 48c-4.4 0-8-3.6-8-8s3.6-8 8-8H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H8z"],
    "gas-pump": [512, 512, [9981], "f52f", "M256 16H96C69.5 16 48 37.5 48 64V416H304V64c0-26.5-21.5-48-48-48zM48 496H304V432H48v64zm296 16H320 304 48 32 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32V64C32 28.7 60.7 0 96 0H256c35.3 0 64 28.7 64 64V272h8c39.8 0 72 32.2 72 72v40c0 26.5 21.5 48 48 48s48-21.5 48-48V224h-8c-30.9 0-56-25.1-56-56V72.9l-29.4-27c-3.3-3-3.5-8-.5-11.3s8-3.5 11.3-.5l80.4 73.7c11.6 10.6 18.2 25.6 18.2 41.3V384c0 35.3-28.7 64-64 64s-64-28.7-64-64V344c0-30.9-25.1-56-56-56h-8V496h24c4.4 0 8 3.6 8 8s-3.6 8-8 8zM496 149.1c0-11.2-4.7-21.9-13-29.5L448 87.5V168c0 22.1 17.9 40 40 40h8V149.1zM128 80c-8.8 0-16 7.2-16 16v96c0 8.8 7.2 16 16 16h96c8.8 0 16-7.2 16-16V96c0-8.8-7.2-16-16-16H128zM96 96c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32H128c-17.7 0-32-14.3-32-32V96z"],
    "signal-bars-slash": [640, 512, ["signal-alt-slash"], "f694", "M448 176c0-26.5-21.5-48-48-48s-48 21.5-48 48v13.5l16 12.6V176c0-17.7 14.3-32 32-32s32 14.3 32 32v76.7l16 12.6V176zM368 464V385.6L352 373v91c0 26.5 21.5 48 48 48s48-21.5 48-48V448.8l-16-12.6V464c0 17.7-14.3 32-32 32s-32-14.3-32-32zM192 304V464c0 26.5 21.5 48 48 48s48-21.5 48-48V322.5l-16-12.6V464c0 17.7-14.3 32-32 32s-32-14.3-32-32V304c0-13.2 8-24.5 19.4-29.4l-13.6-10.8C200.6 272.4 192 287.2 192 304zm336 24.5V48c0-17.7 14.3-32 32-32s32 14.3 32 32V379l16 12.6V48c0-26.5-21.5-48-48-48s-48 21.5-48 48V315.8l16 12.6zM80 400c17.7 0 32 14.3 32 32v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V432c0-17.7 14.3-32 32-32zM32 432v32c0 26.5 21.5 48 48 48s48-21.5 48-48V432c0-26.5-21.5-48-48-48s-48 21.5-48 48zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "monkey": [576, 512, [128018], "f6fb", "M104 16c-48.6 0-88 39.4-88 88V376c0 66.3 53.7 120 120 120h40V431c0-97.8 61-184.5 151.8-218c-10.2-13.1-17.6-28.5-21.2-45.3C278.2 165 256 141.1 256 112c0-30.9 25.1-56 56-56h7c19.4-33.5 55.6-56 97-56s77.7 22.5 97 56h7c30.9 0 56 25.1 56 56c0 29.1-22.2 53-50.5 55.7C514.6 218.2 469.7 256 416 256c-29.6 0-56.5-11.5-76.5-30.2C251.6 255.3 192 337.8 192 431v65H480c8.8 0 16-7.2 16-16s-7.2-16-16-16H440c-4.2 0-7.6-3.2-8-7.3l-.7-8c-3.8-45.6-41.9-80.7-87.7-80.7H328c-4.4 0-8-3.6-8-8s3.6-8 8-8h15.7c37.1 0 69.9 19.5 88.3 49.1V296c0-3.3 2-6.2 5-7.4s6.5-.4 8.8 2l93.2 99c23.7 25.2 37 58.6 37 93.2V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V482.8c0-30.6-11.7-60-32.6-82.2L448 316.2V448h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H136C60.9 512 0 451.1 0 376V104C0 46.6 46.6 0 104 0h32c48.6 0 88 39.4 88 88s-39.4 88-88 88H104c-4.4 0-8-3.6-8-8s3.6-8 8-8h32c39.8 0 72-32.2 72-72s-32.2-72-72-72H104zM512 144V112c0-53-43-96-96-96s-96 43-96 96v32c0 53 43 96 96 96s96-43 96-96zM311.4 72c-21.8 .3-39.4 18.1-39.4 40c0 19.4 13.9 35.6 32.2 39.2c-.2-2.4-.2-4.8-.2-7.2V112c0-14.1 2.6-27.6 7.4-40zM528 112v32c0 2.4-.1 4.9-.2 7.2c18.4-3.6 32.2-19.8 32.2-39.2c0-21.9-17.6-39.6-39.4-40c4.7 12.4 7.4 25.9 7.4 40zm-160 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-96 16c0 17.4 11.1 32.2 26.7 37.7c3.2 1.1 5.3 4.2 5.3 7.5V168c0 17.7 14.3 32 32 32s32-14.3 32-32V157.3c0-3.4 2.1-6.4 5.3-7.5c15.5-5.5 26.7-20.3 26.7-37.7c0-22.1-17.9-40-40-40H392c-22.1 0-40 17.9-40 40zm40-56h48c30.9 0 56 25.1 56 56c0 22.3-13.1 41.6-32 50.6V168c0 26.5-21.5 48-48 48s-48-21.5-48-48v-5.4c-18.9-9-32-28.3-32-50.6c0-30.9 25.1-56 56-56z"],
    "rectangle-pro": [640, 512, ["pro"], "e235", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H576c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H576c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm88 64h56c30.9 0 56 25.1 56 56s-25.1 56-56 56H96v72c0 4.4-3.6 8-8 8s-8-3.6-8-8V264 168c0-4.4 3.6-8 8-8zm56 96c22.1 0 40-17.9 40-40s-17.9-40-40-40H96v80h48zm264-24c0-39.8 32.2-72 72-72s72 32.2 72 72v48c0 39.8-32.2 72-72 72s-72-32.2-72-72V232zm72-56c-30.9 0-56 25.1-56 56v48c0 30.9 25.1 56 56 56s56-25.1 56-56V232c0-30.9-25.1-56-56-56zM248 160h56c30.9 0 56 25.1 56 56c0 24.2-15.3 44.8-36.8 52.6l35.9 71.8c2 4 .4 8.8-3.6 10.7s-8.8 .4-10.7-3.6L307 271.9c-1 .1-2 .1-3 .1H256v72c0 4.4-3.6 8-8 8s-8-3.6-8-8V264 168c0-4.4 3.6-8 8-8zm56 96c22.1 0 40-17.9 40-40s-17.9-40-40-40H256v80h48z"],
    "house-night": [640, 512, [], "e010", "M88 88c0 48.6 39.4 88 88 88c2.6 0 5.3-.1 7.9-.3C166.3 195.5 140.6 208 112 208c-53 0-96-43-96-96s43-96 96-96c4.2 0 8.3 .3 12.3 .8C102.3 32.8 88 58.7 88 88zM147.8 5.8C136.6 2.1 124.5 0 112 0C50.1 0 0 50.1 0 112s50.1 112 112 112c41.3 0 77.3-22.3 96.8-55.6c3.9-6.7-4.5-13.7-11.9-11.5c-6.6 2-13.6 3.1-20.8 3.1c-39.8 0-72-32.2-72-72c0-29.2 17.4-54.3 42.3-65.6c7.1-3.2 8.8-14.1 1.5-16.5zM405.2 97.9c-3-2.6-7.4-2.6-10.4 0l-232 200c-3.3 2.9-3.7 7.9-.8 11.3s7.9 3.7 11.3 .8L224 266.3V456c0 30.9 25.1 56 56 56H520c30.9 0 56-25.1 56-56V266.3l50.8 43.8c3.3 2.9 8.4 2.5 11.3-.8s2.5-8.4-.8-11.3l-232-200zM560 252.5V456c0 22.1-17.9 40-40 40H280c-22.1 0-40-17.9-40-40V252.5L400 114.6 560 252.5zM336 296v80c0 13.3 10.7 24 24 24h80c13.3 0 24-10.7 24-24V296c0-13.3-10.7-24-24-24H360c-13.3 0-24 10.7-24 24zm24-8h80c4.4 0 8 3.6 8 8v80c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8V296c0-4.4 3.6-8 8-8zM256 0c-4.4 0-8 3.6-8 8V56H200c-4.4 0-8 3.6-8 8s3.6 8 8 8h48v48c0 4.4 3.6 8 8 8s8-3.6 8-8V72h48c4.4 0 8-3.6 8-8s-3.6-8-8-8H264V8c0-4.4-3.6-8-8-8zM96 320c-4.4 0-8 3.6-8 8v48H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H88v48c0 4.4 3.6 8 8 8s8-3.6 8-8V392h48c4.4 0 8-3.6 8-8s-3.6-8-8-8H104V328c0-4.4-3.6-8-8-8z"],
    "hot-tub-person": [512, 512, ["hot-tub"], "f593", "M248 0c4.4 0 8 3.6 8 8c0 30.6 13.9 59 36.7 75.6l16.1 11.8C336 115.4 352 148.7 352 184c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-30.6-13.9-59-36.7-75.6L283.2 96.5C256 76.6 240 43.3 240 8c0-4.4 3.6-8 8-8zM16 336V448c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V320c0-26.5-21.5-48-48-48H277.3c-1.4 0-2.7 0-4-.1c-.4 .1-.8 .1-1.3 .1H16v48 16zm213.3-80L144 192c-13.8-10.4-30.7-16-48-16c-44.2 0-80 35.8-80 80H229.3zM0 336V320 256c0-53 43-96 96-96c20.8 0 41 6.7 57.6 19.2l85.3 64c11.1 8.3 24.6 12.8 38.4 12.8H448c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V336zM384 8c0 30.6 13.9 59 36.7 75.6l16.1 11.8C464 115.4 480 148.7 480 184c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-30.6-13.9-59-36.7-75.6L411.2 96.5C384 76.6 368 43.3 368 8c0-4.4 3.6-8 8-8s8 3.6 8 8zM112 320c4.4 0 8 3.6 8 8V440c0 4.4-3.6 8-8 8s-8-3.6-8-8V328c0-4.4 3.6-8 8-8zm96 0c4.4 0 8 3.6 8 8V440c0 4.4-3.6 8-8 8s-8-3.6-8-8V328c0-4.4 3.6-8 8-8zm96 0c4.4 0 8 3.6 8 8V440c0 4.4-3.6 8-8 8s-8-3.6-8-8V328c0-4.4 3.6-8 8-8zm96 0c4.4 0 8 3.6 8 8V440c0 4.4-3.6 8-8 8s-8-3.6-8-8V328c0-4.4 3.6-8 8-8zM112 64A48 48 0 1 0 16 64a48 48 0 1 0 96 0zM0 64a64 64 0 1 1 128 0A64 64 0 1 1 0 64z"],
    "blanket": [448, 512, [], "f498", "M16 120V341.4C31.9 318.8 58.2 304 88 304H400c12.3 0 23.5 4.6 32 12.2V120c0-39.8-32.2-72-72-72H88c-39.8 0-72 32.2-72 72zM.4 384H0V120C0 71.4 39.4 32 88 32H360c48.6 0 88 39.4 88 88V352c0 26.5-21.5 48-48 48H88c-4.4 0-8-3.6-8-8s3.6-8 8-8H400c17.7 0 32-14.3 32-32s-14.3-32-32-32H88c-39.8 0-72 32.2-72 72s32.2 72 72 72H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H88c-48.6 0-88-39.4-88-88c0-2.7 .1-5.4 .4-8z"],
    "map-location": [576, 512, ["map-marked"], "f59f", "M392 120c0-57.4-46.6-104-104-104s-104 46.6-104 104c0 10.5 3.6 24.5 10.7 41.2c6.9 16.4 16.6 34.2 27.5 51.9c21.8 35.4 47.6 69.1 63.5 88.9c1.3 1.6 3.4 1.6 4.6 0c15.9-19.8 41.7-53.6 63.5-88.9c10.9-17.7 20.6-35.5 27.5-51.9c7-16.7 10.7-30.7 10.7-41.2zm16 0c0 54.6-73.1 151.9-105.2 192c-7.7 9.6-22 9.6-29.6 0C241.1 271.9 168 174.6 168 120C168 53.7 221.7 0 288 0s120 53.7 120 120zm130.5 27.2L421.1 189.9c1.6-3.4 3.1-6.7 4.5-10.1c1.4-3.3 2.7-6.6 4-10l103.5-37.6c20.9-7.6 42.9 7.9 42.9 30.1V423.2c0 13.5-8.4 25.5-21.1 30.1L394.7 511.5c-1.6 .6-3.4 .6-5.1 .1L184.2 448.4 42.9 499.8C22.1 507.4 0 491.9 0 469.7V208.8c0-13.5 8.4-25.5 21.1-30.1l116.3-42.3c.8 5.3 2 10.5 3.4 15.8L26.5 193.8c-6.3 2.3-10.5 8.3-10.5 15V469.7c0 11.1 11 18.8 21.5 15L176 434.4V296c0-4.4 3.6-8 8-8s8 3.6 8 8V434.1l192 59.1V296c0-4.4 3.6-8 8-8s8 3.6 8 8V492.6l149.5-54.4c6.3-2.3 10.5-8.3 10.5-15V162.3c0-11.1-11-18.8-21.5-15z"],
    "house-flood-water": [576, 512, [], "e50e", "M292.6 1.5c-2.8-1.9-6.4-1.9-9.2 0l-216 152c-3.6 2.5-4.5 7.5-1.9 11.1s7.5 4.5 11.1 1.9L112 141.6V258.5c5.5 1.4 10.9 3.6 16 6.5V130.4L288 17.8 448 130.4V265c5.1-2.9 10.5-5.1 16-6.5V141.6l35.4 24.9c3.6 2.5 8.6 1.7 11.1-1.9s1.7-8.6-1.9-11.1l-216-152zm29.6 352.6c-10.1-9.2-19.6-19.5-27.6-30.7c-3-4.3-10.2-4.3-13.2 0c-8 11.2-17.5 21.4-27.6 30.7C236.6 369.8 214.5 384 192 384s-44.6-14.2-61.8-29.9c-10.1-9.2-19.7-19.5-27.6-30.7c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.3 10.3-15.9 19.6-25 28.3C48.7 366.5 28.3 380.9 7 383.6c-4.4 .6-7.5 4.6-6.9 8.9s4.6 7.5 8.9 6.9c26.5-3.3 50-20.7 66.4-36.1c8.8-8.3 15.9-16.4 20.6-22.2c5.2 6.4 13.2 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8l0 0 0 0c5.2 6.4 13.3 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8c4.7 5.8 11.8 13.9 20.6 22.2c16.4 15.4 39.9 32.8 66.4 36.1c4.4 .6 8.4-2.6 8.9-6.9s-2.6-8.4-6.9-8.9c-21.3-2.7-41.7-17.1-57.4-31.9c-9.1-8.6-17.7-18-25-28.3c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.9 11.2-17.5 21.5-27.6 30.7C428.6 369.8 406.5 384 384 384s-44.6-14.2-61.8-29.9zm-27.6 81.3c-3-4.3-10.2-4.3-13.2 0c-8 11.2-17.5 21.4-27.6 30.7C236.6 481.8 214.5 496 192 496s-44.6-14.2-61.8-29.9c-10.1-9.2-19.7-19.5-27.6-30.7c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.3 10.3-15.9 19.6-25 28.3C48.7 478.5 28.3 492.9 7 495.6c-4.4 .6-7.5 4.6-6.9 8.9s4.6 7.5 8.9 6.9c26.5-3.3 50-20.7 66.4-36.1c8.8-8.3 15.9-16.4 20.6-22.2c5.2 6.4 13.2 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8l0 0 0 0c5.2 6.4 13.3 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8c4.7 5.8 11.8 13.9 20.6 22.2c16.4 15.4 39.9 32.8 66.4 36.1c4.4 .6 8.4-2.6 8.9-6.9s-2.6-8.4-6.9-8.9c-21.3-2.7-41.7-17.1-57.4-31.9c-9.1-8.6-17.7-18-25-28.3c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.9 11.2-17.5 21.5-27.6 30.7C428.6 481.8 406.5 496 384 496s-44.6-14.2-61.8-29.9c-10.1-9.2-19.6-19.5-27.6-30.7z"],
    "comments-question-check": [640, 512, [], "e14f", "M208 16C99.4 16 16 90 16 176c0 36.1 15.1 68.8 38.9 96.5c1.9 2.2 2.4 5.3 1.4 8c-8 21.5-21.4 41.2-40.2 55.4L16 336c28.8 0 57.3-10.1 83.4-23.9c2.3-1.2 5-1.2 7.3-.1c31.7 15.7 65.9 24 101.3 24c108.6 0 192-74 192-160s-83.4-160-192-160zM0 176C0 78.8 93.1 0 208 0S416 78.8 416 176s-93.1 176-208 176c-36.5 0-71.9-8.4-104.7-23.9C76.8 341.7 47 352 16 352c-6.9 0-13.1-4.5-15.2-11.1c-2.1-6.6 .2-13.7 5.7-17.8c14.7-11.2 25.9-26.6 33.1-43.9C15.7 250.1 0 215.2 0 176zm448 0c0-5.2-.2-10.4-.6-15.5C555.1 167.1 640 243.2 640 336c0 39.2-15.7 74.1-39.6 103.2c7.2 17.3 18.4 32.7 33.1 43.9c5.5 4.1 7.9 11.3 5.7 17.8c-2.1 6.6-8.3 11.1-15.2 11.1c-31 0-60.8-10.3-87.3-23.9C503.9 503.6 468.5 512 432 512c-95.7 0-176.2-54.6-200.5-129c5.5-.5 10.9-1.1 16.3-1.9C271 446.3 343 496 432 496c35.3 0 69.6-8.4 101.3-24c2.3-1.1 5-1.1 7.3 .1C566.7 485.9 595.2 496 624 496l-.1-.1c-18.7-14.2-32.2-33.9-40.2-55.4c-1-2.7-.5-5.8 1.4-8C608.9 404.9 624 372.1 624 336c0-81.7-75.3-152.6-176-159.5l0-.5zM185.3 83h39.8c26.2 0 47.5 21.3 47.5 47.5c0 16-8 30.9-21.4 39.7L216 193.4V210c0 4.4-3.6 8-8 8s-8-3.6-8-8V189.1c0-2.7 1.4-5.2 3.6-6.7l38.9-25.6c8.8-5.8 14.2-15.7 14.2-26.3c0-17.4-14.1-31.5-31.5-31.5H185.3c-14.4 0-26 11.6-26 26v4.6c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-4.6c0-23.2 18.8-42 42-42zM208 232.7a11.3 11.3 0 1 1 0 22.7 11.3 11.3 0 1 1 0-22.7zm309.7 63c3.1 3.1 3.1 8.2 0 11.3l-85.3 85.3c-3.1 3.1-8.2 3.1-11.3 0l-42.7-42.7c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l37 37 79.7-79.7c3.1-3.1 8.2-3.1 11.3 0z"],
    "tree": [448, 512, [127794], "f1bb", "M229.7 2.3c-3.1-3.1-8.2-3.1-11.3 0l-147 147c-4.7 4.7-7.3 11-7.3 17.7c0 13.8 11.2 25 25 25h35.7L39.3 277.4c-4.7 4.7-7.3 11-7.3 17.7c0 13.8 11.2 25 25 25H92.7L7.3 405.4C2.6 410.1 0 416.4 0 423c0 13.8 11.2 25 25 25H160h56v56c0 4.4 3.6 8 8 8s8-3.6 8-8V448h56H423c13.8 0 25-11.2 25-25c0-6.6-2.6-13-7.3-17.7L355.3 320H391c13.8 0 25-11.2 25-25c0-6.6-2.6-13-7.3-17.7L323.3 192H359c13.8 0 25-11.2 25-25c0-6.6-2.6-13-7.3-17.7l-147-147zM232 432V200c0-4.4-3.6-8-8-8s-8 3.6-8 8V432H160 25c-5 0-9-4-9-9c0-2.4 .9-4.7 2.6-6.3l99-99c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9H57c-5 0-9-4-9-9c0-2.4 .9-4.7 2.6-6.3l99-99c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9H89c-5 0-9-4-9-9c0-2.4 .9-4.7 2.6-6.3L224 19.3 365.4 160.7c1.7 1.7 2.6 4 2.6 6.3c0 5-4 9-9 9H304c-3.2 0-6.2 1.9-7.4 4.9s-.6 6.4 1.7 8.7l99 99c1.7 1.7 2.6 4 2.6 6.3c0 5-4 9-9 9H336c-3.2 0-6.2 1.9-7.4 4.9s-.6 6.4 1.7 8.7l99 99c1.7 1.7 2.6 4 2.6 6.3c0 5-4 9-9 9H288 232z"],
    "arrows-cross": [448, 512, [], "e0a2", "M280 32c-4.4 0-8 3.6-8 8s3.6 8 8 8H420.7L2.3 466.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L432 59.3V200c0 4.4 3.6 8 8 8s8-3.6 8-8V40c0-4.4-3.6-8-8-8H280zM13.7 34.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L190.1 233.4l11.3-11.3L13.7 34.3zM420.7 464H280c-4.4 0-8 3.6-8 8s3.6 8 8 8H440c4.4 0 8-3.6 8-8V312c0-4.4-3.6-8-8-8s-8 3.6-8 8V452.7L257.9 278.6l-11.3 11.3L420.7 464z"],
    "backpack": [448, 512, [127890], "f5d4", "M184 16h80c13.3 0 24 10.7 24 24V80H160V40c0-13.3 10.7-24 24-24zM144 40V80H128C57.3 80 0 137.3 0 208V448c0 35.3 28.7 64 64 64H88 360h24c35.3 0 64-28.7 64-64V208c0-70.7-57.3-128-128-128H304V40c0-22.1-17.9-40-40-40H184c-22.1 0-40 17.9-40 40zM368 496V384 344c0-30.9-25.1-56-56-56H136c-30.9 0-56 25.1-56 56v40V496H64c-26.5 0-48-21.5-48-48V208C16 146.1 66.1 96 128 96H320c61.9 0 112 50.1 112 112V448c0 26.5-21.5 48-48 48H368zM96 496V392H352V496H96zm40-304c-4.4 0-8 3.6-8 8s3.6 8 8 8H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H136zM352 376H96V344c0-22.1 17.9-40 40-40H312c22.1 0 40 17.9 40 40v32z"],
    "square-small": [320, 512, [], "e27e", "M256 112c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V160c0-26.5 21.5-48 48-48H256zM64 96C28.7 96 0 124.7 0 160V352c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H64z"],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", "M496 416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H197.5c12.7 0 24.9 5.1 33.9 14.1l35.9 35.9c9 9 21.2 14.1 33.9 14.1H448c26.5 0 48 21.5 48 48V416zM64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H301.3c-8.5 0-16.6-3.4-22.6-9.4L242.7 50.7c-12-12-28.3-18.7-45.3-18.7H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64zm200-88V203.3l74.3 74.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-88-88c-3.1-3.1-8.2-3.1-11.3 0l-88 88c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L248 203.3V392c0 4.4 3.6 8 8 8s8-3.6 8-8z"],
    "bridge-lock": [640, 512, [], "e4cc", "M40 32c-4.4 0-8 3.6-8 8s3.6 8 8 8h80v96H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H528h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H520V48h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H40zM389.6 325.7c2.8-6.2 6.5-11.9 11.1-16.8C387.1 277.8 356.1 256 320 256c-48.6 0-88 39.4-88 88v96c0 13.3-10.7 24-24 24H176c-13.3 0-24-10.7-24-24V344c0-48.6-39.4-88-88-88H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H64c39.8 0 72 32.2 72 72v96c0 22.1 17.9 40 40 40h32c22.1 0 40-17.9 40-40V344c0-39.8 32.2-72 72-72c33.4 0 61.5 22.8 69.6 53.7zM504 48v96H392V48H504zM376 48v96H264V48H376zM248 48v96H136V48H248zM528 208c26.5 0 48 21.5 48 48v64H480V256c0-26.5 21.5-48 48-48zm-64 48v64H448c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32H592V256c0-35.3-28.7-64-64-64s-64 28.7-64 64zm-16 80h16 16 96 16 16c8.8 0 16 7.2 16 16V480c0 8.8-7.2 16-16 16H448c-8.8 0-16-7.2-16-16V352c0-8.8 7.2-16 16-16z"],
    "crosshairs-simple": [512, 512, [], "e59f", "M495.9 248H392c-4.4 0-8 3.6-8 8s3.6 8 8 8H495.9C491.7 390.2 390.2 491.7 264 495.9V392c0-4.4-3.6-8-8-8s-8 3.6-8 8V495.9C121.8 491.7 20.3 390.2 16.1 264H120c4.4 0 8-3.6 8-8s-3.6-8-8-8H16.1C20.3 121.8 121.8 20.3 248 16.1V120c0 4.4 3.6 8 8 8s8-3.6 8-8V16.1C390.2 20.3 491.7 121.8 495.9 248zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256z"],
    "sack-dollar": [512, 512, [128176], "f81d", "M196.8 128H315.2l9.2 5.9C380.2 169.6 496 259.6 496 416c0 44.2-35.8 80-80 80H96c-44.2 0-80-35.8-80-80c0-156.4 115.8-246.4 171.6-282.1l9.2-5.9zm122.5-16H192.7l-.5-.7L135.1 28.5c-3.7-5.3 .1-12.5 6.6-12.5H370.3c6.4 0 10.2 7.2 6.6 12.5l-57.1 82.8-.5 .7zM165.7 129.2C105.1 170.8 0 262.9 0 416c0 53 43 96 96 96H416c53 0 96-43 96-96c0-153.1-105.1-245.2-165.7-286.8c-4.7-3.3-9.2-6.2-13.3-8.8l9.1-13.2 48-69.6C401 21.7 389.6 0 370.3 0H141.7C122.4 0 111 21.7 121.9 37.6l48 69.6 9.1 13.2c-4.1 2.6-8.6 5.6-13.3 8.8zM264 224c0-4.4-3.6-8-8-8s-8 3.6-8 8v16.4c-8.4 .7-16.2 2.6-23 5.7c-12.4 5.6-21.9 15.4-24.2 28.8c-1.4 8.2-.6 15.4 2.4 21.8c3 6.3 7.8 11 13.2 14.7c10 6.8 23.7 10.9 35.9 14.6l1.7 .5c13.4 4 25 7.8 32.9 13.5c3.7 2.7 6.3 5.7 7.7 9c1.4 3.3 2.1 7.6 1.1 13.5c-1.4 8.2-6.5 14.1-15.1 17.8c-8.8 3.8-21.1 5-35.4 2.7c-7.1-1.2-19.2-5.3-28.8-8.5l0 0 0 0c-2.1-.7-4-1.4-5.7-1.9c-4.2-1.4-8.7 .9-10.1 5.1s.9 8.7 5.1 10.1c1.4 .5 3.1 1 5 1.7l0 0 0 0c9.4 3.2 23.4 8 32 9.4l0 0c1.8 .3 3.7 .5 5.5 .7V416c0 4.4 3.6 8 8 8s8-3.6 8-8V399.9c8.3-.5 16-2.1 22.7-5c12.6-5.4 22.1-15.4 24.5-29.7c1.5-8.5 .7-16-2.1-22.6c-2.9-6.6-7.5-11.6-13-15.5c-10.5-7.6-24.9-12-37.6-15.8l-.3-.1 0 0c-13.4-4-25-7.5-32.9-12.9c-3.8-2.6-6.3-5.3-7.7-8.3c-1.4-2.9-2.1-6.8-1.1-12.2c1.2-6.8 6.2-12.9 15.1-17c9-4.1 21.4-5.7 35.4-3.5c4.5 .7 18.5 3.4 22.9 4.6c4.3 1.1 8.7-1.4 9.8-5.7s-1.4-8.7-5.7-9.8c-5.2-1.4-19.8-4.2-24.6-4.9c-1.8-.3-3.7-.5-5.5-.7V224z"],
    "pen-to-square": [512, 512, ["edit"], "f044", "M460.3 39.6l12.1 12.1c15.6 15.6 15.6 40.9 0 56.6L440 140.7 371.3 72l32.4-32.4c15.6-15.6 40.9-15.6 56.6 0zM175.4 267.9L360 83.3 428.7 152 244.1 336.6c-5.3 5.3-12 9-19.3 10.7l-78.1 18 18-78.1c1.7-7.3 5.4-14 10.7-19.3zm217-239.6L164.1 256.6c-7.4 7.4-12.6 16.8-15 27l-20.9 90.6c-.6 2.7 .2 5.5 2.1 7.5s4.8 2.8 7.5 2.1l90.6-20.9c10.2-2.4 19.6-7.5 27-15L483.7 119.6c21.9-21.9 21.9-57.3 0-79.2L471.6 28.3c-21.9-21.9-57.3-21.9-79.2 0zM72 64C32.2 64 0 96.2 0 136V440c0 39.8 32.2 72 72 72H376c39.8 0 72-32.2 72-72V296c0-4.4-3.6-8-8-8s-8 3.6-8 8V440c0 30.9-25.1 56-56 56H72c-30.9 0-56-25.1-56-56V136c0-30.9 25.1-56 56-56H216c4.4 0 8-3.6 8-8s-3.6-8-8-8H72z"],
    "square-sliders": [448, 512, ["sliders-h-square"], "f3f0", "M16 416c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96l0 320zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 72c0-4.4 3.6-8 8-8l56 0 0-24c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-24-56 0c-4.4 0-8-3.6-8-8zm80 0l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32zm80 0c0-4.4 3.6-8 8-8l144 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-144 0c-4.4 0-8-3.6-8-8zM72 352c-4.4 0-8-3.6-8-8s3.6-8 8-8l152 0 0-24c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-24L72 352zm168-40l0 32 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16zm88 40c-4.4 0-8-3.6-8-8s3.6-8 8-8l48 0c4.4 0 8 3.6 8 8s-3.6 8-8 8l-48 0z"],
    "car-side": [640, 512, [128663], "f5e4", "M171.3 48H240V80v96 16H75.8L119.3 83.2c8.5-21.3 29.1-35.2 52-35.2zM256 208H512c61.9 0 112 50.1 112 112v48c0 8.8-7.2 16-16 16H576c0-53-43-96-96-96s-96 43-96 96H256c0-53-43-96-96-96s-96 43-96 96H32c-8.8 0-16-7.2-16-16V256c0-26.5 21.5-48 48-48H240h16zM574.7 400H608c17.7 0 32-14.3 32-32V320c0-69.4-55.2-125.9-124.1-127.9L409.5 59c-13.7-17.1-34.3-27-56.2-27H171.3c-29.4 0-55.9 17.9-66.9 45.3l-46 115C25.7 195 0 222.5 0 256V368c0 17.7 14.3 32 32 32H65.3c7.6 45.4 47.1 80 94.7 80s87.1-34.6 94.7-80H385.3c7.6 45.4 47.1 80 94.7 80s87.1-34.6 94.7-80zM495.4 192H256V176 80 48h97.2c17 0 33.1 7.7 43.7 21l98.4 123zM160 304a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm240 80a80 80 0 1 1 160 0 80 80 0 1 1 -160 0z"],
    "message-middle-top": [512, 512, ["comment-middle-top-alt"], "e1e2", "M343.5 112H448c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V160c0-26.5 21.5-48 48-48H168.5c4.7 0 9.3-2.1 12.3-5.8L256 16l75.2 90.2c3 3.6 7.5 5.8 12.3 5.8zm-175-16H64C28.7 96 0 124.7 0 160V448c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H343.5L268.3 5.8C265.3 2.1 260.7 0 256 0s-9.3 2.1-12.3 5.8L168.5 96z"],
    "lightbulb-on": [640, 512, [], "f672", "M44.1 1.1c-3.8-2.3-8.7-1-11 2.7s-1 8.7 2.7 11l80 48c3.8 2.3 8.7 1 11-2.7s1-8.7-2.7-11l-80-48zm560 13.7c3.8-2.3 5-7.2 2.7-11s-7.2-5-11-2.7l-80 48c-3.8 2.3-5 7.2-2.7 11s7.2 5 11 2.7l80-48zM8 160c-4.4 0-8 3.6-8 8s3.6 8 8 8H88c4.4 0 8-3.6 8-8s-3.6-8-8-8H8zm544 0c-4.4 0-8 3.6-8 8s3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H552zM124.1 270.9c3.8-2.3 5-7.2 2.7-11s-7.2-5-11-2.7l-80 48c-3.8 2.3-5 7.2-2.7 11s7.2 5 11 2.7l80-48zm400-13.7c-3.8-2.3-8.7-1-11 2.7s-1 8.7 2.7 11l80 48c3.8 2.3 8.7 1 11-2.7s1-8.7-2.7-11l-80-48zM480 176c0 33.9-10.5 65.3-28.5 91.2c-4.5 6.5-9.5 13.3-14.5 20.2c-12.5 17.2-25.9 35.5-36.3 54.4c-7.4 13.5-11.6 27.8-14 42.2H403c2.2-12 5.9-23.7 11.8-34.5c9.9-18 22.2-34.9 34.5-51.8l0 0 0 0 0 0c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C496 78.8 417.2 0 320 0S144 78.8 144 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4l0 0 0 0 0 0c12.3 16.8 24.6 33.7 34.5 51.8c5.9 10.8 9.6 22.5 11.8 34.5h16.2c-2.4-14.4-6.6-28.7-14-42.2c-10.4-19-23.7-37.3-36.3-54.4l0 0 0 0c-5-6.9-10-13.7-14.5-20.2c-18-25.9-28.5-57.3-28.5-91.2c0-88.4 71.6-160 160-160s160 71.6 160 160zm-256-8c0-48.6 39.4-88 88-88c4.4 0 8-3.6 8-8s-3.6-8-8-8c-57.4 0-104 46.6-104 104c0 4.4 3.6 8 8 8s8-3.6 8-8zm96 328c-35.3 0-64-28.7-64-64H384c0 35.3-28.7 64-64 64zm-80-69.3V432c0 44.2 35.8 80 80 80s80-35.8 80-80v-5.3c0-5.9-4.8-10.7-10.7-10.7H250.7c-5.9 0-10.7 4.8-10.7 10.7z"],
    "knife": [512, 512, ["utensil-knife"], "f2e4", "M460.7 7.3C465 2.6 471.1 0 477.4 0c9.3 0 18 5.7 21 15.1c5 15.8 13.6 49.4 13.6 92.1c0 48.6-15.3 85.8-42.7 122.7c-23 31-54.7 62.1-93 99.5c-6.7 6.6-13.7 13.4-20.8 20.4c0 0 0 0 0 0L345.3 360c-12.7 12.7-30 19.9-48 19.9s-35.3-7.1-48-19.9l-49.7-49.7L13.8 509.5c-3 3.2-8.1 3.4-11.3 .4s-3.4-8.1-.4-11.3L193.6 293.4 460.7 7.3zM210.6 298.6l50 50c9.7 9.7 22.9 15.2 36.7 15.2s27-5.5 36.7-15.2l10.2-10.2 0 0c7.3-7.1 14.3-14 21.1-20.7c38.4-37.5 69-67.6 91.2-97.4c25.7-34.7 39.5-68.7 39.5-113.2c0-40.7-8.2-72.5-12.9-87.3c-.7-2.2-2.8-3.9-5.7-3.9c-1.9 0-3.8 .8-5.1 2.2L210.6 298.6z"],
    "share-nodes": [448, 512, ["share-alt"], "f1e0", "M448 112c0 44.2-35.8 80-80 80c-25.9 0-48.9-12.3-63.5-31.3L157.1 234.4c1.9 6.9 2.9 14.1 2.9 21.6s-1 14.7-2.9 21.6l147.5 73.7c14.6-19 37.6-31.3 63.5-31.3c44.2 0 80 35.8 80 80s-35.8 80-80 80s-80-35.8-80-80c0-12.6 2.9-24.5 8.1-35L151.2 292.5C137.9 318.3 111 336 80 336c-44.2 0-80-35.8-80-80s35.8-80 80-80c31 0 57.9 17.7 71.2 43.5L296.1 147c-5.2-10.6-8.1-22.5-8.1-35c0-44.2 35.8-80 80-80s80 35.8 80 80zM80 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM432 112a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM368 464a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "display-chart-up-circle-dollar": [640, 512, [], "e5e6", "M512 16H64C37.5 16 16 37.5 16 64V352c0 26.5 21.5 48 48 48H231.8h.3 90.8c1 5.4 2.2 10.8 3.7 16H238.8l-13.3 80H288h62.6 16.2 8.4c6.1 5.8 12.7 11.1 19.6 16H360 216 136c-4.4 0-8-3.6-8-8s3.6-8 8-8h73.2l13.3-80H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H512c35.3 0 64 28.7 64 64V211.2c-5.2-2.7-10.5-5.1-16-7.2V64c0-26.5-21.5-48-48-48zm0 176.7c-5.3-.5-10.6-.7-16-.7V80H80l0 256H322.9c-1 5.3-1.7 10.6-2.2 16H80c-8.8 0-16-7.2-16-16V80c0-8.8 7.2-16 16-16H496c8.8 0 16 7.2 16 16V192.7zm-64 5.9c-5.4 1.5-10.8 3.3-16 5.4V155.3L325.7 261.7c-1.5 1.5-3.5 2.3-5.7 2.3s-4.2-.8-5.7-2.3L240 187.3 133.7 293.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l112-112c3.1-3.1 8.2-3.1 11.3 0L320 244.7 420.7 144H352c-4.4 0-8-3.6-8-8s3.6-8 8-8h88c4.4 0 8 3.6 8 8v62.6zM496 496a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-272a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm-28.2 93.9c-8 4.1-12.3 9.7-11.7 17.6c.4 5.2 3.6 9.5 11.5 13.5c7.9 4 18.3 6.8 30 10l1 .3c11.5 3.1 24.3 6.6 34.1 12.1c10.2 5.7 18.8 14.5 19.2 28.4c.5 16.4-8.9 27-20.4 33c-8.5 4.4-18.5 6.5-27.6 7.1v17.7 8H488v-8V439.4c-12.6-1.4-24.7-5.1-35.9-8.5l0 0c-2.1-.7-4.3-1.3-6.3-1.9l-7.7-2.3 4.5-15.3 7.7 2.3c2.3 .7 4.5 1.3 6.7 2l0 0 0 0c13.6 4.1 26.1 7.9 39.2 8.3c9.4 .3 20.1-1.4 28-5.5c7.6-3.9 12-9.6 11.7-18.3c-.2-6.2-3.6-10.7-11.1-14.9c-7.8-4.4-18.5-7.4-30.5-10.6l-1.8-.5c-11-2.9-22.9-6.1-32.3-11c-10.1-5.2-19.3-13.3-20.2-26.7c-1.1-16.5 8.9-27.1 20.4-32.9c8.5-4.3 18.5-6.5 27.4-7.3V280v-8h16v8 16.4c10.2 .8 20.4 2.8 29.8 5l7.8 1.8-3.7 15.6-7.8-1.8c-11.4-2.7-23.1-4.8-34.3-5c-8.8-.1-19.8 1.6-28.1 5.8z"],
    "wave-sine": [640, 512, [8767], "f899", "M15.8 249.8l0 0 0 0c-1 4.3-5.3 7-9.6 6s-7-5.3-6-9.6L8 248c-7.8-1.8-7.8-1.8-7.8-1.8l0 0 0 0 0-.1 .1-.5c.1-.4 .2-1 .4-1.8c.4-1.6 1-3.9 1.8-6.8c1.6-5.8 4-14.1 7.2-23.9c6.5-19.8 16.4-46.2 30.1-72.7C53.6 113.9 71.4 87 93.7 66.6C116.1 46.1 143.5 32 176 32c48.2 0 79.4 30 101.6 71.7c21.9 41.3 36.1 96.1 50 149.6l.2 .7c0 .1 0 .1 0 .2c14.1 54.2 27.8 107.1 48.8 146.6C397.4 440 424.2 464 464 464c27.5 0 51.1-11.9 71.5-30.4c20.4-18.6 37.1-43.7 50.4-69.3c13.2-25.5 22.8-51.1 29.1-70.3c3.1-9.6 5.4-17.6 7-23.2c.8-2.8 1.3-5 1.7-6.4l.4-1.7 .1-.4 0-.1 0 0 0 0 0 0c1-4.3 5.3-7 9.6-6s7 5.3 6 9.6L632 264c7.8 1.8 7.8 1.8 7.8 1.8l0 0 0 0 0 .1-.1 .5c-.1 .4-.2 1-.4 1.8c-.4 1.6-1 3.9-1.8 6.8c-1.6 5.8-4 14.1-7.2 23.9c-6.5 19.8-16.4 46.2-30.1 72.7c-13.7 26.4-31.5 53.3-53.8 73.7C523.9 465.8 496.5 480 464 480c-48.2 0-79.4-30-101.6-71.7c-21.9-41.3-36.1-96.1-50-149.6l-.2-.7c0-.1 0-.1 0-.2c-14.1-54.2-27.8-107.1-48.8-146.6C242.6 72 215.8 48 176 48c-27.5 0-51.1 11.9-71.5 30.4C84.1 97 67.4 122.1 54.1 147.7C40.9 173.2 31.3 198.7 25 218c-3.1 9.6-5.4 17.6-7 23.2c-.8 2.8-1.3 5-1.7 6.4l-.4 1.7-.1 .4 0 .1 0 0z"],
    "heart-circle-minus": [576, 512, [], "e4ff", "M393.6 57.7c-42.9-5.6-85.8 12.6-111.2 47.6l-20 27.5c-1.5 2.1-3.9 3.3-6.5 3.3s-5-1.2-6.5-3.3l-20-27.5c-25.4-34.9-68.3-53.2-111.2-47.6C60.1 65.3 16 114.9 16 173.5c0 30.3 11.8 59.4 32.9 81.2L248 460.4c2.2 2.3 5.2 3.6 8.4 3.6s6.2-1.3 8.4-3.6l11-11.4c2.6 4.9 5.4 9.7 8.4 14.4l-7.8 8.1c-5.2 5.4-12.4 8.5-19.9 8.5c-7.5 0-14.7-3-19.9-8.4L37.4 265.8C13.4 241.1 0 208 0 173.5C0 106.8 50.2 50.4 116.3 41.8c48.6-6.3 97.4 14.3 126.2 54L256 114.4l13.5-18.6c28.9-39.7 77.6-60.4 126.2-54c66.1 8.6 116.3 65 116.3 131.8c0 12-1.6 23.9-4.8 35.3c-4.9-2.3-9.8-4.4-14.9-6.2c2.4-9.4 3.7-19.2 3.7-29C496 115 451.9 65.3 393.6 57.7zM432 496a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-272a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm80 144c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8s3.6-8 8-8H504c4.4 0 8 3.6 8 8z"],
    "circle-w": [512, 512, [], "e12c", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM127.7 149.7c-1.3-4.2-5.7-6.6-10-5.4s-6.6 5.7-5.4 10l72 240c1 3.4 4.1 5.7 7.7 5.7s6.7-2.3 7.7-5.7L256 204.2l56.3 190.1c1 3.4 4.1 5.7 7.7 5.7s6.7-2.3 7.7-5.7l72-240c1.3-4.2-1.1-8.7-5.4-10s-8.7 1.1-10 5.4L320 364 263.7 173.7c-1-3.4-4.1-5.7-7.7-5.7s-6.7 2.3-7.7 5.7L192 364 127.7 149.7z"],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM200 96c4.4 0 8 3.6 8 8v24h96V104c0-4.4 3.6-8 8-8s8 3.6 8 8v24h16c26.5 0 48 21.5 48 48v32 16V336c0 26.5-21.5 48-48 48H176c-26.5 0-48-21.5-48-48V224 208 176c0-26.5 21.5-48 48-48h16V104c0-4.4 3.6-8 8-8zm-8 72V144H176c-17.7 0-32 14.3-32 32v32H368V176c0-17.7-14.3-32-32-32H320v24c0 4.4-3.6 8-8 8s-8-3.6-8-8V144H208v24c0 4.4-3.6 8-8 8s-8-3.6-8-8zm176 56H144V336c0 17.7 14.3 32 32 32H336c17.7 0 32-14.3 32-32V224z"],
    "hourglass-half": [384, 512, ["hourglass-2"], "f252", "M0 8C0 3.6 3.6 0 8 0H40 344h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H352V76.7c0 29.9-9.8 58.9-28 82.6l-74 96.7 74 96.7c18.1 23.7 28 52.8 28 82.6V496h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H344 40 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32V435.3c0-29.9 9.8-58.9 28-82.6l74-96.7L60 159.3c-18.1-23.7-28-52.8-28-82.6L32 16H8c-4.4 0-8-3.6-8-8zm48 8l0 60.7c0 26.3 8.7 52 24.7 72.9l77.7 101.6c2.2 2.9 2.2 6.9 0 9.7L72.7 362.4C56.7 383.4 48 409 48 435.3V496H336V435.3c0-26.3-8.7-52-24.7-72.9L233.6 260.9c-2.2-2.9-2.2-6.9 0-9.7l77.7-101.6c16-20.9 24.7-46.5 24.7-72.9V16H48zm64.8 108.4c1.4-2.7 4.1-4.4 7.2-4.4H264c3 0 5.8 1.7 7.2 4.4s1.1 6-.8 8.4l-72 96c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2l-72-96c-1.8-2.4-2.1-5.7-.8-8.4zM136 136l56 74.7L248 136H136zM113.6 379.2c1.5-2 3.9-3.2 6.4-3.2H264c2.5 0 4.9 1.2 6.4 3.2l11.2 14.9c9.3 12.5 14.4 27.6 14.4 43.2V456c0 4.4-3.6 8-8 8H96c-4.4 0-8-3.6-8-8V437.3c0-15.6 5.1-30.7 14.4-43.2l11.2-14.9zM124 392l-8.8 11.7c-7.3 9.7-11.2 21.5-11.2 33.6V448H280V437.3c0-12.1-3.9-23.9-11.2-33.6L260 392H124z"],
    "microscope": [512, 512, [128300], "f610", "M176 24V40c0 4.4-3.6 8-8 8h-8c-8.8 0-16 7.2-16 16V288c0 8.8 7.2 16 16 16h96c8.8 0 16-7.2 16-16V144 128 64c0-8.8-7.2-16-16-16h-8c-4.4 0-8-3.6-8-8V24c0-4.4-3.6-8-8-8H184c-4.4 0-8 3.6-8 8zM288 144V288c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V64c0-17.7 14.3-32 32-32V24c0-13.3 10.7-24 24-24h48c13.3 0 24 10.7 24 24v8c17.7 0 32 14.3 32 32v64c106 0 192 86 192 192c0 78.7-47.4 146.4-115.1 176H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H288 208 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H208h80c97.2 0 176-78.8 176-176s-78.8-176-176-176zM160 360c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8zM96 424c0-4.4 3.6-8 8-8H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H104c-4.4 0-8-3.6-8-8z"],
    "sunset": [576, 512, [127751], "f767", "M293.7 221.7c-3.1 3.1-8.2 3.1-11.3 0l-88-88c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L280 196.7V8c0-4.4 3.6-8 8-8s8 3.6 8 8V196.7l74.3-74.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-88 88zm-111.2 3.6c5-2.1 10.7-1.5 15.2 1.6L288 289.1l90.3-62.3c4.5-3.1 10.2-3.7 15.2-1.6s8.6 6.6 9.6 11.9L423 345l107.9 19.8c5.3 1 9.8 4.6 11.9 9.6l-7.4 3.1 7.4-3.1c2.1 5 1.5 10.7-1.6 15.2L489.9 464H470.5L528 380.6 414.7 359.8c-3.3-.6-5.8-3.2-6.4-6.4L387.4 240l-94.9 65.4c-2.7 1.9-6.3 1.9-9.1 0L188.6 240 167.8 353.3c-.6 3.3-3.2 5.8-6.4 6.4L48 380.6 105.5 464H86.1L34.8 389.7c-3.1-4.5-3.7-10.2-1.6-15.2s6.6-8.6 11.9-9.6L153 345l19.8-107.9c1-5.3 4.6-9.8 9.6-11.9zM398.9 464H382.7c-7.6-45.4-47.1-80-94.7-80s-87.1 34.6-94.7 80H177.1c7.8-54.3 54.4-96 110.9-96s103.1 41.7 110.9 96zM8 496H568c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "sink": [512, 512, [], "e06d", "M264 72c0-30.9 25.1-56 56-56s56 25.1 56 56v48c0 4.4 3.6 8 8 8s8-3.6 8-8V72c0-39.8-32.2-72-72-72s-72 32.2-72 72V288H144V264c0-22.1-17.9-40-40-40H40c-4.4 0-8 3.6-8 8s3.6 8 8 8h64c13.3 0 24 10.7 24 24v24H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H384V264c0-13.3 10.7-24 24-24h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H408c-22.1 0-40 17.9-40 40v24H264V72zM32 304H136 256 376 480c8.8 0 16 7.2 16 16s-7.2 16-16 16H32c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 80v24c0 57.4 46.6 104 104 104H376c57.4 0 104-46.6 104-104V384H464v24c0 48.6-39.4 88-88 88H136c-48.6 0-88-39.4-88-88V384H32z"],
    "calendar-exclamation": [448, 512, [], "f334", "M120 0c4.4 0 8 3.6 8 8V64H320V8c0-4.4 3.6-8 8-8s8 3.6 8 8V64h48c35.3 0 64 28.7 64 64v48 16V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V192 176 128C0 92.7 28.7 64 64 64h48V8c0-4.4 3.6-8 8-8zM432 192H16V448c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V192zM112 120V80H64c-26.5 0-48 21.5-48 48v48H432V128c0-26.5-21.5-48-48-48H336v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V80H128v40c0 4.4-3.6 8-8 8s-8-3.6-8-8zm96 296a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm24-168V360c0 4.4-3.6 8-8 8s-8-3.6-8-8V248c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "truck-container-empty": [640, 512, [], "e2b5", "M448 160c0-13.3 10.7-24 24-24h72c12.6 0 24.4 5.9 32 16l56 74.7c5.2 6.9 8 15.3 8 24V304v72c0 17.7-14.3 32-32 32h-.4c-4 40.4-38.1 72-79.6 72c-44.2 0-80-35.8-80-80H304c0 44.2-35.8 80-80 80c-31.7 0-59-18.4-72-45.1C139 461.6 111.7 480 80 480c-44.2 0-80-35.8-80-80s35.8-80 80-80c31.7 0 59 18.4 72 45.1c13-26.7 40.3-45.1 72-45.1c38.7 0 71 27.5 78.4 64H448V352 160zM608 392c8.8 0 16-7.2 16-16V304 256H464v96c14.6-19.4 37.8-32 64-32c41.5 0 75.6 31.6 79.6 72h.4zm13.5-152c-.6-1.3-1.4-2.6-2.3-3.7l-56-74.7c-4.5-6-11.6-9.6-19.2-9.6H472c-4.4 0-8 3.6-8 8v80H621.5zM528 464a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM288 400a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM80 464a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "hand-heart": [512, 512, [], "f4bc", "M264 16c17.7 0 32 14.3 32 32l0 24v8V248c0 4.4 3.6 8 8 8s8-3.6 8-8V80c0-17.7 14.3-32 32-32s32 14.3 32 32v56 8 56 48c0 4.4 3.6 8 8 8s8-3.6 8-8V200 144c0-17.7 14.3-32 32-32s32 14.3 32 32V344c0 83.9-68.1 152-152 152h-8.5c-59.4 0-116.4-23.6-158.4-65.6L25.4 318.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l67.7 67.7c2.3 2.3 5.7 3 8.7 1.7s4.9-4.2 4.9-7.4V80c0-17.7 14.3-32 32-32s32 14.3 32 32l0 0V248c0 4.4 3.6 8 8 8s8-3.6 8-8V72l0 0V48c0-17.7 14.3-32 32-32zm47.9 28.3C310 19.5 289.3 0 264 0s-46 19.5-47.9 44.3C207.6 36.7 196.4 32 184 32c-26.5 0-48 21.5-48 48V316.1L81.9 262.1c-18.7-18.7-49.1-18.7-67.9 0s-18.7 49.1 0 67.9L125.8 441.7c45 45 106.1 70.3 169.7 70.3H304c92.8 0 168-75.2 168-168V144c0-26.5-21.5-48-48-48c-12.3 0-23.5 4.6-32 12.2V80c0-26.5-21.5-48-48-48c-12.4 0-23.6 4.7-32.1 12.3zM204.6 336.6c0-20.2 16.4-36.6 36.6-36.6h.6c9.7 0 19 3.8 26 10.5l14.6 14.2c3.1 3 8 3 11.2 0l14.6-14.2c7-6.8 16.3-10.5 26-10.5h.6c20.2 0 36.6 16.4 36.6 36.6c0 9.3-3.6 18.3-10 25.1l-67.6 71.7c-1.5 1.6-3.6 2.5-5.8 2.5s-4.3-.9-5.8-2.5l-67.6-71.7c-6.4-6.8-10-15.8-10-25.1zM241.2 284c-29.1 0-52.6 23.6-52.6 52.6c0 13.4 5.1 26.3 14.3 36.1l67.6 71.7c4.5 4.8 10.9 7.5 17.5 7.5s12.9-2.7 17.5-7.5l67.6-71.7c9.2-9.8 14.3-22.7 14.3-36.1c0-29.1-23.6-52.6-52.6-52.6h-.6c-13.9 0-27.2 5.4-37.1 15.1l-9 8.8-9-8.8c-9.9-9.7-23.3-15.1-37.1-15.1h-.6z"],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", "M144 96v32H304V96c0-44.2-35.8-80-80-80s-80 35.8-80 80zm-16 48H48c-17.7 0-32 14.3-32 32V416c0 44.2 35.8 80 80 80H352c44.2 0 80-35.8 80-80V176c0-17.7-14.3-32-32-32H320v88c0 4.4-3.6 8-8 8s-8-3.6-8-8V144H144v88c0 4.4-3.6 8-8 8s-8-3.6-8-8V144zm0-16V96c0-53 43-96 96-96s96 43 96 96v32h80c26.5 0 48 21.5 48 48V416c0 53-43 96-96 96H96c-53 0-96-43-96-96V176c0-26.5 21.5-48 48-48h80z"],
    "arrow-down-z-a": [576, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", "M277.7 365.7l-112 112c-3.1 3.1-8.2 3.1-11.3 0l-112-112c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L152 452.7V40c0-4.4 3.6-8 8-8s8 3.6 8 8V452.7l98.3-98.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zM336 40c0-4.4 3.6-8 8-8H488c3.1 0 5.9 1.8 7.2 4.6s.9 6.1-1 8.5L360.9 208H488c4.4 0 8 3.6 8 8s-3.6 8-8 8H344c-3.1 0-5.9-1.8-7.2-4.6s-.9-6.1 1-8.5L471.1 48H344c-4.4 0-8-3.6-8-8zm87.2 252.4l63.9 127.9 .2 .3 23.9 47.8c2 4 .4 8.8-3.6 10.7s-8.8 .4-10.7-3.6L475.1 432H356.9l-21.8 43.6c-2 4-6.8 5.6-10.7 3.6s-5.6-6.8-3.6-10.7l23.9-47.8 .1-.3 63.9-127.9c1.4-2.7 4.1-4.4 7.2-4.4s5.8 1.7 7.2 4.4zM467.1 416L416 313.9 364.9 416H467.1z"],
    "mitten": [448, 512, [], "f7b5", "M0 136C0 60.9 60.9 0 136 0h16.3c60.3 0 113.3 39.7 130.4 97.5l33.3 112.8 2.5-3.7C331.9 187.4 353.7 176 377 176c39.2 0 71 31.8 71 71v1c0 17.4-6.3 34.3-17.8 47.4L366.6 368H345.4l72.8-83.2c8.9-10.2 13.8-23.3 13.8-36.9v-1c0-30.4-24.6-55-55-55c-18 0-34.9 8.9-45.2 23.7l-12.1 17.4c-1.8 2.5-4.8 3.8-7.8 3.3s-5.5-2.7-6.4-5.6L267.4 102c-15.1-51-61.9-86-115.1-86H136C69.7 16 16 69.7 16 136v8.2c0 9.8 1.2 19.6 3.6 29.1L68.2 368H51.8L4.1 177.2C1.4 166.4 0 155.4 0 144.2V136zM64 416c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16H352c8.8 0 16-7.2 16-16V432c0-8.8-7.2-16-16-16H64zM32 432c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32v48c0 17.7-14.3 32-32 32H64c-17.7 0-32-14.3-32-32V432z"],
    "reply-clock": [640, 512, ["reply-time"], "e239", "M496 16a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272A144 144 0 1 0 496 0a144 144 0 1 0 0 288zm0-224c-4.4 0-8 3.6-8 8v72c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H504V72c0-4.4-3.6-8-8-8zm16 272c0-5.6-.3-11.2-.8-16.6c-5 .4-10.1 .6-15.2 .6l-.8 0c.5 5.3 .8 10.6 .8 16c0 104.2-74.6 150.7-91.8 160c-.1 0-.2 0-.6 0c-2 0-3.7-1.6-3.7-3.7c0-1.4 1-4.4 4.7-7.8C416.8 473.1 432 451.5 432 416c0-61.9-50.1-112-112-112H224c-8.8 0-16 7.2-16 16v64c0 6.3-3.7 12-9.5 14.6s-12.5 1.5-17.2-2.7l-160-144c-3.4-3-5.3-7.4-5.3-11.9s1.9-8.9 5.3-11.9l160-144c4.7-4.2 11.4-5.3 17.2-2.7S208 89.7 208 96v64c0 8.8 7.2 16 16 16h98.9c-1-5.3-1.7-10.6-2.2-16H240 224V144 96c0-12.6-7.4-24.1-19-29.2s-25-3-34.4 5.4l-160 144C3.9 222.3 0 230.9 0 240s3.9 17.7 10.6 23.8l160 144c9.4 8.5 22.9 10.6 34.4 5.4s19-16.6 19-29.2V336 320h16 80c53 0 96 43 96 96c0 30.4-12.8 47.9-22.2 56.7c-5.5 5.1-9.8 12-9.8 19.5c0 10.9 8.8 19.7 19.7 19.7c2.8 0 5.6-.6 8.1-1.9C430.5 499.9 512 449.3 512 336z"],
    "person-rays": [512, 512, [], "e54d", "M2.3 2.3c-3.1 3.1-3.1 8.2 0 11.3l104 104c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L13.7 2.3C10.5-.8 5.5-.8 2.3 2.3zm507.3 0c-3.1-3.1-8.2-3.1-11.3 0l-104 104c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l104-104c3.1-3.1 3.1-8.2 0-11.3zM13.7 509.7l104-104c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-104 104c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0zm496 0c3.1-3.1 3.1-8.2 0-11.3l-104-104c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l104 104c3.1 3.1 8.2 3.1 11.3 0zM216 56a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0A56 56 0 1 0 200 56a56 56 0 1 0 112 0zM186.7 175.7c9.3-19.4 28.9-31.7 50.4-31.7h37.8c21.5 0 41.1 12.3 50.4 31.7l67.5 139.8c1.9 4 6.7 5.6 10.7 3.7s5.6-6.7 3.7-10.7L339.7 168.7c-12-24.9-37.2-40.7-64.8-40.7H237.1c-27.6 0-52.8 15.8-64.8 40.7L104.8 308.5c-1.9 4-.3 8.8 3.7 10.7s8.8 .3 10.7-3.7l67.5-139.8zM192 240c-4.4 0-8 3.6-8 8V480c0 17.7 14.3 32 32 32s32-14.3 32-32V360c0-4.4 3.6-8 8-8s8 3.6 8 8V480c0 17.7 14.3 32 32 32s32-14.3 32-32V248c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 8.8-7.2 16-16 16s-16-7.2-16-16V360c0-13.3-10.7-24-24-24s-24 10.7-24 24V480c0 8.8-7.2 16-16 16s-16-7.2-16-16V248c0-4.4-3.6-8-8-8z"],
    "right": [448, 512, [11157, "arrow-alt-right"], "f356", "M432 256c0 8.1-3.2 15.9-9 21.7L274.6 426.1c-3.8 3.8-9 5.9-14.3 5.9c-11.2 0-20.3-9.1-20.3-20.3l0-99.7c0-4.4-3.6-8-8-8L40 304c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24l192 0c4.4 0 8-3.6 8-8l0-99.7c0-11.2 9.1-20.3 20.3-20.3c5.4 0 10.5 2.1 14.3 5.9L423 234.3c5.7 5.7 9 13.5 9 21.7zM260.3 448c9.6 0 18.9-3.8 25.7-10.6L434.4 289c8.7-8.7 13.7-20.6 13.7-33s-4.9-24.2-13.7-33L285.9 74.6c-6.8-6.8-16-10.6-25.7-10.6c-20 0-36.3 16.2-36.3 36.3l0 91.7L40 192c-22.1 0-40 17.9-40 40l0 48c0 22.1 17.9 40 40 40l184 0 0 91.7c0 20 16.2 36.3 36.3 36.3z"],
    "circle-f": [512, 512, [], "e10e", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128c-13.3 0-24 10.7-24 24v96V376c0 4.4 3.6 8 8 8s8-3.6 8-8V256H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H176V152c0-4.4 3.6-8 8-8H344c4.4 0 8-3.6 8-8s-3.6-8-8-8H184z"],
    "users": [640, 512, [], "f0c0", "M80 80a64 64 0 1 1 128 0A64 64 0 1 1 80 80zm144 0A80 80 0 1 0 64 80a80 80 0 1 0 160 0zm96 64a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm-58.7 48H378.7C443.5 368 496 420.5 496 485.3c0 5.9-4.8 10.7-10.7 10.7H154.7c-5.9 0-10.7-4.8-10.7-10.7C144 420.5 196.5 368 261.3 368zm0-16C187.7 352 128 411.7 128 485.3c0 14.7 11.9 26.7 26.7 26.7H485.3c14.7 0 26.7-11.9 26.7-26.7C512 411.7 452.3 352 378.7 352H261.3zM512 16a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 144A80 80 0 1 0 512 0a80 80 0 1 0 0 160zm24 48c48.6 0 88 39.4 88 88c0 4.4 3.6 8 8 8s8-3.6 8-8c0-57.4-46.6-104-104-104H444c1.3 5.2 2.4 10.6 3 16h89zm-343 0c.7-5.4 1.7-10.8 3-16H104C46.6 192 0 238.6 0 296c0 4.4 3.6 8 8 8s8-3.6 8-8c0-48.6 39.4-88 88-88h89z"],
    "face-pleading": [512, 512, [], "e386", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM295.1 420.4c-7.6-8.4-20.6-17.4-39.1-17.4s-31.5 8.9-39.1 17.4c-3 3.3-8 3.5-11.3 .6s-3.6-8-.6-11.3c9.8-10.9 26.8-22.6 50.9-22.6s41.1 11.7 50.9 22.6c3 3.3 2.7 8.3-.6 11.3s-8.3 2.7-11.3-.6zM325.2 96.5c4.1-1.6 8.7 .5 10.3 4.7l1.2 3.1c13.3 35.5 43.6 61.8 80.6 70l8.5 1.9c4.3 1 7 5.2 6.1 9.5s-5.2 7-9.5 6.1l-7.7-1.7c10.9 13.7 17.5 31 17.5 49.9c0 44.2-35.8 80-80 80s-80-35.8-80-80s35.8-80 80-80c1.3 0 2.6 0 3.9 .1c-15-13.5-26.9-30.6-34.2-50.2l-1.2-3.1c-1.6-4.1 .5-8.7 4.7-10.3zM191.5 106.8l-1.2 3.1c-7.3 19.5-19.2 36.6-34.2 50.2c1.3-.1 2.6-.1 3.9-.1c44.2 0 80 35.8 80 80s-35.8 80-80 80s-80-35.8-80-80c0-18.9 6.5-36.2 17.5-49.9l-7.7 1.7c-4.3 1-8.6-1.8-9.5-6.1s1.8-8.6 6.1-9.5l8.5-1.9c37-8.2 67.3-34.6 80.6-70l1.2-3.1c1.6-4.1 6.2-6.2 10.3-4.7s6.2 6.2 4.7 10.3zM160 304a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm256-64a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM160 272c17.7 0 32-14.3 32-32c0-12-6.6-22.4-16.3-27.9c-2 15.7-15.5 27.9-31.7 27.9c-5.7 0-11.1-1.5-15.7-4.1c-.2 1.4-.3 2.7-.3 4.1c0 17.7 14.3 32 32 32zm-44.6-49.7c2.1-5.3 5.1-10.1 8.9-14.3c1.4-1.5 2.8-3 4.4-4.3c-.4 1.4-.6 2.8-.6 4.3c0 5.2 2.5 9.9 6.4 12.8c2.7 2 6 3.2 9.6 3.2c8.8 0 16-7.2 16-16l0-.1c0-6.7-4.3-12.5-10.2-14.8c3.3-.7 6.7-1.1 10.2-1.1c4.4 0 8.6 .6 12.6 1.7C193 199.2 208 217.9 208 240c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-6.2 1.2-12.2 3.4-17.7zM384 240c0-12-6.6-22.4-16.3-27.9c-2 15.7-15.5 27.9-31.7 27.9c-5.7 0-11.1-1.5-15.7-4.1c-.2 1.4-.3 2.7-.3 4.1c0 17.7 14.3 32 32 32s32-14.3 32-32zm-80 0c0-6.2 1.2-12.2 3.4-17.7c2.1-5.3 5.1-10.1 8.9-14.3c1.4-1.5 2.8-3 4.4-4.3c-.4 1.4-.6 2.8-.6 4.3c0 5.2 2.5 9.9 6.4 12.8c2.7 2 6 3.2 9.6 3.2c8.8 0 16-7.2 16-16c0-6.8-4.2-12.6-10.2-14.9c3.3-.7 6.7-1.1 10.2-1.1c4.4 0 8.6 .6 12.6 1.7C385 199.2 400 217.9 400 240c0 26.5-21.5 48-48 48s-48-21.5-48-48z"],
    "eye-slash": [640, 512, [], "f070", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM605.5 268.3c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C465.5 68.8 400.8 32 320 32c-47.8 0-90.1 12.9-126.3 32.5l13.7 10.9C240.3 58.7 277.9 48 320 48c75.6 0 136.6 34.4 181.7 76.3c44.9 41.7 75 91.7 89.1 125.6c1.6 3.9 1.6 8.4 0 12.3C581.7 284 566 312.4 544 341.1l12.6 9.9c23-29.9 39.4-59.7 49-82.7zM83.5 161c-23 29.9-39.4 59.7-49 82.7c-3.3 7.9-3.3 16.7 0 24.6c14.9 35.7 46.2 87.7 93 131.1C174.5 443.2 239.2 480 320 480c47.8 0 90.1-12.9 126.3-32.5l-13.7-10.9C399.7 453.3 362.1 464 320 464c-75.6 0-136.6-34.4-181.7-76.3C93.4 346 63.3 296 49.2 262.2c-1.6-3.9-1.6-8.4 0-12.3C58.3 228 74 199.6 96 170.9L83.5 161zM320 368c7.8 0 15.4-.8 22.7-2.3l-17.5-13.8c-1.7 .1-3.5 .1-5.2 .1c-47.2 0-86.4-34-94.5-78.9L208 259.4C209.8 319.7 259.3 368 320 368zm0-224c-7.8 0-15.4 .8-22.7 2.3l17.5 13.8c1.7-.1 3.5-.1 5.2-.1c47.2 0 86.4 34 94.5 78.9L432 252.6C430.2 192.3 380.7 144 320 144z"],
    "flask-vial": [640, 512, [], "e4f3", "M224 16V327.1l-16 23.1V176H48V352c0 44.2 35.8 80 80 80c12.7 0 24.8-3 35.5-8.3c-1.7 6.1-2.8 12.4-3.2 18.7C150.2 446 139.3 448 128 448c-53 0-96-43-96-96V16H8c-4.4 0-8-3.6-8-8S3.6 0 8 0H40 216h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H224zM48 160H208V16H48V160zM344 0H488h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H496V221.5L628.8 413.4c7.3 10.5 11.2 23 11.2 35.8c0 34.7-28.1 62.9-62.9 62.9H254.9c-34.7 0-62.9-28.1-62.9-62.9c0-12.8 3.9-25.3 11.2-35.8L336 221.5V16H312c-4.4 0-8-3.6-8-8s3.6-8 8-8h32zm8 16V224c0 1.6-.5 3.2-1.4 4.6L287.3 320H544.7l-63.3-91.4c-.9-1.3-1.4-2.9-1.4-4.6V16H352zM216.3 422.5c-5.4 7.8-8.3 17.1-8.3 26.7c0 25.9 21 46.9 46.9 46.9H577.1c25.9 0 46.9-21 46.9-46.9c0-9.5-2.9-18.8-8.3-26.7L555.8 336H276.2l-59.9 86.5z"],
    "police-box": [384, 512, [], "e021", "M200 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V32H88C74.7 32 64 42.7 64 56v8C46.3 64 32 78.3 32 96V496H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H352V96c0-17.7-14.3-32-32-32V56c0-13.3-10.7-24-24-24H200V8zM336 96V496H48V96c0-8.8 7.2-16 16-16h6.5H72 312h2.8H320c8.8 0 16 7.2 16 16zM192 48H296c4.4 0 8 3.6 8 8v8H80V56c0-4.4 3.6-8 8-8H192zM96 272h64v64H96V272zm-16 0v64c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16V272c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16zM288 144v24H264V144h24zm-64 0h24v24H224V144zm0 40h24v24H224V184zm64 24H264V184h24v24zm-64-80c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H224zm-88 16h24v24H136V144zm-16 0v24H96V144h24zm0 40v24H96V184h24zm16 24V184h24v24H136zM80 144v64c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16z"],
    "cucumber": [512, 512, [129362], "e401", "M219.2 463.3c5.6 1.8 11.8 .4 16.2-3.9c4.3-4.3 5.7-10.6 4-16.1c-1.8-5.7-.2-11.9 4-16.1L427.2 243.2c4.2-4.2 10.4-5.7 16.1-4c5.5 1.7 11.8 .4 16.1-4c4.4-4.4 5.7-10.6 3.9-16.2c-1.7-5.4-.4-11.4 3.4-15.6c40.2-43.9 39-112.2-3.5-154.7c-43.7-43.7-114.7-43.7-158.4 0l-124 124c-4.2 4.2-10.4 5.7-16.1 4c-5.5-1.7-11.8-.4-16.1 4s-5.7 10.6-4 16.1c1.8 5.7 .2 11.9-4 16.1l-92 92c-43.7 43.7-43.7 114.7 0 158.4c42.5 42.5 110.8 43.7 154.7 3.5c4.2-3.9 10.2-5.2 15.6-3.4zM474.5 37.5c48.6 48.6 49.9 126.6 4 176.8c3.5 11 .9 23.6-7.9 32.3c-8.7 8.7-21.2 11.3-32.2 7.9L254.6 438.5c3.4 11 .8 23.5-7.9 32.2c-8.7 8.7-21.3 11.4-32.3 7.9c-50.2 45.9-128.2 44.6-176.8-4c-50-50-50-131 0-181l92-92c-3.4-11-.8-23.5 7.9-32.2s21.2-11.3 32.2-7.9l124-124c50-50 131-50 181 0zM336 128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM160 304a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "head-side-brain": [512, 512, [], "f808", "M16 222.9C16 108.6 108.6 16 222.9 16h16.8c71.6 0 137.5 43.3 166.4 105c3.5 7.4 6.9 15.1 10.4 22.9c6.4 14.3 12.9 28.9 20.1 42.7c11.3 21.6 24.8 42.2 43.5 58.9l3.8 3.4c7.7 6.9 12.1 16.7 12.1 27c0 20-16.2 36.2-36.2 36.2H440c-4.4 0-8 3.6-8 8v72c0 22.1-17.9 40-40 40H312c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8s8-3.6 8-8V448h72c30.9 0 56-25.1 56-56V328h11.8c28.8 0 52.2-23.4 52.2-52.2c0-14.9-6.4-29.1-17.5-39l-3.8-3.4c-16.7-14.9-29.2-33.6-40-54.4c-7-13.4-13.1-27.1-19.3-41c-3.5-7.9-7.1-15.9-10.8-23.9C389.1 46.9 317.6 0 239.7 0H222.9C99.8 0 0 99.8 0 222.9c0 52.8 16.9 101.5 47.4 139.9C57.5 375.5 64 390.2 64 405.3V504c0 4.4 3.6 8 8 8s8-3.6 8-8V405.3c0-19.8-8.5-37.8-20.1-52.4C31.8 317.5 16 272.3 16 222.9zM194 113.8c6-10.7 17.2-17.8 30-17.8s24.1 7.1 30 17.8c2.1 3.8 7 5.2 10.8 3.1c4.3-2.4 9.2-3.7 14.4-3.7c10.6 0 19.9 5.5 25.4 14c1.7 2.6 4.8 4.1 7.9 3.6c1.6-.2 3.3-.4 5-.4c19 0 34.5 15.6 34.5 35.1s-15.5 35.1-34.5 35.1h-46c-2.7 0-5.2 1.4-6.7 3.6s-1.7 5.1-.7 7.6c1.9 4.3 2.9 9 2.9 14.1c0 17-11.9 31.2-27.6 34.4c-4.3 .9-7.1 5.1-6.2 9.4s5.1 7.1 9.4 6.2c23.1-4.8 40.4-25.4 40.4-50.1c0-3.1-.3-6.2-.8-9.2h35.3c28 0 50.5-23 50.5-51.1s-22.5-51.1-50.5-51.1c-.8 0-1.6 0-2.3 .1c-8.5-10.5-21.4-17.3-35.9-17.3c-5.4 0-10.5 .9-15.3 2.6c-9.2-12-23.7-19.8-40-19.8s-30.7 7.8-40 19.8c-4.8-1.7-9.9-2.6-15.3-2.6c-21.6 0-39.5 14.9-44.7 34.9c-24.9 3.2-44 24.8-44 50.7c0 19 10.3 35.6 25.5 44.4c.7 27.5 22.9 49.8 50.5 49.8c3.1 0 6.1-.3 9-.8V312c0 4.4 3.6 8 8 8s8-3.6 8-8V265.3c0-2.7-1.4-5.2-3.6-6.7s-5.1-1.7-7.6-.6c-4.2 1.9-8.9 2.9-13.8 2.9c-19 0-34.5-15.6-34.5-35.1c0-1 0-1.9 .1-2.9c.3-3.4-1.6-6.6-4.8-8C104.6 209.6 96 197.2 96 182.8c0-19.5 15.5-35.1 34.5-35.1l.2 0c4.1 0 7.5-3.1 8-7.1c1.7-15.5 14.6-27.3 30.1-27.3c5.2 0 10.1 1.3 14.4 3.7c3.9 2.1 8.7 .7 10.8-3.1z"],
    "hand": [512, 512, [129306, 9995, "hand-paper"], "f256", "M232 48V72l0 0V248c0 4.4-3.6 8-8 8s-8-3.6-8-8V80l0 0c0-17.7-14.3-32-32-32s-32 14.3-32 32V335.4c0 3.2-1.9 6.2-4.9 7.4s-6.4 .6-8.7-1.7L70.6 273.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L137.1 430.4c42 42 99 65.6 158.4 65.6H304c83.9 0 152-68.1 152-152V144c0-17.7-14.3-32-32-32s-32 14.3-32 32v56 48c0 4.4-3.6 8-8 8s-8-3.6-8-8V200 144v-8V80c0-17.7-14.3-32-32-32s-32 14.3-32 32V248c0 4.4-3.6 8-8 8s-8-3.6-8-8V80 72l0-24c0-17.7-14.3-32-32-32s-32 14.3-32 32zM264 0c25.3 0 46 19.5 47.9 44.3C320.4 36.7 331.6 32 344 32c26.5 0 48 21.5 48 48v28.2c8.5-7.6 19.7-12.2 32-12.2c26.5 0 48 21.5 48 48V344c0 92.8-75.2 168-168 168h-8.5c-63.7 0-124.7-25.3-169.7-70.3L14.1 329.9c-18.7-18.7-18.7-49.1 0-67.9s49.1-18.7 67.9 0L136 316.1V80c0-26.5 21.5-48 48-48c12.4 0 23.6 4.7 32.1 12.3C218 19.5 238.7 0 264 0z"],
    "person-biking-mountain": [640, 512, [128693, "biking-mountain"], "f84b", "M392 96a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm0-96a56 56 0 1 1 0 112A56 56 0 1 1 392 0zM335.7 151.2c-9-7.4-22-7.2-30.8 .4l-59.1 50.7c-12.2 10.4-10.9 29.7 2.6 38.4l100 64.7c2.3 1.5 3.7 4 3.7 6.7V416c0 4.4-3.6 8-8 8s-8-3.6-8-8V316.4L239.6 254c-22.4-14.5-24.6-46.6-4.3-64l59.1-50.7c14.7-12.6 36.4-12.9 51.4-.6l65 53.2H488c4.4 0 8 3.6 8 8s-3.6 8-8 8H408c-1.8 0-3.6-.6-5.1-1.8l-67.3-55zM490.3 284.8c-.6 2.9-2.7 5.3-5.6 6.1c-6.8 2-13.2 4.7-19.3 8c-2.6 1.4-5.8 1.3-8.3-.3c-6.2-4.1-14.7-3.4-20.1 2l-8.5 8.5c-5.5 5.5-6.2 13.9-2 20.1c1.6 2.5 1.8 5.7 .3 8.3c-3.3 6.1-6 12.5-8 19.3c-.8 2.9-3.2 5-6.1 5.6c-7.3 1.5-12.8 7.9-12.8 15.7v12c0 7.7 5.5 14.2 12.8 15.7c2.9 .6 5.3 2.7 6.1 5.6c2 6.8 4.7 13.2 8 19.3c1.4 2.6 1.3 5.8-.3 8.3c-4.1 6.2-3.4 14.7 2 20.1l8.5 8.5c5.5 5.5 13.9 6.2 20.1 2c2.5-1.6 5.7-1.8 8.3-.3c6.1 3.3 12.5 6 19.3 8c2.9 .8 5 3.2 5.6 6.1c1.5 7.3 7.9 12.8 15.7 12.8h12c7.7 0 14.2-5.5 15.7-12.8c.6-2.9 2.7-5.3 5.6-6.1c6.8-2 13.2-4.7 19.3-8c2.6-1.4 5.8-1.3 8.3 .3c6.2 4.1 14.7 3.4 20.1-2l8.5-8.5c5.5-5.5 6.2-13.9 2-20.1c-1.6-2.5-1.8-5.7-.3-8.3c3.3-6.1 6-12.5 8-19.3c.8-2.9 3.2-5 6.1-5.6c7.3-1.5 12.8-7.9 12.8-15.7V378c0-7.7-5.5-14.2-12.8-15.7c-2.9-.6-5.3-2.7-6.1-5.6c-2-6.8-4.7-13.2-8-19.3c-1.4-2.6-1.3-5.8 .3-8.3c4.1-6.2 3.4-14.7-2-20.1l-8.5-8.5c-5.5-5.5-13.9-6.2-20.1-2c-2.5 1.6-5.7 1.8-8.3 .3c-6.1-3.3-12.5-6-19.3-8c-2.9-.8-5-3.2-5.6-6.1c-1.5-7.3-7.9-12.8-15.7-12.8H506c-7.7 0-14.2 5.5-15.7 12.8zM506 256h12c13.8 0 25.5 8.7 30 20.9c4.9 1.7 9.7 3.6 14.3 5.9c11.8-5.4 26.2-3.3 36 6.5l8.5 8.5c9.7 9.7 11.9 24.2 6.5 36c2.3 4.6 4.3 9.4 5.9 14.3c12.2 4.5 20.9 16.2 20.9 30v12c0 13.8-8.7 25.5-20.9 30c-1.7 4.9-3.6 9.7-5.9 14.3c5.4 11.8 3.3 26.2-6.5 36l-8.5 8.5c-9.7 9.7-24.2 11.9-36 6.5c-4.6 2.3-9.4 4.3-14.3 5.9c-4.5 12.2-16.2 20.9-30 20.9H506c-13.8 0-25.5-8.7-30-20.9c-4.9-1.7-9.7-3.6-14.3-5.9c-11.8 5.4-26.2 3.3-36-6.5l-8.5-8.5c-9.7-9.7-11.9-24.2-6.5-36c-2.3-4.6-4.3-9.4-5.9-14.3c-12.2-4.5-20.9-16.2-20.9-30V378c0-13.8 8.7-25.5 20.9-30c1.7-4.9 3.6-9.7 5.9-14.3c-5.4-11.8-3.3-26.2 6.5-36l8.5-8.5c9.7-9.7 24.2-11.9 36-6.5c4.6-2.3 9.4-4.3 14.3-5.9c4.5-12.2 16.2-20.9 30-20.9zM472 384a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm40 56a56 56 0 1 1 0-112 56 56 0 1 1 0 112zM122 272c-7.7 0-14.2 5.5-15.7 12.8c-.6 2.9-2.7 5.3-5.6 6.1c-6.8 2-13.2 4.7-19.3 8c-2.6 1.4-5.8 1.3-8.3-.3c-6.2-4.1-14.7-3.4-20.1 2L44.6 309c-5.5 5.5-6.2 13.9-2 20.1c1.6 2.5 1.8 5.7 .3 8.3c-3.3 6.1-6 12.5-8 19.3c-.8 2.9-3.2 5-6.1 5.6C21.5 363.8 16 370.3 16 378v12c0 7.7 5.5 14.2 12.8 15.7c2.9 .6 5.3 2.7 6.1 5.6c2 6.8 4.7 13.2 8 19.3c1.4 2.6 1.3 5.8-.3 8.3c-4.1 6.2-3.4 14.7 2 20.1l8.5 8.5c5.5 5.5 13.9 6.2 20.1 2c2.5-1.6 5.7-1.8 8.3-.3c6.1 3.3 12.5 6 19.3 8c2.9 .8 5 3.2 5.6 6.1c1.5 7.3 7.9 12.8 15.7 12.8h12c7.7 0 14.2-5.5 15.7-12.8c.6-2.9 2.7-5.3 5.6-6.1c6.8-2 13.2-4.7 19.3-8c2.6-1.4 5.8-1.3 8.3 .3c6.2 4.1 14.7 3.4 20.1-2l8.5-8.5c5.5-5.5 6.2-13.9 2-20.1c-1.6-2.5-1.8-5.7-.3-8.3c3.3-6.1 6-12.5 8-19.3c.8-2.9 3.2-5 6.1-5.6c7.3-1.5 12.8-7.9 12.8-15.7V378c0-7.7-5.5-14.2-12.8-15.7c-2.9-.6-5.3-2.7-6.1-5.6c-2-6.8-4.7-13.2-8-19.3c-1.4-2.6-1.3-5.8 .3-8.3c4.1-6.2 3.4-14.7-2-20.1l-8.5-8.5c-5.5-5.5-13.9-6.2-20.1-2c-2.5 1.6-5.7 1.8-8.3 .3c-6.1-3.3-12.5-6-19.3-8c-2.9-.8-5-3.2-5.6-6.1c-1.5-7.3-7.9-12.8-15.7-12.8H122zm-30 4.9c4.5-12.2 16.2-20.9 30-20.9h12c13.8 0 25.5 8.7 30 20.9c4.9 1.7 9.7 3.6 14.3 5.9c11.8-5.4 26.2-3.3 36 6.5l8.5 8.5c9.7 9.7 11.9 24.2 6.5 36c2.3 4.6 4.3 9.4 5.9 14.3c12.2 4.5 20.9 16.2 20.9 30v12c0 13.8-8.7 25.5-20.9 30c-1.7 4.9-3.6 9.7-5.9 14.3c5.4 11.8 3.3 26.2-6.5 36l-8.5 8.5c-9.7 9.7-24.2 11.9-36 6.5c-4.6 2.3-9.4 4.3-14.3 5.9c-4.5 12.2-16.2 20.9-30 20.9H122c-13.8 0-25.5-8.7-30-20.9c-4.9-1.7-9.7-3.6-14.3-5.9c-11.8 5.4-26.2 3.3-36-6.5l-8.5-8.5c-9.7-9.7-11.9-24.2-6.5-36c-2.3-4.6-4.3-9.4-5.9-14.3C8.7 415.5 0 403.8 0 390V378c0-13.8 8.7-25.5 20.9-30c1.7-4.9 3.6-9.7 5.9-14.3c-5.4-11.8-3.3-26.2 6.5-36l8.5-8.5c9.7-9.7 24.2-11.9 36-6.5c4.6-2.3 9.4-4.3 14.3-5.9zM128 344a40 40 0 1 0 0 80 40 40 0 1 0 0-80zm56 40A56 56 0 1 1 72 384a56 56 0 1 1 112 0zm82.1-282l-4.5-6.1c-16.3-22.2-47.8-26.2-69.1-8.8L149.9 122l34.4 46.9 81.9-67zm10.1 12.4l-81.9 67c-7.1 5.8-17.6 4.5-23-2.9L137 131.5c-5-6.9-3.8-16.5 2.8-21.8l42.7-34.9c28.4-23.2 70.4-17.9 92.1 11.7l4.5 6.1c5 6.9 3.8 16.5-2.8 21.8z"],
    "utensils-slash": [640, 512, [], "e464", "M143.9 9.3c.7-4.4-2.2-8.5-6.6-9.2s-8.5 2.2-9.2 6.6l-.9 5.4 14.3 11.3 2.3-14.1zm45.5 51.8L192 8.4c.2-4.4-3.2-8.2-7.6-8.4s-8.2 3.2-8.4 7.6L173.9 49l15.4 12.2zm55.5 43.8L240 7.6c-.2-4.4-4-7.8-8.4-7.6s-7.8 4-7.6 8.4l4.2 83.4 16.7 13.2zM127.2 195.6l-22.6-17.8c4.7 35.2 34.9 62.3 71.3 62.3h7.5l-23-18.2c-14.2-4.1-26.1-13.7-33.3-26.3zM200 253V504c0 4.4 3.6 8 8 8s8-3.6 8-8V265.6L200 253zm112-95v-.7c0-4-.3-7.9-1-11.8L287.9 6.7c-.7-4.4-4.8-7.3-9.2-6.6s-7.3 4.8-6.6 9.2l22.5 134.9L312 158zM528 328.5V24c0-13.3-10.7-24-24-24C488 0 384 32 384 176v38.8l16 12.6V176c0-67.7 24.2-107.4 48.9-130.3c12.5-11.6 25.5-19.2 36-23.8c5.3-2.3 9.9-3.8 13.4-4.8c3.7-1 5.6-1.1 5.7-1.1l0 0c4.4 0 8 3.6 8 8V315.9l16 12.6zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "print-magnifying-glass": [640, 512, ["print-search"], "f81a", "M144 160V64c0-26.5 21.5-48 48-48H421.5c12.7 0 24.9 5.1 33.9 14.1l26.5 26.5c9 9 14.1 21.2 14.1 33.9V160h16V90.5c0-17-6.7-33.3-18.7-45.3L466.7 18.7C454.7 6.7 438.5 0 421.5 0H192c-35.3 0-64 28.7-64 64v96h16zm-16 48H333.7c5.7-5.8 11.8-11.1 18.2-16H128c-35.3 0-64 28.7-64 64V384c0 17.7 14.3 32 32 32h32v64c0 17.7 14.3 32 32 32H480c15.8 0 29-11.5 31.6-26.6L498.2 472c-.7 .2-1.4 .5-2.2 .7V480c0 8.8-7.2 16-16 16H160c-8.8 0-16-7.2-16-16V352c0-8.8 7.2-16 16-16H288.8c-.5-5.3-.8-10.6-.8-16H160c-17.7 0-32 14.3-32 32v48H96c-8.8 0-16-7.2-16-16V256c0-26.5 21.5-48 48-48zm320 .1a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm0 240c32.5 0 62.1-12.1 84.7-32l93.7 93.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L544 404.8c19.9-22.6 32-52.2 32-84.7c0-70.7-57.3-128-128-128s-128 57.3-128 128s57.3 128 128 128z"],
    "folder-bookmark": [512, 512, [], "e186", "M448 464c26.5 0 48-21.5 48-48V160c0-26.5-21.5-48-48-48h-8V344c0 3.1-1.8 5.9-4.5 7.2s-6.1 1-8.5-1l-75-60-75 60c-2.4 1.9-5.7 2.3-8.5 1s-4.5-4.1-4.5-7.2V96c0-.4 0-.9 .1-1.3L231.4 62.1c-9-9-21.2-14.1-33.9-14.1H64C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H448zM424 112H301.3c-7.4 0-14.7-1.7-21.3-5V327.4l67-53.6c2.9-2.3 7.1-2.3 10 0l67 53.6V112zm8-16h16c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H197.5c17 0 33.3 6.7 45.3 18.7l35.9 35.9c6 6 14.1 9.4 22.6 9.4H432z"],
    "om": [512, 512, [128329], "f679", "M332.7 44.7l24-24c6.2-6.2 16.4-6.2 22.6 0l24 24c6.2 6.2 6.2 16.4 0 22.6l-24 24c-6.2 6.2-16.4 6.2-22.6 0l-24-24c-6.2-6.2-6.2-16.4 0-22.6zM368 80l11.3-11.3 1.4-1.4L392 56 380.7 44.7l-1.4-1.4L368 32 356.7 43.3l-1.4 1.4L344 56l11.3 11.3 1.4 1.4L368 80zM142.4 112c-26.2 0-49.4 12.6-64 32c-2.7 3.5-7.7 4.2-11.2 1.6s-4.2-7.7-1.6-11.2C83.1 111.1 111 96 142.4 96c53 0 96 43 96 96c0 33.4-17 62.8-42.9 80h71.6c27.2 0 53.7-9.3 75-26.3l22.2-17.8C380.4 215 400.4 208 421.1 208c50.2 0 90.9 40.7 90.9 90.9v94c0 48.1-39 87.1-87.1 87.1c-33 0-63.2-18.6-77.9-48.2l-10.1-20.3c-2-4-.4-8.8 3.6-10.7s8.8-.4 10.7 3.6l10.1 20.3c12 24.1 36.7 39.3 63.6 39.3c39.3 0 71.1-31.8 71.1-71.1v-94c0-41.4-33.5-74.9-74.9-74.9c-17 0-33.5 5.8-46.8 16.4l-22.2 17.8c-24.1 19.3-54.1 29.8-85 29.8H211.9c35.9 20.7 60.1 59.5 60.1 104c0 66.3-53.7 120-120 120H136C60.9 512 0 451.1 0 376c0-4.4 3.6-8 8-8s8 3.6 8 8c0 66.3 53.7 120 120 120h16c57.4 0 104-46.6 104-104s-46.6-104-104-104h-9.6H136c-4.4 0-8-3.6-8-8s3.6-8 8-8h6.4c44.2 0 80-35.8 80-80s-35.8-80-80-80zm151.2 10.3l148.8 0c3.1-3.1 8.2-3.1 11.3 .1c3.1 3.1 3.1 8.2 0 11.3L448 128c5.6 5.7 5.6 5.7 5.6 5.7l0 0 0 0 0 0-.1 .1-.3 .3c-.3 .2-.6 .6-1.1 1c-.9 .8-2.3 1.9-4 3.1c-3.5 2.5-8.7 5.8-15.7 9c-14 6.5-35.2 12.7-64.3 12.7s-50.3-6.3-64.3-12.7c-7-3.2-12.2-6.5-15.7-9c-1.8-1.3-3.1-2.3-4-3.1c-.5-.4-.8-.7-1.1-1l-.3-.3-.1-.1 0 0 0 0 0 0s0 0 5.6-5.7l-5.6 5.7c-3.1-3.1-3.1-8.2 0-11.3c3.1-3.1 8.1-3.1 11.3-.1zm148.8 0l-148.8 0 .1 .1c.1 .1 .3 .3 .6 .6c.6 .5 1.6 1.3 3 2.3c2.8 2 7.1 4.7 13.1 7.5c12 5.5 30.9 11.3 57.6 11.3s45.6-5.7 57.6-11.3c6-2.8 10.3-5.5 13.1-7.5c1.4-1 2.4-1.8 3-2.3c.3-.3 .5-.4 .6-.6l.1-.1zm0 0h0l0 0 0 0z"],
    "pi": [448, 512, [], "f67e", "M8 64c-4.4 0-8 3.6-8 8s3.6 8 8 8H128V259c0 63.6-21.6 125.3-61.4 174.9l-.9 1.1c-2.8 3.4-2.2 8.5 1.2 11.2s8.5 2.2 11.2-1.2l.9-1.1C121.1 391.4 144 326.2 144 259V80H304V390.6c0 31.7 25.7 57.4 57.4 57.4c21.8 0 41.6-12.3 51.4-31.8l2.3-4.7c2-4 .4-8.8-3.6-10.7s-8.8-.4-10.7 3.6l-2.3 4.7c-7 14-21.4 22.9-37.1 22.9c-22.9 0-41.4-18.6-41.4-41.4V80H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H8z"],
    "flask-round-potion": [448, 512, ["flask-potion"], "f6e1", "M160 16H288V149.3c0 13.1 7.9 24.2 18.8 29.5C371.4 209.7 416 275.6 416 352c0 5.4-.2 10.7-.6 15.9c-62.6-1.3-98.7-16.1-130.3-31.1c-3.1-1.5-6.2-3-9.3-4.5C245.9 317.9 217.1 304 171.8 304c-49.2 0-87.3 12.4-113.2 24.8c-11.1 5.3-19.9 10.6-26.4 15c3.1-72.9 46.7-135.2 109-165.1c10.9-5.2 18.8-16.4 18.8-29.5V16zM413.4 383.9c-6.5 39-24.8 74-51 101.3c-6.7 7-17 10.8-28.5 10.8H114.2c-11.6 0-21.8-3.9-28.5-10.8c-30.8-32-50.6-74.5-53.3-121.7c1.4-1.1 3.4-2.7 5.9-4.4c6.1-4.3 15.2-10 27.3-15.8C89.6 331.6 125.4 320 171.8 320c41.5 0 67.2 12.4 97 26.8c3.1 1.5 6.1 3 9.3 4.5c32.6 15.5 70.6 31.1 135.2 32.6zM304 149.3V16h24c4.4 0 8-3.6 8-8s-3.6-8-8-8H288 160 120c-4.4 0-8 3.6-8 8s3.6 8 8 8l24 0V149.3c0 6.5-3.9 12.2-9.7 15C64.3 197.8 16 269.3 16 352c0 56 22.1 106.9 58.2 144.3C84.5 507 99.3 512 114.2 512H333.8c15 0 29.7-5 40.1-15.7C409.9 458.9 432 408 432 352c0-82.7-48.3-154.2-118.3-187.7c-5.8-2.8-9.7-8.6-9.7-15z"],
    "face-shush": [512, 512, [], "e38c", "M256 16C123.5 16 16 123.5 16 256c0 87.2 46.5 163.6 116.1 205.6c3.8 2.3 5 7.2 2.7 11s-7.2 5-11 2.7C49.7 430.5 0 349 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 78.4-35.3 148.7-90.8 195.6c-3.4 2.9-8.4 2.4-11.3-.9s-2.4-8.4 .9-11.3C462.9 395.3 496 329.5 496 256C496 123.5 388.5 16 256 16zM160.4 144a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm160 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-155 74c12.7 11.3 32.2 23.3 58.7 29v-7c0-17.7 14.3-32 32-32s32 14.3 32 32v7c26.5-5.6 46-17.7 58.7-29c3.3-2.9 8.4-2.7 11.3 .6s2.7 8.4-.6 11.3c-15 13.4-38.2 27.4-69.3 33.3v61.3c23.5 9.5 40 32.5 40 59.3v8c0 17.7-14.3 32-32 32s-32-14.3-32-32v-8H232v15.7l64.3 46.8c2.1-1 4-2.4 5.5-4.2l25.6-30.7c11.3-13.6 31.5-15.4 45.1-4.1s15.4 31.5 4.1 45.1L351 483.2c-15.2 18.2-37.7 28.8-61.5 28.8H288 232c-35.3 0-64-28.7-64-64V416 384c0-32.6 24.4-59.6 56-63.5V263.3c-31.2-5.9-54.3-19.9-69.3-33.3c-3.3-2.9-3.6-8-.6-11.3s8-3.6 11.3-.6zm90.7 6c-8.8 0-16 7.2-16 16v80h32V240c0-8.8-7.2-16-16-16zM232 368h32c8.8 0 16 7.2 16 16v8c0 8.8 7.2 16 16 16s16-7.2 16-16v-8c0-26.5-21.5-48-48-48H232c-26.5 0-48 21.5-48 48v32 32c0 26.5 21.5 48 48 48h56 1.5c19 0 37-8.4 49.2-23l25.6-30.7c5.7-6.8 4.7-16.9-2-22.5s-16.9-4.7-22.5 2l-25.6 30.7c-5.3 6.4-12.9 10.4-21.2 11.3l-76.9-56V384c0-8.8 7.2-16 16-16z"],
    "worm": [512, 512, [], "e599", "M432 178.3V164.4l-13.7-2-54.4-7.8c-34.3-4.9-59.8-34.3-59.8-69C304 47.2 335.2 16 373.7 16h48.7C463 16 496 49 496 89.6V176v16V360c0 75.1-60.9 136-136 136s-136-60.9-136-136V312c0-39.8-32.2-72-72-72s-72 32.2-72 72V464c0 17.7-14.3 32-32 32s-32-14.3-32-32V312c0-75.1 60.9-136 136-136s136 60.9 136 136v48c0 39.8 32.2 72 72 72s72-32.2 72-72V178.3zM373.7 0C326.4 0 288 38.4 288 85.7c0 42.6 31.4 78.8 73.6 84.8l54.4 7.8V360c0 30.9-25.1 56-56 56s-56-25.1-56-56V312c0-83.9-68.1-152-152-152S0 228.1 0 312V464c0 26.5 21.5 48 48 48s48-21.5 48-48V312c0-30.9 25.1-56 56-56s56 25.1 56 56v48c0 83.9 68.1 152 152 152s152-68.1 152-152V192 176 89.6C512 40.1 471.9 0 422.4 0H373.7zM400 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "house-circle-xmark": [640, 512, [], "e50b", "M282.7 2c3-2.7 7.6-2.7 10.6 0l215 190.4c-4.1-.3-8.2-.4-12.3-.4c-4 0-8 .1-11.9 .4L288 18.7 80 202.9V448c0 26.5 21.5 48 48 48h80V328c0-13.3 10.7-24 24-24H332c-2 5.2-3.8 10.6-5.4 16H256 232c-4.4 0-8 3.6-8 8V496h32 96 16 7.2c6.1 5.8 12.7 11.1 19.6 16H128c-35.3 0-64-28.7-64-64V217.1L13.3 262c-3.3 2.9-8.4 2.6-11.3-.7S-.6 252.9 2.7 250L282.7 2zM624 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm205.7-50.3L507.3 368l50.3 50.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L496 379.3l-50.3 50.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L484.7 368l-50.3-50.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L496 356.7l50.3-50.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "plug": [384, 512, [128268], "f1e6", "M112 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V112h16V8zM288 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V112h16V8zM8 144c-4.4 0-8 3.6-8 8s3.6 8 8 8H40v80c0 81.3 63.8 147.6 144 151.8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V391.8c80.2-4.2 144-70.5 144-151.8V160h32c4.4 0 8-3.6 8-8s-3.6-8-8-8H344 328 56 40 8zM192 376c-75.1 0-136-60.9-136-136V160H328v80c0 75.1-60.9 136-136 136z"],
    "calendar-circle-exclamation": [576, 512, [], "e46e", "M128 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H64C28.7 64 0 92.7 0 128v48 16V448c0 35.3 28.7 64 64 64H330.8c-6.9-4.9-13.5-10.2-19.6-16H64c-26.5 0-48-21.5-48-48V192H352h80 16V176 128c0-35.3-28.7-64-64-64H336V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H128V8zM112 80v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80H320v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80h48c26.5 0 48 21.5 48 48v48H16V128c0-26.5 21.5-48 48-48h48zM304 368a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 448a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-168c-4.4 0-8 3.6-8 8v96c0 4.4 3.6 8 8 8s8-3.6 8-8V288c0-4.4-3.6-8-8-8z"],
    "square-i": [448, 512, [], "e272", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm136 32h88 88c4.4 0 8 3.6 8 8s-3.6 8-8 8H232V368h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H136c-4.4 0-8-3.6-8-8s3.6-8 8-8h80V144H136c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "chevron-up": [512, 512, [], "f077", "M250.3 114.3c3.1-3.1 8.2-3.1 11.3 0l216 216c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L256 131.3 45.7 341.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l216-216z"],
    "face-saluting": [640, 512, [129761], "e484", "M234.8 20L56.7 138.6c-39.1 26-30.1 85.8 14.8 99.2c15.5 4.6 32.2 2.3 45.8-6.5l96.9-62.2c11.2-7.2 14.4-22 7.2-33.2s-22-14.4-33.2-7.2l-38.4 24.7c-3.7 2.4-8.6 1.3-11-2.4s-1.4-8.6 2.3-11L261.4 60c11-7.3 14-22.2 6.7-33.3s-22.2-14-33.3-6.7zm46.6-2.2c12.2 18.4 7.3 43.2-11.1 55.5l-56.5 37.6c8.5 2.8 16 8.3 21.2 16.4c11.9 18.6 6.5 43.3-12.1 55.3L126 244.8c-17.5 11.3-39.1 14.3-59.1 8.3C9 235.8-2.5 158.8 47.9 125.2L225.9 6.7c18.4-12.2 43.2-7.3 55.5 11.1zM352 16c-10.5 0-20.8 .7-31 2c-4.4 .6-8.4-2.5-9-6.9s2.5-8.4 6.9-9C329.8 .7 340.8 0 352 0C493.4 0 608 114.6 608 256s-114.6 256-256 256c-117 0-215.6-78.4-246.2-185.5c-1.2-4.2 1.2-8.7 5.5-9.9s8.7 1.2 9.9 5.5C149.9 422.5 242.4 496 352 496c132.5 0 240-107.5 240-240S484.5 16 352 16zM234 343.7c2.9-3.3 8-3.6 11.3-.6c20.4 18.2 55.9 38 106.7 38s86.3-19.8 106.7-38c3.3-2.9 8.4-2.7 11.3 .6s2.7 8.4-.6 11.3c-22.9 20.5-62.1 42-117.3 42s-94.4-21.6-117.3-42c-3.3-2.9-3.6-8-.6-11.3zM272.4 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm144 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "gauge-simple-low": [512, 512, ["tachometer-slow"], "f62c", "M256 496a240 240 0 1 0 0-480 240 240 0 1 0 0 480zM256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zm0 400a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0 16c-35.3 0-64-28.7-64-64c0-22.2 11.3-41.7 28.4-53.2L136.8 131.6c-2-4-.4-8.8 3.6-10.7s8.8-.4 10.7 3.6l83.6 167.2c6.6-2.3 13.8-3.6 21.2-3.6c35.3 0 64 28.7 64 64s-28.7 64-64 64z"],
    "face-persevering": [512, 512, [], "e385", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM322.1 413.4C309.3 399.1 287.3 384 256 384s-53.3 15.1-66.1 29.4c-3 3.3-8 3.6-11.3 .6s-3.6-8-.6-11.3C193.1 386 219.1 368 256 368s62.9 18 77.9 34.6c3 3.3 2.7 8.3-.6 11.3s-8.3 2.7-11.3-.6zM205.7 98.3c3.1 3.1 3.1 8.2 0 11.3l-7.4 7.4c-22.4 22.4-51.2 37.2-82.5 42.5l-2.5 .4c-4.4 .7-8.5-2.2-9.2-6.6s2.2-8.5 6.6-9.2l2.5-.4c28-4.7 53.8-17.9 73.8-38l7.4-7.4c3.1-3.1 8.2-3.1 11.3 0zm100.7 11.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l7.4 7.4c20 20 45.8 33.3 73.8 38l2.5 .4c4.4 .7 7.3 4.8 6.6 9.2s-4.8 7.3-9.2 6.6l-2.5-.4c-31.3-5.2-60.1-20.1-82.5-42.5l-7.4-7.4zM128.8 228.4c2-4 6.8-5.6 10.7-3.6l80 40c2.7 1.4 4.4 4.1 4.4 7.2s-1.7 5.8-4.4 7.2l-80 40c-4 2-8.8 .4-10.7-3.6s-.4-8.8 3.6-10.7L198.1 272l-65.7-32.8c-4-2-5.6-6.8-3.6-10.7zm243.6-3.6c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7L313.9 272l65.7 32.8c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-80-40c-2.7-1.4-4.4-4.1-4.4-7.2s1.7-5.8 4.4-7.2l80-40z"],
    "circle-camera": [512, 512, ["camera-circle"], "e103", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM206.6 136.8L195.1 160H168c-22.1 0-40 17.9-40 40V312c0 22.1 17.9 40 40 40H344c22.1 0 40-17.9 40-40V200c0-22.1-17.9-40-40-40H316.9l-11.6-23.2c-2.7-5.4-8.3-8.8-14.3-8.8H220.9c-6.1 0-11.6 3.4-14.3 8.8zm14.3 7.2h70.1l13.8 27.6c1.4 2.7 4.1 4.4 7.2 4.4h32c13.3 0 24 10.7 24 24V312c0 13.3-10.7 24-24 24H168c-13.3 0-24-10.7-24-24V200c0-13.3 10.7-24 24-24h32c3 0 5.8-1.7 7.2-4.4L220.9 144zM256 304a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-32-48a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "hand-spock": [543, 512, [128406], "f259", "M247.4 34.7l7.2-2.1v0l-7.2 2.1zM200.8 9l2.1 7.2h0L200.8 9zM362.9 66.7l7.3 1.7v0l-7.3-1.7zm45.3-28L406.4 46l1.7-7.3zm28 45.3l-7.3-1.7h0l7.3 1.7zm-5.4 42.3l-7.3-1.9 7.3 1.9zm45.8-27.2l-1.9 7.3 1.9-7.3zm27.2 45.8l-7.3-1.9v0l7.3 1.9zM444.4 377.1l-7.3-1.9 7.3 1.9zM318.2 475.4v-7.5h0l0 7.5zm-.3 0l0 7.5 0 0 0-7.5zm-.3 0l0-7.5h0v7.5zm-158.9-52l-4.9 5.7 4.9-5.7zm-105.8-90l4.9-5.7h0l-4.9 5.7zm-4.3-53.1l-5.7-4.9h0l5.7 4.9zm53.1-4.3l-4.9 5.7h0l4.9-5.7zm13.5-144.5l-7.2 2.2 7.2-2.2zM187 109.3l7.2-2.2h0l-7.2 2.2zM175.1 55.6l-7.2 2.1 7.2-2.1zm58.4 201.8l-7.2 2.1 7.2-2.1zm-.6 .2l7.2-2.2-7.2 2.2zm-72 68.9l-4.9 5.7 4.9-5.7zm12.1-8l-7.2 2.2 7.2-2.2zm138.3-63.4l-7.2 2.1 7.2-2.1zm8.5 220.3l-.1-7.5 .1 7.5zm77.7-218.3l7.3 1.9-7.3-1.9zm-78.8-2.2l7.3 1.7-7.3-1.7zm76.9 1.8l7.3 1.7-7.3-1.7zM254.7 32.6c-6.9-24-32-37.8-56-30.8l4.2 14.5c16-4.6 32.7 4.6 37.3 20.6l14.5-4.2zM318.5 253L254.7 32.6l-14.5 4.2L304 257.2l14.5-4.2zm37.1-188L311.2 253.2l14.7 3.4L370.2 68.4l-14.7-3.4zm54.3-33.6c-24.3-5.7-48.6 9.3-54.3 33.6l14.7 3.4c3.8-16.2 20-26.2 36.2-22.4l3.5-14.7zm33.6 54.3c5.7-24.3-9.3-48.6-33.6-54.3L406.4 46c16.2 3.8 26.2 20 22.4 36.2l14.7 3.4zM402.8 258.4L443.5 85.6l-14.7-3.4L388.2 254.9l14.7 3.4zm20.7-134L390.1 255.2l14.6 3.7 33.4-130.9-14.6-3.7zm55-32.6c-24.2-6.2-48.8 8.4-55 32.6l14.6 3.7c4.1-16.1 20.5-25.8 36.6-21.7l3.7-14.6zm32.6 55c6.2-24.2-8.4-48.8-32.6-55l-3.7 14.6c16.1 4.1 25.8 20.5 21.7 36.6l14.6 3.7zM451.7 378.9L511 146.7 496.4 143 437.1 375.2l14.6 3.7zm-131.9 104c62.3-.9 116.5-43.4 131.9-104l-14.6-3.7c-13.8 54-62 91.9-117.6 92.6l.2 15.1zm-1.6 0h1.5V467.9h-1.5v15.1zm-.3 0l.3 0 0-15.1-.3 0 0 15.1zm-.4 0l.3 0 0-15.1-.3 0 0 15.1zm-17.4 0h17.4V467.9H300.1v15.1zM153.8 429.1c40.8 34.7 92.7 53.8 146.3 53.8V467.9c-50 0-98.4-17.8-136.5-50.2l-9.8 11.5zm-105.8-90l105.8 90 9.8-11.5-105.8-90-9.8 11.5zm-5.2-63.7c-16.2 19-13.8 47.5 5.2 63.7l9.8-11.5c-12.7-10.8-14.2-29.8-3.4-42.5l-11.5-9.8zm63.7-5.2c-19-16.2-47.5-13.8-63.7 5.2l11.5 9.8C65 272.6 84 271 96.7 281.8l9.8-11.5zm59.3 50.4l-59.3-50.4-9.8 11.5L156 332.2l9.8-11.5zM107.9 133.8l57.9 186.9 14.4-4.5L122.3 129.4l-14.4 4.5zm29.8-56.5c-23.8 7.4-37.2 32.7-29.8 56.5l14.4-4.5c-4.9-15.9 4-32.8 19.9-37.7l-4.5-14.4zm56.5 29.8c-7.4-23.8-32.7-37.2-56.5-29.8l4.5 14.4c15.9-4.9 32.8 4 37.7 19.9l14.4-4.5zm45.9 148.3L194.2 107.1l-14.4 4.5 45.9 148.3 14.4-4.5zM167.9 57.7l58.4 201.8 14.5-4.2L182.3 53.6l-14.5 4.2zm30.8-56c-24 6.9-37.8 32-30.8 56l14.5-4.2c-4.6-16 4.6-32.7 20.6-37.3L198.7 1.8zm34.5 263.6c5.2 0 9-5 7.5-10l-14.5 4.2c-1.3-4.6 2.1-9.2 6.9-9.2v15.1zm-7.5-5.5c1 3.3 4.1 5.5 7.5 5.5V250.3c3.2 0 6 2.1 6.9 5.1l-14.4 4.5zM156 332.2c11.5 9.8 28.6-1.5 24.1-15.9l-14.4 4.5 0 0L156 332.2zm148-75.1c1.4 4.8 5.8 8.2 10.9 8.2V250.3c1.7 0 3.1 1.1 3.6 2.7L304 257.2zm15.6 210.7c-4.1 .1-7.4 3.4-7.4 7.5h15.1c0 4.2-3.3 7.5-7.4 7.5l-.2-15.1zm76.9-202.5c3.9 0 7.3-2.6 8.2-6.4l-14.6-3.7c.7-2.9 3.4-4.9 6.4-4.9v15.1zm-84.3 210c0-4.2 3.4-7.5 7.5-7.5v15.1c4.2 0 7.5-3.4 7.5-7.5H312.1zm2.7-210c5.3 0 9.8-3.6 11-8.7l-14.7-3.4c.4-1.7 1.9-2.9 3.6-2.9v15.1zm73.3-10.4c-1.3 5.3 2.8 10.4 8.3 10.4V250.3c4.2 0 7.4 4 6.4 8.1l-14.7-3.4z"],
    "spider-web": [576, 512, [128376], "f719", "M145.7 13.2c1.4-3.6 5.1-5.8 9-5.1l78.2 14.7c38 7.1 77 7.1 115 0L426 8.1c3.8-.7 7.6 1.4 9 5.1l32.4 86.3c12.3 32.8 30 63.3 52.5 90.2l51 61.2c2.5 3 2.5 7.3 0 10.2l-51 61.2c-22.4 26.9-40.2 57.4-52.5 90.2l-32.4 86.3c-1.4 3.6-5.1 5.8-9 5.1l-78.2-14.7c-38-7.1-77-7.1-115 0l-78.2 14.7c-3.8 .7-7.6-1.4-9-5.1l-32.4-86.3c-12.3-32.8-30-63.3-52.4-90.2l-51-61.2c-2.5-3-2.5-7.3 0-10.2l51-61.2c22.4-26.9 40.2-57.4 52.4-90.2l32.4-86.3zM154.2 36l-25.9 69.2c-12.9 34.5-31.6 66.5-55.1 94.8l-40 48h91.1l7.8-8.9c26.1-29.8 46.3-64.3 59.4-101.7l7.9-22.4L154.2 36zm13.2-9.2l44.4 77.7c50.5 14.5 103.9 14.6 154.5 .4l44.4-77.7L350.7 38.5c-40 7.5-80.9 7.5-120.9 0L167.4 26.8zm258.1 6.7l-45.7 80 8.4 23.8c13.2 37.4 33.3 71.9 59.4 101.7l7.8 8.9h92.1l-40-48c-23.6-28.3-42.2-60.3-55.1-94.8L425.5 33.6zM547.5 264H455l-6.2 7.1c-26.9 30.8-47.5 66.5-60.7 105.2l-7.9 23.2 45.1 79 26.8-71.6c12.9-34.5 31.6-66.5 55.1-94.8l40-48zM410.6 484.7l-42.3-74.1c0 0-.1 0-.1 0l-.9-.3C317 393.6 262.9 392.5 212 407l-44.7 78.1 62.4-11.7c39.9-7.5 80.9-7.5 120.9 0l59.9 11.2zM154.2 476l45.2-79.2-8-22.6c-13.2-37.4-33.3-71.9-59.4-101.7l-7.5-8.6H33.1l40 48c23.6 28.3 42.2 60.3 55.1 94.8L154.2 476zm-8.4-212c26.6 30.9 47.2 66.5 60.8 104.9l3.4 9.6L275.4 264H145.8zm77.3 123.7c44.1-9.9 90-9 133.7 2.7L289.1 272.1 223.1 387.7zm146.6-6.8l3.3-9.8c13.3-39.2 33.9-75.6 60.8-107.1H302.9l66.8 116.9zM434.1 248c-26.8-31-47.5-66.7-61.1-105.3L369.2 132 302.9 248H434.1zM355.2 124.2c-43.6 9.8-88.8 9.7-132.4-.3l66.3 116 66.1-115.6zm-145.4 9.1l-3.3 9.3C192.9 181.3 172.2 217 145.5 248H275.4L209.8 133.4z"],
    "circle-microphone": [512, 512, ["microphone-circle"], "e116", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 160v96c0 35.3 28.7 64 64 64s64-28.7 64-64V160c0-35.3-28.7-64-64-64s-64 28.7-64 64zm64-48c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48s-48-21.5-48-48V160c0-26.5 21.5-48 48-48zM144 232c0-4.4-3.6-8-8-8s-8 3.6-8 8v24c0 68 53 123.6 120 127.8V408c0 4.4 3.6 8 8 8s8-3.6 8-8V383.8C331 379.6 384 324 384 256V232c0-4.4-3.6-8-8-8s-8 3.6-8 8v24c0 61.9-50.1 112-112 112s-112-50.1-112-112V232z"],
    "book-arrow-up": [448, 512, [], "e0ba", "M56 0C25.1 0 0 25.1 0 56V456c0 30.9 25.1 56 56 56H192V496H56c-22.1 0-40-17.9-40-40s17.9-40 40-40H192V400H56c-15.7 0-29.8 6.4-40 16.8V56c0-22.1 17.9-40 40-40H408c13.3 0 24 10.7 24 24V376c0 13.3-10.7 24-24 24H288v16H400v80H288v16H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H416V415.2c18.3-3.7 32-19.8 32-39.2V40c0-22.1-17.9-40-40-40H56zm74.3 234.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L232 155.3 232 504c0 4.4 3.6 8 8 8s8-3.6 8-8l0-348.7 90.3 90.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-104-104c-3.1-3.1-8.2-3.1-11.3 0l-104 104z"],
    "popsicle": [320, 512, [], "e43e", "M304 160c0-79.5-64.5-144-144-144S16 80.5 16 160V336c0 17.7 14.3 32 32 32H152V168c0-4.4 3.6-8 8-8s8 3.6 8 8V368H272c17.7 0 32-14.3 32-32V160zM152 384H48c-26.5 0-48-21.5-48-48V160C0 71.6 71.6 0 160 0s160 71.6 160 160V336c0 26.5-21.5 48-48 48H168V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V384z"],
    "command": [512, 512, [], "e142", "M0 80C0 35.8 35.8 0 80 0s80 35.8 80 80v64H352V80c0-44.2 35.8-80 80-80s80 35.8 80 80s-35.8 80-80 80H368V352h64c44.2 0 80 35.8 80 80s-35.8 80-80 80s-80-35.8-80-80V368H160v64c0 44.2-35.8 80-80 80s-80-35.8-80-80s35.8-80 80-80h64V160H80C35.8 160 0 124.2 0 80zm144 64V80c0-35.3-28.7-64-64-64S16 44.7 16 80s28.7 64 64 64h64zm16 208H352V160H160V352zm-16 16H80c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64V368zm224 0v64c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64H368zm0-224h64c35.3 0 64-28.7 64-64s-28.7-64-64-64s-64 28.7-64 64v64z"],
    "blinds": [512, 512, [], "f8fb", "M480 16c8.8 0 16 7.2 16 16V64c0 8.8-7.2 16-16 16H152 136 32c-8.8 0-16-7.2-16-16V32c0-8.8 7.2-16 16-16H480zM152 96H480c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H32C14.3 0 0 14.3 0 32V64C0 81.7 14.3 96 32 96H136V256.7c-22.7 3.8-40 23.6-40 47.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-23.8-17.3-43.5-40-47.3V96zm32 128H492.3c10.9 0 19.7-8.8 19.7-19.7c0-2.8-.6-5.7-1.8-8.2L478.8 128H461.1l34.5 74.8c.2 .5 .3 1 .3 1.5c0 2-1.6 3.7-3.7 3.7H184v16zm-80-16H19.7c-2 0-3.7-1.6-3.7-3.7c0-.5 .1-1.1 .3-1.5L50.9 128H33.2L1.8 196.1C.6 198.7 0 201.5 0 204.3C0 215.2 8.8 224 19.7 224H104V208zM64 304H19.7c-2 0-3.7-1.6-3.7-3.7c0-.5 .1-1.1 .3-1.5L36.1 256H18.5L1.8 292.1C.6 294.7 0 297.5 0 300.3C0 311.2 8.8 320 19.7 320H65.6c-1-5.2-1.6-10.5-1.6-16zm158.4 16H492.3c10.9 0 19.7-8.8 19.7-19.7c0-2.8-.6-5.7-1.8-8.2L493.5 256H475.9l19.7 42.8c.2 .5 .3 1 .3 1.5c0 2-1.6 3.7-3.7 3.7H224c0 5.5-.6 10.8-1.6 16zM18.5 352L1.8 388.1C.6 390.7 0 393.5 0 396.3C0 407.2 8.8 416 19.7 416H492.3c10.9 0 19.7-8.8 19.7-19.7c0-2.8-.6-5.7-1.8-8.2L493.5 352H475.9l19.7 42.8c.2 .5 .3 1 .3 1.5c0 2-1.6 3.7-3.7 3.7H19.7c-2 0-3.7-1.6-3.7-3.7c0-.5 .1-1.1 .3-1.5L36.1 352H18.5zM1.8 484.1C.6 486.7 0 489.5 0 492.3C0 503.2 8.8 512 19.7 512H492.3c10.9 0 19.7-8.8 19.7-19.7c0-2.8-.6-5.7-1.8-8.2L493.5 448H475.9l19.7 42.8c.2 .5 .3 1 .3 1.5c0 2-1.6 3.7-3.7 3.7H19.7c-2 0-3.7-1.6-3.7-3.7c0-.5 .1-1.1 .3-1.5L36.1 448H18.5L1.8 484.1zM176 304a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z"],
    "stopwatch": [448, 512, [9201], "f2f2", "M144 8c0-4.4 3.6-8 8-8H296c4.4 0 8 3.6 8 8s-3.6 8-8 8H232V96.2c55.4 2.1 105.3 25.9 141.4 63.1l36.9-36.9c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-37.6 37.6C414 207.2 432 253.5 432 304c0 114.9-93.1 208-208 208S16 418.9 16 304c0-112.2 88.8-203.6 200-207.8V16H152c-4.4 0-8-3.6-8-8zm80 488a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm8-312V320c0 4.4-3.6 8-8 8s-8-3.6-8-8V184c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "saxophone": [640, 512, [127927], "f8dc", "M487.6 53.1C501.1 39.6 519.4 32 538.5 32h27c19.1 0 37.4 7.6 50.9 21.1l16.3 16.3c4.7 4.7 7.3 11 7.3 17.7c0 13.8-11.2 25-25 25h-64c-7.2 0-13.9 3.2-18.5 8.7L283.8 421.8C253.4 458.7 208.1 480 160.3 480C71.8 480 0 408.2 0 319.7v-7.9c0-11.1 1.1-22.1 3.3-33L30.2 144H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H40 248h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H253.3L194 284.9c-1.3 3.1-2 6.4-2 9.8v4.9c0 11.2 9.1 20.3 20.3 20.3c5.4 0 10.5-2.1 14.3-5.9L344.6 196l-22.3-22.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L356 184.6 392.7 148l-22.3-22.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L404 136.7 440.7 100 418.3 77.7c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L452 88.7l35.6-35.6zM19 282c-2 9.8-3 19.8-3 29.8v7.9C16 399.4 80.6 464 160.3 464c43 0 83.8-19.2 111.2-52.4L520.2 110.5c7.6-9.2 18.9-14.5 30.8-14.5h64c5 0 9-4 9-9c0-2.4-.9-4.7-2.6-6.3L605.1 64.4C594.6 53.9 580.3 48 565.5 48h-27c-14.8 0-29.1 5.9-39.6 16.4l-261 260.8c-6.8 6.8-16 10.6-25.7 10.6c-20 0-36.3-16.2-36.3-36.3v-4.9c0-5.5 1.1-10.9 3.2-16L236 144H46.6L19 282zm93-58a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM96 304a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "square-2": [448, 512, [], "e257", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm187.4 61.9L157 182.2c-3.4 2.8-8.5 2.2-11.2-1.2s-2.2-8.5 1.2-11.2l30.4-24.3c14.1-11.3 31.7-17.3 49.8-17.1l2.3 0C270.8 129 304 162.7 304 204c0 20.1-8 39.3-22.1 53.5L171.3 368H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H152c-3.2 0-6.2-1.9-7.4-4.9s-.6-6.4 1.7-8.7L270.5 246.1C281.7 235 288 219.8 288 204c0-32.6-26.2-59.1-58.8-59.6l-2.3 0c-14.4-.2-28.3 4.6-39.6 13.6z"],
    "field-hockey-stick-ball": [512, 512, [127953, "field-hockey"], "f44c", "M502.8 76.2c15.6-21.4 10.8-51.5-10.6-67.1S440.8-1.7 425.2 19.8L145.3 404.7c-5 6.9-13.1 11.1-21.7 11.1c-14.9 0-27.1-12.2-27-27.2c0-3.7 .8-7.3 2.3-10.7l17-38.5c10.7-24.2-.3-52.6-24.5-63.3s-52.6 .3-63.3 24.5l-17 38.5C4.3 354.4 .7 371 .6 387.8C.1 456.2 55.4 512 123.9 511.8c39.2-.1 76-18.9 99.1-50.6L502.8 76.2zm-12.9-9.4l-70.3 96.6-53.3-35.5 71.8-98.7c10.4-14.3 30.4-17.5 44.7-7.1s17.5 30.4 7.1 44.7zM410.2 176.4L210 451.7c-20.1 27.6-52.1 43.9-86.2 44C64.3 496 16.1 447.4 16.6 388c.1-14.6 3.2-29 9.1-42.4l17-38.5c7.1-16.2 26-23.5 42.2-16.3s23.5 26 16.3 42.2l-17 38.5c-2.4 5.4-3.6 11.2-3.7 17c-.2 23.9 19.2 43.4 43 43.3c13.7 0 26.5-6.6 34.6-17.7L356.9 140.9l53.3 35.5zM432 368a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "arrow-up-square-triangle": [576, 512, ["sort-shapes-up-alt"], "f88b", "M154.3 34.3c3.1-3.1 8.2-3.1 11.3 0l104 104c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L168 59.3V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V59.3L61.7 149.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l104-104zM440.2 301.7L524.4 442c2.3 3.9 3.6 8.4 3.6 12.9c0 13.8-11.2 25.1-25.1 25.1H329.1c-13.8 0-25.1-11.2-25.1-25.1c0-4.5 1.2-9 3.6-12.9l84.2-140.3c5.1-8.5 14.3-13.7 24.2-13.7s19.1 5.2 24.2 13.7zM405.5 310L321.3 450.3c-.8 1.4-1.3 3-1.3 4.7c0 5 4.1 9.1 9.1 9.1H502.9c5 0 9.1-4.1 9.1-9.1c0-1.6-.4-3.3-1.3-4.7L426.5 310c-2.2-3.7-6.2-6-10.5-6s-8.3 2.3-10.5 6zM336 176c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V80c0-17.7-14.3-32-32-32H368c-17.7 0-32 14.3-32 32v96zm-16 0V80c0-26.5 21.5-48 48-48h96c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H368c-26.5 0-48-21.5-48-48z"],
    "face-scream": [640, 512, [], "e38b", "M80 256C80 123.5 187.5 16 320 16s240 107.5 240 240c0 4.4 3.6 8 8 8s8-3.6 8-8C576 114.6 461.4 0 320 0S64 114.6 64 256c0 4.4 3.6 8 8 8s8-3.6 8-8zM258.1 487.9c-4.3-1.1-8.7 1.4-9.8 5.7s1.4 8.7 5.7 9.8C275 509 297.2 512 320 512s45-3 66.1-8.6c4.3-1.1 6.8-5.5 5.7-9.8s-5.5-6.8-9.8-5.7c-19.8 5.3-40.5 8.1-61.9 8.1s-42.2-2.8-61.9-8.1zM181.5 193.2c10.5-17.2 25-29.7 39.7-36.1c14.7-6.5 28.9-6.7 39.8-.8c10.8 5.9 17.5 17.3 18.9 32.3c1.4 15-2.7 33-13.2 50.2s-25 29.7-39.7 36.1c-14.7 6.5-28.9 6.7-39.8 .8c-10.8-5.9-17.5-17.3-18.9-32.3c-1.4-15 2.7-33 13.2-50.2zm87.1-51c-16.4-9-36-7.7-53.9 .2c-17.9 7.9-34.8 22.7-46.9 42.4s-17.2 41.1-15.5 60c1.7 18.9 10.6 35.9 27.1 44.9c16.4 9 36 7.7 53.9-.2c17.9-7.9 34.8-22.7 46.9-42.4s17.2-41.1 15.5-60c-1.7-18.9-10.6-35.9-27.1-44.9zm150.3 14.8c14.7 6.5 29.2 19 39.7 36.1s14.6 35.2 13.2 50.2c-1.4 15-8.1 26.5-18.9 32.3c-10.9 5.9-25 5.7-39.8-.8c-14.7-6.5-29.2-19-39.7-36.1s-14.6-35.2-13.2-50.2c1.4-15 8.1-26.5 18.9-32.3c10.9-5.9 25-5.7 39.8 .8zm6.5-14.6c-17.9-7.9-37.5-9.1-53.9-.2c-16.5 9-25.4 26-27.1 44.9c-1.7 18.9 3.5 40.3 15.5 60s28.9 34.5 46.9 42.4c17.9 7.9 37.5 9.1 53.9 .2c16.5-9 25.4-26 27.1-44.9c1.7-18.9-3.5-40.3-15.5-60s-28.9-34.5-46.9-42.4zM368 368v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V368c0-26.5 21.5-48 48-48s48 21.5 48 48zm-112 0v32c0 35.3 28.7 64 64 64s64-28.7 64-64V368c0-35.3-28.7-64-64-64s-64 28.7-64 64zM55.9 325.7c7.7-5 16.6-6.6 25.1-5.3c6.3 1 12.3 3.7 17.3 7.8c24.7 20.6 46.2 51 61.5 84.3s24.2 68.9 24.1 99.4l16 0c.1-33.4-9.5-71.3-25.6-106.2s-38.8-67.4-65.8-89.9l0 0c-7.2-6-16-9.9-25-11.3c-12.2-1.9-25.1 .4-36.3 7.6l0 0c-23.7 15.4-30.4 46.9-14.8 70.4C56.8 419.6 74.2 465.9 74.2 512h16c0-49.9-18.7-99.3-44.4-138.2l0 0c-10.7-16-6.2-37.6 10.1-48.1zm503-5.3c8.5-1.3 17.4 .3 25.1 5.3c16.3 10.6 20.8 32.1 10.1 48.1l0 0c-25.7 38.9-44.4 88.2-44.4 138.2h16c0-46.1 17.4-92.4 41.8-129.3c15.6-23.5 9-55-14.8-70.4c-11.1-7.2-24.1-9.6-36.3-7.6c-9.1 1.4-17.8 5.3-25 11.3l0 0c-26.9 22.5-49.7 55-65.8 89.9s-25.6 72.8-25.6 106.2l16 0c-.1-30.6 8.8-66.2 24.1-99.4s36.8-63.7 61.5-84.3c5-4.1 11-6.8 17.3-7.8z"],
    "square-m": [448, 512, [], "e276", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm110.5 35.4L224 290.2 337.5 131.4c2-2.8 5.6-4 9-3s5.6 4.1 5.6 7.6V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V161L230.5 308.6c-1.5 2.1-3.9 3.4-6.5 3.4s-5-1.2-6.5-3.4L112 161V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-3.5 2.2-6.6 5.6-7.6s6.9 .1 9 3z"],
    "camera-web": [448, 512, ["webcam"], "f832", "M432 224A208 208 0 1 0 16 224a208 208 0 1 0 416 0zm16 0c0 73.7-35.6 139-90.5 179.9L411 473.4c5.6 7.2 6.5 17 2.5 25.2s-12.4 13.4-21.5 13.4H56c-9.1 0-17.5-5.2-21.5-13.4s-3.1-18 2.5-25.2l53.5-69.5C35.6 363 0 297.7 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224zM224 448c-44.3 0-85.6-12.9-120.4-35.1l-54 70.2c-1.9 2.4-2.2 5.7-.8 8.4s4.1 4.5 7.2 4.5H392c3 0 5.8-1.7 7.2-4.5s1-6-.8-8.4l-54-70.2C309.6 435.1 268.3 448 224 448zM352 224A128 128 0 1 0 96 224a128 128 0 1 0 256 0zM80 224a144 144 0 1 1 288 0A144 144 0 1 1 80 224zm88 0c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-39.8 32.2-72 72-72c4.4 0 8 3.6 8 8s-3.6 8-8 8c-30.9 0-56 25.1-56 56z"],
    "comment-arrow-down": [512, 512, [], "e143", "M157.3 415c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8C68.3 456 41.6 464 16 464l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C28 450 34 442 40 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C31.9 318.8 16 280.7 16 240C16 136.9 120.2 48 256 48s240 88.9 240 192s-104.2 192-240 192c-35.2 0-68.6-6.1-98.7-17zM4.7 452.7l0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0zM264 136c0-4.4-3.6-8-8-8s-8 3.6-8 8V308.7l-74.3-74.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l88 88c3.1 3.1 8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L264 308.7V136z"],
    "lightbulb-cfl": [320, 512, [], "e5a6", "M160 47.7c0 14.1-9.6 26.4-23.2 29.9l-.1 0L54.4 98.2l0 0C34.9 103 16.1 88.3 16.1 68.3c0-14.1 9.6-26.5 23.3-29.9l82.2-20.6C141.1 13 160 27.7 160 47.7zM.1 68.3c0 17.2 9.2 31.9 22.5 40C8.9 116.6 .1 131.6 .1 148.3c0 17.2 9.2 31.9 22.5 40C8.9 196.6 .1 211.6 .1 228.3c0 30.5 28.6 52.8 58.2 45.4l95.6-23.9 0 0 111.7-27.9 .1 0c19.4-4.8 38.2 9.9 38.2 29.9c0 14.1-9.6 26.5-23.3 29.9l-70.5 17.6c-10.7 2.7-18.2 12.3-18.2 23.3V352H128V285.2l-16 4V352H96c-17.7 0-32 14.3-32 32v48c0 17.7 14.3 32 32 32h16c0 26.5 21.5 48 48 48s48-21.5 48-48h16c17.7 0 32-14.3 32-32V384c0-17.7-14.3-32-32-32H207.9V322.5c0-3.7 2.5-6.9 6.1-7.8l70.5-17.6c20.8-5.2 35.5-23.9 35.5-45.4c0-17.2-9.2-31.9-22.5-40c13.7-8.3 22.5-23.3 22.5-40c0-17.2-9.2-31.9-22.5-40c13.7-8.3 22.5-23.3 22.5-40c0-30.5-28.6-52.8-58.2-45.4L170.8 69.1c3.3-6.4 5.1-13.7 5.1-21.3c0-30.5-28.6-52.8-58.2-45.4L35.6 22.9C14.7 28.1 .1 46.8 .1 68.3zm39.3 50.1l18.8-4.7 .1 0 82.2-20.6 .1 0 125-31.3c19.4-4.9 38.3 9.8 38.3 29.9c0 14.1-9.6 26.5-23.3 29.9l-18.8 4.7L54.4 178.2c-19.4 4.9-38.3-9.8-38.3-29.9c0-14.1 9.6-26.5 23.3-29.9zM199.9 368l0 0 0 0H224c8.8 0 16 7.2 16 16v48c0 8.8-7.2 16-16 16H200 120 96c-8.8 0-16-7.2-16-16V384c0-8.8 7.2-16 16-16H199.9zm62-161.7l-.1 0L150 234.2 54.4 258.2c-19.4 4.9-38.3-9.8-38.3-29.9c0-14.1 9.6-26.5 23.3-29.9l18.8-4.7 207.4-51.8c19.4-4.9 38.3 9.8 38.3 29.9c0 14.1-9.6 26.5-23.3 29.9l-18.7 4.7zM160 496c-17.7 0-32-14.3-32-32h64c0 17.7-14.3 32-32 32z"],
    "window-frame-open": [512, 512, [], "e050", "M264 16V272H464V64c0-26.5-21.5-48-48-48H264zM480 64V272v16H464 48 32V272 64C32 28.7 60.7 0 96 0H416c35.3 0 64 28.7 64 64zM248 272V16H96C69.5 16 48 37.5 48 64V272H248zM8 496H32V320H48V496H464V320h16V496h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H472 40 8c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm241.4 16.1c11.4 2.1 22.8 5.4 33.6 9.8c8.4 3.4 17.2 7.9 24.2 13.7c6.9 5.9 12.8 14 12.8 24.4c0 10.2-6.4 17.5-13.4 22.4c-5.9 4.1-13.2 7.3-20.3 9.6c7.1 2.4 14.4 5.5 20.3 9.6c7 4.9 13.4 12.2 13.4 22.4c0 11-5.6 19.5-12.7 25.8c-7 6.2-16 10.6-24.5 13.7c-10.8 4.1-22.3 6.9-33.7 8.4l-.1 0c-4.4 .5-8.4-2.6-9-6.9s2.6-8.4 6.9-8.9c10.3-1.4 20.5-3.9 30.2-7.6c7.6-2.8 14.6-6.4 19.5-10.8c4.9-4.3 7.3-8.7 7.3-13.7c0-2.6-1.6-5.7-6.6-9.2c-5-3.5-12-6.4-19.7-8.7c-7.6-2.3-15.2-3.8-21-4.8c-2.2-.4-4-.5-5.5-.7c-2.3-.2-4.1-.4-5.9-1.1c-3.1-1.1-5.3-4.2-5.3-7.5s2.2-6.4 5.3-7.5c1.8-.6 3.6-.8 5.9-1.1l0 0 0 0c1.6-.2 3.3-.3 5.5-.7c5.8-1 13.4-2.5 21-4.8c7.7-2.3 14.7-5.2 19.7-8.7c5-3.5 6.6-6.6 6.6-9.2c0-3.8-2.1-7.9-7.2-12.2c-5.1-4.3-12.2-8-19.8-11.1c-7.6-3-15.2-5.3-21-6.7c-4.3-1.1-6.9-1.7-9.4-2.1c-4.3-.8-7.3-4.9-6.5-9.3s4.9-7.2 9.3-6.5zm-81-64.1a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "bridge-circle-xmark": [640, 512, [], "e4cb", "M40 32H600c4.4 0 8 3.6 8 8s-3.6 8-8 8H520v96h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H40c-4.4 0-8-3.6-8-8s3.6-8 8-8h80V48H40c-4.4 0-8-3.6-8-8s3.6-8 8-8zM504 48H392v96H504V48zM376 48H264v96H376V48zM248 48H136v96H248V48zM40 256H64c48.6 0 88 39.4 88 88v96c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V344c0-48.6 39.4-88 88-88c12.3 0 24 2.5 34.7 7.1c-3.2 4.4-6.3 8.9-9.1 13.6c-7.9-3-16.5-4.7-25.5-4.7c-39.8 0-72 32.2-72 72v96c0 22.1-17.9 40-40 40H176c-22.1 0-40-17.9-40-40V344c0-39.8-32.2-72-72-72H40c-4.4 0-8-3.6-8-8s3.6-8 8-8zM624 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm205.7-50.3L507.3 368l50.3 50.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L496 379.3l-50.3 50.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L484.7 368l-50.3-50.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L496 356.7l50.3-50.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "period": [128, 512, [], "2e", "M64 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "face-grin-tongue": [512, 512, [128539, "grin-tongue"], "f589", "M256 16C123.5 16 16 123.5 16 256c0 99.6 60.7 185 147.1 221.4c4.1 1.7 6 6.4 4.3 10.5s-6.4 6-10.5 4.3C64.7 453.4 0 362.3 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 106.3-64.7 197.4-156.9 236.1c-4.1 1.7-8.8-.2-10.5-4.3s.2-8.8 4.3-10.5C435.3 441 496 355.6 496 256C496 123.5 388.5 16 256 16zM160.4 208a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM184 409.9c0-23.2 18.8-41.9 41.9-41.9c11.1 0 21.8 4.4 29.7 12.3l.4 .4 .4-.4c7.9-7.9 18.5-12.3 29.7-12.3c23.2 0 41.9 18.8 41.9 41.9V440c0 39.8-32.2 72-72 72s-72-32.2-72-72V409.9zm64-14.6l-3.7-3.7c-4.9-4.9-11.5-7.6-18.3-7.6c-14.3 0-25.9 11.6-25.9 25.9V440c0 30.9 25.1 56 56 56s56-25.1 56-56V409.9c0-14.3-11.6-25.9-25.9-25.9c-6.9 0-13.5 2.7-18.3 7.6l-3.7 3.7V424c0 4.4-3.6 8-8 8s-8-3.6-8-8V395.3zM336.4 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM149.4 321c32.6 8.1 68.6 12.6 106.6 12.6s74-4.5 106.6-12.6c11.1-2.8 22.3 .3 29.6 6.9c3.7 3.4 6.5 7.8 7.5 13.1c1 5.3 0 10.9-2.9 16.1c-10 17.5-23.6 32.9-39.8 45.3c-3.5 2.7-8.5 2-11.2-1.5s-2-8.5 1.5-11.2c14.6-11.2 26.7-25 35.7-40.6c1.2-2.1 1.3-3.8 1.1-5.1c-.3-1.4-1.1-2.9-2.6-4.3c-3.1-2.9-8.8-4.7-14.9-3.2c-33.9 8.4-71.2 13.1-110.4 13.1s-76.5-4.7-110.4-13.1c-6.1-1.5-11.7 .3-14.9 3.2c-1.5 1.4-2.3 2.9-2.6 4.3c-.2 1.3-.1 3 1.1 5.1c8.9 15.6 21.1 29.4 35.7 40.6c3.5 2.7 4.2 7.7 1.5 11.2s-7.7 4.2-11.2 1.5c-16.2-12.4-29.8-27.8-39.8-45.3c-3-5.2-3.9-10.7-2.9-16.1c1-5.2 3.8-9.7 7.5-13.1c7.3-6.7 18.5-9.7 29.6-6.9z"],
    "up-to-dotted-line": [448, 512, [], "e457", "M216 147.3c2.1-2.1 5-3.3 8-3.3s5.9 1.2 8 3.3L363.8 279.4c2.7 2.7 4.2 6.4 4.2 10.2c0 8-6.5 14.4-14.4 14.4L280 304c-4.4 0-8 3.6-8 8l0 136c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-136c0-4.4-3.6-8-8-8l-73.6 0c-8 0-14.4-6.5-14.4-14.4c0-3.8 1.5-7.5 4.2-10.2L216 147.3zm8-19.3c-7.2 0-14.2 2.9-19.3 8L72.9 268.1c-5.7 5.7-8.9 13.4-8.9 21.5C64 306.4 77.6 320 94.4 320l65.6 0 0 128c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-128 65.6 0c16.8 0 30.4-13.6 30.4-30.4c0-8.1-3.2-15.8-8.9-21.5L243.3 136c-5.1-5.1-12.1-8-19.3-8zm0-92.4a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm192 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm-384 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm272 16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm-192 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z"],
    "thought-bubble": [512, 512, [], "e32e", "M137.2 80.3C156.1 33.3 202.1 0 256 0s99.9 33.3 118.8 80.3c3-.2 6.1-.3 9.2-.3c70.7 0 128 57.3 128 128s-57.3 128-128 128c-12.9 0-25.3-1.9-37.1-5.5C329.2 362.4 295.1 384 256 384s-73.2-21.6-90.9-53.5c-11.7 3.6-24.2 5.5-37.1 5.5C57.3 336 0 278.7 0 208S57.3 80 128 80c3.1 0 6.1 .1 9.2 .3zM256 16c-49.1 0-90.8 31.5-105.9 75.5c-1.2 3.6-4.8 5.8-8.5 5.3c-4.4-.5-9-.8-13.6-.8C66.1 96 16 146.1 16 208s50.1 112 112 112c13.5 0 26.4-2.4 38.3-6.7c3.9-1.4 8.2 .4 10 4.1C190.4 347.3 220.8 368 256 368s65.6-20.7 79.7-50.6c1.8-3.7 6.1-5.5 10-4.1c11.9 4.4 24.9 6.7 38.3 6.7c61.9 0 112-50.1 112-112s-50.1-112-112-112c-4.6 0-9.1 .3-13.6 .8c-3.7 .5-7.3-1.8-8.5-5.3C346.8 47.5 305.1 16 256 16zM32 496a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm144-16a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "skeleton-ribs": [640, 512, [], "e5cb", "M328 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H267.3c-39.3 0-75.6 22.2-91.5 58.6c-15.4 35.3-35.4 84.3-51.4 135.5C108.4 309.2 96 363.1 96 408v10.8c0 33.8 27.4 61.2 61.2 61.2c8.2 0 16.2-1.6 23.8-4.8l117.3-49.4c4.4-1.9 9.1-3.1 13.7-3.8v82c0 4.4 3.6 8 8 8s8-3.6 8-8V422c4.7 .7 9.3 1.9 13.7 3.8L459 475.2c7.5 3.2 15.6 4.8 23.8 4.8c33.8 0 61.2-27.4 61.2-61.2V408c0-44.9-12.4-98.8-28.4-149.8c-16.1-51.2-36-100.2-51.4-135.5C448.3 86.2 412 64 372.7 64H328V8zM312 80v89.9L157 212.2c11.5-31.3 23.4-60.1 33.5-83.1c13.2-30.2 43.5-49 76.9-49H312zM150.4 230.5L312 186.5v95.6L119.3 341.4c5-25.5 12.1-52.2 20.3-78.4c3.4-10.9 7-21.8 10.7-32.4zM116.2 359.1L312 298.8V405.9c-6.8 .8-13.5 2.5-19.9 5.2L174.8 460.5c-5.6 2.3-11.5 3.5-17.6 3.5c-25 0-45.2-20.3-45.2-45.2V408c0-15.2 1.5-31.7 4.2-48.9zM328 405.9V298.8l195.8 60.2c2.7 17.2 4.2 33.7 4.2 48.9v10.8c0 25-20.3 45.2-45.2 45.2c-6 0-12-1.2-17.6-3.5L347.9 411.1c-6.4-2.7-13.1-4.4-19.9-5.2zm192.7-64.5L328 282.1V186.5l161.6 44.1c3.7 10.6 7.3 21.5 10.7 32.4c8.2 26.3 15.4 52.9 20.3 78.4zM483 212.2L328 169.9V80h44.7c33.4 0 63.6 18.8 76.9 49c10.1 23 22 51.8 33.5 83.1zM0 124V232 504c0 4.4 3.6 8 8 8s8-3.6 8-8V232c0-11.5 6.7-22 17.1-26.8l51-23.6c21.8-10.1 35.8-31.9 35.8-56V124c0-33.1-26.9-60-60-60S0 90.9 0 124zm16 73.4V124c0-24.3 19.7-44 44-44s44 19.7 44 44v1.7c0 17.8-10.4 34-26.5 41.5l-51 23.6c-3.8 1.8-7.3 4-10.4 6.7zM580 64c-33.1 0-60 26.9-60 60v1.7c0 24.1 14 45.9 35.8 56l51 23.6C617.3 210 624 220.5 624 232V504c0 4.4 3.6 8 8 8s8-3.6 8-8V232 124c0-33.1-26.9-60-60-60zm33.6 126.7l-51-23.6c-16.2-7.5-26.5-23.6-26.5-41.5V124c0-24.3 19.7-44 44-44s44 19.7 44 44v73.4c-3.1-2.7-6.6-4.9-10.4-6.7z"],
    "raygun": [576, 512, [], "e025", "M51.6 1.3c2.3-1.5 5.1-1.7 7.6-.6L201.7 64H280c22.6 0 42.8 10.4 56 26.7V48c0-4.4 3.6-8 8-8s8 3.6 8 8v88 32h48V80c0-4.4 3.6-8 8-8s8 3.6 8 8v88h48V152c0-3.2 1.9-6.1 4.9-7.4l96-40c2.5-1 5.3-.8 7.5 .7s3.6 4 3.6 6.7V240c0 2.7-1.3 5.2-3.6 6.7s-5 1.8-7.5 .7l-96-40c-3-1.2-4.9-4.2-4.9-7.4V184H416v88c0 4.4-3.6 8-8 8s-8-3.6-8-8V184H352v32 88c0 4.4-3.6 8-8 8s-8-3.6-8-8V261.3c-13.2 16.3-33.4 26.7-56 26.7h-4.2L172.6 494.3c-7.9 15.8-27.1 22.2-42.9 14.3l-80-40c-15.8-7.9-22.2-27.1-14.3-42.9l69-137.9C46.1 283.8 0 235.3 0 176c0-38.1 19-71.7 48-91.9V8c0-2.7 1.4-5.2 3.6-6.7zM480 176v18.7L560 228V124l-80 33.3V176zM200.2 80h-.4H112c-53 0-96 43-96 96s43 96 96 96H280c30.9 0 56-25.1 56-56V176 136c0-30.9-25.1-56-56-56H200.2zM64 20.3V74.8C78.5 67.9 94.8 64 112 64h50.3L64 20.3zM122.1 288L49.7 432.8c-4 7.9-.7 17.5 7.2 21.5l80 40c7.9 4 17.5 .7 21.5-7.2L257.9 288H122.1zM112 160a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "flute": [640, 512, [], "f8b9", "M128 336H576c26.5 0 48-21.5 48-48V224c0-26.5-21.5-48-48-48H128V336zm-16 0V176H64c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48h48zM64 160h48 8 8H576c35.3 0 64 28.7 64 64v64c0 35.3-28.7 64-64 64H128h-8-8H64c-35.3 0-64-28.7-64-64V224c0-35.3 28.7-64 64-64zm272 96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm112 32a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "acorn": [448, 512, [], "f6ae", "M261.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L241 11.7C226.9 25.8 218.2 44.3 216.4 64H96C43 64 0 107 0 160v16c0 17.7 14.3 32 32 32H416c17.7 0 32-14.3 32-32V160c0-53-43-96-96-96H232.5c1.8-15.4 8.7-29.9 19.8-41l9.4-9.4zM352 80c44.2 0 80 35.8 80 80v16c0 8.8-7.2 16-16 16H32c-8.8 0-16-7.2-16-16V160c0-44.2 35.8-80 80-80H352zM48.4 240c4.1 78.1 39 189.3 165.5 236.4c6.5 2.4 13.7 2.4 20.2 0C360.6 429.3 395.5 318.1 399.6 240h-16c-4 74.5-37.4 177.5-155.1 221.4c-2.9 1.1-6.1 1.1-9 0C101.8 417.5 68.5 314.5 64.4 240h-16z"],
    "video-arrow-up-right": [576, 512, [], "e2c9", "M320 80c26.5 0 48 21.5 48 48v74.9V309.1 384c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V128c0-26.5 21.5-48 48-48H320zm64 304V336.8 309.1 202.9 175.2 128c0-35.3-28.7-64-64-64H64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64zm32-29.6l103.4 56.9c5.6 3.1 12 4.7 18.4 4.7c21.1 0 38.2-17.1 38.2-38.2V134.2c0-21.1-17.1-38.2-38.2-38.2c-6.4 0-12.8 1.6-18.4 4.7L416 157.6v18.3l111.1-61.1c3.3-1.8 7-2.7 10.7-2.7c12.3 0 22.2 9.9 22.2 22.2V377.8c0 12.3-9.9 22.2-22.2 22.2c-3.7 0-7.4-.9-10.7-2.7L416 336.1v18.3zM152 160c-4.4 0-8 3.6-8 8s3.6 8 8 8H260.7L98.3 338.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L272 187.3V296c0 4.4 3.6 8 8 8s8-3.6 8-8V168c0-4.4-3.6-8-8-8H152z"],
    "grate-droplet": [576, 512, [], "e194", "M64 48H384c26.5 0 48 21.5 48 48v73.5c4.9-3.2 10.3-5.7 16-7.3V96c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H344.2c-3.4-5.1-6.5-10.5-9.3-16H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48zm320 72c0-13.3-10.7-24-24-24H296 224 152 88c-13.3 0-24 10.7-24 24V256 392c0 13.3 10.7 24 24 24h64 72 72 24.9c-.6-5.3-.9-10.6-.9-16H304V264h64v10l16-30V120zM80 120c0-4.4 3.6-8 8-8h56V248H80V120zm80 128V112h56V248H160zm72 0V112h56V248H232zm72 0V112h56c4.4 0 8 3.6 8 8V248H304zm-16 16V400H232V264h56zm-72 0V400H160V264h56zm-72 0V400H88c-4.4 0-8-3.6-8-8V264h64zM352 400c0 61.9 50.1 112 112 112s112-50.1 112-112c0-18.4-4.5-36.5-13.2-52.7L487.5 206.1c-4.6-8.7-13.7-14.1-23.5-14.1s-18.9 5.4-23.5 14.1L365.2 347.3C356.5 363.5 352 381.6 352 400zm27.3-45.2l75.3-141.2c1.9-3.5 5.5-5.6 9.4-5.6s7.6 2.2 9.4 5.6l75.3 141.2c7.4 13.9 11.3 29.4 11.3 45.2c0 53-43 96-96 96s-96-43-96-96c0-15.8 3.9-31.3 11.3-45.2z"],
    "seal-exclamation": [512, 512, [], "e242", "M176 80c4.2 0 8.3-1.7 11.3-4.7l46.1-46.1c12.5-12.5 32.8-12.5 45.3 0l11.3-11.3L278.6 29.3l46.1 46.1c3 3 7.1 4.7 11.3 4.7h64c17.7 0 32 14.3 32 32v64c0 4.2 1.7 8.3 4.7 11.3l45.6 45.6c12.5 12.5 12.5 32.8 0 45.3l-45.6 45.6c-3 3-4.7 7.1-4.7 11.3V400c0 17.7-14.3 32-32 32H335.1c-4.2 0-8.3 1.7-11.3 4.7l-45.1 45.1c-12.5 12.5-32.8 12.5-45.3 0l-45.1-45.1c-3-3-7.1-4.7-11.3-4.7H112c-17.7 0-32-14.3-32-32V335.1c0-4.2-1.7-8.3-4.7-11.3L29.7 278.2c-12.5-12.5-12.5-32.8 0-45.3l45.6-45.6c3-3 4.7-7.1 4.7-11.3V112c0-17.7 14.3-32 32-32h64zM336 64L289.9 17.9c-18.7-18.7-49.1-18.7-67.9 0L176 64H112c-26.5 0-48 21.5-48 48v64L18.4 221.6c-18.7 18.7-18.7 49.1 0 67.9L64 335.1V400c0 26.5 21.5 48 48 48h64.9l45.1 45.1c18.7 18.7 49.1 18.7 67.9 0L335.1 448H400c26.5 0 48-21.5 48-48V335.1l45.6-45.6c18.7-18.7 18.7-49.1 0-67.9L448 176V112c0-26.5-21.5-48-48-48H336zm-80 64c-4.4 0-8 3.6-8 8V296c0 4.4 3.6 8 8 8s8-3.6 8-8V136c0-4.4-3.6-8-8-8zm16 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M124 16c-11 0-20 9-20 20c0 8.5 5.2 15.7 12.7 18.6c2.5 1 4.3 3.2 4.9 5.8s-.2 5.4-2.1 7.3C95 92.5 69 125.4 49.2 159.9C29.2 194.5 16 229.9 16 259.9c0 30.6 11.9 74.5 52.4 100.9c2.3 1.5 3.6 4 3.6 6.7V384H56V371.7C12.4 341.2 0 293 0 259.9c0-34.1 14.8-72.4 35.3-108C54 119.4 77.9 88.4 101 63.7c-8-6.6-13-16.6-13-27.7c0-19.9 16.1-36 36-36h72c19.9 0 36 16.1 36 36c0 11.2-5.1 21.1-13 27.7c23.2 24.6 47.1 55.6 65.8 88.1c20.5 35.6 35.3 73.9 35.3 108c0 33.1-12.4 81.3-56 111.8V384H248V367.5c0-2.7 1.4-5.2 3.6-6.7c40.5-26.4 52.4-70.2 52.4-100.9c0-24.6-8.9-52.9-23.1-81.4L173.7 285.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L273 163.7c-.7-1.3-1.4-2.5-2.2-3.8C251 125.4 225 92.5 200.5 67.7c-1.9-1.9-2.7-4.6-2.1-7.3s2.4-4.8 4.9-5.8C210.8 51.7 216 44.5 216 36c0-11-9-20-20-20H124zM62.3 432c-4.5 0-8.9 1.9-11.9 5.3L19.8 471.2c-2.5 2.7-3.8 6.3-3.8 9.9c0 8.2 6.6 14.8 14.8 14.8H289.2c8.2 0 14.8-6.6 14.8-14.8c0-3.7-1.4-7.2-3.8-9.9l-30.6-33.9c-3-3.4-7.4-5.3-11.9-5.3H62.3zm249.8 28.5c5.1 5.7 7.9 13 7.9 20.6c0 17-13.8 30.8-30.8 30.8H30.8C13.8 512 0 498.2 0 481.2c0-7.6 2.8-15 7.9-20.6l30.6-33.9c6.1-6.7 14.7-10.6 23.8-10.6H257.7c9.1 0 17.7 3.8 23.8 10.6l30.6 33.9z"],
    "message-sms": [512, 512, [], "e1e5", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zm48 182.9c0-4.8 2.3-8.2 6.7-10.8c4.7-2.8 11.1-4.2 17.1-4.1c7.3 .1 18.1 1.7 25.3 3.6c4.3 1.1 8.7-1.4 9.8-5.7s-1.4-8.7-5.7-9.8c-8.3-2.2-20.4-4-29.1-4.2c-8.2-.1-17.7 1.7-25.5 6.3C102.5 163.1 96 171.2 96 183c.1 11 6.4 18.1 13.9 22.6c6.7 4.1 15.3 6.6 22.7 8.9l1 .3c8.2 2.5 15.1 4.7 20 7.7c4.4 2.8 6.3 5.7 6.4 9.9c.1 6.5-2 9.6-4.2 11.3c-2.6 2.1-6.9 3.4-13.1 3.6c-12.3 .4-27.3-3.8-36.5-6.9c-4.2-1.4-8.7 .9-10.1 5.1s.9 8.7 5.1 10.1c9.4 3.1 26.8 8.2 42.1 7.7c7.7-.2 16-1.9 22.4-6.9c6.9-5.4 10.4-13.6 10.3-24.1c-.1-11.2-6.3-18.5-13.9-23.3c-7-4.4-16.1-7.2-23.7-9.5l-.2 0c-8.3-2.5-15.1-4.6-20.1-7.6c-4.5-2.7-6.1-5.3-6.1-9zm240 0c0-4.8 2.3-8.2 6.7-10.8c4.7-2.8 11.1-4.2 17.1-4.1c7 .1 14.6 1.6 22.1 3.6c4.3 1.1 8.7-1.4 9.8-5.7s-1.4-8.7-5.7-9.8c-7.9-2.1-16.9-4-25.9-4.2c-8.2-.1-17.7 1.7-25.5 6.3c-8.1 4.8-14.6 12.9-14.6 24.7c.1 11 6.4 18.1 13.9 22.6c6.7 4.1 15.3 6.6 22.7 8.9l1 .3c8.2 2.5 15.1 4.7 20 7.7c4.4 2.8 6.3 5.7 6.4 9.9c.1 5.5-2.4 9.1-6.5 11.6c-4.4 2.8-10.8 4.2-17.3 4c-8.3-.3-16-2.9-25-6c-1.5-.5-3.1-1-4.7-1.6c-4.2-1.4-8.7 .9-10.1 5.1s.9 8.7 5.1 10.1c1.4 .5 2.8 .9 4.2 1.4l0 0c8.9 3.1 19.2 6.6 30.1 6.9c8.7 .3 18.4-1.5 26.2-6.4c8.2-5.1 14.2-13.6 14-25.4c-.1-11.2-6.3-18.5-13.9-23.3c-7-4.4-16.1-7.2-23.7-9.5l-.2 0c-8.3-2.5-15.1-4.6-20.1-7.6c-4.5-2.7-6.1-5.3-6.1-9zM205.5 152.4c-3.3 1.1-5.5 4.1-5.5 7.6v96c0 4.4 3.6 8 8 8s8-3.6 8-8V184l33.6 44.8c1.5 2 3.9 3.2 6.4 3.2s4.9-1.2 6.4-3.2L296 184v72c0 4.4 3.6 8 8 8s8-3.6 8-8V160c0-3.4-2.2-6.5-5.5-7.6s-6.9 0-8.9 2.8L256 210.7l-41.6-55.5c-2.1-2.8-5.7-3.9-8.9-2.8z"],
    "coffee-beans": [512, 512, [], "e13f", "M442.4 203.7c9.3 11 18.1 27 25.5 42.6c-41.6 39.9-120.8 34-178.5-23.7C240.7 174 228.9 110.2 250.2 66.4c6.6 12.9 14.2 25.7 22.5 35.5c26.4 31.1 58 42.5 87.7 53.1l.5 .2c30 10.7 58 20.9 81.4 48.5zm4.2-138.4c53 53 62.3 124.2 32.6 167.6c-7-14.2-15.4-28.8-24.6-39.6c-26.4-31.1-58-42.5-87.7-53.1l-.5-.2c-30-10.7-58-20.9-81.4-48.5c-9-10.6-17.6-26-24.8-41.1c2.1-2.7 4.3-5.2 6.7-7.6C308.1 1.7 388.3 7 446.6 65.4zm33.8 191.1C530.1 206.8 520.1 116.1 458 54S305.2-18.1 255.6 31.6S215.9 171.9 278 234s152.7 72.2 202.4 22.5zM128 496C69.3 496 16 435 16 352c0-72.7 40.8-128.4 90.4-141.2c-5 14.8-9.2 30.7-10.3 44.6c-3.4 40.7 11 71.1 24.5 99.6l.2 .5c13.6 28.8 26.3 55.8 23.3 91.9c-1.2 14.5-6.4 32.2-12.3 48.6c-1.2 .1-2.5 .1-3.8 .1zm32-47.3c3.4-40.7-11-71.1-24.5-99.6l-.2-.5c-13.6-28.8-26.3-55.8-23.3-91.9c1.2-14.5 6.4-32.2 12.3-48.6c1.2-.1 2.5-.1 3.8-.1c58.7 0 112 61 112 144c0 72.7-40.8 128.4-90.4 141.2c5-14.8 9.2-30.7 10.3-44.6zM128 512c70.7 0 128-71.6 128-160s-57.3-160-128-160S0 263.6 0 352s57.3 160 128 160z"],
    "hat-witch": [576, 512, [], "f6e7", "M96 384h17.5l83.1-189.9c15.5-35.5 42.3-64.8 76.2-83.6L442 17.2c1.4-.8 2.9-1.2 4.5-1.2c2.3 0 4.4 .8 6.1 2.3l105.1 91 10.5-12.1-10.5 12.1c1.4 1.2 2.3 3.1 2.3 5c0 1.1-.3 2.2-.8 3.1l-46 85.5-11.9-31.6c-6.2-16.4-21.8-27.3-39.4-27.3c-14.1 0-27.2 7-35 18.7l-13.8 20.7c-8.6 12.8-13.1 27.9-13.1 43.3c0 10.9 2.3 21.7 6.7 31.7L462.5 384H480L421.4 252c-3.5-7.9-5.4-16.5-5.4-25.2c0-12.3 3.6-24.3 10.4-34.5l13.8-20.7c4.8-7.2 13-11.6 21.7-11.6c10.9 0 20.6 6.7 24.4 16.9L501 216c1.8 4.8 6.4 8 11.6 8c4.6 0 8.8-2.5 10.9-6.5L573.3 125c1.8-3.3 2.7-7 2.7-10.7c0-6.5-2.8-12.8-7.8-17.1L463.2 6.2c-4.6-4-10.5-6.2-16.6-6.2c-4.3 0-8.5 1.1-12.3 3.2L265 96.5c-37 20.4-66.2 52.4-83.2 91.2L96 384zm457.4 48c3.7 0 6.6 3 6.6 6.6c0 1.9-.7 2.9-1.3 3.4c-17.9 15.2-70.9 54-142.7 54H160c-71.8 0-124.8-38.8-142.7-54c-.6-.5-1.3-1.6-1.3-3.4c0-3.7 3-6.6 6.6-6.6H553.4zM22.6 416C10.1 416 0 426.1 0 438.6c0 6 2.4 11.7 6.9 15.6C25.9 470.3 82.6 512 160 512H416c77.4 0 134.1-41.7 153.1-57.8c4.6-3.9 6.9-9.6 6.9-15.6c0-12.5-10.1-22.6-22.6-22.6H22.6zM304 336c17.7 0 32 14.3 32 32v16h16V368c0-26.5-21.5-48-48-48H272c-26.5 0-48 21.5-48 48v16h16V368c0-17.7 14.3-32 32-32h32z"],
    "face-grin-wink": [512, 512, ["grin-wink"], "f58c", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256.3 91.8c-43 0-84.1-5.5-121.5-15.4c-3.9-1-7.1 .3-8.7 1.8c-.7 .7-.9 1.2-.9 1.4l0 0c0 .1-.1 .7 .5 1.9c25 46.8 74.1 78.5 130.5 78.5s105.5-31.7 130.5-78.5c.7-1.2 .6-1.8 .5-1.9l0 0c0-.2-.2-.7-.9-1.4c-1.6-1.5-4.8-2.8-8.7-1.8c-37.4 9.9-78.4 15.4-121.5 15.4zm144.6-2.7C373.2 396.8 318.8 432 256.3 432s-116.9-35.2-144.6-86.9c-9.1-17 8.7-33.1 27.3-28.2c36 9.6 75.6 14.9 117.3 14.9s81.4-5.3 117.3-14.9c18.6-4.9 36.4 11.2 27.3 28.2zM160.4 208a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm134.2 19.9c-2.2 3.9-7 5.2-10.9 3.1s-5.2-7-3.1-10.9c13.1-23.4 33.6-36.1 55-36.1s41.8 12.7 55 36.1c2.2 3.9 .8 8.7-3.1 10.9s-8.7 .8-10.9-3.1c-10.9-19.3-26.4-27.9-41-27.9s-30.2 8.6-41 27.9z"],
    "clock-three-thirty": [512, 512, [], "e357", "M16 256a240 240 0 1 0 480 0A240 240 0 1 0 16 256zm496 0A256 256 0 1 1 0 256a256 256 0 1 1 512 0zM248 408V256c0-4.4 3.6-8 8-8H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H264V408c0 4.4-3.6 8-8 8s-8-3.6-8-8z"],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", "M509.7 13.7l-80 80c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l80-80c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zm-320 320l-176 176c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l176-176c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zM240 80C151.6 80 80 150.9 80 238.2c0 4.4-3.6 8-8 8s-8-3.6-8-8C64 141.9 142.9 64 240 64s176 77.9 176 174.2c0 51-22.2 96.8-57.4 128.7c-6.1 5.6-9.8 12.9-9.8 20.4V392c0 66.3-53.7 120-120 120H206.4c-4.4 0-8-3.6-8-8s3.6-8 8-8h22.4c57.4 0 104-46.6 104-104v-4.8c0-12.8 6.2-24.2 15.1-32.2C379.9 326 400 284.4 400 238.2C400 150.9 328.4 80 240 80zm0 64c-53 0-96 43-96 96c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-61.9 50.1-112 112-112s112 50.1 112 112c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-53-43-96-96-96z"],
    "alarm-clock": [512, 512, [9200], "f34e", "M93.7 0C42 0 0 42 0 93.7c0 18.5 5.4 35.8 14.6 50.3c2.4 3.7 7.3 4.8 11 2.4s4.8-7.3 2.4-11C20.4 123.4 16 109.1 16 93.7C16 50.8 50.8 16 93.7 16c20.4 0 39 7.9 52.8 20.7c3.2 3 8.3 2.8 11.3-.4s2.8-8.3-.4-11.3C140.7 9.5 118.3 0 93.7 0zM45.7 509.7l57.7-57.7C143.4 489.2 197 512 256 512s112.6-22.8 152.6-60.1l57.7 57.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-57.7-57.7C457.2 400.6 480 347 480 288C480 164.3 379.7 64 256 64S32 164.3 32 288c0 59 22.8 112.6 60.1 152.6L34.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0zM256 80a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm8 88c0-4.4-3.6-8-8-8s-8 3.6-8 8V304c0 2.4 1.1 4.7 3 6.2l80 64c3.4 2.8 8.5 2.2 11.2-1.2s2.2-8.5-1.2-11.2l-77-61.6V168zM354.6 25c-3.2 3-3.4 8.1-.4 11.3s8.1 3.4 11.3 .4C379.3 23.9 397.9 16 418.3 16C461.2 16 496 50.8 496 93.7c0 15.4-4.4 29.7-12.1 41.7c-2.4 3.7-1.3 8.7 2.4 11s8.7 1.3 11-2.4c9.3-14.5 14.6-31.8 14.6-50.3C512 42 470 0 418.3 0c-24.6 0-47 9.5-63.7 25z"],
    "eclipse": [640, 512, [], "f749", "M165.7 2.8c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L121 121 13.1 140.8c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L65.1 256 2.8 346.3c-3.1 4.5-3.7 10.2-1.6 15.2s6.6 8.6 11.9 9.6L121 391l19.8 107.9c1 5.3 4.6 9.8 9.6 11.9l3.1-7.4-3.1 7.4c5 2.1 10.7 1.5 15.2-1.6L256 446.9l90.3 62.3c4.5 3.1 10.2 3.7 15.2 1.6s8.6-6.6 9.6-11.9l9.6-52.2c-5.1-2.2-10.1-4.6-14.9-7.3L355.4 496l-94.9-65.4c-2.7-1.9-6.3-1.9-9.1 0L156.6 496 135.8 382.7c-.6-3.3-3.2-5.8-6.4-6.4L16 355.4l65.4-94.9c1.9-2.7 1.9-6.3 0-9.1L16 156.6l113.3-20.8c3.3-.6 5.8-3.2 6.4-6.4L156.6 16l94.9 65.4c2.7 1.9 6.3 1.9 9.1 0L355.4 16l10.4 56.6c4.9-2.6 9.8-5 14.9-7.3l-9.6-52.2c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L256 65.1 165.7 2.8zM256 144c-61.9 0-112 50.1-112 112s50.1 112 112 112c10.4 0 20.5-1.4 30.1-4.1c-2.9-4.7-5.5-9.5-8-14.5c-7.1 1.7-14.5 2.6-22.1 2.6c-53 0-96-43-96-96s43-96 96-96c7.6 0 15 .9 22.1 2.6c2.5-4.9 5.2-9.8 8-14.5c-9.6-2.7-19.7-4.1-30.1-4.1zm48 112a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zm336 0a176 176 0 1 0 -352 0 176 176 0 1 0 352 0z"],
    "face-relieved": [512, 512, [], "e389", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM181.7 370.3c14.3 14.3 39 29.7 74.3 29.7s60.1-15.4 74.3-29.7c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3C325 398.3 296.4 416 256 416s-69-17.7-85.7-34.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm170-98.3c14.6 0 30.2-8.6 41-27.9c2.2-3.9 7-5.2 10.9-3.1s5.2 7 3.1 10.9c-13.1 23.4-33.6 36.1-55 36.1s-41.8-12.7-55-36.1c-2.2-3.9-.8-8.7 3.1-10.9s8.7-.8 10.9 3.1c10.9 19.3 26.4 27.9 41 27.9zm-233-27.9c10.9 19.3 26.4 27.9 41 27.9s30.2-8.6 41-27.9c2.2-3.9 7-5.2 10.9-3.1s5.2 7 3.1 10.9c-13.1 23.4-33.6 36.1-55 36.1s-41.8-12.7-55-36.1c-2.2-3.9-.8-8.7 3.1-10.9s8.7-.8 10.9 3.1zm81-150.6c1.4 4.2-.9 8.7-5.1 10.1l-6.3 2.1c-25.3 8.4-47.1 25.1-61.9 47.3l-7.6 11.5c-2.5 3.7-7.4 4.7-11.1 2.2s-4.7-7.4-2.2-11.1l7.6-11.5c16.8-25.2 41.5-44 70.2-53.6l6.3-2.1c4.2-1.4 8.7 .9 10.1 5.1zm117.9 10.1c-4.2-1.4-6.5-5.9-5.1-10.1s5.9-6.5 10.1-5.1l6.3 2.1c28.7 9.6 53.4 28.4 70.2 53.6l7.6 11.5c2.5 3.7 1.5 8.6-2.2 11.1s-8.6 1.5-11.1-2.2L385.7 153c-14.8-22.2-36.6-38.8-61.9-47.3l-6.3-2.1z"],
    "road-circle-check": [640, 512, [], "e564", "M217.4 32C194 32 173 46.6 164.9 68.6L40.4 404.6C26.9 441.1 54 480 93 480H360.2c-4.2-5.1-8.1-10.4-11.8-16H328V420.6c-2-6.5-3.7-13.2-5-20c-.9-.4-1.9-.6-3-.6c-4.4 0-8 3.6-8 8v56H93c-27.9 0-47.2-27.8-37.5-53.9l124.4-336C185.7 58.4 200.7 48 217.4 48H312v56c0 4.4 3.6 8 8 8s8-3.6 8-8V48h94.6c16.7 0 31.7 10.4 37.5 26.1l43.7 118.1c6 .3 11.9 .8 17.7 1.7L475.1 68.6C467 46.6 446 32 422.6 32H217.4zM328 200c0-4.4-3.6-8-8-8s-8 3.6-8 8V312c0 4.4 3.6 8 8 8s8-3.6 8-8V200zm168 40a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm69.7-189.7c-3.1-3.1-8.2-3.1-11.3 0L480 396.7l-42.3-42.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l48 48c3.1 3.1 8.2 3.1 11.3 0l80-80c3.1-3.1 3.1-8.2 0-11.3z"],
    "dice-five": [448, 512, [9860], "f523", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm144 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 208a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm112-64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm16 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "octagon-minus": [512, 512, ["minus-octagon"], "f308", "M191.5 16.1c-14.9 0-29.1 5.9-39.6 16.4L32.5 151.9C22 162.4 16.1 176.7 16.1 191.5v129c0 14.9 5.9 29.1 16.4 39.6L151.9 479.5c10.5 10.5 24.7 16.4 39.6 16.4h129c14.9 0 29.1-5.9 39.6-16.4L479.5 360.1c10.5-10.5 16.4-24.7 16.4-39.6v-129c0-14.9-5.9-29.1-16.4-39.6L360.1 32.5C349.6 22 335.3 16.1 320.5 16.1h-129zm-50.9 5.1C154.1 7.7 172.4 .1 191.5 .1h129c19.1 0 37.4 7.6 50.9 21.1L490.8 140.6c13.5 13.5 21.1 31.8 21.1 50.9v129c0 19.1-7.6 37.4-21.1 50.9L371.4 490.8c-13.5 13.5-31.8 21.1-50.9 21.1h-129c-19.1 0-37.4-7.6-50.9-21.1L21.2 371.4C7.7 357.9 .1 339.6 .1 320.5v-129c0-19.1 7.6-37.4 21.1-50.9L140.6 21.2zM160 248H352c4.4 0 8 3.6 8 8s-3.6 8-8 8H160c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "square-rss": [448, 512, ["rss-square"], "f143", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm48 304a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM72 96c-4.4 0-8 3.6-8 8s3.6 8 8 8c163.5 0 296 132.5 296 296c0 4.4 3.6 8 8 8s8-3.6 8-8C384 235.7 244.3 96 72 96zm0 96c-4.4 0-8 3.6-8 8s3.6 8 8 8c110.5 0 200 89.5 200 200c0 4.4 3.6 8 8 8s8-3.6 8-8c0-119.3-96.7-216-216-216z"],
    "face-zany": [512, 512, [], "e3a4", "M256 16C123.5 16 16 123.5 16 256c0 99.6 60.7 185 147.1 221.4c4.1 1.7 6 6.4 4.3 10.5s-6.4 6-10.5 4.3C64.7 453.4 0 362.3 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 106.3-64.7 197.4-156.9 236.1c-4.1 1.7-8.8-.2-10.5-4.3s.2-8.8 4.3-10.5C435.3 441 496 355.6 496 256C496 123.5 388.5 16 256 16zM184 409.9c0-23.2 18.8-41.9 41.9-41.9c11.1 0 21.8 4.4 29.7 12.3l.4 .4 .4-.4c7.9-7.9 18.5-12.3 29.7-12.3c23.2 0 41.9 18.8 41.9 41.9V440c0 39.8-32.2 72-72 72s-72-32.2-72-72V409.9zm64-14.6l-3.7-3.7c-4.9-4.9-11.5-7.6-18.3-7.6c-14.3 0-25.9 11.6-25.9 25.9V440c0 30.9 25.1 56 56 56s56-25.1 56-56V409.9c0-14.3-11.6-25.9-25.9-25.9c-6.9 0-13.5 2.7-18.3 7.6l-3.7 3.7V424c0 4.4-3.6 8-8 8s-8-3.6-8-8V395.3zM368 152c0-27.9-20.4-51-47.1-55.3C330.1 104 336 115.3 336 128c0 22.1-17.9 40-40 40c-18.3 0-33.7-12.3-38.5-29c-1 4.2-1.5 8.5-1.5 13c0 30.9 25.1 56 56 56s56-25.1 56-56zm-128 0a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM128 272a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-112a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm192-32a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM112 224a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm289 35.6c4.5 14 7 28.9 7 44.4c0 43.8-19.6 83.1-50.5 109.5c-3.4 2.9-8.4 2.5-11.3-.9s-2.5-8.4 .9-11.3C374.6 377.8 392 343 392 304c0-13.8-2.2-27.1-6.2-39.5c-2.2-6.9-10.9-10.5-19.2-6.2L168.9 363.8c-8.2 4.4-10.1 13.6-5.5 19.4c.7 .9 1.5 1.9 2.3 2.8c2.8 3.4 2.4 8.4-1 11.3s-8.4 2.4-11.3-1c-.9-1-1.7-2.1-2.6-3.2c-11.9-15.1-4.6-35.3 10.6-43.4L359.1 244.2c15.2-8.1 36-2.9 41.9 15.3z"],
    "tricycle": [512, 512, [], "e5c3", "M264 32c-4.4 0-8 3.6-8 8s3.6 8 8 8h97.1C382.6 48 400 65.4 400 86.9c0 13-6.5 25.2-17.3 32.4L333.6 152H299.3c-59.1 0-114.5 26.1-152.2 70.2L94.9 144H120c4.4 0 8-3.6 8-8s-3.6-8-8-8H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H75.7l61 91.5c-2.7 3.8-5.3 7.7-7.8 11.7l-5.8 9.4c-3.7-.4-7.4-.6-11.2-.6C50.1 256 0 306.1 0 368s50.1 112 112 112s112-50.1 112-112c0-52.1-35.6-96-83.9-108.4l2.5-4c33.5-54.4 92.8-87.6 156.7-87.6h30.5l15.5 62C293.5 246.4 256 294.8 256 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-7.9 0-15.7 .7-23.2 2.1l-15.6-62.6 46.4-30.9c15.3-10.2 24.4-27.3 24.4-45.7C416 56.6 391.4 32 361.1 32H264zm85.1 213.5l27.1 108.4c1.1 4.3 5.4 6.9 9.7 5.8s6.9-5.4 5.8-9.7L364.7 241.7c6.3-1.1 12.7-1.7 19.3-1.7c61.9 0 112 50.1 112 112s-50.1 112-112 112s-112-50.1-112-112c0-49.7 32.4-91.8 77.1-106.5zM112 272a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "land-mine-on": [640, 512, [], "e51b", "M320 0c4.4 0 8 3.6 8 8V184c0 4.4-3.6 8-8 8s-8-3.6-8-8V8c0-4.4 3.6-8 8-8zM192 384h0H159.2c-12.6 0-24.1 7.4-29.2 19L98.6 473.5c-4.7 10.6 3 22.5 14.6 22.5H526.8c11.6 0 19.3-11.9 14.6-22.5L510 403c-5.1-11.6-16.6-19-29.2-19H448h0H432 208 192zm16-16H432V320c0-8.8-7.2-16-16-16H224c-8.8 0-16 7.2-16 16v48zm240 0h0 16 16.8c19 0 36.2 11.2 43.9 28.5L556 467c9.4 21.2-6.1 45-29.2 45H113.2c-23.2 0-38.6-23.8-29.2-45l31.3-70.5c7.7-17.3 24.9-28.5 43.9-28.5H176h16V352 320c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32v32 16zM44.9 129.6l136 104c3.5 2.7 4.2 7.7 1.5 11.2s-7.7 4.2-11.2 1.5l-136-104c-3.5-2.7-4.2-7.7-1.5-11.2s7.7-4.2 11.2-1.5zm561.5 1.5c2.7 3.5 2 8.5-1.5 11.2l-136 104c-3.5 2.7-8.5 2-11.2-1.5s-2-8.5 1.5-11.2l136-104c3.5-2.7 8.5-2 11.2 1.5z"],
    "square-arrow-up-left": [448, 512, [], "e263", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm280 64c4.4 0 8 3.6 8 8s-3.6 8-8 8H155.3L317.7 338.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L144 187.3V312c0 4.4-3.6 8-8 8s-8-3.6-8-8V168c0-4.4 3.6-8 8-8H280z"],
    "i-cursor": [256, 512, [], "f246", "M0 7.5c-.3 4.4 3 8.2 7.5 8.5l15.5 1C77.5 20.7 120 66 120 120.8V248H64c-4.4 0-8 3.6-8 8s3.6 8 8 8h56V391.2C120 446 77.5 491.3 22.9 495L7.5 496c-4.4 .3-7.7 4.1-7.5 8.5s4.1 7.7 8.5 7.5L24 511c47.9-3.2 87.7-34.2 104-76.6c16.4 42.4 56.1 73.4 104 76.6l15.5 1c4.4 .3 8.2-3 8.5-7.5s-3-8.2-7.5-8.5l-15.5-1c-54.6-3.6-97.1-49-97.1-103.8V264h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H136V120.8C136 66 178.5 20.7 233.1 17l15.5-1c4.4-.3 7.7-4.1 7.5-8.5s-4.1-7.7-8.5-7.5L232 1c-47.9 3.2-87.7 34.2-104 76.6C111.6 35.2 71.9 4.2 24 1L8.5 0C4.1-.3 .3 3.1 0 7.5z"],
    "chart-mixed-up-circle-dollar": [576, 512, [], "e5d9", "M416 8c0-4.4 3.6-8 8-8H536c4.4 0 8 3.6 8 8V120c0 4.4-3.6 8-8 8s-8-3.6-8-8V26.7L325.3 206c-3.2 2.8-8 2.7-11-.3l-123-123L12.9 222.3c-3.5 2.7-8.5 2.1-11.2-1.4s-2.1-8.5 1.4-11.2l184-144c3.2-2.5 7.7-2.2 10.6 .6L320.3 189 515.9 16H424c-4.4 0-8-3.6-8-8zM192 240c-8.8 0-16 7.2-16 16V448c0 8.8 7.2 16 16 16s16-7.2 16-16V256c0-8.8-7.2-16-16-16zm-32 16c0-17.7 14.3-32 32-32s32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V256zM80 352c0-8.8-7.2-16-16-16s-16 7.2-16 16v96c0 8.8 7.2 16 16 16s16-7.2 16-16V352zm-48 0c0-17.7 14.3-32 32-32s32 14.3 32 32v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V352zM432 496a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-272a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm-28.2 93.9c-8 4.1-12.3 9.7-11.7 17.6c.4 5.2 3.6 9.5 11.5 13.5c7.9 4 18.3 6.8 30 10l1 .3c11.5 3.1 24.3 6.6 34.1 12.1c10.2 5.7 18.8 14.5 19.2 28.4c.5 16.4-8.9 27-20.4 33c-8.5 4.4-18.5 6.5-27.6 7.1v17.7c0 4.4-3.6 8-8 8s-8-3.6-8-8V439.4c-12.6-1.4-24.7-5.1-35.9-8.5l0 0c-2.1-.7-4.3-1.3-6.3-1.9c-4.2-1.3-6.7-5.7-5.4-9.9s5.7-6.7 9.9-5.4c2.3 .7 4.5 1.3 6.7 2l0 0 0 0c13.6 4.1 26.1 7.9 39.2 8.3c9.4 .3 20.1-1.4 28-5.5c7.6-3.9 12-9.6 11.7-18.3c-.2-6.2-3.6-10.7-11.1-14.9c-7.8-4.4-18.5-7.4-30.5-10.6l-1.8-.5c-11-2.9-22.9-6.1-32.3-11c-10.1-5.2-19.3-13.3-20.2-26.7c-1.1-16.5 8.9-27.1 20.4-32.9c8.5-4.3 18.5-6.5 27.4-7.3V280c0-4.4 3.6-8 8-8s8 3.6 8 8v16.4c10.2 .8 20.4 2.8 29.8 5c4.3 1 7 5.3 5.9 9.6s-5.3 7-9.6 5.9c-11.4-2.7-23.1-4.8-34.3-5c-8.8-.1-19.8 1.6-28.1 5.8z"],
    "salt-shaker": [384, 512, [129474], "e446", "M368 453.2c0-2.5-.2-5-.7-7.5L319.2 176H64.8L16.7 445.7c-.4 2.5-.7 5-.7 7.5C16 476.8 35.2 496 58.8 496H325.2c23.6 0 42.8-19.2 42.8-42.8zM316.3 160l-8.4-46.9C297.9 56.9 249.1 16 192 16S86.1 56.9 76.1 113.1L67.7 160H316.3zm8.9 352H58.8C26.3 512 0 485.7 0 453.2c0-3.5 .3-6.9 .9-10.3L60.3 110.3C71.7 46.5 127.2 0 192 0s120.3 46.5 131.7 110.3l59.4 332.6c.6 3.4 .9 6.9 .9 10.3c0 32.5-26.3 58.8-58.8 58.8zM176 64a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM144 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM138.3 233L111.9 441c-.6 4.4-4.6 7.5-8.9 6.9s-7.5-4.6-6.9-8.9l26.4-208c.6-4.4 4.6-7.5 8.9-6.9s7.5 4.6 6.9 8.9zm123.2-2l26.4 208c.6 4.4-2.5 8.4-6.9 8.9s-8.4-2.5-8.9-6.9L245.7 233c-.6-4.4 2.5-8.4 6.9-8.9s8.4 2.5 8.9 6.9z"],
    "stamp": [512, 512, [], "f5bf", "M336 96c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 14.1 3.6 27.2 10 38.7c9.6 17.4 22 39.8 22 65.1c0 48.7-39.5 88.2-88.2 88.2H112c-53 0-96 43-96 96c0 8.8 7.2 16 16 16H480c8.8 0 16-7.2 16-16c0-53-43-96-96-96h-7.8c-48.7 0-88.2-39.5-88.2-88.2c0-25.3 12.4-47.7 22-65.1l14 7.8-14-7.8c6.3-11.5 10-24.6 10-38.7zm4 46.5c-9.9 18-20 36.8-20 57.4c0 39.9 32.3 72.2 72.2 72.2H400c61.9 0 112 50.1 112 112c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32c0-61.9 50.1-112 112-112h7.8c39.9 0 72.2-32.3 72.2-72.2c0-20.5-10.1-39.4-20-57.4c-7.6-13.8-12-29.6-12-46.5c0-53 43-96 96-96s96 43 96 96c0 16.9-4.3 32.7-12 46.5zM48 456v16c0 13.3 10.7 24 24 24H440c13.3 0 24-10.7 24-24V456c0-4.4 3.6-8 8-8s8 3.6 8 8v16c0 22.1-17.9 40-40 40H72c-22.1 0-40-17.9-40-40V456c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "file-plus": [384, 512, [], "f319", "M16 448V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48zM358.6 157.3c.9 .9 1.7 1.8 2.4 2.7H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64zM192 240c-4.4 0-8 3.6-8 8v72H112c-4.4 0-8 3.6-8 8s3.6 8 8 8h72v72c0 4.4 3.6 8 8 8s8-3.6 8-8V336h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H200V248c0-4.4-3.6-8-8-8z"],
    "draw-square": [448, 512, [], "f5ef", "M48 112a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm8 15.3V384.7C76.1 388 92 403.9 95.3 424H352.7c3.4-20.1 19.2-36 39.3-39.3V127.3c-20.1-3.4-36-19.2-39.3-39.3H95.3C92 108.1 76.1 124 56 127.3zM95.3 440c-3.8 22.7-23.6 40-47.3 40c-26.5 0-48-21.5-48-48c0-23.8 17.3-43.5 40-47.3V127.3C17.3 123.5 0 103.8 0 80C0 53.5 21.5 32 48 32c23.8 0 43.5 17.3 47.3 40H352.7c3.8-22.7 23.6-40 47.3-40c26.5 0 48 21.5 48 48c0 23.8-17.3 43.5-40 47.3V384.7c22.7 3.8 40 23.6 40 47.3c0 26.5-21.5 48-48 48c-23.8 0-43.5-17.3-47.3-40H95.3zM80 432a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm352 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "toilet-paper-under-slash": [640, 512, ["toilet-paper-reverse-slash"], "e2a1", "M528.1 512l-20.3-16H264c-13.3 0-24-10.7-24-24V416H224v56c0 22.1 17.9 40 40 40H528.1zM560 291.5v62.3l16 12.6V192c0-51.9-11.9-99.3-31.5-134C525 23.5 496.9 0 464 0H176c-16.1 0-31.1 5.6-44.5 15.5l13.1 10.4c10-6.5 20.6-9.8 31.3-9.8H418.8c-13.6 10.2-25.5 24.7-35.3 42c-19.3 34.2-31.1 80.6-31.5 131.6l16.2 12.8c-.1-3.4-.2-6.8-.2-10.3c0-49.7 11.4-94.3 29.4-126.2C415.6 33.7 439.4 16 464 16s48.4 17.7 66.6 49.8C548.6 97.7 560 142.3 560 192s-11.4 94.3-29.4 126.2c-1.6 2.9-3.3 5.7-5.1 8.3l12.6 9.9c2.2-3.3 4.3-6.8 6.4-10.4c5.9-10.4 11.1-22 15.5-34.6zM64 192c0 51.9 11.9 99.3 31.5 134c19.5 34.5 47.6 58 80.5 58H365.9l-20.3-16H176c-24.6 0-48.4-17.7-66.6-49.8C91.4 286.3 80 241.7 80 192c0-11.1 .6-21.9 1.7-32.4L66.9 147.9C65 162.1 64 176.9 64 192zm420.6 63c4.8-4.8 8.4-10.8 11.1-17.1c5.4-12.6 8.3-28.8 8.3-45.9s-2.9-33.3-8.3-45.9c-2.7-6.3-6.3-12.3-11.1-17.1c-4.9-4.8-11.9-9-20.6-9s-15.7 4.2-20.6 9c-4.8 4.8-8.4 10.8-11.1 17.1c-5.4 12.6-8.3 28.8-8.3 45.9s2.9 33.3 8.3 45.9c2.7 6.3 6.3 12.3 11.1 17.1c4.9 4.8 11.9 9 20.6 9s15.7-4.2 20.6-9zM464 248c-13.3 0-24-25.1-24-56s10.7-56 24-56s24 25.1 24 56s-10.7 56-24 56zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "stairs": [576, 512, [], "e289", "M424 40c0-4.4 3.6-8 8-8H568c4.4 0 8 3.6 8 8s-3.6 8-8 8H440V184c0 4.4-3.6 8-8 8H296V328c0 4.4-3.6 8-8 8H152V472c0 4.4-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H136V328c0-4.4 3.6-8 8-8H280V184c0-4.4 3.6-8 8-8H424V40z"],
    "drone-front": [640, 512, ["drone-alt"], "f860", "M152 104c0-4.4-3.6-8-8-8s-8 3.6-8 8v24H16c-4.4 0-8 3.6-8 8s3.6 8 8 8H136V296c0 4.4 3.6 8 8 8h53.6l0 0-13.5 16.2c-15.6 18.7-24.1 42.2-24.1 66.6V408c0 4.4 3.6 8 8 8s8-3.6 8-8V386.8c0-20.6 7.2-40.5 20.4-56.3L211 312.9l56.6 37.7c1.3 .9 2.9 1.3 4.4 1.3h96c1.6 0 3.1-.5 4.4-1.3L429 312.9l14.6 17.5c13.2 15.8 20.4 35.8 20.4 56.3V408c0 4.4 3.6 8 8 8s8-3.6 8-8V386.8c0-24.3-8.5-47.9-24.1-66.6L442.4 304l0 0H496c4.4 0 8-3.6 8-8V144H624c4.4 0 8-3.6 8-8s-3.6-8-8-8H504V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v24H368c-4.4 0-8 3.6-8 8s3.6 8 8 8H488v99.8l-80-35c-25.3-11.1-52.6-16.8-80.2-16.8H312.2c-27.6 0-54.9 5.7-80.2 16.8l-80 35V144H272c4.4 0 8-3.6 8-8s-3.6-8-8-8H152V104zm0 157.2l86.4-37.8c23.3-10.2 48.4-15.4 73.8-15.4h15.7c25.4 0 50.5 5.3 73.8 15.4L488 261.2V288H440c-1.6 0-3.1 .5-4.4 1.3l-70 46.7H274.4l-70-46.7c-1.3-.9-2.9-1.3-4.4-1.3H152V261.2z"],
    "glass-empty": [384, 512, [], "e191", "M32.1 16c-9.3 0-16.7 8-15.9 17.3L50.9 459.2C52.6 480 69.9 496 90.7 496H293.3c20.8 0 38.2-16 39.9-36.8L367.9 33.3C368.7 24 361.3 16 352 16H32.1zM.2 34.6C-1.3 16 13.4 0 32.1 0H352c18.7 0 33.4 16 31.9 34.6l-34.7 426c-2.4 29.1-26.7 51.4-55.8 51.4H90.7c-29.2 0-53.4-22.4-55.8-51.4L.2 34.6z"],
    "dial-high": [576, 512, [], "e15c", "M272 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM288 296H431.8c-4.2 75.8-66.9 136-143.8 136c-79.5 0-144-64.5-144-144s64.5-144 144-144c76.8 0 139.6 60.2 143.8 136H288c-4.4 0-8 3.6-8 8s3.6 8 8 8zm160-8a160 160 0 1 0 -320 0 160 160 0 1 0 320 0zm96-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM16 288a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0A32 32 0 1 0 0 288a32 32 0 1 0 64 0zM96 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM464 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 464a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm368-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "user-helmet-safety": [448, 512, [128119, "user-construction", "user-hard-hat"], "f82c", "M200 24V88c0 4.4-3.6 8-8 8s-8-3.6-8-8V38.8C137.4 55.3 104 99.8 104 152v8H344v-8c0-52.2-33.4-96.7-80-113.2V88c0 4.4-3.6 8-8 8s-8-3.6-8-8V24c0-4.4-3.6-8-8-8H208c-4.4 0-8 3.6-8 8zm-16 0c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24V22c55.6 17.1 96 68.8 96 130v8l16 0c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-4.4 0-8-3.6-8-8s3.6-8 8-8l16 0v-8c0-61.2 40.4-112.9 96-130v2zm40 296c-65.3 0-119.1-48.9-127-112h16.1c7.8 54.3 54.4 96 110.9 96s103.1-41.7 110.9-96H351c-7.9 63.1-61.7 112-127 112zm-89.6 48C69 368 16 421 16 486.4c0 5.3 4.3 9.6 9.6 9.6H422.4c5.3 0 9.6-4.3 9.6-9.6C432 421 379 368 313.6 368H134.4zM0 486.4C0 412.2 60.2 352 134.4 352H313.6C387.8 352 448 412.2 448 486.4c0 14.1-11.5 25.6-25.6 25.6H25.6C11.5 512 0 500.5 0 486.4z"],
    "i": [320, 512, [105], "49", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8H152V464H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H168V48H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H160 8z"],
    "hryvnia-sign": [384, 512, [8372, "hryvnia"], "f6f2", "M84.2 73.5C109.1 56.9 138.4 48 168.3 48H235c46.9 0 85 38.1 85 85c0 22.4-8.8 43.4-23.8 59H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H275c-1.2 .7-2.5 1.3-3.8 1.9L106 287.6c-.3 .1-.5 .2-.8 .4H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H81.4C60.5 322.9 48 350 48 379c0 55.8 45.2 101 101 101h66.7c33.1 0 65.5-9.8 93-28.2l7.8-5.2c3.7-2.5 4.7-7.4 2.2-11.1s-7.4-4.7-11.1-2.2l-7.8 5.2c-24.9 16.6-54.2 25.5-84.1 25.5H149c-46.9 0-85-38.1-85-85c0-31.5 17.4-60.3 45-75H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H142.8L278 224.4c9.1-4.3 17.4-9.8 24.6-16.4H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H317c12.1-16.9 19-37.4 19-59c0-55.8-45.2-101-101-101H168.3c-33.1 0-65.5 9.8-93 28.2l-7.8 5.2c-3.7 2.5-4.7 7.4-2.2 11.1s7.4 4.7 11.1 2.2l7.8-5.2z"],
    "arrow-down-left-and-arrow-up-right-to-center": [512, 512, [], "e092", "M456 224c4.4 0 8-3.6 8-8s-3.6-8-8-8H315.3L509.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L304 196.7V56c0-4.4-3.6-8-8-8s-8 3.6-8 8V216c0 4.4 3.6 8 8 8H456zM56 288c-4.4 0-8 3.6-8 8s3.6 8 8 8H196.7L2.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L208 315.3V456c0 4.4 3.6 8 8 8s8-3.6 8-8V296c0-4.4-3.6-8-8-8H56z"],
    "pills": [576, 512, [], "f484", "M112 48c53 0 96 43 96 96V256H16V144c0-53 43-96 96-96zM16 368V272H208v96c0 53-43 96-96 96s-96-43-96-96zM0 144V368c0 61.9 50.1 112 112 112s112-50.1 112-112V144c0-61.9-50.1-112-112-112S0 82.1 0 144zM416 464c-79.5 0-144-64.5-144-144c0-36.9 13.9-70.5 36.7-96L512 427.3c-25.5 22.8-59.1 36.7-96 36.7zM320 212.7c25.5-22.8 59.1-36.7 96-36.7c79.5 0 144 64.5 144 144c0 36.9-13.9 70.5-36.7 96L320 212.7zM416 480a160 160 0 1 0 0-320 160 160 0 1 0 0 320z"],
    "face-grin-wide": [512, 512, [128515, "grin-alt"], "f581", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256.3 91.8c-43 0-84.1-5.5-121.5-15.4c-3.9-1-7.1 .3-8.7 1.8c-.7 .7-.9 1.2-.9 1.4l0 0c0 .1-.1 .7 .5 1.9c25 46.8 74.1 78.5 130.5 78.5s105.5-31.7 130.5-78.5c.7-1.2 .6-1.8 .5-1.9l0 0c0-.2-.2-.7-.9-1.4c-1.6-1.5-4.8-2.8-8.7-1.8c-37.4 9.9-78.4 15.4-121.5 15.4zm144.6-2.7C373.2 396.8 318.8 432 256.3 432s-116.9-35.2-144.6-86.9c-9.1-17 8.7-33.1 27.3-28.2c36 9.6 75.6 14.9 117.3 14.9s81.4-5.3 117.3-14.9c18.6-4.9 36.4 11.2 27.3 28.2zM160.5 150.3c-5.1 10.3-8.5 25-8.5 41.7s3.4 31.4 8.5 41.7c5.4 10.7 11.3 14.3 15.5 14.3s10.1-3.6 15.5-14.3c5.1-10.3 8.5-25 8.5-41.7s-3.4-31.4-8.5-41.7C186.1 139.6 180.2 136 176 136s-10.1 3.6-15.5 14.3zm-14.3-7.2c6.2-12.4 16.3-23.2 29.8-23.2s23.6 10.7 29.8 23.2c6.5 12.9 10.2 30.2 10.2 48.8s-3.8 35.9-10.2 48.8C199.6 253.3 189.5 264 176 264s-23.6-10.7-29.8-23.2C139.8 227.9 136 210.6 136 192s3.8-35.9 10.2-48.8zM312 192c0 16.7 3.4 31.4 8.5 41.7c5.4 10.7 11.3 14.3 15.5 14.3s10.1-3.6 15.5-14.3c5.1-10.3 8.5-25 8.5-41.7s-3.4-31.4-8.5-41.7C346.1 139.6 340.2 136 336 136s-10.1 3.6-15.5 14.3c-5.1 10.3-8.5 25-8.5 41.7zm24-72c13.5 0 23.6 10.7 29.8 23.2c6.5 12.9 10.2 30.2 10.2 48.8s-3.8 35.9-10.2 48.8C359.6 253.3 349.5 264 336 264s-23.6-10.7-29.8-23.2C299.8 227.9 296 210.6 296 192s3.8-35.9 10.2-48.8c6.2-12.4 16.3-23.2 29.8-23.2z"],
    "tooth": [448, 512, [129463], "f5c9", "M130 48c17.7 0 35 5.8 49.2 16.4l40 30 21.3 16c3.5 2.7 8.5 1.9 11.2-1.6s1.9-8.5-1.6-11.2l-13.4-10 22.2-19C274.4 55.3 294.2 48 314.6 48c47.2 0 85.4 38.3 85.4 85.4v3.6c0 13.8-3.2 27.5-9.4 39.8l-21.3 42.6c-5.9 11.9-10.1 24.6-12.4 37.7L323 453.8c-1 5.9-6.1 10.2-12.1 10.2c-5.4 0-10.1-3.5-11.7-8.6L259.7 331c-5.1-16.1-20-27-36.9-27c-17.1 0-32.2 11.2-37.1 27.6L148.6 455.3c-1.5 5.1-6.3 8.7-11.7 8.7c-5.9 0-11-4.3-12-10.1L91.1 257.2c-2.3-13.1-6.4-25.8-12.4-37.7L57.4 176.9c-6.2-12.4-9.4-26-9.4-39.8V130c0-45.3 36.7-82 82-82zm93.7 29.7L188.8 51.6C171.8 38.9 151.2 32 130 32c-54.1 0-98 43.9-98 98v7.1c0 16.3 3.8 32.4 11.1 47l21.3 42.6c5.2 10.5 8.9 21.7 10.9 33.3l33.9 196.6c2.3 13.5 14.1 23.4 27.8 23.4c12.4 0 23.4-8.2 27-20.1l37.1-123.7c2.9-9.6 11.7-16.2 21.7-16.2c9.9 0 18.7 6.4 21.6 15.9l39.4 124.4c3.7 11.8 14.7 19.8 27 19.8c13.8 0 25.6-9.9 27.9-23.5L372.7 260c2-11.6 5.7-22.8 10.9-33.3l21.3-42.6c7.3-14.6 11.1-30.7 11.1-47v-3.6C416 77.4 370.6 32 314.6 32c-24.2 0-47.6 8.7-66 24.4L223.7 77.7z"],
    "basketball-hoop": [640, 512, [], "f435", "M20.9 194.4C38.1 162 126 16 320 16s281.9 146 299.1 178.4c3.5 6.7 4.9 13.8 4.9 20.5V331.2c0 19-11.2 36.2-28.5 43.9l-95.6 42.5-2.5 18.6L602 389.7c23.1-10.3 38-33.2 38-58.5V214.9c0-8.9-1.8-18.6-6.8-28C615.3 153.1 523.3 0 320 0S24.7 153.1 6.8 187C1.8 196.3 0 206 0 214.9V331.2c0 25.3 14.9 48.2 38 58.5l104.6 46.5-2.5-18.6L44.5 375.1C27.2 367.4 16 350.2 16 331.2V214.9c0-6.8 1.4-13.8 4.9-20.5zM176 184c0-13.3 10.7-24 24-24H440c13.3 0 24 10.7 24 24v40h16V184c0-22.1-17.9-40-40-40H200c-22.1 0-40 17.9-40 40v40h16V184zm-32 72H128c-4.4 0-8 3.6-8 8s3.6 8 8 8h25l31.1 233.1c.4 3.2 2.7 5.8 5.8 6.7s6.4-.2 8.4-2.7l51.4-64.2 64.7 64.9c1.5 1.5 3.5 2.4 5.7 2.4s4.2-.8 5.7-2.4l64.7-64.9L441.8 509c2 2.5 5.3 3.6 8.4 2.7s5.4-3.5 5.8-6.7L487 272h25c4.4 0 8-3.6 8-8s-3.6-8-8-8H496 480.1c-.1 0-.2 0-.2 0H464 176 160.1c-.1 0-.2 0-.2 0H144zm25.1 16h70.8l-60.2 79.7L169.1 272zm103.5 0h94.7L320 331.2 272.6 272zm127.4 0h70.8l-10.6 79.7L400.1 272zM320 492.7l-60.3-60.5L320 356.8l60.3 75.4L320 492.7zm-71.7-71.9L191 363.3 256.2 277l53.6 67-61.4 76.8zm-10.1 12.6l-40.8 51L183.3 378.2l55 55.2zm153.4-12.6L330.2 344l53.6-67L449 363.3l-57.3 57.5zm10.1 12.6l55-55.2L442.5 484.4l-40.8-51z"],
    "objects-align-bottom": [512, 512, [], "e3bb", "M8 512c-4.4 0-8-3.6-8-8s3.6-8 8-8l496 0c4.4 0 8 3.6 8 8s-3.6 8-8 8L8 512zM176 400c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32H112C94.3 16 80 30.3 80 48l0 320c0 17.7 14.3 32 32 32h64zm-64 16c-26.5 0-48-21.5-48-48L64 48C64 21.5 85.5 0 112 0h64c26.5 0 48 21.5 48 48l0 320c0 26.5-21.5 48-48 48H112zm288-16c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32H336c-17.7 0-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32h64zm-64 16c-26.5 0-48-21.5-48-48l0-192c0-26.5 21.5-48 48-48h64c26.5 0 48 21.5 48 48l0 192c0 26.5-21.5 48-48 48H336z"],
    "v": [384, 512, [118], "56", "M4.9 32.6c4.1-1.7 8.8 .2 10.5 4.2L192 451.6 368.6 36.9c1.7-4.1 6.4-6 10.5-4.2s6 6.4 4.2 10.5l-184 432c-1.3 3-4.2 4.9-7.4 4.9s-6.1-1.9-7.4-4.9L.6 43.1c-1.7-4.1 .2-8.8 4.2-10.5z"],
    "sparkles": [512, 512, [10024], "f890", "M432 40c-4.4 0-8 3.6-8 8v56H368c-4.4 0-8 3.6-8 8s3.6 8 8 8h56v56c0 4.4 3.6 8 8 8s8-3.6 8-8V120h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H440V48c0-4.4-3.6-8-8-8zm0 288c-4.4 0-8 3.6-8 8v56H368c-4.4 0-8 3.6-8 8s3.6 8 8 8h56v56c0 4.4 3.6 8 8 8s8-3.6 8-8V408h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H440V336c0-4.4-3.6-8-8-8zM130.1 201.9c3.5-1.6 6.2-4.4 7.8-7.8L190.6 80l52.7 114.1c1.6 3.5 4.4 6.2 7.8 7.8l114.1 52.7L251 307.2c-3.5 1.6-6.2 4.4-7.8 7.8L190.6 429.1 137.9 315c-1.6-3.5-4.4-6.2-7.8-7.8L16 254.6l114.1-52.7zm75-128.6c-2.6-5.7-8.3-9.3-14.5-9.3s-11.9 3.6-14.5 9.3L123.3 187.4 9.3 240C3.6 242.6 0 248.3 0 254.6s3.6 11.9 9.3 14.5l114.1 52.7L176 435.8c2.6 5.7 8.3 9.3 14.5 9.3s11.9-3.6 14.5-9.3l52.7-114.1 114.1-52.7c5.7-2.6 9.3-8.3 9.3-14.5s-3.6-11.9-9.3-14.5L257.8 187.4 205.1 73.3z"],
    "squid": [512, 512, [129425], "e450", "M122.7 2c3.2-2.8 7.9-2.6 10.9 .4l34.2 34.2c15.2 15.2 15.7 39.7 1 55.5l-62 66.8c-8.8 9.5-8.5 24.2 .6 33.3L153 237.7c4.5-41.1 24.4-92.3 73.3-137c11-10.1 23.5-19.8 37.6-29L257 8.9c-.3-2.4 .6-4.8 2.3-6.6s4.2-2.6 6.6-2.3L400.4 16c25.4-6 53.2-10.8 83.7-14.1c15-1.6 27.6 11 26 26c-3.3 30.4-8.1 58.3-14.1 83.7L512.8 247c.3 2.4-.5 4.9-2.3 6.6s-4.2 2.6-6.6 2.3l-63.6-7.8c-9.2 14.1-18.9 26.6-29 37.6c-44.7 48.9-96 68.8-137 73.3l45.6 45.6c9.1 9.1 23.8 9.4 33.3 .6l66.8-62c15.8-14.6 40.3-14.2 55.5 1l34.2 34.2c3 3 3.1 7.8 .4 10.9l-11 12.5c-27.4 31.3-75.6 33-105.1 3.5l-8.4-8.4-21.5 20c-15.8 14.6-40.3 14.2-55.5-1L255.7 363c-2 .9-3.9 2.1-5.6 3.4l-46 34.5L247 443.7c15.6 15.6 15.6 40.9 0 56.6l-9.4 9.4c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l9.4-9.4c9.4-9.4 9.4-24.6 0-33.9l-44.5-44.5-43.2 32.4c-7.6 5.7-11.9 14.6-11.8 24.1c.3 16.1 13.4 29 29.5 29h19.1c4.4 0 8 3.6 8 8s-3.6 8-8 8H165.8c-24.8 0-45.1-19.9-45.5-44.8c-.2-14.6 6.5-28.4 18.2-37.1l41.3-31-67-67L81.4 374.1C73 385.4 59.7 392 45.6 392C20.9 392 .9 372 .9 347.3V328c0-4.4 3.6-8 8-8s8 3.6 8 8v19.3c0 15.9 12.9 28.7 28.7 28.7c9 0 17.6-4.3 23-11.5l32.8-43.8L57 276.3c-9.4-9.4-24.6-9.4-33.9 0l-9.4 9.4c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l9.4-9.4c15.6-15.6 40.9-15.6 56.6 0l42.9 42.9 34.5-46c1.3-1.7 2.4-3.6 3.4-5.6L96.1 203.5c-15.2-15.2-15.7-39.7-1-55.5l20-21.5-8.4-8.4C77.3 88.6 78.9 40.4 110.2 12.9L122.7 2zm-.2 317.3l70.2 70.2 47.8-35.8c8.4-6.3 18.3-9.3 28.1-10.1c38-3.2 87.5-21.1 130.9-68.6c43.4-47.5 81.2-125.2 94.7-248.7c.5-4.8-3.6-8.9-8.4-8.4C362.3 31.3 284.6 69.1 237.1 112.5c-47.5 43.4-65.4 92.9-68.6 130.9c-.8 9.8-3.9 19.7-10.1 28.1l-35.8 47.8zm327-86.1l46.2 5.7-10.8-86.9c-10 31.2-22 58.2-35.4 81.3zM359.6 27.3L274 17.1l5 45.3c22.9-13.3 49.7-25.2 80.6-35.1zM126 114.7l31.1-33.5c8.8-9.5 8.5-24.2-.6-33.3L127.6 18.9l-6.9 6C96.4 46.3 95.1 83.8 118 106.7l8 8zM397.3 386l8 8c22.9 22.9 60.4 21.7 81.7-2.7l6-6.9-28.9-28.9c-9.1-9.1-23.8-9.4-33.3-.6L397.3 386zM208.9 320a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm-16-48a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "leafy-green": [576, 512, [129388], "e41d", "M233.8 27c-38-36.5-98.4-36-135.8 1.5C92 34.4 87 40.8 83 47.7C70 69.6 50.6 89.9 30.9 105.9c-2.3 1.8-4.4 3.8-6.5 5.9C-1.4 137.6-6.8 176.2 8.5 207.2c5.7 11.7 11 24.1 11 37.1v35.7c0 14.7 5.8 28.8 16.3 39.2l26.3 26.3c10.4 10.4 16.3 24.5 16.3 39.2l0 12.9c0 2.9 .2 5.8 .7 8.7l7.6-7.6c3.5-3.5 6.1-7.8 7.7-12.4v-1.6c0-19-7.5-37.1-20.9-50.5L47 308c-7.4-7.4-11.6-17.4-11.6-27.9l0-35.7c0-17.1-6.9-32.4-12.6-44.2c-12.3-25.1-8-56.3 12.9-77.1c1.7-1.7 3.5-3.3 5.3-4.8c20.7-16.8 41.6-38.5 55.7-62.5c3.4-5.7 7.6-11.2 12.5-16.1c31.7-31.7 83-31.7 114.7 0l.8 .9c2.7-4.7 5.7-9.3 9-13.6zM557 136c-7.9 30.7-8.6 65.1-5.4 95.6c.3 2.8 .4 5.6 .4 8.5c0 35.1-22.6 64.9-54 75.7c-14.3 4.9-31.9 11.6-45.4 25.1l-29.1 29.1c-9 9-21.2 14.1-33.9 14.1h-43c-21.2 0-41.6 8.4-56.6 23.4l-10.5 10.5c-9 9-21.2 14.1-33.9 14.1H165.8c-3.8 0-7.6 .3-11.3 .8L331.3 256H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H347.3l98.3-98.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L272 292.7V200c0-4.4-3.6-8-8-8s-8 3.6-8 8V308.7L143.2 421.5c.5-3.7 .8-7.5 .8-11.3V330.5c0-12.7 5.1-24.9 14.1-33.9l10.5-10.5c15-15 23.4-35.4 23.4-56.6v-43c0-12.7 5.1-24.9 14.1-33.9l29.1-29.1c13.5-13.5 20.2-31.1 25.1-45.4c10.8-31.5 40.6-54 75.7-54c2.9 0 5.7 .1 8.5 .4c30.4 3.2 64.8 2.5 95.6-5.4c7.6-2 15.7-3 24-3c53 0 96 43 96 96c0 8.3-1 16.3-3 24zM66.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l42.9-42.9c12-12 28.3-18.7 45.3-18.7h79.7c17 0 33.3-6.7 45.3-18.7l10.5-10.5c12-12 28.3-18.7 45.3-18.7h43c17 0 33.3-6.7 45.3-18.7l29.1-29.1c10.7-10.7 25-16.4 39.3-21.3C540.9 317.9 568 282.1 568 240c0-3.4-.2-6.8-.5-10.1c-3.1-29.1-2.3-61.5 5-89.9c2.3-8.9 3.5-18.3 3.5-28C576 50.1 525.9 0 464 0c-9.7 0-19 1.2-28 3.5c-28.4 7.3-60.8 8.1-89.9 5c-3.3-.3-6.7-.5-10.1-.5c-42.1 0-77.9 27.1-90.8 64.9c-4.9 14.3-10.6 28.6-21.3 39.3l-29.1 29.1c-12 12-18.7 28.3-18.7 45.3v43c0 17-6.7 33.3-18.7 45.3l-10.5 10.5c-12 12-18.7 28.3-18.7 45.3v79.7c0 17-6.7 33.3-18.7 45.3L66.3 498.3z"],
    "circle-arrow-up-right": [512, 512, [], "e0fc", "M256 496a240 240 0 1 0 0-480 240 240 0 1 0 0 480zM256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zM200 160H344c4.4 0 8 3.6 8 8V312c0 4.4-3.6 8-8 8s-8-3.6-8-8V187.3L173.7 349.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L324.7 176H200c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "calendars": [512, 512, [], "e0d7", "M216 0c4.4 0 8 3.6 8 8V64H384V8c0-4.4 3.6-8 8-8s8 3.6 8 8V64h48c35.3 0 64 28.7 64 64v48 16V352c0 35.3-28.7 64-64 64H160c-35.3 0-64-28.7-64-64V192 176 128c0-35.3 28.7-64 64-64h48V8c0-4.4 3.6-8 8-8zm-8 120V80H160c-26.5 0-48 21.5-48 48v48H496V128c0-26.5-21.5-48-48-48H400v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V80H224v40c0 4.4-3.6 8-8 8s-8-3.6-8-8zm288 72H112V352c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V192zM0 224c0-29.8 20.4-54.9 48-62v16.7c-18.6 6.6-32 24.4-32 45.3V448c0 26.5 21.5 48 48 48H352c20.9 0 38.7-13.4 45.3-32H414c-7.1 27.6-32.2 48-62 48H64c-35.3 0-64-28.7-64-64V224z"],
    "bangladeshi-taka-sign": [384, 512, [], "e2e6", "M41 32.1c-4.4-.5-8.4 2.6-8.9 6.9s2.6 8.4 6.9 8.9l7.9 1C75 52.4 96 76.3 96 104.5V192H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H96V408c0 39.8 32.2 72 72 72h16c110.5 0 200-89.5 200-200V264c0-39.8-32.2-72-72-72H264c-4.4 0-8 3.6-8 8s3.6 8 8 8h48c30.9 0 56 25.1 56 56v16c0 101.6-82.4 184-184 184H168c-30.9 0-56-25.1-56-56V208h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H112V104.5c0-36.3-27-66.9-63.1-71.4l-7.9-1z"],
    "bicycle": [640, 512, [128690], "f206", "M296 32c-4.4 0-8 3.6-8 8s3.6 8 8 8h51.1l57.5 112.1c-.6-.1-1.2-.1-1.8-.1H205.6L166.7 99.7c-1.5-2.3-4-3.7-6.7-3.7H104c-4.4 0-8 3.6-8 8s3.6 8 8 8h51.6l36.4 56.5-26.9 61c-11.8-3.6-24.3-5.5-37.2-5.5C57.3 224 0 281.3 0 352s57.3 128 128 128c68 0 123.6-53 127.8-120H320c3 0 5.7-1.7 7.1-4.3l89.7-171.9L446.6 242C409.1 264.3 384 305.2 384 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-18.2 0-35.5 3.8-51.2 10.6L361.4 40.7c-2.7-5.3-8.2-8.7-14.2-8.7H296zM453.9 256.2l51 99.4c2 3.9 6.8 5.5 10.8 3.5s5.5-6.8 3.5-10.8l-51-99.4c13.5-5.7 28.3-8.9 43.9-8.9c61.9 0 112 50.1 112 112s-50.1 112-112 112s-112-50.1-112-112c0-40.6 21.6-76.1 53.9-95.8zm-295.2-12l-44 100c-3.3 7.4 2.2 15.7 10.3 15.7H239.7c-4.1 58.1-52.6 104-111.7 104C66.1 464 16 413.9 16 352s50.1-112 112-112c10.7 0 20.9 1.5 30.7 4.3zM132.3 344l70.2-159.4L305.3 344H132.3zM216 176H402.8L319.3 336.1 216 176z"],
    "hammer-war": [384, 512, [], "f6e4", "M192 16c-8.8 0-16 7.2-16 16V53.2l11.3 1.7c3.1 .5 6.3 .5 9.5 0L208 53.2V32c0-8.8-7.2-16-16-16zM160 50.8V32c0-17.7 14.3-32 32-32s32 14.3 32 32V50.8L347.3 32.4C366.3 29.5 384 44.7 384 64V256c0 19.3-17.7 34.5-36.7 31.6L196.7 265.1c-3.1-.5-6.3-.5-9.5 0L36.7 287.6C17.7 290.5 0 275.3 0 256V64C0 44.7 17.7 29.5 36.7 32.4L160 50.8zM176 291V480c0 8.8 7.2 16 16 16s16-7.2 16-16V291l16 2.4V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V293.4l16-2.4zM16 256c0 9.5 9 17.2 18.4 15.8l150.5-22.6c4.7-.7 9.5-.7 14.2 0l150.5 22.6c9.4 1.4 18.4-6.3 18.4-15.8V64c0-9.5-9-17.2-18.4-15.8L199.1 70.8c-4.7 .7-9.5 .7-14.2 0L34.4 48.2C25 46.8 16 54.5 16 64V256z"],
    "circle-d": [512, 512, [], "e104", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176 150.9c0-3.8 3.1-6.9 6.9-6.9H256c61.9 0 112 50.1 112 112s-50.1 112-112 112H182.9c-3.8 0-6.9-3.1-6.9-6.9V150.9zm6.9-22.9c-12.6 0-22.9 10.2-22.9 22.9V361.1c0 12.6 10.2 22.9 22.9 22.9H256c70.7 0 128-57.3 128-128s-57.3-128-128-128H182.9z"],
    "spider-black-widow": [512, 512, [], "f718", "M368.8 11.6c-2-4-.4-8.8 3.6-10.7s8.8-.4 10.7 3.6l46.4 92.8c7.3 14.5 5 32-5.7 44.2l-83.1 94.9 120.4-31.7c7.8-2.1 14.1-7.9 16.7-15.6l18.5-55.6c1.4-4.2 5.9-6.5 10.1-5.1s6.5 5.9 5.1 10.1l-18.5 55.6c-4.3 12.8-14.7 22.6-27.8 26L344.2 252l121.1 31.9c13.1 3.4 23.5 13.2 27.8 26l18.5 55.6c1.4 4.2-.9 8.7-5.1 10.1s-8.7-.9-10.1-5.1L477.9 315c-2.6-7.7-8.8-13.6-16.7-15.6L358.2 272.2l70.2 93.6c7.9 10.5 10.1 24.2 5.9 36.6L399.6 506.5c-1.4 4.2-5.9 6.5-10.1 5.1s-6.5-5.9-5.1-10.1l34.7-104.1c2.5-7.5 1.2-15.7-3.6-22l-50.2-66.9c1.7 7.5 2.6 15.3 2.6 23.3v8.3C368 400 317.5 448 256 448s-112-48-112-107.8v-8.3c0-8 .9-15.8 2.6-23.3L96.5 375.4c-4.7 6.3-6.1 14.5-3.6 22l34.7 104.1c1.4 4.2-.9 8.7-5.1 10.1s-8.7-.9-10.1-5.1L77.7 402.4c-4.2-12.5-1.9-26.1 5.9-36.6l70.2-93.6L50.8 299.3c-7.8 2.1-14.1 7.9-16.7 15.6L15.6 370.5c-1.4 4.2-5.9 6.5-10.1 5.1s-6.5-5.9-5.1-10.1l18.5-55.6c4.3-12.8 14.7-22.6 27.8-26L167.8 252 46.7 220.1c-13.1-3.4-23.5-13.2-27.8-26L.4 138.5c-1.4-4.2 .9-8.7 5.1-10.1s8.7 .9 10.1 5.1L34.1 189c2.6 7.7 8.8 13.6 16.7 15.6l120.4 31.7L88.1 141.4c-10.7-12.2-12.9-29.7-5.7-44.2L128.8 4.4c2-4 6.8-5.6 10.7-3.6s5.6 6.8 3.6 10.7L96.8 104.4c-4.4 8.7-3 19.2 3.4 26.5L184 226.7V144c0-27.4 15.3-51.2 37.9-63.4c1.9-1 4.1-1.2 6.1-.6s3.7 2 4.7 3.9L256 127.1l23.3-43.3c1-1.9 2.7-3.3 4.7-3.9s4.2-.4 6.1 .6c22.5 12.2 37.9 36 37.9 63.4v82.7l83.8-95.8c6.4-7.3 7.8-17.8 3.4-26.5L368.8 11.6zM200 144V253.1c0 2.5-1.2 4.9-3.2 6.4c-22.5 16.9-36.8 43-36.8 72.3v8.3c0 50.4 42.7 91.8 96 91.8s96-41.4 96-91.8v-8.3c0-29.3-14.3-55.4-36.8-72.3c-2-1.5-3.2-3.9-3.2-6.4V144c0-18.4-8.9-34.8-22.7-45L263 147.8c-1.4 2.6-4.1 4.2-7 4.2s-5.6-1.6-7-4.2L222.7 99c-13.8 10.2-22.7 26.6-22.7 45zm24 156c0 .9 .3 1.7 .8 2.4l21.6 28.8c2.1 2.8 2.1 6.8 0 9.6l-21.6 28.8c-.5 .7-.8 1.5-.8 2.4c0 2.2 1.8 4 4 4h56c2.2 0 4-1.8 4-4c0-.9-.3-1.7-.8-2.4l-21.6-28.8c-2.1-2.8-2.1-6.8 0-9.6l21.6-28.8c.5-.7 .8-1.5 .8-2.4c0-2.2-1.8-4-4-4H228c-2.2 0-4 1.8-4 4zm4-20h56c11 0 20 9 20 20c0 4.3-1.4 8.5-4 12l-18 24 18 24c2.6 3.5 4 7.7 4 12c0 11-9 20-20 20H228c-11 0-20-9-20-20c0-4.3 1.4-8.5 4-12l18-24-18-24c-2.6-3.5-4-7.7-4-12c0-11 9-20 20-20z"],
    "staff-snake": [384, 512, ["rod-asclepius", "rod-snake", "staff-aesculapius"], "e579", "M236.9 48c1.4-26-19.3-48-45.4-48s-46.9 22-45.4 48H56C25.1 48 0 73.1 0 104s25.1 56 56 56H71.7c22.6 0 43.8-10.6 57.3-28.7l2.5-3.3h19.7l2.1 32c-49.7 .9-89.8 41.5-89.8 91.5V256c0 53 43 96 96 96h6.2c0 .2 0 .3 0 .5l2 31.5H127.5c-17.7 0-32 14.3-32 32s14.3 32 32 32h44.4l3.1 48.5c.6 8.7 7.8 15.5 16.5 15.5s15.9-6.8 16.5-15.5l9.3-144c0-.2 0-.3 0-.5h54.2c8.8 0 16 7.2 16 16s-7.2 16-16 16h-32c-4.4 0-8 3.6-8 8s3.6 8 8 8h32c17.7 0 32-14.3 32-32s-14.3-32-32-32h-112c-44.2 0-80-35.8-80-80v-4.5c0-41.5 33.4-75.1 74.8-75.5l2.1 32.1c-25.1 1.6-44.9 22.4-44.9 47.9c0 26.5 21.5 48 48 48h112c35.3 0 64 28.7 64 64s-28.7 64-64 64h-40c-4.4 0-8 3.6-8 8s3.6 8 8 8h40c44.2 0 80-35.8 80-80s-35.8-80-80-80h-112c-17.7 0-32-14.3-32-32c0-17 13.2-30.9 29.9-31.9l2.1 32.4c.3 4.4 4.1 7.8 8.5 7.5s7.8-4.1 7.5-8.5L167.3 128h48.5l-8.2 127.5c-.3 4.4 3.1 8.2 7.5 8.5s8.2-3.1 8.5-7.5L231.8 128h55.7c8.8 0 16 7.2 16 16s-7.2 16-16 16h-24c-4.4 0-8 3.6-8 8s3.6 8 8 8h24c17.7 0 32-14.3 32-32s-14.3-32-32-32h-160c-2.5 0-4.9 1.2-6.4 3.2l-4.9 6.5c-10.5 14-27 22.3-44.5 22.3H56c-22.1 0-40-17.9-40-40s17.9-40 40-40H287.5c44.2 0 80 35.8 80 80s-35.8 80-80 80h-40c-4.4 0-8 3.6-8 8s3.6 8 8 8h40c53 0 96-43 96-96s-43-96-96-96H236.9zM170.8 432H127.5c-8.8 0-16-7.2-16-16s7.2-16 16-16h41.3l2.1 32zm30.5-80L192 495.5c0 .3-.3 .5-.5 .5s-.5-.2-.5-.5L181.7 352h19.6zM162.1 48c0-.2 0-.4 0-.6C161 30.4 174.5 16 191.5 16s30.5 14.4 29.4 31.4c0 .2 0 .4 0 .6H162.1zM47.5 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z"],
    "pear": [512, 512, [], "e20c", "M509.7 2.3c3.1 3.1 3.1 8.2 0 11.3L448 75.3c19.9 22.6 32 52.2 32 84.7c0 30.7-10.8 58.9-28.9 81c-29.9 36.5-61.4 81.8-73.3 127.4c-8.3 32-25 62.3-50.1 87.3c-75 75-196.5 75-271.5 0s-75-196.5 0-271.5c25.1-25.1 55.3-41.8 87.3-50.1c45.7-11.8 90.9-43.4 127.4-73.3c22.1-18 50.3-28.9 81-28.9c32.5 0 62.1 12.1 84.7 32L498.3 2.3c3.1-3.1 8.2-3.1 11.3 0zm-107.3 96l23-23C405.7 58.3 380 48 352 48c-26.9 0-51.6 9.5-70.9 25.3c-36.8 30.1-84.3 63.6-133.5 76.4c-29.3 7.6-57.1 22.9-80.1 45.9c-68.7 68.7-68.7 180.2 0 248.9s180.2 68.7 248.9 0c23-23 38.3-50.7 45.9-80.1c12.8-49.2 46.3-96.8 76.4-133.5c15.8-19.3 25.3-44 25.3-70.9c0-28-10.3-53.7-27.3-73.3l-23 23c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3zM304 328c0 57.4-46.6 104-104 104c-4.4 0-8-3.6-8-8s3.6-8 8-8c48.6 0 88-39.4 88-88c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "head-side-cough-slash": [640, 512, [], "e062", "M16 222.9c0-34.8 8.6-67.6 23.8-96.4L27 116.4C9.8 148.1 0 184.4 0 222.9c0 52.8 16.9 101.5 47.4 139.9C57.5 375.5 64 390.2 64 405.3V504c0 4.4 3.6 8 8 8s8-3.6 8-8V405.3c0-19.8-8.5-37.8-20.1-52.4C31.8 317.5 16 272.3 16 222.9zm480 52.9c0 8.1-2.7 15.6-7.2 21.7l12.6 9.9c6.7-8.8 10.7-19.7 10.7-31.6c0-14.9-6.4-29.1-17.5-39l-3.8-3.4c-29.2-25.9-44.8-62.8-61-101l0 0 0 0c-2.6-6.1-5.2-12.2-7.9-18.4C392.6 46.9 325.7 0 247.7 0H222.9c-31.3 0-61.1 6.4-88.1 18.1l14.4 11.4C172.2 20.8 197 16 222.9 16h24.8c71.3 0 132.7 43 159.5 104.5c2.5 5.8 5 11.7 7.6 17.7l0 0 0 0 0 0 0 0 0 0 0 0c16 38 33.2 78.7 65.3 107.2l3.8 3.4c7.7 6.9 12.1 16.7 12.1 27zM320 392c0 22.1 17.9 40 40 40h66.7l-20.3-16H360c-13.3 0-24-10.7-24-24c0-9.3 5.3-17.4 13-21.4l-13.3-10.5C326.2 367.5 320 379 320 392zm111.8 44c-2 15.8-15.4 28-31.8 28H312c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8s8-3.6 8-8V480h80c21.3 0 39.4-13.9 45.6-33.1l-13.9-11zm114.9-92.8l25 19.8c2.7-2.9 4.3-6.7 4.3-11c0-8.8-7.2-16-16-16c-5.6 0-10.5 2.9-13.4 7.2zm63 49.7l24.6 19.4c3.5-2.9 5.8-7.4 5.8-12.3c0-8.8-7.2-16-16-16c-6.3 0-11.7 3.6-14.4 8.9zM640 304a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "triangle": [512, 512, [9650], "f2ec", "M221.7 67.7C228.8 55.5 241.9 48 256 48s27.2 7.5 34.3 19.7l201 344.6c3.1 5.3 4.7 11.2 4.7 17.3c0 19-15.4 34.4-34.4 34.4H50.4c-19 0-34.4-15.4-34.4-34.4c0-6.1 1.6-12.1 4.7-17.3l201-344.6zm-13.8-8.1L6.9 404.2C2.4 411.9 0 420.7 0 429.6C0 457.4 22.6 480 50.4 480H461.6c27.8 0 50.4-22.6 50.4-50.4c0-8.9-2.4-17.7-6.9-25.4L304.1 59.6C294.1 42.5 275.8 32 256 32s-38.1 10.5-48.1 27.6z"],
    "apartment": [576, 512, [], "e468", "M144 112H80c-26.5 0-48 21.5-48 48V448c0 26.5 21.5 48 48 48H208h24 8V432c0-26.5 21.5-48 48-48s48 21.5 48 48v64h16 16H496c26.5 0 48-21.5 48-48V256c0-26.5-21.5-48-48-48H432c-8.8 0-16-7.2-16-16V64c0-26.5-21.5-48-48-48H208c-26.5 0-48 21.5-48 48V96c0 8.8-7.2 16-16 16zM320 496V432c0-17.7-14.3-32-32-32s-32 14.3-32 32v64h64zm-80 16h-8H208 80c-35.3 0-64-28.7-64-64V160c0-35.3 28.7-64 64-64h48 16V80 64c0-35.3 28.7-64 64-64H368c35.3 0 64 28.7 64 64V176v16h16 48c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H368 352 336h-8H248h-8zM488 400c0 13.3-10.7 24-24 24H432c-13.3 0-24-10.7-24-24V368c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32zm-24 8c4.4 0 8-3.6 8-8V368c0-4.4-3.6-8-8-8H432c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32zM144 328H112c-13.3 0-24-10.7-24-24V272c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24zm8-24V272c0-4.4-3.6-8-8-8H112c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8zm16 96c0 13.3-10.7 24-24 24H112c-13.3 0-24-10.7-24-24V368c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32zm-24 8c4.4 0 8-3.6 8-8V368c0-4.4-3.6-8-8-8H112c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32zm160-80H272c-13.3 0-24-10.7-24-24V272c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24zm8-24V272c0-4.4-3.6-8-8-8H272c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8zM328 80v32c0 13.3-10.7 24-24 24H272c-13.3 0-24-10.7-24-24V80c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24zm-24-8H272c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V80c0-4.4-3.6-8-8-8zM464 328H432c-13.3 0-24-10.7-24-24V272c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24zm8-24V272c0-4.4-3.6-8-8-8H432c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8zM168 208c0 13.3-10.7 24-24 24H112c-13.3 0-24-10.7-24-24V176c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32zm-24 8c4.4 0 8-3.6 8-8V176c0-4.4-3.6-8-8-8H112c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32zm160 16H272c-13.3 0-24-10.7-24-24V176c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24zm8-24V176c0-4.4-3.6-8-8-8H272c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8z"],
    "truck-medical": [640, 512, [128657, "ambulance"], "f0f9", "M352 16c26.5 0 48 21.5 48 48V400H236.7c-10.4-36.9-44.4-64-84.7-64s-74.2 27.1-84.7 64H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H352zM64 416h.4c-.2 2.6-.4 5.3-.4 8c0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8H400h.4c-.2 2.6-.4 5.3-.4 8c0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H608V229.3c0-10.6-4.2-20.8-11.7-28.3L503 107.7c-7.5-7.5-17.7-11.7-28.3-11.7H416V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64zM416 112h58.7c6.4 0 12.5 2.5 17 7L585 212.3c1.1 1.1 2.2 2.4 3 3.7H416V112zm0 261.4V232H592V400H572.7c-10.4-36.9-44.4-64-84.7-64c-29.8 0-56.1 14.8-72 37.4zM152 352a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm264 72a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM184 96c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H240c-4.4 0-8 3.6-8 8v56c0 4.4-3.6 8-8 8H192c-4.4 0-8-3.6-8-8V216c0-4.4-3.6-8-8-8H120c-4.4 0-8-3.6-8-8V168c0-4.4 3.6-8 8-8h56c4.4 0 8-3.6 8-8V96zm8-24c-13.3 0-24 10.7-24 24v48H120c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h48v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V224h48c13.3 0 24-10.7 24-24V168c0-13.3-10.7-24-24-24H248V96c0-13.3-10.7-24-24-24H192z"],
    "pepper": [512, 512, [129745], "e432", "M202.8 1.9c3.4-2.9 8.4-2.5 11.3 .9L208 8c6.1-5.2 6.1-5.2 6.1-5.2l0 0 0 0 0 0 .1 .1 .4 .5c.4 .5 .9 1.1 1.6 2c1.4 1.7 3.3 4.3 5.7 7.5c4.7 6.5 10.8 15.7 17 27.1c10.9 20 22.1 46.9 24.5 76.3c21.2-17.7 50.4-25.2 79.1-17.5c10.9 2.9 20.8 7.7 29.3 14c20-14.6 46-20.8 72-14.7c47.3 11 76.7 58.4 65.7 105.7l-56 240c-11 47.3-58.4 76.7-105.7 65.7c-13.7-3.2-25.9-9.4-36-17.8c-21.2 17.4-50.1 24.7-78.7 17.1c-12.6-3.4-23.9-9.3-33.3-17.1c-10.1 8.4-22.3 14.6-36 17.8c-47.3 11-94.7-18.4-105.7-65.7L2.3 204C-8.7 156.7 20.7 109.3 68 98.3c26-6.1 52 .1 72 14.7c8.3-6.1 17.9-10.8 28.4-13.8c.1 0 .1 0 .2-.1c28.4-7.8 57.5-.8 78.8 16.4C244.9 90.1 235 66.3 225 47.8c-5.8-10.7-11.6-19.4-16-25.4c-2.2-3-4-5.4-5.2-6.9c-.6-.8-1.1-1.4-1.4-1.8l-.4-.4-.1-.1 0 0 0 0c-2.9-3.4-2.5-8.4 .9-11.3zM172.4 114.7c-37.3 10.5-59.8 48.9-50.3 86.8l37.6 150.4c1.1 4.3-1.5 8.6-5.8 9.7s-8.6-1.5-9.7-5.8L106.6 205.3c-7.5-30 1.4-60.3 21.1-81.4c-15.9-10.5-36-14.7-56-10c-38.7 9-62.8 47.8-53.8 86.5l56 240c9 38.7 47.8 62.8 86.5 53.8c13.3-3.1 24.9-9.7 34-18.7c3.1-3.1 8.1-3.1 11.2 0c8.6 8.4 19.4 14.8 31.8 18.1c25.5 6.8 51.4-.9 69-18.1c3.1-3 8.1-3 11.2 0c9.1 8.9 20.7 15.6 34 18.7c38.7 9 77.4-15 86.5-53.8l56-240c9-38.7-15-77.4-53.8-86.5c-23.2-5.4-46.3 1-63.2 15.4c-3 2.6-7.4 2.6-10.4 0c-7.9-6.8-17.5-12-28.3-14.8c-29.2-7.8-59 3.5-76.2 26.3c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2c-16.9-22.5-46.2-33.8-75.1-26.6l0 0c-.7 .2-1.4 .4-2.1 .6z"],
    "piano": [512, 512, [], "f8d4", "M112 352v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H16v96c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V352H464v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H384v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H272v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H192v48c0 17.7-14.3 32-32 32s-32-14.3-32-32V352H112zm336 0H416v48c0 8.8 7.2 16 16 16s16-7.2 16-16V352zm16-16h32v-8.4c0-18.2-10.3-34.8-26.5-42.9l-58.4-29.2c-26.4-13.2-43.1-40.2-43.1-69.7C368 92 292 16 198.3 16H192C94.8 16 16 94.8 16 192V336H48 64 96h16 16 16 32 16 16 16 32 16 48 16 32 16 16 16 32 16zM336 400c0 8.8 7.2 16 16 16s16-7.2 16-16V352H336v48zm-80-48H224v48c0 8.8 7.2 16 16 16s16-7.2 16-16V352zM144 400c0 8.8 7.2 16 16 16s16-7.2 16-16V352H144v48zM96 352H64v48c0 8.8 7.2 16 16 16s16-7.2 16-16V352zm416-24.4V336v8 8 96c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V352v-8-8V192C0 86 86 0 192 0h6.3C300.8 0 384 83.2 384 185.7c0 23.5 13.2 44.9 34.2 55.4l58.4 29.2c21.7 10.8 35.4 33 35.4 57.2z"],
    "gun-squirt": [576, 512, [], "e19d", "M104 32c4.4 0 8 3.6 8 8V64H448c38.8 0 72.1 23 87.3 56H552c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H535.3c-15.2 33-48.5 56-87.3 56H249l-16 64h55V296c0-4.4 3.6-8 8-8s8 3.6 8 8v32 32c0 4.4-3.6 8-8 8s-8-3.6-8-8V336H229L199 455.8C195.5 470 182.7 480 168 480H64c-9.9 0-19.2-4.5-25.2-12.3s-8.2-17.9-5.8-27.5L79.4 254.6C34.3 246.7 0 207.3 0 160c0-53 43-96 96-96V40c0-4.4 3.6-8 8-8zM16 160c0 44.2 35.8 80 80 80H448c33.9 0 62.9-21.1 74.6-50.9c1.2-3.1 4.2-5.1 7.4-5.1h22c4.4 0 8-3.6 8-8V144c0-4.4-3.6-8-8-8H530c-3.3 0-6.3-2-7.4-5.1C510.9 101.1 481.9 80 448 80H96c-44.2 0-80 35.8-80 80zm216.5 96H96l-.5 0-47 188.1c-1.2 4.8-.1 9.8 2.9 13.7s7.7 6.2 12.6 6.2H168c7.3 0 13.7-5 15.5-12.1l49-195.9zM96 144c-8.8 0-16 7.2-16 16s7.2 16 16 16H448c8.8 0 16-7.2 16-16s-7.2-16-16-16H96zM64 160c0-17.7 14.3-32 32-32H448c17.7 0 32 14.3 32 32s-14.3 32-32 32H96c-17.7 0-32-14.3-32-32z"],
    "wheat-awn-circle-exclamation": [640, 512, [], "e598", "M413.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-48 48c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l48-48zm96 0c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-112 112-49.4 49.4c5.7-38.7-6.4-79.4-36.1-109.1L289.5 43.3c-6.2-6.2-16.4-6.2-22.6 0L255.5 54.6c-37.5 37.5-37.5 98.3 0 135.8l27.4 27.4-47.8 47.8c5.7-38.7-6.4-79.4-36.1-109.1l-11.3-11.3c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-37.5 37.5-37.5 98.3 0 135.8l27.4 27.4-47.8 47.8c5.7-38.7-6.4-79.4-36.1-109.1L85.8 247c-6.2-6.2-16.4-6.2-22.6 0L51.9 258.3c-37.5 37.5-37.5 98.3 0 135.8l27.4 27.4L2.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l76.9-76.9 29.2 29.2c37.5 37.5 98.3 37.5 135.8 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-11.3-11.3C224.7 385.8 182 374 142.1 381.2l50.3-50.3 29.2 29.2c26.8 26.8 65.5 34.4 99 22.9c-.4-5-.6-10-.6-15l0-1.8c-29 12-63.6 6.2-87.1-17.4l-29.2-29.2 15.8-15.8c35-16.3 76.8-13.5 109.5 8.4c1.7-5.2 3.7-10.3 5.9-15.2c-27.5-17.3-60.1-23.1-91-17.5l50.3-50.3 29.2 29.2c7 7 14.7 12.6 23 17c2.8-4.6 5.9-9 9.1-13.3c-7.5-3.8-14.5-8.8-20.8-15l-29.2-29.2L321.3 202c33.1-15.4 72.1-13.8 103.9 4.8c6-2.7 12.2-5 18.6-6.9c-28.8-21-64.4-28.4-98.1-22.3l51.9-51.9 112-112zm-392 392c41.5-19.3 92.3-11.9 126.5 22.3l11.3 11.3-11.3 11.3c-31.2 31.2-81.9 31.2-113.1 0l-29.2-29.2 15.8-15.8zm-27.1 4.5L63.2 382.7C32 351.5 32 300.8 63.2 269.6l11.3-11.3 11.3 11.3c32.5 32.5 40.9 80 25 120.2L90.6 410.1zM192.4 308.3L165 280.9c-31.2-31.2-31.2-81.9 0-113.1l11.3-11.3 11.3 11.3c32.5 32.5 40.9 80 25 120.2l-20.3 20.3zM294.2 206.5l-27.4-27.4c-31.2-31.2-31.2-81.9 0-113.1l11.3-11.3 11.3 11.3c32.5 32.5 40.9 80 25 120.2l-20.3 20.3zm215.4-96.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-48 48c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l48-48zM368 368a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 448a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-168c-4.4 0-8 3.6-8 8v96c0 4.4 3.6 8 8 8s8-3.6 8-8V288c0-4.4-3.6-8-8-8z"],
    "snowman": [512, 512, [9731, 9924], "f7d0", "M256 0C198.6 0 152 46.6 152 104c0 18.1 4.6 35.2 12.8 50c-10.8 12.6-19 27.4-23.8 43.7L79.9 169c0-.3 .1-.7 .1-1V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v57.5L11.4 136.8c-4-1.9-8.8-.2-10.6 3.8s-.2 8.8 3.8 10.6l132.8 62.5c-.9 6-1.4 12.1-1.4 18.3c0 18.9 4.4 36.9 12.2 52.8C120.9 312.3 104 350.2 104 392c0 39.1 14.8 74.9 39.1 101.8c11.8 13 28.8 18.2 45 18.2H323.9c16.2 0 33.3-5.2 45-18.2C393.2 466.9 408 431.1 408 392c0-41.8-16.9-79.7-44.2-107.2c7.8-15.9 12.2-33.9 12.2-52.8c0-6.2-.5-12.3-1.4-18.3l132.8-62.5c4-1.9 5.7-6.6 3.8-10.6s-6.6-5.7-10.6-3.8L448 161.5V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v64c0 .3 0 .7 .1 1l-61 28.7c-4.8-16.3-13.1-31.1-23.8-43.7c8.2-14.8 12.8-31.9 12.8-50C360 46.6 313.4 0 256 0zM168 104c0-48.6 39.4-88 88-88s88 39.4 88 88c0 17.2-4.9 33.2-13.4 46.8c-1.9 3.1-1.5 7.1 1 9.8C349.2 179.2 360 204.3 360 232c0 18.4-4.7 35.6-13.1 50.5c-1.8 3.2-1.2 7.2 1.5 9.8C375.3 317.1 392 352.6 392 392c0 35-13.2 67-35 91.1c-7.9 8.7-20 12.9-33.1 12.9H188.1c-13.1 0-25.3-4.2-33.1-12.9c-21.8-24.1-35-56-35-91.1c0-39.4 16.7-74.9 43.5-99.7c2.7-2.5 3.3-6.5 1.5-9.8c-8.3-15-13.1-32.2-13.1-50.5c0-27.7 10.8-52.8 28.5-71.5c2.5-2.7 2.9-6.7 1-9.8C172.9 137.2 168 121.2 168 104zM272 240a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-16 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 112a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-61.3 88.9c3 4.5 8 7.1 13.3 7.1s10.3-2.7 13.3-7.1l12.9-19.4c3.8-5.7 5.8-12.3 5.8-19.1V144c0-17.7-14.3-32-32-32s-32 14.3-32 32v2.4c0 6.8 2 13.4 5.8 19.1l12.9 19.4zm3.7-23.3l-3.3-4.9c-2-3-3.1-6.6-3.1-10.2V144c0-8.8 7.2-16 16-16s16 7.2 16 16v2.4c0 3.6-1.1 7.2-3.1 10.2l-3.3 4.9L256 176l-9.6-14.4z"],
    "user-alien": [448, 512, [], "e04a", "M80 167C80 83 145.1 16 224 16s144 67 144 151c0 45-23.9 87.6-53.6 123c-29.5 35.1-63.1 61-78.9 72.3c-3.1 2.2-7.1 3.5-11.5 3.5s-8.4-1.3-11.5-3.5c-15.8-11.3-49.4-37.2-78.9-72.3C103.9 254.6 80 212 80 167zM224 0C135.6 0 64 74.8 64 167c0 101 106.6 185 139.2 208.3c6.1 4.3 13.4 6.5 20.8 6.5s14.7-2.1 20.8-6.5C277.4 352 384 268.1 384 167C384 74.8 312.4 0 224 0zM0 486.4C0 500.5 11.5 512 25.6 512H422.4c14.1 0 25.6-11.5 25.6-25.6c0-71.4-55.7-129.8-126.1-134.1c-5.8 5.6-11.4 10.9-16.9 15.7h8.6C379 368 432 421 432 486.4c0 5.3-4.3 9.6-9.6 9.6H25.6c-5.3 0-9.6-4.3-9.6-9.6C16 421 69 368 134.4 368H143c-5.5-4.9-11.1-10.1-16.9-15.7C55.7 356.6 0 415 0 486.4zM208 238.9c0-34.7-28.1-62.9-62.9-62.9h-16c-9.5 0-17.1 7.7-17.1 17.1c0 34.7 28.1 62.9 62.9 62.9h16c9.5 0 17.1-7.7 17.1-17.1zM145.1 192c25.9 0 46.9 21 46.9 46.9c0 .6-.5 1.1-1.1 1.1h-16C149 240 128 219 128 193.1c0-.6 .5-1.1 1.1-1.1h16zm157.7-16c-34.7 0-62.9 28.1-62.9 62.9c0 9.5 7.7 17.1 17.1 17.1h16c34.7 0 62.9-28.1 62.9-62.9c0-9.5-7.7-17.1-17.1-17.1h-16zM256 238.9c0-25.9 21-46.9 46.9-46.9h16c.6 0 1.1 .5 1.1 1.1c0 25.9-21 46.9-46.9 46.9h-16c-.6 0-1.1-.5-1.1-1.1z"],
    "shield-check": [512, 512, [], "f2f7", "M237.3 22.6c12-5.1 25.5-5.1 37.5 0l176.7 75c16.6 7.1 28.6 23.2 28.5 42.4c-.5 96.6-40.3 270.2-204.5 348.8c-12.3 5.9-26.7 5.9-39 0C72.3 410.1 32.5 236.5 32 139.9c-.1-19.1 11.9-35.3 28.5-42.4l176.7-75zM281 7.8c-16-6.8-34-6.8-50 0L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c16.7 8 36.1 8 52.8 0C454.8 420.7 495.5 239.2 496 140c.1-26.2-16.3-47.9-38.3-57.2L281 7.8zm76.6 189.8c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L224 308.7l-58.3-58.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l64 64c3.1 3.1 8.2 3.1 11.3 0l128-128z"],
    "mortar-pestle": [512, 512, [], "f5a7", "M492.4 21.9l0 0c-2.8-3.4-6.6-5.4-10.8-5.8c-2.4-.2-4.7 0-7 .8l0 0c-1.5 .5-2.9 1.3-4.2 2.3l-.2 .1 0 0L278.4 160H251.3L460.8 6.4c2.6-2 5.5-3.5 8.5-4.6c4.5-1.6 9.3-2.2 14-1.7c8.2 .8 16 4.8 21.6 11.6c2.4 2.9 4.1 6.1 5.3 9.5c1.6 4.5 2.2 9.3 1.7 14c-.8 7.8-4.5 15.3-10.7 20.7L385.6 160H361.7L490.4 44.1l.1-.1 0 0c3.1-2.7 4.9-6.4 5.3-10.4c.2-2.4 0-4.7-.8-7l0 0c-.6-1.7-1.5-3.3-2.7-4.7zM48 208v48c0 76 39.4 134.9 113.2 161.2c4.9 1.7 8.6 5.7 10 10.7s.3 10.3-2.9 14.4c-9.7 12.2-17 26.5-20.9 42.1c-.7 2.8 0 5.3 2 7.4c2.2 2.4 6 4.3 10.5 4.3H352c4.5 0 8.3-1.9 10.5-4.3c2-2.2 2.7-4.6 2-7.4c-4-15.6-11.2-29.8-20.9-42.1c-3.2-4-4.3-9.4-2.9-14.4s5.2-9 10-10.7C424.6 390.9 464 332 464 256V208H48zm432 48c0 77.1-37.9 139-108.4 170.1c-5 2.2-10.1 4.2-15.5 6.1c3.4 4.3 6.6 8.8 9.5 13.6c6.4 10.6 11.3 22.2 14.5 34.5c4.4 17.1-10.4 31.7-28.1 31.7H160c-17.7 0-32.4-14.6-28.1-31.7c3.1-12.3 8.1-23.9 14.5-34.5c2.9-4.7 6-9.3 9.5-13.6c-5.3-1.9-10.5-3.9-15.5-6.1C69.9 395 32 333.1 32 256V224 208H16 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32 480h24c4.4 0 8 3.6 8 8s-3.6 8-8 8h-8H480v16 32z"],
    "road-barrier": [640, 512, [], "e562", "M8 32c4.4 0 8 3.6 8 8V80H624V40c0-4.4 3.6-8 8-8s8 3.6 8 8V80 96 288v16V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V304H16V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V304 288 96 80 40c0-4.4 3.6-8 8-8zM624 288V96h-7.1l-1.8 3.6L520.9 288H624zM16 288h7.1l1.8-3.6L119.1 96H16V288zM599.1 96H456.9l-1.8 3.6L360.9 288H503.1l1.8-3.6L599.1 96zM136.9 96l-1.8 3.6L40.9 288H183.1l1.8-3.6L279.1 96H136.9zm158.2 3.6L200.9 288H343.1l1.8-3.6L439.1 96H296.9l-1.8 3.6z"],
    "chart-candlestick": [512, 512, [], "e0e2", "M8 32c4.4 0 8 3.6 8 8V408c0 30.9 25.1 56 56 56H504c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-39.8 0-72-32.2-72-72V40c0-4.4 3.6-8 8-8zm280 80c-8.8 0-16 7.2-16 16v96c0 8.8 7.2 16 16 16h16 16c8.8 0 16-7.2 16-16V128c0-8.8-7.2-16-16-16H304 288zm8 200V256h-8c-17.7 0-32-14.3-32-32V128c0-17.7 14.3-32 32-32h8V40c0-4.4 3.6-8 8-8s8 3.6 8 8V96h8c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32h-8v56c0 4.4-3.6 8-8 8s-8-3.6-8-8zm104-88v64c0 8.8 7.2 16 16 16h16 16c8.8 0 16-7.2 16-16V224c0-8.8-7.2-16-16-16H432 416c-8.8 0-16 7.2-16 16zm24 96h-8c-17.7 0-32-14.3-32-32V224c0-17.7 14.3-32 32-32h8V136c0-4.4 3.6-8 8-8s8 3.6 8 8v56h8c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32h-8v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V320zM208 160c0-8.8-7.2-16-16-16H176 160c-8.8 0-16 7.2-16 16V288c0 8.8 7.2 16 16 16h16 16c8.8 0 16-7.2 16-16V160zM184 320v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V320h-8c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32h8V72c0-4.4 3.6-8 8-8s8 3.6 8 8v56h8c17.7 0 32 14.3 32 32V288c0 17.7-14.3 32-32 32h-8z"],
    "briefcase-blank": [512, 512, [], "e0c8", "M144 40V96H368V40c0-13.3-10.7-24-24-24H168c-13.3 0-24 10.7-24 24zM128 96V40c0-22.1 17.9-40 40-40H344c22.1 0 40 17.9 40 40V96h64c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160c0-35.3 28.7-64 64-64h64zm248 16H136 64c-26.5 0-48 21.5-48 48V416c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V160c0-26.5-21.5-48-48-48H376z"],
    "school": [640, 512, [127979], "f549", "M324.6 1.4c-2.8-1.9-6.4-1.9-9.2 0L157.5 112H56c-30.9 0-56 25.1-56 56V456c0 30.9 25.1 56 56 56H256h16 96 16H584c30.9 0 56-25.1 56-56V168c0-30.9-25.1-56-56-56H482.5L324.6 1.4zM384 496V384c0-35.3-28.7-64-64-64s-64 28.7-64 64V496H56c-22.1 0-40-17.9-40-40V168c0-22.1 17.9-40 40-40H160c1.6 0 3.2-.5 4.6-1.4L320 17.8 475.4 126.6c1.3 .9 2.9 1.4 4.6 1.4H584c22.1 0 40 17.9 40 40V456c0 22.1-17.9 40-40 40H384zm-16 0H272V384c0-26.5 21.5-48 48-48s48 21.5 48 48V496zM64 216v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V216c0-13.3-10.7-24-24-24H88c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H88c-4.4 0-8-3.6-8-8V216c0-4.4 3.6-8 8-8zm432-16c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V216c0-13.3-10.7-24-24-24H520zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H520c-4.4 0-8-3.6-8-8V216zM320 112a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 144a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm8-112c0-4.4-3.6-8-8-8s-8 3.6-8 8v32c0 4.4 3.6 8 8 8h24c4.4 0 8-3.6 8-8s-3.6-8-8-8H328V144zM64 344v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V344c0-13.3-10.7-24-24-24H88c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H88c-4.4 0-8-3.6-8-8V344c0-4.4 3.6-8 8-8zm432-16c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V344c0-13.3-10.7-24-24-24H520zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H520c-4.4 0-8-3.6-8-8V344z"],
    "igloo": [576, 512, [], "f7ae", "M560 320v16H464V192h64.1c20.4 38.1 31.9 81.7 31.9 128zM448 336H378.5c-13.2-37.3-48.7-64-90.5-64s-77.4 26.7-90.5 64H128V192H320h16H448V336zm-65.3 16H448h16 96v64c0 26.5-21.5 48-48 48H384V368c0-5.5-.5-10.8-1.3-16zM128 352h65.3c-.9 5.2-1.3 10.5-1.3 16v96H64c-26.5 0-48-21.5-48-48V352h96 16zm-16-16H16V320c0-46.3 11.6-89.9 32-128.1v.1h64V336zM518.8 176H336V52.2C413 65.9 478.8 112.1 518.8 176zM288 48c10.8 0 21.5 .6 32 1.9V176H57.2C105.3 99.1 190.7 48 288 48zM64 480H192 384 512c35.3 0 64-28.7 64-64V320C576 160.9 447.1 32 288 32S0 160.9 0 320v96c0 35.3 28.7 64 64 64zM288 288c44.2 0 80 35.8 80 80v96H208V368c0-44.2 35.8-80 80-80z"],
    "bracket-round": [192, 512, ["parenthesis"], "28", "M159.2 36.4c2 4 .4 8.8-3.6 10.7c-23.1 11.5-58.2 36.1-87.4 71.7C39 154.5 16 200.7 16 256s23 101.5 52.2 137.1c29.2 35.7 64.3 60.2 87.4 71.7c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6c-24.9-12.5-61.8-38.3-92.6-75.9C25 365.7 0 315.9 0 256s25-109.7 55.8-147.3c30.8-37.5 67.7-63.4 92.6-75.9c4-2 8.8-.4 10.7 3.6z"],
    "joint": [640, 512, [], "f595", "M448 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V43c0 48.8 19.4 95.6 53.9 130.1l21 21C520.4 207.6 528 225.9 528 245v35c0 4.4 3.6 8 8 8s8-3.6 8-8V245c0-23.3-9.3-45.7-25.8-62.2l-21-21C465.7 130.3 448 87.5 448 43V8zM624 280c0 4.4 3.6 8 8 8s8-3.6 8-8V245c0-48.8-19.4-95.6-53.9-130.1l-21-21C551.6 80.4 544 62.1 544 43V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V43c0 23.3 9.3 45.7 25.8 62.2l21 21C606.3 157.7 624 200.5 624 245v35zM266 368H406l3.6 4.8L502 496H362l-3.6-4.8L266 368zm160 0H592c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H522l-3.6-4.8L426 368zM342 496H258.6c-63.1 0-125.6-12-184.2-35.5L20.8 439.1c-2.9-1.2-4.8-4-4.8-7.1s1.9-5.9 4.8-7.1l53.6-21.4c54.7-21.9 112.9-33.8 171.7-35.3l3.5 4.6L342 496zM592 352H258.6c-65.1 0-129.7 12.4-190.2 36.6L14.9 410.1C5.9 413.6 0 422.3 0 432s5.9 18.4 14.9 21.9l53.6 21.4c60.5 24.2 125 36.6 190.2 36.6H592c26.5 0 48-21.5 48-48V400c0-26.5-21.5-48-48-48z"],
    "horse-saddle": [576, 512, [], "f8c3", "M328 136c0-66.3 53.7-120 120-120h8 16 21.8c28.9 0 53 21.9 55.7 50.7l7 73.8c1.8 18.5-8.1 36.2-24.7 44.6c-22.3 11.1-49.3 2.1-60.5-20.2l-8.3-16.5c-1.4-2.7-4.1-4.4-7.2-4.4H440c-4.4 0-8 3.6-8 8v87.5 .4l0 .1c-.2 25.4-11.6 47.6-29.2 62.5c-1.8 1.5-2.8 3.8-2.8 6.1V480c0 8.8-7.2 16-16 16H344c-8.8 0-16-7.2-16-16V325.7c0-3.8-2.6-7-6.3-7.8L248 301.7v-54c44.9-4 80-41.7 80-87.6V136zm-88 96c-39.8 0-72-32.2-72-72V144h23.8H224h88v16c0 39.8-32.2 72-72 72zm-8 15.6v50.5l-33.7-7.4c-2.7-.6-5.5 .2-7.4 2.2s-2.7 4.8-2.1 7.5c2.1 9 3.2 18.1 3.2 27.4c0 16.1-3.3 32.1-9.6 46.9l-6.5 15.3c-3.6 8.4-4.2 17.7-1.8 26.5l16.5 59.3c2.8 10.2-4.8 20.3-15.4 20.3H125.3c-7.2 0-13.5-4.8-15.4-11.7L97 437.8c-7.3-26.3-5.4-54.3 5.3-79.4l6.5-15.3c2.1-4.8 3.2-10.1 3.2-15.3c0-5.1-1-10.2-3-15L77.1 236.3c-3.4-8.1-5.1-16.8-5.1-25.6c0-36.8 29.8-66.7 66.7-66.7H152v16c0 45.9 35.1 83.6 80 87.6zM191.8 128H160 138.7c-26.6 0-50.2 12.5-65.3 32H72 64c-35.3 0-64 28.7-64 64v88c0 4.4 3.6 8 8 8s8-3.6 8-8V224c0-26.4 21.3-47.8 47.6-48c-4.9 10.5-7.6 22.3-7.6 34.7c0 10.9 2.2 21.7 6.4 31.8L94.2 319c1.2 2.8 1.8 5.8 1.8 8.8c0 3.1-.6 6.2-1.9 9l-6.5 15.3c-12.2 28.4-14.3 60.2-6 90l12.9 46.5c3.8 13.9 16.5 23.4 30.8 23.4h49.8c21.2 0 36.5-20.2 30.8-40.6l-16.5-59.3c-1.5-5.3-1.1-10.9 1.1-15.9l6.5-15.3c7.2-16.8 10.9-34.9 10.9-53.2c0-6.3-.4-12.6-1.3-18.8L312 332.1V480c0 17.7 14.3 32 32 32h40c17.7 0 32-14.3 32-32V312.1c19.3-17.7 31.8-43.1 32-71.9l0-.2v-.5V160h3.1l6.1 12.1c15.1 30.2 51.8 42.4 81.9 27.3c22.6-11.3 35.9-35.3 33.5-60.4l-7-73.8c-1.9-20-11.8-37.4-26.4-49.2H552c4.4 0 8-3.6 8-8s-3.6-8-8-8H493.8 472 456h-8C375.6 0 316.4 56.6 312.2 128H224 191.8zM512 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "mug-marshmallows": [512, 512, [], "f7b7", "M203.5 40.6L191.9 52.2C187.2 49.5 181.8 48 176 48H80C62.3 48 48 62.3 48 80v48H32V80c0-26.5 21.5-48 48-48h96c10.2 0 19.7 3.2 27.5 8.6zM360 128H344c0-.3 0-.6 0-.9v-6.3c0-6.4-2.5-12.5-7-17L287.5 54.4c-4.1-4.1-9.7-6.4-15.5-6.4s-11.4 2.3-15.5 6.4L207 103.9c-4.5 4.5-7 10.6-7 17v5.2c0 .6 0 1.3 .1 1.9H184c0-.6 0-1.3 0-1.9v-5.2c0-10.6 4.2-20.8 11.7-28.3l49.5-49.5C252.3 36 261.9 32 272 32s19.7 4 26.8 11.1l49.5 49.5c7.5 7.5 11.7 17.7 11.7 28.3v6.3l0 .9zM176 176v72c0 4.4-3.6 8-8 8s-8-3.6-8-8V176H112V280c0 4.4-3.6 8-8 8s-8-3.6-8-8V176H32c-8.8 0-16 7.2-16 16V384c0 44.2 35.8 80 80 80H288c44.2 0 80-35.8 80-80V176H344 176zm208 0V352h24c48.6 0 88-39.4 88-88s-39.4-88-88-88H384zm0 192v16c0 53-43 96-96 96H96c-53 0-96-43-96-96V192c0-17.7 14.3-32 32-32H344h24 16 24c57.4 0 104 46.6 104 104s-46.6 104-104 104H384z"],
    "filters": [640, 512, [], "e17e", "M223.3 32C206 32 192 46 192 63.3c0 7.5 2.7 14.8 7.7 20.5L352 259V367.9c0 7.7 3.7 14.9 9.9 19.4L438.5 443c4.5 3.2 9.8 5 15.4 5c14.4 0 26.1-11.7 26.1-26.1V259L632.3 83.8c5-5.7 7.7-13 7.7-20.5C640 46 626 32 608.7 32H223.3zM208 63.3c0-8.4 6.8-15.3 15.3-15.3H608.7c8.4 0 15.3 6.8 15.3 15.3c0 3.7-1.3 7.3-3.8 10L466 250.8c-1.3 1.5-2 3.3-2 5.2V421.9c0 5.6-4.5 10.1-10.1 10.1c-2.1 0-4.2-.7-5.9-1.9l-76.6-55.7c-2.1-1.5-3.3-3.9-3.3-6.5V256c0-1.9-.7-3.8-2-5.2L211.8 73.3c-2.4-2.8-3.8-6.3-3.8-10zM31.3 96C14 96 0 110 0 127.3c0 7.5 2.7 14.8 7.7 20.5L160 323v76.9c0 7.7 3.7 14.9 9.9 19.4L246.5 475c4.5 3.2 9.8 5 15.4 5c14.4 0 26.1-11.7 26.1-26.1V323l32-36.6V271l-3.8-4.4L274 314.7c-1.3 1.5-2 3.3-2 5.3V453.9c0 5.6-4.5 10.1-10.1 10.1c-2.1 0-4.2-.7-5.9-1.9l-76.6-55.7c-2.1-1.5-3.3-3.9-3.3-6.5V320c0-1.9-.7-3.8-2-5.2L19.8 137.3c-2.4-2.8-3.8-6.3-3.8-10c0-8.4 6.8-15.3 15.3-15.3H181.8l-6.2-7.2c-2.4-2.8-4.6-5.7-6.4-8.8H31.3z"],
    "bell-on": [640, 512, [128365], "f8fa", "M312 8c0-4.4 3.6-8 8-8s8 3.6 8 8V32l0 .2c84.6 4.2 152 74.1 152 159.8v36.6c0 41.8 14.2 82.3 40.3 114.9l16.7 20.9c4.5 5.6 6.9 12.6 6.9 19.8c0 17.5-14.2 31.7-31.7 31.7H127.7C110.2 416 96 401.8 96 384.3c0-7.2 2.4-14.2 6.9-19.8l16.7-20.9C145.8 311 160 270.4 160 228.6V192c0-85.7 67.4-155.6 152-159.8l0-.2V8zm8 40c-79.5 0-144 64.5-144 144v36.6c0 45.4-15.5 89.5-43.8 124.9l-16.7 20.9c-2.2 2.8-3.4 6.2-3.4 9.8c0 8.7 7 15.7 15.7 15.7H512.3c8.7 0 15.7-7 15.7-15.7c0-3.6-1.2-7-3.4-9.8l-16.7-20.9C479.5 318.1 464 274.1 464 228.6V192c0-79.5-64.5-144-144-144zM272 448c0 12.7 5.1 24.9 14.1 33.9s21.2 14.1 33.9 14.1s24.9-5.1 33.9-14.1s14.1-21.2 14.1-33.9c0-4.4 3.6-8 8-8s8 3.6 8 8c0 17-6.7 33.3-18.7 45.3s-28.3 18.7-45.3 18.7s-33.3-6.7-45.3-18.7s-18.7-28.3-18.7-45.3c0-4.4 3.6-8 8-8s8 3.6 8 8zM0 184c0-4.4 3.6-8 8-8h96c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8zm536-8h96c4.4 0 8 3.6 8 8s-3.6 8-8 8H536c-4.4 0-8-3.6-8-8s3.6-8 8-8zM607.2 36.4c2 4 .4 8.8-3.6 10.7l-80 40c-4 2-8.8 .4-10.7-3.6s-.4-8.8 3.6-10.7l80-40c4-2 8.8-.4 10.7 3.6zM36.4 47.2c-4-2-5.6-6.8-3.6-10.7s6.8-5.6 10.7-3.6l80 40c4 2 5.6 6.8 3.6 10.7s-6.8 5.6-10.7 3.6l-80-40z"],
    "angle-right": [320, 512, [8250], "f105", "M269.7 250.3c3.1 3.1 3.1 8.2 0 11.3l-176 176c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L252.7 256 82.3 85.7c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l176 176z"],
    "dial-med": [576, 512, [], "e15f", "M272 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM296 288V144.2c75.8 4.2 136 66.9 136 143.8c0 79.5-64.5 144-144 144s-144-64.5-144-144c0-76.8 60.2-139.6 136-143.8V288c0 4.4 3.6 8 8 8s8-3.6 8-8zm-8-160a160 160 0 1 0 0 320 160 160 0 1 0 0-320zM544 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM16 288a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0A32 32 0 1 0 0 288a32 32 0 1 0 64 0zM96 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM464 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 464a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm368-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "horse": [576, 512, [128014], "f6f0", "M328 136c0 4.4-3.6 8-8 8H224 191.8 138.7C101.8 144 72 173.8 72 210.7c0 8.8 1.7 17.5 5.1 25.6L109 312.8c2 4.7 3 9.8 3 15c0 5.3-1.1 10.5-3.2 15.3l-6.5 15.3c-10.8 25.1-12.6 53.1-5.3 79.4l12.9 46.5c1.9 6.9 8.2 11.7 15.4 11.7h49.8c10.6 0 18.2-10.1 15.4-20.3l-16.5-59.3c-2.4-8.8-1.8-18.1 1.8-26.5l6.5-15.3c6.3-14.8 9.6-30.7 9.6-46.9c0-9.2-1.1-18.4-3.2-27.4c-.6-2.7 .2-5.5 2.1-7.5s4.7-2.8 7.4-2.2l123.4 27.1c3.7 .8 6.3 4.1 6.3 7.8V480c0 8.8 7.2 16 16 16h40c8.8 0 16-7.2 16-16V308.5c0-2.4 1-4.6 2.8-6.1c17.6-14.9 29-37.1 29.2-62.5l0-.1v-.4V152c0-4.4 3.6-8 8-8h16c3 0 5.8 1.7 7.2 4.4l8.3 16.5c11.1 22.3 38.2 31.3 60.5 20.2c16.7-8.3 26.5-26 24.7-44.6l-7-73.8C546.8 37.9 522.7 16 493.8 16H472 456h-8c-66.3 0-120 53.7-120 120zM539.1 16c14.6 11.8 24.5 29.2 26.4 49.2l7 73.8c2.4 25.1-10.9 49.1-33.5 60.4c-30.2 15.1-66.8 2.9-81.9-27.3L451.1 160H448v79.5 .5l0 .2c-.2 28.8-12.7 54.2-32 71.9V480c0 17.7-14.3 32-32 32H344c-17.7 0-32-14.3-32-32V332.1L206.7 309c.9 6.2 1.3 12.5 1.3 18.8c0 18.3-3.7 36.4-10.9 53.2l-6.5 15.3c-2.2 5-2.5 10.6-1.1 15.9L206 471.4c5.7 20.4-9.7 40.6-30.8 40.6H125.3c-14.4 0-27-9.6-30.8-23.4L81.6 442.1c-8.3-29.8-6.2-61.5 6-90l6.5-15.3c1.2-2.9 1.9-5.9 1.9-9c0-3-.6-6-1.8-8.8L62.4 242.5c-4.2-10.1-6.4-20.9-6.4-31.8c0-12.4 2.7-24.1 7.6-34.7C37.3 176.2 16 197.6 16 224v88c0 4.4-3.6 8-8 8s-8-3.6-8-8V224c0-35.3 28.7-64 64-64h8 1.3c15.1-19.5 38.8-32 65.3-32h53.1H224h88.2C316.4 56.6 375.6 0 448 0h8 16 21.8H552c4.4 0 8 3.6 8 8s-3.6 8-8 8H539.1zM480 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "q": [448, 512, [113], "51", "M16 256c0 114.9 93.1 208 208 208c49.5 0 95-17.3 130.7-46.2L226 269.2c-2.9-3.3-2.5-8.4 .8-11.3s8.4-2.5 11.3 .8L366.8 407.3C406.9 369.4 432 315.6 432 256c0-114.9-93.1-208-208-208S16 141.1 16 256zM365.2 429.9C326.7 461.2 277.5 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32s224 100.3 224 224c0 64.4-27.2 122.5-70.8 163.4L446 498.8c2.9 3.3 2.5 8.4-.8 11.3s-8.4 2.5-11.3-.8l-68.8-79.3z"],
    "monitor-waveform": [576, 512, ["monitor-heart-rate"], "f611", "M512 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H512zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM279.6 160c-3.2 .2-5.9 2.2-7.1 5.1L214 318.7l-39.4-59.1c-1.5-2.2-4-3.6-6.7-3.6H80V128c0-8.8 7.2-16 16-16H480c8.8 0 16 7.2 16 16V384c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V272h83.7l45.6 68.4c1.7 2.5 4.6 3.8 7.6 3.5s5.5-2.3 6.6-5.1l57.5-151 39.9 79.7c1.4 2.7 4.1 4.4 7.2 4.4h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H332.9l-45.8-91.6c-1.4-2.8-4.4-4.6-7.6-4.4zM64 128V384c0 17.7 14.3 32 32 32H480c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H96c-17.7 0-32 14.3-32 32z"],
    "link-simple": [576, 512, [], "e1cd", "M0 256C0 167.6 71.6 96 160 96h88c4.4 0 8 3.6 8 8s-3.6 8-8 8H160C80.5 112 16 176.5 16 256s64.5 144 144 144h88c4.4 0 8 3.6 8 8s-3.6 8-8 8H160C71.6 416 0 344.4 0 256zm576 0c0 88.4-71.6 160-160 160H328c-4.4 0-8-3.6-8-8s3.6-8 8-8h88c79.5 0 144-64.5 144-144s-64.5-144-144-144H328c-4.4 0-8-3.6-8-8s3.6-8 8-8h88c88.4 0 160 71.6 160 160zm-440-8H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H136c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "whistle": [640, 512, [], "f460", "M105.9 104.6C82.4 123 63.2 146.7 50.3 174C30.5 168.1 16 149.8 16 128c0-26.5 21.5-48 48-48c18 0 33.7 9.9 41.9 24.6zM0 128c0 28.4 18.5 52.5 44.1 60.8C36.3 209.7 32 232.4 32 256c0 106 86 192 192 192c64.7 0 121.9-32 156.7-81L529 444.4c4.6 2.4 9.6 3.6 14.8 3.6h2c9 0 17.6-3.8 23.7-10.5l63.4-69.7c4.6-5 7.1-11.6 7.1-18.4c0-8.5-3.9-16.5-10.6-21.6L500.8 228.2c-5.2-4-12.4-4.5-18-1.1l-17.7 10.6c-10.3 6.2-23.4 5.5-33-1.7c-9.7-7.3-14-19.8-10.8-31.5l5.7-21c1.7-6.2-.5-12.9-5.6-16.9l-62.6-48.4c-.9-.7-1.8-1.3-2.7-1.7C321.6 84 275.2 64 224 64c-38.8 0-74.8 11.5-105 31.2C107.8 76.5 87.4 64 64 64C28.7 64 0 92.7 0 128zM367.7 357.7C335.7 402.7 283.3 432 224 432c-97.2 0-176-78.8-176-176s78.8-176 176-176c46.9 0 89.5 18.3 121 48.2c1.1 1.1 2.4 2 3.8 2.7l0 0 .1 .1 62.6 48.4-5.7 21c-4.9 18 1.7 37.2 16.6 48.5c14.8 11.1 34.9 12.2 50.8 2.6L491 240.9l128.6 99.6c2.8 2.2 4.4 5.5 4.4 9c0 2.8-1.1 5.6-3 7.6l-63.4 69.7c-3 3.3-7.3 5.2-11.8 5.2h-2c-2.6 0-5.1-.6-7.4-1.8L388.1 352.8c-7.1-3.7-15.8-1.6-20.4 4.9zM176 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "g": [448, 512, [103], "47", "M224 48C109.1 48 16 141.1 16 256s93.1 208 208 208c109.7 0 199.6-84.9 207.4-192.6c.3-3.8-2.9-7.4-7.4-7.4H232c-4.4 0-8-3.6-8-8s3.6-8 8-8H424c13.1 0 24.4 10.8 23.4 24.6C438.9 388.6 342.1 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32c57.4 0 109.7 21.6 149.3 57c3.3 2.9 3.6 8 .6 11.3s-8 3.6-11.3 .6C325.9 68 277.3 48 224 48z"],
    "wine-glass-crack": [320, 512, ["fragile"], "f4bb", "M60.1 29.8C61.2 21.9 67.9 16 75.9 16h75.5l1.2 3 29.3 73.2-57.4 28.7c-2.3 1.2-3.9 3.3-4.3 5.9s.4 5.1 2.2 6.9l64 64c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-56.2-56.2 54.1-27c3.7-1.9 5.4-6.3 3.8-10.1L168.6 16h75.5c8 0 14.8 5.9 15.9 13.8l22.6 165.8C292.7 269.9 234.9 336 160 336S27.3 269.9 37.5 195.6L60.1 29.8zM44.2 27.7L21.6 193.5C10.5 274.7 71.3 347.3 152 351.8V496H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h88 88c4.4 0 8-3.6 8-8s-3.6-8-8-8H168V351.8c80.7-4.5 141.5-77.1 130.4-158.3L275.8 27.7C273.6 11.8 260.1 0 244.1 0H75.9c-16 0-29.5 11.8-31.7 27.7z"],
    "slot-machine": [640, 512, [], "e3ce", "M432 416v32c0 26.5-21.5 48-48 48H128c-26.5 0-48-21.5-48-48V416H432zm-5.7 80c13.3-11.7 21.7-28.9 21.7-48V416c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64V64c0-35.3-28.7-64-64-64H128C92.7 0 64 28.7 64 64V96C28.7 96 0 124.7 0 160V352c0 35.3 28.7 64 64 64v32c0 35.3 28.7 64 64 64H384 528c39.8 0 72-32.2 72-72V223.3c22.7-3.8 40-23.6 40-47.3c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 23.8 17.3 43.5 40 47.3V440c0 30.9-25.1 56-56 56H426.3zM560 176a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM432 64V96H80V64c0-26.5 21.5-48 48-48l256 0c26.5 0 48 21.5 48 48zm16 48c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V160c0-26.5 21.5-48 48-48H448zM96 176c-4.4 0-8 3.6-8 8s3.6 8 8 8h60.3L104.5 325.1c-1.6 4.1 .4 8.8 4.6 10.4s8.8-.4 10.4-4.6l56-144c1-2.5 .6-5.2-.9-7.4s-4-3.5-6.6-3.5H96zm128 0c-4.4 0-8 3.6-8 8s3.6 8 8 8h60.3L232.5 325.1c-1.6 4.1 .4 8.8 4.6 10.4s8.8-.4 10.4-4.6l56-144c1-2.5 .6-5.2-.9-7.4s-4-3.5-6.6-3.5H224zm128 0c-4.4 0-8 3.6-8 8s3.6 8 8 8h60.3L360.5 325.1c-1.6 4.1 .4 8.8 4.6 10.4s8.8-.4 10.4-4.6l56-144c1-2.5 .6-5.2-.9-7.4s-4-3.5-6.6-3.5H352z"],
    "notes-medical": [512, 512, [], "f481", "M112 96c0-26.5 21.5-48 48-48H416c26.5 0 48 21.5 48 48V293.5c0 12.7-5.1 24.9-14.1 33.9l-58.5 58.5c-9 9-21.2 14.1-33.9 14.1H160c-26.5 0-48-21.5-48-48V96zM96 96V352c0 35.3 28.7 64 64 64H357.5c17 0 33.3-6.7 45.3-18.7l58.5-58.5c12-12 18.7-28.3 18.7-45.3V96c0-35.3-28.7-64-64-64H160c-35.3 0-64 28.7-64 64zm176 32h32c4.4 0 8 3.6 8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H320c-4.4 0-8 3.6-8 8v56c0 4.4-3.6 8-8 8H272c-4.4 0-8-3.6-8-8V256c0-4.4-3.6-8-8-8H200c-4.4 0-8-3.6-8-8V208c0-4.4 3.6-8 8-8h56c4.4 0 8-3.6 8-8V136c0-4.4 3.6-8 8-8zm-24 8v48H200c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h48v48c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V264h48c13.3 0 24-10.7 24-24V208c0-13.3-10.7-24-24-24H328V136c0-13.3-10.7-24-24-24H272c-13.3 0-24 10.7-24 24zM0 192V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64H368c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V192c0-26.5 21.5-48 48-48V128c-35.3 0-64 28.7-64 64z"],
    "car-wash": [448, 512, [], "f5e6", "M87.1 104.2C82 109 74.1 112 64 112c-17.7 0-32-14.3-32-32c0-6.4 3.7-16.2 10.9-28C49.4 41.5 57.4 31.4 64 23.7C70.6 31.4 78.6 41.5 85.1 52C92.3 63.8 96 73.6 96 80c0 12.2-4 19.7-8.9 24.2zM64 128c26.5 0 48-16 48-48c0-22.2-23-52-37.2-68.2C69 5.1 59 5.1 53.2 11.8C39 28 16 57.8 16 80c0 26.5 21.5 48 48 48zM256 80c0 12.2-4 19.7-8.9 24.2c-5.1 4.7-13 7.8-23.1 7.8c-17.7 0-32-14.3-32-32c0-6.4 3.7-16.2 10.9-28c6.5-10.5 14.5-20.7 21.1-28.3c6.6 7.7 14.6 17.8 21.1 28.3C252.3 63.8 256 73.6 256 80zm16 0c0-22.2-23-52-37.2-68.2c-5.8-6.7-15.9-6.7-21.7 0C199 28 176 57.8 176 80c0 26.5 21.5 48 48 48s48-16 48-48zM156.2 192H291.8c17.9 0 33.6 11.8 38.5 29l19.5 68.2c-4.5-.8-9-1.2-13.7-1.2H112c-4.7 0-9.3 .4-13.7 1.2L117.7 221c4.9-17.2 20.6-29 38.5-29zM80.3 293.8l-.2 .8C51.8 307 32 335.2 32 368v64 16 32c0 17.7 14.3 32 32 32H80c17.7 0 32-14.3 32-32V448H336v32c0 17.7 14.3 32 32 32h16c17.7 0 32-14.3 32-32V448 432 368c0-32.8-19.8-61-48.1-73.4l-.2-.8-22.1-77.2c-6.9-24-28.8-40.6-53.8-40.6H156.2c-25 0-47 16.6-53.8 40.6L80.3 293.8zM352 432H336 112 96 48V368c0-35.3 28.7-64 64-64H336c35.3 0 64 28.7 64 64v64H352zm0 48V448h48v32c0 8.8-7.2 16-16 16H368c-8.8 0-16-7.2-16-16zM96 448v32c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V448H96zm32-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm224 48a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32-16a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM416 80c0 12.2-4 19.7-8.9 24.2c-5.1 4.7-13 7.8-23.1 7.8c-17.7 0-32-14.3-32-32c0-6.4 3.7-16.2 10.9-28c6.5-10.5 14.5-20.7 21.1-28.3c6.6 7.7 14.6 17.8 21.1 28.3C412.3 63.8 416 73.6 416 80zm16 0c0-22.2-23-52-37.2-68.2c-5.8-6.7-15.9-6.7-21.7 0C359 28 336 57.8 336 80c0 26.5 21.5 48 48 48s48-16 48-48z"],
    "escalator": [640, 512, [], "e171", "M280 56a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-96 0a56 56 0 1 1 112 0A56 56 0 1 1 184 56zM400.6 161.8c13.1-11.5 30-17.8 47.4-17.8H568c39.8 0 72 32.2 72 72s-32.2 72-72 72H475.1L239.4 494.2c-13.1 11.5-30 17.8-47.4 17.8H72c-39.8 0-72-32.2-72-72s32.2-72 72-72h92.9L400.6 161.8zM448 160c-13.6 0-26.7 4.9-36.9 13.9L173.2 382c-1.5 1.3-3.3 2-5.3 2H72c-30.9 0-56 25.1-56 56s25.1 56 56 56H192c13.6 0 26.7-4.9 36.9-13.9L466.8 274c1.5-1.3 3.3-2 5.3-2h96c30.9 0 56-25.1 56-56s-25.1-56-56-56H448zM312.8 190.8l-12.7 11.1c-9-24.5-32.5-41.9-60.1-41.9c-35.3 0-64 28.7-64 64v86.5l-16 14V224c0-44.2 35.8-80 80-80c32.3 0 60.2 19.2 72.8 46.8z"],
    "comment-image": [512, 512, [], "e148", "M157.3 415c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8C68.3 456 41.6 464 16 464l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C28 450 34 442 40 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C31.9 318.8 16 280.7 16 240C16 136.9 120.2 48 256 48s240 88.9 240 192s-104.2 192-240 192c-35.2 0-68.6-6.1-98.7-17zM4.7 452.7l0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0zM200 160a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-40-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm135.7 24c2.6 0 5 1.3 6.5 3.4L407.2 313.4c.5 .7 .8 1.5 .8 2.4c0 2.3-1.9 4.2-4.2 4.2h-296c-2.1 0-3.8-1.7-3.8-3.8c0-.9 .3-1.7 .8-2.4l56.5-70.6c1.6-2 4-3.1 6.5-3.1c2.6 0 5.1 1.2 6.7 3.3l19.1 25.5c1.5 2 3.8 3.2 6.3 3.2s4.8-1.1 6.4-3.1L289.5 163c1.5-1.9 3.8-3 6.2-3zm-18.8-6.9l-76.8 97.7-12.9-17.1c-4.6-6.1-11.8-9.7-19.5-9.7c-7.4 0-14.4 3.4-19 9.1L92.3 303.8c-2.8 3.5-4.3 7.9-4.3 12.4c0 11 8.9 19.8 19.8 19.8h296c11.1 0 20.2-9 20.2-20.2c0-4.1-1.3-8.2-3.6-11.6L315.3 154.2c-4.5-6.4-11.8-10.2-19.6-10.2c-7.3 0-14.3 3.4-18.8 9.1z"],
    "temperature-half": [320, 512, [127777, "temperature-2", "thermometer-2", "thermometer-half"], "f2c9", "M160 16c-35.3 0-64 28.7-64 64V243.8c0 8.4-4.4 15.7-10.7 20.3C53 287.3 32 325.2 32 368c0 70.7 57.3 128 128 128s128-57.3 128-128c0-42.8-21-80.7-53.3-104c-6.3-4.6-10.7-11.9-10.7-20.3V80c0-35.3-28.7-64-64-64zM80 80c0-44.2 35.8-80 80-80s80 35.8 80 80V243.8c0 2.7 1.4 5.4 4 7.3c36.3 26.1 60 68.8 60 117c0 79.5-64.5 144-144 144S16 447.5 16 368c0-48.2 23.7-90.8 60-117c2.6-1.9 4-4.6 4-7.3V80zm80 336a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0 16c-35.3 0-64-28.7-64-64c0-32.6 24.4-59.6 56-63.5V200c0-4.4 3.6-8 8-8s8 3.6 8 8V304.5c31.6 3.9 56 30.9 56 63.5c0 35.3-28.7 64-64 64z"],
    "dong-sign": [384, 512, [], "e169", "M312 32c-4.4 0-8 3.6-8 8V80H200c-4.4 0-8 3.6-8 8s3.6 8 8 8H304V226c-21.8-39.4-63.8-66-112-66c-70.7 0-128 57.3-128 128s57.3 128 128 128c48.2 0 90.2-26.6 112-66v58c0 4.4 3.6 8 8 8s8-3.6 8-8V288 96h24c4.4 0 8-3.6 8-8s-3.6-8-8-8H320V40c0-4.4-3.6-8-8-8zM80 288a112 112 0 1 1 224 0A112 112 0 1 1 80 288zM8 464c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H8z"],
    "donut": [512, 512, [127849, "doughnut"], "e406", "M16 208c0-36.7 23.8-72.3 67.5-99.6C126.9 81.3 187.8 64 256 64c9.4 0 18.6 .3 27.7 1L250.3 98.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l40-40c.8-.8 1.4-1.8 1.8-2.8c48.8 6 92 20.9 125.1 41.6C472.2 135.7 496 171.3 496 208v23.3c-.7 10.5-4.5 20.6-10.9 28.9c-6.5 8.4-15.3 14.6-25.4 17.9l0 0-.3 .1c-10.7 4-19.8 11.3-26.1 20.9c-9.2 12.9-21.6 23.1-36 29.7c-14.4 6.7-30.3 9.5-46.1 8.2l-.3 0-.3 0c-15.3-.1-30.4 2.8-44.6 8.7l0 0c-15.8 6.7-32.8 10.1-50 9.9v0l-.2 0c-17.2 .2-34.2-3.2-50-9.9l0 0c-14.1-5.9-29.3-8.8-44.6-8.7l-.3 0-.3 0c-15.8 1.3-31.7-1.5-46.1-8.2c-14.3-6.7-26.7-16.9-36-29.8c-6.2-9.5-15.4-16.8-26-20.9l0 0-.4-.1c-10.1-3.3-18.9-9.5-25.4-17.9c-6.4-8.3-10.2-18.4-10.9-29V208zm0 64.1c8.2 9.8 19 17.1 31.2 21.1c7.5 2.8 13.8 8 18.2 14.7l0 0 .2 .3c10.8 15.2 25.4 27.3 42.3 35.2c16.8 7.8 35.4 11.2 53.8 9.7c13-.1 25.9 2.4 37.9 7.5c17.8 7.6 37 11.4 56.3 11.2c19.3 .2 38.5-3.6 56.3-11.2c12-5 24.9-7.5 37.9-7.5c18.5 1.5 37-1.8 53.8-9.6c16.9-7.8 31.5-19.9 42.4-35.1l0 0 .2-.3c4.3-6.7 10.7-11.9 18.2-14.7c12.2-4 23-11.3 31.2-21.1V304c0 36.7-23.8 72.3-67.5 99.6C385.1 430.7 324.2 448 256 448s-129.1-17.3-172.5-44.4C39.8 376.3 16 340.7 16 304V272.1zM256 48C114.6 48 0 119.6 0 208v96c0 88.4 114.6 160 256 160s256-71.6 256-160V208c0-88.4-114.6-160-256-160zM209 170.7c11.6-6.5 28.2-10.7 47-10.7s35.4 4.2 47 10.7c11.9 6.6 17 14.5 17 21.3s-5.1 14.7-17 21.3c-11.6 6.5-28.2 10.7-47 10.7s-35.4-4.2-47-10.7c-11.9-6.6-17-14.5-17-21.3s5.1-14.7 17-21.3zm-7.8-14C187 164.6 176 176.7 176 192s11 27.4 25.2 35.3c14.4 8 33.8 12.7 54.8 12.7s40.4-4.7 54.8-12.7c14.2-7.9 25.2-20 25.2-35.3s-11-27.4-25.2-35.3C296.4 148.7 277 144 256 144s-40.4 4.7-54.8 12.7zm-35.5-23.1c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-32 32c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l32-32zm224 4.7c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l32 32c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-32-32zM64 200c-4.4 0-8 3.6-8 8s3.6 8 8 8H96c4.4 0 8-3.6 8-8s-3.6-8-8-8H64zm325.7 34.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l32 32c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-32-32zm-240 16c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l32 32c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-32-32zm176 27.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-32 32c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l32-32z"],
    "capsules": [576, 512, [], "f46b", "M112 48c-53 0-96 43-96 96V256H208V144c0-53-43-96-96-96zM16 368c0 53 43 96 96 96s96-43 96-96V272H16v96zM0 144C0 82.1 50.1 32 112 32s112 50.1 112 112v24.2c3-32.2 19.3-63 47.3-83c50.7-36.2 120.5-23.6 156 28.1L555.7 300.6c35.5 51.7 23.2 123-27.5 159.2s-120.5 23.6-156-28.1L243.8 244.4c-11.5-16.8-18-35.7-19.8-54.8V368c0 61.9-50.1 112-112 112S0 429.9 0 368V144zm257 91.4l62.8 91.6L474.1 209.8l-60-87.5c-30.5-44.4-90.2-55.1-133.5-24.1c-43.5 31.1-54.2 92.5-23.6 137.2zM385.4 422.7c30.5 44.4 90.2 55.1 133.5 24.1c43.5-31.1 54.2-92.5 23.6-137.2L483.1 223 328.8 340.1l56.6 82.5z"],
    "poo-storm": [448, 512, ["poo-bolt"], "f75a", "M172.3 3.4c1.5-2.1 3.9-3.4 6.5-3.4c42.1 0 79.7 11.3 107.8 32.7c27 20.6 44.6 50.2 48.6 87C364 133 384 162.1 384 196c0 3.5-.2 7-.6 10.4C421.1 220.7 448 257.2 448 300c0 52.5-40.5 95.6-91.9 99.7c4.5-5.2 7.8-11.2 9.8-17.6c37.8-8.2 66.1-41.8 66.1-82.1c0-38-25.3-70.2-59.9-80.5c-4-1.2-6.4-5.2-5.5-9.3c1-4.6 1.5-9.3 1.5-14.2c0-28.8-17.9-53.5-43.3-63.4c-2.9-1.1-4.8-3.8-5.1-6.9c-2.5-34.4-18.2-61.6-42.8-80.3c-22.3-17-52.1-27.3-86.6-29.1C194.5 28.3 200 46 200 63.4c0 27.5-13.8 43.9-27.5 53.1c-6.7 4.5-13.4 7.3-18.4 9c-2.5 .8-4.6 1.4-6.1 1.8l-.2 0c-1 .5-2 .8-3.1 .8C108.6 129.9 80 159.6 80 196c0 4.9 .5 9.6 1.5 14.2c.9 4.1-1.5 8.1-5.5 9.3C41.3 229.8 16 262 16 300c0 40.3 28.3 73.9 66.1 82.1c.2 .6 .4 1.2 .6 1.8c2.1 5.9 5.2 11.3 9.2 15.8C40.5 395.6 0 352.5 0 300c0-42.8 26.9-79.3 64.6-93.6c-.4-3.4-.6-6.9-.6-10.4c0-44.2 34.2-80.5 77.6-83.8c.3-.1 .7-.2 1.1-.3l0 0 0 0 0 0 0 0 0 0 .3-.1c.3-.1 .7-.1 1.2-.3c1.1-.3 2.8-.7 4.8-1.4c4-1.3 9.3-3.6 14.6-7.1C173.8 96.3 184 84.5 184 63.4c0-17.5-6.7-36.1-11-47.8l0-.1 0 0 0 0c-.7-1.8-1.3-3.5-1.8-5c-.8-2.4-.4-5.1 1.1-7.2zm63.3 341.5L288 240 128 368h70.1c5.5 0 10.7 2.9 13.6 7.6s3.2 10.6 .7 15.6L160 496 320 368H249.9c-5.5 0-10.7-2.9-13.6-7.6s-3.2-10.6-.7-15.6zm66.7-97.7L257.9 336l-8 16h17.9H320c6.8 0 12.9 4.3 15.1 10.7s.2 13.5-5.1 17.8l-160 128c-5.9 4.7-14.2 4.7-20.1-.1s-7.6-12.9-4.3-19.6L190.1 400l8-16H180.2 128c-6.8 0-12.8-4.3-15.1-10.7s-.2-13.5 5.1-17.8l160-128c5.9-4.7 14.2-4.7 20.1 .1s7.6 12.9 4.3 19.6z"],
    "tally-1": [640, 512, [], "e294", "M128 32c4.4 0 8 3.6 8 8V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V40c0-4.4 3.6-8 8-8z"],
    "face-frown-open": [512, 512, [128550, "frown-open"], "f57a", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm176.4-64a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm144 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm17.1 184.7c-23.4-9.9-49.7-15.5-77.6-15.5c-27.8 0-54.1 5.6-77.5 15.4c-8.7 3.7-18.2 2.3-24.9-2.6c-7-5.2-10.7-14.5-6.4-24.3c17.9-41.2 60-69.9 108.8-69.9c48.8 0 90.9 28.7 108.8 69.9c4.3 9.9 .6 19.1-6.4 24.3c-6.7 4.9-16.2 6.3-24.9 2.6zm16.6-20.5c-15.4-35.3-51.7-60.3-94.2-60.3c-42.5 0-78.8 25-94.2 60.3c-.6 1.5-.5 2.4-.4 3c.2 .6 .7 1.4 1.6 2.1c2 1.5 5.6 2.2 9.1 .7c25.4-10.7 53.8-16.7 83.7-16.7c30 0 58.4 6 83.8 16.7c3.6 1.5 7.1 .8 9.1-.7c1-.7 1.4-1.5 1.6-2.1c.2-.6 .3-1.5-.4-3z"],
    "square-dashed": [448, 512, [], "e269", "M88 32h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H88c-39.8 0-72 32.2-72 72v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V120C0 71.4 39.4 32 88 32zM8 192c4.4 0 8 3.6 8 8V312c0 4.4-3.6 8-8 8s-8-3.6-8-8V200c0-4.4 3.6-8 8-8zm432 0c4.4 0 8 3.6 8 8V312c0 4.4-3.6 8-8 8s-8-3.6-8-8V200c0-4.4 3.6-8 8-8zm0-32c-4.4 0-8-3.6-8-8V120c0-39.8-32.2-72-72-72H328c-4.4 0-8-3.6-8-8s3.6-8 8-8h32c48.6 0 88 39.4 88 88v32c0 4.4-3.6 8-8 8zm8 200v32c0 48.6-39.4 88-88 88H328c-4.4 0-8-3.6-8-8s3.6-8 8-8h32c39.8 0 72-32.2 72-72V360c0-4.4 3.6-8 8-8s8 3.6 8 8zM16 360v32c0 39.8 32.2 72 72 72h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H88c-48.6 0-88-39.4-88-88V360c0-4.4 3.6-8 8-8s8 3.6 8 8zM168 480c-4.4 0-8-3.6-8-8s3.6-8 8-8H280c4.4 0 8 3.6 8 8s-3.6 8-8 8H168zM160 40c0-4.4 3.6-8 8-8H280c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8z"],
    "square-j": [448, 512, [], "e273", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm304 40V296c0 48.6-39.4 88-88 88s-88-39.4-88-88V280c0-4.4 3.6-8 8-8s8 3.6 8 8v16c0 39.8 32.2 72 72 72s72-32.2 72-72V136c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "hand-point-up": [384, 512, [9757], "f0a6", "M64 48c0-17.7 14.3-32 32-32s32 14.3 32 32V200v56H72c-2.7 0-5.4 .1-8 .4V48zm64 224v0h16v0h32c17.7 0 32 14.3 32 32s-14.3 32-32 32H104c-4.4 0-8 3.6-8 8s3.6 8 8 8h72c18.5 0 34.6-10.5 42.6-25.9C227.4 337 240.9 344 256 344s28.6-7 37.4-17.9c8 15.4 24.1 25.9 42.6 25.9c12.3 0 23.5-4.6 32-12.2V360c0 75.1-60.9 136-136 136H152C76.9 496 16 435.1 16 360V328c0-30.9 25.1-56 56-56h56zm16-16V200c0-17.7 14.3-32 32-32s32 14.3 32 32v31.9c0 0 0 0 0 .1v36.2c-8.5-7.6-19.7-12.2-32-12.2H144zm0-91.8V48c0-26.5-21.5-48-48-48S48 21.5 48 48V260.1C20 270 0 296.7 0 328v32c0 83.9 68.1 152 152 152h80c83.9 0 152-68.1 152-152V304 280 248c0-26.5-21.5-48-48-48c-13.8 0-26.3 5.8-35 15.2C294.2 197 276.6 184 256 184c-12.4 0-23.6 4.7-32.1 12.3C222 171.5 201.3 152 176 152c-12.3 0-23.5 4.6-32 12.2zM224 272V232c0-17.7 14.3-32 32-32c17.7 0 32 14.3 32 32v16 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-24zm144 8v24c0 17.7-14.3 32-32 32s-32-14.3-32-32v-8V248c0-17.7 14.3-32 32-32s32 14.3 32 32v32z"],
    "money-bill": [576, 512, [], "f0d6", "M64 80c-26.5 0-48 21.5-48 48V384c0 26.5 21.5 48 48 48H512c26.5 0 48-21.5 48-48V128c0-26.5-21.5-48-48-48H64zM0 128C0 92.7 28.7 64 64 64H512c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128zm536 56h-8c-39.8 0-72-32.2-72-72v-8c0-4.4 3.6-8 8-8s8 3.6 8 8v8c0 30.9 25.1 56 56 56h8c4.4 0 8 3.6 8 8s-3.6 8-8 8zM32 176c0-4.4 3.6-8 8-8h8c30.9 0 56-25.1 56-56v-8c0-4.4 3.6-8 8-8s8 3.6 8 8v8c0 39.8-32.2 72-72 72H40c-4.4 0-8-3.6-8-8zM536 328c4.4 0 8 3.6 8 8s-3.6 8-8 8h-8c-30.9 0-56 25.1-56 56v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-39.8 32.2-72 72-72h8zM32 336c0-4.4 3.6-8 8-8h8c39.8 0 72 32.2 72 72v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-30.9-25.1-56-56-56H40c-4.4 0-8-3.6-8-8zm336-80a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-176 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z"],
    "arrow-up-big-small": [576, 512, ["sort-size-up"], "f88e", "M154.3 34.3c3.1-3.1 8.2-3.1 11.3 0l104 104c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L168 59.3V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V59.3L61.7 149.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l104-104zM336 432c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V368c0-17.7-14.3-32-32-32H368c-17.7 0-32 14.3-32 32v64zm-16 0V368c0-26.5 21.5-48 48-48h64c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H368c-26.5 0-48-21.5-48-48zM336 80V208c0 17.7 14.3 32 32 32H496c17.7 0 32-14.3 32-32V80c0-17.7-14.3-32-32-32H368c-17.7 0-32 14.3-32 32zm-16 0c0-26.5 21.5-48 48-48H496c26.5 0 48 21.5 48 48V208c0 26.5-21.5 48-48 48H368c-26.5 0-48-21.5-48-48V80z"],
    "barcode-read": [576, 512, [], "f464", "M40 16C26.7 16 16 26.7 16 40V152c0 4.4-3.6 8-8 8s-8-3.6-8-8V40C0 17.9 17.9 0 40 0H152c4.4 0 8 3.6 8 8s-3.6 8-8 8H40zm96 112c4.4 0 8 3.6 8 8V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-4.4 3.6-8 8-8zm48 0c4.4 0 8 3.6 8 8V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-4.4 3.6-8 8-8zm56 8c0-4.4 3.6-8 8-8s8 3.6 8 8V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V136zm88-8c4.4 0 8 3.6 8 8V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-4.4 3.6-8 8-8zm40 8c0-4.4 3.6-8 8-8s8 3.6 8 8V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V136zm72-8c4.4 0 8 3.6 8 8V376c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-4.4 3.6-8 8-8zM560 40c0-13.3-10.7-24-24-24H424c-4.4 0-8-3.6-8-8s3.6-8 8-8H536c22.1 0 40 17.9 40 40V152c0 4.4-3.6 8-8 8s-8-3.6-8-8V40zM40 496H152c4.4 0 8 3.6 8 8s-3.6 8-8 8H40c-22.1 0-40-17.9-40-40V360c0-4.4 3.6-8 8-8s8 3.6 8 8V472c0 13.3 10.7 24 24 24zm520-24V360c0-4.4 3.6-8 8-8s8 3.6 8 8V472c0 22.1-17.9 40-40 40H424c-4.4 0-8-3.6-8-8s3.6-8 8-8H536c13.3 0 24-10.7 24-24z"],
    "baguette": [640, 512, [129366], "e3d8", "M605.2 65.9C570.9 14.4 501.3 .5 449.9 34.8L361.2 93.9l60.4 60.4c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L347.6 103 246 170.7l63.6 63.6c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-65.9-65.9L130.8 247.5l66.8 66.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-69.1-69.1L65.9 290.8C14.4 325.1 .5 394.7 34.8 446.1s103.8 65.4 155.3 31.1l384-256c51.5-34.3 65.4-103.8 31.1-155.3zM618.5 57c39.2 58.8 23.3 138.3-35.5 177.5l-384 256C140.2 529.7 60.7 513.8 21.5 455S-1.8 316.7 57 277.5l384-256C499.8-17.7 579.3-1.8 618.5 57z"],
    "bowl-soft-serve": [512, 512, [], "e46b", "M264 0c-3 0-5.7 1.6-7.1 4.2s-1.2 5.8 .4 8.2l10.8 16.3c2.5 3.7 3.8 8.1 3.8 12.6C272 53.8 261.8 64 249.3 64H176c-35.3 0-64 28.7-64 64c0 8.5 1.7 16.6 4.7 24H108c-42 0-76 34-76 76s34 76 76 76H404c42 0 76-34 76-76s-34-76-76-76H391.7c5.3-10.2 8.3-21.7 8.3-34C400 52.8 347.2 0 282 0H264zm17.5 19.8L278.9 16H282c56.3 0 102 45.7 102 102c0 12.7-4.1 24.4-11 34H296c-4.4 0-8 3.6-8 8s3.6 8 8 8h80.9H384h20c33.1 0 60 26.9 60 60s-26.9 60-60 60H108c-33.1 0-60-26.9-60-60s26.9-60 60-60h20 2 38c4.4 0 8-3.6 8-8s-3.6-8-8-8H134.4c-4.1-7.1-6.4-15.2-6.4-24c0-26.5 21.5-48 48-48h73.3C270.7 80 288 62.7 288 41.3c0-7.6-2.3-15.1-6.5-21.5zM64 336c0-4.4-3.6-8-8-8s-8 3.6-8 8v16c0 53 43 96 96 96h43.1l-26.2 52.4c-1.2 2.5-1.1 5.4 .4 7.8s4 3.8 6.8 3.8H344c2.8 0 5.3-1.4 6.8-3.8s1.6-5.3 .3-7.8L324.9 448H368c53 0 96-43 96-96V336c0-4.4-3.6-8-8-8s-8 3.6-8 8v16c0 44.2-35.8 80-80 80H312c-2.8 0-5.3 1.4-6.8 3.8s-1.6 5.3-.4 7.8L331.1 496H180.9l26.2-52.4c1.2-2.5 1.1-5.4-.4-7.8s-4-3.8-6.8-3.8H144c-44.2 0-80-35.8-80-80V336z"],
    "face-holding-back-tears": [512, 512, [129401], "e482", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM320.5 106.8c-1.6-4.1 .5-8.7 4.7-10.3s8.7 .5 10.3 4.7l1.2 3.1c13.3 35.5 43.6 61.8 80.6 70l8.5 1.9c4.3 1 7 5.2 6.1 9.5s-5.2 7-9.5 6.1l-7.7-1.7c10.9 13.7 17.5 31 17.5 49.9c0 44.2-35.8 80-80 80s-80-35.8-80-80s35.8-80 80-80c1.3 0 2.6 0 3.9 .1c-15-13.5-26.9-30.6-34.2-50.2l-1.2-3.1zM186.8 96.5c4.1 1.6 6.2 6.2 4.7 10.3l-1.2 3.1c-7.3 19.5-19.2 36.6-34.2 50.2c1.3-.1 2.6-.1 3.9-.1c44.2 0 80 35.8 80 80s-35.8 80-80 80s-80-35.8-80-80c0-18.9 6.5-36.2 17.5-49.9l-7.7 1.7c-4.3 1-8.6-1.8-9.5-6.1s1.8-8.6 6.1-9.5l8.5-1.9c37-8.2 67.3-34.6 80.6-70l1.2-3.1c1.6-4.1 6.2-6.2 10.3-4.7zM224 240A64 64 0 1 0 96 240a64 64 0 1 0 128 0zm128 64a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM192 240c0-12-6.6-22.4-16.3-27.9c-2 15.7-15.5 27.9-31.7 27.9c-5.7 0-11.1-1.5-15.7-4.1c-.2 1.4-.3 2.7-.3 4.1c0 17.7 14.3 32 32 32s32-14.3 32-32zm-80 0c0-6.2 1.2-12.2 3.4-17.7c2.1-5.3 5.1-10.1 8.9-14.3c1.4-1.5 2.8-3 4.4-4.3c-.4 1.4-.6 2.8-.6 4.3c0 5.2 2.5 9.9 6.4 12.8c2.7 2 6 3.2 9.6 3.2c8.8 0 16-7.2 16-16l0-.1c0-6.7-4.3-12.5-10.2-14.8c3.3-.7 6.7-1.1 10.2-1.1c4.4 0 8.6 .6 12.6 1.7C193 199.2 208 217.9 208 240c0 26.5-21.5 48-48 48s-48-21.5-48-48zm240 32c17.7 0 32-14.3 32-32c0-12-6.6-22.4-16.3-27.9c-2 15.7-15.5 27.9-31.7 27.9c-5.7 0-11.1-1.5-15.7-4.1c-.2 1.4-.3 2.7-.3 4.1c0 17.7 14.3 32 32 32zm-44.6-49.7c2.1-5.3 5.1-10.1 8.9-14.3c1.4-1.5 2.8-3 4.4-4.3c-.4 1.4-.6 2.8-.6 4.3c0 5.2 2.5 9.9 6.4 12.8c2.7 2 6 3.2 9.6 3.2c8.8 0 16-7.2 16-16c0-6.8-4.2-12.6-10.2-14.9c3.3-.7 6.7-1.1 10.2-1.1c4.4 0 8.6 .6 12.6 1.7C385 199.2 400 217.9 400 240c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-6.2 1.2-12.2 3.4-17.7zm26.1 147.1c2.5-3.6 7.5-4.5 11.1-2s4.5 7.5 2 11.1c-17 24.3-47.1 51.4-90.6 51.4s-73.5-27.1-90.6-51.4c-2.5-3.6-1.7-8.6 2-11.1s8.6-1.7 11.1 2C194 391.5 219.9 414 256 414s62-22.5 77.4-44.6z"],
    "square-up": [448, 512, [11014, "arrow-alt-square-up"], "f353", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm224 16c7.2 0 14.2 2.9 19.3 8L343 219.7c5.7 5.7 9 13.5 9 21.7c0 16.9-13.7 30.6-30.6 30.6H272v88c0 22.1-17.9 40-40 40H216c-22.1 0-40-17.9-40-40V272H126.6C109.7 272 96 258.3 96 241.4c0-8.1 3.2-15.9 9-21.7L204.7 120c5.1-5.1 12.1-8 19.3-8zm-8 19.3L116.3 231c-2.7 2.7-4.3 6.5-4.3 10.3c0 8.1 6.5 14.6 14.6 14.6H184c4.4 0 8 3.6 8 8v96c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V264c0-4.4 3.6-8 8-8h57.4c8.1 0 14.6-6.5 14.6-14.6c0-3.9-1.5-7.6-4.3-10.3L232 131.3c-2.1-2.1-5-3.3-8-3.3s-5.9 1.2-8 3.3z"],
    "train-subway-tunnel": [512, 512, ["subway-tunnel"], "e2a3", "M16 256C16 123.5 123.5 16 256 16s240 107.5 240 240V504c0 4.4 3.6 8 8 8s8-3.6 8-8V256C512 114.6 397.4 0 256 0S0 114.6 0 256V504c0 4.4 3.6 8 8 8s8-3.6 8-8V256zM192 144H320c35.3 0 64 28.7 64 64V368c0 35.3-28.7 64-64 64H192c-35.3 0-64-28.7-64-64V208c0-35.3 28.7-64 64-64zm-80 64V368c0 38.2 26.8 70.2 62.6 78.1l-52.2 52.2c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L195.3 448H316.7l61.7 61.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-52.2-52.2c35.8-7.9 62.6-39.9 62.6-78.1V208c0-44.2-35.8-80-80-80H192c-44.2 0-80 35.8-80 80zm64 176a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm176-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM248 208l0 96H192c-8.8 0-16-7.2-16-16V224c0-8.8 7.2-16 16-16h56zm16 0h56c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H264l0-96zm-72-16c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H320c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H192z"],
    "square-exclamation": [448, 512, ["exclamation-square"], "f321", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm224 32c4.4 0 8 3.6 8 8V296c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-4.4 3.6-8 8-8zM208 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "semicolon": [192, 512, [], "3b", "M48 128a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0A64 64 0 1 0 32 128a64 64 0 1 0 128 0zM144 350.4c0 8.5-2.4 16.9-6.8 24.2L69 486.2c-3.7 6.1-10.3 9.8-17.5 9.8c-12.7 0-22.4-11.5-20.1-24.1L54.8 341.1C58.6 319.6 77.3 304 99 304c24.8 0 45 20.1 45 45v1.5zm16 0V349c0-33.7-27.3-61-61-61c-29.5 0-54.8 21.2-60 50.2L15.7 469.1c-4 22.3 13.2 42.9 35.9 42.9c12.7 0 24.5-6.6 31.1-17.4L150.8 383c6-9.8 9.2-21.1 9.2-32.6z"],
    "bookmark": [384, 512, [128278, 61591], "f02e", "M0 56C0 25.1 25.1 0 56 0H328c30.9 0 56 25.1 56 56V485.8c0 14.5-11.8 26.2-26.2 26.2c-5.4 0-10.6-1.7-15.1-4.7L192 401.8 41.3 507.3c-4.4 3.1-9.7 4.7-15.1 4.7C11.8 512 0 500.2 0 485.8V56zM56 16C33.9 16 16 33.9 16 56V485.8c0 5.7 4.6 10.2 10.2 10.2c2.1 0 4.2-.6 5.9-1.9L187.4 385.4c2.8-1.9 6.4-1.9 9.2 0L351.9 494.1c1.7 1.2 3.8 1.9 5.9 1.9c5.7 0 10.2-4.6 10.2-10.2V56c0-22.1-17.9-40-40-40H56z"],
    "fan-table": [448, 512, [], "e004", "M432 224A208 208 0 1 0 16 224a208 208 0 1 0 416 0zm16 0c0 121-96 219.6-216 223.9V496H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H224 72c-4.4 0-8-3.6-8-8s3.6-8 8-8H216V447.9C96 443.6 0 345 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224zM192.3 81.5l34.5 85.3c20.6-21 50.5-32.2 81.9-27.8c52.5 7.4 89.1 55.9 81.7 108.4c-1.8 13.1-14 22.3-27.1 20.4L272.2 255c7.9 28.3 2.7 59.9-16.8 84.8c-32.6 41.8-93 49.2-134.8 16.5l4.9-6.3-4.9 6.3c-10.4-8.2-12.3-23.2-4.1-33.7l56.6-72.5c-28.5-7.4-53.2-27.6-65-57c-19.9-49.2 3.9-105.1 53-125c12.3-5 26.3 1 31.2 13.3zm-25.2 1.6c-41 16.6-60.8 63.2-44.2 104.1c11.4 28.3 37.2 46.5 65.5 49.6c2.9 .3 5.4 2.2 6.5 4.8s.7 5.7-1.1 8L129 332.5c-2.7 3.5-2.1 8.5 1.4 11.2c34.8 27.2 85.1 21 112.3-13.8c18.8-24 21.7-55.4 10.2-81.5c-1.2-2.7-.8-5.7 .9-8s4.6-3.5 7.5-3.1L365.5 252c4.4 .6 8.4-2.4 9-6.8c6.1-43.8-24.3-84.2-68.1-90.4c-30.2-4.2-58.8 8.9-75.7 31.9c-1.7 2.3-4.6 3.6-7.4 3.2s-5.3-2.3-6.4-4.9L177.5 87.5c-1.7-4.1-6.3-6.1-10.4-4.4zM224 208a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "align-justify": [448, 512, [], "f039", "M8 56c-4.4 0-8 3.6-8 8s3.6 8 8 8H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H8zM0 192c0 4.4 3.6 8 8 8H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H8c-4.4 0-8 3.6-8 8zM8 312c-4.4 0-8 3.6-8 8s3.6 8 8 8H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H8zM8 440c-4.4 0-8 3.6-8 8s3.6 8 8 8H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H8z"],
    "battery-low": [576, 512, ["battery-1"], "e0b1", "M448 112c35.3 0 64 28.7 64 64v16 16 96 16 16c0 35.3-28.7 64-64 64H80c-35.3 0-64-28.7-64-64V176c0-35.3 28.7-64 64-64H448zm80 224V320h16c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H528V176c0-44.2-35.8-80-80-80H80C35.8 96 0 131.8 0 176V336c0 44.2 35.8 80 80 80H448c44.2 0 80-35.8 80-80zm0-32V208h16c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H528zM144 208v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V208c0-17.7 14.3-32 32-32s32 14.3 32 32zm-80 0v96c0 26.5 21.5 48 48 48s48-21.5 48-48V208c0-26.5-21.5-48-48-48s-48 21.5-48 48z"],
    "credit-card-front": [576, 512, [], "f38a", "M512 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H512zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM96 296c0 4.4 3.6 8 8 8H472c4.4 0 8-3.6 8-8s-3.6-8-8-8H104c-4.4 0-8 3.6-8 8zm0 64c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H104c-4.4 0-8 3.6-8 8zm136-8c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H232zM424 112h48c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H424c-13.3 0-24-10.7-24-24V136c0-13.3 10.7-24 24-24zm-40 24v32c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V136c0-22.1-17.9-40-40-40H424c-22.1 0-40 17.9-40 40z"],
    "brain-arrow-curved-right": [640, 512, ["mind-share"], "f677", "M200 0c-29.9 0-55 20.5-62.1 48.3C105.4 51.3 80 78.7 80 112c0 6.7 1 13.1 2.9 19.1C53.4 140.2 32 167.6 32 200c0 12.4 3.1 24.1 8.7 34.3C16.4 248 0 274.1 0 304c0 33.3 20.4 61.9 49.4 73.9c-.9 4.6-1.4 9.3-1.4 14.1c0 39.8 32.2 72 72 72c3.7 0 7.2-.3 10.8-.8C139 491.4 165.1 512 196 512c26 0 48.5-14.6 60-36c11.5 21.4 34 36 60 36c7 0 13.7-1 20-3c-3.3-4.2-6.6-8.9-9.7-14c-3.3 .7-6.7 1-10.3 1c-27.6 0-50.1-21.4-51.9-48.5c0-.3-.1-.6-.1-.9V444 64c0-26.5 21.5-48 48-48c24.2 0 44.2 17.9 47.5 41.1c.6 4 4 6.9 8 6.9l.5 0c26.5 0 48 21.5 48 48c0 7.7-1.8 14.9-5 21.3c-1.1 2.3-1.1 5 .1 7.2s3.3 3.8 5.8 4.2c26.7 4.3 47 27.4 47 55.3c0 12.3-4 23.6-10.7 32.9c-1.4 2-1.9 4.5-1.2 6.9s2.4 4.3 4.6 5.2c9 3.8 16.9 9.5 23.3 16.7v-5.9c0-4.9 .7-9.6 2.1-14.1c-3.4-2.7-7-5.2-10.8-7.3c5.5-10.2 8.7-21.9 8.7-34.3c0-32.4-21.4-59.8-50.9-68.9c1.9-6 2.9-12.5 2.9-19.1c0-33.3-25.4-60.7-57.9-63.7C367 20.5 341.9 0 312 0c-24.1 0-45.1 13.3-56 33C245.1 13.3 224.1 0 200 0zm48 64V444v2.6c-.1 .3-.1 .6-.1 .9C246.1 474.6 223.6 496 196 496c-25.8 0-47.3-18.8-51.3-43.5c-.4-2.2-1.7-4.2-3.6-5.4s-4.2-1.6-6.4-1c-4.7 1.3-9.6 1.9-14.7 1.9c-30.9 0-56-25.1-56-56c0-5.8 .9-11.5 2.5-16.7c.6-2 .4-4.2-.6-6.1s-2.7-3.3-4.7-3.9C35 357.2 16 332.8 16 304c0-26.6 16.2-49.4 39.3-59.1c2.3-.9 4-2.9 4.6-5.2s.2-4.9-1.2-6.9C52 223.6 48 212.3 48 200c0-27.9 20.4-51 47-55.3c2.5-.4 4.7-2 5.8-4.2s1.2-4.9 .1-7.2c-3.2-6.4-5-13.6-5-21.3c0-26.5 21.5-48 48-48l.5 0c4 0 7.4-2.9 8-6.9C155.8 33.9 175.8 16 200 16c26.5 0 48 21.5 48 48zM528 400c0-8.8-7.2-16-16-16H464c-44.2 0-80 35.8-80 80v27.1c-12.2-11.8-32-36.9-32-75.1c0-53 43-96 96-96h64c8.8 0 16-7.2 16-16V256l96 96-96 96V400zM512 256v32 16H496 448c-61.9 0-112 50.1-112 112c0 54.3 34.6 85.6 45 93.8c1.9 1.5 4.3 2.2 6.7 2.2c6.8 0 12.3-5.5 12.3-12.3V464c0-35.3 28.7-64 64-64h32 16v16 32c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l96-96c6.2-6.2 6.2-16.4 0-22.6l-96-96c-4.6-4.6-11.5-5.9-17.4-3.5s-9.9 8.3-9.9 14.8z"],
    "umbrella-beach": [576, 512, [127958], "f5ca", "M462.6 70.6c64.2 49.4 99.6 128.8 92.9 210c-.6 7-8.4 13.2-18.2 9.7l-89.1-32.4 4.1-11.4c16.1-44.3 23-91.4 20.2-138.4c-.8-13.3-4.2-25.9-9.9-37.4zM409.3 39.6c27.1 12.6 45.4 39.1 47.2 69.3c2.7 44.9-3.9 89.8-19.3 132l-4.2 11.4L235.4 180.3l4.1-11.4c15.4-42.2 39.2-80.8 70.1-113.5c21.8-23.1 55-31.4 85-21.5c1.2 .4 2.4 .9 3.6 1.3c3.7 1.4 7.4 2.8 11 4.3zM331.8 21.3c-12.5 5.2-24.1 13-33.7 23.2c-32.4 34.2-57.4 74.7-73.5 119l-4.1 11.4L128 141.2c-9.8-3.6-11.8-13.4-7.7-19.1c48.1-68 128.6-106.3 211.5-100.9zm68-2.4c-109.8-38-228.4 3.2-292.6 94c-11.1 15.7-2.8 36.8 15.3 43.4l92.4 33.6 0 0 15 5.5 197.7 71.9 15 5.5 0 0 89.1 32.4c18.1 6.6 38-4.2 39.6-23.4c9-108.1-52-213.2-155.6-256.9c-2.4-1.1-4.9-2.1-7.4-3l-5.9-2.1c-.9-.3-1.8-.6-2.7-.9zM8 496c-4.4 0-8 3.6-8 8s3.6 8 8 8H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H239.1l84.6-232.4-15-5.5-84.8 233-1.8 4.9H8z"],
    "helmet-un": [512, 512, [], "e503", "M16 240v72c0 30.9 25.1 56 56 56H218.2l30.2-90.5c1.1-3.3 4.1-5.5 7.6-5.5H464V240C464 116.3 363.7 16 240 16S16 116.3 16 240zm464 0v32h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H472 368V496H472c4.4 0 8 3.6 8 8s-3.6 8-8 8H360c-2 0-4-.8-5.5-2.2L220.8 384H72c-39.8 0-72-32.2-72-72V240C0 107.5 107.5 0 240 0S480 107.5 480 240zM261.8 288l-28.6 85.7L352 485.5V288H261.8zm8.7-188.6L336 191V104c0-4.4 3.6-8 8-8s8 3.6 8 8V216c0 3.5-2.2 6.6-5.6 7.6s-6.9-.1-9-3L272 129v87c0 4.4-3.6 8-8 8s-8-3.6-8-8V104c0-3.5 2.2-6.6 5.6-7.6s6.9 .1 9 3zM144 104v72c0 17.7 14.3 32 32 32s32-14.3 32-32V104c0-4.4 3.6-8 8-8s8 3.6 8 8v72c0 26.5-21.5 48-48 48s-48-21.5-48-48V104c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "location-smile": [384, 512, ["map-marker-smile"], "f60d", "M368 192c0-97.2-78.8-176-176-176S16 94.8 16 192c0 18.7 6.4 42.5 17.8 69.6c11.3 26.9 27.1 55.8 44.7 84.3c35.2 57 76.8 111.4 102.3 143.2c5.9 7.3 16.6 7.3 22.4 0c25.5-31.8 67.1-86.2 102.3-143.2c17.6-28.5 33.4-57.4 44.7-84.3C361.6 234.5 368 210.7 368 192zm16 0c0 87.4-117 243-168.3 307.2c-12.3 15.3-35.1 15.3-47.4 0C117 435 0 279.4 0 192C0 86 86 0 192 0S384 86 384 192zM128 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm112 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM102.7 259.6C112.3 274 144.2 304 192 304s79.7-30 89.3-44.4c2.5-3.7 7.4-4.7 11.1-2.2s4.7 7.4 2.2 11.1C282.9 286 246.6 320 192 320s-90.9-34-102.7-51.6c-2.5-3.7-1.5-8.6 2.2-11.1s8.6-1.5 11.1 2.2z"],
    "arrow-left-to-line": [448, 512, [8676, "arrow-to-left"], "f33e", "M0 440c0 4.4 3.6 8 8 8s8-3.6 8-8L16 72c0-4.4-3.6-8-8-8s-8 3.6-8 8L0 440zM98.3 250.3c-3.1 3.1-3.1 8.2 0 11.3l136 136c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L123.3 264 440 264c4.4 0 8-3.6 8-8s-3.6-8-8-8l-316.7 0L245.7 125.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-136 136z"],
    "bullseye": [512, 512, [], "f140", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-408a152 152 0 1 1 0 304 152 152 0 1 1 0-304zm0 320a168 168 0 1 0 0-336 168 168 0 1 0 0 336zM200 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm128 0a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"],
    "sushi": [576, 512, [127843, "nigiri"], "e48a", "M328.2 64h38.7c93.2 0 172.9 66.9 189.1 158.6l6 34.1c6.3 35.8-27.9 65.4-62.4 53.9L323.1 252c-26.7-8.9-55.6-8.7-82.3 .5L77.2 309.3c-34.6 12-69.4-17.6-63-53.7L20 222.6C36.2 130.9 115.9 64 209.1 64H327.8c.1 0 .3 0 .4 0zM271.1 195.8c-2.1 3.9-6.9 5.4-10.8 3.3s-5.4-6.9-3.3-10.8L314.7 80H209.1c-1.6 0-3.1 0-4.7 .1L110.8 228.3c-2.4 3.7-7.3 4.9-11 2.5s-4.9-7.3-2.5-11l87.2-138C109.9 92.2 49.2 149.5 35.8 225.4L30 258.3c-4.2 24 18.9 43.8 42 35.8l163.7-56.7c29.9-10.4 62.5-10.6 92.5-.6l176.5 58.6c23 7.6 45.8-12.1 41.6-35.9l-6-34.1c-7.6-43.3-30.7-80.6-63-106.5L414.9 228c-2.2 3.8-7.1 5.2-10.9 3s-5.2-7.1-3-10.9l63.2-110.6C436.2 90.7 402.6 80 366.9 80H332.8L271.1 195.8zM32 352V338.3c5.1 2.1 10.5 3.6 16 4.5V352c0 44.2 35.8 80 80 80c16 0 30.8-4.7 43.3-12.7c5.3-3.4 12.1-3.4 17.4 0C201.2 427.3 216 432 232 432c17.4 0 33.5-5.6 46.7-15c5.6-4 13.1-4 18.7 0c13.1 9.4 29.2 15 46.7 15c16 0 30.8-4.7 43.3-12.7c5.3-3.4 12.1-3.4 17.4 0C417.2 427.3 432 432 448 432c44.2 0 80-35.8 80-80v-7.9c5.5-.9 10.9-2.4 16-4.5V352c0 53-43 96-96 96c-19.2 0-37-5.6-52-15.3c-15 9.7-32.8 15.3-52 15.3c-20.9 0-40.2-6.7-56-18c-15.8 11.3-35.1 18-56 18c-19.2 0-37-5.6-52-15.3c-15 9.7-32.8 15.3-52 15.3c-53 0-96-43-96-96z"],
    "message-captions": [512, 512, ["comment-alt-captions"], "e1de", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zm8 240c-4.4 0-8 3.6-8 8s3.6 8 8 8H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H72zm304 0c-4.4 0-8 3.6-8 8s3.6 8 8 8h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H376zM72 304c-4.4 0-8 3.6-8 8s3.6 8 8 8h96c4.4 0 8-3.6 8-8s-3.6-8-8-8H72zm160 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H232z"],
    "trash-list": [640, 512, [], "e2b1", "M157.4 27.3L134.4 64H281.6l-23-36.7c-4.4-7-12.1-11.3-20.4-11.3H177.7c-8.3 0-16 4.3-20.4 11.3zM115.6 64l28.2-45.2C151.1 7.1 163.9 0 177.7 0h60.5c13.8 0 26.6 7.1 33.9 18.8L300.4 64H408c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H115.6zM39.3 112c4.4-.4 8.3 2.9 8.6 7.3l28.3 340C78 480.1 95.4 496 116.2 496H299.8c20.8 0 38.1-15.9 39.9-36.7l28.3-340c.4-4.4 4.2-7.7 8.6-7.3s7.7 4.2 7.3 8.6l-28.3 340c-2.4 29-26.7 51.4-55.8 51.4H116.2c-29.1 0-53.4-22.3-55.8-51.4L32 120.7c-.4-4.4 2.9-8.3 7.3-8.6zM456 128H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H456c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 128H600c4.4 0 8 3.6 8 8s-3.6 8-8 8H456c-4.4 0-8-3.6-8-8s3.6-8 8-8zm-8 136c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H456c-4.4 0-8-3.6-8-8z"],
    "bacon": [576, 512, [129363], "f7e5", "M441.7 216c-26.1 23-45.1 49.9-67.3 82.1l-2.2 3.2C327.8 365.9 275.5 442 142.3 508.6c-12.3 6.2-27.2 3.7-36.9-6l-96-96c-7.3-7.3-10.6-17.6-9-27.8s8.1-18.9 17.3-23.5C136.1 296.2 180.9 231 223.3 169.3l2.3-3.4c21.8-31.8 44.9-64.9 77.7-93.9c33.4-29.5 75.8-53.6 135.9-70.8c11.2-3.2 23.2-.1 31.4 8.1l96 96c8 8 11.2 19.7 8.3 30.7s-11.3 19.6-22.2 22.7c-51.9 14.8-85.6 34.7-111.1 57.2zM236.5 178.3l0 0c-42.9 62.5-89.6 130.3-211.6 191.4c-4.6 2.3-7.8 6.7-8.6 11.7s.8 10.2 4.5 13.9l32.9 32.9 22.8-11.4c124-62 171.5-131.2 214.7-194l2.3-3.3c22-31.9 43.5-62.7 73.8-89.5c30.5-26.9 69.5-49.4 126.5-65.7l7.1-2.1L459.3 20.7c-4.1-4.1-10.1-5.7-15.7-4.1c-58 16.6-98.2 39.7-129.7 67.4c-31.2 27.5-53.2 59.1-75.1 90.9l0 0-2.3 3.4zM65.5 440.2l51.1 51.1-8.5 8.5 8.5-8.5c4.9 4.9 12.3 6.1 18.5 3c129.5-64.7 179.9-138.1 223.7-201.9l.1-.1 0 0 2.2-3.2 0 0c22.1-32.1 42.1-60.5 69.9-85.1c27.5-24.3 63.4-45.2 117.3-60.6c5.4-1.6 9.7-5.9 11.1-11.4s-.2-11.3-4.2-15.3L513.7 75l-15.4 4.6-.1 0 0 0c-55 15.7-91.9 37.2-120.4 62.3c-28.7 25.3-49.2 54.5-71.2 86.5l-2.3 3.3c-43.6 63.5-93.1 135.5-220.8 199.3l-18 9z"],
    "option": [640, 512, [], "e318", "M463.8 417.5c7.6 9.2 18.9 14.5 30.8 14.5H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H494.6c-16.7 0-32.5-7.5-43.2-20.3L176.2 94.5C168.6 85.3 157.3 80 145.4 80H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H145.4c16.7 0 32.5 7.5 43.2 20.3L463.8 417.5zM424 80c-4.4 0-8-3.6-8-8s3.6-8 8-8H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H424z"],
    "hand-point-down": [384, 512, [], "f0a7", "M64 464c0 17.7 14.3 32 32 32s32-14.3 32-32V312 256H72c-2.7 0-5.4-.1-8-.4V464zm64-224v0h16v0h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H104c-4.4 0-8-3.6-8-8s3.6-8 8-8h72c18.5 0 34.6 10.5 42.6 25.9C227.4 175 240.9 168 256 168s28.6 7 37.4 17.9c8-15.4 24.1-25.9 42.6-25.9c12.3 0 23.5 4.6 32 12.2V152c0-75.1-60.9-136-136-136H152C76.9 16 16 76.9 16 152v32c0 30.9 25.1 56 56 56h56zm16 16v56c0 17.7 14.3 32 32 32s32-14.3 32-32V280.1c0 0 0 0 0-.1V243.8c-8.5 7.6-19.7 12.2-32 12.2H144zm0 91.8V464c0 26.5-21.5 48-48 48s-48-21.5-48-48V251.9C20 242 0 215.3 0 184V152C0 68.1 68.1 0 152 0h80c83.9 0 152 68.1 152 152v56 24 32c0 26.5-21.5 48-48 48c-13.8 0-26.3-5.8-35-15.2C294.2 315 276.6 328 256 328c-12.4 0-23.6-4.7-32.1-12.3C222 340.5 201.3 360 176 360c-12.3 0-23.5-4.6-32-12.2zM224 240v40c0 17.7 14.3 32 32 32c17.7 0 32-14.3 32-32V264 216c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 24zm144-8V208c0-17.7-14.3-32-32-32s-32 14.3-32 32v8 48c0 17.7 14.3 32 32 32s32-14.3 32-32V232z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M229.7 2.3c-3.1-3.1-8.2-3.1-11.3 0l-136 136c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L216 27.3V344c0 4.4 3.6 8 8 8s8-3.6 8-8V27.3L354.3 149.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-136-136zM16 328c0-4.4-3.6-8-8-8s-8 3.6-8 8v96c0 48.6 39.4 88 88 88H360c48.6 0 88-39.4 88-88V328c0-4.4-3.6-8-8-8s-8 3.6-8 8v96c0 39.8-32.2 72-72 72H88c-39.8 0-72-32.2-72-72V328z"],
    "trash-plus": [448, 512, [], "e2b2", "M157.4 27.3L134.4 64H313.6l-23-36.7c-4.4-7-12.1-11.3-20.4-11.3H177.7c-8.3 0-16 4.3-20.4 11.3zM115.6 64l28.2-45.2C151.1 7.1 163.9 0 177.7 0h92.5c13.8 0 26.6 7.1 33.9 18.8L332.4 64H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H115.6zM39.3 112c4.4-.4 8.3 2.9 8.6 7.3l28.3 340C78 480.1 95.4 496 116.2 496H331.8c20.8 0 38.1-15.9 39.9-36.7l28.3-340c.4-4.4 4.2-7.7 8.6-7.3s7.7 4.2 7.3 8.6l-28.3 340c-2.4 29-26.7 51.4-55.8 51.4H116.2c-29.1 0-53.4-22.3-55.8-51.4L32 120.7c-.4-4.4 2.9-8.3 7.3-8.6zM216 384V296H128c-4.4 0-8-3.6-8-8s3.6-8 8-8h88V192c0-4.4 3.6-8 8-8s8 3.6 8 8v88h88c4.4 0 8 3.6 8 8s-3.6 8-8 8H232v88c0 4.4-3.6 8-8 8s-8-3.6-8-8z"],
    "objects-align-top": [512, 512, [], "e3c0", "M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8l496 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L8 0zM176 112c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32H112c-17.7 0-32-14.3-32-32l0-320c0-17.7 14.3-32 32-32l64 0zM112 96c-26.5 0-48 21.5-48 48l0 320c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48l-64 0zm288 16c17.7 0 32 14.3 32 32l0 192c0 17.7-14.3 32-32 32H336c-17.7 0-32-14.3-32-32l0-192c0-17.7 14.3-32 32-32l64 0zM336 96c-26.5 0-48 21.5-48 48l0 192c0 26.5 21.5 48 48 48h64c26.5 0 48-21.5 48-48l0-192c0-26.5-21.5-48-48-48l-64 0z"],
    "folder": [512, 512, [128193, 128447, 61716, "folder-blank"], "f07b", "M64 464H448c26.5 0 48-21.5 48-48V160c0-26.5-21.5-48-48-48H301.3c-12.7 0-24.9-5.1-33.9-14.1L231.4 62.1c-9-9-21.2-14.1-33.9-14.1H64C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48zm384 16H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H197.5c17 0 33.3 6.7 45.3 18.7l35.9 35.9c6 6 14.1 9.4 22.6 9.4H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64z"],
    "face-anxious-sweat": [576, 512, [], "e36a", "M288 16C166 16 65.2 107.1 50 225c-.6 4.4-4.6 7.5-9 6.9s-7.5-4.6-6.9-9C50.3 97.2 157.8 0 288 0C429.4 0 544 114.6 544 256s-114.6 256-256 256c-70.4 0-134.1-28.4-180.4-74.3c-3.1-3.1-3.2-8.2 0-11.3s8.2-3.2 11.3 0C162.3 469.4 222 496 288 496c132.5 0 240-107.5 240-240S420.5 16 288 16zM197.7 162.3c3.1 3.1 3.1 8.2 0 11.3l-7.4 7.4c-22.4 22.4-51.2 37.2-82.5 42.5l-2.5 .4c-4.4 .7-8.5-2.2-9.2-6.6s2.2-8.5 6.6-9.2l2.5-.4c28-4.7 53.8-17.9 73.8-38l7.4-7.4c3.1-3.1 8.2-3.1 11.3 0zm180.7 11.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l7.4 7.4c20 20 45.8 33.3 73.8 38l2.5 .4c4.4 .7 7.3 4.8 6.6 9.2s-4.8 7.3-9.2 6.6l-2.5-.4c-31.3-5.2-60.1-20.1-82.5-42.5l-7.4-7.4zM64 275.1c-8.4 10.7-19.7 25.7-29.3 40.9c-5.6 8.9-10.5 17.5-13.9 25.1c-3.6 8-4.8 13.3-4.8 16.1C16 379.6 36.2 400 64 400s48-20.4 48-42.7c0-2.8-1.2-8.2-4.8-16.2c-3.4-7.6-8.2-16.2-13.9-25.1c-9.6-15.2-20.9-30.3-29.3-40.9zm-8.5-15c4.3-5.5 12.8-5.5 17.1 0c17.6 21.7 55.5 72.2 55.5 97.2c0 32.5-28.7 58.7-64 58.7s-64-26.2-64-58.7c0-25 38.1-75.5 55.5-97.2zM367.6 256a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-144 16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm60.2 48h8.4c46.3 0 83.8 37.5 83.8 83.8c0 6.7-5.5 12.2-12.2 12.2H212.2c-6.7 0-12.2-5.5-12.2-12.2c0-46.3 37.5-83.8 83.8-83.8zm76.1 80c-2-35.7-31.5-64-67.7-64h-8.4c-36.2 0-65.7 28.3-67.7 64H359.9z"],
    "credit-card-blank": [576, 512, [], "f389", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H512c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H512c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM96 360c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H104c-4.4 0-8-3.6-8-8zm128 0c0-4.4 3.6-8 8-8H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H232c-4.4 0-8-3.6-8-8z"],
    "file-waveform": [448, 512, ["file-medical-alt"], "f478", "M432 496H80V336H64V496v16H80 432h16V496 160L288 0H80 64V16 256H80V16H272V168v8h8H432V496zm-6.6-336H288V22.6L425.4 160zM263.2 228.4c-1.4-2.8-4.2-4.5-7.3-4.4s-5.9 1.9-7.1 4.7L190.9 358.7l-40.1-66.8c-1.4-2.4-4-3.9-6.9-3.9H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H139.5l45.7 76.1c1.5 2.6 4.4 4.1 7.3 3.9s5.6-2 6.8-4.7l57.1-128.5 24.4 48.8c1.4 2.7 4.1 4.4 7.2 4.4h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H292.9l-29.8-59.6z"],
    "microchip-ai": [512, 512, [], "e1ec", "M160 0c4.4 0 8 3.6 8 8V64h80V8c0-4.4 3.6-8 8-8s8 3.6 8 8V64h80V8c0-4.4 3.6-8 8-8s8 3.6 8 8V64h24c35.3 0 64 28.7 64 64v24h56c4.4 0 8 3.6 8 8s-3.6 8-8 8H448v80h56c4.4 0 8 3.6 8 8s-3.6 8-8 8H448v80h56c4.4 0 8 3.6 8 8s-3.6 8-8 8H448v24c0 35.3-28.7 64-64 64H360v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V448H264v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V448H168v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V448H128c-35.3 0-64-28.7-64-64V360H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H64V264H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H64V168H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H64V128c0-35.3 28.7-64 64-64h24V8c0-4.4 3.6-8 8-8zm0 80H128c-26.5 0-48 21.5-48 48v32 96 96 32c0 26.5 21.5 48 48 48h32 96 96 32c26.5 0 48-21.5 48-48V352 256 160 128c0-26.5-21.5-48-48-48H352 256 160zm55.3 100.8l64 144c1.8 4 0 8.8-4.1 10.6s-8.8 0-10.6-4.1L252.6 304H163.4l-12.1 27.2c-1.8 4-6.5 5.9-10.6 4.1s-5.9-6.5-4.1-10.6l64-144c1.3-2.9 4.1-4.8 7.3-4.8s6 1.9 7.3 4.8zM208 203.7L170.5 288h74.9L208 203.7zM344 184V328c0 4.4-3.6 8-8 8s-8-3.6-8-8V184c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "mug": [576, 512, [], "f874", "M64 80c-8.8 0-16 7.2-16 16V352c0 44.2 35.8 80 80 80H320c44.2 0 80-35.8 80-80V288 272 80H368 64zM416 288v64c0 53-43 96-96 96H128c-53 0-96-43-96-96V96c0-17.7 14.3-32 32-32H368h32 16 48c61.9 0 112 50.1 112 112s-50.1 112-112 112H416zm0-16h48c53 0 96-43 96-96s-43-96-96-96H416V272z"],
    "plane-up-slash": [640, 512, [], "e22e", "M368 385.6V400c0 2.5 1.2 4.9 3.2 6.4l57.6 43.2c2 1.5 3.2 3.9 3.2 6.4v34.1c0 3.3-2.6 5.9-5.9 5.9c-.6 0-1.2-.1-1.7-.3l-2.4 7.6 2.4-7.6-102-31.4c-1.5-.5-3.2-.5-4.7 0l-102 31.4c-.6 .2-1.1 .3-1.7 .3c-3.3 0-5.9-2.6-5.9-5.9V456c0-2.5 1.2-4.9 3.2-6.4l57.6-43.2c2-1.5 3.2-3.9 3.2-6.4V323c0-2.5-1.2-4.9-3.2-6.4s-4.6-2-7-1.3L90.1 362.7C85 364.1 80 360.3 80 355V306.9c0-8.7 4.8-16.8 12.4-21l87.8-48.5-13.6-10.8-82 45.2c-12.8 7-20.7 20.5-20.7 35V355c0 15.9 15.1 27.4 30.4 23.1L256 333.5V396l-54.4 40.8c-6 4.5-9.6 11.6-9.6 19.2v34.1c0 12.1 9.8 21.9 21.9 21.9c2.2 0 4.4-.3 6.4-1L320 480.4 419.6 511c2.1 .6 4.3 1 6.4 1c12.1 0 21.9-9.8 21.9-21.9V456c0-2.9-.5-5.8-1.5-8.4l-78.5-62zM256 89.2v24.6l16 12.6V89.2c0-13 5.7-31.9 15.3-47.5C297.2 25.6 309.1 16 320 16c11.3 0 23.2 9.6 33 25.6c9.5 15.6 15 34.5 15 47.5v92.9c0 2.9 1.6 5.6 4.1 7l175.5 96.8c7.7 4.2 12.4 12.3 12.4 21v46.8l13.9 11c1.3-3 2.1-6.3 2.1-9.8V306.9c0-14.6-7.9-28-20.7-35L384 177.3V89.2c0-16.6-6.7-38.3-17.3-55.8C356.2 16.2 340.2 0 320 0c-19.8 0-35.8 16.2-46.3 33.3C263 50.8 256 72.6 256 89.2zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "radiation": [512, 512, [], "f7b9", "M192.4 184c-15.3 13.6-26.3 32-30.6 52.9c-.2 1.2-.8 2.2-1.4 2.7c-.3 .2-.4 .3-.5 .3l0 0L32 240c-9.5 0-15-7.3-14.2-14C26 160.4 60.7 102.9 111 64.7c5.3-4 14.4-2.9 19.1 5.3l64 110.9 0 0c0 .1 0 .3-.1 .6c-.2 .8-.7 1.8-1.6 2.6zm33 163c9.6 3.2 19.9 5 30.5 5s20.9-1.7 30.5-5c1.2-.4 2.3-.4 3.1-.1c.3 .1 .5 .2 .5 .2l0 0 64 110.9c4.7 8.2 1.2 16.6-5 19.2C320.6 489.3 289.1 496 256 496s-64.6-6.7-93.2-18.8c-6.1-2.6-9.7-11-5-19.2l64-110.9 0 0c0 0 .2-.1 .5-.2c.7-.2 1.9-.3 3.1 .1zM480 240l-128 0 0 0c0 0-.2-.1-.5-.3c-.6-.5-1.2-1.5-1.4-2.7c-4.2-20.9-15.2-39.3-30.6-52.9c-.9-.8-1.5-1.8-1.6-2.6c-.1-.3-.1-.5-.1-.6l0 0L381.9 70c4.7-8.2 13.8-9.3 19.1-5.3c50.3 38.2 85 95.6 93.2 161.3c.8 6.7-4.7 14-14.2 14zM160 256c8.8 0 15.8-7.2 17.6-15.9c3.5-17.4 12.7-32.8 25.5-44.1c6.6-5.8 9.4-15.5 5-23.2L144 62c-8.8-15.3-28.6-20.7-42.7-10C47.8 92.7 10.7 154 2 224.1C-.2 241.6 14.3 256 32 256l128 0zm48 83.2L144 450.1c-8.8 15.3-3.7 35.1 12.6 41.9c30.6 12.9 64.2 20 99.4 20s68.9-7.1 99.4-20c16.3-6.9 21.4-26.6 12.6-41.9L304 339.2c-4.4-7.7-14.2-10.1-22.6-7.3c-8 2.7-16.5 4.1-25.4 4.1s-17.4-1.4-25.4-4.1c-8.4-2.8-18.2-.4-22.6 7.3zm126.4-99.1c1.7 8.7 8.7 15.9 17.6 15.9l128 0c17.7 0 32.2-14.4 30-31.9C501.3 154 464.2 92.7 410.7 52c-14.1-10.7-33.8-5.3-42.7 10L304 172.9c-4.4 7.6-1.7 17.3 5 23.2c12.8 11.3 22 26.7 25.5 44.1zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "pen-circle": [512, 512, [], "e20e", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM132.7 379.2c-4-4-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9L307.4 133.5c15.6-15.6 40.9-15.6 56.6 0l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6L222.9 359.9c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2zM367 193.1c9.4-9.4 9.4-24.6 0-33.9l-14.4-14.4c-9.4-9.4-24.6-9.4-33.9 0l-25.3 25.3 48.3 48.3L367 193.1zM211.6 348.6L330.4 229.7l-48.3-48.3L163.2 300.3c-2.1 2.1-3.5 4.6-4.2 7.4l-10.6 42.5L144 367.9l17.6-4.4 42.5-10.6c2.8-.7 5.4-2.2 7.4-4.2z"],
    "bag-seedling": [512, 512, [], "e5f2", "M76.5 80l0 .1L60.9 142.4C52.3 176.6 48 211.8 48 247.2v17.7c0 35.3 4.3 70.5 12.9 104.8l15.6 62.3 0 .1h359l0-.1 15.6-62.3c8.6-34.3 12.9-69.5 12.9-104.8V247.2c0-35.3-4.3-70.5-12.9-104.8L435.5 80.1l0-.1H76.5zM440.3 64L461 38.1c1.9-2.4 3-5.4 3-8.5c0-7.5-6.1-13.6-13.6-13.6H61.6C54.1 16 48 22.1 48 29.6c0 3.1 1.1 6.1 3 8.5L71.7 64H440.3zM71.7 448L51 473.9l-12.4-9.9L51 473.9c-1.9 2.4-3 5.4-3 8.5c0 7.5 6.1 13.6 13.6 13.6H450.4c7.5 0 13.6-6.1 13.6-13.6c0-3.1-1.1-6.1-3-8.5L440.3 448H71.7zM480 29.6c0 6.7-2.3 13.2-6.5 18.5L451 76.2l15.6 62.3c8.9 35.5 13.4 72 13.4 108.7v17.7c0 36.6-4.5 73.1-13.4 108.7L451 435.8l22.5 28.1c4.2 5.3 6.5 11.8 6.5 18.5c0 16.4-13.3 29.6-29.6 29.6H61.6C45.3 512 32 498.7 32 482.4c0-6.7 2.3-13.2 6.5-18.5L61 435.8 45.4 373.5C36.5 338 32 301.5 32 264.8V247.2c0-36.6 4.5-73.1 13.4-108.7L61 76.2 38.5 48.1C34.3 42.9 32 36.3 32 29.6C32 13.3 45.3 0 61.6 0H450.4C466.7 0 480 13.3 480 29.6zM151.1 176c-3.9 0-7.1 3.2-7.1 7.2C144 240.7 190.6 288 248 288V230.9c-12.5-31.5-43-54.9-80.7-54.9H151.1zM264 230.9V288c57.4 0 104-47.3 104-104.8c0-4-3.3-7.2-7.1-7.2H344.7c-37.7 0-68.2 23.4-80.7 54.9zM248 304c-66.3 0-120-54.6-120-120.8c0-12.7 10.3-23.2 23.1-23.2h16.2c38.8 0 71.2 21 88.7 50.9C273.5 181 305.9 160 344.7 160h16.2c12.8 0 23.1 10.5 23.1 23.2C384 249.4 330.3 304 264 304v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V304z"],
    "chart-simple": [448, 512, [], "e473", "M240 48c17.7 0 32 14.3 32 32V432c0 17.7-14.3 32-32 32H208c-17.7 0-32-14.3-32-32V80c0-17.7 14.3-32 32-32h32zM208 32c-26.5 0-48 21.5-48 48V432c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H208zM80 240c17.7 0 32 14.3 32 32V432c0 17.7-14.3 32-32 32H48c-17.7 0-32-14.3-32-32V272c0-17.7 14.3-32 32-32H80zM48 224c-26.5 0-48 21.5-48 48V432c0 26.5 21.5 48 48 48H80c26.5 0 48-21.5 48-48V272c0-26.5-21.5-48-48-48H48zM368 112h32c17.7 0 32 14.3 32 32V432c0 17.7-14.3 32-32 32H368c-17.7 0-32-14.3-32-32V144c0-17.7 14.3-32 32-32zm-48 32V432c0 26.5 21.5 48 48 48h32c26.5 0 48-21.5 48-48V144c0-26.5-21.5-48-48-48H368c-26.5 0-48 21.5-48 48z"],
    "crutches": [640, 512, [], "f7f8", "M203.3 20.7c6.2 6.2 6.2 16.4 0 22.6l-160 160c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l160-160c6.2-6.2 16.4-6.2 22.6 0zM214.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3zm12.3 78.2L215.6 98.9l70.5 70.5 11.3-11.3L226.9 87.6zM406.1 394.8l-1.2 .3-18.1 3.6c1.9 1.4 3.7 3 5.3 4.7l98.3 98.3 8 8c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-8-8-95.6-95.6zM216 332.6l-117-117L87.6 226.9l117 117c4.8 4.8 10.3 8.9 16.1 12.1l3.3-16.7c-2.9-2-5.7-4.2-8.2-6.8zm243.4-312l160 160c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-160-160c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zM470.6 9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160zM413.1 87.6l-82.7 82.7-.1 .1-.1 .1L296 204.6c-10.1 10.1-16.9 22.9-19.7 36.8L252 363.4c-2.2 10.8-7.5 20.8-15.3 28.6l-98.3 98.3-8 8c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l8-8L248 403.4c7.8-7.8 17.8-13.1 28.6-15.3l122-24.4c13.9-2.8 26.7-9.6 36.8-19.7l34.3-34.3 82.7-82.7-11.3-11.3L464 292.7 347.3 176l77.1-77.1L413.1 87.6zM307.4 216L336 187.3 452.7 304 424 332.6c-7.8 7.8-17.8 13.1-28.6 15.3l-122 24.4c-2.6 .5-5.3 1.2-7.8 2c.8-2.6 1.5-5.2 2-7.8l24.4-122c2.2-10.8 7.5-20.8 15.3-28.6z"],
    "circle-parking": [512, 512, ["parking-circle"], "f615", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM192 128h96c48.6 0 88 39.4 88 88s-39.4 88-88 88H192v72c0 4.4-3.6 8-8 8s-8-3.6-8-8V296 144c0-8.8 7.2-16 16-16zm96 160c39.8 0 72-32.2 72-72s-32.2-72-72-72H192V288h96z"],
    "mars-stroke": [512, 512, [9894], "f229", "M376 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H484.7L392 108.7 349.7 66.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L380.7 120l-50.3 50.3c-1.4 1.4-2.1 3.1-2.3 4.9C296.6 145.9 254.4 128 208 128c-97.2 0-176 78.8-176 176s78.8 176 176 176s176-78.8 176-176c0-46.4-17.9-88.6-47.3-120c1.8-.2 3.6-.9 4.9-2.3L392 131.3l42.3 42.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L403.3 120 496 27.3V136c0 4.4 3.6 8 8 8s8-3.6 8-8V8c0-4.4-3.6-8-8-8H376zM48 304a160 160 0 1 1 320 0A160 160 0 1 1 48 304z"],
    "leaf-oak": [512, 512, [], "f6f7", "M309.3 0c-29.6 0-55 21.3-60 50.5L245.6 72 221.3 53.7C200.4 38 171 40 152.5 58.5c-11.7 11.7-17.2 28.2-14.9 44.6l8.8 61.3C124.9 153 98 157.6 81.6 176.3L75 183.8c-17.3 19.7-20.9 47.9-9.2 71.3l12.7 25.4c8.3 16.7 12.7 35 12.7 53.7v75.3L2.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l88.8-88.8h75.3c18.6 0 37 4.3 53.7 12.7l25.4 12.7c23.4 11.7 51.6 8.1 71.3-9.2l7.6-6.6c18.7-16.4 23.3-43.3 11.8-64.7l61.3 8.8c16.4 2.3 32.9-3.2 44.6-14.9c18.5-18.5 20.6-47.9 4.8-68.8L440 266.4l21.5-3.7c29.2-5 50.5-30.4 50.5-60c0-20.4-10.2-39.4-27.1-50.7l-10.5-7c-2.7-1.8-4.1-5.2-3.4-8.4l5.5-25.2c4.7-21.2-1.8-43.4-17.2-58.8s-37.5-21.9-58.8-17.2L375.3 41c-3.2 .7-6.5-.6-8.4-3.4l-7-10.5C348.6 10.2 329.6 0 309.3 0zM118.5 404.8L317.7 205.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L107.2 393.5V334.2c0-21.1-4.9-41.9-14.4-60.8L80.1 247.9c-8.8-17.6-6.1-38.8 6.9-53.6l6.6-7.6c12.2-13.9 32.8-16.6 48.2-6.4c9.8 6.5 22.7-1.6 21-13.3l-9.5-66.3c-1.6-11.4 2.2-22.9 10.4-31.1c12.9-12.9 33.3-14.3 47.9-3.3l24.2 18.3c9.6 7.2 23.4 1.7 25.4-10.1L265 53.3C268.7 31.7 287.4 16 309.3 16c15 0 29 7.5 37.4 20l7 10.5c5.5 8.2 15.4 12.2 25.1 10.1l25.2-5.5c15.9-3.5 32.5 1.4 44 12.9s16.4 28.1 12.9 44l-5.5 25.2c-2.1 9.7 1.9 19.6 10.1 25.1l10.5 7c12.5 8.3 20 22.3 20 37.4c0 21.8-15.7 40.5-37.3 44.2l-21.5 3.7c-11.8 2-17.3 15.8-10.1 25.4l18.3 24.2c11 14.6 9.6 35-3.3 47.9c-8.1 8.1-19.6 12-31.1 10.3l-66.3-9.5c-11.7-1.7-19.8 11.2-13.3 21c10.3 15.4 7.5 36-6.4 48.2l-7.6 6.6c-14.8 13-36 15.7-53.6 6.9l-25.4-12.7c-18.9-9.4-39.7-14.4-60.8-14.4H118.5z"],
    "square-bolt": [448, 512, [], "e265", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM235.6 232.8L288 128 128 256h70.1c5.5 0 10.7 2.9 13.6 7.6s3.2 10.6 .7 15.6L160 384 320 256H249.9c-5.5 0-10.7-2.9-13.6-7.6s-3.2-10.6-.7-15.6zm66.7-97.7L257.9 224l-8 16h17.9H320c6.8 0 12.9 4.3 15.1 10.7s.2 13.5-5.1 17.8l-160 128c-5.9 4.7-14.2 4.7-20.1-.1s-7.6-12.9-4.3-19.6L190.1 288l8-16H180.2 128c-6.8 0-12.8-4.3-15.1-10.7s-.2-13.5 5.1-17.8l160-128c5.9-4.7 14.2-4.7 20.1 .1s7.6 12.9 4.3 19.6z"],
    "vial": [512, 512, [129514], "f492", "M322.3 2.3c3.1-3.1 8.2-3.1 11.3 0l24 24 128 128 24 24c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L480 171.3l-98.3 98.3L168.2 483.1C149.7 501.6 124.6 512 98.5 512C44.1 512 0 467.9 0 413.5c0-26.1 10.4-51.2 28.9-69.7l85.5-85.5L340.7 32 322.3 13.7c-3.1-3.1-3.1-8.2 0-11.3zm29.7 41L139.3 256H372.7l96-96L352 43.3zM356.7 272H123.3L40.2 355.1C24.7 370.6 16 391.6 16 413.5C16 459.1 52.9 496 98.5 496c21.9 0 42.9-8.7 58.3-24.2L356.7 272z"],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112c35.3 0 64-28.7 64-64c0-32.6-24.4-59.6-56-63.5V80c0-4.4-3.6-8-8-8s-8 3.6-8 8V288.5c-31.6 3.9-56 30.9-56 63.5c0 35.3 28.7 64 64 64zM144 144a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-32 96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm304 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM384 128a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "wand-magic-sparkles": [576, 512, ["magic-wand-sparkles"], "e2ca", "M455 23.6c9.4-9.4 24.6-9.4 33.9 0L520.4 55c9.4 9.4 9.4 24.6 0 33.9L390.3 219.1c-.2-.3-.4-.5-.6-.7l-64-64c-.2-.2-.5-.4-.7-.6L455 23.6zM55.6 423L313.7 164.9c.2 .3 .4 .5 .6 .7l64 64c.2 .2 .5 .4 .7 .6L121 488.4c-9.4 9.4-24.6 9.4-33.9 0L55.6 457c-9.4-9.4-9.4-24.6 0-33.9zM443.7 12.3L44.3 411.7c-15.6 15.6-15.6 40.9 0 56.6l31.4 31.4c15.6 15.6 40.9 15.6 56.6 0L531.7 100.3c15.6-15.6 15.6-40.9 0-56.6L500.3 12.3c-15.6-15.6-40.9-15.6-56.6 0zM104 64c0-4.4-3.6-8-8-8s-8 3.6-8 8v56H32c-4.4 0-8 3.6-8 8s3.6 8 8 8H88v56c0 4.4 3.6 8 8 8s8-3.6 8-8V136h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H104V64zM480 312c-4.4 0-8 3.6-8 8v56H416c-4.4 0-8 3.6-8 8s3.6 8 8 8h56v56c0 4.4 3.6 8 8 8s8-3.6 8-8V392h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H488V320c0-4.4-3.6-8-8-8zM232 32c0-4.4-3.6-8-8-8s-8 3.6-8 8V56H192c-4.4 0-8 3.6-8 8s3.6 8 8 8h24V96c0 4.4 3.6 8 8 8s8-3.6 8-8V72h24c4.4 0 8-3.6 8-8s-3.6-8-8-8H232V32z"],
    "lambda": [448, 512, [], "f66e", "M8 32c-4.4 0-8 3.6-8 8s3.6 8 8 8H131.9c9.2 0 17.6 5.3 21.6 13.6l21.1 43.9L16.7 468.8c-1.8 4.1 .1 8.8 4.1 10.5s8.8-.1 10.5-4.1L183.8 124.5 344.1 457.4c6.7 13.8 20.7 22.6 36 22.6H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H380.1c-9.2 0-17.6-5.3-21.6-13.6L167.9 54.6c-6.7-13.8-20.7-22.6-36-22.6H8z"],
    "e": [320, 512, [101], "45", "M32 32C14.3 32 0 46.3 0 64V256 448c0 17.7 14.3 32 32 32H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H32c-8.8 0-16-7.2-16-16V256H248c4.4 0 8-3.6 8-8s-3.6-8-8-8H16V64c0-8.8 7.2-16 16-16H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H32z"],
    "pizza": [576, 512, [127829], "f817", "M256 278.6c-12.5-12.5-12.5-32.8 0-45.3L368.6 120.7C338.1 95.3 298.8 80 256 80C158.8 80 80 158.8 80 256s78.8 176 176 176c42.8 0 82.1-15.3 112.6-40.7L256 278.6zm11.3-11.3L380.5 380.5l11.3 11.3 33.9 33.9c6.2 6.2 6.3 16.4-.3 22.3c-45.1 39.8-104.4 64-169.4 64C114.6 512 0 397.4 0 256S114.6 0 256 0c64.9 0 124.2 24.2 169.4 64c6.6 5.8 6.6 16 .3 22.3l-33.9 33.9-11.3 11.3L267.3 244.7c-6.2 6.2-6.2 16.4 0 22.6zM414 436.6l-34-34C346.5 430.9 303.3 448 256 448C150 448 64 362 64 256S150 64 256 64c47.3 0 90.5 17.1 124 45.4l34-34C371.8 38.4 316.5 16 256 16C123.5 16 16 123.5 16 256s107.5 240 240 240c60.5 0 115.8-22.4 158-59.4zM560 256c0-60.5-22.4-115.8-59.4-158l-34 34c28.3 33.5 45.4 76.7 45.4 124s-17.1 90.5-45.4 124l34 34c37-42.2 59.4-97.5 59.4-158zM455.3 143.4L342.6 256 455.3 368.6C480.7 338.1 496 298.8 496 256s-15.3-82.1-40.7-112.6zm34.5 282.3l-33.9-33.9-11.3-11.3L331.3 267.3c-6.2-6.2-6.2-16.4 0-22.6L489.7 86.3C496 80 506.1 80 512 86.6c39.8 45.1 64 104.4 64 169.4s-24.2 124.2-64 169.4c-5.8 6.6-16 6.6-22.3 .3zM144 256a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM208 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM448 240a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", "M505.6 15.8c4.3-.9 7.1-5.1 6.2-9.5s-5.1-7.1-9.5-6.2L192 65.2V81.6L505.6 15.8zM192 140.1v16L504.5 136c4.4-.3 7.8-4.1 7.5-8.5s-4.1-7.8-8.5-7.5L192 140.1zM160 224h0V31.8c-.1-4.3-3.6-7.8-8-7.8c-4.4 0-8 3.6-8 8V75.3l0 0V91.7l0 0v51.6l0 0v16l0 0V224H112v0h0V47.8c-.1-4.3-3.6-7.8-8-7.8c-4.4 0-8 3.6-8 8V85.4L6.4 104.2c-4.3 .9-7.1 5.1-6.2 9.5s5.1 7.1 9.5 6.2L96 101.7v44.6L7.5 152c-4.4 .3-7.8 4.1-7.5 8.5s4.1 7.8 8.5 7.5L96 162.3V224H33.9C15.5 224 .9 239.5 2 257.9l1.6 27.3c4.9 83.3 54.8 153.7 125.3 188.2c4.3 22.1 23.8 38.7 47.1 38.7H336c23.3 0 42.8-16.6 47.1-38.7c70.5-34.5 120.4-104.9 125.3-188.2l1.6-27.3c1.1-18.4-13.5-33.9-31.9-33.9H160v0zM144.6 470.2c-1-4.9-4.2-9.1-8.7-11.3c-65.5-32-111.8-97.4-116.4-174.7L18 256.9c-.5-9.2 6.8-16.9 16-16.9H478.1c9.2 0 16.5 7.7 16 16.9l-1.6 27.3c-4.5 77.3-50.9 142.7-116.4 174.7c-4.5 2.2-7.7 6.4-8.7 11.3C364.5 484.9 351.5 496 336 496H176c-15.5 0-28.5-11.1-31.4-25.8z"],
    "h3": [640, 512, [], "f315", "M16 72c0-4.4-3.6-8-8-8s-8 3.6-8 8V248 440c0 4.4 3.6 8 8 8s8-3.6 8-8V256H304V440c0 4.4 3.6 8 8 8s8-3.6 8-8V248 72c0-4.4-3.6-8-8-8s-8 3.6-8 8V240H16V72zm376-8c-4.4 0-8 3.6-8 8s3.6 8 8 8H580.7L418.3 242.3c-2.3 2.3-3 5.7-1.7 8.7s4.2 4.9 7.4 4.9h96c48.6 0 88 39.4 88 88s-39.4 88-88 88H447.4c-23.5 0-43.5-17-47.3-40.1l-.2-1.2c-.7-4.4-4.8-7.3-9.2-6.6s-7.3 4.8-6.6 9.2l.2 1.2c5.1 30.9 31.8 53.5 63.1 53.5H520c57.4 0 104-46.6 104-104s-46.6-104-104-104H443.3L605.7 77.7c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9H392z"],
    "pen-clip": [512, 512, ["pen-alt"], "f305", "M374.1 30.6c18.7-18.7 49.1-18.7 67.9 0l39.4 39.4c18.7 18.7 18.7 49.1 0 67.9L427.3 192 320 84.7l54.1-54.1zM297.4 84.7L99.5 282.5c-48 48-80.8 109.2-94.1 175.8l-5 25c-1.6 7.9 .9 16 6.6 21.7s13.8 8.1 21.7 6.6l25-5c66.6-13.3 127.8-46.1 175.8-94.1L492.7 149.3c25-25 25-65.5 0-90.5L453.3 19.3c-25-25-65.5-25-90.5 0L308.7 73.4 295.6 60.3c-21.9-21.9-57.3-21.9-79.2 0L98.3 178.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L227.7 71.6c15.6-15.6 40.9-15.6 56.6 0l13.1 13.1zM308.7 96L416 203.3 218.2 401.1c-45.8 45.8-104.1 77-167.6 89.7l-25 5c-2.6 .5-5.3-.3-7.2-2.2s-2.7-4.6-2.2-7.2l5-25c12.7-63.5 43.9-121.8 89.7-167.6L308.7 96z"],
    "bridge-circle-exclamation": [640, 512, [], "e4ca", "M40 32H600c4.4 0 8 3.6 8 8s-3.6 8-8 8H520v96h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H40c-4.4 0-8-3.6-8-8s3.6-8 8-8h80V48H40c-4.4 0-8-3.6-8-8s3.6-8 8-8zM504 48H392v96H504V48zM376 48H264v96H376V48zM248 48H136v96H248V48zM40 256H64c48.6 0 88 39.4 88 88v96c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V344c0-48.6 39.4-88 88-88c12.3 0 24 2.5 34.7 7.1c-3.2 4.4-6.3 8.9-9.1 13.6c-7.9-3-16.5-4.7-25.5-4.7c-39.8 0-72 32.2-72 72v96c0 22.1-17.9 40-40 40H176c-22.1 0-40-17.9-40-40V344c0-39.8-32.2-72-72-72H40c-4.4 0-8-3.6-8-8s3.6-8 8-8zM624 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0-136c4.4 0 8 3.6 8 8v96c0 4.4-3.6 8-8 8s-8-3.6-8-8V288c0-4.4 3.6-8 8-8z"],
    "badge-percent": [512, 512, [], "f646", "M180.8 61.2C195.1 34.3 223.4 16 256 16s60.9 18.3 75.2 45.2c1.8 3.4 5.7 5 9.4 3.9c29.1-8.9 62.1-1.9 85.1 21.1s30.1 56 21.1 85.1c-1.1 3.7 .5 7.6 3.9 9.4C477.7 195.1 496 223.4 496 256s-18.3 60.9-45.2 75.2c-3.4 1.8-5 5.8-3.9 9.4c8.9 29.1 1.9 62.1-21.1 85.1s-56 30.1-85.1 21.1c-3.7-1.1-7.6 .5-9.4 3.9C316.9 477.7 288.6 496 256 496s-60.9-18.3-75.2-45.2c-1.8-3.4-5.7-5-9.4-3.9c-29.1 8.9-62.1 1.9-85.1-21.1s-30.1-56-21.1-85.1c1.1-3.7-.5-7.6-3.9-9.4C34.3 316.9 16 288.6 16 256s18.3-60.9 45.2-75.2c3.4-1.8 5-5.7 3.9-9.4c-8.9-29.1-1.9-62.1 21.1-85.1s56-30.1 85.1-21.1c3.7 1.1 7.6-.5 9.4-3.9zM256 0c-36.4 0-68.3 19.3-86.1 48.2c-33-7.9-69.2 1.1-94.9 26.8s-34.7 61.9-26.8 94.9C19.3 187.7 0 219.6 0 256s19.3 68.3 48.2 86.1c-7.9 33 1.1 69.2 26.8 94.9s61.9 34.7 94.9 26.8C187.7 492.7 219.6 512 256 512s68.3-19.3 86.1-48.2c33 7.9 69.2-1.1 94.9-26.8s34.7-61.9 26.8-94.9C492.7 324.3 512 292.4 512 256s-19.3-68.3-48.2-86.1c7.9-33-1.1-69.2-26.8-94.9s-62-34.7-94.9-26.8C324.3 19.3 292.4 0 256 0zM176 192a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm21.7-170.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-160 160c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l160-160z"],
    "user": [448, 512, [128100, 62144], "f007", "M336 128a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zM96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM16 482.3c0 7.6 6.1 13.7 13.7 13.7H418.3c7.6 0 13.7-6.1 13.7-13.7C432 392.7 359.3 320 269.7 320H178.3C88.7 320 16 392.7 16 482.3zm-16 0C0 383.8 79.8 304 178.3 304h91.4C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7H29.7C13.3 512 0 498.7 0 482.3z"],
    "sensor": [448, 512, [], "e028", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm96 8V280c0 4.4-3.6 8-8 8s-8-3.6-8-8V104c0-4.4 3.6-8 8-8s8 3.6 8 8zm64 0V280c0 4.4-3.6 8-8 8s-8-3.6-8-8V104c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "comma": [192, 512, [], "2c", "M138 374.6c5-7.4 7.6-16.3 7.6-25.3c0-24.9-20.2-45.3-45-45.3c-21.8 0-40.4 15.6-44.3 37.1L32.2 476.7c-1.8 10 5.9 19.3 16.1 19.3c5.5 0 10.6-2.7 13.6-7.3L138 374.6zm13.3 8.9L75.3 497.6c-6 9-16.1 14.4-26.9 14.4c-20.2 0-35.4-18.2-31.9-38.1L40.7 338.2c5.2-29.1 30.5-50.2 60-50.2c33.7 0 61 27.6 61 61.3c0 12.1-3.6 24.1-10.3 34.2z"],
    "school-circle-check": [640, 512, [], "e56b", "M315.4 1.4c2.8-1.9 6.4-1.9 9.2 0L482.5 112H584c30.9 0 56 25.1 56 56v98.8c-4.9-6.9-10.2-13.5-16-19.6V168c0-22.1-17.9-40-40-40H480c-1.6 0-3.2-.5-4.6-1.4L320 17.8 164.6 126.6c-1.3 .9-2.9 1.4-4.6 1.4H56c-22.1 0-40 17.9-40 40V456c0 22.1 17.9 40 40 40H256V384c0-35.3 28.7-64 64-64c2.2 0 4.4 .1 6.5 .3c-1.4 5.2-2.7 10.4-3.6 15.8c-1-.1-1.9-.1-2.9-.1c-26.5 0-48 21.5-48 48V496h32 64 7.2c6.1 5.8 12.7 11.1 19.6 16H384 368 272 256 56c-30.9 0-56-25.1-56-56V168c0-30.9 25.1-56 56-56H157.5L315.4 1.4zM88 192h32c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H88c-13.3 0-24-10.7-24-24V216c0-13.3 10.7-24 24-24zm-8 24v48c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V216c0-4.4-3.6-8-8-8H88c-4.4 0-8 3.6-8 8zm240 24a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-144a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm8 48v24h16c4.4 0 8 3.6 8 8s-3.6 8-8 8H320c-4.4 0-8-3.6-8-8V144c0-4.4 3.6-8 8-8s8 3.6 8 8zM64 344c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v48c0 13.3-10.7 24-24 24H88c-13.3 0-24-10.7-24-24V344zm24-8c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V344c0-4.4-3.6-8-8-8H88zM496 496a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-272a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm69.7 98.3c3.1 3.1 3.1 8.2 0 11.3l-80 80c-3.1 3.1-8.2 3.1-11.3 0l-48-48c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L480 396.7l74.3-74.3c3.1-3.1 8.2-3.1 11.3 0z"],
    "toilet-paper-under": [512, 512, ["toilet-paper-reverse"], "e2a0", "M16 192c0 49.7 11.4 94.3 29.4 126.2C63.6 350.3 87.4 368 112 368H354.8c-13.6-10.2-25.5-24.7-35.3-42C299.9 291.3 288 243.9 288 192s11.9-99.3 31.5-134c9.8-17.3 21.7-31.8 35.3-42H112C87.4 16 63.6 33.7 45.4 65.8C27.4 97.7 16 142.3 16 192zM333.4 65.8C315.4 97.7 304 142.3 304 192s11.4 94.3 29.4 126.2c18.2 32.1 42 49.8 66.6 49.8s48.4-17.7 66.6-49.8c18-31.9 29.4-76.5 29.4-126.2s-11.4-94.3-29.4-126.2C448.4 33.7 424.6 16 400 16s-48.4 17.7-66.6 49.8zM496 472V291.5c-4.4 12.5-9.6 24.1-15.5 34.6c-19.5 34.5-47.6 58-80.5 58H112c-32.9 0-61-23.5-80.5-58C11.9 291.3 0 243.9 0 192S11.9 92.7 31.5 58C51 23.5 79.1 0 112 0H400c32.9 0 61 23.5 80.5 58C500.1 92.7 512 140.1 512 192V472c0 22.1-17.9 40-40 40H200c-22.1 0-40-17.9-40-40V416h16v56c0 13.3 10.7 24 24 24H472c13.3 0 24-10.7 24-24zM400 264c-8.7 0-15.7-4.2-20.6-9c-4.8-4.8-8.4-10.8-11.1-17.1c-5.4-12.6-8.3-28.8-8.3-45.9s2.9-33.3 8.3-45.9c2.7-6.3 6.3-12.3 11.1-17.1c4.9-4.8 11.9-9 20.6-9s15.7 4.2 20.6 9c4.8 4.8 8.4 10.8 11.1 17.1c5.4 12.6 8.3 28.8 8.3 45.9s-2.9 33.3-8.3 45.9c-2.7 6.3-6.3 12.3-11.1 17.1c-4.9 4.8-11.9 9-20.6 9zm24-72c0-30.9-10.7-56-24-56s-24 25.1-24 56s10.7 56 24 56s24-25.1 24-56zM64 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "light-emergency": [448, 512, [], "e41f", "M368 320V192c0-79.5-64.5-144-144-144S80 112.5 80 192V320H64V192c0-88.4 71.6-160 160-160s160 71.6 160 160V320H368zM48 368c-17.7 0-32 14.3-32 32v32c0 17.7 14.3 32 32 32H400c17.7 0 32-14.3 32-32V400c0-17.7-14.3-32-32-32H48zm0-16H400c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V400c0-26.5 21.5-48 48-48zm96.4-168c-.4 4.4-4 8-8.4 8s-8-3.6-7.7-8c3.8-46.6 41-83.8 87.7-87.7c4.4-.4 8 3.3 8 7.7s-3.6 8-8 8.4c-37.8 3.7-67.9 33.8-71.6 71.6z"],
    "arrow-down-to-arc": [512, 512, [], "e4ae", "M256 496c132.5 0 240-107.5 240-240c0-4.4 3.6-8 8-8s8 3.6 8 8c0 141.4-114.6 256-256 256S0 397.4 0 256c0-4.4 3.6-8 8-8s8 3.6 8 8c0 132.5 107.5 240 240 240zM390.1 197.2l-128 152c-1.5 1.8-3.8 2.8-6.1 2.8s-4.6-1-6.1-2.8l-128-152c-2.8-3.4-2.4-8.4 1-11.3s8.4-2.4 11.3 1L248 322.1 248 8c0-4.4 3.6-8 8-8s8 3.6 8 8l0 314.1L377.9 186.8c2.8-3.4 7.9-3.8 11.3-1s3.8 7.9 1 11.3z"],
    "dumpster": [576, 512, [], "f793", "M39.9 58.9C42.1 52.4 48.2 48 55.1 48h92.7l-24 96H27.5c-6.4 0-11.5-5.2-11.5-11.5c0-1.2 .2-2.5 .6-3.6L39.9 58.9zM164.2 48H280v96H140.2l24-96zM296 48H411.8l24 96H296V48zm132.2 0h92.7c6.9 0 13 4.4 15.2 10.9l23.3 69.9 15.2-5.1L551.3 53.9C546.9 40.8 534.7 32 520.9 32H55.1c-13.8 0-26 8.8-30.4 21.9L1.4 123.8c-.9 2.8-1.4 5.7-1.4 8.7C0 147.7 12.3 160 27.5 160H548.5c15.2 0 27.5-12.3 27.5-27.5c0-3-.5-5.9-1.4-8.7l-15.2 5.1c.4 1.2 .6 2.4 .6 3.6c0 6.4-5.2 11.5-11.5 11.5H452.2l-24-96zM47.9 198.9c-.6-4.4-4.7-7.4-9.1-6.8s-7.4 4.7-6.8 9.1L38.8 248H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H41.1l23 161.1c.6 3.9 3.9 6.9 7.9 6.9H96v40c0 4.4 3.6 8 8 8s8-3.6 8-8V432H464v40c0 4.4 3.6 8 8 8s8-3.6 8-8V432h24c4 0 7.4-2.9 7.9-6.9l23-161.1H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H537.2l6.7-46.9c.6-4.4-2.4-8.4-6.8-9.1s-8.4 2.4-9.1 6.8l-8 55.9 0 .3-23 161H472 104 78.9l-23-161 0-.3-8-55.9z"],
    "van-shuttle": [640, 512, [128656, "shuttle-van"], "f5b6", "M16 80V192H160V48H48C30.3 48 16 62.3 16 80zm0 128V336c0 17.7 14.3 32 32 32H65.3c7.6-45.4 47.1-80 94.7-80s87.1 34.6 94.7 80H385.3c7.6-45.4 47.1-80 94.7-80s87.1 34.6 94.7 80H592c17.7 0 32-14.3 32-32V212.8c0-1.6-.2-3.2-.5-4.8H376 168 16zm160-16H368V48H176V192zm208 0H613.4L483.7 55.5c-4.5-4.8-10.8-7.5-17.4-7.5H384V192zM592 384H576c0 53-43 96-96 96s-96-43-96-96H256c0 53-43 96-96 96s-96-43-96-96H48c-26.5 0-48-21.5-48-48V80C0 53.5 21.5 32 48 32H168 376h90.3c11 0 21.4 4.5 29 12.4L629 185.2c7.1 7.4 11 17.3 11 27.6V336c0 26.5-21.5 48-48 48zm-32 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM160 464a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "building-user": [640, 512, [], "e4da", "M48 16H336c17.7 0 32 14.3 32 32V378.4c5-3.9 10.4-7.5 16-10.7V271.8 48c0-26.5-21.5-48-48-48H48C21.5 0 0 21.5 0 48V464c0 26.5 21.5 48 48 48h96 16 64 16 89.9c-3-4.9-5.5-10.3-7.2-16H240V416c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-17.7 0-32-14.3-32-32V48c0-17.7 14.3-32 32-32zM224 496H160V416c0-17.7 14.3-32 32-32s32 14.3 32 32v80zM104 232c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H104zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V256zm128 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V256c0-4.4 3.6-8 8-8zM104 104c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H104zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V128zm128 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V128c0-4.4 3.6-8 8-8zM432 272a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM368 477.1c0-42.6 34.5-77.1 77.1-77.1H546.9c42.6 0 77.1 34.5 77.1 77.1c0 10.4-8.5 18.9-18.9 18.9H386.9c-10.4 0-18.9-8.5-18.9-18.9zM496 352a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm-50.9 32c-51.4 0-93.1 41.7-93.1 93.1c0 19.3 15.6 34.9 34.9 34.9H605.1c19.3 0 34.9-15.6 34.9-34.9c0-51.4-41.7-93.1-93.1-93.1H445.1z"],
    "light-switch": [384, 512, [], "e017", "M320 16c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H320zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM272 368c0 17.7-14.3 32-32 32H144c-17.7 0-32-14.3-32-32V264H272V368zM112 144c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32V248H112V144zm32-48c-26.5 0-48 21.5-48 48V368c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V144c0-26.5-21.5-48-48-48H144zm64-40a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm0 400a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "square-caret-left": [448, 512, ["caret-square-left"], "f191", "M16 416c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96l0 320zm48 64c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480zm64-224c0-7.3 3-14.3 8.4-19.3L245.6 134.8c4.7-4.4 10.8-6.8 17.2-6.8c13.9 0 25.2 11.3 25.2 25.2l0 205.6c0 13.9-11.3 25.2-25.2 25.2c-6.4 0-12.5-2.4-17.2-6.8L136.4 275.3c-5.4-5-8.4-12-8.4-19.3zM272 358.8l0-205.6c0-5.1-4.1-9.2-9.2-9.2c-2.3 0-4.6 .9-6.3 2.5L147.3 248.4c-2.1 2-3.3 4.7-3.3 7.6s1.2 5.6 3.3 7.6L256.5 365.5c1.7 1.6 4 2.5 6.3 2.5c5.1 0 9.2-4.1 9.2-9.2z"],
    "highlighter": [576, 512, [], "f591", "M144 312.6v-64c0-10.3 5-20 13.3-26l31.4-22.6L343.9 355.2l-22.6 31.4c-6 8.4-15.7 13.3-26 13.3h-64c-4.2 0-8.3 1.7-11.3 4.7l-35.7 35.7c-9.4 9.4-24.6 9.4-33.9 0l-46.8-46.8c-9.4-9.4-9.4-24.6 0-33.9l35.7-35.7c3-3 4.7-7.1 4.7-11.3zM520.8 108.9L353.4 342.1 201.9 190.6 435.1 23.2c6.5-4.7 14.3-7.2 22.4-7.2c10.2 0 19.9 4 27.1 11.2l32.2 32.2C524 66.6 528 76.3 528 86.5c0 8-2.5 15.8-7.2 22.4zM231.4 416h64c15.5 0 30-7.4 39-20L533.8 118.2C540.4 109 544 97.9 544 86.5c0-14.4-5.7-28.2-15.9-38.4L495.9 15.9C485.7 5.7 471.9 0 457.5 0C446.1 0 435 3.6 425.8 10.2L148 209.6c-12.6 9-20 23.5-20 39v64L92.3 348.3c-15.6 15.6-15.6 41 0 56.6l46.8 46.8c15.6 15.6 40.9 15.6 56.6 0L231.4 416zm-172 1.3L7.3 469.4C2.6 474.1 0 480.4 0 487c0 13.8 11.2 25 25 25H82.7c10.6 0 20.8-4.2 28.3-11.7l15.7-15.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L99.7 489c-4.5 4.5-10.6 7-17 7H25c-5 0-9-4-9-9c0-2.4 .9-4.7 2.6-6.3l52.1-52.1c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0z"],
    "wave-pulse": [640, 512, ["heart-rate"], "f5f8", "M319.8 0c3.8-.1 7.1 2.5 8 6.1l90.1 375.6 46.6-116.5c6.1-15.2 20.8-25.1 37.1-25.1H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H501.7c-9.8 0-18.6 6-22.3 15.1L423.4 411c-1.3 3.2-4.5 5.3-8 5s-6.4-2.7-7.2-6.1L320.8 45.8l-89 459.7c-.7 3.7-3.9 6.4-7.6 6.5s-7.1-2.4-8-6.1L158.3 274.2C155.6 263.5 146 256 135 256H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H135c18.4 0 34.4 12.5 38.8 30.3L223 467 312.1 6.5c.7-3.7 3.9-6.4 7.7-6.5z"],
    "key": [512, 512, [128273], "f084", "M287.2 328.4c15.4 4.9 31.8 7.6 48.8 7.6c88.4 0 160-71.6 160-160s-71.6-160-160-160s-160 71.6-160 160c0 17.1 2.7 33.5 7.6 48.8c1.8 5.7 .3 12-3.9 16.2L18.3 402.3c-1.5 1.5-2.3 3.5-2.3 5.7v80c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V448c0-8.8 7.2-16 16-16h40c4.4 0 8-3.6 8-8V384c0-8.8 7.2-16 16-16h40c2.1 0 4.2-.8 5.7-2.3L271 332.3c4.2-4.2 10.5-5.8 16.2-3.9zM336 352c-18.7 0-36.8-2.9-53.7-8.3L249 377c-4.5 4.5-10.6 7-17 7H208 192v16 24c0 13.3-10.7 24-24 24H144 128v16 24c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V408c0-6.4 2.5-12.5 7-17L168.3 229.7c-5.4-16.9-8.3-35-8.3-53.7C160 78.8 238.8 0 336 0s176 78.8 176 176s-78.8 176-176 176zm32-248a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "hat-santa": [640, 512, [], "f7a7", "M371.4 226.8c-2.2-4.7-3.4-9.9-3.4-15.2c0-19.7 15.9-35.6 35.6-35.6h1.2c3.8 0 7.5 .6 11.1 1.7l49 15.5c-.3 2.4-.5 4.8-.5 7.2c-2.3 2.3-4.4 4.8-6.3 7.4L411.1 193c-2-.6-4.1-1-6.3-1h-1.2c-10.8 0-19.6 8.8-19.6 19.6c0 2.9 .6 5.7 1.9 8.4l54.6 116H422.8L371.4 226.8zm104.9-60.9l-54.1-63.9C393.3 67.7 350.7 48 305.9 48c-62.3 0-118.3 37.9-141.4 95.7L87.6 336H70.4l79.3-198.2C175.2 73.9 237.1 32 305.9 32c49.5 0 96.5 21.8 128.5 59.6l53.5 63.2c-2.5 1.8-4.9 3.8-7.1 6c-1.6 1.6-3.1 3.3-4.5 5.1zM456 384H56c-22.1 0-40 17.9-40 40s17.9 40 40 40H456c22.1 0 40-17.9 40-40s-17.9-40-40-40zM56 368H456c30.9 0 56 25.1 56 56s-25.1 56-56 56H56c-30.9 0-56-25.1-56-56s25.1-56 56-56zM573.5 183.4c-2.9-4.5-7.9-7.4-13.5-7.4s-10.6 2.9-13.5 7.4c-3.6 5.7-10.4 8.5-16.9 7c-5.2-1.2-10.8 .3-14.8 4.3s-5.5 9.6-4.3 14.8c1.5 6.6-1.4 13.3-7 16.9c-4.5 2.9-7.4 7.9-7.4 13.5s2.9 10.6 7.4 13.5c5.7 3.6 8.5 10.4 7 16.9c-1.2 5.2 .3 10.8 4.3 14.8s9.6 5.5 14.8 4.3c6.6-1.5 13.3 1.4 16.9 7c2.9 4.5 7.9 7.4 13.5 7.4s10.6-2.9 13.5-7.4c3.6-5.7 10.4-8.5 16.9-7c5.2 1.2 10.8-.3 14.8-4.3s5.5-9.6 4.3-14.8c-1.5-6.6 1.4-13.3 7-16.9c4.5-2.9 7.4-7.9 7.4-13.5s-2.9-10.6-7.4-13.5c-5.7-3.6-8.5-10.4-7-16.9c1.2-5.2-.3-10.8-4.3-14.8s-9.6-5.5-14.8-4.3c-6.6 1.5-13.3-1.4-16.9-7zM640 240c0 11.3-5.9 21.3-14.8 27c2.3 10.3-.6 21.5-8.6 29.6s-19.3 10.9-29.6 8.6c-5.7 8.9-15.6 14.8-27 14.8s-21.3-5.9-27-14.8c-10.3 2.3-21.5-.6-29.6-8.6s-10.9-19.3-8.6-29.6c-8.9-5.7-14.8-15.7-14.8-27s5.9-21.3 14.8-27c-2.3-10.3 .6-21.5 8.6-29.6s19.3-10.9 29.6-8.6c5.7-8.9 15.6-14.8 27-14.8s21.3 5.9 27 14.8c10.3-2.3 21.5 .6 29.6 8.6s10.9 19.3 8.6 29.6c8.9 5.7 14.8 15.7 14.8 27z"],
    "tamale": [320, 512, [129748], "e451", "M295.1 296l24.5 146.7c1.7 10.2-1.7 20.6-9 27.9C274 507 207.7 512 160 512s-114-5-150.6-41.3c-7.3-7.3-10.7-17.7-9-27.9L24.9 296H41.1L16.2 445.4c-.8 5.1 .8 10.3 4.5 14c15.2 15.1 37.6 24.5 63.2 30c25.5 5.4 52.7 6.7 76.1 6.7s50.6-1.2 76.1-6.7c25.6-5.5 48-14.9 63.2-30c3.7-3.7 5.3-8.9 4.5-14L278.9 296h16.2zM319.6 69.3L295.1 216H278.9L303.8 66.6c.8-5.1-.8-10.3-4.5-14c-15.2-15.1-37.6-24.5-63.2-30C210.6 17.2 183.4 16 160 16s-50.6 1.2-76.1 6.7c-25.6 5.5-48 14.9-63.2 30c-3.7 3.7-5.3 8.9-4.5 14L41.1 216H24.9L.4 69.3c-1.7-10.2 1.7-20.6 9-27.9C46 5 112.3 0 160 0s114 5 150.6 41.3c7.3 7.3 10.7 17.7 9 27.9zM8 256c0-4.4 3.6-8 8-8H160 304c4.4 0 8 3.6 8 8s-3.6 8-8 8H176.4l46 59.1c2.7 3.5 2.1 8.5-1.4 11.2s-8.5 2.1-11.2-1.4L160 269l-49.7 63.9c-2.7 3.5-7.7 4.1-11.2 1.4s-4.1-7.7-1.4-11.2l46-59.1H16c-4.4 0-8-3.6-8-8zM160 64c4.4 0 8 3.6 8 8V216h-8-8V72c0-4.4 3.6-8 8-8zm0 258.7l8 10.7V440c0 4.4-3.6 8-8 8s-8-3.6-8-8V333.3l8-10.7zM88 79.3L100.4 216H84.3L72 80.7c-.4-4.4 2.8-8.3 7.2-8.7s8.3 2.8 8.7 7.2zM88 352c2.2 1.7 4.5 3 6.9 4.2l-7 76.5c-.4 4.4-4.3 7.6-8.7 7.2s-7.6-4.3-7.2-8.7L80 344c2.2 3 4.9 5.7 8 8zm144 0c3.1-2.3 5.8-5 8-8l7.9 87.3c.4 4.4-2.8 8.3-7.2 8.7s-8.3-2.8-8.7-7.2l-7-76.5c2.4-1.1 4.7-2.5 6.9-4.2zM219.6 216L232 79.3c.4-4.4 4.3-7.6 8.7-7.2s7.6 4.3 7.2 8.7L235.7 216H219.6z"],
    "box-check": [448, 512, [], "f467", "M232 48H342.4c19 0 36.2 11.2 43.9 28.5l41.6 93.6c.9 1.9 1.6 3.9 2.2 5.9H232V48zM16 192H432V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V192zm200-16H18c.6-2 1.3-4 2.2-5.9L61.7 76.5C69.4 59.2 86.6 48 105.6 48H216V176zM400.9 70c-10.3-23.1-33.2-38-58.5-38H105.6C80.3 32 57.4 46.9 47.1 70L5.5 163.6c-3.6 8.2-5.5 17-5.5 26V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V189.6c0-9-1.9-17.8-5.5-26L400.9 70zM325.7 261.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L192 372.7l-58.3-58.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l64 64c3.1 3.1 8.2 3.1 11.3 0l128-128z"],
    "bullhorn": [512, 512, [128226, 128363], "f0a1", "M464 32c0-28.1-33.7-42.6-54.1-23.2l-44 41.9C326.4 88.4 277 113.4 224 123.3v16.3c57.1-10 110.4-36.7 152.9-77.2l44-41.9c10.2-9.7 27-2.5 27 11.6V448c0 14.1-16.8 21.3-27 11.6l-44-41.9c-42.5-40.5-95.8-67.2-152.9-77.2v16.3c53 9.9 102.4 34.9 141.9 72.5l44 41.9c20.4 19.4 54.1 5 54.1-23.2V313.3c28.3-12.3 48-40.5 48-73.3s-19.7-61-48-73.3V32zM192 416V352.7v-16V143.4v-16c-6.4 .4-12.8 .7-19.2 .7H160l-96 0c-35.3 0-64 28.7-64 64v96c0 35.3 28.7 64 64 64l0 120c0 22.1 17.9 40 40 40h48c22.1 0 40-17.9 40-40V416zM464 295.4V184.6c19.1 11.1 32 31.7 32 55.4s-12.9 44.4-32 55.4zM176 352V472c0 13.3-10.7 24-24 24H104c-13.3 0-24-10.7-24-24V352h80 12.8c1.1 0 2.1 0 3.2 0zm-3.2-16H160 64c-26.5 0-48-21.5-48-48V192c0-26.5 21.5-48 48-48l96 0h12.8c1.1 0 2.1 0 3.2 0V336c-1.1 0-2.1 0-3.2 0z"],
    "steak": [576, 512, [129385], "f824", "M368 16c58.3 0 106.9 35.2 138 74c31.9 39.9 54 93.7 54 150c0 76.7-50.6 141.4-106.9 183.3C395 466.6 317.8 496 240 496c-35.8 0-83.6-4.3-124.8-18.5C79.2 465.2 16 432.9 16 360c0-33.1 15.1-58.4 36.5-75.6c18.2-14.6 38.5-24.9 60.5-36c2.7-1.4 5.5-2.8 8.2-4.2c24.6-12.6 50.8-26.8 73.5-49.5c16.1-16.1 23-32.8 32.9-56.6l.6-1.6c3.2-7.7 6.8-16.3 11.1-26.3c7.6-17.3 19.3-41.7 40.3-61.2C303.3 27.1 333.3 16 368 16zm0-16c-38.3 0-72.3 12.4-99.2 37.4c-23.5 21.9-36.3 48.9-44.1 66.5c-4.4 10.1-8 18.9-11.2 26.6c-10.4 25.1-16.2 39.1-30 52.9c-23.1 23.1-50.4 36.9-77.7 50.7c-21.8 11-43.6 22.1-63.3 37.8C17.8 291.7 0 321.4 0 360c0 84.3 73.4 120.1 110 132.7c43.5 15 93.3 19.3 130 19.3c81.7 0 162.1-30.8 222.6-75.8C520.9 392.8 576 323.9 576 240c0-60.4-23.6-117.6-57.5-160C485.7 39 433 0 368 0zm16 248a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm-40-24a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zM121.7 316l0 0-1.3 .6 0 0c-15 6.4-27.2 11.7-35.6 18.8c-3.4 2.9-7 6.8-9.5 12.4C72.9 353.1 72 359 72 365.2c0 28.6 24.3 47.4 57.8 59.1C163.1 435.8 204.7 440 238 440c65 0 131.5-25.2 181.8-62.9c50.3-37.8 84.2-88 84.2-137.9c0-41.8-16.6-83.6-41.5-115C437.6 92.8 404.4 72 371.3 72c-20.7 0-35.2 6.3-46.2 16.6C314 99 306.3 113.6 299 130.4c-2.5 5.7-5 11.9-7.5 18.2l0 0 0 .1c-12 29.8-25.8 63.7-53 91.2C193 285.6 151.7 303.2 121.7 316zm128.1-64.9c29.8-30.1 44.6-66.9 56.5-96.5c2.6-6.3 5-12.4 7.4-17.9c7.1-16.5 13.8-28.4 22.4-36.4C343.9 93 354.3 88 371.3 88c26.5 0 55.5 17 78.7 46.2c22.9 28.9 38 67.3 38 105c0 42.9-29.5 88.9-77.8 125.1C362.3 400.2 299.1 424 238 424c-32.3 0-72-4.1-102.9-14.8c-32.4-11.2-47.1-26.4-47.1-44c0-9.5 2.7-13.8 7.2-17.7c6.1-5.2 15.6-9.5 31.4-16.2l1.3-.6c30.5-13 74.1-31.5 121.9-79.6z"],
    "location-crosshairs-slash": [640, 512, ["location-slash"], "f603", "M401.5 412.1C377.1 424.8 349.4 432 320 432c-97.2 0-176-78.8-176-176c0-14.8 1.8-29.3 5.3-43l-13.7-10.8c-4.3 14.6-6.8 30-7.5 45.8H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h56.2c4.1 99.7 84.2 179.8 183.8 183.8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V447.8c31.6-1.3 61.2-10.2 87.1-25l-13.6-10.8zM312 64.2c-31.6 1.3-61.2 10.2-87.1 25l13.6 10.8C262.9 87.2 290.6 80 320 80c97.2 0 176 78.8 176 176c0 14.8-1.8 29.3-5.3 43l13.7 10.8c4.3-14.6 6.8-30 7.5-45.8H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H511.8C507.8 148.3 427.7 68.2 328 64.2V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64.2zM320 352c1.8 0 3.5 0 5.2-.1l-22.4-17.7c-24.2-5.3-44.3-21.5-54.8-43.3l-22.5-17.7C233.6 318 272.8 352 320 352zm-5.2-191.9l22.4 17.7c24.2 5.3 44.3 21.5 54.8 43.3l22.5 17.7C406.4 194 367.2 160 320 160c-1.8 0-3.5 0-5.2 .1zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "person-dolly": [512, 512, [], "f4d0", "M91.4 226.4c-6.7 2-11.4 8.3-11.4 15.3v65.1c0 4.2 1.7 8.3 4.7 11.3l51 51c4.7 4.7 7.8 10.8 8.9 17.4l15.2 90.9c1.5 8.7-4.4 17-13.2 18.4s-17-4.4-18.4-13.2l-14.3-85.9c-.5-3.3-2.1-6.3-4.5-8.7L30.1 308.7c-9-9-14.1-21.2-14.1-33.9V186.6C16 163.1 35.1 144 58.6 144c18.7 0 36.2 9.3 46.5 24.9l42.6 64c3 4.5 8 7.1 13.3 7.1h57.3l7.4 31.9c-.6 .1-1.3 .1-1.9 .1H152.6c-10.7 0-20.7-5.3-26.6-14.3l-16.6-24.9c-3.9-5.9-11.2-8.5-17.9-6.4zM224 288c1.9 0 3.7-.2 5.5-.5l24.7 106.1C236.1 404.9 224 425 224 448c0 35.3 28.7 64 64 64c33.8 0 61.6-26.3 63.8-59.5l154-36.7c4.3-1 7-5.3 5.9-9.6s-5.3-7-9.6-5.9l-151.2 36C345.4 406.5 319.3 384 288 384c-6.6 0-12.9 1-18.9 2.8L215.8 158.2c-1-4.3-5.3-7-9.6-6s-7 5.3-6 9.6L214.7 224H161.1l-42.6-64c-13.3-20-35.8-32-59.9-32C26.2 128 0 154.2 0 186.6v88.1c0 17 6.7 33.3 18.7 45.3l79.4 79.4 14.3 85.9c2.9 17.4 19.4 29.2 36.8 26.3s29.2-19.4 26.3-36.8l-15.2-90.9c-1.6-9.9-6.3-19-13.4-26.1l-51-51V270.5 241.7l16 24 .6 .9c8.9 13.4 23.9 21.4 39.9 21.4H224zM80 16a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm48 32A48 48 0 1 0 32 48a48 48 0 1 0 96 0zM0 346.5L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-69.5-16-16L48 480c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-117.5-16-16zM240 448a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM445.1 337.8l-91.5 22.9c-8.6 2.1-17.3-3.1-19.4-11.6l-22.9-91.5c-2.1-8.6 3.1-17.3 11.6-19.4l91.5-22.9c8.6-2.1 17.3 3.1 19.4 11.6l22.9 91.5c2.1 8.6-3.1 17.3-11.6 19.4zm3.9 15.5c17.1-4.3 27.6-21.7 23.3-38.8L449.4 223c-4.3-17.1-21.7-27.6-38.8-23.3L319 222.6c-17.1 4.3-27.6 21.7-23.3 38.8L318.6 353c4.3 17.1 21.7 27.6 38.8 23.3L449 353.4z"],
    "globe": [512, 512, [127760], "f0ac", "M256 496c26 0 53.9-21.5 76.2-66.1c11-21.9 19.9-48.3 26.2-77.9H153.6c6.2 29.5 15.2 55.9 26.2 77.9C202.1 474.5 230 496 256 496zM150.6 336H361.4c4.3-25 6.6-51.9 6.6-80s-2.3-55-6.6-80H150.6c-4.3 25-6.6 51.9-6.6 80s2.3 55 6.6 80zm3-176H358.4c-6.2-29.6-15.2-55.9-26.2-77.9C309.9 37.5 282 16 256 16s-53.9 21.5-76.2 66.1c-11 21.9-19.9 48.3-26.2 77.9zm224 16c4.1 25.2 6.4 52.1 6.4 80s-2.2 54.8-6.4 80H482.3c8.8-25 13.7-51.9 13.7-80s-4.8-55-13.7-80H377.6zM476 160C445.6 90.5 383.2 38.1 307.5 21.5c30.5 26.8 54.7 76.6 67.2 138.5H476zm-338.7 0c12.5-61.8 36.8-111.7 67.2-138.5C128.8 38.1 66.4 90.5 36 160H137.3zM29.7 176C20.8 201 16 227.9 16 256s4.8 55 13.7 80H134.4c-4.1-25.2-6.4-52.1-6.4-80s2.2-54.8 6.4-80H29.7zM307.5 490.5C383.2 473.9 445.6 421.5 476 352H374.7c-12.5 61.8-36.8 111.7-67.2 138.5zm-102.9 0c-30.5-26.8-54.7-76.6-67.2-138.5H36c30.4 69.5 92.8 121.9 168.6 138.5zM256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512z"],
    "synagogue": [640, 512, [128333], "f69b", "M325 1.7c-2.9-2.3-7-2.3-9.9 0L187.4 102.5C170.1 116.2 160 137 160 159V260.7L93.7 194.3c-3.1-3.1-8.2-3.1-11.3 0L11.7 265C4.2 272.5 0 282.6 0 293.3V472c0 22.1 17.9 40 40 40H168h88 16 96 16 88H600c22.1 0 40-17.9 40-40V293.3c0-10.6-4.2-20.8-11.7-28.3l-70.6-70.6c-3.1-3.1-8.2-3.1-11.3 0L480 260.7V159c0-22-10.1-42.9-27.4-56.5L325 1.7zM480 293.3c0-6.4 2.5-12.5 7-17l65-65 65 65c4.5 4.5 7 10.6 7 17V472c0 13.3-10.7 24-24 24H480V293.3zm-16 0V496H384V384c0-35.3-28.7-64-64-64s-64 28.7-64 64V496H176V293.3 159c0-17.1 7.8-33.3 21.3-44L320 18.2l122.7 96.9c13.4 10.6 21.3 26.8 21.3 44V293.3zM368 496H272V384c0-26.5 21.5-48 48-48s48 21.5 48 48V496zm-208 0H40c-13.3 0-24-10.7-24-24V293.3c0-6.4 2.5-12.5 7-17l65-65 65 65c4.5 4.5 7 10.6 7 17V496zm77.9-340.8L258.3 191l-20.5 35.8c-4 6.9 1 15.6 9 15.6h40.8L311 283.1c4 7 14.1 7 18.1 0l23.3-40.7h40.8c8 0 13-8.6 9-15.6L381.7 191l20.5-35.8c4-6.9-1-15.6-9-15.6H352.3L329 98.9c-4-7-14.1-7-18.1 0l-23.3 40.7H246.9c-8 0-13 8.6-9 15.6zm27.9 48.7l14.7 25.7H251l14.7-25.7zm29.4 25.7L273.1 191l22.1-38.6h49.7L366.9 191l-22.1 38.6H295.1zm7.3 12.8h35.1L320 273.1l-17.5-30.7zm57.1-12.8l14.7-25.7L389 229.6H359.6zm14.7-51.5l-14.7-25.7H389l-14.7 25.7zm-36.7-38.5H302.5L320 108.9l17.5 30.7zm-57.1 12.8l-14.7 25.7L251 152.4h29.4z"],
    "file-chart-column": [384, 512, ["file-chart-line"], "f659", "M16 448V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48zM358.6 157.3c.9 .9 1.7 1.8 2.4 2.7H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64zM192 224c-17.7 0-32 14.3-32 32V416c0 17.7 14.3 32 32 32s32-14.3 32-32V256c0-17.7-14.3-32-32-32zm-16 32c0-8.8 7.2-16 16-16s16 7.2 16 16V416c0 8.8-7.2 16-16 16s-16-7.2-16-16V256zm112 32c-17.7 0-32 14.3-32 32v96c0 17.7 14.3 32 32 32s32-14.3 32-32V320c0-17.7-14.3-32-32-32zm-16 32c0-8.8 7.2-16 16-16s16 7.2 16 16v96c0 8.8-7.2 16-16 16s-16-7.2-16-16V320zM96 352c-17.7 0-32 14.3-32 32v32c0 17.7 14.3 32 32 32s32-14.3 32-32V384c0-17.7-14.3-32-32-32zM80 384c0-8.8 7.2-16 16-16s16 7.2 16 16v32c0 8.8-7.2 16-16 16s-16-7.2-16-16V384z"],
    "person-half-dress": [320, 512, [], "e548", "M160 16a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm0 96A56 56 0 1 0 160 0a56 56 0 1 0 0 112zM90.7 175.7c9.3-19.4 28.9-31.7 50.4-31.7H152V368h-8H96 67.1l52.5-157.5c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1l-56 168c-.8 2.4-.4 5.1 1.1 7.2s3.9 3.3 6.5 3.3H88v96c0 17.7 14.3 32 32 32s32-14.3 32-32V384h16v96c0 17.7 14.3 32 32 32s32-14.3 32-32V248c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 8.8-7.2 16-16 16s-16-7.2-16-16V376c0-4.4-3.6-8-8-8h-8V144h10.9c21.5 0 41.1 12.3 50.4 31.7l67.5 139.8c1.9 4 6.7 5.6 10.7 3.7s5.6-6.7 3.7-10.7L243.7 168.7c-12-24.9-37.2-40.7-64.8-40.7H141.1c-27.6 0-52.8 15.8-64.8 40.7L8.8 308.5c-1.9 4-.3 8.8 3.7 10.7s8.8 .3 10.7-3.7L90.7 175.7zM104 480V384h32v96c0 8.8-7.2 16-16 16s-16-7.2-16-16z"],
    "folder-image": [512, 512, [], "e18a", "M448 464H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H197.5c12.7 0 24.9 5.1 33.9 14.1l35.9 35.9c9 9 21.2 14.1 33.9 14.1H448c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48zM64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H301.3c-8.5 0-16.6-3.4-22.6-9.4L242.7 50.7c-12-12-28.3-18.7-45.3-18.7H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64zM168 208a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-40-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm167.9 40c2.3 0 4.5 1.2 5.7 3.1L407.3 393.3c.5 .7 .7 1.5 .7 2.4c0 2.4-2 4.4-4.4 4.4H108.3c-2.4 0-4.3-1.9-4.3-4.3c0-.8 .3-1.7 .7-2.4L162 307.5c1.4-2.2 3.9-3.5 6.4-3.5c2.4 0 4.6 1.1 6.1 2.9L201.8 341c1.6 2 4 3.1 6.6 3s4.9-1.4 6.3-3.6L290.3 227c1.3-1.9 3.4-3 5.6-3zM277 218.1L207.4 322.5 187 296.9c-4.5-5.6-11.3-8.9-18.5-8.9c-7.9 0-15.4 4-19.8 10.6L91.4 384.5c-2.2 3.3-3.4 7.2-3.4 11.3c0 11.2 9.1 20.3 20.3 20.3H403.6c11.3 0 20.4-9.1 20.4-20.4c0-3.9-1.1-7.7-3.2-11L315.1 218.5c-4.2-6.6-11.4-10.5-19.2-10.5c-7.6 0-14.7 3.8-18.9 10.1z"],
    "calendar-pen": [512, 512, ["calendar-edit"], "f333", "M160 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H96c-35.3 0-64 28.7-64 64v48 16V448c0 35.3 28.7 64 64 64H416c35.3 0 64-28.7 64-64V192 176 128c0-35.3-28.7-64-64-64H368V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H160V8zM48 192H464V448c0 26.5-21.5 48-48 48H96c-26.5 0-48-21.5-48-48V192zM144 80v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80H352v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80h48c26.5 0 48 21.5 48 48v48H48V128c0-26.5 21.5-48 48-48h48zM333.3 252.3l6.4 6.4c9.4 9.4 9.4 24.6 0 33.9l-17.9 17.9-40.4-40.4 17.9-17.9c9.4-9.4 24.6-9.4 33.9 0zm-157 123l93.9-93.9 40.4 40.4-93.9 93.9c-1.1 1.1-2.4 1.8-3.9 2.1l-50.2 11.5 11.5-50.2c.3-1.5 1.1-2.8 2.1-3.9zM288 241L165 364c-3.2 3.2-5.4 7.2-6.4 11.6l-11.5 50.2c-2.6 11.5 7.7 21.8 19.2 19.2l50.2-11.5c4.4-1 8.4-3.2 11.6-6.4L351 304c15.6-15.6 15.6-40.9 0-56.6l-6.4-6.4c-15.6-15.6-40.9-15.6-56.6 0z"],
    "road-bridge": [640, 512, [], "e563", "M576 16H488V96c0 4.4-3.6 8-8 8s-8-3.6-8-8V16H384c-26.5 0-48 21.5-48 48V448c0 26.5 21.5 48 48 48h88V416c0-4.4 3.6-8 8-8s8 3.6 8 8v80h88c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48zM384 0h96 96c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H384c-35.3 0-64-28.7-64-64V64c0-35.3 28.7-64 64-64zm96 192c4.4 0 8 3.6 8 8V312c0 4.4-3.6 8-8 8s-8-3.6-8-8V200c0-4.4 3.6-8 8-8zM8 96H288v16H232v80h56v16H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H88V112H8c-4.4 0-8-3.6-8-8s3.6-8 8-8zM272 304h16v16H272c-39.8 0-72 32.2-72 72v80c0 22.1-17.9 40-40 40H128c-22.1 0-40-17.9-40-40V392c0-39.8-32.2-72-72-72H8c-4.4 0-8-3.6-8-8s3.6-8 8-8h8c48.6 0 88 39.4 88 88v80c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V392c0-48.6 39.4-88 88-88zM216 112H104v80H216V112z"],
    "face-smile-tear": [512, 512, [], "e393", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm317.4 79.4C308.8 349.1 304 360.9 304 369c0 16.8 14 31 32 31s32-14.2 32-31c0-8.1-4.9-19.8-13.5-33.6c-6-9.5-12.7-18.5-18.5-26.1c-5.9 7.7-12.6 16.6-18.5 26.1zm12.2-44.1c3.2-4.4 9.6-4.4 12.8 0c1.3 1.8 2.8 3.7 4.4 5.8c14.1 18.5 37.2 48.6 37.2 72c0 26-21.5 47-48 47s-48-21-48-47c0-23.7 23.5-54.3 37.7-72.7c1.4-1.8 2.7-3.5 3.9-5.1zM160.4 208a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "message-plus": [512, 512, ["comment-alt-plus"], "f4a8", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM248 304c0 4.4 3.6 8 8 8s8-3.6 8-8V216h88c4.4 0 8-3.6 8-8s-3.6-8-8-8H264V112c0-4.4-3.6-8-8-8s-8 3.6-8 8v88H160c-4.4 0-8 3.6-8 8s3.6 8 8 8h88v88z"],
    "location-arrow": [448, 512, [], "f124", "M224 240H48c-7.6 0-14.2-5.4-15.7-12.9s2.6-15 9.6-17.9l352-144c6-2.4 12.8-1.1 17.4 3.5s5.9 11.4 3.5 17.4l-144 352c-2.9 7.1-10.4 11.1-17.9 9.6s-12.9-8.1-12.9-15.7V256c0-8.8-7.2-16-16-16zm-16 16h16v16V432c0 15.3 10.8 28.4 25.8 31.4s30-5.1 35.8-19.3l144-352c4.9-11.9 2.1-25.6-7-34.7s-22.8-11.9-34.7-7l-352 144c-14.2 5.8-22.2 20.8-19.3 35.8s16.1 25.8 31.4 25.8H208z"],
    "c": [384, 512, [99], "43", "M76.9 108.9c-81.2 81.2-81.2 212.9 0 294.2s212.9 81.2 294.2 0c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3c-87.5 87.5-229.3 87.5-316.8 0s-87.5-229.3 0-316.8s229.3-87.5 316.8 0c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0c-81.2-81.2-212.9-81.2-294.2 0z"],
    "tablet-button": [448, 512, [], "f10a", "M64 16C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H64zM0 64C0 28.7 28.7 0 64 0H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM208 432a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm16 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "rectangle-history-circle-user": [640, 512, [], "e4a4", "M448 144c26.5 0 48 21.5 48 48c5.4 0 10.7 .2 16 .7V192c0-35.3-28.7-64-64-64L64 128c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64l330.8 0c-6.9-4.9-13.4-10.2-19.6-16L64 496c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l384 0zm8-80L56 64c-4.4 0-8 3.6-8 8s3.6 8 8 8l400 0c4.4 0 8-3.6 8-8s-3.6-8-8-8zM408 0H104c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8zM573.9 469.6C552.3 486.2 525.3 496 496 496s-56.3-9.8-77.9-26.4l3.3-6.6c9.5-19 28.9-31 50.1-31h48.9c21.2 0 40.6 12 50.1 31l3.3 6.6zm12.4-10.9l-1.5-2.9c-12.2-24.4-37.1-39.8-64.4-39.8H471.6c-27.3 0-52.2 15.4-64.4 39.8l-1.5 2.9C382.4 435.5 368 403.5 368 368c0-70.7 57.3-128 128-128s128 57.3 128 128c0 35.5-14.4 67.5-37.7 90.7zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 304a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "building-lock": [576, 512, [], "e4d6", "M48 16H336c17.7 0 32 14.3 32 32V256c0-19.6 5.9-37.9 16-53.1V48c0-26.5-21.5-48-48-48H48C21.5 0 0 21.5 0 48V464c0 26.5 21.5 48 48 48h96 16 64 16 88.6c-2.9-5-5.1-10.3-6.5-16H240V416c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-17.7 0-32-14.3-32-32V48c0-17.7 14.3-32 32-32zM224 496H160V416c0-17.7 14.3-32 32-32s32 14.3 32 32v80zM104 232c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H104zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V256zm128 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V256c0-4.4 3.6-8 8-8zM104 104c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H104zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V128zm128 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V128c0-4.4 3.6-8 8-8zm216 88c26.5 0 48 21.5 48 48v64H416V256c0-26.5 21.5-48 48-48zm-64 48v64H384c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32H544c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32H528V256c0-35.3-28.7-64-64-64s-64 28.7-64 64zm-16 80h16 16 96 16 16c8.8 0 16 7.2 16 16V480c0 8.8-7.2 16-16 16H384c-8.8 0-16-7.2-16-16V352c0-8.8 7.2-16 16-16z"],
    "chart-line-up": [512, 512, [], "e0e5", "M16 40c0-4.4-3.6-8-8-8s-8 3.6-8 8V408c0 39.8 32.2 72 72 72H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H72c-30.9 0-56-25.1-56-56V40zm336 88c-4.4 0-8 3.6-8 8s3.6 8 8 8H452.7L288 308.7l-90.3-90.3c-3.1-3.1-8.2-3.1-11.3 0l-96 96c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L192 235.3l90.3 90.3c3.1 3.1 8.2 3.1 11.3 0L464 155.3V256c0 4.4 3.6 8 8 8s8-3.6 8-8V136c0-4.4-3.6-8-8-8H352z"],
    "mailbox": [576, 512, [128234], "f813", "M272 384c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V208C16 137.3 73.3 80 144 80s128 57.3 128 128V384zm16-176c0-55.7-31.7-104.1-78-128H432c70.7 0 128 57.3 128 128V384c0 26.5-21.5 48-48 48H266.3c13.3-11.7 21.7-28.9 21.7-48V208zM64 448H224 512c35.3 0 64-28.7 64-64V208c0-79.5-64.5-144-144-144H144C64.5 64 0 128.5 0 208V384c0 35.3 28.7 64 64 64zm8-256c-4.4 0-8 3.6-8 8s3.6 8 8 8H216c4.4 0 8-3.6 8-8s-3.6-8-8-8H72zm304 0c-4.4 0-8 3.6-8 8s3.6 8 8 8h56v64c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V216c0-13.3-10.7-24-24-24H440 376zm72 80V208h40c4.4 0 8 3.6 8 8v56c0 4.4-3.6 8-8 8H456c-4.4 0-8-3.6-8-8z"],
    "truck-bolt": [640, 512, [], "e3d0", "M352 16c26.5 0 48 21.5 48 48V400H236.7c-10.4-36.9-44.4-64-84.7-64s-74.2 27.1-84.7 64H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H352zM64 416h.4c-.2 2.6-.4 5.3-.4 8c0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8H400h.4c-.2 2.6-.4 5.3-.4 8c0 48.6 39.4 88 88 88s88-39.4 88-88c0-2.7-.1-5.4-.4-8H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H608V229.3c0-10.6-4.2-20.8-11.7-28.3L503 107.7c-7.5-7.5-17.7-11.7-28.3-11.7H416V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64zM416 112h58.7c6.4 0 12.5 2.5 17 7L585 212.3c1.1 1.1 2.2 2.4 3 3.7H416V112zm0 261.4V232H592V400H572.7c-10.4-36.9-44.4-64-84.7-64c-29.8 0-56.1 14.8-72 37.4zM152 352a72 72 0 1 1 0 144 72 72 0 1 1 0-144zm264 72a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM270.9 104.1c8.3-14.5-8.4-30.4-22.5-21.4L122.9 162.5c-13.5 8.6-7.4 29.5 8.6 29.5h45.6l-32 55.9c-8.3 14.5 8.4 30.4 22.5 21.4l125.5-79.9c13.5-8.6 7.4-29.5-8.6-29.5H238.9l32-55.9zM131.5 176L257 96.1 218.2 164c-1.4 2.5-1.4 5.5 0 8s4.1 4 6.9 4h59.4L159 255.9 197.8 188c1.4-2.5 1.4-5.5 0-8s-4.1-4-6.9-4l-59.4 0z"],
    "pizza-slice": [512, 512, [], "f818", "M168.6 16.8c-14.4-1-27.2 8.9-30.9 22.9L124.7 88.3c162.2 6.5 292.5 136.8 299 299l48.5-12.9c14.1-3.7 23.9-16.5 22.9-30.9C483.1 168.6 343.4 28.9 168.6 16.8zM16 496L407.9 391.5c-4.4-156.7-130.7-283-287.4-287.4L16 496zM122.2 35.6C127.7 14.9 146.9-.7 169.7 .9C352.5 13.5 498.5 159.5 511.1 342.3c1.6 22.8-14 41.9-34.7 47.5L20.1 511.5c-5.5 1.5-11.4-.1-15.4-4.1s-5.6-9.9-4.1-15.4L122.2 35.6zM176 200a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm32 96a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm40 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM144 328a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "money-bill-wave": [576, 512, [], "f53a", "M16 422.3c0 12.4 6.9 22.7 16.6 26.3c78.1 29.1 156.8 11.7 240.7-9.6c4-1 8-2 12-3.1c78.7-20.1 162.3-41.4 246.3-18.5c15.2 4.2 28.4-6.9 28.4-17.9V89.7c0-12.4-6.9-22.7-16.6-26.3C465.3 34.2 386.7 51.7 302.8 73c-4 1-8 2-12 3l0 0 0 0 0 0C212 96.2 128.4 117.5 44.4 94.6C29.2 90.4 16 101.5 16 112.5V422.3zm-16 0V112.5C0 88.6 25.6 72.8 48.7 79.1c79.8 21.8 159.6 1.5 239.3-18.9c87-22.2 174-44.4 261-11.9c16.9 6.3 27 23.2 27 41.3V399.5c0 23.9-25.6 39.7-48.7 33.4c-79.8-21.8-159.6-1.5-239.3 18.9c-87 22.2-174 44.4-261 11.9c-16.9-6.3-27-23.2-27-41.3zM216 256c0 50 33.5 88 72 88s72-38 72-88s-33.5-88-72-88s-72 38-72 88zm72-104c49.9 0 88 48 88 104s-38.1 104-88 104s-88-48-88-104s38.1-104 88-104zm256 0c0 4.4-3.6 8-8 8h-8c-39.8 0-72-32.2-72-72V80c0-4.4 3.6-8 8-8s8 3.6 8 8v8c0 30.9 25.1 56 56 56h8c4.4 0 8 3.6 8 8zM40 216c-4.4 0-8-3.6-8-8s3.6-8 8-8h8c30.9 0 56-25.1 56-56v-8c0-4.4 3.6-8 8-8s8 3.6 8 8v8c0 39.8-32.2 72-72 72H40zm504 88c0 4.4-3.6 8-8 8h-8c-30.9 0-56 25.1-56 56v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-39.8 32.2-72 72-72h8c4.4 0 8 3.6 8 8zM40 352h8c39.8 0 72 32.2 72 72v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-30.9-25.1-56-56-56H40c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M16 40c0-4.4-3.6-8-8-8s-8 3.6-8 8V408c0 39.8 32.2 72 72 72H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H72c-30.9 0-56-25.1-56-56V40zM308.7 203.3c3 3 7.1 4.7 11.3 4.7s8.3-1.7 11.3-4.7l39.6-39.6c6.6-6.6 17.4-6.2 23.5 .9l62 72.3c5 5.8 7.7 13.2 7.7 20.8V352c0 8.8-7.2 16-16 16H128c-8.8 0-16-7.2-16-16V243.9c0-8.5 3.4-16.6 9.4-22.6l91.3-91.3c6.2-6.2 16.4-6.2 22.6 0l73.4 73.4zM320 192l-11.3-11.3-62.1-62.1c-12.5-12.5-32.8-12.5-45.3 0l-91.3 91.3c-9 9-14.1 21.2-14.1 33.9V352c0 17.7 14.3 32 32 32H448c17.7 0 32-14.3 32-32V257.8c0-11.5-4.1-22.5-11.6-31.2l-62-72.3c-12.1-14.2-33.7-15-46.9-1.8l-28.2 28.3L320 192z"],
    "house-flag": [640, 512, [], "e50d", "M456 0c-4.4 0-8 3.6-8 8V32h0V48 176v16h0V512h16V192H624c8.8 0 16-7.2 16-16V48c0-8.8-7.2-16-16-16H464V8c0-4.4-3.6-8-8-8zm8 176V48H624V176H464zm-48-38L276.8 33.6c-2.8-2.1-6.8-2.1-9.6 0l-256 192c-3.5 2.7-4.3 7.7-1.6 11.2s7.7 4.3 11.2 1.6L64 206V448c0 35.3 28.7 64 64 64H416V496H352V344c0-13.3-10.7-24-24-24H216c-13.3 0-24 10.7-24 24V496H128c-26.5 0-48-21.5-48-48V194L272 50 416 158V138zM336 344V496l-128 0V344c0-4.4 3.6-8 8-8H328c4.4 0 8 3.6 8 8z"],
    "circle-three-quarters-stroke": [512, 512, [], "e5d4", "M495.5 272H280c-22.1 0-40-17.9-40-40V16.5C114.9 24.8 16 128.8 16 256c0 132.5 107.5 240 240 240c127.2 0 231.2-98.9 239.5-224zm.5-16C496 123.5 388.5 16 256 16V232c0 13.3 10.7 24 24 24H496zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "person-circle-minus": [576, 512, [], "e540", "M160 16a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm0 96A56 56 0 1 0 160 0a56 56 0 1 0 0 112zm-18.9 32h37.8c21.5 0 41.1 12.3 50.4 31.7l50.3 104.2c3.1-5.4 6.5-10.6 10.2-15.6l-46.1-95.5c-12-24.9-37.2-40.7-64.8-40.7H141.1c-27.6 0-52.8 15.8-64.8 40.7L8.8 308.5c-1.9 4-.3 8.8 3.7 10.7s8.8 .3 10.7-3.7L90.7 175.7c9.3-19.4 28.9-31.7 50.4-31.7zM104 248c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 17.7 14.3 32 32 32s32-14.3 32-32V360c0-4.4 3.6-8 8-8s8 3.6 8 8V480c0 17.7 14.3 32 32 32s32-14.3 32-32V248c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 8.8-7.2 16-16 16s-16-7.2-16-16V360c0-13.3-10.7-24-24-24s-24 10.7-24 24V480c0 8.8-7.2 16-16 16s-16-7.2-16-16V248zm328-8a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm80-144c0-4.4-3.6-8-8-8H360c-4.4 0-8 3.6-8 8s3.6 8 8 8H504c4.4 0 8-3.6 8-8z"],
    "scalpel": [512, 512, [], "f61d", "M399.6 35.4C410 23.1 425.3 16 441.4 16C471.5 16 496 40.5 496 70.6v4c0 13.8-4.9 27.2-13.8 37.8L357.1 260.6c-6.1 7.2-15 11.4-24.5 11.4H200L399.6 35.4zM441.4 0c-20.8 0-40.6 9.2-54 25.1L187.8 261.7c-4 4.8-4.9 11.4-2.3 17.1s8.3 9.3 14.5 9.3H332.6c14.1 0 27.6-6.2 36.7-17L494.4 122.7C505.8 109.2 512 92.2 512 74.6v-4C512 31.6 480.4 0 441.4 0zM2.3 498.4c-2.2 2.3-2.9 5.7-1.6 8.7s4.2 4.9 7.4 4.9c17.9 0 95-8.9 167.8-39.6c66-27.9 131.2-75 142.5-152.4H302.1C291 387.6 233.3 430.7 169.6 457.6c-53.9 22.8-110.2 33.1-141 36.8L198.5 320H176.1L2.3 498.4z"],
    "ban": [512, 512, [128683, "cancel"], "f05e", "M420 431.3L80.7 92C40.6 134.9 16 192.6 16 256c0 132.5 107.5 240 240 240c63.4 0 121.1-24.6 164-64.7zM431.3 420C471.4 377.1 496 319.4 496 256C496 123.5 388.5 16 256 16C192.6 16 134.9 40.6 92 80.7L431.3 420zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "bell-exclamation": [448, 512, [], "f848", "M216 8c0-4.4 3.6-8 8-8s8 3.6 8 8V32l0 .2c84.6 4.2 152 74.1 152 159.8v36.6c0 41.8 14.2 82.3 40.3 114.9l16.7 20.9c4.5 5.6 6.9 12.6 6.9 19.8c0 17.5-14.2 31.7-31.7 31.7H31.7C14.2 416 0 401.8 0 384.3c0-7.2 2.4-14.2 6.9-19.8l16.7-20.9C49.8 311 64 270.4 64 228.6V192c0-85.7 67.4-155.6 152-159.8l0-.2V8zm8 40C144.5 48 80 112.5 80 192v36.6c0 45.4-15.5 89.5-43.8 124.9L19.4 374.5c-2.2 2.8-3.4 6.2-3.4 9.8C16 393 23 400 31.7 400H416.3c8.7 0 15.7-7 15.7-15.7c0-3.6-1.2-7-3.4-9.8l-16.7-20.9C383.5 318.1 368 274.1 368 228.6V192c0-79.5-64.5-144-144-144zM176 448c0 12.7 5.1 24.9 14.1 33.9s21.2 14.1 33.9 14.1s24.9-5.1 33.9-14.1s14.1-21.2 14.1-33.9c0-4.4 3.6-8 8-8s8 3.6 8 8c0 17-6.7 33.3-18.7 45.3s-28.3 18.7-45.3 18.7s-33.3-6.7-45.3-18.7s-18.7-28.3-18.7-45.3c0-4.4 3.6-8 8-8s8 3.6 8 8zm32-128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm24-184V264c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "circle-bookmark": [512, 512, ["bookmark-circle"], "e100", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm80-144l-70-56c-5.8-4.7-14.1-4.7-20 0l-70 56V176c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32V368zm-10 12.5c4.8 3.8 11.4 4.6 16.9 1.9s9.1-8.3 9.1-14.4V176c0-26.5-21.5-48-48-48H208c-26.5 0-48 21.5-48 48V368c0 6.2 3.5 11.8 9.1 14.4s12.1 1.9 16.9-1.9l70-56 70 56z"],
    "egg-fried": [512, 512, [], "f7fc", "M474 173.3C510.8 223 500.4 293.1 450.7 330c-15.6 11.6-33.2 18.5-51.1 21c-21.2 3-44.4 12.1-64.7 24.6c-20.2 12.4-39.1 29.2-50.2 48.5C244.9 492.9 156.9 516.5 88 476.7S-4.5 348.9 35.3 280C61.7 234.3 76 168.6 80.4 118.2c2.3-26 13.6-51.4 34-70.9C159 4.4 229.9 5.8 272.7 50.4c16.5 17.2 40.1 34.5 64.7 48.9s51.3 26.4 74.4 32.3c24.1 6.2 46.2 20.3 62.1 41.8zM415.8 116c-42.4-10.9-101.2-45.1-131.5-76.7c-49-51-130-52.6-181-3.6C80.1 58 67.1 87 64.5 116.8C60.2 166.1 46.2 229.1 21.4 272C-22.7 348.5 3.5 446.4 80 490.6s174.4 18 218.6-58.6c18.8-32.5 66.1-60 103.3-65.2c20.5-2.9 40.6-10.8 58.4-24c56.8-42.1 68.7-122.3 26.6-179.1c-18.2-24.6-43.5-40.7-71-47.8zM224 144a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 208a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM176 240c0-26.5 21.5-48 48-48c4.4 0 8-3.6 8-8s-3.6-8-8-8c-35.3 0-64 28.7-64 64c0 4.4 3.6 8 8 8s8-3.6 8-8z"],
    "face-weary": [512, 512, [], "e3a1", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm176 84c-10 10-18 21-23.5 31.5S144 392 144 400l20.5-7.7c28.7-10.8 59.2-16.3 89.9-16.3h3.2c30.7 0 61.1 5.5 89.9 16.3L368 400c0-8-3-18-8.5-28.5S346 350 336 340c-20-20-48-36-80-36s-60 16-80 36zm80-52c37.4 0 69.3 18.7 91.3 40.7c11.1 11.1 20.1 23.4 26.4 35.4c6.2 11.7 10.3 24.4 10.3 35.9c0 5.2-2.6 10.2-6.9 13.2s-9.8 3.7-14.7 1.8l-20.5-7.7c-26.9-10.1-55.5-15.3-84.3-15.3h-3.2c-28.8 0-57.3 5.2-84.3 15.3L149.6 415c-4.9 1.8-10.4 1.2-14.7-1.8s-6.9-7.9-6.9-13.2c0-11.6 4.2-24.2 10.3-35.9c6.3-12 15.3-24.3 26.4-35.4c22-22 53.9-40.7 91.3-40.7zM205.7 170.3c3.1 3.1 3.1 8.2 0 11.3l-7.4 7.4c-22.4 22.4-51.2 37.2-82.5 42.5l-2.5 .4c-4.4 .7-8.5-2.2-9.2-6.6s2.2-8.5 6.6-9.2l2.5-.4c28-4.7 53.8-17.9 73.8-38l7.4-7.4c3.1-3.1 8.2-3.1 11.3 0zm100.7 11.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l7.4 7.4c20 20 45.8 33.3 73.8 38l2.5 .4c4.4 .7 7.3 4.8 6.6 9.2s-4.8 7.3-9.2 6.6l-2.5-.4c-31.3-5.2-60.1-20.1-82.5-42.5l-7.4-7.4z"],
    "uniform-martial-arts": [640, 512, [], "e3d1", "M235.1 16H216c-1.2 0-2.5 .1-3.7 .2c-.5 0-1.1 0-1.6 0c-.9-.1-1.8-.2-2.7-.2H192 172.4c-32.1 0-61.6 17.5-77.1 45.6L28.9 182.3C20.4 197.7 16 214.9 16 232.4V376c0 13.3 10.7 24 24 24H72c13.3 0 24-10.7 24-24V232.4c0-4 1-8 3-11.6l57.3-104.1c1.6-3 3.6-5.7 5.9-8.1c2.2-2.4 5.7-3.2 8.8-2s5.1 4.2 5.1 7.4V304H160V143.1l-47 85.5c-.6 1.2-1 2.5-1 3.9V376c0 22.1-17.9 40-40 40H40c-22.1 0-40-17.9-40-40V232.4c0-20.2 5.1-40.1 14.9-57.8L81.3 53.9C99.5 20.6 134.5 0 172.4 0H192h16c1.2 0 2.5 .1 3.7 .2c1.4-.1 2.9-.2 4.3-.2h23.8 .3H399.8h.3H424c1.5 0 2.9 .1 4.3 .2c1.2-.1 2.4-.2 3.7-.2h16 19.6c37.9 0 72.8 20.6 91.1 53.9l66.4 120.7c9.7 17.7 14.9 37.6 14.9 57.8V376c0 22.1-17.9 40-40 40H568c-22.1 0-40-17.9-40-40V232.4c0-1.3-.3-2.7-1-3.9l-47-85.5V304H464V114.1c0-3.3 2-6.2 5-7.4s6.5-.4 8.8 2c2.3 2.4 4.3 5.2 5.9 8.1L541 220.9l-7 3.9 7-3.9c1.9 3.5 3 7.5 3 11.6V376c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V232.4c0-17.5-4.4-34.8-12.9-50.1L544.7 61.6C529.3 33.5 499.7 16 467.6 16H448 432c-.9 0-1.8 .1-2.7 .2c-.5 .1-1.1 .1-1.6 0c-1.2-.1-2.4-.2-3.7-.2H404.9L327.2 171.5 264.1 304H246.4l64.7-135.9L235.1 16zM160 384h16v80c0 17.7 14.3 32 32 32H432c17.7 0 32-14.3 32-32V384h16v80c0 26.5-21.5 48-48 48H208c-26.5 0-48-21.5-48-48V384zM387.1 16H252.9L320 150.1 387.1 16zM160 336H320 480c4.4 0 8 3.6 8 8s-3.6 8-8 8H334.9l55.7 83.6c2.5 3.7 1.5 8.6-2.2 11.1s-8.6 1.5-11.1-2.2l-57.3-86-57.3 86c-2.5 3.7-7.4 4.7-11.1 2.2s-4.7-7.4-2.2-11.1L305.1 352H160c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "camera-rotate": [640, 512, [], "e0d8", "M260.8 32c-20.7 0-39 13.2-45.5 32.8L204.9 96H128c-35.3 0-64 28.7-64 64V416c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H435.1L424.7 64.8C418.2 45.2 399.8 32 379.2 32H260.8zM230.5 69.9C234.8 56.8 247.1 48 260.8 48H379.2c13.8 0 26 8.8 30.4 21.9l12.2 36.6c1.1 3.3 4.1 5.5 7.6 5.5H512c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H128c-26.5 0-48-21.5-48-48V160c0-26.5 21.5-48 48-48h82.7c3.4 0 6.5-2.2 7.6-5.5l12.2-36.6zM224 312c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8s8-3.6 8-8V339.3L259.7 367c16 16 37.7 25 60.3 25c36.2 0 68-18.5 86.7-46.5c2.4-3.7 1.4-8.6-2.2-11.1s-8.6-1.4-11.1 2.2C377.6 360.4 350.6 376 320 376c-18.4 0-36-7.3-49-20.3L243.3 328H288c4.4 0 8-3.6 8-8s-3.6-8-8-8H224zm200-56V192c0-4.4-3.6-8-8-8s-8 3.6-8 8v44.7L380.3 209c-16-16-37.7-25-60.3-25c-36.2 0-68 18.5-86.7 46.5c-2.4 3.7-1.4 8.6 2.2 11.1s8.6 1.4 11.1-2.2C262.4 215.6 289.4 200 320 200c18.4 0 36 7.3 49 20.3L396.7 248H352c-4.4 0-8 3.6-8 8s3.6 8 8 8h64c4.4 0 8-3.6 8-8z"],
    "sun-dust": [512, 512, [], "f764", "M165.7 2.8c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L121 121 13.1 140.8c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L65.1 256 2.8 346.3c-3.1 4.5-3.7 10.2-1.6 15.2s6.6 8.6 11.9 9.6L121 391l0 0 12.5-12.5c-1.1-1.1-2.6-1.9-4.2-2.2L16 355.4l65.4-94.9c1.9-2.7 1.9-6.3 0-9.1L16 156.6l113.3-20.8c3.3-.6 5.8-3.2 6.4-6.4L156.6 16l94.9 65.4c2.7 1.9 6.3 1.9 9.1 0L355.4 16l20.8 113.3c.3 1.6 1.1 3.1 2.2 4.2L391 121l0 0L371.1 13.1c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L256 65.1 165.7 2.8zM256 144c-61.9 0-112 50.1-112 112c0 30.9 12.5 58.9 32.8 79.2l11.3-11.3C170.7 306.5 160 282.5 160 256c0-53 43-96 96-96c26.5 0 50.5 10.7 67.9 28.1l11.3-11.3C314.9 156.5 286.9 144 256 144zm240 16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-96 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm96 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-96 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM160 496a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm160 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm176-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM240 416a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm96-96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "comment-text": [512, 512, [], "e14d", "M157.3 415c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8C68.3 456 41.6 464 16 464l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C28 450 34 442 40 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C31.9 318.8 16 280.7 16 240C16 136.9 120.2 48 256 48s240 88.9 240 192s-104.2 192-240 192c-35.2 0-68.6-6.1-98.7-17zM4.7 452.7l0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0zM168 176c-4.4 0-8 3.6-8 8s3.6 8 8 8h80V328c0 4.4 3.6 8 8 8s8-3.6 8-8V192h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H256 168z"],
    "spray-can-sparkles": [512, 512, ["air-freshener"], "f5d0", "M136 0h48c22.1 0 40 17.9 40 40v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V40c0-13.3-10.7-24-24-24H136c-13.3 0-24 10.7-24 24v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V40c0-22.1 17.9-40 40-40zM96 176c-44.2 0-80 35.8-80 80V448c0 26.5 21.5 48 48 48H256c26.5 0 48-21.5 48-48V256c0-44.2-35.8-80-80-80H96zM0 256c0-53 43-96 96-96H224c53 0 96 43 96 96V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256zm160 8a72 72 0 1 0 0 144 72 72 0 1 0 0-144zm88 72A88 88 0 1 1 72 336a88 88 0 1 1 176 0zM336 0c4.4 0 8 3.6 8 8V40h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H344V88c0 4.4-3.6 8-8 8s-8-3.6-8-8V56H296c-4.4 0-8-3.6-8-8s3.6-8 8-8h32V8c0-4.4 3.6-8 8-8zM472 8V40h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H472V88c0 4.4-3.6 8-8 8s-8-3.6-8-8V56H424c-4.4 0-8-3.6-8-8s3.6-8 8-8h32V8c0-4.4 3.6-8 8-8s8 3.6 8 8zm-8 184c4.4 0 8 3.6 8 8v32h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H472v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V248H424c-4.4 0-8-3.6-8-8s3.6-8 8-8h32V200c0-4.4 3.6-8 8-8zm-56-88v32h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H408v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V152H360c-4.4 0-8-3.6-8-8s3.6-8 8-8h32V104c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "signal-bars": [640, 512, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", "M560 16c-17.7 0-32 14.3-32 32V464c0 17.7 14.3 32 32 32s32-14.3 32-32V48c0-17.7-14.3-32-32-32zM512 48c0-26.5 21.5-48 48-48s48 21.5 48 48V464c0 26.5-21.5 48-48 48s-48-21.5-48-48V48zM432 464V176c0-17.7-14.3-32-32-32s-32 14.3-32 32V464c0 17.7 14.3 32 32 32s32-14.3 32-32zM400 128c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48s-48-21.5-48-48V176c0-26.5 21.5-48 48-48zM240 272c-17.7 0-32 14.3-32 32V464c0 17.7 14.3 32 32 32s32-14.3 32-32V304c0-17.7-14.3-32-32-32zm-48 32c0-26.5 21.5-48 48-48s48 21.5 48 48V464c0 26.5-21.5 48-48 48s-48-21.5-48-48V304zM112 432c0-17.7-14.3-32-32-32s-32 14.3-32 32v32c0 17.7 14.3 32 32 32s32-14.3 32-32V432zm-80 0c0-26.5 21.5-48 48-48s48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V432z"],
    "diamond-exclamation": [512, 512, [], "e405", "M273 23c-9.4-9.4-24.6-9.4-33.9 0L23 239c-9.4 9.4-9.4 24.6 0 33.9L239 489c9.4 9.4 24.6 9.4 33.9 0L489 273c9.4-9.4 9.4-24.6 0-33.9L273 23zM227.7 11.7c15.6-15.6 40.9-15.6 56.6 0l216 216c15.6 15.6 15.6 40.9 0 56.6l-216 216c-15.6 15.6-40.9 15.6-56.6 0l-216-216c-15.6-15.6-15.6-40.9 0-56.6l216-216zM256 128c4.4 0 8 3.6 8 8V296c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-4.4 3.6-8 8-8zM240 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "star": [576, 512, [11088, 61446], "f005", "M212.1 161.8L280.7 20.5c1.3-2.8 4.1-4.5 7.2-4.5s5.9 1.7 7.2 4.5l68.6 141.3c2.3 4.8 6.8 8.1 12.1 8.8L529 193.3c3 .4 5.5 2.5 6.4 5.4s.2 6-2 8.2L422.4 317c-3.7 3.7-5.4 8.9-4.5 14l26.2 155.6c.5 3-.7 6-3.2 7.8s-5.8 2-8.4 .6l-137-73.2c-4.7-2.5-10.4-2.5-15.1 0L143.4 495c-2.7 1.4-6 1.2-8.4-.6s-3.7-4.8-3.2-7.8L158 331c.9-5.1-.8-10.4-4.5-14L42.4 206.9 31.2 218.1l11.2-11.3c-2.2-2.1-2.9-5.3-2-8.2s3.4-5 6.4-5.4l153.2-22.6c5.2-.8 9.7-4.1 12.1-8.8zM424.9 509.1c8.1 4.3 17.9 3.7 25.3-1.7s11.2-14.5 9.7-23.5L433.6 328.4 544.8 218.2c6.5-6.4 8.7-15.9 5.9-24.5s-10.3-14.9-19.3-16.3L378.1 154.8 309.5 13.5C305.5 5.2 297.1 0 287.9 0s-17.6 5.2-21.6 13.5L197.7 154.8 44.5 177.5c-9 1.3-16.5 7.6-19.3 16.3s-.5 18.1 5.9 24.5L142.2 328.4 116 483.9c-1.5 9 2.2 18.1 9.7 23.5s17.3 6 25.3 1.7l137-73.2 137 73.2z"],
    "dial-min": [576, 512, [], "e161", "M272 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM282.3 282.3L180.7 384c-50.7-56.5-48.8-143.5 5.5-197.8c56.2-56.2 147.4-56.2 203.6 0s56.2 147.4 0 203.6C335.5 444.2 248.5 446 192 395.3L293.7 293.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0zM174.9 401.1A160 160 0 1 0 401.1 174.9 160 160 0 1 0 174.9 401.1zM544 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM16 288a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0A32 32 0 1 0 0 288a32 32 0 1 0 64 0zM96 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM464 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 464a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm368-32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "repeat": [512, 512, [128257], "f363", "M347.3 176c3 0 5.9-1.2 8-3.3L432 96 355.3 19.3c-2.1-2.1-5-3.3-8-3.3c-6.2 0-11.3 5.1-11.3 11.3L336 96v68.7c0 6.2 5.1 11.3 11.3 11.3zM320 164.7V104H168C84.1 104 16 172.1 16 256v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8C0 163.2 75.2 88 168 88H320V27.3C320 12.2 332.2 0 347.3 0c7.2 0 14.2 2.9 19.3 8l76.7 76.7c3 3 4.7 7.1 4.7 11.3s-1.7 8.3-4.7 11.3L366.6 184c-5.1 5.1-12.1 8-19.3 8c-15.1 0-27.3-12.2-27.3-27.3zM164.7 336c-3 0-5.9 1.2-8 3.3L80 416l76.7 76.7c2.1 2.1 5 3.3 8 3.3c6.2 0 11.3-5.1 11.3-11.3l0-68.7V347.3c0-6.2-5.1-11.3-11.3-11.3zM192 347.3V408H344c83.9 0 152-68.1 152-152v-8c0-4.4 3.6-8 8-8s8 3.6 8 8v8c0 92.8-75.2 168-168 168H192v60.7c0 15.1-12.2 27.3-27.3 27.3c-7.2 0-14.2-2.9-19.3-8L68.7 427.3c-3-3-4.7-7.1-4.7-11.3s1.7-8.3 4.7-11.3L145.4 328c5.1-5.1 12.1-8 19.3-8c15.1 0 27.3 12.2 27.3 27.3z"],
    "cross": [384, 512, [128327, 10013], "f654", "M128 32c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32v96h96c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H256V480c0 17.7-14.3 32-32 32H160c-17.7 0-32-14.3-32-32V256H32c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32h96V32zm32-16c-8.8 0-16 7.2-16 16V136c0 4.4-3.6 8-8 8H32c-8.8 0-16 7.2-16 16v64c0 8.8 7.2 16 16 16H136c4.4 0 8 3.6 8 8V480c0 8.8 7.2 16 16 16h64c8.8 0 16-7.2 16-16V248c0-4.4 3.6-8 8-8H352c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16H248c-4.4 0-8-3.6-8-8V32c0-8.8-7.2-16-16-16H160z"],
    "page-caret-down": [384, 512, ["file-caret-down"], "e429", "M320 496H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H245.5c12.7 0 24.9 5.1 33.9 14.1l74.5 74.5c9 9 14.1 21.2 14.1 33.9V448c0 26.5-21.5 48-48 48zM64 512H320c35.3 0 64-28.7 64-64V138.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0H64C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64zM267.7 253.4L192 336l-75.7-82.6c-4.7-5.1-1.1-13.4 5.9-13.4l139.6 0c7 0 10.6 8.3 5.9 13.4zm-87.5 93.4c3 3.3 7.3 5.2 11.8 5.2s8.8-1.9 11.8-5.2l75.7-82.6c14.1-15.4 3.2-40.2-17.7-40.2l-139.6 0c-20.9 0-31.8 24.8-17.7 40.2l75.7 82.6z"],
    "box": [448, 512, [128230], "f466", "M342.4 48H232V176H430c-.6-2-1.3-4-2.2-5.9L386.3 76.5C378.6 59.2 361.4 48 342.4 48zM432 192H16V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V192zM18 176H216V48H105.6c-19 0-36.2 11.2-43.9 28.5L20.1 170.1c-.9 1.9-1.6 3.9-2.2 5.9zM342.4 32c25.3 0 48.2 14.9 58.5 38l41.6 93.6c3.6 8.2 5.5 17 5.5 26V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V189.6c0-9 1.9-17.8 5.5-26L47.1 70c10.3-23.1 33.2-38 58.5-38H342.4z"],
    "venus-mars": [640, 512, [9892], "f228", "M176 336a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM352 176c0 94.5-74.5 171.6-168 175.8V416h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H184v72c0 4.4-3.6 8-8 8s-8-3.6-8-8V432H88c-4.4 0-8-3.6-8-8s3.6-8 8-8h80V351.8C74.5 347.6 0 270.5 0 176C0 78.8 78.8 0 176 0s176 78.8 176 176zM286.2 352.5c29 29.4 69.3 47.5 113.8 47.5c88.4 0 160-71.6 160-160s-71.6-160-160-160c-12.8 0-25.3 1.5-37.2 4.4c-2.4-5-5.1-9.8-7.9-14.5C369.3 66 384.4 64 400 64c45.7 0 87.4 17.4 118.7 46l94-94H488c-4.4 0-8-3.6-8-8s3.6-8 8-8H632c4.4 0 8 3.6 8 8V152c0 4.4-3.6 8-8 8s-8-3.6-8-8V27.3l-94 94c28.6 31.3 46 72.9 46 118.7c0 97.2-78.8 176-176 176c-50.5 0-96-21.3-128.1-55.4c4.9-2.5 9.7-5.3 14.3-8.2z"],
    "clock-seven-thirty": [512, 512, [], "e351", "M16 256a240 240 0 1 0 480 0A240 240 0 1 0 16 256zm496 0A256 256 0 1 1 0 256a256 256 0 1 1 512 0zM248 408V282.4l-49.3 74c-2.5 3.7-7.4 4.7-11.1 2.2s-4.7-7.4-2.2-11.1l64-96c2-2.9 5.6-4.2 9-3.2s5.7 4.1 5.7 7.7V408c0 4.4-3.6 8-8 8s-8-3.6-8-8z"],
    "arrow-pointer": [320, 512, ["mouse-pointer"], "f245", "M144 304H297.9c3.4 0 6.1-2.7 6.1-6.1c0-1.7-.7-3.4-2-4.5L28 49.8c-1.3-1.2-3-1.8-4.8-1.8c-4 0-7.2 3.2-7.2 7.2V426c0 3.3 2.7 6 6 6c1.7 0 3.4-.7 4.5-2.1L132 309.5c3-3.5 7.4-5.5 12-5.5zM0 426V55.2C0 42.4 10.4 32 23.2 32c5.7 0 11.2 2.1 15.4 5.9l274 243.6c4.7 4.2 7.4 10.2 7.4 16.5c0 12.2-9.9 22.1-22.1 22.1H152.9l70.4 148.6c1.9 4 .2 8.8-3.8 10.7s-8.8 .2-10.7-3.8L138.3 326.6 38.6 440.5C34.4 445.3 28.4 448 22 448c-12.2 0-22-9.9-22-22z"],
    "clock-four-thirty": [512, 512, [], "e34b", "M16 256a240 240 0 1 1 480 0A240 240 0 1 1 16 256zm496 0A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM264 408V270.9l83.6 55.7c3.7 2.5 8.6 1.5 11.1-2.2s1.5-8.6-2.2-11.1l-96-64c-2.5-1.6-5.6-1.8-8.2-.4s-4.2 4.1-4.2 7.1V408c0 4.4 3.6 8 8 8s8-3.6 8-8z"],
    "signal-bars-good": [640, 512, ["signal-alt-3"], "f693", "M432 176c0-17.7-14.3-32-32-32s-32 14.3-32 32V464c0 17.7 14.3 32 32 32s32-14.3 32-32V176zm-80 0c0-26.5 21.5-48 48-48s48 21.5 48 48V464c0 26.5-21.5 48-48 48s-48-21.5-48-48V176zM272 304c0-17.7-14.3-32-32-32s-32 14.3-32 32V464c0 17.7 14.3 32 32 32s32-14.3 32-32V304zm-32-48c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48s-48-21.5-48-48V304c0-26.5 21.5-48 48-48zM112 464V432c0-17.7-14.3-32-32-32s-32 14.3-32 32v32c0 17.7 14.3 32 32 32s32-14.3 32-32zM80 384c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V432c0-26.5 21.5-48 48-48z"],
    "cactus": [512, 512, [127797], "f8a7", "M336 464c0 17.7-14.3 32-32 32H208c-17.7 0-32-14.3-32-32V320 304 240 224 96c0-44.2 35.8-80 80-80s80 35.8 80 80V352v16 64 16 16zm16-112V96c0-53-43-96-96-96s-96 43-96 96V224H112c-8.8 0-16-7.2-16-16V144c0-26.5-21.5-48-48-48S0 117.5 0 144v64c0 61.9 50.1 112 112 112h48V464c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V448h48c61.9 0 112-50.1 112-112V272c0-26.5-21.5-48-48-48s-48 21.5-48 48v64c0 8.8-7.2 16-16 16H352zm0 16h48c17.7 0 32-14.3 32-32V272c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 53-43 96-96 96H352V368zM112 304c-53 0-96-43-96-96V144c0-17.7 14.3-32 32-32s32 14.3 32 32v64c0 17.7 14.3 32 32 32h48v64H112zM256 144a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm16 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "lightbulb-gear": [576, 512, [], "e5fd", "M192 0c97 0 175.6 78.4 176 175.3c-6.5 2.8-12 7-16.4 12.1c.3-3.8 .4-7.5 .4-11.4c0-88.4-71.6-160-160-160S32 87.6 32 176c0 33.9 10.5 65.3 28.5 91.2c4.5 6.5 9.5 13.3 14.5 20.2l0 0 0 0c12.5 17.2 25.9 35.5 36.3 54.4c7.4 13.5 11.6 27.8 14 42.2H109c-2.2-12-5.9-23.7-11.8-34.5c-9.9-18-22.2-34.9-34.5-51.8l0 0 0 0 0 0c-5.2-7.1-10.4-14.2-15.4-21.4C27.6 247.9 16 213.3 16 176C16 78.8 94.8 0 192 0zM122.7 416h123c2 5.4 4.3 10.7 6.9 16H128c0 35.3 28.7 64 64 64c33.3 0 60.6-25.4 63.7-57.9c.9 1.7 1.8 3.3 2.7 4.9c2.9 5 6 9.9 9.4 14.6C257.1 489.2 227.2 512 192 512c-44.2 0-80-35.8-80-80v-5.3c0-5.9 4.8-10.7 10.7-10.7zM184 80c-48.6 0-88 39.4-88 88c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-57.4 46.6-104 104-104c4.4 0 8 3.6 8 8s-3.6 8-8 8zM388 218.5v17.8c0 13.9-8.4 25.7-19.6 32.1c-11.1 6.3-25.3 7.7-37.3 .8l-13.9-8c-6.4 7-12.2 14.9-17.2 23.5s-8.9 17.5-11.8 26.6l14.3 8.3c11.8 6.8 17.3 19.6 17.3 32c0 12.4-5.5 25.2-17.3 32l-14.3 8.2c2.9 9.1 6.8 18 11.8 26.6s10.8 16.5 17.2 23.5l13.9-8c11.9-6.9 26.2-5.5 37.3 .8c11.2 6.4 19.6 18.1 19.6 32.1v17.8c9 2 18.4 3 28.1 3s19-1 28.1-3l0-18.1c0-13.8 8.3-25.5 19.4-31.8c11-6.3 25.2-7.7 37.1-.8l14.1 8.2c6.4-7 12.2-14.9 17.2-23.5c5-8.6 8.9-17.5 11.8-26.6l-14.6-8.4c-11.8-6.8-17.2-19.5-17.2-31.8s5.5-25 17.2-31.8l14.6-8.4c-2.9-9.1-6.8-18-11.8-26.6c-5-8.6-10.8-16.5-17.2-23.5l-14.1 8.1c-11.9 6.9-26.1 5.5-37.1-.8c-11.1-6.4-19.4-18-19.4-31.8V218.5c-9-2-18.4-3-28.1-3s-19 1-28.1 3zm-4.7-15.4c10.5-2.4 21.5-3.7 32.7-3.7s22.2 1.3 32.7 3.7c6.7 1.5 11.3 7.7 11.3 14.8v18.7c0 7.1 4.3 13.9 11.4 18c7 4 15.1 4.4 21.2 .8l14.6-8.4c6.1-3.5 13.8-2.6 18.5 2.4c7.6 8.1 14.3 17.2 20.1 27.2s10.3 20.4 13.5 31c2 6.6-1 13.7-7.2 17.2l-15.1 8.7c-5.8 3.3-9.2 10.1-9.2 18s3.5 14.6 9.2 18l15.1 8.7c6.1 3.5 9.2 10.6 7.2 17.2c-3.3 10.6-7.8 21-13.5 31s-12.5 19.1-20.1 27.2c-4.7 5.1-12.4 5.9-18.5 2.4l-14.6-8.4c-6.1-3.5-14.2-3.2-21.2 .8c-7 4-11.4 10.9-11.4 18l0 18.7c0 7.1-4.6 13.3-11.3 14.8c-10.5 2.4-21.5 3.7-32.7 3.7s-22.2-1.3-32.7-3.7c-6.7-1.5-11.3-7.7-11.3-14.8V466.7c0-7.2-4.4-14.1-11.5-18.2c-7.1-4-15.2-4.4-21.3-.8L324.8 456c-6.1 3.5-13.8 2.6-18.5-2.4c-7.6-8.1-14.3-17.2-20.1-27.2s-10.3-20.4-13.5-31c-2-6.6 1-13.7 7.2-17.2l14.8-8.5c5.8-3.4 9.3-10.2 9.3-18.2c0-8-3.5-14.8-9.3-18.1l-14.8-8.5c-6.1-3.5-9.2-10.6-7.2-17.2c3.3-10.6 7.7-21 13.5-31s12.5-19.1 20.1-27.2c4.7-5.1 12.4-5.9 18.5-2.4l14.4 8.3c6.2 3.6 14.3 3.2 21.4-.8c7.1-4.1 11.5-11 11.5-18.2V218c0-7.1 4.6-13.3 11.3-14.8zM416 383.7a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "maximize": [512, 512, ["expand-arrows-alt"], "f31e", "M54.7 181.2l-.6-.2 0 0c-3.6-.9-6.1-4.1-6.1-7.8L48 56c0-4.4 3.6-8 8-8l117.3 0c3.7 0 6.9 2.5 7.8 6.1l.2 .6c.7 2.7-.1 5.6-2.1 7.6L62.3 179.1c-2 2-4.9 2.8-7.6 2.1l0 0zM32 173.3c0 11 7.5 20.6 18.2 23.3l.6 .2c8.2 2 16.8-.4 22.8-6.3l52.7-52.7L244.7 256 126.3 374.3 73.6 321.6c-6-6-14.6-8.4-22.8-6.3l-.6 .2C39.5 318.1 32 327.7 32 338.7V456c0 13.3 10.7 24 24 24l117.3 0c11 0 20.6-7.5 23.3-18.2l.2-.6c2-8.2-.4-16.8-6.3-22.8l-52.7-52.7L256 267.3 374.3 385.7l-52.7 52.7c-6 6-8.4 14.6-6.3 22.8l.2 .6c2.7 10.7 12.3 18.2 23.3 18.2L456 480c13.3 0 24-10.7 24-24l0-117.3c0-11-7.5-20.6-18.2-23.3l-.6-.2c-8.2-2-16.8 .4-22.8 6.3l-52.7 52.7L267.3 256 385.7 137.7l52.7 52.7c6 6 14.6 8.4 22.8 6.3l.6-.2c10.7-2.7 18.2-12.3 18.2-23.3L480 56c0-13.3-10.7-24-24-24H338.7c-11 0-20.6 7.5-23.3 18.2l-.2 .6c-2 8.2 .4 16.8 6.3 22.8l52.7 52.7L256 244.7 137.7 126.3l52.7-52.7c6-6 8.4-14.6 6.3-22.8l-.2-.6C193.9 39.5 184.3 32 173.3 32H56C42.7 32 32 42.7 32 56V173.3zM54.7 330.8c2.7-.7 5.6 .1 7.6 2.1L179.1 449.7c2 2 2.8 4.9 2.1 7.6l-.2 .6c-.9 3.6-4.1 6.1-7.8 6.1L56 464c-4.4 0-8-3.6-8-8l0-117.3c0-3.7 2.5-6.9 6.1-7.8l.6-.2zM457.9 181l-.6 .2c-2.7 .7-5.6-.1-7.6-2.1L332.9 62.3c-2-2-2.8-4.9-2.1-7.6l.2-.6c.9-3.6 4.1-6.1 7.8-6.1L456 48c4.4 0 8 3.6 8 8l0 117.3c0 3.7-2.5 6.9-6.1 7.8zm-.6 149.8l.6 .2c3.6 .9 6.1 4.1 6.1 7.8L464 456c0 4.4-3.6 8-8 8l-117.3 0c-3.7 0-6.9-2.5-7.8-6.1l-.2-.6c-.7-2.7 .1-5.6 2.1-7.6L449.7 332.9c2-2 4.9-2.8 7.6-2.1z"],
    "charging-station": [576, 512, [], "f5e7", "M96 16C69.5 16 48 37.5 48 64V416H304V64c0-26.5-21.5-48-48-48H96zM48 432v64H304V432H48zM32 496V64C32 28.7 60.7 0 96 0H256c35.3 0 64 28.7 64 64V272h8c39.8 0 72 32.2 72 72v44c0 24.3 19.7 44 44 44s44-19.7 44-44V255.6c-40.4-4-72-38.1-72-79.6V152c0-13.3 10.7-24 24-24h8V72c0-4.4 3.6-8 8-8s8 3.6 8 8v56h64V72c0-4.4 3.6-8 8-8s8 3.6 8 8v56h8c13.3 0 24 10.7 24 24v24c0 41.5-31.6 75.6-72 79.6V388c0 33.1-26.9 60-60 60s-60-26.9-60-60V344c0-30.9-25.1-56-56-56h-8V496l24 0c4.4 0 8 3.6 8 8s-3.6 8-8 8H320 304 48 32 8c-4.4 0-8-3.6-8-8s3.6-8 8-8l24 0zM536 144H456 440c-4.4 0-8 3.6-8 8v24c0 35.3 28.7 64 64 64s64-28.7 64-64V152c0-4.4-3.6-8-8-8H536zM196.8 105.6c3.5 2.7 4.3 7.7 1.6 11.2L136 200h96c3 0 5.8 1.7 7.2 4.4s1.1 6-.8 8.4l-72 96c-2.7 3.5-7.7 4.3-11.2 1.6s-4.3-7.7-1.6-11.2L216 216H120c-3 0-5.8-1.7-7.2-4.4s-1.1-6 .8-8.4l72-96c2.7-3.5 7.7-4.3 11.2-1.6z"],
    "shapes": [512, 512, ["triangle-circle-square"], "f61f", "M301.7 23.8c-2.9-4.8-8.1-7.8-13.7-7.8s-10.8 2.9-13.7 7.8l-96 160c-3 4.9-3 11.1-.2 16.1s8.2 8.1 13.9 8.1H384c5.8 0 11.1-3.1 13.9-8.1s2.8-11.2-.2-16.1l-96-160zM288 0c11.2 0 21.7 5.9 27.4 15.5l96 160c5.9 9.9 6.1 22.2 .4 32.2s-16.3 16.2-27.8 16.2H192c-11.5 0-22.2-6.2-27.8-16.2s-5.5-22.3 .4-32.2l96-160C266.3 5.9 276.8 0 288 0zM472 288H328c-13.3 0-24 10.7-24 24V456c0 13.3 10.7 24 24 24H472c13.3 0 24-10.7 24-24V312c0-13.3-10.7-24-24-24zM328 272H472c22.1 0 40 17.9 40 40V456c0 22.1-17.9 40-40 40H328c-22.1 0-40-17.9-40-40V312c0-22.1 17.9-40 40-40zM240 384A112 112 0 1 0 16 384a112 112 0 1 0 224 0zM0 384a128 128 0 1 1 256 0A128 128 0 1 1 0 384z"],
    "plane-tail": [512, 512, [], "e22c", "M39.4 16h62.1c14.9 0 29.1 5.9 39.6 16.4L364.7 256H264.1c-6.1 0-12.1 .8-18 2.3L70.4 303.6 16 44.9C12.8 30 24.2 16 39.4 16zM.3 48.2L54.9 307.6l-4.3 1.1C20.8 316.4 0 343.3 0 374c0 28.5 18 54 44.9 63.5l198.1 70.3c7.7 2.7 15.9 4.1 24.1 4.1H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H267c-6.4 0-12.7-1.1-18.7-3.2L50.2 422.5C29.7 415.2 16 395.8 16 374c0-23.4 15.9-43.9 38.6-49.8l195.6-50.5c4.6-1.2 9.3-1.8 14-1.8H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H387.3l-5.7-5.7L152.4 21.1C138.9 7.6 120.6 0 101.5 0H39.4C14 0-4.9 23.4 .3 48.2zM200 368c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H200z"],
    "gauge-simple-max": [512, 512, ["tachometer-fastest"], "f62b", "M256 496a240 240 0 1 0 0-480 240 240 0 1 0 0 480zM256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zm0 400a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0 16c-35.3 0-64-28.7-64-64s28.7-64 64-64c18.8 0 35.7 8.1 47.4 21l108-75.6c3.6-2.5 8.6-1.7 11.1 2s1.7 8.6-2 11.1l-108 75.6c4.7 8.9 7.4 19.1 7.4 29.9c0 35.3-28.7 64-64 64z"],
    "circle-u": [512, 512, [], "e127", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 152c0-4.4-3.6-8-8-8s-8 3.6-8 8V288c0 61.9 50.1 112 112 112s112-50.1 112-112V152c0-4.4-3.6-8-8-8s-8 3.6-8 8V288c0 53-43 96-96 96s-96-43-96-96V152z"],
    "shield-slash": [640, 512, [], "e24b", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM424.9 430.5c-23.8 22.4-52 42.2-85.4 58.2c-12.3 5.9-26.7 5.9-39 0C153.3 418.2 106 271.3 97.5 172.1l-17-13.4c5.3 101.9 51.1 266.9 213.1 344.5c16.7 8 36.1 8 52.8 0c35.8-17.1 65.9-38.5 91.2-62.6l-12.7-10zM295 7.8L182.4 55.6l14.3 11.3L301.3 22.6c12-5.1 25.5-5.1 37.5 0l176.7 75c16.6 7.1 28.6 23.2 28.5 42.4c-.2 46.1-9.4 109.7-36.8 172.2l13 10.2C550 256 559.8 188.2 560 140c.1-26.2-16.3-47.9-38.3-57.2L345 7.8c-16-6.8-34-6.8-50 0z"],
    "square-phone-hangup": [448, 512, ["phone-square-down"], "e27a", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zm64 48c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96zM75.7 240.8c81.8-75.8 214.8-75.8 296.6 0c4.1 3.8 4.8 9.3 2.1 13.7l-21.7 35.2c-3.2 5.1-10.4 7.7-17 5.2l-46.2-17.6c-5.7-2.2-8.5-7.2-8-11.9l2.9-26.7c.4-3.8-1.9-7.3-5.5-8.5c-35.4-11.4-74.1-11.4-109.4 0c-3.6 1.2-5.9 4.7-5.5 8.5l2.9 26.7c.5 4.8-2.4 9.8-8 11.9L112.4 295c-6.6 2.5-13.9-.1-17-5.2L73.6 254.6c-2.7-4.4-2-10 2.1-13.7zm307.5-11.7c-88-81.5-230.4-81.5-318.3 0c-9.5 8.8-11.7 22.8-4.8 33.9l21.7 35.2c7.5 12.1 23.1 16.8 36.4 11.8l46.2-17.6c11.8-4.5 19.6-16 18.2-28.6l-2.2-20c28.4-7.9 58.8-7.9 87.2 0l-2.2 20c-1.4 12.7 6.4 24.1 18.2 28.6L329.9 310c13.3 5.1 28.9 .4 36.4-11.8L388 263c6.9-11.1 4.7-25.1-4.8-33.9z"],
    "arrow-up-left": [384, 512, [], "e09d", "M40 96c-4.4 0-8 3.6-8 8V344c0 4.4 3.6 8 8 8s8-3.6 8-8V123.3L338.3 413.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L59.3 112H280c4.4 0 8-3.6 8-8s-3.6-8-8-8H40z"],
    "transporter-1": [512, 512, [], "e043", "M256 16l-.4 0c-.3 0-.6 0-.9 0c-17 .7-30.6 14.8-30.6 32c0 17.7 14.3 32 32 32s32-14.3 32-32s-14.3-32-32-32zm0 80h0c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48s-21.5 48-48 48zm216 40v32h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H472v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V184H424c-4.4 0-8-3.6-8-8s3.6-8 8-8h32V136c0-4.4 3.6-8 8-8s8 3.6 8 8zM56 328v32H88c4.4 0 8 3.6 8 8s-3.6 8-8 8H56v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V376H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H40V328c0-4.4 3.6-8 8-8s8 3.6 8 8zm56 168v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-26.5 21.5-48 48-48H368c26.5 0 48 21.5 48 48v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-17.7-14.3-32-32-32H144c-17.7 0-32 14.3-32 32zM235.6 144c-24.3 0-47.2 11-62.4 30l-57.7 72c-5.5 6.9-4.4 17 2.5 22.5s17 4.4 22.5-2.5l45.3-56.5c2.1-2.7 5.7-3.7 8.9-2.5s5.3 4.2 5.3 7.5V288H184V237.3L153 276c-6.3 7.8-15.4 11.9-24.7 12h-.5c-6.9-.1-13.9-2.4-19.7-7c-13.8-11.1-16-31.2-5-45l57.7-72c18.2-22.7 45.8-36 74.9-36h40.7c29.1 0 56.7 13.2 74.9 36L409 236c11 13.8 8.8 33.9-5 45c-5.8 4.7-12.8 7-19.7 7h-.5c-9.3-.1-18.5-4.2-24.7-12l-31-38.7V288H312V214.5c0-3.4 2.1-6.4 5.3-7.5s6.8-.1 8.9 2.5L371.5 266c5.5 6.9 15.6 8 22.5 2.5s8-15.6 2.5-22.5l-57.7-72c-15.2-18.9-38.1-30-62.4-30H235.6zM160 392c0-4.4 3.6-8 8-8H344c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8zm8-72H344c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "peanuts": [640, 512, [129372], "e431", "M314.5 117.8c-1.5-7.3-3.8-14.5-7-21.6L284.8 45.3C273.6 20.1 244.1 8.8 219 20L168.1 42.7c-13.1 5.8-24.4 14-33.7 23.8l0 0c-9.2 9.7-16.8 21.4-21.9 34.7l-.2 .4 0 0c-5.1 13.3-7.3 27-6.9 40.4l0 0c.2 7.4 1.2 14.8 3 22.1l.1 .2 0 0c4.7 20.6 8 45.5-1.1 69.1s-28.2 39.9-45.5 52.1l-.2 .1 0 0c-6.2 4.3-11.9 9.1-17 14.4l0 0c-9.3 9.8-16.8 21.5-22 34.9c-5.1 13.4-7.4 27.2-7 40.6l0 0c.3 13.5 3.3 27.1 9.1 40.2l22.7 50.9c11.2 25.2 40.7 36.5 65.9 25.3l0 0c2.9 4.5 6.1 8.8 9.6 12.9l-3.2 1.4c-33.1 14.7-71.8-.2-86.6-33.2L10.5 422.2C3.8 407.2 .4 391.5 0 376c-.4-15.5 2.2-31.3 8-46.6C14 314 22.7 300.5 33.4 289.3c5.8-6.1 12.3-11.7 19.5-16.6c16.7-11.8 32.5-25.8 39.8-44.9s5-40.1 .4-60c-2.1-8.4-3.2-17-3.4-25.4c-.4-15.4 2.1-31.1 7.9-46.4l.2-.5c5.9-15.3 14.5-28.7 25.2-39.9c10.7-11.2 23.6-20.6 38.7-27.3L212.6 5.7c33.1-14.7 71.8 .1 86.6 33.2l22.5 50.6c-2.9 8.4-5.1 17.1-6.7 26c-.2 .8-.3 1.6-.5 2.3zM252.3 234.1l0 0c-9.3 1.7-18.2 4.3-26.7 7.9l0 0c-15.6 6.4-30.2 16-42.9 28.7c-12.7 12.7-22.2 27.3-28.6 42.8l0 0c-6.4 15.5-10 32.6-10 50.5v68c0 35.3 28.7 64 64 64h68c36.8 0 70.1-15.1 94.1-39.4l0 0c12.3-12.5 21.6-26.8 27.9-42.1l0 0c3.5-8.5 6.2-17.5 7.9-26.8l0-.2 0 0c5-25.2 13.5-53.8 34.6-74.9s49.7-29.7 74.9-34.6l.2 0 0 0c9.3-1.7 18.2-4.3 26.7-7.9l0 0c15.6-6.4 30.2-16 42.9-28.7c12.7-12.7 22.2-27.3 28.6-42.8l0 0c6.4-15.5 10-32.6 10-50.5V80c0-35.3-28.7-64-64-64H492c-36.8 0-70.1 15.1-94.1 39.4l0 0C385.6 67.9 376.3 82.3 370 97.5l0 0c-3.5 8.5-6.2 17.5-7.9 26.8l0 .2 0 0c-5 25.2-13.5 53.8-34.6 74.9s-49.7 29.7-74.9 34.6l-.2 0zm-113 73.2c7.2-17.5 17.9-33.8 32.1-48c14.2-14.2 30.6-24.9 48.1-32.1c9.5-4 19.6-6.9 30-8.8c24.5-4.8 49.1-12.6 66.7-30.3s25.4-42.2 30.3-66.7c1.9-10.4 4.9-20.5 8.8-30c7.1-17.1 17.5-33.2 31.3-47.2C413.3 16.9 450.7 0 492 0h68c44.2 0 80 35.8 80 80v68c0 20.1-4 39.2-11.2 56.7c-7.2 17.5-17.9 33.8-32.1 48c-14.2 14.2-30.6 24.9-48.1 32.1c-9.5 4-19.6 6.9-30 8.8c-24.5 4.8-49.1 12.6-66.7 30.3s-25.4 42.2-30.3 66.7c-1.9 10.4-4.9 20.5-8.8 30c-7.1 17.1-17.5 33.2-31.3 47.2C354.7 495.1 317.3 512 276 512H208c-44.2 0-80-35.8-80-80V364c0-20.1 4-39.2 11.2-56.7zM544 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-64 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM320 336a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-80 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM528 192a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "shuffle": [512, 512, [128256, "random"], "f074", "M410.3 466.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3l-88-88c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L484.7 376H344c-12.6 0-24.4-5.9-32-16L144 136c-7.6-10.1-19.4-16-32-16H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H112c7.6 0 14.7 3.6 19.2 9.6l168 224C309.8 383.7 326.4 392 344 392H484.7l-74.3 74.3zM144 376l60-80-10-13.3-62.8 83.7c-4.5 6-11.6 9.6-19.2 9.6H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H112c12.6 0 24.4-5.9 32-16zM254 229.3L312 152c7.6-10.1 19.4-16 32-16H484.7l-74.3 74.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3l-88-88c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L484.7 120H344c-17.6 0-34.2 8.3-44.8 22.4L244 216l10 13.3z"],
    "person-running": [448, 512, [127939, "running"], "f70c", "M181.9 156c-2-3.9-5.6-6.7-9.8-7.9l-8.8-2.5c-3.7-1.1-7.6-1.6-11.5-1.6c-11.1 0-21.7 4.4-29.5 12.2L91.3 187.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l31.1-31.1c13.8-13.8 32.6-21.6 52.1-21.6c6.9 0 13.7 1 20.3 2.8l90.7 25.9c12.9 3.7 23.7 12.7 29.7 24.7l32.9 65.7c2.7 5.4 8.2 8.8 14.3 8.8H384c8.8 0 16 7.2 16 16s-7.2 16-16 16H339.8c-18.2 0-34.8-10.3-42.9-26.5L281 213.7c-2.8-5.7-8.7-9.1-15.1-8.8s-11.9 4.3-14.2 10.2l-30 77.3c-2.8 7.2-.1 15.3 6.4 19.4l47.9 30c18.1 11.3 26.6 33.3 20.7 53.9l-25.4 88.8c-2.4 8.5-11.3 13.4-19.8 11s-13.4-11.3-11-19.8L266 386.8c2-6.9-.9-14.2-6.9-18l-86.2-53.9c-18.8-11.8-27.1-34.8-20.1-55.9l30.2-90.5c1.4-4.1 1-8.7-1-12.5zM88.5 122.3L57.4 153.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l31.1-31.1c4.8-4.8 11.4-7.5 18.2-7.5l.2 0c2.3 0 4.7 .3 6.9 1l8.8 2.5-5.1 15.2L137.6 254c-9.3 28 1.7 58.8 26.8 74.5l86.2 53.9-25.4 88.8c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22L312.2 400c7.8-27.4-3.4-56.7-27.6-71.9l-47.9-30L258.8 241l7.8-20.1 9.7 19.3 6.2 12.4c10.8 21.7 33 35.4 57.2 35.4H384c17.7 0 32-14.3 32-32s-14.3-32-32-32H339.8l-32.9-65.7c-8-16-22.4-28-39.7-32.9L176.6 99.5c-8-2.3-16.3-3.5-24.7-3.5c-23.8 0-46.6 9.5-63.5 26.3zM240 48a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM97.6 352H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H97.6c26.8 0 50.8-16.8 60.1-42l3.6-9.7-13.9-8.7 0 0-4.7 12.9c-6.9 18.9-24.9 31.5-45.1 31.5H32c-8.8 0-16-7.2-16-16s7.2-16 16-16H97.6h11.2l3.8-10.5 9.2-25.2c-4.2-5.5-7.7-11.4-10.6-17.6L97.6 352z"],
    "mobile-retro": [320, 512, [], "e527", "M240 16c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H80c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H240zM80 0C44.7 0 16 28.7 16 64V448c0 35.3 28.7 64 64 64H240c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H80zM224 144c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V160c0-8.8 7.2-16 16-16H224zM96 128c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32H224c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H96zM72 328a8 8 0 1 1 16 0 8 8 0 1 1 -16 0zm32 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM80 400a8 8 0 1 1 0 16 8 8 0 1 1 0-16zm0 32a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm72-104a8 8 0 1 1 16 0 8 8 0 1 1 -16 0zm32 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-24 72a8 8 0 1 1 0 16 8 8 0 1 1 0-16zm0 32a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm72-104a8 8 0 1 1 16 0 8 8 0 1 1 -16 0zm32 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-24 72a8 8 0 1 1 0 16 8 8 0 1 1 0-16zm0 32a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM104 64c-4.4 0-8 3.6-8 8s3.6 8 8 8H216c4.4 0 8-3.6 8-8s-3.6-8-8-8H104z"],
    "grip-lines-vertical": [192, 512, [], "f7a5", "M32 32c-4.4 0-8 3.6-8 8l0 432c0 4.4 3.6 8 8 8s8-3.6 8-8L40 40c0-4.4-3.6-8-8-8zm128 0c-4.4 0-8 3.6-8 8l0 432c0 4.4 3.6 8 8 8s8-3.6 8-8l0-432c0-4.4-3.6-8-8-8z"],
    "bin-bottles-recycle": [640, 512, [], "e5f6", "M384 24v8h16V24c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v8h16V24c0-13.3-10.7-24-24-24H408c-13.3 0-24 10.7-24 24zM352 192c0-53-43-96-96-96H128c-53 0-96 43-96 96H48c0-44.2 35.8-80 80-80H256c44.2 0 80 35.8 80 80h16zm223.1 0c-1.2-9.7-4.6-18.7-9.6-26.5c6.4-9.5 10.1-21 10.1-33.3c0-23.2-13.4-44.3-34.5-54.2L528 71.8c-11-5.1-23-7.8-35.1-7.8H402.3c-12.1 0-24.1 2.7-35.1 7.8L354.1 78c-7.2 3.4-13.5 8-18.6 13.6c4.2 3.3 8.2 6.9 11.9 10.7c3.8-4.1 8.3-7.4 13.5-9.9L374 86.3c8.9-4.1 18.5-6.3 28.3-6.3h90.6c9.8 0 19.4 2.2 28.3 6.3l13.2 6.2c15.4 7.2 25.2 22.7 25.2 39.7c0 9.1-2.7 17.4-7.4 24.4c-3.6 5.3-3.6 12.2-.2 17.6c3.4 5.3 5.8 11.4 6.9 17.9h16.2zM47.2 224H32 8c-4.4 0-8 3.6-8 8s3.6 8 8 8H33.8L56.1 440.8c4.5 40.5 38.7 71.2 79.5 71.2H504.4c40.8 0 75-30.6 79.5-71.2L606.2 240H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H608 592.8h-.9H48.1h-.9zm2.7 16H590.1L568 439.1c-3.6 32.4-31 56.9-63.6 56.9H135.6c-32.6 0-60-24.5-63.6-56.9L49.9 240zM320 304c7.3 0 14 3.7 17.9 9.8l16.2 25.5c2.4 3.7 7.3 4.8 11 2.5c3.8-2.4 4.9-7.3 2.5-11.1l-16.2-25.5C344.5 294.5 332.7 288 320 288c-12.7 0-24.5 6.4-31.3 17.1l-15.4 24c-2.4 3.8-1.3 8.7 2.5 11.1c3.7 2.3 8.6 1.2 11-2.5l15.4-24c3.9-6.1 10.6-9.7 17.9-9.7zm-61.7 63c-3.7-2.3-8.6-1.2-11 2.5l-18.1 28.1c-3.4 5.3-5.2 11.4-5.2 17.7c0 18.1 14.7 32.7 32.7 32.7h41c4.4 0 8-3.6 8-8s-3.6-8-8-8h-41c-9.2 0-16.7-7.5-16.7-16.7c0-3.2 .9-6.3 2.7-9l18.1-28.1c2.4-3.8 1.3-8.7-2.5-11.1zm79.5 73c0 4.4 3.6 8 8 8h36.8c18.1 0 32.8-14.7 32.8-32.8c0-6.2-1.8-12.3-5.1-17.6l-16.8-26.4c-2.4-3.7-7.3-4.8-11-2.5c-3.8 2.4-4.9 7.3-2.5 11.1l16.8 26.4c1.7 2.7 2.6 5.8 2.6 9c0 9.3-7.5 16.8-16.8 16.8H345.7c-4.4 0-8 3.6-8 8zM144 32c0-8.8 7.2-16 16-16h64c8.8 0 16 7.2 16 16V56c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8s-3.6-8-8-8h-8V32c0-17.7-14.3-32-32-32H160c-17.7 0-32 14.3-32 32V48h-8c-4.4 0-8 3.6-8 8s3.6 8 8 8h16c4.4 0 8-3.6 8-8V32z"],
    "arrow-up-from-square": [512, 512, [], "e09c", "M261.7 2.3c-3.1-3.1-8.2-3.1-11.3 0l-112 112c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L248 27.3V328c0 4.4 3.6 8 8 8s8-3.6 8-8V27.3l98.3 98.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-112-112zM56 32C25.1 32 0 57.1 0 88V456c0 30.9 25.1 56 56 56H456c30.9 0 56-25.1 56-56V88c0-30.9-25.1-56-56-56H408c-4.4 0-8 3.6-8 8s3.6 8 8 8h48c22.1 0 40 17.9 40 40V456c0 22.1-17.9 40-40 40H56c-22.1 0-40-17.9-40-40V88c0-22.1 17.9-40 40-40h48c4.4 0 8-3.6 8-8s-3.6-8-8-8H56z"],
    "file-dashed-line": [640, 512, ["page-break"], "f877", "M448 496H192c-26.5 0-48-21.5-48-48V352H128v96c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V352H496v96c0 26.5-21.5 48-48 48zm48-316.1V240h16V179.9c0-12.7-5.1-24.9-14.1-33.9L366.1 14.1c-9-9-21.2-14.1-33.9-14.1H192c-35.3 0-64 28.7-64 64V240h16V64c0-26.5 21.5-48 48-48H332.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H495.8c.2 1.3 .2 2.6 .2 3.9zM489.1 160H376c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L486.6 157.3c.9 .9 1.7 1.8 2.4 2.7zM40 288c-4.4 0-8 3.6-8 8s3.6 8 8 8H184c4.4 0 8-3.6 8-8s-3.6-8-8-8H40zm224 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H264zm192 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H600c4.4 0 8-3.6 8-8s-3.6-8-8-8H456z"],
    "bracket-curly-right": [256, 512, [], "7d", "M192 88c0-30.9-25.1-56-56-56H56c-4.4 0-8 3.6-8 8s3.6 8 8 8h80c22.1 0 40 17.9 40 40v77.5c0 19.1 7.6 37.4 21.1 50.9L236.7 256l-39.6 39.6c-13.5 13.5-21.1 31.8-21.1 50.9V424c0 22.1-17.9 40-40 40H56c-4.4 0-8 3.6-8 8s3.6 8 8 8h80c30.9 0 56-25.1 56-56V346.5c0-14.9 5.9-29.1 16.4-39.6l45.3-45.3c3.1-3.1 3.1-8.2 0-11.3l-45.3-45.3c-10.5-10.5-16.4-24.7-16.4-39.6V88z"],
    "spider": [512, 512, [128375], "f717", "M372.4 .8c-4 2-5.6 6.8-3.6 10.7l46.4 92.8c4.4 8.7 3 19.2-3.4 26.5L328 226.7V144c0-27.4-15.3-51.2-37.9-63.4c-1.9-1-4.1-1.2-6.1-.6s-3.7 2-4.7 3.9L256 127.1 232.7 83.8c-1-1.9-2.7-3.3-4.7-3.9s-4.2-.4-6.1 .6C199.3 92.7 184 116.6 184 144v82.7l-83.8-95.8c-6.4-7.3-7.8-17.8-3.4-26.5l46.4-92.8c2-4 .4-8.8-3.6-10.7s-8.8-.4-10.7 3.6L82.5 97.2c-7.3 14.5-5 32 5.7 44.2l83.1 94.9L50.8 204.7c-7.8-2.1-14.1-7.9-16.7-15.6L15.6 133.5c-1.4-4.2-5.9-6.5-10.1-5.1s-6.5 5.9-5.1 10.1l18.5 55.6c4.3 12.8 14.7 22.6 27.8 26L167.8 252 46.7 283.9c-13.1 3.4-23.5 13.2-27.8 26L.4 365.5c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1L34.1 315c2.6-7.7 8.8-13.6 16.7-15.6l103.1-27.1L83.7 365.8c-7.9 10.5-10.1 24.2-5.9 36.6l34.7 104.1c1.4 4.2 5.9 6.5 10.1 5.1s6.5-5.9 5.1-10.1L92.9 397.4c-2.5-7.5-1.2-15.7 3.6-22l50.2-66.9c-1.7 7.5-2.6 15.3-2.6 23.3v8.3C144 400 194.5 448 256 448s112-48 112-107.8v-8.3c0-8-.9-15.8-2.6-23.3l50.2 66.9c4.7 6.3 6.1 14.5 3.6 22L384.4 501.5c-1.4 4.2 .9 8.7 5.1 10.1s8.7-.9 10.1-5.1l34.7-104.1c4.2-12.5 1.9-26.1-5.9-36.6l-70.2-93.6 103.1 27.1c7.8 2.1 14.1 7.9 16.7 15.6l18.5 55.6c1.4 4.2 5.9 6.5 10.1 5.1s6.5-5.9 5.1-10.1l-18.5-55.6c-4.3-12.8-14.7-22.6-27.8-26L344.2 252l121.1-31.9c13.1-3.4 23.5-13.2 27.8-26l18.5-55.6c1.4-4.2-.9-8.7-5.1-10.1s-8.7 .9-10.1 5.1L477.9 189c-2.6 7.7-8.8 13.6-16.7 15.6L340.8 236.4l83.1-94.9c10.7-12.2 12.9-29.7 5.7-44.2L383.2 4.4c-2-4-6.8-5.6-10.7-3.6zM222.7 99L249 147.8c1.4 2.6 4.1 4.2 7 4.2s5.6-1.6 7-4.2L289.3 99c13.8 10.2 22.7 26.6 22.7 45V253.1c0 2.5 1.2 4.9 3.2 6.4c22.5 16.9 36.8 43 36.8 72.3v8.3c0 50.4-42.7 91.8-96 91.8s-96-41.4-96-91.8v-8.3c0-29.3 14.3-55.4 36.8-72.3c2-1.5 3.2-3.9 3.2-6.4V144c0-18.4 8.9-34.8 22.7-45z"],
    "clock-three": [512, 512, [], "e356", "M496 256A240 240 0 1 1 16 256a240 240 0 1 1 480 0zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM248 104V256c0 4.4 3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H264V104c0-4.4-3.6-8-8-8s-8 3.6-8 8z"],
    "hands-bound": [640, 512, [], "e4f9", "M272 368V352v-8V258.1c0-20.7-7.6-40.7-21.4-56.2L204 149.4c-5.8-6.5-15.6-7.2-22.3-1.6s-7.6 15.5-2.2 22.2l27.6 34.5c13.1 16.4 8.7 40.6-9.4 51.3c-15.2 8.9-34.6 5.1-45.2-9L83.2 154.4 80 150.1v-5.3V96 32c0-8.8-7.2-16-16-16s-16 7.2-16 16V96v59.1 .7V192v21.9c0 10.4 3.7 20.4 10.5 28.3L161.6 362.4c1.5 1.7 3.3 3.1 5.3 4l3.3 1.5H272zm16-16v16h64V352v-8V258.1c0-24.6 9-48.4 25.4-66.8l46.7-52.5c11.5-13 31.3-14.4 44.5-3.2s15.2 30.9 4.4 44.5l-27.6 34.5c-7 8.8-4.7 21.8 5.1 27.5c8.1 4.8 18.6 2.7 24.2-4.8L544 144.8V96 32c0-17.7 14.3-32 32-32s32 14.3 32 32V96v59.1 .7V192v21.9c0 14.2-5.1 27.9-14.3 38.7L494.7 368H512c4.4 0 8 3.6 8 8s-3.6 8-8 8H480 464 368 352 288 272 176 160 128c-4.4 0-8-3.6-8-8s3.6-8 8-8h17.3l-99-115.5C37.1 241.8 32 228 32 213.9V192 155.8v-.7V96 32C32 14.3 46.3 0 64 0S96 14.3 96 32V96v48.8l69.3 92.4c5.7 7.6 16.1 9.6 24.2 4.8c9.7-5.7 12.1-18.7 5.1-27.5L167 180c-10.8-13.5-8.9-33.3 4.4-44.5s33-9.8 44.5 3.2l46.7 52.5C279 209.7 288 233.4 288 258.1V344v8zm181.9 16l3.3-1.5c2-1 3.8-2.3 5.3-4L581.5 242.1c6.7-7.9 10.5-17.9 10.5-28.3V192 155.8v-.7V96 32c0-8.8-7.2-16-16-16s-16 7.2-16 16V96v48.8 5.3l-3.2 4.3-69.3 92.4c-10.6 14.1-30 18-45.2 9c-18.1-10.7-22.6-34.9-9.4-51.3L460.5 170c5.4-6.8 4.5-16.6-2.2-22.2s-16.5-4.9-22.3 1.6l-46.7 52.5c-13.8 15.5-21.4 35.5-21.4 56.2V344v8 16H469.9zM176 464v24c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V464h16v24c0 13.3-10.7 24-24 24H184c-13.3 0-24-10.7-24-24V464h16zm176 0h16v24c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V464h16v24c0 13.3-10.7 24-24 24H376c-13.3 0-24-10.7-24-24V464zM128 416H512c4.4 0 8 3.6 8 8s-3.6 8-8 8H128c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "scalpel-line-dashed": [576, 512, ["scalpel-path"], "f61e", "M441.4 16c-16.1 0-31.4 7.1-41.7 19.4L200 272H332.6c9.4 0 18.4-4.2 24.5-11.4L482.2 112.4c8.9-10.6 13.8-24 13.8-37.8v-4C496 40.5 471.5 16 441.4 16zM185.5 278.7c-2.6-5.6-1.7-12.3 2.3-17.1L387.4 25.1C400.8 9.2 420.6 0 441.4 0c39 0 70.6 31.6 70.6 70.6v4c0 17.6-6.2 34.6-17.6 48.1L369.3 271c-9.1 10.8-22.5 17-36.7 17H200c-6.2 0-11.9-3.6-14.5-9.3zM176.1 320h22.3L28.5 494.4c30.8-3.6 87.1-14 141-36.8c63.8-27 121.4-70 132.5-137.6h16.2C307 397.3 241.7 444.5 175.8 472.4C103 503.1 25.9 512 8 512c-3.2 0-6.1-1.9-7.4-4.9s-.6-6.4 1.6-8.7L176.1 320zM232 496h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H232c-4.4 0-8-3.6-8-8s3.6-8 8-8zm128 0h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H360c-4.4 0-8-3.6-8-8s3.6-8 8-8zm128 0h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H488c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "file-invoice-dollar": [384, 512, [], "f571", "M64 496c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48H64zM358.6 157.3c.9 .9 1.7 1.8 2.4 2.7H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64zm0 72c0 4.4 3.6 8 8 8h96c4.4 0 8-3.6 8-8s-3.6-8-8-8H72c-4.4 0-8 3.6-8 8zm0 64c0 4.4 3.6 8 8 8h96c4.4 0 8-3.6 8-8s-3.6-8-8-8H72c-4.4 0-8 3.6-8 8zM192 242.7c-4.4 0-8 3.6-8 8v13.7c-8.3 .6-16 2.3-22.7 5c-12.1 4.9-22.1 13.6-24.5 26.2c-1.5 7.6-.6 14.4 2.6 20.4c3.1 5.8 8 10.1 13.4 13.3c10 6 23.5 9.6 35.7 12.9l1.7 .4c13.4 3.6 25.1 6.9 33 12c3.8 2.4 6.2 5 7.5 7.7c1.3 2.6 1.9 6 .9 11c-1.3 6.6-6 11.8-14.8 15.2c-9 3.4-21.4 4.5-35.8 2.5c-7.2-1-19.4-4.7-28.9-7.6c-2.1-.6-4-1.2-5.7-1.7c-4.2-1.3-8.7 1.2-9.9 5.4s1.2 8.7 5.4 9.9c1.4 .4 3.1 .9 5 1.5c9.4 2.9 23.3 7.1 31.9 8.3l0 0c1.8 .2 3.6 .5 5.3 .6v13.9c0 4.4 3.6 8 8 8s8-3.6 8-8l0-13.5c8.2-.4 15.8-1.9 22.4-4.4c12.4-4.7 22.2-13.6 24.8-27.1c1.5-7.8 .8-14.9-2.3-21.1c-3-6.1-7.8-10.6-13.2-14.1c-10.4-6.7-24.8-10.6-37.5-14l-.3-.1c-13.4-3.6-25-6.7-33-11.5c-3.9-2.3-6.2-4.7-7.5-7.1c-1.2-2.3-1.9-5.3-1-9.8c1-5.4 5.6-10.8 14.8-14.5c9.1-3.7 21.7-5.1 35.9-3.2c4.6 .6 18.6 3.1 23 4.1c4.3 1 8.6-1.6 9.6-5.9s-1.6-8.6-5.9-9.6c-5.1-1.2-19.7-3.7-24.5-4.4c-1.8-.2-3.6-.5-5.3-.6V250.7c0-4.4-3.6-8-8-8z"],
    "pipe-smoking": [640, 512, [], "e3c4", "M573.8 0C524 0 477 23.2 446.7 62.8L270.4 293.6c-4.6 6.1-14.4 2.8-14.4-4.9V264c0-22.1-17.9-40-40-40H40c-22.1 0-40 17.9-40 40v96c0 83.9 68.1 152 152 152h9.8c51.5 0 99.5-26.1 127.5-69.3L509 104.1c16.2-25 44-40.1 73.8-40.1H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H573.8zM459.4 72.6C486.6 36.9 528.9 16 573.8 16H608c8.8 0 16 7.2 16 16s-7.2 16-16 16H582.8c-35.2 0-68.1 17.8-87.2 47.4L410.8 226.1l-43.7-32.8L459.4 72.6zM357.4 206l44.7 33.5L275.9 434c-25.1 38.7-68 62-114.1 62H152C76.9 496 16 435.1 16 360V264c0-13.3 10.7-24 24-24H216c13.3 0 24 10.7 24 24v24.7c0 23 29.1 32.8 43.1 14.6L357.4 206z"],
    "face-astonished": [512, 512, [], "e36b", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm304 96c0-26.5-21.5-48-48-48s-48 21.5-48 48v32c0 26.5 21.5 48 48 48s48-21.5 48-48V352zm-112 0c0-35.3 28.7-64 64-64s64 28.7 64 64v32c0 35.3-28.7 64-64 64s-64-28.7-64-64V352zM160.4 224a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM200 119.5c.3 4.4-3.1 8.2-7.5 8.5c-32.5 2-61.6 16.5-82.7 38.7c-3 3.2-8.1 3.3-11.3 .3s-3.3-8.1-.3-11.3c23.7-25.1 56.6-41.4 93.3-43.7c4.4-.3 8.2 3.1 8.5 7.5zM319.5 128c-4.4-.3-7.8-4.1-7.5-8.5s4.1-7.8 8.5-7.5c36.7 2.3 69.6 18.6 93.3 43.7c3 3.2 2.9 8.3-.3 11.3s-8.3 2.9-11.3-.3C381.1 144.5 352 130 319.5 128z"],
    "window": [512, 512, [], "f40e", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm96 16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm112-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "plane-circle-exclamation": [640, 512, [], "e556", "M256 0c-19.8 0-35.8 16.2-46.3 33.3C199 50.8 192 72.6 192 89.2V176l0 1.3L20.7 271.9C7.9 278.9 0 292.3 0 306.9L0 355c0 15.9 15.1 27.4 30.4 23.1L192 333.5l0 18.5 0 44-54.4 40.8c-6 4.5-9.6 11.6-9.6 19.2v34.1c0 12.1 9.8 21.9 21.9 21.9c2.2 0 4.4-.3 6.4-1L256 480.4 355.6 511c2.1 .6 4.3 1 6.4 1c2 0 4-.3 5.9-.8l0-21.1c0 3.3-2.6 5.9-5.9 5.9c-.6 0-1.2-.1-1.7-.3l-2.4 7.6 2.4-7.6-102-31.4c-1.5-.5-3.2-.5-4.7 0l-102 31.4c-.6 .2-1.1 .3-1.7 .3c-3.3 0-5.9-2.6-5.9-5.9V456c0-2.5 1.2-4.9 3.2-6.4l57.6-43.2c2-1.5 3.2-3.9 3.2-6.4l0-48 0-29 0-141 0-6.1V89.2c0-13 5.7-31.9 15.3-47.5C233.2 25.6 245.1 16 256 16c11.3 0 23.2 9.6 33 25.6c9.5 15.6 15 34.5 15 47.5l0 86.8 0 6.1 0 0V323v29l0 48c0 2.5 1.2 4.9 3.2 6.4l32.3 24.2c-3.2-8.3-5.7-16.9-7.6-25.7L320 396l0-44 0-18.5 10.8 3c1-5.3 2.1-10.5 3.6-15.6l-14.4-4V195.6l69.8 38.5c4.4-3.8 9-7.3 13.8-10.7L320 177.3l0-1.3 0-86.8c0-16.6-6.7-38.3-17.3-55.8C292.3 16.2 276.2 0 256 0zM28.4 285.9L192 195.6V316.9L26.1 362.7C21 364.1 16 360.3 16 355V306.9c0-8.7 4.8-16.8 12.4-21zM368 368a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM496 448a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-168c-4.4 0-8 3.6-8 8v96c0 4.4 3.6 8 8 8s8-3.6 8-8V288c0-4.4-3.6-8-8-8z"],
    "ear": [384, 512, [128066], "f5f0", "M368 192c0-97.2-78.8-176-176-176S16 94.8 16 192V368c0 70.7 57.3 128 128 128s128-57.3 128-128c0-11.1 5.6-21.7 15.2-27.9c48.7-31.3 80.8-86 80.8-148.1zm16 0c0 67.8-35.1 127.4-88.2 161.5c-4.9 3.2-7.8 8.6-7.8 14.5c0 79.5-64.5 144-144 144S0 447.5 0 368V192C0 86 86 0 192 0S384 86 384 192zM80 192v14.3c0 13.4 6.7 25.9 17.8 33.3l8.9 5.9c13.3 8.9 21.3 23.8 21.3 39.8c0 14.2-6.3 27.7-17.2 36.8L77.1 350.1c-3.4 2.8-8.4 2.4-11.3-1s-2.4-8.4 1-11.3l33.7-28c7.3-6.1 11.5-15 11.5-24.5c0-10.7-5.3-20.6-14.2-26.5l-8.9-5.9C73.4 242.5 64 225 64 206.3V192c0-70.7 57.3-128 128-128s128 57.3 128 128v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-61.9-50.1-112-112-112S80 130.1 80 192z"],
    "file-lock": [576, 512, [], "e3a6", "M64 496H320c.7 0 1.3 0 2 0c1.4 5.5 3.5 10.7 6.3 15.5c-2.7 .3-5.5 .5-8.3 .5H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H204.1c12.7 0 24.9 5.1 33.9 14.1L369.9 145.9c8.1 8.1 13 18.7 13.9 30.1H367.8 320 248c-22.1 0-40-17.9-40-40V16.2c-1.3-.2-2.6-.2-3.9-.2H64C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48zM358.6 157.3L226.7 25.4c-.9-.9-1.8-1.7-2.7-2.4V136c0 13.3 10.7 24 24 24H361.1c-.8-1-1.6-1.9-2.4-2.7zM464 208c-26.5 0-48 21.5-48 48v64h96V256c0-26.5-21.5-48-48-48zm-64 48c0-35.3 28.7-64 64-64s64 28.7 64 64v64h16c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H384c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32h16V256zm-16 80c-8.8 0-16 7.2-16 16V480c0 8.8 7.2 16 16 16H544c8.8 0 16-7.2 16-16V352c0-8.8-7.2-16-16-16H528 512 416 400 384z"],
    "diagram-venn": [640, 512, [], "e15a", "M224 464C109.1 464 16 370.9 16 256S109.1 48 224 48c27.6 0 53.9 5.4 78 15.1c-65.9 39-110 110.8-110 192.9s44.2 153.9 110 192.9c-24.1 9.8-50.4 15.1-78 15.1zM431.8 248H208.2c1-25.4 6.5-49.7 15.8-72H416.1c9.3 22.3 14.8 46.6 15.8 72zM416 336.1V336H224v.1c-9.3-22.3-14.9-46.7-15.8-72.1H431.8c-1 25.5-6.5 49.8-15.8 72.1zM408.6 352c-19.7 37.8-50.7 68.8-88.6 88.6c-37.8-19.7-68.8-50.7-88.6-88.6H408.6zM231.4 160c19.7-37.8 50.7-68.8 88.6-88.6c37.8 19.7 68.8 50.7 88.6 88.6H231.4zM224 480c34.4 0 66.9-7.7 96-21.6c29.1 13.8 61.6 21.6 96 21.6c123.7 0 224-100.3 224-224S539.7 32 416 32c-34.4 0-66.9 7.7-96 21.6C290.9 39.7 258.4 32 224 32C100.3 32 0 132.3 0 256S100.3 480 224 480zM416 48c114.9 0 208 93.1 208 208s-93.1 208-208 208c-27.6 0-53.9-5.4-78-15.1c65.9-39 110-110.8 110-192.9s-44.2-153.9-110-192.9C362.1 53.4 388.4 48 416 48z"],
    "x-ray": [512, 512, [], "f497", "M0 40c0-4.4 3.6-8 8-8H40 472h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H480V464h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H472 40 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32V48H8c-4.4 0-8-3.6-8-8zm48 8V464H464V48H48zM256 96c4.4 0 8 3.6 8 8v40h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H264v48H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H264v80c0 .5-.1 1.1-.2 1.6l.1 0L328.7 283c5.7-2 11.6-3 17.6-3c29.6 0 53.6 24 53.6 53.6v3.1c0 12.7-4.3 25-12.1 35L371 393.3c-11.2 14.3-28.4 22.7-46.6 22.7H187.6c-18.2 0-35.4-8.4-46.6-22.7l-16.9-21.5c-7.8-10-12.1-22.3-12.1-35v-3.1c0-29.6 24-53.6 53.6-53.6c6 0 12 1 17.6 3l64.8 22.6 .1 0c-.1-.5-.2-1-.2-1.6V224H144c-4.4 0-8-3.6-8-8s3.6-8 8-8H248V160H176c-4.4 0-8-3.6-8-8s3.6-8 8-8h72V104c0-4.4 3.6-8 8-8zM128 333.6v3.1c0 9.1 3.1 18 8.7 25.2l16.9 21.5c8.2 10.4 20.7 16.5 34 16.5H324.4c13.3 0 25.8-6.1 34-16.5l16.9-21.5c5.6-7.2 8.7-16 8.7-25.2v-3.1c0-20.8-16.8-37.6-37.6-37.6c-4.2 0-8.4 .7-12.4 2.1l-64.8 22.6c-8.5 3-17.8 3-26.3 0L178 298.1c-4-1.4-8.2-2.1-12.4-2.1c-20.8 0-37.6 16.8-37.6 37.6zM192 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm112-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "goal-net": [640, 512, [], "e3ab", "M16 104c0-30.9 25.1-56 56-56H568c30.9 0 56 25.1 56 56V472c0 4.4 3.6 8 8 8s8-3.6 8-8V104c0-39.8-32.2-72-72-72H72C32.2 32 0 64.2 0 104V472c0 4.4 3.6 8 8 8s8-3.6 8-8V104zm136-8c-4.4 0-8 3.6-8 8v56H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h72v96H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h72v96H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h72v72c0 4.4 3.6 8 8 8s8-3.6 8-8V400h96v72c0 4.4 3.6 8 8 8s8-3.6 8-8V400h96v72c0 4.4 3.6 8 8 8s8-3.6 8-8V400h96v72c0 4.4 3.6 8 8 8s8-3.6 8-8V400h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H496V288h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H496V176h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H496V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v56H384V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v56H272V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v56H160V104c0-4.4-3.6-8-8-8zm8 80h96v96H160V176zm112 0h96v96H272V176zm112 0h96v96H384V176zM160 384V288h96v96H160zm112 0V288h96v96H272zm112 0V288h96v96H384z"],
    "coffin-cross": [384, 512, [], "e051", "M23.5 125.4c-4.8 5.5-7.5 12.7-7.5 20c0 2.9 .4 5.7 1.2 8.4l95.5 330.6c2 6.8 8.2 11.6 15.4 11.6H255.9c7.1 0 13.4-4.7 15.4-11.6l95.5-330.6c.8-2.7 1.2-5.6 1.2-8.4c0-7.4-2.7-14.5-7.5-20l-91-104c-3-3.5-7.4-5.5-12-5.5h-131c-4.6 0-9 2-12 5.5l-91 104zm-12-10.5l91-104C108.5 4 117.3 0 126.5 0h131c9.2 0 18 4 24.1 10.9l91 104c7.4 8.5 11.5 19.3 11.5 30.6c0 4.4-.6 8.7-1.8 12.9L286.7 488.9c-4 13.7-16.5 23.1-30.7 23.1H128.1c-14.3 0-26.8-9.4-30.7-23.1L1.8 158.3C.6 154.1 0 149.8 0 145.4c0-11.2 4.1-22.1 11.5-30.6zM200 104v72h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H200V344c0 4.4-3.6 8-8 8s-8-3.6-8-8V192H104c-4.4 0-8-3.6-8-8s3.6-8 8-8h80V104c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "spell-check": [576, 512, [], "f891", "M119.3 4.8C118.1 1.9 115.2 0 112 0s-6.1 1.9-7.3 4.8L.7 244.8c-1.8 4.1 .1 8.8 4.2 10.5s8.8-.1 10.5-4.2L48 175.8v.2H176v-.2l32.7 75.4c1.8 4.1 6.5 5.9 10.5 4.2s5.9-6.5 4.2-10.5l-104-240zM169.1 160H54.9L112 28.1 169.1 160zM256 16V120 240c0 8.8 7.2 16 16 16H376c39.8 0 72-32.2 72-72c0-34.2-23.8-62.8-55.8-70.2C406.7 102.1 416 84.1 416 64c0-35.3-28.7-64-64-64H272c-8.8 0-16 7.2-16 16zm96 96H272V16h80c26.5 0 48 21.5 48 48s-21.5 48-48 48zm-80 16h80 24c30.9 0 56 25.1 56 56s-25.1 56-56 56H272V128zM565.7 301.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L351.8 492.9 237.5 386.2c-3.2-3-8.3-2.8-11.3 .4s-2.8 8.3 .4 11.3l120 112c3.2 2.9 8.1 2.9 11.1-.2l208-208z"],
    "location-xmark": [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", "M368 192c0-97.2-78.8-176-176-176S16 94.8 16 192c0 18.7 6.4 42.5 17.8 69.6c11.3 26.9 27.1 55.8 44.7 84.3c35.2 57 76.8 111.4 102.3 143.2c5.9 7.3 16.6 7.3 22.4 0c25.5-31.8 67.1-86.2 102.3-143.2c17.6-28.5 33.4-57.4 44.7-84.3C361.6 234.5 368 210.7 368 192zm16 0c0 87.4-117 243-168.3 307.2c-12.3 15.3-35.1 15.3-47.4 0C117 435 0 279.4 0 192C0 86 86 0 192 0S384 86 384 192zM114.3 114.3c3.1-3.1 8.2-3.1 11.3 0L192 180.7l66.3-66.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L203.3 192l66.3 66.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L192 203.3l-66.3 66.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L180.7 192l-66.3-66.3c-3.1-3.1-3.1-8.2 0-11.3z"],
    "circle-quarter-stroke": [512, 512, [], "e5d3", "M496 256C496 123.5 388.5 16 256 16V200c0 22.1-17.9 40-40 40H16.5c-.3 5.3-.5 10.6-.5 16c0 132.5 107.5 240 240 240s240-107.5 240-240zM240 16.5C125.6 24.1 33.1 111.8 18.1 224H216c13.3 0 24-10.7 24-24V16.5zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "lasso": [576, 512, [], "f8c8", "M576 176c0 97.2-128.9 176-288 176c-30.4 0-59.6-2.9-87.1-8.2C220.4 361.9 232 387.6 232 415c0 53.6-43.4 97-97 97H40c-4.4 0-8-3.6-8-8s3.6-8 8-8h95c44.7 0 81-36.3 81-81c0-30.7-17.3-58.7-44.8-72.4l-30.7-15.4C56.4 296.5 0 240.3 0 176C0 78.8 128.9 0 288 0S576 78.8 576 176zM288 336c150.2 0 272-71.6 272-160S438.2 16 288 16S16 87.6 16 176s121.8 160 272 160z"],
    "slash": [640, 512, [], "f715", "M1.7 3C4.5-.4 9.5-1 13 1.7l624 496c3.5 2.7 4 7.8 1.3 11.2s-7.8 4-11.2 1.3L3 14.3C-.4 11.5-1 6.5 1.7 3z"],
    "person-to-portal": [512, 512, ["portal-enter"], "e022", "M172.2 148.1c4.2 1.2 7.7 4.1 9.8 7.9s2.4 8.4 1 12.5L152.8 259c-7 21 1.3 44.1 20.1 55.9l86.2 53.9c6 3.8 8.9 11.1 6.9 18l-25.4 88.8c-2.4 8.5 2.5 17.4 11 19.8s17.4-2.5 19.8-11l25.4-88.8c5.9-20.6-2.6-42.6-20.7-53.9l-47.9-30c-6.5-4.1-9.2-12.2-6.4-19.4l30-77.3c2.3-5.9 7.8-9.9 14.2-10.2s12.2 3.2 15.1 8.8l15.9 31.7c8.1 16.3 24.8 26.5 42.9 26.5H384c8.8 0 16-7.2 16-16s-7.2-16-16-16H339.8c-6.1 0-11.6-3.4-14.3-8.8l-32.9-65.7c-6-12-16.8-21-29.7-24.7l-90.7-25.9c-6.6-1.9-13.4-2.8-20.3-2.8c-19.6 0-38.3 7.8-52.1 21.6L68.7 164.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l31.1-31.1c7.8-7.8 18.4-12.2 29.5-12.2c3.9 0 7.7 .5 11.5 1.6l8.8 2.5zM57.4 153.4l31.1-31.1C105.3 105.5 128.1 96 151.9 96c8.3 0 16.6 1.2 24.7 3.5l90.7 25.9c17.2 4.9 31.6 16.9 39.7 32.9L339.8 224H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H339.8c-24.2 0-46.4-13.7-57.2-35.4l-6.2-12.4-9.7-19.3L258.8 241l-22.2 57.1 47.9 30c24.2 15.1 35.5 44.4 27.6 71.9l-25.4 88.8c-4.9 17-22.6 26.8-39.6 22s-26.8-22.6-22-39.6l25.4-88.8-86.2-53.9c-25.1-15.7-36.1-46.5-26.8-74.5l25.1-75.3 5.1-15.2L159 161c-2.2-.6-4.6-1-6.9-1l-.2 0c-6.8 0-13.4 2.7-18.2 7.5l-31.1 31.1c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3zM272 80a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM224 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM111.3 314.8c2.9 6.2 6.4 12.1 10.6 17.6l-9.2 25.2L108.8 368H97.6 32c-8.8 0-16 7.2-16 16s7.2 16 16 16H97.6c20.1 0 38.1-12.6 45.1-31.5l4.7-12.9 0 0 13.9 8.7-3.6 9.7c-9.2 25.2-33.2 42-60.1 42H32c-17.7 0-32-14.3-32-32s14.3-32 32-32H97.6l13.7-37.2zM473.5 449.6C459.8 487.7 443.8 496 432 496s-27.8-8.3-41.5-46.4c-10.2-28.4-17.8-70.4-20.9-129.6h-16c7.3 140.7 39.7 192 78.4 192c44.2 0 80-66.6 80-256S476.2 0 432 0c-38.8 0-71.1 51.3-78.4 192h16c3.1-59.2 10.7-101.2 20.9-129.6C404.2 24.3 420.2 16 432 16s27.8 8.3 41.5 46.4C487.1 100.1 496 161.9 496 256s-8.9 155.9-22.5 193.6z"],
    "calendar-star": [512, 512, [], "f736", "M160 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H96c-35.3 0-64 28.7-64 64v48 16V448c0 35.3 28.7 64 64 64H416c35.3 0 64-28.7 64-64V192 176 128c0-35.3-28.7-64-64-64H368V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H160V8zM48 192H464V448c0 26.5-21.5 48-48 48H96c-26.5 0-48-21.5-48-48V192zM144 80v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80H352v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80h48c26.5 0 48 21.5 48 48v48H48V128c0-26.5 21.5-48 48-48h48zM270.3 251c-5.9-11.9-22.8-11.9-28.7 0l-23.9 48.4-53.4 7.8c-13.1 1.9-18.4 18-8.9 27.3l38.6 37.7L185 425.3c-2.2 13.1 11.5 23 23.2 16.9L256 417l47.8 25.1c11.7 6.2 25.5-3.8 23.2-16.9l-9.1-53.2 38.6-37.7c9.5-9.3 4.3-25.4-8.9-27.3l-53.4-7.8L270.3 251zM256 258.1l25.7 52.2 1.9 3.8 4.2 .6 57.6 8.4-41.7 40.6-3 2.9 .7 4.1 9.8 57.3-51.5-27.1-3.7-2-3.7 2L200.8 428l9.8-57.3 .7-4.1-3-2.9L166.7 323l57.6-8.4 4.2-.6 1.9-3.8L256 258.1z"],
    "computer-mouse": [384, 512, [128433, "mouse"], "f8cc", "M16 192H184V16H160C80.5 16 16 80.5 16 160v32zM184 0h8 8 24c88.4 0 160 71.6 160 160v32 8 8V352c0 88.4-71.6 160-160 160H160C71.6 512 0 440.4 0 352V208v-8-8V160C0 71.6 71.6 0 160 0h24zM16 208V352c0 79.5 64.5 144 144 144h64c79.5 0 144-64.5 144-144V208H192 16zm352-16V160c0-79.5-64.5-144-144-144H200V192H368z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M213.7 114.3l136 136c3.1 3.1 3.1 8.2 0 11.3l-136 136c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L324.7 264 8 264c-4.4 0-8-3.6-8-8s3.6-8 8-8l316.7 0L202.3 125.7c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zM328 464l96 0c39.8 0 72-32.2 72-72l0-272c0-39.8-32.2-72-72-72l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l96 0c48.6 0 88 39.4 88 88l0 272c0 48.6-39.4 88-88 88l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "pegasus": [576, 512, [], "f703", "M448 16c-66.3 0-120 53.7-120 120c0 2.4-1.1 4.6-2.8 6.1c-1.4 1.2-3.2 1.9-5.2 1.9h-3.2c-1.3 0-2.6-.3-3.8-.9L144.3 53.4c3.3 81.1 36.4 127.2 68.7 153.3c17.2 13.9 34.4 22.2 47.3 27.1c6.4 2.4 11.8 4 15.5 5c1.8 .5 3.3 .8 4.2 1c.5 .1 .8 .2 1 .2l.2 0 0 0 0 0c4.4 .7 7.3 4.8 6.6 9.2s-4.8 7.3-9.2 6.6L280 248c-1.3 7.9-1.3 7.9-1.3 7.9l0 0 0 0-.1 0-.4-.1c-.3-.1-.8-.2-1.4-.3c-1.2-.2-2.8-.6-4.9-1.2c-4.2-1.1-10.1-2.8-17.2-5.5c-14.1-5.4-32.9-14.5-51.7-29.6c-21-16.9-41.7-41-56-75.2c-2.1-5.1-4.1-10.4-6-16c-8.1-24.5-13-53.6-13-88c0-2.8 1.5-5.4 3.9-6.9s5.4-1.5 7.9-.2l172.7 91.7C318.2 54.8 376.7 0 448 0h8 16 21.8H552c4.4 0 8 3.6 8 8s-3.6 8-8 8H539.1c14.6 11.8 24.5 29.2 26.4 49.2l7 73.8c2.4 25.1-10.9 49.1-33.5 60.4c-30.2 15.1-66.8 2.9-81.9-27.3L451.1 160H448v79.5 .5l0 .2c-.2 28.8-12.7 54.2-32 71.9V480c0 17.7-14.3 32-32 32H344c-17.7 0-32-14.3-32-32V332.1L206.7 309c.9 6.2 1.3 12.5 1.3 18.8c0 18.3-3.7 36.4-10.9 53.2l-6.5 15.3c-2.2 5-2.5 10.6-1.1 15.9L206 471.4c5.7 20.4-9.7 40.6-30.8 40.6H125.3c-14.4 0-27-9.6-30.8-23.4L81.6 442.1c-8.3-29.8-6.2-61.5 6-90l6.5-15.3c1.2-2.9 1.9-5.9 1.9-9c0-3-.6-6-1.8-8.8L62.4 242.5c-4.2-10.1-6.4-20.9-6.4-31.8c0-12.4 2.7-24.1 7.6-34.7C37.3 176.2 16 197.6 16 224v88c0 4.4-3.6 8-8 8s-8-3.6-8-8V224c0-35.3 28.7-64 64-64h8 1.3c9.2-11.8 21.6-21.1 35.8-26.6c1.6 5.2 3.3 10.3 5.2 15.1C89.6 158.3 72 182.4 72 210.7c0 8.8 1.7 17.5 5.1 25.6L109 312.8c2 4.7 3 9.8 3 15c0 5.3-1.1 10.5-3.2 15.3l-6.5 15.3c-10.8 25.1-12.6 53.1-5.3 79.4l12.9 46.5c1.9 6.9 8.2 11.7 15.4 11.7h49.8c10.6 0 18.2-10.1 15.4-20.3l-16.5-59.3c-2.4-8.8-1.8-18.1 1.8-26.5l6.5-15.3c6.3-14.8 9.6-30.7 9.6-46.9c0-9.2-1.1-18.4-3.2-27.4c-.6-2.7 .2-5.5 2.1-7.5s4.7-2.8 7.4-2.2l123.4 27.1c3.7 .8 6.3 4.1 6.3 7.8V480c0 8.8 7.2 16 16 16h40c8.8 0 16-7.2 16-16V308.5c0-2.4 1-4.6 2.8-6.1c17.6-14.9 29-37.1 29.2-62.5l0-.1v-.4V152c0-4.4 3.6-8 8-8h16c3 0 5.8 1.7 7.2 4.4l8.3 16.5c11.1 22.3 38.2 31.3 60.5 20.2c16.7-8.3 26.5-26 24.7-44.6l-7-73.8C546.8 37.9 522.7 16 493.8 16H472 456h-8zm48 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "files-medical": [448, 512, [], "f7fd", "M384 400H192c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H324.1c4.1 0 8.1 .8 11.9 2.3V88c0 13.3 10.7 24 24 24h69.7c1.5 3.7 2.3 7.8 2.3 11.9V352c0 26.5-21.5 48-48 48zM439.1 96c-1.5-2.1-3.2-4.2-5.1-6.1L358.1 14.1c-9-9-21.2-14.1-33.9-14.1H192c-35.3 0-64 28.7-64 64V352c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V123.9c0-9.5-2.8-18.7-8-26.5V96h-.9zm-21.7 0H360c-4.4 0-8-3.6-8-8V30.6L417.4 96zM96 96H64C28.7 96 0 124.7 0 160V448c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64H304c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V160c0-26.5 21.5-48 48-48H96V96zm173.3 89.3c0-4.4 3.6-8 8-8h21.3c4.4 0 8 3.6 8 8v44c0 4.4 3.6 8 8 8h44c4.4 0 8 3.6 8 8v21.3c0 4.4-3.6 8-8 8h-44c-4.4 0-8 3.6-8 8v44c0 4.4-3.6 8-8 8H277.3c-4.4 0-8-3.6-8-8v-44c0-4.4-3.6-8-8-8h-44c-4.4 0-8-3.6-8-8V245.3c0-4.4 3.6-8 8-8h44c2.1 0 4.2-.8 5.7-2.3s2.3-3.5 2.3-5.7v-44zm8-24c-13.3 0-24 10.7-24 24v36h-36c-13.3 0-24 10.7-24 24v21.3c0 13.3 10.7 24 24 24h36v36c0 13.3 10.7 24 24 24h21.3c13.3 0 24-10.7 24-24v-36h36c13.3 0 24-10.7 24-24V245.3c0-13.3-10.7-24-24-24h-36v-36c0-13.3-10.7-24-24-24H277.3z"],
    "nfc-lock": [576, 512, [], "e1f8", "M384 48H64C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H320v16H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64v65.3c-5.5 .9-10.9 2.3-16 4.1V96c0-26.5-21.5-48-48-48zM368 256v34c-5.7 1.5-11 3.7-16 6.5V136c0-4.4-3.6-8-8-8H240c-4.4 0-8 3.6-8 8v80.8c18.3 3.7 32 19.8 32 39.2c0 22.1-17.9 40-40 40s-40-17.9-40-40c0-19.4 13.7-35.5 32-39.2V136c0-13.3 10.7-24 24-24H344c13.3 0 24 10.7 24 24V256zM320 400H104c-13.3 0-24-10.7-24-24V136c0-13.3 10.7-24 24-24h48c4.4 0 8 3.6 8 8s-3.6 8-8 8H104c-4.4 0-8 3.6-8 8V376c0 4.4 3.6 8 8 8H320v16zM224 232a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm240-24c-26.5 0-48 21.5-48 48v64h96V256c0-26.5-21.5-48-48-48zm-64 48c0-35.3 28.7-64 64-64s64 28.7 64 64v64h16c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H384c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32h16V256zm-16 80c-8.8 0-16 7.2-16 16V480c0 8.8 7.2 16 16 16H544c8.8 0 16-7.2 16-16V352c0-8.8-7.2-16-16-16H528 512 416 400 384z"],
    "person-ski-lift": [512, 512, ["ski-lift"], "f7c8", "M248 0c4.4 0 8 3.6 8 8V198.3l-16 4.3V8c0-4.4 3.6-8 8-8zm24 297.7v134l32-12.2v-153c0-15.8-14.9-27.3-30.2-23.2l-55.9 14.9c-7.6 2-15.5-1.7-18.7-8.8l-28.8-63.4C165.5 175 154.6 168 142.7 168c-22.3 0-37 23.1-27.7 43.3l32.9 71.2c6.5 14.1 22.3 21.5 37.3 17.5l66.7-17.8c4.8-1.3 9.9-.3 13.9 2.8s6.3 7.7 6.3 12.7zm48-31.2v147l145-55.1c18.6-7.1 31-24.9 31-44.9V296c0-4.4 3.6-8 8-8s8 3.6 8 8v17.4c0 26.6-16.4 50.4-41.3 59.8L106.8 511.5c-4.1 1.6-8.8-.5-10.3-4.6s.5-8.8 4.6-10.3L256 437.7V432 314.2 297.7l-16 4.3-50.7 13.5c-22.6 6-46.2-5.1-55.9-26.3L100.4 218c-14.2-30.8 8.3-66 42.2-66c18.2 0 34.8 10.7 42.3 27.3l28.8 63.4 55.9-14.9c25.4-6.8 50.3 12.4 50.3 38.6zM144 80A32 32 0 1 0 80 80a32 32 0 1 0 64 0zM112 32a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM15.4 164.8L87.1 332.2c11.9 27.7 43.5 41 71.6 30.2l46.5-17.9c4.1-1.6 8.8 .5 10.3 4.6s-.5 8.8-4.6 10.3l-46.5 17.9c-36.1 13.9-76.8-3.3-92-38.8L.6 171.2c-1.7-4.1 .1-8.8 4.2-10.5s8.8 .1 10.5 4.2z"],
    "square-6": [448, 512, [], "e25b", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm270 34.7c2.9 3.3 2.6 8.4-.8 11.3l-58.1 50.8c4.2-.6 8.5-.8 12.8-.8c53 0 96 43 96 96s-43 96-96 96s-96-43-96-96c0-16.6 4.2-32.2 11.6-45.8c5.4-9.9 12.5-19 21.2-26.6L258.7 130c3.3-2.9 8.4-2.6 11.3 .8zM224 368a80 80 0 1 0 .1-160A80 80 0 1 0 224 368z"],
    "shop-slash": [640, 512, ["store-alt-slash"], "e070", "M4.7 167.4C1.6 173.1 0 179.4 0 185.8C0 206.9 17.1 224 38.2 224H64V464c0 26.5 21.5 48 48 48H336c26.5 0 48-21.5 48-48V398.3l-16-12.6V464c0 17.7-14.3 32-32 32H112c-17.7 0-32-14.3-32-32V224h83.3L143 208H72 38.2C26 208 16 198 16 185.8c0-3.7 .9-7.4 2.7-10.7l24.9-45.6L30.8 119.5l-26.2 48zM113.5 1.3L132.2 16H515.5c11.7 0 22.5 6.4 28.1 16.7l77.7 142.4c1.8 3.3 2.7 6.9 2.7 10.7c0 12.3-10 22.2-22.2 22.2H568 375.4l20.3 16H560V353.7l16 12.6V224h25.8c21.1 0 38.2-17.1 38.2-38.2c0-6.4-1.6-12.7-4.7-18.3L557.6 25C549.2 9.6 533.1 0 515.5 0h-391c-3.7 0-7.4 .4-11 1.3zM512 315.8V256c0-4.4-3.6-8-8-8s-8 3.6-8 8v47.2l16 12.6zM304 335.1V360c0 4.4-3.6 8-8 8H152c-4.4 0-8-3.6-8-8V256c0-4.4-3.6-8-8-8s-8 3.6-8 8V360c0 13.3 10.7 24 24 24H296c13.3 0 24-10.7 24-24V347.7l-16-12.6zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "wind-turbine": [512, 512, [], "f89b", "M301 214.3c-1-6.8 .2-13.8 3.5-19.9L396.9 23.6 244.7 144.2c-5.4 4.3-12.1 6.7-19 6.9L31.5 156.5l180.6 71.5c6.4 2.5 11.9 7.1 15.5 13L329.4 406.5 301 214.3zm44.2 189.8c2.5 17.2-20.3 25.5-29.5 10.7L288 369.7l-16-26-32-52-16-26-10-16.3c-1.8-2.9-4.5-5.2-7.7-6.5L25.7 171.4C9.5 165 13.7 141 31.1 140.6l194.1-5.4c3.5-.1 6.8-1.3 9.5-3.5L387 11c13.6-10.8 32.3 4.8 24 20.1L318.6 202c-1.6 3-2.3 6.5-1.8 9.9l28.4 192.1zM240 352.8V496h32V404.8l16 26V496h88c4.4 0 8 3.6 8 8s-3.6 8-8 8H280 232 136c-4.4 0-8-3.6-8-8s3.6-8 8-8h88V326.8l16 26zM256 184a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "sliders-simple": [512, 512, [], "e253", "M80 304a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm79.6 56L504 360c4.4 0 8 3.6 8 8s-3.6 8-8 8l-344.4 0c-4 40.4-38.1 72-79.6 72c-44.2 0-80-35.8-80-80s35.8-80 80-80c41.5 0 75.6 31.6 79.6 72zM368 144a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm-15.6-8c4-40.4 38.1-72 79.6-72c44.2 0 80 35.8 80 80s-35.8 80-80 80c-41.5 0-75.6-31.6-79.6-72L8 152c-4.4 0-8-3.6-8-8s3.6-8 8-8l344.4 0z"],
    "grid-round": [448, 512, [], "e5da", "M112 96A48 48 0 1 1 16 96a48 48 0 1 1 96 0zM64 32a64 64 0 1 0 0 128A64 64 0 1 0 64 32zm48 224a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM64 192a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm0 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM0 416a64 64 0 1 0 128 0A64 64 0 1 0 0 416zM272 96a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM224 32a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm0 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm-64 48a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM272 416a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-48-64a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM384 48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM320 96a64 64 0 1 0 128 0A64 64 0 1 0 320 96zM432 256a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-48-64a64 64 0 1 0 0 128 64 64 0 1 0 0-128zm0 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm-64 48a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z"],
    "badge-sheriff": [448, 512, [], "f8a2", "M224 0c-30.9 0-56 25.1-56 56c0 16.3 7 31 18.1 41.2l-24.7 42.4c-1.4 2.4-4 4-6.9 4l-44.9 .2c-4-13.1-12.8-24.8-25.6-32.2C57.2 96 23 105.2 7.5 132S1.2 193 28 208.5c13.3 7.7 28.4 9.3 42.2 5.7L91.9 252c1.4 2.5 1.4 5.5 0 7.9L70.2 297.8c-13.8-3.6-28.9-2-42.2 5.7C1.2 319-8 353.2 7.5 380S57.2 416 84 400.5c12.8-7.4 21.6-19.1 25.6-32.2l44.9 .2c2.8 0 5.5 1.5 6.9 4l24.7 42.4C175 425 168 439.7 168 456c0 30.9 25.1 56 56 56s56-25.1 56-56c0-16.3-7-31-18.1-41.2l24.7-42.4c1.4-2.4 4-4 6.9-4l44.9-.2c4 13.1 12.8 24.8 25.6 32.2c26.8 15.5 61 6.3 76.5-20.5s6.3-61-20.5-76.5c-13.3-7.7-28.5-9.3-42.2-5.7L356.1 260c-1.4-2.5-1.4-5.5 0-7.9l21.7-37.9c13.8 3.6 28.9 2 42.2-5.7c26.8-15.5 36-49.7 20.5-76.5S390.8 96 364 111.5c-12.8 7.4-21.6 19.1-25.6 32.2l-44.9-.2c-2.8 0-5.5-1.5-6.9-4l-6.9 4 6.9-4L261.9 97.2C273 87 280 72.3 280 56c0-30.9-25.1-56-56-56zM184 56c0-22.1 17.9-40 40-40s40 17.9 40 40c0 13.5-6.7 25.5-17 32.8c-3.4 2.4-4.4 7-2.3 10.6l28.2 48.3c4.3 7.3 12.1 11.9 20.6 11.9l51.2 .2c3.9 0 7.2-2.8 7.9-6.6c2-11.3 8.7-21.6 19.4-27.8c19.1-11 43.6-4.5 54.6 14.6s4.5 43.6-14.6 54.6c-11.1 6.4-23.9 6.9-34.9 2.5c-3.7-1.5-7.9 0-9.9 3.5l-24.9 43.5c-4.2 7.4-4.2 16.5 0 23.8l24.9 43.5c2 3.5 6.2 4.9 9.9 3.5c11-4.4 23.9-3.9 34.9 2.5c19.1 11 25.7 35.5 14.6 54.6s-35.5 25.7-54.6 14.6c-10.7-6.2-17.4-16.5-19.4-27.8c-.7-3.8-4-6.6-7.9-6.6l-51.2 .2c-8.5 0-16.4 4.6-20.6 11.9l-28.2 48.3c-2.1 3.6-1.1 8.2 2.3 10.6c10.3 7.3 17 19.2 17 32.8c0 22.1-17.9 40-40 40s-40-17.9-40-40c0-13.5 6.7-25.5 17-32.8c3.4-2.4 4.4-7 2.3-10.6l-28.1-48.3c-4.3-7.4-12.1-11.9-20.6-11.9l-51.2-.2c-3.9 0-7.2 2.8-7.9 6.6c-2 11.3-8.7 21.6-19.4 27.8c-19.1 11-43.6 4.5-54.6-14.6s-4.5-43.6 14.6-54.6c11.1-6.4 23.9-6.9 34.9-2.5c3.7 1.5 7.9 0 9.9-3.5l24.9-43.5c4.2-7.4 4.2-16.5 0-23.8L80.9 200.6c-2-3.5-6.2-4.9-9.9-3.5c-11 4.4-23.9 3.9-34.9-2.5c-19.1-11-25.7-35.5-14.6-54.6s35.5-25.7 54.6-14.6c10.7 6.2 17.4 16.5 19.4 27.8c.7 3.8 4 6.6 7.9 6.6l51.2-.2c8.5 0 16.4-4.6 20.6-11.9l28.1-48.3c2.1-3.6 1.1-8.2-2.3-10.6c-10.3-7.2-17-19.2-17-32.8zm40 264a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-48-64a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "server": [512, 512, [], "f233", "M64 48C37.5 48 16 69.5 16 96v64c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64v64c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM64 304c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V352c0-26.5-21.5-48-48-48H64zM0 352c0-35.3 28.7-64 64-64H448c35.3 0 64 28.7 64 64v64c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V352zm336 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16-272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16-272a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "virus-covid-slash": [640, 512, [], "e4a9", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM503.8 264H552v32c0 4.4 3.6 8 8 8s8-3.6 8-8V216c0-4.4-3.6-8-8-8s-8 3.6-8 8v32H503.8c-1.9-44.8-19.8-85.4-48.2-116.3l34.1-34.1 0 0 22.6 22.6c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L467.1 52.4c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l22.6 22.6 0 0-34.1 34.1C413.4 92 372.8 74.1 328 72.2V24l32 0c4.4 0 8-3.6 8-8s-3.6-8-8-8H280c-4.4 0-8 3.6-8 8s3.6 8 8 8h32V72.2c-29 1.2-56.3 9.2-80.3 22.4l13.8 10.9C267.9 94.3 293.2 88 320 88c92.8 0 168 75.2 168 168c0 12.9-1.5 25.5-4.2 37.6l13.8 10.9c3.5-13 5.7-26.5 6.3-40.4zM142.4 207.6c-3.5 13-5.7 26.5-6.3 40.4H88l0-32c0-4.4-3.6-8-8-8s-8 3.6-8 8v80c0 4.4 3.6 8 8 8s8-3.6 8-8V264h48.2c1.9 44.8 19.8 85.4 48.2 116.3l-34.1 34.1 0 0-22.6-22.6c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l56.6 56.6c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-22.6-22.6 0 0 34.1-34.1c30.9 28.4 71.5 46.3 116.3 48.2V488H280c-4.4 0-8 3.6-8 8s3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H328V439.8c29-1.2 56.3-9.2 80.3-22.4l-13.8-10.9C372.1 417.7 346.8 424 320 424c-92.8 0-168-75.2-168-168c0-12.9 1.5-25.5 4.2-37.6l-13.8-10.9z"],
    "intersection": [384, 512, [8898], "f668", "M24 480c4.4 0 8-3.6 8-8V208c0-88.4 71.6-160 160-160s160 71.6 160 160V472c0 4.4 3.6 8 8 8s8-3.6 8-8V208c0-97.2-78.8-176-176-176S16 110.8 16 208V472c0 4.4 3.6 8 8 8z"],
    "shop-lock": [640, 512, [], "e4a5", "M0 185.8c0-6.4 1.6-12.7 4.7-18.3L82.4 25C90.8 9.6 106.9 0 124.5 0h391c17.6 0 33.7 9.6 42.1 25l77.7 142.4c3.1 5.6 4.7 11.9 4.7 18.3c0 12.4-5.9 23.3-14.9 30.3c-2.7-4.7-5.7-9.1-9-13.3c4.9-4.1 7.9-10.2 7.9-17c0-3.7-.9-7.4-2.7-10.7L543.6 32.7C538 22.4 527.2 16 515.5 16h-391c-11.7 0-22.5 6.4-28.1 16.7L18.7 175.1c-1.8 3.3-2.7 6.9-2.7 10.7C16 198 26 208 38.2 208H72 436.1c-3.5 5-6.6 10.4-9.3 16H80V464c0 17.7 14.3 32 32 32H336c17.7 0 32-14.3 32-32V256c0-4.4 3.6-8 8-8s8 3.6 8 8V464c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48V224H38.2C17.1 224 0 206.9 0 185.8zM136 248c4.4 0 8 3.6 8 8V360c0 4.4 3.6 8 8 8H296c4.4 0 8-3.6 8-8V256c0-4.4 3.6-8 8-8s8 3.6 8 8V360c0 13.3-10.7 24-24 24H152c-13.3 0-24-10.7-24-24V256c0-4.4 3.6-8 8-8zm392-40c-26.5 0-48 21.5-48 48v64h96V256c0-26.5-21.5-48-48-48zm-64 48c0-35.3 28.7-64 64-64s64 28.7 64 64v64h16c17.7 0 32 14.3 32 32V480c0 17.7-14.3 32-32 32H448c-17.7 0-32-14.3-32-32V352c0-17.7 14.3-32 32-32h16V256zm-16 80c-8.8 0-16 7.2-16 16V480c0 8.8 7.2 16 16 16H608c8.8 0 16-7.2 16-16V352c0-8.8-7.2-16-16-16H592 576 480 464 448z"],
    "family": [512, 512, [], "e300", "M176 64A48 48 0 1 0 80 64a48 48 0 1 0 96 0zM64 64a64 64 0 1 1 128 0A64 64 0 1 1 64 64zM41.8 234.7L37.7 284c-2.3 28 19.8 52 47.8 52H112h32 16v16h-8V480c0 8.8 7.2 16 16 16c2.9 0 5.6-.8 8-2.1V511c-2.6 .7-5.2 1-8 1c-17.7 0-32-14.3-32-32V352H120V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V344.8c-22.1-11.5-36.4-35.4-34.2-62.1l4.1-49.3C29.3 191.9 64 160 105.6 160h44.8c7 0 13.8 .9 20.2 2.6c-1.3 5.1-2.1 10.5-2.5 15.9c-5.7-1.6-11.6-2.5-17.8-2.5H105.6c-33.3 0-61 25.5-63.8 58.7zM344 512c-2.8 0-5.4-.3-8-1V493.9c2.4 1.4 5.1 2.1 8 2.1c8.8 0 16-7.2 16-16V384h-8V368h16 32 48 21.6c10.6 0 18.3-10.2 15.4-20.4L445.9 210.8C440 190.2 421.2 176 399.7 176H368.3c-8.8 0-17.1 2.4-24.3 6.6c-.1-5.8-.7-11.5-1.9-17c8.1-3.6 17-5.6 26.2-5.6h31.4c28.6 0 53.7 18.9 61.5 46.4l39.1 136.8c5.8 20.4-9.5 40.8-30.8 40.8H456v96c0 17.7-14.3 32-32 32s-32-14.3-32-32V384H376v96c0 17.7-14.3 32-32 32zM85.6 352c-4.7 0-9.2-.5-13.6-1.4V480c0 8.8 7.2 16 16 16s16-7.2 16-16V352H85.6zM432 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM320 64a64 64 0 1 1 128 0A64 64 0 1 1 320 64zM440 384H408v96c0 8.8 7.2 16 16 16s16-7.2 16-16V384zM296 184a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-96 0a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm56 88c-35.3 0-64 28.7-64 64v32c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V336c0-35.3-28.7-64-64-64zm-80 64c0-44.2 35.8-80 80-80s80 35.8 80 80v32c0 20.9-13.4 38.7-32 45.3V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V416H224v88c0 4.4-3.6 8-8 8s-8-3.6-8-8V413.3c-18.6-6.6-32-24.4-32-45.3V336z"],
    "hourglass-start": [384, 512, ["hourglass-1"], "f251", "M0 8C0 3.6 3.6 0 8 0H40 344h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H352V76.7c0 29.9-9.8 58.9-28 82.6l-74 96.7 74 96.7c18.1 23.7 28 52.8 28 82.6V496h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H344 40 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32V435.3c0-29.9 9.8-58.9 28-82.6l74-96.7L60 159.3c-18.1-23.7-28-52.8-28-82.6L32 16H8c-4.4 0-8-3.6-8-8zm48 8l0 60.7c0 26.3 8.7 52 24.7 72.9l77.7 101.6c2.2 2.9 2.2 6.9 0 9.7L72.7 362.4C56.7 383.4 48 409 48 435.3V496H336V435.3c0-26.3-8.7-52-24.7-72.9L233.6 260.9c-2.2-2.9-2.2-6.9 0-9.7l77.7-101.6c16-20.9 24.7-46.5 24.7-72.9V16H48zM198.4 228.8c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2L102.4 117.9C93.1 105.4 88 90.2 88 74.7V56c0-4.4 3.6-8 8-8H288c4.4 0 8 3.6 8 8V74.7c0 15.6-5.1 30.7-14.4 43.2L198.4 228.8zM115.2 108.3L192 210.7l76.8-102.4c7.3-9.7 11.2-21.5 11.2-33.6V64H104V74.7c0 12.1 3.9 23.9 11.2 33.6z"],
    "user-hair-buns": [448, 512, [], "e3d3", "M333.4 104H282.5c-14.9 0-29.1-5.9-39.6-16.4L229.7 74.3c-3.1-3.1-8.2-3.1-11.3 0L205.1 87.6C194.6 98.1 180.3 104 165.5 104H114.6c11-50.3 55.8-88 109.4-88s98.4 37.7 109.4 88zm2.3 16c.2 2.6 .3 5.3 .3 8v16c0 61.9-50.1 112-112 112s-112-50.1-112-112V128c0-2.7 .1-5.4 .3-8h53.2c19.1 0 37.4-7.6 50.9-21.1l7.6-7.6 7.6 7.6c13.5 13.5 31.8 21.1 50.9 21.1h53.2zM224 272c50.7 0 94.5-29.5 115.2-72.2C345.4 214 359.5 224 376 224c22.1 0 40-17.9 40-40V104c0-22.1-17.9-40-40-40c-13.6 0-25.6 6.8-32.8 17.2C324.5 33.6 278.2 0 224 0S123.5 33.6 104.8 81.2C97.6 70.8 85.6 64 72 64c-22.1 0-40 17.9-40 40v80c0 22.1 17.9 40 40 40c16.5 0 30.6-10 36.8-24.2C129.5 242.5 173.3 272 224 272zm128-88V144 128 104c0-13.3 10.7-24 24-24s24 10.7 24 24v80c0 13.3-10.7 24-24 24s-24-10.7-24-24zM168 320H280c83.9 0 152 68.1 152 152v8c0 8.8-7.2 16-16 16H32c-8.8 0-16-7.2-16-16v-8c0-83.9 68.1-152 152-152zm0-16C75.2 304 0 379.2 0 472v8c0 17.7 14.3 32 32 32H416c17.7 0 32-14.3 32-32v-8c0-92.8-75.2-168-168-168H168zM96 144v40c0 13.3-10.7 24-24 24s-24-10.7-24-24V104c0-13.3 10.7-24 24-24s24 10.7 24 24v24 16z"],
    "blender-phone": [576, 512, [], "f6b6", "M156.5 53.6l.1 0c3.1 2 4.2 5.7 2.9 8.8l-26.9 66.1c-1.2 3-4.4 5.1-8.1 4.7l-31-3c-7.8-.8-15 4.2-17 11.7c-8.9 32.8-8.9 67.4 0 100.2c2 7.5 9.2 12.5 17 11.7l31.1-3c3.7-.4 6.9 1.7 8.1 4.7l26.9 66.1c1.3 3.1 .2 6.8-2.9 8.8l-.1 0L99.8 366.7l0 0c-3.2 2-8 1.5-10.5-1c-97.8-96-97.8-251.5 0-347.5c2.5-2.5 7.3-3.1 10.5-1l0 0 56.6 36.3zM78.1 377.2c7.9 7.8 20.9 9.1 30.3 3.1l56.7-36.4c9.6-6.1 13.4-17.9 9.2-28.3l-26.9-66.1c-3.9-9.7-13.9-15.6-24.5-14.6l-31.1 3c-8.2-30-8.2-61.8 0-91.8l31 3c10.6 1 20.5-4.9 24.5-14.6l26.9-66.1c4.2-10.4 .4-22.2-9.2-28.3L108.4 3.8C99-2.2 86-.9 78.1 6.8C-26 109.1-26 274.9 78.1 377.2zm393.3-24.8c-2.4-.2-4.9-.3-7.4-.3H240c-.9 0-1.7 0-2.6 0L210.8 33.3C210.1 24 217.4 16 226.8 16H535c10.4 0 18 9.8 15.5 19.9L535.5 96H360c-4.4 0-8 3.6-8 8s3.6 8 8 8H531.5l-20 80H360c-4.4 0-8 3.6-8 8s3.6 8 8 8H507.5L471.4 352.3zm15.7 3.1L566.1 39.8C571.1 19.6 555.8 0 535 0H226.8c-18.7 0-33.4 16-31.9 34.7l26.6 319.5c-35.3 8.3-61.5 40-61.5 77.9v32c0 26.5 21.5 48 48 48H496c26.5 0 48-21.5 48-48V432c0-36.1-24-66.7-56.9-76.6zM176 432c0-35.3 28.7-64 64-64H464c35.3 0 64 28.7 64 64v32c0 17.7-14.3 32-32 32H208c-17.7 0-32-14.3-32-32V432zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "hourglass-clock": [576, 512, [], "e41b", "M0 8C0 3.6 3.6 0 8 0H40 344h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H352V76.7c0 29.9-9.8 58.9-28 82.6l-74 96.7 24.9 32.5c-2.7 5.4-5.2 11-7.4 16.7l-33.9-44.3c-2.2-2.9-2.2-6.9 0-9.7l77.7-101.6c16-20.9 24.7-46.5 24.7-72.9V16H48l0 60.7c0 26.3 8.7 52 24.7 72.9l77.7 101.6c2.2 2.9 2.2 6.9 0 9.7L72.7 362.4C56.7 383.4 48 409 48 435.3V496H311.2c6.1 5.8 12.7 11.1 19.6 16H40 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32V435.3c0-29.9 9.8-58.9 28-82.6l74-96.7L60 159.3c-18.1-23.7-28-52.8-28-82.6L32 16H8c-4.4 0-8-3.6-8-8zM104 448H275.2c2.8 5.5 5.9 10.8 9.3 16H96c-4.4 0-8-3.6-8-8V437c0-15.3 4.9-30.2 13.9-42.6l75.6-103.1c2.6-3.6 7.6-4.3 11.2-1.7s4.3 7.6 1.7 11.2L114.8 403.8c-7 9.6-10.8 21.2-10.8 33.1v11zm8.8-323.6c1.4-2.7 4.1-4.4 7.2-4.4H264c3 0 5.8 1.7 7.2 4.4s1.1 6-.8 8.4l-72 96c-1.5 2-3.9 3.2-6.4 3.2s-4.9-1.2-6.4-3.2l-72-96c-1.8-2.4-2.1-5.7-.8-8.4zM136 136l56 74.7L248 136H136zM432 496a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-272a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 64c4.4 0 8 3.6 8 8v64h48c4.4 0 8 3.6 8 8s-3.6 8-8 8H432c-4.4 0-8-3.6-8-8V296c0-4.4 3.6-8 8-8z"],
    "person-seat-reclined": [512, 512, [], "e21f", "M241 240c-4.9 0-9.6 2.3-12.6 6.2s-4.1 8.9-2.9 13.7l8 32c1.8 7.1 8.2 12.1 15.5 12.1h69.8c26.7 0 50.6 16.5 59.9 41.5l25.5 68c3 8.1 11.9 12.3 20 9.6l18.7-6.2c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-48 16c-8.2 2.7-17-1.5-20-9.6l-36.3-96.9c-4.7-12.5-16.6-20.8-30-20.8H224.7v0l-.3 0c-.2 0-.5 0-.7 0l0 0h-.3H217c-22 0-41.2-15-46.6-36.4l-21.1-84.5c-5-19.9 10.1-39.2 30.6-39.2c13.5 0 25.4 8.6 29.8 21.2c2.2 6.5 8.3 10.8 15.1 10.8H320c8.8 0 16 7.2 16 16s-7.2 16-16 16H241zM128 80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM249 288l-4-16-4-16h16.5H320c17.7 0 32-14.3 32-32s-14.3-32-32-32H224.8c-6.6-19-24.5-32-44.9-32c-30.9 0-53.6 29.1-46.1 59l21.1 84.5C162 332 187.6 352 217 352h6.3c.5 0 .9 0 1.4 0h94.1c6.7 0 12.6 4.1 15 10.4L370 459.2c6 16.1 23.8 24.6 40.1 19.1l48-16c16.8-5.6 25.8-23.7 20.2-40.5s-23.7-25.8-40.5-20.2l-18.7 6.2-25.5-68c-11.7-31.2-41.6-51.9-74.9-51.9H249zM208 80a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM47.8 134.4c-.9-4.3-5.1-7.1-9.4-6.2s-7.1 5.1-6.2 9.4L72.4 333c10 48.3 52.5 83 101.9 83H296c4.4 0 8-3.6 8-8s-3.6-8-8-8H174.2c-41.8 0-77.8-29.4-86.2-70.3L47.8 134.4z"],
    "paper-plane-top": [512, 512, ["paper-plane-alt", "send"], "e20a", "M20.4 53c-4.6 4.9-5.7 12.1-2.7 18.1L106.1 248H493.9c-1.7-2.9-4.3-5.3-7.6-6.7l-448-192C32.1 46.6 25 48.1 20.4 53zm85.8 211L17.7 440.8c-3 6-1.9 13.2 2.7 18.1s11.8 6.4 17.9 3.7l6.3 14.7c-12.3 5.3-26.7 2.3-35.9-7.5s-11.3-24.3-5.3-36.3L92.2 256 3.4 78.3c-6-12-3.9-26.5 5.3-36.3s23.5-12.7 35.9-7.5l448 192c11.8 5 19.4 16.6 19.4 29.4s-7.6 24.4-19.4 29.4l-448 192-6.3-14.7 448-192c3.2-1.4 5.9-3.8 7.6-6.7H106.1z"],
    "message-arrow-up": [512, 512, ["comment-alt-arrow-up"], "e1dc", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM264 123.3l74.3 74.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-88-88c-3.1-3.1-8.2-3.1-11.3 0l-88 88c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L248 123.3V296c0 4.4 3.6 8 8 8s8-3.6 8-8V123.3z"],
    "lightbulb-exclamation": [384, 512, [], "f671", "M352 176c0 33.9-10.5 65.3-28.5 91.2c-4.5 6.5-9.5 13.3-14.5 20.2c-12.5 17.2-25.9 35.5-36.3 54.4c-7.4 13.5-11.6 27.8-14 42.2H275c2.2-12 5.9-23.7 11.8-34.5c9.9-18 22.2-34.9 34.5-51.8l0 0 0 0 0 0c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C368 78.8 289.2 0 192 0S16 78.8 16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4l0 0 0 0 0 0c12.3 16.8 24.6 33.7 34.5 51.8c5.9 10.8 9.6 22.5 11.8 34.5h16.2c-2.4-14.4-6.6-28.7-14-42.2c-10.4-19-23.7-37.3-36.3-54.4l0 0 0 0c-5-6.9-10-13.7-14.5-20.2C42.5 241.3 32 209.9 32 176C32 87.6 103.6 16 192 16s160 71.6 160 160zM128 432H256c0 35.3-28.7 64-64 64s-64-28.7-64-64zm-16 0c0 44.2 35.8 80 80 80s80-35.8 80-80v-5.3c0-5.9-4.8-10.7-10.7-10.7H122.7c-5.9 0-10.7 4.8-10.7 10.7V432zM192 96c-4.4 0-8 3.6-8 8V264c0 4.4 3.6 8 8 8s8-3.6 8-8V104c0-4.4-3.6-8-8-8zm16 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "layer-minus": [576, 512, ["layer-group-minus"], "f5fe", "M408 72H520c4.4 0 8 3.6 8 8s-3.6 8-8 8H408c-4.4 0-8-3.6-8-8s3.6-8 8-8zM269.4 132.1c5.8-2.7 12.2-4.1 18.6-4.1s12.8 1.4 18.6 4.1L532.1 237.4C539.4 240.7 544 248 544 256s-4.6 15.3-11.9 18.6L306.6 379.9c-5.8 2.7-12.2 4.1-18.6 4.1s-12.8-1.4-18.6-4.1L43.9 274.6C36.6 271.3 32 264 32 256s4.6-15.3 11.9-18.6L269.4 132.1zM288 144c-4.1 0-8.2 .9-11.9 2.6L50.6 251.9c-1.6 .7-2.6 2.4-2.6 4.1s1 3.4 2.6 4.1L276.1 365.4c3.7 1.7 7.8 2.6 11.9 2.6s8.2-.9 11.9-2.6L525.4 260.1c1.6-.7 2.6-2.4 2.6-4.1s-1-3.4-2.6-4.1L299.9 146.6c-3.7-1.7-7.8-2.6-11.9-2.6zM43.9 365.4l59.4-27.7 18.9 8.8L50.6 379.9c-1.6 .7-2.6 2.4-2.6 4.1s1 3.4 2.6 4.1L276.1 493.4c3.7 1.7 7.8 2.6 11.9 2.6s8.2-.9 11.9-2.6L525.4 388.1c1.6-.7 2.6-2.4 2.6-4.1s-1-3.4-2.6-4.1l-71.5-33.4 18.9-8.8 59.4 27.7C539.4 368.7 544 376 544 384s-4.6 15.3-11.9 18.6L306.6 507.9c-5.8 2.7-12.2 4.1-18.6 4.1s-12.8-1.4-18.6-4.1L43.9 402.6C36.6 399.3 32 392 32 384s4.6-15.3 11.9-18.6z"],
    "chart-pie-simple-circle-currency": [640, 512, [], "e604", "M272 240H375.2c-5.3 5-10.3 10.4-15 16H272c-8.8 0-16-7.2-16-16V17.7C256 8.1 263.4 0 273.1 0c116 0 212.7 82.7 234.4 192.4c-3.8-.2-7.6-.4-11.5-.4c-1.7 0-3.3 0-4.9 .1C469.5 91.4 380.1 16 273.1 16c-.1 0-.2 0-.3 0c-.1 0-.2 .1-.3 .2c-.3 .3-.5 .8-.5 1.4V240zm-32 48h99.2c-2.7 5.2-5.1 10.5-7.2 16H224c-8.8 0-16-7.2-16-16V66.7c0-10-8-15.3-14.5-13.9C92.1 74.2 16 164.3 16 272c0 123.7 100.3 224 224 224c40.1 0 77.8-10.6 110.4-29.1c3 4.5 6.3 8.8 9.7 12.9C324.8 500.3 283.8 512 240 512C107.5 512 0 404.5 0 272C0 156.5 81.5 60.1 190.2 37.2c18.1-3.8 33.8 11 33.8 29.5V272v16h16zM496 496a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-272a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 200a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm56.3-11.1l13.4 13.4c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-13.4-13.4C528.6 434.1 513 440 496 440s-32.6-5.9-44.9-15.7l-13.4 13.4c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l13.4-13.4C429.9 400.6 424 385 424 368s5.9-32.6 15.7-44.9l-13.4-13.4c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l13.4 13.4C463.4 301.9 479 296 496 296s32.6 5.9 44.9 15.7l13.4-13.4c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-13.4 13.4C562.1 335.4 568 351 568 368s-5.9 32.6-15.7 44.9z"],
    "circle-e": [512, 512, [], "e109", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128c-13.3 0-24 10.7-24 24V256 360c0 13.3 10.7 24 24 24H344c4.4 0 8-3.6 8-8s-3.6-8-8-8H184c-4.4 0-8-3.6-8-8V264H304c4.4 0 8-3.6 8-8s-3.6-8-8-8H176V152c0-4.4 3.6-8 8-8H344c4.4 0 8-3.6 8-8s-3.6-8-8-8H184z"],
    "building-wheat": [640, 512, [], "e4db", "M336 16c17.7 0 32 14.3 32 32V464c0 17.7-14.3 32-32 32H240V416c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-17.7 0-32-14.3-32-32V48c0-17.7 14.3-32 32-32H336zM224 416v80H160V416c0-17.7 14.3-32 32-32s32 14.3 32 32zM48 512h96 16 64 16 96c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H48C21.5 0 0 21.5 0 48V464c0 26.5 21.5 48 48 48zM80 256v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H104c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V256c0-4.4 3.6-8 8-8zm144-16c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H248zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V256zM80 128v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H104c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V128c0-4.4 3.6-8 8-8zm144-16c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H248zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V128zM624 240c0 35.3-28.7 64-64 64H536V288c0-35.3 28.7-64 64-64h24v16zm-96 77.9c2.4 1.4 5.1 2.1 8 2.1h16c-10.1 7.6-18.4 17.6-24 29.1c-5.6-11.5-13.9-21.5-24-29.1l16 0c2.9 0 5.6-.8 8-2.1zM448 304H432c-8.8 0-16 7.2-16 16v16c0 26.2 12.6 49.4 32 64H432c-8.8 0-16 7.2-16 16v16c0 44.2 35.8 80 80 80l24 0c2.9 0 5.6-.8 8-2.1c2.4 1.4 5.1 2.1 8 2.1h24c44.2 0 80-35.8 80-80V416c0-8.8-7.2-16-16-16H608c19.4-14.6 32-37.8 32-64V320c0-8.8-7.2-16-16-16H608c19.4-14.6 32-37.8 32-64V224c0-8.8-7.2-16-16-16H600c-31.7 0-59 18.4-72 45.1c-13-26.7-40.3-45.1-72-45.1H432c-8.8 0-16 7.2-16 16v16c0 26.2 12.6 49.4 32 64zm72-16v16l-24 0c-35.3 0-64-28.7-64-64V224h24c35.3 0 64 28.7 64 64zm104 48c0 35.3-28.7 64-64 64H536V384c0-35.3 28.7-64 64-64h24v16zm-96 77.9c2.4 1.4 5.1 2.1 8 2.1h16c-10.1 7.6-18.4 17.6-24 29.1c-5.6-11.5-13.9-21.5-24-29.1l16 0c2.9 0 5.6-.8 8-2.1zM520 384v16l-24 0c-35.3 0-64-28.7-64-64V320h24c35.3 0 64 28.7 64 64zm104 32v16c0 35.3-28.7 64-64 64H536V480c0-35.3 28.7-64 64-64h24zM520 496l-24 0c-35.3 0-64-28.7-64-64V416h24c35.3 0 64 28.7 64 64v16zm8-464c-4.4 0-8 3.6-8 8V184c0 4.4 3.6 8 8 8s8-3.6 8-8V40c0-4.4-3.6-8-8-8zm80 40c0-4.4-3.6-8-8-8s-8 3.6-8 8v80c0 4.4 3.6 8 8 8s8-3.6 8-8V72zM456 64c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8s8-3.6 8-8V72c0-4.4-3.6-8-8-8z"],
    "gauge-max": [512, 512, ["tachometer-alt-fastest"], "f626", "M256 496a240 240 0 1 0 0-480 240 240 0 1 0 0 480zM256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zm16 80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM208 352a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm-16 0c0-35.3 28.7-64 64-64c18.8 0 35.7 8.1 47.4 21l108-75.6c3.6-2.5 8.6-1.7 11.1 2s1.7 8.6-2 11.1l-108 75.6c4.7 8.9 7.4 19.1 7.4 29.9c0 35.3-28.7 64-64 64s-64-28.7-64-64zM384 128a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM96 224a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64-96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z"],
    "person-breastfeeding": [448, 512, [], "e53a", "M424.6 372.5l0 0-.2 .3L361 452c-11 13.8-31.2 16-45 5c-9.5-7.6-13.5-19.5-11.5-30.8l0-.1L366.2 349c2.8-3.4 2.2-8.5-1.2-11.2s-8.5-2.2-11.2 1.2l-55.6 69.6-7-1c-37-5.6-70.7-24.1-95.2-52.2V320c0-19.9-16.1-36-36-36s-36 16.1-36 36v48c0 6 1.5 11.9 4.4 17.2l2.4 4.4 4.5 2.3 87 43.5c15.8 7.9 22.2 27.1 14.3 42.9s-27.1 22.2-42.9 14.3L34.4 413l0 0-.2-.1c-.7-.4-1.5-.7-2.2-1.2l0 0c-3.3-1.9-6.1-4.3-8.4-7l0 0c-3-3.6-5.2-7.8-6.4-12.2c-2.2-8-1.2-16.8 3.2-24.4l0 0c.4-.7 .9-1.5 1.4-2.1l0 0 .1-.2L88.9 265c23.7-35.6 63.7-57 106.5-57h75.2c41.3 0 80.1 20 104.2 53.6l50.7 70.9 0 0 .2 .3c1.5 2 2.7 4.1 3.7 6.3l0 0c1.9 4.4 2.8 9.1 2.7 13.8c-.2 7.1-2.8 14-7.4 19.6zM180 320v41.1c24.9 30.7 59.5 51.9 98 60.2c3.5 .8 7.1 1.4 10.7 2c-.2 1-.3 2-.4 3c-1.9 15.9 4.2 32.4 17.7 43.2c20.7 16.6 50.9 13.2 67.5-7.5l63.3-79.2c7-8.4 10.8-18.8 11.2-29.4c.2-7-1.1-14.1-4-20.8c-1.5-3.3-3.3-6.5-5.5-9.4l-50.7-70.9c-27-37.8-70.7-60.3-117.2-60.3H195.4c-48.1 0-93.1 24.1-119.8 64.1L8.5 356.7c-.7 1-1.4 2.1-2 3.2c-6.6 11.4-8 24.6-4.8 36.6c1.8 6.7 5 12.9 9.6 18.4c3.5 4.1 7.7 7.7 12.6 10.6c1.1 .6 2.2 1.2 3.3 1.7l159.3 79.7c23.7 11.9 52.5 2.2 64.4-21.5s2.2-52.5-21.5-64.4l-87-43.5c-1.6-2.9-2.4-6.2-2.4-9.5V320c0-11 9-20 20-20s20 9 20 20zM160 80a64 64 0 1 1 128 0A64 64 0 1 1 160 80zM272 376a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM224 160A80 80 0 1 0 224 0a80 80 0 1 0 0 160zm16 168a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "apostrophe": [192, 512, [], "27", "M80 352c61.9 0 112-50.1 112-112V152 136 104c0-39.8-32.2-72-72-72H72C32.2 32 0 64.2 0 104v48c0 39.8 32.2 72 72 72h48c22.6 0 42.8-10.4 56-26.7V240c0 53-43 96-96 96H72c-4.4 0-8 3.6-8 8s3.6 8 8 8h8zm96-200c0 30.9-25.1 56-56 56H72c-30.9 0-56-25.1-56-56V104c0-30.9 25.1-56 56-56h48c30.9 0 56 25.1 56 56v32 16z"],
    "fire-hydrant": [384, 512, [], "e17f", "M192 0c-4.4 0-8 3.6-8 8V32l0 .2C122.4 36 72.5 83.5 65 144H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H64 80 304h16 24c4.4 0 8-3.6 8-8s-3.6-8-8-8H319C311.5 83.5 261.6 36 200 32.2l0-.2V8c0-4.4-3.6-8-8-8zm0 48c56.4 0 103.1 41.7 110.9 96H81.1C88.9 89.7 135.6 48 192 48zm80 272a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-80-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM40 496c-4.4 0-8 3.6-8 8s3.6 8 8 8H72 312h32c4.4 0 8-3.6 8-8s-3.6-8-8-8H320V392h24c22.1 0 40-17.9 40-40V288c0-22.1-17.9-40-40-40H320V192H304v64V384 496H80V384 256 192H64v56H40c-22.1 0-40 17.9-40 40v64c0 22.1 17.9 40 40 40H64V496H40zM64 376H40c-13.3 0-24-10.7-24-24V288c0-13.3 10.7-24 24-24H64V376zm256 0V264h24c13.3 0 24 10.7 24 24v64c0 13.3-10.7 24-24 24H320z"],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", "M332.7 264c2.1-2.1 3.3-5 3.3-8s-1.2-5.9-3.3-8L200.6 116.2c-2.7-2.7-6.4-4.2-10.2-4.2c-8 0-14.4 6.5-14.4 14.4l0 73.6c0 4.4-3.6 8-8 8L32 208c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l136 0c4.4 0 8 3.6 8 8l0 73.6c0 8 6.5 14.4 14.4 14.4c3.8 0 7.5-1.5 10.2-4.2L332.7 264zm19.3-8c0 7.2-2.9 14.2-8 19.3L211.9 407.1c-5.7 5.7-13.4 8.9-21.5 8.9c-16.8 0-30.4-13.6-30.4-30.4l0-65.6L32 320c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l128 0 0-65.6c0-16.8 13.6-30.4 30.4-30.4c8.1 0 15.8 3.2 21.5 8.9L344 236.7c5.1 5.1 8 12.1 8 19.3zM328 464l96 0c39.8 0 72-32.2 72-72l0-272c0-39.8-32.2-72-72-72l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8l96 0c48.6 0 88 39.4 88 88l0 272c0 48.6-39.4 88-88 88l-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "video-plus": [576, 512, [], "f4e1", "M320 80c26.5 0 48 21.5 48 48v74.9V309.1 384c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V128c0-26.5 21.5-48 48-48H320zm64 304V336.8 309.1 202.9 175.2 128c0-35.3-28.7-64-64-64H64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64zm32-29.6l103.4 56.9c5.6 3.1 12 4.7 18.4 4.7c21.1 0 38.2-17.1 38.2-38.2V134.2c0-21.1-17.1-38.2-38.2-38.2c-6.4 0-12.8 1.6-18.4 4.7L416 157.6v18.3l111.1-61.1c3.3-1.8 7-2.7 10.7-2.7c12.3 0 22.2 9.9 22.2 22.2V377.8c0 12.3-9.9 22.2-22.2 22.2c-3.7 0-7.4-.9-10.7-2.7L416 336.1v18.3zM200 168c0-4.4-3.6-8-8-8s-8 3.6-8 8v80H104c-4.4 0-8 3.6-8 8s3.6 8 8 8h80v80c0 4.4 3.6 8 8 8s8-3.6 8-8V264h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H200V168z"],
    "square-right": [448, 512, [10145, "arrow-alt-square-right"], "f352", "M432 96c0-26.5-21.5-48-48-48L64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320zM384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM368 256c0 7.2-2.9 14.2-8 19.3L260.3 375c-5.7 5.7-13.5 9-21.7 9c-16.9 0-30.6-13.7-30.6-30.6l0-49.4-88 0c-22.1 0-40-17.9-40-40l0-16c0-22.1 17.9-40 40-40l88 0 0-49.4c0-16.9 13.7-30.6 30.6-30.6c8.1 0 15.9 3.2 21.7 9L360 236.7c5.1 5.1 8 12.1 8 19.3zm-19.3-8L249 148.3c-2.7-2.7-6.5-4.3-10.3-4.3c-8.1 0-14.6 6.5-14.6 14.6l0 57.4c0 4.4-3.6 8-8 8l-96 0c-13.3 0-24 10.7-24 24l0 16c0 13.3 10.7 24 24 24l96 0c4.4 0 8 3.6 8 8l0 57.4c0 8.1 6.5 14.6 14.6 14.6c3.9 0 7.6-1.5 10.3-4.3L348.7 264c2.1-2.1 3.3-5 3.3-8s-1.2-5.9-3.3-8z"],
    "comment-smile": [512, 512, [], "f4b4", "M157.3 415c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8C68.3 456 41.6 464 16 464l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C28 450 34 442 40 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C31.9 318.8 16 280.7 16 240C16 136.9 120.2 48 256 48s240 88.9 240 192s-104.2 192-240 192c-35.2 0-68.6-6.1-98.7-17zM4.7 452.7l0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0zM192 208a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm128 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM161.2 282c-3.3 2.9-3.6 8-.6 11.3C184 319.5 218.1 336 256 336s72-16.5 95.4-42.7c2.9-3.3 2.7-8.3-.6-11.3s-8.3-2.7-11.3 .6C319 305.6 289.2 320 256 320s-63-14.4-83.5-37.3c-2.9-3.3-8-3.6-11.3-.6z"],
    "venus": [384, 512, [9792], "f221", "M32 176a160 160 0 1 1 320 0A160 160 0 1 1 32 176zM200 351.8c93.5-4.2 168-81.3 168-175.8C368 78.8 289.2 0 192 0S16 78.8 16 176c0 94.5 74.5 171.6 168 175.8V416H104c-4.4 0-8 3.6-8 8s3.6 8 8 8h80v72c0 4.4 3.6 8 8 8s8-3.6 8-8V432h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H200V351.8z"],
    "passport": [448, 512, [], "f5ab", "M384 16c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H384zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM96 392c0 4.4 3.6 8 8 8H344c4.4 0 8-3.6 8-8s-3.6-8-8-8H104c-4.4 0-8 3.6-8 8zm.2-208c-.2 2.6-.2 5.3-.2 8s.1 5.4 .2 8C100.4 267 156 320 224 320s123.6-53 127.8-120c.2-2.6 .2-5.3 .2-8s-.1-5.4-.2-8C347.6 117 292 64 224 64s-123.6 53-127.8 120zm16 16h55.8c1.4 41.3 13.1 70.2 25.1 89.3c3.1 4.9 6.1 9 9.1 12.6c-48.9-9.6-86.4-51.1-90-101.9zm223.4 0c-3.6 50.8-41.1 92.3-90 101.9c2.9-3.6 6-7.8 9.1-12.6c12-19 23.8-48 25.1-89.3h55.8zm0-16H279.9c-1.4-41.3-13.1-70.2-25.1-89.3c-3.1-4.9-6.1-9-9.1-12.6c48.9 9.6 86.4 51.1 90 101.9zm-223.4 0c3.6-50.8 41.1-92.3 90-101.9c-2.9 3.6-6 7.8-9.1 12.6c-12 19-23.8 48-25.1 89.3H112.3zm94.5-80.7c5.6-8.9 11.2-15.2 15.3-19.2c.7-.7 1.3-1.3 1.9-1.8c.6 .5 1.2 1.1 1.9 1.8c4.1 4 9.7 10.3 15.3 19.2c10.5 16.6 21.3 42.7 22.6 80.7H184.1c1.3-38.1 12.1-64.1 22.6-80.7zM263.9 200c-1.3 38.1-12.1 64.1-22.6 80.7c-5.6 8.9-11.2 15.2-15.3 19.2c-.7 .7-1.3 1.3-1.9 1.8c-.6-.5-1.2-1.1-1.9-1.8c-4.1-4-9.7-10.3-15.3-19.2c-10.5-16.6-21.3-42.7-22.6-80.7h79.7z"],
    "inbox-in": [512, 512, [128229, "inbox-arrow-down"], "f310", "M264 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V292.7L141.7 186.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l120 120c3.1 3.1 8.2 3.1 11.3 0l120-120c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L264 292.7V8zM48 336h74.3c12.1 0 23.2 6.8 28.6 17.7l9.9 19.8c8.1 16.3 24.8 26.5 42.9 26.5H308.2c18.2 0 34.8-10.3 42.9-26.5l9.9-19.8c5.4-10.8 16.5-17.7 28.6-17.7H464c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32H48c-17.7 0-32-14.3-32-32V368c0-17.7 14.3-32 32-32zm298.7 10.5l-9.9 19.8c-5.4 10.8-16.5 17.7-28.6 17.7H203.8c-12.1 0-23.2-6.8-28.6-17.7l-9.9-19.8c-8.1-16.3-24.8-26.5-42.9-26.5H48c-26.5 0-48 21.5-48 48v96c0 26.5 21.5 48 48 48H464c26.5 0 48-21.5 48-48V368c0-26.5-21.5-48-48-48H389.7c-18.2 0-34.8 10.3-42.9 26.5z"],
    "heart-pulse": [512, 512, ["heartbeat"], "f21e", "M393.6 57.7C451.9 65.3 496 115 496 173.6c0 30.3-11.7 59.3-32.8 81.1L462 256H371.8c-9.1 0-17.4-5.1-21.5-13.3l-23.2-46.3c-1.4-2.7-4.1-4.4-7.2-4.4s-5.8 1.7-7.2 4.4L256.4 309.4 191.3 164.7c-1.3-2.9-4.2-4.8-7.4-4.7s-6 2-7.3 4.9l-31.8 76.3c-3.7 8.9-12.5 14.8-22.2 14.8H50.1l-1.3-1.3C27.8 232.9 16 203.8 16 173.5C16 114.9 60.1 65.3 118.3 57.7c42.9-5.6 85.8 12.6 111.2 47.6l20 27.5c1.5 2.1 3.9 3.3 6.5 3.3s5-1.2 6.5-3.3l20-27.5c25.4-34.9 68.3-53.2 111.2-47.6zM464 272h4.8l6-6.2C498.6 241.1 512 208 512 173.6c0-66.8-50.2-123.2-116.3-131.8c-48.6-6.3-97.3 14.3-126.2 54L256 114.4 242.5 95.8c-28.9-39.7-77.6-60.4-126.2-54C50.2 50.4 0 106.8 0 173.5c0 34.5 13.4 67.6 37.4 92.3l6 6.2H47c0 0 0 0 0 0h75.7c16.1 0 30.7-9.7 36.9-24.6l24.7-59.3 64.4 143.2c1.3 2.8 4 4.7 7.1 4.7s5.9-1.7 7.3-4.4L320 217.9l16 32c6.8 13.6 20.6 22.1 35.8 22.1H464s0 0 0 0zM74.3 304L236.5 471.6c5.2 5.4 12.4 8.4 19.9 8.4c7.5 0 14.7-3.1 19.9-8.5L437.9 304H415.7l-151 156.4c-2.2 2.3-5.2 3.6-8.4 3.6s-6.2-1.3-8.4-3.6L96.6 304H74.3z"],
    "circle-8": [512, 512, [], "e0f5", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM264 128c35.3 0 64 28.7 64 64c0 22.3-11.4 41.9-28.7 53.4C325.5 256.1 344 281.9 344 312c0 39.8-32.2 72-72 72H240c-39.8 0-72-32.2-72-72c0-30.1 18.5-55.9 44.7-66.6C195.4 233.9 184 214.3 184 192c0-35.3 28.7-64 64-64h16zM248 240c0 0 0 0 0 0h16c0 0 0 0 0 0c26.5 0 48-21.5 48-48c0-26.5-21.5-48-48-48H248c-26.5 0-48 21.5-48 48c0 26.5 21.5 48 48 48zm16 16H248h-8c-30.9 0-56 25.1-56 56s25.1 56 56 56h32c30.9 0 56-25.1 56-56s-25.1-56-56-56h-8z"],
    "clouds-moon": [640, 512, [], "f745", "M368 160c0-79.5 64.3-144 143.5-144c4.1 0 8.2 .2 12.2 .5c-40.2 22.8-67.4 66.1-67.4 115.8c0 73.4 59.3 132.9 132.5 132.9c7.8 0 15.3-.7 22.7-1.9c-25.8 25.2-61.1 40.7-100 40.7c-17.6 0-34.4-3.2-49.9-9l.3 1.3c14.2 5.5 27.2 13.4 38.5 23.2c3.7 .3 7.4 .4 11.2 .4c43.2 0 82.5-17.3 111.2-45.3c5-4.9 6.3-12.5 3.1-18.7s-10.1-9.7-17-8.5c-6.5 1.1-13.2 1.7-20 1.7c-64.3 0-116.5-52.3-116.5-116.9c0-43.7 23.9-81.8 59.3-101.9c6.1-3.5 9.2-10.5 7.7-17.3S532 1.2 525.1 .6c-4.5-.4-9-.6-13.5-.6C423.4 0 352 71.7 352 160c0 11.5 1.2 22.7 3.5 33.4c5.9 .9 11.7 2.2 17.4 3.9c-3.2-11.9-4.9-24.4-4.9-37.4zm-32.1 80c44.2 0 80 35.8 80 80c0 2.5-.1 5.1-.4 7.6c-.2 2.1 .5 4.2 1.8 5.9s3.3 2.7 5.5 2.8c40.9 3.5 73 37.9 73 79.7c0 44.2-35.8 80-80 80c-.9 0-1.8 0-2.8 0l-.3 0v0H146.5h-.3l0 0c-.7 0-1.5 0-2.2 0c-35.3 0-64-28.7-64-64c0-34.2 26.8-62.1 60.5-63.9c2.5-.1 4.8-1.4 6.2-3.5s1.7-4.7 .9-7.1c-2.4-6.7-3.7-13.9-3.7-21.4c0-35.3 28.7-64 64-64c16.5 0 31.6 6.2 42.9 16.5c1.9 1.7 4.5 2.4 6.9 1.9s4.6-2.1 5.7-4.4c12.8-27.2 40.4-46 72.4-46zm96 80c0-53-43-96-96-96c-34.9 0-65.4 18.6-82.2 46.4c-13-9.1-28.8-14.4-45.8-14.4c-44.2 0-80 35.8-80 80c0 5.9 .6 11.7 1.9 17.2C92.4 359.9 64 392.6 64 432c0 44.2 35.8 80 80 80c.9 0 1.8 0 2.6 0H412.7c1.1 0 2.1 .1 3.2 .1c53 0 96-43 96-96c0-47.6-34.6-87-80-94.7l0-1.3zM320 192.1h0c0-35.3-28.6-64-64-64c-7.4 0-14.6 1.3-21.2 3.6c-11.5-30.1-40.6-51.6-74.8-51.6c-38.9 0-71.3 27.8-78.5 64.6c-3.1-.4-6.3-.6-9.5-.6c-39.8 0-72 32.2-72 72s32.2 72 72 72l0 0h34.8c2.7-5.6 5.8-11 9.3-16h-43c-.3 0-.7 0-1 0c-30.9 0-56-25.1-56-56s25.1-56 56-56c2.5 0 5 .2 7.4 .5c8.4 1.1 16.2-4.5 17.8-12.8c5.7-29.4 31.7-51.7 62.8-51.7c27.3 0 50.7 17.1 59.8 41.3c3.1 8.1 12.1 12.3 20.3 9.4c5-1.7 10.3-2.7 15.9-2.7c26.5 0 48 21.5 48 48c0 .2 0 .5 0 .7c0 1.1 0 2.2-.1 3.3c5.2-1.4 10.6-2.4 16.1-3.1l0-.9z"],
    "clock-ten-thirty": [512, 512, [], "e355", "M16 256a240 240 0 1 1 480 0A240 240 0 1 1 16 256zm496 0A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM264 408V256c0-2.7-1.3-5.2-3.6-6.7l-96-64c-3.7-2.5-8.6-1.5-11.1 2.2s-1.5 8.6 2.2 11.1L248 260.3V408c0 4.4 3.6 8 8 8s8-3.6 8-8z"],
    "people-carry-box": [640, 512, ["people-carry"], "f4ce", "M128 16a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm48 32A48 48 0 1 1 80 48a48 48 0 1 1 96 0zm-69.4 96C83.1 144 64 163.1 64 186.6v88.1c0 12.7 5.1 24.9 14.1 33.9l81.2 81.2c1.2 1.2 2 2.7 2.2 4.3l14.7 88.4c1.5 8.7 9.7 14.6 18.4 13.2s14.6-9.7 13.2-18.4l-15.2-90.9c-1.1-6.6-4.2-12.7-8.9-17.4l-53.3-53.3c-1.5-1.5-2.3-3.5-2.3-5.7V215.3c0-3.5 2.3-6.6 5.7-7.7s7 .3 9 3.2l33.7 50.5c3.1 4.6 7.3 8.4 12.3 10.9l60.2 30.1c2.3 1.2 4.7 1.7 7.2 1.7v0h.3c5.7-.1 11.2-3.3 14-8.8c4-7.9 .7-17.5-7.2-21.5l-58.3-29.1c-1.2-.6-2.3-1.6-3.1-2.7l-48.6-72.9c-10.4-15.6-27.8-24.9-46.5-24.9zm150 176c-5 .1-10.1-1-15-3.4l-60.2-30.1c-7.5-3.7-13.8-9.4-18.5-16.3l-19-28.5v65.1l51 51c7.1 7.1 11.8 16.2 13.4 26.1l15.2 90.9c2.9 17.4-8.9 33.9-26.3 36.8s-33.9-8.9-36.8-26.3l-14.3-85.9L66.7 320C54.7 308 48 291.7 48 274.7V186.6c0-32.4 26.2-58.6 58.6-58.6c24.1 0 46.5 12 59.9 32l47.4 71.1 10.1 5V160c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32v76.2l10.1-5L473.5 160c13.3-20 35.8-32 59.9-32c32.4 0 58.6 26.2 58.6 58.6v88.1c0 17-6.7 33.3-18.7 45.3l-79.4 79.4-14.3 85.9c-2.9 17.4-19.4 29.2-36.8 26.3s-29.2-19.4-26.3-36.8l15.2-90.9c1.6-9.9 6.3-19 13.4-26.1l51-51V241.7l-19 28.5c-4.6 7-11 12.6-18.5 16.3l-60.2 30.1c-4.8 2.4-9.9 3.5-15 3.4H256.6zm99.6-16c-.3-.6-.6-1.1-.9-1.7c-7.9-15.8-1.5-35 14.3-42.9L400 244.2V160c0-8.8-7.2-16-16-16H256c-8.8 0-16 7.2-16 16v84.2l30.3 15.2c15.8 7.9 22.2 27.1 14.3 42.9c-.3 .6-.6 1.1-.9 1.7h72.6zm27.7 0c2.4 0 4.9-.5 7.2-1.7l60.2-30.1c5-2.5 9.2-6.2 12.3-10.9l33.7-50.5c2-2.9 5.6-4.2 9-3.2s5.7 4.1 5.7 7.7v94.8c0 2.1-.8 4.2-2.3 5.7l-53.3 53.3c-4.7 4.7-7.8 10.8-8.9 17.4l-15.2 90.9c-1.5 8.7 4.4 17 13.2 18.4s17-4.4 18.4-13.2l14.7-88.4c.3-1.6 1.1-3.2 2.2-4.3l81.2-81.2c9-9 14.1-21.2 14.1-33.9V186.6c0-23.5-19.1-42.6-42.6-42.6c-18.7 0-36.2 9.3-46.5 24.9l-48.6 72.9c-.8 1.2-1.8 2.1-3.1 2.7l-58.3 29.1c-7.9 4-11.1 13.6-7.2 21.5c2.8 5.5 8.2 8.7 14 8.8h.3v0zM512 16a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM464 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM2.3 468.1L50.1 348.6l12.3 12.3L17.1 474.1c-3.3 8.2 .7 17.5 8.9 20.8s17.5-.7 20.8-8.9L87 385.5l12.3 12.3-37.6 94c-6.6 16.4-25.2 24.4-41.6 17.8S-4.3 484.5 2.3 468.1zM590.5 348.6l47.8 119.5c6.6 16.4-1.4 35-17.8 41.6s-35-1.4-41.6-17.8l-37.6-94 12.3-12.3 40.2 100.4c3.3 8.2 12.6 12.2 20.8 8.9s12.2-12.6 8.9-20.8L578.2 360.9l12.3-12.3z"],
    "folder-user": [512, 512, [], "e18e", "M496 416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H197.5c12.7 0 24.9 5.1 33.9 14.1l35.9 35.9c9 9 21.2 14.1 33.9 14.1H448c26.5 0 48 21.5 48 48V416zM64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H301.3c-8.5 0-16.6-3.4-22.6-9.4L242.7 50.7c-12-12-28.3-18.7-45.3-18.7H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64zM256 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-40 48h80c30.9 0 56 25.1 56 56c0 4.4-3.6 8-8 8H168c-4.4 0-8-3.6-8-8c0-30.9 25.1-56 56-56zm-72 56c0 13.3 10.7 24 24 24H344c13.3 0 24-10.7 24-24c0-39.8-32.2-72-72-72H216c-39.8 0-72 32.2-72 72z"],
    "trash-can-xmark": [448, 512, [], "e2ae", "M157.4 27.3L134.4 64H313.6l-23-36.7c-4.4-7-12.1-11.3-20.4-11.3H177.7c-8.3 0-16 4.3-20.4 11.3zM115.6 64l28.2-45.2C151.1 7.1 163.9 0 177.7 0h92.5c13.8 0 26.6 7.1 33.9 18.8L332.4 64H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H115.6zM40 112c4.4 0 8 3.6 8 8V440c0 30.9 25.1 56 56 56H344c30.9 0 56-25.1 56-56V120c0-4.4 3.6-8 8-8s8 3.6 8 8V440c0 39.8-32.2 72-72 72H104c-39.8 0-72-32.2-72-72V120c0-4.4 3.6-8 8-8zm106.3 98.3c3.1-3.1 8.2-3.1 11.3 0L224 276.7l66.3-66.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L235.3 288l66.3 66.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L224 299.3l-66.3 66.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L212.7 288l-66.3-66.3c-3.1-3.1-3.1-8.2 0-11.3z"],
    "temperature-high": [512, 512, [], "f769", "M416 16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112A64 64 0 1 0 416 0a64 64 0 1 0 0 128zM112 80c0-35.3 28.7-64 64-64s64 28.7 64 64V243.8c0 8.4 4.4 15.7 10.7 20.3C283 287.3 304 325.2 304 368c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-42.8 21-80.7 53.3-104c6.3-4.6 10.7-11.9 10.7-20.3V80zM176 0C131.8 0 96 35.8 96 80V243.8c0 2.7-1.4 5.4-4 7.3c-36.3 26.1-60 68.8-60 117c0 79.5 64.5 144 144 144s144-64.5 144-144c0-48.2-23.7-90.8-60-117c-2.6-1.9-4-4.6-4-7.3V80c0-44.2-35.8-80-80-80zM128 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm112 0c0-32.6-24.4-59.6-56-63.5V72c0-4.4-3.6-8-8-8s-8 3.6-8 8V304.5c-31.6 3.9-56 30.9-56 63.5c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "microchip": [512, 512, [], "f2db", "M168 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H128c-35.3 0-64 28.7-64 64v24H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H64v80H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H64v80H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H64v24c0 35.3 28.7 64 64 64h24v56c0 4.4 3.6 8 8 8s8-3.6 8-8V448h80v56c0 4.4 3.6 8 8 8s8-3.6 8-8V448h80v56c0 4.4 3.6 8 8 8s8-3.6 8-8V448h24c35.3 0 64-28.7 64-64V360h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H448V264h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H448V168h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H448V128c0-35.3-28.7-64-64-64H360V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H264V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H168V8zm88 72h96 32c26.5 0 48 21.5 48 48v32 96 96 32c0 26.5-21.5 48-48 48H352 256 160 128c-26.5 0-48-21.5-48-48V352 256 160 128c0-26.5 21.5-48 48-48h32 96zm112 80V352c0 8.8-7.2 16-16 16H160c-8.8 0-16-7.2-16-16V160c0-8.8 7.2-16 16-16H352c8.8 0 16 7.2 16 16zM160 128c-17.7 0-32 14.3-32 32V352c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H160z"],
    "left-long-to-line": [640, 512, [], "e41e", "M0 72c0-4.4 3.6-8 8-8s8 3.6 8 8V440c0 4.4-3.6 8-8 8s-8-3.6-8-8V72zM320 296H600c13.3 0 24-10.7 24-24l0-32c0-13.3-10.7-24-24-24H320c-8.8 0-16-7.2-16-16V118.9c0-3.8-3.1-6.9-6.9-6.9c-1.8 0-3.5 .7-4.7 1.9L144.8 254.1c-.5 .5-.8 1.2-.8 1.9s.3 1.4 .8 1.9L292.4 398.1c1.3 1.2 3 1.9 4.7 1.9c3.8 0 6.9-3.1 6.9-6.9V312c0-8.8 7.2-16 16-16zM281.4 409.7L133.8 269.5c-3.7-3.5-5.8-8.4-5.8-13.5s2.1-10 5.8-13.5L281.4 102.3c4.3-4 9.9-6.3 15.8-6.3c12.6 0 22.9 10.2 22.9 22.9V184v16h16H600c22.1 0 40 17.9 40 40l0 32c0 22.1-17.9 40-40 40H336 320v16 65.1c0 12.6-10.2 22.9-22.9 22.9c-5.9 0-11.5-2.3-15.8-6.3z"],
    "crown": [576, 512, [128081], "f521", "M264 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0c0-22.1-17.9-40-40-40s-40 17.9-40 40c0 14.4 7.6 27 19 34L209.7 220.6c-9.1 18.2-32.7 23.4-48.6 10.7L72 160c-3.3 4.4-7.4 8-12.2 10.7l91.3 73c23.9 19.1 59.3 11.3 72.9-16l58.1-116.2c-2.7-.4-5.3-1.1-7.9-2c4.3 1.6 8.9 2.4 13.8 2.4c22.1 0 40-17.9 40-40zM16 136a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0A40 40 0 1 0 0 136a40 40 0 1 0 80 0zm456-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 64c22.1 0 40-17.9 40-40s-17.9-40-40-40s-40 17.9-40 40c0 9 3 17.3 8 24l-89.1 71.3c-15.9 12.7-39.5 7.5-48.6-10.7L309 106c-4.5 2.8-9.6 4.7-15.1 5.5L352 227.8c13.7 27.3 49.1 35.1 72.9 16l91.3-73c1.4 .8 2.8 1.5 4.3 2.1c-.3-.1-.5-.2-.8-.3L473.8 424.6c-4.2 22.8-24 39.4-47.2 39.4H149.4c-23.2 0-43.1-16.6-47.2-39.4L56.4 172.5c-4.8 2.1-10.1 3.4-15.6 3.5L86.4 427.4c5.5 30.4 32 52.6 63 52.6H426.6c30.9 0 57.4-22.1 63-52.6L535.3 176c.2 0 .5 0 .7 0z"],
    "weight-hanging": [512, 512, [], "f5cd", "M200 72a56 56 0 1 1 112 0A56 56 0 1 1 200 72zm101.3 56C317.6 114.8 328 94.6 328 72c0-39.8-32.2-72-72-72s-72 32.2-72 72c0 22.6 10.4 42.8 26.7 56H120c-22 0-41.2 15-46.6 36.4l-72 288c-3.6 14.3-.4 29.5 8.7 41.2S33.2 512 48 512H464c14.8 0 28.7-6.8 37.8-18.5s12.3-26.8 8.7-41.2l-72-288C433.2 143 414 128 392 128H301.3zM256 144H392c14.7 0 27.5 10 31 24.2l72 288c2.4 9.6 .2 19.7-5.8 27.5s-15.4 12.3-25.2 12.3H48c-9.9 0-19.2-4.5-25.2-12.3s-8.2-17.9-5.8-27.5l72-288C92.5 154 105.3 144 120 144H256z"],
    "xmarks-lines": [640, 512, [], "e59a", "M8 32H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8zM8 464H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8zm99.3-208l82.3 82.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L96 267.3 13.7 349.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L84.7 256 2.3 173.7c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L96 244.7l82.3-82.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L107.3 256zm130.3-93.7L320 244.7l82.3-82.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L331.3 256l82.3 82.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L320 267.3l-82.3 82.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L308.7 256l-82.3-82.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm212.7 0c3.1-3.1 8.2-3.1 11.3 0L544 244.7l82.3-82.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L555.3 256l82.3 82.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L544 267.3l-82.3 82.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L532.7 256l-82.3-82.3c-3.1-3.1-3.1-8.2 0-11.3zM0 424c0-4.4 3.6-8 8-8H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8zM8 80H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "file-prescription": [384, 512, [], "f572", "M64 496c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48H64zM358.6 157.3c.9 .9 1.7 1.8 2.4 2.7H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64zm40 224c-4.4 0-8 3.6-8 8v80 80c0 4.4 3.6 8 8 8s8-3.6 8-8V320h52.7l64 64-42.3 42.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L240 395.3l42.3 42.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L251.3 384l42.3-42.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L240 372.7l-53.8-53.8C207.8 314.2 224 295 224 272c0-26.5-21.5-48-48-48H104zm64 80h0H112V240h64c17.7 0 32 14.3 32 32s-14.3 32-32 32h-8z"],
    "calendar-range": [512, 512, [], "e0d6", "M152 0c4.4 0 8 3.6 8 8V64H352V8c0-4.4 3.6-8 8-8s8 3.6 8 8V64h48c35.3 0 64 28.7 64 64v48 16V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V192 176 128c0-35.3 28.7-64 64-64h48V8c0-4.4 3.6-8 8-8zM464 192H48V448c0 26.5 21.5 48 48 48H416c26.5 0 48-21.5 48-48V192zM144 120V80H96c-26.5 0-48 21.5-48 48v48H464V128c0-26.5-21.5-48-48-48H368v40c0 4.4-3.6 8-8 8s-8-3.6-8-8V80H160v40c0 4.4-3.6 8-8 8s-8-3.6-8-8zM408 280c0 4.4-3.6 8-8 8H208c-4.4 0-8-3.6-8-8s3.6-8 8-8H400c4.4 0 8 3.6 8 8zM304 416H112c-4.4 0-8-3.6-8-8s3.6-8 8-8H304c4.4 0 8 3.6 8 8s-3.6 8-8 8zM104 288a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 40a40 40 0 1 1 0-80 40 40 0 1 1 0 80zM384 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm40-24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z"],
    "flower-daffodil": [512, 512, [9880], "f800", "M192 0c-44.2 0-80 35.8-80 80c0 26.2 12.6 49.4 32 64c-19.4 14.6-32 37.8-32 64c0 44.2 35.8 80 80 80c21.8 0 41.6-8.7 56-22.9V422.6C220.2 362 159 320 88 320H29.5C13.2 320 0 333.2 0 349.5C0 439.3 72.7 512 162.5 512H248h16 85.5C439.3 512 512 439.3 512 349.5c0-16.3-13.2-29.5-29.5-29.5H424c-71 0-132.2 42-160 102.6V265.1c14.4 14.1 34.2 22.9 56 22.9c44.2 0 80-35.8 80-80c0-26.2-12.6-49.4-32-64c19.4-14.6 32-37.8 32-64c0-44.2-35.8-80-80-80c-26.2 0-49.4 12.6-64 32C241.4 12.6 218.2 0 192 0zm56 496H162.5C81.6 496 16 430.4 16 349.5c0-7.5 6.1-13.5 13.5-13.5H88c88.4 0 160 71.6 160 160zM128 80c0-35.3 28.7-64 64-64c24.8 0 46.2 14.1 56.9 34.7c1.4 2.7 4.1 4.3 7.1 4.3s5.7-1.7 7.1-4.3C273.8 30.1 295.2 16 320 16c35.3 0 64 28.7 64 64c0 24.8-14.1 46.2-34.7 56.9c-2.7 1.4-4.3 4.1-4.3 7.1s1.7 5.7 4.3 7.1C369.9 161.8 384 183.2 384 208c0 35.3-28.7 64-64 64c-24.8 0-46.2-14.1-56.9-34.7c-1.4-2.7-4.1-4.3-7.1-4.3s-5.7 1.7-7.1 4.3C238.2 257.9 216.8 272 192 272c-35.3 0-64-28.7-64-64c0-24.8 14.1-46.2 34.7-56.9c2.7-1.4 4.3-4.1 4.3-7.1s-1.7-5.7-4.3-7.1C142.1 126.2 128 104.8 128 80zM349.5 496H264c0-88.4 71.6-160 160-160h58.5c7.5 0 13.5 6.1 13.5 13.5C496 430.4 430.4 496 349.5 496zM256 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 80a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "hand-back-point-up": [448, 512, [], "e1a2", "M140 0C111.3 0 88 23.3 88 52V240v9.6c-6 3.7-11.8 7.8-17.3 12.5L41.5 286.7C25.3 300.4 16 320.5 16 341.7v24c0 48.8 26.2 93.9 68.5 118.1l18 10.3C123.1 505.8 146.3 512 170 512H312c57.4 0 104-46.6 104-104V392 308v-4c0-.8-.1-1.5-.3-2.2C412.5 271.5 387 248 356 248c-3.6 0-7.1 .3-10.5 .9C335.7 229.4 315.4 216 292 216c-6.1 0-12 .9-17.6 2.6C264.8 198.2 244.1 184 220 184c-10.1 0-19.6 2.5-28 6.9V52c0-28.7-23.3-52-52-52zM88 268.8V344c0 4.4 3.6 8 8 8s8-3.6 8-8V254.2 240 52c0-19.9 16.1-36 36-36s36 16.1 36 36V206.5c0 3.2 1.9 6.1 4.9 7.4s6.4 .6 8.7-1.6c7.9-7.6 18.6-12.2 30.5-12.2c19.9 0 36.7 13.2 42.1 31.3c.7 2.2 2.3 4.1 4.4 5s4.6 .9 6.7-.1c5.7-2.7 12-4.2 18.8-4.2c19 0 35.2 12.1 41.4 29c1.5 4 5.8 6.2 9.8 4.9c4-1.2 8.3-1.9 12.8-1.9c23.1 0 42.1 17.9 43.9 40.6c0 .3 .1 .6 .1 1V308v84 16c0 48.6-39.4 88-88 88H170c-20.9 0-41.4-5.4-59.5-15.8l-18-10.3C55.1 448.5 32 408.8 32 365.7v-24c0-16.5 7.3-32.1 19.8-42.7L81 274.2c2.3-1.9 4.6-3.7 7-5.5z"],
    "weight-scale": [512, 512, ["weight"], "f496", "M416 176c0-36-11.9-69.3-32-96c-4.2-5.5-8.7-10.8-13.5-15.8C341.4 34.5 300.9 16 256 16c-44.8 0-85.2 18.4-114.3 48c-4.6 4.6-8.8 9.6-12.8 14.7L128 80c-20.1 26.7-32 60-32 96c0 88.4 71.6 160 160 160s160-71.6 160-160zM403.5 80c18 27.6 28.5 60.6 28.5 96c0 97.2-78.8 176-176 176s-176-78.8-176-176c0-35.4 10.5-68.4 28.5-96H64c-26.5 0-48 21.5-48 48V448c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V128c0-26.5-21.5-48-48-48H403.5zM120.2 64C152.5 24.9 201.3 0 256 0s103.5 24.9 135.8 64H448c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V128C0 92.7 28.7 64 64 64h56.2zM304 224c0 26.5-21.5 48-48 48s-48-21.5-48-48s21.5-48 48-48c4.4 0 8.7 .6 12.8 1.7l36-77.1c1.9-4 6.6-5.7 10.6-3.9s5.7 6.6 3.9 10.6l-36 77.1c12.5 8.7 20.7 23.1 20.7 39.5zm-48 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "star-exclamation": [576, 512, [], "f2f3", "M200.1 170.7L46.8 193.3c-3 .4-5.5 2.5-6.4 5.4s-.2 6 2 8.2L31.2 218.1l11.2-11.3L153.5 317c3.7 3.7 5.4 8.9 4.5 14L131.8 486.6c-.5 3 .7 6 3.2 7.8s5.8 2 8.4 .6l137-73.2c4.7-2.5 10.4-2.5 15.1 0l137 73.2c2.7 1.4 6 1.2 8.4-.6s3.7-4.8 3.2-7.8L417.9 331c-.9-5.1 .8-10.4 4.5-14L533.5 206.9c2.2-2.1 2.9-5.3 2-8.2s-3.4-5-6.4-5.4L375.8 170.7c-5.2-.8-9.7-4.1-12.1-8.8L295.1 20.5c-1.3-2.8-4.1-4.5-7.2-4.5s-5.9 1.7-7.2 4.5L212.1 161.8c-2.3 4.8-6.8 8.1-12.1 8.8zM450.2 507.4c-7.4 5.3-17.3 6-25.3 1.7l-137-73.2L151 509.1c-8.1 4.3-17.9 3.7-25.3-1.7s-11.2-14.5-9.7-23.5l26.2-155.6L31.1 218.2c-6.5-6.4-8.7-15.9-5.9-24.5s10.3-14.9 19.3-16.3l153.2-22.6L266.3 13.5C270.4 5.2 278.7 0 287.9 0s17.6 5.2 21.6 13.5l68.6 141.3 153.2 22.6c9 1.3 16.5 7.6 19.3 16.3s.5 18.1-5.9 24.5L433.6 328.4l26.2 155.6c1.5 9-2.2 18.1-9.7 23.5zM288 128c4.4 0 8 3.6 8 8V296c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-4.4 3.6-8 8-8zM272 352a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "books": [512, 512, [128218], "f5db", "M128 416v48c0 17.7-14.3 32-32 32H48c-17.7 0-32-14.3-32-32V416H128zM96 512c16.7 0 31.4-8.5 40-21.5c8.6 12.9 23.3 21.5 40 21.5h48c26.5 0 48-21.5 48-48V416v-8-8V132.2l1.5 6 2 7.7 65.9 253.8 2 7.7 18 69.2c6.6 25.5 32 40.6 56.7 33.8l59.6-16.5c24.7-6.8 39.3-33 32.7-58.5l-16-61.5-2-7.7L426.6 112.4l-2-7.7-18-69.2C400 9.9 374.6-5.2 349.9 1.6L290.3 18.1c-8.4 2.3-15.7 6.9-21.4 13C262.1 12.9 244.6 0 224 0H176c-16.7 0-31.4 8.5-40 21.5C127.4 8.5 112.7 0 96 0H48C21.5 0 0 21.5 0 48V96v8 8V400v8 8 48c0 26.5 21.5 48 48 48H96zM272 64.8V63.6c.3-14 9.5-26.4 22.6-30l59.6-16.5c15.7-4.3 32.5 5.1 36.9 22.4l16 61.7L289 133.8 273.1 72.6c-.7-2.6-1-5.2-1.1-7.8zm-16-.6c0 0 0 0 0 0V96H144V48c0-17.7 14.3-32 32-32h48c17.7 0 32 14.3 32 32V64.2zM176 496c-17.7 0-32-14.3-32-32V416H256v48c0 17.7-14.3 32-32 32H176zM128 112V400H16V112H128zm0-64V96H16V48c0-17.7 14.3-32 32-32H96c17.7 0 32 14.3 32 32zM256 400H144V112H256V400zM411.2 116.7l63.9 246L356.8 395.3 293 149.3l118.2-32.7zM479 378.2l15.9 61.2c4.5 17.4-5.6 34.7-21.5 39.1l-59.6 16.5c-15.7 4.3-32.5-5.1-36.9-22.4l-16-61.7L479 378.2z"],
    "user-group": [640, 512, [128101, "user-friends"], "f500", "M112 128a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM16 482.3C16 392.7 88.7 320 178.3 320h91.4C359.3 320 432 392.7 432 482.3c0 7.6-6.1 13.7-13.7 13.7H29.7c-7.6 0-13.7-6.1-13.7-13.7zM224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3zm431 208c17 0 30.7-13.8 30.7-30.7C640 392.2 567.8 320 478.7 320H417.3c-4.4 0-8.8 .2-13.2 .5c5.8 4.9 11.4 10 16.7 15.5h57.9C559 336 624 401 624 481.3c0 8.1-6.6 14.7-14.7 14.7H478.5c-1.3 5.7-3.4 11-6.1 16H609.3zM432 256c61.9 0 112-50.1 112-112s-50.1-112-112-112c-24.8 0-47.7 8.1-66.3 21.7c2.5 4.8 4.8 9.8 6.9 14.9C388.9 55.7 409.6 48 432 48c53 0 96 43 96 96s-43 96-96 96c-27.7 0-52.7-11.8-70.2-30.6c-2.8 4.7-5.8 9.3-9.1 13.7C373 243.4 401 256 432 256z"],
    "arrow-up-a-z": [576, 512, ["sort-alpha-up"], "f15e", "M154.3 34.3c3.1-3.1 8.2-3.1 11.3 0l112 112c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L168 59.3V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V59.3L53.7 157.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l112-112zM336 296c0-4.4 3.6-8 8-8H488c3.1 0 5.9 1.8 7.2 4.6s.9 6.1-1 8.5L360.9 464H488c4.4 0 8 3.6 8 8s-3.6 8-8 8H344c-3.1 0-5.9-1.8-7.2-4.6s-.9-6.1 1-8.5L471.1 304H344c-4.4 0-8-3.6-8-8zM416 32c3 0 5.8 1.7 7.2 4.4l63.9 127.9 .1 .3 23.9 47.8c2 4 .4 8.8-3.6 10.7s-8.8 .4-10.7-3.6L475.1 176H356.9l-21.8 43.6c-2 4-6.8 5.6-10.7 3.6s-5.6-6.8-3.6-10.7l23.9-47.8 .1-.3L408.8 36.4c1.4-2.7 4.1-4.4 7.2-4.4zm0 25.9L364.9 160H467.1L416 57.9z"],
    "layer-plus": [576, 512, ["layer-group-plus"], "f5ff", "M472 24c0-4.4-3.6-8-8-8s-8 3.6-8 8V72H408c-4.4 0-8 3.6-8 8s3.6 8 8 8h48v48c0 4.4 3.6 8 8 8s8-3.6 8-8V88h48c4.4 0 8-3.6 8-8s-3.6-8-8-8H472V24zM288 128c-6.4 0-12.8 1.4-18.6 4.1L43.9 237.4C36.6 240.7 32 248 32 256s4.6 15.3 11.9 18.6L269.4 379.9c5.8 2.7 12.2 4.1 18.6 4.1s12.8-1.4 18.6-4.1L532.1 274.6C539.4 271.3 544 264 544 256s-4.6-15.3-11.9-18.6L306.6 132.1c-5.8-2.7-12.2-4.1-18.6-4.1zm-11.9 18.6c3.7-1.7 7.8-2.6 11.9-2.6s8.2 .9 11.9 2.6L525.4 251.9c1.6 .7 2.6 2.4 2.6 4.1s-1 3.4-2.6 4.1L299.9 365.4c-3.7 1.7-7.8 2.6-11.9 2.6s-8.2-.9-11.9-2.6L50.6 260.1c-1.6-.7-2.6-2.4-2.6-4.1s1-3.4 2.6-4.1L276.1 146.6zm-172.9 191L43.9 365.4C36.6 368.7 32 376 32 384s4.6 15.3 11.9 18.6L269.4 507.9c5.8 2.7 12.2 4.1 18.6 4.1s12.8-1.4 18.6-4.1L532.1 402.6C539.4 399.3 544 392 544 384s-4.6-15.3-11.9-18.6l-59.4-27.7-18.9 8.8 71.5 33.4c1.6 .7 2.6 2.4 2.6 4.1s-1 3.4-2.6 4.1L299.9 493.4c-3.7 1.7-7.8 2.6-11.9 2.6s-8.2-.9-11.9-2.6L50.6 388.1c-1.6-.7-2.6-2.4-2.6-4.1s1-3.4 2.6-4.1l71.5-33.4-18.9-8.8z"],
    "play-pause": [640, 512, [], "e22f", "M432 72c0-4.4-3.6-8-8-8s-8 3.6-8 8V440c0 4.4 3.6 8 8 8s8-3.6 8-8V72zm144 0c0-4.4-3.6-8-8-8s-8 3.6-8 8V440c0 4.4 3.6 8 8 8s8-3.6 8-8V72zM89.2 81.5c5.6-2.6 12.3-1.8 17 2.2l192 160c3.6 3 5.8 7.5 5.8 12.3s-2.1 9.3-5.8 12.3l-192 160c-4.8 4-11.4 4.8-17 2.2L82.4 445l6.8-14.5c-5.6-2.6-9.2-8.3-9.2-14.5V96c0-6.2 3.6-11.9 9.2-14.5zM64 416c0 12.4 7.2 23.7 18.4 29s24.5 3.6 34.1-4.4l192-160c7.3-6.1 11.5-15.1 11.5-24.6s-4.2-18.5-11.5-24.6l-192-160c-9.5-7.9-22.8-9.7-34.1-4.4S64 83.6 64 96V416z"],
    "block-question": [448, 512, [], "e3dd", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm136 96c0-30.9 25.1-56 56-56h56.2c35.2 0 63.8 28.6 63.8 63.8c0 21.4-10.8 41.5-28.7 53.3L232 286.9V312c0 4.4-3.6 8-8 8s-8-3.6-8-8V282.5c0-2.7 1.4-5.2 3.6-6.7l54.9-36.2c13.4-8.8 21.5-23.8 21.5-39.9c0-26.4-21.4-47.8-47.8-47.8H192c-22.1 0-40 17.9-40 40l0 6.5c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-6.5zm72 168a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM64 112a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM368 96a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM64 400a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm304-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "snooze": [448, 512, [128164, "zzz"], "f880", "M160 8c0-4.4 3.6-8 8-8H312c3.3 0 6.3 2.1 7.5 5.2s.3 6.6-2.2 8.8L189 128H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-3.3 0-6.3-2.1-7.5-5.2s-.3-6.6 2.2-8.8L291 16H168c-4.4 0-8-3.6-8-8zM0 264c0-4.4 3.6-8 8-8H216c3.1 0 6 1.8 7.3 4.7s.8 6.2-1.2 8.6L25.5 496H216c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-3.1 0-6-1.8-7.3-4.7s-.8-6.2 1.2-8.6L198.5 272H8c-4.4 0-8-3.6-8-8zm296-40H440c3.2 0 6 1.9 7.3 4.7s.8 6.3-1.4 8.6L314 384H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H296c-3.2 0-6-1.9-7.3-4.7s-.8-6.3 1.4-8.6L422 240H296c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "scanner-image": [576, 512, [], "f8f3", "M43.7 32.9c-3.9-2-8.8-.5-10.8 3.4s-.5 8.8 3.4 10.8L503.9 288H64c-35.3 0-64 28.7-64 64v64c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64v-8V352v-1c0-27-15.1-51.7-39-64L43.7 32.9zM560 352v56 8c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V352c0-26.5 21.5-48 48-48H512c26.5 0 48 21.5 48 48zM208 384a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM96 400a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "tv-retro": [512, 512, [128250], "f401", "M141 1.8C137.5-1 132.5-.4 129.8 3s-2.2 8.5 1.2 11.2L233.2 96H80C35.8 96 0 131.8 0 176V432c0 44.2 35.8 80 80 80H432c44.2 0 80-35.8 80-80V176c0-44.2-35.8-80-80-80H278.8L381 14.2c3.4-2.8 4-7.8 1.2-11.2s-7.8-4-11.2-1.2l-115 92L141 1.8zM256 112H432c35.3 0 64 28.7 64 64V432c0 35.3-28.7 64-64 64H80c-35.3 0-64-28.7-64-64V176c0-35.3 28.7-64 64-64H256zm80 64c17.7 0 32 14.3 32 32V400c0 17.7-14.3 32-32 32H112c-17.7 0-32-14.3-32-32V208c0-17.7 14.3-32 32-32H336zM112 160c-26.5 0-48 21.5-48 48V400c0 26.5 21.5 48 48 48H336c26.5 0 48-21.5 48-48V208c0-26.5-21.5-48-48-48H112zm312 48a8 8 0 1 1 16 0 8 8 0 1 1 -16 0zm32 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-24 56a8 8 0 1 1 0 16 8 8 0 1 1 0-16zm0 32a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "square-t": [448, 512, [], "e280", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm104 48H224 344c4.4 0 8 3.6 8 8s-3.6 8-8 8H232V392c0 4.4-3.6 8-8 8s-8-3.6-8-8V160H104c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "farm": [576, 512, ["barn-silo"], "f864", "M0 104V456c0 30.9 25.1 56 56 56h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H56c-22.1 0-40-17.9-40-40V192H144c4.4 0 8-3.6 8-8s-3.6-8-8-8H16V104c0-48.6 39.4-88 88-88s88 39.4 88 88v8c0 4.4 3.6 8 8 8s8-3.6 8-8v-8C208 46.6 161.4 0 104 0S0 46.6 0 104zM365.1 81.7c1.9-.7 3.9-.7 5.8 0l132 51.3c2 .8 3.6 2.3 4.4 4.2l52 118.8c.4 1 .7 2.1 .7 3.2V472c0 13.3-10.7 24-24 24H448V424c0-22.1-17.9-40-40-40H328c-22.1 0-40 17.9-40 40v72H200c-13.3 0-24-10.7-24-24V259.3c0-1.1 .2-2.2 .7-3.2l52-118.8c.9-1.9 2.4-3.5 4.4-4.2l132-51.3zM304 496V424c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24v72H304zM376.7 66.8c-5.6-2.2-11.8-2.2-17.4 0l-132 51.3c-5.9 2.3-10.7 6.9-13.3 12.7L162 249.7c-1.3 3-2 6.3-2 9.6V472c0 22.1 17.9 40 40 40H536c22.1 0 40-17.9 40-40V259.3c0-3.3-.7-6.6-2-9.6L522 130.9c-2.6-5.8-7.3-10.4-13.3-12.7l-132-51.3zM400 208c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H336c-8.8 0-16-7.2-16-16V224c0-8.8 7.2-16 16-16h64zm-64-16c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H336z"],
    "chess-knight": [448, 512, [9822], "f441", "M91.8 16C85.3 16 80 21.3 80 27.8c0 4.5 2.5 8.5 6.5 10.5l21.1 10.5c2.3 1.2 3.9 3.3 4.3 5.9s-.4 5.1-2.2 6.9L96.3 75C85.9 85.4 80 99.6 79.9 114.4l-.3 104.4c0 15.4 7.4 29.9 19.9 38.9l1.9 1.4c15.6 11.1 36.5 11 51.9-.2l89.9-65.4c3.6-2.6 8.6-1.8 11.2 1.8s1.8 8.6-1.8 11.2l-89.9 65.4-53.8 39.1C90.8 324.2 80 345.4 80 368v16H64V368c0-27.7 13.2-53.7 35.6-70l20.7-15c-9.9-1.2-19.6-4.8-28.1-10.8l-1.9-1.4c-16.8-12-26.7-31.3-26.6-51.9l.3-104.4c0-19 7.6-37.3 21.1-50.7l5.5-5.5L79.4 52.6C69.9 47.9 64 38.3 64 27.8C64 12.4 76.4 0 91.8 0H234.6C334.8 0 416 81.2 416 181.4c0 10.2-.9 20.4-2.6 30.4L383.9 385.3l-15.8-2.7 29.5-173.6c1.6-9.2 2.3-18.4 2.3-27.7C400 90 326 16 234.6 16H91.8zM128 144a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM78.3 432c-4.5 0-8.9 1.9-11.9 5.3L35.8 471.2c-2.5 2.7-3.8 6.3-3.8 9.9c0 8.2 6.6 14.8 14.8 14.8H401.2c8.2 0 14.8-6.6 14.8-14.8c0-3.7-1.4-7.2-3.8-9.9l-30.6-33.9c-3-3.4-7.4-5.3-11.9-5.3H78.3zm345.8 28.5c5.1 5.7 7.9 13 7.9 20.6c0 17-13.8 30.8-30.8 30.8H46.8c-17 0-30.8-13.8-30.8-30.8c0-7.6 2.8-15 7.9-20.6l30.6-33.9c6.1-6.7 14.7-10.6 23.8-10.6H369.7c9.1 0 17.7 3.8 23.8 10.6l30.6 33.9z"],
    "bars-sort": [448, 512, [], "e0ae", "M0 88c0-4.4 3.6-8 8-8H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8zM0 248c0-4.4 3.6-8 8-8H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8zM192 408c0 4.4-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H184c4.4 0 8 3.6 8 8z"],
    "pallet-boxes": [640, 512, [57863, "palette-boxes", "pallet-alt"], "f483", "M272 16H112C94.3 16 80 30.3 80 48V240c0 17.7 14.3 32 32 32H272c17.7 0 32-14.3 32-32V48c0-17.7-14.3-32-32-32zM112 0H272c26.5 0 48 21.5 48 48V240c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48V48C64 21.5 85.5 0 112 0zM528 112H432c-17.7 0-32 14.3-32 32v96c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM432 96h96c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H432c-26.5 0-48-21.5-48-48V144c0-26.5 21.5-48 48-48zM0 360c0-4.4 3.6-8 8-8H88 320 552h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H560V496h72c4.4 0 8 3.6 8 8s-3.6 8-8 8H552 320 88 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H80V368H8c-4.4 0-8-3.6-8-8zM96 496H312V368H96V496zm232 0H544V368H328V496z"],
    "face-laugh-squint": [512, 512, ["laugh-squint"], "f59b", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM120.2 309.9c-.4-1.4-.1-2.5 .9-3.6c1.1-1.2 3-2.3 5.4-2.3H385.5c2.4 0 4.4 1.1 5.4 2.3c1 1.1 1.2 2.2 .9 3.6C375.5 371.2 320.7 416 256 416s-119.5-44.8-135.8-106.1zM104.7 314c18.1 68 79 118 151.3 118s133.2-50 151.3-118c3.6-13.7-7.6-26-21.8-26H126.5c-14.2 0-25.4 12.3-21.8 26zM372.4 144.8l-80 40c-2.7 1.4-4.4 4.1-4.4 7.2s1.7 5.8 4.4 7.2l80 40c4 2 8.8 .4 10.7-3.6s.4-8.8-3.6-10.7L313.9 192l65.7-32.8c4-2 5.6-6.8 3.6-10.7s-6.8-5.6-10.7-3.6zm-232.8 0c-4-2-8.8-.4-10.7 3.6s-.4 8.8 3.6 10.7L198.1 192l-65.7 32.8c-4 2-5.6 6.8-3.6 10.7s6.8 5.6 10.7 3.6l80-40c2.7-1.4 4.4-4.1 4.4-7.2s-1.7-5.8-4.4-7.2l-80-40z"],
    "code-simple": [576, 512, [], "e13d", "M205.5 77.8c3.2-3.1 3.3-8.1 .2-11.3s-8.1-3.3-11.3-.2l-192 184C.9 251.7 0 253.8 0 256s.9 4.3 2.5 5.8l192 184c3.2 3.1 8.3 3 11.3-.2s2.9-8.3-.2-11.3L19.6 256l186-178.2zm164.9 0L556.4 256l-186 178.2c-3.2 3.1-3.3 8.1-.2 11.3s8.1 3.3 11.3 .2l192-184c1.6-1.5 2.5-3.6 2.5-5.8s-.9-4.3-2.5-5.8l-192-184c-3.2-3.1-8.3-2.9-11.3 .2s-3 8.3 .2 11.3z"],
    "bolt-slash": [640, 512, [], "e0b8", "M356.1 376.3L223.5 493.8c-1.6 1.4-3.7 2.2-5.9 2.2c-6.4 0-10.7-6.5-8.2-12.4l71.5-166.8-13-10.3L194.7 477.3c-7 16.4 5 34.7 22.9 34.7c6.1 0 11.9-2.2 16.5-6.3L368.9 386.3l-12.8-10.1zM224.1 272H151.3c-4.1 0-7.3-3.3-7.3-7.3c0-2.1 .9-4.1 2.5-5.5l28.8-25.7-12.8-10.1-26.7 23.8c-5 4.4-7.8 10.8-7.8 17.4c0 12.9 10.5 23.3 23.3 23.3h93l-20.3-16zm60.3-135.9L416.5 18.2c1.6-1.4 3.7-2.2 5.9-2.2c6.4 0 10.6 6.5 8.1 12.4L359.1 195.1l13 10.3L445.3 34.7c7-16.4-5-34.7-22.9-34.7c-6.1 0-12 2.2-16.6 6.3L271.6 126.1l12.8 10.1zM487.4 224H395.7l20.3 16h71.5c4.7 0 8.6 3.8 8.6 8.6c0 2.4-1 4.8-2.9 6.4l-27.5 24.3 12.8 10.1 25.3-22.4c5.3-4.7 8.3-11.4 8.3-18.4c0-13.6-11-24.6-24.6-24.6zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "panel-fire": [640, 512, [], "e42f", "M384 48H64C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H324.8c4 5.6 8.3 10.9 12.8 16H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64v32.2c-5.4-.5-10.8-.1-16 1.3V96c0-26.5-21.5-48-48-48zM349.1 208H96c-17.7 0-32-14.3-32-32V128c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32v39.4c-12.6 13.2-24.3 26.8-34.9 40.6zm2.9-96H96c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16H352c8.8 0 16-7.2 16-16V128c0-8.8-7.2-16-16-16zM112 256a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm269.2-18.7c-4.8 .1-9.4-2.1-12.5-5.8c-16.5-19.9-34.2-38.3-53.1-55.3c-31.8 28.6-58.7 60.8-77.6 91.5c-19 30.8-30 62.1-30 84.2c0 79 63.2 143.8 144 143.8c79.9 0 144-64.8 144-143.8c0-16.5-8.3-44.5-22.4-71.6c-14-26.9-33.5-54.9-56.2-76c-8.3 7.7-16.3 17.4-23.9 26.9c-3 3.8-7.5 6-12.3 6zM498.4 209c3.6 4.1 7.1 8.2 10.6 12.4c3.3-4.1 6.7-8.4 10.3-12.6c5.1-5.9 10.5-11.8 16.1-16.9c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 58.8 24.2 79c0 87.8-71.3 159.8-160 159.8c-89.7 0-160-72.1-160-159.8c0-26.4 12.7-60.7 32.4-92.6c20-32.4 48.1-66.1 81.4-95.8c2.8-2.5 6.4-3.8 10-3.7c3.5 0 7 1.3 9.8 3.8c15.8 14.2 30.7 29.3 44.9 45.3zm-56.8 46.9c2.4 0 4.7 1.1 6.2 3c2.2 2.8 19.4 24.6 35.9 45.7l22.5 28.7 4 5.2 33.4-38.9c1.6-1.8 3.9-2.9 6.3-2.8s4.7 1.3 6.1 3.2c3.7 5 6.2 10 8.4 14.3l0 0 0 .1c21.5 39.6 12.2 90.5-24.6 116.2l-.2 .1 0 0c-17.8 11.9-37 17.9-58.5 17.9c-26.5 0-50.9-8.6-68.7-24.9c-17.9-16.4-28.7-40.1-28.7-69.2c0-15.1 4.8-28.9 13.5-43.9c8.6-14.8 21.4-31.3 37.9-51.6c1.5-1.9 3.8-3 6.2-3zM510.1 351l-6.3 4.9 0 0 0 0 0 0-.1-.2-.5-.7-2-2.6-7.3-9.3-22.5-28.7c-11.3-14.4-22.7-29-29.6-37.8c-13.4 16.7-23.4 30-30.3 41.8c-7.8 13.4-11.3 24.4-11.3 35.8c0 24.9 9.1 44.3 23.5 57.4c14.5 13.2 34.8 20.7 57.9 20.7c18.2 0 34.3-5 49.5-15.2c29.4-20.6 37.7-62.3 19.6-95.5l-.1-.2 0 0c-.6-1.1-1.1-2.2-1.7-3.3l-32.6 38c-1.6 1.8-3.9 2.8-6.2 2.8s-4.6-1.2-6.1-3.1l6.3-4.9z"],
    "binary-circle-check": [640, 512, [], "e33c", "M312 8c0-2.6-1.3-5.1-3.4-6.6s-4.9-1.8-7.4-.9l-64 24c-4.1 1.6-6.2 6.2-4.7 10.3s6.2 6.2 10.3 4.7L296 19.5V208H232c-4.4 0-8 3.6-8 8s3.6 8 8 8h72 72c4.4 0 8-3.6 8-8s-3.6-8-8-8H312V8zM88 296c0-2.6-1.3-5.1-3.4-6.6s-4.9-1.8-7.4-.9l-64 24c-4.1 1.6-6.2 6.2-4.7 10.3s6.2 6.2 10.3 4.7L72 307.5V496H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H80h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H88V296zM16 64v96c0 35.3 28.7 64 64 64h32c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H80C44.7 0 16 28.7 16 64zM80 16h32c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H80c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48zM272 288c-35.3 0-64 28.7-64 64v96c0 35.3 28.7 64 64 64h32c23.9 0 44.8-13.1 55.8-32.6c-3.8-4.7-7.4-9.6-10.8-14.6C342.2 483 324.6 496 304 496H272c-26.5 0-48-21.5-48-48V352c0-26.5 21.5-48 48-48h32c9.3 0 18 2.6 25.4 7.2c1.8-5.1 3.7-10.2 5.9-15.1C326 291 315.4 288 304 288H272zm224-48a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm69.7-189.7c-3.1-3.1-8.2-3.1-11.3 0L480 396.7l-42.3-42.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l48 48c3.1 3.1 8.2 3.1 11.3 0l80-80c3.1-3.1 3.1-8.2 0-11.3z"],
    "comment-minus": [512, 512, [], "f4b1", "M157.3 415c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8C68.3 456 41.6 464 16 464l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C28 450 34 442 40 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C31.9 318.8 16 280.7 16 240C16 136.9 120.2 48 256 48s240 88.9 240 192s-104.2 192-240 192c-35.2 0-68.6-6.1-98.7-17zM4.7 452.7l0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0zM160 232c-4.4 0-8 3.6-8 8s3.6 8 8 8H352c4.4 0 8-3.6 8-8s-3.6-8-8-8H160z"],
    "burrito": [512, 512, [127791], "f7ed", "M262.1 43c-2.5 1.8-4.9 3.8-7.1 6L33.9 270.1C12.2 291.8 0 321.3 0 352s12.2 60.2 33.9 81.9l44.1 44.1C99.8 499.8 129.3 512 160 512s60.2-12.2 81.9-33.9L463 257c.7-.7 1.4-1.4 2-2.1l0 0c1.4-1.6 2.8-3.2 4-4.9c25.3-11.2 43-36.5 43-65.9c0-11.5-2.7-22.4-7.5-32c4.8-9.6 7.5-20.5 7.5-32c0-32.5-21.5-60-51.1-68.9C452 21.5 424.5 0 392 0c-11.5 0-22.4 2.7-32 7.5C350.4 2.7 339.5 0 328 0c-29.4 0-54.7 17.7-65.9 43zm15.4 4.8C286.6 28.9 305.8 16 328 16c10.2 0 19.8 2.7 28 7.5c2.5 1.4 5.5 1.4 8 0c8.2-4.8 17.8-7.5 28-7.5c26.6 0 48.9 18.5 54.6 43.4c.7 3 3 5.3 6 6c24.9 5.7 43.4 28 43.4 54.6c0 10.2-2.7 19.8-7.5 28c-1.4 2.5-1.4 5.5 0 8c4.8 8.2 7.5 17.8 7.5 28c0 22.2-12.9 41.4-31.7 50.5C432.3 212.7 393.6 200 352 200c-15.5 0-30.6 1.8-45.1 5.1c3.3-14.5 5.1-29.6 5.1-45.1c0-41.6-12.7-80.3-34.5-112.3zM16 352c0-5.3 .4-10.6 1.3-15.8C45.5 351.4 77.7 360 112 360c88.5 0 163.5-57.5 189.9-137.1c15.9-4.5 32.7-6.9 50.1-6.9c36.8 0 71.1 10.8 99.9 29.5l-.2 .2L230.6 466.7C211.9 485.5 186.5 496 160 496s-51.9-10.5-70.6-29.3L45.3 422.6C26.5 403.9 16 378.5 16 352zM266.3 60.3l.2-.2C285.2 88.9 296 123.2 296 160c0 18.8-2.8 37-8.1 54.1C264.8 289.3 194.8 344 112 344c-33 0-64-8.7-90.8-23.9c4.9-14.5 13-27.7 24-38.7L266.3 60.3z"],
    "violin": [640, 512, [127931], "f8ed", "M349.7 2.3c3.1 3.1 3.1 8.2 0 11.3l-336 336c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l336-336c3.1-3.1 8.2-3.1 11.3 0zm288 0c3.1 3.1 3.1 8.2 0 11.3L448 203.3c19.9 22.6 32 52.2 32 84.7c0 20.8-5 40.4-13.8 57.8c-3.4 6.7-11.4 9.1-18.8 7.7c-5-1-10.2-1.5-15.4-1.5c-44.2 0-80 35.8-80 80c0 11.6 2.5 22.7 7 32.7c3.3 7.4 2.4 16.6-4.3 21.3C331.3 502.4 302.8 512 272 512c-17.6 0-34.5-3.2-50.1-8.9c-4.5 5.6-11.3 8.9-18.7 8.9c-6.3 0-12.4-2.5-16.9-7L135 453.6c-4.5-4.5-7-10.6-7-16.9c0-7.3 3.3-14.2 8.9-18.7c-5.8-15.6-8.9-32.5-8.9-50.1c0-30.8 9.6-59.3 26.1-82.6c4.7-6.7 13.8-7.6 21.3-4.3c10 4.5 21 7 32.7 7c44.2 0 80-35.8 80-80c0-5.3-.5-10.4-1.5-15.4c-1.4-7.4 1-15.4 7.7-18.8c17.4-8.8 37-13.8 57.8-13.8c32.5 0 62.1 12.1 84.7 32L626.3 2.3c3.1-3.1 8.2-3.1 11.3 0zM272 496c27.1 0 52.1-8.4 72.8-22.7c0-.2 0-.4 0-.6c-.1-.5-.2-1-.4-1.5c-5.4-12-8.3-25.3-8.3-39.2c0-53 43-96 96-96c6.3 0 12.5 .6 18.5 1.8c.5 .1 1 .1 1.4 .1c.2 0 .3 0 .4-.1c7.5-15 11.7-31.9 11.7-49.8c0-28-10.3-53.7-27.3-73.3l-71 71c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l71-71C405.7 186.3 380 176 352 176c-17.9 0-34.8 4.2-49.8 11.7c0 .1 0 .3-.1 .4c0 .4 0 .9 .1 1.4c1.2 6 1.8 12.2 1.8 18.5c0 53-43 96-96 96c-13.9 0-27.2-3-39.2-8.3c-.5-.2-1-.4-1.5-.4c-.2 0-.5 0-.6 0C152.4 315.9 144 340.9 144 368c0 14.7 2.5 28.8 7 41.9l68.1-37.1c9.3-5.1 20.9-3.4 28.5 4.1l15.5 15.5c7.5 7.5 9.2 19.1 4.1 28.5L230.1 489c13.1 4.6 27.3 7 41.9 7zM236.2 388.2c-2.5-2.5-6.4-3.1-9.5-1.4l-78.6 42.9c-2.6 1.4-4.1 4.1-4.1 7c0 2.1 .8 4.1 2.3 5.6l51.4 51.4c1.5 1.5 3.5 2.3 5.6 2.3c2.9 0 5.6-1.6 7-4.1l42.9-78.6c1.7-3.1 1.1-7-1.4-9.5l-15.5-15.5zM528 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM448 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64-64a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "objects-column": [448, 512, [], "e3c1", "M48 48C30.3 48 16 62.3 16 80V240c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V80c0-17.7-14.3-32-32-32H48zM0 80C0 53.5 21.5 32 48 32h96c26.5 0 48 21.5 48 48V240c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80zM304 240c-17.7 0-32 14.3-32 32V432c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V272c0-17.7-14.3-32-32-32H304zm-48 32c0-26.5 21.5-48 48-48h96c26.5 0 48 21.5 48 48V432c0 26.5-21.5 48-48 48H304c-26.5 0-48-21.5-48-48V272zM144 336H48c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V368c0-17.7-14.3-32-32-32zM48 320h96c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V368c0-26.5 21.5-48 48-48zM304 48c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32h96c17.7 0 32-14.3 32-32V80c0-17.7-14.3-32-32-32H304zM256 80c0-26.5 21.5-48 48-48h96c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H304c-26.5 0-48-21.5-48-48V80z"],
    "square-chevron-down": [448, 512, ["chevron-square-down"], "f329", "M64 464c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64zM0 416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416zm229.7-74.3l120-120c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L224 324.7 109.7 210.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l120 120c3.1 3.1 8.2 3.1 11.3 0z"],
    "comment-plus": [512, 512, [], "f4b2", "M157.3 415c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8C68.3 456 41.6 464 16 464l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C28 450 34 442 40 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C31.9 318.8 16 280.7 16 240C16 136.9 120.2 48 256 48s240 88.9 240 192s-104.2 192-240 192c-35.2 0-68.6-6.1-98.7-17zM4.7 452.7l0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0zM248 336c0 4.4 3.6 8 8 8s8-3.6 8-8V248h88c4.4 0 8-3.6 8-8s-3.6-8-8-8H264V144c0-4.4-3.6-8-8-8s-8 3.6-8 8v88H160c-4.4 0-8 3.6-8 8s3.6 8 8 8h88v88z"],
    "triangle-instrument": [576, 512, ["triangle-music"], "f8e2", "M296 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64.4c-27.8 2.5-53.1 17.8-68.1 41.6L46.5 367.7C37 382.8 32 400.2 32 418c0 51.9 42.1 94 94 94H450c51.9 0 94-42.1 94-94c0-17.8-5-35.2-14.5-50.2L439.4 225.2l-11.6 11.6 88.1 139.5c7.9 12.5 12.1 26.9 12.1 41.7c0 43.1-34.9 78-78 78H126c-43.1 0-78-34.9-78-78c0-14.8 4.2-29.2 12.1-41.7L225.4 114.5C239 93 262.6 80 288 80s49 13 62.6 34.5l50.9 80.6-74.3 74.3C316.4 261 302.8 256 288 256c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64c0-14.8-5-28.4-13.4-39.2L410.3 209l11.6-11.6L541.7 77.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L413.1 183.5l-49-77.6C349.1 82.1 323.8 66.8 296 64.4V8zm40 312a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"],
    "wheelchair": [512, 512, [], "f193", "M192 80a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM143.9 200.6c.7 4.4-2.3 8.5-6.6 9.2C68.5 220.7 16 280.2 16 352c0 79.5 64.5 144 144 144c66.4 0 122.4-45 139-106.2c1.2-4.3 5.6-6.8 9.8-5.6s6.8 5.6 5.6 9.8C296 462 233.8 512 160 512C71.6 512 0 440.4 0 352c0-79.8 58.4-145.9 134.8-158c4.4-.7 8.5 2.3 9.2 6.6zm122.6 90.5l-9.6-48c-.9-4.7 .3-9.6 3.3-13.3s7.6-5.9 12.4-5.9H336c8.8 0 16-7.2 16-16s-7.2-16-16-16H259.8c-7.6 0-14.2-5.4-15.7-12.9l-1.9-9.7c-3-14.8-16-25.5-31.1-25.5c-20 0-35 18.3-31.1 37.9l23.1 115.5c4.5 22.4 24.2 38.6 47.1 38.6h5.1 .3l0 0c.1 0 .2 0 .3 0c.1 0 .2 0 .4 0l.3 0v0h94.1c13.3 0 25.3 8.3 30 20.8L417 453.6c3 8.1 11.9 12.3 20 9.6l48-16c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-18.7 6.2c-8.2 2.7-17-1.5-20-9.6l-25.5-68c-9.4-25-33.2-41.5-59.9-41.5H282.2c-7.6 0-14.2-5.4-15.7-12.9zm159.1 48.8l25.5 68 18.7-6.2c16.8-5.6 34.9 3.5 40.5 20.2s-3.5 34.9-20.2 40.5l-48 16c-16.3 5.4-34-3-40.1-19.1l-36.3-96.9c-2.3-6.2-8.3-10.4-15-10.4H256.6c-.4 0-.8 0-1.3 0h-5.1c-30.5 0-56.8-21.5-62.8-51.4L164.4 185c-5.9-29.5 16.7-57 46.8-57c22.7 0 42.3 16 46.8 38.3l1.9 9.7H336c17.7 0 32 14.3 32 32s-14.3 32-32 32H288.9 272.6l3.2 16 6.4 32h68.5c33.3 0 63.2 20.7 74.9 51.9z"],
    "user-pilot-tie": [448, 512, [], "e2c1", "M225.6 16.2c-1.2-.3-2.4-.3-3.5 0L62.2 52.1c-2.8 .6-5.1 2.8-5.9 5.6s-.1 5.8 2 7.9L87.5 95.1c1.5 1.5 2.3 3.5 2.3 5.6v26.9c18.1 11.7 55.9 32.2 134.1 32.2s116.1-20.5 134.1-32.2V100.7c0-2.1 .8-4.1 2.3-5.6l29.1-29.5c2-2.1 2.8-5.1 2-7.9s-3.1-4.9-5.9-5.6l-159.9-36zm-7-15.6c3.5-.8 7.1-.8 10.5 0L389 36.5c8.5 1.9 15.3 8.3 17.8 16.7s.2 17.4-6 23.6L374 104v23.6c0 5.3-2.6 10.3-7.2 13.3c-20.4 13.3-61.3 34.9-142.9 34.9s-122.5-21.6-142.9-34.9c-4.6-3-7.2-8-7.2-13.3V104L46.9 76.8c-6.1-6.2-8.4-15.2-6-23.6s9.3-14.8 17.8-16.7L218.6 .6zM214 466.7L224 480l10-13.3 6.2-8.2L224 431.6l-16.2 26.9 6.2 8.2zM128.1 352.1l69.4 92.5 17-28.3-37-51.7c-1.7-2.4-2-5.6-.6-8.3s4.1-4.3 7.1-4.3h80c3 0 5.7 1.7 7.1 4.3s1.1 5.9-.6 8.3l-37 51.7 17 28.3 69.4-92.5C391.2 355.4 448 414.3 448 486.4c0 14.1-11.5 25.6-25.6 25.6H25.6C11.5 512 0 500.5 0 486.4c0-72.1 56.8-131 128.1-134.3zm199.3 16.7L236.8 489.6 232 496H422.4c5.3 0 9.6-4.3 9.6-9.6c0-60.7-45.7-110.8-104.6-117.6zM216 496l-4.8-6.4L120.6 368.8C61.7 375.6 16 425.7 16 486.4c0 5.3 4.3 9.6 9.6 9.6H216zM96.3 183.3c4.8 2.3 10.1 4.5 15.7 6.7c0 .7 0 1.3 0 2c0 61.9 50.1 112 112 112s112-50.1 112-112c0-.7 0-1.3 0-2c5.7-2.2 10.9-4.4 15.7-6.7c.2 2.9 .3 5.8 .3 8.7c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-2.9 .1-5.8 .3-8.7zM224 402.2L248.5 368H199.5L224 402.2zM320 440c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8s-3.6 8-8 8H328c-4.4 0-8-3.6-8-8zM163.6 64.8L224 95.1l60.4-30.2c4-2 8.8-.4 10.7 3.6s.4 8.8-3.6 10.7l-64 32c-2.3 1.1-4.9 1.1-7.2 0l-64-32c-4-2-5.6-6.8-3.6-10.7s6.8-5.6 10.7-3.6z"],
    "piano-keyboard": [576, 512, [127929], "f8d5", "M448 224v72c0 13.3-10.7 24-24 24s-24-10.7-24-24V224h48zM416 335.2V432H296V335.2c18.3-3.7 32-19.8 32-39.2V224h56v72c0 19.4 13.7 35.5 32 39.2zM432 432V335.2c18.3-3.7 32-19.8 32-39.2V224h96V384c0 26.5-21.5 48-48 48H432zm-152 0H160V335.2c18.3-3.7 32-19.8 32-39.2V224h56v72c0 19.4 13.7 35.5 32 39.2V432zm-136 0H64c-26.5 0-48-21.5-48-48V224h96v72c0 19.4 13.7 35.5 32 39.2V432zm8-112c-13.3 0-24-10.7-24-24V224h48v72c0 13.3-10.7 24-24 24zm136 0c-13.3 0-24-10.7-24-24V224h48v72c0 13.3-10.7 24-24 24zM456 208H392 320 256 184 120 16V128c0-26.5 21.5-48 48-48H512c26.5 0 48 21.5 48 48v80H456zm120 0V128c0-35.3-28.7-64-64-64H64C28.7 64 0 92.7 0 128v80 8 8V384c0 35.3 28.7 64 64 64H512c35.3 0 64-28.7 64-64V224v-8-8z"],
    "bed-empty": [640, 512, [128719], "f8f9", "M16 40c0-4.4-3.6-8-8-8s-8 3.6-8 8V200 328v80 64c0 4.4 3.6 8 8 8s8-3.6 8-8V416H624v56c0 4.4 3.6 8 8 8s8-3.6 8-8V408 328 296c0-57.4-46.6-104-104-104H16V40zM624 320H16V208H536c48.6 0 88 39.4 88 88v24zM16 336H624v64H16V336z"],
    "circle-arrow-up": [512, 512, ["arrow-circle-up"], "f0aa", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM365.7 234.3l-104-104c-3.1-3.1-8.2-3.1-11.3 0l-104 104c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L248 155.3V376c0 4.4 3.6 8 8 8s8-3.6 8-8V155.3l90.3 90.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3z"],
    "toggle-on": [576, 512, [], "f205", "M160 112C80.5 112 16 176.5 16 256s64.5 144 144 144H416c79.5 0 144-64.5 144-144s-64.5-144-144-144H160zM0 256C0 167.6 71.6 96 160 96H416c88.4 0 160 71.6 160 160s-71.6 160-160 160H160C71.6 416 0 344.4 0 256zm496 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-176 0a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z"],
    "rectangle-vertical": [384, 512, ["rectangle-portrait"], "f2fb", "M368 448c0 26.5-21.5 48-48 48L64 496c-26.5 0-48-21.5-48-48L16 64c0-26.5 21.5-48 48-48l256 0c26.5 0 48 21.5 48 48l0 384zM384 64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384z"],
    "person-walking": [320, 512, [128694, "walking"], "f554", "M142 203.4l-16.9 63.5c-4.2 15.8-.1 32.7 11 44.8l70.7 77.1c1.8 2 3.1 4.3 3.7 6.9l22 88.1c2.1 8.6 10.8 13.8 19.4 11.6s13.8-10.8 11.6-19.4l-23-92.1c-1.3-5.2-3.9-9.9-7.5-13.9l-49.5-54c-3.8-4.1-5.1-9.9-3.6-15.3l19.3-65.5c1.9-6.5 7.7-11.1 14.5-11.5s13 3.6 15.6 9.8l10.2 24.5c2.2 5.3 5.8 9.9 10.3 13.3l28.5 21.4c7.1 5.3 17.1 3.9 22.4-3.2s3.9-17.1-3.2-22.4l-25-18.8c-2.3-1.7-4.1-4-5.2-6.6l-16.5-39.7c-14.7-35.2-49-58.1-87.1-58.1c-20.5 0-40.8 4.3-59.6 12.6l-5.7 2.5c-30.3 13.5-53.1 39.7-62.2 71.6l-3.7 12.9c-2.4 8.5 2.5 17.4 11 19.8s17.4-2.5 19.8-11l3.7-12.9c6.5-22.8 22.8-41.5 44.4-51.1l5.7-2.5 0 0c1.1-.5 2.2-1 3.4-1.4c5.6-2.3 12.1-1.2 16.6 2.8s6.4 10.3 4.9 16.1zM244 52a36 36 0 1 0 -72 0 36 36 0 1 0 72 0zM118 203c-3.7 1.7-7.3 3.7-10.6 6c-12 8.3-20.9 20.6-24.9 34.9l-3.7 12.9c-4.9 17-22.6 26.8-39.6 22s-26.8-22.6-22-39.6l3.7-12.9c10.4-36.4 36.4-66.4 71.1-81.8l5.7-2.5c20.8-9.2 43.3-14 66.1-14c44.6 0 84.8 26.8 101.9 67.9l16.5 39.7 25 18.8c14.1 10.6 17 30.7 6.4 44.8s-30.7 17-44.8 6.4l-28.5-21.4c-6.9-5.1-12.2-12-15.5-19.9l-.4-1-9.8-23.5-7.2 24.4-12.1 41.2 49.5 54c5.4 5.9 9.2 13 11.2 20.8l23 92.1c4.3 17.1-6.1 34.5-23.3 38.8s-34.5-6.1-38.8-23.3l-22-88.1-70.7-77.1c-14.8-16.1-20.3-38.6-14.7-59.7l11.6-43.6 1.5-5.6 2.5-9.6 1.3-4.8c-1 .4-1.9 .8-2.9 1.2L118 203zM208 0a52 52 0 1 1 0 104A52 52 0 1 1 208 0zM103.4 354.3L83 405.5l-.6 1.5-1.2 1.2L20.7 468.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L105 429.6c3.1-3.1 5.5-6.7 7.1-10.7L127.2 381c1.6-4.1 6.3-6.1 10.4-4.5s6.1 6.3 4.5 10.4l-15.1 37.9c-2.4 6-6 11.5-10.6 16.1L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L68.7 398l19.8-49.6c1.6-4.1 6.3-6.1 10.4-4.5s6.1 6.3 4.5 10.4z"],
    "l": [320, 512, [108], "4c", "M40 32c4.4 0 8 3.6 8 8V464H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H48c-8.8 0-16-7.2-16-16V40c0-4.4 3.6-8 8-8z"],
    "signal-stream": [576, 512, [], "f8dd", "M82.3 65.9c3.3 2.9 3.7 8 .8 11.3C41.3 125 16 187.5 16 256s25.3 131 67 178.8c2.9 3.3 2.6 8.4-.8 11.3s-8.4 2.6-11.3-.8C26.8 394.7 0 328.5 0 256S26.8 117.3 71 66.7c2.9-3.3 8-3.7 11.3-.8zm411.5 0c3.3-2.9 8.4-2.6 11.3 .8c44.2 50.6 71 116.9 71 189.3s-26.8 138.7-71 189.3c-2.9 3.3-8 3.7-11.3 .8s-3.7-8-.8-11.3C534.7 387 560 324.5 560 256s-25.3-131-67-178.8c-2.9-3.3-2.6-8.4 .8-11.3zM240 256a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm48 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM154.6 141.1C128.1 172 112 212.1 112 256s16.1 84 42.6 114.9c2.9 3.3 2.5 8.4-.8 11.3s-8.4 2.5-11.3-.8C113.5 347.7 96 303.9 96 256s17.5-91.7 46.5-125.3c2.9-3.3 7.9-3.7 11.3-.8s3.7 7.9 .8 11.3zm278.9-10.4c29 33.6 46.5 77.4 46.5 125.3s-17.5 91.7-46.5 125.3c-2.9 3.3-7.9 3.7-11.3 .8s-3.7-7.9-.8-11.3C447.9 340 464 299.9 464 256s-16.1-84-42.6-114.9c-2.9-3.3-2.5-8.4 .8-11.3s8.4-2.5 11.3 .8z"],
    "down-to-bracket": [448, 512, [], "e4e7", "M216 332.7c2.1 2.1 5 3.3 8 3.3s5.9-1.2 8-3.3L363.8 200.6c2.7-2.7 4.2-6.4 4.2-10.2c0-8-6.5-14.4-14.4-14.4H280c-4.4 0-8-3.6-8-8V32c0-8.8-7.2-16-16-16H192c-8.8 0-16 7.2-16 16V168c0 4.4-3.6 8-8 8H94.4c-8 0-14.4 6.5-14.4 14.4c0 3.8 1.5 7.5 4.2 10.2L216 332.7zm8 19.3c-7.2 0-14.2-2.9-19.3-8L72.9 211.9c-5.7-5.7-8.9-13.4-8.9-21.5C64 173.6 77.6 160 94.4 160H160V32c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32V160h65.6c16.8 0 30.4 13.6 30.4 30.4c0 8.1-3.2 15.8-8.9 21.5L243.3 344c-5.1 5.1-12.1 8-19.3 8zM16 328v96c0 39.8 32.2 72 72 72H360c39.8 0 72-32.2 72-72V328c0-4.4 3.6-8 8-8s8 3.6 8 8v96c0 48.6-39.4 88-88 88H88c-48.6 0-88-39.4-88-88V328c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "circle-z": [512, 512, [], "e130", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 128c-4.4 0-8 3.6-8 8s3.6 8 8 8H335.4L153.8 371c-1.9 2.4-2.3 5.7-1 8.5s4.1 4.5 7.2 4.5H352c4.4 0 8-3.6 8-8s-3.6-8-8-8H176.6L358.2 141c1.9-2.4 2.3-5.7 1-8.5s-4.1-4.5-7.2-4.5H160z"],
    "stars": [512, 512, [], "f762", "M344 0c4.4 0 8 3.6 8 8V72h64c4.4 0 8 3.6 8 8s-3.6 8-8 8H352v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V88H272c-4.4 0-8-3.6-8-8s3.6-8 8-8h64V8c0-4.4 3.6-8 8-8zM138.4 258.5c-2.3 4.7-6.8 8-12 8.8L22.9 282.3c-6.6 1-9.2 9-4.4 13.6l74.9 73.2c3.8 3.7 5.5 9 4.6 14.1L80.3 486.6c-1.1 6.5 5.7 11.5 11.6 8.4l92.6-48.8c4.7-2.5 10.2-2.5 14.9 0L291.9 495c5.9 3.1 12.7-1.9 11.6-8.4L285.9 383.3c-.9-5.2 .8-10.5 4.6-14.1l74.9-73.2c4.7-4.6 2.1-12.7-4.4-13.6L257.4 267.2c-5.2-.8-9.7-4-12-8.8l-46.3-94c-2.9-6-11.4-6-14.4 0l-46.3 94zM7.2 307.4C-7 293.5 .9 269.3 20.5 266.5l103.5-15.1 46.3-94c8.8-17.9 34.3-17.9 43.1 0l46.3 94 103.5 15.1c19.7 2.9 27.5 27 13.3 40.9l-74.9 73.2 17.7 103.3c3.4 19.6-17.2 34.6-34.8 25.3l-92.6-48.8L99.3 509.2c-17.6 9.3-38.2-5.7-34.8-25.3L82.2 380.6 7.2 307.4zM464 160v48h48c4.4 0 8 3.6 8 8s-3.6 8-8 8H464v48c0 4.4-3.6 8-8 8s-8-3.6-8-8V224H400c-4.4 0-8-3.6-8-8s3.6-8 8-8h48V160c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "fire": [448, 512, [128293], "f06d", "M252.2 99.4c3.1 3.8 7.7 6.1 12.7 6s9.5-2.4 12.5-6.3c11-14.3 22.8-29.2 35.3-41c1.7-1.6 4.3-1.6 5.9 0c32.9 31.4 61.2 73.4 81.3 113.6c20 40.1 32.1 79.1 32.1 104.7C432 396.3 338.5 496 224 496C108.2 496 16 396.3 16 276.5c0-34.1 16.1-78 43.1-123.6c27.1-45.7 65.6-93.6 111-135.8c1.7-1.5 4.2-1.5 5.9 0c27.1 25.3 52.4 52.7 76.1 82.3zm12.5-10c-3.4-4.3-6.9-8.5-10.4-12.7c-21.2-25.3-43.6-49-67.3-71.2c-7.8-7.3-19.9-7.3-27.7-.1c-46.5 43.2-86 92.3-113.9 139.3C17.8 191.2 0 238.1 0 276.5C0 404.1 98.4 512 224 512c124.2 0 224-107.8 224-235.5c0-29.3-13.5-71.1-33.8-111.9c-20.7-41.4-49.9-85-84.5-118c-7.8-7.5-20.1-7.5-28-.1c-9.5 9-18.6 19.5-26.9 30c-3.5 4.4-6.9 8.7-10.1 13zm38.8 318.9l0 0 .3-.2c54.6-38.1 60-113.2 28.3-164.5c-8.9-14.5-28.2-13.9-37.8-2.7l-31.4 36.5 0 0c-18.8-23.9-54.4-69.2-68.9-87.6c-9.6-12.2-27.9-11.9-37.4-.1C119.3 235.8 96 268.3 96 306.8s14.3 70.2 38.4 92.1c23.9 21.8 56.4 33.1 91.3 33.1c28.5 0 54.1-8 77.7-23.7zm15-156.3c28.2 45.7 22.3 110.8-23.9 143c-21.1 14-43.5 21-68.8 21C162.6 416 112 375.4 112 306.8c0-31.9 19-60 56.9-107.1c3.2-4 9.2-4 12.4 0c14.5 18.4 50.2 63.8 69 87.6c6.2 7.9 18.1 8.1 24.7 .5l31.4-36.5c3.3-3.9 9.4-3.7 12.1 .7z"],
    "bed-pulse": [640, 512, ["procedures"], "f487", "M471.2 4.4L500.9 64H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H496c-3 0-5.8-1.7-7.2-4.4l-24-48.1L407.4 171c-1.2 2.9-3.9 4.9-7.1 5s-6.1-1.6-7.5-4.4L347.1 80H200c-4.4 0-8-3.6-8-8s3.6-8 8-8H352c3 0 5.8 1.7 7.2 4.4l40 80.1L456.6 5c1.2-2.9 3.9-4.9 7.1-5s6.1 1.6 7.5 4.4zM312 160h39.3l8 16H312c-13.3 0-24 10.7-24 24V352H624V264c0-48.6-39.4-88-88-88H439.9l6.4-16H536c57.4 0 104 46.6 104 104v96 80 64c0 4.4-3.6 8-8 8s-8-3.6-8-8V448H16v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V440 360 72c0-4.4 3.6-8 8-8s8 3.6 8 8V352H272V200c0-22.1 17.9-40 40-40zM624 432V368H280 16v64H624zM208 240A64 64 0 1 0 80 240a64 64 0 1 0 128 0zM64 240a80 80 0 1 1 160 0A80 80 0 1 1 64 240z"],
    "house-day": [640, 512, [], "e00e", "M161.2 8.4L130.1 66.2 67.3 47.4c-12.2-3.7-23.6 7.7-19.9 19.9l18.8 62.9L8.4 161.3c-11.2 6-11.2 22.1 0 28.2l57.8 31.1L47.3 283.5c-3.7 12.2 7.7 23.6 19.9 19.9l69.1-20.7c4.2-1.3 6.6-5.7 5.4-10s-5.7-6.6-10-5.4L62.7 288.1 83.4 219c1.1-3.6-.5-7.5-3.9-9.3L16 175.4l63.5-34.2c3.3-1.8 5-5.7 3.9-9.3L62.7 62.7l69.1 20.7c3.6 1.1 7.5-.5 9.3-3.9L175.3 16l34.2 63.5c1.8 3.3 5.7 5 9.3 3.9L288 62.7l-20.7 69.1c-1.3 4.2 1.1 8.7 5.4 10s8.7-1.1 10-5.4l20.7-69.1c3.7-12.2-7.7-23.6-19.9-19.9L220.5 66.2 189.4 8.4c-6-11.2-22.1-11.2-28.2 0zm12.8 213.4a47.7 47.7 0 1 1 0-95.3 47.7 47.7 0 1 1 0 95.3zm-63.6-47.7a63.6 63.6 0 1 0 127.3 0 63.6 63.6 0 1 0 -127.3 0zM405.2 97.9c-3-2.6-7.4-2.6-10.4 0l-232 200c-3.3 2.9-3.7 7.9-.8 11.3s7.9 3.7 11.3 .8L224 266.3V456c0 30.9 25.1 56 56 56H520c30.9 0 56-25.1 56-56V266.3l50.8 43.8c3.3 2.9 8.4 2.5 11.3-.8s2.5-8.4-.8-11.3l-232-200zM560 252.5V456c0 22.1-17.9 40-40 40H280c-22.1 0-40-17.9-40-40V252.5L400 114.6 560 252.5zM336 296v80c0 13.3 10.7 24 24 24h80c13.3 0 24-10.7 24-24V296c0-13.3-10.7-24-24-24H360c-13.3 0-24 10.7-24 24zm24-8h80c4.4 0 8 3.6 8 8v80c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8V296c0-4.4 3.6-8 8-8z"],
    "shuttle-space": [640, 512, ["space-shuttle"], "f197", "M405.3 352L245.2 448.1C210.4 469 170.6 480 130 480H80c-26.5 0-48-21.5-48-48V384c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32V80c0-26.5 21.5-48 48-48h50c40.6 0 80.4 11 115.2 31.9L405.3 160H456c60.5 0 128.5 31.4 170.4 76.8c10 10.9 10 27.6 0 38.5C584.5 320.6 516.5 352 456 352H405.3zm-31.1 0h-185c-5.5 0-11.2 3.1-16.1 8.5c-9.7 10.6-22.6 18.4-37.2 21.7v81.7c35.6-1 70.4-11.2 101-29.6L374.2 352zM48 384v48c0 17.7 14.3 32 32 32h40V384H48zM374.2 160L237 77.6c-30.6-18.4-65.4-28.5-101-29.6v81.7c14.6 3.3 27.5 11 37.2 21.7c4.9 5.4 10.6 8.5 16.1 8.5h185zM80 48C62.3 48 48 62.3 48 80v48h72V48H80zM16 160v88H184c4.4 0 8 3.6 8 8s-3.6 8-8 8H16v88c0 8.8 7.2 16 16 16h88c16.4 0 31.1-7 41.4-18.2c6.6-7.3 16.3-13.8 27.9-13.8H456c55.7 0 119.6-29.3 158.6-71.6c4.4-4.8 4.4-12 0-16.8C575.6 205.3 511.7 176 456 176H189.3c-11.6 0-21.3-6.5-27.9-13.8C151.1 151 136.4 144 120 144H32c-8.8 0-16 7.2-16 16zm472 56c4.4 0 8 3.6 8 8v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V224c0-4.4 3.6-8 8-8z"],
    "shirt-long-sleeve": [640, 512, [], "e3c7", "M95.3 61.6c15.5-28.1 45-45.6 77.1-45.6H192h16c.9 0 1.8 .1 2.7 .2c.5 .1 1.1 .1 1.6 0c1.2-.1 2.4-.2 3.7-.2h9.3c7.6 45.4 47.1 80 94.7 80s87.1-34.6 94.7-80H424c1.2 0 2.5 .1 3.7 .2c.5 0 1.1 0 1.6 0c.9-.1 1.8-.2 2.7-.2h16 19.6c32.1 0 61.6 17.5 77.1 45.6l66.4 120.7c8.4 15.4 12.9 32.6 12.9 50.1V376c0 13.3-10.7 24-24 24H568c-13.3 0-24-10.7-24-24V232.4c0-4-1-8-3-11.6l-7 3.9 7-3.9L483.7 116.7c-1.6-3-3.6-5.7-5.9-8.1c-2.2-2.4-5.7-3.2-8.8-2s-5 4.2-5 7.4V464c0 17.7-14.3 32-32 32H208c-17.7 0-32-14.3-32-32V114.1c0-3.3-2-6.2-5.1-7.4s-6.5-.4-8.8 2c-2.3 2.4-4.3 5.2-5.9 8.1L99 220.9c-1.9 3.5-3 7.5-3 11.6V376c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V232.4c0-17.5 4.4-34.8 12.9-50.1L95.3 61.6zM398.4 16C391 52.5 358.7 80 320 80s-71-27.5-78.4-64H398.4zM172.4 0C134.5 0 99.5 20.6 81.3 53.9L14.9 174.6C5.1 192.3 0 212.2 0 232.4V376c0 22.1 17.9 40 40 40H72c22.1 0 40-17.9 40-40V232.4c0-1.3 .3-2.7 1-3.9l47-85.5V464c0 26.5 21.5 48 48 48H432c26.5 0 48-21.5 48-48V143.1l47 85.5c.6 1.2 1 2.5 1 3.9V376c0 22.1 17.9 40 40 40h32c22.1 0 40-17.9 40-40V232.4c0-20.2-5.1-40.1-14.9-57.8L558.7 53.9C540.5 20.6 505.5 0 467.6 0H448 432c-1.2 0-2.5 .1-3.7 .2c-1.4-.1-2.9-.2-4.3-.2H216c-1.5 0-2.9 .1-4.3 .2c-1.2-.1-2.4-.2-3.7-.2H192 172.4z"],
    "chart-pie-simple": [512, 512, ["chart-pie-alt"], "f64e", "M259 7.6c-1.9 2.9-3 6.3-3 10V240c0 8.8 7.2 16 16 16H494.3c9.6 0 17.7-7.4 17.7-17.1C512 107 405 0 273.1 0c-5.9 0-11 3.1-14.1 7.6zM494.3 240H272V17.7c0-.7 .2-1.1 .5-1.4c.1-.1 .2-.2 .3-.2c0 0 .1 0 .3 0C396.2 16 496 115.8 496 238.9c0 .1 0 .2 0 .3c0 .1-.1 .2-.2 .3c-.3 .3-.8 .5-1.4 .5zM208 288c0 8.8 7.2 16 16 16H445.3c10 0 15.3 8 13.9 14.5C437.8 419.9 347.7 496 240 496C116.3 496 16 395.7 16 272C16 164.3 92.1 74.2 193.5 52.8C200 51.4 208 56.7 208 66.7V288zM224 66.7c0-18.5-15.7-33.3-33.8-29.5C81.5 60.1 0 156.5 0 272C0 404.5 107.5 512 240 512c115.5 0 211.9-81.5 234.8-190.2c3.8-18.1-11-33.8-29.5-33.8H240 224V272 66.7z"],
    "face-laugh": [512, 512, ["laugh"], "f599", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM256 416c64.7 0 119.5-44.8 135.8-106.1c.4-1.4 .1-2.5-.9-3.6c-1.1-1.2-3-2.3-5.4-2.3H126.5c-2.4 0-4.4 1.1-5.4 2.3c-1 1.1-1.2 2.2-.9 3.6C136.5 371.2 191.3 416 256 416zM126.5 288H385.5c14.2 0 25.4 12.3 21.8 26c-18.1 68-79 118-151.3 118s-133.2-50-151.3-118c-3.6-13.7 7.6-26 21.8-26zm33.9-96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm176-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", "M64 464c-10.6 0-20.5-5.3-26.5-14.1s-7.2-20-3.2-29.8l64-160C103.1 248 114.9 240 128 240H528c10.6 0 20.5 5.3 26.5 14.1s7.2 20 3.2 29.8l-64 160C488.9 456 477.1 464 464 464H384 64zm320 16h80c19.6 0 37.3-11.9 44.6-30.2l64-160c5.9-14.8 4.1-31.5-4.8-44.7S543.9 224 528 224H128c-19.6 0-37.3 11.9-44.6 30.2l-64 160c-1.3 3.2-2.2 6.5-2.8 9.8c-.4-2.6-.7-5.3-.7-8V96c0-26.5 21.5-48 48-48H181.5c12.7 0 24.9 5.1 33.9 14.1l26.5 26.5c15 15 35.4 23.4 56.6 23.4H416c26.5 0 48 21.5 48 48v32h16V160c0-35.3-28.7-64-64-64H298.5c-17 0-33.3-6.7-45.3-18.7L226.7 50.7c-12-12-28.3-18.7-45.3-18.7H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384z"],
    "album-collection-circle-user": [640, 512, [], "e48f", "M64 0H448c17.7 0 32 14.3 32 32v8c0 4.4-3.6 8-8 8s-8-3.6-8-8V32c0-8.8-7.2-16-16-16H64c-8.8 0-16 7.2-16 16v8c0 4.4-3.6 8-8 8s-8-3.6-8-8V32C32 14.3 46.3 0 64 0zM16 112c0-17.7 14.3-32 32-32H464c17.7 0 32 14.3 32 32v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-8.8-7.2-16-16-16H48c-8.8 0-16 7.2-16 16v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8zM4.2 212.6C1.5 184.4 23.7 160 52 160H460c21.2 0 38.9 13.6 45.4 32.2c-3.1-.2-6.2-.2-9.4-.2c-2.7 0-5.5 .1-8.2 .2C482.4 182.6 472 176 460 176H52c-18.9 0-33.6 16.2-31.9 35L44.5 467c1.6 16.4 15.4 29 31.9 29H375.2c6.1 5.8 12.7 11.1 19.6 16H76.4c-24.7 0-45.4-18.8-47.8-43.4L4.2 212.6zM256 208c45.1 0 86.3 12.7 117.4 33.7c-3.9 3.8-7.6 7.7-11.1 11.8C334.3 235.3 297.2 224 256 224c-45.5 0-86 13.8-114.9 35.5S96 309.7 96 340s16.3 58.9 45.1 80.5S210.5 456 256 456c29.2 0 56.3-5.7 79.6-15.5c2.2 4.9 4.6 9.7 7.3 14.3C317.2 465.8 287.6 472 256 472c-97.2 0-176-59.1-176-132s78.8-132 176-132zm25.8 160.6c-7.3 4.9-16.5 7.4-25.8 7.4s-18.5-2.5-25.8-7.4C223 363.8 216 355.4 216 344s7-19.8 14.2-24.6c7.3-4.9 16.5-7.4 25.8-7.4s18.5 2.5 25.8 7.4c7.2 4.8 14.2 13.2 14.2 24.6s-7 19.8-14.2 24.6zM256 360c13.3 0 24-7.2 24-16s-10.7-16-24-16s-24 7.2-24 16s10.7 16 24 16zM573.9 469.6l-3.3-6.6c-9.5-19-28.9-31-50.1-31H471.6c-21.2 0-40.6 12-50.1 31l-3.3 6.6C439.7 486.2 466.7 496 496 496s56.3-9.8 77.9-26.4zm12.4-10.9C609.6 435.5 624 403.5 624 368c0-70.7-57.3-128-128-128s-128 57.3-128 128c0 35.5 14.4 67.5 37.7 90.7l1.5-2.9c12.2-24.4 37.1-39.8 64.4-39.8h48.9c27.3 0 52.2 15.4 64.4 39.8l1.5 2.9zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "candy": [640, 512, [127852], "e3e7", "M391.5 416.9L234.2 102.3c-26.1 14.6-48 35.6-63.7 60.8L304.6 431.3c7 .6 14.1 .8 21.3 .6c23.4-.8 45.5-6.1 65.6-15zm14.3-7.2c26.1-14.6 48-35.6 63.7-60.8L335.4 80.7c-7-.6-14.1-.8-21.3-.6c-23.3 .8-45.5 6.1-65.6 15L405.8 409.7zm73.1-77.9c11.8-24.7 18-52.5 17-81.7c-2.8-83.2-63-151-141.3-166.7L478.9 331.8zM345.8 65.7c76 10.2 138.5 65.1 159 138.1l91.9-49c10.5-5.6 23.5-2.7 30.6 6.9c13 17.5-3.4 34.9-18.4 48.6c-1.6 1.5-3.3 2.9-4.9 4.3l0 0c-3.2 2.9-6.3 5.6-8.7 8c2.8 1 5.8 2 9 3l0 0c2.7 .9 5.5 1.8 8.3 2.7c13.8 4.9 27.4 11.9 27.4 27.6s-13.6 22.7-27.4 27.6c-2.8 1-5.6 1.9-8.3 2.7l0 0 0 0c-3.2 1-6.3 2-9 3c2.4 2.4 5.4 5.1 8.7 8l0 0 0 0 0 0c1.6 1.4 3.2 2.8 4.9 4.3c15 13.6 31.4 31.1 18.4 48.6c-7.1 9.6-20.1 12.5-30.6 6.9l-91.9-49C482.7 386.5 412.1 445 326.4 447.9c-90.2 3-167.9-56.6-191.3-139.7l-91.9 49c-10.5 5.6-23.5 2.7-30.6-6.9c-13-17.5 3.4-34.9 18.4-48.6c1.6-1.5 3.3-2.9 4.8-4.3l0 0 0 0 0 0 0 0c3.2-2.9 6.3-5.6 8.7-8c-2.8-1-5.8-2-9-3l0 0 0 0c-2.7-.9-5.5-1.8-8.3-2.7C13.6 278.7 0 271.7 0 256s13.6-22.7 27.4-27.6c2.8-1 5.6-1.9 8.3-2.7l0 0 0 0c3.2-1 6.3-2 9-3c-2.4-2.4-5.4-5.1-8.7-8l0 0 0 0c-1.6-1.4-3.2-2.8-4.8-4.3C16.1 196.7-.3 179.3 12.7 161.7c7.1-9.6 20.1-12.5 30.6-6.9l91.9 49c4.1-14.5 9.9-28.4 17.1-41.4l0 0c3.1-5.5 6.4-10.8 9.9-15.9l0 0C179 122.4 201.2 102.3 227 88l0 0c4.7-2.6 9.4-5 14.3-7.2l0 0c22.1-9.9 46.5-15.8 72.2-16.7c4.6-.2 9.1-.1 13.6 0l0 0c6.3 .2 12.5 .8 18.7 1.6l0 0zM161.1 180.2c-11.8 24.7-18 52.5-17 81.7c2.8 83.2 63 151 141.3 166.7L161.1 180.2zm350.8 69.4c.5 14.6-.7 28.8-3.3 42.5l95.6 51c3.5 1.9 7.8 .9 10.2-2.3c1.7-2.3 1.7-3.7 1.5-4.9c-.4-2-1.8-5.1-5.2-9.5c-3.3-4.2-7.7-8.5-12.6-12.9c-1.3-1.2-2.7-2.5-4.2-3.8l0 0c-3.4-3.1-7.1-6.3-9.8-9.1c-3.8-3.8-5.5-9.4-4.3-14.7s4.9-9.7 10-11.6c3.1-1.2 6.8-2.4 10.3-3.5l0 0c1.5-.5 3-1 4.3-1.4c4.8-1.6 8.9-3.1 12.2-4.9c6.6-3.5 7.5-5.9 7.5-8.6s-.9-5.2-7.5-8.7c-3.4-1.8-7.5-3.3-12.2-4.9c-1.3-.4-2.8-.9-4.3-1.4c-3.4-1.1-7.2-2.3-10.3-3.5c-5.1-1.9-8.9-6.3-10-11.6s.5-10.9 4.3-14.7c2.8-2.8 6.4-6 9.8-9.1l0 0c1.5-1.3 2.9-2.6 4.2-3.8c4.9-4.4 9.3-8.7 12.6-12.9c3.4-4.3 4.9-7.4 5.2-9.5c.2-1.3 .3-2.6-1.5-4.9c-2.4-3.2-6.7-4.2-10.2-2.3l-95.6 51c1.8 9.6 2.9 19.5 3.3 29.6zM131.4 219.9l-95.6-51c-3.5-1.9-7.8-.9-10.2 2.3c-1.7 2.3-1.7 3.7-1.5 4.9c.4 2 1.8 5.1 5.2 9.5c3.3 4.2 7.7 8.5 12.6 12.9c1.3 1.2 2.7 2.5 4.2 3.8l0 0 0 0c3.4 3.1 7.1 6.3 9.8 9.1c3.8 3.8 5.5 9.4 4.3 14.7s-4.9 9.7-10 11.6c-3.1 1.2-6.8 2.4-10.3 3.5l0 0 0 0 0 0c-1.5 .5-3 1-4.3 1.4c-4.8 1.6-8.9 3.1-12.2 4.9c-6.6 3.5-7.5 5.9-7.5 8.7s.9 5.2 7.5 8.6c3.4 1.8 7.5 3.3 12.2 4.9c1.3 .4 2.8 .9 4.3 1.4l0 0c3.4 1.1 7.2 2.3 10.3 3.5c5.1 1.9 8.9 6.3 10 11.6s-.5 10.9-4.3 14.7c-2.8 2.8-6.4 6-9.8 9.1c-1.5 1.3-2.9 2.6-4.2 3.8c-4.9 4.4-9.3 8.7-12.6 12.9c-3.4 4.3-4.9 7.4-5.2 9.5c-.2 1.3-.3 2.6 1.5 4.9c2.4 3.2 6.7 4.2 10.2 2.3l95.6-51c-1.8-9.6-2.9-19.5-3.3-29.6c-.5-14.6 .7-28.8 3.3-42.5z"],
    "bowl-hot": [512, 512, ["soup"], "f823", "M136 0c4.4 0 8 3.6 8 8V25.4c0 26.1 13.7 50.3 36.1 63.8c27.2 16.3 43.9 45.8 43.9 77.5V184c0 4.4-3.6 8-8 8s-8-3.6-8-8V166.6c0-26.1-13.7-50.3-36.1-63.8C144.7 86.5 128 57.1 128 25.4V8c0-4.4 3.6-8 8-8zm-.1 458.9c4.5 2.2 7.7 6.4 8.7 11.3c2.9 14.7 15.9 25.8 31.4 25.8H336c15.5 0 28.5-11.1 31.4-25.8c1-4.9 4.2-9.1 8.7-11.3c65.5-32 111.8-97.4 116.4-174.7l1.6-27.3c.5-9.2-6.8-16.9-16-16.9H33.9c-9.2 0-16.5 7.7-16 16.9l1.6 27.3c4.5 77.3 50.9 142.7 116.4 174.7zM2 257.9C.9 239.5 15.5 224 33.9 224H478.1c18.4 0 33 15.5 31.9 33.9l-1.6 27.3c-4.9 83.3-54.8 153.7-125.3 188.2c-4.3 22-23.8 38.7-47.1 38.7H176c-23.3 0-42.8-16.6-47.1-38.7C58.4 438.9 8.5 368.4 3.6 285.2L2 257.9zM272 8V25.4c0 26.1 13.7 50.3 36.1 63.8c27.2 16.3 43.9 45.8 43.9 77.5V184c0 4.4-3.6 8-8 8s-8-3.6-8-8V166.6c0-26.1-13.7-50.3-36.1-63.8C272.7 86.5 256 57.1 256 25.4V8c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "flatbread": [512, 512, [129747], "e40b", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm357.7-90.3l-192 192c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l192-192c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3zm-112-59.3c3.1 3.1 3.1 8.2 0 11.3l-128 128c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l128-128c3.1-3.1 8.2-3.1 11.3 0zm160 171.3l-128 128c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l128-128c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "heart-circle-plus": [576, 512, [], "e500", "M393.6 57.7c-42.9-5.6-85.8 12.6-111.2 47.6l-20 27.5c-1.5 2.1-3.9 3.3-6.5 3.3s-5-1.2-6.5-3.3l-20-27.5c-25.4-34.9-68.3-53.2-111.2-47.6C60.1 65.3 16 114.9 16 173.5c0 30.3 11.8 59.4 32.9 81.2L248 460.4c2.2 2.3 5.2 3.6 8.4 3.6s6.2-1.3 8.4-3.6l11-11.4c2.6 4.9 5.4 9.7 8.4 14.4l-7.8 8.1c-5.2 5.4-12.4 8.5-19.9 8.5c-7.5 0-14.7-3-19.9-8.4L37.4 265.8C13.4 241.1 0 208 0 173.5C0 106.8 50.2 50.4 116.3 41.8c48.6-6.3 97.4 14.3 126.2 54L256 114.4l13.5-18.6c28.9-39.7 77.6-60.4 126.2-54c66.1 8.6 116.3 65 116.3 131.8c0 12-1.6 23.9-4.8 35.3c-4.9-2.3-9.8-4.4-14.9-6.2c2.4-9.4 3.7-19.2 3.7-29C496 115 451.9 65.3 393.6 57.7zM560 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm152-72v64h64c4.4 0 8 3.6 8 8s-3.6 8-8 8H440v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V376H360c-4.4 0-8-3.6-8-8s3.6-8 8-8h64V296c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "code-fork": [448, 512, [], "e13b", "M64 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm64-48c0 32.6-24.4 59.6-56 63.5V192c0 30.9 25.1 56 56 56H320c30.9 0 56-25.1 56-56V127.5c-31.6-3.9-56-30.9-56-63.5c0-35.3 28.7-64 64-64s64 28.7 64 64c0 32.6-24.4 59.6-56 63.5V192c0 39.8-32.2 72-72 72H232V384h-8-8V264H128c-39.8 0-72-32.2-72-72V127.5C24.4 123.6 0 96.6 0 64C0 28.7 28.7 0 64 0s64 28.7 64 64zm96 448a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM384 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM272 448a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "city": [640, 512, [127961], "f64f", "M80 8V64h80V8c0-4.4 3.6-8 8-8s8 3.6 8 8V64h48V80H176 160 80 64 56c-22.1 0-40 17.9-40 40V456c0 22.1 17.9 40 40 40H236.8c3.3 5.7 7.2 11.1 11.6 16H56c-30.9 0-56-25.1-56-56V120C0 89.1 25.1 64 56 64h8V8c0-4.4 3.6-8 8-8s8 3.6 8 8zM480 176c-8.8 0-16-7.2-16-16V64c0-26.5-21.5-48-48-48H320c-26.5 0-48 21.5-48 48V224 448c0 26.5 21.5 48 48 48h96H576c26.5 0 48-21.5 48-48V224c0-26.5-21.5-48-48-48H480zm0-112v80 16h16 80c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H416 320c-35.3 0-64-28.7-64-64V224 64c0-35.3 28.7-64 64-64h96c35.3 0 64 28.7 64 64zM328 384V352c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H352c-13.3 0-24-10.7-24-24zm24 8h32c4.4 0 8-3.6 8-8V352c0-4.4-3.6-8-8-8H352c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8zm0-320h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H352c-13.3 0-24-10.7-24-24V96c0-13.3 10.7-24 24-24zm-8 24v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V96c0-4.4-3.6-8-8-8H352c-4.4 0-8 3.6-8 8zM328 256V224c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H352c-13.3 0-24-10.7-24-24zm24 8h32c4.4 0 8-3.6 8-8V224c0-4.4-3.6-8-8-8H352c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8zM512 440c-13.3 0-24-10.7-24-24V384c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H512zm-8-24c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V384c0-4.4-3.6-8-8-8H512c-4.4 0-8 3.6-8 8v32zM488 288V256c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H512c-13.3 0-24-10.7-24-24zm24 8h32c4.4 0 8-3.6 8-8V256c0-4.4-3.6-8-8-8H512c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8zM96 344c-13.3 0-24-10.7-24-24V288c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H96zm-8-24c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V288c0-4.4-3.6-8-8-8H96c-4.4 0-8 3.6-8 8v32zM72 192V160c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H96c-13.3 0-24-10.7-24-24zm24 8h32c4.4 0 8-3.6 8-8V160c0-4.4-3.6-8-8-8H96c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8z"],
    "signal-bars-weak": [640, 512, ["signal-alt-1"], "f691", "M112 464c0 17.7-14.3 32-32 32s-32-14.3-32-32V432c0-17.7 14.3-32 32-32s32 14.3 32 32v32zM80 384c-26.5 0-48 21.5-48 48v32c0 26.5 21.5 48 48 48s48-21.5 48-48V432c0-26.5-21.5-48-48-48z"],
    "microphone-lines": [384, 512, [127897, "microphone-alt"], "f3c9", "M272 112V96c0-44.2-35.8-80-80-80s-80 35.8-80 80V256c0 44.2 35.8 80 80 80s80-35.8 80-80H200c-4.4 0-8-3.6-8-8s3.6-8 8-8h72V192H200c-4.4 0-8-3.6-8-8s3.6-8 8-8h72V128H200c-4.4 0-8-3.6-8-8s3.6-8 8-8h72zm16 8v64 64 8c0 53-43 96-96 96s-96-43-96-96V96c0-53 43-96 96-96s96 43 96 96v24zM40 192c4.4 0 8 3.6 8 8v56c0 79.5 64.5 144 144 144s144-64.5 144-144V200c0-4.4 3.6-8 8-8s8 3.6 8 8v56c0 85.7-67.4 155.6-152 159.8V496h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H192 104c-4.4 0-8-3.6-8-8s3.6-8 8-8h80V415.8C99.4 411.6 32 341.7 32 256V200c0-4.4 3.6-8 8-8z"],
    "clock-twelve": [512, 512, [], "e358", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM264 104V256c0 4.4-3.6 8-8 8s-8-3.6-8-8V104c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "pepper-hot": [512, 512, [127798], "f816", "M441.6 127.3l5.8 4.6 5.3 5.2c26.8 26.2 43.4 62.6 43.4 103c0 16.7-2.8 32.7-8 47.5c-.4 1.2-.9 1.6-1 1.6l0 0c-.1 .1-.5 .3-1.2 .3c-1.4 0-3.7-.9-5.2-3.9l-11.7-23.4c-6.8-13.6-20.6-22.1-35.8-22.1H360c-4.4 0-8-3.6-8-8V152c0-22.1-17.9-40-40-40l-17.1 0c-3.1 0-4.6-1.1-5.1-1.8c.3-.2 .6-.4 1.1-.6C309.4 100.9 330.1 96 352 96c33.9 0 65 11.7 89.6 31.3zM512 240c0-44.8-18.4-85.3-48.1-114.4l0 0c.5-1 1.1-1.9 1.6-2.9c12-22.3 16.6-48 13.2-73c-1.1-8.1-3-16.1-5.8-23.9c-1.6-4.6-3.5-9.1-5.8-13.5l-3.9-7.8 0 0c-2-4-6.8-5.6-10.7-3.6s-5.6 6.8-3.6 10.7l3.9 7.8c5.9 11.9 9.4 24.5 10.6 37.2c1.3 14.6-.5 29.2-5.2 43c-1.8 5.2-4 10.3-6.6 15.2c-4.2-3.4-8.6-6.5-13.1-9.4C413.5 89.3 383.8 80 352 80c-24.3 0-47.3 5.4-67.9 15.1c-19.3 9-10.5 32.9 10.8 32.9l17.1 0c13.3 0 24 10.7 24 24v80c0 13.3 10.7 24 24 24h73.2c9.1 0 17.4 5.1 21.5 13.3l11.7 23.4c8.2 16.4 30.7 17.5 36.8 .1c5.8-16.5 8.9-34.3 8.9-52.8zM289.2 110.7a0 0 0 1 0 0 0 0 0 0 1 0 0 0zM261.7 160L172.4 305.7c-18.1 29.6-47.5 50.5-81.4 58.1l-35.4 7.9C23.1 378.9 0 407.7 0 441c0 39.2 31.8 71 71 71h32.1c141.1 0 269.1-68.1 348.9-176.2L444 319.6C367.6 427.6 241.9 496 103.2 496H71c-30.4 0-55-24.6-55-55c0-25.8 17.9-48.1 43.1-53.7l35.4-7.9c38.1-8.5 71.1-32 91.5-65.3L280.4 160H261.7z"],
    "citrus-slice": [512, 512, [], "e2f5", "M421.7 2.3c-3.1-3.1-8.2-3.1-11.3 0l-408 408c-3.1 3.1-3.1 8.2 0 11.3l3.5 3.5c55.6 55.6 131 86.8 209.7 86.8C379.3 512 512 379.3 512 215.5c0-78.6-31.2-154.1-86.8-209.7l-3.5-3.5zM215.5 496c-73.4 0-143.8-28.7-196.2-80l34.3-34.3C95.5 422.7 152.8 448 216 448c128.1 0 232-103.9 232-232c0-63.2-25.3-120.5-66.3-162.4L416 19.3c51.3 52.4 80 122.8 80 196.2C496 370.4 370.4 496 215.5 496zM431.4 200c.4 5.3 .6 10.6 .6 16c0 56.8-21.9 108.4-57.7 147L269.9 258.6C281.2 244.8 288 227.2 288 208c0-2.7-.1-5.4-.4-8H431.4zm-1.8-16H284.3c-2.5-8-6.2-15.4-10.9-22.1l97-97c31.1 31.7 52.4 73 59.3 119.1zm-171 85.9L363 374.3C324.4 410.1 272.8 432 216 432c-5.4 0-10.7-.2-16-.6V287.6c2.6 .3 5.3 .4 8 .4c19.2 0 36.8-6.8 50.6-18.1zM184 429.6c-46-6.8-87.3-28.2-119.1-59.3l97-97c6.7 4.7 14.1 8.4 22.1 10.9V429.6zM208 272c-12.7 0-24.6-3.7-34.6-10.1l88.4-88.4c6.4 10 10.1 21.8 10.1 34.6c0 35.3-28.7 64-64 64z"],
    "sheep": [640, 512, [128017], "f711", "M560 132c0-46.4-37.6-84-84-84s-84 37.6-84 84v76c0 44.2 35.8 80 80 80h8c44.2 0 80-35.8 80-80V132zM384.6 91.4C400.2 56.4 435.2 32 476 32s75.8 24.4 91.4 59.4L618.3 126c8.6 5.8 13.7 15.5 13.7 25.9c0 24-26 39.1-46.8 27.2l-9.2-5.3V208c0 53-43 96-96 96h-8c-53 0-96-43-96-96V173.8l-9.2 5.3C346 191 320 175.9 320 151.9c0-10.4 5.1-20 13.7-25.9l50.9-34.7zM576 132v23.4l17.1 9.8c10.2 5.8 22.9-1.5 22.9-13.3c0-5.1-2.5-9.8-6.7-12.6l-34.6-23.6c.9 5.3 1.3 10.8 1.3 16.3zM377.3 115.7l-34.6 23.6c-4.2 2.8-6.7 7.6-6.7 12.6c0 11.7 12.7 19.1 22.9 13.3l17.1-9.8V132c0-5.6 .5-11 1.3-16.3zM448 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM416 360c18.3 0 34.1-10.2 42.2-25.2c5.6 .8 11.3 1.2 17.1 1.2c-8.7 21.6-28.9 37.3-52.9 39.7L397.6 481.2c-4.3 18.1-20.4 30.8-38.9 30.8H344c-22.1 0-40-17.9-40-40V448c0-4.4 3.6-8 8-8s8 3.6 8 8v24c0 13.3 10.7 24 24 24h14.7c11.1 0 20.8-7.7 23.4-18.5l23.4-99.4C397.6 404.6 373.1 424 344 424c-15 0-28.9-5.2-39.8-13.9c-11.7 13.4-29 21.9-48.2 21.9s-36.5-8.5-48.2-21.9C196.9 418.8 183 424 168 424c-29.1 0-53.6-19.4-61.4-45.9L130 477.5c2.6 10.8 12.2 18.5 23.4 18.5H168c13.3 0 24-10.7 24-24V448c0-4.4 3.6-8 8-8s8 3.6 8 8v24c0 22.1-17.9 40-40 40H153.3c-18.6 0-34.7-12.8-38.9-30.8L89.6 375.7C57.3 372.5 32 345.2 32 312c0-5.3 .7-10.5 1.9-15.5C13.7 285.7 0 264.5 0 240s13.7-45.7 33.9-56.5c-1.2-5-1.9-10.2-1.9-15.5c0-35.3 28.7-64 64-64c3.3 0 6.6 .3 9.8 .8C112.7 76.8 137.9 56 168 56c15 0 28.9 5.2 39.8 13.9C219.5 56.5 236.8 48 256 48s36.5 8.5 48.2 21.9C315.1 61.2 329 56 344 56c7.6 0 14.8 1.3 21.5 3.7c-3 4.5-5.7 9.3-8.1 14.2c-4.3-1.2-8.8-1.9-13.4-1.9c-11.3 0-21.7 3.9-29.8 10.4c-6.7 5.3-16.4 4.4-22-2C283.3 70.3 270.4 64 256 64s-27.3 6.3-36.1 16.4c-5.6 6.4-15.3 7.3-22 2C189.7 75.9 179.3 72 168 72c-22.5 0-41.5 15.6-46.6 36.5c-2 8.1-9.8 13.3-18 12c-2.4-.4-4.9-.6-7.4-.6c-26.5 0-48 21.5-48 48c0 4 .5 7.9 1.4 11.6c1.8 7.1-1.5 14.5-8 18C26.3 205.7 16 221.7 16 240s10.3 34.3 25.4 42.4c6.5 3.5 9.8 10.9 8 18C48.5 304.1 48 308 48 312c0 26.5 21.5 48 48 48c2.5 0 5-.2 7.4-.6c8.2-1.3 16 4 18 12c5.1 21 24.1 36.6 46.6 36.6c11.3 0 21.7-3.9 29.8-10.4c6.7-5.3 16.4-4.4 22 2c8.8 10.1 21.7 16.4 36.1 16.4s27.3-6.3 36.1-16.4c5.6-6.4 15.3-7.3 22-2c8.2 6.5 18.5 10.4 29.8 10.4c22.5 0 41.5-15.6 46.6-36.6c2-8.1 9.8-13.3 18-12c2.4 .4 4.9 .6 7.4 .6z"],
    "unlock": [448, 512, [128275], "f09c", "M112 128c0-61.9 50.1-112 112-112c51.5 0 94.9 34.8 108 82.1c1.2 4.3 5.6 6.8 9.8 5.6s6.8-5.6 5.6-9.8C332.5 39.8 282.9 0 224 0C153.3 0 96 57.3 96 128v64H64c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V256c0-35.3-28.7-64-64-64H112V128zM96 208h16H384c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V256c0-26.5 21.5-48 48-48H96z"],
    "colon-sign": [384, 512, [], "e140", "M247.8 9.8c1-4.3-1.7-8.6-6-9.6s-8.6 1.7-9.6 6l-13.1 58C115 69.8 32 153.3 32 256c0 73.8 42.8 137.6 105.5 169.8l-17.3 76.5c-1 4.3 1.7 8.6 6 9.6s8.6-1.7 9.6-6l16.5-73.1c18.8 7.8 39.1 12.8 60.3 14.6l-12.4 55c-1 4.3 1.7 8.6 6 9.6s8.6-1.7 9.6-6l13-57.8c.4 0 .8 0 1.1 0c44.5 0 85.6-14.2 118.7-38.3c3.6-2.6 4.4-7.6 1.8-11.2s-7.6-4.4-11.2-1.8c-29.8 21.7-66.7 34.7-106.8 35.3L308.1 97c11.1 5.1 21.5 11.2 31.2 18.3c3.6 2.6 8.6 1.8 11.2-1.8s1.8-8.6-1.8-11.2c-11.4-8.3-23.8-15.5-37-21.3L327.8 9.8c1-4.3-1.7-8.6-6-9.6s-8.6 1.7-9.6 6L296.6 75.2c-19.2-6.6-39.7-10.5-61.1-11.1L247.8 9.8zM215.4 80.6L141.1 409.6C85.5 379.5 48 321.9 48 256c0-92.2 73.5-168.3 167.4-175.4zM155.9 416.8L231.9 80c21.5 .2 42.1 4 61.1 10.9L216.2 431.5c-21.3-1.5-41.6-6.6-60.3-14.7z"],
    "headset": [512, 512, [], "f590", "M16 256C16 123.5 123.5 16 256 16s240 107.5 240 240V400.1c0 30.9-25.1 56-56 56L319.3 456c-3.8-22.7-23.6-40-47.3-40H240c-26.5 0-48 21.5-48 48s21.5 48 48 48h32c23.8 0 43.5-17.3 47.3-40l120.6 .1c39.8 0 72-32.2 72-72V256C512 114.6 397.4 0 256 0S0 114.6 0 256v56c0 4.4 3.6 8 8 8s8-3.6 8-8V256zm144-32V352c0 8.8-7.2 16-16 16c-35.3 0-64-28.7-64-64V272c0-35.3 28.7-64 64-64c8.8 0 16 7.2 16 16zM64 272v32c0 44.2 35.8 80 80 80c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32c-44.2 0-80 35.8-80 80zm288-48c0-8.8 7.2-16 16-16c35.3 0 64 28.7 64 64v32c0 35.3-28.7 64-64 64c-8.8 0-16-7.2-16-16V224zm96 48c0-44.2-35.8-80-80-80c-17.7 0-32 14.3-32 32V352c0 17.7 14.3 32 32 32c44.2 0 80-35.8 80-80V272zM304 464c0 17.7-14.3 32-32 32H240c-17.7 0-32-14.3-32-32s14.3-32 32-32h32c17.7 0 32 14.3 32 32z"],
    "badger-honey": [640, 512, [129441], "f6b4", "M395.9 95c-22.1 11.1-46.9 17-71.7 17H124c-6.8 0-13.5 .6-20 1.8v14C104 189.8 154.2 240 216.1 240c19.5 0 38.7-5.1 55.6-14.8L353 178.8C392.9 156 438 144 484 144H610.3c-3.3-3.3-7.1-6.2-11.4-8.5L524.9 96.3C504.6 85.6 482 80 459.1 80c-21.8 0-43.7 5.2-63.2 15zM88 118.1C46.1 133 16 173 16 220c0 1.1 0 2.1 0 3.1c0 .3 0 .6 0 .9v57 39c0 4.4-3.6 8-8 8s-8-3.6-8-8V224c0-.3 0-.5 0-.8c0-1.1 0-2.1 0-3.2C0 151.5 55.5 96 124 96H324.2c22.3 0 44.6-5.3 64.5-15.3c21.7-10.9 46-16.7 70.3-16.7c25.5 0 50.7 6.2 73.3 18.2l74.1 39.2c20.7 10.9 33.6 32.5 33.6 55.9c0 16.6-6.6 32.6-18.3 44.4c-11.8 11.8-27.6 17.9-43.5 19.4c-6.5 .6-13 1.4-19.5 2.5c.9 1.3 1.4 2.8 1.4 4.5v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V248c0-.6 .1-1.2 .2-1.8c-57.3 12.3-111.2 40.8-146.6 66.9l20 120.3c4.1 24.4-14.7 46.6-39.5 46.6H347.1c-19.6 0-36.2-14.1-39.5-33.4L290.6 344H197.3l-17.3 40.5c-2.2 5.2-2.5 11-.9 16.3l8.3 27.7C195 454.2 175.8 480 149 480H119.8c-17.7 0-33.2-11.6-38.3-28.5L68.4 407.8c-3.1-10.3-3.1-21.2-.2-31.5l11.6-40.4c-18.4-7-34.7-18.4-47.7-32.7V276.6c13.5 22 34.7 38.7 59.9 46.5c4.1 1.3 6.5 5.7 5.3 9.8L83.6 380.7c-2.1 7.4-2 15.2 .1 22.5l13.1 43.7c3 10.2 12.4 17.1 23 17.1H149c16.1 0 27.6-15.5 23-30.9l-8.3-27.7c-2.7-9-2.1-18.6 1.5-27.3l19.4-45.3c1.3-2.9 4.2-4.8 7.4-4.8H297.3c3.9 0 7.2 2.8 7.9 6.7l18.2 109.3c1.9 11.6 11.9 20.1 23.7 20.1h31.1c14.8 0 26.1-13.3 23.7-27.9L381.1 311c-.5-2.9 .7-5.9 3-7.7c43.4-33.2 117.1-71.4 192.6-78.2c13-1.2 25-6.1 33.7-14.7c8.7-8.7 13.7-20.7 13.7-33.1c0-6-1.1-11.9-3.3-17.3H509.9c1.4 2.4 2.1 5.1 2.1 8c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-2.9 .8-5.6 2.1-8c-42.5 .3-84.3 11.6-121.2 32.7l-81.3 46.4c-19.4 11.1-41.3 16.9-63.6 16.9C145.4 256 88 198.6 88 127.9v-9.8z"],
    "h4": [640, 512, [], "f86a", "M433.5 64.1c-4.3-.8-8.5 2-9.4 6.3l-40 208c-.5 2.3 .2 4.8 1.7 6.6s3.8 2.9 6.2 2.9H624V440c0 4.4 3.6 8 8 8s8-3.6 8-8V72c0-4.4-3.6-8-8-8s-8 3.6-8 8V272H401.7L439.9 73.5c.8-4.3-2-8.5-6.3-9.4zM16 72c0-4.4-3.6-8-8-8s-8 3.6-8 8V248 440c0 4.4 3.6 8 8 8s8-3.6 8-8V256H304V440c0 4.4 3.6 8 8 8s8-3.6 8-8V248 72c0-4.4-3.6-8-8-8s-8 3.6-8 8V240H16V72z"],
    "store-slash": [640, 512, [], "e071", "M499 489.1c-8 4.4-17.2 6.9-27 6.9H168c-30.9 0-56-25.1-56-56V376 264 223.2l.2 0c4 .5 8.1 .8 12.1 .8c11.2 0 21.8-2.1 31.5-5.8l-15.2-12c-5.2 1.2-10.7 1.9-16.3 1.9c-3.3 0-6.7-.2-10-.7c-30.7-4.1-50.8-32.1-50.4-61.8L49 133.8c-5.7 35.5 13 72.4 47 85.3V264 376v64c0 39.8 32.2 72 72 72H472c15 0 28.9-4.6 40.4-12.4L499 489.1zM141.6 0c-7.4 0-14.5 2.9-19.7 7.9L134.8 18c2-1.3 4.3-2 6.8-2H498.4c4.3 0 8.2 2.2 10.4 5.6l0 .1 57.3 90.7 0 0c24.2 38.3 1.8 89.3-40.7 95c-3.3 .4-6.6 .7-10 .7c-21.3 0-40.2-9.3-53.3-23.7c-3-3.3-7.3-5.2-11.9-5.2s-8.8 1.9-11.8 5.3c-13 14.4-31.9 23.7-53.3 23.7c-3.6 0-7.2-.3-10.7-.8L395 223.5c16.4-1.8 31.3-8.2 43.5-17.6c4.3-3.3 8.2-6.9 11.8-10.9c3.6 3.9 7.5 7.6 11.8 10.8c14.7 11.3 33.2 18.1 53.4 18.1c4.1 0 8.1-.3 12.1-.8l.5-.1V264v64.5l16 12.6V264 219.1c43.9-16.7 62.2-73.3 35.6-115.3L522.3 13.1C517.2 5 508.1 0 498.4 0H141.6zM184 368c-4.4 0-8-3.6-8-8V256c0-4.4-3.6-8-8-8s-8 3.6-8 8V360c0 13.3 10.7 24 24 24H365.9l-20.3-16H184zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "road-circle-xmark": [640, 512, [], "e566", "M217.4 32C194 32 173 46.6 164.9 68.6L40.4 404.6C26.9 441.1 54 480 93 480H360.2c-4.2-5.1-8.1-10.4-11.8-16H328V420.6c-2-6.5-3.7-13.2-5-20c-.9-.4-1.9-.6-3-.6c-4.4 0-8 3.6-8 8v56H93c-27.9 0-47.2-27.8-37.5-53.9l124.4-336C185.7 58.4 200.7 48 217.4 48H312v56c0 4.4 3.6 8 8 8s8-3.6 8-8V48h94.6c16.7 0 31.7 10.4 37.5 26.1l43.7 118.1c6 .3 11.9 .8 17.7 1.7L475.1 68.6C467 46.6 446 32 422.6 32H217.4zM328 200c0-4.4-3.6-8-8-8s-8 3.6-8 8V312c0 4.4 3.6 8 8 8s8-3.6 8-8V200zm40 168a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-132.7 0l50.3-50.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L496 356.7l-50.3-50.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L484.7 368l-50.3 50.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L496 379.3l50.3 50.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L507.3 368z"],
    "signal-slash": [640, 512, [], "f695", "M584 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V360.1l16 12.6V8zM440 504c0 4.4 3.6 8 8 8s8-3.6 8-8V455.1l-16-12.6V504zm16-400c0-4.4-3.6-8-8-8s-8 3.6-8 8V259l16 12.6V104zM312 341.4V504c0 4.4 3.6 8 8 8s8-3.6 8-8V354l-16-12.6zM192 288c-4.4 0-8 3.6-8 8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V296c0-4.4-3.6-8-8-8zM64 384c-4.4 0-8 3.6-8 8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V392c0-4.4-3.6-8-8-8zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "user-minus": [640, 512, [], "f503", "M112 128a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM16 482.3C16 392.7 88.7 320 178.3 320h91.4C359.3 320 432 392.7 432 482.3c0 7.6-6.1 13.7-13.7 13.7H29.7c-7.6 0-13.7-6.1-13.7-13.7zM224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3zM432 200c-4.4 0-8 3.6-8 8s3.6 8 8 8H624c4.4 0 8-3.6 8-8s-3.6-8-8-8H432z"],
    "mars-stroke-up": [320, 512, [9896, "mars-stroke-v"], "f22a", "M165.7 2.3c-3.1-3.1-8.2-3.1-11.3 0l-64 64c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L152 27.3V128H96c-4.4 0-8 3.6-8 8s3.6 8 8 8h56v48.2C67.4 196.4 0 266.3 0 352c0 88.4 71.6 160 160 160s160-71.6 160-160c0-85.7-67.4-155.6-152-159.8V144h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H168V27.3l50.3 50.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-64-64zM160 496a144 144 0 1 1 0-288 144 144 0 1 1 0 288z"],
    "champagne-glasses": [640, 512, [129346, "glass-cheers"], "f79f", "M344 40.5c3.5 4.2 6.4 8.9 8.5 13.9L455.3 17c7.3-2.6 15.4 .3 19.3 7L522 105.1 341.6 170.7l-9.5 55.4 2.6 15c12.9 75.6 88.9 122.1 161.3 100.6L543 470.6l-71.3 25.9c-4.2 1.5-6.3 6.1-4.8 10.3s6.1 6.3 10.3 4.8l78.8-28.7 78.8-28.7c4.2-1.5 6.3-6.1 4.8-10.3s-6.1-6.3-10.3-4.8L558 465.1 511.1 336.3c69.2-30.1 97.6-114.6 58.9-180.8L488.4 15.9c-7.8-13.4-24-19.2-38.6-13.9L344 40.5zM556.2 163.6c35 59.9 7.2 136.9-58 160.7s-136-17.4-147.7-85.8l-8.7-50.8 188.4-68.6 26 44.5zm-472.4 0l26-44.5 188.4 68.6-8.7 50.8C277.8 306.8 207 348 141.8 324.2s-93-100.7-58-160.7zm217.1 8.1L118 105.1l47.4-81.1c3.9-6.7 12-9.6 19.3-7L306.4 61.3c7.3 2.6 11.6 10.1 10.3 17.7l-15.8 92.6zm4.4 69.5L332.5 81.7c2.6-15.2-6.1-30.2-20.6-35.5L190.2 1.9c-14.5-5.3-30.8 .6-38.6 13.9L70 155.5c-38.7 66.2-10.3 150.7 58.9 180.8L82 465.1 10.7 439.2c-4.2-1.5-8.7 .6-10.3 4.8s.6 8.7 4.8 10.3l78.8 28.7 78.8 28.7c4.2 1.5 8.7-.6 10.3-4.8s-.6-8.7-4.8-10.3L97 470.6l46.9-128.8c72.4 21.4 148.4-25 161.3-100.6z"],
    "taco": [512, 512, [127790], "f826", "M265 51.1l44.1 34.2 9.8-12.6-9.8 12.6c8.6 6.6 19.2 10.1 30 9.7l55.8-1.7c6.7-.2 12.6 4.1 14.5 10.5l15.6 53.6c3 10.4 9.6 19.4 18.5 25.5l46.1 31.4c5.5 3.8 7.8 10.8 5.5 17c-1.5 4.3-3.8 9.3-6.6 15.5l0 0-.1 .2c-2.7 6-5.8 12.9-8.4 20c4.1 5.1 8 10.3 11.8 15.6c2.7-10 7.3-20.3 11.5-29.7c2.6-5.8 5.1-11.3 6.8-16.2c4.7-13.1 0-27.8-11.6-35.7l-46.1-31.4c-5.9-4-10.2-9.9-12.2-16.8L424.7 99.3c-3.9-13.4-16.4-22.5-30.4-22.1L338.6 79c-7.1 .2-14.1-2-19.7-6.4L274.8 38.4c-11-8.6-26.5-8.6-37.5 0L193.1 72.6c-5.6 4.4-12.6 6.6-19.7 6.4l-55.8-1.7c-14-.4-26.5 8.6-30.4 22.1L71.7 152.9c-2 6.8-6.3 12.8-12.2 16.8L13.4 201C1.9 208.9-2.9 223.6 1.8 236.7C3.6 241.6 6 247.1 8.7 253c4.2 9.4 8.8 19.6 11.5 29.7c3.7-5.3 7.7-10.5 11.8-15.6c-2.6-7.1-5.7-14-8.4-20l-.1-.2c-2.8-6.2-5-11.2-6.6-15.5c-2.3-6.3 0-13.3 5.5-17l46.1-31.4c9-6.1 15.5-15.1 18.5-25.5l15.6-53.6c1.9-6.4 7.8-10.7 14.5-10.5L172.9 95c10.8 .3 21.4-3.1 30-9.7L247 51.1c5.3-4.1 12.7-4.1 17.9 0zM256 208c132.5 0 240 107.5 240 240c0 8.8-7.2 16-16 16H32c-8.8 0-16-7.2-16-16c0-132.5 107.5-240 240-240zM32 480H480c17.7 0 32-14.3 32-32c0-141.4-114.6-256-256-256S0 306.6 0 448c0 17.7 14.3 32 32 32zm80-96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "hexagon-plus": [512, 512, ["plus-hexagon"], "f300", "M400.8 450.8l0 0L497.1 284c2.5-4.3 4.4-8.9 5.6-13.6c2-7.7 2.4-15.7 1.1-23.6c-1.1-6.5-3.3-12.9-6.7-18.8L400.8 61.2c-10-17.3-28.5-28-48.5-28H159.7c-20 0-38.5 10.7-48.5 28L14.9 228c-3.9 6.7-6.3 14.1-7.1 21.6c-1.4 11.8 1 23.9 7.1 34.4l96.3 166.8c10 17.3 28.5 28 48.5 28H352.3c20 0 38.5-10.7 48.5-28zM483.2 236c2.7 4.6 4.4 9.7 5 14.8l-2.7 20.4c-.7 1.6-1.4 3.2-2.3 4.8L386.9 442.8c-7.1 12.4-20.4 20-34.6 20H159.7c-14.3 0-27.5-7.6-34.6-20L28.8 276c-3.6-6.2-5.4-13.1-5.4-20c0-3.4 .4-6.8 1.3-10.1c.9-3.4 2.2-6.8 4.1-9.9L125.1 69.2c7.1-12.4 20.4-20 34.6-20l192.6 0c14.3 0 27.5 7.6 34.6 20L483.2 236zM248 352c0 4.4 3.6 8 8 8s8-3.6 8-8V264h88c4.4 0 8-3.6 8-8s-3.6-8-8-8H264V160c0-4.4-3.6-8-8-8s-8 3.6-8 8v88H160c-4.4 0-8 3.6-8 8s3.6 8 8 8h88v88z"],
    "clipboard": [384, 512, [128203], "f328", "M120.4 64c4-36 34.5-64 71.6-64s67.6 28 71.6 64H272c20.9 0 38.7 13.4 45.3 32H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160c0-35.3 28.7-64 64-64h2.7C73.3 77.4 91.1 64 112 64h8.4zM64 112c-26.5 0-48 21.5-48 48V448c0 26.5 21.5 48 48 48H320c26.5 0 48-21.5 48-48V160c0-26.5-21.5-48-48-48v16c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V112zM192 16c-30.9 0-56 25.1-56 56c0 4.4-3.6 8-8 8H112c-17.7 0-32 14.3-32 32v16c0 8.8 7.2 16 16 16H288c8.8 0 16-7.2 16-16V112c0-17.7-14.3-32-32-32H256c-4.4 0-8-3.6-8-8c0-30.9-25.1-56-56-56zM176 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "house-circle-exclamation": [640, 512, [], "e50a", "M282.7 2c3-2.7 7.6-2.7 10.6 0l215 190.4c-4.1-.3-8.2-.4-12.3-.4c-4 0-8 .1-11.9 .4L288 18.7 80 202.9V448c0 26.5 21.5 48 48 48h80V328c0-13.3 10.7-24 24-24H332c-2 5.2-3.8 10.6-5.4 16H256 232c-4.4 0-8 3.6-8 8V496h32 96 16 7.2c6.1 5.8 12.7 11.1 19.6 16H128c-35.3 0-64-28.7-64-64V217.1L13.3 262c-3.3 2.9-8.4 2.6-11.3-.7S-.6 252.9 2.7 250L282.7 2zM624 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0-136c4.4 0 8 3.6 8 8v96c0 4.4-3.6 8-8 8s-8-3.6-8-8V288c0-4.4 3.6-8 8-8z"],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", "M16 448V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48zM358.6 157.3c.9 .9 1.7 1.8 2.4 2.7H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64zM200 440V251.3l74.3 74.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-88-88c-3.1-3.1-8.2-3.1-11.3 0l-88 88c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L184 251.3V440c0 4.4 3.6 8 8 8s8-3.6 8-8z"],
    "wifi": [640, 512, ["wifi-3", "wifi-strong"], "f1eb", "M13.8 175.3C92 96.6 200.3 48 320 48s228 48.6 306.2 127.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3C556.4 82.5 444.1 32 320 32S83.6 82.5 2.5 164c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0zM320 208c72.2 0 137.8 28.1 186.5 74c3.2 3 8.3 2.9 11.3-.3s2.9-8.3-.3-11.3C465.9 221.8 396.4 192 320 192s-145.9 29.8-197.5 78.4c-3.2 3-3.4 8.1-.3 11.3s8.1 3.4 11.3 .3c48.7-45.9 114.3-74 186.5-74zm0 160a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 112a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "messages": [640, 512, ["comments-alt"], "f4b6", "M202.7 304H352c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H64C37.5 16 16 37.5 16 64V256c0 26.5 21.5 48 48 48H96c8.8 0 16 7.2 16 16v48l81.1-60.8c2.8-2.1 6.1-3.2 9.6-3.2zM352 320H202.7l-81.1 60.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3V336 320H80 64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H352c35.3 0 64 28.7 64 64V256c0 35.3-28.7 64-64 64zM320 448c-35.3 0-64-28.7-64-64V352h16v32c0 26.5 21.5 48 48 48H437.3c3.5 0 6.8 1.1 9.6 3.2L528 496V448c0-8.8 7.2-16 16-16h32c26.5 0 48-21.5 48-48V192c0-26.5-21.5-48-48-48H448V128H576c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H560 544v16 32c0 6.1-3.4 11.6-8.8 14.3s-11.9 2.1-16.8-1.5L437.3 448H320z"],
    "bath": [512, 512, [128705, "bathtub"], "f2cd", "M85.3 16C64.7 16 48 32.7 48 53.3V272H464h16 24c4.4 0 8 3.6 8 8s-3.6 8-8 8H480 464 48 32 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32V53.3C32 23.8 55.8 0 85.3 0c14.1 0 27.7 5.6 37.7 15.6l32.1 32.1C167.4 37.9 183 32 200 32c23.1 0 43.7 10.9 56.9 27.8l1.5-1.5c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-104 104c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l1.5-1.5C138.9 147.7 128 127.1 128 104c0-17 5.9-32.6 15.7-44.9L111.6 26.9c-7-7-16.5-10.9-26.3-10.9zM32 320H48v48c0 53 43 96 96 96H368c53 0 96-43 96-96V320h16v48c0 38.1-19 71.7-48 91.9V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V469.2c-14.5 6.9-30.8 10.8-48 10.8H144c-17.2 0-33.5-3.9-48-10.8V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V459.9C51 439.7 32 406.1 32 368V320zM200 48c-30.9 0-56 25.1-56 56c0 18.7 9.2 35.3 23.3 45.4l78.2-78.2C235.3 57.2 218.7 48 200 48z"],
    "umbrella-simple": [512, 512, ["umbrella-alt"], "e2bc", "M264 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V32.1C121.1 36 17.4 132.3 2 256.1C-.2 273.6 14.3 288 32 288H480c17.7 0 32.2-14.4 30-31.9C494.6 132.3 390.9 36 264 32.1V8zm0 454.2V320H248V462.2c0 18.7-15.2 33.8-33.8 33.8c-14.6 0-27.5-9.3-32.1-23.1l-6.5-19.4c-1.4-4.2-5.9-6.5-10.1-5.1s-6.5 5.9-5.1 10.1l6.5 19.4c6.8 20.4 25.8 34.1 47.3 34.1c27.5 0 49.8-22.3 49.8-49.8zM17.9 258C32.6 139.6 133.6 48 256 48s223.4 91.6 238.1 210c.8 6.7-4.7 14-14.2 14H32c-9.4 0-15-7.3-14.1-14z"],
    "rectangle-history-circle-plus": [640, 512, [], "e4a3", "M448 144c26.5 0 48 21.5 48 48c5.4 0 10.7 .2 16 .7V192c0-35.3-28.7-64-64-64L64 128c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64l330.8 0c-6.9-4.9-13.4-10.2-19.6-16L64 496c-26.5 0-48-21.5-48-48l0-256c0-26.5 21.5-48 48-48l384 0zm8-80L56 64c-4.4 0-8 3.6-8 8s3.6 8 8 8l400 0c4.4 0 8-3.6 8-8s-3.6-8-8-8zM408 0H104c-4.4 0-8 3.6-8 8s3.6 8 8 8l304 0c4.4 0 8-3.6 8-8s-3.6-8-8-8zM368 368a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm272 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM504 296c0-4.4-3.6-8-8-8s-8 3.6-8 8v64H424c-4.4 0-8 3.6-8 8s3.6 8 8 8h64v64c0 4.4 3.6 8 8 8s8-3.6 8-8V376h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H504V296z"],
    "underline": [448, 512, [], "f0cd", "M0 40c0-4.4 3.6-8 8-8H136c4.4 0 8 3.6 8 8s-3.6 8-8 8H80V240c0 79.5 64.5 144 144 144s144-64.5 144-144V48H312c-4.4 0-8-3.6-8-8s3.6-8 8-8H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H384V240c0 88.4-71.6 160-160 160s-160-71.6-160-160V48H8c-4.4 0-8-3.6-8-8zM0 472c0-4.4 3.6-8 8-8H440c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8z"],
    "prescription-bottle-pill": [576, 512, [], "e5c0", "M344 16c13.3 0 24 10.7 24 24V88c0 13.3-10.7 24-24 24H40c-13.3 0-24-10.7-24-24V40c0-13.3 10.7-24 24-24H344zM40 0C17.9 0 0 17.9 0 40V88c0 22.1 17.9 40 40 40H344c22.1 0 40-17.9 40-40V40c0-22.1-17.9-40-40-40H40zM32 408v40c0 35.3 28.7 64 64 64H288c11.6 0 22.4-3.1 31.8-8.4c-4.4-3.6-8.6-7.5-12.6-11.5c-5.9 2.6-12.3 4-19.1 4H96c-26.5 0-48-21.5-48-48V416H152c4.4 0 8-3.6 8-8s-3.6-8-8-8H48V320H152c4.4 0 8-3.6 8-8s-3.6-8-8-8H48V224H152c4.4 0 8-3.6 8-8s-3.6-8-8-8H48V160H32v56 96 96zM352 160H336v60.5c5.2-3.4 10.5-6.5 16-9.3V160zm80 80a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM370.3 306.3c-3.1 3.1-3.1 8.2 0 11.3l112 112c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-112-112c-3.1-3.1-8.2-3.1-11.3 0z"],
    "user-pen": [640, 512, ["user-edit"], "f4ff", "M224 240a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm-45.7 80C88.7 320 16 392.7 16 482.3c0 7.6 6.1 13.7 13.7 13.7h290c0 5.5 1 10.9 2.8 16H29.7C13.3 512 0 498.7 0 482.3C0 383.8 79.8 304 178.3 304h91.4c48 0 91.7 19 123.7 49.9l-11.3 11.3C353 337.2 313.3 320 269.7 320H178.3zM96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM356.7 507.2c-4-4-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9L557.2 235.7c15.6-15.6 40.9-15.6 56.6 0l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6L446.9 487.9c-4.1 4.1-9.2 7-14.9 8.4l-3.4-13.6 3.4 13.6-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2zm15.7-28.9L368 495.8l17.6-4.4 42.5-10.6c2.8-.7 5.4-2.2 7.4-4.2L578.4 333.7l-48.3-48.3L387.2 428.3c-2 2.1-3.5 4.6-4.2 7.4l-10.6 42.5zM616.8 295.4c9.4-9.4 9.4-24.6 0-33.9L602.4 247c-9.4-9.4-24.6-9.4-33.9 0l-27.1 27.1 48.3 48.3 27.1-27.1z"],
    "binary-slash": [640, 512, [], "e33e", "M432 224h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H440V8c0-2.6-1.3-5.1-3.4-6.6s-4.9-1.8-7.4-.9l-64 24c-4.1 1.6-6.2 6.2-4.7 10.3s6.2 6.2 10.3 4.7L424 19.5V208H375.4l20.3 16H432zM304 64c0-35.3-28.7-64-64-64H208c-23.7 0-44.4 12.9-55.5 32.1l12.7 10.1C173.2 26.6 189.4 16 208 16h32c26.5 0 48 21.5 48 48v75l16 12.6V64zm32 384c0 35.3 28.7 64 64 64h32c23.7 0 44.4-12.9 55.5-32.1l-12.7-10.1c-8 15.5-24.1 26.1-42.7 26.1H400c-26.5 0-48-21.5-48-48V373l-16-12.6V448zM216 296c0-2.6-1.3-5.1-3.4-6.6s-4.9-1.8-7.4-.9l-64 24c-4.1 1.6-6.2 6.2-4.7 10.3s6.2 6.2 10.3 4.7L200 307.5V496H136c-4.4 0-8 3.6-8 8s3.6 8 8 8h72 72c4.4 0 8-3.6 8-8s-3.6-8-8-8H216V296zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "square-o": [448, 512, [], "e278", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM112 256a112 112 0 1 0 224 0 112 112 0 1 0 -224 0zM224 384a128 128 0 1 1 0-256 128 128 0 1 1 0 256z"],
    "signature": [640, 512, [], "f5b7", "M144 120c0-39.8 32.2-72 72-72s72 32.2 72 72v15.9c0 26.8-2.1 53.6-6.4 80l-118 34.9c-30.6 9-51.6 37.1-51.6 69V427.1c0 29.2 23.7 52.9 52.9 52.9c19.6 0 37.6-10.8 46.8-28.2l27-51c21.8-41.2 37.9-85 48-130.5l4.8-21.8c1.5-6.7 2.8-13.4 4.1-20.1L454 181.6 385.2 291.8c-1.5 2.5-1.6 5.6-.2 8.1s4.1 4.1 7 4.1H568c4.4 0 8-3.6 8-8s-3.6-8-8-8H406.4l72.3-115.8c1.8-2.8 1.6-6.4-.4-9.1s-5.4-3.8-8.6-2.8L298.6 210.9c3.6-24.8 5.4-49.9 5.4-75V120c0-48.6-39.4-88-88-88s-88 39.4-88 88v40c0 4.4 3.6 8 8 8s8-3.6 8-8V120zm24.1 146.1l110.3-32.6c-.8 3.8-1.6 7.7-2.4 11.5l-4.8 21.8c-9.8 44.1-25.5 86.6-46.6 126.5l-27 51c-6.4 12.1-19 19.7-32.6 19.7c-20.4 0-36.9-16.5-36.9-36.9V319.8c0-24.8 16.3-46.7 40.1-53.7zM8 368c-4.4 0-8 3.6-8 8s3.6 8 8 8H56c4.4 0 8-3.6 8-8s-3.6-8-8-8H8zm320 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H328z"],
    "stroopwafel": [512, 512, [], "f551", "M256 16a240 240 0 1 0 0 480 240 240 0 1 0 0-480zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM131.5 120.2l56.6 56.6 56.6-56.6L210.7 86.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L256 108.9 289.9 75c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-33.9 33.9 56.6 56.6 56.6-56.6c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-56.6 56.6 56.6 56.6 33.9-33.9c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L403.1 256 437 289.9c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-33.9-33.9-56.6 56.6 56.6 56.6c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-56.6-56.6-56.6 56.6 33.9 33.9c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L256 403.1 222.1 437c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l33.9-33.9-56.6-56.6-56.6 56.6c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l56.6-56.6-56.6-56.6L86.3 301.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L108.9 256 75 222.1c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l33.9 33.9 56.6-56.6-56.6-56.6c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0zm0 135.8l56.6 56.6L244.7 256l-56.6-56.6L131.5 256zm67.9 67.9L256 380.5l56.6-56.6L256 267.3l-56.6 56.6zM267.3 256l56.6 56.6L380.5 256l-56.6-56.6L267.3 256zM256 244.7l56.6-56.6L256 131.5l-56.6 56.6L256 244.7z"],
    "bold": [384, 512, [], "f032", "M0 40c0-4.4 3.6-8 8-8H40 72 224c61.9 0 112 50.1 112 112c0 43.1-24.4 80.5-60.1 99.3C328.7 255.8 368 303.3 368 360c0 66.3-53.7 120-120 120H72 40 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32V248 48H8c-4.4 0-8-3.6-8-8zM48 464H72 248c57.4 0 104-46.6 104-104s-46.6-104-104-104H224 48V464zm0-224H224c53 0 96-43 96-96s-43-96-96-96H72 48V240z"],
    "anchor-lock": [640, 512, [], "e4ad", "M352 80A64 64 0 1 1 224 80a64 64 0 1 1 128 0zM288 0c-44.2 0-80 35.8-80 80c0 41.5 31.6 75.6 72 79.6c0 .1 0 .3 0 .4v48H200c-4.4 0-8 3.6-8 8s3.6 8 8 8h80V496h-8C170.4 496 88 413.6 88 312V284.8l58.1 64.5c3 3.3 8 3.6 11.3 .6s3.6-8 .6-11.3l-72-80C84.4 257 82.3 256 80 256s-4.4 1-5.9 2.6l-72 80c-3 3.3-2.7 8.3 .6 11.3s8.3 2.7 11.3-.6L72 284.8V312c0 110.5 89.5 200 200 200h16 16c29.1 0 56.7-6.2 81.7-17.4c-1.1-4.7-1.7-9.6-1.7-14.6v-2.3c-24.2 11.7-51.3 18.3-80 18.3h-8V224h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H296V160c0-.1 0-.3 0-.4c40.4-4 72-38.1 72-79.6c0-44.2-35.8-80-80-80zM528 208c26.5 0 48 21.5 48 48v64H480V256c0-26.5 21.5-48 48-48zm-64 48v64H448c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32H592V256c0-35.3-28.7-64-64-64s-64 28.7-64 64zm-16 80h16 16 96 16 16c8.8 0 16 7.2 16 16V480c0 8.8-7.2 16-16 16H448c-8.8 0-16-7.2-16-16V352c0-8.8 7.2-16 16-16z"],
    "building-ngo": [384, 512, [], "e4d7", "M48 16C30.3 16 16 30.3 16 48V464c0 17.7 14.3 32 32 32h96V416c0-26.5 21.5-48 48-48s48 21.5 48 48v80h96c17.7 0 32-14.3 32-32V48c0-17.7-14.3-32-32-32H48zM224 496V416c0-17.7-14.3-32-32-32s-32 14.3-32 32v80h64zm-80 16H48c-26.5 0-48-21.5-48-48V48C0 21.5 21.5 0 48 0H336c26.5 0 48 21.5 48 48V464c0 26.5-21.5 48-48 48H240 224 160 144zM104 232h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H104c-13.3 0-24-10.7-24-24V256c0-13.3 10.7-24 24-24zm-8 24v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V256c0-4.4-3.6-8-8-8H104c-4.4 0-8 3.6-8 8zm128 0c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H248c-13.3 0-24-10.7-24-24V256zm24-8c-4.4 0-8 3.6-8 8v32c0 4.4 3.6 8 8 8h32c4.4 0 8-3.6 8-8V256c0-4.4-3.6-8-8-8H248zM176 56h40c4.4 0 8 3.6 8 8s-3.6 8-8 8H176v80h32V128c0-4.4 3.6-8 8-8s8 3.6 8 8v24c0 8.8-7.2 16-16 16H176c-8.8 0-16-7.2-16-16V72c0-8.8 7.2-16 16-16zM296 72c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24s24-10.7 24-24V96c0-13.3-10.7-24-24-24zM256 96c0-22.1 17.9-40 40-40s40 17.9 40 40v32c0 22.1-17.9 40-40 40s-40-17.9-40-40V96zM62.7 59.6l49.3 74V64c0-4.4 3.6-8 8-8s8 3.6 8 8v96c0 3.5-2.3 6.6-5.7 7.7s-7-.3-9-3.2L64 90.4V160c0 4.4-3.6 8-8 8s-8-3.6-8-8V64c0-3.5 2.3-6.6 5.7-7.7s7 .3 9 3.2z"],
    "transporter-3": [512, 512, [], "e045", "M464 0c4.4 0 8 3.6 8 8V40h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H472V88c0 4.4-3.6 8-8 8s-8-3.6-8-8V56H424c-4.4 0-8-3.6-8-8s3.6-8 8-8h32V8c0-4.4 3.6-8 8-8zM48 96c4.4 0 8 3.6 8 8v32H88c4.4 0 8 3.6 8 8s-3.6 8-8 8H56v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V152H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H40V104c0-4.4 3.6-8 8-8zm96 368c-17.7 0-32 14.3-32 32v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-26.5 21.5-48 48-48H368c26.5 0 48 21.5 48 48v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-17.7-14.3-32-32-32H144zM288 48c0-17.7-14.3-32-32-32l-.4 0c-.3 0-.6 0-.9 0c-17 .7-30.6 14.8-30.6 32c0 17.7 14.3 32 32 32s32-14.3 32-32zm16 0c0 26.5-21.5 48-48 48h0c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48zM168 384H344c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8s3.6-8 8-8zm-8-56c0-4.4 3.6-8 8-8H344c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8zm-56-72H408c4.4 0 8 3.6 8 8s-3.6 8-8 8H104c-4.4 0-8-3.6-8-8s3.6-8 8-8zm24-56c0-4.4 3.6-8 8-8H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H136c-4.4 0-8-3.6-8-8zm72-72H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H200c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "engine-warning": [640, 512, ["engine-exclamation"], "f5f2", "M408 80c4.4 0 8-3.6 8-8s-3.6-8-8-8H304 200c-4.4 0-8 3.6-8 8s3.6 8 8 8l96 0v48H160 112c-26.5 0-48 21.5-48 48v72H16V168c0-4.4-3.6-8-8-8s-8 3.6-8 8V344c0 4.4 3.6 8 8 8s8-3.6 8-8V264H64v72c0 26.5 21.5 48 48 48h67.2l59 49.2c11.5 9.6 26 14.8 41 14.8H448c35.3 0 64-28.7 64-64V226.3c0-21.4-10.7-41.4-28.5-53.3l-51.4-34.3c-10.5-7-22.9-10.7-35.5-10.7H312V80l96 0zM80 264V248 176c0-17.7 14.3-32 32-32h48H304h92.6c9.5 0 18.7 2.8 26.6 8.1l51.4 34.3c13.4 8.9 21.4 23.9 21.4 39.9V384c0 26.5-21.5 48-48 48H279.2c-11.2 0-22.1-3.9-30.7-11.1l-59-49.2c-2.9-2.4-6.5-3.7-10.2-3.7H112c-17.7 0-32-14.3-32-32V264zM304 368a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-192c-4.4 0-8 3.6-8 8V304c0 4.4 3.6 8 8 8s8-3.6 8-8V184c0-4.4-3.6-8-8-8zm272 32h32c8.8 0 16 7.2 16 16V416c0 8.8-7.2 16-16 16H576c-8.8 0-16-7.2-16-16V224c0-8.8 7.2-16 16-16zm-32 16V416c0 17.7 14.3 32 32 32h32c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H576c-17.7 0-32 14.3-32 32z"],
    "circle-down-right": [512, 512, [], "e108", "M256 496a240 240 0 1 1 0-480 240 240 0 1 1 0 480zM256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zm96 344c0 4.4-3.6 8-8 8H217c-5 0-9-4-9-9c0-2.4 .9-4.7 2.6-6.3l35-35c3.1-3.1 3.1-8.2 0-11.3L163.3 208c-2.1-2.1-3.3-5-3.3-8s1.2-5.9 3.3-8L192 163.3c2.1-2.1 5-3.3 8-3.3s5.9 1.2 8 3.3l82.3 82.3c3.1 3.1 8.2 3.1 11.3 0l35-35c1.7-1.7 4-2.6 6.3-2.6c5 0 9 4 9 9V344zm-8 24c13.3 0 24-10.7 24-24V217c0-13.8-11.2-25-25-25c-6.6 0-13 2.6-17.7 7.3L296 228.7 219.3 152c-5.1-5.1-12.1-8-19.3-8s-14.2 2.9-19.3 8L152 180.7c-5.1 5.1-8 12.1-8 19.3s2.9 14.2 8 19.3L228.7 296l-29.4 29.4c-4.7 4.7-7.3 11-7.3 17.7c0 13.8 11.2 25 25 25H344z"],
    "square-k": [448, 512, [], "e274", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm317.4 45.9L215.2 236.3 318.4 371.1c2.7 3.5 2 8.5-1.5 11.2s-8.5 2-11.2-1.5L203.4 247.2 144 302v74c0 4.4-3.6 8-8 8s-8-3.6-8-8V298.5 136c0-4.4 3.6-8 8-8s8 3.6 8 8V280.2L306.6 130.1c3.2-3 8.3-2.8 11.3 .5s2.8 8.3-.5 11.3z"],
    "manat-sign": [384, 512, [], "e1d5", "M192 32c-4.4 0-8 3.6-8 8V96.2C81.7 100.4 0 184.6 0 288V472c0 4.4 3.6 8 8 8s8-3.6 8-8V288c0-94.5 74.5-171.6 168-175.8V472c0 4.4 3.6 8 8 8s8-3.6 8-8V112.2c93.5 4.2 168 81.3 168 175.8V472c0 4.4 3.6 8 8 8s8-3.6 8-8V288c0-103.4-81.7-187.6-184-191.8V40c0-4.4-3.6-8-8-8z"],
    "money-check-pen": [640, 512, ["money-check-edit"], "f872", "M64 80H512c26.5 0 48 21.5 48 48v68.6c5.2-2 10.6-3.3 16-4V128c0-35.3-28.7-64-64-64H64C28.7 64 0 92.7 0 128V384c0 35.3 28.7 64 64 64H330.5l4-16H64c-26.5 0-48-21.5-48-48V128c0-26.5 21.5-48 48-48zm40 224c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H104zm-8-88c0 4.4 3.6 8 8 8H472c4.4 0 8-3.6 8-8s-3.6-8-8-8H104c-4.4 0-8 3.6-8 8zM356.7 507.2c4 4 9.7 5.6 15.2 4.2l60.1-15-3.4-13.6 3.4 13.6c5.6-1.4 10.8-4.3 14.9-8.4L628.1 306.7c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0L375.9 417c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2zm15.7-28.9L383 435.7c.7-2.8 2.2-5.4 4.2-7.4L530.1 285.4l48.3 48.3L435.6 476.6c-2.1 2.1-4.6 3.5-7.4 4.2l-42.5 10.6L368 495.8l4.4-17.6zM616.8 295.4l-27.1 27.1-48.3-48.3L568.5 247c9.4-9.4 24.6-9.4 33.9 0l14.4 14.4c9.4 9.4 9.4 24.6 0 33.9z"],
    "not-equal": [448, 512, [], "f53e", "M380.6 33.5c3.6 2.5 4.5 7.5 1.9 11.1L301.3 160H424c4.4 0 8 3.6 8 8s-3.6 8-8 8H290.1L177.5 336H424c4.4 0 8 3.6 8 8s-3.6 8-8 8H166.2L78.5 476.6c-2.5 3.6-7.5 4.5-11.1 1.9s-4.5-7.5-1.9-11.1L146.7 352H24c-4.4 0-8-3.6-8-8s3.6-8 8-8H157.9L270.5 176H24c-4.4 0-8-3.6-8-8s3.6-8 8-8H281.8L369.5 35.4c2.5-3.6 7.5-4.5 11.1-1.9z"],
    "border-top-left": [448, 512, ["border-style"], "f853", "M0 456c0 4.4 3.6 8 8 8s8-3.6 8-8L16 88c0-22.1 17.9-40 40-40l368 0c4.4 0 8-3.6 8-8s-3.6-8-8-8L56 32C25.1 32 0 57.1 0 88L0 456zm128-24a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm192 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm-96 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm192-32a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm0-160a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0 64a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm0-160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "map-location-dot": [576, 512, ["map-marked-alt"], "f5a0", "M381.3 161.2c-6.9 16.4-16.6 34.2-27.5 51.9c-21.8 35.4-47.6 69.1-63.5 88.9c-1.3 1.6-3.4 1.6-4.6 0c-15.9-19.8-41.7-53.6-63.5-88.9c-10.9-17.7-20.6-35.5-27.5-51.9c-7-16.7-10.7-30.7-10.7-41.2c0-57.4 46.6-104 104-104s104 46.6 104 104c0 10.5-3.6 24.5-10.7 41.2zM302.8 312C334.9 271.9 408 174.6 408 120C408 53.7 354.3 0 288 0S168 53.7 168 120c0 54.6 73.1 151.9 105.2 192c7.7 9.6 22 9.6 29.6 0zm118.3-122l117.4-42.7c10.4-3.8 21.5 3.9 21.5 15V423.2c0 6.7-4.2 12.7-10.5 15L400 492.6V296c0-4.4-3.6-8-8-8s-8 3.6-8 8V493.2L192 434.1V296c0-4.4-3.6-8-8-8s-8 3.6-8 8V434.4L37.5 484.8C27 488.6 16 480.8 16 469.7V208.8c0-6.7 4.2-12.7 10.5-15l114.2-41.5c-1.4-5.2-2.6-10.5-3.4-15.8L21.1 178.7C8.4 183.3 0 195.4 0 208.8V469.7c0 22.2 22.1 37.7 42.9 30.1l141.3-51.4 205.4 63.2c1.7 .5 3.4 .5 5.1-.1l160.2-58.3c12.6-4.6 21.1-16.6 21.1-30.1V162.3c0-22.2-22.1-37.7-42.9-30.1L429.6 169.8c-1.3 3.4-2.6 6.7-4 10c-1.4 3.3-2.9 6.7-4.5 10.1zM256 112a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "tilde": [448, 512, [63135], "7e", "M91.5 160C49.8 160 16 193.8 16 235.5V320c0 4.4-3.6 8-8 8s-8-3.6-8-8V235.5C0 184.9 40.9 144 91.5 144c25.5 0 49.9 10.7 67.2 29.4L301.1 327.7c14.3 15.5 34.4 24.3 55.4 24.3c41.7 0 75.5-33.8 75.5-75.5V192c0-4.4 3.6-8 8-8s8 3.6 8 8v84.5c0 50.5-40.9 91.5-91.5 91.5c-25.5 0-49.9-10.7-67.2-29.4L146.9 184.3C132.6 168.8 112.5 160 91.5 160z"],
    "jedi": [576, 512, [], "f669", "M288 0c4.4 0 8 3.6 8 8V308.7l42.9-42.9c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L307.3 320H368c4.4 0 8 3.6 8 8s-3.6 8-8 8H307.3l42.9 42.9c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L296 347.3v84.4c58.1-4.1 104-52.6 104-111.7c0-37.3-18.2-70.4-46.3-90.7c-2.2-1.6-3.5-4.3-3.3-7.1s1.8-5.2 4.3-6.5C400.6 191.6 432 143.5 432 88c0-26.8-7.3-51.8-20-73.2c-1.8-3.1-1.4-7.1 1.2-9.7s6.5-3.1 9.7-1.3C504.8 50.6 560 138.8 560 240c0 150.2-121.8 272-272 272S16 390.2 16 240C16 138.8 71.2 50.6 153.1 3.7c3.2-1.8 7.1-1.3 9.7 1.3s3 6.6 1.2 9.7C151.3 36.2 144 61.2 144 88c0 55.5 31.4 103.6 77.4 127.7c2.5 1.3 4.1 3.7 4.3 6.5s-1 5.4-3.3 7.1C194.2 249.6 176 282.7 176 320c0 59.2 45.9 107.6 104 111.7V347.3l-42.9 42.9c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L268.7 336H208c-4.4 0-8-3.6-8-8s3.6-8 8-8h60.7l-42.9-42.9c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L280 308.7V8c0-4.4 3.6-8 8-8zM160 320c0-38.3 16.8-72.7 43.5-96.1C158.2 195.6 128 145.3 128 88c0-19.5 3.5-38.1 9.8-55.4C101 59.4 71.6 95.7 53.2 137.9l.5 .5 80 80c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L46.8 154.1c-6.8 19-11.4 39.1-13.5 59.9l4.4 4.4 64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L32 235.4c0 1.5 0 3.1 0 4.6c0 141.4 114.6 256 256 256s256-114.6 256-256c0-1.6 0-3.1 0-4.6l-58.3 58.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l64-64 4.4-4.4c-2.1-20.8-6.7-40.9-13.5-59.9l-75.6 75.6c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l80-80 .5-.5C504.4 95.7 475 59.4 438.2 32.6C444.5 49.9 448 68.5 448 88c0 57.3-30.2 107.6-75.5 135.9C399.2 247.3 416 281.7 416 320c0 70.7-57.3 128-128 128s-128-57.3-128-128z"],
    "square-poll-vertical": [448, 512, ["poll"], "f681", "M64 48C37.5 48 16 69.5 16 96l0 320c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L64 48zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM128 368c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16zm96 0c8.8 0 16-7.2 16-16l0-192c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 192c0 8.8 7.2 16 16 16zm96 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16zM96 352l0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32zm96 0l0-192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32zm96 0l0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32z"],
    "arrow-down-square-triangle": [576, 512, ["sort-shapes-down-alt"], "f889", "M165.7 477.7l104-104c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L168 452.7V40c0-4.4-3.6-8-8-8s-8 3.6-8 8V452.7L61.7 362.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l104 104c3.1 3.1 8.2 3.1 11.3 0zM440.2 301.7c-5.1-8.5-14.3-13.7-24.2-13.7s-19.1 5.2-24.2 13.7L307.6 442c-2.3 3.9-3.6 8.4-3.6 12.9c0 13.8 11.2 25.1 25.1 25.1H502.9c13.8 0 25.1-11.2 25.1-25.1c0-4.5-1.2-9-3.6-12.9L440.2 301.7zM405.5 310c2.2-3.7 6.2-6 10.5-6s8.3 2.3 10.5 6l84.2 140.3c.8 1.4 1.3 3 1.3 4.7c0 5-4.1 9.1-9.1 9.1H329.1c-5 0-9.1-4.1-9.1-9.1c0-1.6 .4-3.3 1.3-4.7L405.5 310zM336 176V80c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32H368c-17.7 0-32-14.3-32-32zm-16 0c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48H368c-26.5 0-48 21.5-48 48v96z"],
    "mug-hot": [512, 512, [9749], "f7b6", "M80 8c0-4.4-3.6-8-8-8s-8 3.6-8 8c0 27.3 5.1 45.2 13.6 57.9C86 78.4 97.1 85 106.7 90.6l.4 .3c9.9 5.9 18.2 10.9 24.4 20.1c6.2 9.2 10.9 23.5 10.9 49c0 4.4 3.6 8 8 8s8-3.6 8-8c0-27.3-5.1-45.2-13.6-57.9c-8.4-12.5-19.5-19.1-29.1-24.7l-.4-.3C105.4 71.2 97.1 66.2 90.9 57C84.7 47.8 80 33.5 80 8zM209.6 8c0-4.4-3.6-8-8-8s-8 3.6-8 8c0 27.3 5.1 45.2 13.6 57.9c8.4 12.5 19.5 19.1 29.1 24.7l.4 .3c9.9 5.9 18.2 10.9 24.4 20.1c6.2 9.2 10.9 23.5 10.9 49c0 4.4 3.6 8 8 8s8-3.6 8-8c0-27.3-5.1-45.2-13.6-57.9C266 89.6 254.9 83 245.3 77.4l-.4-.3C235 71.2 226.7 66.2 220.5 57c-6.2-9.2-10.9-23.5-10.9-49zM344 208h24V416c0 44.2-35.8 80-80 80H96c-44.2 0-80-35.8-80-80V224c0-8.8 7.2-16 16-16H344zm40 176V208h24c48.6 0 88 39.4 88 88s-39.4 88-88 88H384zm0 32V400h24c57.4 0 104-46.6 104-104s-46.6-104-104-104H384 368 344 32c-17.7 0-32 14.3-32 32V416c0 53 43 96 96 96H288c53 0 96-43 96-96z"],
    "dog-leashed": [576, 512, [129454], "f6d4", "M65.6 3.2C68.3-.4 73.3-1 76.8 1.6L306.7 176h8l26-156.2 15.8 2.6-26 156.2c-.1 .7-.3 1.3-.4 1.9l88.4 51.6 7.1-42.8c1.3-7.7 8-13.4 15.8-13.4H464h40c30.9 0 56-25.1 56-56V96c0-8.8-7.2-16-16-16H496c-4.2 0-8.3-1.7-11.3-4.7L466.7 57.4c-6-6-14.1-9.4-22.6-9.4H400c-5 0-9.8-2.4-12.8-6.4L370.3 19.1l12.5-9.4-12.5 9.4c-1.5-2-3.8-3.1-6.2-3.1c-3.8 0-7 2.7-7.7 6.5l-15.8-2.6C342.6 8.4 352.5 0 364.1 0c7.5 0 14.5 3.5 19 9.5L400 32h44.1c12.7 0 24.9 5.1 33.9 14.1L496 64h48c17.7 0 32 14.3 32 32v24c0 39.8-32.2 72-72 72H464 441.3L432 248V464c0 26.5-21.5 48-48 48H368c-26.5 0-48-21.5-48-48V386.6 369.4c-5.2 2.2-10.6 4.2-16 5.9c-17.7 5.6-36.5 8.7-56 8.7s-38.3-3-56-8.7c-5.4-1.7-10.8-3.7-16-5.9v17.3V464c0 26.5-21.5 48-48 48H112c-26.5 0-48-21.5-48-48V233.8c-28.8-10.9-51.4-35.3-59.2-66.5L1 151.8c-4.3-17.1 6.1-34.5 23.3-38.8s34.5 6.1 38.8 23.3l3.9 15.5C70.5 166 83.3 176 98 176h46 8H280.2L67.2 14.4C63.6 11.7 63 6.7 65.6 3.2zM412 246.9l-94.5-55.1c-.9 .2-1.8 .2-2.8 .2H288V363.2c8.9-2.2 17.5-5 25.7-8.6c4.9-2.1 10.6-1.6 15.1 1.4s7.2 8 7.2 13.3V464c0 17.7 14.3 32 32 32h16c17.7 0 32-14.3 32-32V249.3l-4-2.4zM272 192H152h-8H98c-22 0-41.2-15-46.6-36.4l-3.9-15.5c-2.1-8.6-10.8-13.8-19.4-11.6s-13.8 10.8-11.6 19.4l3.9 15.5c6.5 26 25.3 46.3 49.3 55.4c6.2 2.4 10.3 8.3 10.3 15V464c0 17.7 14.3 32 32 32h16c17.7 0 32-14.3 32-32V369.4c0-5.4 2.7-10.4 7.2-13.3s10.1-3.5 15.1-1.4c20.2 8.6 42.4 13.3 65.7 13.3c8.2 0 16.2-.6 24-1.7V192zM444 80a12 12 0 1 1 0 24 12 12 0 1 1 0-24z"],
    "car-battery": [512, 512, ["battery-car"], "f5df", "M168 80c4.4 0 8 3.6 8 8v40H80V88c0-4.4 3.6-8 8-8h80zm24 48V88c0-13.3-10.7-24-24-24H88C74.7 64 64 74.7 64 88v40c-35.3 0-64 28.7-64 64V384c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V192c0-35.3-28.7-64-64-64V88c0-13.3-10.7-24-24-24H344c-13.3 0-24 10.7-24 24v40H192zm144 0V88c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v40H336zm-16 16h16 96 16c26.5 0 48 21.5 48 48V384c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V192c0-26.5 21.5-48 48-48H80h96 16H320zm48 72c-4.4 0-8 3.6-8 8v40H320c-4.4 0-8 3.6-8 8s3.6 8 8 8h40v40c0 4.4 3.6 8 8 8s8-3.6 8-8V280h40c4.4 0 8-3.6 8-8s-3.6-8-8-8H376V224c0-4.4-3.6-8-8-8zM96 264c-4.4 0-8 3.6-8 8s3.6 8 8 8h96c4.4 0 8-3.6 8-8s-3.6-8-8-8H96z"],
    "face-downcast-sweat": [512, 512, [], "e371", "M93.3 60c5.6 8.9 10.5 17.5 13.9 25.1c3.6 8 4.8 13.3 4.8 16.2c0 22.4-20.2 42.7-48 42.7s-48-20.4-48-42.7c0-2.8 1.2-8.1 4.8-16.1c3.4-7.6 8.3-16.2 13.9-25.1C44.4 44.8 55.6 29.8 64 19.1C72.4 29.7 83.7 44.8 93.3 60zM72.5 4.1c-4.3-5.5-12.8-5.5-17.1 0C38.1 25.8 0 76.3 0 101.3C0 133.8 28.7 160 64 160s64-26.2 64-58.7c0-25-37.9-75.5-55.5-97.2zM256 16c132.5 0 240 107.5 240 240s-107.5 240-240 240S16 388.6 16 256c0-22.2 3-43.6 8.6-64c1.2-4.3-1.3-8.7-5.6-9.8s-8.7 1.3-9.8 5.6C3.2 209.5 0 232.4 0 256C0 397.4 114.6 512 256 512s256-114.6 256-256S397.4 0 256 0c-43.1 0-83.8 10.7-119.5 29.5c-3.9 2.1-5.4 6.9-3.3 10.8s6.9 5.4 10.8 3.3C177.4 26 215.5 16 256 16zM178.6 413.9c3.3 3 8.3 2.7 11.3-.6C202.7 399.1 224.7 384 256 384s53.3 15.1 66.1 29.4c3 3.3 8 3.5 11.3 .6s3.6-8 .6-11.3C318.9 386 292.9 368 256 368s-62.9 18-77.9 34.6c-3 3.3-2.7 8.3 .6 11.3zM400 272H304c-4.4 0-8 3.6-8 8s3.6 8 8 8h96c4.4 0 8-3.6 8-8s-3.6-8-8-8zm-184 8c0-4.4-3.6-8-8-8H112c-4.4 0-8 3.6-8 8s3.6 8 8 8h96c4.4 0 8-3.6 8-8z"],
    "mailbox-flag-up": [576, 512, [], "e5bb", "M352 200V104 56c0-13.3 10.7-24 24-24h64c13.3 0 24 10.7 24 24V88c0 13.3-10.7 24-24 24H368v88c0 4.4-3.6 8-8 8s-8-3.6-8-8zM440 96c4.4 0 8-3.6 8-8V56c0-4.4-3.6-8-8-8l-64 0c-4.4 0-8 3.6-8 8V96l72 0zM560 208c0-47.7-26-89.2-64.7-111.3c.4-2.8 .7-5.8 .7-8.7V79c47.4 23.6 80 72.5 80 129V384c0 35.3-28.7 64-64 64H224 64c-35.3 0-64-28.7-64-64V208C0 128.5 64.5 64 144 64H320V80H210c46.3 23.9 78 72.3 78 128V384c0 19.1-8.4 36.3-21.7 48H512c26.5 0 48-21.5 48-48V208zM224 432c26.5 0 48-21.5 48-48V208c0-70.7-57.3-128-128-128S16 137.3 16 208V384c0 26.5 21.5 48 48 48H224zM64 200c0-4.4 3.6-8 8-8H216c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-4.4 0-8-3.6-8-8z"],
    "memo-circle-info": [576, 512, [], "e49a", "M320 16H64C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48H311.2c5.8 5.5 12 10.6 18.5 15.3c-3.2 .5-6.4 .7-9.7 .7H64c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0H320c35.3 0 64 28.7 64 64V198.6c-5.4 1.5-10.8 3.3-16 5.4V64c0-26.5-21.5-48-48-48zM64 136c0-4.4 3.6-8 8-8H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-4.4 0-8-3.6-8-8zm8 88H280c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-4.4 0-8-3.6-8-8s3.6-8 8-8zm0 96H216c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-4.4 0-8-3.6-8-8s3.6-8 8-8zm488 48a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-48a16 16 0 1 1 0-32 16 16 0 1 1 0 32zM408 440c0-4.4 3.6-8 8-8h8V360h-8c-4.4 0-8-3.6-8-8s3.6-8 8-8h16c4.4 0 8 3.6 8 8v80h8c4.4 0 8 3.6 8 8s-3.6 8-8 8H432 416c-4.4 0-8-3.6-8-8z"],
    "gift": [512, 512, [127873], "f06b", "M373.1 16c-20.3 0-39.2 10.5-50 27.7L270.4 128H296h80c30.9 0 56-25.1 56-56s-25.1-56-56-56h-2.9zM241.6 128L188.9 43.7C178.1 26.5 159.2 16 138.9 16H136c-30.9 0-56 25.1-56 56s25.1 56 56 56h80 25.6zm14.4-7.1l53.6-85.7C323.3 13.3 347.3 0 373.1 0H376c39.8 0 72 32.2 72 72c0 22.6-10.4 42.8-26.7 56H464c26.5 0 48 21.5 48 48v32c0 20.9-13.4 38.7-32 45.3V256 448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V256v-2.7C13.4 246.7 0 228.9 0 208V176c0-26.5 21.5-48 48-48H90.7C74.4 114.8 64 94.6 64 72C64 32.2 96.2 0 136 0h2.9c25.8 0 49.8 13.3 63.5 35.2L256 120.9zM136 144H48c-17.7 0-32 14.3-32 32v32c0 17.7 14.3 32 32 32H248V144H216 136zm128 0v96H464c17.7 0 32-14.3 32-32V176c0-17.7-14.3-32-32-32H376 296 264zM248 256H48V448c0 26.5 21.5 48 48 48H248V256zm16 240H416c26.5 0 48-21.5 48-48V256H264V496z"],
    "dice-two": [448, 512, [9857], "f528", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM320 336a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM112 160a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "volume": [576, 512, [128265, "volume-medium"], "f6a8", "M322.2 48c-3.4 0-6.6 1.2-9.2 3.5L175.2 174c-1.5 1.3-3.4 2-5.3 2H88c-22.1 0-40 17.9-40 40v80c0 22.1 17.9 40 40 40h81.9c2 0 3.9 .7 5.3 2L313 460.5c2.5 2.2 5.8 3.5 9.2 3.5c7.6 0 13.8-6.2 13.8-13.8V61.8c0-7.6-6.2-13.8-13.8-13.8zm-19.8-8.5c5.5-4.8 12.5-7.5 19.8-7.5C338.7 32 352 45.3 352 61.8V450.2c0 16.5-13.3 29.8-29.8 29.8c-7.3 0-14.3-2.7-19.8-7.5L166.9 352H88c-30.9 0-56-25.1-56-56V216c0-30.9 25.1-56 56-56h78.9L302.4 39.5zM430.5 180.8c2.7-3.5 7.7-4.2 11.2-1.6C464.9 196.8 480 224.6 480 256s-15.1 59.2-38.3 76.7c-3.5 2.7-8.5 1.9-11.2-1.6s-1.9-8.5 1.6-11.2c19.4-14.6 31.9-37.8 31.9-64s-12.5-49.4-31.9-64c-3.5-2.7-4.2-7.7-1.6-11.2zm70.4-77.2C546.5 138.7 576 193.9 576 256s-29.5 117.3-75.1 152.3c-3.5 2.7-8.5 2-11.2-1.5s-2-8.5 1.5-11.2C533 363.5 560 312.9 560 256s-27-107.5-68.9-139.7c-3.5-2.7-4.2-7.7-1.5-11.2s7.7-4.2 11.2-1.5z"],
    "transporter-5": [512, 512, [], "e2a6", "M464 0c4.4 0 8 3.6 8 8V40h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H472V88c0 4.4-3.6 8-8 8s-8-3.6-8-8V56H424c-4.4 0-8-3.6-8-8s3.6-8 8-8h32V8c0-4.4 3.6-8 8-8zM48 128c4.4 0 8 3.6 8 8v32H88c4.4 0 8 3.6 8 8s-3.6 8-8 8H56v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V184H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H40V136c0-4.4 3.6-8 8-8zm96 336c-17.7 0-32 14.3-32 32v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-26.5 21.5-48 48-48H368c26.5 0 48 21.5 48 48v8c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8c0-17.7-14.3-32-32-32H144zm24-80H344c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8s3.6-8 8-8zm-8-56c0-4.4 3.6-8 8-8H344c4.4 0 8 3.6 8 8s-3.6 8-8 8H168c-4.4 0-8-3.6-8-8zm-56-72H408c4.4 0 8 3.6 8 8s-3.6 8-8 8H104c-4.4 0-8-3.6-8-8s3.6-8 8-8zm24-56c0-4.4 3.6-8 8-8H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H136c-4.4 0-8-3.6-8-8zm72-72H312c4.4 0 8 3.6 8 8s-3.6 8-8 8H200c-4.4 0-8-3.6-8-8s3.6-8 8-8zM224 8c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8s-3.6 8-8 8H232c-4.4 0-8-3.6-8-8zm0 56h64c4.4 0 8 3.6 8 8s-3.6 8-8 8H224c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "gauge-circle-bolt": [640, 512, [], "e496", "M256 496c35.6 0 69.4-7.7 99.8-21.6c3.3 4.4 6.9 8.6 10.6 12.7C333 503 295.5 512 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0C375.4 0 475.6 81.7 504 192.2c-2.6-.1-5.3-.2-8-.2c-2.9 0-5.7 .1-8.6 .2C459.5 90.6 366.5 16 256 16C123.5 16 16 123.5 16 256s107.5 240 240 240zm0-96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0 16c-35.3 0-64-28.7-64-64c0-32.6 24.4-59.6 56-63.5V80c0-4.4 3.6-8 8-8s8 3.6 8 8V288.5c31.6 3.9 56 30.9 56 63.5c0 35.3-28.7 64-64 64zM144 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM80 240a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM352 128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM496 496a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-272a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm36.5 57.4c3 2 4.3 5.8 3.1 9.2L517.8 344H576c3.3 0 6.3 2.1 7.5 5.2s.2 6.7-2.3 8.8l-112 96c-2.7 2.3-6.7 2.6-9.7 .6s-4.3-5.8-3.1-9.2L474.2 392H416c-3.3 0-6.3-2.1-7.5-5.2s-.2-6.7 2.3-8.8l112-96c2.7-2.3 6.7-2.6 9.7-.6zM437.6 376h47.7c2.6 0 5 1.2 6.5 3.3s1.9 4.8 1.1 7.2l-12.2 36.6L554.4 360H506.7c-2.6 0-5-1.2-6.5-3.3s-1.9-4.8-1.1-7.2l12.2-36.6L437.6 376z"],
    "coin-front": [512, 512, [], "e3fc", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-432a176 176 0 1 1 0 352 176 176 0 1 1 0-352zm0 368a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm8-280c0-4.4-3.6-8-8-8s-8 3.6-8 8V344c0 4.4 3.6 8 8 8s8-3.6 8-8V168z"],
    "file-slash": [640, 512, [], "e3a7", "M512 179.9c0-12.7-5.1-24.9-14.1-33.9L366.1 14.1c-9-9-21.2-14.1-33.9-14.1H192c-20.1 0-38.1 9.3-49.8 23.9l12.6 9.9C163.5 22.9 176.9 16 192 16H332.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H495.8c.2 1.3 .2 2.6 .2 3.9V303.2l16 12.6v-136zM144 448V208.8l-16-12.6V448c0 35.3 28.7 64 64 64H448c20.1 0 38.1-9.3 49.8-23.9l-12.6-9.9C476.5 489.1 463.1 496 448 496H192c-26.5 0-48-21.5-48-48zM489.1 160H376c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L486.6 157.3c.9 .9 1.7 1.8 2.4 2.7zM13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7z"],
    "message-arrow-up-right": [512, 512, [], "e1dd", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM200 120c-4.4 0-8 3.6-8 8s3.6 8 8 8H308.7L170.3 274.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L320 147.3V256c0 4.4 3.6 8 8 8s8-3.6 8-8V128c0-4.4-3.6-8-8-8H200z"],
    "treasure-chest": [576, 512, [], "f723", "M136 48V272h80V224c0-26.5 21.5-48 48-48h48c26.5 0 48 21.5 48 48v48h80V48H136zM312 368H264c-26.5 0-48-21.5-48-48V288H136V464H440V288H360v32c0 26.5-21.5 48-48 48zM120 48.3C61.9 52.4 16 100.8 16 160V272H120V48.3zM16 288V432c0 17.7 14.3 32 32 32h72V288H16zM456 464h72c17.7 0 32-14.3 32-32V288H456V464zM560 272V160c0-59.2-45.9-107.6-104-111.7V272H560zM0 160C0 89.3 57.3 32 128 32H448c70.7 0 128 57.3 128 128V432c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V160zm312 32H264c-17.7 0-32 14.3-32 32v96c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32zm-16 48v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V240c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "chess-queen": [512, 512, [9819], "f445", "M256 16a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm0 96A56 56 0 1 0 256 0a56 56 0 1 0 0 112zm-95.2 8c-10 0-17.7 7.1-20.3 15.6c-10 32.7-40.5 56.5-76.5 56.5c-14.2 0-27.5-3.7-39.1-10.2c-4.4-2.4-9.9-2.8-14.6-.2c-7.3 3.9-10 12.9-6.1 20.2L101.3 384h18.1L20 197.4c13.2 6.8 28.2 10.7 44 10.7c43.2 0 79.7-28.5 91.8-67.8c.9-2.9 3.1-4.3 5-4.3c1.6 0 3.4 1 4.5 2.9C183.1 170.6 217.1 192 256 192s72.9-21.4 90.7-53.1c1.1-2 2.9-2.9 4.5-2.9c1.9 0 4.2 1.4 5 4.3c12.1 39.2 48.6 67.8 91.8 67.8c15.9 0 30.8-3.9 44-10.7L392.5 384h18.1l97.1-182.1c3.9-7.3 1.1-16.3-6.1-20.2c-4.8-2.5-10.3-2.2-14.6 .2c-11.5 6.5-24.9 10.2-39.1 10.2c-36 0-66.4-23.8-76.5-56.5c-2.6-8.5-10.3-15.6-20.3-15.6c-8.1 0-14.8 4.7-18.4 11.1C317.6 157.9 288.9 176 256 176s-61.6-18.1-76.7-44.9c-3.6-6.4-10.4-11.1-18.4-11.1zM126.3 432H385.7c4.5 0 8.9 1.9 11.9 5.3l30.6 33.9c2.5 2.7 3.8 6.3 3.8 9.9c0 8.2-6.6 14.8-14.8 14.8H94.8c-8.2 0-14.8-6.6-14.8-14.8c0-3.7 1.4-7.2 3.8-9.9l30.6-33.9c3-3.4 7.4-5.3 11.9-5.3zm313.8 28.5l-30.6-33.9c-6.1-6.7-14.7-10.6-23.8-10.6H126.3c-9.1 0-17.7 3.8-23.8 10.6L71.9 460.5c-5.1 5.7-7.9 13-7.9 20.6c0 17 13.8 30.8 30.8 30.8H417.2c17 0 30.8-13.8 30.8-30.8c0-7.6-2.8-15-7.9-20.6z"],
    "paintbrush-fine": [576, 512, ["paint-brush-alt", "paint-brush-fine", "paintbrush-alt"], "f5a9", "M548.2 27.7c-15.6-15.6-40.9-15.6-56.6 0L297.3 222l56.6 56.6L548.2 84.3c15.6-15.6 15.6-40.9 0-56.6zM286 233.3l-26.3 26.3 0 0L205.3 314l56.6 56.6 2.3-2.3 0 0 52.1-52.1 26.3-26.3L286 233.3zm-94 90c-7.6-2.2-15.7-3.3-24-3.3c-48.6 0-88 39.4-88 88c0 1.4 0 2.9 .1 4.3c.6 12.3-3.3 24.7-10.6 34.3C62.2 456.3 50.5 464 36 464H32c-8.8 0-16 7.2-16 16s7.2 16 16 16H168h5c.6-.1 1.3-.2 1.9-.3c45.4-3.5 81.1-41.5 81.1-87.7c0-8.3-1.2-16.4-3.3-24L192 323.3zM559.5 95.6L269.6 385.5c1.6 7.2 2.4 14.7 2.4 22.5c0 54.7-42.2 99.5-95.9 103.7c-.1 0-.1 .1-.1 .2s-.1 .2-.2 .2H168 32c-17.7 0-32-14.3-32-32s14.3-32 32-32h4c17.1 0 29-17.8 28.2-35c-.1-1.7-.1-3.4-.1-5c0-57.4 46.6-104 104-104c7.7 0 15.1 .8 22.3 2.4l290-290c21.9-21.9 57.3-21.9 79.2 0s21.9 57.3 0 79.2z"],
    "glasses": [576, 512, [], "f530", "M70.8 77.7c4.4-17.5 20-29.7 38-29.7c6.1 0 12.1 1.4 17.5 4.1l22 11c4 2 8.8 .4 10.7-3.6s.4-8.8-3.6-10.7l-22-11C125.9 34 117.4 32 108.9 32C83.5 32 61.4 49.2 55.3 73.8L6 271.1C3 282.9 1.2 294.9 .4 306.9c-.3 1.7-.4 3.4-.4 5.1v7.6V336v32c0 61.9 50.1 112 112 112h44.3c59.4 0 108.5-46.4 111.8-105.8l3.8-60.4c.2-3.3-.2-6.6-1-9.8h34c-.8 3.1-1.2 6.4-1 9.8l3.8 60.4C311.1 433.6 360.2 480 419.7 480H464c61.9 0 112-50.1 112-112V336 319.6 312c0-1.7-.1-3.4-.4-5.1c-.8-12.1-2.6-24-5.6-35.8L520.7 73.8C514.6 49.2 492.5 32 467.1 32c-8.6 0-17 2-24.7 5.8l-22 11c-4 2-5.6 6.8-3.6 10.7s6.8 5.6 10.7 3.6l22-11c5.4-2.7 11.4-4.1 17.5-4.1c18 0 33.7 12.2 38 29.7L554.5 275c.6 2.4 1.2 4.9 1.7 7.3C520.6 265.2 479.5 256 440.3 256c-40.1 0-82.2 9.6-118.5 27.3c-2.7 1.4-5.2 3.1-7.4 5.1c-.8-.2-1.6-.4-2.4-.4H264c-.8 0-1.7 .1-2.4 .4c-2.2-2-4.7-3.7-7.4-5.1C217.9 265.6 175.8 256 135.7 256c-39.1 0-80.3 9.2-115.9 26.3c.5-2.5 1.1-4.9 1.7-7.3L70.8 77.7zM16 319.6c0-3.6 .1-7.2 .3-10.8c1-4.7 4-8.9 8.5-11.1C58.5 281 98.1 272 135.7 272c37.7 0 77.4 9 111.4 25.7c5.7 2.9 9.2 8.9 8.9 15.2l-3.8 60.4 0 0 0 .1c-2.8 50.9-44.9 90.7-95.9 90.7H112c-53 0-96-43-96-96V336 319.6zm535.2-21.9c4.4 2.2 7.5 6.4 8.5 11.1c.2 3.6 .3 7.2 .3 10.8V336v32c0 53-43 96-96 96H419.7c-51 0-93-39.8-95.9-90.7l0-.1 0 0L320 312.8c-.3-6.3 3.2-12.3 8.9-15.2c34-16.6 73.7-25.7 111.4-25.7c37.5 0 77.2 9 110.9 25.7z"],
    "hood-cloak": [576, 512, [], "f6ef", "M20.6 468.8l0 0 .2-.2 .2-.2 0 0 .1-.1C65.9 420.5 80 346.7 80 288V256C80 123.5 187.5 16 320 16H432c3.3 0 6.3 2 7.5 5.1c1 2.5 .6 5.4-1 7.6c-3.4 4.7-8.1 9.3-14.1 14.4c-1.9 1.6-4.1 3.4-6.5 5.4l0 0c-4.2 3.4-8.7 7.2-12.5 10.6c-3.3 3-5.3 7.4-5.2 11.9s1.9 8.8 5.3 11.9C452.2 124.7 496 190.3 496 288c0 58.6 14 132.4 59 180.3l0 0 .1 .1 .3 .3 0 0 0 0c4.5 4.6 5.8 11.4 3.4 17.3c-2.5 6-8.3 9.9-14.8 9.9H416V320c0-70.7-57.3-128-128-128s-128 57.3-128 128V496H32c-6.5 0-12.3-3.9-14.8-9.9c-2.5-5.9-1.1-12.8 3.4-17.4zM176 496V320c0-61.9 50.1-112 112-112s112 50.1 112 112V496H176zm397.6-3.8c4.9-11.9 2.2-25.6-6.8-34.7l0 0-.1-.1C525.8 413.8 512 345 512 288c0-94.9-39.4-161.6-84.2-206.2c-3.9-3.8-7.7-7.5-11.7-11c3.5-3.2 7.4-6.3 11.3-9.5l1.1-.9c8.4-6.9 17-14 23-22.4c4.7-6.5 5.9-15 2.9-22.7C450.8 6.1 441.9 0 432 0H320C178.6 0 64 114.6 64 256v32c0 57.1-13.9 125.9-54.6 169.4l-.2 .2c-9 9.1-11.7 22.8-6.8 34.7c5 12 16.6 19.8 29.6 19.8H544c12.9 0 24.6-7.8 29.6-19.8z"],
    "square-quote": [448, 512, [], "e329", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm80 224c-17.7 0-32-14.3-32-32V208c0-17.7 14.3-32 32-32h16c17.7 0 32 14.3 32 32v8 8c0 17.7-14.3 32-32 32H144zm64-40v-8c0-26.5-21.5-48-48-48H144c-26.5 0-48 21.5-48 48v16c0 26.5 21.5 48 48 48h16c12.3 0 23.5-4.6 32-12.2v26.6c0 19.9-14.6 36.8-34.3 39.6l-14.8 2.1c-4.4 .6-7.4 4.7-6.8 9s4.7 7.4 9.1 6.8l14.8-2.1c27.6-3.9 48.1-27.6 48.1-55.4V224v-8zm80 40c-17.7 0-32-14.3-32-32V208c0-17.7 14.3-32 32-32h16c17.7 0 32 14.3 32 32v8 8c0 17.7-14.3 32-32 32H288zm64-40v-8c0-26.5-21.5-48-48-48H288c-26.5 0-48 21.5-48 48v16c0 26.5 21.5 48 48 48h16c12.3 0 23.5-4.6 32-12.2v26.6c0 19.9-14.6 36.8-34.3 39.6l-14.8 2.1c-4.4 .6-7.4 4.7-6.8 9s4.7 7.4 9.1 6.8l14.8-2.1c27.6-3.9 48.1-27.6 48.1-55.4V224v-8z"],
    "up-left": [384, 512, [], "e2bd", "M48 96c-8.8 0-16 7.2-16 16V347.7c0 11.2 9.1 20.3 20.3 20.3c5.4 0 10.5-2.1 14.3-5.9l75.7-75.7c3.1-3.1 8.2-3.1 11.3 0L290.3 423c5.7 5.7 13.5 9 21.7 9s15.9-3.2 21.7-9L359 397.6c5.7-5.7 9-13.5 9-21.7s-3.2-15.9-9-21.7L222.3 217.7c-1.5-1.5-2.3-3.5-2.3-5.7s.8-4.2 2.3-5.7l75.7-75.7c3.8-3.8 5.9-9 5.9-14.3c0-11.2-9.1-20.3-20.3-20.3H48zM16 112c0-17.7 14.3-32 32-32H283.7c20 0 36.3 16.2 36.3 36.3c0 9.6-3.8 18.9-10.6 25.7L239.3 212l131 131c8.7 8.7 13.7 20.6 13.7 33s-4.9 24.2-13.7 33L345 434.3c-8.7 8.7-20.6 13.7-33 13.7s-24.2-4.9-33-13.7l-131-131L77.9 373.4c-6.8 6.8-16 10.6-25.7 10.6c-20 0-36.3-16.2-36.3-36.3V112z"],
    "bring-front": [640, 512, [], "f857", "M64 16H192c26.5 0 48 21.5 48 48h16c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64V192c0 35.3 28.7 64 64 64h64V240H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48zM448 512H576c35.3 0 64-28.7 64-64V320c0-35.3-28.7-64-64-64H512v16h64c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H448c-26.5 0-48-21.5-48-48H384c0 35.3 28.7 64 64 64zM416 112c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H224c-26.5 0-48-21.5-48-48V160c0-26.5 21.5-48 48-48H416zM224 96c-35.3 0-64 28.7-64 64V352c0 35.3 28.7 64 64 64H416c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H224zm32 80H384c8.8 0 16 7.2 16 16V320c0 8.8-7.2 16-16 16H256c-8.8 0-16-7.2-16-16V192c0-8.8 7.2-16 16-16zm-32 16V320c0 17.7 14.3 32 32 32H384c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32H256c-17.7 0-32 14.3-32 32z"],
    "chess-board": [448, 512, [], "f43c", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm80-8h48 64 64 64 48c13.3 0 24 10.7 24 24v48 64 64 64 48c0 13.3-10.7 24-24 24H320 256 192 128 80c-13.3 0-24-10.7-24-24V352 288 224 160 112c0-13.3 10.7-24 24-24zm-8 24v40h48V104H80c-4.4 0-8 3.6-8 8zm64 40h48V104H136v48zm64 0h48V104H200v48zm64 0h48V104H264v48zm64 0h48V112c0-4.4-3.6-8-8-8H328v48zm0 16v48h48V168H328zm0 64v48h48V232H328zm0 64v48h48V296H328zm0 64v48h40c4.4 0 8-3.6 8-8V360H328zm-16 0H264v48h48V360zm-64 0H200v48h48V360zm-64 0H136v48h48V360zm-64 0H72v40c0 4.4 3.6 8 8 8h40V360zm0-16V296H72v48h48zm0-64V232H72v48h48zm0-64V168H72v48h48zm16 0h48V168H136v48zm64 0h48V168H200v48zm64 0h48V168H264v48zm0 16v48h48V232H264zm0 64v48h48V296H264zm-16 0H200v48h48V296zm-64 0H136v48h48V296zm0-16V232H136v48h48zm16 0h48V232H200v48z"],
    "burger-cheese": [512, 512, [127828, "cheeseburger"], "f7f1", "M450.9 208H61.1c-7.2 0-13.1-5.9-13.1-13.1c0-1 .1-1.4 .2-1.7c2.3-9.2 13-45.7 43.6-79.7C121.9 80 172.1 48 256 48s134.1 32 164.3 65.5c30.6 34 41.3 70.5 43.6 79.7c.1 .3 .2 .7 .2 1.7c0 7.2-5.9 13.1-13.1 13.1zM61.1 224H450.9c16.1 0 29.1-13 29.1-29.1c0-1.9-.2-3.7-.6-5.6C474.1 168.3 433.2 32 256 32S37.9 168.3 32.6 189.3c-.5 1.9-.6 3.7-.6 5.6C32 211 45 224 61.1 224zM59.4 400H452.6c6.3 0 11.4 5.1 11.4 11.4c0 29-23.5 52.6-52.6 52.6H100.6c-29 0-52.6-23.5-52.6-52.6c0-6.3 5.1-11.4 11.4-11.4zm0-16C44.3 384 32 396.3 32 411.4c0 37.9 30.7 68.6 68.6 68.6H411.4c37.9 0 68.6-30.7 68.6-68.6c0-15.1-12.3-27.4-27.4-27.4H59.4zM144 144a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm240-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM256 112a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm46.2 215.4c10.7 7.2 24.8 7.2 35.5 0L414.8 276c3.9-2.6 8.5-4 13.2-4H432h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H370.4l-24 16H448c26.5 0 48-21.5 48-48s-21.5-48-48-48H432h-3.9H211.9 208 192 64c-26.5 0-48 21.5-48 48s21.5 48 48 48H293.6l-24-16H64c-17.7 0-32-14.3-32-32s14.3-32 32-32H192h16 3.9c4.7 0 9.3 1.4 13.2 4l77.1 51.4zM392 272l-63.1 42.1c-5.4 3.6-12.4 3.6-17.8 0L248 272H392z"],
    "building-circle-check": [640, 512, [], "e4d2", "M48 16H336c17.7 0 32 14.3 32 32V247.2c5-5.3 10.4-10.3 16-15V48c0-26.5-21.5-48-48-48H48C21.5 0 0 21.5 0 48V464c0 26.5 21.5 48 48 48h96 16 64 16 96c15.1 0 28.5-6.9 37.3-17.8c-3.9-3.8-7.6-7.7-11.1-11.8c-5.8 8.2-15.4 13.6-26.2 13.6H240V416c0-26.5-21.5-48-48-48s-48 21.5-48 48v80H48c-17.7 0-32-14.3-32-32V48c0-17.7 14.3-32 32-32zM224 496H160V416c0-17.7 14.3-32 32-32s32 14.3 32 32v80zM104 232c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H104zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V256zm128 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V256c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V256c0-4.4 3.6-8 8-8zM104 104c-13.3 0-24 10.7-24 24v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H104zm-8 24c0-4.4 3.6-8 8-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H104c-4.4 0-8-3.6-8-8V128zm128 0v32c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24V128c0-13.3-10.7-24-24-24H248c-13.3 0-24 10.7-24 24zm24-8h32c4.4 0 8 3.6 8 8v32c0 4.4-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V128c0-4.4 3.6-8 8-8zM496 240a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm69.7-189.7c-3.1-3.1-8.2-3.1-11.3 0L480 396.7l-42.3-42.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l48 48c3.1 3.1 8.2 3.1 11.3 0l80-80c3.1-3.1 3.1-8.2 0-11.3z"],
    "repeat-1": [512, 512, [128258], "f365", "M355.3 172.7c-2.1 2.1-5 3.3-8 3.3c-6.2 0-11.3-5.1-11.3-11.3V96l0-68.7c0-6.2 5.1-11.3 11.3-11.3c3 0 5.9 1.2 8 3.3L432 96l-76.7 76.7zM320 104v60.7c0 15.1 12.2 27.3 27.3 27.3c7.2 0 14.2-2.9 19.3-8l76.7-76.7c3-3 4.7-7.1 4.7-11.3s-1.7-8.3-4.7-11.3L366.6 8c-5.1-5.1-12.1-8-19.3-8C332.2 0 320 12.2 320 27.3V88H168C75.2 88 0 163.2 0 256v8c0 4.4 3.6 8 8 8s8-3.6 8-8v-8c0-83.9 68.1-152 152-152H320zM156.7 339.3c2.1-2.1 5-3.3 8-3.3c6.2 0 11.3 5.1 11.3 11.3V416l0 68.7c0 6.2-5.1 11.3-11.3 11.3c-3 0-5.9-1.2-8-3.3L80 416l76.7-76.7zM192 408V347.3c0-15.1-12.2-27.3-27.3-27.3c-7.2 0-14.2 2.9-19.3 8L68.7 404.7c-3 3-4.7 7.1-4.7 11.3s1.7 8.3 4.7 11.3L145.4 504c5.1 5.1 12.1 8 19.3 8c15.1 0 27.3-12.2 27.3-27.3V424H344c92.8 0 168-75.2 168-168v-8c0-4.4-3.6-8-8-8s-8 3.6-8 8v8c0 83.9-68.1 152-152 152H192zm88-208c0-2.9-1.6-5.5-4.1-7s-5.6-1.4-8.1 .1l-40 24c-3.8 2.3-5 7.2-2.7 11s7.2 5 11 2.7L264 214.1V312c0 4.4 3.6 8 8 8s8-3.6 8-8V200z"],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", "M8 480c-4.4 0-8-3.6-8-8s3.6-8 8-8H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H8zm189.7-98.3c-3.1 3.1-8.2 3.1-11.3 0l-136-136c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L184 356.7V40c0-4.4 3.6-8 8-8s8 3.6 8 8V356.7L322.3 234.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3l-136 136z"],
    "grid-5": [448, 512, [], "e199", "M48 44.8c1.8 0 3.2 1.4 3.2 3.2V80c0 1.8-1.4 3.2-3.2 3.2H16c-1.8 0-3.2-1.4-3.2-3.2V48c0-1.8 1.4-3.2 3.2-3.2H48zM16 32C7.2 32 0 39.2 0 48V80c0 8.8 7.2 16 16 16H48c8.8 0 16-7.2 16-16V48c0-8.8-7.2-16-16-16H16zM48 140.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H16c-1.8 0-3.2-1.4-3.2-3.2V144c0-1.8 1.4-3.2 3.2-3.2H48zM16 128c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16H48c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H16zm0 108.8H48c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H16c-1.8 0-3.2-1.4-3.2-3.2V240c0-1.8 1.4-3.2 3.2-3.2zM0 240v32c0 8.8 7.2 16 16 16H48c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H16c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H16c-1.8 0-3.2-1.4-3.2-3.2V336c0-1.8 1.4-3.2 3.2-3.2H48zM16 320c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16H48c8.8 0 16-7.2 16-16V336c0-8.8-7.2-16-16-16H16zm0 108.8H48c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H16c-1.8 0-3.2-1.4-3.2-3.2V432c0-1.8 1.4-3.2 3.2-3.2zM0 432v32c0 8.8 7.2 16 16 16H48c8.8 0 16-7.2 16-16V432c0-8.8-7.2-16-16-16H16c-8.8 0-16 7.2-16 16zM144 44.8c1.8 0 3.2 1.4 3.2 3.2V80c0 1.8-1.4 3.2-3.2 3.2H112c-1.8 0-3.2-1.4-3.2-3.2V48c0-1.8 1.4-3.2 3.2-3.2h32zM112 32c-8.8 0-16 7.2-16 16V80c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V48c0-8.8-7.2-16-16-16H112zm0 108.8h32c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H112c-1.8 0-3.2-1.4-3.2-3.2V144c0-1.8 1.4-3.2 3.2-3.2zM96 144v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H112c-1.8 0-3.2-1.4-3.2-3.2V240c0-1.8 1.4-3.2 3.2-3.2h32zM112 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H112zm0 108.8h32c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H112c-1.8 0-3.2-1.4-3.2-3.2V336c0-1.8 1.4-3.2 3.2-3.2zM96 336v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V336c0-8.8-7.2-16-16-16H112c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H112c-1.8 0-3.2-1.4-3.2-3.2V432c0-1.8 1.4-3.2 3.2-3.2h32zM112 416c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V432c0-8.8-7.2-16-16-16H112zM208 44.8h32c1.8 0 3.2 1.4 3.2 3.2V80c0 1.8-1.4 3.2-3.2 3.2H208c-1.8 0-3.2-1.4-3.2-3.2V48c0-1.8 1.4-3.2 3.2-3.2zM192 48V80c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V48c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H208c-1.8 0-3.2-1.4-3.2-3.2V144c0-1.8 1.4-3.2 3.2-3.2h32zM208 128c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H208zm0 108.8h32c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H208c-1.8 0-3.2-1.4-3.2-3.2V240c0-1.8 1.4-3.2 3.2-3.2zM192 240v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H208c-1.8 0-3.2-1.4-3.2-3.2V336c0-1.8 1.4-3.2 3.2-3.2h32zM208 320c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V336c0-8.8-7.2-16-16-16H208zm0 108.8h32c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H208c-1.8 0-3.2-1.4-3.2-3.2V432c0-1.8 1.4-3.2 3.2-3.2zM192 432v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V432c0-8.8-7.2-16-16-16H208c-8.8 0-16 7.2-16 16zM336 44.8c1.8 0 3.2 1.4 3.2 3.2V80c0 1.8-1.4 3.2-3.2 3.2H304c-1.8 0-3.2-1.4-3.2-3.2V48c0-1.8 1.4-3.2 3.2-3.2h32zM304 32c-8.8 0-16 7.2-16 16V80c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V48c0-8.8-7.2-16-16-16H304zm0 108.8h32c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H304c-1.8 0-3.2-1.4-3.2-3.2V144c0-1.8 1.4-3.2 3.2-3.2zM288 144v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H304c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H304c-1.8 0-3.2-1.4-3.2-3.2V240c0-1.8 1.4-3.2 3.2-3.2h32zM304 224c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H304zm0 108.8h32c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H304c-1.8 0-3.2-1.4-3.2-3.2V336c0-1.8 1.4-3.2 3.2-3.2zM288 336v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V336c0-8.8-7.2-16-16-16H304c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H304c-1.8 0-3.2-1.4-3.2-3.2V432c0-1.8 1.4-3.2 3.2-3.2h32zM304 416c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V432c0-8.8-7.2-16-16-16H304zM400 44.8h32c1.8 0 3.2 1.4 3.2 3.2V80c0 1.8-1.4 3.2-3.2 3.2H400c-1.8 0-3.2-1.4-3.2-3.2V48c0-1.8 1.4-3.2 3.2-3.2zM384 48V80c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V48c0-8.8-7.2-16-16-16H400c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H400c-1.8 0-3.2-1.4-3.2-3.2V144c0-1.8 1.4-3.2 3.2-3.2h32zM400 128c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V144c0-8.8-7.2-16-16-16H400zm0 108.8h32c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H400c-1.8 0-3.2-1.4-3.2-3.2V240c0-1.8 1.4-3.2 3.2-3.2zM384 240v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H400c-8.8 0-16 7.2-16 16zm48 92.8c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H400c-1.8 0-3.2-1.4-3.2-3.2V336c0-1.8 1.4-3.2 3.2-3.2h32zM400 320c-8.8 0-16 7.2-16 16v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V336c0-8.8-7.2-16-16-16H400zm0 108.8h32c1.8 0 3.2 1.4 3.2 3.2v32c0 1.8-1.4 3.2-3.2 3.2H400c-1.8 0-3.2-1.4-3.2-3.2V432c0-1.8 1.4-3.2 3.2-3.2zM384 432v32c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V432c0-8.8-7.2-16-16-16H400c-8.8 0-16 7.2-16 16z"],
    "right-long-to-line": [640, 512, [], "e444", "M640 72V440c0 4.4-3.6 8-8 8s-8-3.6-8-8V72c0-4.4 3.6-8 8-8s8 3.6 8 8zM320 216H40c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24H320c8.8 0 16 7.2 16 16v81.1c0 3.8 3.1 6.9 6.9 6.9c1.8 0 3.5-.7 4.7-1.9L495.2 257.9c.5-.5 .8-1.2 .8-1.9s-.3-1.4-.8-1.9L347.6 113.9c-1.3-1.2-3-1.9-4.7-1.9c-3.8 0-6.9 3.1-6.9 6.9V200c0 8.8-7.2 16-16 16zm38.6-113.7L506.2 242.5c3.7 3.5 5.8 8.4 5.8 13.5s-2.1 10-5.8 13.5L358.6 409.7c-4.2 4-9.9 6.3-15.8 6.3c-12.6 0-22.9-10.2-22.9-22.9V328 312H304 40c-22.1 0-40-17.9-40-40l0-32c0-22.1 17.9-40 40-40H304h16V184 118.9c0-12.6 10.2-22.9 22.9-22.9c5.9 0 11.5 2.3 15.8 6.3z"],
    "person-chalkboard": [640, 512, [], "e53d", "M152 56a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm96 0A56 56 0 1 0 136 56a56 56 0 1 0 112 0zM122 173.9c9.7-18.4 28.8-29.9 49.5-29.9h79.6H384c8.8 0 16 7.2 16 16s-7.2 16-16 16H264c-8.8 0-16 7.2-16 16v55.8l0 .2V480c0 8.8-7.2 16-16 16s-16-7.2-16-16V360c0-13.3-10.7-24-24-24s-24 10.7-24 24V480c0 8.8-7.2 16-16 16s-16-7.2-16-16V248c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 17.7 14.3 32 32 32s32-14.3 32-32V360c0-4.4 3.6-8 8-8s8 3.6 8 8V480c0 17.7 14.3 32 32 32s32-14.3 32-32V256.2l0-.2V192H384c17.7 0 32-14.3 32-32s-14.3-32-32-32H336V48c0-17.7 14.3-32 32-32H592c17.7 0 32 14.3 32 32V272c0 17.7-14.3 32-32 32H368c-17.7 0-32-14.3-32-32V224H320v48c0 26.5 21.5 48 48 48H592c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48H368c-26.5 0-48 21.5-48 48v80H251.1 171.5c-26.7 0-51.2 14.8-63.7 38.4L32.9 308.3c-2.1 3.9-.6 8.7 3.3 10.8s8.7 .6 10.8-3.3L122 173.9z"],
    "mars-stroke-right": [640, 512, [9897, "mars-stroke-h"], "f22b", "M48 256a160 160 0 1 1 320 0A160 160 0 1 1 48 256zm335.8-8C379.6 154.5 302.5 80 208 80C110.8 80 32 158.8 32 256s78.8 176 176 176c94.5 0 171.6-74.5 175.8-168H448v56c0 4.4 3.6 8 8 8s8-3.6 8-8V264H580.7l-74.3 74.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l88-88c3.1-3.1 3.1-8.2 0-11.3l-88-88c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L580.7 248H464V192c0-4.4-3.6-8-8-8s-8 3.6-8 8v56H383.8z"],
    "hand-back-fist": [448, 512, ["hand-rock"], "f255", "M112 56c0-30.9 25.1-56 56-56c22.9 0 42.6 13.8 51.3 33.5c4.1-1 8.4-1.5 12.7-1.5c22.9 0 42.6 13.8 51.3 33.5c4.1-1 8.4-1.5 12.7-1.5c22.9 0 42.6 13.8 51.3 33.5c4.1-1 8.4-1.5 12.7-1.5c30.9 0 56 25.1 56 56V256c0 46.8-23.7 88.1-59.7 112.6c-2.8 1.9-4.3 4.8-4.3 7.5V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V376.1c0-8.7 4.7-16.2 11.3-20.8c31.8-21.6 52.7-58 52.7-99.4V152c0-22.1-17.9-40-40-40c-5.2 0-10.2 1-14.7 2.8c-2.1 .8-4.5 .7-6.5-.3s-3.5-2.9-4.1-5.1C330 92.5 314.4 80 296 80c-5.2 0-10.2 1-14.7 2.8c-2.1 .8-4.5 .7-6.5-.3s-3.5-2.9-4.1-5.1C266 60.5 250.4 48 232 48c-5.2 0-10.2 1-14.7 2.8c-2.1 .8-4.5 .7-6.5-.3s-3.5-2.9-4.1-5.1C202 28.5 186.4 16 168 16c-22.1 0-40 17.9-40 40v64s0 0 0 0v96c0 4.4-3.6 8-8 8s-8-3.6-8-8V139.3L80.4 170.9C69.9 181.4 64 195.7 64 210.5V256c0 47.9 32.4 88.3 76.5 100.3c10.6 2.9 19.5 12.3 19.5 24.4V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V380.7c0-3.8-2.9-7.7-7.7-9C85.4 357.9 48 311.3 48 256V210.5c0-19.1 7.6-37.4 21.1-50.9L112 116.7V56z"],
    "grid-round-5": [448, 512, [], "e5de", "M51.2 64A19.2 19.2 0 1 1 12.8 64a19.2 19.2 0 1 1 38.4 0zM32 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM51.2 160a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM32 128a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM0 256a32 32 0 1 0 64 0A32 32 0 1 0 0 256zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM32 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM0 448a32 32 0 1 0 64 0A32 32 0 1 0 0 448zM147.2 64a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM128 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM96 160a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM128 224a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM96 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM128 416a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM224 44.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM192 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM224 128a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM192 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM224 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM192 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM339.2 64a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM320 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM288 160a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM320 224a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM288 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM320 416a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM416 44.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM384 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM416 128a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM384 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm51.2 96a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zM416 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0 108.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zM384 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"],
    "tally": [640, 512, ["tally-5"], "f69c", "M128 32c4.4 0 8 3.6 8 8V308.9l112-37.3V40c0-4.4 3.6-8 8-8s8 3.6 8 8V266.2l112-37.3V40c0-4.4 3.6-8 8-8s8 3.6 8 8V223.6l112-37.3V40c0-4.4 3.6-8 8-8s8 3.6 8 8V180.9l85.5-28.5c4.2-1.4 8.7 .9 10.1 5.1s-.9 8.7-5.1 10.1L520 197.8V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V203.1L392 240.4V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V245.8L264 283.1V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V288.4L136 325.8V472c0 4.4-3.6 8-8 8s-8-3.6-8-8V331.1L34.5 359.6c-4.2 1.4-8.7-.9-10.1-5.1s.9-8.7 5.1-10.1L120 314.2V40c0-4.4 3.6-8 8-8z"],
    "square-caret-up": [448, 512, ["caret-square-up"], "f151", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm224 64c7.3 0 14.3 3 19.3 8.4L345.2 277.6c4.4 4.7 6.8 10.8 6.8 17.2c0 13.9-11.3 25.2-25.2 25.2H121.2C107.3 320 96 308.7 96 294.8c0-6.4 2.4-12.5 6.8-17.2L204.7 168.4c5-5.4 12-8.4 19.3-8.4zM121.2 304H326.8c5.1 0 9.2-4.1 9.2-9.2c0-2.3-.9-4.6-2.5-6.3L231.6 179.3c-2-2.1-4.7-3.3-7.6-3.3s-5.6 1.2-7.6 3.3L114.5 288.5c-1.6 1.7-2.5 4-2.5 6.3c0 5.1 4.1 9.2 9.2 9.2z"],
    "cloud-showers-water": [576, 512, [], "e4e4", "M224 0c-53 0-96 43-96 96c-35.3 0-64 28.7-64 64s28.7 64 64 64H448c35.3 0 64-28.7 64-64s-28.7-64-64-64h-1.6C439 59.5 406.7 32 368 32c-22.2 0-42.4 9.1-56.8 23.7C295.9 22.8 262.6 0 224 0zM144 96c0-44.2 35.8-80 80-80c36.4 0 67.2 24.3 76.8 57.6c.9 3 3.4 5.2 6.4 5.7s6.1-.8 7.9-3.4C326.7 59.1 346 48 368 48c32.9 0 60.1 24.9 63.6 56.9c.4 4.1 3.9 7.1 8 7.1H448c26.5 0 48 21.5 48 48s-21.5 48-48 48H128c-26.5 0-48-21.5-48-48s21.5-48 48-48h8.4c2.2 0 4.4-.9 5.9-2.6s2.3-3.9 2.1-6.1c-.2-2.4-.3-4.8-.3-7.3zm-1.5 172.6c2.6-3.6 1.7-8.6-1.9-11.2s-8.6-1.7-11.2 1.9l-80 112c-2.6 3.6-1.7 8.6 1.9 11.2s8.6 1.7 11.2-1.9l80-112zm334.1-11.2c-3.6-2.6-8.6-1.7-11.2 1.9l-80 112c-2.6 3.6-1.7 8.6 1.9 11.2s8.6 1.7 11.2-1.9l80-112c2.6-3.6 1.7-8.6-1.9-11.2zM254.5 268.6c2.6-3.6 1.7-8.6-1.9-11.2s-8.6-1.7-11.2 1.9l-80 112c-2.6 3.6-1.7 8.6 1.9 11.2s8.6 1.7 11.2-1.9l80-112zm110.1-11.2c-3.6-2.6-8.6-1.7-11.2 1.9l-80 112c-2.6 3.6-1.7 8.6 1.9 11.2s8.6 1.7 11.2-1.9l80-112c2.6-3.6 1.7-8.6-1.9-11.2zM294.6 435.4c-3-4.3-10.2-4.3-13.2 0c-8 11.2-17.5 21.4-27.6 30.7C236.6 481.8 214.5 496 192 496s-44.6-14.2-61.8-29.9c-10.1-9.2-19.7-19.5-27.6-30.7c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.3 10.3-15.9 19.6-25 28.3C48.7 478.5 28.3 492.9 7 495.6c-4.4 .6-7.5 4.6-6.9 8.9s4.6 7.5 8.9 6.9c26.5-3.3 50-20.7 66.4-36.1c8.8-8.3 15.9-16.4 20.6-22.2c5.2 6.4 13.2 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8l0 0 0 0c5.2 6.4 13.3 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8c4.7 5.8 11.8 13.9 20.6 22.2c16.4 15.4 39.9 32.8 66.4 36.1c4.4 .6 8.4-2.6 8.9-6.9s-2.6-8.4-6.9-8.9c-21.3-2.7-41.7-17.1-57.4-31.9c-9.1-8.6-17.7-18-25-28.3c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.9 11.2-17.5 21.5-27.6 30.7C428.6 481.8 406.5 496 384 496s-44.6-14.2-61.8-29.9c-10.1-9.2-19.6-19.5-27.6-30.7z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M16 40c0-4.4-3.6-8-8-8s-8 3.6-8 8V408c0 39.8 32.2 72 72 72H504c4.4 0 8-3.6 8-8s-3.6-8-8-8H72c-30.9 0-56-25.1-56-56V40zm96 104c0-8.8 7.2-16 16-16l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16H256c8.8 0 16 7.2 16 16s-7.2 16-16 16H128c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16H384c8.8 0 16 7.2 16 16s-7.2 16-16 16H128c-8.8 0-16-7.2-16-16zm16-224c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-192 0zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32H256c17.7 0 32-14.3 32-32s-14.3-32-32-32H128zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32H384c17.7 0 32-14.3 32-32s-14.3-32-32-32H128z"],
    "hands-bubbles": [576, 512, ["hands-wash"], "e05e", "M392 64a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-64a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM16 136l0 90.5C16 283 45.9 335.3 94.6 364l1.4 .8c-5.1 2.9-9.8 6.3-14.3 10.1C31 342.8 0 286.8 0 226.5L0 136c0-22.1 17.9-40 40-40s40 17.9 40 40l0 25.7L160.4 22.4C171.5 3.2 196-3.3 215.1 7.7c7.8 4.5 13.5 11.2 16.8 18.9C242.9 7.5 267.4 1 286.5 12s25.7 35.5 14.6 54.6c8.3-1 17 .6 24.8 5.1c19.1 11 25.7 35.5 14.6 54.6l-1.6 2.8c-5 .9-10 2.4-14.9 4.5l-8.1 3.4 10.8-18.7c6.6-11.5 2.7-26.2-8.8-32.8c-11.5-6.6-26.1-2.7-32.8 8.8l0 0-42.5 73.7c-9.6 4.4-18.7 9.5-27.3 15.3l56-97 0 0 16-27.7c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8l-16 27.7 0 0-64 110.9c-2.2 3.8-7.1 5.1-10.9 2.9s-5.1-7.1-2.9-10.9l64-110.8 0 0c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8L78.9 195.5c-1.8 3.1-5.5 4.7-9 3.7s-5.9-4.1-5.9-7.7L64 136c0-13.3-10.7-24-24-24s-24 10.7-24 24zM325 512c-34.1 0-65.7-10.3-92-28c2.1-5.2 3.7-10.5 4.9-16.1C262.4 485.6 292.5 496 325 496H472c13.3 0 24-10.7 24-24c0-13.2-10.7-24-24-24l0 0-96 0c-4.4 0-8-3.6-8-8s3.6-8 8-8h96l0 0h32c13.3 0 24-10.7 24-24c0-13.2-10.7-24-24-24l0 0H376c-4.4 0-8-3.6-8-8s3.6-8 8-8H504l0 0h32c13.3 0 24-10.7 24-24s-10.7-24-24-24H504l0 0H376c-4.4 0-8-3.6-8-8s3.6-8 8-8H504l0 0c13.3 0 24-10.7 24-24s-10.7-24-24-24H320.5c-3.8 0-7.1-2.7-7.8-6.4s1.2-7.5 4.7-9l44-18.5c12.2-5.1 18-19.2 12.8-31.4s-19.2-17.9-31.4-12.8l-75.5 31.8C211.9 232.9 176 287 176 347c0 3.6 .1 7.1 .4 10.6c-5.2-1.9-10.7-3.3-16.3-4.2c-.1-2.1-.1-4.2-.1-6.3c0-66.4 39.8-126.3 101-152.1l75.5-31.8c20.4-8.6 43.8 1 52.4 21.3s-1 43.8-21.3 52.4l-7.4 3.1H504c22.1 0 40 17.9 40 40c0 9-3 17.3-8 24c22.1 0 40 17.9 40 40s-17.9 40-40 40c5 6.7 8 15 8 24c0 22.1-17.9 40-40 40c5 6.7 8 15 8 24c0 22.1-17.9 40-40 40H325zM192 448a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM80 448a64 64 0 1 1 128 0A64 64 0 1 1 80 448zM528 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 0a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "less-than-equal": [448, 512, [], "f537", "M411.1 47.4c4.1-1.7 6-6.4 4.3-10.4s-6.4-6-10.4-4.3l-368 152c-3 1.2-4.9 4.2-4.9 7.4s2 6.2 4.9 7.4l368 152c4.1 1.7 8.8-.3 10.4-4.3s-.3-8.8-4.3-10.4L61 192 411.1 47.4zM8 464c-4.4 0-8 3.6-8 8s3.6 8 8 8H440c4.4 0 8-3.6 8-8s-3.6-8-8-8H8z"],
    "train": [448, 512, [128646], "f238", "M352 16c44.2 0 80 35.8 80 80V352c0 44.2-35.8 80-80 80H96c-44.2 0-80-35.8-80-80V96c0-44.2 35.8-80 80-80H352zM96 0C43 0 0 43 0 96V352c0 49.4 37.3 90.1 85.3 95.4L34.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L107.3 448H340.7l61.7 61.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-50.9-50.9c48-5.3 85.3-46 85.3-95.4V96c0-53-43-96-96-96H96zM272 320a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-48-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 80H352c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V96c0-8.8 7.2-16 16-16zM64 96v96c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32H96C78.3 64 64 78.3 64 96z"],
    "up-from-dotted-line": [448, 512, [], "e456", "M216 51.3c2.1-2.1 5-3.3 8-3.3s5.9 1.2 8 3.3L363.8 183.4c2.7 2.7 4.2 6.4 4.2 10.2c0 8-6.5 14.4-14.4 14.4H280c-4.4 0-8 3.6-8 8V352c0 8.8-7.2 16-16 16H192c-8.8 0-16-7.2-16-16V216c0-4.4-3.6-8-8-8H94.4c-8 0-14.4-6.5-14.4-14.4c0-3.8 1.5-7.5 4.2-10.2L216 51.3zM224 32c-7.2 0-14.2 2.9-19.3 8L72.9 172.1c-5.7 5.7-8.9 13.4-8.9 21.5C64 210.4 77.6 224 94.4 224H160V352c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V224h65.6c16.8 0 30.4-13.6 30.4-30.4c0-8.1-3.2-15.8-8.9-21.5L243.3 40c-5.1-5.1-12.1-8-19.3-8zM32 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm96 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "eye-low-vision": [640, 512, ["low-vision"], "f2a8", "M1.7 3C4.5-.4 9.5-1 13 1.7l624 496c3.5 2.7 4 7.8 1.3 11.2s-7.8 4-11.2 1.3L3 14.3C-.4 11.5-1 6.5 1.7 3zM605.5 268.3c-9.6 23-26 52.8-49 82.7L544 341.1c22-28.7 37.7-57.1 46.8-78.9c1.6-3.9 1.6-8.4 0-12.3C576.7 216 546.6 166 501.7 124.3C456.6 82.4 395.6 48 320 48c-42.1 0-79.7 10.7-112.6 27.4L193.7 64.5C229.9 44.9 272.2 32 320 32c80.8 0 145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6zM320 144c60.7 0 110.2 48.3 112 108.6l-17.5-13.8C406.4 194 367.2 160 320 160c-1.8 0-3.5 0-5.2 .1l-17.5-13.8c7.3-1.5 15-2.3 22.7-2.3zM101 169.8l320 256c3.4 2.8 4 7.8 1.2 11.2s-7.8 4-11.2 1.2L91 182.2c-3.5-2.8-4-7.8-1.2-11.2s7.8-4 11.2-1.2zM73.8 243c2.8-3.5 7.8-4 11.2-1.2l250 200c3.4 2.8 4 7.8 1.2 11.2s-7.8 4-11.2 1.2L75 254.2c-3.5-2.8-4-7.8-1.2-11.2zM101 342.6l124 99.2c3.4 2.8 4 7.8 1.2 11.2s-7.8 4-11.2 1.2L91 355c-3.5-2.8-4-7.8-1.2-11.2s7.8-4 11.2-1.2z"],
    "traffic-light-go": [320, 512, [], "f638", "M256 16c26.5 0 48 21.5 48 48V352c0 79.5-64.5 144-144 144S16 431.5 16 352V64c0-26.5 21.5-48 48-48H256zM64 0C28.7 0 0 28.7 0 64V352c0 88.4 71.6 160 160 160s160-71.6 160-160V64c0-35.3-28.7-64-64-64H64zm96 432a40 40 0 1 1 0-80 40 40 0 1 1 0 80zm0-96a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm40-80a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm-96 0a56 56 0 1 0 112 0 56 56 0 1 0 -112 0zm56-96a40 40 0 1 1 0-80 40 40 0 1 1 0 80zm0-96a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm0 312a16 16 0 1 0 0 32 16 16 0 1 0 0-32z"],
    "face-exhaling": [576, 512, [], "e480", "M256 16C123.5 16 16 123.5 16 256s107.5 240 240 240c43.7 0 84.6-11.6 119.8-32c3.8-2.2 8.7-.9 10.9 2.9s.9 8.7-2.9 10.9C346.2 499.6 302.5 512 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0C391.7 0 502.7 105.5 511.4 238.9c.3 4.4-3 8.2-7.5 8.5s-8.2-3-8.5-7.5C487.2 114.9 383.2 16 256 16zm0 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm54.6-91.9c10.9 19.3 26.4 27.9 41 27.9s30.2-8.6 41-27.9c2.2-3.9 7-5.2 10.9-3.1s5.2 7 3 10.9c-13.1 23.4-33.6 36.1-55 36.1s-41.8-12.7-55-36.1c-2.2-3.9-.8-8.7 3.1-10.9s8.7-.8 10.9 3.1zM159.6 272c14.6 0 30.2-8.6 41-27.9c2.2-3.9 7-5.2 10.9-3.1s5.2 7 3.1 10.9c-13.1 23.4-33.6 36.1-55 36.1s-41.8-12.7-55-36.1c-2.2-3.9-.8-8.7 3.1-10.9s8.7-.8 10.9 3.1c10.9 19.3 26.4 27.9 41 27.9zm335.2 24c23.3 0 42.3 18.3 43.8 41.3C556 345.5 568 363.4 568 384s-12 38.5-29.4 46.7c-1.6 23-20.5 41.3-43.8 41.3c-13.4 0-25.4-6.1-33.4-15.6c-3.1 .7-6.2 1-9.5 1c-24.4 0-44-19.9-44-44.4c0-.4 0-.9 0-1.3l-66.2-20.1c-3.4-1-5.7-4.1-5.7-7.7s2.3-6.6 5.7-7.7l66.6-20.2c2.9-21.6 21.2-38.3 43.5-38.3c1.7 0 3.3 .1 4.9 .3c7.6-13.2 21.7-22.1 38-22.1zm-26 34c-1.5 3.8-5.6 5.9-9.6 4.8c-2.3-.6-4.8-1-7.3-1c-15.4 0-27.9 12.6-27.9 28.4c0 3.5-2.3 6.6-5.7 7.7L371.6 384l47.3 14.4c3.9 1.2 6.3 5.2 5.5 9.2c-.3 1.8-.5 3.6-.5 5.5c0 15.8 12.6 28.4 28 28.4c3.4 0 6.7-.6 9.8-1.8c3.6-1.3 7.6 0 9.6 3.2c5 7.9 13.7 13.1 23.6 13.1c15.4 0 27.9-12.6 27.9-28.4c0-.6 0-1.2-.1-1.8c-.2-3.6 2-6.9 5.4-8.1c13.9-4.7 23.9-18 23.9-33.8s-10.1-29-23.9-33.8c-3.4-1.2-5.6-4.5-5.4-8.1c0-.6 .1-1.2 .1-1.8c0-15.8-12.6-28.4-27.9-28.4c-11.8 0-21.9 7.4-26 18z"],
    "sensor-fire": [640, 512, [], "e02a", "M64 48H384c26.5 0 48 21.5 48 48v33.5c5.2-1.3 10.6-1.8 16-1.3V96c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H337.6c-4.5-5.1-8.8-10.4-12.8-16H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48zm32 56c0-4.4-3.6-8-8-8s-8 3.6-8 8V280c0 4.4 3.6 8 8 8s8-3.6 8-8V104zm64 0c0-4.4-3.6-8-8-8s-8 3.6-8 8V280c0 4.4 3.6 8 8 8s8-3.6 8-8V104zM509.2 237.3c4.8-.1 9.4-2.3 12.3-6c7.6-9.5 15.6-19.2 23.9-26.9c22.7 21 42.2 49 56.2 76c14 27.1 22.4 55.2 22.4 71.6c0 79-64.1 143.8-144 143.8c-80.8 0-144-64.8-144-143.8c0-22.2 11-53.4 30-84.2c18.9-30.7 45.8-63 77.6-91.5c18.9 17.1 36.6 35.5 53.1 55.3c3.1 3.7 7.7 5.8 12.5 5.8zM498.4 209c-14.2-16.1-29.1-31.2-44.9-45.3c-2.8-2.5-6.3-3.7-9.8-3.8c-3.6 0-7.2 1.2-10 3.7c-33.2 29.7-61.4 63.4-81.4 95.8C332.7 291.3 320 325.6 320 352c0 87.8 70.3 159.8 160 159.8c88.7 0 160-72 160-159.8c0-20.2-9.6-50.9-24.2-79c-14.8-28.5-35.7-58.5-60.4-81.1c-5.6-5.1-14.4-5.2-20 0c-5.6 5.1-11 11-16.1 16.9c-3.6 4.2-7.1 8.5-10.3 12.6c-3.5-4.2-7-8.3-10.6-12.4zm-56.8 46.9c-2.4 0-4.7 1.1-6.2 3c-16.5 20.4-29.3 36.8-37.9 51.6c-8.7 15-13.5 28.8-13.5 43.9c0 29.1 10.8 52.8 28.7 69.2c17.8 16.3 42.2 24.9 68.7 24.9c21.5 0 40.7-6 58.5-17.9l0 0 .2-.1c36.7-25.7 46.1-76.6 24.6-116.2l0-.1 0 0c-2.2-4.3-4.6-9.3-8.4-14.3c-1.5-1.9-3.7-3.1-6.1-3.2s-4.8 .9-6.3 2.8l-33.4 38.9-4-5.2-22.5-28.7c-16.5-21.1-33.7-42.9-35.9-45.7c-1.5-1.9-3.8-3-6.2-3zM510.1 351l-6.3 4.9c1.5 1.9 3.7 3 6.1 3.1s4.7-1 6.2-2.8l32.6-38c.5 1.1 1.1 2.1 1.7 3.3l0 0 .1 .2c18.1 33.2 9.8 74.9-19.6 95.5c-15.3 10.2-31.4 15.2-49.5 15.2c-23.1 0-43.5-7.4-57.9-20.7c-14.4-13.1-23.5-32.5-23.5-57.4c0-11.4 3.5-22.4 11.3-35.8c6.9-11.8 16.9-25.1 30.3-41.8c6.9 8.8 18.4 23.4 29.6 37.8l22.5 28.7 7.3 9.3 2 2.6 .5 .7 .1 .2 0 0 0 0 0 0 6.3-4.9z"],
    "user-unlock": [640, 512, [], "e058", "M112 128a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zM16 482.3C16 392.7 88.7 320 178.3 320h91.4c44.6 0 85 18 114.3 47.1V352c0-2.1 .1-4.2 .3-6.3c-31-26-71-41.7-114.6-41.7H178.3C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H392.6c-2.9-5-5.1-10.3-6.5-16H29.7c-7.6 0-13.7-6.1-13.7-13.7zM224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm256 0c0-26.5 21.5-48 48-48s48 21.5 48 48v16h16V256c0-35.3-28.7-64-64-64s-64 28.7-64 64v64H448c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32H592 576 512 480V256zm-16 80h16 96 16 16c8.8 0 16 7.2 16 16V480c0 8.8-7.2 16-16 16H448c-8.8 0-16-7.2-16-16V352c0-8.8 7.2-16 16-16h16z"],
    "hexagon-divide": [512, 512, [], "e1ad", "M400.8 450.8l0 0L497.1 284c2.5-4.3 4.4-8.9 5.6-13.6c2-7.7 2.4-15.7 1.1-23.6c-1.1-6.5-3.3-12.9-6.7-18.8L400.8 61.2c-10-17.3-28.5-28-48.5-28H159.7c-20 0-38.5 10.7-48.5 28L14.9 228c-3.9 6.7-6.3 14.1-7.1 21.6c-1.4 11.8 1 23.9 7.1 34.4l96.3 166.8c10 17.3 28.5 28 48.5 28H352.3c20 0 38.5-10.7 48.5-28zM483.2 236c2.7 4.6 4.4 9.7 5 14.8l-2.7 20.4c-.7 1.6-1.4 3.2-2.3 4.8L386.9 442.8c-7.1 12.4-20.4 20-34.6 20H159.7c-14.3 0-27.5-7.6-34.6-20L28.8 276c-3.6-6.2-5.4-13.1-5.4-20c0-3.4 .4-6.8 1.3-10.1c.9-3.4 2.2-6.8 4.1-9.9L125.1 69.2c7.1-12.4 20.4-20 34.6-20l192.6 0c14.3 0 27.5 7.6 34.6 20L483.2 236zM240 160a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM152 248c-4.4 0-8 3.6-8 8s3.6 8 8 8H360c4.4 0 8-3.6 8-8s-3.6-8-8-8H152zm104 88a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 48a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "00": [640, 512, [], "e467", "M144 32C64.5 32 0 96.5 0 176V336c0 79.5 64.5 144 144 144s144-64.5 144-144V176c0-79.5-64.5-144-144-144zM16 176C16 105.3 73.3 48 144 48s128 57.3 128 128V336c0 70.7-57.3 128-128 128S16 406.7 16 336V176zM496 32c-79.5 0-144 64.5-144 144V336c0 79.5 64.5 144 144 144s144-64.5 144-144V176c0-79.5-64.5-144-144-144zM368 176c0-70.7 57.3-128 128-128s128 57.3 128 128V336c0 70.7-57.3 128-128 128s-128-57.3-128-128V176z"],
    "crow": [640, 512, [], "f520", "M352 88c0-48.6 39.4-88 88-88c34.2 0 63.8 19.5 78.4 48H568c39.8 0 72 32.2 72 72L528 148v44c0 85.3-55.6 157.6-132.6 182.6l52 126.3c1.7 4.1-.3 8.8-4.4 10.4s-8.8-.3-10.4-4.4L379.9 379c-14.1 3.3-28.8 5-43.9 5H303.2l48.2 117c1.7 4.1-.3 8.8-4.4 10.4s-8.8-.3-10.4-4.3L285.9 384H137L10.1 415.7c-3.1 .9-6.6-.2-8.6-3c-2.6-3.6-1.8-8.6 1.8-11.2L352 147.9V88zm176 43.5l94.7-23.7C617.1 82.8 594.8 64 568 64H524.7c2.2 7.6 3.3 15.7 3.3 24v43.5zM336 368c97.2 0 176-78.8 176-176V88c0-39.8-32.2-72-72-72s-72 32.2-72 72v64 .1 24c0 88.3-60.1 165.3-145.8 186.7L201 368H336zM46 390.3l172.4-43.1C296.9 327.5 352 257 352 176v-8.3L46 390.3zM440 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "cassette-betamax": [576, 512, ["betamax"], "f8a4", "M16 144V416c0 26.5 21.5 48 48 48H512c26.5 0 48-21.5 48-48V144H16zm0-16H560V96c0-26.5-21.5-48-48-48H64C37.5 48 16 69.5 16 96v32zM576 96v32 8 8V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V144v-8-8V96C0 60.7 28.7 32 64 32H512c35.3 0 64 28.7 64 64zM240 304A80 80 0 1 0 80 304a80 80 0 1 0 160 0zM64 304a96 96 0 1 1 192 0A96 96 0 1 1 64 304zm96-16a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm32 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm160-80c-8.8 0-16 7.2-16 16V368c0 8.8 7.2 16 16 16H480c8.8 0 16-7.2 16-16V240c0-8.8-7.2-16-16-16H352zm-32 16c0-17.7 14.3-32 32-32H480c17.7 0 32 14.3 32 32V368c0 17.7-14.3 32-32 32H352c-17.7 0-32-14.3-32-32V240z"],
    "sailboat": [576, 512, [], "e445", "M270.5 3.4c-2-2.8-5.6-4-9-3S256 4.5 256 8V344c0 4.4 3.6 8 8 8H504c3 0 5.7-1.7 7.1-4.3s1.1-5.9-.6-8.3l-240-336zM272 336V33L488.5 336H272zM218.1 96.3c-3.5-1-7.1 .5-9 3.6l-144 240c-1.5 2.5-1.5 5.5-.1 8.1s4.1 4.1 7 4.1H216c4.4 0 8-3.6 8-8V104c0-3.6-2.4-6.8-5.9-7.7zM86.1 336L208 132.9V336H86.1zm468.7 64l-4 14.3C537.3 462.6 493.2 496 443 496H133c-50.2 0-94.2-33.4-107.8-81.7l-4-14.3H554.9zM21.1 384c-10.6 0-18.3 10.1-15.4 20.3l4 14.3C25.3 473.9 75.6 512 133 512H443c57.3 0 107.7-38.1 123.2-93.3l4-14.3c2.9-10.2-4.8-20.3-15.4-20.3H21.1z"],
    "window-restore": [512, 512, [], "f2d2", "M432 16H208c-35.3 0-64 28.7-64 64V96H128V80c0-44.2 35.8-80 80-80H432c44.2 0 80 35.8 80 80V304c0 44.2-35.8 80-80 80H416V368h16c35.3 0 64-28.7 64-64V80c0-35.3-28.7-64-64-64zM320 144H64c-26.5 0-48 21.5-48 48v64H368V192c0-26.5-21.5-48-48-48zM16 448c0 26.5 21.5 48 48 48H320c26.5 0 48-21.5 48-48V272H16V448zM64 128H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V192c0-35.3 28.7-64 64-64z"],
    "nfc-magnifying-glass": [640, 512, [], "e1f9", "M384 48H64C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H378.2c9.6 4.7 19.8 8.4 30.4 11.1c-7.6 3.2-15.9 4.9-24.6 4.9H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64v64c-5.4 0-10.7 .3-16 .8V96c0-26.5-21.5-48-48-48zm-16 88v45.4c-5.6 3.2-10.9 6.7-16 10.6V136c0-4.4-3.6-8-8-8H240c-4.4 0-8 3.6-8 8v80.8c18.3 3.7 32 19.8 32 39.2c0 22.1-17.9 40-40 40s-40-17.9-40-40c0-19.4 13.7-35.5 32-39.2V136c0-13.3 10.7-24 24-24H344c13.3 0 24 10.7 24 24zM309.4 400H104c-13.3 0-24-10.7-24-24V136c0-13.3 10.7-24 24-24h48c4.4 0 8 3.6 8 8s-3.6 8-8 8H104c-4.4 0-8 3.6-8 8V376c0 4.4 3.6 8 8 8H301.3c2.4 5.5 5.1 10.8 8.1 16zM224 232a24 24 0 1 0 0 48 24 24 0 1 0 0-48zM448 432.2a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm0 16c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 32.5-12.1 62.1-32 84.7l93.7 93.7c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-93.7-93.7c-22.6 19.9-52.2 32-84.7 32z"],
    "file-binary": [384, 512, [], "e175", "M64 496c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48H64zM358.6 157.3c.9 .9 1.7 1.8 2.4 2.7H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64zm48 256c-22.1 0-40 17.9-40 40v80c0 22.1 17.9 40 40 40h32c22.1 0 40-17.9 40-40V296c0-22.1-17.9-40-40-40H112zM88 296c0-13.3 10.7-24 24-24h32c13.3 0 24 10.7 24 24v80c0 13.3-10.7 24-24 24H112c-13.3 0-24-10.7-24-24V296zm152-40c-4.4 0-8 3.6-8 8s3.6 8 8 8h24V400H240c-4.4 0-8 3.6-8 8s3.6 8 8 8h32 32c4.4 0 8-3.6 8-8s-3.6-8-8-8H280V264c0-4.4-3.6-8-8-8H240z"],
    "circle-v": [512, 512, [], "e12a", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM143.2 148.4c-2-4-6.8-5.6-10.7-3.6s-5.6 6.8-3.6 10.7l120 240c1.4 2.7 4.1 4.4 7.2 4.4s5.8-1.7 7.2-4.4l120-240c2-4 .4-8.8-3.6-10.7s-8.8-.4-10.7 3.6L256 374.1 143.2 148.4z"],
    "square-plus": [448, 512, [61846, "plus-square"], "f0fe", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM216 352V264H128c-4.4 0-8-3.6-8-8s3.6-8 8-8h88V160c0-4.4 3.6-8 8-8s8 3.6 8 8v88h88c4.4 0 8 3.6 8 8s-3.6 8-8 8H232v88c0 4.4-3.6 8-8 8s-8-3.6-8-8z"],
    "bowl-scoops": [448, 512, [127813], "e3df", "M335.3 64.7C313.3 26.1 271.7 0 224 0s-89.3 26.1-111.3 64.7c5-.5 10.1-.7 15.3-.7c1.4 0 2.7 0 4 0c20.2-29 53.9-48 92-48s71.7 19 92 48c1.3 0 2.7 0 4 0c5.2 0 10.3 .2 15.3 .7zM200 118.2c-20.5-14-45.3-22.2-72-22.2C57.3 96 0 153.3 0 224H16c0-61.9 50.1-112 112-112c22.9 0 44.2 6.9 62 18.7c3.1-4.4 6.5-8.5 10-12.6zM448 224c0-70.7-57.3-128-128-128s-128 57.3-128 128h16c0-61.9 50.1-112 112-112s112 50.1 112 112h16zM17.9 280.7c-.5-4.6 3.1-8.7 7.7-8.7H422.4c4.6 0 8.3 4 7.7 8.7c-7.5 67.9-65 119.3-133.3 119.3H264c-3.2 0-6.2 1.9-7.4 4.9s-.6 6.4 1.7 8.7L335 490.3c.6 .6 1 1.5 1 2.3c0 1.8-1.5 3.3-3.3 3.3H115.3c-1.8 0-3.3-1.5-3.3-3.3c0-.9 .3-1.7 1-2.3l76.7-76.7c2.3-2.3 3-5.7 1.7-8.7s-4.2-4.9-7.4-4.9H151.2C82.9 400 25.4 348.6 17.9 280.7zM25.6 256C11.5 256 .4 268.3 2 282.4C10.4 358.5 74.7 416 151.2 416h13.4l-63 63c-3.6 3.6-5.7 8.5-5.7 13.7c0 10.7 8.6 19.3 19.3 19.3H332.7c10.7 0 19.3-8.6 19.3-19.3c0-5.1-2-10-5.7-13.7l-63-63h13.4c76.5 0 140.8-57.5 149.2-133.6c1.6-14.1-9.5-26.4-23.7-26.4H25.6z"],
    "mistletoe": [576, 512, [], "f7b4", "M288 0c4.4 0 8 3.6 8 8V92.7l86 86 2.9 .6 99.8 19.2C537.7 208.6 576 255 576 309c0 41.4-33.6 75-75 75c-54 0-100.3-38.3-110.5-91.3l-19.2-99.8-.6-2.9L296 115.3V266.7l2 2.7 66.8 89.1C377.3 375 384 395.2 384 416c0 53-43 96-96 96s-96-43-96-96c0-20.8 6.7-41 19.2-57.6L278 269.3l2-2.7V115.3L205.3 190l-.6 2.9-6.7 35c-4.9-1.8-10.2-3-15.6-3.6l5-25.8c-.4-.3-.7-.5-1-.9s-.6-.7-.9-1L94.3 214.2C48.9 222.9 16 262.7 16 309c0 32.6 26.4 59 59 59c25.4 0 48.8-9.9 66.2-26.3c4.7 3.1 9.9 5.5 15.4 7.3c-20.7 21.7-49.8 35-81.6 35c-41.4 0-75-33.6-75-75c0-54 38.3-100.3 91.3-110.5l99.8-19.2 2.9-.6 86-86V8c0-4.4 3.6-8 8-8zM389.7 197.7c-.3 .3-.7 .6-1 .9l17.5 91.2c8.7 45.5 48.5 78.3 94.8 78.3c32.6 0 59-26.4 59-59c0-46.3-32.9-86.1-78.3-94.8l-91.2-17.5c-.3 .4-.5 .7-.9 1zM224 368c-10.4 13.8-16 30.7-16 48c0 44.2 35.8 80 80 80s80-35.8 80-80c0-17.3-5.6-34.2-16-48l-64-85.3L224 368zM360 64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24 40a40 40 0 1 1 0-80 40 40 0 1 1 0 80zM176 264a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm40 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z"],
    "custard": [576, 512, [127854], "e403", "M57.8 384l66.3-271.2c7-28.6 32.7-48.8 62.2-48.8H389.8c29.5 0 55.2 20.2 62.2 48.8L518.2 384H501.8L459.7 211.9C439.9 205.4 418 200 400 200c-20.7 0-35.9 7.2-52.5 15.2l-.4 .2C330.6 223.3 312.6 232 288 232s-42.6-8.7-59.1-16.6l-.4-.2c-16.7-8-31.8-15.2-52.5-15.2c-18 0-39.9 5.4-59.7 11.9L74.2 384H57.8zm63-190.3c18.1-5.4 37.9-9.7 55.2-9.7c24.6 0 42.6 8.7 59.1 16.6l.4 .2c16.7 8 31.8 15.2 52.5 15.2s35.9-7.2 52.5-15.2l.4-.2c16.5-7.9 34.5-16.6 59.1-16.6c17.3 0 37.1 4.3 55.2 9.7l-18.8-77.1C431.1 95.1 411.9 80 389.8 80H186.2c-22.1 0-41.4 15.1-46.6 36.6l-18.9 77.1zM0 440c0-4.4 3.6-8 8-8H568c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8z"],
    "lacrosse-stick": [512, 512, [], "e3b5", "M344 16c-51.2 0-96.7 32.8-112.9 81.4l-.6 1.8c-6.4 19.2-13.6 40.9-29 59.7l-34.4 42c-15 18.3-23.1 41.2-23.1 64.8C144 322.2 189.8 368 246.3 368c23.6 0 46.5-8.2 64.8-23.1l42-34.4c18.8-15.4 40.5-22.6 59.6-29l1.1-.4 0 0 .8-.3C463.2 264.7 496 219.2 496 168v0l0-.2 0-.1c0-34.8-21.6-72.7-50.3-101.4C417 37.6 379.2 16 344.4 16l-.3 0-.1 0zm0-16l.3 0C385.1 0 426.8 24.8 457 55s55 71.9 55 112.7l0 .3c0 58.1-37.2 109.7-92.3 128.1l-.8 .3c-19.8 6.6-39.1 13-55.6 26.5l-42 34.4c-21.1 17.3-47.6 26.7-74.9 26.7c-29.8 0-57-11-77.8-29.2L13.7 509.7c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L157.2 343.5c-18.2-20.8-29.2-48-29.2-77.8c0-27.3 9.5-53.8 26.7-74.9l34.4-42c13.5-16.5 19.9-35.8 26.5-55.6l0 0 .3-.8C234.3 37.2 285.9 0 344 0z"],
    "hockey-mask": [448, 512, [], "f6ee", "M16 240c0-62.1 15.4-118.1 48.4-158.2C96.9 42.1 148 16 224 16s127.1 26.1 159.6 65.8C416.6 121.9 432 177.9 432 240c0 95.7-12.2 158.8-42.7 198.2C359.8 476.4 310 496 224 496s-135.8-19.6-165.3-57.8C28.2 398.8 16 335.7 16 240zM224 0C64 0 0 111 0 240C0 432 48 512 224 512s224-80 224-272C448 111 384 0 224 0zM176 224c0 26.5-21.5 48-48 48s-48-21.5-48-48V208c0-8.8 7.2-16 16-16h64c8.8 0 16 7.2 16 16v16zm-48 64c35.3 0 64-28.7 64-64V208c0-17.7-14.3-32-32-32H96c-17.7 0-32 14.3-32 32v16c0 35.3 28.7 64 64 64zm192-16c-26.5 0-48-21.5-48-48V208c0-8.8 7.2-16 16-16h64c8.8 0 16 7.2 16 16v16c0 26.5-21.5 48-48 48zm64-48V208c0-17.7-14.3-32-32-32H288c-17.7 0-32 14.3-32 32v16c0 35.3 28.7 64 64 64s64-28.7 64-64zM160 112a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80 16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM208 320a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm0 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-16 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm64 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-64a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-64a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM304 96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "sunrise": [576, 512, [127749], "f766", "M282.3 2.3c3.1-3.1 8.2-3.1 11.3 0l88 88c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L296 27.3V216c0 4.4-3.6 8-8 8s-8-3.6-8-8V27.3l-74.3 74.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l88-88zM182.5 225.2c5-2.1 10.7-1.5 15.2 1.6L288 289.1l90.3-62.3c4.5-3.1 10.2-3.7 15.2-1.6s8.6 6.6 9.6 11.9L423 345l107.9 19.8c5.3 1 9.8 4.6 11.9 9.6s1.5 10.7-1.6 15.2L489.9 464H470.5L528 380.6 414.7 359.8c-3.3-.6-5.8-3.2-6.4-6.4L387.4 240l-94.9 65.4c-2.7 1.9-6.3 1.9-9.1 0L188.6 240 167.8 353.3c-.6 3.3-3.2 5.8-6.4 6.4L48 380.6 105.5 464H86.1L34.8 389.7c-3.1-4.5-3.7-10.2-1.6-15.2s6.6-8.6 11.9-9.6L153 345l19.8-107.9c1-5.3 4.6-9.8 9.6-11.9zM398.9 464H382.7c-7.6-45.4-47.1-80-94.7-80s-87.1 34.6-94.7 80H177.1c7.8-54.3 54.4-96 110.9-96s103.1 41.7 110.9 96zM8 496H568c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "panel-ews": [512, 512, [], "e42e", "M64 16H448c26.5 0 48 21.5 48 48V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V304c30.9 0 56 25.1 56 56v32c0 30.9 25.1 56 56 56s56-25.1 56-56V352h24c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32H144c-17.7 0-32 14.3-32 32v64c0 17.7 14.3 32 32 32h24v40c0 22.1-17.9 40-40 40s-40-17.9-40-40V360c0-39.8-32.2-72-72-72V64c0-26.5 21.5-48 48-48zM0 296V448c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64V296zM96 80c-4.4 0-8 3.6-8 8s3.6 8 8 8H224c4.4 0 8-3.6 8-8s-3.6-8-8-8H96zm192 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H416c4.4 0 8-3.6 8-8s-3.6-8-8-8H288zM96 144c-4.4 0-8 3.6-8 8s3.6 8 8 8H224c4.4 0 8-3.6 8-8s-3.6-8-8-8H96zm192 0c-4.4 0-8 3.6-8 8s3.6 8 8 8H416c4.4 0 8-3.6 8-8s-3.6-8-8-8H288zM208 336H176 144c-8.8 0-16-7.2-16-16V256c0-8.8 7.2-16 16-16h64c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16zm112-96h64c8.8 0 16 7.2 16 16V416c0 8.8-7.2 16-16 16H320c-8.8 0-16-7.2-16-16V256c0-8.8 7.2-16 16-16zm-32 16V416c0 17.7 14.3 32 32 32h64c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32H320c-17.7 0-32 14.3-32 32z"],
    "torii-gate": [512, 512, [9961], "f6a1", "M16 96c0 26.5 21.5 48 48 48H88 424h24c26.5 0 48-21.5 48-48V17.2L450.6 35.4c-20.8 8.3-43 12.6-65.4 12.6H126.8c-22.4 0-44.6-4.3-65.4-12.6L16 17.2V96zm64 64H64C28.7 160 0 131.3 0 96V13.4C0 6 6 0 13.4 0c1.7 0 3.4 .3 5 1l49 19.6C86.3 28.1 106.5 32 126.8 32H385.2c20.4 0 40.5-3.9 59.4-11.4L493.6 1c1.6-.6 3.3-1 5-1C506 0 512 6 512 13.4V96c0 35.3-28.7 64-64 64H432v80h72c4.4 0 8 3.6 8 8s-3.6 8-8 8H432V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V256l-160 0L96 256V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V256H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H80V160zm336 0H264v80l152 0V160zm-168 0H96v80l152 0V160z"],
    "cloud-exclamation": [640, 512, [], "e491", "M522.7 220.8c3.4-8.9 5.3-18.6 5.3-28.8c0-44.2-35.8-80-80-80c-16.5 0-31.7 5-44.4 13.5c-3.7 2.5-8.2 3.3-12.5 2.3s-8-3.8-10.2-7.6C355.9 77 309.3 48 256 48c-79.5 0-144 64.5-144 144c0 2.5 .1 4.9 .2 7.3c.4 7.1-4 13.5-10.7 15.9C51.7 232.7 16 280.2 16 336c0 70.7 57.3 128 128 128H512c61.9 0 112-50.1 112-112c0-54.2-38.5-99.4-89.6-109.8c-4.6-.9-8.6-3.9-10.9-8s-2.6-9.1-.9-13.4zM256 32c53.6 0 101 26.3 130 66.7c3.1 4.3 6 8.8 8.7 13.4c3.5-2.4 7.2-4.5 11-6.4C418.5 99.5 432.8 96 448 96c53 0 96 43 96 96c0 6.6-.7 13-1.9 19.2c-1.1 5.3-2.6 10.5-4.5 15.4c5.3 1.1 10.5 2.5 15.5 4.2C603.6 247.9 640 295.7 640 352c0 70.7-57.3 128-128 128H144C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160zm64 128c4.4 0 8 3.6 8 8V328c0 4.4-3.6 8-8 8s-8-3.6-8-8V168c0-4.4 3.6-8 8-8zM304 384a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "message-lines": [512, 512, ["comment-alt-lines"], "f4a6", "M176 416c0-8.8-7.2-16-16-16H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H448c26.5 0 48 21.5 48 48V352c0 26.5-21.5 48-48 48H309.3c-3.5 0-6.8 1.1-9.6 3.2L176 496V416zM64 0C28.7 0 0 28.7 0 64V352c0 35.3 28.7 64 64 64h80 16v16 64c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416H448c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zm72 152c-4.4 0-8 3.6-8 8s3.6 8 8 8H376c4.4 0 8-3.6 8-8s-3.6-8-8-8H136zm0 96c-4.4 0-8 3.6-8 8s3.6 8 8 8H280c4.4 0 8-3.6 8-8s-3.6-8-8-8H136z"],
    "frog": [576, 512, [], "f52e", "M368 48c-30.9 0-56 25.1-56 56c0 .1 0 .3 0 .4c-.2 3.7-2.9 6.8-6.5 7.4L241.3 124C110.6 148.7 16 262.9 16 396v28c0 22.1 17.9 40 40 40H344c13.3 0 24-10.7 24-24s-10.7-24-24-24H304.1c-1.8 0-3.6-.6-5.1-1.8c-3.5-2.8-4-7.8-1.2-11.2l6.9-8.6 7-8.7c10.6-13.3 16.4-29.8 16.4-46.8v-3.7c0-19.5-7.9-37.2-20.6-50.1c-12.9-13-30.8-21.1-50.6-21.1c-18.9 0-37 7.5-50.3 20.9l-40.8 40.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l40.8-40.8c16.4-16.4 38.5-25.5 61.7-25.5c19.1 0 36.8 6.1 51.1 16.5c21.9 15.8 36.1 41.6 36.1 70.7v3.7c0 20.6-7 40.7-19.9 56.8l-3.4 4.3H344c22.1 0 40 17.9 40 40s-17.9 40-40 40H56c-30.9 0-56-25.1-56-56V396C0 255.3 100.1 134.4 238.4 108.3l57.9-11C299.7 60.7 330.5 32 368 32c39.2 0 71.1 31.4 72 70.4c39.6 7 74 18.4 97.6 27.6c24.3 9.5 38.4 33.2 38.4 58.5c0 24.9-13.6 47.7-35.4 59.6L404.2 322.5 515.9 464H568c4.4 0 8 3.6 8 8s-3.6 8-8 8H512c-2.4 0-4.8-1.1-6.3-3l-120-152c-1.5-1.8-2-4.2-1.6-6.6s1.9-4.3 4-5.4l144.8-79c16.7-9.1 27.1-26.6 27.1-45.6c0-19.5-10.8-36.8-28.2-43.6c-24.3-9.5-60.1-21.3-101.2-27.8c-4.1-.7-7-4.4-6.7-8.5c.1-1.5 .2-3 .2-4.5c0-30.9-25.1-56-56-56zm0 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "bucket": [448, 512, [], "e4cf", "M80 136v24c0 4.4-3.6 8-8 8s-8-3.6-8-8V136C64 60.9 124.9 0 200 0h48c75.1 0 136 60.9 136 136v16c0 4.4-3.6 8-8 8s-8-3.6-8-8V136c0-66.3-53.7-120-120-120H200C133.7 16 80 69.7 80 136zM0 200c0-4.4 3.6-8 8-8H24 40.1 407.9 424h16c4.4 0 8 3.6 8 8s-3.6 8-8 8H422L389.3 470c-3 24-23.4 42-47.6 42H106.4c-24.2 0-44.6-18-47.6-42L26 208H8c-4.4 0-8-3.6-8-8zm42.1 8L74.6 468c2 16 15.6 28 31.8 28H341.6c16.1 0 29.8-12 31.8-28l32.5-260H42.1z"],
    "floppy-disk-pen": [576, 512, [], "e182", "M16 96V416c0 26.5 21.5 48 48 48H262.2l-4 16H64c-35.3 0-64-28.7-64-64V96C0 60.7 28.7 32 64 32H309.5c17 0 33.3 6.7 45.3 18.7l74.5 74.5c12 12 18.7 28.3 18.7 45.3v64.8l-16 16V170.5c0-12.7-5.1-24.9-14.1-33.9L343.4 62.1C337 55.6 328.8 51.1 320 49.2V160c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V48C37.5 48 16 69.5 16 96zM80 48V160c0 8.8 7.2 16 16 16H288c8.8 0 16-7.2 16-16V48H80zm72 280a72 72 0 1 0 144 0 72 72 0 1 0 -144 0zm72 88a88 88 0 1 1 0-176 88 88 0 1 1 0 176zm68.7 91.3c-4-4-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9L493.2 235.8c15.6-15.6 40.9-15.6 56.6 0l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6L382.9 488.1c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2zm15.7-28.9L304 496l17.6-4.4L364.1 481c2.8-.7 5.4-2.2 7.4-4.2L514.4 333.9l-48.3-48.3L323.2 428.4c-2 2-3.5 4.6-4.2 7.4l-10.6 42.5zM552.8 295.5c9.4-9.4 9.4-24.6 0-33.9l-14.4-14.4c-9.4-9.4-24.6-9.4-33.9 0l-27.1 27.1 48.3 48.3 27.1-27.1z"],
    "image": [512, 512, [], "f03e", "M64 48C37.5 48 16 69.5 16 96V356.7l89.4-89.4c12.5-12.5 32.8-12.5 45.3 0L224 340.7 361.4 203.3c12.5-12.5 32.8-12.5 45.3 0L496 292.7V96c0-26.5-21.5-48-48-48H64zM16 379.3V416c0 26.5 21.5 48 48 48h36.7l112-112-73.4-73.4c-6.2-6.2-16.4-6.2-22.6 0L16 379.3zM395.3 214.6c-6.2-6.2-16.4-6.2-22.6 0L123.3 464H448c26.5 0 48-21.5 48-48V315.3L395.3 214.6zM0 96C0 60.7 28.7 32 64 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm168 64a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm-96 0a56 56 0 1 1 112 0A56 56 0 1 1 72 160z"],
    "window-frame": [512, 512, [129695], "e04f", "M248 256V496H48V256H248zm16 240V256H464V496H264zm216 0V64c0-35.3-28.7-64-64-64H96C60.7 0 32 28.7 32 64V496H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H32 48 464h16 24c4.4 0 8-3.6 8-8s-3.6-8-8-8H480zM464 240H264V16H416c26.5 0 48 21.5 48 48V240zM96 16H248V240H48V64c0-26.5 21.5-48 48-48z"],
    "microphone": [384, 512, [], "f130", "M272 96V256c0 44.2-35.8 80-80 80s-80-35.8-80-80V96c0-44.2 35.8-80 80-80s80 35.8 80 80zM96 96V256c0 53 43 96 96 96s96-43 96-96V96c0-53-43-96-96-96S96 43 96 96zM48 200c0-4.4-3.6-8-8-8s-8 3.6-8 8v56c0 85.7 67.4 155.6 152 159.8V496H104c-4.4 0-8 3.6-8 8s3.6 8 8 8h88 88c4.4 0 8-3.6 8-8s-3.6-8-8-8H200V415.8c84.6-4.2 152-74.1 152-159.8V200c0-4.4-3.6-8-8-8s-8 3.6-8 8v56c0 79.5-64.5 144-144 144s-144-64.5-144-144V200z"],
    "cow": [640, 512, [128004], "f6c8", "M120 80c-30.9 0-56 25.1-56 56v88 8 8 28.8C64 297.1 41.1 320 12.8 320C5.7 320 0 314.3 0 307.2V288c0-29.8 20.4-54.9 48-62V136c0-39.8 32.2-72 72-72h48 16H423.6c33 0 64 15.6 83.6 42.1l60.3 81.4c5.9-7 14.7-11.4 24.5-11.4c17.7 0 32 14.3 32 32v55.8l8.1 11c5.1 6.9 7.9 15.2 7.9 23.8V392c0 30.9-25.1 56-56 56c-17.6 0-34.2-8.3-44.8-22.4L488 357.3c-5.2-6.9-8-15.3-8-24V284.3l-32-21.3V416c0 17.7-14.3 32-32 32H368c-17.7 0-32-14.3-32-32V362l-6.7 1.5c-8.4 1.9-16.8 3.3-25.3 4.3c0 .1 0 .1 0 .2v16c0 4.4-3.6 8-8 8s-8-3.6-8-8V369.3c-10.7 .6-21.3 .6-32 0V384c0 4.4-3.6 8-8 8s-8-3.6-8-8V368c0-.1 0-.1 0-.2c-8.5-1-16.9-2.5-25.3-4.3L208 362v54c0 17.7-14.3 32-32 32H128c-17.7 0-32-14.3-32-32V136c0-22.6 10.4-42.8 26.7-56H120zm88 265.6l10.2 2.3c35.4 7.9 72.2 7.9 107.6 0l10.2-2.3V328c0-35.3-28.7-64-64-64s-64 28.7-64 64v17.6zm-48-265c.1 23.2 9.3 45.5 25.8 61.9l3.1 3.1c19.5 19.5 46 30.5 73.5 30.5h3.2c27.6 0 54-11 73.5-30.5l3.1-3.1C358.7 126 368 103.6 368 80.2V80H184 168c-2.7 0-5.4 .2-8 .6zm-15.9 4.8c-19 9-32.1 28.3-32.1 50.7V416c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V328c0-44.2 35.8-80 80-80s80 35.8 80 80v88c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V248c0-3 1.6-5.7 4.2-7.1s5.8-1.2 8.2 .4l48 32c2.2 1.5 3.6 4 3.6 6.7v53.3c0 5.2 1.7 10.2 4.8 14.4L552 416c7.6 10.1 19.4 16 32 16c22.1 0 40-17.9 40-40V298.6c0-5.1-1.7-10.2-4.7-14.3l-9.7-13.1c-1-1.4-1.6-3-1.6-4.8V208c0-8.8-7.2-16-16-16c-7.6 0-13.9 5.2-15.6 12.3c-.7 3-3.1 5.4-6.2 6s-6.2-.6-8-3.1l-67.9-91.6C477.8 93.2 451.5 80 423.6 80H384v.2c0 27.6-11 54-30.5 73.5l-3.1 3.1c-22.5 22.5-53 35.1-84.9 35.1h-3.2c-31.8 0-62.3-12.6-84.9-35.1l-3.1-3.1c-18.3-18.3-29.1-42.7-30.3-68.4zM16 288v15.9c17.9-1.6 32-16.7 32-35.1V242.7c-18.6 6.6-32 24.4-32 45.3zm536 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "file-zip": [512, 512, [], "e5ee", "M176 496H64c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V304h16V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H176V496zM361.1 160H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3c.9 .9 1.7 1.8 2.4 2.7zM240 368c-4.4 0-8 3.6-8 8s3.6 8 8 8h51.1L232.8 500.4c-1.2 2.5-1.1 5.4 .4 7.8s4 3.8 6.8 3.8h64c4.4 0 8-3.6 8-8s-3.6-8-8-8H252.9l58.2-116.4c1.2-2.5 1.1-5.4-.4-7.8s-4-3.8-6.8-3.8H240zm136 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V376zm48 0v80 48c0 4.4 3.6 8 8 8s8-3.6 8-8V464h16c26.5 0 48-21.5 48-48s-21.5-48-48-48H432c-4.4 0-8 3.6-8 8zm16 72V384h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H440z"],
    "square-ring": [448, 512, [], "e44f", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm160 80a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 304a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM144 256a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zm176 0a96 96 0 1 0 -192 0 96 96 0 1 0 192 0z"],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", "M184 460.7c2.1 2.1 5 3.3 8 3.3s5.9-1.2 8-3.3L331.8 328.6c2.7-2.7 4.2-6.4 4.2-10.2c0-8-6.5-14.4-14.4-14.4H248c-4.4 0-8-3.6-8-8V160c0-8.8-7.2-16-16-16H160c-8.8 0-16 7.2-16 16V296c0 4.4-3.6 8-8 8H62.4c-8 0-14.4 6.5-14.4 14.4c0 3.8 1.5 7.5 4.2 10.2L184 460.7zm8 19.3c-7.2 0-14.2-2.9-19.3-8L40.9 339.9c-5.7-5.7-8.9-13.4-8.9-21.5C32 301.6 45.6 288 62.4 288H128V160c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32V288h65.6c16.8 0 30.4 13.6 30.4 30.4c0 8.1-3.2 15.8-8.9 21.5L211.3 472c-5.1 5.1-12.1 8-19.3 8zM8 32H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H8c-4.4 0-8-3.6-8-8s3.6-8 8-8z"],
    "caret-up": [320, 512, [], "f0d8", "M144.6 150.6c4-4.2 9.6-6.6 15.4-6.6s11.4 2.4 15.4 6.6L300.5 282.7c2.2 2.3 3.5 5.4 3.5 8.7c0 7-5.6 12.6-12.6 12.6H28.6c-7 0-12.6-5.6-12.6-12.6c0-3.2 1.2-6.3 3.5-8.7L144.6 150.6zm-11.6-11L7.8 271.7C2.8 277 0 284.1 0 291.4C0 307.2 12.8 320 28.6 320H291.4c15.8 0 28.6-12.8 28.6-28.6c0-7.3-2.8-14.4-7.8-19.7L187 139.6c-7-7.4-16.8-11.6-27-11.6s-20 4.2-27 11.6z"],
    "shield-xmark": [512, 512, ["shield-times"], "e24c", "M237.3 22.6c12-5.1 25.5-5.1 37.5 0l176.7 75c16.6 7.1 28.6 23.2 28.5 42.4c-.5 96.6-40.3 270.2-204.5 348.8c-12.3 5.9-26.7 5.9-39 0C72.3 410.1 32.5 236.5 32 139.9c-.1-19.1 11.9-35.3 28.5-42.4l176.7-75zM281 7.8c-16-6.8-34-6.8-50 0L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c16.7 8 36.1 8 52.8 0C454.8 420.7 495.5 239.2 496 140c.1-26.2-16.3-47.9-38.3-57.2L281 7.8zM178.3 178.3c-3.1 3.1-3.1 8.2 0 11.3L244.7 256l-66.3 66.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L256 267.3l66.3 66.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L267.3 256l66.3-66.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L256 244.7l-66.3-66.3c-3.1-3.1-8.2-3.1-11.3 0z"],
    "screwdriver": [512, 512, [129691], "f54a", "M465 7l40 40c8.5 8.5 9.4 22 2.1 31.6l-80 104c-4.5 5.9-11.6 9.4-19 9.4H344h-8-4.7l-72.6 72.6c-1.7-2-3.6-4-5.5-5.9s-3.9-3.7-5.9-5.5L320 180.7V176v-8V104c0-7.5 3.5-14.5 9.4-19l104-80C442.9-2.4 456.4-1.5 465 7zM336 176h8 64c2.5 0 4.8-1.2 6.3-3.1l80-104c2.4-3.2 2.2-7.7-.7-10.5l-40-40c-2.8-2.8-7.4-3.1-10.5-.7l-104 80c-2 1.5-3.1 3.9-3.1 6.3v64 8zM219.3 292.7c-23.9-23.9-62.7-23.9-86.6 0l-112 112c-6.2 6.2-6.2 16.4 0 22.6l64 64c6.2 6.2 16.4 6.2 22.6 0l112-112c23.9-23.9 23.9-62.7 0-86.6zM9.4 438.6c-12.5-12.5-12.5-32.8 0-45.3l112-112c30.2-30.2 79.1-30.2 109.3 0s30.2 79.1 0 109.3l-112 112c-12.5 12.5-32.8 12.5-45.3 0l-64-64z"],
    "circle-sort-down": [512, 512, ["sort-circle-down"], "e031", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM267.3 411.3c-6.2 6.2-16.4 6.2-22.6 0l-96-96c-4.6-4.6-5.9-11.5-3.5-17.4s8.3-9.9 14.8-9.9H352c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-96 96zM352 304H160l96 96 96-96zM267.3 100.7l96 96c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-96-96-96 96c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l96-96c6.2-6.2 16.4-6.2 22.6 0z"],
    "folder-closed": [512, 512, [], "e185", "M448 464H64c-26.5 0-48-21.5-48-48V192H496V416c0 26.5-21.5 48-48 48zm48-288H16V96c0-26.5 21.5-48 48-48H197.5c12.7 0 24.9 5.1 33.9 14.1l35.9 35.9c9 9 21.2 14.1 33.9 14.1H448c26.5 0 48 21.5 48 48v16zM64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H301.3c-8.5 0-16.6-3.4-22.6-9.4L242.7 50.7c-12-12-28.3-18.7-45.3-18.7H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64z"],
    "house-tsunami": [576, 512, [], "e515", "M16 200C16 98.8 102.6 16 210.3 16c22.4 0 44 3.6 64 10.2c4.2 1.4 8.7-.9 10.1-5.1s-.9-8.7-5.1-10.1c-21.6-7.1-44.9-11-69-11C94.6 0 0 89.2 0 200C0 309.8 74 400 190.9 400c.4 0 .8 0 1.1-.1v.1c28.7 0 54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8l0 0 0 0c5.2 6.4 13.3 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8c4.7 5.8 11.8 13.9 20.6 22.2c16.4 15.4 39.9 32.8 66.4 36.1c4.4 .6 8.4-2.6 8.9-6.9s-2.6-8.4-6.9-8.9c-21.3-2.7-41.7-17.1-57.4-31.9c-9.1-8.6-17.7-18-25-28.3c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.9 11.2-17.5 21.5-27.6 30.7C428.6 369.8 406.5 384 384 384s-44.6-14.2-61.8-29.9c-10.1-9.2-19.6-19.5-27.6-30.7c-3-4.3-10.2-4.3-13.2 0c-8 11.2-17.5 21.4-27.6 30.7C236.6 369.8 214.5 384 192 384v.1c-.4-.1-.8-.1-1.1-.1C84.2 384 16 302.3 16 200zm326.4-68.8l96-72c5.7-4.3 13.5-4.3 19.2 0l95.5 71.9c4 3 6.4 7.7 6.4 12.7l.3 146.5c5.7 1.5 11.1 3.6 16 6.5l-.3-153c0-10-4.7-19.5-12.7-25.5L467.2 46.5c-11.4-8.6-27.1-8.6-38.5 0l-96 72c-8.1 6-12.8 15.5-12.8 25.6V265c1.6 1 3.3 2 4.8 3.1c3.6 2.5 7.4 4.8 11.2 6.9V144c0-5 2.4-9.8 6.4-12.8zM294.6 435.4c-3-4.3-10.2-4.3-13.2 0c-8 11.2-17.5 21.4-27.6 30.7C236.6 481.8 214.5 496 192 496s-44.6-14.2-61.8-29.9c-10.1-9.2-19.7-19.5-27.6-30.7c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.3 10.3-15.9 19.6-25 28.3C48.7 478.5 28.3 492.9 7 495.6c-4.4 .6-7.5 4.6-6.9 8.9s4.6 7.5 8.9 6.9c26.5-3.3 50-20.7 66.4-36.1c8.8-8.3 15.9-16.4 20.6-22.2c5.2 6.4 13.2 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8l0 0 0 0c5.2 6.4 13.3 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8c4.7 5.8 11.8 13.9 20.6 22.2c16.4 15.4 39.9 32.8 66.4 36.1c4.4 .6 8.4-2.6 8.9-6.9s-2.6-8.4-6.9-8.9c-21.3-2.7-41.7-17.1-57.4-31.9c-9.1-8.6-17.7-18-25-28.3c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.9 11.2-17.5 21.5-27.6 30.7C428.6 481.8 406.5 496 384 496s-44.6-14.2-61.8-29.9c-10.1-9.2-19.6-19.5-27.6-30.7zM190 112c16.7 0 32.6 3.5 46.7 9.8c4 1.8 8.8 0 10.6-4.1s0-8.8-4.1-10.6C227.1 100 209 96 190 96C120.8 96 64 149.3 64 216s56.8 120 126 120c4.4 0 8-3.6 8-8s-3.6-8-8-8c-61.2 0-110-47-110-104s48.9-104 110-104z"],
    "square-nfi": [448, 512, [], "e576", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm79 68.2l81 148.5V168c0-4.4 3.6-8 8-8s8 3.6 8 8V344c0 3.7-2.5 6.8-6 7.8s-7.2-.7-9-3.9L80 199.4V344c0 4.4-3.6 8-8 8s-8-3.6-8-8V168c0-3.7 2.5-6.8 6-7.8s7.2 .7 9 3.9zM240 160h72c4.4 0 8 3.6 8 8s-3.6 8-8 8H248v48h64c4.4 0 8 3.6 8 8s-3.6 8-8 8H248V344c0 4.4-3.6 8-8 8s-8-3.6-8-8V232 168c0-4.4 3.6-8 8-8zm144 8V344c0 4.4-3.6 8-8 8s-8-3.6-8-8V168c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "forklift": [640, 512, [], "f47a", "M144 40c0-13.3 10.7-24 24-24H268.5c9 0 17.2 5 21.3 13l103 198.7c2 3.9 6.9 5.5 10.8 3.4s5.5-6.9 3.4-10.8L304.1 21.6C297.2 8.3 283.5 0 268.5 0H168c-22.1 0-40 17.9-40 40v88c0 4.4 3.6 8 8 8s8-3.6 8-8V40zM96 336a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176c53 0 96-43 96-96h64c0 53 43 96 96 96s96-43 96-96c0-28.4-12.4-54-32-71.6V296c0-22.1-17.9-40-40-40H264L159.3 172.3c-9.9-7.9-22.3-12.3-35-12.3H64c-35.3 0-64 28.7-64 64V400v16c0 53 43 96 96 96zm0-192c-33.4 0-62.8 17-80 42.9V224c0-26.5 21.5-48 48-48h60.4c9.1 0 17.9 3.1 25 8.8L254 268.5c2.8 2.3 6.4 3.5 10 3.5H376c13.3 0 24 10.7 24 24v36.8l0 0c-14.1-8.2-30.5-12.8-48-12.8c-47.6 0-87.1 34.6-94.7 80H190.7c-7.6-45.4-47.1-80-94.7-80zm256 16a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM496 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V440c0 4.4 3.6 8 8 8H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H496V8z"],
    "arrow-up-from-ground-water": [576, 512, [], "e4b5", "M288 352c4.4 0 8-3.6 8-8V27.3l82.3 82.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-96-96c-3.1-3.1-8.2-3.1-11.3 0l-96 96c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L280 27.3V344c0 4.4 3.6 8 8 8zM64 192c-35.3 0-64 28.7-64 64V425c4.9-2.8 10.3-5 16-6.5V256c0-26.5 21.5-48 48-48H192V192H64zM576 425V256c0-35.3-28.7-64-64-64H384v16H512c26.5 0 48 21.5 48 48V418.5c5.7 1.5 11.1 3.7 16 6.5zM294.6 435.4c-3-4.3-10.2-4.3-13.2 0c-8 11.2-17.5 21.4-27.6 30.7C236.6 481.8 214.5 496 192 496s-44.6-14.2-61.8-29.9c-10.1-9.2-19.7-19.5-27.6-30.7c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.3 10.3-15.9 19.6-25 28.3C48.7 478.5 28.3 492.9 7 495.6c-4.4 .6-7.5 4.6-6.9 8.9s4.6 7.5 8.9 6.9c26.5-3.3 50-20.7 66.4-36.1c8.8-8.3 15.9-16.4 20.6-22.2c5.2 6.4 13.2 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8l0 0 0 0c5.2 6.4 13.3 15.6 23.4 24.8c18 16.3 43.9 34.1 72.6 34.1s54.6-17.8 72.6-34.1c10.2-9.2 18.2-18.4 23.4-24.8c4.7 5.8 11.8 13.9 20.6 22.2c16.4 15.4 39.9 32.8 66.4 36.1c4.4 .6 8.4-2.6 8.9-6.9s-2.6-8.4-6.9-8.9c-21.3-2.7-41.7-17.1-57.4-31.9c-9.1-8.6-17.7-18-25-28.3c-1.5-2.1-3.9-3.4-6.6-3.4s-5.1 1.3-6.6 3.4c-7.9 11.2-17.5 21.5-27.6 30.7C428.6 481.8 406.5 496 384 496s-44.6-14.2-61.8-29.9c-10.1-9.2-19.6-19.5-27.6-30.7z"],
    "bracket-square-right": [192, 512, [], "5d", "M192 72c0-22.1-17.9-40-40-40H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H152c13.3 0 24 10.7 24 24V440c0 13.3-10.7 24-24 24H40c-4.4 0-8 3.6-8 8s3.6 8 8 8H152c22.1 0 40-17.9 40-40V72z"],
    "martini-glass": [512, 512, [127864, "glass-martini-alt"], "f57b", "M16 25.5c0-5.3 4.3-9.5 9.5-9.5H486.5c5.3 0 9.5 4.3 9.5 9.5c0 2.5-1 5-2.8 6.7L397.5 128h-283L18.8 32.3C17 30.5 16 28.1 16 25.5zM130.5 144h251L256 269.5 130.5 144zM7.5 43.6L248 284.1V496H136c-4.4 0-8 3.6-8 8s3.6 8 8 8H256 376c4.4 0 8-3.6 8-8s-3.6-8-8-8H264V284.1L504.5 43.6c4.8-4.8 7.5-11.3 7.5-18.1C512 11.4 500.6 0 486.5 0H25.5C11.4 0 0 11.4 0 25.5c0 6.8 2.7 13.3 7.5 18.1z"],
    "rotate-left": [512, 512, ["rotate-back", "rotate-backward", "undo-alt"], "f2ea", "M419.9 384.1c-70.7 90.5-201.4 106.6-292 35.8C105 402 86.9 380.2 73.7 356.3c-2.1-3.9-7-5.3-10.9-3.2s-5.3 7-3.2 10.9c14.2 25.8 33.7 49.3 58.4 68.6c97.5 76.2 238.3 58.9 314.4-38.6s58.9-238.3-38.6-314.4C304.1 9.3 177.5 18.5 98.6 96.6l11.3 11.3c73.3-72.5 190.8-81 274.2-15.8c90.5 70.7 106.6 201.4 35.8 292zM32 192c-4.4 0-8-3.6-8-8V64c0-3.2 1.9-6.2 4.9-7.4s6.4-.6 8.7 1.7l120 120c2.3 2.3 3 5.7 1.7 8.7s-4.2 4.9-7.4 4.9H32zm120 16c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2L49 47c-6.9-6.9-17.2-8.9-26.2-5.2S8 54.3 8 64V184c0 13.3 10.7 24 24 24H152z"],
    "table-columns": [512, 512, ["columns"], "f0db", "M16 96c0-26.5 21.5-48 48-48l384 0c26.5 0 48 21.5 48 48l0 64L16 160l0-64zm0 320l0-240 232 0 0 288L64 464c-26.5 0-48-21.5-48-48zm248 48l0-288 232 0 0 240c0 26.5-21.5 48-48 48l-184 0zM0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416z"],
    "square-a": [448, 512, [], "e25f", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zm224 32c3 0 5.8 1.7 7.2 4.4l120 240c2 4 .4 8.8-3.6 10.7s-8.8 .4-10.7-3.6L307.1 320H140.9l-29.8 59.6c-2 4-6.8 5.6-10.7 3.6s-5.6-6.8-3.6-10.7l120-240c1.4-2.7 4.1-4.4 7.2-4.4zm0 25.9L148.9 304H299.1L224 153.9z"],
    "tick": [128, 512, [], "e32f", "M16 96c0-26.5 21.5-48 48-48s48 21.5 48 48v7.9c0 4.2-.5 8.3-1.4 12.4L77.7 261.1C76.3 267.5 70.6 272 64 272s-12.3-4.5-13.7-10.9L17.4 116.3c-.9-4.1-1.4-8.2-1.4-12.4V96zM0 96v7.9c0 5.4 .6 10.7 1.8 15.9L34.7 264.6C37.8 278.3 50 288 64 288s26.2-9.7 29.3-23.4l32.9-144.7c1.2-5.2 1.8-10.6 1.8-15.9V96c0-35.3-28.7-64-64-64S0 60.7 0 96z"],
    "lemon": [448, 512, [127819], "f094", "M368 48c-7.6 0-14.9 1.3-21.6 3.7c-17.8 6.4-39.6 11.3-61.3 6.5c-67.2-15-140.6 12.3-193.5 65.3s-80.2 126.4-65.3 193.5c4.8 21.7-.1 43.4-6.5 61.3c-2.4 6.7-3.7 14-3.7 21.6c0 35.3 28.7 64 64 64c7.6 0 14.9-1.3 21.6-3.7c17.8-6.4 39.6-11.3 61.3-6.5c67.2 15 140.6-12.3 193.5-65.3s80.2-126.4 65.3-193.5c-4.8-21.7 .1-43.4 6.5-61.3c2.4-6.7 3.7-14 3.7-21.6c0-35.3-28.7-64-64-64zm0-16c44.2 0 80 35.8 80 80c0 9.5-1.7 18.6-4.7 27.1c-6 16.7-9.8 35-5.9 52.4c16.4 73.7-13.7 152.4-69.6 208.3s-134.7 86-208.3 69.6c-17.3-3.9-35.7-.1-52.4 5.9c-8.4 3-17.6 4.7-27.1 4.7c-44.2 0-80-35.8-80-80c0-9.5 1.7-18.6 4.7-27.1c6-16.7 9.8-35 5.9-52.4C-5.8 246.9 24.3 168.2 80.2 112.2s134.7-86 208.3-69.6c17.3 3.9 35.7 .1 52.4-5.9c8.4-3 17.6-4.7 27.1-4.7zM219.1 119.4l-16.9 7.1c-48.7 20.3-87.4 59-107.7 107.7l-7.1 16.9c-1.7 4.1-6.4 6-10.5 4.3s-6-6.4-4.3-10.5L79.7 228c21.9-52.6 63.7-94.4 116.3-116.3l16.9-7.1c4.1-1.7 8.8 .2 10.5 4.3s-.2 8.8-4.3 10.5z"],
    "head-side-mask": [576, 512, [], "e063", "M48 222.9c0-21.2 3.2-41.6 9.1-60.8L256 287.4v.6V480c0 17.7 14.3 32 32 32H431.7c28.6 0 53.7-18.9 61.5-46.4l46.3-162.2c1.4-5.1 2.5-10.2 3.3-15.4c.7-5.3 1.1-10.6 1.1-16h-.1c-1-13.5-7.2-26.1-17.4-35.2l-3.8-3.4c-16.7-14.9-29.2-33.6-40-54.4c-7-13.4-13.1-27.1-19.3-41c-3.5-7.9-7.1-15.9-10.8-23.9C421.1 46.9 349.6 0 271.7 0H254.9C131.8 0 32 99.8 32 222.9c0 52.8 16.9 101.5 47.4 139.9C89.5 375.5 96 390.2 96 405.3V504c0 4.4 3.6 8 8 8s8-3.6 8-8V405.3c0-19.8-8.5-37.8-20.1-52.4C63.8 317.5 48 272.3 48 222.9zM261.6 272L62.5 146.6C92.9 70.1 167.6 16 254.9 16h16.8c71.6 0 137.5 43.3 166.4 105c3.5 7.4 6.9 15.1 10.4 22.9c6.4 14.3 12.9 28.9 20.1 42.7c11.3 21.6 24.8 42.2 43.5 58.9l3.8 3.4c6.8 6 11 14.3 11.9 23.2H272 261.6zM272 480V288H526.7c-.6 3.7-1.4 7.4-2.5 11l-15.1 53H368c-4.4 0-8 3.6-8 8s3.6 8 8 8H504.5l-13.7 48H368c-4.4 0-8 3.6-8 8s3.6 8 8 8H486.2l-8.3 29.2C472 481.8 453.2 496 431.7 496H288c-8.8 0-16-7.2-16-16zm96-256a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "handshake": [640, 512, [], "f2b5", "M255.9 64c-32 0-63 11.3-87.5 31.9L144 116.4v20.9l34.7-29.2C200.3 90 227.7 80 255.9 80h21.2L294 64H255.9zM112 336V144 128h-8H96 32c-17.7 0-32 14.3-32 32V368c0 17.7 14.3 32 32 32H80c17.7 0 32-14.3 32-32V352h3.4c12.7 0 24.9 5.1 33.9 14.1l20.6 20.6 15.4 15.4 .1 .1 24.4 24.4c22.1 22.1 57.5 23.1 80.8 2.2c1.2-1.1 2.3-2.2 3.4-3.3l4.8 4.8c22.9 22.9 60.3 21.8 81.9-2.4c7.9-8.8 12.4-19.5 13.8-30.4c20.2 10.8 45.6 8.4 63.6-7.5c11.4-10.1 17.7-23.8 18.6-37.9H528v16c0 17.7 14.3 32 32 32h48c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H544h-8-8v16V336H475.4c-2.2-10.1-7.2-19.6-15.1-27.5L360.8 209 375 195.9c3.2-3 3.4-8.1 .5-11.3s-8.1-3.4-11.3-.5l-76 70.2c-16.3 15-41.3 15.3-57.8 .5c-18.9-16.8-19.3-46.1-1-63.5l87.5-82.9c19.3-18.3 45-28.5 71.6-28.5c24.5 0 48.2 8.6 67 24.4L496 138.5V117.6L465.8 92.2C444.1 74 416.7 64 388.5 64c-30.7 0-60.3 11.8-82.6 32.9l-87.5 82.9c-25.1 23.8-24.5 64 1.4 87c22.7 20.2 57 19.9 79.3-.7l50.1-46.2L449 319.8c16.3 16.3 15.5 42.8-1.7 58.1c-15.8 14-39.8 13.3-54.8-1.6l-1-1c-2.5-2.5-6.3-3.1-9.4-1.4s-4.8 5.2-4.1 8.6c2.4 12-.7 24.9-9.4 34.7c-15.4 17.3-42.2 18.1-58.6 1.7l-11.1-11.1c-1.7-1.7-4-2.5-6.4-2.3s-4.5 1.5-5.9 3.5c-1.9 2.8-4.2 5.4-6.9 7.8c-16.9 15.1-42.7 14.4-58.8-1.6l-39.9-39.9-20.6-20.6c-12-12-28.3-18.7-45.3-18.7H112zM96 144V368c0 8.8-7.2 16-16 16H32c-8.8 0-16-7.2-16-16V160c0-8.8 7.2-16 16-16H96zm512 0c8.8 0 16 7.2 16 16V368c0 8.8-7.2 16-16 16H560c-8.8 0-16-7.2-16-16V144h64z"],
    "gem": [512, 512, [128142], "f3a5", "M128 32c-2.5 0-4.9 1.2-6.4 3.2l-120 160c-2.3 3.1-2.1 7.4 .5 10.2l248 272c1.5 1.7 3.7 2.6 5.9 2.6s4.4-.9 5.9-2.6l248-272c2.6-2.8 2.8-7.1 .5-10.2l-120-160c-1.5-2-3.9-3.2-6.4-3.2H128zm.2 21.1L239.4 192H24L128.2 53.1zM26.1 208H256 485.9L256 460.1 26.1 208zM488 192H272.6L383.8 53.1 488 192zM367.4 48L256 187.2 144.6 48H367.4z"],
    "dolly": [576, 512, ["dolly-box"], "f472", "M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8H96.5c10.5 0 19.7 6.8 22.9 16.8L231.5 388.9C208.3 398.5 192 421.3 192 448c0 35.3 28.7 64 64 64s64-28.7 64-64c0-6.4-.9-12.6-2.7-18.5l253.1-77.9c4.2-1.3 6.6-5.8 5.3-10s-5.8-6.6-10-5.3L310.7 414.8C299.5 396.3 279.2 384 256 384c-3.1 0-6.1 .2-9 .6L134.7 28C129.4 11.3 114 0 96.5 0H8zM256 400a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM356.7 164.1c1.3 4.2 5.8 6.6 10 5.3s6.6-5.8 5.3-10l-16.4-53.5 68.9-21.1c8.5-2.6 17.4 2.2 20 10.6l46.8 153c2.6 8.5-2.2 17.4-10.6 20l-153 46.8c-8.5 2.6-17.4-2.2-20-10.6l-46.8-153c-2.6-8.5 2.2-17.4 10.6-20l68.9-21 16.4 53.5zm-111.1-7.8l46.8 153c5.2 16.9 23.1 26.4 40 21.2l153-46.8c16.9-5.2 26.4-23.1 21.2-40l-46.8-153c-5.2-16.9-23.1-26.4-40-21.2l-153 46.8c-16.9 5.2-26.4 23.1-21.2 40z"],
    "smoking": [640, 512, [128684], "f48d", "M456 0c-4.4 0-8 3.6-8 8V43c0 46.7 18.5 91.4 51.5 124.5l21 21c15 15 23.4 35.4 23.4 56.6v35c0 4.4 3.6 8 8 8s8-3.6 8-8V245c0-25.5-10.1-49.9-28.1-67.9l-21-21C480.9 126.1 464 85.4 464 43V8c0-4.4-3.6-8-8-8zM632 288c4.4 0 8-3.6 8-8V245c0-46.7-18.5-91.4-51.5-124.5l-21-21C552.4 84.5 544 64.2 544 43V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V43c0 25.5 10.1 49.9 28.1 67.9l21 21c30 30 46.9 70.7 46.9 113.1v35c0 4.4 3.6 8 8 8zM48 368H224V496H48c-17.7 0-32-14.3-32-32V400c0-17.7 14.3-32 32-32zm192-16H224 48c-26.5 0-48 21.5-48 48v64c0 26.5 21.5 48 48 48H224h16H480c17.7 0 32-14.3 32-32V384c0-17.7-14.3-32-32-32H240zM480 496H240V368H480c8.8 0 16 7.2 16 16v96c0 8.8-7.2 16-16 16zM640 360c0-4.4-3.6-8-8-8s-8 3.6-8 8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V360zm-88-8c-4.4 0-8 3.6-8 8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V360c0-4.4-3.6-8-8-8zm48 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V360z"],
    "minimize": [512, 512, ["compress-arrows-alt"], "f78c", "M509.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-116 116L329.6 65.6c-6-6-14.6-8.4-22.8-6.3l-.6 .2C295.5 62.1 288 71.7 288 82.7V200c0 13.3 10.7 24 24 24H429.3c11 0 20.6-7.5 23.3-18.2l.2-.6c2-8.2-.4-16.8-6.3-22.8l-52.7-52.7 116-116zM2.3 13.7l116 116L65.6 182.4c-6 6-8.4 14.6-6.3 22.8l.2 .6C62.1 216.5 71.7 224 82.7 224H200c13.3 0 24-10.7 24-24V82.7c0-11-7.5-20.6-18.2-23.3l-.6-.2c-8.2-2-16.8 .4-22.8 6.3l-52.7 52.7L13.7 2.3C10.5-.8 5.5-.8 2.3 2.3s-3.1 8.2 0 11.3zm507.3 496c3.1-3.1 3.1-8.2 0-11.3l-116-116 52.7-52.7c6-6 8.4-14.6 6.3-22.8l-.2-.6c-2.7-10.7-12.3-18.2-23.3-18.2H312c-13.3 0-24 10.7-24 24V429.3c0 11 7.5 20.6 18.2 23.3l.6 .2c8.2 2 16.8-.4 22.8-6.3l52.7-52.7 116 116c3.1 3.1 8.2 3.1 11.3 0zM2.3 498.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l116-116 52.7 52.7c6 6 14.6 8.4 22.8 6.3l.6-.2c10.7-2.7 18.2-12.3 18.2-23.3V312c0-13.3-10.7-24-24-24H82.7c-11 0-20.6 7.5-23.3 18.2l-.2 .6c-2 8.2 .4 16.8 6.3 22.8l52.7 52.7-116 116zM310.7 74.8c2.7-.7 5.6 .1 7.6 2.1L435.1 193.7c2 2 2.8 4.9 2.1 7.6l-.2 .6c-.9 3.6-4.1 6.1-7.8 6.1H312c-4.4 0-8-3.6-8-8V82.7c0-3.7 2.5-6.9 6.1-7.8l.6-.2zm-109.4 0l.6 .2 0 0c3.6 .9 6.1 4.1 6.1 7.8V200c0 4.4-3.6 8-8 8H82.7c-3.7 0-6.9-2.5-7.8-6.1l-.2-.6c-.7-2.7 .1-5.6 2.1-7.6L193.7 76.9c2-2 4.9-2.8 7.6-2.1l0 0zM310.7 437.2l-.6-.2c-3.6-.9-6.1-4.1-6.1-7.8V312c0-4.4 3.6-8 8-8H429.3c3.7 0 6.9 2.5 7.8 6.1l.2 .6c.7 2.7-.1 5.6-2.1 7.6L318.3 435.1c-2 2-4.9 2.8-7.6 2.1zM201.9 437l-.6 .2c-2.7 .7-5.6-.1-7.6-2.1L76.9 318.3c-2-2-2.8-4.9-2.1-7.6l.2-.6c.9-3.6 4.1-6.1 7.8-6.1H200c4.4 0 8 3.6 8 8V429.3c0 3.7-2.5 6.9-6.1 7.8z"],
    "refrigerator": [384, 512, [], "e026", "M288 16c44.2 0 80 35.8 80 80v80H272V104c0-4.4-3.6-8-8-8s-8 3.6-8 8v72H16V96c0-44.2 35.8-80 80-80H288zM256 192V376c0 4.4 3.6 8 8 8s8-3.6 8-8V192h96V448c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V192H256zM0 96v88V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V184 96c0-53-43-96-96-96H96C43 0 0 43 0 96z"],
    "monument": [384, 512, [], "f5a6", "M197.7 25c-3.1-3.1-8.2-3.1-11.3 0l-61 61c-3.7 3.7-6.1 8.6-6.8 13.8L79.9 393c-.6 4.4-4.6 7.5-9 6.9s-7.5-4.6-6.9-9L102.7 97.7c1.1-8.7 5.1-16.8 11.4-23.1l61-61c9.4-9.4 24.6-9.4 33.9 0l61 61c6.2 6.2 10.2 14.3 11.4 23.1L319.9 391c.6 4.4-2.5 8.4-6.9 9s-8.4-2.5-9-6.9L265.5 99.8c-.7-5.2-3.1-10.1-6.8-13.8l-61-61zM232 272H152c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8zm-80-16h80c13.3 0 24 10.7 24 24v16c0 13.3-10.7 24-24 24H152c-13.3 0-24-10.7-24-24V280c0-13.3 10.7-24 24-24zM32 432H352c17.7 0 32 14.3 32 32v16c0 17.7-14.3 32-32 32H32c-17.7 0-32-14.3-32-32V464c0-17.7 14.3-32 32-32zM16 464v16c0 8.8 7.2 16 16 16H352c8.8 0 16-7.2 16-16V464c0-8.8-7.2-16-16-16H32c-8.8 0-16 7.2-16 16z"],
    "octagon-xmark": [512, 512, ["times-octagon", "xmark-octagon"], "f2f0", "M191.5 16.1c-14.9 0-29.1 5.9-39.6 16.4L32.5 151.9C22 162.4 16.1 176.7 16.1 191.5v129c0 14.9 5.9 29.1 16.4 39.6L151.9 479.5c10.5 10.5 24.7 16.4 39.6 16.4h129c14.9 0 29.1-5.9 39.6-16.4L479.5 360.1c10.5-10.5 16.4-24.7 16.4-39.6v-129c0-14.9-5.9-29.1-16.4-39.6L360.1 32.5C349.6 22 335.3 16.1 320.5 16.1h-129zm-50.9 5.1C154.1 7.7 172.4 .1 191.5 .1h129c19.1 0 37.4 7.6 50.9 21.1L490.8 140.6c13.5 13.5 21.1 31.8 21.1 50.9v129c0 19.1-7.6 37.4-21.1 50.9L371.4 490.8c-13.5 13.5-31.8 21.1-50.9 21.1h-129c-19.1 0-37.4-7.6-50.9-21.1L21.2 371.4C7.7 357.9 .1 339.6 .1 320.5v-129c0-19.1 7.6-37.4 21.1-50.9L140.6 21.2zm37.7 157.2c3.1-3.1 8.2-3.1 11.3 0L256 244.7l66.3-66.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3L267.3 256l66.3 66.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L256 267.3l-66.3 66.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L244.7 256l-66.3-66.3c-3.1-3.1-3.1-8.2 0-11.3z"],
    "align-slash": [640, 512, [], "f846", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM274.7 312H104c-4.4 0-8 3.6-8 8s3.6 8 8 8H295l-20.3-16zm252.7 16H536c4.4 0 8-3.6 8-8s-3.6-8-8-8H507.1l20.3 16zM536 200c4.4 0 8-3.6 8-8s-3.6-8-8-8H345l20.3 16H536zm-403.1 0l-20.3-16H104c-4.4 0-8 3.6-8 8s3.6 8 8 8h28.9zM536 56H182.9l20.3 16H536c4.4 0 8-3.6 8-8s-3.6-8-8-8zM457.1 456l-20.3-16H104c-4.4 0-8 3.6-8 8s3.6 8 8 8H457.1z"],
    "snowplow": [640, 512, [], "f7d2", "M152 16c-4.4 0-8 3.6-8 8v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V24c0-13.3 10.7-24 24-24H300.6c14.9 0 28.6 8.3 35.5 21.5l87 166.8c2 3.9 .5 8.7-3.4 10.8s-8.7 .5-10.8-3.4l-87-166.8C317.7 21 309.5 16 300.6 16H152zM637.2 129.9c3.4 2.9 3.8 7.9 .9 11.3L552 242.9V397.1l86.1 101.8c2.9 3.4 2.4 8.4-.9 11.3s-8.4 2.4-11.3-.9l-88-104c-1.2-1.4-1.9-3.3-1.9-5.2V320H446.4c20.7 20.3 33.6 48.7 33.6 80c0 61.9-50.1 112-112 112H112C50.1 512 0 461.9 0 400c0-44.7 26.2-83.2 64-101.2V176c0-17.7 14.3-32 32-32h29.3c9.1 0 17.7 3.9 23.8 10.6L211.6 224H400c17.7 0 32 14.3 32 32v48H536V240c0-1.9 .7-3.7 1.9-5.2l88-104c2.9-3.4 7.9-3.8 11.3-.9zM80 176V292.6c10.1-3 20.9-4.6 32-4.6H368c17.2 0 33.5 3.9 48 10.8V256c0-8.8-7.2-16-16-16H208c-2.3 0-4.4-1-5.9-2.6l-64.8-72.1c-3-3.4-7.4-5.3-11.9-5.3H96c-8.8 0-16 7.2-16 16zM368 304H112c-53 0-96 43-96 96s43 96 96 96H368c53 0 96-43 96-96s-43-96-96-96zm16 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM80 400a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm112-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "angles-right": [512, 512, [187, "angle-double-right"], "f101", "M93.7 437.7l176-176c3.1-3.1 3.1-8.2 0-11.3l-176-176c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L252.7 256 82.3 426.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0zm192 0l176-176c3.1-3.1 3.1-8.2 0-11.3l-176-176c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L444.7 256 274.3 426.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0z"],
    "truck-ramp-couch": [640, 512, ["truck-couch"], "f4dd", "M352 72c0-39.8 32.2-72 72-72H632c4.4 0 8 3.6 8 8s-3.6 8-8 8H424c-30.9 0-56 25.1-56 56V392.5l50.1-14.4C428.3 326.8 473.6 288 528 288c61.9 0 112 50.1 112 112s-50.1 112-112 112s-112-50.1-112-112c0-1.5 0-3.1 .1-4.6L10.2 511.7c-4.2 1.2-8.7-1.2-9.9-5.5s1.2-8.7 5.5-9.9L352 397.1V72zM624 400a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM318.4 194.5l1.6 6v19.4c-2.6 .1-5.3 .4-8 1.2c-18.2 4.9-29 23.6-24.2 41.8l2.3 8.5c2.3 8.5-2.8 17.3-11.3 19.6L112.9 335.4c-8.5 2.3-17.3-2.8-19.6-11.3l-2.8-10.6c-4.6-17.1-22.1-27.2-39.2-22.6S24.2 313 28.7 330l15.5 58c3.4 12.8 16.6 20.4 29.4 17l24.8-6.6c.9-.2 1.7-.4 2.6-.5l192.6-51.6c.5-.1 1-.3 1.6-.3l24.8-6.7v16.6l-6.8 1.8-15.5 4.1 0-.1-15.5 4.1-164.2 44L102.6 414l-.1-.2L87.1 418l-9.3 2.5c-21.3 5.7-43.3-6.9-49-28.3l-15.5-58c-5.4-20 2.8-40.5 18.8-51.8l-2.8-10.5C16.7 225 44.6 176.7 91.5 164.1l119.1-31.9c46.9-12.6 95.2 15.3 107.8 62.2zM214.8 147.7L95.7 179.6c-38.4 10.3-61.2 49.8-50.9 88.2l2.1 7.7 .4-.1c25.6-6.9 51.9 8.3 58.8 33.9l2.8 10.6 15.5-4.1 134.9-36.2 15.5-4.1-2.3-8.5c-6.9-25.8 7.6-52.3 32.7-60.6l-2.1-7.8c-10.3-38.4-49.8-61.2-88.2-50.9z"],
    "cannabis": [512, 512, [], "f55f", "M262.6 3.6c-1.5-2.2-4-3.6-6.6-3.6s-5.2 1.3-6.6 3.6c-14.2 21.2-34.1 60.7-48.7 105.6c-12.3 38-20.9 80.6-18.5 119.8c-53.8-43-126.5-66.2-164.6-73.8c-2.6-.5-5.3 .3-7.2 2.2s-2.7 4.6-2.2 7.2c7.7 38.1 31.1 110.9 74.4 164.5c-25.8 9.5-49 22.6-64.2 31.2c-2.3 1.3-4.4 2.5-6.3 3.5c-2.5 1.4-4.1 4.1-4.1 7s1.6 5.6 4.1 7c14.5 8.1 42.2 23.1 73.3 33.7c25.4 8.7 54.3 14.7 80.4 10.5l-18.2 47.1c-1.2 3-.4 6.5 2 8.7s5.9 2.8 8.8 1.4l89.6-41V504c0 4.4 3.6 8 8 8s8-3.6 8-8V438.3l89.6 41c3 1.4 6.4 .8 8.8-1.4s3.2-5.7 2-8.7L346.3 422c26 4.2 54.9-1.8 80.4-10.5c31-10.6 58.7-25.6 73.3-33.7c2.5-1.4 4.1-4.1 4.1-7s-1.6-5.6-4.1-7c-15.3-8.5-42.6-22.6-73.3-31.3c45.2-53.9 69.4-129 77.3-167.9c.5-2.6-.3-5.3-2.2-7.2s-4.6-2.7-7.2-2.2C456.4 162.8 383.6 186 329.8 229c2.4-39.2-6.3-81.8-18.5-119.8C296.8 64.3 276.8 24.8 262.6 3.6zM264 420.7V328c0-4.4-3.6-8-8-8s-8 3.6-8 8v92.7l-78.4 35.9 16.7-43.2c1.1-2.9 .4-6.2-1.7-8.5s-5.5-3-8.4-1.9c-24.4 8.7-55.6 3.6-85.5-6.6c-22.3-7.6-43-17.7-58-25.6c17.2-9.6 40.9-22.3 66.1-30.2c2.6-.8 4.6-2.9 5.3-5.5s.1-5.4-1.7-7.5C61 281.3 36.6 214.7 26.6 173.6c43.1 10.5 113.9 36.4 160.4 80.8c2.5 2.4 6.3 2.9 9.3 1.3s4.7-5 4.1-8.4c-7.2-40.8 1.4-89.2 15.6-133.1c11.9-36.9 27.5-69.7 40.1-91c12.6 21.3 28.2 54.2 40.1 91c14.2 43.8 22.7 92.3 15.6 133.1c-.6 3.4 1.1 6.8 4.1 8.4s6.8 1.1 9.3-1.3c46.5-44.4 117.3-70.3 160.4-80.8c-10.4 42.4-35.9 111.6-79.4 158c-2 2.1-2.7 5.1-1.8 7.8s3.1 4.8 5.9 5.5c26.2 5.9 51.2 16.9 69 26c-15 7.9-35.5 17.9-57.7 25.5c-29.9 10.2-61.2 15.3-85.5 6.6c-2.9-1.1-6.2-.3-8.4 1.9s-2.9 5.5-1.7 8.5l16.7 43.2L264 420.7z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM196.1 161c2.5-1.4 5.6-1.4 8.1 .2l144 88c2.4 1.5 3.8 4 3.8 6.8s-1.4 5.4-3.8 6.8l-144 88c-2.5 1.5-5.6 1.6-8.1 .2s-4.1-4.1-4.1-7V168c0-2.9 1.6-5.6 4.1-7zm16.4-13.5c-7.4-4.5-16.7-4.7-24.3-.5s-12.3 12.3-12.3 20.9V344c0 8.7 4.7 16.7 12.3 20.9s16.8 4.1 24.3-.5l144-88c7.1-4.4 11.5-12.1 11.5-20.5s-4.4-16.1-11.5-20.5l-144-88z"],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", "M290.3 210.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L496 27.3V168c0 4.4 3.6 8 8 8s8-3.6 8-8V8c0-4.4-3.6-8-8-8H344c-4.4 0-8 3.6-8 8s3.6 8 8 8H484.7L290.3 210.3zm-68.7 91.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L16 484.7V344c0-4.4-3.6-8-8-8s-8 3.6-8 8V504c0 4.4 3.6 8 8 8H168c4.4 0 8-3.6 8-8s-3.6-8-8-8H27.3L221.7 301.7z"],
    "tablets": [640, 512, [], "f490", "M576 267.3L372.7 64C349.9 89.5 336 123.1 336 160c0 79.5 64.5 144 144 144c36.9 0 70.5-13.9 96-36.7zM587.3 256c22.8-25.5 36.7-59.1 36.7-96c0-79.5-64.5-144-144-144c-36.9 0-70.5 13.9-96 36.7L587.3 256zM320 160a160 160 0 1 1 320 0 160 160 0 1 1 -320 0zM303.8 360H16.2C20.4 435.8 83.2 496 160 496s139.6-60.2 143.8-136zm0-16c-4.2-75.8-66.9-136-143.8-136S20.4 268.2 16.2 344H303.8zM160 192a160 160 0 1 1 0 320 160 160 0 1 1 0-320z"],
    "360-degrees": [640, 512, [], "e2dc", "M592 32a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM8 64c-4.4 0-8 3.6-8 8s3.6 8 8 8H142.9L33.9 210.9c-2 2.4-2.4 5.7-1.1 8.5s4.1 4.6 7.2 4.6H72c57.4 0 104 46.6 104 104v19.4c0 46.7-37.9 84.6-84.6 84.6c-25.1 0-48.9-11.2-65-30.4L14.1 386.9c-2.8-3.4-7.9-3.9-11.3-1s-3.9 7.9-1 11.3l12.2 14.7C33.2 434.7 61.5 448 91.4 448C147 448 192 403 192 347.4V328c0-66.3-53.7-120-120-120H57.1L166.1 77.1c2-2.4 2.4-5.7 1.1-8.5s-4.1-4.6-7.2-4.6H8zm424 80c0-35.3 28.7-64 64-64s64 28.7 64 64V368c0 35.3-28.7 64-64 64s-64-28.7-64-64V144zM576 368V144c0-44.2-35.8-80-80-80s-80 35.8-80 80V368c0 44.2 35.8 80 80 80s80-35.8 80-80zM344 80c4.4 0 8-3.6 8-8s-3.6-8-8-8c-66.3 0-120 53.7-120 120V288c0 0 0 .1 0 .1V368c0 44.2 35.8 80 80 80s80-35.8 80-80V288c0-44.2-35.8-80-80-80c-26.2 0-49.4 12.6-64 32V184c0-57.4 46.6-104 104-104zM240 288c0-35.3 28.7-64 64-64s64 28.7 64 64v80c0 35.3-28.7 64-64 64s-64-28.7-64-64V288z"],
    "ethernet": [512, 512, [], "f796", "M128 96c0-17.7 14.3-32 32-32H352c17.7 0 32 14.3 32 32v32h32c17.7 0 32 14.3 32 32v32h32c17.7 0 32 14.3 32 32V416c0 17.7-14.3 32-32 32H400 304 208 112 32c-17.7 0-32-14.3-32-32V224c0-17.7 14.3-32 32-32H64V160c0-17.7 14.3-32 32-32h32V96zm32-16c-8.8 0-16 7.2-16 16v40c0 4.4-3.6 8-8 8H96c-8.8 0-16 7.2-16 16v40c0 4.4-3.6 8-8 8H32c-8.8 0-16 7.2-16 16V416c0 8.8 7.2 16 16 16h72V328c0-4.4 3.6-8 8-8s8 3.6 8 8V432h80V328c0-4.4 3.6-8 8-8s8 3.6 8 8V432h80V328c0-4.4 3.6-8 8-8s8 3.6 8 8V432h80V328c0-4.4 3.6-8 8-8s8 3.6 8 8V432h72c8.8 0 16-7.2 16-16V224c0-8.8-7.2-16-16-16H440c-4.4 0-8-3.6-8-8V160c0-8.8-7.2-16-16-16H376c-4.4 0-8-3.6-8-8V96c0-8.8-7.2-16-16-16H160z"],
    "euro-sign": [320, 512, [8364, "eur", "euro"], "f153", "M35.7 208c-2.4 13-3.7 26.3-3.7 40v16c0 13.7 1.3 27 3.7 40H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H39.3C64 412.1 148.1 480 248 480h65c4.4 0 8-3.6 8-8s-3.6-8-8-8H248c-91 0-167.8-60.8-192.1-144H280c4.4 0 8-3.6 8-8s-3.6-8-8-8H52c-2.6-12.9-4-26.3-4-40V248c0-13.7 1.4-27.1 4-40H280c4.4 0 8-3.6 8-8s-3.6-8-8-8H55.9C80.2 108.8 157 48 248 48h65c4.4 0 8-3.6 8-8s-3.6-8-8-8H248C148.1 32 64 99.9 39.3 192H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H35.7z"],
    "chair": [448, 512, [129681], "f6c0", "M232 16V256H216V16H192c-11.1 0-21.9 1.6-32 4.6V256H144V26.8C106.2 44.8 80 83.3 80 128V256H64V128C64 57.3 121.3 0 192 0h64c70.7 0 128 57.3 128 128V256H368V128c0-44.7-26.2-83.2-64-101.2V256H288V20.6c-10.1-3-20.9-4.6-32-4.6H232zM33.7 312.8l-16 32c-2.5 5-2.2 10.9 .7 15.6s8.1 7.6 13.6 7.6H416c5.5 0 10.7-2.9 13.6-7.6s3.2-10.6 .7-15.6l-16-32c-2.7-5.4-8.2-8.8-14.3-8.8H48c-6.1 0-11.6 3.4-14.3 8.8zm-14.3-7.2C24.8 294.8 35.9 288 48 288H400c12.1 0 23.2 6.8 28.6 17.7l16 32c5 9.9 4.4 21.7-1.4 31.1s-16.1 15.2-27.2 15.2H400V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V384H64V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V384H32c-11.1 0-21.4-5.7-27.2-15.2s-6.4-21.2-1.4-31.1l16-32z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM357.7 197.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L224 308.7l-58.3-58.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l64 64c3.1 3.1 8.2 3.1 11.3 0l128-128z"],
    "square-dashed-circle-plus": [576, 512, [], "e5c2", "M120 32c4.4 0 8 3.6 8 8s-3.6 8-8 8H88c-39.8 0-72 32.2-72 72v32c0 4.4-3.6 8-8 8s-8-3.6-8-8V120C0 71.4 39.4 32 88 32h32zM0 312V200c0-4.4 3.6-8 8-8s8 3.6 8 8V312c0 4.4-3.6 8-8 8s-8-3.6-8-8zm8 40c4.4 0 8 3.6 8 8v32c0 39.8 32.2 72 72 72h32c4.4 0 8 3.6 8 8s-3.6 8-8 8H88c-48.6 0-88-39.4-88-88V360c0-4.4 3.6-8 8-8zM439.7 192.2c-4.2-.2-7.7-3.6-7.7-7.8V120c0-39.8-32.2-72-72-72H328c-4.4 0-8-3.6-8-8s3.6-8 8-8h32c48.6 0 88 39.4 88 88v64.3c0 4.5-3.8 8-8.3 7.8zm-153 275.1c.9 1.2 1.3 2.7 1.3 4.2v.3c0 4.5-3.7 8.2-8.2 8.2H168c-4.4 0-8-3.6-8-8s3.6-8 8-8H280.5c2.5 0 4.8 1.3 6.2 3.3zM280 48H168c-4.4 0-8-3.6-8-8s3.6-8 8-8H280c4.4 0 8 3.6 8 8s-3.6 8-8 8zM560 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm152-72v64h64c4.4 0 8 3.6 8 8s-3.6 8-8 8H440v64c0 4.4-3.6 8-8 8s-8-3.6-8-8V376H360c-4.4 0-8-3.6-8-8s3.6-8 8-8h64V296c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "money-simple-from-bracket": [640, 512, [], "e313", "M72 16C41.1 16 16 41.1 16 72v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V72C0 32.2 32.2 0 72 0H568c39.8 0 72 32.2 72 72v80c0 4.4-3.6 8-8 8s-8-3.6-8-8V72c0-30.9-25.1-56-56-56H72zM504 80c4.4 0 8 3.6 8 8l0 376c0 26.5-21.5 48-48 48H176c-26.5 0-48-21.5-48-48l0-376c0-4.4 3.6-8 8-8s8 3.6 8 8l0 376c0 17.7 14.3 32 32 32H464c17.7 0 32-14.3 32-32l0-376c0-4.4 3.6-8 8-8zM320 200c-50 0-88 33.5-88 72s38 72 88 72s88-33.5 88-72s-38-72-88-72zm104 72c0 49.9-48 88-104 88s-104-38.1-104-88s48-88 104-88s104 38.1 104 88z"],
    "bat": [576, 512, [], "f6b5", "M372.2 166.1c4.4 2.3 9.6 2.3 14.1 .2l73.2-34.8c9.6-4.6 21.1-2.1 28.1 5.9c46.7 54.5 72.4 124 72.4 195.8v40.9l-59.6-29.8c-15-7.5-33.1-2.2-41.8 12.2l-29.8 49.7-36.6-36.6c-13.7-13.7-36.2-12.2-48 3.1L288 445.8l-56.2-73.1c-11.8-15.3-34.3-16.8-48-3.1l-36.6 36.6-29.8-49.7c-8.6-14.3-26.8-19.6-41.8-12.2L16 374.1V333.2c0-71.8 25.7-141.3 72.4-195.8c6.9-8.1 18.4-10.5 28.1-5.9l73.2 34.8c4.5 2.1 9.7 2.1 14.1-.2s7.6-6.4 8.5-11.3L229 65.3l35.4 23.6c7 4.6 15.2 7.1 23.5 7.1s16.6-2.5 23.5-7.1L347 65.3l16.8 89.6c.9 4.9 4 9.1 8.5 11.3zM181.6 144.8L123.4 117c-16.2-7.7-35.5-3.6-47.1 10C27.1 184.4 0 257.6 0 333.2v44.7c0 10.2 10.7 16.8 19.8 12.2l63-31.5c7.5-3.7 16.6-1.1 20.9 6.1l29.8 49.7c5.4 8.9 17.7 10.4 25 3.1l36.6-36.6c6.8-6.8 18.1-6.1 24 1.6l56.2 73.1c6.4 8.3 19 8.3 25.4 0l56.2-73.1c5.9-7.7 17.2-8.4 24-1.6l36.6 36.6c7.4 7.4 19.7 5.8 25-3.1l29.8-49.7c4.3-7.2 13.4-9.8 20.9-6.1l63 31.5c9.1 4.5 19.8-2.1 19.8-12.2V333.2c0-75.6-27.1-148.8-76.3-206.2c-11.6-13.6-30.9-17.7-47.1-10l-58.2 27.7-14.9 7.1-3-16.3L362.2 59.5c-1.3-6.7-7.1-11.5-13.9-11.5c-2.8 0-5.5 .8-7.8 2.4L302.7 75.6c-4.3 2.9-9.4 4.4-14.7 4.4s-10.3-1.5-14.7-4.4L235.6 50.4c-2.3-1.5-5-2.4-7.8-2.4c-6.8 0-12.6 4.8-13.9 11.5l-14.3 76.1-3.1 16.3-14.9-7.1z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm176-64V320c0 8.8 7.2 16 16 16H320c8.8 0 16-7.2 16-16V192c0-8.8-7.2-16-16-16H192c-8.8 0-16 7.2-16 16zm-16 0c0-17.7 14.3-32 32-32H320c17.7 0 32 14.3 32 32V320c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V192z"],
    "head-side-headphones": [512, 512, [], "f8c2", "M168 23.4v80c12.4-4.8 25.9-7.4 40-7.4s27.6 2.6 40 7.4V16.2c-2.7-.1-5.5-.2-8.3-.2H222.9c-19 0-37.4 2.6-54.9 7.4zm-16 5.1C72.7 57.4 16 133.6 16 222.9c0 49.4 15.8 94.6 43.9 130C71.5 367.5 80 385.5 80 405.3V504c0 4.4-3.6 8-8 8s-8-3.6-8-8V405.3c0-15.1-6.5-29.8-16.6-42.5C16.9 324.5 0 275.8 0 222.9C0 99.8 99.8 0 222.9 0h16.8c77.9 0 149.4 46.9 180.9 114.2c3.8 8 7.3 16 10.8 23.9c6.2 13.9 12.3 27.6 19.3 41c10.8 20.7 23.3 39.5 40 54.4l3.8 3.4c11.1 9.9 17.5 24.1 17.5 39c0 28.8-23.4 52.2-52.2 52.2H448v64c0 30.9-25.1 56-56 56H320v56c0 4.4-3.6 8-8 8s-8-3.6-8-8V440c0-4.4 3.6-8 8-8h80c22.1 0 40-17.9 40-40V320c0-4.4 3.6-8 8-8h19.8c20 0 36.2-16.2 36.2-36.2c0-10.3-4.4-20.2-12.1-27l-3.8-3.4c-18.8-16.7-32.3-37.3-43.5-58.9c-7.2-13.8-13.7-28.4-20.1-42.7c-3.5-7.8-6.9-15.5-10.4-22.9C380.5 66.3 325.9 26.1 264 17.6V111c33.5 19.4 56 55.6 56 97c0 61.9-50.1 112-112 112s-112-50.1-112-112c0-41.5 22.5-77.7 56-97V28.5zM304 208a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm-96 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-80a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "phone-rotary": [512, 512, [9742], "f8d3", "M256 48c124.8 0 209 60.9 235.8 83.4l7.9-9.4-7.9 9.4c2.5 2.1 4.2 5.5 4.2 9.8V192c0 8.8-7.2 16-16 16H437.7c-6.5 0-12.4-4-14.9-10.1l-19.4-48.6c-4.3-10.8-12.8-20.5-25-25c-20-7.5-62.8-20.3-122.4-20.3s-102.4 12.8-122.4 20.3c-12.1 4.6-20.6 14.2-25 25L89.2 197.9C86.8 204 80.9 208 74.3 208H32c-8.8 0-16-7.2-16-16V141.3c0-4.3 1.7-7.8 4.2-9.8C47 108.9 131.2 48 256 48zM0 192c0 17.7 14.3 32 32 32H74.3c13.1 0 24.9-8 29.7-20.1l19.4-48.6c2.9-7.3 8.4-13.2 15.7-16c18.6-7 59.5-19.3 116.8-19.3s98.2 12.3 116.8 19.3c7.3 2.8 12.8 8.7 15.7 16L408 203.9c4.9 12.1 16.6 20.1 29.7 20.1H480c17.7 0 32-14.3 32-32V141.3c0-8.5-3.4-16.6-9.9-22.1C473.8 95.4 386.1 32 256 32S38.2 95.4 9.9 119.2C3.4 124.6 0 132.8 0 141.3V192zM48 401c0-8.4 2.2-16.6 6.3-23.8l101.1-177c8.5-15 24.5-24.2 41.7-24.2H314.9c17.2 0 33.1 9.2 41.7 24.2l101.1 177c4.1 7.3 6.3 15.5 6.3 23.8v31c0 17.7-14.3 32-32 32H80c-17.7 0-32-14.3-32-32V401zm-16 0v31c0 26.5 21.5 48 48 48H432c26.5 0 48-21.5 48-48V401c0-11.1-2.9-22.1-8.4-31.8l-101.1-177C359 172.3 337.8 160 314.9 160H197.1c-23 0-44.2 12.3-55.6 32.2L40.4 369.2C34.9 378.9 32 389.9 32 401zm224-33a56 56 0 1 1 0-112 56 56 0 1 1 0 112zm-72-56a72 72 0 1 0 144 0 72 72 0 1 0 -144 0z"],
    "compass-drafting": [512, 512, ["drafting-compass"], "f568", "M320 80A64 64 0 1 0 192 80a64 64 0 1 0 128 0zm-22.7 68.5C285.3 155.8 271.1 160 256 160s-29.3-4.2-41.3-11.5l-88.9 160c37.4 22.6 81.2 35.5 128 35.5c91.8 0 171.9-49.9 214.8-124c2.2-3.8 7.1-5.1 10.9-2.9s5.1 7.1 2.9 10.9c-45.6 78.9-130.9 132-228.7 132c-49.6 0-96.1-13.7-135.8-37.5L15 507.9c-2.1 3.9-7 5.3-10.9 3.1s-5.3-7-3.1-10.9L104.5 313.8C72.1 291.5 44.8 262.2 25.1 228c-2.2-3.8-.9-8.7 2.9-10.9s8.7-.9 10.9 2.9c18.3 31.7 43.5 58.9 73.4 79.8L201 140.1l.7-1.3C185.9 124.2 176 103.2 176 80c0-44.2 35.8-80 80-80s80 35.8 80 80c0 23.2-9.9 44.2-25.7 58.8l.7 1.3 62.2 112c2.1 3.9 .8 8.7-3.1 10.9s-8.7 .8-10.9-3.1L297.4 148.5zM421.5 371.9c-2.1-3.9-.8-8.7 3.1-10.9s8.7-.8 10.9 3.1l75.6 136c2.1 3.9 .8 8.7-3.1 10.9s-8.7 .8-10.9-3.1l-75.6-136z"],
    "plate-wheat": [512, 512, [], "e55a", "M240 112v24c-35.3 0-64-28.7-64-64V48c35.3 0 64 28.7 64 64zM160 48V72c0 44.2 35.8 80 80 80c8.8 0 16-7.2 16-16V112c0-44.2-35.8-80-80-80c-8.8 0-16 7.2-16 16zm192 64v24c-35.3 0-64-28.7-64-64V48c35.3 0 64 28.7 64 64zM272 48V72c0 44.2 35.8 80 80 80c8.8 0 16-7.2 16-16V112c0-44.2-35.8-80-80-80c-8.8 0-16 7.2-16 16zm192 88c-35.3 0-64-28.7-64-64V48c35.3 0 64 28.7 64 64v24zM400 32c-8.8 0-16 7.2-16 16V72c0 44.2 35.8 80 80 80c8.8 0 16-7.2 16-16V112c0-44.2-35.8-80-80-80zM288 248c0-35.3 28.7-64 64-64v24c0 35.3-28.7 64-64 64V248zm80-64c0-8.8-7.2-16-16-16c-44.2 0-80 35.8-80 80v24c0 8.8 7.2 16 16 16c44.2 0 80-35.8 80-80V184zM176 272V248c0-35.3 28.7-64 64-64v24c0 35.3-28.7 64-64 64zm64-104c-44.2 0-80 35.8-80 80v24c0 8.8 7.2 16 16 16c44.2 0 80-35.8 80-80V184c0-8.8-7.2-16-16-16zm160 80c0-35.3 28.7-64 64-64v24c0 35.3-28.7 64-64 64V248zm80-64c0-8.8-7.2-16-16-16c-44.2 0-80 35.8-80 80v24c0 8.8 7.2 16 16 16c44.2 0 80-35.8 80-80V184zM0 160c0 4.4 3.6 8 8 8H152c4.4 0 8-3.6 8-8s-3.6-8-8-8H8c-4.4 0-8 3.6-8 8zM40 80c-4.4 0-8 3.6-8 8s3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H40zM32 232c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H40c-4.4 0-8 3.6-8 8zm81.8 210.6c-2.2-6.2-7.9-10.4-14.5-10.7C53 430.3 16 392.3 16 345.6c0-5.3 4.3-9.6 9.6-9.6H144 368 486.4c5.3 0 9.6 4.3 9.6 9.6c0 46.7-37 84.7-83.3 86.3c-6.6 .2-12.3 4.5-14.5 10.7C393.8 455.1 381.9 464 368 464H144c-13.9 0-25.8-8.9-30.2-21.4zM25.6 320C11.5 320 0 331.5 0 345.6C0 400.9 43.9 446 98.7 447.9c6.6 18.7 24.4 32.1 45.3 32.1H368c20.9 0 38.7-13.4 45.3-32.1c54.8-1.9 98.7-47 98.7-102.3c0-14.1-11.5-25.6-25.6-25.6H368 144 25.6z"],
    "calendar-circle-minus": [576, 512, [], "e46f", "M128 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H64C28.7 64 0 92.7 0 128v48 16V448c0 35.3 28.7 64 64 64H330.8c-6.9-4.9-13.5-10.2-19.6-16H64c-26.5 0-48-21.5-48-48V192H352h80 16V176 128c0-35.3-28.7-64-64-64H336V8c0-4.4-3.6-8-8-8s-8 3.6-8 8V64H128V8zM112 80v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80H320v40c0 4.4 3.6 8 8 8s8-3.6 8-8V80h48c26.5 0 48 21.5 48 48v48H16V128c0-26.5 21.5-48 48-48h48zM432 240a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm80-144c0-4.4-3.6-8-8-8H360c-4.4 0-8 3.6-8 8s3.6 8 8 8H504c4.4 0 8-3.6 8-8z"],
    "chopsticks": [640, 512, [], "e3f7", "M17.7 484.3L335.3 29.9C342 21.4 352.2 16 363.7 16C383.6 16 400 32.4 400 53c0 8.6-2.9 16.5-7.7 22.7L28.4 493l-.2 .2-.1 .2c-2.3 3-6.5 3.5-9.4 1.2c-3-2.4-3.5-6.8-1.2-9.9l0 0 .2-.3zM363.7 0c-16.7 0-31.6 8-41.2 20.3l0 0-.2 .3L4.7 475c-7.5 9.9-5.8 24.2 4 32c9.9 7.9 24.1 6.2 31.9-3.7l364-417.3 .2-.2 .1-.2c7-9 11.1-20.4 11.1-32.7c0-29.2-23.3-53-52.3-53zM146.7 483.7l416.3-395c6.5-5.4 14.8-8.7 23.9-8.7c20.5 0 37 16.4 37 36.6c0 11-4.9 20.9-12.8 27.6L155.9 494.1l0 0-.3 .3c-3 2.5-7.4 2.2-9.9-.7c-2.5-2.9-2.2-7.1 .8-9.6l0 0 .3-.3zM587 64c-13.1 0-25.2 4.8-34.5 12.6l0 0-.3 .3-416.3 395c-9.5 8.2-10.6 22.6-2.3 32.1c8.2 9.5 22.6 10.6 32.2 2.6L621.2 156.8l0 0 .3-.3c11.3-9.6 18.5-23.9 18.5-39.9C640 87.5 616.2 64 587 64z"],
    "car-wrench": [512, 512, ["car-mechanic"], "f5e3", "M134.8 113c-11.2 18.6-31.6 31-54.8 31c-23.7 0-44.4-12.8-55.4-32H59.2c6.3 0 12.5-1.9 17.8-5.4c19-12.7 19-40.6 0-53.3C71.6 49.9 65.5 48 59.2 48H24.6C35.6 28.8 56.3 16 80 16c23.2 0 43.6 12.4 54.8 31c5.6 9.2 15.9 17 29 17H348.2c13.1 0 23.4-7.8 29-17c11.2-18.6 31.6-31 54.8-31c23.7 0 44.4 12.8 55.4 32H452.8c-6.3 0-12.5 1.9-17.8 5.4c-19 12.7-19 40.6 0 53.3c5.3 3.5 11.4 5.4 17.8 5.4h34.6c-11.1 19.2-31.8 32-55.4 32c-23.2 0-43.6-12.4-54.8-31c-5.6-9.2-15.9-17-29-17H163.8c-13.1 0-23.4 7.8-29 17zm29-1H348.2c6.4 0 12 3.8 15.3 9.3c14 23.2 39.5 38.7 68.5 38.7c31.8 0 59.3-18.6 72.2-45.5c4.4-9.1-3.3-18.5-13.4-18.5h-38c-3.2 0-6.2-.9-8.9-2.7c-9.5-6.3-9.5-20.3 0-26.6c2.6-1.8 5.7-2.7 8.9-2.7h38c10.1 0 17.7-9.4 13.4-18.5C491.3 18.6 463.8 0 432 0c-29.1 0-54.5 15.5-68.5 38.7c-3.3 5.4-8.9 9.3-15.3 9.3H163.8c-6.4 0-12-3.8-15.3-9.3C134.5 15.5 109.1 0 80 0C48.2 0 20.7 18.6 7.8 45.5C3.4 54.6 11.1 64 21.2 64h38c3.2 0 6.2 .9 8.9 2.7C77.5 73 77.5 87 68 93.3c-2.6 1.8-5.7 2.7-8.9 2.7h-38c-10.1 0-17.7 9.4-13.4 18.5C20.7 141.4 48.2 160 80 160c29.1 0 54.5-15.5 68.5-38.7c3.3-5.4 8.9-9.3 15.3-9.3zm24.4 80H323.8c17.9 0 33.6 11.8 38.5 29l19.5 68.2c-4.5-.8-9-1.2-13.7-1.2H144c-4.7 0-9.3 .4-13.7 1.2L149.7 221c4.9-17.2 20.6-29 38.5-29zM112.3 293.8l-.2 .8C83.8 307 64 335.2 64 368v64 16 32c0 17.7 14.3 32 32 32h16c17.7 0 32-14.3 32-32V448H368v32c0 17.7 14.3 32 32 32h16c17.7 0 32-14.3 32-32V448 432 368c0-32.8-19.8-61-48.1-73.4l-.2-.8-22.1-77.2c-6.9-24-28.8-40.6-53.8-40.6H188.2c-25 0-47 16.6-53.8 40.6l-22.1 77.2zM384 432H368 144 128 80V368c0-35.3 28.7-64 64-64H368c35.3 0 64 28.7 64 64v64H384zm0 48V448h48v32c0 8.8-7.2 16-16 16H400c-8.8 0-16-7.2-16-16zM128 448v32c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V448h48zm32-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-16-32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm224 48a16 16 0 1 1 0-32 16 16 0 1 1 0 32zm-32-16a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"],
    "icicles": [512, 512, [], "f7ad", "M0 28.8C0 12.9 12.9 0 28.8 0H482c16.6 0 30 13.4 30 30c0 1.8-.2 3.7-.5 5.5l-87.6 470c-.7 3.8-4 6.5-7.9 6.5s-7.2-2.7-7.9-6.5L342.3 154.4 295.7 314.2c-1 3.4-4 5.7-7.5 5.8s-6.6-2.1-7.7-5.5l-39-117L199.8 377.8c-.8 3.6-4.1 6.2-7.8 6.2s-7-2.6-7.8-6.2L142.6 197.5l-39 117c-1.1 3.3-4.2 5.5-7.7 5.5s-6.5-2.3-7.6-5.6l-87-277C.4 34.6 0 31.7 0 28.8zM28.8 16C21.7 16 16 21.7 16 28.8c0 1.3 .2 2.6 .6 3.8L96.2 286l40.2-120.6c1.1-3.4 4.4-5.6 8-5.5s6.6 2.7 7.4 6.2L192 340.4l40.2-174.2c.8-3.5 3.8-6 7.4-6.2s6.8 2.1 8 5.5l39.9 119.7 48.8-167.4c1-3.6 4.4-5.9 8.1-5.8s6.8 2.9 7.5 6.5L416 460.5 495.8 32.5c.2-.8 .2-1.7 .2-2.6c0-7.7-6.3-14-14-14H28.8z"],
    "person-shelter": [512, 512, [], "e54f", "M260.2 1.2c-2.6-1.6-5.8-1.6-8.4 0l-248 152c-2.4 1.5-3.8 4-3.8 6.8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V164.5L256 17.4 496 164.5V504c0 4.4 3.6 8 8 8s8-3.6 8-8V160c0-2.8-1.4-5.4-3.8-6.8l-248-152zM232 168a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm64 0a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM216 296c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 17.7 14.3 32 32 32c9.6 0 18.1-4.2 24-10.8c5.9 6.6 14.4 10.8 24 10.8c17.7 0 32-14.3 32-32V296c0-4.4-3.6-8-8-8s-8 3.6-8 8V480c0 8.8-7.2 16-16 16s-16-7.2-16-16V384c0-4.4-3.6-8-8-8h0 0c-4.4 0-8 3.6-8 8v96c0 8.8-7.2 16-16 16s-16-7.2-16-16V296zm-21.7-25.4c9.5-18.8 28.8-30.6 49.9-30.6h23.6c21.1 0 40.4 11.8 49.9 30.6l43.1 85c2 3.9 6.8 5.5 10.8 3.5s5.5-6.8 3.5-10.8l-43.1-85c-12.3-24.2-37.1-39.4-64.2-39.4H244.2c-27.1 0-51.9 15.2-64.2 39.4l-43.1 85c-2 3.9-.4 8.8 3.5 10.8s8.8 .4 10.8-3.5l43.1-85z"],
    "neuter": [384, 512, [9906], "f22c", "M32 176a160 160 0 1 1 320 0A160 160 0 1 1 32 176zM200 351.8c93.5-4.2 168-81.3 168-175.8C368 78.8 289.2 0 192 0S16 78.8 16 176c0 94.5 74.5 171.6 168 175.8V504c0 4.4 3.6 8 8 8s8-3.6 8-8V351.8z"],
    "id-badge": [384, 512, [], "f2c1", "M64 16C37.5 16 16 37.5 16 64V448c0 26.5 21.5 48 48 48H320c26.5 0 48-21.5 48-48V64c0-26.5-21.5-48-48-48H64zM0 64C0 28.7 28.7 0 64 0H320c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V64zM240 224a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-112 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm0-152c0-4.4 3.6-8 8-8H248c4.4 0 8 3.6 8 8s-3.6 8-8 8H136c-4.4 0-8-3.6-8-8zM96 392c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-39.8 32.2-72 72-72h80c39.8 0 72 32.2 72 72c0 4.4-3.6 8-8 8s-8-3.6-8-8c0-30.9-25.1-56-56-56H152c-30.9 0-56 25.1-56 56z"],
    "kazoo": [640, 512, [], "f8c7", "M448 128a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 272c23.8 0 46.3-5.8 66-16h94c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32H514c-19.8-10.2-42.2-16-66-16s-46.3 5.8-66 16H224c-3 0-6 .4-9 1.3l-192 56C9.4 189.3 0 201.8 0 216v80c0 14.2 9.4 26.7 23 30.7l192 56c2.9 .8 5.9 1.3 9 1.3H382c19.8 10.2 42.2 16 66 16zm160-32H538.5c32.6-26.4 53.5-66.8 53.5-112s-20.9-85.6-53.5-112H608c8.8 0 16 7.2 16 16V352c0 8.8-7.2 16-16 16zM224 144H357.5C324.9 170.4 304 210.8 304 256s20.9 85.6 53.5 112H224c-1.5 0-3-.2-4.5-.6l-192-56c-6.8-2-11.5-8.2-11.5-15.4V216c0-7.1 4.7-13.4 11.5-15.4l192-56c1.5-.4 3-.6 4.5-.6zm189.7 66.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L436.7 256l-34.3 34.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L448 267.3l34.3 34.3c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L459.3 256l34.3-34.3c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L448 244.7l-34.3-34.3z"],
    "marker": [512, 512, [], "f5a1", "M469.7 42.3C440 12.7 392 12.7 362.3 42.3L192 212.7 299.3 320 469.7 149.7c29.6-29.6 29.6-77.7 0-107.3zM288 331.3L180.7 224l-69.8 69.8c-45.8 45.8-77 104.1-89.7 167.6l-5 25c-.5 2.6 .3 5.3 2.2 7.2s4.6 2.7 7.2 2.2l25-5c63.5-12.7 121.8-43.9 167.6-89.7L288 331.3zM351 31C386.9-4.8 445.1-4.8 481 31s35.9 94.1 0 129.9L229.5 412.5c-48 48-109.2 80.8-175.8 94.1l-25 5c-7.9 1.6-16-.9-21.7-6.6s-8.1-13.8-6.6-21.7l5-25c13.3-66.6 46.1-127.8 94.1-175.8L313.4 68.7 300.3 55.6c-15.6-15.6-40.9-15.6-56.6 0l-94.1 94.1c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l94.1-94.1c21.9-21.9 57.3-21.9 79.2 0l13.1 13.1L351 31z"],
    "bin-bottles": [640, 512, [], "e5f5", "M384 24c0-13.3 10.7-24 24-24h80c13.3 0 24 10.7 24 24v8H496V24c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v8H384V24zM352 192H336c0-44.2-35.8-80-80-80H128c-44.2 0-80 35.8-80 80H32c0-53 43-96 96-96H256c53 0 96 43 96 96zm223.1 0H558.9c-1.1-6.5-3.5-12.6-6.9-17.9c-3.4-5.4-3.4-12.3 .2-17.6c4.7-7 7.4-15.3 7.4-24.4c0-17-9.8-32.5-25.2-39.7l-13.2-6.2c-8.9-4.1-18.5-6.3-28.3-6.3H402.3c-9.8 0-19.4 2.2-28.3 6.3l-13.2 6.2c-5.2 2.4-9.7 5.8-13.5 9.9c-3.7-3.8-7.7-7.4-11.9-10.7c5.2-5.6 11.5-10.3 18.6-13.6l13.1-6.2c11-5.1 23-7.8 35.1-7.8h90.6C505 64 517 66.7 528 71.8L541.2 78c21 9.9 34.5 31 34.5 54.2c0 12.3-3.7 23.8-10.1 33.3c5 7.8 8.4 16.9 9.6 26.5zM32 224H47.2h.9H591.9h.9H608h24c4.4 0 8 3.6 8 8s-3.6 8-8 8H606.2L583.9 440.8c-4.5 40.5-38.7 71.2-79.5 71.2H135.6c-40.8 0-75-30.6-79.5-71.2L33.8 240H8c-4.4 0-8-3.6-8-8s3.6-8 8-8H32zm558.1 16H49.9L72 439.1c3.6 32.4 31 56.9 63.6 56.9H504.4c32.6 0 60-24.5 63.6-56.9L590.1 240zM144 32V56c0 4.4-3.6 8-8 8H120c-4.4 0-8-3.6-8-8s3.6-8 8-8h8V32c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32V48h8c4.4 0 8 3.6 8 8s-3.6 8-8 8H248c-4.4 0-8-3.6-8-8V32c0-8.8-7.2-16-16-16H160c-8.8 0-16 7.2-16 16z"],
    "face-laugh-beam": [512, 512, [128513, "laugh-beam"], "f59a", "M496 256A240 240 0 1 0 16 256a240 240 0 1 0 480 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM256 416c64.7 0 119.5-44.8 135.8-106.1c.4-1.4 .1-2.5-.9-3.6c-1.1-1.2-3-2.3-5.4-2.3H126.5c-2.4 0-4.4 1.1-5.4 2.3c-1 1.1-1.2 2.2-.9 3.6C136.5 371.2 191.3 416 256 416zM126.5 288H385.5c14.2 0 25.4 12.3 21.8 26c-18.1 68-79 118-151.3 118s-133.2-50-151.3-118c-3.6-13.7 7.6-26 21.8-26zm24.5-108.3c-7.4 11.4-12.7 26.3-15.2 39.8c-.8 4.3-5 7.2-9.3 6.4s-7.2-5-6.4-9.3c2.8-15 8.7-32 17.6-45.6c8.7-13.3 21.5-25 38.3-25s29.6 11.7 38.3 25c8.8 13.5 14.8 30.6 17.6 45.6c.8 4.3-2 8.5-6.4 9.3s-8.5-2-9.3-6.4c-2.5-13.5-7.8-28.4-15.2-39.8c-7.6-11.6-16.1-17.7-24.9-17.7s-17.3 6.1-24.9 17.7zm144.8 39.8c-.8 4.3-5 7.2-9.3 6.4s-7.2-5-6.4-9.3c2.8-15 8.7-32 17.6-45.6c8.7-13.3 21.5-25 38.3-25s29.6 11.7 38.3 25c8.8 13.5 14.8 30.6 17.6 45.6c.8 4.3-2 8.5-6.4 9.3s-8.5-2-9.3-6.4c-2.5-13.5-7.8-28.4-15.2-39.8c-7.6-11.6-16.1-17.7-24.9-17.7s-17.3 6.1-24.9 17.7c-7.4 11.4-12.7 26.3-15.2 39.8z"],
    "square-arrow-down-left": [448, 512, [], "e261", "M64 464c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64zM0 416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416zm280-64c4.4 0 8-3.6 8-8s-3.6-8-8-8H155.3L317.7 173.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L144 324.7V200c0-4.4-3.6-8-8-8s-8 3.6-8 8V344c0 4.4 3.6 8 8 8H280z"],
    "battery-bolt": [576, 512, [], "f376", "M80 96C35.8 96 0 131.8 0 176V336c0 44.2 35.8 80 80 80h92.2c-4.2-4.7-7.4-10.2-9.5-16H80c-35.3 0-64-28.7-64-64V176c0-35.3 28.7-64 64-64H279.2l20-16H80zM448 400H264.8l-20 16H448c44.2 0 80-35.8 80-80V320h16c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H528V176c0-44.2-35.8-80-80-80H371.8c4.2 4.7 7.4 10.2 9.5 16H448c35.3 0 64 28.7 64 64v16 16 96 16 16c0 35.3-28.7 64-64 64zm96-192c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H528V208h16zM283.6 232.8c-2.5 5-2.2 10.9 .7 15.6s8.1 7.6 13.6 7.6H368L208 384l52.4-104.8c2.5-5 2.2-10.9-.7-15.6s-8.1-7.6-13.6-7.6H176L336 128 283.6 232.8zm66.7-97.7c3.4-6.7 1.6-14.9-4.2-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7h52.2 17.9l-8 16-44.4 88.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7H315.8 297.9l8-16 44.4-88.8z"],
    "tree-large": [448, 512, [], "f7dd", "M224 0c2.2 0 4.3 .9 5.8 2.5L375.5 155.9c5.4 5.7 8.5 13.3 8.5 21.3c0 17-13.8 30.9-30.9 30.9H322.3l85.4 91.9c5.3 5.7 8.3 13.3 8.3 21.1c0 17.1-13.9 31-31 31H352.8l88.1 108.4c4.6 5.6 7.1 12.7 7.1 19.9c0 17.5-14.2 31.6-31.6 31.6H288 160 31.6C14.2 512 0 497.8 0 480.4c0-7.3 2.5-14.3 7.1-19.9L95.2 352H63c-17.1 0-31-13.9-31-31c0-7.8 3-15.3 8.3-21.1L125.7 208H94.9c-17 0-30.9-13.8-30.9-30.9c0-7.9 3-15.5 8.5-21.3L218.2 2.5C219.7 .9 221.8 0 224 0zM160 496H288 416.4c8.6 0 15.6-7 15.6-15.6c0-3.6-1.2-7.1-3.5-9.8L329.8 349c-1.9-2.4-2.3-5.7-1-8.5s4.1-4.6 7.2-4.6h49c8.3 0 15-6.7 15-15c0-3.8-1.4-7.4-4-10.2L298.1 205.4c-2.2-2.3-2.7-5.7-1.5-8.6s4.2-4.8 7.3-4.8h49.1c8.2 0 14.9-6.7 14.9-14.9c0-3.8-1.5-7.5-4.1-10.2L224 19.6 84.1 166.9c-2.6 2.8-4.1 6.4-4.1 10.2c0 8.2 6.7 14.9 14.9 14.9H144c3.2 0 6.1 1.9 7.3 4.8s.7 6.3-1.5 8.6L52 310.8c-2.6 2.8-4 6.4-4 10.2c0 8.3 6.7 15 15 15h49c3.1 0 5.9 1.8 7.2 4.6s.9 6.1-1 8.5L19.5 470.5c-2.3 2.8-3.5 6.3-3.5 9.8C16 489 23 496 31.6 496H160z"],
    "helicopter-symbol": [512, 512, [], "e502", "M493.9 224H510C495.6 108.2 403.8 16.4 288 2V18.1C395 32.4 479.6 117.1 493.9 224zM510 288H493.9C479.6 395 395 479.6 288 493.9V510c115.8-14.4 207.6-106.2 222-222zM2 288C16.4 403.8 108.2 495.6 224 510V493.9C117 479.6 32.4 395 18.1 288H2zm0-64H18.1C32.4 117 117.1 32.4 224 18.1V2C108.2 16.4 16.4 108.2 2 224zm166-80c0-4.4-3.6-8-8-8s-8 3.6-8 8V368c0 4.4 3.6 8 8 8s8-3.6 8-8V264H344V368c0 4.4 3.6 8 8 8s8-3.6 8-8V144c0-4.4-3.6-8-8-8s-8 3.6-8 8V248H168V144z"],
    "aperture": [512, 512, [], "e2df", "M256 496c-9.1 0-18-.5-26.9-1.5L316 344l9.5-16.5c.8-1.1 1.5-2.3 2.2-3.5l23.1-40c.7-1.2 1.3-2.4 1.9-3.6l4.8-8.4 79.7 138 1.1 2c-44 51.4-109.4 84-182.4 84zm23.3-144H293L213.3 490l-1.2 2C132.9 477.4 67.4 423.9 36 352H209.8h23.3 46.2zM233.1 160H219L298.7 22l1.2-2C379.1 34.6 444.6 88.1 476 160H302.2 279.3 233.1zm92.5 24.5l-4.9-8.5H480h2.3c8.8 25 13.7 51.9 13.7 80c0 53.4-17.4 102.7-46.9 142.5L362.2 248l-9.4-16.4c-.6-1.2-1.2-2.4-1.9-3.6l-23.1-40c-.7-1.2-1.4-2.4-2.2-3.5zM312 193.1l26.6 46c5 10.7 5 23.1 0 33.8l-26.6 46c-7.4 10.6-19.7 17.1-32.8 17.1H233.1c-14.3 0-27.5-7.6-34.6-20l-23.1-40c-7.1-12.4-7.1-27.6 0-40l23.1-40c7.1-12.4 20.4-20 34.6-20h46.2c13.1 0 25.3 6.4 32.8 17.1zM149.8 264l41.6 72H32 29.7C20.8 311 16 284.1 16 256c0-53.4 17.4-102.7 46.9-142.5L149.8 264zm-75-162l-1.1-2C117.6 48.6 183 16 256 16c9.1 0 18 .5 26.9 1.5L196 168l-41.6 72L74.7 102zM256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512z"],
    "universal-access": [512, 512, [], "f29a", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM224 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm80 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM128.7 188.8c-1.8 4 0 8.8 4.1 10.6l28.1 12.5c15.2 6.7 31 11.8 47.1 15.2v99.8l-23.7 78.9c-1.3 4.2 1.1 8.7 5.4 10s8.7-1.1 10-5.4L222 336H290l22.3 74.3c1.3 4.2 5.7 6.6 10 5.4s6.6-5.7 5.4-10L304 326.8V227c16.2-3.4 31.9-8.5 47.1-15.2l28.1-12.5c4-1.8 5.9-6.5 4.1-10.6s-6.5-5.9-10.6-4.1l-28.1 12.5C316.7 209.6 286.5 216 256 216s-60.7-6.4-88.6-18.8l-28.1-12.5c-4-1.8-8.8 0-10.6 4.1zM224 229.8c10.6 1.5 21.3 2.2 32 2.2s21.4-.7 32-2.2V320H224V229.8z"],
    "gear-complex": [512, 512, [], "e5e9", "M436.6 74.5l0 0C425.6 63.6 413.7 53.7 401 45c-8.2-5.6-18.8-5.4-26.7-.1L341.8 66.5c-4.1-1.8-8.2-3.6-12.4-5.1l-7.7-38.3c-1.9-9.4-9.2-17-19-18.8C287.6 1.5 271.9 0 256 0s-31.6 1.5-46.7 4.3c-9.8 1.8-17.1 9.4-19 18.8l-7.7 38.3c-4.2 1.6-8.3 3.3-12.4 5.1L137.8 44.8c-7.9-5.3-18.5-5.5-26.7 .1C98.3 53.7 86.4 63.7 75.4 74.5l0 0-.8 .8 0 0C63.7 86.4 53.7 98.3 45 111c-5.6 8.2-5.4 18.8-.1 26.7l21.6 32.5c-1.8 4.1-3.6 8.2-5.1 12.4l-38.3 7.7c-9.4 1.9-17 9.2-18.8 19C1.5 224.4 0 240.1 0 256s1.5 31.6 4.3 46.7c1.8 9.8 9.4 17.1 18.8 19l38.3 7.7c1.6 4.2 3.3 8.3 5.1 12.4L44.8 374.2c-5.3 7.9-5.5 18.5 .1 26.7C62.8 426.8 85.2 449.2 111 467c8.2 5.6 18.8 5.4 26.7 .2l32.5-21.6c4.1 1.8 8.2 3.6 12.4 5.1l7.7 38.3c1.9 9.4 9.2 17 19 18.8c15.2 2.8 30.8 4.3 46.7 4.3s31.6-1.5 46.7-4.3c9.8-1.8 17.1-9.4 19-18.8l7.7-38.3c4.2-1.6 8.3-3.3 12.4-5.1l32.5 21.6c7.9 5.3 18.5 5.5 26.7-.2c25.9-17.8 48.3-40.2 66.1-66.1c5.6-8.2 5.4-18.8 .2-26.7l-21.6-32.5c1.8-4.1 3.6-8.2 5.1-12.4l38.3-7.7c9.4-1.9 17-9.2 18.8-19c2.8-15.1 4.2-30.6 4.3-46.5v0-.4 0c0-15.9-1.5-31.4-4.3-46.5c-1.8-9.8-9.4-17.1-18.8-19l-38.3-7.7c-1.6-4.2-3.3-8.3-5.1-12.4l21.6-32.5c5.3-7.9 5.5-18.5-.1-26.7c-8.8-12.7-18.7-24.6-29.5-35.6l0 0-.9-.9zm17.3 45.6c1.8 2.6 1.8 6.1 0 8.8L429.8 165c-1.6 2.4-1.8 5.5-.5 8.1c2.9 6.1 5.6 12.5 7.9 18.9c1 2.7 3.3 4.8 6.1 5.4l42.6 8.5c3.1 .6 5.6 3.1 6.2 6.2c2.6 14.1 4 28.7 4 43.6v.4c0 14.9-1.4 29.5-4 43.6c-.6 3.2-3.1 5.6-6.2 6.2l-42.6 8.5c-2.8 .6-5.1 2.6-6.1 5.4c-2.3 6.5-4.9 12.8-7.9 18.9c-1.3 2.6-1.1 5.7 .5 8.1l24.1 36.1c1.8 2.7 1.8 6.2 0 8.8c-16.7 24.2-37.7 45.3-62 62c-2.6 1.8-6.1 1.8-8.8 0L347 429.8c-2.4-1.6-5.5-1.8-8.1-.5c-6.1 2.9-12.5 5.6-18.9 7.9c-2.7 1-4.8 3.3-5.4 6.1L306 485.8c-.6 3.1-3.1 5.6-6.2 6.2c-14.2 2.6-28.8 4-43.8 4s-29.6-1.4-43.8-4c-3.2-.6-5.6-3.1-6.2-6.2l-8.5-42.6c-.6-2.8-2.6-5.1-5.4-6.1c-6.5-2.3-12.8-4.9-18.9-7.9c-2.6-1.3-5.7-1.1-8.1 .5l-36.1 24.1c-2.7 1.8-6.2 1.8-8.8 0c-24.2-16.7-45.3-37.7-62-62c-1.8-2.6-1.8-6.1 0-8.8L82.2 347c1.6-2.4 1.8-5.5 .5-8.1c-2.9-6.1-5.6-12.5-7.9-18.9c-1-2.7-3.3-4.8-6.1-5.4L26.2 306c-3.1-.6-5.6-3.1-6.2-6.2c-2.6-14.2-4-28.8-4-43.8s1.4-29.6 4-43.8c.6-3.2 3.1-5.6 6.2-6.2l42.6-8.5c2.8-.6 5.1-2.6 6.1-5.4c2.3-6.5 4.9-12.8 7.9-18.9c1.2-2.6 1.1-5.7-.5-8.1L58.1 128.9c-1.8-2.7-1.8-6.2 0-8.8c8.2-12 17.5-23.1 27.7-33.4l.8-.8C97 75.7 108.1 66.4 120.1 58.2c2.6-1.8 6.1-1.8 8.8 0L165 82.2c2.4 1.6 5.5 1.8 8.1 .5c6.1-2.9 12.5-5.6 18.9-7.9c2.7-1 4.8-3.3 5.4-6.1L206 26.2c.6-3.1 3.1-5.6 6.2-6.2c14.2-2.6 28.8-4 43.8-4s29.6 1.4 43.8 4c3.2 .6 5.6 3.1 6.2 6.2l8.5 42.6c.6 2.8 2.6 5.1 5.4 6.1c6.5 2.3 12.8 4.9 18.9 7.9c2.6 1.2 5.7 1.1 8.1-.5l36.1-24.1c2.7-1.8 6.2-1.8 8.8 0c11.9 8.2 23.1 17.5 33.4 27.7l.9 .9c10.2 10.2 19.5 21.4 27.7 33.4zM176 256a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zm176 0a96 96 0 1 0 -192 0 96 96 0 1 0 192 0z"],
    "file-magnifying-glass": [384, 512, ["file-search"], "f865", "M64 496c-26.5 0-48-21.5-48-48V64c0-26.5 21.5-48 48-48H204.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H367.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48H64zM358.6 157.3c.9 .9 1.7 1.8 2.4 2.7H248c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L358.6 157.3zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L238.1 14.1c-9-9-21.2-14.1-33.9-14.1H64zM176 240a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176c23.6 0 45.3-8.5 62-22.7l52.4 52.4c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3L249.3 382c14.2-16.7 22.7-38.4 22.7-62c0-53-43-96-96-96s-96 43-96 96s43 96 96 96z"],
    "up-right": [384, 512, [], "e2be", "M336 96c8.8 0 16 7.2 16 16V347.7c0 11.2-9.1 20.3-20.3 20.3c-5.4 0-10.5-2.1-14.3-5.9l-75.7-75.7c-3.1-3.1-8.2-3.1-11.3 0L93.7 423c-5.7 5.7-13.5 9-21.7 9s-15.9-3.2-21.7-9L25 397.6c-5.7-5.7-9-13.5-9-21.7s3.2-15.9 9-21.7L161.7 217.7c1.5-1.5 2.3-3.5 2.3-5.7s-.8-4.2-2.3-5.7L85.9 130.6c-3.8-3.8-5.9-9-5.9-14.3C80 105.1 89.1 96 100.3 96H336zm32 16c0-17.7-14.3-32-32-32H100.3C80.2 80 64 96.2 64 116.3c0 9.6 3.8 18.9 10.6 25.7L144.7 212 13.7 343C4.9 351.8 0 363.6 0 376s4.9 24.2 13.7 33L39 434.3c8.7 8.7 20.6 13.7 33 13.7s24.2-4.9 33-13.7l131-131 70.1 70.1c6.8 6.8 16 10.6 25.7 10.6c20 0 36.3-16.2 36.3-36.3V112z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M256 16a240 240 0 1 1 0 480 240 240 0 1 1 0-480zm0 496A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM381.7 290.3l-120-120c-3.1-3.1-8.2-3.1-11.3 0l-120 120c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L256 187.3 370.3 301.7c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3z"],
    "user-police": [448, 512, [], "e333", "M222.1 16.2L62.2 52.1c-2.8 .6-5.1 2.8-5.9 5.6s-.1 5.8 2 7.9L87.5 95.1c1.5 1.5 2.3 3.5 2.3 5.6v26.9c15.7 10.2 46.4 27 105.5 31.3C173.9 138.5 168 110.1 168 91.2c0-3.3 2-6.2 5-7.4l48-19.2c1.9-.8 4-.8 5.9 0l48 19.2c3 1.2 5 4.2 5 7.4c0 18.9-5.9 47.3-27.2 67.6c59-4.3 89.6-21.1 105.2-31.2V100.7c0-2.1 .8-4.1 2.3-5.6l29.1-29.5c2-2.1 2.8-5.1 2-7.9s-3.1-4.9-5.9-5.6l-159.9-36c-1.2-.3-2.4-.3-3.5 0zM366.8 140.9c-20.3 13.2-60.7 34.6-141.1 34.9c-1.1 .2-2.3 .2-3.4 0c-80.6-.3-121-21.7-141.3-34.9c-4.6-3-7.2-8-7.2-13.3V104L46.9 76.8c-6.1-6.2-8.4-15.2-6-23.6s9.3-14.8 17.8-16.7L218.6 .6c3.5-.8 7.1-.8 10.5 0L389 36.5c8.5 1.9 15.3 8.3 17.8 16.7s.2 17.4-6 23.6L374 104v23.6c0 5.3-2.6 10.3-7.2 13.3zM96.3 183.3c4.8 2.3 10.1 4.5 15.7 6.7c0 .7 0 1.3 0 2c0 61.9 50.1 112 112 112s112-50.1 112-112c0-.7 0-1.3 0-2c5.7-2.2 10.9-4.4 15.7-6.7c.2 2.9 .3 5.8 .3 8.7c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-2.9 .1-5.8 .3-8.7zm87.9-86.8c1.3 20.9 10.8 49 39.8 62.7c29-13.7 38.5-41.8 39.8-62.7L224 80.6 184.2 96.5zM213.5 444l-86.6-75.8C65 372.1 16 423.5 16 486.4c0 5.3 4.3 9.6 9.6 9.6H216V446.3l-2.5-2.2zM232 496H422.4c5.3 0 9.6-4.3 9.6-9.6c0-62.8-49-114.3-110.8-118.2L234.5 444l-2.5 2.2V496zm190.4 16H224.2l-.2 0-.2 0H25.6C11.5 512 0 500.5 0 486.4C0 412.8 59.2 353 132.6 352L224 432l91.4-80C388.8 353 448 412.8 448 486.4c0 14.1-11.5 25.6-25.6 25.6zM360 424v16h16c4.4 0 8 3.6 8 8s-3.6 8-8 8H360v16c0 4.4-3.6 8-8 8s-8-3.6-8-8V456H328c-4.4 0-8-3.6-8-8s3.6-8 8-8h16V424c0-4.4 3.6-8 8-8s8 3.6 8 8z"],
    "lari-sign": [384, 512, [], "e1c8", "M136 32c4.4 0 8 3.6 8 8v62.4c15.9-4.2 32.6-6.4 49.9-6.4c10.3 0 20.3 .8 30.1 2.3V40c0-4.4 3.6-8 8-8s8 3.6 8 8v61.5c72.4 17.5 128.9 75.3 143.8 148.1c.9 4.3-1.9 8.6-6.2 9.4s-8.6-1.9-9.4-6.2C354.8 187.4 304.7 135.1 240 118l0 162c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-165.5c-9.8-1.7-19.9-2.5-30.1-2.5c-17.3 0-34 2.4-49.9 7l0 161c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-155.5C62.3 150.4 16 213.9 16 288c0 97.1 79.6 176 177.9 176H376c4.4 0 8 3.6 8 8s-3.6 8-8 8H193.9 8c-4.4 0-8-3.6-8-8s3.6-8 8-8H116.3C47.9 434.4 0 366.8 0 288c0-83.2 53.4-153.9 128-180.6V40c0-4.4 3.6-8 8-8z"],
    "volcano": [512, 512, [127755], "f770", "M210.9 47.4c-1 2.7-3.4 4.7-6.2 5.1s-5.7-.6-7.5-2.8C188.4 38.9 175 32 160 32c-26.5 0-48 21.5-48 48s21.5 48 48 48c13.1 0 25-5.2 33.6-13.8c1.7-1.7 4.1-2.5 6.5-2.2s4.5 1.6 5.8 3.7l32.2 50.6c3.9 6.1 10.6 9.8 17.8 9.8s14-3.7 17.8-9.8L306 115.7c1.3-2 3.4-3.4 5.8-3.7s4.8 .5 6.5 2.2C327 122.8 338.9 128 352 128c26.5 0 48-21.5 48-48s-21.5-48-48-48c-15 0-28.4 6.9-37.2 17.7c-1.8 2.2-4.7 3.3-7.5 2.8s-5.2-2.4-6.2-5.1C294.3 29.1 276.7 16 256 16s-38.3 13.1-45.1 31.4zM256 0c23.3 0 43.6 12.4 54.8 31C322 21.6 336.3 16 352 16c35.3 0 64 28.7 64 64s-28.7 64-64 64c-14 0-26.9-4.5-37.4-12.1l-27.3 42.9C280.5 185.5 268.7 192 256 192s-24.5-6.5-31.3-17.2l-27.3-42.9C186.9 139.5 174 144 160 144c-35.3 0-64-28.7-64-64s28.7-64 64-64c15.7 0 30 5.6 41.2 15C212.4 12.4 232.7 0 256 0zM16 459.8c0 20 16.2 36.2 36.2 36.2H459.8c20 0 36.2-16.2 36.2-36.2c0-8.9-3.3-17.4-9.1-24L390.1 326.9 362 369c-6.3 9.4-16.8 15-28 15c-8.9 0-17.5-3.6-23.8-9.9l-34.5-34.5C263.1 327.1 246 320 228.3 320c-13.2 0-26.1 3.9-37.1 11.2l-17.8 11.9c-8.7 5.8-18.9 8.9-29.3 8.9s-20.6-3.1-29.3-8.9l-4.5-3L25.1 435.8c-5.9 6.6-9.1 15.2-9.1 24zm332.7-99.7l30.4-45.6-42.4-47.7c-15.2-17.1-36.9-26.9-59.8-26.9H235.1c-22.9 0-44.6 9.8-59.8 26.9L120.9 328l2.6 1.8c6.1 4 13.2 6.2 20.4 6.2s14.4-2.2 20.4-6.2l17.8-11.9c13.6-9.1 29.6-13.9 46-13.9c22 0 43.1 8.7 58.7 24.3l34.5 34.5c3.3 3.3 7.8 5.2 12.5 5.2c5.9 0 11.4-3 14.7-7.9zm-.1-103.9l39.6 44.6 0 0 11 12.4 0 0 99.6 112c8.5 9.5 13.2 21.9 13.2 34.7c0 28.8-23.4 52.2-52.2 52.2H52.2C23.4 512 0 488.6 0 459.8c0-12.8 4.7-25.1 13.2-34.7l83.6-94 0 0 10.7-12.1 0 0 55.9-62.9c18.2-20.5 44.3-32.2 71.8-32.2h41.8c27.4 0 53.5 11.7 71.8 32.2z"],
    "teddy-bear": [576, 512, [], "e3cf", "M144 64c0 16.8 8.6 31.6 21.7 40.2c2.7 1.8 4 4.9 3.5 8.1c-.8 4.5-1.2 9.3-1.2 14.4C168 188 220.4 240 288 240s120-52 120-113.3c0-5.2-.4-10-1.2-14.4c-.6-3.1 .8-6.3 3.5-8.1C423.4 95.6 432 80.8 432 64c0-26.5-21.5-48-48-48c-20.3 0-37.8 12.7-44.7 30.6c-1.4 3.6-5.1 5.6-8.9 5C316.3 49 301.7 48 288 48s-28.3 1-42.4 3.5c-3.8 .7-7.5-1.4-8.9-5C229.8 28.7 212.3 16 192 16c-26.5 0-48 21.5-48 48zM192 0c24.8 0 46.3 14.1 56.9 34.8c13.2-2 26.5-2.8 39.1-2.8s25.8 .8 39.1 2.8C337.7 14.1 359.2 0 384 0c35.3 0 64 28.7 64 64c0 20.5-9.7 38.8-24.7 50.5c.5 3.9 .7 7.9 .7 12.1C424 197.4 363.8 256 288 256s-136-58.6-136-129.3c0-4.2 .2-8.2 .7-12.1c-15-11.7-24.7-30-24.7-50.5c0-35.3 28.7-64 64-64zm72 168c0 3.5 1.9 7.4 6.2 10.6s10.6 5.4 17.8 5.4s13.5-2.2 17.8-5.4s6.2-7 6.2-10.6s-1.9-7.4-6.2-10.6s-10.6-5.4-17.8-5.4s-13.5 2.2-17.8 5.4s-6.2 7-6.2 10.6zm24-32c10.4 0 20.1 3.2 27.4 8.6s12.6 13.7 12.6 23.4s-5.3 17.9-12.6 23.4s-17 8.6-27.4 8.6s-20.1-3.2-27.4-8.6s-12.6-13.7-12.6-23.4s5.3-17.9 12.6-23.4s17-8.6 27.4-8.6zM61 196.3c24.2-19.3 59.4-15.4 78.7 8.7l10.8 13.5c70.5 88.1 204.4 88.1 274.9 0L436.3 205c19.3-24.2 54.6-28.1 78.7-8.7s28.1 54.6 8.7 78.7l-10.8 13.5c-27.4 34.2-60.6 60.3-96.9 78.3V400h48.6c3.9-27.1 27.2-48 55.4-48c30.9 0 56 25.1 56 56c0 33.7-14.7 66.8-24.3 85c-6.6 12.4-19.5 19-32.8 19H472l-.1 0H104.1l-.1 0H57.1c-13.3 0-26.2-6.7-32.8-19C14.7 474.8 0 441.7 0 408c0-30.9 25.1-56 56-56c28.2 0 51.6 20.9 55.4 48H160V366.8c-36.3-18-69.5-44.1-96.9-78.3L52.3 275C33 250.8 36.9 215.6 61 196.3zM103.9 496l.1 0H216V472c0-30.9-25.1-56-56-56v0H104c-4.4 0-8-3.6-8-8c0-22.1-17.9-40-40-40s-40 17.9-40 40c0 29.7 13.2 59.9 22.5 77.5C41.9 492 49 496 57.1 496h46.8zM176 401.8c9.1 2.1 17.5 5.8 24.9 10.9c5.4-34.4 35.2-60.7 71.1-60.7h32c35.9 0 65.7 26.3 71.1 60.7c7.4-5.1 15.8-8.9 24.9-10.9v-40c0-3.1 1.8-5.9 4.6-7.2c35.9-17 68.9-42.3 95.8-76L511.2 265c13.8-17.3 11-42.4-6.2-56.2s-42.4-11-56.2 6.2l-10.8 13.5c-76.9 96.1-223 96.1-299.9 0L127.2 215c-13.8-17.3-39-20-56.2-6.2s-20 39-6.2 56.2l10.8 13.5c26.9 33.7 59.9 59 95.8 76c2.8 1.3 4.6 4.1 4.6 7.2v40zm40 25c10 12.4 16 28.1 16 45.3v24H344V472c0-17.1 6-32.9 16-45.3V424c0-30.9-25.1-56-56-56H272c-30.9 0-56 25.1-56 56v2.7zM416 416c-30.9 0-56 25.1-56 56v24H472l.1 0h46.8c8.1 0 15.2-4 18.7-10.5c9.3-17.6 22.5-47.8 22.5-77.5c0-22.1-17.9-40-40-40s-40 17.9-40 40c0 4.4-3.6 8-8 8H416v0zM240 100a12 12 0 1 1 0 24 12 12 0 1 1 0-24zm84 12a12 12 0 1 1 24 0 12 12 0 1 1 -24 0z"],
    "stocking": [384, 512, [], "f7d5", "M96 16H352c8.8 0 16 7.2 16 16V80c0 8.8-7.2 16-16 16H96c-8.8 0-16-7.2-16-16V32c0-8.8 7.2-16 16-16zM64 32V80c0 17.7 14.3 32 32 32H352c17.7 0 32-14.3 32-32V32c0-17.7-14.3-32-32-32H96C78.3 0 64 14.3 64 32zm48 206.9V144H96v94.9c0 10.7-5.3 20.7-14.2 26.6L55.7 282.9C20.9 306.1 0 345.1 0 386.9v2.2C0 457 55 512 122.8 512c24.2 0 48-7.2 68.1-20.6L295 422c35.6-23.7 57-63.7 57-106.5V144H336V315.5c0 37.4-18.7 72.4-49.9 93.2L182.1 478.1c-17.5 11.7-38.2 17.9-59.3 17.9C63.8 496 16 448.2 16 389.2v-2.2c0-36.5 18.2-70.5 48.6-90.7l26.1-17.4c13.4-8.9 21.4-23.9 21.4-39.9z"],
    "person-walking-dashed-line-arrow-right": [640, 512, [], "e553", "M137.1 187.3c-4.6-4-11-5.1-16.6-2.8c-1.1 .5-2.2 .9-3.4 1.4l0 0-5.7 2.5c-21.6 9.6-37.9 28.3-44.4 51.1l-3.7 12.9c-2.4 8.5-11.3 13.4-19.8 11s-13.4-11.3-11-19.8l3.7-12.9c9.1-31.9 31.9-58.1 62.2-71.6l5.7-2.5c18.8-8.3 39-12.6 59.6-12.6c38.1 0 72.5 22.9 87.1 58.1l16.5 39.7c1.1 2.6 2.9 4.9 5.2 6.6l25 18.8c7.1 5.3 8.5 15.3 3.2 22.4s-15.3 8.5-22.4 3.2l-28.5-21.4c-4.6-3.4-8.1-8-10.3-13.3l-10.2-24.5c-2.6-6.3-8.9-10.2-15.6-9.8s-12.6 5-14.5 11.5L180 300.8c-1.6 5.4-.2 11.2 3.6 15.3l49.5 54c3.6 3.9 6.2 8.7 7.5 13.9l23 92.1c2.1 8.6-3.1 17.3-11.6 19.4s-17.3-3.1-19.4-11.6l-22-88.1c-.6-2.6-1.9-5-3.7-6.9l-70.7-77.1c-11.1-12.1-15.2-29-11-44.8L142 203.4c1.6-5.9-.3-12.1-4.9-16.1zM208 16a36 36 0 1 1 0 72 36 36 0 1 1 0-72zM107.4 209c3.3-2.3 6.8-4.3 10.6-6l5.7-2.5c1-.4 1.9-.8 2.9-1.2l-1.3 4.8-2.5 9.6-1.5 5.6-11.6 43.6c-5.6 21.1-.1 43.6 14.7 59.7l70.7 77.1 22 88.1c4.3 17.1 21.7 27.6 38.8 23.3s27.6-21.7 23.3-38.8l-23-92.1c-1.9-7.8-5.8-14.9-11.2-20.8l-49.5-54 12.1-41.2 7.2-24.4 9.8 23.5 .4 1c3.3 7.9 8.7 14.8 15.5 19.9l28.5 21.4c14.1 10.6 34.2 7.7 44.8-6.4s7.7-34.2-6.4-44.8l-25-18.8-16.5-39.7C248.5 154.8 208.3 128 163.7 128c-22.8 0-45.3 4.8-66.1 14L92 144.5c-34.6 15.4-60.7 45.3-71.1 81.8l-3.7 12.9c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l3.7-12.9c4.1-14.3 13-26.6 24.9-34.9zM260 52A52 52 0 1 0 156 52a52 52 0 1 0 104 0zM99 343.9c-4.1-1.6-8.8 .4-10.4 4.5L68.7 398 9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l61.7-61.7c4.6-4.6 8.2-10.1 10.6-16.1L142.1 387c1.6-4.1-.4-8.8-4.5-10.4s-8.8 .4-10.4 4.5l-15.1 37.9c-1.6 4-4 7.7-7.1 10.7L43.3 491.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l60.5-60.5 1.2-1.2 .6-1.5 20.5-51.1c1.6-4.1-.4-8.8-4.5-10.4zM400 8c0-4.4-3.6-8-8-8s-8 3.6-8 8V88c0 4.4 3.6 8 8 8s8-3.6 8-8V8zM541.1 169.9c-3.4-2.8-8.4-2.4-11.3 1s-2.4 8.4 1 11.3l79 65.9H392c-4.4 0-8 3.6-8 8s3.6 8 8 8H609.9l-79 65.9c-3.4 2.8-3.9 7.9-1 11.3s7.9 3.9 11.3 1l96-80c1.8-1.5 2.9-3.8 2.9-6.1s-1.1-4.6-2.9-6.1l-96-80zM392 128c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8s8-3.6 8-8V136c0-4.4-3.6-8-8-8zm8 200c0-4.4-3.6-8-8-8s-8 3.6-8 8v48c0 4.4 3.6 8 8 8s8-3.6 8-8V328zm-8 88c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8s8-3.6 8-8V424c0-4.4-3.6-8-8-8z"],
    "image-slash": [640, 512, [], "e1b7", "M13 1.7C9.5-1 4.5-.4 1.7 3S-.4 11.5 3 14.3l624 496c3.5 2.7 8.5 2.2 11.2-1.3s2.2-8.5-1.3-11.2L13 1.7zM467.3 464h-280L310.8 340.5l-12.6-10L288 340.7l-73.4-73.4c-12.5-12.5-32.8-12.5-45.3 0L80 356.7V158.3L64 145.6V416c0 35.3 28.7 64 64 64H487.5l-20.3-16zM512 32H152.5l20.3 16H512c26.5 0 48 21.5 48 48V292.7l-89.4-89.4c-12.5-12.5-32.8-12.5-45.3 0L400.7 228l12.6 10 23.3-23.3c6.2-6.2 16.4-6.2 22.6 0L560 315.3v38.4l16 12.6V96c0-35.3-28.7-64-64-64zM80 379.3L180.7 278.6c6.2-6.2 16.4-6.2 22.6 0L276.7 352l-112 112H128c-26.5 0-48-21.5-48-48V379.3z"],
    "mask-snorkel": [576, 512, [], "e3b7", "M536 48c-13.3 0-24 10.7-24 24v72h48V72c0-13.3-10.7-24-24-24zM512 160v32h48V160H512zm0 207.3c0 44.5-36.1 80.7-80.7 80.7c-39 0-72.4-27.9-79.4-66.2l-.4-2.1c-2.4-13-14.9-21.7-27.9-19.3s-21.7 14.9-19.3 27.9l.4 2.1C315.9 451.5 369.2 496 431.3 496C502.4 496 560 438.4 560 367.3V208H512V367.3zM536 32c22.1 0 40 17.9 40 40V367.3C576 447.2 511.2 512 431.3 512c-69.9 0-129.8-50-142.3-118.8l-.4-2.1c-4-21.7 10.5-42.6 32.2-46.5s42.6 10.5 46.5 32.2l.4 2.1c5.6 30.7 32.4 53.1 63.6 53.1c35.7 0 64.7-28.9 64.7-64.7V72c0-22.1 17.9-40 40-40zM64 80c-26.5 0-48 21.5-48 48v96c0 26.5 21.5 48 48 48h79.7c21.4 0 40.3-14.2 46.2-34.8l3.4-11.7c8.8-30.9 52.7-30.9 61.5 0l3.4 11.7c5.9 20.6 24.7 34.8 46.2 34.8H384c26.5 0 48-21.5 48-48V128c0-26.5-21.5-48-48-48H64zM0 128C0 92.7 28.7 64 64 64H384c35.3 0 64 28.7 64 64v96c0 35.3-28.7 64-64 64H304.3c-28.6 0-53.7-18.9-61.5-46.4l-3.4-11.7c-4.4-15.5-26.3-15.5-30.8 0l-3.4 11.7c-7.9 27.5-33 46.4-61.5 46.4H64c-35.3 0-64-28.7-64-64V128z"],
    "smoke": [640, 512, [], "f760", "M48 128c0 32.8 14.1 62.3 36.6 82.8c-5.4 2-10.7 4.4-15.8 6.9C46 194.7 32 163 32 128C32 57.3 89.3 0 160 0c40.1 0 75.9 18.4 99.3 47.3C277.4 37.5 298.1 32 320 32c47.2 0 88.4 25.6 110.6 63.6c-4.5 2.9-8.9 6-13.1 9.3C398.3 70.9 361.8 48 320 48c-21.5 0-41.5 6-58.6 16.5c-3.6 2.2-8.2 1.3-10.7-2.1C230.4 34.3 197.3 16 160 16C98.1 16 48 66.1 48 128zm464-16c-44 0-82.1 25.4-100.4 62.3c-1.1 2.3-3.3 3.9-5.9 4.3s-5.1-.4-6.9-2.2C378.6 156.4 350.7 144 320 144c-47.7 0-88.5 29.8-104.6 71.9c-4.8-2.3-9.7-4.3-14.8-6.1c18.5-47.9 65-81.8 119.4-81.8c31.3 0 60.1 11.3 82.3 30c22.4-37.1 63.1-62 109.7-62c70.7 0 128 57.3 128 128c0 45.1-23.3 84.7-58.5 107.5c-2.7-4.6-5.7-9.1-8.9-13.3C603.5 298.2 624 263.5 624 224c0-61.9-50.1-112-112-112zM144 240C73.3 240 16 297.3 16 368s57.3 128 128 128H464c53 0 96-43 96-96s-43-96-96-96c-11.3 0-22.1 2-32.2 5.5c-3.9 1.4-8.2-.4-10-4.2C404.1 266.8 365.2 240 320 240c-30.9 0-58.9 12.5-79.2 32.8c-3 3-7.9 3.1-11 .3c-22.7-20.5-52.8-33-85.8-33zM0 368c0-79.5 64.5-144 144-144c34.5 0 66.2 12.1 90.9 32.3C257.5 236.2 287.4 224 320 224c49.1 0 91.8 27.7 113.2 68.3c9.8-2.8 20.1-4.3 30.8-4.3c61.9 0 112 50.1 112 112s-50.1 112-112 112H144C64.5 512 0 447.5 0 368z"],
    "sterling-sign": [320, 512, [163, "gbp", "pound-sign"], "f154", "M80 143.2C80 90.6 122.6 48 175.2 48c10.2 0 20.4 1.7 30.1 4.9l80.1 26.7c4.2 1.4 8.7-.9 10.1-5.1s-.9-8.7-5.1-10.1L210.4 37.7c-11.3-3.8-23.2-5.7-35.2-5.7C113.8 32 64 81.8 64 143.2V256H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H63.8C61.7 341.6 40.1 409.4 1.4 467.5C.5 468.8 0 470.3 0 472c0 4.4 3.6 8 8 8H312c4.4 0 8-3.6 8-8s-3.6-8-8-8H22.6c35.5-57.9 55.2-124.1 57.2-192H248c4.4 0 8-3.6 8-8s-3.6-8-8-8H80V143.2z"],
    "battery-exclamation": [576, 512, [], "e0b0", "M448 112c35.3 0 64 28.7 64 64v16 16 96 16 16c0 35.3-28.7 64-64 64H80c-35.3 0-64-28.7-64-64V176c0-35.3 28.7-64 64-64H448zm80 224V320h16c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32H528V176c0-44.2-35.8-80-80-80H80C35.8 96 0 131.8 0 176V336c0 44.2 35.8 80 80 80H448c44.2 0 80-35.8 80-80zm0-32V208h16c8.8 0 16 7.2 16 16v64c0 8.8-7.2 16-16 16H528zM272 144c-4.4 0-8 3.6-8 8V296c0 4.4 3.6 8 8 8s8-3.6 8-8V152c0-4.4-3.6-8-8-8zm16 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "viruses": [640, 512, [], "e076", "M200 24c0-4.4-3.6-8-8-8s-8 3.6-8 8V37.5c0 49.9-60.3 74.9-95.6 39.6l-9.5-9.5c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l9.5 9.5C112.4 123.7 87.4 184 37.5 184H24c-4.4 0-8 3.6-8 8s3.6 8 8 8H37.5c49.9 0 74.9 60.3 39.6 95.6l-9.5 9.5c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l9.5-9.5c35.3-35.3 95.6-10.3 95.6 39.6V360c0 4.4 3.6 8 8 8s8-3.6 8-8V346.5c0-49.9 60.3-74.9 95.6-39.6l9.5 9.5c3.1 3.1 8.2 3.1 11.3 0s3.1-8.2 0-11.3l-9.5-9.5c-35.3-35.3-10.3-95.6 39.6-95.6H360c4.4 0 8-3.6 8-8s-3.6-8-8-8H346.5c-49.9 0-74.9-60.3-39.6-95.6l9.5-9.5c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-9.5 9.5C260.3 112.4 200 87.4 200 37.5V24zM192 0c13.3 0 24 10.7 24 24V37.5c0 35.6 43.1 53.5 68.3 28.3l9.5-9.5c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-9.5 9.5C293 124.9 310.9 168 346.5 168H360c13.3 0 24 10.7 24 24s-10.7 24-24 24H346.5c-35.6 0-53.5 43.1-28.3 68.3l9.5 9.5c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-9.5-9.5C259.1 293 216 310.9 216 346.5V360c0 13.3-10.7 24-24 24s-24-10.7-24-24V346.5c0-35.6-43.1-53.5-68.3-28.3l-9.5 9.5c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l9.5-9.5C91 259.1 73.1 216 37.5 216H24c-13.3 0-24-10.7-24-24s10.7-24 24-24H37.5c35.6 0 53.5-43.1 28.3-68.3l-9.5-9.5c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l9.5 9.5C124.9 91 168 73.1 168 37.5V24c0-13.3 10.7-24 24-24zM480 368a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM240 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-80-56a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm40 24a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM575.2 266.2c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6C574.5 312.1 591 352 624 352c8.8 0 16 7.2 16 16s-7.2 16-16 16c-33 0-49.5 39.9-26.2 63.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0C551.9 446.5 512 463 512 496c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-33-39.9-49.5-63.2-26.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6C417.5 423.9 401 384 368 384c-8.8 0-16-7.2-16-16s7.2-16 16-16c33 0 49.5-39.9 26.2-63.2c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0C440.1 289.5 480 273 480 240c0-8.8 7.2-16 16-16s16 7.2 16 16c0 33 39.9 49.5 63.2 26.2zM405.5 277.5c33.4 33.4 9.7 90.5-37.5 90.5c47.2 0 70.9 57.1 37.5 90.5c33.4-33.4 90.5-9.7 90.5 37.5c0-47.2 57.1-70.9 90.5-37.5C553.1 425.1 576.8 368 624 368c-47.2 0-70.9-57.1-37.5-90.5c-17.6 17.6-41.9 19.4-60.8 10.1c-17-8.3-29.7-25.3-29.7-47.6c0 47.2-57.1 70.9-90.5 37.5z"],
    "square-person-confined": [448, 512, [], "e577", "M64 48C37.5 48 16 69.5 16 96V416c0 26.5 21.5 48 48 48H384c26.5 0 48-21.5 48-48V96c0-26.5-21.5-48-48-48H64zM0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96zM228.7 318.1l-41.4-41.4c-3.6-3.6-8.8-5.3-13.9-4.5s-9.4 4-11.7 8.6l-48 96c-4 7.9-.7 17.5 7.2 21.5s17.5 .7 21.5-7.2l28.1-56.3c2.3-4.6 6.7-7.8 11.7-8.6s10.2 .8 13.9 4.5l54.7 54.7c9.4 9.4 22.1 14.6 35.3 14.6c27.6 0 49.9-22.4 49.9-49.9V248c0-22.1-17.9-40-40-40s-40 17.9-40 40v58.7c0 6.5-3.9 12.3-9.9 14.8s-12.9 1.1-17.4-3.5zM240 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-.6 252.7l-42.7-42.7L184.8 342l-7.5 15.1-20.6 41.2c-7.9 15.8-27.1 22.2-42.9 14.3s-22.2-27.1-14.3-42.9l48-96c4.6-9.2 13.3-15.6 23.5-17.3s20.5 1.7 27.8 9L224 290.7l16 16V284.1 248c0-30.9 25.1-56 56-56s56 25.1 56 56V350.1c0 36.4-29.5 65.9-65.9 65.9c-17.5 0-34.3-6.9-46.6-19.3zM208 96a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "user-tie": [448, 512, [], "f508", "M224 240a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM352 128A128 128 0 1 1 96 128a128 128 0 1 1 256 0zM176.9 308.3c1.4-2.7 4.1-4.3 7.1-4.3h80c3 0 5.7 1.7 7.1 4.3s1.1 5.9-.6 8.3l-37.2 52.1 23.2 46.3 47.1-94.2c81.2 8.4 144.4 77 144.4 160.4c0 17-13.8 30.7-30.7 30.7H225.9h-3.8H30.7C13.8 512 0 498.2 0 481.3c0-83.4 63.3-152 144.4-160.4l47.1 94.2 23.2-46.3-37.2-52.1c-1.7-2.4-2-5.6-.6-8.3zM199.5 320L224 354.2 248.5 320H199.5zm10.1 167.2L135.3 338.3C67.5 350.6 16 409.9 16 481.3c0 8.1 6.6 14.7 14.7 14.7H214.1l-4.4-8.8zm-9.2-54.2l14.6 29.2L224 480l8.9-17.9 14.6-29.2L224 385.9l-23.5 47.1zM432 481.3c0-71.4-51.5-130.7-119.3-143L238.3 487.2l-4.4 8.8H417.3c8.1 0 14.7-6.6 14.7-14.7z"],
    "arrow-down-long": [384, 512, ["long-arrow-down"], "f175", "M186.3 509.7c3.1 3.1 8.2 3.1 11.3 0l152-152c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0L200 484.7 200 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 476.7L45.7 346.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l152 152z"],
    "tent-arrow-down-to-line": [640, 512, [], "e57e", "M245.9 122.6c-3-3.3-8-3.5-11.3-.5L152 197.8 152 8c0-4.4-3.6-8-8-8s-8 3.6-8 8l0 189.8L53.4 122.1c-3.3-3-8.3-2.8-11.3 .5s-2.8 8.3 .5 11.3l96 88c3.1 2.8 7.8 2.8 10.8 0l96-88c3.3-3 3.5-8 .5-11.3zM0 504c0 4.4 3.6 8 8 8H632c4.4 0 8-3.6 8-8s-3.6-8-8-8H8c-4.4 0-8 3.6-8 8zM388.6 129.5c-2.8-2-6.5-2-9.2 0L198.8 257.4c-9.1 6.4-15.1 16.4-16.5 27.5L160.1 455c-.6 4.4 2.5 8.4 6.9 9s8.4-2.5 9-6.9l22.2-170.1c.9-6.6 4.5-12.6 9.9-16.5l168-119V287.9c0 .1 0 .2 0 .3V456c0 4.4 3.6 8 8 8s8-3.6 8-8V316.1l89.2 144.1c2.3 3.8 7.3 4.9 11 2.6s4.9-7.3 2.6-11L392 285.7V151.5l168 119c5.5 3.9 9.1 9.8 9.9 16.5L592.1 457c.6 4.4 4.6 7.5 9 6.9s7.5-4.6 6.9-9L585.7 284.8c-1.4-11.1-7.4-21-16.5-27.5L388.6 129.5z"],
    "certificate": [512, 512, [], "f0a3", "M162.7 94.5c3.7-2.2 6.4-5.7 7.5-9.9L186.1 22c.7-2.8 2.9-5 5.7-5.8s5.8 .1 7.8 2.1l45 46.2c3 3.1 7.1 4.8 11.5 4.8s8.5-1.7 11.5-4.8l45-46.2c2-2.1 5-2.9 7.8-2.1s5 3 5.7 5.8l15.8 62.5c1.1 4.2 3.8 7.8 7.5 9.9s8.2 2.7 12.3 1.5l62-17.5c2.8-.8 5.8 0 7.8 2s2.8 5 2 7.8l-17.5 62c-1.2 4.2-.6 8.6 1.5 12.3s5.7 6.4 9.9 7.5L490 186.1c2.8 .7 5 2.9 5.8 5.7s-.1 5.8-2.1 7.8l-46.2 45c-3.1 3-4.8 7.1-4.8 11.5s1.7 8.5 4.8 11.5l46.2 45c2.1 2 2.9 5 2.1 7.8s-3 5-5.8 5.7l-62.5 15.8c-4.2 1.1-7.8 3.8-9.9 7.5s-2.7 8.2-1.5 12.3l17.5 62c.8 2.8 0 5.8-2 7.8s-5 2.8-7.8 2l-62-17.5c-4.2-1.2-8.6-.6-12.3 1.5s-6.4 5.7-7.5 9.9L325.9 490c-.7 2.8-2.9 5-5.7 5.8s-5.8-.1-7.8-2.1l-45-46.2c-3-3.1-7.1-4.8-11.5-4.8s-8.5 1.7-11.5 4.8l-45 46.2c-2 2.1-5 2.9-7.8 2.1s-5-3-5.7-5.8l-15.8-62.5c-1.1-4.2-3.8-7.8-7.5-9.9s-8.2-2.7-12.3-1.5l-62 17.5c-2.8 .8-5.8 0-7.8-2s-2.8-5-2-7.8l17.5-62c1.2-4.2 .6-8.6-1.5-12.3s-5.7-6.4-9.9-7.5L22 325.9c-2.8-.7-5-2.9-5.8-5.7s.1-5.8 2.1-7.8l46.2-45c3.1-3 4.8-7.1 4.8-11.5s-1.7-8.5-4.8-11.5l-46.2-45c-2.1-2-2.9-5-2.1-7.8s3-5 5.8-5.7l62.5-15.8c4.2-1.1 7.8-3.8 9.9-7.5s2.7-8.2 1.5-12.3l-17.5-62c-.8-2.8 0-5.8 2-7.8s5-2.8 7.8-2l62 17.5c4.2 1.2 8.6 .6 12.4-1.5zM244.8 42L211 7.3C205 1 196-1.4 187.6 .8s-14.9 8.9-17.1 17.3l-11.9 47-3.9 15.5-15.4-4.4L92.7 63.1c-8.4-2.4-17.4 0-23.5 6.1s-8.5 15.1-6.1 23.5l13.2 46.6 4.4 15.4-15.5 3.9-47 11.9c-8.4 2.1-15 8.7-17.3 17.1S1 205 7.3 211L42 244.8 53.5 256 42 267.2 7.3 301C1 307-1.4 316 .8 324.4s8.9 14.9 17.3 17.1l47 11.9 15.5 3.9-4.4 15.4L63.1 419.3c-2.4 8.4 0 17.4 6.1 23.5s15.1 8.5 23.5 6.1l46.6-13.2 15.4-4.4 3.9 15.5 11.9 47c2.1 8.4 8.7 15 17.1 17.3s17.3-.2 23.4-6.4L244.8 470 256 458.5 267.2 470 301 504.7c6.1 6.2 15 8.7 23.4 6.4s14.9-8.9 17.1-17.3l11.9-47 3.9-15.5 15.4 4.4 46.6 13.2c8.4 2.4 17.4 0 23.5-6.1s8.5-15.1 6.1-23.5l-13.2-46.6-4.4-15.4 15.5-3.9 47-11.9c8.4-2.1 15-8.7 17.3-17.1s-.2-17.4-6.4-23.4L470 267.2 458.5 256 470 244.8 504.7 211c6.2-6.1 8.7-15 6.4-23.4s-8.9-14.9-17.3-17.1l-47-11.9-15.5-3.9 4.4-15.4 13.2-46.6c2.4-8.4 0-17.4-6.1-23.5s-15.1-8.5-23.5-6.1L372.7 76.2l-15.4 4.4-3.9-15.5-11.9-47c-2.1-8.4-8.7-15-17.1-17.3S307 1 301 7.3L267.2 42 256 53.5 244.8 42z"],
    "crystal-ball": [448, 512, [], "e362", "M432 224c0 55.9-22 106.6-57.9 144h21.5c32.7-38.9 52.4-89.2 52.4-144C448 100.3 347.7 0 224 0S0 100.3 0 224c0 54.8 19.7 105.1 52.4 144H73.9C38 330.6 16 279.9 16 224C16 109.1 109.1 16 224 16s208 93.1 208 208zM80 400c-2.7 0-5.2 1.3-6.7 3.6L28.4 470.9c-2.9 4.3-4.4 9.4-4.4 14.7C24 500.2 35.8 512 50.4 512H397.6c14.6 0 26.4-11.8 26.4-26.4c0-5.2-1.5-10.3-4.4-14.7l-44.9-67.4c-1.5-2.2-4-3.6-6.7-3.6H80zM41.8 479.8L84.3 416H363.7l42.5 63.8c1.1 1.7 1.8 3.7 1.8 5.8c0 5.8-4.7 10.4-10.4 10.4H50.4c-5.8 0-10.4-4.7-10.4-10.4c0-2.1 .6-4.1 1.8-5.8zM288 152c-4.4 0-8 3.6-8 8v56H224c-4.4 0-8 3.6-8 8s3.6 8 8 8h56v56c0 4.4 3.6 8 8 8s8-3.6 8-8V232h56c4.4 0 8-3.6 8-8s-3.6-8-8-8H296V160c0-4.4-3.6-8-8-8zM144 104c-4.4 0-8 3.6-8 8v24H112c-4.4 0-8 3.6-8 8s3.6 8 8 8h24v24c0 4.4 3.6 8 8 8s8-3.6 8-8V152h24c4.4 0 8-3.6 8-8s-3.6-8-8-8H152V112c0-4.4-3.6-8-8-8z"],
    "reply-all": [576, 512, ["mail-reply-all"], "f122", "M304 128c0 8.8 7.2 16 16 16h80c88.4 0 160 71.6 160 160c0 104.2-74.6 150.7-91.8 160c-.1 0-.2 0-.6 0c-2 0-3.7-1.6-3.7-3.7c0-1.4 1-4.4 4.7-7.8C480.8 441.1 496 419.5 496 384c0-61.9-50.1-112-112-112H320c-8.8 0-16 7.2-16 16v64c0 6.3-3.7 12-9.5 14.6s-12.5 1.5-17.2-2.7l-160-144c-3.4-3-5.3-7.4-5.3-11.9s1.9-8.9 5.3-11.9l160-144c4.7-4.2 11.4-5.3 17.2-2.7S304 57.7 304 64v64zm16 224V304 288h16 48c53 0 96 43 96 96c0 30.4-12.8 47.9-22.2 56.7c-5.5 5.1-9.8 12-9.8 19.5c0 10.9 8.8 19.7 19.7 19.7c2.8 0 5.6-.6 8.1-1.9C494.5 467.9 576 417.3 576 304c0-97.2-78.8-176-176-176H336 320V112 64c0-12.6-7.4-24.1-19-29.2s-25-3-34.4 5.4l-160 144C99.9 190.3 96 198.9 96 208s3.9 17.7 10.6 23.8l160 144c9.4 8.5 22.9 10.6 34.4 5.4s19-16.6 19-29.2zM197.4 53.9c3.3-3 3.5-8 .5-11.3s-8-3.5-11.3-.5L30.2 184.3c-14 12.7-14 34.7 0 47.4L186.6 373.9c3.3 3 8.3 2.7 11.3-.5s2.7-8.3-.5-11.3L40.9 219.8c-7-6.3-7-17.3 0-23.7L197.4 53.9z"],
    "suitcase": [512, 512, [129523], "f0f2", "M144 40V96H368V40c0-13.3-10.7-24-24-24H168c-13.3 0-24 10.7-24 24zM128 96V40c0-22.1 17.9-40 40-40H344c22.1 0 40 17.9 40 40V96h64c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160c0-35.3 28.7-64 64-64h64zm248 16H136 104V464H408V112H376zM88 112H64c-26.5 0-48 21.5-48 48V416c0 26.5 21.5 48 48 48H88V112zM424 464h24c26.5 0 48-21.5 48-48V160c0-26.5-21.5-48-48-48H424V464z"],
    "person-skating": [448, 512, ["skating"], "f7c5", "M249.9 154.6c-2.3-6.3-8.3-10.6-15-10.6H160c-8.8 0-16-7.2-16-16s7.2-16 16-16H319.4c29 0 43.1 35.6 21.8 55.4l-74.4 69.4c-3.2 3-5 7.1-5.1 11.4s1.6 8.5 4.7 11.6L326.6 320c6 6 9.4 14.1 9.4 22.6V432c0 8.8-7.2 16-16 16s-16-7.2-16-16V349.3c0-4.2-1.7-8.3-4.7-11.3l-77.9-77.9c-20-20-18.5-52.7 3.2-70.8l20.4-17c5.2-4.3 7.1-11.4 4.8-17.7zM400 16a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM209.8 160h25l-19.2 16-1.2 1c-28.9 24.1-30.9 67.8-4.3 94.4L288 349.3V432c0 17.7 14.3 32 32 32s32-14.3 32-32V342.6c0-12.7-5.1-24.9-14.1-33.9l-48.8-48.8-11.3-11.3 11.7-10.9 62.7-58.5C384 149.4 363 96 319.4 96H160c-17.7 0-32 14.3-32 32s14.3 32 32 32h49.8zM448 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM148.4 468.3c3.6-2.6 4.4-7.6 1.9-11.2s-7.6-4.4-11.2-1.9l-12 8.6c-12.7 9.1-30.2 7.6-41.2-3.4L13.7 388.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3l72.2 72.2c16.6 16.6 42.7 18.8 61.8 5.1l12-8.6zm267.5-11c.7-4.4-2.2-8.5-6.6-9.2s-8.5 2.2-9.2 6.6l-2.4 14.6c-2.6 15.4-15.9 26.7-31.6 26.7H264c-4.4 0-8 3.6-8 8s3.6 8 8 8H366.1c23.5 0 43.5-17 47.3-40.1l2.4-14.6zM73.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l90.7-90.7-11.3-11.3-90.7 90.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l91.8-91.8c-3.2-4.6-6-9.4-8.2-14.4L73.4 361.4z"],
    "star-shooting": [512, 512, [127776], "e036", "M317.7 13.7c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-80 80c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l80-80zm192 0c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-176 176c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l176-176zm0 192c3.1-3.1 3.1-8.2 0-11.3s-8.2-3.1-11.3 0l-80 80c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l80-80zM126.4 267.2c5.2-.8 9.7-4 12-8.8l46.3-94c2.9-6 11.4-6 14.4 0l46.3 94c2.3 4.7 6.8 8 12 8.8L361 282.3c6.6 1 9.2 9 4.4 13.6l-74.9 73.2c-3.8 3.7-5.5 9-4.6 14.1l17.7 103.3c1.1 6.5-5.7 11.5-11.6 8.4l-92.6-48.8c-4.7-2.5-10.2-2.5-14.9 0L91.9 495c-5.9 3.1-12.7-1.9-11.6-8.4L98 383.3c.9-5.2-.8-10.5-4.6-14.1L18.4 295.9c-4.7-4.6-2.1-12.7 4.4-13.6l103.5-15.1zm-105.8-.8C.9 269.3-7 293.5 7.2 307.4l74.9 73.2L64.5 483.9c-3.4 19.6 17.2 34.6 34.8 25.3l92.6-48.8 92.6 48.8c17.6 9.3 38.2-5.7 34.8-25.3L301.6 380.6l74.9-73.2c14.2-13.9 6.4-38.1-13.3-40.9L259.7 251.4l-46.3-94c-8.8-17.9-34.3-17.9-43.1 0l-46.3 94L20.5 266.5z"],
    "binary-lock": [640, 512, [], "e33d", "M308.6 1.4c-2.2-1.5-4.9-1.8-7.4-.9l-64 24c-4.1 1.6-6.2 6.2-4.7 10.3s6.2 6.2 10.3 4.7L296 19.5V208H232c-4.4 0-8 3.6-8 8s3.6 8 8 8h72 72c4.4 0 8-3.6 8-8s-3.6-8-8-8H312V8c0-2.6-1.3-5.1-3.4-6.6zm-224 288c-2.2-1.5-4.9-1.8-7.4-.9l-64 24c-4.1 1.6-6.2 6.2-4.7 10.3s6.2 6.2 10.3 4.7L72 307.5V496H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H80h72c4.4 0 8-3.6 8-8s-3.6-8-8-8H88V296c0-2.6-1.3-5.1-3.4-6.6zM80 0C44.7 0 16 28.7 16 64v96c0 35.3 28.7 64 64 64h32c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H80zM32 64c0-26.5 21.5-48 48-48h32c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H80c-26.5 0-48-21.5-48-48V64zM208 352v96c0 35.3 28.7 64 64 64h32c35.3 0 64-28.7 64-64V352c0-35.3-28.7-64-64-64H272c-35.3 0-64 28.7-64 64zm64-48h32c26.5 0 48 21.5 48 48v96c0 26.5-21.5 48-48 48H272c-26.5 0-48-21.5-48-48V352c0-26.5 21.5-48 48-48zm256-96c26.5 0 48 21.5 48 48v64H480V256c0-26.5 21.5-48 48-48zm-64 48v64H448c-17.7 0-32 14.3-32 32V480c0 17.7 14.3 32 32 32H608c17.7 0 32-14.3 32-32V352c0-17.7-14.3-32-32-32H592V256c0-35.3-28.7-64-64-64s-64 28.7-64 64zm-16 80h16 16 96 16 16c8.8 0 16 7.2 16 16V480c0 8.8-7.2 16-16 16H448c-8.8 0-16-7.2-16-16V352c0-8.8 7.2-16 16-16z"],
    "filter-circle-dollar": [576, 512, ["funnel-dollar"], "f662", "M0 37.6C0 16.8 16.8 0 37.6 0H474.4C495.2 0 512 16.8 512 37.6c0 8.5-2.9 16.8-8.2 23.5L396.1 195.7c-9.2 1.9-18.1 4.5-26.7 7.8L491.3 51.1c3.1-3.8 4.7-8.6 4.7-13.5c0-11.9-9.7-21.6-21.6-21.6H37.6C25.7 16 16 25.7 16 37.6c0 4.9 1.7 9.7 4.7 13.5L206.2 283c1.1 1.4 1.8 3.2 1.8 5v71.7c0 7.7 3.7 14.9 9.9 19.4l43.3 31.5c2.2 9 5.2 17.7 8.7 26.1l-61.5-44.7c-10.3-7.5-16.5-19.6-16.5-32.3V290.8L8.2 61.1C2.9 54.4 0 46.2 0 37.6zM560 368a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-272 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm205.7-50.3L443.3 368l50.3 50.3c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0L432 379.3l-50.3 50.3c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3L420.7 368l-50.3-50.3c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L432 356.7l50.3-50.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "camera-retro": [512, 512, [128247], "f083", "M192 96H64c-26.5 0-48 21.5-48 48v88H146c18.5-42.4 60.8-72 110-72s91.5 29.6 110 72H496V96c0-26.5-21.5-48-48-48H277.3c-10.4 0-20.5 3.4-28.8 9.6L201.6 92.8c-2.8 2.1-6.1 3.2-9.6 3.2zM16 248V416c0 26.5 21.5 48 48 48H448c26.5 0 48-21.5 48-48V248H371.7c2.8 10.2 4.3 20.9 4.3 32c0 66.3-53.7 120-120 120s-120-53.7-120-120c0-11.1 1.5-21.8 4.3-32H16zM0 416V144c0-35.3 28.7-64 64-64H192l46.9-35.2C250 36.5 263.5 32 277.3 32H448c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64zM360 280a104 104 0 1 0 -208 0 104 104 0 1 0 208 0zM64 40c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8s-3.6 8-8 8H72c-4.4 0-8-3.6-8-8z"],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", "M256 16a240 240 0 1 0 0 480 240 240 0 1 0 0-480zm0 496A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM365.7 277.7l-104 104c-3.1 3.1-8.2 3.1-11.3 0l-104-104c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0L248 356.7V136c0-4.4 3.6-8 8-8s8 3.6 8 8V356.7l90.3-90.3c3.1-3.1 8.2-3.1 11.3 0s3.1 8.2 0 11.3z"],
    "comment-pen": [512, 512, ["comment-edit"], "f4ae", "M157.3 415c-5-1.8-10.6-1-14.9 2.1c-11 8-29.4 19.3-51.2 28.8C68.3 456 41.6 464 16 464l.1-.1 0 0 0 0 .3-.3 .1-.1c.4-.4 .9-.9 1.5-1.6c1.3-1.4 3.2-3.6 5.4-6.3l-12.2-10 12.2 10C28 450 34 442 40 432c10.7-17.9 21.4-42.1 23.6-69.9c.3-4.3-1.1-8.6-3.9-11.8C31.9 318.8 16 280.7 16 240C16 136.9 120.2 48 256 48s240 88.9 240 192s-104.2 192-240 192c-35.2 0-68.6-6.1-98.7-17zM4.7 452.7l0 0 0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3 0 0zM164.6 331.4c4 4 9.7 5.6 15.2 4.2l36.7-9.2c5.6-1.4 10.8-4.3 14.9-8.4L341 208.4c14.7-14.7 14.7-38.6 0-53.4s-38.6-14.7-53.4 0L178 264.6c-4.1 4.1-7 9.2-8.4 14.9l-9.2 36.7c-1.4 5.5 .2 11.2 4.2 15.2zm15.7-28.9l4.8-19.1c.7-2.8 2.2-5.4 4.2-7.4L275 190.3 305.7 221 220 306.7c-2.1 2.1-4.6 3.5-7.4 4.2l-19.1 4.8-17.6 4.4 4.4-17.6zM329.7 197.1L317 209.7 286.3 179l12.6-12.6c8.5-8.5 22.3-8.5 30.7 0s8.5 22.3 0 30.7z"],
    "file-import": [512, 512, ["arrow-right-to-file"], "f56f", "M448 496H192c-26.5 0-48-21.5-48-48V352H128v96c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V179.9c0-12.7-5.1-24.9-14.1-33.9L366.1 14.1c-9-9-21.2-14.1-33.9-14.1H192c-35.3 0-64 28.7-64 64V256h16V64c0-26.5 21.5-48 48-48H332.1c1.3 0 2.6 .1 3.9 .2V136c0 22.1 17.9 40 40 40H495.8c.2 1.3 .2 2.6 .2 3.9V448c0 26.5-21.5 48-48 48zm41.1-336H376c-13.3 0-24-10.7-24-24V22.9c1 .8 1.9 1.6 2.7 2.4L486.6 157.3c.9 .9 1.7 1.8 2.4 2.7zM269.7 186.3c-3.1-3.1-8.2-3.1-11.3 0s-3.1 8.2 0 11.3L356.7 296H8c-4.4 0-8 3.6-8 8s3.6 8 8 8H356.7l-98.3 98.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0l112-112c3.1-3.1 3.1-8.2 0-11.3l-112-112z"],
    "banjo": [512, 512, [129685], "f8a3", "M448 16c-3 0-5.9 1.2-8 3.3L393.1 66.2c-1.1 1.1-1.9 2.5-2.2 4.1l-12.7 63.5 63.5-12.7c1.5-.3 3-1.1 4.1-2.2L492.7 72c2.1-2.1 3.3-5 3.3-8s-1.2-5.9-3.3-8L456 19.3c-2.1-2.1-5-3.3-8-3.3zM360.6 140.1l14.6-72.9c.9-4.6 3.2-8.9 6.6-12.3L428.7 8c5.1-5.1 12.1-8 19.3-8s14.2 2.9 19.3 8L504 44.7c5.1 5.1 8 12.1 8 19.3s-2.9 14.2-8 19.3l-46.9 46.9c-3.4 3.4-7.6 5.6-12.3 6.6l-72.9 14.6-77.3 77.3c24 26.5 39.3 61.2 41.2 99.3H344c4.4 0 8 3.6 8 8s-3.6 8-8 8h-8.2c-1.9 38.2-17.1 72.8-41.2 99.3l5.8 5.8c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-5.8-5.8c-26.5 24-61.2 39.3-99.3 41.2V504c0 4.4-3.6 8-8 8s-8-3.6-8-8v-8.2c-38.2-1.9-72.8-17.1-99.3-41.2l-5.8 5.8c-3.1 3.1-8.2 3.1-11.3 0s-3.1-8.2 0-11.3l5.8-5.8c-24-26.5-39.3-61.2-41.2-99.3H8c-4.4 0-8-3.6-8-8s3.6-8 8-8h8.2c1.9-38.2 17.1-72.8 41.2-99.3l-5.8-5.8c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0l5.8 5.8c26.5-24 61.2-39.3 99.3-41.2V168c0-4.4 3.6-8 8-8s8 3.6 8 8v8.2c38.2 1.9 72.8 17.1 99.3 41.2l77.3-77.3zM72.4 235.5C47.7 261 32.3 295.6 31.7 333.8c.2 .7 .3 1.4 .3 2.2s-.1 1.5-.3 2.2c.6 38.2 16 72.8 40.7 98.3c.6 .4 1.2 .8 1.8 1.3s1 1.1 1.3 1.8c25.5 24.7 60.1 40.1 98.3 40.7c.7-.2 1.4-.3 2.2-.3s1.5 .1 2.2 .3c38.2-.6 72.8-16 98.3-40.7c.4-.6 .8-1.2 1.3-1.8s1.1-1 1.8-1.3c24.7-25.5 40.1-60.1 40.7-98.3c-.2-.7-.3-1.4-.3-2.2s.1-1.5 .3-2.2c-1.2-78-64.1-141-142.1-142.1c-.7 .2-1.4 .3-2.2 .3s-1.5-.1-2.2-.3c-38.2 .6-72.8 16-98.3 40.7c-.4 .6-.8 1.2-1.3 1.8s-1.1 1-1.8 1.3zm45.2 94.8l64 64c3.1 3.1 3.1 8.2 0 11.3s-8.2 3.1-11.3 0l-64-64c-3.1-3.1-3.1-8.2 0-11.3s8.2-3.1 11.3 0z"],
    "square-arrow-up-right": [448, 512, ["external-link-square"], "f14c", "M384 48c26.5 0 48 21.5 48 48V416c0 26.5-21.5 48-48 48H64c-26.5 0-48-21.5-48-48V96c0-26.5 21.5-48 48-48H384zm64 48c0-35.3-28.7-64-64-64H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96zM168 160c-4.4 0-8 3.6-8 8s3.6 8 8 8H292.7L130.3 338.3c-3.1 3.1-3.1 8.2 0 11.3s8.2 3.1 11.3 0L304 187.3V312c0 4.4 3.6 8 8 8s8-3.6 8-8V168c0-4.4-3.6-8-8-8H168z"],
    "light-emergency-on": [640, 512, [], "e420", "M44.1 33.1c-3.8-2.3-8.7-1-11 2.7s-1 8.7 2.7 11l80 48c3.8 2.3 8.7 1 11-2.7s1-8.7-2.7-11l-80-48zm560 13.7c3.8-2.3 5-7.2 2.7-11s-7.2-5-11-2.7l-80 48c-3.8 2.3-5 7.2-2.7 11s7.2 5 11 2.7l80-48zM8 192c-4.4 0-8 3.6-8 8s3.6 8 8 8H88c4.4 0 8-3.6 8-8s-3.6-8-8-8H8zm544 0c-4.4 0-8 3.6-8 8s3.6 8 8 8h80c4.4 0 8-3.6 8-8s-3.6-8-8-8H552zm-88 0V320h16V192c0-88.4-71.6-160-160-160s-160 71.6-160 160V320h16V192c0-79.5 64.5-144 144-144s144 64.5 144 144zM112 400c0-17.7 14.3-32 32-32H496c17.7 0 32 14.3 32 32v32c0 17.7-14.3 32-32 32H144c-17.7 0-32-14.3-32-32V400zm-16 0v32c0 26.5 21.5 48 48 48H496c26.5 0 48-21.5 48-48V400c0-26.5-21.5-48-48-48H144c-26.5 0-48 21.5-48 48zM312 112.4c4.4-.4 8-4 8-8.4s-3.6-8-8-7.7c-46.6 3.8-83.8 41-87.7 87.7c-.4 4.4 3.3 8 7.7 8s8-3.6 8.4-8c3.7-37.8 33.8-67.9 71.6-71.6z"],
    "kerning": [640, 512, [], "f86f", "M447.2 11.5c1.9-4 .3-8.8-3.7-10.7s-8.8-.3-10.7 3.7l-240 496c-1.9 4-.3 8.8 3.7 10.7s8.8 .3 10.7-3.7l240-496zm-432 88.9c-2-4-6.8-5.6-10.7-3.6s-5.6 6.8-3.6 10.7l152 304c1.4 2.7 4.1 4.4 7.2 4.4s5.8-1.7 7.2-4.4l152-304c2-4 .4-8.8-3.6-10.7s-8.8-.4-10.7 3.6L160 390.1 15.2 100.4zm320 311.2L372.9 336H587.1l37.8 75.6c2 4 6.8 5.6 10.7 3.6s5.6-6.8 3.6-10.7l-152-304C485.8 97.7 483 96 480 96s-5.8 1.7-7.2 4.4l-152 304c-2 4-.4 8.8 3.6 10.7s8.8 .4 10.7-3.6zM480 121.9L579.1 320H380.9L480 121.9z"],
    "box-open": [640, 512, [], "f49e", "M61.4 54.6l-33.2 83c-3.6 9 1.5 19 10.8 21.4l167.7 43.5c9.9 2.6 20.2-1.4 25.9-9.8L306.2 83.4 70 49.7c-3.7-.5-7.2 1.5-8.6 4.9zM72.2 33.9L320 69.3 567.8 33.9c11-1.6 21.6 4.6 25.7 14.8l33.2 83c7.2 17.9-3 38-21.7 42.9L437.3 218.1c-16.4 4.3-33.7-2.3-43.2-16.4l-74-110-74 110c-9.5 14.1-26.8 20.6-43.2 16.4L35 174.6c-18.7-4.8-28.8-25-21.7-42.9l33.2-83c4.1-10.3 14.7-16.4 25.7-14.8zM560 216.1l16-4.6v167c0 22-15 41.2-36.4 46.6l-208 52c-7.6 1.9-15.6 1.9-23.3 0l-208-52C79 419.7 64 400.5 64 378.5v-167l16 4.6V378.5c0 14.7 10 27.5 24.2 31L312 461.5V200c0-4.4 3.6-8 8-8s8 3.6 8 8V461.5l207.8-51.9c14.2-3.6 24.2-16.4 24.2-31V216.1zM570 49.7L333.8 83.4l73.6 109.3c5.7 8.4 16.1 12.4 25.9 9.8l167.7-43.5c9.3-2.4 14.4-12.5 10.8-21.4l-33.2-83c-1.4-3.4-4.9-5.5-8.6-4.9z"],
    "square-f": [448, 512, 